# MMF_MOD   Format of 2008.09.21
#
# Generator: GEN_MMF_MOD  Version of 2008.09.21
#
# Generated by Leonid Petrov  at 2008.10.06-19:16:34
#
#============================ Beginning of format description: =================
# 
#    Specifications of MMF_EPO format.
#    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#  
#    MMF_EPO format is for distribution the mean mapping function in the neutral
#    atmosphere for the set of epochs for a given set of stations.
#  
#    A file in MMF_EPO format consists of records of variable length
#    in ASCII coding. The records are separated by a character with decimal
#    code 13. The records are grouped into sections. Sections follow
#    in this order:
#  
# 1) Header record -- the first record should have a signature:
#                     TROPO_PATH_DELAY  Format version of 2007.10.04
#  
#                     The header record allows to distinguish a valid
#                     file in the TROPO_PATH_DELAY  format from files
#                     in other formats.
#  
# 2) M-record section
#    M-record  has letter M in the first field. The M record keeps the
#              model identifier.
#  
# 3) N-record section
#  
# 4) S-record section
#  
# 5) D-record section
#  
# 6) Trailer record -- the last record is the same as the header record.
#  
#  
# Format of an S-record:
# ----------------------
#  
# Field  1:1   A1    -- Record ID. Should be letter S (decimal code 83).
# field  2:2   a1       delimiter: blanks.
# Field  4:11  A8    -- 8-letter long site identifier. May contain
#                       any characters with decimal codes 32-255, but
#                       blanks are allowed only at the end of the site
#                       identifier. This site identifier should be unique
#                       among S-records. This field should not
#                       necessarily have a special meaning. Parsing
#                       software should not try to interpret it.
# field 12:13  a2       delimiter: blanks.
# Field 14:26  F13.4 -- X site coordinate in a crust fixed reference
#                       frame. Units: meters.
# field 27:27  a1       delimiter: blank.
# Field 28:40  F13.4 -- Y site coordinate in a crust fixed reference
#                       frame. Units: meters.
# field 27:27  a1       delimiter: blank.
# Field 42:54  F13.4 -- Z site coordinate in a crust fixed reference
#                       frame. Units: meters.
# field 55:56  a2       delimiter: blanks.
# Field 57:64  F8.4  -- Site geocentric latitude, positive to north,
#                       in degrees. This field is for information only.
#                       Parsing software MUST ignore it.
# field 65:65  a1       delimiter: blank.
# Field 66:73  F8.4  -- Site longitude, positive towards east,
#                       in degrees. This field is for information only.
#                       Parsing software MUST ignore it.
# field 74:74  a1       delimiter: blank.
# Field 75:80  F6.1  -- Site height above the reference ellipsoid in
#                       meters. This field is for information only.
#                       Parsing software MUST ignore it.
# 
#============================ End of format description: =======================
#
M  GMAO MMF_EPO
#
N         205   3.00000  90.00000
#
S  AIRA      -3530219.3120  4118797.5720  3344015.8670   31.6516 130.5999  323.1
S  ALGOPARK    918034.7420 -4346132.2710  4561971.1660   45.7632 281.9273  224.7
S  AUSTINTX   -737793.8560 -5459892.2790  3202990.4460   30.1718 262.3043  190.3
S  AZORES     4552174.6170 -2186664.6930  3882779.7980   37.5548 334.3424   59.3
S  ARECIBO    2390486.9000  5564731.4400  1994720.4500   18.2295  66.7527  451.9
S  ATCA-104  -4751639.8280  2791700.3520 -3200491.1710  -30.1455 149.5648  252.7
S  BADARY     -838200.6570  3865751.5510  4987670.9330   51.5831 102.2339  822.3
S  BERMUDA    2307209.4380 -4874215.9080  3394318.0240   32.1875 295.3305  -30.0
S  BLKBUTTE  -2306307.0300 -4787914.3670  3515736.3470   33.4864 244.2802  490.1
S  BLOOMIND    302384.3940 -4941699.0670  4007908.5240   38.9910 273.5016  218.6
S  BR-VLBA   -2112064.9780 -3705356.5200  4726813.7980   47.9399 240.3167  251.2
S  BREST      4228877.0960  -333104.1800  4747181.0240   48.2167 355.4962  105.2
S  CAMBRIDG   3920356.1500     2542.0200  5014284.4200   51.9804   0.0372   84.2
S  CARNUSTY   3526416.3350  -171421.1920  5294098.8900   56.3011 357.2170   58.6
S  CARROLGA    453520.5500 -5300506.7740  3507207.4680   33.3955 274.8904  300.2
S  CEDUNA    -3753442.7450  3912709.7530 -3348067.6090  -31.6954 133.8098  165.3
S  CHICHI10  -4490618.4700  3483908.1630  2884899.1320   26.9116 142.1950  108.2
S  CHLBOLTN   4008310.0490  -100650.7480  4943794.8050   50.9569 358.5616  147.5
S  CRIMEA     3785231.0680  2551207.4130  4439796.3740   44.2052  33.9796   50.9
S  CTVASBAY   1091444.6420 -4351283.4290  4518706.9640   45.2076 284.0811   48.6
S  CTVASTJ    2612547.1010 -3426881.2980  4686757.5890   47.4035 307.3208  158.8
S  DARNHALL   3829087.8990  -169568.9550  5081082.3460   52.9715 357.4643  112.6
S  DAITO     -3786460.5110  4320156.0080  2762038.8780   25.6783 131.2334   53.4
S  DEADMANL  -2336820.0080 -4732587.5070  3570330.3550   34.0762 243.7211  834.6
S  DSS11     -2351429.2450 -4645078.4700  3673763.8480   35.2080 243.1506 1006.3
S  DSS12     -2350443.8120 -4651980.8400  3665630.9880   35.1187 243.1945  962.9
S  DSS112    -2350443.0000 -4651979.2300  3665628.4950   35.1187 243.1945  960.0
S  DSS13     -2351112.4910 -4655530.7100  3660912.7870   35.0660 243.2055 1071.2
S  DSS14     -2353621.2510 -4641341.5400  3677052.3700   35.2444 243.1105 1002.1
S  DSS15     -2353538.8540 -4641649.5030  3676670.0190   35.2403 243.1128  974.0
S  DSS16     -2354763.1580 -4646787.4600  3669387.0690   35.1602 243.1264  944.7
S  DSS17     -2354730.3570 -4646751.7700  3669440.6590   35.1608 243.1265  937.6
S  DSS23     -2354757.5670 -4646934.6800  3669207.8240   35.1582 243.1271  946.1
S  DSS24     -2354906.4950 -4646840.1300  3669242.3170   35.1585 243.1252  952.2
S  DSS25     -2355022.0660 -4646953.6400  3669040.9000   35.1563 243.1246  960.9
S  DSS26     -2354890.9670 -4647166.9300  3668872.2100   35.1543 243.1270  970.2
S  DSS27     -2349915.2600 -4656756.4800  3660096.5300   35.0571 243.2234 1053.2
S  DSS28     -2350101.8490 -4656673.4500  3660103.5800   35.0571 243.2211 1065.4
S  DSS33     -4461083.5140  2682281.7500 -3674570.3900  -35.2190 148.9831  684.8
S  DSS34     -4461146.7560  2682439.2900 -3674393.5400  -35.2170 148.9820  692.7
S  DSS41     -3978719.9420  3724851.3700 -3302171.8900  -31.2108 136.8875  151.7
S  DSS42     -4460981.0160  2682413.5300 -3674582.0700  -35.2192 148.9813  675.4
S  DSS43     -4460894.5850  2682361.5500 -3674748.5800  -35.2209 148.9813  689.6
S  DSS44     -4451073.3190  2676824.7700 -3691347.5900  -35.4013 148.9778 1151.1
S  DSS45     -4460935.4010  2682765.7110 -3674381.1930  -35.2170 148.9777  675.1
S  DSS46     -4460828.6190  2682129.5600 -3674975.5100  -35.2235 148.9831  677.6
S  DSS49     -4554231.8430  2816758.9800 -3454036.0700  -32.8229 148.2635  415.5
S  DSS51      5085442.7740  2668263.3800 -2768697.1200  -25.7389  27.6854 1416.4
S  DSS53      4849330.1290  -360338.0900  4114758.7700   40.2375 355.7503  827.5
S  DSS54      4849434.5550  -360724.1100  4114618.6400   40.2358 355.7459  837.7
S  DSS55      4849525.2560  -360606.0900  4114495.0800   40.2344 355.7474  819.8
S  DSS61      4849245.2110  -360278.1700  4114884.4500   40.2389 355.7510  841.2
S  DSS161     4849242.8900  -360277.9900  4114882.4500   40.2389 355.7510  838.1
S  DSS62      4846700.4150  -370196.9800  4116905.4500   40.2632 355.6322  787.9
S  DSS63      4849092.6470  -360180.5700  4115109.1100   40.2414 355.7520  865.5
S  DSS65      4849336.6940  -360488.7910  4114748.8320   40.2373 355.7486  834.5
S  DSS66      4849148.5430  -360474.8400  4114995.0200   40.2401 355.7486  850.6
S  EFLSBERG   4033947.4810   486990.5150  4900430.8160   50.3359   6.8836  417.4
S  ELY       -2077236.4070 -4486712.7050  4018753.6880   39.1047 245.1570 1886.9
S  FD-VLBA   -1324009.1290 -5332181.9700  3231962.4720   30.4666 256.0552 1607.1
S  FLAGSTAF  -1923992.7780 -4850854.6370  3658589.3290   35.0337 248.3653 2145.4
S  FORTLEZA   4985370.0370 -3955020.3200  -428472.2860   -3.8520 321.5741   23.8
S  FORTORDS  -2699840.4730 -4359126.8630  3781051.2000   36.4054 238.2279  250.7
S  FORT_ORD  -2697026.9740 -4354393.0730  3788077.8380   36.4856 238.2267   24.5
S  FTD_7900  -1324228.0000 -5332063.0680  3232023.0420   30.4674 256.0527 1584.1
S  GBT-VLBA    882589.6540 -4924872.4040  3943729.4190   38.2459 280.1602  824.5
S  GGAO7108   1130794.7600 -4831233.8060  3994217.0430   38.8338 283.1735   14.4
S  GIFU11    -3787123.3130  3564181.7440  3680275.0470   35.2859 136.7371   61.0
S  GIFU3     -3787518.2460  3564247.1470  3679797.1720   35.2807 136.7395   54.5
S  GILCREEK  -2281547.3090 -1453645.0860  5756993.1620   64.8306 212.5025  332.8
S  GOLDVENU  -2351129.1840 -4655477.0200  3660956.8770   35.0666 243.2051 1063.6
S  GORF7102   1130686.5090 -4831353.0270  3994110.9330   38.8325 283.1719   18.7
S  GRASSE     4581697.6340   556125.7510  4389351.4530   43.5625   6.9207 1319.3
S  HALEAKAL  -5465998.5930 -2404407.9890  2242228.8130   20.5807 203.7439 3068.6
S  HARTRAO    5085442.7800  2668263.4900 -2768697.0140  -25.7389  27.6854 1416.4
S  HATCREEK  -2523970.0440 -4123506.3140  4147752.5470   40.6271 238.5295 1010.0
S  HAYSTACK   1492404.7310 -4457266.5250  4296881.7730   42.4316 288.5118  117.4
S  HN-VLBA    1446375.1140 -4447939.6600  4322306.1220   42.7417 288.0134  296.3
S  HOBART26  -3950236.7370  2522347.5600 -4311562.5390  -42.6118 147.4405   65.8
S  HOFN       2679650.2580  -727916.4390  5722807.2590   64.1169 344.8026   79.0
S  HOHENFRG   3778214.7060   698644.6270  5074053.6940   52.8656  10.4765  150.5
S  HOHNBERG   4213687.2340   820422.9580  4702784.2400   47.6094  11.0179 1006.4
S  HRAS_085  -1324210.9990 -5332023.1530  3232118.3620   30.4683 256.0527 1595.8
S  JODRELL1   3822626.0400  -154105.6500  5086486.0400   53.0518 357.6914  180.1
S  JODRELL2   3822846.7600  -153802.2800  5086285.9000   53.0493 357.6961  144.5
S  JPL_MV1   -2493306.2170 -4655197.4720  3565519.4580   34.0264 241.8267  424.8
S  KAINAN    -3751040.3680  3721052.3540  3560816.8170   33.9775 135.2299   61.2
S  KANOZAN   -3991747.4420  3355061.8090  3661225.3460   35.0739 139.9530  374.0
S  KARLBURG   3653204.3420   884427.6150  5135732.0720   53.8004  13.6093   77.8
S  KASHIM11  -3997505.6680  3276878.4090  3724240.7100   35.7729 140.6575   63.2
S  KASHIM34  -3997649.2270  3276690.7540  3724278.8250   35.7732 140.6601   79.1
S  KASHIMA   -3997892.2690  3276581.2780  3724118.2330   35.7714 140.6627   80.8
S  KAUAI     -5543846.0630 -2054563.6430  2387814.1110   21.9924 200.3348 1169.0
S  KIRSBERG   3879830.8630   987963.3080  4948713.2720   51.0262  14.2862  261.9
S  KODIAK    -3026940.2980 -1575911.7730  5370362.4980   57.5660 207.5028   32.0
S  KOGANEI   -3941937.4350  3368150.9050  3702235.2990   35.5284 139.4881  126.1
S  KOGANEI3  -3942077.3640  3368332.1040  3701904.8280   35.5248 139.4876  115.2
S  KOKEE     -5543837.6280 -2054567.8590  2387851.9390   21.9927 200.3349 1177.3
S  KP-VLBA   -1995678.6300 -5037317.7180  3357328.1290   31.7838 248.3876 1902.7
S  KWAJAL26  -6143536.3270  1363997.8120  1034707.6840    9.3369 167.4821   58.1
S  LA-VLBA   -1449752.3610 -4975298.5930  3709123.9260   35.5928 253.7544 1963.1
S  LEONRDOK   -522231.6420 -5145676.8720  3720152.3590   35.7264 264.2049  227.0
S  MAMMOTHL  -2448246.8090 -4426738.1310  3875435.7770   37.4558 241.0548 2311.1
S  MARCUS    -5227446.4500  2551379.6720  2607604.9890   24.1460 153.9842   42.4
S  MARPOINT   1106629.3020 -4882907.1650  3938086.9680   38.1871 282.7694  -12.8
S  MATERA     4641938.7700  1393003.0170  4133325.5460   40.4594  16.7040  544.1
S  MCD_7850  -1330008.2030 -5328391.5790  3236502.7200   30.5119 255.9849 2004.9
S  MEDICINA   4461369.9850   919596.8190  4449559.2080   44.3281  11.6469   67.9
S  METSHOVI   2890652.7530  1310295.3400  5513958.7420   60.0759  24.3842   60.3
S  METSAHOV   2892583.1900  1311714.4580  5512636.2870   60.0516  24.3931   76.3
S  MIAMI20     961255.3290 -5674092.5920  2740533.7960   25.4640 279.6153  -11.1
S  MILESMON  -1204439.0790 -4239211.0980  4596266.0300   46.2043 254.1392  704.2
S  MIURA     -3976129.9580  3377927.8880  3656753.8460   35.0263 139.6504  105.9
S  MIYAZAKI  -3582768.0580  4052033.9700  3369020.5410   31.9178 131.4828  108.0
S  MIZNAO10  -3857236.1030  3108803.2170  4003883.0750   38.9451 141.1323  111.7
S  MIZUSGSI  -3862411.8940  3105015.0430  4001944.8750   38.9222 141.2040  173.9
S  MK-VLBA   -5464074.9650 -2495249.1180  2148296.8450   19.6791 204.5445 3763.8
S  MOJAVE12  -2356171.0820 -4646755.8590  3668470.5880   35.1503 243.1124  910.9
S  MOJ_7288  -2356494.1430 -4646607.5980  3668426.5800   35.1499 243.1085  896.8
S  MON_PEAK  -2386289.6280 -4802346.3110  3444884.0750   32.7166 243.5772 1839.4
S  MOPRA     -4682769.0790  2802618.9760 -3291759.3600  -31.0974 149.0996  868.0
S  MV2ONSLA   3370641.9550   711866.1180  5349796.1710   57.2205  11.9254   44.1
S  NL-VLBA    -130872.2560 -4762317.1220  4226851.0390   41.5803 268.4259  223.0
S  NOBEY_6M  -3871168.2950  3428273.9910  3723697.5800   35.7582 138.4722 1390.3
S  NOME      -2658150.6180  -693821.9830  5737236.6050   64.4131 194.6288  332.4
S  NOTO       4934563.1220  1321201.2610  3806484.4970   36.6915  14.9890  143.9
S  NOTOX      4934563.1220  1321201.2610  3806484.4970   36.6915  14.9890  143.9
S  NRAO20      883772.7470 -4924385.5960  3944042.4940   38.2496 280.1745  807.3
S  NRAO85_1    883555.5470 -4924490.8870  3943961.9670   38.2487 280.1718  808.4
S  NRAO85_3    882325.5690 -4925137.9940  3943397.6790   38.2424 280.1566  786.6
S  NRAO_140    882879.8860 -4924482.3070  3944130.6920   38.2506 280.1642  813.2
S  NYALES20   1202462.7540   252734.3950  6237766.0380   78.8564  11.8697   88.0
S  OCOTILLO  -2335601.4180 -4832243.9630  3434392.8340   32.6151 244.2038  -36.0
S  OHIGGINS   1525833.0130 -2432463.6630 -5676174.4870  -63.1664 302.0992   40.6
S  ONSALA60   3370606.0310   711917.4850  5349830.7460   57.2209  11.9264   60.0
S  ONSALA85   3370966.1210   711465.9590  5349664.0290   57.2181  11.9178   59.1
S  OV-VLBA   -2409150.1140 -4478573.2320  3838617.3970   37.0465 241.7229 1197.0
S  OVRO_130  -2409600.8320 -4478349.4900  3838603.1800   37.0463 241.7173 1201.6
S  OVR_7853  -2410421.2970 -4477800.3420  3838690.3080   37.0474 241.7062 1178.8
S  PARKES    -4554232.0090  2816758.9660 -3454035.8470  -32.8229 148.2635  415.5
S  PBLOSSOM  -2464071.0020 -4649425.3840  3593905.6730   34.3327 242.0776  891.6
S  PENTICTN  -2058840.5450 -3621286.5320  4814420.8520   49.1323 240.3801  530.3
S  PICOVEL    5088967.9000  -301681.6000  3825015.8000   36.8813 356.6074 2922.4
S  PIETOWN   -1640953.7130 -5014816.0270  3575411.8780   34.1221 251.8808 2365.4
S  PINFLATS  -2369636.1000 -4761324.8040  3511116.2250   33.4321 243.5412 1236.3
S  PLATTVIL  -1240708.2190 -4720454.3970  4094481.6390   39.9932 255.2737 1502.1
S  PRESIDIO  -2707704.9850 -4257609.3760  3888374.2390   37.6191 237.5449  -28.7
S  PT_REYES  -2732333.2960 -4217634.7360  3914491.2990   37.9168 237.0634   -1.7
S  PVERDES   -2525452.9670 -4670035.3910  3522886.8540   33.5662 241.5964   70.1
S  QUINCY    -2517230.9980 -4198595.1520  4076531.2350   39.7852 239.0556 1106.5
S  RICHMOND    961258.0520 -5674090.0600  2740533.8090   25.4641 279.6153  -12.9
S  ROBLED32   4849245.2350  -360278.1630  4114884.6040   40.2389 355.7510  841.3
S  SAGARA    -3913437.8230  3501122.8110  3608593.5180   34.4977 138.1829  152.1
S  SANPAULA  -2554476.9200 -4608627.2350  3582138.4610   34.2087 241.0012  185.6
S  SANTIA12   1769693.1120 -5044504.5320 -3468434.9680  -32.9755 289.3317  731.0
S  SC-VLBA    2607848.5210 -5488069.6900  1932739.5370   17.6451 295.4164  -14.3
S  SEATTLE1  -2295347.9910 -3638029.3570  4693408.5010   47.4940 237.7509  -15.7
S  SESHAN25  -2831686.9130  4675733.6660  3275327.6900   30.9292 121.1997   30.1
S  SEST       1838237.8810 -5258699.2630 -3100588.7410  -29.0997 289.2677 2416.5
S  SHANGHAI  -2847698.0840  4659872.2880  3283958.4610   31.0200 121.4296   18.5
S  SINTOTU   -3642141.9430  2861496.5580  4370361.6550   43.3366 141.8446  119.3
S  SINTOTU3  -3642142.0760  2861496.6730  4370361.8280   43.3366 141.8446  119.5
S  SNDPOINT  -3425462.0230 -1214669.1090  5223858.1640   55.1721 199.5245   93.4
S  SOURDOGH  -2419993.6790 -1664228.7270  5643538.1040   62.5066 214.5163  748.7
S  SUWON     -3062023.9880  4055453.8080  3841809.9920   37.0901 127.0542   82.2
S  SVETLOE    2730173.8690  1562442.6570  5529969.0550   60.3672  29.7819   86.7
S  SYOWA      1766194.1240  1460410.9220 -5932273.3570  -68.8773  39.5863   51.7
S  TATEYAMA  -4000983.4050  3375275.9670  3632213.1870   34.7566 139.8486  126.9
S  TIDBIN64  -4460894.2180  2682361.2090 -3674747.6030  -35.2209 148.9813  688.6
S  TIGOCONC   1492054.0300 -4887960.9660 -3803541.4110  -36.6582 286.9749  171.6
S  TIGOWTZL   4075572.6810   931755.1200  4801584.3580   48.9540  12.8776  659.6
S  TITIJIMA  -4489356.5720  3482989.6460  2887931.2410   26.9422 142.1945   99.6
S  TOMAKO11  -3680586.3460  2917515.7850  4300987.6810   42.4820 141.5970   90.6
S  TORUN      3638558.5100  1221969.7200  5077036.7600   52.9105  18.5641  134.3
S  TOULOUSE   4627949.9790   119843.6700  4372863.0180   43.3671   1.4834  192.9
S  TROMSONO   2102904.0430   721602.5950  5958201.3480   69.5372  18.9394  133.6
S  TRYSILNO   2988029.1710   655957.0700  5578669.1510   61.2609  12.3816  724.7
S  TSUKU3    -3957184.4790  3310224.8250  3737709.0860   35.9226 140.0872   70.3
S  TSUKUB32  -3957408.7520  3310229.3670  3737494.7890   35.9201 140.0887   85.4
S  TSUKUBA   -3957172.9220  3310237.9590  3737708.9370   35.9226 140.0870   69.9
S  URUMQI      228310.7310  4631922.8970  4367064.0750   43.2795  87.1781 2034.0
S  USSURISK  -3059725.3240  3427256.7830  4409485.7410   43.8238 131.7573  155.7
S  USUDA64   -3855355.4090  3427427.6230  3740971.2910   35.9494 138.3628 1533.5
S  VERAIRIK  -3521719.5680  4132174.7530  3336994.3260   31.5760 130.4399  574.3
S  VERAISGK  -3263994.6480  4808056.3570  2619949.3950   24.2677 124.1710   65.8
S  VERAMZSW  -3857241.8560  3108784.8030  4003900.5950   38.9453 141.1326  117.2
S  VERAOGSW  -4491068.8940  3481544.8290  2887399.6220   26.9361 142.2166  273.9
S  VERNAL    -1631473.3780 -4589129.0050  4106759.8980   40.1372 250.4293 1591.3
S  VICTORIA  -2341310.1470 -3539083.8820  4745768.3280   48.1984 236.5130   25.9
S  VLA       -1601185.3050 -5041977.4570  3554875.9180   33.9005 252.3817 2115.5
S  VLA-N8    -1601147.7470 -5041733.5010  3555235.7660   33.9044 252.3813 2115.2
S  VNDNBERG  -2678094.9520 -4525450.5720  3597410.3390   34.3765 239.3836  -11.6
S  WESTFORD   1492206.5880 -4458130.5180  4296015.5410   42.4212 288.5062   87.5
S  WETTZELL   4075539.8830   931735.2610  4801629.3710   48.9545  12.8775  669.8
S  WHTHORSE  -2215213.3870 -2209261.2670  5540291.8440   60.5468 224.9229  710.3
S  WSTRBOR7   3828651.2900   443447.4800  5064921.5700   52.7300   6.6068   71.6
S  WSTRBORK   3828445.6590   445223.6000  5064921.5680   52.7300   6.6333   71.9
S  YAKATAGA  -2529744.3900 -1942091.0810  5505028.1130   59.9148 217.5135   21.8
S  YAMAGUCH  -3502544.2580  3950966.3970  3566381.1650   34.0373 131.5571  166.3
S  YEBES      4848780.3000  -261702.0790  4123035.7490   40.3342 356.9106  980.6
S  YEBES40M   4848762.1000  -261484.5000  4123084.9000   40.3347 356.9131  989.8
S  YELLOWKN  -1224124.6420 -2689530.6680  5633555.3270   62.3214 245.5276  177.5
S  YLOW7296  -1224399.5690 -2689273.2560  5633620.2670   62.3226 245.5207  179.5
S  YUMA      -2196778.0150 -4887337.1610  3448425.2580   32.7638 245.7969  239.3
S  ZELENCHK   3451207.8510  3060375.1820  4391914.8790   43.5956  41.5652 1175.7
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  AIRA      HYD  DER_NORT   1.2411D-04   7.4156D-05   5.2771D-05   6.4066D-06  -2.7316D-05  -4.2093D-06   2.5528D-07   1.5372D-08  -3.3984D-07  
D  AIRA      HYD  DER_EAST  -1.1234D-05   3.8512D-07  -1.3529D-05   3.7829D-06  -4.3280D-06   1.2494D-06  -1.6752D-06  -9.2192D-07  -1.4040D-06  
D  AIRA      HYD  CHEB_0     7.4685D-09   6.0721D-11   1.4460D-11   1.6310D-12  -5.9540D-12  -2.8521D-13  -7.1317D-13  -2.2325D-12   3.2436D-12  
D  AIRA      HYD  CHEB_1    -2.0632D-11   1.3657D-11   8.3145D-12  -6.8005D-13  -1.3204D-12   1.4474D-13   3.7068D-13  -3.6117D-13   5.2648D-13  
D  AIRA      HYD  CHEB_2    -5.0543D-12   2.1138D-12   1.3411D-12  -6.1388D-14  -1.7949D-13   4.5533D-14   7.4801D-14  -7.0941D-14   4.3347D-14  
D  AIRA      HYD  CHEB_3    -1.2799D-12  -3.6822D-13  -2.2538D-13   3.5615D-14   4.4699D-14   6.4689D-15   4.3746D-15   1.3823D-14  -1.2788D-15  
D  AIRA      HYD  CHEB_4    -6.8585D-13  -8.5448D-15  -8.2799D-15   7.5536D-15   5.5157D-15   2.3458D-15  -6.3423D-15   1.2164D-15   7.5390D-17  
D  AIRA      HYD  CHEB_5    -9.5916D-14   1.4703D-15   4.0875D-15  -6.9033D-15  -1.9654D-15  -6.4201D-16   1.1125D-15  -2.2064D-15  -1.4250D-15  
#
D  AIRA      NHY  DER_NORT   1.6998D-03   1.0865D-03   4.2763D-04  -5.5143D-04  -3.3790D-04   4.5480D-06   3.3472D-04  -1.7650D-04   1.7448D-04  
D  AIRA      NHY  DER_EAST   3.2619D-04  -3.7377D-04  -4.7423D-05  -5.4095D-04  -1.9591D-04   9.3198D-05  -5.5333D-05   3.0625D-04  -4.8298D-04  
D  AIRA      NHY  CHEB_0     5.7617D-10  -3.6332D-10  -2.1298D-10   7.9696D-11   1.1878D-10  -7.1514D-12  -3.8634D-11   1.0477D-11  -1.0360D-11  
D  AIRA      NHY  CHEB_1     2.9396D-11  -1.5753D-11  -1.0021D-11   3.2383D-12   4.3487D-12  -9.9341D-13  -1.8132D-12  -4.7829D-15   7.2249D-13  
D  AIRA      NHY  CHEB_2     5.2910D-12  -2.7155D-12  -1.7904D-12   5.4063D-13   7.4672D-13  -1.9263D-13  -3.6292D-13  -2.4196D-15  -1.1358D-13  
D  AIRA      NHY  CHEB_3    -5.6489D-13   3.6213D-13   1.9802D-13  -8.9249D-14  -1.0279D-13   1.2812D-14   2.8421D-14  -2.6371D-15  -5.8536D-14  
D  AIRA      NHY  CHEB_4    -1.0279D-13   7.2372D-14   4.1000D-14  -1.8922D-14  -2.8268D-14   5.6350D-15   1.4855D-14  -1.7087D-15   2.6630D-14  
D  AIRA      NHY  CHEB_5    -1.0918D-14   3.8390D-15   2.0216D-15  -8.6757D-16   2.6228D-15  -8.7547D-16  -1.5538D-15  -3.3857D-16   2.9481D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ALGOPARK  HYD  DER_NORT   1.4930D-04   5.1494D-05  -9.5556D-06   2.1117D-05   1.1243D-05  -2.9675D-06   3.1165D-06   7.5539D-07   7.7700D-07  
D  ALGOPARK  HYD  DER_EAST  -1.7314D-05   5.3121D-06  -3.6286D-05  -5.5190D-06  -1.6673D-05  -7.2972D-06   1.2735D-06   1.2323D-06   3.3690D-07  
D  ALGOPARK  HYD  CHEB_0     7.4969D-09   1.0371D-11   9.6834D-12  -1.1585D-12  -3.6821D-12   9.7051D-12  -6.5280D-12   2.6946D-12  -6.8384D-13  
D  ALGOPARK  HYD  CHEB_1    -5.4698D-13   1.8301D-11   8.5993D-12  -1.6042D-12   2.6545D-12  -2.7295D-12   2.8479D-12   5.5599D-13  -1.3992D-13  
D  ALGOPARK  HYD  CHEB_2    -2.1396D-12   2.9289D-12   1.3848D-12  -2.1746D-13   6.0957D-13  -4.4007D-13   5.1602D-13   9.9512D-14  -2.8145D-14  
D  ALGOPARK  HYD  CHEB_3    -1.7043D-12  -4.0190D-13  -1.9480D-13   5.1070D-14  -1.2490D-14   6.3211D-14  -5.2874D-14  -9.8209D-15   7.2444D-16  
D  ALGOPARK  HYD  CHEB_4    -6.9537D-13  -1.5272D-15  -5.7886D-15  -1.2082D-15  -9.1072D-15  -7.4978D-17  -4.2506D-15   6.3080D-16  -9.9069D-16  
D  ALGOPARK  HYD  CHEB_5    -1.0683D-13  -1.9543D-15   3.1288D-16  -1.2788D-15  -1.3220D-15  -2.7251D-16   5.5546D-16  -6.3939D-16   2.3493D-16  
#
D  ALGOPARK  NHY  DER_NORT   1.2509D-03   7.8600D-04   1.2471D-04  -1.8924D-04   6.2801D-04   7.9808D-05  -4.0404D-04   1.6823D-04   2.9541D-04  
D  ALGOPARK  NHY  DER_EAST  -4.6517D-04  -6.3890D-05  -4.3936D-04   7.9886D-05  -1.1010D-04  -2.4719D-04   8.0206D-05  -5.1472D-05   1.5550D-04  
D  ALGOPARK  NHY  CHEB_0     3.3144D-10  -1.9715D-10  -1.0052D-10   4.0848D-11  -7.4876D-12  -6.5970D-12  -2.0671D-11  -3.7881D-12   2.3511D-12  
D  ALGOPARK  NHY  CHEB_1     1.8933D-11  -1.1568D-11  -6.0037D-12   2.7322D-12  -2.1524D-13  -6.5646D-13  -1.2880D-12  -3.3987D-13   1.6111D-13  
D  ALGOPARK  NHY  CHEB_2     3.3890D-12  -2.1033D-12  -1.0930D-12   5.1513D-13  -4.6137D-15  -1.2916D-13  -2.3767D-13  -6.9988D-14   2.3526D-14  
D  ALGOPARK  NHY  CHEB_3    -3.6006D-13   2.0670D-13   1.0703D-13  -4.0780D-14   1.8770D-14   1.0453D-14   2.3023D-14   1.7988D-15  -3.5156D-15  
D  ALGOPARK  NHY  CHEB_4    -5.0384D-14   2.7393D-14   1.6338D-14  -5.6775D-15  -2.8799D-16  -5.2124D-16   2.9521D-15  -1.2919D-15  -3.6575D-17  
D  ALGOPARK  NHY  CHEB_5    -9.6783D-15   8.1545D-15   3.6145D-15  -2.0348D-15  -2.2016D-16   1.6386D-15   2.0607D-15   6.0116D-17   1.5509D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  AUSTINTX  HYD  DER_NORT   7.7349D-05   5.7096D-05   2.4466D-05  -1.3009D-05  -8.0560D-06  -1.0058D-05   1.1056D-05  -1.6707D-07  -1.5533D-07  
D  AUSTINTX  HYD  DER_EAST   6.4603D-06   4.0541D-06   8.9040D-06   7.5191D-06  -2.4934D-06   9.6008D-06  -2.7802D-06  -6.1189D-07   1.5478D-06  
D  AUSTINTX  HYD  CHEB_0     7.5419D-09   3.1699D-11   7.5741D-12   1.3159D-11   2.4076D-12   7.1142D-13  -2.8327D-12   6.6856D-12   3.4386D-12  
D  AUSTINTX  HYD  CHEB_1    -2.5318D-11   9.2920D-12   5.1970D-12   8.1379D-13  -6.7229D-13  -1.7492D-14   3.0018D-13   7.3336D-13   1.8243D-13  
D  AUSTINTX  HYD  CHEB_2    -6.3061D-12   1.4183D-12   7.5565D-13   1.8163D-13  -6.5335D-14   9.5847D-15   6.5343D-14   1.2321D-13   3.2695D-14  
D  AUSTINTX  HYD  CHEB_3    -1.2071D-12  -2.3084D-13  -1.5083D-13  -6.2082D-16   3.0991D-14   3.1266D-15   1.6840D-15  -1.3774D-14  -4.1117D-15  
D  AUSTINTX  HYD  CHEB_4    -6.6655D-13   5.9742D-15   1.0322D-15  -2.1954D-15  -9.3250D-16  -2.5774D-15   1.5468D-15   5.9543D-16  -1.8965D-15  
D  AUSTINTX  HYD  CHEB_5    -1.1285D-13  -1.8241D-15  -1.3706D-16  -8.2008D-16  -8.6765D-16   1.2993D-15  -5.3042D-16  -1.1852D-15  -1.0508D-16  
#
D  AUSTINTX  NHY  DER_NORT   1.5098D-03   8.6266D-04  -8.6985D-04  -2.1442D-04  -5.3018D-05  -3.7772D-04  -2.5766D-05   2.1522D-04   2.0884D-04  
D  AUSTINTX  NHY  DER_EAST   1.6876D-04   1.0634D-04  -3.4691D-06   2.4407D-04   1.1309D-04   6.5192D-05  -5.1587D-05   9.7982D-05   5.2157D-06  
D  AUSTINTX  NHY  CHEB_0     6.1937D-10  -2.9790D-10  -8.8526D-11   3.3344D-11   4.7056D-11   6.7978D-12   3.5294D-12  -7.5263D-12   1.0134D-11  
D  AUSTINTX  NHY  CHEB_1     3.4155D-11  -1.5017D-11  -4.2584D-12   8.7000D-13   1.7287D-12   3.2121D-13   1.7824D-13   5.7742D-13   2.8821D-13  
D  AUSTINTX  NHY  CHEB_2     6.0706D-12  -2.5511D-12  -7.4032D-13   6.8433D-14   2.4413D-13   4.9642D-14   5.1930D-15   1.3136D-13   3.5701D-14  
D  AUSTINTX  NHY  CHEB_3    -6.7286D-13   3.5822D-13   9.6901D-14  -5.2141D-14  -5.7529D-14  -1.8561D-14  -1.0126D-14   2.3159D-15  -1.5904D-14  
D  AUSTINTX  NHY  CHEB_4    -9.4369D-14   4.0595D-14   1.8560D-14  -5.5283D-15  -1.1646D-14  -1.9233D-15  -3.0718D-15  -3.7936D-16  -1.4270D-15  
D  AUSTINTX  NHY  CHEB_5    -1.7085D-14   1.0529D-14   2.4167D-15  -1.9525D-16   8.9400D-16  -8.0153D-17   2.8397D-15   7.0879D-16   1.6803D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  AZORES    HYD  DER_NORT   6.0092D-05   2.4299D-05   3.4859D-06  -2.2610D-06  -7.1799D-06  -1.8178D-05   2.0769D-05  -7.2338D-07  -9.2702D-07  
D  AZORES    HYD  DER_EAST  -1.6121D-05   2.0035D-05  -2.4042D-06   5.7499D-06   1.2048D-05   1.4038D-05  -1.0790D-05  -5.1511D-07  -5.6272D-07  
D  AZORES    HYD  CHEB_0     7.7693D-09   5.8159D-12   2.5529D-11   1.5079D-11   6.5902D-12   1.0409D-11  -1.4589D-11   2.4977D-14   2.6433D-13  
D  AZORES    HYD  CHEB_1    -2.2338D-11   6.6609D-12   5.4180D-12  -7.4814D-13  -2.0343D-12  -5.0601D-13   3.1528D-13   1.6395D-13  -3.8037D-13  
D  AZORES    HYD  CHEB_2    -5.7093D-12   7.9155D-13   7.3312D-13  -1.0227D-13  -2.6753D-13  -8.0046D-14   7.1350D-14   2.8783D-14  -5.2241D-14  
D  AZORES    HYD  CHEB_3    -1.3671D-12  -2.2415D-13  -1.7499D-13   2.0503D-14   6.3859D-14   1.2196D-14  -1.7310D-15  -5.3827D-15   8.0823D-15  
D  AZORES    HYD  CHEB_4    -7.0755D-13   1.3458D-14  -1.8061D-15  -1.7747D-15  -2.1847D-15  -2.4751D-15   2.8482D-16   6.4109D-17  -9.3212D-16  
D  AZORES    HYD  CHEB_5    -1.0592D-13   1.5930D-16   2.3151D-15  -5.7708D-16  -9.1691D-16   5.7215D-16  -2.8636D-16  -5.5061D-17   4.6232D-16  
#
D  AZORES    NHY  DER_NORT  -9.1915D-05   4.3938D-04  -6.8044D-05   5.1717D-05  -3.6134D-04  -6.5304D-05   2.6594D-05   1.0746D-05   2.0307D-05  
D  AZORES    NHY  DER_EAST  -2.0522D-04   8.9228D-05  -3.6216D-04  -6.3603D-05  -3.5931D-04  -1.2781D-04  -8.6960D-07   5.5479D-05   4.4351D-05  
D  AZORES    NHY  CHEB_0     5.4432D-10  -7.3568D-11  -1.0124D-10   6.0199D-12   1.9363D-11  -7.6919D-12   1.2193D-11  -1.4474D-14   8.9835D-13  
D  AZORES    NHY  CHEB_1     3.0998D-11  -4.1128D-12  -5.0286D-12   1.3938D-13   1.1119D-12  -6.5820D-13   5.3197D-13  -1.7924D-13  -2.0564D-14  
D  AZORES    NHY  CHEB_2     5.5559D-12  -7.2593D-13  -8.3809D-13   1.4310D-14   1.9856D-13  -1.3929D-13   8.2024D-14  -3.8874D-14   1.3441D-15  
D  AZORES    NHY  CHEB_3    -5.5841D-13   8.2010D-14   1.0533D-13  -7.3556D-15  -2.1329D-14   1.7501D-14  -1.7048D-14   1.7508D-15  -8.3274D-16  
D  AZORES    NHY  CHEB_4    -9.7865D-14   1.7178D-14   2.3044D-14  -1.7846D-15  -3.2082D-15  -6.4834D-15   1.7111D-16   2.0643D-15  -2.4500D-16  
D  AZORES    NHY  CHEB_5    -1.6921D-16   3.7780D-16  -6.4608D-15  -9.4164D-16   6.1401D-16   6.3236D-15  -2.2465D-16  -7.7025D-16  -8.5710D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ARECIBO   HYD  DER_NORT  -1.2099D-05   1.5770D-05   1.0904D-05   1.9799D-06   1.0140D-05  -4.3344D-06  -2.9911D-06  -3.8268D-07   5.0045D-07  
D  ARECIBO   HYD  DER_EAST  -2.3660D-05  -5.4383D-07   1.8098D-06   3.2640D-06  -2.1445D-06   1.8541D-06  -1.7102D-07   3.5259D-07  -2.8436D-08  
D  ARECIBO   HYD  CHEB_0     7.2482D-09   4.2340D-11   3.8668D-12  -7.6164D-12  -1.7674D-12   4.0751D-12  -1.0856D-12  -1.4137D-13  -2.0857D-12  
D  ARECIBO   HYD  CHEB_1    -2.8788D-11   3.7217D-12   4.0798D-13  -4.4738D-13   4.6014D-13  -4.2349D-13  -2.2806D-13  -2.3920D-13  -1.0606D-13  
D  ARECIBO   HYD  CHEB_2    -6.8778D-12   4.4172D-13  -6.7518D-15  -1.0742D-14   1.2358D-13  -7.7927D-14  -1.5272D-14  -2.3720D-14  -9.9407D-15  
D  ARECIBO   HYD  CHEB_3    -1.0307D-12  -1.3688D-13  -3.5598D-14   3.7950D-14   1.0281D-14   9.3247D-15   1.7718D-14   9.6117D-15   2.2044D-15  
D  ARECIBO   HYD  CHEB_4    -6.2052D-13   1.4539D-15   1.3955D-15   2.1019D-15   6.7215D-16  -4.9233D-17  -8.5476D-16   2.0007D-16  -7.8333D-16  
D  ARECIBO   HYD  CHEB_5    -1.1134D-13   3.4154D-15   1.2541D-15  -1.6646D-16   1.0343D-16  -5.6955D-16  -2.4312D-15  -1.5376D-15   2.9961D-16  
#
D  ARECIBO   NHY  DER_NORT   7.0332D-04  -8.6977D-05  -3.1690D-04  -7.3886D-04  -1.4962D-03  -7.4593D-05   4.5306D-04   5.3389D-05   5.0696D-05  
D  ARECIBO   NHY  DER_EAST   2.5034D-04  -5.3367D-04  -2.7339D-04  -6.6489D-05  -1.2336D-04  -3.1968D-04   1.3115D-04  -3.6170D-05   7.8586D-06  
D  ARECIBO   NHY  CHEB_0     5.7681D-10  -3.1456D-10  -1.9647D-10   7.5744D-11   6.5426D-11  -1.0170D-11   4.6102D-11   5.5866D-12   2.0426D-12  
D  ARECIBO   NHY  CHEB_1     3.1833D-11  -1.2559D-11  -1.0827D-11   3.2385D-12   3.5153D-12  -5.8907D-13   1.4161D-12   4.9615D-13  -6.7042D-14  
D  ARECIBO   NHY  CHEB_2     5.7128D-12  -1.8808D-12  -1.8372D-12   4.4983D-13   5.0556D-13  -7.4468D-14   2.1392D-13   9.1242D-14  -3.2744D-16  
D  ARECIBO   NHY  CHEB_3    -5.9905D-13   4.0437D-13   2.3553D-13  -8.6337D-14  -1.0926D-13   4.7327D-15  -4.5736D-14  -1.1599D-14   6.1249D-15  
D  ARECIBO   NHY  CHEB_4    -9.0125D-14   3.6297D-14   3.6256D-14  -2.6776D-15   4.6172D-16   7.0360D-15   1.8524D-15  -5.9111D-16  -3.1196D-15  
D  ARECIBO   NHY  CHEB_5    -9.8510D-15   2.7763D-15   6.2173D-16   1.0451D-15  -3.3160D-15  -3.2469D-15  -1.3432D-15  -4.9824D-16   3.5818D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ATCA-104  HYD  DER_NORT  -9.3168D-05   3.3443D-05   1.0951D-05  -1.1128D-05   5.7068D-06   7.7400D-06   3.0723D-06   1.2432D-06   3.1277D-07  
D  ATCA-104  HYD  DER_EAST   1.1501D-05   1.0035D-06   7.1663D-06   1.7189D-07  -7.6109D-06   1.6239D-06   1.1536D-05   6.4485D-07   6.3750D-08  
D  ATCA-104  HYD  CHEB_0     7.5440D-09  -3.9252D-11  -1.5144D-11  -6.5593D-12  -1.1115D-12   6.3719D-12  -5.4459D-12  -6.3872D-12   6.3320D-12  
D  ATCA-104  HYD  CHEB_1    -2.0438D-11  -8.6128D-12  -3.1523D-12   2.1310D-12  -9.3465D-13  -4.6509D-13  -2.9803D-13  -5.3845D-13   6.1004D-13  
D  ATCA-104  HYD  CHEB_2    -5.5412D-12  -1.5307D-12  -5.3548D-13   3.8107D-13  -8.3818D-14  -1.2191D-13  -7.1944D-14  -9.8495D-14   1.2418D-13  
D  ATCA-104  HYD  CHEB_3    -1.3782D-12   1.7080D-13   8.1981D-14  -3.6376D-14   4.4394D-14  -3.2020D-16   1.3376D-14   5.4789D-15  -4.7224D-15  
D  ATCA-104  HYD  CHEB_4    -6.7442D-13   1.4949D-14   1.1981D-14  -3.7040D-17  -1.9375D-15   2.7153D-15   1.8978D-15   2.2475D-15   4.3920D-16  
D  ATCA-104  HYD  CHEB_5    -9.8158D-14   2.8390D-15  -3.1287D-15  -1.4966D-15  -1.8009D-15  -6.6815D-16  -2.2633D-15  -1.1096D-15  -1.8832D-15  
#
D  ATCA-104  NHY  DER_NORT  -2.5936D-04  -2.5755D-04   2.8564D-04  -2.2694D-04   2.2441D-04   7.1987D-05  -3.8407D-04   8.8424D-05  -1.2308D-04  
D  ATCA-104  NHY  DER_EAST   9.6617D-04  -2.0998D-05  -4.0339D-04  -4.2088D-05   3.3714D-05  -6.2410D-05   2.1660D-04   1.3876D-05  -1.0626D-04  
D  ATCA-104  NHY  CHEB_0     4.2526D-10   1.6690D-10   8.9608D-11   4.7523D-12   2.9481D-11  -2.0145D-11   2.4075D-11   2.5965D-12   1.0508D-12  
D  ATCA-104  NHY  CHEB_1     2.4798D-11   8.0049D-12   4.8506D-12   4.6887D-13   1.4505D-12  -7.1788D-13   1.4320D-12  -2.4815D-13   2.8985D-13  
D  ATCA-104  NHY  CHEB_2     4.5371D-12   1.3321D-12   8.5606D-13   8.2964D-14   2.3246D-13  -1.0711D-13   2.4964D-13  -9.4468D-14   1.8209D-14  
D  ATCA-104  NHY  CHEB_3    -4.4511D-13  -2.1329D-13  -1.1082D-13  -1.1765D-14  -5.0187D-14   3.1960D-14  -3.5774D-14  -1.7321D-14  -7.6682D-15  
D  ATCA-104  NHY  CHEB_4    -6.7392D-14  -3.3934D-14  -1.6868D-14  -2.9643D-15  -7.4917D-15   4.6858D-16  -4.8131D-15   5.0989D-15  -1.0008D-15  
D  ATCA-104  NHY  CHEB_5    -1.3136D-14  -1.8992D-15  -3.0492D-15   9.4467D-16  -1.1012D-15   3.3530D-15  -9.5129D-16  -1.4091D-15   1.1494D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BADARY    HYD  DER_NORT   1.2442D-04   3.4142D-05  -1.7244D-07  -2.2280D-05  -2.5355D-06  -5.9086D-06   1.5703D-05  -1.0195D-06   7.8122D-07  
D  BADARY    HYD  DER_EAST  -6.7573D-05  -4.2046D-05  -1.4136D-05   7.3898D-06   1.8409D-05  -5.8825D-07   1.6563D-05   3.6377D-06  -6.1008D-06  
D  BADARY    HYD  CHEB_0     7.0019D-09   6.4766D-11   2.5866D-12  -8.7338D-12  -7.1302D-13   1.0922D-11  -5.0499D-12  -3.7334D-12   4.7225D-12  
D  BADARY    HYD  CHEB_1     1.5860D-11   2.1334D-11   6.3944D-12  -2.8163D-12  -1.1296D-12  -3.8529D-13  -7.7470D-13  -8.5295D-13   3.9635D-13  
D  BADARY    HYD  CHEB_2     3.4121D-13   3.1775D-12   1.0149D-12  -3.7822D-13  -1.1700D-14  -9.7561D-14  -1.0400D-13  -1.5474D-13   9.1193D-14  
D  BADARY    HYD  CHEB_3    -1.9250D-12  -5.4180D-13  -1.4534D-13   7.2711D-14   5.5662D-14  -1.3247D-14   2.9020D-14   1.4447D-14   1.0469D-15  
D  BADARY    HYD  CHEB_4    -6.6759D-13   1.1770D-14  -1.3309D-15  -7.7887D-16  -9.2915D-15   2.9955D-15  -8.8581D-15  -1.4973D-15   2.1422D-15  
D  BADARY    HYD  CHEB_5    -1.1024D-13  -5.0260D-15   6.7745D-16   4.2094D-15  -1.0705D-15  -6.3219D-16   3.2498D-17  -2.6067D-16  -8.0796D-16  
#
D  BADARY    NHY  DER_NORT   2.0610D-05  -2.8307D-04  -2.9266D-05   1.0788D-04  -2.2296D-04  -3.0498D-04   2.4412D-04  -1.6352D-04   2.9161D-04  
D  BADARY    NHY  DER_EAST  -8.4133D-04   3.8185D-04   2.0942D-04   4.1023D-05   3.5918D-04   2.5079D-04   1.4251D-04  -2.2771D-04   4.6370D-04  
D  BADARY    NHY  CHEB_0     2.5693D-10  -2.2708D-10  -6.5965D-11   7.1692D-11   3.0832D-11  -2.6448D-11  -1.3193D-11   1.5756D-11   3.1186D-12  
D  BADARY    NHY  CHEB_1     1.5968D-11  -1.3539D-11  -3.9837D-12   3.5217D-12   1.7089D-12  -1.0099D-12  -5.0412D-13   6.4068D-13   3.2474D-13  
D  BADARY    NHY  CHEB_2     2.9084D-12  -2.4165D-12  -7.0868D-13   5.5971D-13   2.8353D-13  -1.4189D-13  -5.8443D-14   7.8793D-14   3.5098D-14  
D  BADARY    NHY  CHEB_3    -2.7941D-13   2.5551D-13   7.6113D-14  -9.3505D-14  -4.0197D-14   3.2931D-14   2.0003D-14  -2.4526D-14  -2.3592D-14  
D  BADARY    NHY  CHEB_4    -4.1217D-14   3.7535D-14   1.1281D-14  -1.3157D-14  -5.0199D-15   5.0968D-15   2.1586D-15  -3.6534D-15   1.8894D-15  
D  BADARY    NHY  CHEB_5    -5.8791D-15   3.6733D-15   9.6830D-16   1.5339D-16   5.0000D-17  -4.5853D-16  -9.2204D-16   1.0529D-15  -1.5617D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BERMUDA   HYD  DER_NORT   8.5753D-05   5.7777D-05   5.1025D-05  -6.7702D-06   1.8909D-05  -1.5251D-05   2.4359D-05   4.9209D-07   2.1719D-07  
D  BERMUDA   HYD  DER_EAST   2.1395D-05  -2.7313D-06  -6.6351D-06  -3.2097D-06   1.0759D-06  -6.2386D-06   8.9596D-06   1.2754D-07  -1.7439D-07  
D  BERMUDA   HYD  CHEB_0     7.7449D-09   1.0905D-11   1.0523D-11   2.1422D-11  -3.1398D-12   5.1035D-13  -1.0683D-11   2.9627D-13   1.2922D-12  
D  BERMUDA   HYD  CHEB_1    -2.8974D-11   6.4119D-12   7.6337D-12  -9.4211D-13  -5.9246D-13  -7.8838D-13   9.3805D-14   2.4861D-13  -1.3679D-13  
D  BERMUDA   HYD  CHEB_2    -6.1664D-12   8.7390D-13   1.1446D-12  -1.6955D-13  -4.1646D-14  -1.1462D-13   3.4521D-14   3.4838D-14  -2.0076D-14  
D  BERMUDA   HYD  CHEB_3    -1.2636D-12  -1.8168D-13  -2.0344D-13   1.7872D-14   3.2598D-14   2.0032D-14   9.8021D-15  -6.8789D-15   4.0170D-16  
D  BERMUDA   HYD  CHEB_4    -7.1421D-13   5.4891D-15  -6.4645D-15   1.0625D-15  -1.8322D-15   3.1541D-15   6.4625D-16  -5.7683D-16   5.2205D-16  
D  BERMUDA   HYD  CHEB_5    -9.2247D-14   2.0031D-15   3.4391D-15  -1.1698D-15  -1.0334D-15  -2.5599D-15   1.6081D-15   7.5497D-16  -9.0046D-16  
#
D  BERMUDA   NHY  DER_NORT   6.2322D-04   5.0620D-05   1.8578D-04  -4.3146D-05   3.0474D-04  -3.9179D-04   4.4996D-04  -4.6801D-05   8.2855D-06  
D  BERMUDA   NHY  DER_EAST  -1.5191D-04  -2.3620D-05  -1.2205D-06  -9.2078D-05  -4.1863D-05  -3.9808D-04   3.3888D-04   7.8241D-05   6.0975D-06  
D  BERMUDA   NHY  CHEB_0     6.5033D-10  -1.7862D-10  -1.6497D-10   1.7459D-11   5.6899D-11  -3.3433D-12   1.0040D-11   4.1022D-13  -5.5553D-14  
D  BERMUDA   NHY  CHEB_1     3.6588D-11  -8.6390D-12  -8.4161D-12   8.3598D-13   1.9854D-12  -1.1303D-13  -3.7967D-15  -1.3275D-14   1.8798D-14  
D  BERMUDA   NHY  CHEB_2     6.5829D-12  -1.4406D-12  -1.4684D-12   1.1900D-13   2.6453D-13  -1.2795D-14   7.9363D-15   7.9736D-15  -8.2420D-15  
D  BERMUDA   NHY  CHEB_3    -6.9969D-13   2.2453D-13   1.8430D-13  -3.7271D-14  -7.8359D-14   4.6551D-15  -1.4108D-14   6.8125D-15  -2.7290D-15  
D  BERMUDA   NHY  CHEB_4    -9.9658D-14   2.2428D-14   2.8258D-14   4.2585D-15  -3.6885D-15  -8.8846D-16  -3.4306D-15  -3.6953D-15  -1.1504D-15  
D  BERMUDA   NHY  CHEB_5    -2.1449D-14   6.8807D-15   5.7374D-15  -1.7278D-15  -2.3896D-15  -1.3133D-15  -2.4523D-15   2.8181D-15   1.5000D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BLKBUTTE  HYD  DER_NORT   5.2088D-05   2.1621D-05   9.3440D-06  -2.0580D-05  -1.5449D-05   6.5481D-07  -8.4641D-09  -1.4485D-06  -3.3266D-07  
D  BLKBUTTE  HYD  DER_EAST   1.3338D-05  -1.9183D-05  -1.0046D-05  -4.6607D-06   5.5714D-06  -1.0279D-05   4.3430D-06   4.2193D-06   1.4656D-07  
D  BLKBUTTE  HYD  CHEB_0     7.2563D-09   3.7677D-11   6.3707D-12   8.3600D-12   1.9689D-12   1.1169D-12  -2.7394D-12   2.9409D-12   5.9345D-12  
D  BLKBUTTE  HYD  CHEB_1    -1.7183D-11   1.1846D-11   6.0557D-12  -9.0200D-13  -1.1213D-12   1.6978D-12   1.1387D-12   4.8753D-13   5.6983D-13  
D  BLKBUTTE  HYD  CHEB_2    -5.0941D-12   1.8769D-12   9.2030D-13  -1.4942D-13  -1.4995D-13   3.2337D-13   1.8353D-13   9.2874D-14   9.5737D-14  
D  BLKBUTTE  HYD  CHEB_3    -1.3906D-12  -2.8421D-13  -1.5924D-13   3.3166D-14   4.0077D-14  -2.5868D-14  -2.9778D-14  -7.0137D-15  -1.1198D-14  
D  BLKBUTTE  HYD  CHEB_4    -6.5728D-13  -7.8251D-15  -7.4637D-15   7.4508D-15   1.0768D-15  -3.1166D-15  -2.1017D-15   8.2692D-16  -1.1818D-15  
D  BLKBUTTE  HYD  CHEB_5    -8.5593D-14   6.3373D-15   4.0519D-15  -8.5647D-15  -7.8837D-15   4.9511D-16   2.1815D-15  -4.9214D-17  -1.9744D-16  
#
D  BLKBUTTE  NHY  DER_NORT  -8.9306D-04  -1.2051D-03  -8.4109D-04   3.6705D-04   4.5222D-04   5.9468D-05   2.6452D-04   3.0345D-05   1.9430D-06  
D  BLKBUTTE  NHY  DER_EAST   1.1289D-03  -1.3598D-03  -2.0510D-04   4.3430D-04   7.0377D-04   3.1682D-04  -1.9181D-04   4.3845D-04   2.1416D-04  
D  BLKBUTTE  NHY  CHEB_0     2.9447D-10  -1.4591D-10  -9.6057D-11   1.4998D-11   9.3784D-11  -5.4641D-12  -6.6398D-11  -7.4867D-13   4.5524D-12  
D  BLKBUTTE  NHY  CHEB_1     1.7006D-11  -7.7339D-12  -4.9676D-12   2.1491D-13   4.7674D-12   2.8618D-13  -3.1370D-12  -2.7127D-13   3.0461D-13  
D  BLKBUTTE  NHY  CHEB_2     3.0828D-12  -1.3450D-12  -8.3642D-13  -9.9855D-15   7.9047D-13   7.8334D-14  -4.9708D-13  -1.2654D-14   3.7027D-14  
D  BLKBUTTE  NHY  CHEB_3    -3.0738D-13   1.6678D-13   1.2137D-13  -2.7702D-14  -1.2030D-13   7.2743D-15   8.6192D-14   2.2102D-14  -1.5888D-14  
D  BLKBUTTE  NHY  CHEB_4    -4.1144D-14   1.8238D-14   1.1859D-14   3.6417D-16  -1.2866D-14  -6.7178D-16   7.7436D-15   1.1346D-15   2.2183D-16  
D  BLKBUTTE  NHY  CHEB_5    -8.9391D-15   5.8838D-15   4.2335D-15  -2.1141D-15  -4.4526D-15   2.2742D-16   2.8677D-15   5.0448D-16  -1.8549D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BLOOMIND  HYD  DER_NORT   1.3992D-04   7.4537D-05   1.0789D-05  -1.8564D-06   1.7872D-05  -9.9774D-06   1.9114D-05   2.0471D-06   1.0249D-06  
D  BLOOMIND  HYD  DER_EAST  -2.1976D-05   7.9134D-06  -1.3586D-05   1.5822D-06  -1.4089D-05   1.4804D-05  -3.5584D-06   2.2727D-08   7.3202D-07  
D  BLOOMIND  HYD  CHEB_0     7.5189D-09   2.5547D-11   9.6775D-12   8.6986D-12  -2.6131D-12   8.8290D-13  -1.2019D-12   4.0387D-12   1.5559D-12  
D  BLOOMIND  HYD  CHEB_1    -1.2777D-11   1.5372D-11   6.7331D-12  -1.7846D-12   3.9739D-13  -2.3254D-12   2.4920D-12   6.1996D-13  -2.7690D-14  
D  BLOOMIND  HYD  CHEB_2    -4.1339D-12   2.4520D-12   9.9631D-13  -2.4718D-13   1.8310D-13  -3.7268D-13   4.3638D-13   1.0124D-13   2.9838D-15  
D  BLOOMIND  HYD  CHEB_3    -1.4900D-12  -3.5111D-13  -1.8794D-13   5.7576D-14   3.0820D-14   5.5064D-14  -4.4571D-14  -1.1191D-14   9.6329D-16  
D  BLOOMIND  HYD  CHEB_4    -6.8606D-13  -3.1071D-15  -2.6879D-15  -6.7278D-16  -4.0123D-15   2.7327D-15  -3.4936D-15   3.4384D-16  -9.4109D-16  
D  BLOOMIND  HYD  CHEB_5    -1.0584D-13  -2.9452D-16   1.5198D-15  -9.5182D-16  -1.8004D-15  -1.7252D-15   1.1656D-15   7.3464D-16  -1.4006D-15  
#
D  BLOOMIND  NHY  DER_NORT   9.6069D-04   8.9093D-04   3.3795D-04   1.4753D-04   1.1595D-03  -2.0281D-04   2.7912D-04  -3.3162D-05   1.1088D-05  
D  BLOOMIND  NHY  DER_EAST  -4.3920D-04  -1.2797D-05  -3.2602D-04   6.1269D-05  -8.3046D-05   7.6619D-05  -9.8699D-05  -2.1343D-05  -1.3910D-04  
D  BLOOMIND  NHY  CHEB_0     4.4925D-10  -2.3017D-10  -7.9338D-11   2.4994D-11   3.3387D-11   3.0307D-11  -4.0789D-11  -9.5743D-12   7.0826D-13  
D  BLOOMIND  NHY  CHEB_1     2.4882D-11  -1.2852D-11  -4.4076D-12   9.4834D-13   1.7639D-12   1.8629D-12  -2.4376D-12  -5.5902D-13   4.0777D-13  
D  BLOOMIND  NHY  CHEB_2     4.3928D-12  -2.2748D-12  -7.5779D-13   1.4854D-13   2.8494D-13   3.1933D-13  -4.4034D-13  -1.0211D-13   6.4645D-14  
D  BLOOMIND  NHY  CHEB_3    -4.8671D-13   2.4193D-13   9.4492D-14  -2.3372D-14  -4.4973D-14  -3.8921D-14   4.3616D-14   1.1783D-14  -8.9814D-15  
D  BLOOMIND  NHY  CHEB_4    -6.5806D-14   2.6689D-14   1.1878D-14  -2.9513D-15  -4.4441D-15  -3.8849D-15   7.0285D-15  -1.0780D-15   7.9659D-15  
D  BLOOMIND  NHY  CHEB_5    -6.5637D-15   4.3043D-15   2.3104D-15  -3.1066D-16  -1.9926D-15   6.7122D-16   1.5928D-15   8.3600D-16  -5.2324D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BR-VLBA   HYD  DER_NORT   9.9935D-05   3.3084D-05   1.0134D-06   3.8871D-06  -1.7374D-05  -1.9655D-05  -2.2291D-05  -5.2516D-06   2.8193D-06  
D  BR-VLBA   HYD  DER_EAST   3.2028D-05  -8.4383D-06   1.1827D-05   1.2726D-05  -9.6940D-06  -9.2663D-06  -3.0482D-05  -6.7978D-06   5.6725D-06  
D  BR-VLBA   HYD  CHEB_0     7.4976D-09   3.6972D-11   7.8452D-12   8.9084D-12   1.2825D-13   8.7032D-12   7.0620D-12   9.3508D-12   3.2713D-12  
D  BR-VLBA   HYD  CHEB_1    -4.8117D-12   1.4348D-11   5.8533D-12  -1.2512D-12  -4.1302D-12   1.9751D-13  -7.0312D-13   1.1337D-12   2.5512D-13  
D  BR-VLBA   HYD  CHEB_2    -2.7240D-12   2.3482D-12   9.6856D-13  -6.3524D-14  -5.7630D-13   3.9914D-14  -1.3510D-13   2.1613D-13   4.5473D-14  
D  BR-VLBA   HYD  CHEB_3    -1.6335D-12  -3.0492D-13  -1.3912D-13   5.0887D-14   1.1535D-13   4.0099D-15   1.9982D-15  -7.0561D-15  -1.1927D-14  
D  BR-VLBA   HYD  CHEB_4    -6.7867D-13  -1.8476D-14  -4.3613D-15  -6.8047D-15  -7.7461D-16  -2.5769D-15   7.3453D-15  -6.3585D-16  -1.6928D-15  
D  BR-VLBA   HYD  CHEB_5    -1.1857D-13   5.0021D-15   3.3584D-15  -1.8290D-15  -9.5979D-16   1.2653D-15   1.1224D-15   2.2738D-15  -7.7092D-16  
#
D  BR-VLBA   NHY  DER_NORT  -5.9421D-04   9.3550D-04   5.6313D-04  -1.5196D-04  -2.6278D-04  -1.3685D-04  -8.3090D-05   2.5387D-04   8.7183D-05  
D  BR-VLBA   NHY  DER_EAST  -7.5137D-05  -6.1216D-04  -7.3780D-07  -4.0044D-04   2.3343D-04   6.1868D-05   2.9638D-04   1.8980D-04   1.4259D-04  
D  BR-VLBA   NHY  CHEB_0     3.2348D-10  -9.0393D-11  -3.8124D-11   1.1506D-11   1.8622D-11  -2.9211D-11  -3.1447D-12   6.4623D-13  -3.2794D-13  
D  BR-VLBA   NHY  CHEB_1     1.9554D-11  -5.3319D-12  -2.0904D-12   3.9008D-13   1.0356D-12  -1.7708D-12  -1.5549D-13  -5.2779D-14  -9.9528D-14  
D  BR-VLBA   NHY  CHEB_2     3.5970D-12  -9.9872D-13  -3.8054D-13   4.0214D-14   1.8517D-13  -2.9239D-13  -1.6450D-14  -2.6859D-14  -2.8955D-14  
D  BR-VLBA   NHY  CHEB_3    -3.3069D-13   7.9286D-14   3.6500D-14  -2.4338D-14  -1.9721D-14   4.6655D-14   9.5371D-15  -7.3532D-15  -2.6891D-15  
D  BR-VLBA   NHY  CHEB_4    -5.0884D-14   1.4136D-14   5.8040D-15  -1.2325D-15  -1.3417D-15   6.1063D-15   1.7818D-16   1.3814D-15  -1.4488D-15  
D  BR-VLBA   NHY  CHEB_5    -7.9735D-15   9.1765D-16   1.0442D-15  -8.5993D-16  -1.1904D-15   3.8752D-16   6.3514D-16   7.4015D-16   1.0624D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  BREST     HYD  DER_NORT   1.0205D-04   3.2022D-05  -3.1325D-05   3.8270D-05   7.8557D-06  -1.2802D-05   1.2829D-05   6.5997D-08  -1.1942D-06  
D  BREST     HYD  DER_EAST   5.1624D-06   2.2476D-06  -2.9376D-05   6.7076D-06  -2.2734D-05  -1.4630D-05   2.1412D-05  -2.5828D-07   6.3802D-07  
D  BREST     HYD  CHEB_0     7.6795D-09   1.7974D-11   1.6232D-11   1.2845D-11   2.4054D-12   1.8960D-11  -2.0631D-11  -3.6236D-13   3.4526D-13  
D  BREST     HYD  CHEB_1    -1.0369D-11   8.6018D-12   6.1503D-12  -2.3676D-13  -7.1524D-13  -1.1070D-12   2.1462D-14  -6.6583D-14  -4.2114D-13  
D  BREST     HYD  CHEB_2    -3.9663D-12   9.5456D-13   8.8174D-13  -9.2718D-15  -2.4718D-14  -2.0534D-13   2.6454D-14   1.8729D-14  -4.8239D-14  
D  BREST     HYD  CHEB_3    -1.6408D-12  -2.9586D-13  -1.8971D-13   1.0682D-14   3.6555D-14   1.7173D-14   5.8995D-15  -4.7171D-15   9.3692D-15  
D  BREST     HYD  CHEB_4    -6.9093D-13   2.3841D-14  -1.7363D-15  -3.6811D-15  -7.0725D-15   1.4784D-15   1.1223D-15  -1.2645D-15  -1.3842D-15  
D  BREST     HYD  CHEB_5    -1.1276D-13  -4.4070D-16   1.4063D-15  -3.2573D-16  -3.8090D-16  -2.7474D-16  -7.8264D-16   1.1678D-15   5.0352D-16  
#
D  BREST     NHY  DER_NORT   6.2418D-04  -6.5330D-04   1.5775D-04  -1.3992D-04   1.4123D-04   1.7507D-04   2.2228D-04   3.6069D-04   2.3534D-05  
D  BREST     NHY  DER_EAST   4.8849D-04  -2.9888D-04  -4.7127D-04  -9.2574D-05  -2.4068D-04  -2.2071D-05   2.8687D-06   9.4494D-05  -9.1689D-05  
D  BREST     NHY  CHEB_0     4.3582D-10  -1.1609D-10  -8.2213D-11   1.0410D-11   8.4171D-12   5.1672D-12   2.0664D-11  -3.4605D-12  -3.5879D-12  
D  BREST     NHY  CHEB_1     2.4901D-11  -5.9392D-12  -4.1231D-12   7.0997D-13   6.3265D-13   1.5327D-13   1.0250D-12  -1.1952D-13  -3.1961D-13  
D  BREST     NHY  CHEB_2     4.4887D-12  -9.8929D-13  -7.0635D-13   1.0797D-13   1.0778D-13   1.2178D-14   1.7021D-13  -4.0685D-14  -6.1180D-14  
D  BREST     NHY  CHEB_3    -4.6232D-13   1.5597D-13   9.8163D-14  -1.7428D-14  -1.9051D-14  -8.6090D-15  -2.2266D-14   1.7190D-15   3.9098D-15  
D  BREST     NHY  CHEB_4    -7.0857D-14   1.3831D-14   1.1080D-14  -9.1282D-16   1.1790D-15  -1.9880D-15  -3.1721D-15  -7.6606D-16  -1.5931D-15  
D  BREST     NHY  CHEB_5    -1.1863D-14   5.1608D-15   3.4405D-15   1.1349D-15  -1.8703D-15  -9.0583D-16   6.3356D-16   1.9864D-15   4.6682D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CAMBRIDG  HYD  DER_NORT   1.1427D-04   5.9938D-05  -3.0548D-05   3.7963D-05  -6.7460D-06   3.8537D-06   1.6763D-06  -1.7173D-07   5.4748D-07  
D  CAMBRIDG  HYD  DER_EAST   4.8455D-06  -3.5464D-06  -2.5353D-05   7.4681D-06  -2.6439D-05  -1.3052D-05   1.3091D-05  -5.7823D-07  -1.6062D-06  
D  CAMBRIDG  HYD  CHEB_0     7.6772D-09   9.6808D-12   1.7509D-11   9.3841D-13  -2.1492D-12   1.6780D-11  -1.8313D-11  -7.5046D-13  -1.2687D-12  
D  CAMBRIDG  HYD  CHEB_1    -7.5374D-12   9.8458D-12   5.6126D-12   2.0705D-13  -1.2199D-13  -9.4498D-13  -1.1673D-13   2.9055D-14  -5.9896D-13  
D  CAMBRIDG  HYD  CHEB_2    -3.5473D-12   1.1228D-12   7.9543D-13   8.2740D-14   6.6537D-14  -1.9959D-13   5.1248D-15   7.1460D-15  -9.2090D-14  
D  CAMBRIDG  HYD  CHEB_3    -1.6769D-12  -3.2528D-13  -1.7211D-13   6.4594D-15   1.4147D-14   7.0108D-15   9.1898D-15  -1.7210D-15   1.1480D-14  
D  CAMBRIDG  HYD  CHEB_4    -7.1865D-13   1.6817D-14   1.8990D-15  -8.3679D-15  -4.4347D-15  -8.8321D-16   3.1835D-15   9.7186D-16  -7.2333D-16  
D  CAMBRIDG  HYD  CHEB_5    -1.0694D-13   7.1966D-15   7.5211D-16   2.4363D-15  -1.6534D-15   2.1491D-15  -3.5314D-16  -1.0183D-15   3.5014D-16  
#
D  CAMBRIDG  NHY  DER_NORT   3.3318D-04   3.1591D-04  -2.0853D-04   1.6386D-05  -4.5757D-04   2.0993D-04   2.2566D-04   7.9662D-05   7.4417D-05  
D  CAMBRIDG  NHY  DER_EAST  -8.7403D-05  -1.5594D-04  -1.0648D-04  -2.0034D-04  -1.2524D-04   9.7991D-05   1.7247D-04   2.8174D-04  -2.9558D-04  
D  CAMBRIDG  NHY  CHEB_0     4.0220D-10  -1.1996D-10  -8.2502D-11   7.5277D-12   9.3518D-12   8.1882D-12   2.4007D-11  -6.8902D-12   1.9871D-12  
D  CAMBRIDG  NHY  CHEB_1     2.3769D-11  -6.7150D-12  -4.6816D-12   5.7559D-13   6.8786D-13   4.2266D-13   1.2887D-12  -2.1514D-13   1.4136D-13  
D  CAMBRIDG  NHY  CHEB_2     4.3104D-12  -1.1492D-12  -8.2803D-13   1.0854D-13   1.2937D-13   6.2160D-14   2.0524D-13  -3.2875D-14   2.8508D-14  
D  CAMBRIDG  NHY  CHEB_3    -4.1013D-13   1.3572D-13   8.0235D-14  -4.5369D-15  -4.0873D-16  -1.1828D-14  -3.8717D-14   1.0033D-14   2.0184D-15  
D  CAMBRIDG  NHY  CHEB_4    -7.1210D-14   2.5143D-14   1.9160D-14  -1.7579D-15  -8.5195D-15  -3.2539D-15  -1.7519D-16   2.5287D-15  -5.7567D-16  
D  CAMBRIDG  NHY  CHEB_5    -5.3990D-15  -3.4969D-15  -2.2099D-16   6.3900D-16   3.3649D-15   1.1835D-15  -1.9865D-15  -5.1969D-16   2.5316D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CARNUSTY  HYD  DER_NORT   1.2880D-04   7.8780D-05  -7.0324D-06   2.5320D-05  -1.8325D-05   1.7015D-05  -1.8927D-05  -2.6202D-06   6.6740D-07  
D  CARNUSTY  HYD  DER_EAST   1.7453D-05   7.4960D-06  -2.4695D-05   1.6022D-06  -2.0251D-05  -2.9557D-06   2.6227D-06  -2.1365D-06  -9.1792D-07  
D  CARNUSTY  HYD  CHEB_0     7.6747D-09  -1.9591D-11   2.9243D-11  -1.0088D-11   2.7638D-12   1.5582D-11  -1.1419D-11   2.4033D-14  -4.5067D-13  
D  CARNUSTY  HYD  CHEB_1    -4.0113D-12   1.0289D-11   5.1109D-12   9.1279D-13  -9.7365D-13  -6.9569D-13   6.0606D-13   2.5175D-14  -4.5183D-13  
D  CARNUSTY  HYD  CHEB_2    -2.6356D-12   1.3738D-12   6.7715D-13   2.5089D-13  -1.5005D-13  -1.2135D-13   6.3433D-14  -2.2865D-14  -8.4470D-14  
D  CARNUSTY  HYD  CHEB_3    -1.8173D-12  -4.0443D-13  -1.6993D-13  -2.2271D-14   3.8089D-14  -4.4096D-15  -4.0198D-15   3.4556D-15   7.4220D-15  
D  CARNUSTY  HYD  CHEB_4    -6.9082D-13   4.7075D-14   1.7217D-15  -1.3861D-15  -8.5499D-15   3.0232D-15   8.2210D-16  -1.6407D-16  -3.7560D-16  
D  CARNUSTY  HYD  CHEB_5    -1.1868D-13   1.9536D-15   3.6288D-15  -1.6075D-15   1.1436D-15   1.7980D-16  -2.2279D-15  -1.1986D-15  -1.3879D-15  
#
D  CARNUSTY  NHY  DER_NORT   9.7486D-05   9.6364D-05   9.1224D-05   1.7916D-04  -2.8920D-04   2.3661D-04   1.3231D-04  -2.0561D-04  -1.6018D-04  
D  CARNUSTY  NHY  DER_EAST  -1.8011D-04  -1.2974D-04  -2.3503D-04  -2.7377D-04   2.7199D-04   1.3465D-04   1.1539D-04  -1.7092D-04  -3.5929D-04  
D  CARNUSTY  NHY  CHEB_0     3.7987D-10  -1.1718D-10  -7.9474D-11   5.1968D-12   2.5447D-11  -4.7776D-12   7.0921D-12  -4.3384D-12   5.0718D-12  
D  CARNUSTY  NHY  CHEB_1     2.2788D-11  -5.9751D-12  -4.2605D-12   4.1328D-13   1.1417D-12  -2.0641D-13   3.9870D-13  -2.1769D-13   2.3162D-13  
D  CARNUSTY  NHY  CHEB_2     4.2087D-12  -9.9284D-13  -7.6643D-13   5.4928D-14   1.9674D-13  -1.4516D-14   5.8450D-14  -2.7287D-14   2.9522D-14  
D  CARNUSTY  NHY  CHEB_3    -3.7826D-13   1.4187D-13   7.8004D-14  -1.8483D-14  -2.7419D-14   8.1990D-15  -1.2311D-14   9.6678D-15  -1.3246D-14  
D  CARNUSTY  NHY  CHEB_4    -6.6485D-14   1.8922D-14   1.3453D-14   4.1183D-16  -1.6901D-15   1.5075D-15   3.6790D-16   4.1550D-16  -8.4591D-16  
D  CARNUSTY  NHY  CHEB_5    -7.1566D-15   9.0282D-16   6.6029D-16  -1.9062D-15  -1.7961D-15  -1.5026D-15  -1.9571D-15  -6.1586D-16  -6.9924D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CARROLGA  HYD  DER_NORT   1.0890D-04   7.3923D-05   2.2259D-05  -1.1954D-05   1.5607D-05  -1.6555D-05   1.7216D-05  -4.9853D-08   6.5314D-08  
D  CARROLGA  HYD  DER_EAST  -7.7498D-06   9.9754D-06  -7.0512D-06   8.6092D-06  -1.2901D-06   8.5062D-06  -4.1882D-06  -3.3934D-07   6.8787D-08  
D  CARROLGA  HYD  CHEB_0     7.4559D-09   2.4552D-11   1.0926D-11   9.8715D-12  -3.3919D-12   8.6363D-13  -4.2672D-12   5.9764D-12   1.4872D-12  
D  CARROLGA  HYD  CHEB_1    -1.9105D-11   1.0261D-11   5.8081D-12  -1.1668D-12  -9.1892D-13  -1.7768D-12   1.0032D-12   7.5392D-13  -8.4859D-14  
D  CARROLGA  HYD  CHEB_2    -5.2790D-12   1.6048D-12   8.3099D-13  -1.7784D-13  -9.4791D-14  -2.7783D-13   1.7942D-13   1.3080D-13  -2.6617D-14  
D  CARROLGA  HYD  CHEB_3    -1.3417D-12  -2.3160D-13  -1.7202D-13   3.3263D-14   4.4208D-14   4.4559D-14  -1.6441D-14  -1.0801D-14  -4.4841D-15  
D  CARROLGA  HYD  CHEB_4    -6.6497D-13  -6.5389D-16  -5.3762D-16   6.6825D-17  -1.8002D-15   1.5822D-15   7.9196D-16  -4.3210D-17   9.5404D-16  
D  CARROLGA  HYD  CHEB_5    -1.0468D-13   3.3550D-15   1.1249D-15  -6.6060D-16   9.5891D-16  -2.6737D-16  -3.9556D-16  -7.7595D-16  -3.4158D-16  
#
D  CARROLGA  NHY  DER_NORT   2.6394D-04   4.1787D-04   1.4686D-04   2.1371D-04   6.5137D-04   2.1367D-04   5.3027D-04   7.2498D-05   5.6986D-05  
D  CARROLGA  NHY  DER_EAST  -2.9458D-04   3.0637D-05  -6.4018D-05  -8.2392D-05   4.1240D-05   1.6006D-04  -4.5556D-05   6.8160D-05   4.8501D-05  
D  CARROLGA  NHY  CHEB_0     5.0645D-10  -2.5572D-10  -1.1576D-10   5.0097D-11   1.0307D-10   2.3245D-11  -4.8528D-11  -8.6754D-12   1.9817D-12  
D  CARROLGA  NHY  CHEB_1     2.8285D-11  -1.4078D-11  -6.0254D-12   1.5865D-12   4.7155D-12   2.0596D-12  -2.5983D-12  -5.4921D-13   1.2249D-13  
D  CARROLGA  NHY  CHEB_2     5.0746D-12  -2.4819D-12  -1.0156D-12   2.0640D-13   7.2463D-13   4.1798D-13  -3.8754D-13  -8.6345D-14  -1.5182D-14  
D  CARROLGA  NHY  CHEB_3    -5.3938D-13   2.9258D-13   1.3824D-13  -6.1782D-14  -1.3998D-13  -2.6548D-14   7.4121D-14   1.5749D-14  -2.3937D-14  
D  CARROLGA  NHY  CHEB_4    -7.9786D-14   3.7869D-14   2.1156D-14  -9.8529D-15  -1.5413D-14  -8.0337D-16   6.7318D-15   8.3789D-15   6.2958D-16  
D  CARROLGA  NHY  CHEB_5    -1.0964D-14   4.1010D-15   9.3700D-16   3.4133D-15  -1.7124D-15  -6.1315D-15  -1.5833D-15  -2.8836D-15   7.3440D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CEDUNA    HYD  DER_NORT  -1.1693D-04   2.4236D-05   1.1847D-05   4.9866D-06   7.6792D-07  -1.3974D-05   8.4107D-06   1.5484D-06   1.0257D-07  
D  CEDUNA    HYD  DER_EAST   3.1216D-05  -7.2268D-07   2.5620D-06  -7.2208D-06  -3.1136D-06   8.1651D-06  -5.6157D-06  -1.8283D-06  -5.5381D-07  
D  CEDUNA    HYD  CHEB_0     7.5938D-09  -4.1420D-11  -1.6240D-11  -3.3158D-12  -4.0806D-12  -2.5939D-12   1.6029D-12  -3.6182D-12   4.0539D-12  
D  CEDUNA    HYD  CHEB_1    -2.0744D-11  -8.9801D-12  -2.4318D-12   1.9549D-12  -2.3661D-12   2.2689D-13   6.9818D-13  -3.5350D-13   4.3827D-13  
D  CEDUNA    HYD  CHEB_2    -5.6414D-12  -1.4754D-12  -4.0484D-13   3.1530D-13  -3.0383D-13   2.1468D-14   1.0709D-13  -7.4865D-14   5.4896D-14  
D  CEDUNA    HYD  CHEB_3    -1.3715D-12   1.9848D-13   6.5728D-14  -4.0540D-14   8.4655D-14  -9.5022D-15  -2.3359D-14   7.8521D-15   3.5073D-15  
D  CEDUNA    HYD  CHEB_4    -6.7635D-13   1.4714D-14   6.3349D-15  -2.3072D-15  -1.8325D-15   3.2740D-16   4.6789D-16   6.1948D-16   2.1981D-15  
D  CEDUNA    HYD  CHEB_5    -1.0886D-13   5.1105D-16  -9.5133D-16   1.3084D-15  -6.6666D-17   2.9375D-16  -6.0277D-16  -8.4438D-16  -2.7632D-15  
#
D  CEDUNA    NHY  DER_NORT  -1.0138D-03  -1.5045D-03   9.1948D-05   1.5599D-05   5.1391D-04   3.1765D-04   5.5588D-04  -3.2006D-04   2.4709D-04  
D  CEDUNA    NHY  DER_EAST  -4.4805D-04   1.0017D-04   3.0599D-04   6.1270D-04   2.4169D-04   2.6769D-04  -4.6296D-05   1.8078D-04  -2.4456D-04  
D  CEDUNA    NHY  CHEB_0     3.7677D-10   9.0695D-11   9.2320D-11  -1.3941D-11   8.2953D-12  -1.0945D-11  -1.9105D-11   2.1338D-13  -1.3960D-12  
D  CEDUNA    NHY  CHEB_1     2.1158D-11   3.2851D-12   4.4193D-12   3.3197D-13   2.8356D-13   5.4429D-13  -2.4570D-13   3.0383D-13   1.0743D-13  
D  CEDUNA    NHY  CHEB_2     3.8288D-12   4.7431D-13   7.3942D-13   1.1866D-13   3.4030D-14   1.7413D-13   2.1032D-14   6.6934D-14  -2.4968D-15  
D  CEDUNA    NHY  CHEB_3    -3.9256D-13  -1.1691D-13  -1.0472D-13   2.1151D-14  -1.0145D-14   2.3897D-14   2.4581D-14   3.3952D-15  -1.0473D-14  
D  CEDUNA    NHY  CHEB_4    -5.8973D-14  -1.6627D-14  -1.5619D-14   3.0706D-15  -1.1067D-15   2.9410D-15   6.5328D-15  -2.1505D-15   4.8762D-15  
D  CEDUNA    NHY  CHEB_5    -1.1021D-14  -8.8672D-16  -8.9552D-16   4.5444D-16   7.3791D-16  -8.8434D-16  -2.6742D-15   1.1961D-15  -2.2980D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CHICHI10  HYD  DER_NORT   7.4444D-05   5.6833D-05   6.5638D-05   5.0232D-06  -9.6268D-06   1.6409D-06   3.6990D-06  -1.2504D-07   8.8604D-07  
D  CHICHI10  HYD  DER_EAST  -1.8039D-05   3.2786D-06  -4.9879D-06  -2.9085D-06  -7.5443D-06   8.0801D-06  -1.7374D-07  -3.2185D-07  -3.1870D-07  
D  CHICHI10  HYD  CHEB_0     7.6547D-09   3.6646D-11   2.2869D-11   8.5976D-12  -4.3954D-12  -2.4022D-12  -5.4679D-12  -5.3275D-13   7.5764D-13  
D  CHICHI10  HYD  CHEB_1    -3.5228D-11   6.2960D-12   5.7767D-12  -9.7296D-13   9.2819D-13  -7.3449D-13   1.0418D-13  -1.9400D-13   2.2836D-13  
D  CHICHI10  HYD  CHEB_2    -6.8864D-12   8.9206D-13   9.0258D-13  -1.3725D-13   2.1277D-13  -1.0907D-13   4.6300D-14  -1.6728D-14   3.1034D-14  
D  CHICHI10  HYD  CHEB_3    -9.5497D-13  -1.7464D-13  -1.3868D-13   3.1365D-14  -3.4671D-15   2.0441D-14   1.4050D-14   6.5078D-15  -5.3650D-15  
D  CHICHI10  HYD  CHEB_4    -7.6146D-13   2.7834D-15  -1.2382D-15   6.0971D-16  -4.0147D-15  -1.4384D-15  -1.7584D-15  -6.4684D-16   3.3579D-17  
D  CHICHI10  HYD  CHEB_5    -7.5305D-14  -2.6764D-17  -6.3101D-16  -2.1040D-16   2.1405D-17   6.4799D-16   1.4324D-15  -8.5829D-16   3.3485D-16  
#
D  CHICHI10  NHY  DER_NORT   1.1027D-03   4.3153D-04   5.4199D-04  -2.2019D-04  -4.4724D-04   5.7993D-04   9.4307D-06   1.6042D-04  -7.6929D-05  
D  CHICHI10  NHY  DER_EAST  -1.7151D-04   2.9788D-05  -1.2896D-04   1.0987D-04  -2.0170D-04  -5.2791D-05   1.0399D-04   1.0742D-04  -2.5278D-05  
D  CHICHI10  NHY  CHEB_0     7.9477D-10  -2.2094D-10  -2.0382D-10   9.3645D-12  -2.2074D-11   1.7935D-11  -1.4043D-11   3.4168D-12  -1.9323D-12  
D  CHICHI10  NHY  CHEB_1     4.2527D-11  -9.6956D-12  -1.0180D-11   3.2636D-13  -8.8975D-13  -1.4426D-13  -9.6183D-13  -1.0953D-13   1.8664D-13  
D  CHICHI10  NHY  CHEB_2     7.3917D-12  -1.4906D-12  -1.6594D-12  -7.1046D-15  -1.4565D-13  -3.3143D-14  -1.3242D-13  -3.7666D-14   3.1730D-14  
D  CHICHI10  NHY  CHEB_3    -8.7004D-13   2.7685D-13   2.3161D-13  -2.2758D-14   2.7594D-14  -1.2218D-14   2.9706D-14  -8.0530D-15  -6.9719D-17  
D  CHICHI10  NHY  CHEB_4    -1.4301D-13   3.7377D-14   4.8363D-14  -1.8966D-15   6.5639D-15  -5.8602D-15  -5.0648D-15  -1.8809D-16   8.8005D-17  
D  CHICHI10  NHY  CHEB_5    -1.0660D-14   2.6442D-15  -4.6621D-15   1.5480D-16   3.0004D-15  -1.4812D-16   1.9634D-15   1.1154D-15  -3.7404D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CHLBOLTN  HYD  DER_NORT   1.0883D-04   5.4811D-05  -3.2198D-05   3.9432D-05  -1.6723D-06   2.0607D-07   3.7933D-06  -2.0582D-07  -5.2786D-08  
D  CHLBOLTN  HYD  DER_EAST  -3.9627D-06  -1.6549D-06  -2.5102D-05   6.2460D-06  -2.5969D-05  -1.3823D-05   1.5966D-05  -1.0887D-06  -9.0047D-07  
D  CHLBOLTN  HYD  CHEB_0     7.6261D-09   1.1972D-11   1.6118D-11   3.7281D-12  -9.7598D-13   1.7482D-11  -1.9131D-11  -5.2911D-13  -8.9745D-13  
D  CHLBOLTN  HYD  CHEB_1    -6.6251D-12   9.4999D-12   5.6821D-12   9.7028D-14  -2.7731D-13  -1.0493D-12  -6.1439D-14   1.9280D-14  -5.8617D-13  
D  CHLBOLTN  HYD  CHEB_2    -3.4959D-12   1.0396D-12   8.0173D-13   3.5785D-14   5.0673D-14  -2.3118D-13   1.7296D-14   5.6625D-15  -9.9665D-14  
D  CHLBOLTN  HYD  CHEB_3    -1.7308D-12  -3.2780D-13  -1.6833D-13   9.0948D-15   2.1392D-14   9.5503D-15   1.5065D-14   1.8545D-16   1.1271D-14  
D  CHLBOLTN  HYD  CHEB_4    -6.7518D-13   4.0138D-14   3.2245D-17   1.6820D-15  -7.7314D-15   8.1432D-15   5.3559D-16  -2.6874D-15  -1.6960D-15  
D  CHLBOLTN  HYD  CHEB_5    -1.1275D-13  -4.9289D-15   7.1244D-16  -1.1397D-15  -9.3838D-16  -2.9889D-15   4.1623D-16   2.3316D-15   6.4475D-16  
#
D  CHLBOLTN  NHY  DER_NORT   4.5856D-04   1.1806D-04  -2.8335D-04  -7.7476D-05  -2.7285D-04   2.2329D-04   3.2743D-04   7.1353D-05  -2.9138D-04  
D  CHLBOLTN  NHY  DER_EAST  -5.2317D-04  -1.6145D-04  -1.1632D-04  -7.2164D-05  -1.5897D-04   1.0418D-04   3.4577D-04   2.2890D-04  -2.0732D-04  
D  CHLBOLTN  NHY  CHEB_0     4.0198D-10  -1.1386D-10  -8.1819D-11   6.8211D-12   5.6928D-12   8.5962D-12   2.3029D-11  -8.3627D-12   1.7326D-12  
D  CHLBOLTN  NHY  CHEB_1     2.3772D-11  -6.0156D-12  -4.3198D-12   5.0867D-13   2.2434D-13   3.5636D-13   1.4412D-12  -1.9021D-13   2.6920D-14  
D  CHLBOLTN  NHY  CHEB_2     4.3124D-12  -1.0436D-12  -7.4033D-13   1.1484D-13   4.2021D-14   4.4628D-14   2.3792D-13  -1.7471D-14  -2.0462D-15  
D  CHLBOLTN  NHY  CHEB_3    -4.3497D-13   1.3013D-13   9.9906D-14  -1.5106D-15  -5.4887D-15  -1.8354D-14  -3.8210D-14   1.6581D-14  -1.9788D-15  
D  CHLBOLTN  NHY  CHEB_4    -5.5493D-14   1.3726D-14   9.7235D-15   4.3693D-16   8.2988D-16   3.1335D-15  -8.1361D-16   1.2593D-15   2.1360D-15  
D  CHLBOLTN  NHY  CHEB_5    -1.7624D-14   6.4042D-15   3.3248D-15  -1.6897D-15  -2.0347D-15  -2.8536D-15  -1.4522D-15   9.7514D-16  -6.8182D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CRIMEA    HYD  DER_NORT   5.7290D-05   2.6648D-05  -6.1020D-06   1.2237D-05   1.9419D-05   1.1905D-05   8.1008D-06   2.2745D-06   3.1869D-08  
D  CRIMEA    HYD  DER_EAST  -4.2986D-05  -2.6261D-05  -8.4314D-06  -7.7162D-06   5.4957D-06   5.4860D-06   1.2107D-05   9.9274D-07  -3.7953D-07  
D  CRIMEA    HYD  CHEB_0     7.7062D-09   4.8092D-11   5.6709D-12  -5.0692D-13  -1.3400D-11   6.7162D-12  -1.3397D-11  -1.0283D-12  -1.6860D-12  
D  CRIMEA    HYD  CHEB_1    -1.2189D-11   1.5973D-11   8.5775D-12  -2.4827D-12  -1.0766D-12  -5.0342D-13  -5.7105D-13  -5.2478D-13  -4.3392D-13  
D  CRIMEA    HYD  CHEB_2    -3.8515D-12   2.2027D-12   1.3026D-12  -3.8038D-13  -5.3583D-14  -9.5720D-14  -1.2718D-13  -4.4800D-14  -7.7170D-14  
D  CRIMEA    HYD  CHEB_3    -1.6670D-12  -4.4621D-13  -2.2630D-13   6.9105D-14   5.1782D-14  -1.5418D-15   3.0696D-15  -1.3922D-15   1.1600D-14  
D  CRIMEA    HYD  CHEB_4    -7.1598D-13   3.0211D-15  -8.8792D-15   4.0920D-15  -1.5575D-15   1.8492D-15  -1.6934D-15   1.3893D-15  -3.9576D-16  
D  CRIMEA    HYD  CHEB_5    -9.5958D-14   3.3927D-15   4.0354D-15  -1.1567D-15  -2.2059D-15   3.3139D-16   4.6024D-15   1.4878D-15   8.8007D-16  
#
D  CRIMEA    NHY  DER_NORT  -5.3855D-04   9.1150D-04  -4.3478D-04  -4.7617D-04  -8.5955D-05  -1.5728D-04   2.2929D-04  -4.7081D-04  -3.6662D-04  
D  CRIMEA    NHY  DER_EAST  -5.7600D-04  -2.0659D-04  -3.0756D-04   1.4324D-04   3.3623D-04  -2.0743D-04   5.4942D-05   8.8510D-05  -6.8084D-05  
D  CRIMEA    NHY  CHEB_0     3.8298D-10  -1.4679D-10  -9.6438D-11   1.5227D-11   2.3297D-11  -3.2570D-12   2.7300D-11  -2.7409D-12  -2.9267D-12  
D  CRIMEA    NHY  CHEB_1     2.1714D-11  -7.9852D-12  -5.1907D-12   1.2251D-12   1.0333D-12  -9.5038D-14   1.5169D-12  -5.9542D-13  -2.6765D-13  
D  CRIMEA    NHY  CHEB_2     3.9225D-12  -1.4262D-12  -9.4374D-13   2.3894D-13   1.6713D-13  -2.4937D-14   2.7130D-13  -8.6021D-14  -5.5752D-14  
D  CRIMEA    NHY  CHEB_3    -3.9649D-13   1.4932D-13   1.0497D-13  -1.5816D-14  -2.6907D-14  -3.2377D-15  -2.8447D-14   3.4978D-15  -2.8344D-15  
D  CRIMEA    NHY  CHEB_4    -6.1283D-14   2.8189D-14   1.1306D-14  -1.6843D-15  -3.6571D-15   8.9837D-15  -1.0458D-14  -3.9780D-15  -1.3083D-16  
D  CRIMEA    NHY  CHEB_5    -7.0262D-15   9.0835D-16   7.8108D-15  -1.3769D-15   1.4214D-15  -4.2273D-15   7.3121D-16  -5.2657D-15  -9.5038D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CTVASBAY  HYD  DER_NORT   1.4833D-04   5.4039D-05  -1.0284D-05   2.0967D-05   1.3875D-05  -1.8259D-06   2.3450D-06   4.2004D-07   9.9676D-07  
D  CTVASBAY  HYD  DER_EAST  -6.9959D-07   7.4052D-06  -3.7951D-05  -4.9088D-06  -1.3833D-05  -9.5518D-06   7.8659D-07   1.3761D-06   5.0049D-07  
D  CTVASBAY  HYD  CHEB_0     7.6577D-09   1.9675D-11   1.1020D-11  -9.9052D-13  -3.7269D-12   8.8443D-12  -5.7132D-12   3.5610D-12  -8.4727D-13  
D  CTVASBAY  HYD  CHEB_1    -4.5105D-12   1.8361D-11   9.3854D-12  -1.6401D-12   2.8137D-12  -2.5808D-12   2.8605D-12   5.8407D-13  -2.0014D-13  
D  CTVASBAY  HYD  CHEB_2    -2.8235D-12   2.9113D-12   1.5128D-12  -2.3052D-13   6.3005D-13  -4.2277D-13   5.1660D-13   1.0167D-13  -3.1739D-14  
D  CTVASBAY  HYD  CHEB_3    -1.6543D-12  -4.1245D-13  -2.1756D-13   5.2447D-14  -1.2801D-14   6.2077D-14  -5.2449D-14  -5.5754D-15   2.3069D-15  
D  CTVASBAY  HYD  CHEB_4    -7.1813D-13  -3.3095D-15  -5.3441D-15  -5.1058D-15  -1.2468D-14   3.8294D-16  -3.7863D-15  -2.9253D-16   1.2834D-15  
D  CTVASBAY  HYD  CHEB_5    -1.1412D-13  -1.4379D-16   8.3700D-16   1.6049D-15   2.5460D-16   1.8697D-16  -6.1848D-16   3.5998D-16  -2.1960D-15  
#
D  CTVASBAY  NHY  DER_NORT   1.0387D-03   9.2619D-04   1.4121D-04  -4.6803D-05   6.6926D-04   2.1668D-04  -5.6438D-05   2.1051D-05   9.1100D-05  
D  CTVASBAY  NHY  DER_EAST  -2.5432D-04  -4.6280D-05  -2.7883D-04   1.1256D-04  -1.6197D-04  -1.9447D-04   1.0609D-05  -1.2778D-04  -1.5376D-04  
D  CTVASBAY  NHY  CHEB_0     3.6298D-10  -2.0878D-10  -1.1617D-10   4.3163D-11  -6.3262D-12  -7.9783D-12  -2.5255D-11  -5.4688D-12   3.6222D-12  
D  CTVASBAY  NHY  CHEB_1     2.0275D-11  -1.2152D-11  -6.5872D-12   2.6496D-12  -2.2879D-13  -4.2187D-13  -1.2052D-12  -1.3133D-13   1.8214D-13  
D  CTVASBAY  NHY  CHEB_2     3.5866D-12  -2.1721D-12  -1.1755D-12   4.7622D-13  -1.2213D-14  -4.9932D-14  -2.1063D-13  -2.9715D-14   3.5015D-14  
D  CTVASBAY  NHY  CHEB_3    -3.9227D-13   2.1390D-13   1.3323D-13  -3.9166D-14   8.2866D-15   1.0870D-14   3.1163D-14  -3.7376D-16  -9.1218D-15  
D  CTVASBAY  NHY  CHEB_4    -5.9546D-14   3.8014D-14   1.7173D-14  -1.0206D-14  -1.1262D-15   1.8408D-15   5.0132D-15  -1.3228D-15   2.2226D-15  
D  CTVASBAY  NHY  CHEB_5    -2.3126D-15  -4.2693D-15   4.5603D-15   3.4180D-15  -1.1349D-15  -3.3757D-15   5.7126D-16   3.0439D-16  -4.2737D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  CTVASTJ   HYD  DER_NORT   1.5563D-04   5.1854D-05  -2.5125D-05   2.3047D-05   3.2879D-06   4.5237D-06  -9.6419D-06  -1.0960D-06   1.5954D-06  
D  CTVASTJ   HYD  DER_EAST   6.3770D-05   1.1308D-05   2.9357D-06   3.6203D-06   2.5130D-05  -1.3367D-05   9.1915D-06  -1.3800D-06  -1.7951D-06  
D  CTVASTJ   HYD  CHEB_0     7.5652D-09  -2.0460D-11  -1.7506D-11  -3.4899D-12  -2.7924D-11  -1.1277D-12  -1.3033D-11   1.3572D-12  -4.0426D-13  
D  CTVASTJ   HYD  CHEB_1    -1.6720D-12   1.5747D-11   1.0561D-11  -7.2368D-13   5.4968D-13   4.1918D-13   1.2564D-12   4.1504D-13  -4.0302D-13  
D  CTVASTJ   HYD  CHEB_2    -2.3542D-12   2.3727D-12   1.7506D-12  -1.0296D-13   2.3112D-13   1.1458D-13   2.5039D-13   6.7542D-14  -5.6539D-14  
D  CTVASTJ   HYD  CHEB_3    -1.6907D-12  -3.8369D-13  -2.3811D-13   2.5598D-14   2.5623D-14   6.9156D-15  -1.4402D-14  -1.2924D-14   7.5313D-15  
D  CTVASTJ   HYD  CHEB_4    -7.0146D-13   1.0682D-14  -4.4201D-15  -2.1939D-15  -9.6870D-15   4.9664D-16  -3.3287D-15   1.4188D-15   6.9348D-16  
D  CTVASTJ   HYD  CHEB_5    -1.1285D-13  -2.3369D-15   7.1709D-16  -1.6172D-16   1.0087D-15  -1.2461D-15   9.0996D-16  -5.7983D-16  -5.5765D-17  
#
D  CTVASTJ   NHY  DER_NORT   1.1764D-03   4.3554D-04   4.3272D-04  -1.1502D-04  -1.2657D-04   4.9133D-04  -2.8576D-05   1.7045D-04  -1.0871D-04  
D  CTVASTJ   NHY  DER_EAST   2.3981D-05   3.5582D-05   3.7830D-04  -4.9599D-04   2.2757D-04   3.0298D-04   1.3608D-04  -7.1686D-05  -1.4055D-05  
D  CTVASTJ   NHY  CHEB_0     3.4567D-10  -1.7641D-10  -1.0957D-10   3.4587D-11   1.0629D-11  -3.0273D-11  -1.5583D-11  -4.3335D-12   6.7699D-12  
D  CTVASTJ   NHY  CHEB_1     1.9402D-11  -9.8388D-12  -5.9064D-12   2.0421D-12   7.9623D-13  -1.4862D-12  -9.6335D-13  -3.7894D-13   3.1329D-13  
D  CTVASTJ   NHY  CHEB_2     3.4701D-12  -1.7345D-12  -1.0406D-12   3.5520D-13   1.4599D-13  -2.4901D-13  -1.6865D-13  -8.0438D-14   3.9069D-14  
D  CTVASTJ   NHY  CHEB_3    -3.7281D-13   1.9658D-13   1.2157D-13  -4.3860D-14  -1.4305D-14   4.0253D-14   2.5377D-14   5.8258D-15  -1.5442D-14  
D  CTVASTJ   NHY  CHEB_4    -5.7850D-14   3.0443D-14   1.6377D-14  -3.8706D-15  -3.2646D-16  -4.5318D-16   8.9067D-16  -2.2443D-15   2.8004D-15  
D  CTVASTJ   NHY  CHEB_5    -6.7266D-15   2.4789D-15   3.7066D-15  -5.9223D-16  -1.7666D-15   2.5344D-15   2.2148D-15   2.8952D-15  -1.5389D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DARNHALL  HYD  DER_NORT   1.1345D-04   6.1229D-05  -2.5988D-05   3.3342D-05  -9.4842D-06   9.9264D-06  -3.2650D-06  -1.0840D-07   9.4479D-07  
D  DARNHALL  HYD  DER_EAST   9.5194D-06   2.5752D-06  -2.9225D-05   4.6112D-06  -2.6682D-05  -1.0231D-05   1.4112D-05  -1.0878D-06  -3.1594D-07  
D  DARNHALL  HYD  CHEB_0     7.6489D-09   1.1529D-12   2.2412D-11  -2.7305D-12   9.6351D-13   1.7996D-11  -1.8535D-11  -2.3552D-13  -1.0975D-12  
D  DARNHALL  HYD  CHEB_1    -5.8318D-12   9.8378D-12   5.2613D-12   3.8600D-13  -4.6632D-13  -8.9083D-13   9.4431D-14   4.9636D-14  -5.7731D-13  
D  DARNHALL  HYD  CHEB_2    -3.2525D-12   1.1293D-12   7.0050D-13   1.1975D-13  -1.6319D-14  -1.8322D-13   5.2076D-14   2.2082D-14  -9.7696D-14  
D  DARNHALL  HYD  CHEB_3    -1.6990D-12  -3.2088D-13  -1.6201D-13  -5.6738D-16   2.4122D-14   5.0082D-15   5.2320D-15  -4.4628D-15   8.6151D-15  
D  DARNHALL  HYD  CHEB_4    -7.0724D-13   2.1243D-14   1.6575D-15  -4.3699D-15  -4.7183D-15  -5.4617D-16   2.7321D-15  -1.4279D-15  -7.6541D-16  
D  DARNHALL  HYD  CHEB_5    -1.1414D-13  -1.0034D-15  -5.9781D-16   5.5763D-16  -7.3885D-16  -6.7262D-18  -3.1703D-16   1.1807D-15   1.3076D-15  
#
D  DARNHALL  NHY  DER_NORT   8.0242D-05  -1.0975D-04  -6.6077D-05   2.5161D-04  -2.4514D-04   2.2932D-04   4.0311D-04   2.3909D-05   1.6153D-04  
D  DARNHALL  NHY  DER_EAST   1.4538D-04  -3.6093D-04  -1.4880D-04  -1.9986D-04   7.2133D-05   1.8468D-04   2.3876D-04  -7.2333D-05  -1.7014D-04  
D  DARNHALL  NHY  CHEB_0     3.9488D-10  -1.1429D-10  -7.6870D-11   1.2247D-11   1.6677D-11   3.2205D-12   1.2713D-11  -6.5158D-12   6.5108D-12  
D  DARNHALL  NHY  CHEB_1     2.3610D-11  -6.0139D-12  -4.6312D-12   7.3040D-13   8.9400D-13   2.4189D-13   8.1807D-13  -5.4785D-13   5.0316D-13  
D  DARNHALL  NHY  CHEB_2     4.2480D-12  -1.0191D-12  -8.0776D-13   1.1276D-13   1.2902D-13   4.4012D-14   1.6677D-13  -8.5575D-14   8.5544D-14  
D  DARNHALL  NHY  CHEB_3    -4.2578D-13   1.2850D-13   9.2551D-14  -1.9749D-14  -2.7443D-14  -2.7039D-15  -7.0159D-15   1.5670D-14  -1.2697D-14  
D  DARNHALL  NHY  CHEB_4    -6.2418D-14   1.9835D-14   1.2320D-14  -1.8386D-15  -2.5709D-15   3.6838D-16  -1.1406D-15  -1.8206D-15  -3.4651D-15  
D  DARNHALL  NHY  CHEB_5    -1.0391D-14   2.2133D-16   1.7317D-15   8.8373D-17   1.5468D-15   3.4650D-16  -1.5223D-15   9.4599D-16   3.9900D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DAITO     HYD  DER_NORT   8.8740D-05   5.5593D-05   5.5070D-05  -2.8965D-06  -1.2739D-05   3.5622D-06   2.2667D-06   2.4712D-07   4.9476D-07  
D  DAITO     HYD  DER_EAST   2.9794D-05   1.5241D-06   2.6669D-06   9.7799D-06  -4.4406D-06   1.1889D-06  -3.8159D-06   1.5908D-07  -9.9225D-07  
D  DAITO     HYD  CHEB_0     7.6921D-09   5.0703D-11   2.4375D-11   6.9176D-12  -4.2583D-12  -1.7884D-12  -9.2380D-13  -1.0440D-12   1.0504D-12  
D  DAITO     HYD  CHEB_1    -3.4714D-11   7.1244D-12   5.0898D-12  -6.0139D-13   4.2557D-13  -4.7649D-15   1.8287D-13  -2.8118D-13   1.9943D-13  
D  DAITO     HYD  CHEB_2    -7.6089D-12   1.0412D-12   7.8295D-13  -7.5767D-14   1.3706D-13   2.6012D-14   5.2125D-14  -3.3493D-14   3.0242D-14  
D  DAITO     HYD  CHEB_3    -9.1785D-13  -1.9013D-13  -1.2485D-13   2.1455D-14   3.3608D-15   7.2772D-15   8.0503D-15   9.0870D-15  -3.9196D-15  
D  DAITO     HYD  CHEB_4    -6.9486D-13   2.3075D-15  -4.9707D-15  -1.2865D-15  -8.0941D-16  -1.4763D-15  -8.9603D-16  -1.4456D-16  -1.4403D-15  
D  DAITO     HYD  CHEB_5    -1.1922D-13  -6.4474D-17   3.0888D-15  -1.1231D-15  -3.9069D-15   1.2502D-15   1.7286D-15  -7.8353D-16   9.0435D-16  
#
D  DAITO     NHY  DER_NORT   1.3896D-03   4.1107D-04   5.2296D-04  -4.4371D-05  -1.0254D-03   4.5587D-04  -2.7437D-04   4.5046D-05   9.3549D-05  
D  DAITO     NHY  DER_EAST   3.9542D-05   9.0247D-05  -4.0311D-04   1.1841D-04  -3.3322D-04   2.3246D-04  -6.0996D-05   1.4873D-05   5.1166D-06  
D  DAITO     NHY  CHEB_0     8.2293D-10  -2.5045D-10  -1.5210D-10   3.7106D-11  -7.2553D-12   3.1188D-12  -3.9406D-11   4.1532D-12  -5.4509D-12  
D  DAITO     NHY  CHEB_1     4.3896D-11  -1.1055D-11  -8.0958D-12   1.5232D-12   2.8936D-14  -4.5116D-13  -1.6296D-12  -1.6083D-13  -1.1097D-13  
D  DAITO     NHY  CHEB_2     7.6129D-12  -1.6699D-12  -1.4268D-12   1.9776D-13   4.1047D-14  -1.0399D-13  -2.5513D-13  -7.6540D-14  -3.3689D-14  
D  DAITO     NHY  CHEB_3    -9.1820D-13   3.0135D-13   1.6534D-13  -5.7610D-14   2.5352D-14   1.3722D-14   4.4065D-14  -1.0106D-14   2.8963D-15  
D  DAITO     NHY  CHEB_4    -1.3171D-13   4.4001D-14   1.8105D-14  -2.9087D-15   5.2656D-15  -1.1847D-14   4.5035D-15  -1.5318D-15   1.7671D-15  
D  DAITO     NHY  CHEB_5    -1.1023D-14  -8.3277D-15   7.9878D-15  -3.8189D-15   1.1708D-15   1.1415D-14   1.2586D-16   3.2845D-15   1.3582D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DEADMANL  HYD  DER_NORT   6.2319D-05   2.2257D-05   7.0645D-06  -1.8958D-05  -1.5108D-05   5.9074D-07  -3.1415D-07   1.3329D-06  -1.0309D-06  
D  DEADMANL  HYD  DER_EAST  -1.4613D-05  -3.1798D-05  -1.6955D-05  -2.8311D-06   1.0293D-05  -1.1105D-05   5.8640D-06  -1.9771D-06   2.2715D-06  
D  DEADMANL  HYD  CHEB_0     6.9815D-09   3.0252D-11   2.6932D-12   8.0074D-12   2.0228D-12  -6.6816D-14  -2.8162D-12   4.0355D-12   4.0556D-12  
D  DEADMANL  HYD  CHEB_1    -1.0388D-11   1.1541D-11   5.8361D-12  -1.1453D-12  -1.2504D-12   1.4829D-12   1.1319D-12   6.6889D-13   4.0211D-13  
D  DEADMANL  HYD  CHEB_2    -3.8311D-12   1.8228D-12   9.0842D-13  -1.5210D-13  -1.5116D-13   3.0611D-13   1.8051D-13   1.3755D-13   6.5694D-14  
D  DEADMANL  HYD  CHEB_3    -1.4727D-12  -2.5954D-13  -1.3881D-13   3.6648D-14   3.9060D-14  -1.3401D-14  -2.8349D-14  -3.8502D-15  -9.3069D-15  
D  DEADMANL  HYD  CHEB_4    -6.4340D-13  -1.2906D-14  -1.0509D-14   9.3956D-16   2.6036D-15  -6.0228D-15   7.3353D-16  -1.1554D-15   7.0306D-16  
D  DEADMANL  HYD  CHEB_5    -8.6357D-14   1.5494D-15   2.6784D-15  -3.6062D-15  -4.1113D-15  -1.3474D-15   4.6146D-16   2.4298D-16  -1.0128D-16  
#
D  DEADMANL  NHY  DER_NORT  -3.8271D-04  -1.0417D-03  -9.1986D-04   2.2082D-04   4.6055D-04   4.6883D-05   3.9478D-05  -1.0863D-04   3.0472D-04  
D  DEADMANL  NHY  DER_EAST  -5.0989D-05  -1.6465D-03  -1.2136D-03   4.3372D-04   1.0562D-03   3.3362D-04  -4.1279D-04   2.0323D-04   4.3472D-04  
D  DEADMANL  NHY  CHEB_0     2.5761D-10  -1.1620D-10  -7.2325D-11   1.1254D-11   7.1526D-11  -1.1824D-11  -5.5016D-11  -2.4349D-12  -5.3077D-13  
D  DEADMANL  NHY  CHEB_1     1.4834D-11  -5.9551D-12  -3.4947D-12   1.4809D-13   3.5286D-12  -3.6993D-13  -2.6758D-12   4.6035D-13   3.4969D-14  
D  DEADMANL  NHY  CHEB_2     2.7369D-12  -1.0900D-12  -6.1342D-13   1.6193D-14   6.2957D-13  -5.5957D-14  -4.6919D-13   8.6183D-14   3.4783D-14  
D  DEADMANL  NHY  CHEB_3    -2.4811D-13   1.0725D-13   7.8237D-14  -1.0181D-14  -7.4792D-14   1.0674D-14   5.9486D-14  -2.5303D-15   7.0836D-15  
D  DEADMANL  NHY  CHEB_4    -3.8892D-14   1.8513D-14   9.3680D-15  -1.7391D-15  -9.7907D-15   2.0696D-15   8.1450D-15  -6.2972D-16  -1.8623D-15  
D  DEADMANL  NHY  CHEB_5    -7.4537D-15   3.8334D-15   3.2737D-15  -7.8593D-16  -3.4268D-15   1.0460D-16   1.8563D-15   1.5733D-15  -1.3304D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS11     HYD  DER_NORT   6.0887D-05   1.6834D-05   3.9270D-06  -1.5552D-05  -1.6441D-05  -2.7399D-07  -3.7558D-06   1.2105D-07  -2.9187D-06  
D  DSS11     HYD  DER_EAST   1.2530D-06  -2.7370D-05  -1.5613D-05  -1.0389D-06   1.1700D-05  -1.1483D-05   2.2673D-06   1.9647D-06  -1.3202D-06  
D  DSS11     HYD  CHEB_0     6.8455D-09   2.8083D-11   5.1922D-13   7.9953D-12   1.7884D-12  -2.5152D-13  -2.4998D-12   1.5318D-12   5.2614D-12  
D  DSS11     HYD  CHEB_1    -6.9483D-12   1.1294D-11   5.5756D-12  -1.2958D-12  -1.3867D-12   1.4358D-12   1.1608D-12   4.3106D-13   5.7524D-13  
D  DSS11     HYD  CHEB_2    -3.1714D-12   1.8573D-12   8.9529D-13  -2.0588D-13  -1.8165D-13   3.0305D-13   1.9947D-13   7.6350D-14   9.9818D-14  
D  DSS11     HYD  CHEB_3    -1.5150D-12  -2.4802D-13  -1.3821D-13   3.6501D-14   4.1051D-14  -1.8482D-14  -2.9584D-14  -8.8778D-15  -8.5165D-15  
D  DSS11     HYD  CHEB_4    -6.6922D-13  -3.3447D-14  -8.8035D-15   1.0965D-14   1.6230D-14  -1.1836D-14   1.5160D-15   1.2818D-15  -1.2109D-16  
D  DSS11     HYD  CHEB_5    -7.9871D-14   1.5772D-14   1.8091D-15  -4.4913D-15  -1.1961D-14   5.7628D-15   1.4809D-15   3.9624D-16  -1.5367D-17  
#
D  DSS11     NHY  DER_NORT  -3.9508D-04  -7.7362D-04  -1.0870D-03  -3.6706D-04   7.1664D-04   5.4695D-04  -2.9294D-04  -7.8578D-05  -2.0836D-04  
D  DSS11     NHY  DER_EAST   8.8667D-04  -1.5242D-03  -1.0434D-03   1.8947D-05   1.1957D-03   7.2915D-04  -7.9917D-04   3.3524D-04   8.9953D-05  
D  DSS11     NHY  CHEB_0     2.2942D-10  -8.7096D-11  -4.6354D-11   9.5448D-12   4.8445D-11  -2.0926D-11  -4.0603D-11  -2.7670D-12  -3.9201D-13  
D  DSS11     NHY  CHEB_1     1.3485D-11  -4.9481D-12  -2.5746D-12   1.9905D-13   2.5772D-12  -9.8871D-13  -1.8924D-12  -2.2909D-13   1.2984D-14  
D  DSS11     NHY  CHEB_2     2.5425D-12  -9.4170D-13  -4.6583D-13   2.0483D-14   4.7060D-13  -1.5878D-13  -3.2524D-13  -4.9109D-14   3.0993D-15  
D  DSS11     NHY  CHEB_3    -2.0118D-13   7.0621D-14   5.0163D-14  -9.7487D-15  -4.6819D-14   2.9577D-14   4.3024D-14   5.1025D-15  -1.7977D-15  
D  DSS11     NHY  CHEB_4    -3.5651D-14   1.6906D-14   1.0520D-14  -1.4309D-15  -9.7714D-15   3.6478D-15   6.3774D-15   2.1996D-15  -1.7585D-15  
D  DSS11     NHY  CHEB_5    -7.2052D-15   2.2251D-15   1.1248D-15  -4.8476D-16  -1.5580D-15   1.4081D-15   1.8294D-15  -2.8070D-17   1.9915D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS12     HYD  DER_NORT   5.9754D-05   1.7117D-05   4.3701D-06  -1.5770D-05  -1.6533D-05  -2.6813D-07  -3.6347D-06   3.1812D-07  -2.6012D-06  
D  DSS12     HYD  DER_EAST  -5.8876D-07  -2.7989D-05  -1.5595D-05  -1.2102D-06   1.1597D-05  -1.1459D-05   2.6582D-06   1.8020D-06  -8.7441D-07  
D  DSS12     HYD  CHEB_0     6.8795D-09   2.9059D-11   1.0138D-12   8.0458D-12   1.6456D-12  -1.9272D-13  -2.5049D-12   1.8294D-12   5.3151D-12  
D  DSS12     HYD  CHEB_1    -7.7000D-12   1.1380D-11   5.6322D-12  -1.2962D-12  -1.4091D-12   1.4385D-12   1.1420D-12   4.5296D-13   5.7995D-13  
D  DSS12     HYD  CHEB_2    -3.3398D-12   1.8503D-12   8.9290D-13  -1.9302D-13  -1.7191D-13   3.0249D-13   2.0083D-13   8.4102D-14   9.9404D-14  
D  DSS12     HYD  CHEB_3    -1.4952D-12  -2.5266D-13  -1.3743D-13   3.4617D-14   3.7578D-14  -1.7879D-14  -2.9712D-14  -7.8183D-15  -8.7363D-15  
D  DSS12     HYD  CHEB_4    -6.5460D-13  -2.4509D-14  -7.9259D-15   1.1571D-14   1.3221D-14  -9.5040D-15   5.6574D-16   5.3796D-16   1.2999D-16  
D  DSS12     HYD  CHEB_5    -9.4995D-14   7.8286D-15   2.1521D-16  -5.1446D-15  -8.3518D-15   2.8392D-15   2.5841D-15   7.7237D-16  -1.5125D-16  
#
D  DSS12     NHY  DER_NORT  -3.8119D-04  -8.3176D-04  -1.0889D-03  -3.2509D-04   6.7182D-04   5.3957D-04  -2.6898D-04  -1.3978D-04  -2.1108D-04  
D  DSS12     NHY  DER_EAST   8.6605D-04  -1.6058D-03  -1.0831D-03   4.2961D-05   1.1884D-03   7.3246D-04  -7.6929D-04   2.5443D-04   1.2309D-04  
D  DSS12     NHY  CHEB_0     2.3387D-10  -8.9420D-11  -4.8202D-11   9.2060D-12   5.0044D-11  -2.0464D-11  -4.1725D-11  -2.3240D-12  -4.3578D-13  
D  DSS12     NHY  CHEB_1     1.3714D-11  -5.0497D-12  -2.6237D-12   2.0522D-13   2.6374D-12  -9.7972D-13  -1.9682D-12  -1.8894D-13   4.5510D-14  
D  DSS12     NHY  CHEB_2     2.5685D-12  -9.4457D-13  -4.6399D-13   1.5658D-14   4.6980D-13  -1.5615D-13  -3.3184D-13  -2.7370D-14   5.0420D-15  
D  DSS12     NHY  CHEB_3    -2.0920D-13   7.7620D-14   5.3368D-14  -1.0458D-14  -5.1767D-14   2.8951D-14   4.5505D-14   4.7687D-15  -2.9043D-15  
D  DSS12     NHY  CHEB_4    -3.6064D-14   1.6028D-14   1.0747D-14  -2.1678D-15  -9.7451D-15   4.3647D-15   7.5853D-15   3.1915D-15  -9.5352D-16  
D  DSS12     NHY  CHEB_5    -6.7570D-15   1.7209D-15   5.4259D-16   5.9761D-16  -1.3867D-15   6.4263D-16   6.6616D-16  -2.1179D-15   2.6909D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS112    HYD  DER_NORT   5.9733D-05   1.7089D-05   4.3772D-06  -1.5765D-05  -1.6526D-05  -2.7205D-07  -3.6354D-06   3.1940D-07  -2.6062D-06  
D  DSS112    HYD  DER_EAST  -5.9565D-07  -2.7980D-05  -1.5592D-05  -1.2109D-06   1.1594D-05  -1.1457D-05   2.6539D-06   1.7993D-06  -8.7118D-07  
D  DSS112    HYD  CHEB_0     6.8818D-09   2.9152D-11   1.0416D-12   8.0505D-12   1.6348D-12  -1.8188D-13  -2.5025D-12   1.8491D-12   5.3275D-12  
D  DSS112    HYD  CHEB_1    -7.7512D-12   1.1385D-11   5.6342D-12  -1.2960D-12  -1.4102D-12   1.4391D-12   1.1421D-12   4.5474D-13   5.8056D-13  
D  DSS112    HYD  CHEB_2    -3.3491D-12   1.8510D-12   8.9280D-13  -1.9277D-13  -1.7195D-13   3.0260D-13   2.0090D-13   8.4515D-14   9.9570D-14  
D  DSS112    HYD  CHEB_3    -1.4943D-12  -2.5273D-13  -1.3729D-13   3.4512D-14   3.7473D-14  -1.7973D-14  -2.9802D-14  -7.8037D-15  -8.8276D-15  
D  DSS112    HYD  CHEB_4    -6.5496D-13  -2.4634D-14  -8.1323D-15   1.1675D-14   1.3288D-14  -9.4666D-15   6.2096D-16   5.6293D-16   1.6749D-16  
D  DSS112    HYD  CHEB_5    -9.4892D-14   7.8597D-15   3.6295D-16  -5.2417D-15  -8.4404D-15   2.8027D-15   2.5410D-15   7.5667D-16  -1.8815D-16  
#
D  DSS112    NHY  DER_NORT  -3.7994D-04  -8.3189D-04  -1.0888D-03  -3.2513D-04   6.7196D-04   5.3944D-04  -2.6909D-04  -1.3942D-04  -2.1115D-04  
D  DSS112    NHY  DER_EAST   8.6562D-04  -1.6060D-03  -1.0834D-03   4.3166D-05   1.1888D-03   7.3267D-04  -7.6994D-04   2.5442D-04   1.2342D-04  
D  DSS112    NHY  CHEB_0     2.3412D-10  -8.9484D-11  -4.8232D-11   9.1958D-12   5.0073D-11  -2.0484D-11  -4.1745D-11  -2.2985D-12  -4.3152D-13  
D  DSS112    NHY  CHEB_1     1.3725D-11  -5.0514D-12  -2.6240D-12   2.0403D-13   2.6374D-12  -9.8061D-13  -1.9678D-12  -1.8673D-13   4.5883D-14  
D  DSS112    NHY  CHEB_2     2.5703D-12  -9.4491D-13  -4.6398D-13   1.5369D-14   4.6973D-13  -1.5617D-13  -3.3163D-13  -2.6870D-14   5.1266D-15  
D  DSS112    NHY  CHEB_3    -2.0945D-13   7.7750D-14   5.3410D-14  -1.0390D-14  -5.1810D-14   2.8891D-14   4.5434D-14   4.6183D-15  -2.9347D-15  
D  DSS112    NHY  CHEB_4    -3.6139D-14   1.5947D-14   1.0739D-14  -2.2040D-15  -9.7549D-15   4.4283D-15   7.6255D-15   3.2076D-15  -9.3844D-16  
D  DSS112    NHY  CHEB_5    -6.7274D-15   1.7675D-15   5.3918D-16   6.3917D-16  -1.3861D-15   5.9709D-16   6.1013D-16  -2.1745D-15   2.5396D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS13     HYD  DER_NORT   6.0580D-05   1.8595D-05   4.3382D-06  -1.6070D-05  -1.6837D-05  -5.7481D-08  -3.5935D-06   3.7260D-07  -2.2257D-06  
D  DSS13     HYD  DER_EAST  -8.4620D-07  -2.8269D-05  -1.5745D-05  -1.2025D-06   1.1664D-05  -1.1545D-05   3.0498D-06   1.8602D-06  -7.8187D-07  
D  DSS13     HYD  CHEB_0     6.7950D-09   2.5456D-11   1.2654D-13   7.8247D-12   2.0030D-12  -6.0295D-13  -2.6381D-12   1.1711D-12   4.8827D-12  
D  DSS13     HYD  CHEB_1    -5.8069D-12   1.1178D-11   5.5792D-12  -1.2977D-12  -1.3635D-12   1.4105D-12   1.1284D-12   3.9757D-13   5.4638D-13  
D  DSS13     HYD  CHEB_2    -3.0225D-12   1.8120D-12   8.9045D-13  -1.9848D-13  -1.7039D-13   2.9804D-13   2.0030D-13   7.3167D-14   9.3442D-14  
D  DSS13     HYD  CHEB_3    -1.5128D-12  -2.4318D-13  -1.3753D-13   3.7657D-14   4.3043D-14  -1.5004D-14  -2.8062D-14  -7.5645D-15  -8.4336D-15  
D  DSS13     HYD  CHEB_4    -6.3599D-13  -1.8872D-14  -2.1356D-15   7.8294D-15   5.2231D-15  -8.6089D-15  -6.0247D-16   4.5674D-16   4.9786D-16  
D  DSS13     HYD  CHEB_5    -1.0173D-13   5.4929D-15  -2.7301D-15  -2.4845D-15  -1.8514D-15   1.4399D-15   3.3075D-15   3.1779D-16  -4.4001D-16  
#
D  DSS13     NHY  DER_NORT  -4.1486D-04  -8.5501D-04  -1.0868D-03  -2.9724D-04   6.4298D-04   5.3989D-04  -2.5870D-04  -1.8476D-04  -2.0462D-04  
D  DSS13     NHY  DER_EAST   8.6963D-04  -1.6179D-03  -1.0851D-03   5.1336D-05   1.1643D-03   7.1791D-04  -7.2306D-04   2.2511D-04   1.2618D-04  
D  DSS13     NHY  CHEB_0     2.2495D-10  -8.7645D-11  -4.7751D-11   9.4423D-12   4.9489D-11  -1.9396D-11  -4.1279D-11  -3.2000D-12  -6.9308D-13  
D  DSS13     NHY  CHEB_1     1.3357D-11  -5.0290D-12  -2.6365D-12   2.6395D-13   2.6761D-12  -9.3523D-13  -2.0254D-12  -2.5605D-13   4.5386D-14  
D  DSS13     NHY  CHEB_2     2.5045D-12  -9.3708D-13  -4.6821D-13   2.5881D-14   4.7577D-13  -1.4917D-13  -3.4516D-13  -3.9991D-14   4.2953D-15  
D  DSS13     NHY  CHEB_3    -2.0397D-13   8.0999D-14   5.5398D-14  -1.4249D-14  -5.4271D-14   2.7361D-14   4.8618D-14   1.0350D-14  -3.0778D-15  
D  DSS13     NHY  CHEB_4    -3.2588D-14   1.2969D-14   7.9331D-15  -4.0823D-16  -7.8003D-15   3.5585D-15   4.7838D-15  -2.8069D-15   2.9476D-16  
D  DSS13     NHY  CHEB_5    -6.7573D-15   3.3960D-15   2.3582D-15  -2.1468D-16  -1.6226D-15   4.5585D-16   1.6842D-15   7.7948D-16  -3.2446D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS14     HYD  DER_NORT   6.1527D-05   1.6517D-05   3.8308D-06  -1.5383D-05  -1.6325D-05  -2.9968D-07  -3.9199D-06   5.4258D-08  -3.1793D-06  
D  DSS14     HYD  DER_EAST   2.5630D-06  -2.6399D-05  -1.5627D-05  -8.7083D-07   1.1671D-05  -1.1432D-05   2.0200D-06   2.0860D-06  -1.5226D-06  
D  DSS14     HYD  CHEB_0     6.8487D-09   2.8393D-11   5.3138D-13   8.0111D-12   1.7587D-12  -1.9318D-13  -2.4718D-12   1.5672D-12   5.3041D-12  
D  DSS14     HYD  CHEB_1    -7.0158D-12   1.1298D-11   5.5619D-12  -1.2890D-12  -1.3723D-12   1.4394D-12   1.1784D-12   4.3810D-13   5.7711D-13  
D  DSS14     HYD  CHEB_2    -3.1674D-12   1.8695D-12   8.9564D-13  -2.1160D-13  -1.9012D-13   3.0359D-13   1.9739D-13   7.5711D-14   1.0040D-13  
D  DSS14     HYD  CHEB_3    -1.5193D-12  -2.4999D-13  -1.3896D-13   3.6225D-14   4.3179D-14  -1.9519D-14  -2.9594D-14  -8.8165D-15  -8.7380D-15  
D  DSS14     HYD  CHEB_4    -6.7867D-13  -3.5685D-14  -9.9280D-15   1.2169D-14   1.7867D-14  -1.2163D-14   2.1706D-15   1.4753D-15  -2.6213D-16  
D  DSS14     HYD  CHEB_5    -7.1220D-14   1.8272D-14   3.1556D-15  -5.2799D-15  -1.4637D-14   6.8916D-15   3.8565D-16   3.1167D-16  -1.5769D-18  
#
D  DSS14     NHY  DER_NORT  -3.9074D-04  -7.4129D-04  -1.0781D-03  -3.8373D-04   7.4018D-04   5.4384D-04  -3.1309D-04  -4.0311D-05  -2.0788D-04  
D  DSS14     NHY  DER_EAST   8.8411D-04  -1.4523D-03  -1.0165D-03   1.5741D-05   1.1955D-03   7.2171D-04  -8.2095D-04   3.9431D-04   7.7314D-05  
D  DSS14     NHY  CHEB_0     2.2928D-10  -8.6319D-11  -4.5599D-11   9.5744D-12   4.7726D-11  -2.1357D-11  -4.0072D-11  -2.8585D-12  -3.9807D-13  
D  DSS14     NHY  CHEB_1     1.3503D-11  -4.9280D-12  -2.5589D-12   1.9215D-13   2.5542D-12  -9.9811D-13  -1.8527D-12  -2.3025D-13  -5.0130D-16  
D  DSS14     NHY  CHEB_2     2.5492D-12  -9.4246D-13  -4.6692D-13   1.9591D-14   4.6983D-13  -1.5937D-13  -3.1909D-13  -5.2697D-14   2.5297D-15  
D  DSS14     NHY  CHEB_3    -2.0119D-13   6.9334D-14   4.8427D-14  -9.7207D-15  -4.5475D-14   3.0021D-14   4.1851D-14   3.7899D-15  -1.4706D-15  
D  DSS14     NHY  CHEB_4    -3.5972D-14   1.7097D-14   1.0801D-14  -1.4566D-15  -9.8233D-15   3.5630D-15   6.1307D-15   2.5389D-15  -2.1760D-15  
D  DSS14     NHY  CHEB_5    -7.2628D-15   2.2051D-15   9.3582D-16  -5.2769D-16  -1.4441D-15   1.5329D-15   1.8027D-15  -2.0227D-17   2.6240D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS15     HYD  DER_NORT   6.1292D-05   1.6251D-05   3.9151D-06  -1.5350D-05  -1.6274D-05  -3.3686D-07  -3.9159D-06   4.5575D-08  -3.2068D-06  
D  DSS15     HYD  DER_EAST   2.4627D-06  -2.6351D-05  -1.5603D-05  -8.8086D-07   1.1632D-05  -1.1404D-05   2.0058D-06   2.0588D-06  -1.4642D-06  
D  DSS15     HYD  CHEB_0     6.8707D-09   2.9278D-11   7.7874D-13   8.0676D-12   1.6658D-12  -1.0276D-13  -2.4474D-12   1.7566D-12   5.3904D-12  
D  DSS15     HYD  CHEB_1    -7.5098D-12   1.1353D-11   5.5813D-12  -1.2883D-12  -1.3836D-12   1.4452D-12   1.1787D-12   4.5505D-13   5.8321D-13  
D  DSS15     HYD  CHEB_2    -3.2584D-12   1.8754D-12   8.9468D-13  -2.0828D-13  -1.8933D-13   3.0433D-13   1.9803D-13   7.9303D-14   1.0159D-13  
D  DSS15     HYD  CHEB_3    -1.5112D-12  -2.5158D-13  -1.3774D-13   3.4841D-14   4.1587D-14  -2.0177D-14  -3.0336D-14  -8.5821D-15  -9.1362D-15  
D  DSS15     HYD  CHEB_4    -6.8139D-13  -3.6234D-14  -1.1790D-14   1.3525D-14   1.8932D-14  -1.1896D-14   2.5675D-15   1.3407D-15  -1.4163D-16  
D  DSS15     HYD  CHEB_5    -7.0781D-14   1.8074D-14   4.2168D-15  -6.3170D-15  -1.5572D-14   6.6426D-15   1.5112D-16   4.1278D-16  -1.0035D-16  
#
D  DSS15     NHY  DER_NORT  -3.7969D-04  -7.4610D-04  -1.0771D-03  -3.8172D-04   7.3874D-04   5.4160D-04  -3.1199D-04  -4.0644D-05  -2.0936D-04  
D  DSS15     NHY  DER_EAST   8.8031D-04  -1.4589D-03  -1.0213D-03   1.8436D-05   1.1986D-03   7.2400D-04  -8.2496D-04   3.9024D-04   8.2885D-05  
D  DSS15     NHY  CHEB_0     2.3171D-10  -8.6991D-11  -4.5940D-11   9.4753D-12   4.8047D-11  -2.1509D-11  -4.0302D-11  -2.6154D-12  -3.7272D-13  
D  DSS15     NHY  CHEB_1     1.3610D-11  -4.9488D-12  -2.5646D-12   1.8138D-13   2.5554D-12  -1.0048D-12  -1.8511D-12  -2.1072D-13   2.7517D-15  
D  DSS15     NHY  CHEB_2     2.5662D-12  -9.4496D-13  -4.6621D-13   1.6464D-14   4.6884D-13  -1.5967D-13  -3.1710D-13  -4.6311D-14   2.9979D-15  
D  DSS15     NHY  CHEB_3    -2.0345D-13   6.9820D-14   4.8587D-14  -8.6775D-15  -4.5879D-14   2.9695D-14   4.1214D-14   1.9749D-15  -1.6975D-15  
D  DSS15     NHY  CHEB_4    -3.6920D-14   1.7341D-14   1.1251D-14  -2.1867D-15  -1.0100D-14   4.1331D-15   6.8160D-15   3.8920D-15  -2.1715D-15  
D  DSS15     NHY  CHEB_5    -7.0925D-15   1.9133D-15   4.8644D-16  -2.5008D-17  -1.4061D-15   1.2079D-15   1.3314D-15  -1.2845D-15   3.2324D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS16     HYD  DER_NORT   6.0066D-05   1.6347D-05   4.3348D-06  -1.5637D-05  -1.6381D-05  -3.5838D-07  -3.8904D-06   1.9004D-07  -2.9698D-06  
D  DSS16     HYD  DER_EAST   1.6249D-06  -2.6200D-05  -1.5668D-05  -9.1718D-07   1.1548D-05  -1.1317D-05   2.4160D-06   2.0345D-06  -1.0601D-06  
D  DSS16     HYD  CHEB_0     6.8938D-09   2.9856D-11   1.1633D-12   8.0988D-12   1.5543D-12  -6.9859D-14  -2.4550D-12   1.9591D-12   5.3954D-12  
D  DSS16     HYD  CHEB_1    -8.0185D-12   1.1406D-11   5.6204D-12  -1.2821D-12  -1.3913D-12   1.4438D-12   1.1677D-12   4.7011D-13   5.8440D-13  
D  DSS16     HYD  CHEB_2    -3.3758D-12   1.8676D-12   8.9380D-13  -1.9980D-13  -1.8320D-13   3.0384D-13   1.9894D-13   8.5073D-14   1.0090D-13  
D  DSS16     HYD  CHEB_3    -1.4944D-12  -2.5315D-13  -1.3739D-13   3.3470D-14   3.9325D-14  -2.0226D-14  -3.0217D-14  -7.8362D-15  -9.3423D-15  
D  DSS16     HYD  CHEB_4    -6.6997D-13  -3.0537D-14  -1.0513D-14   1.4114D-14   1.6670D-14  -9.7706D-15   1.8296D-15   9.5219D-16   3.2779D-16  
D  DSS16     HYD  CHEB_5    -8.5266D-14   1.2612D-14   2.8977D-15  -6.8028D-15  -1.2785D-14   4.2026D-15   1.0118D-15   4.6024D-16  -4.7451D-16  
#
D  DSS16     NHY  DER_NORT  -3.7691D-04  -7.9697D-04  -1.0788D-03  -3.5418D-04   6.9950D-04   5.3774D-04  -2.9332D-04  -9.0790D-05  -2.2028D-04  
D  DSS16     NHY  DER_EAST   8.8725D-04  -1.5051D-03  -1.0474D-03   3.4144D-05   1.1863D-03   7.3732D-04  -7.9647D-04   3.3448D-04   1.0455D-04  
D  DSS16     NHY  CHEB_0     2.3469D-10  -8.8436D-11  -4.7160D-11   9.1404D-12   4.9023D-11  -2.1196D-11  -4.0967D-11  -2.2973D-12  -4.6980D-13  
D  DSS16     NHY  CHEB_1     1.3772D-11  -5.0132D-12  -2.5962D-12   1.9146D-13   2.5907D-12  -1.0062D-12  -1.8997D-12  -1.8078D-13   2.8089D-14  
D  DSS16     NHY  CHEB_2     2.5812D-12  -9.4254D-13  -4.6356D-13   1.3100D-14   4.6412D-13  -1.5907D-13  -3.1853D-13  -3.1342D-14   5.5758D-15  
D  DSS16     NHY  CHEB_3    -2.0932D-13   7.6021D-14   5.1823D-14  -9.7445D-15  -4.9990D-14   2.9145D-14   4.3498D-14   3.1967D-15  -2.4537D-15  
D  DSS16     NHY  CHEB_4    -3.6698D-14   1.5758D-14   1.0751D-14  -2.3843D-15  -9.8740D-15   4.8466D-15   7.4514D-15   3.4567D-15  -1.1873D-15  
D  DSS16     NHY  CHEB_5    -6.6217D-15   2.0656D-15   4.4046D-16   5.8910D-16  -1.2489D-15   5.7203D-16   4.7993D-16  -2.1427D-15  -2.4163D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS17     HYD  DER_NORT   6.0026D-05   1.6274D-05   4.3501D-06  -1.5623D-05  -1.6365D-05  -3.6869D-07  -3.8913D-06   1.8865D-07  -2.9832D-06  
D  DSS17     HYD  DER_EAST   1.6133D-06  -2.6182D-05  -1.5661D-05  -9.1859D-07   1.1539D-05  -1.1310D-05   2.4023D-06   2.0274D-06  -1.0527D-06  
D  DSS17     HYD  CHEB_0     6.8994D-09   3.0084D-11   1.2247D-12   8.1120D-12   1.5280D-12  -4.6614D-14  -2.4467D-12   2.0163D-12   5.4190D-12  
D  DSS17     HYD  CHEB_1    -8.1439D-12   1.1420D-11   5.6249D-12  -1.2817D-12  -1.3938D-12   1.4453D-12   1.1681D-12   4.7495D-13   5.8588D-13  
D  DSS17     HYD  CHEB_2    -3.3976D-12   1.8693D-12   8.9359D-13  -1.9931D-13  -1.8346D-13   3.0417D-13   1.9904D-13   8.6132D-14   1.0118D-13  
D  DSS17     HYD  CHEB_3    -1.4928D-12  -2.5326D-13  -1.3709D-13   3.3314D-14   3.9172D-14  -2.0470D-14  -3.0387D-14  -7.7944D-15  -9.4707D-15  
D  DSS17     HYD  CHEB_4    -6.7059D-13  -3.0950D-14  -1.0971D-14   1.4266D-14   1.6744D-14  -9.6659D-15   1.9215D-15   9.6919D-16   3.6815D-16  
D  DSS17     HYD  CHEB_5    -8.5251D-14   1.2785D-14   3.2778D-15  -6.9966D-15  -1.2987D-14   4.1093D-15   9.3483D-16   4.4530D-16  -5.0841D-16  
#
D  DSS17     NHY  DER_NORT  -3.7386D-04  -7.9696D-04  -1.0785D-03  -3.5440D-04   7.0003D-04   5.3732D-04  -2.9359D-04  -8.9573D-05  -2.2028D-04  
D  DSS17     NHY  DER_EAST   8.8584D-04  -1.5054D-03  -1.0480D-03   3.4554D-05   1.1874D-03   7.3765D-04  -7.9827D-04   3.3472D-04   1.0551D-04  
D  DSS17     NHY  CHEB_0     2.3530D-10  -8.8587D-11  -4.7225D-11   9.1187D-12   4.9089D-11  -2.1246D-11  -4.1015D-11  -2.2338D-12  -4.5945D-13  
D  DSS17     NHY  CHEB_1     1.3798D-11  -5.0168D-12  -2.5965D-12   1.8804D-13   2.5902D-12  -1.0082D-12  -1.8981D-12  -1.7492D-13   2.8488D-14  
D  DSS17     NHY  CHEB_2     2.5857D-12  -9.4368D-13  -4.6380D-13   1.2573D-14   4.6405D-13  -1.5916D-13  -3.1818D-13  -3.0761D-14   5.8918D-15  
D  DSS17     NHY  CHEB_3    -2.0997D-13   7.6471D-14   5.2087D-14  -9.7274D-15  -5.0106D-14   2.9037D-14   4.3438D-14   3.2388D-15  -2.6611D-15  
D  DSS17     NHY  CHEB_4    -3.6794D-14   1.5400D-14   1.0532D-14  -2.3243D-15  -9.8269D-15   4.9484D-15   7.4357D-15   3.1072D-15  -1.0241D-15  
D  DSS17     NHY  CHEB_5    -6.5613D-15   2.3388D-15   5.8524D-16   5.7893D-16  -1.2645D-15   4.7827D-16   4.3126D-16  -1.9610D-15  -1.8167D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS23     HYD  DER_NORT   6.0057D-05   1.6376D-05   4.3389D-06  -1.5646D-05  -1.6387D-05  -3.5496D-07  -3.8875D-06   1.9507D-07  -2.9591D-06  
D  DSS23     HYD  DER_EAST   1.5937D-06  -2.6216D-05  -1.5671D-05  -9.1964D-07   1.1549D-05  -1.1318D-05   2.4291D-06   2.0338D-06  -1.0533D-06  
D  DSS23     HYD  CHEB_0     6.8927D-09   2.9799D-11   1.1552D-12   8.0947D-12   1.5567D-12  -7.8083D-14  -2.4579D-12   1.9512D-12   5.3875D-12  
D  DSS23     HYD  CHEB_1    -7.9939D-12   1.1403D-11   5.6202D-12  -1.2822D-12  -1.3909D-12   1.4434D-12   1.1672D-12   4.6911D-13   5.8406D-13  
D  DSS23     HYD  CHEB_2    -3.3721D-12   1.8669D-12   8.9383D-13  -1.9972D-13  -1.8294D-13   3.0374D-13   1.9894D-13   8.4912D-14   1.0077D-13  
D  DSS23     HYD  CHEB_3    -1.4947D-12  -2.5314D-13  -1.3746D-13   3.3502D-14   3.9312D-14  -2.0148D-14  -3.0166D-14  -7.8195D-15  -9.2822D-15  
D  DSS23     HYD  CHEB_4    -6.6938D-13  -3.0251D-14  -1.0333D-14   1.4057D-14   1.6567D-14  -9.7479D-15   1.7747D-15   9.2948D-16   2.9865D-16  
D  DSS23     HYD  CHEB_5    -8.5717D-14   1.2412D-14   2.7431D-15  -6.7472D-15  -1.2633D-14   4.1592D-15   1.0654D-15   4.7735D-16  -4.5082D-16  
#
D  DSS23     NHY  DER_NORT  -3.7740D-04  -7.9821D-04  -1.0789D-03  -3.5335D-04   6.9841D-04   5.3785D-04  -2.9277D-04  -9.2429D-05  -2.2032D-04  
D  DSS23     NHY  DER_EAST   8.8749D-04  -1.5066D-03  -1.0480D-03   3.4432D-05   1.1859D-03   7.3740D-04  -7.9528D-04   3.3274D-04   1.0484D-04  
D  DSS23     NHY  CHEB_0     2.3459D-10  -8.8434D-11  -4.7175D-11   9.1401D-12   4.9033D-11  -2.1171D-11  -4.0974D-11  -2.3076D-12  -4.7385D-13  
D  DSS23     NHY  CHEB_1     1.3768D-11  -5.0139D-12  -2.5970D-12   1.9260D-13   2.5920D-12  -1.0054D-12  -1.9016D-12  -1.8162D-13   2.8699D-14  
D  DSS23     NHY  CHEB_2     2.5803D-12  -9.4225D-13  -4.6349D-13   1.3182D-14   4.6411D-13  -1.5899D-13  -3.1879D-13  -3.1184D-14   5.5632D-15  
D  DSS23     NHY  CHEB_3    -2.0927D-13   7.6061D-14   5.1851D-14  -9.7836D-15  -5.0051D-14   2.9157D-14   4.3584D-14   3.2531D-15  -2.4241D-15  
D  DSS23     NHY  CHEB_4    -3.6653D-14   1.5795D-14   1.0769D-14  -2.3912D-15  -9.8755D-15   4.8244D-15   7.4498D-15   3.4912D-15  -1.2015D-15  
D  DSS23     NHY  CHEB_5    -6.6237D-15   2.0125D-15   4.2278D-16   5.9878D-16  -1.2428D-15   5.8284D-16   4.8698D-16  -2.1759D-15   3.2715D-18  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS24     HYD  DER_NORT   6.0104D-05   1.6426D-05   4.3246D-06  -1.5655D-05  -1.6398D-05  -3.4749D-07  -3.8939D-06   1.9339D-07  -2.9564D-06  
D  DSS24     HYD  DER_EAST   1.6602D-06  -2.6184D-05  -1.5679D-05  -9.1085D-07   1.1555D-05  -1.1320D-05   2.4350D-06   2.0457D-06  -1.0643D-06  
D  DSS24     HYD  CHEB_0     6.8880D-09   2.9605D-11   1.1018D-12   8.0813D-12   1.5786D-12  -9.7362D-14  -2.4613D-12   1.9054D-12   5.3685D-12  
D  DSS24     HYD  CHEB_1    -7.8862D-12   1.1391D-11   5.6158D-12  -1.2822D-12  -1.3880D-12   1.4421D-12   1.1675D-12   4.6524D-13   5.8273D-13  
D  DSS24     HYD  CHEB_2    -3.3528D-12   1.8659D-12   8.9408D-13  -2.0039D-13  -1.8307D-13   3.0349D-13   1.9874D-13   8.3995D-14   1.0052D-13  
D  DSS24     HYD  CHEB_3    -1.4962D-12  -2.5309D-13  -1.3779D-13   3.3656D-14   3.9558D-14  -1.9991D-14  -2.9991D-14  -7.8569D-15  -9.1743D-15  
D  DSS24     HYD  CHEB_4    -6.6910D-13  -2.9969D-14  -9.9150D-15   1.3938D-14   1.6519D-14  -9.8304D-15   1.6999D-15   9.2159D-16   2.7730D-16  
D  DSS24     HYD  CHEB_5    -8.5559D-14   1.2356D-14   2.4447D-15  -6.5889D-15  -1.2531D-14   4.2676D-15   1.1043D-15   4.8125D-16  -4.3438D-16  
#
D  DSS24     NHY  DER_NORT  -3.8017D-04  -7.9727D-04  -1.0788D-03  -3.5377D-04   6.9858D-04   5.3809D-04  -2.9319D-04  -9.2254D-05  -2.2051D-04  
D  DSS24     NHY  DER_EAST   8.8904D-04  -1.5036D-03  -1.0464D-03   3.3961D-05   1.1847D-03   7.3703D-04  -7.9429D-04   3.3460D-04   1.0356D-04  
D  DSS24     NHY  CHEB_0     2.3405D-10  -8.8270D-11  -4.7089D-11   9.1578D-12   4.8947D-11  -2.1143D-11  -4.0911D-11  -2.3661D-12  -4.8511D-13  
D  DSS24     NHY  CHEB_1     1.3745D-11  -5.0100D-12  -2.5961D-12   1.9543D-13   2.5915D-12  -1.0041D-12  -1.9014D-12  -1.8666D-13   2.7793D-14  
D  DSS24     NHY  CHEB_2     2.5766D-12  -9.4124D-13  -4.6337D-13   1.3679D-14   4.6409D-13  -1.5898D-13  -3.1888D-13  -3.1961D-14   5.3015D-15  
D  DSS24     NHY  CHEB_3    -2.0875D-13   7.5690D-14   5.1631D-14  -9.8702D-15  -4.9938D-14   2.9290D-14   4.3681D-14   3.3167D-15  -2.2497D-15  
D  DSS24     NHY  CHEB_4    -3.6543D-14   1.6086D-14   1.0901D-14  -2.3909D-15  -9.8917D-15   4.7056D-15   7.3953D-15   3.7019D-15  -1.3250D-15  
D  DSS24     NHY  CHEB_5    -6.6861D-15   1.8064D-15   3.3641D-16   5.7521D-16  -1.2304D-15   6.7951D-16   5.6130D-16  -2.2458D-15   1.1707D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS25     HYD  DER_NORT   6.0144D-05   1.6523D-05   4.3132D-06  -1.5678D-05  -1.6420D-05  -3.3415D-07  -3.8948D-06   1.9815D-07  -2.9369D-06  
D  DSS25     HYD  DER_EAST   1.6774D-06  -2.6187D-05  -1.5690D-05  -9.0655D-07   1.1564D-05  -1.1326D-05   2.4595D-06   2.0557D-06  -1.0672D-06  
D  DSS25     HYD  CHEB_0     6.8811D-09   2.9317D-11   1.0262D-12   8.0652D-12   1.6062D-12  -1.2863D-13  -2.4728D-12   1.8419D-12   5.3380D-12  
D  DSS25     HYD  CHEB_1    -7.7319D-12   1.1374D-11   5.6104D-12  -1.2823D-12  -1.3844D-12   1.4401D-12   1.1671D-12   4.5959D-13   5.8072D-13  
D  DSS25     HYD  CHEB_2    -3.3259D-12   1.8637D-12   8.9440D-13  -2.0102D-13  -1.8285D-13   3.0307D-13   1.9853D-13   8.2817D-14   1.0005D-13  
D  DSS25     HYD  CHEB_3    -1.4984D-12  -2.5294D-13  -1.3827D-13   3.3922D-14   3.9849D-14  -1.9695D-14  -2.9706D-14  -7.9058D-15  -8.9767D-15  
D  DSS25     HYD  CHEB_4    -6.6783D-13  -2.9306D-14  -9.1855D-15   1.3663D-14   1.6259D-14  -9.9006D-15   1.5207D-15   9.0317D-16   2.1728D-16  
D  DSS25     HYD  CHEB_5    -8.6085D-14   1.2049D-14   1.9027D-15  -6.3121D-15  -1.2172D-14   4.3244D-15   1.2440D-15   4.9795D-16  -3.8784D-16  
#
D  DSS25     NHY  DER_NORT  -3.8389D-04  -7.9799D-04  -1.0790D-03  -3.5303D-04   6.9726D-04   5.3854D-04  -2.9277D-04  -9.4482D-05  -2.2066D-04  
D  DSS25     NHY  DER_EAST   8.9097D-04  -1.5030D-03  -1.0456D-03   3.3781D-05   1.1829D-03   7.3671D-04  -7.9148D-04   3.3386D-04   1.0261D-04  
D  DSS25     NHY  CHEB_0     2.3331D-10  -8.8091D-11  -4.7019D-11   9.1789D-12   4.8871D-11  -2.1075D-11  -4.0854D-11  -2.4439D-12  -5.0207D-13  
D  DSS25     NHY  CHEB_1     1.3715D-11  -5.0065D-12  -2.5961D-12   1.9995D-13   2.5927D-12  -1.0015D-12  -1.9039D-12  -1.9319D-13   2.7655D-14  
D  DSS25     NHY  CHEB_2     2.5711D-12  -9.3987D-13  -4.6326D-13   1.4468D-14   4.6413D-13  -1.5888D-13  -3.1950D-13  -3.2942D-14   5.0218D-15  
D  DSS25     NHY  CHEB_3    -2.0810D-13   7.5395D-14   5.1505D-14  -1.0119D-14  -4.9923D-14   2.9481D-14   4.3981D-14   3.7015D-15  -2.0392D-15  
D  DSS25     NHY  CHEB_4    -3.6329D-14   1.6374D-14   1.0988D-14  -2.3072D-15  -9.8752D-15   4.5155D-15   7.2729D-15   3.7596D-15  -1.4601D-15  
D  DSS25     NHY  CHEB_5    -6.7538D-15   1.5802D-15   2.7687D-16   4.9684D-16  -1.2177D-15   8.1746D-16   6.9828D-16  -2.1949D-15   2.5110D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS26     HYD  DER_NORT   6.0182D-05   1.6636D-05   4.2949D-06  -1.5699D-05  -1.6444D-05  -3.1863D-07  -3.8832D-06   2.0283D-07  -2.9073D-06  
D  DSS26     HYD  DER_EAST   1.6152D-06  -2.6275D-05  -1.5698D-05  -9.1520D-07   1.1577D-05  -1.1339D-05   2.4847D-06   2.0552D-06  -1.0701D-06  
D  DSS26     HYD  CHEB_0     6.8738D-09   2.9012D-11   9.4806D-13   8.0441D-12   1.6386D-12  -1.6281D-13  -2.4851D-12   1.7763D-12   5.3065D-12  
D  DSS26     HYD  CHEB_1    -7.5686D-12   1.1356D-11   5.6053D-12  -1.2832D-12  -1.3819D-12   1.4380D-12   1.1657D-12   4.5347D-13   5.7871D-13  
D  DSS26     HYD  CHEB_2    -3.2974D-12   1.8610D-12   8.9469D-13  -2.0150D-13  -1.8230D-13   3.0269D-13   1.9841D-13   8.1603D-14   9.9610D-14  
D  DSS26     HYD  CHEB_3    -1.5006D-12  -2.5256D-13  -1.3866D-13   3.4261D-14   4.0093D-14  -1.9354D-14  -2.9405D-14  -7.9666D-15  -8.7776D-15  
D  DSS26     HYD  CHEB_4    -6.6634D-13  -2.8744D-14  -8.4632D-15   1.3264D-14   1.5897D-14  -9.9904D-15   1.3013D-15   8.6882D-16   1.7303D-16  
D  DSS26     HYD  CHEB_5    -8.6733D-14   1.1787D-14   1.3646D-15  -5.9776D-15  -1.1703D-14   4.3586D-15   1.4488D-15   5.2006D-16  -3.2738D-16  
#
D  DSS26     NHY  DER_NORT  -3.8764D-04  -7.9919D-04  -1.0798D-03  -3.5192D-04   6.9568D-04   5.3923D-04  -2.9153D-04  -9.7690D-05  -2.2031D-04  
D  DSS26     NHY  DER_EAST   8.9223D-04  -1.5063D-03  -1.0462D-03   3.3405D-05   1.1819D-03   7.3633D-04  -7.8834D-04   3.3072D-04   1.0202D-04  
D  DSS26     NHY  CHEB_0     2.3254D-10  -8.7940D-11  -4.6972D-11   9.2084D-12   4.8826D-11  -2.0990D-11  -4.0822D-11  -2.5193D-12  -5.1232D-13  
D  DSS26     NHY  CHEB_1     1.3680D-11  -5.0024D-12  -2.5961D-12   2.0406D-13   2.5944D-12  -9.9818D-13  -1.9077D-12  -1.9992D-13   2.7656D-14  
D  DSS26     NHY  CHEB_2     2.5652D-12  -9.3892D-13  -4.6330D-13   1.5501D-14   4.6453D-13  -1.5879D-13  -3.2066D-13  -3.4360D-14   4.8296D-15  
D  DSS26     NHY  CHEB_3    -2.0740D-13   7.5185D-14   5.1490D-14  -1.0414D-14  -4.9931D-14   2.9663D-14   4.4330D-14   4.2858D-15  -1.9355D-15  
D  DSS26     NHY  CHEB_4    -3.6019D-14   1.6503D-14   1.0974D-14  -2.1261D-15  -9.7910D-15   4.2824D-15   7.0901D-15   3.6005D-15  -1.4999D-15  
D  DSS26     NHY  CHEB_5    -6.8757D-15   1.5193D-15   3.1023D-16   3.4547D-16  -1.2576D-15   9.7838D-16   8.9581D-16  -1.9665D-15   3.1550D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS27     HYD  DER_NORT   6.0455D-05   1.8613D-05   4.3876D-06  -1.6043D-05  -1.6819D-05  -6.2187D-08  -3.5450D-06   4.2082D-07  -2.1858D-06  
D  DSS27     HYD  DER_EAST  -1.4621D-06  -2.8654D-05  -1.5693D-05  -1.2861D-06   1.1636D-05  -1.1563D-05   3.0460D-06   1.7895D-06  -7.2706D-07  
D  DSS27     HYD  CHEB_0     6.8090D-09   2.5965D-11   2.8286D-13   7.8500D-12   1.9536D-12  -5.5361D-13  -2.6273D-12   1.2782D-12   4.9397D-12  
D  DSS27     HYD  CHEB_1    -6.1190D-12   1.1212D-11   5.5939D-12  -1.2994D-12  -1.3746D-12   1.4145D-12   1.1252D-12   4.0530D-13   5.5124D-13  
D  DSS27     HYD  CHEB_2    -3.0794D-12   1.8167D-12   8.9158D-13  -1.9616D-13  -1.6856D-13   2.9847D-13   1.9995D-13   7.5919D-14   9.3564D-14  
D  DSS27     HYD  CHEB_3    -1.5110D-12  -2.4722D-13  -1.3912D-13   3.8126D-14   4.2401D-14  -1.4696D-14  -2.7808D-14  -7.5519D-15  -8.1522D-15  
D  DSS27     HYD  CHEB_4    -6.3332D-13  -1.6133D-14  -1.2918D-15   7.1627D-15   4.9645D-15  -8.5079D-15  -1.1479D-15   2.8552D-16   2.9034D-16  
D  DSS27     HYD  CHEB_5    -1.0413D-13   3.3273D-15  -3.6597D-15  -2.0822D-15  -1.4077D-15   1.2985D-15   3.7303D-15   3.7849D-16  -1.9514D-16  
#
D  DSS27     NHY  DER_NORT  -4.0541D-04  -8.6278D-04  -1.0876D-03  -2.8884D-04   6.3873D-04   5.3754D-04  -2.5456D-04  -1.9094D-04  -2.0156D-04  
D  DSS27     NHY  DER_EAST   8.5574D-04  -1.6413D-03  -1.0942D-03   5.6855D-05   1.1676D-03   7.1443D-04  -7.2329D-04   2.0835D-04   1.3451D-04  
D  DSS27     NHY  CHEB_0     2.2665D-10  -8.8395D-11  -4.8249D-11   9.3989D-12   4.9965D-11  -1.9358D-11  -4.1628D-11  -3.0515D-12  -6.5855D-13  
D  DSS27     NHY  CHEB_1     1.3435D-11  -5.0572D-12  -2.6480D-12   2.5819D-13   2.6899D-12  -9.3199D-13  -2.0396D-12  -2.4134D-13   5.0616D-14  
D  DSS27     NHY  CHEB_2     2.5167D-12  -9.4050D-13  -4.6900D-13   2.4352D-14   4.7708D-13  -1.4875D-13  -3.4756D-13  -3.6354D-14   4.3455D-15  
D  DSS27     NHY  CHEB_3    -2.0614D-13   8.1666D-14   5.6036D-14  -1.4353D-14  -5.5026D-14   2.7813D-14   4.9401D-14   1.0925D-14  -3.3816D-15  
D  DSS27     NHY  CHEB_4    -3.2771D-14   1.3611D-14   7.9889D-15  -5.5216D-16  -7.8204D-15   3.4327D-15   5.1546D-15  -2.6787D-15   2.8644D-16  
D  DSS27     NHY  CHEB_5    -6.8430D-15   2.9457D-15   2.3697D-15  -1.3137D-16  -1.6657D-15   5.8913D-16   1.7643D-15   9.4104D-16  -2.2491D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS28     HYD  DER_NORT   6.0552D-05   1.8707D-05   4.3653D-06  -1.6067D-05  -1.6845D-05  -4.7219D-08  -3.5485D-06   4.0714D-07  -2.1691D-06  
D  DSS28     HYD  DER_EAST  -1.3582D-06  -2.8624D-05  -1.5711D-05  -1.2725D-06   1.1649D-05  -1.1569D-05   3.0655D-06   1.8053D-06  -7.3814D-07  
D  DSS28     HYD  CHEB_0     6.7995D-09   2.5592D-11   1.7871D-13   7.8295D-12   1.9928D-12  -5.9576D-13  -2.6425D-12   1.2088D-12   4.8982D-12  
D  DSS28     HYD  CHEB_1    -5.9076D-12   1.1190D-11   5.5869D-12  -1.2998D-12  -1.3695D-12   1.4116D-12   1.1246D-12   3.9988D-13   5.4751D-13  
D  DSS28     HYD  CHEB_2    -3.0434D-12   1.8123D-12   8.9061D-13  -1.9680D-13  -1.6879D-13   2.9814D-13   2.0024D-13   7.4367D-14   9.3296D-14  
D  DSS28     HYD  CHEB_3    -1.5122D-12  -2.4499D-13  -1.3816D-13   3.7977D-14   4.2831D-14  -1.4641D-14  -2.7921D-14  -7.4950D-15  -8.3313D-15  
D  DSS28     HYD  CHEB_4    -6.3315D-13  -1.6938D-14  -1.6069D-15   7.2572D-15   4.5014D-15  -8.4744D-15  -9.4215D-16   3.5650D-16   4.1528D-16  
D  DSS28     HYD  CHEB_5    -1.0337D-13   4.0839D-15  -3.2218D-15  -2.1817D-15  -1.1939D-15   1.2162D-15   3.5752D-15   3.3944D-16  -3.2520D-16  
#
D  DSS28     NHY  DER_NORT  -4.1040D-04  -8.6181D-04  -1.0876D-03  -2.8916D-04   6.3824D-04   5.3803D-04  -2.5469D-04  -1.9206D-04  -2.0142D-04  
D  DSS28     NHY  DER_EAST   8.5850D-04  -1.6377D-03  -1.0922D-03   5.5840D-05   1.1656D-03   7.1383D-04  -7.2046D-04   2.1002D-04   1.3287D-04  
D  DSS28     NHY  CHEB_0     2.2560D-10  -8.8090D-11  -4.8091D-11   9.4347D-12   4.9815D-11  -1.9294D-11  -4.1516D-11  -3.1438D-12  -6.7995D-13  
D  DSS28     NHY  CHEB_1     1.3388D-11  -5.0480D-12  -2.6458D-12   2.6323D-13   2.6890D-12  -9.2958D-13  -2.0400D-12  -2.5021D-13   4.8856D-14  
D  DSS28     NHY  CHEB_2     2.5092D-12  -9.3954D-13  -4.6903D-13   2.5537D-14   4.7745D-13  -1.4825D-13  -3.4801D-13  -3.8073D-14   4.1287D-15  
D  DSS28     NHY  CHEB_3    -2.0510D-13   8.1738D-14   5.5882D-14  -1.4487D-14  -5.4893D-14   2.7443D-14   4.9229D-14   1.0778D-14  -3.3116D-15  
D  DSS28     NHY  CHEB_4    -3.2629D-14   1.3156D-14   7.8810D-15  -4.2761D-16  -7.7641D-15   3.4823D-15   4.8580D-15  -2.9643D-15   3.4279D-16  
D  DSS28     NHY  CHEB_5    -6.7761D-15   3.2552D-15   2.4011D-15  -1.8025D-16  -1.6363D-15   4.8477D-16   1.7495D-15   9.0311D-16  -2.7541D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS33     HYD  DER_NORT  -1.1499D-04   5.7509D-06   1.7111D-05   7.4397D-06   7.3024D-06  -2.9418D-06   3.8199D-06   2.9909D-06   2.2670D-06  
D  DSS33     HYD  DER_EAST  -6.5160D-06   5.4627D-06   7.9338D-06  -1.0288D-07  -6.3221D-06   9.6738D-06   1.2505D-05  -3.6496D-07  -1.6062D-06  
D  DSS33     HYD  CHEB_0     7.1739D-09  -2.5476D-11  -9.3004D-12  -1.0767D-11   2.1991D-12   8.5162D-12  -5.2111D-12  -9.0181D-13   6.9432D-12  
D  DSS33     HYD  CHEB_1    -7.0583D-12  -9.1760D-12  -3.4989D-12   1.9107D-12  -9.7566D-13  -5.1842D-13  -6.2198D-13  -1.6782D-13   7.6285D-13  
D  DSS33     HYD  CHEB_2    -3.2423D-12  -1.5147D-12  -6.0917D-13   3.1984D-13  -1.1253D-13  -1.2902D-13  -9.8749D-14  -2.6140D-14   1.3641D-13  
D  DSS33     HYD  CHEB_3    -1.5677D-12   2.0120D-13   7.8559D-14  -3.6845D-14   4.0133D-14  -2.7994D-15   2.1404D-14   6.1893D-15  -8.3093D-15  
D  DSS33     HYD  CHEB_4    -6.4910D-13   9.1018D-15   8.4823D-15   1.5071D-15  -2.2267D-15   3.3844D-15   1.3200D-15  -1.6614D-15   7.3988D-16  
D  DSS33     HYD  CHEB_5    -9.9909D-14   1.9699D-15  -1.0822D-15  -2.5386D-15  -1.1571D-15  -1.4033D-15  -8.9673D-17   8.1526D-16   7.9181D-17  
#
D  DSS33     NHY  DER_NORT   8.3145D-04  -3.7940D-04  -3.8919D-04  -4.9046D-05   2.5944D-04   3.3888D-04   8.0738D-05   4.4478D-05  -2.9183D-04  
D  DSS33     NHY  DER_EAST  -2.2270D-04   3.8308D-04  -6.1849D-05   2.3400D-04  -3.1953D-04  -2.5496D-04   3.8920D-05   7.7091D-06  -1.5010D-04  
D  DSS33     NHY  CHEB_0     3.3168D-10   1.1745D-10   8.8553D-11   1.8671D-11   3.5223D-11  -8.3701D-13   1.6032D-11   9.7616D-12  -1.3737D-12  
D  DSS33     NHY  CHEB_1     2.0494D-11   5.5971D-12   5.1434D-12   6.5840D-13   1.8987D-12  -1.9789D-13   6.3445D-13   3.2744D-13   2.4791D-13  
D  DSS33     NHY  CHEB_2     3.7664D-12   8.5183D-13   9.0344D-13   6.3806D-14   3.0203D-13  -4.8611D-14   1.0469D-13   6.8597D-14   1.3059D-13  
D  DSS33     NHY  CHEB_3    -3.4379D-13  -1.6992D-13  -1.0450D-13  -3.2420D-14  -4.3401D-14   2.4346D-15  -1.6622D-14  -3.1688D-15   2.6561D-14  
D  DSS33     NHY  CHEB_4    -4.9998D-14  -1.6504D-14  -1.4242D-14  -2.6747D-15  -9.2455D-15  -2.8285D-16  -2.2901D-15  -4.0926D-15   2.8460D-15  
D  DSS33     NHY  CHEB_5    -9.7071D-15  -1.7398D-15  -1.9140D-15   8.3101D-17   2.7816D-15   1.5237D-15  -4.9543D-16   1.9739D-16  -3.1381D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS34     HYD  DER_NORT  -1.1518D-04   5.7932D-06   1.7116D-05   7.4344D-06   7.2906D-06  -2.9221D-06   3.8223D-06   2.9499D-06   2.2218D-06  
D  DSS34     HYD  DER_EAST  -6.4717D-06   5.3562D-06   7.9077D-06  -1.1316D-07  -6.3559D-06   9.6794D-06   1.2520D-05  -3.6152D-07  -1.5598D-06  
D  DSS34     HYD  CHEB_0     7.1673D-09  -2.5276D-11  -9.2494D-12  -1.0787D-11   2.1956D-12   8.5234D-12  -5.1974D-12  -9.1979D-13   6.8421D-12  
D  DSS34     HYD  CHEB_1    -6.9263D-12  -9.1624D-12  -3.4964D-12   1.9081D-12  -9.7656D-13  -5.1698D-13  -6.2124D-13  -1.6995D-13   7.5405D-13  
D  DSS34     HYD  CHEB_2    -3.2201D-12  -1.5136D-12  -6.0919D-13   3.1980D-13  -1.1236D-13  -1.2884D-13  -9.8672D-14  -2.6576D-14   1.3488D-13  
D  DSS34     HYD  CHEB_3    -1.5692D-12   2.0074D-13   7.8526D-14  -3.6854D-14   3.9815D-14  -3.0186D-15   2.1373D-14   6.2540D-15  -8.1368D-15  
D  DSS34     HYD  CHEB_4    -6.4810D-13   9.0346D-15   8.3535D-15   1.6136D-15  -2.0597D-15   3.4837D-15   1.2901D-15  -1.6750D-15   7.0297D-16  
D  DSS34     HYD  CHEB_5    -1.0016D-13   2.1259D-15  -8.9000D-16  -2.5414D-15  -1.3399D-15  -1.4859D-15  -8.3654D-17   7.8953D-16   1.2819D-16  
#
D  DSS34     NHY  DER_NORT   8.3035D-04  -3.7724D-04  -3.8853D-04  -4.8917D-05   2.6004D-04   3.3961D-04   8.0863D-05   4.3520D-05  -2.9322D-04  
D  DSS34     NHY  DER_EAST  -2.2149D-04   3.8095D-04  -6.2945D-05   2.3519D-04  -3.1917D-04  -2.5501D-04   4.0559D-05   5.8019D-06  -1.5081D-04  
D  DSS34     NHY  CHEB_0     3.3044D-10   1.1723D-10   8.8260D-11   1.8627D-11   3.5086D-11  -8.3738D-13   1.5993D-11   9.7406D-12  -1.4786D-12  
D  DSS34     NHY  CHEB_1     2.0435D-11   5.6000D-12   5.1322D-12   6.5894D-13   1.8944D-12  -1.9702D-13   6.3427D-13   3.2773D-13   2.3392D-13  
D  DSS34     NHY  CHEB_2     3.7577D-12   8.5365D-13   9.0200D-13   6.4681D-14   3.0157D-13  -4.8672D-14   1.0489D-13   6.8679D-14   1.2874D-13  
D  DSS34     NHY  CHEB_3    -3.4237D-13  -1.6983D-13  -1.0404D-13  -3.2886D-14  -4.3311D-14   2.6022D-15  -1.6602D-14  -3.0061D-15   2.6183D-14  
D  DSS34     NHY  CHEB_4    -4.9495D-14  -1.6464D-14  -1.4298D-14  -2.3000D-15  -9.3456D-15  -5.1476D-16  -2.1820D-15  -4.0661D-15   3.4394D-15  
D  DSS34     NHY  CHEB_5    -9.8141D-15  -1.7383D-15  -1.9043D-15  -1.7253D-16   2.6007D-15   1.5921D-15  -5.5744D-16   1.9200D-16  -3.2690D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS41     HYD  DER_NORT  -9.9048D-05   2.5858D-05   1.2779D-05   1.8476D-06   3.1602D-06  -1.1431D-05   7.7867D-06   1.3786D-06  -3.6049D-07  
D  DSS41     HYD  DER_EAST   2.1316D-05   9.0636D-07   3.8116D-06  -5.6104D-06  -5.6967D-06   9.7086D-06  -3.6253D-06  -5.9904D-07  -5.3378D-07  
D  DSS41     HYD  CHEB_0     7.6140D-09  -4.7070D-11  -1.6633D-11  -4.1877D-12  -3.6064D-12  -8.2074D-13  -1.2810D-13  -6.3442D-12   5.3475D-12  
D  DSS41     HYD  CHEB_1    -2.2173D-11  -9.3338D-12  -2.4872D-12   2.0976D-12  -2.1372D-12   4.1139D-14   7.3709D-13  -6.1133D-13   4.8721D-13  
D  DSS41     HYD  CHEB_2    -5.8473D-12  -1.5776D-12  -4.1299D-13   3.4297D-13  -2.6699D-13  -1.4192D-14   1.1314D-13  -1.0809D-13   9.9382D-14  
D  DSS41     HYD  CHEB_3    -1.3336D-12   2.0459D-13   6.5787D-14  -4.3412D-14   7.8271D-14  -6.7263D-15  -2.5099D-14   9.3145D-15  -4.2736D-15  
D  DSS41     HYD  CHEB_4    -6.9178D-13   1.5593D-14   7.9866D-15  -6.3305D-16  -1.0700D-15  -6.5256D-16   2.5059D-15   7.6238D-16   2.0751D-15  
D  DSS41     HYD  CHEB_5    -1.0557D-13  -1.6297D-16   1.2150D-16   7.4926D-16   5.6333D-16   1.1865D-15  -2.0647D-15  -3.8984D-16  -2.7635D-15  
#
D  DSS41     NHY  DER_NORT  -4.7219D-04  -7.5822D-04   1.1993D-04   6.3388D-04   7.4720D-05   3.7378D-04   7.1555D-05  -1.3338D-04  -1.4917D-04  
D  DSS41     NHY  DER_EAST  -4.5252D-04  -9.7093D-05   3.3167D-05   8.5900D-05   2.0350D-04   4.0162D-04   3.3622D-04   2.3264D-04  -2.4920D-05  
D  DSS41     NHY  CHEB_0     3.6838D-10   9.9963D-11   8.9190D-11  -4.9724D-12   1.3647D-11  -1.2919D-12  -1.0111D-11   4.7621D-12   4.4037D-13  
D  DSS41     NHY  CHEB_1     2.0553D-11   3.6483D-12   4.6316D-12   5.3020D-13   9.9782D-13   7.0883D-13   1.6782D-13   1.9002D-14   3.5338D-13  
D  DSS41     NHY  CHEB_2     3.6840D-12   5.1378D-13   8.0608D-13   1.3628D-13   1.8779D-13   1.8379D-13   8.4705D-14  -1.4732D-14   8.4923D-14  
D  DSS41     NHY  CHEB_3    -3.8667D-13  -1.3335D-13  -9.2595D-14   1.3806D-14  -1.0594D-14   1.5791D-14   1.5189D-14  -5.8336D-15  -1.0974D-15  
D  DSS41     NHY  CHEB_4    -5.7192D-14  -1.1774D-14  -1.7245D-14   4.5236D-15  -5.2558D-15  -7.0388D-16   3.2599D-15  -2.2261D-15  -3.8223D-15  
D  DSS41     NHY  CHEB_5    -8.1029D-15  -3.1641D-15   6.9718D-16   6.5209D-16  -2.7751D-17   1.0038D-15  -2.4264D-15   1.1063D-15  -2.7838D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS42     HYD  DER_NORT  -1.1472D-04   5.7044D-06   1.7093D-05   7.4310D-06   7.3052D-06  -2.9512D-06   3.8164D-06   3.0424D-06   2.3517D-06  
D  DSS42     HYD  DER_EAST  -6.4505D-06   5.5890D-06   7.9561D-06  -1.0382D-07  -6.2916D-06   9.6722D-06   1.2484D-05  -3.6084D-07  -1.6432D-06  
D  DSS42     HYD  CHEB_0     7.1818D-09  -2.5737D-11  -9.3684D-12  -1.0744D-11   2.1949D-12   8.5113D-12  -5.2289D-12  -8.8479D-13   7.0638D-12  
D  DSS42     HYD  CHEB_1    -7.2157D-12  -9.1928D-12  -3.5028D-12   1.9132D-12  -9.7591D-13  -5.1974D-13  -6.2269D-13  -1.6619D-13   7.7259D-13  
D  DSS42     HYD  CHEB_2    -3.2725D-12  -1.5167D-12  -6.0872D-13   3.2022D-13  -1.1265D-13  -1.2931D-13  -9.8556D-14  -2.5700D-14   1.3829D-13  
D  DSS42     HYD  CHEB_3    -1.5644D-12   2.0166D-13   7.8387D-14  -3.6763D-14   4.0583D-14  -2.5427D-15   2.1290D-14   6.0426D-15  -8.5750D-15  
D  DSS42     HYD  CHEB_4    -6.5064D-13   9.2589D-15   8.5879D-15   1.2886D-15  -2.4646D-15   3.2721D-15   1.3902D-15  -1.5630D-15   7.8430D-16  
D  DSS42     HYD  CHEB_5    -9.9510D-14   1.7734D-15  -1.2334D-15  -2.4458D-15  -8.8402D-16  -1.2703D-15  -1.0828D-16   7.7267D-16  -1.5728D-18  
#
D  DSS42     NHY  DER_NORT   8.3587D-04  -3.7992D-04  -3.8954D-04  -4.8803D-05   2.6002D-04   3.3826D-04   8.1727D-05   4.5530D-05  -2.9055D-04  
D  DSS42     NHY  DER_EAST  -2.1588D-04   3.8784D-04  -6.0738D-05   2.3347D-04  -3.1853D-04  -2.5406D-04   3.7652D-05   9.9457D-06  -1.5080D-04  
D  DSS42     NHY  CHEB_0     3.3312D-10   1.1767D-10   8.8897D-11   1.8709D-11   3.5378D-11  -8.4042D-13   1.6078D-11   9.7636D-12  -1.2405D-12  
D  DSS42     NHY  CHEB_1     2.0557D-11   5.5916D-12   5.1547D-12   6.5884D-13   1.9027D-12  -1.9870D-13   6.3425D-13   3.2346D-13   2.6117D-13  
D  DSS42     NHY  CHEB_2     3.7752D-12   8.4886D-13   9.0482D-13   6.3249D-14   3.0279D-13  -4.8156D-14   1.0437D-13   6.8351D-14   1.3248D-13  
D  DSS42     NHY  CHEB_3    -3.4522D-13  -1.7010D-13  -1.0507D-13  -3.1969D-14  -4.3816D-14   2.2016D-15  -1.6426D-14  -3.3189D-15   2.7534D-14  
D  DSS42     NHY  CHEB_4    -5.0554D-14  -1.6322D-14  -1.4044D-14  -3.0052D-15  -8.8275D-15   1.0355D-16  -2.5627D-15  -4.0116D-15   1.9290D-15  
D  DSS42     NHY  CHEB_5    -9.4772D-15  -1.7612D-15  -1.9697D-15   3.2833D-16   2.7484D-15   1.3525D-15  -3.6201D-16   5.8116D-17  -2.8567D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS43     HYD  DER_NORT  -1.1505D-04   5.7438D-06   1.7109D-05   7.4479D-06   7.2920D-06  -2.9618D-06   3.8160D-06   2.9580D-06   2.2027D-06  
D  DSS43     HYD  DER_EAST  -6.5212D-06   5.4207D-06   7.9345D-06  -1.0522D-07  -6.3300D-06   9.6897D-06   1.2519D-05  -3.5525D-07  -1.5777D-06  
D  DSS43     HYD  CHEB_0     7.1699D-09  -2.5368D-11  -9.2690D-12  -1.0777D-11   2.2005D-12   8.5203D-12  -5.2009D-12  -9.0173D-13   6.9007D-12  
D  DSS43     HYD  CHEB_1    -6.9748D-12  -9.1698D-12  -3.4981D-12   1.9086D-12  -9.7639D-13  -5.1778D-13  -6.2158D-13  -1.6806D-13   7.5996D-13  
D  DSS43     HYD  CHEB_2    -3.2290D-12  -1.5138D-12  -6.0885D-13   3.1986D-13  -1.1251D-13  -1.2872D-13  -9.8559D-14  -2.6329D-14   1.3572D-13  
D  DSS43     HYD  CHEB_3    -1.5683D-12   2.0094D-13   7.8465D-14  -3.6846D-14   3.9998D-14  -2.8848D-15   2.1300D-14   6.2774D-15  -8.2555D-15  
D  DSS43     HYD  CHEB_4    -6.4832D-13   9.0661D-15   8.3091D-15   1.5553D-15  -2.1496D-15   3.4385D-15   1.3101D-15  -1.6939D-15   7.2326D-16  
D  DSS43     HYD  CHEB_5    -1.0032D-13   2.0550D-15  -9.0730D-16  -2.5285D-15  -1.2502D-15  -1.4785D-15  -8.3379D-17   8.3269D-16   1.0097D-16  
#
D  DSS43     NHY  DER_NORT   8.3138D-04  -3.8134D-04  -3.9033D-04  -4.9113D-05   2.5903D-04   3.3859D-04   8.0414D-05   4.3325D-05  -2.9139D-04  
D  DSS43     NHY  DER_EAST  -2.2318D-04   3.8301D-04  -6.1962D-05   2.3459D-04  -3.1971D-04  -2.5431D-04   3.9048D-05   7.2582D-06  -1.5166D-04  
D  DSS43     NHY  CHEB_0     3.3099D-10   1.1731D-10   8.8380D-11   1.8644D-11   3.5163D-11  -8.2283D-13   1.6021D-11   9.7602D-12  -1.4402D-12  
D  DSS43     NHY  CHEB_1     2.0454D-11   5.5925D-12   5.1343D-12   6.5898D-13   1.8951D-12  -1.9657D-13   6.3380D-13   3.2656D-13   2.4312D-13  
D  DSS43     NHY  CHEB_2     3.7593D-12   8.5108D-13   9.0186D-13   6.4245D-14   3.0137D-13  -4.8508D-14   1.0485D-13   6.8742D-14   1.3077D-13  
D  DSS43     NHY  CHEB_3    -3.4304D-13  -1.6980D-13  -1.0420D-13  -3.2688D-14  -4.3286D-14   2.5239D-15  -1.6569D-14  -2.9362D-15   2.6359D-14  
D  DSS43     NHY  CHEB_4    -4.9622D-14  -1.6399D-14  -1.4261D-14  -2.4349D-15  -9.3327D-15  -4.4403D-16  -2.2082D-15  -4.1250D-15   3.1451D-15  
D  DSS43     NHY  CHEB_5    -9.7731D-15  -1.7323D-15  -1.8971D-15  -6.3399D-17   2.7117D-15   1.5849D-15  -5.4543D-16   2.2766D-16  -3.2262D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS44     HYD  DER_NORT  -1.2329D-04   5.5961D-06   1.7651D-05   8.3243D-06   6.9964D-06  -4.1856D-06   3.5538D-06   1.2845D-06  -2.1161D-06  
D  DSS44     HYD  DER_EAST  -1.1491D-05   4.2721D-07   7.8356D-06   9.7882D-08  -7.2707D-06   1.0623D-05   1.3876D-05  -2.1745D-07   9.0145D-07  
D  DSS44     HYD  CHEB_0     6.7944D-09  -1.4427D-11  -6.1874D-12  -1.1773D-11   2.4484D-12   8.7043D-12  -4.3680D-12  -1.0177D-12   2.5216D-12  
D  DSS44     HYD  CHEB_1     7.8563D-13  -8.4836D-12  -3.3811D-12   1.7550D-12  -9.7651D-13  -4.3055D-13  -5.9479D-13  -2.0348D-13   4.1730D-13  
D  DSS44     HYD  CHEB_2    -1.8414D-12  -1.4201D-12  -6.0169D-13   2.9917D-13  -1.1925D-13  -1.0851D-13  -9.6989D-14  -3.0468D-14   6.7265D-14  
D  DSS44     HYD  CHEB_3    -1.6417D-12   1.7930D-13   6.8610D-14  -3.1230D-14   3.5385D-14  -4.0332D-15   1.6343D-14   4.0783D-15  -5.6183D-15  
D  DSS44     HYD  CHEB_4    -6.1957D-13   5.4351D-15   5.0729D-15   8.0674D-17   4.4766D-16   3.7029D-15   5.8912D-16  -2.2955D-16   2.4696D-15  
D  DSS44     HYD  CHEB_5    -9.0123D-14   3.5891D-15   4.9724D-16  -5.3156D-16  -1.8007D-15  -2.0351D-15  -4.4087D-16  -1.5966D-16  -1.1369D-15  
#
D  DSS44     NHY  DER_NORT   5.6459D-04  -5.7063D-04  -4.5624D-04  -6.6150D-05   1.9480D-04   3.1843D-04   1.0195D-05  -3.0375D-05  -2.2247D-04  
D  DSS44     NHY  DER_EAST  -5.3886D-04   2.3196D-04  -7.6153D-05   2.4952D-04  -3.8487D-04  -2.5281D-04   5.7479D-05  -7.9638D-05  -1.8671D-04  
D  DSS44     NHY  CHEB_0     2.6758D-10   1.0547D-10   7.2307D-11   1.6602D-11   2.8953D-11   2.2357D-13   1.4418D-11   9.8173D-12  -7.6012D-12  
D  DSS44     NHY  CHEB_1     1.7064D-11   5.4778D-12   4.3853D-12   6.6314D-13   1.5863D-12  -1.0805D-13   6.2048D-13   4.1035D-13  -2.1593D-13  
D  DSS44     NHY  CHEB_2     3.1854D-12   8.8542D-13   7.9035D-13   7.4105D-14   2.6457D-13  -2.9440D-14   1.0433D-13   8.9965D-14   2.5965D-14  
D  DSS44     NHY  CHEB_3    -2.5869D-13  -1.4197D-13  -7.8168D-14  -2.9037D-14  -3.4287D-14  -3.2400D-15  -1.2700D-14  -3.2316D-15   2.9247D-14  
D  DSS44     NHY  CHEB_4    -4.0071D-14  -1.5166D-14  -1.1609D-14  -2.5591D-15  -6.4186D-15   8.2274D-16  -3.8385D-15  -2.4170D-15   2.5414D-15  
D  DSS44     NHY  CHEB_5    -6.7282D-15  -1.6150D-15  -1.3184D-15  -4.2567D-16   8.2567D-16   1.7917D-18   8.6837D-16  -1.4493D-15  -1.3077D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS45     HYD  DER_NORT  -1.1468D-04   5.7048D-06   1.7079D-05   7.4147D-06   7.2930D-06  -2.9381D-06   3.8151D-06   3.0459D-06   2.3869D-06  
D  DSS45     HYD  DER_EAST  -6.3190D-06   5.5912D-06   7.9473D-06  -1.1822D-07  -6.3010D-06   9.6785D-06   1.2479D-05  -3.5061D-07  -1.6232D-06  
D  DSS45     HYD  CHEB_0     7.1821D-09  -2.5763D-11  -9.3781D-12  -1.0744D-11   2.1893D-12   8.5106D-12  -5.2302D-12  -8.8903D-13   7.0638D-12  
D  DSS45     HYD  CHEB_1    -7.2196D-12  -9.1940D-12  -3.5040D-12   1.9125D-12  -9.7736D-13  -5.1936D-13  -6.2251D-13  -1.6690D-13   7.7225D-13  
D  DSS45     HYD  CHEB_2    -3.2771D-12  -1.5175D-12  -6.0823D-13   3.2068D-13  -1.1258D-13  -1.2934D-13  -9.8230D-14  -2.5910D-14   1.3836D-13  
D  DSS45     HYD  CHEB_3    -1.5628D-12   2.0153D-13   7.8153D-14  -3.6766D-14   4.0710D-14  -2.5790D-15   2.1131D-14   6.1057D-15  -8.6054D-15  
D  DSS45     HYD  CHEB_4    -6.5082D-13   9.3494D-15   8.5352D-15   1.2470D-15  -2.5472D-15   3.3050D-15   1.4346D-15  -1.6055D-15   7.2048D-16  
D  DSS45     HYD  CHEB_5    -9.9782D-14   1.7694D-15  -1.1346D-15  -2.4140D-15  -8.0956D-16  -1.2750D-15  -1.0826D-16   7.8733D-16   2.5216D-17  
#
D  DSS45     NHY  DER_NORT   8.3939D-04  -3.7790D-04  -3.8916D-04  -4.8357D-05   2.6145D-04   3.3847D-04   8.2950D-05   4.5416D-05  -2.9081D-04  
D  DSS45     NHY  DER_EAST  -2.0668D-04   3.9045D-04  -6.0894D-05   2.3443D-04  -3.1696D-04  -2.5307D-04   3.8313D-05   1.0002D-05  -1.5256D-04  
D  DSS45     NHY  CHEB_0     3.3310D-10   1.1764D-10   8.8897D-11   1.8696D-11   3.5373D-11  -8.4386D-13   1.6079D-11   9.7383D-12  -1.2290D-12  
D  DSS45     NHY  CHEB_1     2.0551D-11   5.5887D-12   5.1527D-12   6.6027D-13   1.9021D-12  -1.9821D-13   6.3359D-13   3.1945D-13   2.5773D-13  
D  DSS45     NHY  CHEB_2     3.7737D-12   8.4769D-13   9.0435D-13   6.3533D-14   3.0269D-13  -4.7842D-14   1.0443D-13   6.8012D-14   1.3244D-13  
D  DSS45     NHY  CHEB_3    -3.4513D-13  -1.7018D-13  -1.0507D-13  -3.1916D-14  -4.3764D-14   2.2942D-15  -1.6294D-14  -3.0897D-15   2.7832D-14  
D  DSS45     NHY  CHEB_4    -5.0426D-14  -1.6150D-14  -1.3976D-14  -3.0157D-15  -8.7921D-15   8.3947D-17  -2.5788D-15  -4.0085D-15   1.8296D-15  
D  DSS45     NHY  CHEB_5    -9.4952D-15  -1.7763D-15  -1.9950D-15   3.5514D-16   2.7462D-15   1.3662D-15  -3.6082D-16   3.8887D-17  -2.8602D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS46     HYD  DER_NORT  -1.1476D-04   5.6849D-06   1.7102D-05   7.4541D-06   7.3095D-06  -2.9872D-06   3.8131D-06   3.0214D-06   2.2748D-06  
D  DSS46     HYD  DER_EAST  -6.5846D-06   5.5810D-06   7.9724D-06  -9.0089D-08  -6.2803D-06   9.6798D-06   1.2496D-05  -3.6165D-07  -1.6482D-06  
D  DSS46     HYD  CHEB_0     7.1800D-09  -2.5673D-11  -9.3449D-12  -1.0747D-11   2.2027D-12   8.5102D-12  -5.2252D-12  -8.7310D-13   7.0549D-12  
D  DSS46     HYD  CHEB_1    -7.1760D-12  -9.1901D-12  -3.5018D-12   1.9127D-12  -9.7504D-13  -5.1991D-13  -6.2270D-13  -1.6509D-13   7.7294D-13  
D  DSS46     HYD  CHEB_2    -3.2631D-12  -1.5156D-12  -6.0887D-13   3.1988D-13  -1.1274D-13  -1.2905D-13  -9.8696D-14  -2.5586D-14   1.3802D-13  
D  DSS46     HYD  CHEB_3    -1.5659D-12   2.0170D-13   7.8528D-14  -3.6787D-14   4.0454D-14  -2.5393D-15   2.1354D-14   6.0716D-15  -8.5164D-15  
D  DSS46     HYD  CHEB_4    -6.5008D-13   9.1362D-15   8.5021D-15   1.3539D-15  -2.3751D-15   3.2755D-15   1.3470D-15  -1.5847D-15   8.1058D-16  
D  DSS46     HYD  CHEB_5    -9.9624D-14   1.8238D-15  -1.2110D-15  -2.4834D-15  -9.7889D-16  -1.3209D-15  -9.7897D-17   8.0419D-16   8.4800D-18  
#
D  DSS46     NHY  DER_NORT   8.3294D-04  -3.8412D-04  -3.9112D-04  -4.9307D-05   2.5820D-04   3.3758D-04   8.0326D-05   4.4863D-05  -2.8946D-04  
D  DSS46     NHY  DER_EAST  -2.2473D-04   3.8617D-04  -6.0368D-05   2.3279D-04  -3.2017D-04  -2.5433D-04   3.6701D-05   1.0061D-05  -1.5048D-04  
D  DSS46     NHY  CHEB_0     3.3288D-10   1.1764D-10   8.8827D-11   1.8710D-11   3.5370D-11  -8.2441D-13   1.6079D-11   9.7910D-12  -1.2795D-12  
D  DSS46     NHY  CHEB_1     2.0543D-11   5.5890D-12   5.1516D-12   6.5798D-13   1.9015D-12  -1.9817D-13   6.3432D-13   3.2613D-13   2.6411D-13  
D  DSS46     NHY  CHEB_2     3.7728D-12   8.4866D-13   9.0423D-13   6.3082D-14   3.0236D-13  -4.8337D-14   1.0443D-13   6.8742D-14   1.3323D-13  
D  DSS46     NHY  CHEB_3    -3.4508D-13  -1.6996D-13  -1.0494D-13  -3.2072D-14  -4.3699D-14   2.1804D-15  -1.6513D-14  -3.3374D-15   2.7164D-14  
D  DSS46     NHY  CHEB_4    -5.0457D-14  -1.6405D-14  -1.4113D-14  -2.9303D-15  -8.9653D-15   2.1006D-17  -2.4826D-15  -4.0543D-15   2.1031D-15  
D  DSS46     NHY  CHEB_5    -9.5251D-15  -1.7488D-15  -1.9390D-15   2.6745D-16   2.7928D-15   1.3980D-15  -3.9496D-16   1.1696D-16  -2.9106D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS49     HYD  DER_NORT  -1.0606D-04   1.9425D-05   1.3211D-05  -1.7472D-06   4.8078D-06   2.2149D-06   6.2031D-06   1.5614D-06   1.0680D-07  
D  DSS49     HYD  DER_EAST   1.4263D-05   1.9873D-06   6.7600D-06  -1.1526D-06  -8.5042D-06   6.9190D-06   1.1450D-05  -1.0525D-06  -2.9038D-07  
D  DSS49     HYD  CHEB_0     7.4022D-09  -3.5597D-11  -1.3553D-11  -8.7722D-12  -1.1358D-13   7.4385D-12  -5.3823D-12  -4.8772D-12   4.8949D-12  
D  DSS49     HYD  CHEB_1    -1.4651D-11  -9.2954D-12  -3.3150D-12   2.1665D-12  -1.0813D-12  -4.7914D-13  -3.6863D-13  -4.8047D-13   4.6759D-13  
D  DSS49     HYD  CHEB_2    -4.5646D-12  -1.5928D-12  -5.7728D-13   3.7117D-13  -1.1475D-13  -1.2133D-13  -6.3188D-14  -9.4153D-14   9.6678D-14  
D  DSS49     HYD  CHEB_3    -1.4474D-12   1.9225D-13   7.8611D-14  -4.0984D-14   3.4554D-14  -6.9242D-15   1.1183D-14   4.9417D-15  -6.3597D-15  
D  DSS49     HYD  CHEB_4    -6.8464D-13   1.5027D-14   9.8526D-15  -2.1489D-16   3.2727D-17   4.3801D-15   1.7773D-15   1.7118D-15   2.4201D-15  
D  DSS49     HYD  CHEB_5    -1.0198D-13   2.2580D-15  -7.9329D-18  -3.3454D-16  -3.8163D-16  -1.3241D-15  -1.0914D-15  -6.1540D-16  -2.9690D-15  
#
D  DSS49     NHY  DER_NORT  -4.6578D-04  -8.1816D-04   3.2807D-04   4.7468D-04   2.0876D-04   2.1627D-04   1.2901D-04  -1.7142D-04  -1.9313D-05  
D  DSS49     NHY  DER_EAST   8.0783D-04   6.4246D-04  -2.5092D-04   5.1992D-05   8.9941D-06  -2.4306D-04   8.7902D-05   1.6329D-04  -1.0164D-04  
D  DSS49     NHY  CHEB_0     3.6043D-10   1.2224D-10   9.6355D-11   1.4772D-11   2.8425D-11  -3.2191D-12   1.3638D-11   4.1974D-12   2.3930D-13  
D  DSS49     NHY  CHEB_1     2.1131D-11   5.5260D-12   5.3918D-12   6.2452D-13   1.6009D-12  -1.5767D-13   9.6308D-13   8.2349D-14   3.8552D-13  
D  DSS49     NHY  CHEB_2     3.8845D-12   9.0335D-13   9.5168D-13   1.0589D-13   2.8336D-13  -1.4209D-14   1.9464D-13   1.5769D-14   8.3445D-14  
D  DSS49     NHY  CHEB_3    -3.5545D-13  -1.4734D-13  -1.0160D-13  -2.1090D-14  -2.7768D-14   5.3273D-15  -8.5909D-15  -7.9455D-15  -4.0537D-15  
D  DSS49     NHY  CHEB_4    -5.8656D-14  -2.1930D-14  -2.1845D-14   1.8698D-15  -8.7867D-15   5.7580D-15  -1.4737D-15  -1.6820D-15   1.8250D-15  
D  DSS49     NHY  CHEB_5    -8.5612D-15  -1.0435D-15   2.6035D-16  -2.6536D-15   5.5152D-16  -1.5154D-15  -6.8282D-16  -1.8859D-15  -2.1354D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS51     HYD  DER_NORT  -2.5703D-05   2.7849D-05   6.6378D-06  -5.9568D-06   7.9646D-06  -9.3751D-07  -2.6639D-06  -1.0966D-06   3.4666D-07  
D  DSS51     HYD  DER_EAST  -2.5773D-06  -3.8567D-06  -4.3662D-06   6.5539D-07   1.4442D-06  -2.2262D-06   1.7246D-06  -1.1849D-06   9.1582D-07  
D  DSS51     HYD  CHEB_0     6.5974D-09  -3.0182D-11  -7.1194D-12   9.3807D-13  -1.0554D-12   7.9420D-13   2.3953D-13  -3.6544D-12  -6.0973D-12  
D  DSS51     HYD  CHEB_1    -7.8164D-12  -5.6160D-12  -8.6981D-13   1.3143D-13  -6.2975D-13   6.1857D-13   1.1964D-13  -4.8813D-13  -6.6922D-13  
D  DSS51     HYD  CHEB_2    -3.3945D-12  -1.0105D-12  -1.5288D-13   5.8378D-14  -7.6063D-14   1.0027D-13   1.3382D-14  -1.0064D-13  -1.2896D-13  
D  DSS51     HYD  CHEB_3    -1.4399D-12   9.5532D-14   2.0375D-14   2.3435D-14   2.4900D-14  -1.1717D-14  -6.3140D-16   5.4225D-15   2.5839D-15  
D  DSS51     HYD  CHEB_4    -5.8782D-13   1.3414D-14   3.2165D-15   4.1727D-16  -1.4896D-15  -1.1604D-15  -4.8522D-16  -2.2560D-15  -2.5056D-16  
D  DSS51     HYD  CHEB_5    -9.3294D-14  -2.9047D-15  -1.6487D-16   6.2471D-16  -7.4722D-17   1.2591D-15   8.5254D-16   9.3375D-16   1.3322D-17  
#
D  DSS51     NHY  DER_NORT  -1.8109D-04  -9.9141D-04  -4.2461D-04   4.3514D-04   5.8551D-04   4.2581D-04   4.8345D-04   3.2667D-04   5.1833D-05  
D  DSS51     NHY  DER_EAST   4.3064D-04   3.6275D-04  -3.0083D-04  -1.4881D-04  -3.4095D-04   3.7347D-05  -7.1285D-05  -1.2749D-04   3.0018D-04  
D  DSS51     NHY  CHEB_0     3.6138D-10   2.1579D-10   2.7612D-11  -6.6257D-12  -1.8818D-11  -2.3301D-12  -3.0487D-11  -7.8435D-12   1.0356D-11  
D  DSS51     NHY  CHEB_1     2.1997D-11   1.1474D-11   1.5423D-12  -2.9107D-13  -5.5273D-13   6.4484D-14  -1.4573D-12  -5.8241D-13  -3.3717D-13  
D  DSS51     NHY  CHEB_2     4.0777D-12   1.9866D-12   2.6397D-13  -4.7741D-14  -7.9707D-14   1.8374D-14  -2.6329D-13  -1.0669D-13  -1.2710D-13  
D  DSS51     NHY  CHEB_3    -3.5022D-13  -2.4740D-13  -3.7763D-14   8.8848D-15   2.0371D-14   6.3972D-15   2.6764D-14   6.7008D-15  -2.4793D-14  
D  DSS51     NHY  CHEB_4    -4.8886D-14  -2.8884D-14  -2.6296D-15   2.8517D-15  -6.8603D-16   3.5322D-16   8.8663D-16   5.8205D-15   2.9029D-17  
D  DSS51     NHY  CHEB_5    -9.1155D-15  -4.6075D-15  -1.4607D-15   1.7513D-16   1.4883D-15   1.2546D-15   1.7920D-15  -1.6092D-15  -1.5388D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS53     HYD  DER_NORT   6.9794D-05  -2.5850D-06  -1.6250D-05   8.5907D-06   1.2397D-05  -2.3418D-05   1.8700D-05   1.3247D-06   1.4755D-06  
D  DSS53     HYD  DER_EAST  -1.5040D-05  -1.7193D-05  -2.4227D-05   6.9290D-06  -1.8789D-05  -1.2539D-05   1.7309D-05   1.6976D-06  -4.6519D-07  
D  DSS53     HYD  CHEB_0     7.0824D-09   3.1782D-11   4.0488D-12   1.7588D-11  -5.8290D-13   1.0008D-11  -6.0503D-12   2.2119D-13  -4.0421D-12  
D  DSS53     HYD  CHEB_1    -3.6906D-12   1.0005D-11   7.9982D-12  -1.7818D-12  -2.0103D-12   6.6262D-13  -4.7873D-13   5.5719D-14  -7.9999D-13  
D  DSS53     HYD  CHEB_2    -2.8470D-12   1.4128D-12   1.2338D-12  -2.9280D-13  -3.1141D-13   6.6798D-14  -3.9838D-14   1.8284D-14  -1.4885D-13  
D  DSS53     HYD  CHEB_3    -1.6465D-12  -2.5335D-13  -1.8346D-13   3.1641D-14   6.0436D-14  -9.6057D-15   3.0648D-15  -6.7057D-15   8.1408D-15  
D  DSS53     HYD  CHEB_4    -6.4878D-13   8.9018D-15  -8.3640D-15   1.7224D-15  -2.3600D-15   1.1309D-15  -1.4433D-15  -1.8472D-15  -1.2166D-15  
D  DSS53     HYD  CHEB_5    -9.4117D-14  -3.0362D-15  -2.6337D-15   2.2360D-15  -3.5816D-15  -2.3056D-15   4.3694D-15   1.5191D-15   1.2081D-15  
#
D  DSS53     NHY  DER_NORT  -6.7516D-04   1.6993D-04  -1.5706D-04  -2.7651D-05  -1.5473D-04   1.3354D-04   3.1624D-04   8.5074D-06  -2.1217D-04  
D  DSS53     NHY  DER_EAST  -6.4599D-05  -3.1350D-04  -8.6577D-05   7.7190D-05  -1.2887D-04   7.7269D-05   2.9836D-05  -3.0128D-05  -1.0817D-05  
D  DSS53     NHY  CHEB_0     3.4092D-10  -6.7592D-11  -7.1413D-11  -2.4160D-11  -2.8141D-11  -2.1677D-11   3.1872D-11  -5.3653D-12   2.4958D-12  
D  DSS53     NHY  CHEB_1     2.1038D-11  -3.6549D-12  -3.3958D-12  -1.4923D-12  -1.9018D-12  -1.4156D-12   1.8081D-12  -3.9466D-13  -2.0776D-13  
D  DSS53     NHY  CHEB_2     3.9132D-12  -6.5725D-13  -5.8574D-13  -2.7497D-13  -3.6014D-13  -2.8902D-13   3.1520D-13  -6.7622D-14  -5.2892D-14  
D  DSS53     NHY  CHEB_3    -3.3031D-13   7.0846D-14   7.8251D-14   2.1366D-14   2.2565D-14   1.7289D-14  -3.6001D-14   5.7310D-15  -6.3633D-15  
D  DSS53     NHY  CHEB_4    -5.3562D-14   1.2291D-14   1.0562D-14   2.4695D-15   5.6516D-15   2.0379D-15  -6.1938D-15  -8.9207D-17   5.3468D-16  
D  DSS53     NHY  CHEB_5    -8.4010D-15   1.1529D-15   1.2595D-15   4.8083D-16   1.0321D-17   1.3447D-15  -4.4235D-16  -1.5126D-17   4.4126D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS54     HYD  DER_NORT   7.0013D-05  -2.5701D-06  -1.6238D-05   8.6115D-06   1.2444D-05  -2.3426D-05   1.8715D-05   1.2719D-06   1.4359D-06  
D  DSS54     HYD  DER_EAST  -1.5051D-05  -1.7208D-05  -2.4240D-05   6.9538D-06  -1.8802D-05  -1.2556D-05   1.7343D-05   1.6758D-06  -4.8028D-07  
D  DSS54     HYD  CHEB_0     7.0740D-09   3.1478D-11   3.9100D-12   1.7565D-11  -5.4137D-13   9.9782D-12  -6.0422D-12   2.5412D-13  -3.9472D-12  
D  DSS54     HYD  CHEB_1    -3.5281D-12   9.9851D-12   7.9864D-12  -1.7819D-12  -2.0103D-12   6.6048D-13  -4.7755D-13   5.8180D-14  -7.9260D-13  
D  DSS54     HYD  CHEB_2    -2.8144D-12   1.4105D-12   1.2339D-12  -2.9318D-13  -3.1080D-13   6.7085D-14  -4.0498D-14   1.9658D-14  -1.4689D-13  
D  DSS54     HYD  CHEB_3    -1.6485D-12  -2.5317D-13  -1.8333D-13   3.1277D-14   5.9965D-14  -9.9946D-15   3.2274D-15  -7.0523D-15   8.0411D-15  
D  DSS54     HYD  CHEB_4    -6.4748D-13   8.8785D-15  -8.1761D-15   1.8925D-15  -2.1169D-15   1.3346D-15  -1.4873D-15  -1.3793D-15  -1.0738D-15  
D  DSS54     HYD  CHEB_5    -9.5099D-14  -2.9070D-15  -2.6952D-15   2.0153D-15  -3.7808D-15  -2.3791D-15   4.3825D-15   9.4454D-16   8.8592D-16  
#
D  DSS54     NHY  DER_NORT  -6.7217D-04   1.6910D-04  -1.5668D-04  -2.8458D-05  -1.5456D-04   1.3324D-04   3.1687D-04   7.1012D-06  -2.1346D-04  
D  DSS54     NHY  DER_EAST  -6.7279D-05  -3.1143D-04  -8.6090D-05   7.7862D-05  -1.2949D-04   7.8802D-05   3.0236D-05  -3.0744D-05  -1.0124D-05  
D  DSS54     NHY  CHEB_0     3.3940D-10  -6.7485D-11  -7.1243D-11  -2.4065D-11  -2.7966D-11  -2.1591D-11   3.1760D-11  -5.3128D-12   2.6298D-12  
D  DSS54     NHY  CHEB_1     2.0963D-11  -3.6546D-12  -3.3949D-12  -1.4892D-12  -1.8932D-12  -1.4141D-12   1.8036D-12  -3.9127D-13  -1.9575D-13  
D  DSS54     NHY  CHEB_2     3.9007D-12  -6.5853D-13  -5.8581D-13  -2.7446D-13  -3.5849D-13  -2.8718D-13   3.1512D-13  -6.6418D-14  -5.0627D-14  
D  DSS54     NHY  CHEB_3    -3.2831D-13   7.0688D-14   7.7620D-14   2.1212D-14   2.2380D-14   1.5919D-14  -3.6415D-14   5.3813D-15  -5.7941D-15  
D  DSS54     NHY  CHEB_4    -5.3303D-14   1.1874D-14   1.0548D-14   2.7792D-15   5.7237D-15   3.0130D-15  -5.6915D-15   2.5107D-16   1.2574D-16  
D  DSS54     NHY  CHEB_5    -8.2717D-15   1.5757D-15   1.4647D-15   2.2917D-16  -2.6380D-16   4.8586D-16  -8.0481D-16  -3.0553D-16   2.9354D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS55     HYD  DER_NORT   6.9683D-05  -2.6035D-06  -1.6214D-05   8.5733D-06   1.2430D-05  -2.3396D-05   1.8690D-05   1.3691D-06   1.5348D-06  
D  DSS55     HYD  DER_EAST  -1.5138D-05  -1.7186D-05  -2.4222D-05   6.9151D-06  -1.8763D-05  -1.2524D-05   1.7288D-05   1.7136D-06  -4.5863D-07  
D  DSS55     HYD  CHEB_0     7.0888D-09   3.2017D-11   4.1597D-12   1.7606D-11  -6.1000D-13   1.0030D-11  -6.0532D-12   2.0095D-13  -4.1047D-12  
D  DSS55     HYD  CHEB_1    -3.8211D-12   1.0018D-11   8.0034D-12  -1.7817D-12  -2.0137D-12   6.6278D-13  -4.7723D-13   5.4819D-14  -8.0458D-13  
D  DSS55     HYD  CHEB_2    -2.8706D-12   1.4152D-12   1.2348D-12  -2.9296D-13  -3.1156D-13   6.6828D-14  -3.9925D-14   1.7560D-14  -1.4998D-13  
D  DSS55     HYD  CHEB_3    -1.6455D-12  -2.5374D-13  -1.8387D-13   3.1981D-14   6.0650D-14  -9.5741D-15   3.1546D-15  -6.4863D-15   8.1635D-15  
D  DSS55     HYD  CHEB_4    -6.4916D-13   8.8906D-15  -8.3617D-15   1.5870D-15  -2.5811D-15   1.0315D-15  -1.5213D-15  -2.1122D-15  -1.2555D-15  
D  DSS55     HYD  CHEB_5    -9.3539D-14  -3.0608D-15  -2.5162D-15   2.3743D-15  -3.3780D-15  -2.1667D-15   4.3631D-15   1.9016D-15   1.4220D-15  
#
D  DSS55     NHY  DER_NORT  -6.7870D-04   1.7009D-04  -1.5678D-04  -2.7098D-05  -1.5244D-04   1.3298D-04   3.1807D-04   9.7674D-06  -2.1196D-04  
D  DSS55     NHY  DER_EAST  -6.8978D-05  -3.1310D-04  -8.6459D-05   7.7791D-05  -1.2849D-04   7.7944D-05   3.0128D-05  -2.9748D-05  -1.1073D-05  
D  DSS55     NHY  CHEB_0     3.4202D-10  -6.7619D-11  -7.1536D-11  -2.4238D-11  -2.8273D-11  -2.1747D-11   3.1966D-11  -5.3873D-12   2.4040D-12  
D  DSS55     NHY  CHEB_1     2.1094D-11  -3.6508D-12  -3.3992D-12  -1.4965D-12  -1.9089D-12  -1.4202D-12   1.8138D-12  -3.9492D-13  -2.1454D-13  
D  DSS55     NHY  CHEB_2     3.9226D-12  -6.5545D-13  -5.8548D-13  -2.7582D-13  -3.6169D-13  -2.9039D-13   3.1576D-13  -6.8039D-14  -5.4266D-14  
D  DSS55     NHY  CHEB_3    -3.3187D-13   7.0847D-14   7.8882D-14   2.1406D-14   2.2753D-14   1.8359D-14  -3.5818D-14   5.9422D-15  -6.6830D-15  
D  DSS55     NHY  CHEB_4    -5.3682D-14   1.2502D-14   1.0623D-14   2.3099D-15   5.4558D-15   1.3922D-15  -6.5368D-15  -3.0491D-16   8.4973D-16  
D  DSS55     NHY  CHEB_5    -8.5191D-15   8.5816D-16   1.1072D-15   6.0986D-16   2.5846D-16   1.9686D-15  -1.8869D-16   1.6764D-16  -1.3703D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS61     HYD  DER_NORT   7.0042D-05  -2.5586D-06  -1.6266D-05   8.6206D-06   1.2407D-05  -2.3442D-05   1.8718D-05   1.2493D-06   1.3979D-06  
D  DSS61     HYD  DER_EAST  -1.4943D-05  -1.7207D-05  -2.4234D-05   6.9580D-06  -1.8819D-05  -1.2563D-05   1.7348D-05   1.6675D-06  -4.8124D-07  
D  DSS61     HYD  CHEB_0     7.0712D-09   3.1373D-11   3.8565D-12   1.7559D-11  -5.3515D-13   9.9718D-12  -6.0415D-12   2.6008D-13  -3.9188D-12  
D  DSS61     HYD  CHEB_1    -3.4659D-12   9.9801D-12   7.9861D-12  -1.7824D-12  -2.0074D-12   6.6124D-13  -4.7967D-13   5.8326D-14  -7.9092D-13  
D  DSS61     HYD  CHEB_2    -2.8049D-12   1.4091D-12   1.2329D-12  -2.9283D-13  -3.1085D-13   6.6968D-14  -4.0115D-14   1.9835D-14  -1.4651D-13  
D  DSS61     HYD  CHEB_3    -1.6489D-12  -2.5288D-13  -1.8299D-13   3.1039D-14   5.9934D-14  -9.8815D-15   3.0414D-15  -7.1619D-15   8.0084D-15  
D  DSS61     HYD  CHEB_4    -6.4724D-13   8.8503D-15  -8.2425D-15   1.9784D-15  -1.9990D-15   1.3536D-15  -1.3787D-15  -1.1993D-15  -9.6894D-16  
D  DSS61     HYD  CHEB_5    -9.5465D-14  -2.9206D-15  -2.7864D-15   1.9570D-15  -3.8977D-15  -2.4868D-15   4.3796D-15   7.5475D-16   7.4171D-16  
#
D  DSS61     NHY  DER_NORT  -6.7025D-04   1.6949D-04  -1.5676D-04  -2.8478D-05  -1.5646D-04   1.3375D-04   3.1529D-04   6.3367D-06  -2.1327D-04  
D  DSS61     NHY  DER_EAST  -6.1701D-05  -3.1252D-04  -8.6159D-05   7.7103D-05  -1.2953D-04   7.7388D-05   2.9905D-05  -3.1010D-05  -1.0195D-05  
D  DSS61     NHY  CHEB_0     3.3893D-10  -6.7501D-11  -7.1191D-11  -2.4027D-11  -2.7907D-11  -2.1556D-11   3.1714D-11  -5.3094D-12   2.6657D-12  
D  DSS61     NHY  CHEB_1     2.0939D-11  -3.6591D-12  -3.3926D-12  -1.4864D-12  -1.8894D-12  -1.4105D-12   1.7997D-12  -3.9203D-13  -1.9343D-13  
D  DSS61     NHY  CHEB_2     3.8967D-12  -6.5982D-13  -5.8577D-13  -2.7385D-13  -3.5798D-13  -2.8636D-13   3.1473D-13  -6.6411D-14  -5.0309D-14  
D  DSS61     NHY  CHEB_3    -3.2774D-13   7.0799D-14   7.7155D-14   2.1155D-14   2.2463D-14   1.5253D-14  -3.6541D-14   5.2763D-15  -5.5663D-15  
D  DSS61     NHY  CHEB_4    -5.3165D-14   1.1686D-14   1.0550D-14   2.8540D-15   5.7196D-15   3.4208D-15  -5.4795D-15   3.8105D-16  -4.1253D-17  
D  DSS61     NHY  CHEB_5    -8.2499D-15   1.7147D-15   1.5234D-15   1.3637D-16  -3.2884D-16   1.7329D-16  -9.3519D-16  -4.0031D-16   4.0297D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS161    HYD  DER_NORT   6.9982D-05  -2.5643D-06  -1.6267D-05   8.6137D-06   1.2399D-05  -2.3438D-05   1.8714D-05   1.2663D-06   1.4134D-06  
D  DSS161    HYD  DER_EAST  -1.4963D-05  -1.7204D-05  -2.4234D-05   6.9513D-06  -1.8814D-05  -1.2557D-05   1.7340D-05   1.6746D-06  -4.7752D-07  
D  DSS161    HYD  CHEB_0     7.0737D-09   3.1465D-11   3.9000D-12   1.7565D-11  -5.4332D-13   9.9803D-12  -6.0441D-12   2.5105D-13  -3.9479D-12  
D  DSS161    HYD  CHEB_1    -3.5163D-12   9.9858D-12   7.9889D-12  -1.7822D-12  -2.0079D-12   6.6160D-13  -4.7953D-13   5.7634D-14  -7.9303D-13  
D  DSS161    HYD  CHEB_2    -2.8143D-12   1.4099D-12   1.2331D-12  -2.9282D-13  -3.1100D-13   6.6907D-14  -4.0029D-14   1.9477D-14  -1.4708D-13  
D  DSS161    HYD  CHEB_3    -1.6483D-12  -2.5295D-13  -1.8309D-13   3.1192D-14   6.0056D-14  -9.8004D-15   3.0379D-15  -7.0595D-15   8.0633D-15  
D  DSS161    HYD  CHEB_4    -6.4765D-13   8.8523D-15  -8.2769D-15   1.9105D-15  -2.0789D-15   1.2957D-15  -1.3845D-15  -1.3558D-15  -1.0524D-15  
D  DSS161    HYD  CHEB_5    -9.5172D-14  -2.9410D-15  -2.7608D-15   2.0265D-15  -3.8281D-15  -2.4420D-15   4.3741D-15   9.2670D-16   8.5960D-16  
#
D  DSS161    NHY  DER_NORT  -6.7122D-04   1.6954D-04  -1.5695D-04  -2.8341D-05  -1.5627D-04   1.3377D-04   3.1530D-04   6.8437D-06  -2.1295D-04  
D  DSS161    NHY  DER_EAST  -6.2162D-05  -3.1284D-04  -8.6328D-05   7.7053D-05  -1.2940D-04   7.7330D-05   2.9838D-05  -3.0776D-05  -1.0335D-05  
D  DSS161    NHY  CHEB_0     3.3939D-10  -6.7524D-11  -7.1241D-11  -2.4057D-11  -2.7960D-11  -2.1583D-11   3.1749D-11  -5.3233D-12   2.6274D-12  
D  DSS161    NHY  CHEB_1     2.0961D-11  -3.6582D-12  -3.3931D-12  -1.4876D-12  -1.8922D-12  -1.4115D-12   1.8015D-12  -3.9279D-13  -1.9690D-13  
D  DSS161    NHY  CHEB_2     3.9003D-12  -6.5924D-13  -5.8581D-13  -2.7406D-13  -3.5838D-13  -2.8699D-13   3.1478D-13  -6.6715D-14  -5.0839D-14  
D  DSS161    NHY  CHEB_3    -3.2829D-13   7.0785D-14   7.7416D-14   2.1202D-14   2.2441D-14   1.5729D-14  -3.6386D-14   5.3822D-15  -5.8081D-15  
D  DSS161    NHY  CHEB_4    -5.3274D-14   1.1862D-14   1.0536D-14   2.7711D-15   5.7434D-15   3.0836D-15  -5.6633D-15   2.6512D-16   1.2302D-16  
D  DSS161    NHY  CHEB_5    -8.2805D-15   1.5816D-15   1.4752D-15   2.1801D-16  -2.7661D-16   4.3793D-16  -8.1585D-16  -3.1425D-16   2.9800D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS62     HYD  DER_NORT   6.8781D-05  -2.5474D-06  -1.7201D-05   8.3638D-06   1.1174D-05  -2.3583D-05   1.8757D-05   1.6606D-06   1.4484D-06  
D  DSS62     HYD  DER_EAST  -1.7658D-05  -1.7314D-05  -2.4892D-05   6.8269D-06  -1.9014D-05  -1.2428D-05   1.7276D-05   1.8907D-06  -5.1931D-07  
D  DSS62     HYD  CHEB_0     7.1160D-09   3.3118D-11   4.9133D-12   1.7731D-11  -6.4256D-13   1.0190D-11  -6.1271D-12  -1.2138D-13  -4.5355D-12  
D  DSS62     HYD  CHEB_1    -4.4370D-12   1.0055D-11   7.9781D-12  -1.7453D-12  -2.0164D-12   6.3874D-13  -4.2810D-13   2.8115D-14  -8.3677D-13  
D  DSS62     HYD  CHEB_2    -2.9118D-12   1.4300D-12   1.2463D-12  -2.9462D-13  -3.1533D-13   7.0023D-14  -4.5123D-14   1.1982D-14  -1.5580D-13  
D  DSS62     HYD  CHEB_3    -1.6493D-12  -2.5760D-13  -1.8686D-13   3.3237D-14   6.0066D-14  -1.1631D-14   6.3492D-15  -6.3886D-15   8.2784D-15  
D  DSS62     HYD  CHEB_4    -6.5143D-13   6.5839D-15  -9.7157D-15   3.1772D-15  -2.1092D-15   9.3387D-16  -1.6755D-15  -2.4617D-15  -1.6295D-15  
D  DSS62     HYD  CHEB_5    -9.1838D-14  -1.5196D-15  -9.3604D-16   1.0831D-15  -2.6746D-15  -1.1013D-16   3.4144D-15   3.1015D-15   2.4542D-15  
#
D  DSS62     NHY  DER_NORT  -6.2430D-04   1.4128D-04  -1.9412D-04  -5.5750D-05  -1.7954D-04   1.4303D-04   2.7942D-04   3.1475D-05  -1.9818D-04  
D  DSS62     NHY  DER_EAST  -1.6256D-04  -3.1180D-04  -1.1102D-04   7.6061D-05  -1.3678D-04   1.1910D-04   1.4387D-05  -1.6750D-05  -9.1710D-06  
D  DSS62     NHY  CHEB_0     3.4795D-10  -6.7421D-11  -7.1907D-11  -2.4695D-11  -2.8903D-11  -2.2187D-11   3.2280D-11  -5.7777D-12   2.1030D-12  
D  DSS62     NHY  CHEB_1     2.1255D-11  -3.5338D-12  -3.3884D-12  -1.5145D-12  -1.9337D-12  -1.4576D-12   1.8571D-12  -4.2148D-13  -2.6923D-13  
D  DSS62     NHY  CHEB_2     3.9503D-12  -6.3456D-13  -5.8452D-13  -2.8106D-13  -3.6812D-13  -2.9624D-13   3.1966D-13  -7.3777D-14  -6.5157D-14  
D  DSS62     NHY  CHEB_3    -3.3883D-13   6.7468D-14   7.9426D-14   2.2510D-14   2.3870D-14   2.1294D-14  -3.5917D-14   6.6840D-15  -7.6019D-15  
D  DSS62     NHY  CHEB_4    -5.3293D-14   1.2549D-14   1.1560D-14   2.6780D-15   3.2779D-15  -6.7344D-16  -6.7190D-15  -1.4518D-15   1.8569D-15  
D  DSS62     NHY  CHEB_5    -9.3319D-15   1.4148D-16   6.8732D-16   1.0283D-15   1.5764D-15   4.0025D-15   7.6958D-16   8.4195D-16  -1.2204D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS63     HYD  DER_NORT   7.0468D-05  -2.5123D-06  -1.6297D-05   8.6751D-06   1.2425D-05  -2.3485D-05   1.8751D-05   1.1179D-06   1.2604D-06  
D  DSS63     HYD  DER_EAST  -1.4781D-05  -1.7231D-05  -2.4248D-05   7.0106D-06  -1.8872D-05  -1.2605D-05   1.7419D-05   1.6140D-06  -5.1093D-07  
D  DSS63     HYD  CHEB_0     7.0511D-09   3.0644D-11   3.5162D-12   1.7506D-11  -4.4381D-13   9.9012D-12  -6.0304D-12   3.2953D-13  -3.7060D-12  
D  DSS63     HYD  CHEB_1    -3.0641D-12   9.9352D-12   7.9645D-12  -1.7835D-12  -2.0021D-12   6.5863D-13  -4.8151D-13   6.3356D-14  -7.7417D-13  
D  DSS63     HYD  CHEB_2    -2.7307D-12   1.4028D-12   1.2312D-12  -2.9262D-13  -3.0993D-13   6.7389D-14  -4.0420D-14   2.2388D-14  -1.4282D-13  
D  DSS63     HYD  CHEB_3    -1.6536D-12  -2.5213D-13  -1.8206D-13   2.9821D-14   5.9088D-14  -1.0388D-14   2.8802D-15  -8.0565D-15   7.8255D-15  
D  DSS63     HYD  CHEB_4    -6.4365D-13   8.6635D-15  -8.0765D-15   2.5600D-15  -1.3758D-15   1.7676D-15  -1.1866D-15   2.6715D-16  -4.0443D-16  
D  DSS63     HYD  CHEB_5    -9.7769D-14  -2.8893D-15  -3.0085D-15   1.3896D-15  -4.3733D-15  -2.7820D-15   4.3336D-15  -4.2435D-16   1.1445D-16  
#
D  DSS63     NHY  DER_NORT  -6.6149D-04   1.6868D-04  -1.5634D-04  -2.9987D-05  -1.5952D-04   1.3406D-04   3.1359D-04   2.4937D-06  -2.1527D-04  
D  DSS63     NHY  DER_EAST  -5.6614D-05  -3.1075D-04  -8.5372D-05   7.6936D-05  -1.3078D-04   7.7682D-05   3.0029D-05  -3.2595D-05  -9.0830D-06  
D  DSS63     NHY  CHEB_0     3.3540D-10  -6.7338D-11  -7.0796D-11  -2.3792D-11  -2.7493D-11  -2.1341D-11   3.1435D-11  -5.2107D-12   2.9674D-12  
D  DSS63     NHY  CHEB_1     2.0761D-11  -3.6672D-12  -3.3882D-12  -1.4757D-12  -1.8661D-12  -1.4019D-12   1.7845D-12  -3.8684D-13  -1.6688D-13  
D  DSS63     NHY  CHEB_2     3.8682D-12  -6.6432D-13  -5.8462D-13  -2.7217D-13  -3.5559D-13  -2.8091D-13   3.1429D-13  -6.4636D-14  -4.6312D-14  
D  DSS63     NHY  CHEB_3    -3.2379D-13   7.0779D-14   7.4771D-14   2.0817D-14   2.3141D-14   1.1452D-14  -3.7657D-14   4.7581D-15  -3.9857D-15  
D  DSS63     NHY  CHEB_4    -5.1949D-14   1.0188D-14   1.0903D-14   3.4272D-15   5.1296D-15   6.2576D-15  -4.0191D-15   1.0614D-15  -1.0623D-15  
D  DSS63     NHY  CHEB_5    -8.4013D-15   2.4995D-15   1.6283D-15  -3.6551D-16  -2.8079D-16  -1.6657D-15  -1.7283D-15  -7.8994D-16   1.1123D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS65     HYD  DER_NORT   6.9932D-05  -2.5732D-06  -1.6253D-05   8.6054D-06   1.2413D-05  -2.3427D-05   1.8710D-05   1.2874D-06   1.4416D-06  
D  DSS65     HYD  DER_EAST  -1.5027D-05  -1.7203D-05  -2.4236D-05   6.9452D-06  -1.8803D-05  -1.2551D-05   1.7332D-05   1.6827D-06  -4.7461D-07  
D  DSS65     HYD  CHEB_0     7.0766D-09   3.1572D-11   3.9499D-12   1.7574D-11  -5.5423D-13   9.9888D-12  -6.0432D-12   2.4187D-13  -3.9763D-12  
D  DSS65     HYD  CHEB_1    -3.5768D-12   9.9916D-12   7.9908D-12  -1.7819D-12  -2.0096D-12   6.6143D-13  -4.7840D-13   5.7195D-14  -7.9512D-13  
D  DSS65     HYD  CHEB_2    -2.8247D-12   1.4111D-12   1.2336D-12  -2.9296D-13  -3.1105D-13   6.6942D-14  -4.0165D-14   1.9140D-14  -1.4757D-13  
D  DSS65     HYD  CHEB_3    -1.6478D-12  -2.5315D-13  -1.8329D-13   3.1368D-14   6.0133D-14  -9.8183D-15   3.1352D-15  -6.9221D-15   8.0876D-15  
D  DSS65     HYD  CHEB_4    -6.4802D-13   8.8735D-15  -8.2745D-15   1.8463D-15  -2.1780D-15   1.2590D-15  -1.4482D-15  -1.5560D-15  -1.1235D-15  
D  DSS65     HYD  CHEB_5    -9.4748D-14  -2.9439D-15  -2.6842D-15   2.0845D-15  -3.7381D-15  -2.3720D-15   4.3784D-15   1.1410D-15   9.8649D-16  
#
D  DSS65     NHY  DER_NORT  -6.7276D-04   1.6941D-04  -1.5698D-04  -2.8221D-05  -1.5519D-04   1.3353D-04   3.1610D-04   7.5115D-06  -2.1287D-04  
D  DSS65     NHY  DER_EAST  -6.5101D-05  -3.1251D-04  -8.6380D-05   7.7396D-05  -1.2929D-04   7.7954D-05   2.9968D-05  -3.0519D-05  -1.0393D-05  
D  DSS65     NHY  CHEB_0     3.3989D-10  -6.7530D-11  -7.1296D-11  -2.4093D-11  -2.8021D-11  -2.1616D-11   3.1792D-11  -5.3334D-12   2.5863D-12  
D  DSS65     NHY  CHEB_1     2.0986D-11  -3.6555D-12  -3.3946D-12  -1.4897D-12  -1.8957D-12  -1.4138D-12   1.8045D-12  -3.9286D-13  -2.0001D-13  
D  DSS65     NHY  CHEB_2     3.9045D-12  -6.5829D-13  -5.8581D-13  -2.7452D-13  -3.5895D-13  -2.8776D-13   3.1503D-13  -6.6898D-14  -5.1416D-14  
D  DSS65     NHY  CHEB_3    -3.2893D-13   7.0741D-14   7.7767D-14   2.1282D-14   2.2436D-14   1.6329D-14  -3.6262D-14   5.4951D-15  -5.9878D-15  
D  DSS65     NHY  CHEB_4    -5.3391D-14   1.2032D-14   1.0548D-14   2.6659D-15   5.7264D-15   2.6941D-15  -5.8550D-15   1.4516D-16   2.5045D-16  
D  DSS65     NHY  CHEB_5    -8.3083D-15   1.4304D-15   1.3991D-15   3.2180D-16  -1.8526D-16   7.5526D-16  -6.8723D-16  -2.1654D-16   2.0928D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  DSS66     HYD  DER_NORT   7.0197D-05  -2.5420D-06  -1.6296D-05   8.6397D-06   1.2396D-05  -2.3460D-05   1.8732D-05   1.2016D-06   1.3434D-06  
D  DSS66     HYD  DER_EAST  -1.4934D-05  -1.7221D-05  -2.4256D-05   6.9787D-06  -1.8845D-05  -1.2580D-05   1.7380D-05   1.6499D-06  -4.9370D-07  
D  DSS66     HYD  CHEB_0     7.0634D-09   3.1093D-11   3.7287D-12   1.7538D-11  -4.9415D-13   9.9460D-12  -6.0386D-12   2.8496D-13  -3.8384D-12  
D  DSS66     HYD  CHEB_1    -3.3132D-12   9.9624D-12   7.9766D-12  -1.7821D-12  -2.0055D-12   6.5964D-13  -4.7932D-13   5.9765D-14  -7.8474D-13  
D  DSS66     HYD  CHEB_2    -2.7749D-12   1.4068D-12   1.2325D-12  -2.9285D-13  -3.1051D-13   6.7176D-14  -4.0388D-14   2.0890D-14  -1.4502D-13  
D  DSS66     HYD  CHEB_3    -1.6508D-12  -2.5262D-13  -1.8269D-13   3.0577D-14   5.9554D-14  -1.0156D-14   3.0657D-15  -7.5535D-15   7.9337D-15  
D  DSS66     HYD  CHEB_4    -6.4598D-13   8.7455D-15  -8.1786D-15   2.2258D-15  -1.7329D-15   1.5267D-15  -1.3227D-15  -6.3263D-16  -7.8198D-16  
D  DSS66     HYD  CHEB_5    -9.6409D-14  -2.8318D-15  -2.8574D-15   1.7133D-15  -4.0980D-15  -2.5647D-15   4.3482D-15   2.2486D-16   4.7292D-16  
#
D  DSS66     NHY  DER_NORT  -6.6628D-04   1.6840D-04  -1.5740D-04  -2.9599D-05  -1.5804D-04   1.3405D-04   3.1401D-04   5.1568D-06  -2.1388D-04  
D  DSS66     NHY  DER_EAST  -6.2062D-05  -3.1162D-04  -8.6331D-05   7.7083D-05  -1.3023D-04   7.8400D-05   2.9807D-05  -3.1308D-05  -9.6176D-06  
D  DSS66     NHY  CHEB_0     3.3758D-10  -6.7425D-11  -7.1035D-11  -2.3939D-11  -2.7749D-11  -2.1476D-11   3.1605D-11  -5.2744D-12   2.7852D-12  
D  DSS66     NHY  CHEB_1     2.0869D-11  -3.6596D-12  -3.3905D-12  -1.4826D-12  -1.8806D-12  -1.4079D-12   1.7945D-12  -3.9041D-13  -1.8361D-13  
D  DSS66     NHY  CHEB_2     3.8854D-12  -6.6125D-13  -5.8549D-13  -2.7320D-13  -3.5686D-13  -2.8438D-13   3.1462D-13  -6.5681D-14  -4.8693D-14  
D  DSS66     NHY  CHEB_3    -3.2616D-13   7.0731D-14   7.6233D-14   2.0979D-14   2.2648D-14   1.3753D-14  -3.7007D-14   4.9938D-15  -4.9887D-15  
D  DSS66     NHY  CHEB_4    -5.2715D-14   1.1120D-14   1.0674D-14   3.1549D-15   5.5307D-15   4.4969D-15  -4.9010D-15   6.8916D-16  -4.1509D-16  
D  DSS66     NHY  CHEB_5    -8.2797D-15   2.0855D-15   1.6216D-15  -1.1778D-16  -4.0058D-16  -6.0973D-16  -1.2741D-15  -6.2047D-16   6.6255D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  EFLSBERG  HYD  DER_NORT   1.2053D-04   4.8556D-05  -2.4462D-05   3.6255D-05   4.1938D-06  -7.4478D-06   1.1990D-05   9.9263D-08   2.1920D-07  
D  EFLSBERG  HYD  DER_EAST   7.3545D-06  -1.9290D-05  -1.6917D-05   6.7108D-06  -1.7224D-05  -1.2925D-05  -6.2352D-07   2.4145D-06  -2.8949D-07  
D  EFLSBERG  HYD  CHEB_0     7.3981D-09   1.7963D-11   1.9188D-12   6.8491D-12  -5.3925D-12   1.2484D-11  -1.5491D-11  -6.4269D-13  -1.1928D-12  
D  EFLSBERG  HYD  CHEB_1    -3.4137D-12   1.0591D-11   5.7438D-12  -3.7332D-13   7.6902D-13  -5.4597D-13  -5.8889D-13  -6.9627D-14  -4.7628D-13  
D  EFLSBERG  HYD  CHEB_2    -2.8343D-12   1.2857D-12   8.3932D-13  -4.0958D-14   2.2791D-13  -1.3342D-13  -9.4228D-14  -1.2591D-14  -7.9341D-14  
D  EFLSBERG  HYD  CHEB_3    -1.7031D-12  -3.2218D-13  -1.6411D-13   2.3304D-14  -2.9946D-16   5.1303D-15   1.6493D-14  -2.0682D-15   5.8104D-15  
D  EFLSBERG  HYD  CHEB_4    -6.8344D-13   2.7462D-14   1.6030D-18  -6.5119D-16  -5.3138D-15   1.8121D-15   3.7103D-15  -1.1701D-15  -5.7250D-16  
D  EFLSBERG  HYD  CHEB_5    -9.8535D-14  -3.4647D-15   1.7888D-15  -2.1363D-16  -6.1562D-16  -1.7651D-15   4.2905D-16   2.4952D-15   1.3798D-15  
#
D  EFLSBERG  NHY  DER_NORT   7.0530D-04  -3.5722D-05  -2.5127D-04   3.9236D-05   5.8017D-05  -1.2908D-04   1.5936D-04  -7.3576D-05   4.6293D-05  
D  EFLSBERG  NHY  DER_EAST  -4.1531D-04  -2.3601D-04  -9.4686D-05   6.8965D-05  -5.9756D-05  -2.9670D-04  -1.6546D-04  -2.8669D-07   7.8370D-05  
D  EFLSBERG  NHY  CHEB_0     3.7115D-10  -1.2798D-10  -8.2441D-11   1.5589D-11  -1.8347D-12  -2.2789D-12   3.0757D-11  -5.1095D-12   7.0342D-12  
D  EFLSBERG  NHY  CHEB_1     2.2363D-11  -7.3019D-12  -4.4431D-12   1.0418D-12   4.6828D-14  -3.1657D-13   1.6326D-12  -3.6009D-13   1.6448D-13  
D  EFLSBERG  NHY  CHEB_2     4.0961D-12  -1.2982D-12  -7.5004D-13   1.9135D-13   1.3992D-14  -6.9119D-14   2.7664D-13  -6.7503D-14  -4.1496D-15  
D  EFLSBERG  NHY  CHEB_3    -3.8799D-13   1.4767D-13   1.0453D-13  -1.7846D-14  -6.0289D-16  -3.5085D-16  -3.7280D-14   9.3748D-15  -1.6446D-14  
D  EFLSBERG  NHY  CHEB_4    -5.6442D-14   1.6821D-14   1.2294D-14  -2.6856D-15   1.7406D-15   1.1540D-15  -7.2869D-15  -2.2987D-15  -1.8507D-15  
D  EFLSBERG  NHY  CHEB_5    -1.1431D-14   6.3940D-15  -9.0683D-17   8.7597D-17   2.6033D-16  -9.1563D-16   1.4330D-16   1.4678D-15   5.9072D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ELY       HYD  DER_NORT   6.9877D-05   2.3760D-05  -4.8737D-06  -9.3420D-06  -1.6515D-05  -1.1666D-05  -5.9528D-06   7.7234D-07   3.1376D-08  
D  ELY       HYD  DER_EAST   1.3110D-06  -3.3321D-05  -9.0839D-06   1.0636D-06   5.5770D-06  -1.8433D-06  -5.8491D-06   2.0491D-06  -5.1065D-07  
D  ELY       HYD  CHEB_0     6.1887D-09   8.7787D-12  -8.1548D-12   7.6438D-12   3.4083D-12  -1.7534D-12  -1.4429D-12   3.8755D-12   2.6096D-12  
D  ELY       HYD  CHEB_1     9.6793D-12   1.1612D-11   4.9315D-12  -1.8005D-12  -1.9869D-12   1.3698D-12   1.1850D-12   7.5579D-13   2.8161D-13  
D  ELY       HYD  CHEB_2    -9.2484D-14   1.9946D-12   8.2487D-13  -2.8096D-13  -2.9102D-13   2.8549D-13   1.9112D-13   1.4101D-13   6.1343D-14  
D  ELY       HYD  CHEB_3    -1.7200D-12  -2.2446D-13  -1.0639D-13   4.8243D-14   6.2523D-14  -6.1784D-15  -2.4763D-14  -9.4806D-15  -6.3835D-15  
D  ELY       HYD  CHEB_4    -6.0171D-13  -1.1701D-14  -3.9556D-15  -1.8042D-17  -2.1632D-15  -2.5463D-15  -4.2366D-15   8.2093D-18   8.4743D-17  
D  ELY       HYD  CHEB_5    -6.3947D-14   2.4814D-15  -1.8250D-15   1.1012D-15   1.1951D-15  -2.2896D-15   3.9112D-16   8.6167D-17  -2.5204D-16  
#
D  ELY       NHY  DER_NORT  -4.9202D-04  -2.1702D-04  -3.9723D-04  -5.9073D-04   7.6042D-04  -2.6759D-04  -9.0735D-04  -8.0895D-05   1.4251D-04  
D  ELY       NHY  DER_EAST   4.9688D-04  -6.2840D-04  -6.1864D-04  -2.2515D-04   8.0998D-04   4.0321D-04  -5.5061D-04  -1.4296D-04   3.1467D-04  
D  ELY       NHY  CHEB_0     1.9665D-10  -7.6522D-11  -3.5166D-11   7.1212D-12   3.4206D-11  -1.3777D-11  -2.8490D-11  -3.5850D-12  -2.7142D-12  
D  ELY       NHY  CHEB_1     1.1997D-11  -3.9637D-12  -1.8066D-12  -1.4204D-14   1.9421D-12  -6.9690D-13  -1.5599D-12   1.9555D-13   9.7166D-14  
D  ELY       NHY  CHEB_2     2.2523D-12  -6.9110D-13  -3.1886D-13  -3.5379D-14   3.4838D-13  -1.1841D-13  -2.7401D-13   6.2685D-14   4.1521D-14  
D  ELY       NHY  CHEB_3    -1.8106D-13   8.6147D-14   3.8340D-14  -1.6036D-14  -3.6167D-14   1.7024D-14   3.3015D-14   8.7800D-15   8.3223D-15  
D  ELY       NHY  CHEB_4    -2.8678D-14   1.2422D-14   3.7432D-15  -2.5870D-15  -4.9190D-15   1.6290D-15   3.6721D-15   1.3218D-15   3.6308D-16  
D  ELY       NHY  CHEB_5    -6.1597D-15   2.8332D-15   1.6837D-15   1.4176D-16  -1.0590D-15   1.2455D-15   1.4307D-15  -6.3738D-16  -1.9737D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FD-VLBA   HYD  DER_NORT   1.0437D-04   6.9512D-05   3.1693D-05  -2.3665D-05  -1.4019D-05   4.8751D-07   1.1200D-05  -3.5708D-07   1.3223D-06  
D  FD-VLBA   HYD  DER_EAST   9.0168D-06   7.9870D-06   5.3245D-06  -9.3359D-07   3.1233D-06   1.6568D-05   1.5055D-06   5.8154D-07   6.8913D-07  
D  FD-VLBA   HYD  CHEB_0     6.4027D-09   3.7314D-12  -7.0388D-12   6.7749D-12   3.2921D-12  -1.0660D-12  -2.1009D-12   3.3971D-12   2.4017D-12  
D  FD-VLBA   HYD  CHEB_1    -1.5825D-12   8.3163D-12   4.6241D-12   6.2840D-13  -4.4029D-13   7.5219D-13   2.0697D-13   6.0812D-13   1.5135D-13  
D  FD-VLBA   HYD  CHEB_2    -2.0110D-12   1.3805D-12   7.1461D-13   1.1980D-13  -2.5719D-14   1.6138D-13   6.7573D-14   1.0205D-13   2.8561D-14  
D  FD-VLBA   HYD  CHEB_3    -1.5432D-12  -1.8082D-13  -1.2456D-13   8.8482D-15   4.1237D-14   9.8645D-16  -4.4710D-15  -9.6984D-15  -2.2276D-15  
D  FD-VLBA   HYD  CHEB_4    -5.9390D-13  -3.2770D-15  -3.9979D-15  -6.0837D-16  -2.0264D-15  -9.4238D-16  -4.1717D-16   1.8879D-15   4.9386D-16  
D  FD-VLBA   HYD  CHEB_5    -7.5384D-14   1.7902D-15   1.8692D-15  -3.1379D-15  -8.9256D-16   7.5885D-18  -3.2548D-16  -7.9404D-16  -1.9489D-16  
#
D  FD-VLBA   NHY  DER_NORT   1.4985D-03   3.6244D-04  -4.1892D-04  -5.0261D-04   2.0112D-04  -2.5042D-04   3.7609D-04  -1.3119D-04  -3.4175D-04  
D  FD-VLBA   NHY  DER_EAST  -1.4184D-04   1.8406D-04   6.0906D-04  -4.3026D-04  -5.7702D-04   2.8559D-04   4.3643D-04  -1.4881D-04   3.3400D-04  
D  FD-VLBA   NHY  CHEB_0     3.2141D-10  -1.8953D-10  -1.0539D-10   1.7386D-11   7.4237D-11   2.7788D-11   1.2636D-13  -3.5763D-12  -1.8025D-12  
D  FD-VLBA   NHY  CHEB_1     1.9713D-11  -1.0781D-11  -6.3306D-12   5.8972D-13   3.7596D-12   1.4838D-12   3.8277D-13   5.5957D-13  -1.1508D-13  
D  FD-VLBA   NHY  CHEB_2     3.7183D-12  -1.9434D-12  -1.1737D-12   6.0666D-14   6.4405D-13   2.7908D-13   1.1263D-13   1.6631D-13  -5.6762D-14  
D  FD-VLBA   NHY  CHEB_3    -2.9298D-13   1.9778D-13   1.0689D-13  -2.6194D-14  -8.8555D-14  -2.7476D-14   1.2198D-14   1.8724D-14  -1.2914D-14  
D  FD-VLBA   NHY  CHEB_4    -4.5030D-14   2.5922D-14   1.7095D-14  -2.0303D-15  -1.2104D-14  -3.5854D-15  -4.4593D-16  -2.6438D-15   1.9328D-15  
D  FD-VLBA   NHY  CHEB_5    -1.0366D-14   4.9600D-15   3.6864D-15   2.8773D-16  -2.5780D-15  -1.9700D-15   1.3269D-16   1.0487D-15  -6.9741D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FLAGSTAF  HYD  DER_NORT   7.5599D-05   3.5519D-05   5.8002D-07  -2.7347D-05  -2.2242D-05  -5.2721D-06   7.4132D-06   6.1860D-07   2.4562D-06  
D  FLAGSTAF  HYD  DER_EAST   9.0199D-06  -1.3978D-05  -5.3052D-06  -4.4416D-06   1.0187D-06   6.5022D-06   2.9809D-06  -5.5022D-08  -9.6405D-07  
D  FLAGSTAF  HYD  CHEB_0     6.0044D-09  -5.8073D-12  -1.0336D-11   5.7476D-12   4.6576D-12  -4.3481D-12  -3.0985D-12   1.8203D-12   1.7832D-12  
D  FLAGSTAF  HYD  CHEB_1     1.0135D-11   1.0179D-11   5.2647D-12  -1.2482D-12  -1.3272D-12   1.2891D-12   8.5564D-13   5.4525D-13   1.8213D-13  
D  FLAGSTAF  HYD  CHEB_2    -1.2465D-13   1.6738D-12   8.5435D-13  -1.8982D-13  -1.5211D-13   2.9114D-13   1.3838D-13   1.0091D-13   3.9337D-14  
D  FLAGSTAF  HYD  CHEB_3    -1.6623D-12  -1.9629D-13  -1.2446D-13   2.5375D-14   4.0546D-14  -6.3457D-16  -1.6078D-14  -1.0809D-14   7.6677D-16  
D  FLAGSTAF  HYD  CHEB_4    -5.3918D-13   8.1342D-15  -2.3777D-15  -2.6051D-15  -2.4563D-15  -5.5074D-15  -1.7549D-15  -9.2148D-16  -8.7129D-16  
D  FLAGSTAF  HYD  CHEB_5    -9.0923D-14  -9.2266D-15   9.6995D-16   4.4436D-15  -6.5704D-16   3.9963D-17   1.3395D-15   7.3683D-16   3.5631D-17  
#
D  FLAGSTAF  NHY  DER_NORT   2.1740D-04  -1.1819D-03  -6.0227D-04  -4.5387D-05   8.4096D-04   6.9703D-04   1.5548D-04  -9.8230D-05   2.3544D-04  
D  FLAGSTAF  NHY  DER_EAST   4.7799D-04  -9.5293D-04  -7.3141D-05   6.0458D-04  -2.5752D-04   4.4999D-04   3.5757D-04   3.7975D-05  -1.4554D-04  
D  FLAGSTAF  NHY  CHEB_0     2.0344D-10  -1.2522D-10  -6.7855D-11   1.5929D-11   7.3072D-11   1.0219D-11  -4.7880D-11  -7.4216D-12   1.1969D-12  
D  FLAGSTAF  NHY  CHEB_1     1.2938D-11  -7.2357D-12  -4.2107D-12   5.1277D-13   4.5082D-12   7.0837D-13  -2.8091D-12   3.1069D-14   2.9349D-13  
D  FLAGSTAF  NHY  CHEB_2     2.4418D-12  -1.2902D-12  -7.6947D-13   5.6109D-14   8.1221D-13   1.2857D-13  -4.8783D-13   6.5847D-14   5.1221D-14  
D  FLAGSTAF  NHY  CHEB_3    -1.8538D-13   1.4063D-13   7.1325D-14  -2.5414D-14  -8.3253D-14  -1.4701D-14   5.7910D-14   2.6141D-14  -4.4548D-15  
D  FLAGSTAF  NHY  CHEB_4    -2.9451D-14   1.8959D-14   1.0770D-14  -2.7866D-15  -1.1750D-14  -2.1059D-15   7.4545D-15   2.1791D-15  -7.8304D-16  
D  FLAGSTAF  NHY  CHEB_5    -4.6991D-15   2.6714D-15   8.1778D-16   1.0403D-16  -1.1588D-15  -3.6461D-16   2.8753D-17  -9.7539D-16   1.0193D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FORTLEZA  HYD  DER_NORT   1.5094D-05  -1.2392D-06  -1.3986D-06   4.6386D-07  -4.1961D-09   2.2327D-07  -5.0392D-07   2.5364D-06  -1.3341D-06  
D  FORTLEZA  HYD  DER_EAST   1.1273D-05  -2.5959D-06  -1.4862D-06   6.0757D-08  -2.8262D-08   3.1682D-07  -4.0601D-07  -4.1375D-07   1.4354D-06  
D  FORTLEZA  HYD  CHEB_0     7.6682D-09  -7.9953D-12  -3.6950D-12   4.9178D-12   4.4240D-12   9.9470D-13   1.3823D-12   2.5894D-12  -5.0050D-12  
D  FORTLEZA  HYD  CHEB_1    -3.9072D-11   3.1243D-13  -3.7509D-13   3.8277D-13   3.2212D-13  -1.9285D-13  -1.8583D-13   2.6293D-13  -6.3205D-13  
D  FORTLEZA  HYD  CHEB_2    -8.3748D-12  -2.0768D-14  -1.5101D-13   4.7894D-14   3.4822D-14  -2.2984D-14  -2.9605D-14   5.9522D-14  -7.7507D-14  
D  FORTLEZA  HYD  CHEB_3    -8.6971D-13  -1.6627D-14   1.0358D-14  -2.3230D-14  -8.2085D-15   5.0185D-15   3.8573D-15  -1.1988D-14   2.9144D-15  
D  FORTLEZA  HYD  CHEB_4    -6.8267D-13   9.0903D-15   1.1256D-14  -7.4299D-16   3.5227D-17  -2.3469D-17  -9.2923D-16   4.4085D-16  -1.2184D-15  
D  FORTLEZA  HYD  CHEB_5    -1.1438D-13  -2.8781D-15  -2.8740D-15  -3.1414D-16   5.7096D-18   2.3298D-16   2.1844D-16   4.9822D-16  -7.3895D-16  
#
D  FORTLEZA  NHY  DER_NORT  -8.3558D-05   5.9203D-04  -1.2013D-03   1.8350D-04  -4.4673D-04   1.7390D-04  -8.1622D-05  -1.1208D-03   5.4493D-04  
D  FORTLEZA  NHY  DER_EAST  -9.2125D-04  -4.7906D-04   2.4518D-04  -3.7399D-05   2.2522D-04   1.1917D-04   3.1469D-05   4.8817D-04  -3.0676D-04  
D  FORTLEZA  NHY  CHEB_0     8.9917D-10   1.0506D-11   1.9132D-10  -2.6490D-11   4.2717D-13   7.4446D-12  -1.9158D-11  -1.9361D-11  -2.4927D-11  
D  FORTLEZA  NHY  CHEB_1     4.9671D-11  -9.6404D-13   3.7694D-12  -2.7337D-13   1.1371D-13   7.1777D-14   1.5962D-13  -1.8842D-12  -2.5734D-13  
D  FORTLEZA  NHY  CHEB_2     9.0242D-12  -6.4403D-14   1.4425D-13   3.9208D-14  -5.3952D-14  -6.7601D-14   6.9222D-14  -2.7435D-13   2.4306D-13  
D  FORTLEZA  NHY  CHEB_3    -9.6286D-13   3.4484D-14  -2.9522D-13   4.1992D-14  -1.4772D-14  -9.8299D-15   3.6518D-14   3.8865D-14   5.9962D-14  
D  FORTLEZA  NHY  CHEB_4    -1.4503D-13  -1.3628D-14  -4.9338D-16   1.6002D-15   9.2294D-15   4.4587D-15  -8.9671D-15   7.2353D-15  -3.6617D-14  
D  FORTLEZA  NHY  CHEB_5    -3.1514D-14  -4.7518D-15  -1.1322D-14   8.7307D-16  -3.6612D-15   9.1616D-15   2.9811D-15  -4.2545D-15   5.4405D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FORTORDS  HYD  DER_NORT   5.0950D-05   1.7892D-05   1.0345D-05  -5.2817D-06  -1.6817D-05   1.0272D-06  -1.3835D-05   1.4145D-06  -8.1798D-07  
D  FORTORDS  HYD  DER_EAST   1.7064D-05  -2.3692D-05  -1.3543D-05   6.0533D-06   1.6269D-05  -1.4686D-05  -1.2168D-06  -3.5876D-07   2.0882D-06  
D  FORTORDS  HYD  CHEB_0     7.4846D-09   3.2783D-11   1.3539D-11   8.0821D-12  -3.0340D-12   9.9830D-13  -3.3138D-12   6.9095D-13   2.5822D-12  
D  FORTORDS  HYD  CHEB_1    -1.7976D-11   1.0276D-11   5.7677D-12  -1.3218D-12  -1.2340D-12   8.8494D-13   1.1503D-12   3.3703D-13   1.9887D-13  
D  FORTORDS  HYD  CHEB_2    -5.0384D-12   1.5009D-12   8.6933D-13  -1.6995D-13  -1.6456D-13   2.0800D-13   1.7857D-13   3.4750D-14   3.5087D-14  
D  FORTORDS  HYD  CHEB_3    -1.3664D-12  -2.9957D-13  -1.6516D-13   4.6083D-14   4.8703D-14  -8.3564D-15  -3.1237D-14  -8.3009D-15  -4.9090D-15  
D  FORTORDS  HYD  CHEB_4    -6.6192D-13   7.4445D-15   6.1907D-15  -1.9064D-15  -7.4651D-15  -9.7807D-16  -1.6273D-15   3.6064D-15  -8.3600D-17  
D  FORTORDS  HYD  CHEB_5    -1.2618D-13  -8.1921D-16  -2.2064D-15  -2.6032D-15   2.9350D-15  -4.5089D-15  -3.3795D-16  -8.5258D-16  -1.1816D-15  
#
D  FORTORDS  NHY  DER_NORT  -1.0170D-03  -2.8183D-04  -5.4651D-04  -1.2547D-04   1.0310D-04   1.7235D-04  -4.4731D-05   1.1111D-04  -3.5444D-05  
D  FORTORDS  NHY  DER_EAST   1.2823D-03  -1.0879D-03  -1.5794D-04  -1.5188D-04   7.5944D-04   1.9181D-05  -1.8753D-04  -4.2586D-04  -1.1735D-04  
D  FORTORDS  NHY  CHEB_0     2.9630D-10  -3.9914D-11  -3.1860D-11  -7.6197D-12   1.2576D-11  -3.8089D-11  -1.4161D-11  -3.3855D-12   4.2920D-12  
D  FORTORDS  NHY  CHEB_1     1.7286D-11  -2.8442D-12  -1.9066D-12  -5.3074D-13   8.5706D-13  -2.0199D-12  -5.8397D-13  -3.1670D-13   1.9217D-13  
D  FORTORDS  NHY  CHEB_2     3.1974D-12  -5.8348D-13  -3.5883D-13  -8.7241D-14   1.8491D-13  -3.3955D-13  -1.1460D-13  -6.4088D-14   1.3680D-14  
D  FORTORDS  NHY  CHEB_3    -2.8363D-13   2.5625D-14   3.1662D-14   1.4846D-14  -4.6898D-15   4.4389D-14   3.9359D-15   1.2979D-15  -1.1779D-14  
D  FORTORDS  NHY  CHEB_4    -4.1511D-14   1.6553D-15   3.0271D-15   1.0782D-18  -1.3043D-15   1.0316D-14   2.7276D-15   2.6249D-15  -7.2600D-16  
D  FORTORDS  NHY  CHEB_5    -1.2625D-14   6.5806D-15   2.7579D-15  -6.3457D-16  -1.6022D-15  -2.0537D-15  -5.4556D-16  -1.2864D-15  -1.5183D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FORT_ORD  HYD  DER_NORT   4.9782D-05   1.6447D-05   1.0355D-05  -5.2142D-06  -1.6414D-05   8.7895D-07  -1.3521D-05   1.0625D-06  -9.1872D-07  
D  FORT_ORD  HYD  DER_EAST   1.5991D-05  -1.8886D-05  -1.2328D-05   6.3943D-06   1.5428D-05  -1.4029D-05  -1.4835D-06   4.1870D-06   7.0282D-07  
D  FORT_ORD  HYD  CHEB_0     7.6846D-09   3.5575D-11   1.5520D-11   8.8549D-12  -3.4316D-12   1.6867D-12  -3.1103D-12   3.1684D-12   2.0898D-12  
D  FORT_ORD  HYD  CHEB_1    -2.1934D-11   1.0354D-11   5.8504D-12  -1.2757D-12  -1.2743D-12   9.4484D-13   1.1505D-12   5.7274D-13   1.2111D-13  
D  FORT_ORD  HYD  CHEB_2    -5.7224D-12   1.4620D-12   8.5907D-13  -1.4876D-13  -1.6013D-13   2.1432D-13   1.7412D-13   8.1029D-14   2.3473D-14  
D  FORT_ORD  HYD  CHEB_3    -1.2985D-12  -3.0829D-13  -1.6784D-13   4.5019D-14   4.6654D-14  -8.0433D-15  -3.3087D-14  -6.9652D-15  -5.3686D-15  
D  FORT_ORD  HYD  CHEB_4    -6.8659D-13   5.6703D-15   3.3164D-15  -2.1784D-15  -4.7778D-15  -4.1309D-15  -1.9619D-15   4.0411D-15  -2.4516D-15  
D  FORT_ORD  HYD  CHEB_5    -1.3128D-13  -2.1695D-15  -5.1149D-16  -3.1518D-15   2.4487D-15  -3.4028D-15   4.4333D-16  -5.6404D-16   4.6177D-16  
#
D  FORT_ORD  NHY  DER_NORT  -8.8601D-04  -2.6478D-04  -4.8088D-04  -1.4063D-04   1.1024D-04   1.7776D-04  -6.0037D-05   8.7963D-05  -3.1738D-05  
D  FORT_ORD  NHY  DER_EAST   1.3037D-03  -1.0185D-03  -1.0390D-04  -1.6154D-04   7.1046D-04   3.8231D-05  -2.0808D-04  -3.1864D-04  -1.9848D-04  
D  FORT_ORD  NHY  CHEB_0     3.3606D-10  -4.6783D-11  -3.5413D-11  -8.4768D-12   1.4617D-11  -4.0892D-11  -1.5620D-11  -3.1838D-13   3.0558D-12  
D  FORT_ORD  NHY  CHEB_1     1.9535D-11  -3.2812D-12  -2.0903D-12  -5.6013D-13   9.7729D-13  -2.0639D-12  -7.0041D-13  -1.3698D-14   3.5601D-14  
D  FORT_ORD  NHY  CHEB_2     3.5870D-12  -6.6883D-13  -3.8838D-13  -8.2307D-14   2.0816D-13  -3.4090D-13  -1.3945D-13  -1.5256D-14  -1.1532D-14  
D  FORT_ORD  NHY  CHEB_3    -3.2893D-13   2.7788D-14   3.1801D-14   1.5497D-14  -5.5303D-15   5.2235D-14   2.8887D-15   8.8847D-16  -9.9347D-15  
D  FORT_ORD  NHY  CHEB_4    -5.1082D-14   5.8854D-15   6.4314D-15  -2.7496D-16  -1.0816D-15   8.5351D-15   4.3936D-15   1.1715D-15  -3.5675D-15  
D  FORT_ORD  NHY  CHEB_5    -1.1259D-14   5.2735D-15   1.2599D-15  -7.5974D-16  -2.5669D-15  -3.8655D-16  -2.0250D-16  -5.7410D-16   5.1870D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  FTD_7900  HYD  DER_NORT   1.0412D-04   6.9327D-05   3.1580D-05  -2.3584D-05  -1.3979D-05   4.7572D-07   1.1141D-05  -2.5902D-07   1.2665D-06  
D  FTD_7900  HYD  DER_EAST   9.1264D-06   7.8711D-06   5.2995D-06  -9.4010D-07   3.1131D-06   1.6503D-05   1.5191D-06   5.0426D-07   6.7586D-07  
D  FTD_7900  HYD  CHEB_0     6.4197D-09   4.2850D-12  -6.9300D-12   6.9106D-12   3.3200D-12  -9.9352D-13  -2.0845D-12   3.5798D-12   2.3917D-12  
D  FTD_7900  HYD  CHEB_1    -1.9380D-12   8.3579D-12   4.6304D-12   6.4005D-13  -4.3685D-13   7.5950D-13   2.0922D-13   6.2440D-13   1.4897D-13  
D  FTD_7900  HYD  CHEB_2    -2.0746D-12   1.3870D-12   7.1490D-13   1.2047D-13  -2.5874D-14   1.6257D-13   6.7927D-14   1.0569D-13   2.7849D-14  
D  FTD_7900  HYD  CHEB_3    -1.5377D-12  -1.8183D-13  -1.2514D-13   1.0065D-14   4.2059D-14   7.7519D-16  -4.4741D-15  -1.0212D-14  -2.2180D-15  
D  FTD_7900  HYD  CHEB_4    -5.9576D-13  -3.7318D-15  -4.1039D-15  -1.5378D-15  -2.5218D-15  -8.0716D-16  -5.9280D-16   2.1183D-15   3.2513D-16  
D  FTD_7900  HYD  CHEB_5    -7.3911D-14   1.6687D-15   1.7310D-15  -2.2978D-15  -2.0915D-16  -1.1694D-16  -3.6106D-16  -1.1256D-15  -1.9975D-16  
#
D  FTD_7900  NHY  DER_NORT   1.5024D-03   3.6270D-04  -4.1808D-04  -4.9908D-04   2.0033D-04  -2.5121D-04   3.7838D-04  -1.2619D-04  -3.4172D-04  
D  FTD_7900  NHY  DER_EAST  -1.3389D-04   1.8071D-04   6.1395D-04  -4.3211D-04  -5.7889D-04   2.8410D-04   4.3577D-04  -1.5115D-04   3.3327D-04  
D  FTD_7900  NHY  CHEB_0     3.2460D-10  -1.9117D-10  -1.0633D-10   1.7461D-11   7.4743D-11   2.7997D-11   2.4464D-13  -3.2572D-12  -1.8581D-12  
D  FTD_7900  NHY  CHEB_1     1.9866D-11  -1.0850D-11  -6.3691D-12   5.8949D-13   3.7724D-12   1.4929D-12   3.9292D-13   5.9256D-13  -1.2155D-13  
D  FTD_7900  NHY  CHEB_2     3.7425D-12  -1.9524D-12  -1.1796D-12   5.9099D-14   6.4485D-13   2.8093D-13   1.1582D-13   1.7410D-13  -5.8101D-14  
D  FTD_7900  NHY  CHEB_3    -2.9535D-13   1.9835D-13   1.0818D-13  -2.4893D-14  -8.8796D-14  -2.8372D-14   1.1182D-14   1.7325D-14  -1.2855D-14  
D  FTD_7900  NHY  CHEB_4    -4.6732D-14   2.7265D-14   1.7368D-14  -3.0195D-15  -1.2821D-14  -3.4050D-15   3.4011D-16  -1.4694D-15   1.9083D-15  
D  FTD_7900  NHY  CHEB_5    -9.8995D-15   4.1910D-15   3.7342D-15   1.1520D-15  -2.3424D-15  -2.5018D-15  -3.7890D-16   4.6266D-16  -9.0542D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GBT-VLBA  HYD  DER_NORT   1.4339D-04   7.9451D-05   2.1175D-05   1.5831D-06   3.0204D-05  -1.3019D-05   1.9280D-05   1.1033D-06   8.8488D-07  
D  GBT-VLBA  HYD  DER_EAST  -2.4667D-05   1.5328D-06  -3.1096D-05   3.2530D-06  -1.0357D-05   4.7510D-06  -4.8966D-06  -8.7772D-07   3.8478D-07  
D  GBT-VLBA  HYD  CHEB_0     7.0092D-09   2.5173D-12   8.6328D-13   9.2570D-12  -6.7414D-12   4.7588D-12  -5.8221D-12   2.2511D-12   2.0349D-13  
D  GBT-VLBA  HYD  CHEB_1    -2.9249D-12   1.2433D-11   7.2376D-12  -1.7681D-12   4.8807D-13  -2.6767D-12   2.2179D-12   4.8892D-13  -1.8521D-13  
D  GBT-VLBA  HYD  CHEB_2    -2.4732D-12   1.9227D-12   1.0452D-12  -2.7364D-13   1.2063D-13  -4.1608D-13   3.9454D-13   8.1826D-14  -6.6110D-14  
D  GBT-VLBA  HYD  CHEB_3    -1.5258D-12  -2.5247D-13  -1.7212D-13   4.1304D-14   3.0735D-14   5.1158D-14  -2.9537D-14  -8.2436D-15  -1.9229D-15  
D  GBT-VLBA  HYD  CHEB_4    -6.6508D-13   1.7496D-15   3.3244D-15   1.2386D-15   8.9495D-16   2.2115D-15  -2.6807D-17   1.1248D-15   1.3182D-16  
D  GBT-VLBA  HYD  CHEB_5    -9.0142D-14   3.7526D-16  -1.9971D-15  -1.9493D-15  -2.8308D-15   1.1612D-15  -1.1982D-15  -3.0129D-16   7.4038D-16  
#
D  GBT-VLBA  NHY  DER_NORT   4.7792D-04  -3.6374D-05   3.0348D-04   3.2038D-05   5.8392D-04  -1.5740D-04   3.8323D-04  -2.4147D-04  -1.3444D-04  
D  GBT-VLBA  NHY  DER_EAST  -9.2713D-04  -5.8822D-04  -5.2435D-04   1.5042D-04  -1.4985D-04   2.7626D-04  -1.1333D-04  -2.5648D-04  -5.2353D-05  
D  GBT-VLBA  NHY  CHEB_0     3.7681D-10  -1.9011D-10  -8.1408D-11   2.1265D-11   3.3768D-11   2.4743D-11  -2.6949D-11  -1.5240D-11   3.1102D-12  
D  GBT-VLBA  NHY  CHEB_1     2.1516D-11  -1.1025D-11  -4.3320D-12   1.0975D-12   1.6560D-12   1.1317D-12  -1.5271D-12  -6.5511D-13   4.7743D-14  
D  GBT-VLBA  NHY  CHEB_2     3.9772D-12  -2.0519D-12  -7.7979D-13   1.8192D-13   2.5650D-13   2.0094D-13  -2.7108D-13  -1.2407D-13   6.9003D-15  
D  GBT-VLBA  NHY  CHEB_3    -3.6176D-13   1.8420D-13   8.4672D-14  -2.7184D-14  -5.0327D-14  -2.2744D-14   3.1900D-14   1.5001D-14  -9.1308D-15  
D  GBT-VLBA  NHY  CHEB_4    -6.3137D-14   3.2068D-14   1.3215D-14  -4.2643D-15  -4.8596D-15  -2.2078D-15   6.9424D-15   3.8302D-15  -2.0818D-15  
D  GBT-VLBA  NHY  CHEB_5    -8.3646D-15   4.6347D-15   1.5971D-15   5.3956D-16  -5.7215D-16  -1.5042D-15  -5.0277D-16  -3.6414D-17   4.9174D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GGAO7108  HYD  DER_NORT   1.3663D-04   7.4331D-05   2.5156D-05   5.9281D-06   3.0611D-05  -1.1938D-05   1.7063D-05   7.6814D-07   2.4279D-06  
D  GGAO7108  HYD  DER_EAST  -1.4981D-05   4.7241D-06  -3.0543D-05   2.2577D-06  -4.8465D-06  -7.8355D-07  -2.3084D-06  -1.0592D-06   8.5717D-07  
D  GGAO7108  HYD  CHEB_0     7.6980D-09   2.9021D-11   1.1367D-11   5.9344D-12  -4.9913D-12   3.6093D-12  -2.9642D-12   5.0367D-12   1.8782D-13  
D  GGAO7108  HYD  CHEB_1    -1.6585D-11   1.4547D-11   8.7441D-12  -2.2145D-12   9.8219D-13  -2.7104D-12   2.6610D-12   7.4048D-13  -1.6885D-13  
D  GGAO7108  HYD  CHEB_2    -4.6486D-12   2.2966D-12   1.3267D-12  -3.4810D-13   2.8358D-13  -4.5587D-13   4.5958D-13   1.2676D-13  -3.6568D-14  
D  GGAO7108  HYD  CHEB_3    -1.4640D-12  -3.8974D-13  -2.5888D-13   5.0341D-14  -4.0774D-15   6.6570D-14  -6.6185D-14  -1.2444D-14   7.3114D-15  
D  GGAO7108  HYD  CHEB_4    -7.1067D-13   9.2118D-15  -1.9081D-15   1.7924D-15   5.3854D-16   5.8941D-15  -1.9995D-15  -1.1822D-15  -7.4802D-16  
D  GGAO7108  HYD  CHEB_5    -1.0144D-13   2.9775D-15   6.9182D-15  -1.2905D-15  -4.1619D-16  -2.2303D-15   1.3775D-15   2.4835D-16   2.8202D-16  
#
D  GGAO7108  NHY  DER_NORT   1.0743D-03   1.6947D-04   4.3834D-04  -4.9852D-05   7.2852D-04   7.8417D-05   1.4946D-04   1.0345D-04  -6.2364D-05  
D  GGAO7108  NHY  DER_EAST  -3.6188D-04  -1.2431D-04  -9.4973D-05   1.8621D-04  -3.3719D-04   5.9705D-05   2.0863D-04   1.7257D-04  -1.7441D-05  
D  GGAO7108  NHY  CHEB_0     4.7729D-10  -2.3889D-10  -1.2375D-10   3.6057D-11   3.3429D-11   2.5325D-11  -2.4179D-11  -7.5992D-12  -5.1267D-12  
D  GGAO7108  NHY  CHEB_1     2.6049D-11  -1.3365D-11  -6.3925D-12   1.6582D-12   1.2349D-12   1.5516D-12  -1.0330D-12  -2.8009D-13  -6.3530D-13  
D  GGAO7108  NHY  CHEB_2     4.6154D-12  -2.4002D-12  -1.1256D-12   3.0443D-13   2.0318D-13   2.7676D-13  -1.9489D-13  -2.3767D-14  -9.5259D-14  
D  GGAO7108  NHY  CHEB_3    -5.1753D-13   2.4685D-13   1.3113D-13  -2.9335D-14  -3.7902D-14  -3.4684D-14   2.0177D-14   1.5231D-14   2.6695D-14  
D  GGAO7108  NHY  CHEB_4    -6.6900D-14   2.5066D-14   1.5909D-14  -4.3243D-16  -1.7070D-15   6.7427D-16   2.0118D-15  -3.5934D-15   1.2936D-14  
D  GGAO7108  NHY  CHEB_5    -1.3785D-14   1.0464D-14   4.7942D-15  -2.5263D-15  -3.0430D-15  -2.7452D-15   1.9738D-15   1.7033D-15  -2.4697D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GIFU11    HYD  DER_NORT   1.3077D-04   6.4726D-05   3.8345D-05   4.0054D-06  -2.2670D-05  -1.3369D-06  -1.0423D-05  -2.2505D-06  -4.7617D-06  
D  GIFU11    HYD  DER_EAST   1.4211D-05  -3.4714D-06  -1.7352D-05  -1.2003D-06  -1.4620D-05   3.3472D-06  -4.8258D-07  -3.5172D-07   4.4546D-06  
D  GIFU11    HYD  CHEB_0     7.7025D-09   6.5474D-11   1.4359D-11  -1.3466D-12  -6.0292D-12  -5.8291D-13  -1.1074D-12  -1.5356D-12   6.0874D-12  
D  GIFU11    HYD  CHEB_1    -1.7177D-11   1.7585D-11   1.1756D-11  -5.9095D-13  -2.1948D-12  -4.2475D-13   8.6903D-14  -2.9911D-13   7.0106D-13  
D  GIFU11    HYD  CHEB_2    -5.3160D-12   2.5365D-12   1.7058D-12  -2.6403D-14  -2.4872D-13  -4.1578D-14   3.4871D-14  -4.2543D-14   1.4721D-13  
D  GIFU11    HYD  CHEB_3    -1.3026D-12  -4.4427D-13  -2.8004D-13   3.9938D-14   8.3587D-14   4.8540D-15  -9.5476D-15   3.8237D-15  -6.9703D-15  
D  GIFU11    HYD  CHEB_4    -7.0913D-13  -7.1593D-15  -9.0925D-15   4.6260D-15   1.0171D-14   3.4868D-15  -3.6986D-16   1.5546D-15   4.7153D-15  
D  GIFU11    HYD  CHEB_5    -1.2158D-13  -1.0544D-14  -4.7217D-15  -3.3268D-15  -5.7169D-15  -1.1018D-15   2.2384D-15  -1.3648D-15  -2.8451D-15  
#
D  GIFU11    NHY  DER_NORT   3.3254D-05  -2.1221D-04  -3.3312D-04   1.1911D-04   3.5100D-04  -4.6897D-05  -1.6220D-04   1.2982D-05   2.6198D-04  
D  GIFU11    NHY  DER_EAST   1.7212D-04  -6.0007D-04  -5.0381D-04  -3.2293D-04   1.5729D-04   2.4604D-04   2.4893D-04   1.6404D-04  -1.9522D-04  
D  GIFU11    NHY  CHEB_0     5.6657D-10  -3.8443D-10  -2.4133D-10   7.4868D-11   1.1767D-10  -1.5714D-11  -4.6194D-11   1.4484D-11  -6.0055D-12  
D  GIFU11    NHY  CHEB_1     3.0836D-11  -1.8186D-11  -1.1921D-11   2.8143D-12   4.9116D-12  -3.5898D-13  -1.9461D-12   6.1475D-13  -6.6496D-13  
D  GIFU11    NHY  CHEB_2     5.4758D-12  -2.9923D-12  -2.0171D-12   3.4362D-13   6.9875D-13  -3.4988D-14  -2.0776D-13   7.7068D-14  -1.5969D-13  
D  GIFU11    NHY  CHEB_3    -6.2219D-13   4.7478D-13   2.9262D-13  -1.0793D-13  -1.7443D-13   1.2154D-15   9.0053D-14  -2.2786D-14   4.6241D-16  
D  GIFU11    NHY  CHEB_4    -7.8657D-14   4.9061D-14   3.5729D-14  -9.1425D-15  -1.8832D-14   1.6068D-15   8.1821D-15   5.6344D-15   1.5273D-15  
D  GIFU11    NHY  CHEB_5    -2.2667D-14   1.5057D-14   6.6168D-15   6.5353D-16  -1.7569D-15  -2.7314D-15   7.6054D-17  -5.1085D-15  -6.3967D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GIFU3     HYD  DER_NORT   1.3081D-04   6.4863D-05   3.8425D-05   4.0274D-06  -2.2649D-05  -1.3708D-06  -1.0420D-05  -2.2505D-06  -4.7353D-06  
D  GIFU3     HYD  DER_EAST   1.4111D-05  -3.4236D-06  -1.7272D-05  -1.1355D-06  -1.4607D-05   3.3216D-06  -5.1874D-07  -3.2846D-07   4.5155D-06  
D  GIFU3     HYD  CHEB_0     7.7083D-09   6.5697D-11   1.4482D-11  -1.3302D-12  -6.0440D-12  -5.8064D-13  -1.1103D-12  -1.5468D-12   6.1275D-12  
D  GIFU3     HYD  CHEB_1    -1.7295D-11   1.7594D-11   1.1765D-11  -5.8704D-13  -2.1930D-12  -4.2531D-13   8.4585D-14  -2.9968D-13   7.0424D-13  
D  GIFU3     HYD  CHEB_2    -5.3426D-12   2.5353D-12   1.7060D-12  -2.6202D-14  -2.4755D-13  -4.1740D-14   3.4941D-14  -4.2580D-14   1.4794D-13  
D  GIFU3     HYD  CHEB_3    -1.3007D-12  -4.4485D-13  -2.8066D-13   3.9817D-14   8.3484D-14   4.8267D-15  -9.4517D-15   3.9416D-15  -6.6363D-15  
D  GIFU3     HYD  CHEB_4    -7.0821D-13  -6.6189D-15  -8.7833D-15   4.3463D-15   9.8252D-15   3.6150D-15  -2.7456D-16   1.4390D-15   4.3482D-15  
D  GIFU3     HYD  CHEB_5    -1.2262D-13  -1.0777D-14  -4.8775D-15  -3.1977D-15  -5.4825D-15  -1.1558D-15   2.1683D-15  -1.2981D-15  -2.6636D-15  
#
D  GIFU3     NHY  DER_NORT   3.8250D-05  -1.9921D-04  -3.2694D-04   1.1947D-04   3.4892D-04  -4.9093D-05  -1.6350D-04   1.0255D-05   2.6657D-04  
D  GIFU3     NHY  DER_EAST   1.6124D-04  -6.0028D-04  -5.0258D-04  -3.1847D-04   1.5913D-04   2.4486D-04   2.4643D-04   1.6324D-04  -1.9104D-04  
D  GIFU3     NHY  CHEB_0     5.6801D-10  -3.8524D-10  -2.4190D-10   7.4941D-11   1.1791D-10  -1.5724D-11  -4.6246D-11   1.4532D-11  -5.9626D-12  
D  GIFU3     NHY  CHEB_1     3.0919D-11  -1.8221D-11  -1.1941D-11   2.8148D-12   4.9120D-12  -3.5958D-13  -1.9452D-12   6.1448D-13  -6.6548D-13  
D  GIFU3     NHY  CHEB_2     5.4876D-12  -2.9950D-12  -2.0181D-12   3.4286D-13   6.9770D-13  -3.4861D-14  -2.0640D-13   7.6596D-14  -1.5956D-13  
D  GIFU3     NHY  CHEB_3    -6.2436D-13   4.7658D-13   2.9360D-13  -1.0831D-13  -1.7536D-13   1.5748D-15   8.9975D-14  -2.2129D-14  -9.4733D-17  
D  GIFU3     NHY  CHEB_4    -7.9526D-14   4.9336D-14   3.6013D-14  -9.0742D-15  -1.8610D-14   1.2412D-15   8.8134D-15   5.0264D-15   1.6565D-15  
D  GIFU3     NHY  CHEB_5    -2.2366D-14   1.5082D-14   6.6759D-15   6.6335D-16  -2.0967D-15  -2.6767D-15  -1.6319D-16  -4.7762D-15  -5.6390D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GILCREEK  HYD  DER_NORT   4.1539D-05   7.0085D-06  -2.9447D-06  -2.8624D-06   2.1475D-05   5.0857D-06   8.2429D-06  -1.5396D-06  -2.3100D-07  
D  GILCREEK  HYD  DER_EAST   3.2063D-05  -1.6820D-06  -1.4180D-05   1.4383D-05   2.6233D-06   3.9542D-05   1.0122D-05  -1.4152D-06   1.1837D-06  
D  GILCREEK  HYD  CHEB_0     7.3928D-09   2.6105D-13   9.2216D-12  -1.5640D-11   9.8778D-12  -3.8745D-11   7.0870D-12   1.3605D-12   1.4284D-12  
D  GILCREEK  HYD  CHEB_1     1.3626D-11   1.8929D-11   5.6843D-12  -3.4827D-12  -1.9285D-12  -1.7812D-12  -3.1131D-12   2.0565D-13   3.5260D-13  
D  GILCREEK  HYD  CHEB_2     1.1954D-14   2.9662D-12   1.1709D-12  -6.3303D-13  -8.8236D-14  -5.4926D-13  -5.8644D-13   3.7154D-14   4.6785D-14  
D  GILCREEK  HYD  CHEB_3    -1.9512D-12  -4.1344D-13  -9.0936D-14   8.9162D-14   1.3974D-13   2.3225D-14   7.2635D-14   1.6003D-15  -7.5472D-15  
D  GILCREEK  HYD  CHEB_4    -6.7161D-13   1.8561D-14  -1.8880D-14   6.6798D-15  -2.2472D-14   3.8040D-14  -4.6986D-16  -2.3342D-15   1.5574D-15  
D  GILCREEK  HYD  CHEB_5    -1.4109D-13  -3.3232D-15   3.4621D-15  -7.3816D-16   5.1560D-16  -1.7278D-14  -3.1935D-15   3.1146D-15  -5.3543D-16  
#
D  GILCREEK  NHY  DER_NORT   4.4046D-04   6.3376D-04   1.0067D-03  -6.4553D-05   8.6400D-04  -2.6071D-04   2.6897D-04  -2.5170D-04   5.3901D-05  
D  GILCREEK  NHY  DER_EAST   3.9521D-04   1.1276D-04   5.5855D-05   1.5294D-04   2.4239D-04   3.5271D-04   1.9961D-04  -2.5527D-06  -2.1582D-05  
D  GILCREEK  NHY  CHEB_0     2.3304D-10  -1.8968D-10  -7.3957D-11   5.5587D-11   2.7974D-11   3.4081D-12   1.9522D-11  -4.3744D-13  -3.2400D-12  
D  GILCREEK  NHY  CHEB_1     1.3930D-11  -1.1850D-11  -4.4757D-12   3.3201D-12   1.8048D-12   3.4345D-13   8.0869D-13  -2.5729D-13  -3.6281D-13  
D  GILCREEK  NHY  CHEB_2     2.4991D-12  -2.1356D-12  -7.8664D-13   6.0123D-13   3.1278D-13   7.0935D-14   1.2729D-13  -7.3922D-14  -5.8712D-14  
D  GILCREEK  NHY  CHEB_3    -2.4522D-13   1.9285D-13   8.7623D-14  -5.2659D-14  -3.8746D-14  -4.5312D-15  -2.0992D-14  -1.4563D-16   3.5956D-15  
D  GILCREEK  NHY  CHEB_4    -3.6267D-14   2.9729D-14   9.9341D-15  -9.8999D-15  -3.1706D-15   1.9990D-15  -3.3240D-15  -1.7261D-15   7.6764D-16  
D  GILCREEK  NHY  CHEB_5    -9.6134D-16  -2.9527D-15   1.3007D-15  -3.2063D-17  -1.0285D-15  -1.1476D-15   7.6566D-17   4.4599D-15  -1.9521D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GOLDVENU  HYD  DER_NORT   6.0520D-05   1.8523D-05   4.3526D-06  -1.6055D-05  -1.6818D-05  -6.8189D-08  -3.5972D-06   3.7818D-07  -2.2425D-06  
D  GOLDVENU  HYD  DER_EAST  -8.5362D-07  -2.8239D-05  -1.5738D-05  -1.2022D-06   1.1656D-05  -1.1537D-05   3.0370D-06   1.8580D-06  -7.7780D-07  
D  GOLDVENU  HYD  CHEB_0     6.8009D-09   2.5691D-11   1.9252D-13   7.8382D-12   1.9805D-12  -5.7568D-13  -2.6325D-12   1.2139D-12   4.9094D-12  
D  GOLDVENU  HYD  CHEB_1    -5.9379D-12   1.1191D-11   5.5830D-12  -1.2970D-12  -1.3660D-12   1.4123D-12   1.1293D-12   4.0089D-13   5.4877D-13  
D  GOLDVENU  HYD  CHEB_2    -3.0443D-12   1.8150D-12   8.9113D-13  -1.9831D-13  -1.7048D-13   2.9824D-13   2.0008D-13   7.4129D-14   9.3584D-14  
D  GOLDVENU  HYD  CHEB_3    -1.5121D-12  -2.4451D-13  -1.3817D-13   3.7791D-14   4.2847D-14  -1.5064D-14  -2.7983D-14  -7.6194D-15  -8.2926D-15  
D  GOLDVENU  HYD  CHEB_4    -6.3629D-13  -1.8463D-14  -1.9169D-15   7.7810D-15   5.5404D-15  -8.6396D-15  -7.1914D-16   4.4676D-16   3.9643D-16  
D  GOLDVENU  HYD  CHEB_5    -1.0220D-13   5.1001D-15  -3.0179D-15  -2.4108D-15  -2.0136D-15   1.5193D-15   3.3961D-15   3.2985D-16  -3.5376D-16  
#
D  GOLDVENU  NHY  DER_NORT  -4.1179D-04  -8.5517D-04  -1.0866D-03  -2.9773D-04   6.4368D-04   5.3973D-04  -2.5908D-04  -1.8339D-04  -2.0506D-04  
D  GOLDVENU  NHY  DER_EAST   8.6905D-04  -1.6179D-03  -1.0857D-03   5.1650D-05   1.1654D-03   7.1875D-04  -7.2512D-04   2.2575D-04   1.2663D-04  
D  GOLDVENU  NHY  CHEB_0     2.2558D-10  -8.7800D-11  -4.7820D-11   9.4177D-12   4.9552D-11  -1.9450D-11  -4.1327D-11  -3.1460D-12  -6.8207D-13  
D  GOLDVENU  NHY  CHEB_1     1.3386D-11  -5.0332D-12  -2.6371D-12   2.6078D-13   2.6754D-12  -9.3736D-13  -2.0235D-12  -2.5052D-13   4.6219D-14  
D  GOLDVENU  NHY  CHEB_2     2.5091D-12  -9.3748D-13  -4.6818D-13   2.5101D-14   4.7533D-13  -1.4958D-13  -3.4464D-13  -3.9208D-14   4.5071D-15  
D  GOLDVENU  NHY  CHEB_3    -2.0459D-13   8.0922D-14   5.5499D-14  -1.4129D-14  -5.4327D-14   2.7584D-14   4.8740D-14   1.0526D-14  -3.1124D-15  
D  GOLDVENU  NHY  CHEB_4    -3.2663D-14   1.3223D-14   7.9628D-15  -4.9738D-16  -7.8095D-15   3.5392D-15   4.8870D-15  -2.7494D-15   2.7651D-16  
D  GOLDVENU  NHY  CHEB_5    -6.7949D-15   3.2349D-15   2.3650D-15  -1.7580D-16  -1.6389D-15   5.2439D-16   1.7203D-15   8.7015D-16  -3.2585D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GORF7102  HYD  DER_NORT   1.3672D-04   7.4391D-05   2.5176D-05   5.9215D-06   3.0633D-05  -1.1947D-05   1.7075D-05   7.7644D-07   2.4173D-06  
D  GORF7102  HYD  DER_EAST  -1.4969D-05   4.7497D-06  -3.0555D-05   2.2608D-06  -4.8495D-06  -7.8880D-07  -2.3073D-06  -1.0506D-06   8.5333D-07  
D  GORF7102  HYD  CHEB_0     7.6943D-09   2.8842D-11   1.1294D-11   5.9509D-12  -5.0016D-12   3.6242D-12  -2.9782D-12   5.0043D-12   2.1273D-13  
D  GORF7102  HYD  CHEB_1    -1.6505D-11   1.4535D-11   8.7395D-12  -2.2129D-12   9.8140D-13  -2.7093D-12   2.6601D-12   7.3800D-13  -1.6599D-13  
D  GORF7102  HYD  CHEB_2    -4.6355D-12   2.2943D-12   1.3259D-12  -3.4802D-13   2.8308D-13  -4.5582D-13   4.5943D-13   1.2617D-13  -3.6213D-14  
D  GORF7102  HYD  CHEB_3    -1.4649D-12  -3.8911D-13  -2.5859D-13   5.0284D-14  -3.9475D-15   6.6563D-14  -6.6156D-14  -1.2392D-14   7.3202D-15  
D  GORF7102  HYD  CHEB_4    -7.1023D-13   9.0843D-15  -1.8723D-15   1.7895D-15   5.4176D-16   5.8628D-15  -1.9441D-15  -1.2134D-15  -7.3787D-16  
D  GORF7102  HYD  CHEB_5    -1.0170D-13   3.0087D-15   6.8469D-15  -1.2480D-15  -4.2327D-16  -2.1740D-15   1.3382D-15   3.1331D-16   3.2637D-16  
#
D  GORF7102  NHY  DER_NORT   1.0742D-03   1.7035D-04   4.3899D-04  -4.9907D-05   7.2937D-04   7.7575D-05   1.4995D-04   1.0361D-04  -6.2661D-05  
D  GORF7102  NHY  DER_EAST  -3.6128D-04  -1.2446D-04  -9.4659D-05   1.8609D-04  -3.3774D-04   5.9768D-05   2.0906D-04   1.7267D-04  -1.7292D-05  
D  GORF7102  NHY  CHEB_0     4.7652D-10  -2.3851D-10  -1.2354D-10   3.5989D-11   3.3430D-11   2.5298D-11  -2.4160D-11  -7.6294D-12  -5.0734D-12  
D  GORF7102  NHY  CHEB_1     2.6019D-11  -1.3353D-11  -6.3853D-12   1.6564D-12   1.2379D-12   1.5506D-12  -1.0331D-12  -2.8221D-13  -6.2912D-13  
D  GORF7102  NHY  CHEB_2     4.6106D-12  -2.3976D-12  -1.1239D-12   3.0339D-13   2.0304D-13   2.7639D-13  -1.9401D-13  -2.4324D-14  -9.4748D-14  
D  GORF7102  NHY  CHEB_3    -5.1533D-13   2.4524D-13   1.3034D-13  -2.8642D-14  -3.7424D-14  -3.4267D-14   1.9534D-14   1.4935D-14   2.7259D-14  
D  GORF7102  NHY  CHEB_4    -6.7610D-14   2.5688D-14   1.6124D-14  -8.6654D-16  -2.0097D-15   4.4333D-16   2.6199D-15  -3.4923D-15   1.2464D-14  
D  GORF7102  NHY  CHEB_5    -1.3136D-14   9.6978D-15   4.4192D-15  -2.0929D-15  -2.7313D-15  -2.4862D-15   1.6321D-15   1.6479D-15  -2.1942D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  GRASSE    HYD  DER_NORT   5.4491D-05   3.4932D-06  -2.1154D-05   2.6131D-05   1.9746D-05  -1.1602D-05   1.2918D-05  -4.1620D-06  -2.3954D-06  
D  GRASSE    HYD  DER_EAST  -2.7792D-05  -1.0614D-05  -5.7837D-07  -1.5198D-06  -9.0157D-06   8.4843D-07  -2.9775D-06  -2.8342D-06  -1.0328D-06  
D  GRASSE    HYD  CHEB_0     6.6694D-09   1.0961D-11  -1.2499D-11   1.2783D-11  -8.4374D-12   7.4551D-12  -8.6499D-12   1.1416D-12   2.2289D-13  
D  GRASSE    HYD  CHEB_1     5.6589D-12   9.0820D-12   6.7352D-12  -1.7415D-12  -7.3426D-13   2.2259D-13  -9.6349D-13   6.9967D-15  -3.5725D-13  
D  GRASSE    HYD  CHEB_2    -9.8809D-13   1.2416D-12   1.1054D-12  -2.6285D-13  -2.0534D-15   3.4844D-14  -1.6451D-13   2.1336D-14  -4.2041D-14  
D  GRASSE    HYD  CHEB_3    -1.7245D-12  -2.5061D-13  -1.5578D-13   4.4608D-14   4.7799D-14  -8.7250D-15   1.8995D-14  -5.0704D-15   1.1486D-14  
D  GRASSE    HYD  CHEB_4    -6.2103D-13   1.5095D-14  -7.4004D-15  -2.4516D-15  -4.1955D-15  -3.3013D-15   2.1228D-15  -2.8548D-15  -2.3297D-15  
D  GRASSE    HYD  CHEB_5    -9.7905D-14  -2.6595D-15   1.7598D-15  -1.1955D-15  -3.9282D-15  -4.4293D-16  -1.7751D-15   1.4390D-15   1.4561D-16  
#
D  GRASSE    NHY  DER_NORT  -1.6372D-03   1.8727D-03   7.6276D-05   2.0339D-05   1.7231D-04   1.0728D-06  -1.4374D-04  -6.2680D-04  -1.4672D-03  
D  GRASSE    NHY  DER_EAST  -7.6600D-04  -3.9320D-04  -2.0990D-04   2.9341D-04   3.4125D-04   4.0039D-04   2.2262D-05  -3.6799D-04  -4.8211D-04  
D  GRASSE    NHY  CHEB_0     2.6019D-10  -1.0174D-10  -5.4949D-11  -4.0907D-12  -1.8241D-12   2.9905D-12   9.6675D-12  -1.7810D-12   4.3340D-12  
D  GRASSE    NHY  CHEB_1     1.6146D-11  -5.5368D-12  -3.1867D-12  -5.9091D-13  -1.7502D-13   6.2619D-13   7.2183D-13  -2.9924D-13  -1.9939D-13  
D  GRASSE    NHY  CHEB_2     3.0635D-12  -1.0270D-12  -5.6733D-13  -8.2111D-14  -3.6585D-14   1.1535D-13   1.1542D-13  -4.4151D-14  -4.7008D-14  
D  GRASSE    NHY  CHEB_3    -2.2694D-13   8.5778D-14   6.2249D-14   2.6021D-14  -3.2694D-16  -1.4633D-14  -2.0441D-14   1.0984D-14  -1.8599D-15  
D  GRASSE    NHY  CHEB_4    -3.9152D-14   1.2194D-14   7.6473D-15   1.7001D-15  -1.9381D-16  -3.0711D-15  -2.6488D-15   9.9872D-16   4.1778D-16  
D  GRASSE    NHY  CHEB_5    -7.8176D-15   3.2457D-15   1.0940D-15  -4.5477D-16   2.9242D-16   7.7026D-17  -1.8733D-16  -3.8077D-16  -6.8586D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HALEAKAL  HYD  DER_NORT   7.5997D-05   2.7120D-05   9.1911D-06  -6.3264D-06   1.4138D-05  -9.7246D-06   7.9802D-06   8.9747D-07  -4.0781D-07  
D  HALEAKAL  HYD  DER_EAST  -2.2650D-05  -6.5491D-06  -8.3048D-06  -6.6344D-07  -9.0606D-07  -3.8119D-06  -2.5393D-06   3.3650D-08  -3.6564D-07  
D  HALEAKAL  HYD  CHEB_0     5.4355D-09  -5.2327D-12  -9.7734D-13   4.1580D-12  -2.9177D-12   1.7642D-12  -2.9495D-12  -2.8025D-13   1.8140D-13  
D  HALEAKAL  HYD  CHEB_1     1.0937D-11   1.1055D-12   1.9953D-12  -3.5296D-13  -9.6412D-14  -5.5146D-13  -3.5641D-13   8.9754D-14   1.5296D-13  
D  HALEAKAL  HYD  CHEB_2     5.8467D-13   1.0858D-13   3.2418D-13  -6.9411D-14   8.1082D-15  -9.6421D-14  -5.2659D-14   7.3987D-15   2.3297D-14  
D  HALEAKAL  HYD  CHEB_3    -1.6063D-12  -3.5216D-14  -4.8351D-14   2.6526D-15   1.2965D-14   7.5162D-15   8.9100D-15   3.9062D-16  -4.1462D-15  
D  HALEAKAL  HYD  CHEB_4    -5.2958D-13   9.0221D-15   4.2706D-16   2.4679D-15  -4.6819D-16  -1.2398D-15   1.1154D-15   5.0682D-16   2.1267D-16  
D  HALEAKAL  HYD  CHEB_5    -5.0718D-14   1.2753D-15   3.6454D-16  -7.1561D-16   1.0885D-15   1.0070D-15   1.3415D-15  -6.4839D-16  -1.6558D-16  
#
D  HALEAKAL  NHY  DER_NORT  -8.3529D-05  -7.7145D-05  -6.9971D-04  -3.3019D-04   1.0481D-05  -7.5708D-04   4.1678D-04   4.5820D-04   3.2904D-05  
D  HALEAKAL  NHY  DER_EAST  -1.9412D-04   2.9229D-04   6.5978D-05  -4.1814D-05  -7.5841D-05  -3.0245D-04  -3.8818D-04   6.3488D-05   3.5245D-05  
D  HALEAKAL  NHY  CHEB_0     1.1745D-10   6.2210D-12  -4.3440D-11  -1.9703D-11  -6.2009D-12  -2.2708D-11   1.3700D-11  -1.1618D-12   7.2017D-13  
D  HALEAKAL  NHY  CHEB_1     7.9349D-12   3.0497D-13  -2.8788D-12  -1.2792D-12  -4.4944D-13  -1.4611D-12   7.8656D-13  -7.9722D-14  -4.4726D-14  
D  HALEAKAL  NHY  CHEB_2     1.5652D-12   4.4544D-14  -5.5845D-13  -2.4994D-13  -8.2760D-14  -2.7720D-13   1.3527D-13  -9.8531D-15  -1.2978D-14  
D  HALEAKAL  NHY  CHEB_3    -8.3969D-14  -8.9505D-15   3.5539D-14   1.4813D-14   6.7004D-15   2.0483D-14  -1.7270D-14   3.3896D-15  -7.7116D-16  
D  HALEAKAL  NHY  CHEB_4    -1.6006D-14  -1.1735D-15   6.0080D-15   2.3798D-15   5.5051D-17   3.1923D-15  -2.3376D-15  -2.2695D-16   2.4345D-16  
D  HALEAKAL  NHY  CHEB_5    -2.6023D-15   3.0712D-16   1.5890D-15   6.0336D-16   6.8855D-16   1.1830D-15   3.1701D-16   6.2380D-17   1.0961D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HARTRAO   HYD  DER_NORT  -2.5703D-05   2.7849D-05   6.6378D-06  -5.9567D-06   7.9646D-06  -9.3752D-07  -2.6639D-06  -1.0966D-06   3.4666D-07  
D  HARTRAO   HYD  DER_EAST  -2.5774D-06  -3.8567D-06  -4.3662D-06   6.5538D-07   1.4442D-06  -2.2262D-06   1.7246D-06  -1.1849D-06   9.1582D-07  
D  HARTRAO   HYD  CHEB_0     6.5974D-09  -3.0182D-11  -7.1185D-12   9.3813D-13  -1.0544D-12   7.9359D-13   2.3905D-13  -3.6531D-12  -6.0966D-12  
D  HARTRAO   HYD  CHEB_1    -7.8163D-12  -5.6160D-12  -8.6980D-13   1.3143D-13  -6.2975D-13   6.1858D-13   1.1964D-13  -4.8812D-13  -6.6922D-13  
D  HARTRAO   HYD  CHEB_2    -3.3945D-12  -1.0105D-12  -1.5288D-13   5.8378D-14  -7.6065D-14   1.0027D-13   1.3377D-14  -1.0064D-13  -1.2896D-13  
D  HARTRAO   HYD  CHEB_3    -1.4399D-12   9.5535D-14   2.0374D-14   2.3434D-14   2.4899D-14  -1.1715D-14  -6.3130D-16   5.4250D-15   2.5824D-15  
D  HARTRAO   HYD  CHEB_4    -5.8782D-13   1.3413D-14   3.2183D-15   4.1683D-16  -1.4901D-15  -1.1614D-15  -4.8767D-16  -2.2568D-15  -2.5012D-16  
D  HARTRAO   HYD  CHEB_5    -9.3297D-14  -2.9035D-15  -1.6512D-16   6.2527D-16  -7.5275D-17   1.2590D-15   8.5259D-16   9.3318D-16   1.1568D-17  
#
D  HARTRAO   NHY  DER_NORT  -1.8108D-04  -9.9141D-04  -4.2461D-04   4.3514D-04   5.8551D-04   4.2581D-04   4.8345D-04   3.2668D-04   5.1834D-05  
D  HARTRAO   NHY  DER_EAST   4.3064D-04   3.6275D-04  -3.0083D-04  -1.4881D-04  -3.4095D-04   3.7348D-05  -7.1285D-05  -1.2748D-04   3.0017D-04  
D  HARTRAO   NHY  CHEB_0     3.6138D-10   2.1579D-10   2.7612D-11  -6.6258D-12  -1.8818D-11  -2.3300D-12  -3.0487D-11  -7.8435D-12   1.0356D-11  
D  HARTRAO   NHY  CHEB_1     2.1997D-11   1.1474D-11   1.5423D-12  -2.9107D-13  -5.5274D-13   6.4487D-14  -1.4573D-12  -5.8241D-13  -3.3717D-13  
D  HARTRAO   NHY  CHEB_2     4.0777D-12   1.9866D-12   2.6397D-13  -4.7739D-14  -7.9712D-14   1.8371D-14  -2.6328D-13  -1.0669D-13  -1.2711D-13  
D  HARTRAO   NHY  CHEB_3    -3.5023D-13  -2.4740D-13  -3.7761D-14   8.8809D-15   2.0374D-14   6.3989D-15   2.6761D-14   6.7016D-15  -2.4787D-14  
D  HARTRAO   NHY  CHEB_4    -4.8882D-14  -2.8885D-14  -2.6335D-15   2.8540D-15  -6.8746D-16   3.5157D-16   8.8989D-16   5.8208D-15   2.4610D-17  
D  HARTRAO   NHY  CHEB_5    -9.1205D-15  -4.6073D-15  -1.4595D-15   1.7289D-16   1.4906D-15   1.2562D-15   1.7912D-15  -1.6095D-15  -1.5015D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HATCREEK  HYD  DER_NORT   9.7120D-05   3.0420D-05   8.6262D-06   4.3282D-06  -2.6310D-05  -1.1096D-05  -2.7242D-05   3.7915D-06  -3.7623D-06  
D  HATCREEK  HYD  DER_EAST   2.9292D-05  -1.4535D-05   2.4442D-06   1.5095D-05   5.6000D-06  -1.2076D-05  -1.4554D-05   8.2692D-06  -2.4579D-06  
D  HATCREEK  HYD  CHEB_0     6.8627D-09   2.6047D-11   4.8487D-12   7.0536D-12  -2.1163D-12   1.8626D-12  -1.2149D-12   5.7296D-12   1.0352D-12  
D  HATCREEK  HYD  CHEB_1    -1.7801D-12   1.0948D-11   5.5520D-12  -1.5828D-12  -2.1134D-12   9.2194D-13   5.5303D-13   8.9938D-13   1.3536D-13  
D  HATCREEK  HYD  CHEB_2    -1.9986D-12   1.8171D-12   9.1397D-13  -2.3127D-13  -3.8502D-13   1.9325D-13   2.7879D-14   1.9045D-13   1.6797D-14  
D  HATCREEK  HYD  CHEB_3    -1.6956D-12  -2.6366D-13  -1.3821D-13   5.1825D-14   7.0959D-14  -1.3484D-14  -3.8801D-15  -1.9861D-15   1.4341D-16  
D  HATCREEK  HYD  CHEB_4    -6.2046D-13  -8.1372D-15  -5.1281D-15   4.0434D-15  -2.2510D-17  -4.6773D-15   1.9408D-15   1.7626D-16   1.0307D-15  
D  HATCREEK  HYD  CHEB_5    -6.8794D-14   7.5642D-15   4.4969D-15  -3.1368D-15  -5.4531D-15   2.5452D-15  -3.6072D-15  -9.8581D-16   8.5410D-17  
#
D  HATCREEK  NHY  DER_NORT   2.7637D-06   8.0928D-04   4.7309D-04  -3.6639D-04  -4.1527D-04   1.4598D-04   2.7887D-04   1.6241D-04   4.1794D-04  
D  HATCREEK  NHY  DER_EAST   6.9544D-04  -8.1045D-04  -2.2668D-05  -1.3547D-04   3.7809D-04   7.0024D-05   1.4602D-04  -3.9472D-05  -1.3091D-04  
D  HATCREEK  NHY  CHEB_0     2.5890D-10  -5.2491D-11  -3.5313D-12   5.4560D-12  -3.5986D-12  -2.8357D-11  -2.3803D-11  -3.8000D-12  -4.4976D-12  
D  HATCREEK  NHY  CHEB_1     1.6009D-11  -4.0567D-12   1.5432D-13   2.2020D-13  -1.8817D-14  -1.4901D-12  -1.4367D-12  -1.9013D-13  -4.9359D-13  
D  HATCREEK  NHY  CHEB_2     3.0103D-12  -8.0542D-13   6.0478D-14   4.8101D-14  -4.3654D-15  -2.6682D-13  -2.6847D-13  -4.3149D-14  -9.2017D-14  
D  HATCREEK  NHY  CHEB_3    -2.4889D-13   5.1224D-14   1.3837D-14  -5.7059D-15  -6.7195D-16   2.5922D-14   2.5734D-14   8.1812D-15   8.4681D-15  
D  HATCREEK  NHY  CHEB_4    -3.9556D-14   1.3101D-14   4.0485D-15  -1.0881D-15  -5.0636D-15   2.9724D-15   6.0321D-15   4.5434D-15  -6.0076D-17  
D  HATCREEK  NHY  CHEB_5    -7.8947D-15   1.8277D-15  -7.6962D-16  -7.3740D-16   1.3177D-15   7.1503D-16   5.2474D-16   2.2514D-16   7.3567D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HAYSTACK  HYD  DER_NORT   1.4801D-04   6.4520D-05   4.5994D-06   1.9945D-05   2.7449D-05  -8.0616D-07   3.2492D-06  -4.0808D-07   2.1851D-06  
D  HAYSTACK  HYD  DER_EAST  -1.7288D-06   7.9609D-06  -3.3398D-05  -1.4968D-06  -3.8601D-06  -1.3256D-05  -1.0600D-06  -1.0826D-07   7.8416D-07  
D  HAYSTACK  HYD  CHEB_0     7.5987D-09   1.5682D-11   2.2813D-12   1.3528D-12  -8.0516D-12   8.8137D-12  -7.8735D-12   3.4488D-12  -2.4005D-12  
D  HAYSTACK  HYD  CHEB_1    -8.4076D-12   1.6011D-11   1.0302D-11  -2.1090D-12   2.1239D-12  -2.2440D-12   2.6101D-12   5.5779D-13  -4.6380D-13  
D  HAYSTACK  HYD  CHEB_2    -3.4274D-12   2.5550D-12   1.6471D-12  -3.0431D-13   4.9394D-13  -3.5865D-13   4.6269D-13   9.3822D-14  -6.8665D-14  
D  HAYSTACK  HYD  CHEB_3    -1.5218D-12  -3.4858D-13  -2.3558D-13   5.8910D-14   1.0655D-14   5.5923D-14  -4.2991D-14  -1.1206D-14   5.6612D-15  
D  HAYSTACK  HYD  CHEB_4    -7.1853D-13  -6.4415D-15  -4.0968D-15  -6.2975D-15  -7.5968D-15  -2.8256D-15  -3.2677D-16   1.9665D-15  -6.6904D-17  
D  HAYSTACK  HYD  CHEB_5    -1.1011D-13  -2.1872D-15  -4.1843D-15   2.1384D-15  -2.7585D-16   5.0519D-16  -1.0971D-15  -1.2363D-15   9.1600D-16  
#
D  HAYSTACK  NHY  DER_NORT   1.2919D-03   4.4479D-04   3.4576D-04   2.9136D-04   6.1213D-04   1.0242D-04   2.9108D-04   2.9172D-04   9.4201D-05  
D  HAYSTACK  NHY  DER_EAST  -7.1355D-04  -3.7023D-04   1.4538D-04   2.7400D-04   1.0086D-04  -2.3021D-04  -1.5394D-04   2.6976D-04  -9.2489D-05  
D  HAYSTACK  NHY  CHEB_0     3.9165D-10  -2.1628D-10  -1.0640D-10   6.2173D-11   3.8184D-12  -8.5159D-12  -3.0859D-11  -1.1016D-11  -1.0627D-12  
D  HAYSTACK  NHY  CHEB_1     2.1773D-11  -1.1785D-11  -6.5669D-12   3.0628D-12   2.7452D-13  -2.6944D-13  -1.6235D-12  -1.4473D-13  -1.0394D-14  
D  HAYSTACK  NHY  CHEB_2     3.8968D-12  -2.0966D-12  -1.2325D-12   5.1289D-13   5.2479D-14  -3.7048D-14  -2.7278D-13  -1.1877D-14   2.6635D-14  
D  HAYSTACK  NHY  CHEB_3    -4.1616D-13   2.2828D-13   9.7125D-14  -7.4709D-14   1.9381D-15   1.3152D-14   3.6129D-14   5.2982D-15   8.4358D-15  
D  HAYSTACK  NHY  CHEB_4    -6.3704D-14   3.5854D-14   2.1282D-14  -9.9900D-15  -6.6032D-15   8.7575D-16   7.7897D-15   1.7173D-15  -6.7144D-16  
D  HAYSTACK  NHY  CHEB_5    -1.0223D-14   5.1769D-15   2.3580D-15  -1.3616D-15   1.2719D-15   4.2338D-16   1.6258D-16  -1.1785D-15   2.2749D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HN-VLBA   HYD  DER_NORT   1.5485D-04   6.3818D-05   2.1286D-06   2.0016D-05   2.6565D-05  -4.9658D-07   2.8823D-06  -3.9640D-07   2.0866D-06  
D  HN-VLBA   HYD  DER_EAST  -4.5295D-06   3.8502D-06  -3.5854D-05  -3.7062D-06  -5.9423D-06  -1.2640D-05  -1.3050D-06   5.3862D-07   8.7351D-07  
D  HN-VLBA   HYD  CHEB_0     7.4408D-09   8.9232D-12  -9.8773D-13   1.6062D-12  -8.4598D-12   9.2944D-12  -8.4675D-12   2.6670D-12  -1.4780D-12  
D  HN-VLBA   HYD  CHEB_1    -4.7199D-12   1.5934D-11   9.9203D-12  -1.9679D-12   2.2233D-12  -2.2690D-12   2.5869D-12   4.9705D-13  -3.4217D-13  
D  HN-VLBA   HYD  CHEB_2    -2.6243D-12   2.5766D-12   1.6562D-12  -2.7868D-13   5.5619D-13  -3.7128D-13   4.8957D-13   7.3150D-14  -6.3394D-14  
D  HN-VLBA   HYD  CHEB_3    -1.6182D-12  -3.7610D-13  -2.2980D-13   4.2205D-14  -2.1553D-15   4.4455D-14  -4.4632D-14  -6.0844D-15   8.1178D-15  
D  HN-VLBA   HYD  CHEB_4    -7.0539D-13  -5.7896D-15  -1.3850D-14  -7.2210D-16  -9.9495D-15   4.2974D-15  -4.5297D-15   5.2778D-16   8.7669D-17  
D  HN-VLBA   HYD  CHEB_5    -9.2902D-14   3.3721D-15   5.5097D-15  -2.3237D-16  -2.4292D-15   1.1710D-15  -7.1776D-17  -1.7254D-16   8.1974D-16  
#
D  HN-VLBA   NHY  DER_NORT   1.2473D-03   3.2120D-04   4.5202D-04   2.3815D-04   6.5888D-04   1.5278D-04   3.4581D-04   2.6889D-04  -5.0585D-05  
D  HN-VLBA   NHY  DER_EAST  -7.8973D-04  -5.7914D-04   9.6275D-05   2.2373D-04   8.5752D-05  -1.6804D-04  -1.0297D-04   1.8182D-04  -1.7807D-04  
D  HN-VLBA   NHY  CHEB_0     3.6295D-10  -2.0100D-10  -9.9107D-11   5.6567D-11   1.3285D-12  -7.3877D-12  -2.7384D-11  -1.3827D-11   8.8759D-13  
D  HN-VLBA   NHY  CHEB_1     2.0841D-11  -1.1593D-11  -6.2357D-12   3.0709D-12   2.8346D-13  -4.1565D-13  -1.4767D-12  -4.3245D-13   1.9368D-13  
D  HN-VLBA   NHY  CHEB_2     3.7522D-12  -2.0781D-12  -1.1768D-12   5.0320D-13   6.2865D-14  -4.3673D-14  -2.4951D-13  -5.4363D-14   1.6328D-14  
D  HN-VLBA   NHY  CHEB_3    -3.8756D-13   2.1053D-13   9.2843D-14  -6.7994D-14   2.5695D-15   2.0437D-14   3.4930D-14   1.0742D-14  -6.2653D-15  
D  HN-VLBA   NHY  CHEB_4    -5.8777D-14   3.2273D-14   1.8219D-14  -6.4819D-15  -6.0119D-15  -9.2531D-16   6.2612D-15   2.7831D-15   3.0939D-15  
D  HN-VLBA   NHY  CHEB_5    -9.3387D-15   2.8167D-15   2.8241D-15   6.8109D-16   2.5506D-15   5.8659D-16  -4.0896D-16  -1.5730D-15  -2.5446D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HOBART26  HYD  DER_NORT  -1.5598D-04  -9.6334D-06   3.1574D-05   2.3364D-05   6.2543D-06  -9.2119D-06  -5.1800D-06   5.4447D-07  -2.0261D-06  
D  HOBART26  HYD  DER_EAST   1.6948D-05  -4.4595D-06   1.2123D-06  -7.8577D-06  -8.3876D-08   2.1860D-05   1.1209D-05  -1.1810D-07   1.3537D-06  
D  HOBART26  HYD  CHEB_0     7.6687D-09  -2.0220D-11   1.1969D-13  -1.3708D-12   3.0299D-12  -2.9337D-12  -9.2748D-12  -5.5565D-13   3.6058D-12  
D  HOBART26  HYD  CHEB_1    -1.0059D-11  -7.5302D-12  -4.6596D-12   1.2626D-12  -1.6779D-12  -5.1232D-13  -4.8424D-13  -7.0709D-14   4.9190D-13  
D  HOBART26  HYD  CHEB_2    -3.6975D-12  -9.4315D-13  -8.7272D-13   1.0916D-13  -3.2309D-13  -1.3247D-13  -4.6531D-14  -2.1492D-14   7.8492D-14  
D  HOBART26  HYD  CHEB_3    -1.5748D-12   2.2075D-13   8.7864D-14  -5.5027D-14   2.0583D-14   6.9824D-15   4.3032D-14   6.0882D-15   3.0571D-15  
D  HOBART26  HYD  CHEB_4    -7.2092D-13  -6.4311D-15   1.8464D-14   9.8096D-15   1.2608D-14  -1.5826D-15  -1.1730D-14  -1.3857D-16  -1.0052D-15  
D  HOBART26  HYD  CHEB_5    -1.0839D-13   7.4917D-15  -1.9353D-15  -2.1664D-15  -2.5052D-15  -4.6520D-16   3.1175D-16   7.6140D-16   5.6003D-16  
#
D  HOBART26  NHY  DER_NORT  -2.3176D-04  -5.8507D-04  -3.3571D-04  -2.8542D-04   3.2543D-04   2.5485D-04  -5.5778D-05  -2.4392D-04   2.9712D-04  
D  HOBART26  NHY  DER_EAST  -1.7483D-04  -1.7555D-04   1.6049D-04  -3.7955D-05   1.0066D-04  -2.4859D-04  -2.6590D-04   7.5950D-05   2.0087D-04  
D  HOBART26  NHY  CHEB_0     3.5364D-10   6.6414D-11   6.8272D-11   6.5547D-12   2.6294D-11   3.8929D-12   1.0589D-11   8.8929D-12  -2.7938D-12  
D  HOBART26  NHY  CHEB_1     2.1968D-11   2.7382D-12   3.9434D-12   1.0932D-13   1.5305D-12   2.9599D-13   7.1216D-13   4.7312D-13   1.1659D-13  
D  HOBART26  NHY  CHEB_2     4.0303D-12   4.1352D-13   7.1234D-13   1.2609D-14   2.7658D-13   5.2630D-14   1.2530D-13   8.4456D-14   3.9216D-14  
D  HOBART26  NHY  CHEB_3    -3.7052D-13  -8.3831D-14  -7.3230D-14  -8.0645D-15  -3.0421D-14  -8.6456D-16  -1.1569D-14  -8.1385D-15  -5.3042D-16  
D  HOBART26  NHY  CHEB_4    -5.3982D-14  -8.3919D-15  -1.1176D-14   5.3128D-16  -4.2114D-15  -2.5640D-15  -1.3996D-15  -2.4951D-15   1.8933D-15  
D  HOBART26  NHY  CHEB_5    -1.0911D-14  -1.2272D-15  -1.6284D-15  -2.3472D-15  -8.1071D-16   1.0949D-15  -3.9732D-16   7.2501D-17  -3.4288D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HOFN      HYD  DER_NORT   5.4624D-05   4.7409D-05   5.5917D-05  -4.6523D-06   2.8355D-06   1.8278D-05  -3.9230D-05   5.4152D-08  -2.2945D-07  
D  HOFN      HYD  DER_EAST   2.3161D-05   1.3774D-05   7.6148D-06  -1.6168D-05  -9.4613D-08   8.6824D-06  -1.5967D-05  -1.4234D-06  -2.6659D-09  
D  HOFN      HYD  CHEB_0     7.6334D-09  -5.8388D-11   1.2975D-11  -1.3361D-11   7.2409D-12  -6.8927D-12   2.3756D-11  -1.5855D-13  -4.0612D-13  
D  HOFN      HYD  CHEB_1     5.3744D-12   1.3784D-11   4.9006D-12   1.1225D-13  -2.4943D-12  -8.0541D-13   5.5235D-13  -4.6827D-14  -3.1247D-13  
D  HOFN      HYD  CHEB_2    -1.1552D-12   1.6621D-12   8.5284D-13  -3.5681D-14  -3.7363D-13  -1.3220D-13  -2.6507D-14  -1.5988D-14  -5.5932D-14  
D  HOFN      HYD  CHEB_3    -2.0215D-12  -5.0107D-13  -2.0474D-13  -2.9167D-15   5.1438D-14  -2.2254D-14   2.3600D-14   8.4096D-16   9.0887D-15  
D  HOFN      HYD  CHEB_4    -6.9967D-13   5.8612D-14   2.5997D-14  -3.3997D-15  -4.2617D-15   1.5550D-14  -3.2391D-14   4.1255D-16  -4.8970D-16  
D  HOFN      HYD  CHEB_5    -1.1490D-13  -3.7172D-15  -1.1872D-14   5.1023D-15   2.2432D-15  -5.4313D-15   1.4975D-14   1.0208D-15   5.1262D-16  
#
D  HOFN      NHY  DER_NORT   8.3053D-04   8.7626D-04   6.4025D-04  -3.3685D-04  -3.7249D-04  -6.6660D-05  -2.0227D-04   9.1074D-05  -1.1700D-04  
D  HOFN      NHY  DER_EAST   1.0802D-04   4.4452D-04  -5.0469D-06  -1.1377D-05  -6.4489D-06   5.0775D-05  -2.2543D-04  -8.7196D-05  -8.4296D-05  
D  HOFN      NHY  CHEB_0     2.9346D-10  -1.0344D-10  -7.2652D-11   2.6991D-12   4.0144D-11   1.3232D-11  -1.4924D-11  -2.4112D-14   6.4609D-12  
D  HOFN      NHY  CHEB_1     1.7532D-11  -5.3436D-12  -3.9936D-12   3.3234D-13   1.9770D-12   4.8135D-13  -9.1506D-13  -1.2328D-14   2.3382D-13  
D  HOFN      NHY  CHEB_2     3.1725D-12  -8.7583D-13  -6.5252D-13   6.7623D-14   3.1638D-13   8.0412D-14  -1.7653D-13   2.5559D-15   2.5784D-14  
D  HOFN      NHY  CHEB_3    -3.1294D-13   1.3958D-13   9.5957D-14  -8.2617D-15  -5.2424D-14  -1.0937D-14   2.0152D-14  -1.4631D-15  -1.4252D-14  
D  HOFN      NHY  CHEB_4    -4.4994D-14   8.7141D-15   8.2938D-15  -1.8661D-15  -4.1001D-15  -1.5571D-15   4.3045D-15  -3.2476D-16  -2.8603D-16  
D  HOFN      NHY  CHEB_5    -8.1566D-15   5.8452D-15   2.1197D-15  -9.7363D-17  -1.8468D-15  -2.2919D-16   2.0043D-16  -2.6865D-16  -1.2740D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HOHENFRG  HYD  DER_NORT   1.3772D-04   6.3700D-05  -1.8389D-05   3.6832D-05  -7.1235D-06   4.1599D-06   6.3182D-06  -7.3212D-07   1.3670D-07  
D  HOHENFRG  HYD  DER_EAST  -9.7174D-06  -2.2045D-05  -1.8408D-05   4.3599D-06  -1.4844D-05  -1.2393D-05  -8.9273D-06   2.3237D-06  -9.6963D-08  
D  HOHENFRG  HYD  CHEB_0     7.6154D-09   1.2313D-11   9.0500D-12  -1.4701D-12  -7.9187D-12   1.1118D-11  -1.6644D-11  -7.3229D-13  -1.6880D-12  
D  HOHENFRG  HYD  CHEB_1    -5.4725D-12   1.2003D-11   6.1756D-12  -2.8196D-13   8.6525D-13  -4.0137D-13  -9.9691D-14  -1.8528D-13  -4.9757D-13  
D  HOHENFRG  HYD  CHEB_2    -3.2768D-12   1.4788D-12   8.9688D-13  -1.6281D-14   2.5173D-13  -9.5108D-14  -7.0308D-15  -3.9377D-14  -8.2498D-14  
D  HOHENFRG  HYD  CHEB_3    -1.7473D-12  -3.7560D-13  -1.8464D-13   2.4749D-14   3.4087D-15  -3.6619D-15   6.2482D-15   2.4534D-15   1.0242D-14  
D  HOHENFRG  HYD  CHEB_4    -6.8436D-13   3.0467D-14   1.1404D-15  -3.5260D-16  -8.9029D-15   1.1709D-15   3.6525D-15  -4.4053D-16  -1.8902D-15  
D  HOHENFRG  HYD  CHEB_5    -1.1202D-13  -2.5937D-15   2.5811D-15  -1.4263D-15   2.8432D-15   9.9544D-16   2.7040D-17   1.2310D-15   1.5477D-15  
#
D  HOHENFRG  NHY  DER_NORT   2.5681D-04  -1.4302D-04   4.2416D-05  -2.7608D-05  -2.4177D-04  -1.2226D-04   1.9396D-04   2.8848D-05   2.4795D-04  
D  HOHENFRG  NHY  DER_EAST  -2.5738D-04  -4.1605D-04  -7.2713D-05   2.7294D-04  -1.6969D-04  -3.2157D-04  -7.8133D-05  -2.0959D-04   8.7011D-05  
D  HOHENFRG  NHY  CHEB_0     3.8518D-10  -1.2921D-10  -8.6522D-11   2.5529D-11   6.5569D-12  -3.8139D-12   1.8009D-11  -6.4034D-13   8.2343D-12  
D  HOHENFRG  NHY  CHEB_1     2.2732D-11  -7.4180D-12  -4.7459D-12   1.6568D-12   2.4698D-13  -3.3065D-13   1.2941D-12  -9.6935D-14   2.6849D-13  
D  HOHENFRG  NHY  CHEB_2     4.1658D-12  -1.3419D-12  -8.3799D-13   3.1846D-13   1.2071D-14  -7.0379D-14   2.5856D-13  -2.1635D-14   3.7678D-14  
D  HOHENFRG  NHY  CHEB_3    -4.0332D-13   1.4367D-13   9.8544D-14  -2.8258D-14  -1.0990D-14   1.7468D-15  -2.5224D-14   9.6069D-15  -6.8407D-15  
D  HOHENFRG  NHY  CHEB_4    -4.9586D-14   1.1448D-14   1.0479D-14  -7.5081D-16  -2.7331D-15   1.1710D-15   1.3763D-15   6.4436D-16  -2.8610D-15  
D  HOHENFRG  NHY  CHEB_5    -2.0560D-14   1.2695D-14   3.7318D-15  -5.5712D-15   2.2258D-15   3.6090D-16  -4.0424D-15   1.6906D-15   8.2858D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HOHNBERG  HYD  DER_NORT   8.8610D-05   2.5500D-05  -1.4700D-05   2.4241D-05   2.0664D-05  -6.9556D-06   1.4329D-05  -1.1699D-06   1.1062D-06  
D  HOHNBERG  HYD  DER_EAST  -2.0104D-05  -2.1003D-05  -6.0973D-06  -9.7605D-07  -5.4020D-06  -3.6224D-06  -1.2179D-05   1.4295D-06  -5.0789D-07  
D  HOHNBERG  HYD  CHEB_0     6.9139D-09   1.3235D-11  -8.8775D-12   1.1462D-11  -5.6164D-12   9.0526D-12  -1.2041D-11  -6.7407D-13  -2.2998D-13  
D  HOHNBERG  HYD  CHEB_1     4.9009D-12   1.0067D-11   5.9771D-12  -9.3765D-13   5.6856D-13  -2.1163D-13  -5.6000D-13  -9.6902D-14  -4.1970D-13  
D  HOHNBERG  HYD  CHEB_2    -1.4079D-12   1.3028D-12   9.0216D-13  -1.1369D-13   2.0054D-13  -4.6730D-14  -8.6193D-14  -3.0746D-14  -7.4622D-14  
D  HOHNBERG  HYD  CHEB_3    -1.8256D-12  -2.9420D-13  -1.5378D-13   2.5285D-14   2.1610D-14  -1.3789D-15   2.0832D-14  -6.5938D-15   4.6945D-15  
D  HOHNBERG  HYD  CHEB_4    -6.2393D-13   1.3395D-14   2.9488D-15   2.7784D-15  -7.7902D-15  -1.1892D-15   3.2235D-15   1.7152D-15  -4.7099D-16  
D  HOHNBERG  HYD  CHEB_5    -9.2480D-14   2.1193D-15  -4.4856D-15   6.7231D-16  -4.3846D-17  -2.7065D-15  -4.7067D-15  -8.5749D-16   1.8257D-16  
#
D  HOHNBERG  NHY  DER_NORT   1.6126D-03  -1.4736D-03   3.7816D-04  -1.4850D-04  -2.3456D-04   3.4769D-04   1.9496D-04   3.0264D-04   8.7394D-04  
D  HOHNBERG  NHY  DER_EAST  -3.0161D-05  -5.3662D-04   7.4213D-05   2.4768D-04   8.4797D-05  -7.1377D-05  -2.0610D-04   4.6288D-05  -6.2221D-05  
D  HOHNBERG  NHY  CHEB_0     3.0966D-10  -1.3168D-10  -6.6361D-11   2.3604D-11   2.1878D-12  -4.4725D-12   2.5780D-11  -1.7040D-12   8.1629D-12  
D  HOHNBERG  NHY  CHEB_1     1.9626D-11  -8.4119D-12  -3.3915D-12   1.1941D-12   2.7536D-13  -1.1820D-13   1.0604D-12   6.0333D-14   4.6407D-13  
D  HOHNBERG  NHY  CHEB_2     3.7291D-12  -1.6191D-12  -5.6554D-13   2.0898D-13   4.6598D-14  -3.3211D-15   1.5291D-13   5.0407D-14   1.1592D-13  
D  HOHNBERG  NHY  CHEB_3    -2.7476D-13   1.0782D-13   7.9873D-14  -2.5333D-14  -3.3787D-15   8.1436D-15  -3.6516D-14   2.1125D-14   6.8814D-15  
D  HOHNBERG  NHY  CHEB_4    -5.1546D-14   2.1591D-14   8.8707D-15  -6.1021D-15   1.5033D-15  -5.8526D-16  -1.3361D-15   5.5350D-15  -9.9831D-17  
D  HOHNBERG  NHY  CHEB_5    -5.8822D-15   2.9160D-15  -7.4824D-17  -2.7395D-16  -1.9402D-16  -1.2639D-16  -9.6669D-16  -2.3372D-15  -7.6391D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  HRAS_085  HYD  DER_NORT   1.0428D-04   6.9439D-05   3.1639D-05  -2.3632D-05  -1.4003D-05   4.8013D-07   1.1172D-05  -3.0845D-07   1.2995D-06  
D  HRAS_085  HYD  DER_EAST   9.1007D-06   7.9429D-06   5.3177D-06  -9.3622D-07   3.1142D-06   1.6534D-05   1.5123D-06   5.4677D-07   6.8328D-07  
D  HRAS_085  HYD  CHEB_0     6.4111D-09   4.0027D-12  -6.9866D-12   6.8417D-12   3.3071D-12  -1.0312D-12  -2.0926D-12   3.4872D-12   2.4014D-12  
D  HRAS_085  HYD  CHEB_1    -1.7547D-12   8.3380D-12   4.6276D-12   6.3376D-13  -4.3851D-13   7.5638D-13   2.0820D-13   6.1601D-13   1.5051D-13  
D  HRAS_085  HYD  CHEB_2    -2.0425D-12   1.3839D-12   7.1485D-13   1.2016D-13  -2.5881D-14   1.6204D-13   6.7746D-14   1.0380D-13   2.8315D-14  
D  HRAS_085  HYD  CHEB_3    -1.5403D-12  -1.8140D-13  -1.2484D-13   9.4346D-15   4.1702D-14   8.2243D-16  -4.5112D-15  -9.9535D-15  -2.2601D-15  
D  HRAS_085  HYD  CHEB_4    -5.9504D-13  -3.4962D-15  -4.0455D-15  -1.0721D-15  -2.3176D-15  -8.3367D-16  -4.9044D-16   2.0065D-15   4.2023D-16  
D  HRAS_085  HYD  CHEB_5    -7.4525D-14   1.7027D-15   1.7652D-15  -2.7305D-15  -5.1059D-16  -7.2370D-17  -3.6572D-16  -9.5383D-16  -2.2246D-16  
#
D  HRAS_085  NHY  DER_NORT   1.5019D-03   3.6278D-04  -4.1784D-04  -5.0134D-04   2.0094D-04  -2.5099D-04   3.7776D-04  -1.2928D-04  -3.4160D-04  
D  HRAS_085  NHY  DER_EAST  -1.3612D-04   1.8300D-04   6.1117D-04  -4.3118D-04  -5.7776D-04   2.8437D-04   4.3627D-04  -1.4992D-04   3.3368D-04  
D  HRAS_085  NHY  CHEB_0     3.2294D-10  -1.9033D-10  -1.0585D-10   1.7432D-11   7.4494D-11   2.7892D-11   1.6206D-13  -3.4212D-12  -1.8240D-12  
D  HRAS_085  NHY  CHEB_1     1.9788D-11  -1.0816D-11  -6.3502D-12   5.8989D-13   3.7670D-12   1.4892D-12   3.8706D-13   5.7585D-13  -1.1881D-13  
D  HRAS_085  NHY  CHEB_2     3.7302D-12  -1.9481D-12  -1.1768D-12   5.9850D-14   6.4462D-13   2.8022D-13   1.1418D-13   1.6992D-13  -5.7278D-14  
D  HRAS_085  NHY  CHEB_3    -2.9435D-13   1.9820D-13   1.0760D-13  -2.5477D-14  -8.8785D-14  -2.7997D-14   1.1764D-14   1.8089D-14  -1.2907D-14  
D  HRAS_085  NHY  CHEB_4    -4.5740D-14   2.6551D-14   1.7190D-14  -2.5965D-15  -1.2442D-14  -3.4352D-15  -5.1641D-17  -2.0937D-15   1.9564D-15  
D  HRAS_085  NHY  CHEB_5    -1.0272D-14   4.6400D-15   3.7451D-15   7.1806D-16  -2.5190D-15  -2.2746D-15  -8.8233D-17   8.4735D-16  -8.6632D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  JODRELL1  HYD  DER_NORT   1.1506D-04   6.1956D-05  -2.6280D-05   3.3763D-05  -9.9027D-06   9.7922D-06  -3.2100D-06  -1.4280D-07   1.0270D-06  
D  JODRELL1  HYD  DER_EAST   9.8339D-06   1.7921D-06  -2.7959D-05   4.0536D-06  -2.6954D-05  -9.9087D-06   1.3728D-05  -1.0025D-06  -6.2028D-07  
D  JODRELL1  HYD  CHEB_0     7.5892D-09   4.3176D-14   2.1490D-11  -2.8675D-12   7.1089D-13   1.7783D-11  -1.8214D-11  -8.5530D-14  -7.0396D-13  
D  JODRELL1  HYD  CHEB_1    -4.9607D-12   9.6391D-12   5.2737D-12   3.6787D-13  -4.1552D-13  -8.8379D-13   1.1694D-13   7.7427D-14  -5.3428D-13  
D  JODRELL1  HYD  CHEB_2    -2.9998D-12   1.1430D-12   7.1583D-13   1.2846D-13  -9.0082D-15  -1.7409D-13   4.1839D-14   1.8531D-14  -9.1545D-14  
D  JODRELL1  HYD  CHEB_3    -1.7070D-12  -3.2543D-13  -1.6719D-13   2.2733D-15   2.3057D-14   3.2951D-15   5.3335D-15  -1.3663D-15   8.8179D-15  
D  JODRELL1  HYD  CHEB_4    -7.0783D-13   2.5130D-14   3.3938D-15  -9.0121D-15  -4.7011D-15   1.5757D-15  -7.3682D-16  -2.5750D-15  -1.0978D-15  
D  JODRELL1  HYD  CHEB_5    -1.0522D-13  -8.2768D-17  -1.0336D-15   4.5402D-15  -1.5223D-15  -9.7573D-16   1.6736D-15   8.9636D-16   5.9073D-16  
#
D  JODRELL1  NHY  DER_NORT   6.0531D-06  -1.4721D-04  -6.2786D-05   2.3992D-04  -2.5312D-04   2.2173D-04   3.9269D-04  -9.5596D-07   1.3430D-04  
D  JODRELL1  NHY  DER_EAST   2.7959D-04  -3.4313D-04  -1.1207D-04  -2.5523D-04   6.7786D-05   1.9312D-04   2.7497D-04  -8.0702D-05  -1.7340D-04  
D  JODRELL1  NHY  CHEB_0     3.8493D-10  -1.1260D-10  -7.6106D-11   1.1394D-11   1.7017D-11   3.1921D-12   1.2357D-11  -6.1689D-12   6.2986D-12  
D  JODRELL1  NHY  CHEB_1     2.2394D-11  -5.9808D-12  -4.3561D-12   7.2348D-13   8.9543D-13   1.9128D-13   8.0769D-13  -4.2229D-13   5.0376D-13  
D  JODRELL1  NHY  CHEB_2     4.1038D-12  -1.0444D-12  -7.8283D-13   1.2222D-13   1.2955D-13   3.5118D-14   1.6503D-13  -8.3921D-14   8.8190D-14  
D  JODRELL1  NHY  CHEB_3    -3.9504D-13   1.2742D-13   8.8634D-14  -1.9897D-14  -2.4823D-14   1.1988D-19  -9.9846D-15   2.6238D-15  -1.4440D-14  
D  JODRELL1  NHY  CHEB_4    -5.0765D-14   1.3208D-14   5.7766D-15  -6.8432D-16  -4.1496D-15  -7.8907D-16   2.4235D-15   2.8125D-15   1.7876D-15  
D  JODRELL1  NHY  CHEB_5    -1.6081D-14   5.1821D-15   4.4164D-15  -9.4397D-16   1.7903D-15   1.0923D-15  -2.2447D-15  -7.8155D-16  -1.8981D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  JODRELL2  HYD  DER_NORT   1.1456D-04   6.1891D-05  -2.6262D-05   3.3707D-05  -9.8724D-06   9.7298D-06  -3.2425D-06  -1.4176D-07   9.8693D-07  
D  JODRELL2  HYD  DER_EAST   9.9520D-06   1.8792D-06  -2.7879D-05   4.0258D-06  -2.6918D-05  -9.9108D-06   1.3688D-05  -1.0475D-06  -6.5161D-07  
D  JODRELL2  HYD  CHEB_0     7.6211D-09   6.7771D-13   2.1876D-11  -2.8724D-12   6.8760D-13   1.7819D-11  -1.8302D-11  -2.1868D-13  -9.1756D-13  
D  JODRELL2  HYD  CHEB_1    -5.6148D-12   9.6770D-12   5.2917D-12   3.6420D-13  -4.1563D-13  -8.8796D-13   1.1747D-13   6.3328D-14  -5.5375D-13  
D  JODRELL2  HYD  CHEB_2    -3.1107D-12   1.1473D-12   7.1526D-13   1.2968D-13  -8.8285D-15  -1.7533D-13   4.2530D-14   1.4764D-14  -9.6171D-14  
D  JODRELL2  HYD  CHEB_3    -1.7024D-12  -3.2669D-13  -1.6692D-13   5.1219D-16   2.2367D-14   4.1235D-15   4.8856D-15  -6.9570D-16   9.8027D-15  
D  JODRELL2  HYD  CHEB_4    -7.0778D-13   2.4459D-14   2.5306D-15  -7.2210D-15  -4.3661D-15   9.9509D-16  -1.2234D-16  -2.4579D-15  -1.3243D-15  
D  JODRELL2  HYD  CHEB_5    -1.0669D-13  -8.5467D-17  -1.3062D-16   3.8783D-15  -2.1413D-15  -7.0624D-16   1.6070D-15   1.4465D-15   1.1731D-15  
#
D  JODRELL2  NHY  DER_NORT   3.7502D-06  -1.4635D-04  -6.3290D-05   2.3925D-04  -2.5295D-04   2.1997D-04   3.9044D-04  -3.6050D-06   1.3273D-04  
D  JODRELL2  NHY  DER_EAST   2.8334D-04  -3.4176D-04  -1.1517D-04  -2.5457D-04   6.6716D-05   1.9093D-04   2.7308D-04  -8.0286D-05  -1.7396D-04  
D  JODRELL2  NHY  CHEB_0     3.9145D-10  -1.1396D-10  -7.7247D-11   1.1465D-11   1.7244D-11   3.2253D-12   1.2528D-11  -6.3081D-12   6.2776D-12  
D  JODRELL2  NHY  CHEB_1     2.2701D-11  -6.0300D-12  -4.3996D-12   7.2313D-13   8.9998D-13   1.9045D-13   8.1489D-13  -4.2815D-13   4.9829D-13  
D  JODRELL2  NHY  CHEB_2     4.1533D-12  -1.0471D-12  -7.8857D-13   1.2169D-13   1.2979D-13   3.4891D-14   1.6475D-13  -8.7489D-14   8.6675D-14  
D  JODRELL2  NHY  CHEB_3    -4.0369D-13   1.2752D-13   9.0177D-14  -2.0592D-14  -2.5438D-14  -4.3660D-16  -9.7309D-15   4.3625D-15  -1.4864D-14  
D  JODRELL2  NHY  CHEB_4    -5.4449D-14   1.8244D-14   6.8424D-15  -9.2769D-16  -4.1084D-15  -4.8007D-16   1.4201D-15   1.4897D-15   1.1957D-15  
D  JODRELL2  NHY  CHEB_5    -1.8505D-14   4.0693D-15   5.5563D-15  -1.6722D-15   2.4957D-15   1.2447D-15  -2.3089D-15   1.0065D-16  -2.6847D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  JPL_MV1   HYD  DER_NORT   3.5290D-05   1.0592D-05   8.2212D-06  -1.5839D-05  -1.0916D-05   1.7283D-06  -2.9714D-06  -7.4907D-06   3.4889D-07  
D  JPL_MV1   HYD  DER_EAST   6.6717D-06  -2.3744D-05  -1.7423D-05  -2.8143D-06   1.1517D-05  -1.3737D-05   4.1597D-06   1.0364D-06  -2.2078D-07  
D  JPL_MV1   HYD  CHEB_0     7.3221D-09   3.3105D-11   8.7377D-12   7.4706D-12   8.9021D-13   1.0304D-12  -1.6711D-12   4.1302D-12   2.5007D-12  
D  JPL_MV1   HYD  CHEB_1    -1.7742D-11   1.0979D-11   5.9177D-12  -1.1884D-12  -1.0893D-12   1.3824D-12   1.3554D-12   7.0287D-13   1.8308D-13  
D  JPL_MV1   HYD  CHEB_2    -4.9063D-12   1.6722D-12   8.9716D-13  -1.6989D-13  -1.2768D-13   2.7791D-13   2.2326D-13   1.1064D-13   3.8582D-14  
D  JPL_MV1   HYD  CHEB_3    -1.3771D-12  -2.6889D-13  -1.4863D-13   3.6535D-14   3.2729D-14  -1.4418D-14  -3.4693D-14  -1.8567D-15  -1.1617D-14  
D  JPL_MV1   HYD  CHEB_4    -6.9087D-13  -2.2576D-14  -1.3633D-14   4.8983D-15   1.4518D-15  -7.3388D-15  -1.3773D-15   9.6514D-16   1.9077D-17  
D  JPL_MV1   HYD  CHEB_5    -7.3091D-14   1.1935D-14   7.8354D-15  -4.0243D-15  -6.2460D-15   3.4717D-15  -3.1684D-16  -9.9563D-16   2.9682D-16  
#
D  JPL_MV1   NHY  DER_NORT  -2.1718D-03  -4.3172D-04  -8.1100D-04  -5.4913D-05   7.8633D-04   3.2960D-04  -3.7983D-04   4.4006D-04   5.4751D-04  
D  JPL_MV1   NHY  DER_EAST   1.1735D-03  -1.2081D-03  -3.1431D-04  -3.3569D-05   5.5787D-04   4.6883D-04  -8.5861D-04  -1.4905D-04  -1.7515D-04  
D  JPL_MV1   NHY  CHEB_0     2.8691D-10  -1.0427D-10  -5.4104D-11   2.0050D-12   5.2556D-11  -2.3028D-11  -4.1230D-11  -3.6554D-12  -3.4329D-12  
D  JPL_MV1   NHY  CHEB_1     1.6706D-11  -6.0545D-12  -2.7644D-12  -1.5960D-13   2.4873D-12  -1.0295D-12  -1.8832D-12  -2.8367D-13  -4.2644D-13  
D  JPL_MV1   NHY  CHEB_2     3.1093D-12  -1.1149D-12  -4.7976D-13  -4.7200D-14   4.1808D-13  -1.6921D-13  -3.0820D-13  -5.9219D-14  -8.0587D-14  
D  JPL_MV1   NHY  CHEB_3    -2.6753D-13   1.0613D-13   5.7929D-14  -8.8416D-15  -6.1498D-14   2.5391D-14   5.1409D-14   5.0336D-15  -4.1019D-16  
D  JPL_MV1   NHY  CHEB_4    -4.6191D-14   1.9616D-14   1.0819D-14  -1.8766D-15  -1.0974D-14   2.1638D-16   1.0621D-14   5.8359D-15   5.9351D-16  
D  JPL_MV1   NHY  CHEB_5    -7.5624D-15   2.5337D-15  -7.3343D-16  -9.6229D-17  -5.9021D-17   1.4122D-15  -4.5710D-17  -1.9366D-15  -3.8497D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KAINAN    HYD  DER_NORT   1.5503D-04   7.4018D-05   5.1330D-05   7.7797D-06  -2.7165D-05  -6.0654D-06  -6.1263D-06  -2.2136D-07   2.1149D-06  
D  KAINAN    HYD  DER_EAST   2.4897D-05   2.7751D-06  -1.1224D-05   2.8251D-06  -8.9379D-06   2.6885D-06  -2.9222D-06  -1.6587D-07   1.7012D-06  
D  KAINAN    HYD  CHEB_0     7.7010D-09   6.7493D-11   1.6242D-11  -7.5908D-13  -6.2060D-12  -2.4921D-13  -6.7182D-13  -2.4559D-12   4.3876D-12  
D  KAINAN    HYD  CHEB_1    -2.1833D-11   1.5622D-11   1.0366D-11  -7.6927D-13  -1.9202D-12  -1.7288D-13   4.3659D-13  -3.8718D-13   5.7660D-13  
D  KAINAN    HYD  CHEB_2    -5.4499D-12   2.3196D-12   1.6199D-12  -5.2089D-14  -2.0526D-13  -2.1501D-14   8.8826D-14  -6.5435D-14   8.7220D-14  
D  KAINAN    HYD  CHEB_3    -1.2880D-12  -4.4312D-13  -3.0411D-13   3.6539D-14   6.2762D-14   1.1902D-14  -7.2195D-15   9.5766D-15  -8.6810D-15  
D  KAINAN    HYD  CHEB_4    -6.8038D-13   5.9711D-15   1.9139D-15   2.0964D-15  -4.8183D-15   1.4791D-15  -4.6701D-15   7.6364D-17  -2.5188D-15  
D  KAINAN    HYD  CHEB_5    -1.2760D-13  -1.6006D-15   4.0727D-15  -3.6877D-15   2.7626D-15  -5.1438D-16   2.3453D-15   1.6702D-15   1.5649D-15  
#
D  KAINAN    NHY  DER_NORT   2.1204D-03   8.1962D-04   2.8294D-04  -1.0567D-04   1.5090D-05   2.3235D-04   3.9125D-04  -2.6299D-04   3.3844D-05  
D  KAINAN    NHY  DER_EAST   4.8849D-04  -5.8497D-05  -3.3823D-04  -1.5068D-04  -2.6602D-04   1.6577D-04   1.4665D-04  -6.3025D-05  -1.0290D-04  
D  KAINAN    NHY  CHEB_0     5.8043D-10  -3.7931D-10  -2.3709D-10   8.2214D-11   1.2030D-10  -2.2123D-11  -5.1082D-11   1.1442D-11   3.4690D-12  
D  KAINAN    NHY  CHEB_1     3.0977D-11  -1.7736D-11  -1.2068D-11   2.7133D-12   4.7829D-12  -6.4911D-13  -1.9935D-12   5.5728D-13  -2.7448D-13  
D  KAINAN    NHY  CHEB_2     5.4300D-12  -2.9144D-12  -2.0172D-12   3.7597D-13   6.6956D-13  -1.2889D-13  -2.6923D-13   7.1697D-14  -6.5833D-14  
D  KAINAN    NHY  CHEB_3    -6.4179D-13   4.7346D-13   2.9358D-13  -1.1423D-13  -1.8301D-13   9.9201D-15   8.6899D-14  -1.6024D-14   1.8467D-14  
D  KAINAN    NHY  CHEB_4    -1.0283D-13   6.9129D-14   4.2893D-14  -2.1900D-14  -2.4917D-14   8.5434D-15   1.1295D-14  -5.0533D-15   7.3045D-15  
D  KAINAN    NHY  CHEB_5    -1.5294D-15   5.6622D-16  -6.3622D-16   3.2058D-15   3.0815D-15  -2.5703D-15  -3.1359D-15   4.7508D-15  -2.2530D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KANOZAN   HYD  DER_NORT   1.4873D-04   7.9441D-05   5.3001D-05   1.1486D-05  -2.5917D-05  -4.7483D-06  -1.3993D-05   6.7022D-07  -9.2624D-07  
D  KANOZAN   HYD  DER_EAST  -5.7713D-05   4.9122D-06  -9.7948D-06  -5.2138D-06  -1.5232D-05   5.3656D-06  -1.5982D-06   4.1649D-08  -1.9061D-06  
D  KANOZAN   HYD  CHEB_0     7.4213D-09   4.6265D-11   4.5641D-12  -3.3568D-12  -4.9946D-12  -1.0525D-13  -7.2977D-13  -1.6493D-12   2.7773D-12  
D  KANOZAN   HYD  CHEB_1    -1.3285D-11   1.5362D-11   1.1123D-11  -7.6063D-13  -1.6098D-12  -4.7010D-13   2.4890D-13  -3.2855D-13   4.3574D-13  
D  KANOZAN   HYD  CHEB_2    -4.4531D-12   2.2827D-12   1.6130D-12  -6.6887D-14  -2.3202D-13  -3.0597D-14   3.4365D-14  -6.9618D-14   3.5434D-14  
D  KANOZAN   HYD  CHEB_3    -1.3583D-12  -4.1052D-13  -2.8680D-13   3.1573D-14   5.0344D-14   1.4447D-14  -9.8574D-15   1.4312D-14  -1.2813D-14  
D  KANOZAN   HYD  CHEB_4    -6.6734D-13  -1.1126D-14  -1.6610D-15  -4.0494D-15   8.6071D-15  -6.2767D-15   2.0447D-15   1.4798D-15   3.3023D-15  
D  KANOZAN   HYD  CHEB_5    -1.1677D-13   3.2527D-15   1.9949D-15   3.8654D-15  -2.7041D-15   2.0610D-15  -1.0356D-16  -1.5076D-15  -1.1160D-15  
#
D  KANOZAN   NHY  DER_NORT   1.1089D-03   1.0323D-03   8.0092D-05   2.3920D-04   5.5367D-04  -4.8741D-05   1.4009D-04  -5.8328D-04   6.0991D-04  
D  KANOZAN   NHY  DER_EAST   1.1313D-04   8.0322D-04   2.3940D-05  -3.6395D-04  -7.5246D-05   1.6355D-04  -9.9835D-05  -2.7029D-04   1.1909D-04  
D  KANOZAN   NHY  CHEB_0     5.0051D-10  -3.2677D-10  -2.1822D-10   5.0159D-11   1.0470D-10  -1.2555D-11  -4.9225D-11   8.6894D-12   1.9354D-12  
D  KANOZAN   NHY  CHEB_1     2.7535D-11  -1.5463D-11  -1.1420D-11   1.3101D-12   4.3397D-12  -2.5178D-13  -1.8139D-12   6.3751D-13  -2.1832D-13  
D  KANOZAN   NHY  CHEB_2     4.8993D-12  -2.5468D-12  -1.9600D-12   1.0770D-13   6.2815D-13   3.6692D-15  -2.0543D-13   1.3707D-13  -5.5009D-14  
D  KANOZAN   NHY  CHEB_3    -5.3953D-13   3.9347D-13   2.6317D-13  -7.3278D-14  -1.4764D-13   1.8350D-14   8.0930D-14   7.6959D-16  -9.1986D-15  
D  KANOZAN   NHY  CHEB_4    -6.9544D-14   3.7467D-14   2.8789D-14  -2.7310D-15  -1.0671D-14   1.2724D-15   2.1058D-15  -3.4619D-15   2.4054D-16  
D  KANOZAN   NHY  CHEB_5    -1.6074D-14   1.2187D-14   9.2719D-15  -3.7665D-16  -4.2383D-15  -2.2530D-15   1.6402D-15   7.9983D-16  -9.7582D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KARLBURG  HYD  DER_NORT   1.2961D-04   6.4957D-05  -1.2857D-05   3.3369D-05  -1.0713D-05   7.4835D-06   1.4155D-06  -3.1938D-07   8.7339D-08  
D  KARLBURG  HYD  DER_EAST  -2.8484D-05  -2.3253D-05  -1.8841D-05   3.6561D-06  -1.1395D-05  -1.4233D-05  -6.8934D-06   1.3574D-06   5.4694D-08  
D  KARLBURG  HYD  CHEB_0     7.6718D-09   9.7993D-12   1.1146D-11  -6.6312D-12  -8.2942D-12   8.3092D-12  -1.5191D-11  -4.8309D-15  -1.0735D-12  
D  KARLBURG  HYD  CHEB_1    -5.5881D-12   1.2912D-11   6.5857D-12  -4.3250D-13   1.0368D-12  -3.0745D-13   3.5803D-13  -1.2123D-13  -4.2874D-13  
D  KARLBURG  HYD  CHEB_2    -3.3153D-12   1.6097D-12   9.6002D-13  -2.8754D-14   2.6656D-13  -8.1186D-14   6.2536D-14  -1.6464D-14  -6.8820D-14  
D  KARLBURG  HYD  CHEB_3    -1.7607D-12  -4.0514D-13  -1.8396D-13   2.2900D-14  -7.5054D-15  -6.9141D-15  -2.8177D-15  -2.0344D-15   6.2034D-15  
D  KARLBURG  HYD  CHEB_4    -6.9733D-13   2.6620D-14  -2.3218D-15  -4.2612D-16  -4.6637D-15   9.8052D-16  -1.8803D-16  -1.9445D-16   5.0567D-16  
D  KARLBURG  HYD  CHEB_5    -1.0938D-13   2.5972D-15   2.6037D-15  -9.2202D-16  -1.8462D-15   2.3128D-16   1.0936D-15   2.5386D-16  -3.9802D-16  
#
D  KARLBURG  NHY  DER_NORT   4.7391D-04  -2.8029D-04   6.2818D-05  -2.6641D-04   7.2375D-05  -1.2524D-04   3.8170D-05   1.3412D-04   2.9556D-04  
D  KARLBURG  NHY  DER_EAST  -2.0316D-04  -4.3741D-04   1.5685D-06   1.4452D-04  -1.1547D-04   1.6728D-05  -8.3497D-05  -1.8145D-04   6.4351D-05  
D  KARLBURG  NHY  CHEB_0     3.8630D-10  -1.3801D-10  -8.9513D-11   3.5124D-11   2.9866D-12  -6.2988D-12   1.5023D-11  -2.8438D-12   1.9467D-12  
D  KARLBURG  NHY  CHEB_1     2.2829D-11  -7.7141D-12  -5.0227D-12   1.8902D-12   1.9287D-13  -1.2873D-13   8.8802D-13  -1.2970D-13  -3.1162D-14  
D  KARLBURG  NHY  CHEB_2     4.1343D-12  -1.3454D-12  -8.7342D-13   3.2747D-13   3.5846D-14  -9.8428D-15   1.4834D-13   7.2124D-15  -4.1937D-15  
D  KARLBURG  NHY  CHEB_3    -3.9855D-13   1.4586D-13   9.9924D-14  -3.9074D-14  -1.9291D-15   1.3651D-14  -1.2567D-14   9.9487D-15   1.2125D-15  
D  KARLBURG  NHY  CHEB_4    -6.9770D-14   3.3599D-14   1.8549D-14  -6.1329D-15  -2.1802D-15  -1.7034D-15  -9.3747D-15   3.1476D-15  -9.5974D-16  
D  KARLBURG  NHY  CHEB_5    -4.3650D-15  -5.0237D-15  -2.0817D-16  -1.4246D-16   6.7096D-16   1.2901D-15   4.2103D-15  -2.3975D-15   3.5201D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KASHIM11  HYD  DER_NORT   1.0863D-04   7.2948D-05   4.7376D-05   9.2556D-06  -2.0646D-05  -3.0714D-06  -1.2691D-05   2.9051D-07  -5.4293D-07  
D  KASHIM11  HYD  DER_EAST  -7.5476D-05   2.4274D-06  -1.1792D-05  -6.7431D-06  -1.5474D-05   5.8966D-06  -1.9212D-06   5.9088D-07  -3.1564D-06  
D  KASHIM11  HYD  CHEB_0     7.6928D-09   5.6073D-11   8.8772D-12  -3.6787D-12  -5.0925D-12  -4.6911D-13  -1.4169D-12  -1.6857D-12   4.0667D-12  
D  KASHIM11  HYD  CHEB_1    -1.8724D-11   1.6231D-11   1.1683D-11  -6.3752D-13  -1.7289D-12  -6.0586D-13   6.1691D-14  -3.1645D-13   5.1162D-13  
D  KASHIM11  HYD  CHEB_2    -5.0210D-12   2.2752D-12   1.6576D-12  -9.5702D-15  -2.3039D-13  -4.4952D-14  -1.4680D-15  -5.3339D-14   7.1534D-14  
D  KASHIM11  HYD  CHEB_3    -1.3584D-12  -4.5433D-13  -3.2923D-13   1.7243D-14   5.9964D-14   7.1708D-15  -7.4934D-15   1.5906D-14  -1.8976D-14  
D  KASHIM11  HYD  CHEB_4    -7.0233D-13   2.1716D-14   1.5579D-14   1.4508D-15   1.7253D-14   2.6204D-15   2.5557D-15  -1.0675D-15   3.2005D-15  
D  KASHIM11  HYD  CHEB_5    -1.1963D-13  -7.8862D-15  -3.5732D-15   1.9881D-15  -5.2659D-15   7.9840D-17   7.3076D-16  -8.3066D-16   2.5801D-16  
#
D  KASHIM11  NHY  DER_NORT   1.5377D-03   8.0909D-04   5.0302D-05   7.8504D-05   3.2598D-04   5.6816D-05  -1.9839D-04  -3.7820D-04   2.2039D-04  
D  KASHIM11  NHY  DER_EAST  -1.5607D-04   1.2442D-03   1.3338D-04  -3.1735D-04   1.1238D-04   4.9640D-05  -6.7946D-05  -3.0659D-04   3.7319D-04  
D  KASHIM11  NHY  CHEB_0     5.5142D-10  -3.4935D-10  -2.3268D-10   4.4780D-11   1.0402D-10  -1.1422D-11  -4.8319D-11   1.3109D-11   4.1382D-12  
D  KASHIM11  NHY  CHEB_1     2.9499D-11  -1.6326D-11  -1.1299D-11   1.4137D-12   4.0830D-12  -3.5360D-13  -1.7206D-12   5.6376D-13   5.8229D-13  
D  KASHIM11  NHY  CHEB_2     5.1611D-12  -2.6359D-12  -1.9011D-12   1.4850D-13   5.9396D-13  -4.7613D-14  -2.0190D-13   8.9464D-14   9.3458D-14  
D  KASHIM11  NHY  CHEB_3    -5.9980D-13   4.1545D-13   2.6023D-13  -6.9040D-14  -1.2935D-13   2.0945D-14   7.7297D-14  -1.8106D-14  -2.7841D-14  
D  KASHIM11  NHY  CHEB_4    -8.2260D-14   5.3315D-14   3.1998D-14  -6.4259D-15  -1.4849D-14   2.0608D-15   5.4803D-15   3.9746D-16  -5.0748D-15  
D  KASHIM11  NHY  CHEB_5    -1.1268D-14   2.3004D-15   4.8283D-15   1.1604D-15  -3.8680D-16   8.1017D-16  -2.7214D-16  -1.1686D-15  -1.3393D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KASHIM34  HYD  DER_NORT   1.0900D-04   7.3154D-05   4.7437D-05   9.2564D-06  -2.0699D-05  -3.0877D-06  -1.2740D-05   2.8569D-07  -5.3811D-07  
D  KASHIM34  HYD  DER_EAST  -7.5636D-05   2.5550D-06  -1.1856D-05  -6.7563D-06  -1.5534D-05   5.9264D-06  -1.9142D-06   5.7126D-07  -3.0387D-06  
D  KASHIM34  HYD  CHEB_0     7.6786D-09   5.5527D-11   8.5962D-12  -3.6999D-12  -5.0744D-12  -4.6193D-13  -1.4061D-12  -1.6723D-12   3.9640D-12  
D  KASHIM34  HYD  CHEB_1    -1.8404D-11   1.6210D-11   1.1670D-11  -6.3983D-13  -1.7281D-12  -6.0578D-13   6.2515D-14  -3.1652D-13   5.0335D-13  
D  KASHIM34  HYD  CHEB_2    -4.9652D-12   2.2753D-12   1.6587D-12  -1.0324D-14  -2.3024D-13  -4.4919D-14  -9.7656D-16  -5.3213D-14   7.0403D-14  
D  KASHIM34  HYD  CHEB_3    -1.3632D-12  -4.5316D-13  -3.2873D-13   1.7856D-14   5.9655D-14   7.2247D-15  -7.7714D-15   1.5640D-14  -1.8949D-14  
D  KASHIM34  HYD  CHEB_4    -6.9997D-13   2.1621D-14   1.5746D-14   9.3247D-16   1.7407D-14   2.5312D-15   2.7068D-15  -8.1611D-16   3.1961D-15  
D  KASHIM34  HYD  CHEB_5    -1.1939D-13  -7.5795D-15  -3.6113D-15   2.3774D-15  -5.1074D-15   1.4303D-16   5.9700D-16  -8.9788D-16   1.9464D-16  
#
D  KASHIM34  NHY  DER_NORT   1.5390D-03   8.0750D-04   4.9611D-05   7.9458D-05   3.2685D-04   5.7223D-05  -1.9795D-04  -3.7783D-04   2.1970D-04  
D  KASHIM34  NHY  DER_EAST  -1.6176D-04   1.2423D-03   1.3125D-04  -3.1705D-04   1.1334D-04   4.9260D-05  -6.8345D-05  -3.0538D-04   3.7457D-04  
D  KASHIM34  NHY  CHEB_0     5.4789D-10  -3.4757D-10  -2.3149D-10   4.4732D-11   1.0369D-10  -1.1440D-11  -4.8232D-11   1.3029D-11   3.9050D-12  
D  KASHIM34  NHY  CHEB_1     2.9361D-11  -1.6284D-11  -1.1270D-11   1.4226D-12   4.0882D-12  -3.5589D-13  -1.7307D-12   5.5994D-13   5.6194D-13  
D  KASHIM34  NHY  CHEB_2     5.1376D-12  -2.6300D-12  -1.8944D-12   1.5094D-13   5.9462D-13  -4.9481D-14  -2.0384D-13   9.0457D-14   9.1938D-14  
D  KASHIM34  NHY  CHEB_3    -5.9377D-13   4.1255D-13   2.5676D-13  -6.9138D-14  -1.2828D-13   2.1465D-14   7.6407D-14  -1.8619D-14  -2.8075D-14  
D  KASHIM34  NHY  CHEB_4    -8.4671D-14   5.5605D-14   3.4855D-14  -6.7070D-15  -1.6203D-14   7.9589D-16   6.3714D-15   1.3669D-15  -4.4999D-15  
D  KASHIM34  NHY  CHEB_5    -1.0148D-14   1.9571D-15   3.5315D-15   1.0506D-15  -3.7831D-18   1.1758D-15  -5.9316D-16  -1.3476D-15  -1.7335D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KASHIMA   HYD  DER_NORT   1.0900D-04   7.3139D-05   4.7433D-05   9.2660D-06  -2.0729D-05  -3.0911D-06  -1.2756D-05   2.8476D-07  -5.5591D-07  
D  KASHIMA   HYD  DER_EAST  -7.5810D-05   2.5436D-06  -1.1879D-05  -6.7506D-06  -1.5560D-05   5.9311D-06  -1.9207D-06   5.6322D-07  -3.0196D-06  
D  KASHIMA   HYD  CHEB_0     7.6771D-09   5.5458D-11   8.5692D-12  -3.6990D-12  -5.0723D-12  -4.6163D-13  -1.4023D-12  -1.6661D-12   3.9458D-12  
D  KASHIMA   HYD  CHEB_1    -1.8366D-11   1.6206D-11   1.1670D-11  -6.3989D-13  -1.7264D-12  -6.0621D-13   6.3136D-14  -3.1640D-13   5.0162D-13  
D  KASHIMA   HYD  CHEB_2    -4.9575D-12   2.2760D-12   1.6596D-12  -9.9104D-15  -2.3012D-13  -4.4634D-14  -8.8759D-16  -5.3427D-14   7.0516D-14  
D  KASHIMA   HYD  CHEB_3    -1.3649D-12  -4.5362D-13  -3.2916D-13   1.7849D-14   5.9387D-14   7.1895D-15  -7.8402D-15   1.5599D-14  -1.8946D-14  
D  KASHIMA   HYD  CHEB_4    -6.9953D-13   2.1596D-14   1.5754D-14   8.0712D-16   1.7364D-14   2.4740D-15   2.7310D-15  -7.5254D-16   3.1769D-15  
D  KASHIMA   HYD  CHEB_5    -1.1927D-13  -7.3969D-15  -3.4683D-15   2.4365D-15  -4.9965D-15   1.5318D-16   5.7383D-16  -9.0183D-16   1.8179D-16  
#
D  KASHIMA   NHY  DER_NORT   1.5381D-03   8.0698D-04   4.8644D-05   8.0190D-05   3.2731D-04   5.7616D-05  -1.9745D-04  -3.7775D-04   2.1876D-04  
D  KASHIMA   NHY  DER_EAST  -1.6316D-04   1.2435D-03   1.3023D-04  -3.1596D-04   1.1371D-04   4.9216D-05  -6.7936D-05  -3.0450D-04   3.7496D-04  
D  KASHIMA   NHY  CHEB_0     5.4756D-10  -3.4731D-10  -2.3137D-10   4.4696D-11   1.0365D-10  -1.1438D-11  -4.8219D-11   1.2983D-11   3.8988D-12  
D  KASHIMA   NHY  CHEB_1     2.9351D-11  -1.6275D-11  -1.1267D-11   1.4224D-12   4.0875D-12  -3.5557D-13  -1.7306D-12   5.5835D-13   5.6019D-13  
D  KASHIMA   NHY  CHEB_2     5.1364D-12  -2.6291D-12  -1.8940D-12   1.5117D-13   5.9459D-13  -4.9522D-14  -2.0390D-13   9.0474D-14   9.2090D-14  
D  KASHIMA   NHY  CHEB_3    -5.9329D-13   4.1227D-13   2.5644D-13  -6.9120D-14  -1.2813D-13   2.1511D-14   7.6312D-14  -1.8556D-14  -2.7981D-14  
D  KASHIMA   NHY  CHEB_4    -8.4888D-14   5.5788D-14   3.5196D-14  -6.7056D-15  -1.6420D-14   5.8879D-16   6.4974D-15   1.4683D-15  -4.4320D-15  
D  KASHIMA   NHY  CHEB_5    -1.0115D-14   2.0099D-15   3.4240D-15   1.0147D-15   4.4524D-17   1.2192D-15  -6.1637D-16  -1.3747D-15  -1.7554D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KAUAI     HYD  DER_NORT   4.6623D-05   3.1686D-05   5.7947D-06  -8.6139D-06   1.2808D-05  -7.3979D-06   1.0290D-05  -9.3012D-07   3.5546D-07  
D  KAUAI     HYD  DER_EAST  -4.8512D-06  -1.8807D-06  -8.3664D-06  -1.3209D-06  -1.3764D-06  -2.1363D-06   2.9394D-07  -1.0617D-06   5.0588D-07  
D  KAUAI     HYD  CHEB_0     6.7830D-09  -4.9938D-12   7.6923D-12   4.6112D-12  -2.8386D-12   4.2456D-12  -4.3015D-12  -1.9413D-13   1.1842D-12  
D  KAUAI     HYD  CHEB_1    -1.3877D-11   1.3835D-12   2.3190D-12  -5.2712D-13   1.4886D-13  -5.3759D-13  -2.6449D-13   1.2404D-13   1.9842D-13  
D  KAUAI     HYD  CHEB_2    -3.6175D-12   1.2566D-13   3.4689D-13  -9.2453D-14   5.3273D-14  -7.3936D-14  -2.1667D-14  -1.2398D-14   3.2469D-14  
D  KAUAI     HYD  CHEB_3    -1.3477D-12  -3.3541D-14  -6.7682D-14   9.1104D-15   6.7356D-15   1.2853D-14   1.3425D-14   6.0269D-15  -4.6029D-15  
D  KAUAI     HYD  CHEB_4    -6.4886D-13   6.9734D-15   9.3691D-17   3.2664D-15   5.7267D-16   1.2474D-15   1.0983D-15   9.4381D-16   7.2994D-16  
D  KAUAI     HYD  CHEB_5    -6.9985D-14   3.2800D-16   7.0056D-16  -2.0308D-15  -1.8686D-15  -7.6458D-16  -1.0247D-16  -1.6771D-15  -3.4565D-16  
#
D  KAUAI     NHY  DER_NORT   5.5712D-05   1.7898D-04   1.6738D-04  -2.7172D-04   4.6165D-04  -7.6380D-05   6.0729D-05  -2.2245D-04  -2.5428D-05  
D  KAUAI     NHY  DER_EAST   4.9249D-05   2.3109D-04   3.2698D-04   1.6210D-04   3.2664D-04   1.6794D-05  -3.5471D-04  -6.3049D-05   1.2105D-06  
D  KAUAI     NHY  CHEB_0     3.6188D-10  -2.5938D-11  -7.9796D-11  -3.3813D-11  -1.0940D-11  -2.4878D-11   2.6345D-11  -5.6374D-12   1.8446D-12  
D  KAUAI     NHY  CHEB_1     2.3665D-11  -2.0979D-12  -4.2246D-12  -1.6257D-12  -3.8093D-13  -1.1273D-12   1.1192D-12  -5.5412D-13  -8.9885D-14  
D  KAUAI     NHY  CHEB_2     4.5718D-12  -4.2422D-13  -7.4715D-13  -2.7929D-13  -5.4454D-14  -1.8676D-13   1.5561D-13  -8.1307D-14  -2.7967D-16  
D  KAUAI     NHY  CHEB_3    -3.0511D-13   2.1127D-14   8.8684D-14   3.5112D-14   1.9176D-14   3.0288D-14  -3.4947D-14   1.1617D-14   4.4924D-15  
D  KAUAI     NHY  CHEB_4    -5.1176D-14   1.3646D-15   1.3173D-14   6.2093D-15  -2.0953D-15   6.3915D-15  -3.2662D-15  -6.3318D-16   1.3355D-16  
D  KAUAI     NHY  CHEB_5    -1.3122D-14   6.1343D-16   2.2043D-15  -5.0973D-16   4.4597D-15  -3.7514D-16  -1.8859D-15  -2.1159D-15  -1.7362D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KIRSBERG  HYD  DER_NORT   1.2714D-04   5.4076D-05  -1.4987D-05   3.1418D-05   8.0185D-06   7.0611D-07   9.2364D-06  -6.3054D-07   3.3984D-07  
D  KIRSBERG  HYD  DER_EAST  -3.0412D-05  -2.4187D-05  -1.3577D-05  -4.6150D-07  -7.0828D-06  -1.0518D-05  -7.6178D-06   4.7344D-07   1.9775D-07  
D  KIRSBERG  HYD  CHEB_0     7.5292D-09   2.0382D-11   2.4341D-12   5.6794D-13  -9.8314D-12   1.0495D-11  -1.5912D-11  -5.2425D-13  -2.6939D-12  
D  KIRSBERG  HYD  CHEB_1    -4.9274D-12   1.2216D-11   6.3713D-12  -9.1067D-13   9.0262D-13  -1.2873D-13   1.1726D-13  -1.6618D-13  -5.9900D-13  
D  KIRSBERG  HYD  CHEB_2    -3.1301D-12   1.5530D-12   9.3476D-13  -1.1326D-13   2.6209D-13  -4.9567D-14   2.8629D-14  -2.7553D-14  -1.0313D-13  
D  KIRSBERG  HYD  CHEB_3    -1.7331D-12  -3.6711D-13  -1.8148D-13   3.5109D-14   1.6041D-14  -3.5571D-15   3.0274D-15   1.7412D-15   8.9556D-15  
D  KIRSBERG  HYD  CHEB_4    -6.8733D-13   2.2729D-14  -2.3869D-16  -4.2799D-15  -1.0674D-14  -1.2380D-15  -4.2598D-16  -2.6824D-16  -1.6201D-15  
D  KIRSBERG  HYD  CHEB_5    -1.0938D-13  -5.5187D-16   1.5598D-15  -1.1144D-15   2.7857D-15   1.6358D-15  -5.6129D-17  -1.0969D-16   4.2912D-16  
#
D  KIRSBERG  NHY  DER_NORT   6.5426D-04  -1.5089D-04   1.8471D-04   2.4527D-05   1.6521D-04   2.2772D-05   2.4239D-04  -1.7787D-05  -7.4231D-05  
D  KIRSBERG  NHY  DER_EAST  -1.8515D-04  -2.0337D-04   9.3774D-05  -7.3034D-05   2.9365D-04   2.8986D-04  -4.7010D-05  -1.8579D-05  -2.6395D-04  
D  KIRSBERG  NHY  CHEB_0     3.7145D-10  -1.3831D-10  -8.1643D-11   3.4099D-11   8.6972D-12  -6.2085D-12   1.6010D-11  -6.8264D-12   4.5798D-12  
D  KIRSBERG  NHY  CHEB_1     2.1719D-11  -7.5597D-12  -4.0750D-12   1.6770D-12   3.8589D-13  -2.5614D-13   1.1765D-12  -3.3394D-13   6.7787D-14  
D  KIRSBERG  NHY  CHEB_2     3.9722D-12  -1.3576D-12  -6.8127D-13   2.8743D-13   6.4176D-14  -3.5682D-14   2.2524D-13  -2.9340D-14   1.4928D-14  
D  KIRSBERG  NHY  CHEB_3    -3.7152D-13   1.3412D-13   9.1420D-14  -3.4806D-14  -5.7110D-15   1.0811D-14  -1.9613D-14   1.9439D-14   1.5340D-15  
D  KIRSBERG  NHY  CHEB_4    -5.4580D-14   1.6880D-14   1.3885D-14  -2.0660D-15  -2.9625D-15   2.3657D-17   1.1066D-15   2.2098D-15   1.1611D-16  
D  KIRSBERG  NHY  CHEB_5    -8.2945D-15   1.9931D-15  -8.6419D-16  -1.9013D-15   1.4477D-15   4.9691D-16  -2.1785D-15  -1.1127D-15   1.9258D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KODIAK    HYD  DER_NORT   4.0229D-05   4.5349D-05  -4.2448D-05  -1.4990D-05   2.4944D-05  -3.4571D-06  -3.3771D-06   2.3848D-07  -5.4369D-07  
D  KODIAK    HYD  DER_EAST   6.0964D-06  -4.6645D-06  -1.1249D-05   8.3447D-06   7.7443D-06   4.4263D-05   4.6477D-05  -7.0105D-07   6.5357D-07  
D  KODIAK    HYD  CHEB_0     7.6408D-09  -3.3654D-11   1.4228D-13  -6.8942D-12   9.4913D-12  -3.3479D-11   1.8142D-11   1.7339D-12   3.3689D-13  
D  KODIAK    HYD  CHEB_1     5.5927D-12   1.3327D-11   5.9458D-12  -1.9285D-12  -4.1576D-12  -1.0961D-13  -1.9281D-12   2.2741D-13   2.6614D-13  
D  KODIAK    HYD  CHEB_2    -1.0450D-12   1.9905D-12   1.1066D-12  -2.4211D-13  -5.0122D-13   2.5179D-14  -3.3612D-13   1.5799D-14   3.6205D-14  
D  KODIAK    HYD  CHEB_3    -1.8908D-12  -3.2423D-13  -1.0609D-13   5.9726D-14   1.3497D-13   8.9522D-15   3.4895D-14   2.5851D-15  -7.2746D-15  
D  KODIAK    HYD  CHEB_4    -7.2531D-13   1.2071D-14  -1.3852D-14  -1.1704D-14  -7.1767D-15  -3.2434D-15  -2.3865D-15  -4.9590D-16   1.5516D-15  
D  KODIAK    HYD  CHEB_5    -1.1601D-13   1.1263D-15   3.2794D-15   2.9505D-15  -4.6670D-16  -3.3248D-15  -5.5939D-16  -4.0003D-16  -6.8029D-16  
#
D  KODIAK    NHY  DER_NORT   3.9461D-04   2.9163D-04   1.2233D-04   3.0672D-04   3.7767D-05   3.8466D-04   2.4230D-04  -2.0255D-04   5.0571D-05  
D  KODIAK    NHY  DER_EAST   7.7652D-05   9.7896D-04  -1.7529D-05   2.2679D-05  -1.1127D-05   1.2412D-07  -4.1638D-04   3.1622D-04   8.1602D-05  
D  KODIAK    NHY  CHEB_0     2.7997D-10  -1.6142D-10  -8.0890D-11   2.8707D-11   5.0912D-11   2.2038D-11   1.4963D-11  -1.3856D-12  -1.6220D-13  
D  KODIAK    NHY  CHEB_1     1.6416D-11  -8.7933D-12  -4.4772D-12   1.3660D-12   2.5989D-12   1.1217D-12   1.0317D-12   2.0405D-13   1.3051D-13  
D  KODIAK    NHY  CHEB_2     2.9737D-12  -1.5155D-12  -7.9127D-13   2.1711D-13   4.2234D-13   2.0096D-13   2.0876D-13   4.5428D-14   3.4081D-14  
D  KODIAK    NHY  CHEB_3    -2.9673D-13   1.9106D-13   8.8111D-14  -4.0698D-14  -6.7116D-14  -1.9735D-14  -1.2218D-14   1.5805D-16   1.3209D-15  
D  KODIAK    NHY  CHEB_4    -4.3020D-14   2.2757D-14   1.2210D-14  -5.4066D-15  -6.4406D-15  -1.1847D-15  -1.2334D-15   5.1922D-16  -1.8358D-15  
D  KODIAK    NHY  CHEB_5    -7.8133D-15   3.4356D-15   1.7793D-15  -1.3536D-15  -1.6130D-15  -1.2180D-15  -1.8185D-15  -3.0580D-16  -8.3373D-18  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KOGANEI   HYD  DER_NORT   1.4950D-04   8.1445D-05   5.3593D-05   9.3056D-06  -2.2210D-05  -3.6816D-06  -1.2001D-05  -3.9296D-07   2.4509D-06  
D  KOGANEI   HYD  DER_EAST  -2.2160D-05   1.0078D-05  -1.2011D-06  -9.6445D-07  -1.1302D-05   3.4117D-06  -1.2545D-06  -1.5168D-06   5.7740D-07  
D  KOGANEI   HYD  CHEB_0     7.6386D-09   5.7014D-11   7.1711D-12  -3.7285D-12  -5.0263D-12   2.9463D-13  -8.3681D-13  -2.2597D-12   5.7409D-12  
D  KOGANEI   HYD  CHEB_1    -1.7997D-11   1.6001D-11   1.1048D-11  -8.4308D-13  -2.0511D-12  -4.7005D-13   7.3699D-14  -3.2696D-13   5.5104D-13  
D  KOGANEI   HYD  CHEB_2    -5.0310D-12   2.4779D-12   1.8211D-12  -5.2078D-14  -1.7091D-13  -3.9485D-14   2.8534D-14  -3.8793D-14   1.1331D-13  
D  KOGANEI   HYD  CHEB_3    -1.2734D-12  -4.1409D-13  -2.7019D-13   3.7796D-14   8.1657D-14  -7.1257D-15  -4.2485D-15   9.5272D-15  -7.8619D-15  
D  KOGANEI   HYD  CHEB_4    -6.9082D-13  -6.9773D-15  -1.0729D-14   6.6100D-15   8.9858D-15   5.9830D-15  -2.3798D-15  -1.4619D-15  -1.3237D-15  
D  KOGANEI   HYD  CHEB_5    -1.3735D-13  -9.5068D-15  -1.0074D-14  -4.4189D-15  -5.3710D-15   3.9601D-15   2.9514D-15  -5.2033D-16   6.3062D-16  
#
D  KOGANEI   NHY  DER_NORT   1.5632D-03   8.5357D-04   4.3669D-04   2.3533D-05   4.1582D-04  -1.4812D-04  -1.7680D-04  -5.1245D-04   5.8034D-04  
D  KOGANEI   NHY  DER_EAST  -6.8206D-05   5.3261D-04   2.0316D-04  -3.3643D-04  -2.0306D-04   8.6277D-05  -2.7831D-04  -2.7026D-04   5.7782D-04  
D  KOGANEI   NHY  CHEB_0     5.4595D-10  -3.6683D-10  -2.3665D-10   5.5663D-11   1.1246D-10  -1.2364D-11  -5.1686D-11   2.0255D-11  -2.9650D-12  
D  KOGANEI   NHY  CHEB_1     2.9310D-11  -1.7287D-11  -1.1469D-11   1.5578D-12   4.5354D-12  -1.3482D-13  -1.9988D-12   1.0062D-12   1.2212D-13  
D  KOGANEI   NHY  CHEB_2     5.2003D-12  -2.9096D-12  -1.9130D-12   2.3064D-13   6.9626D-13  -2.5604D-14  -2.9151D-13   1.2811D-13  -5.9905D-14  
D  KOGANEI   NHY  CHEB_3    -5.7928D-13   4.1299D-13   2.7586D-13  -5.6342D-14  -1.3535D-13   3.2771D-15   7.0371D-14  -4.6117D-14  -2.9494D-14  
D  KOGANEI   NHY  CHEB_4    -8.3636D-14   5.6894D-14   3.7318D-14  -6.2651D-15  -1.7780D-14  -1.3054D-15   8.9805D-15  -8.2974D-16   2.3595D-15  
D  KOGANEI   NHY  CHEB_5    -1.4589D-14   7.7586D-15   3.2956D-15  -3.4475D-15  -1.6191D-15   2.2303D-15   1.7829D-15  -6.3023D-16   2.0483D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KOGANEI3  HYD  DER_NORT   1.4929D-04   8.1212D-05   5.3596D-05   9.3468D-06  -2.2232D-05  -3.6908D-06  -1.1976D-05  -3.8589D-07   2.4088D-06  
D  KOGANEI3  HYD  DER_EAST  -2.2440D-05   9.9758D-06  -1.1958D-06  -9.5354D-07  -1.1259D-05   3.3903D-06  -1.2559D-06  -1.5157D-06   5.1740D-07  
D  KOGANEI3  HYD  CHEB_0     7.6483D-09   5.7419D-11   7.3733D-12  -3.7110D-12  -5.0516D-12   2.9593D-13  -8.3520D-13  -2.2737D-12   5.8510D-12  
D  KOGANEI3  HYD  CHEB_1    -1.8203D-11   1.6019D-11   1.1060D-11  -8.3998D-13  -2.0505D-12  -4.7034D-13   7.4107D-14  -3.2766D-13   5.6128D-13  
D  KOGANEI3  HYD  CHEB_2    -5.0715D-12   2.4775D-12   1.8200D-12  -5.0935D-14  -1.7066D-13  -3.9172D-14   2.8477D-14  -3.8920D-14   1.1468D-13  
D  KOGANEI3  HYD  CHEB_3    -1.2700D-12  -4.1548D-13  -2.7076D-13   3.7216D-14   8.1250D-14  -7.2886D-15  -4.0729D-15   9.5693D-15  -7.7798D-15  
D  KOGANEI3  HYD  CHEB_4    -6.9258D-13  -6.9186D-15  -1.0802D-14   7.0639D-15   9.4155D-15   6.0671D-15  -2.3984D-15  -1.4013D-15  -1.5231D-15  
D  KOGANEI3  HYD  CHEB_5    -1.3669D-13  -9.5823D-15  -1.0065D-14  -4.7038D-15  -5.8463D-15   3.9533D-15   2.9882D-15  -5.3220D-16   7.9120D-16  
#
D  KOGANEI3  NHY  DER_NORT   1.5577D-03   8.5332D-04   4.3770D-04   2.4036D-05   4.1517D-04  -1.4815D-04  -1.7634D-04  -5.1375D-04   5.8199D-04  
D  KOGANEI3  NHY  DER_EAST  -7.3175D-05   5.3395D-04   2.0107D-04  -3.3593D-04  -2.0331D-04   8.6647D-05  -2.7875D-04  -2.7094D-04   5.7716D-04  
D  KOGANEI3  NHY  CHEB_0     5.4839D-10  -3.6809D-10  -2.3745D-10   5.5736D-11   1.1275D-10  -1.2384D-11  -5.1808D-11   2.0283D-11  -2.8043D-12  
D  KOGANEI3  NHY  CHEB_1     2.9409D-11  -1.7320D-11  -1.1490D-11   1.5544D-12   4.5356D-12  -1.3288D-13  -1.9954D-12   1.0040D-12   1.3610D-13  
D  KOGANEI3  NHY  CHEB_2     5.2138D-12  -2.9133D-12  -1.9147D-12   2.2876D-13   6.9478D-13  -2.4854D-14  -2.8847D-13   1.2810D-13  -5.9025D-14  
D  KOGANEI3  NHY  CHEB_3    -5.8188D-13   4.1454D-13   2.7645D-13  -5.6153D-14  -1.3502D-13   3.6021D-15   6.9972D-14  -4.7836D-14  -3.0218D-14  
D  KOGANEI3  NHY  CHEB_4    -8.4804D-14   5.6935D-14   3.7653D-14  -6.7877D-15  -1.8159D-14  -1.2016D-15   9.6828D-15   1.9022D-16   2.6205D-15  
D  KOGANEI3  NHY  CHEB_5    -1.3833D-14   8.1349D-15   3.2442D-15  -3.0519D-15  -1.3932D-15   2.0989D-15   1.3587D-15  -1.3472D-15   1.6721D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KOKEE     HYD  DER_NORT   4.6713D-05   3.1719D-05   5.8024D-06  -8.6158D-06   1.2825D-05  -7.4035D-06   1.0296D-05  -9.2505D-07   3.6098D-07  
D  KOKEE     HYD  DER_EAST  -4.8649D-06  -1.8889D-06  -8.3785D-06  -1.3211D-06  -1.3776D-06  -2.1353D-06   2.9231D-07  -1.0642D-06   5.0594D-07  
D  KOKEE     HYD  CHEB_0     6.7765D-09  -5.0134D-12   7.6439D-12   4.5979D-12  -2.8435D-12   4.2348D-12  -4.2951D-12  -1.9493D-13   1.1793D-12  
D  KOKEE     HYD  CHEB_1    -1.3741D-11   1.3820D-12   2.3163D-12  -5.2825D-13   1.4843D-13  -5.3821D-13  -2.6468D-13   1.2359D-13   1.9816D-13  
D  KOKEE     HYD  CHEB_2    -3.5952D-12   1.2528D-13   3.4654D-13  -9.2532D-14   5.3118D-14  -7.4266D-14  -2.1529D-14  -1.2521D-14   3.2509D-14  
D  KOKEE     HYD  CHEB_3    -1.3495D-12  -3.3444D-14  -6.7580D-14   8.8571D-15   6.8590D-15   1.2886D-14   1.3203D-14   6.0064D-15  -4.6840D-15  
D  KOKEE     HYD  CHEB_4    -6.4823D-13   6.8770D-15   1.1648D-16   3.4478D-15   5.4088D-16   1.1952D-15   1.3009D-15   9.9537D-16   8.3380D-16  
D  KOKEE     HYD  CHEB_5    -6.9990D-14   3.8238D-16   7.2176D-16  -2.1222D-15  -1.7720D-15  -6.9343D-16  -2.5745D-16  -1.6803D-15  -3.8316D-16  
#
D  KOKEE     NHY  DER_NORT   4.9572D-05   1.8027D-04   1.6580D-04  -2.7235D-04   4.6436D-04  -7.8016D-05   6.2111D-05  -2.1985D-04  -2.2761D-05  
D  KOKEE     NHY  DER_EAST   4.7517D-05   2.3155D-04   3.2756D-04   1.6317D-04   3.2738D-04   1.6971D-05  -3.5502D-04  -6.3176D-05   9.5886D-07  
D  KOKEE     NHY  CHEB_0     3.5998D-10  -2.5786D-11  -7.9641D-11  -3.3829D-11  -1.0932D-11  -2.4883D-11   2.6336D-11  -5.5397D-12   1.8882D-12  
D  KOKEE     NHY  CHEB_1     2.3545D-11  -2.0884D-12  -4.2212D-12  -1.6348D-12  -3.8035D-13  -1.1310D-12   1.1224D-12  -5.4820D-13  -8.5618D-14  
D  KOKEE     NHY  CHEB_2     4.5503D-12  -4.2233D-13  -7.4737D-13  -2.8064D-13  -5.5166D-14  -1.8763D-13   1.5740D-13  -8.1245D-14   5.9800D-16  
D  KOKEE     NHY  CHEB_3    -3.0313D-13   2.0386D-14   8.8711D-14   3.4444D-14   1.9945D-14   3.0012D-14  -3.6254D-14   1.1399D-14   4.0434D-15  
D  KOKEE     NHY  CHEB_4    -5.0684D-14   1.8281D-15   1.3253D-14   6.4612D-15  -3.0450D-15   6.5145D-15  -1.9263D-15   8.8455D-17   5.8048D-16  
D  KOKEE     NHY  CHEB_5    -1.3027D-14   2.9137D-16   2.3182D-15  -7.7990D-16   4.8099D-15  -5.1619D-16  -2.7988D-15  -2.3371D-15  -1.9156D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KP-VLBA   HYD  DER_NORT   7.3831D-05   4.7446D-05   1.7280D-05  -2.9591D-05  -1.8458D-05   2.6910D-06   6.7430D-06  -1.9976D-06   1.2599D-06  
D  KP-VLBA   HYD  DER_EAST   1.9030D-05  -1.1263D-05  -2.7895D-06  -8.4302D-06  -1.2968D-06   4.0038D-06   9.7433D-06  -2.4567D-06   1.0105D-06  
D  KP-VLBA   HYD  CHEB_0     6.1775D-09  -4.1516D-12  -6.7263D-12   5.4962D-12   4.1940D-12  -4.4108D-12  -3.0541D-12   3.6343D-13   2.4144D-12  
D  KP-VLBA   HYD  CHEB_1     4.9558D-12   8.8515D-12   5.4042D-12  -3.0581D-13  -6.3889D-13   1.3355D-12   7.2948D-13   2.9638D-13   2.1422D-13  
D  KP-VLBA   HYD  CHEB_2    -1.0997D-12   1.4541D-12   8.8011D-13  -5.1059D-14  -5.4057D-14   3.0595D-13   1.4726D-13   4.6671D-14   3.4433D-14  
D  KP-VLBA   HYD  CHEB_3    -1.6149D-12  -1.9640D-13  -1.2879D-13   1.8916D-14   3.9797D-14  -5.3173D-15  -1.7034D-14  -7.2918D-15  -1.1651D-15  
D  KP-VLBA   HYD  CHEB_4    -5.7484D-13  -2.0639D-15  -7.0325D-15   5.5286D-15   2.5626D-15  -7.2789D-15  -3.9106D-15   1.1831D-15  -8.8634D-16  
D  KP-VLBA   HYD  CHEB_5    -7.3711D-14   1.4669D-15  -9.6314D-17  -6.3392D-15   4.6238D-16   2.0304D-15   2.5176D-15  -4.4152D-16  -3.1608D-16  
#
D  KP-VLBA   NHY  DER_NORT  -2.0405D-04  -6.1325D-04  -9.9985D-04   4.6702D-04   5.7835D-04  -6.3230D-04  -1.3658D-05  -3.7261D-04  -2.1992D-05  
D  KP-VLBA   NHY  DER_EAST   1.3953D-03  -1.0725D-03  -1.7890D-04   8.3224D-05  -2.4761D-04   8.0119D-04   5.6450D-04  -4.5587D-04  -2.1190D-04  
D  KP-VLBA   NHY  CHEB_0     2.2050D-10  -1.5761D-10  -9.6867D-11   3.0622D-11   9.5634D-11   1.1367D-11  -4.7009D-11  -2.8043D-12   3.7036D-12  
D  KP-VLBA   NHY  CHEB_1     1.4134D-11  -9.2749D-12  -5.9777D-12   1.3629D-12   5.3204D-12   8.3516D-13  -2.1466D-12   1.2660D-13   1.9382D-13  
D  KP-VLBA   NHY  CHEB_2     2.6783D-12  -1.6820D-12  -1.1041D-12   2.0952D-13   9.3328D-13   1.7095D-13  -3.3759D-13   4.3045D-14   2.3019D-14  
D  KP-VLBA   NHY  CHEB_3    -1.9876D-13   1.6687D-13   9.6086D-14  -4.3244D-14  -1.0852D-13  -6.5079D-15   6.2885D-14   4.2102D-15  -9.1040D-15  
D  KP-VLBA   NHY  CHEB_4    -3.2791D-14   2.3358D-14   1.5298D-14  -3.8871D-15  -1.5452D-14  -1.6520D-15   6.7399D-15   1.9505D-16  -5.7625D-16  
D  KP-VLBA   NHY  CHEB_5    -5.5394D-15   4.3825D-15   1.8078D-15  -1.0990D-15  -1.6225D-15  -8.2351D-16   1.3718D-15  -5.7317D-16  -3.4613D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  KWAJAL26  HYD  DER_NORT   6.1136D-06  -4.3759D-06  -2.1155D-06  -4.4644D-06  -1.8483D-06  -1.5864D-06   4.1055D-07   4.7094D-08   6.8675D-07  
D  KWAJAL26  HYD  DER_EAST  -1.2038D-05  -9.6580D-07  -9.9000D-07  -5.3066D-07   9.2761D-07  -1.0296D-07   4.9012D-07  -3.6076D-08  -1.6144D-07  
D  KWAJAL26  HYD  CHEB_0     7.6470D-09   1.3357D-12   4.1206D-12  -5.0949D-13  -6.2892D-13   2.2007D-12   7.6766D-13   4.7421D-13   2.5341D-12  
D  KWAJAL26  HYD  CHEB_1    -4.1170D-11   4.0440D-13   2.1757D-13  -1.2268D-14  -5.1593D-14  -1.0001D-13  -1.5085D-13  -2.2300D-14   2.8563D-13  
D  KWAJAL26  HYD  CHEB_2    -8.3857D-12   4.1115D-15   1.3746D-14  -1.2691D-14   9.9615D-15   2.8272D-15  -1.4313D-14  -3.6946D-15   3.8624D-14  
D  KWAJAL26  HYD  CHEB_3    -8.7073D-13  -1.3698D-14  -5.6411D-15   2.8464D-15   8.5242D-15   4.1538D-15   4.4532D-15   7.9361D-17  -6.2618D-15  
D  KWAJAL26  HYD  CHEB_4    -6.8639D-13   7.9514D-15   2.4860D-15   8.0278D-16  -4.7016D-15  -2.8160D-15   5.2757D-15   1.8742D-15  -2.6814D-15  
D  KWAJAL26  HYD  CHEB_5    -1.0364D-13   2.2963D-15   1.3761D-15  -1.1095D-15  -4.4602D-16  -4.8662D-16  -3.0104D-15  -1.8053D-15   8.8943D-16  
#
D  KWAJAL26  NHY  DER_NORT   1.8332D-03   3.3829D-04   6.7265D-04   2.9429D-04  -5.4395D-04  -2.9499D-04   1.0723D-04  -9.6257D-05  -2.9007D-05  
D  KWAJAL26  NHY  DER_EAST  -2.6288D-04   1.4630D-04  -2.3218D-04   9.1286D-05  -2.1976D-04  -5.6984D-05   1.0638D-05   1.8310D-05   1.6261D-05  
D  KWAJAL26  NHY  CHEB_0     1.0155D-09  -1.2126D-10  -1.3270D-10  -3.7591D-11  -4.3673D-11  -6.6506D-12  -2.7432D-11   1.5202D-12   1.2828D-12  
D  KWAJAL26  NHY  CHEB_1     5.3964D-11  -2.7400D-12  -1.3582D-12  -1.4742D-12  -1.2565D-12   1.6115D-13  -6.2207D-13   9.9432D-14  -1.8408D-13  
D  KWAJAL26  NHY  CHEB_2     9.4162D-12  -1.8020D-13   6.8367D-14  -2.1260D-13  -6.9565D-14   6.2841D-14  -2.7866D-14   1.4800D-14  -5.8741D-14  
D  KWAJAL26  NHY  CHEB_3    -1.1364D-12   2.0450D-13   1.8505D-13   3.9159D-14   7.5661D-14  -3.9198D-15   2.8943D-14  -1.7383D-14  -1.1968D-14  
D  KWAJAL26  NHY  CHEB_4    -1.5185D-13  -3.7325D-15  -1.4938D-14   2.5879D-15   1.0063D-14  -1.1386D-15   2.7995D-15   5.4851D-15   1.1255D-14  
D  KWAJAL26  NHY  CHEB_5    -2.9258D-14   1.5985D-14   2.2538D-14  -8.3311D-16  -4.0826D-15  -4.5008D-15  -1.6141D-15  -4.9211D-15  -7.0375D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  LA-VLBA   HYD  DER_NORT   8.4849D-05   4.4433D-05   5.7595D-07  -2.6837D-05  -1.8747D-05  -3.8988D-06   1.6277D-05  -2.8446D-06   1.7633D-06  
D  LA-VLBA   HYD  DER_EAST  -2.8222D-06  -1.5714D-05   2.4384D-06  -3.9831D-06  -4.1902D-06   1.6558D-05  -2.1351D-06  -1.5645D-06   9.3028D-07  
D  LA-VLBA   HYD  CHEB_0     6.1349D-09  -2.9967D-12  -1.0232D-11   5.4645D-12   3.4030D-12  -1.6567D-12  -2.7579D-12   5.9846D-12   3.8015D-13  
D  LA-VLBA   HYD  CHEB_1     8.6709D-12   1.1181D-11   5.2582D-12  -1.2708D-12  -1.4740D-12   9.2045D-13   9.3749D-13   8.4525D-13   6.0738D-14  
D  LA-VLBA   HYD  CHEB_2    -5.5931D-13   1.8485D-12   8.3752D-13  -1.3239D-13  -1.6446D-13   2.0259D-13   1.4100D-13   1.8008D-13   2.2584D-15  
D  LA-VLBA   HYD  CHEB_3    -1.6471D-12  -2.1369D-13  -1.2791D-13   2.8886D-14   5.5377D-14   6.9572D-15  -1.6895D-14  -1.6496D-15  -5.6385D-15  
D  LA-VLBA   HYD  CHEB_4    -5.4125D-13  -1.3353D-15   9.3218D-16  -9.9369D-15  -1.0486D-14   1.2970D-15   5.9581D-15  -1.7058D-15   3.1556D-15  
D  LA-VLBA   HYD  CHEB_5    -1.0646D-13  -5.9702D-15   2.4824D-16   6.0823D-15   6.6195D-15  -5.3257D-15  -8.7756D-15  -9.6896D-16  -1.3089D-15  
#
D  LA-VLBA   NHY  DER_NORT  -6.3098D-04  -6.1492D-05   2.1363D-04   2.7638D-04   1.6049D-04   2.9513D-04   6.6012D-04   2.7988D-04  -1.9628D-05  
D  LA-VLBA   NHY  DER_EAST   1.5714D-04  -8.5517D-04   1.7645D-04   4.8612D-04  -1.8278D-04  -1.8071D-04   4.0637D-04  -3.4214D-04  -4.6579D-04  
D  LA-VLBA   NHY  CHEB_0     2.5820D-10  -1.7127D-10  -7.1631D-11   3.0628D-11   6.9973D-11   1.8946D-11  -4.2894D-11  -5.1320D-12  -7.6739D-12  
D  LA-VLBA   NHY  CHEB_1     1.6598D-11  -9.7295D-12  -4.0747D-12   1.3040D-12   3.7383D-12   1.2266D-12  -2.0825D-12  -1.9051D-15  -1.3585D-13  
D  LA-VLBA   NHY  CHEB_2     3.1513D-12  -1.7681D-12  -7.3999D-13   2.1709D-13   6.6677D-13   2.2167D-13  -3.6193D-13   1.5912D-14   1.5525D-14  
D  LA-VLBA   NHY  CHEB_3    -2.3631D-13   1.8405D-13   7.3376D-14  -4.2547D-14  -7.4725D-14  -1.6620D-14   4.6247D-14   1.2413D-14   1.5377D-14  
D  LA-VLBA   NHY  CHEB_4    -4.0814D-14   3.1159D-14   1.0012D-14  -8.8380D-15  -1.0828D-14   1.1574D-15   6.0975D-15   4.3345D-15  -2.4025D-15  
D  LA-VLBA   NHY  CHEB_5    -7.9969D-15   5.7377D-15   2.4220D-15  -1.6089D-15  -2.8064D-15  -4.5709D-16   1.8114D-15   2.3245D-16   1.8544D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  LEONRDOK  HYD  DER_NORT   1.0156D-04   6.4695D-05   8.4105D-06  -1.6775D-05   2.3569D-06  -5.0472D-06   1.6789D-05   5.7210D-07   6.5968D-07  
D  LEONRDOK  HYD  DER_EAST   1.0721D-06  -3.5513D-06   6.8389D-06   7.6429D-06  -1.4171D-05   1.4685D-05  -3.3028D-06  -1.7336D-06   2.0152D-06  
D  LEONRDOK  HYD  CHEB_0     7.5088D-09   3.2547D-11   7.6299D-12   1.0884D-11   3.8880D-13   3.0115D-12   1.5273D-12   5.7528D-12   2.9793D-12  
D  LEONRDOK  HYD  CHEB_1    -1.8458D-11   1.3615D-11   6.0798D-12  -7.2941D-13  -1.0312D-12  -6.5031D-13   1.5961D-12   6.9624D-13   1.0624D-13  
D  LEONRDOK  HYD  CHEB_2    -5.1520D-12   2.1504D-12   9.0860D-13  -6.9710D-14  -9.7381D-14  -8.0673D-14   2.9230D-13   1.1639D-13   2.5828D-14  
D  LEONRDOK  HYD  CHEB_3    -1.3669D-12  -3.2640D-13  -1.6781D-13   3.7417D-14   4.5434D-14   2.4418D-14  -2.4853D-14  -1.3557D-14  -6.1535D-16  
D  LEONRDOK  HYD  CHEB_4    -6.7609D-13  -6.8765D-16   1.0088D-15  -3.3923D-15  -2.9837D-15  -7.7413D-16  -1.7489D-15  -1.2939D-15   8.5221D-16  
D  LEONRDOK  HYD  CHEB_5    -1.0826D-13   1.7539D-15   2.2758D-16   1.5690D-16  -1.9420D-15  -1.3348D-15   8.3450D-16   1.0232D-15  -1.9845D-15  
#
D  LEONRDOK  NHY  DER_NORT   4.1021D-04  -1.1659D-04   4.3241D-04   5.2783D-04   1.6791D-04   3.1669D-04   6.6886D-04  -2.7165D-04  -1.0146D-04  
D  LEONRDOK  NHY  DER_EAST  -4.4051D-05   5.2873D-04   2.2862D-04   2.1501D-04  -1.1751D-04  -3.8180D-05   1.3456D-04  -1.2155D-04  -5.3142D-05  
D  LEONRDOK  NHY  CHEB_0     5.1527D-10  -3.0073D-10  -6.1967D-11   4.4560D-11   3.8383D-11   1.7208D-11  -3.1840D-11   1.3426D-12   3.7008D-12  
D  LEONRDOK  NHY  CHEB_1     2.8230D-11  -1.5268D-11  -2.5944D-12   1.6304D-12   1.1189D-12   5.0180D-13  -1.8371D-12   4.3156D-13  -1.1488D-13  
D  LEONRDOK  NHY  CHEB_2     4.9913D-12  -2.6053D-12  -3.9513D-13   2.4131D-13   1.2917D-13   6.1755D-14  -3.4599D-13   5.3401D-14  -6.0133D-14  
D  LEONRDOK  NHY  CHEB_3    -5.6872D-13   3.5916D-13   7.7356D-14  -6.2262D-14  -5.0850D-14  -1.2466D-14   2.5695D-14  -1.1058D-14  -1.5800D-14  
D  LEONRDOK  NHY  CHEB_4    -7.3064D-14   3.5569D-14   8.8740D-15  -8.7552D-15  -5.4929D-15   3.6339D-15   4.9842D-15  -5.1354D-15   3.4220D-15  
D  LEONRDOK  NHY  CHEB_5    -1.1915D-14   9.8691D-15   1.6813D-15  -1.0785D-15  -1.5619D-15  -1.5862D-15   1.4430D-15   4.2304D-15  -1.2463D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MAMMOTHL  HYD  DER_NORT   8.1565D-05   3.0282D-05   1.4624D-06  -1.2688D-05  -2.5874D-05  -7.8799D-06  -1.5055D-05  -8.8783D-07   4.8709D-06  
D  MAMMOTHL  HYD  DER_EAST  -1.8123D-05  -3.1106D-05  -9.1856D-06   3.6885D-06   1.3448D-05  -1.1479D-05  -2.1237D-06   1.6489D-06  -4.6435D-06  
D  MAMMOTHL  HYD  CHEB_0     5.8861D-09  -3.1852D-12  -7.7015D-12   7.3335D-12   3.2512D-12  -3.0683D-12  -3.5948D-12   8.2437D-13   9.9876D-13  
D  MAMMOTHL  HYD  CHEB_1     1.3999D-11   9.5913D-12   4.9110D-12  -1.5078D-12  -1.4480D-12   9.1524D-13   8.3225D-13   5.3808D-13   1.0659D-13  
D  MAMMOTHL  HYD  CHEB_2     6.2142D-13   1.5119D-12   7.9076D-13  -2.5224D-13  -1.8253D-13   2.3797D-13   1.5046D-13   1.0291D-13   3.0202D-15  
D  MAMMOTHL  HYD  CHEB_3    -1.7740D-12  -1.9994D-13  -1.0005D-13   3.5673D-14   5.5882D-14   1.2420D-15  -4.4606D-15  -6.8952D-16  -6.5161D-15  
D  MAMMOTHL  HYD  CHEB_4    -5.0137D-13   1.9958D-14   5.8582D-15  -1.2326D-15  -1.3299D-14  -6.0005D-15  -7.4502D-15   2.0693D-15   2.4372D-15  
D  MAMMOTHL  HYD  CHEB_5    -9.6595D-14  -6.1444D-15  -1.3317D-15  -9.3785D-16   4.9261D-15   3.2163D-16   1.7592D-15  -2.0135D-15   2.9134D-16  
#
D  MAMMOTHL  NHY  DER_NORT  -1.3640D-03   1.1051D-03   1.9523D-04  -3.7854D-04  -4.9551D-04  -3.3643D-04   6.9319D-05   3.3601D-04   5.9011D-04  
D  MAMMOTHL  NHY  DER_EAST   1.5016D-04  -1.8761D-03  -6.8518D-05   4.8689D-04   3.9705D-04   1.0413D-04   2.6836D-04  -2.0528D-04  -1.0930D-03  
D  MAMMOTHL  NHY  CHEB_0     1.5589D-10  -6.1831D-11  -2.0932D-11   1.2175D-11   1.8657D-11  -1.5933D-11  -2.0242D-11  -1.2269D-11  -8.9554D-12  
D  MAMMOTHL  NHY  CHEB_1     1.0211D-11  -3.7184D-12  -1.0659D-12   4.7226D-13   1.0712D-12  -9.1909D-13  -1.0199D-12  -4.3661D-13  -3.8296D-13  
D  MAMMOTHL  NHY  CHEB_2     1.9475D-12  -7.0136D-13  -1.5961D-13   7.1403D-14   1.7255D-13  -1.7502D-13  -1.5457D-13  -6.9692D-14  -6.3664D-14  
D  MAMMOTHL  NHY  CHEB_3    -1.4470D-13   6.6370D-14   3.4041D-14  -2.1067D-14  -3.0351D-14   1.3470D-14   3.1354D-14   1.5164D-14   9.8289D-15  
D  MAMMOTHL  NHY  CHEB_4    -2.5755D-14   1.5166D-14   4.1441D-15  -5.0752D-15  -4.6680D-15   1.1652D-15   3.0187D-15   2.2398D-15   3.2689D-15  
D  MAMMOTHL  NHY  CHEB_5    -4.8577D-15   2.7617D-15   1.6755D-16  -5.4001D-16   2.9649D-16   6.6592D-16  -3.5173D-16   5.9682D-16   6.2870D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MARCUS    HYD  DER_NORT   5.9272D-05   3.8524D-05   5.3439D-05   2.6838D-07   1.0563D-05  -8.0083D-06   2.8408D-06  -1.4704D-07   8.1708D-07  
D  MARCUS    HYD  DER_EAST  -1.5305D-05  -5.3824D-07  -1.2065D-06  -2.8839D-06  -2.0910D-06   3.2556D-06   2.9829D-06  -4.5493D-07  -4.3125D-07  
D  MARCUS    HYD  CHEB_0     7.6978D-09   2.3839D-11   1.5402D-11   6.7100D-12  -9.4637D-12   2.0317D-14  -5.4035D-12  -1.0029D-13   1.4967D-12  
D  MARCUS    HYD  CHEB_1    -3.6572D-11   3.3474D-12   3.2976D-12  -9.0416D-13   1.1342D-12  -1.0478D-12  -1.6881D-13  -1.3347D-13   2.7960D-13  
D  MARCUS    HYD  CHEB_2    -7.8704D-12   4.6293D-13   5.1508D-13  -1.5944D-13   2.5506D-13  -1.7074D-13  -9.6362D-15  -1.0648D-14   3.4302D-14  
D  MARCUS    HYD  CHEB_3    -9.7996D-13  -9.0025D-14  -7.9066D-14   1.7593D-14  -3.9110D-16   2.3597D-14   1.0567D-14   5.7367D-15  -8.3111D-15  
D  MARCUS    HYD  CHEB_4    -6.6950D-13   4.8326D-15  -2.7115D-15   1.7137D-15  -1.7246D-15   1.2071D-15   1.9049D-16  -8.9786D-16   9.5467D-16  
D  MARCUS    HYD  CHEB_5    -1.1183D-13  -1.2965D-15   6.3593D-16  -1.4819D-15  -6.4154D-16   7.6594D-16  -4.2732D-16  -5.1765D-16  -8.9499D-16  
#
D  MARCUS    NHY  DER_NORT   1.3051D-04   4.0207D-05  -8.0614D-05  -7.2904D-04   8.4728D-04  -8.9121D-05   3.0862D-04   1.0912D-04  -4.0524D-05  
D  MARCUS    NHY  DER_EAST  -3.6842D-04  -1.4236D-04  -1.1950D-04  -2.4921D-05   3.3377D-04   1.1846D-04  -4.9144D-05   7.0051D-05  -6.9984D-05  
D  MARCUS    NHY  CHEB_0     8.3571D-10  -2.1018D-10  -1.2057D-10   1.6193D-11  -1.8327D-11   3.3593D-11  -4.9430D-12   2.2349D-12  -1.3335D-12  
D  MARCUS    NHY  CHEB_1     4.6586D-11  -7.5338D-12  -5.8841D-12   6.5192D-13  -1.8011D-12   1.4591D-12  -3.2807D-13   1.6382D-13  -2.1599D-13  
D  MARCUS    NHY  CHEB_2     8.2389D-12  -1.0412D-12  -9.4384D-13   1.4298D-13  -3.4942D-13   2.0417D-13  -8.9148D-14   3.6931D-14  -2.6734D-14  
D  MARCUS    NHY  CHEB_3    -9.3636D-13   2.8426D-13   1.5587D-13  -2.4135D-14   3.1081D-14  -5.9279D-14   5.6872D-15  -1.8863D-16   2.4252D-15  
D  MARCUS    NHY  CHEB_4    -1.3024D-13   2.4183D-14   1.7160D-14   2.1679D-15   2.4047D-15  -8.5261D-15  -2.9875D-15   1.4098D-15  -1.8848D-15  
D  MARCUS    NHY  CHEB_5    -1.7061D-14   6.6417D-15  -2.1523D-15  -1.2578D-14   1.1981D-15  -2.6777D-15   7.8241D-15  -1.7050D-15  -3.7720D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MARPOINT  HYD  DER_NORT   1.3254D-04   7.5524D-05   2.7384D-05   4.2254D-06   3.0488D-05  -1.3551D-05   1.8537D-05   1.2045D-06   1.6177D-06  
D  MARPOINT  HYD  DER_EAST  -1.9084D-05   4.6794D-06  -2.8324D-05   2.6047D-06  -4.6424D-06  -5.8091D-08  -2.6689D-06  -1.6037D-06   6.9352D-07  
D  MARPOINT  HYD  CHEB_0     7.7222D-09   3.0630D-11   1.2036D-11   6.6138D-12  -4.9551D-12   3.0798D-12  -2.5542D-12   5.6486D-12  -4.6459D-13  
D  MARPOINT  HYD  CHEB_1    -1.8070D-11   1.4194D-11   8.4916D-12  -2.1685D-12   7.5175D-13  -2.6791D-12   2.5528D-12   7.7500D-13  -2.8705D-13  
D  MARPOINT  HYD  CHEB_2    -5.0159D-12   2.1632D-12   1.2320D-12  -3.5643D-13   1.8850D-13  -4.4648D-13   4.2170D-13   1.3334D-13  -4.1817D-14  
D  MARPOINT  HYD  CHEB_3    -1.4376D-12  -3.6553D-13  -2.5446D-13   5.3131D-14   4.9139D-15   6.4749D-14  -5.6914D-14  -1.6042D-14   2.1305D-15  
D  MARPOINT  HYD  CHEB_4    -7.0429D-13   1.0842D-14  -1.1150D-15   3.2524D-15  -4.0171D-16   5.0116D-15   2.0501D-16  -2.8020D-16   1.0303D-15  
D  MARPOINT  HYD  CHEB_5    -1.0255D-13   2.5229D-15   8.9122D-15  -2.0199D-15   1.0746D-15  -2.7159D-15   1.2699D-15   1.4429D-16  -1.5102D-16  
#
D  MARPOINT  NHY  DER_NORT   1.2279D-03   1.3895D-04   4.2879D-04  -1.0433D-04   8.1188D-04  -4.4304D-05   1.8887D-04   1.4512D-04  -7.5303D-06  
D  MARPOINT  NHY  DER_EAST  -3.6256D-04  -9.4341D-06  -1.7050D-04   2.0464D-04  -2.6636D-04   3.9016D-05   1.4305D-04   2.2275D-04  -1.1323D-04  
D  MARPOINT  NHY  CHEB_0     4.9671D-10  -2.5095D-10  -1.2588D-10   3.3096D-11   4.2484D-11   3.4415D-11  -3.0184D-11  -9.1564D-12  -3.9039D-12  
D  MARPOINT  NHY  CHEB_1     2.7477D-11  -1.4497D-11  -6.5410D-12   1.6512D-12   1.8022D-12   1.9776D-12  -1.3316D-12  -2.1920D-13  -1.2535D-13  
D  MARPOINT  NHY  CHEB_2     4.8228D-12  -2.5437D-12  -1.1277D-12   2.7088D-13   2.4857D-13   3.6448D-13  -2.0729D-13  -4.7608D-15   2.7460D-15  
D  MARPOINT  NHY  CHEB_3    -5.7868D-13   3.1522D-13   1.5252D-13  -5.2409D-14  -8.0115D-14  -4.5747D-14   5.4875D-14   1.3675D-14  -6.6245D-15  
D  MARPOINT  NHY  CHEB_4    -7.4755D-14   3.7072D-14   1.6656D-14  -3.0018D-16  -6.2908D-15  -3.5591D-15   5.1062D-15  -5.5916D-15  -1.7077D-15  
D  MARPOINT  NHY  CHEB_5    -1.2591D-14   8.0158D-15   3.9046D-15  -3.2481D-15  -7.8090D-16  -3.0757D-15   1.1697D-15   1.2736D-15   2.0917D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MATERA    HYD  DER_NORT   3.6793D-05   6.3552D-07  -1.3482D-06   7.4725D-06   1.6159D-05   3.2637D-06   5.8926D-06   5.3499D-07  -4.7427D-09  
D  MATERA    HYD  DER_EAST  -4.8774D-05  -8.5362D-06   1.2294D-05  -5.3312D-06   6.3595D-06   8.9747D-06  -1.1697D-05   2.9352D-07  -1.2411D-06  
D  MATERA    HYD  CHEB_0     7.2986D-09   3.1616D-11  -7.4310D-12   1.4040D-11  -1.0034D-11   9.5853D-12  -7.8818D-12   9.1673D-13  -4.8325D-13  
D  MATERA    HYD  CHEB_1    -8.4453D-12   1.1353D-11   6.9924D-12  -2.0041D-12  -1.2697D-12  -9.4714D-14  -1.4950D-13  -1.2768D-13  -3.9066D-13  
D  MATERA    HYD  CHEB_2    -3.5186D-12   1.5881D-12   1.1081D-12  -3.3034D-13  -1.2441D-13  -1.3612D-14  -5.0404D-14   1.9929D-14  -6.8443D-14  
D  MATERA    HYD  CHEB_3    -1.5851D-12  -3.1071D-13  -1.9019D-13   5.0442D-14   6.2711D-14  -1.3391D-15   4.3838D-15  -2.0390D-15   9.5734D-15  
D  MATERA    HYD  CHEB_4    -6.6297D-13   6.6463D-15  -6.6469D-15   2.6864D-15  -3.3849D-15   2.9936D-15   5.4655D-16  -1.6503D-15  -3.8031D-16  
D  MATERA    HYD  CHEB_5    -1.0942D-13   5.4180D-15   4.6473D-15  -2.7802D-15  -3.2191D-15  -5.4291D-15  -2.9771D-16   6.4186D-16  -2.9192D-16  
#
D  MATERA    NHY  DER_NORT  -5.9189D-05   2.6594D-04   9.3994D-05  -1.7006D-04  -6.8198D-05   6.3454D-05  -4.3070D-05   7.2227D-05   4.3237D-04  
D  MATERA    NHY  DER_EAST  -9.9729D-04   2.5805D-04   1.5637D-04   1.0572D-04   9.3678D-05  -2.1271D-04   7.5925D-05  -3.2515D-04  -2.4044D-04  
D  MATERA    NHY  CHEB_0     3.7333D-10  -1.2636D-10  -5.8412D-11  -6.9022D-12   1.1758D-11   6.7525D-12   3.2400D-11   9.3098D-12   7.5447D-12  
D  MATERA    NHY  CHEB_1     2.2280D-11  -6.0875D-12  -2.9969D-12  -6.9234D-13   4.0415D-13   2.4580D-13   1.7243D-12  -2.0740D-13   2.0893D-14  
D  MATERA    NHY  CHEB_2     4.1276D-12  -1.0703D-12  -5.3620D-13  -1.2403D-13   8.9847D-14   2.3829D-14   2.5453D-13  -1.4595D-14   4.0794D-16  
D  MATERA    NHY  CHEB_3    -3.5783D-13   1.2503D-13   6.1545D-14   1.6504D-14  -3.0406D-15  -1.1671D-14  -5.3241D-14   1.0171D-14  -4.1684D-15  
D  MATERA    NHY  CHEB_4    -5.7088D-14   1.5481D-14   9.1698D-15  -5.0685D-17  -1.0104D-15  -3.2781D-16  -3.7087D-15   1.3200D-15  -1.4347D-16  
D  MATERA    NHY  CHEB_5    -9.8790D-15   4.1908D-15   2.3130D-15   6.2702D-16  -1.1912D-15  -1.2473D-16  -1.7529D-16  -2.4050D-15  -1.3618D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MCD_7850  HYD  DER_NORT   1.0893D-04   7.3377D-05   3.3570D-05  -2.5419D-05  -1.4835D-05   5.6017D-07   1.2224D-05  -1.5182D-06   2.1761D-06  
D  MCD_7850  HYD  DER_EAST   1.0999D-05   1.0764D-05   6.3822D-06  -8.5170D-07   2.8832D-06   1.7304D-05   1.4905D-06   1.5585D-06   1.1561D-06  
D  MCD_7850  HYD  CHEB_0     6.1143D-09  -4.9710D-12  -8.7902D-12   4.6324D-12   2.8421D-12  -2.2298D-12  -2.4063D-12   1.2569D-12   2.2053D-12  
D  MCD_7850  HYD  CHEB_1     4.2841D-12   7.6886D-12   4.5242D-12   4.4674D-13  -4.7995D-13   6.5941D-13   1.7661D-13   4.1186D-13   1.6367D-13  
D  MCD_7850  HYD  CHEB_2    -9.8395D-13   1.2761D-12   7.1683D-13   8.9901D-14  -3.3565D-14   1.4427D-13   5.8250D-14   5.9875D-14   3.2178D-14  
D  MCD_7850  HYD  CHEB_3    -1.6017D-12  -1.5512D-13  -1.1024D-13   7.7482D-15   3.9612D-14   1.9122D-15  -1.6884D-15  -7.6428D-15  -3.8589D-16  
D  MCD_7850  HYD  CHEB_4    -5.6884D-13  -7.3683D-15  -6.5580D-15   1.2056D-15  -8.2317D-16  -1.0121D-16  -9.1926D-16   1.4909D-15  -4.5146D-16  
D  MCD_7850  HYD  CHEB_5    -7.4094D-14   5.8974D-15   2.8289D-15  -4.1341D-15  -1.6148D-15  -8.8689D-16   9.9354D-16  -1.0314D-16   7.9472D-16  
#
D  MCD_7850  NHY  DER_NORT   1.4591D-03   3.7714D-04  -3.9596D-04  -5.8905D-04   2.5034D-04  -2.4776D-04   3.7748D-04  -2.3104D-04  -3.3787D-04  
D  MCD_7850  NHY  DER_EAST  -6.1435D-05   2.7536D-04   5.0864D-04  -3.9799D-04  -5.3153D-04   2.6019D-04   4.5708D-04  -1.2457D-04   3.5737D-04  
D  MCD_7850  NHY  CHEB_0     2.6795D-10  -1.6271D-10  -9.0162D-11   1.6459D-11   6.6983D-11   2.4460D-11  -2.9788D-12  -6.8969D-12  -1.2755D-12  
D  MCD_7850  NHY  CHEB_1     1.7034D-11  -9.6316D-12  -5.7107D-12   6.0062D-13   3.6541D-12   1.3916D-12   1.5099D-13   1.4838D-13  -8.2832D-14  
D  MCD_7850  NHY  CHEB_2     3.2440D-12  -1.7552D-12  -1.0754D-12   6.9301D-14   6.3803D-13   2.6248D-13   7.1671D-14   8.2331D-14  -4.1810D-14  
D  MCD_7850  NHY  CHEB_3    -2.2871D-13   1.6121D-13   8.2890D-14  -2.5461D-14  -7.3709D-14  -1.9403D-14   1.3400D-14   1.5156D-14  -8.4566D-15  
D  MCD_7850  NHY  CHEB_4    -4.0122D-14   2.4101D-14   1.4946D-14  -2.3753D-15  -1.1807D-14  -4.4916D-15   1.4179D-15   1.3831D-15  -3.9405D-16  
D  MCD_7850  NHY  CHEB_5    -5.3191D-15   1.5119D-15   1.6928D-15   1.6338D-15  -2.5927D-16  -3.3747D-16  -1.6097D-15  -1.9278D-15   4.3582D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MEDICINA  HYD  DER_NORT   5.7689D-05   5.2745D-06  -1.7615D-05   2.0040D-05   1.5786D-05  -6.3345D-06   9.8533D-06  -8.1571D-08  -2.7203D-07  
D  MEDICINA  HYD  DER_EAST  -1.0352D-05  -1.2117D-05   6.4491D-07   1.0920D-06  -2.9066D-06   2.9523D-06  -9.7845D-06   6.6057D-07   1.8504D-06  
D  MEDICINA  HYD  CHEB_0     7.7079D-09   4.4143D-11  -4.3965D-12   1.2997D-11  -1.1539D-11   1.0208D-11  -1.0850D-11  -7.9009D-13  -3.7422D-12  
D  MEDICINA  HYD  CHEB_1    -1.3130D-11   1.1667D-11   6.8746D-12  -1.5531D-12  -5.3535D-13   1.2070D-13  -5.4389D-13  -2.4110D-13  -6.9972D-13  
D  MEDICINA  HYD  CHEB_2    -4.8296D-12   1.5805D-12   1.0132D-12  -2.2068D-13  -9.5466D-16   2.3238D-15  -6.2811D-14  -1.6224D-14  -1.2217D-13  
D  MEDICINA  HYD  CHEB_3    -1.5956D-12  -3.3347D-13  -2.0594D-13   4.7676D-14   3.9449D-14  -1.2109D-14   2.6666D-14  -4.0744D-15   4.4333D-15  
D  MEDICINA  HYD  CHEB_4    -6.7928D-13   7.9583D-15   3.2166D-15  -2.7876D-15  -5.0036D-15   6.8081D-15  -4.2915D-15   6.4516D-17   5.1299D-16  
D  MEDICINA  HYD  CHEB_5    -1.2755D-13   3.5702D-15   5.7375D-15  -3.1135D-15   4.0659D-16  -1.7294D-15   1.1685D-15  -1.3663D-15   7.6678D-16  
#
D  MEDICINA  NHY  DER_NORT   6.0623D-05   7.8762D-04   2.8901D-04  -5.3058D-04   6.0594D-04   1.0646D-04  -2.1030D-04   5.2517D-04   2.3757D-04  
D  MEDICINA  NHY  DER_EAST  -1.0340D-04   3.1457D-04   4.5811D-04   3.5336D-04   2.8126D-04  -1.0772D-04  -3.1590D-04  -1.0127D-04  -1.3265D-04  
D  MEDICINA  NHY  CHEB_0     4.5335D-10  -1.5472D-10  -7.6844D-11   1.2170D-11   1.0678D-11   3.4598D-12   2.4004D-11  -2.2865D-13  -8.7215D-12  
D  MEDICINA  NHY  CHEB_1     2.6675D-11  -7.6403D-12  -3.9087D-12   1.9700D-13  -6.4973D-14   2.5130D-13   1.5776D-12  -7.2190D-13  -6.1365D-13  
D  MEDICINA  NHY  CHEB_2     4.8003D-12  -1.2694D-12  -6.8922D-13   1.6801D-14  -1.9108D-14   5.5429D-14   2.5821D-13  -1.3499D-13  -9.8609D-14  
D  MEDICINA  NHY  CHEB_3    -4.7955D-13   1.7710D-13   8.7658D-14  -9.1826D-15  -1.5962D-14   1.3698D-15  -3.9897D-14   1.4199D-14   2.0523D-14  
D  MEDICINA  NHY  CHEB_4    -7.2246D-14   1.9837D-14   1.0895D-14  -2.1932D-15   1.3915D-15  -2.9579D-15  -3.7336D-15   2.2691D-15  -1.5696D-15  
D  MEDICINA  NHY  CHEB_5    -6.2623D-15   8.9284D-16   4.9330D-15  -1.5453D-15  -4.4038D-15   1.6479D-15  -1.0474D-15  -1.0854D-15   2.0450D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  METSHOVI  HYD  DER_NORT   1.1620D-04   5.6632D-05   2.4876D-06   1.3495D-05  -3.9871D-05   6.0679D-06  -6.1256D-06  -8.4911D-07  -1.1759D-07  
D  METSHOVI  HYD  DER_EAST  -4.2353D-05  -1.5059D-05  -1.5641D-05   5.0444D-06  -4.8496D-06  -9.7206D-06  -6.1562D-06   1.0136D-06   5.6839D-07  
D  METSHOVI  HYD  CHEB_0     7.6429D-09  -9.9490D-12   1.7663D-11  -2.0853D-11   4.5763D-12  -1.4230D-11  -2.3980D-12   2.1938D-13  -2.3561D-13  
D  METSHOVI  HYD  CHEB_1     1.8558D-12   1.7298D-11   8.0849D-12  -4.2027D-13   5.8005D-13  -9.9351D-13   1.4758D-12  -1.8508D-13  -3.4373D-13  
D  METSHOVI  HYD  CHEB_2    -2.0175D-12   2.1937D-12   1.1845D-12  -5.1120D-14   9.9845D-14  -1.9324D-13   2.2449D-13  -2.7441D-14  -5.4603D-14  
D  METSHOVI  HYD  CHEB_3    -1.9243D-12  -5.2869D-13  -2.2809D-13   1.7132D-14  -1.6210D-14   1.5084D-14  -3.9849D-14   2.4935D-15   6.7115D-15  
D  METSHOVI  HYD  CHEB_4    -7.0308D-13   4.2545D-14  -7.3325D-16   7.6635D-16  -3.8665D-15   3.3734D-15   1.4554D-15   1.5696D-15  -9.8164D-16  
D  METSHOVI  HYD  CHEB_5    -1.0792D-13   3.2739D-16   3.3972D-15  -9.4545D-17   1.6324D-16   6.8532D-16   1.2612D-15  -1.9595D-15  -2.9202D-16  
#
D  METSHOVI  NHY  DER_NORT   3.4742D-04   4.9717D-04  -1.0624D-05   1.0028D-04  -2.4312D-04  -2.1475D-04   2.0679D-04  -2.3380D-04  -6.3528D-04  
D  METSHOVI  NHY  DER_EAST  -4.4696D-04  -1.5063D-04   5.1282D-05  -3.0492D-04   4.8304D-05   2.4951D-04   1.9751D-04   7.0233D-05   9.6546D-05  
D  METSHOVI  NHY  CHEB_0     3.1938D-10  -1.3999D-10  -9.9904D-11   1.4972D-11   1.1199D-11   1.1858D-11  -6.2845D-12   1.4547D-12   1.9327D-12  
D  METSHOVI  NHY  CHEB_1     1.8769D-11  -7.7570D-12  -5.7548D-12   9.0310D-13   6.5796D-13   5.0538D-13  -6.1583D-13   1.9468D-13   1.3765D-13  
D  METSHOVI  NHY  CHEB_2     3.4128D-12  -1.3705D-12  -1.0369D-12   1.6794D-13   1.1798D-13   8.4411D-14  -1.3798D-13   2.0626D-14   3.4653D-14  
D  METSHOVI  NHY  CHEB_3    -3.2719D-13   1.4514D-13   9.7280D-14  -1.6972D-14  -3.0869D-15  -4.7590D-15  -4.0797D-15  -1.2313D-14  -2.3954D-15  
D  METSHOVI  NHY  CHEB_4    -5.5191D-14   2.8789D-14   2.1042D-14  -1.9742D-15  -7.3276D-15  -3.0906D-15   2.5110D-15   2.1580D-15   7.3252D-16  
D  METSHOVI  NHY  CHEB_5    -4.2188D-15  -4.1440D-15  -6.9581D-16  -5.0835D-16   3.4657D-15   2.2393D-15  -5.9944D-16  -1.0777D-15  -9.1377D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  METSAHOV  HYD  DER_NORT   1.1659D-04   5.6819D-05   2.4141D-06   1.3566D-05  -3.9883D-05   6.0082D-06  -6.0650D-06  -9.3773D-07  -1.3247D-07  
D  METSAHOV  HYD  DER_EAST  -4.2423D-05  -1.5167D-05  -1.5601D-05   5.0185D-06  -4.8547D-06  -9.6876D-06  -6.1311D-06   9.9105D-07   5.8640D-07  
D  METSAHOV  HYD  CHEB_0     7.6284D-09  -1.0477D-11   1.7358D-11  -2.0736D-11   4.4484D-12  -1.4047D-11  -2.5205D-12   3.5154D-13  -1.5959D-13  
D  METSAHOV  HYD  CHEB_1     2.1098D-12   1.7241D-11   8.0710D-12  -4.1976D-13   5.8174D-13  -9.8119D-13   1.4673D-12  -1.6690D-13  -3.3657D-13  
D  METSAHOV  HYD  CHEB_2    -1.9723D-12   2.1877D-12   1.1820D-12  -5.0506D-14   1.0170D-13  -1.9126D-13   2.2261D-13  -2.5418D-14  -5.2686D-14  
D  METSAHOV  HYD  CHEB_3    -1.9271D-12  -5.2645D-13  -2.2631D-13   1.7303D-14  -1.6853D-14   1.5414D-14  -3.8665D-14   2.4834D-15   6.6229D-15  
D  METSAHOV  HYD  CHEB_4    -7.0030D-13   4.1199D-14  -1.9032D-15   7.0496D-16  -3.4036D-15   2.8425D-15   1.0514D-15   1.9907D-15  -8.4633D-16  
D  METSAHOV  HYD  CHEB_5    -1.0783D-13   1.1060D-15   3.9101D-15  -4.2895D-17  -4.5935D-16   9.8455D-16   1.7110D-15  -1.9095D-15  -3.0525D-16  
#
D  METSAHOV  NHY  DER_NORT   3.5454D-04   4.9728D-04  -1.8383D-05   1.1267D-04  -2.4841D-04  -2.1701D-04   2.0106D-04  -2.2281D-04  -6.3423D-04  
D  METSAHOV  NHY  DER_EAST  -4.4512D-04  -1.4831D-04   4.5145D-05  -3.0827D-04   4.1963D-05   2.5312D-04   1.9897D-04   7.2312D-05   9.6816D-05  
D  METSAHOV  NHY  CHEB_0     3.1697D-10  -1.3886D-10  -9.9148D-11   1.4845D-11   1.0997D-11   1.1662D-11  -6.1297D-12   1.4193D-12   1.7503D-12  
D  METSAHOV  NHY  CHEB_1     1.8656D-11  -7.7090D-12  -5.7208D-12   8.9636D-13   6.5844D-13   5.0284D-13  -6.1078D-13   2.1783D-13   1.3543D-13  
D  METSAHOV  NHY  CHEB_2     3.3958D-12  -1.3652D-12  -1.0319D-12   1.6916D-13   1.1749D-13   8.1227D-14  -1.3610D-13   2.2295D-14   3.6616D-14  
D  METSAHOV  NHY  CHEB_3    -3.2377D-13   1.4333D-13   9.6980D-14  -1.7164D-14  -3.1692D-15  -4.1451D-15  -4.5113D-15  -1.2777D-14  -1.4318D-15  
D  METSAHOV  NHY  CHEB_4    -5.6368D-14   3.0744D-14   2.1502D-14  -1.5737D-15  -8.3994D-15  -4.6747D-15   3.2140D-15   1.9964D-15   8.7531D-16  
D  METSAHOV  NHY  CHEB_5    -4.4994D-15  -3.4244D-15   6.5939D-17  -8.3627D-16   3.0279D-15   2.4995D-15  -5.7900D-16  -4.5102D-16  -7.9426D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MIAMI20   HYD  DER_NORT   4.9334D-05   2.9632D-05   2.5350D-05  -9.9400D-06  -3.2069D-06  -1.0557D-05   1.0789D-05   2.5027D-07  -1.6295D-06  
D  MIAMI20   HYD  DER_EAST  -1.9686D-05   4.4938D-06  -2.3837D-06   6.0794D-06   4.5587D-07  -7.9375D-08   1.4749D-07   4.3814D-07  -6.7895D-07  
D  MIAMI20   HYD  CHEB_0     7.7161D-09   1.6041D-11   1.1665D-11   1.1174D-11   5.2139D-12  -1.4835D-14  -6.2608D-12   1.4213D-12   1.6315D-12  
D  MIAMI20   HYD  CHEB_1    -3.3934D-11   3.4678D-12   3.8823D-12  -4.6909D-13  -7.8383D-13  -2.6027D-13  -3.9191D-13   2.6391D-13  -1.1972D-14  
D  MIAMI20   HYD  CHEB_2    -7.7360D-12   4.8852D-13   5.8496D-13  -1.0135D-13  -1.3158D-13  -5.2306D-14  -5.0559D-14   2.8880D-14  -1.2551D-14  
D  MIAMI20   HYD  CHEB_3    -1.0583D-12  -6.4155D-14  -9.2818D-14  -2.1917D-15   7.7944D-15   2.4832D-15   1.5958D-14  -8.0920D-15  -4.4195D-15  
D  MIAMI20   HYD  CHEB_4    -6.7023D-13  -1.0928D-14  -1.3990D-14   5.0323D-15   1.0581D-14  -1.0411D-16  -1.4581D-15   8.6649D-16   3.6537D-15  
D  MIAMI20   HYD  CHEB_5    -1.1055D-13  -1.7428D-15   1.5699D-15  -2.1736D-16  -8.6538D-16   3.6327D-16   7.8269D-18   8.5850D-16  -2.2183D-15  
#
D  MIAMI20   NHY  DER_NORT   7.1798D-04   5.2717D-04  -4.1859D-04  -3.3178D-04  -6.3308D-04  -5.4493D-04   1.0518D-03   5.2957D-04  -3.3223D-04  
D  MIAMI20   NHY  DER_EAST  -2.3582D-04   2.1476D-04   5.0579D-05  -1.8846D-04  -3.6457D-04  -3.5528D-04   7.1705D-05   3.4137D-04  -2.5198D-04  
D  MIAMI20   NHY  CHEB_0     7.7246D-10  -1.7549D-10  -1.6274D-10   5.9740D-11   5.5401D-11   2.2948D-11   2.8898D-11  -6.2893D-12   4.6879D-12  
D  MIAMI20   NHY  CHEB_1     4.2105D-11  -5.5458D-12  -6.0418D-12   2.0273D-12   1.1642D-12   1.4854D-12   9.6443D-13  -5.5026D-13   3.5254D-13  
D  MIAMI20   NHY  CHEB_2     7.5081D-12  -7.7411D-13  -7.8546D-13   3.0875D-13  -6.0131D-14   1.6338D-13   2.3006D-13  -2.2661D-13   2.3912D-14  
D  MIAMI20   NHY  CHEB_3    -7.9589D-13   1.4948D-13   2.0199D-13  -5.1079D-14  -8.7805D-14  -6.4601D-14  -2.5776D-14   4.9418D-15  -5.8040D-14  
D  MIAMI20   NHY  CHEB_4    -9.3596D-14  -4.6738D-15  -4.7059D-15  -9.5362D-15   2.9487D-14   2.4496D-15  -9.7419D-15   1.6835D-14  -3.9728D-15  
D  MIAMI20   NHY  CHEB_5    -2.4787D-14   2.1952D-15   7.9085D-15   2.4170D-15  -4.1513D-15   4.2802D-15  -4.8595D-15   2.0678D-15   2.1755D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MILESMON  HYD  DER_NORT   1.2033D-04   4.5735D-05  -9.6833D-06   6.1684D-06  -4.7698D-06  -2.3750D-05  -4.0151D-06   5.2739D-07  -6.9271D-09  
D  MILESMON  HYD  DER_EAST  -4.0209D-05  -4.0897D-05   8.0303D-07  -2.6302D-06  -1.5173D-05   1.0621D-05  -2.7190D-05  -1.2117D-07   1.2674D-06  
D  MILESMON  HYD  CHEB_0     7.0966D-09   2.7629D-11   2.5672D-12   2.3316D-12   2.4184D-12   1.9522D-12   3.1342D-12   3.9064D-12   2.1584D-12  
D  MILESMON  HYD  CHEB_1     1.6684D-13   1.7445D-11   5.5847D-12  -2.2553D-12  -2.4778D-12  -1.3056D-13   2.1368D-12   6.2052D-13   2.7334D-13  
D  MILESMON  HYD  CHEB_2    -2.0833D-12   2.8343D-12   9.1826D-13  -2.9938D-13  -3.2109D-13   2.2503D-14   4.1270D-13   1.1300D-13   5.8032D-14  
D  MILESMON  HYD  CHEB_3    -1.6746D-12  -3.5779D-13  -1.2765D-13   6.6691D-14   7.7535D-14   3.8253D-15  -3.2764D-14  -5.6297D-15  -3.0726D-15  
D  MILESMON  HYD  CHEB_4    -6.7858D-13  -8.9168D-15  -5.8138D-15  -3.5526D-15  -1.5598D-15  -3.7911D-15   1.5418D-15  -1.6005D-15  -1.0847D-15  
D  MILESMON  HYD  CHEB_5    -9.2022D-14  -4.4414D-15  -3.8221D-15   1.6291D-16  -1.2231D-15   1.1585D-15  -4.3746D-15  -1.6254D-16  -8.6063D-16  
#
D  MILESMON  NHY  DER_NORT   1.1035D-03   3.8522D-04   1.1672D-04  -1.4949D-04   6.0810D-04  -2.4488D-04   1.0482D-04  -7.9168D-05  -8.9856D-05  
D  MILESMON  NHY  DER_EAST  -7.5591D-04  -6.2442D-04  -2.0473D-04   1.5549D-04   1.9920D-04   5.0769D-04  -1.2662D-04  -1.2567D-04   3.4395D-04  
D  MILESMON  NHY  CHEB_0     3.0521D-10  -1.6937D-10  -3.2976D-11   2.1048D-11   8.6643D-12  -7.9705D-12   1.2221D-12   9.7100D-14   3.3684D-12  
D  MILESMON  NHY  CHEB_1     1.7645D-11  -9.6466D-12  -1.3444D-12   9.6278D-13   9.2531D-14  -3.3645D-13   3.8716D-13  -1.0003D-13   3.2248D-13  
D  MILESMON  NHY  CHEB_2     3.1944D-12  -1.7341D-12  -2.0840D-13   1.5189D-13  -1.3997D-14  -4.6803D-14   9.8182D-14  -3.0268D-14   7.9804D-14  
D  MILESMON  NHY  CHEB_3    -3.1830D-13   1.8416D-13   4.1387D-14  -2.7811D-14  -1.8863D-14   1.1542D-14   7.1726D-15  -3.0450D-15   2.1200D-15  
D  MILESMON  NHY  CHEB_4    -4.7212D-14   2.5919D-14   5.9459D-15  -4.9012D-15  -2.8991D-15   5.2620D-16   2.0054D-15   1.4351D-15  -1.8711D-15  
D  MILESMON  NHY  CHEB_5    -8.1400D-15   5.6472D-15   3.0401D-16   2.5958D-16  -6.1479D-17   2.8319D-17  -4.1754D-16  -1.1176D-15   2.9548D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MIURA     HYD  DER_NORT   1.5125D-04   7.5905D-05   5.4558D-05   1.2568D-05  -2.4543D-05  -5.6303D-06  -1.3299D-05   1.0088D-06  -1.7924D-06  
D  MIURA     HYD  DER_EAST  -4.4352D-05   4.8602D-06  -7.3328D-06  -4.3102D-06  -1.2613D-05   4.2512D-06  -1.1306D-06   3.3415D-07  -7.0655D-07  
D  MIURA     HYD  CHEB_0     7.6561D-09   5.5621D-11   9.2043D-12  -2.8482D-12  -5.5063D-12  -3.3071D-14  -6.8734D-13  -2.2157D-12   4.3560D-12  
D  MIURA     HYD  CHEB_1    -1.9201D-11   1.5517D-11   1.1084D-11  -8.2414D-13  -1.7092D-12  -4.2549D-13   2.8873D-13  -3.7171D-13   4.7723D-13  
D  MIURA     HYD  CHEB_2    -5.2510D-12   2.3670D-12   1.6897D-12  -5.5461D-14  -2.3231D-13  -3.8733D-14   3.4562D-14  -5.5489D-14   5.2243D-14  
D  MIURA     HYD  CHEB_3    -1.2871D-12  -4.4909D-13  -3.1120D-13   3.6788D-14   6.6283D-14   1.0579D-14  -1.1573D-14   1.2399D-14  -1.0127D-14  
D  MIURA     HYD  CHEB_4    -7.0406D-13  -1.8497D-14  -8.1187D-15   7.7808D-16   7.0009D-15  -2.0958D-15   2.4987D-15   1.4783D-15   4.7852D-15  
D  MIURA     HYD  CHEB_5    -1.0859D-13   1.1689D-14   8.0686D-15   2.6119D-15  -4.6220D-15   1.6658D-15  -1.3386D-15  -9.2776D-16  -1.4509D-15  
#
D  MIURA     NHY  DER_NORT   1.0607D-03   1.1221D-03   1.9065D-04   2.9645D-04   5.7377D-04  -4.8721D-05   1.3057D-04  -6.1444D-04   7.3625D-04  
D  MIURA     NHY  DER_EAST   2.3781D-04   7.2448D-04   6.9861D-05  -4.0026D-04  -1.2813D-04   1.3258D-04  -1.4600D-04  -3.0020D-04   1.9157D-04  
D  MIURA     NHY  CHEB_0     5.5871D-10  -3.6042D-10  -2.3852D-10   5.4204D-11   1.1240D-10  -1.3088D-11  -5.1941D-11   1.0901D-11   5.1889D-12  
D  MIURA     NHY  CHEB_1     2.9809D-11  -1.6402D-11  -1.1998D-11   1.1303D-12   4.2587D-12  -1.4918D-13  -1.6326D-12   7.1529D-13  -3.3281D-13  
D  MIURA     NHY  CHEB_2     5.2841D-12  -2.6946D-12  -2.0296D-12   8.3840D-14   6.0409D-13  -4.1113D-15  -1.6926D-13   1.5707D-13  -7.9814D-14  
D  MIURA     NHY  CHEB_3    -5.8447D-13   4.0588D-13   2.7258D-13  -7.0261D-14  -1.4182D-13   1.8524D-14   7.6312D-14  -8.9844D-15  -4.9377D-15  
D  MIURA     NHY  CHEB_4    -9.3045D-14   6.0003D-14   4.7992D-14  -3.2206D-15  -2.3327D-14  -3.7410D-15   8.5547D-15   9.2721D-16  -4.3950D-15  
D  MIURA     NHY  CHEB_5    -1.1744D-14   5.0138D-15   1.4041D-15  -7.9743D-16   1.6983D-15   2.5832D-15  -2.3147D-15  -2.1256D-15   5.1121D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MIYAZAKI  HYD  DER_NORT   1.1471D-04   7.1121D-05   5.4242D-05   7.3181D-06  -2.6602D-05  -5.1545D-06  -5.0621D-07  -6.6653D-07  -2.7757D-06  
D  MIYAZAKI  HYD  DER_EAST  -1.1946D-05   8.1738D-06  -1.0909D-05   1.7107D-06  -5.5018D-06   3.7940D-06  -2.2085D-06   1.0123D-07  -1.3012D-06  
D  MIYAZAKI  HYD  CHEB_0     7.6521D-09   6.6881D-11   1.6093D-11   4.9980D-13  -6.5094D-12   2.4147D-13   1.2590D-13  -2.6035D-12   4.0447D-12  
D  MIYAZAKI  HYD  CHEB_1    -2.2276D-11   1.4300D-11   8.9621D-12  -6.9679D-13  -1.4470D-12   3.6820D-14   4.6397D-13  -3.9633D-13   5.1258D-13  
D  MIYAZAKI  HYD  CHEB_2    -5.9215D-12   2.1558D-12   1.3209D-12  -1.4250D-14  -1.6714D-13   6.7358D-14   8.4150D-14  -6.2895D-14   7.8205D-14  
D  MIYAZAKI  HYD  CHEB_3    -1.2644D-12  -3.8081D-13  -2.1965D-13   3.6836D-14   5.6649D-14   8.9102D-15  -2.4484D-15   7.7939D-15  -4.1500D-15  
D  MIYAZAKI  HYD  CHEB_4    -6.5820D-13  -1.2036D-14  -9.8719D-15  -6.0898D-15  -7.6798D-16  -6.0382D-15   2.5343D-16   9.7895D-16   1.5495D-15  
D  MIYAZAKI  HYD  CHEB_5    -1.2403D-13   2.9782D-15   2.3710D-15   1.6466D-15  -1.4553D-15   1.6298D-15  -9.0718D-16  -2.1738D-16  -1.0949D-16  
#
D  MIYAZAKI  NHY  DER_NORT   1.3141D-03   1.0906D-03   2.9439D-04  -4.1548D-04  -2.8913D-04  -7.1733D-06   2.9059D-04  -1.4136D-04   1.9586D-04  
D  MIYAZAKI  NHY  DER_EAST  -2.6310D-04   9.4234D-04  -1.3057D-04   2.6291D-04  -1.9468D-04  -2.3851D-05  -1.9743D-04  -2.2579D-04   6.5269D-04  
D  MIYAZAKI  NHY  CHEB_0     6.2155D-10  -3.8426D-10  -2.2708D-10   8.0409D-11   1.2248D-10  -8.0187D-12  -4.4526D-11   1.0709D-11  -6.9664D-12  
D  MIYAZAKI  NHY  CHEB_1     3.3378D-11  -1.7403D-11  -1.1251D-11   3.2986D-12   4.3495D-12  -1.2371D-12  -1.5912D-12  -6.8413D-14   6.6542D-13  
D  MIYAZAKI  NHY  CHEB_2     5.7319D-12  -2.7055D-12  -1.8829D-12   4.3646D-13   6.1786D-13  -2.2644D-13  -2.5572D-13  -2.3887D-14   9.8346D-14  
D  MIYAZAKI  NHY  CHEB_3    -7.0948D-13   4.7613D-13   2.5748D-13  -1.0987D-13  -1.3894D-13   1.0800D-14   3.3664D-14  -7.6348D-15  -2.5982D-14  
D  MIYAZAKI  NHY  CHEB_4    -9.6916D-14   5.9200D-14   3.9566D-14  -1.0774D-14  -2.0993D-14   2.9662D-16   8.4993D-15  -5.0992D-15  -3.1858D-15  
D  MIYAZAKI  NHY  CHEB_5    -1.0545D-14   2.2229D-15   1.9611D-15   2.2902D-15   5.7233D-16  -1.3770D-15  -1.5147D-15  -8.9425D-17   8.7857D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MIZNAO10  HYD  DER_NORT   1.6086D-04   7.0027D-05   2.8588D-05   3.8189D-06  -1.4957D-05   2.2504D-06  -1.7831D-05  -5.1102D-07  -2.3164D-07  
D  MIZNAO10  HYD  DER_EAST  -3.4471D-05  -8.9997D-06  -1.9110D-05  -1.1938D-05  -1.6211D-05   5.9426D-06  -4.9267D-06  -1.0448D-06  -1.6898D-06  
D  MIZNAO10  HYD  CHEB_0     7.6598D-09   5.4966D-11   3.0019D-12  -6.9420D-12  -6.0688D-12  -2.1460D-12  -1.5941D-12   1.3160D-13   5.8995D-12  
D  MIZNAO10  HYD  CHEB_1    -1.1424D-11   1.9465D-11   1.2827D-11  -6.1325D-13  -2.2289D-12  -9.1740D-13  -5.6094D-13  -1.0568D-13   8.4266D-13  
D  MIZNAO10  HYD  CHEB_2    -3.8472D-12   2.9072D-12   1.9459D-12  -4.1634D-14  -2.6281D-13  -1.2241D-13  -1.0627D-13  -1.7871D-14   1.2814D-13  
D  MIZNAO10  HYD  CHEB_3    -1.4405D-12  -4.8971D-13  -3.2630D-13   4.1393D-14   1.0082D-13   3.2891D-14   5.5966D-15   3.5030D-15  -1.1700D-14  
D  MIZNAO10  HYD  CHEB_4    -6.9698D-13   8.9666D-15   3.2390D-15  -5.4962D-15   1.0042D-15  -2.2209D-15  -2.0152D-16   1.5264D-16   1.1634D-15  
D  MIZNAO10  HYD  CHEB_5    -1.3940D-13  -1.2414D-14  -3.8926D-15   4.0876D-15  -9.0410D-16   5.5006D-16  -1.4168D-18  -4.4615D-16  -4.6859D-16  
#
D  MIZNAO10  NHY  DER_NORT   9.1396D-04  -1.3440D-05  -3.9133D-04   4.5100D-05  -2.8748D-05  -2.4003D-04  -5.5366D-04  -1.0537D-04  -1.8602D-05  
D  MIZNAO10  NHY  DER_EAST  -1.2323D-03  -8.7524D-04  -3.5894D-04  -5.7102D-04  -1.0038D-04  -1.2308D-04   1.6708D-04   3.0992D-04  -1.8100D-05  
D  MIZNAO10  NHY  CHEB_0     4.5903D-10  -3.1915D-10  -1.8979D-10   4.7757D-11   9.1143D-11   4.5884D-12  -3.2299D-11   1.1649D-11  -1.1669D-11  
D  MIZNAO10  NHY  CHEB_1     2.5888D-11  -1.6322D-11  -9.4980D-12   2.5392D-12   4.2483D-12   1.4553D-13  -1.5296D-12   5.1470D-13  -1.2819D-13  
D  MIZNAO10  NHY  CHEB_2     4.5829D-12  -2.7523D-12  -1.5913D-12   4.1254D-13   6.6139D-13   1.1695D-14  -2.2249D-13   3.8828D-14   2.4759D-14  
D  MIZNAO10  NHY  CHEB_3    -5.1208D-13   3.8355D-13   2.2992D-13  -6.3894D-14  -1.2428D-13  -5.7207D-15   4.9176D-14  -3.2621D-14   1.8628D-14  
D  MIZNAO10  NHY  CHEB_4    -7.3276D-14   4.9957D-14   2.8741D-14  -1.0272D-14  -1.6052D-14  -2.4516D-15   6.4586D-15  -7.4787D-16  -2.7913D-16  
D  MIZNAO10  NHY  CHEB_5    -1.0798D-14   5.7334D-15   4.8455D-15   3.0335D-16  -1.1839D-15   7.6917D-16  -4.0308D-16   7.5248D-16  -1.3982D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MIZUSGSI  HYD  DER_NORT   1.6289D-04   7.2443D-05   2.9716D-05   4.1492D-06  -1.5284D-05   2.1291D-06  -1.8098D-05  -4.5957D-07   5.5088D-08  
D  MIZUSGSI  HYD  DER_EAST  -3.5875D-05  -5.5874D-06  -1.8172D-05  -1.1655D-05  -1.6445D-05   5.7298D-06  -5.0195D-06  -8.5997D-07  -1.4510D-06  
D  MIZUSGSI  HYD  CHEB_0     7.6027D-09   5.1663D-11   1.6908D-12  -6.9721D-12  -5.9110D-12  -1.9392D-12  -1.4628D-12  -2.4209D-14   5.0650D-12  
D  MIZUSGSI  HYD  CHEB_1    -1.0413D-11   1.9309D-11   1.2795D-11  -6.0229D-13  -2.2054D-12  -9.1093D-13  -5.5784D-13  -1.1811D-13   7.7437D-13  
D  MIZUSGSI  HYD  CHEB_2    -3.6664D-12   2.8767D-12   1.9379D-12  -4.8021D-14  -2.6495D-13  -1.2129D-13  -1.0108D-13  -2.3561D-14   1.1294D-13  
D  MIZUSGSI  HYD  CHEB_3    -1.4411D-12  -4.6774D-13  -3.1720D-13   4.3487D-14   1.0221D-13   3.4115D-14   5.9482D-15   4.9634D-15  -1.0817D-14  
D  MIZUSGSI  HYD  CHEB_4    -6.8949D-13   4.8484D-15   2.2342D-15  -7.2138D-15   1.4846D-15  -3.9321D-15   1.3888D-15   1.0145D-16   2.1555D-15  
D  MIZUSGSI  HYD  CHEB_5    -1.3858D-13  -1.1254D-14  -3.7888D-15   4.7242D-15  -1.0694D-15   1.1992D-15  -1.5068D-15  -5.3934D-16  -1.2743D-15  
#
D  MIZUSGSI  NHY  DER_NORT   8.7146D-04  -2.8522D-05  -3.8409D-04   5.1073D-05  -3.0648D-05  -2.4474D-04  -5.8684D-04  -1.0314D-04   5.7415D-06  
D  MIZUSGSI  NHY  DER_EAST  -1.2723D-03  -7.9795D-04  -3.4852D-04  -5.5428D-04  -9.3952D-05  -1.3889D-04   1.4183D-04   2.8932D-04   7.7418D-05  
D  MIZUSGSI  NHY  CHEB_0     4.4583D-10  -3.1229D-10  -1.8571D-10   4.6806D-11   8.9252D-11   3.7364D-12  -3.1932D-11   1.1447D-11  -1.2052D-11  
D  MIZUSGSI  NHY  CHEB_1     2.5500D-11  -1.6126D-11  -9.4263D-12   2.4925D-12   4.2244D-12   1.4966D-13  -1.5311D-12   5.1836D-13  -1.9622D-13  
D  MIZUSGSI  NHY  CHEB_2     4.5225D-12  -2.7188D-12  -1.5785D-12   4.0996D-13   6.5585D-13   2.1598D-14  -2.2183D-13   3.7624D-14   9.8953D-15  
D  MIZUSGSI  NHY  CHEB_3    -4.9879D-13   3.7391D-13   2.2171D-13  -6.6324D-14  -1.2195D-13  -1.0073D-14   5.0349D-14  -3.1921D-14   1.7152D-14  
D  MIZUSGSI  NHY  CHEB_4    -6.8466D-14   5.1410D-14   3.0915D-14  -6.0777D-15  -1.7501D-14  -1.7219D-16   6.6598D-15  -9.6103D-16   1.3847D-15  
D  MIZUSGSI  NHY  CHEB_5    -1.2246D-14   5.4140D-15   3.5277D-15  -2.1462D-15  -1.8320D-15  -1.2384D-15   8.1231D-16   7.7544D-16  -1.1761D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MK-VLBA   HYD  DER_NORT   6.5791D-05   2.4263D-05   1.1050D-05  -5.7759D-06   1.4202D-05  -1.1474D-05   6.9535D-06  -3.2396D-07  -4.4745D-07  
D  MK-VLBA   HYD  DER_EAST  -3.8491D-05  -9.7921D-06  -7.6085D-06   1.8733D-06  -3.4275D-07  -2.3357D-06  -4.5448D-06  -1.5236D-08   1.7003D-07  
D  MK-VLBA   HYD  CHEB_0     5.0076D-09  -5.3143D-12  -2.4425D-12   3.5134D-12  -2.4855D-12   1.8426D-12  -2.1613D-12  -5.5982D-13  -7.7403D-14  
D  MK-VLBA   HYD  CHEB_1     1.5475D-11   8.6071D-13   1.7704D-12  -4.0736D-13  -2.2098D-13  -4.6755D-13  -3.6259D-13   1.5655D-13   1.1369D-13  
D  MK-VLBA   HYD  CHEB_2     2.1174D-12   1.0228D-13   3.4184D-13  -8.1666D-14  -1.3588D-14  -8.2800D-14  -5.8546D-14  -1.4475D-14   2.5347D-14  
D  MK-VLBA   HYD  CHEB_3    -1.5325D-12  -2.5196D-14  -3.4595D-14   5.7515D-15   1.1255D-14   4.9678D-15   4.2976D-15   4.3038D-16  -2.8812D-15  
D  MK-VLBA   HYD  CHEB_4    -5.7216D-13  -3.1930D-16  -8.5459D-15   1.1960D-16   3.5785D-15   2.6223D-16   2.1245D-15   2.0468D-15  -1.4997D-15  
D  MK-VLBA   HYD  CHEB_5    -2.4322D-14   6.7489D-15   5.1895D-15   2.0656D-15  -8.5196D-16   3.2787D-16  -7.3801D-17  -1.1771D-15   7.5714D-16  
#
D  MK-VLBA   NHY  DER_NORT   1.0395D-03  -3.2677D-04  -7.8521D-05  -1.0846D-04   9.7324D-05  -3.8255D-04  -5.8358D-05  -1.2010D-05   9.8416D-05  
D  MK-VLBA   NHY  DER_EAST   5.1024D-04   9.8309D-05   2.2896D-04   2.7690D-04   1.5440D-04  -1.3632D-04  -8.0483D-04  -2.1496D-04  -8.1154D-05  
D  MK-VLBA   NHY  CHEB_0     8.3431D-11   3.9438D-12  -3.6609D-11  -1.4603D-11  -4.0322D-12  -1.7366D-11   9.8478D-12  -1.2746D-12  -2.0919D-13  
D  MK-VLBA   NHY  CHEB_1     5.5267D-12   4.4034D-13  -2.2517D-12  -9.6955D-13  -2.1954D-13  -1.1856D-12   6.9234D-13   1.6963D-13   6.8463D-14  
D  MK-VLBA   NHY  CHEB_2     1.1004D-12   8.7456D-14  -4.3619D-13  -1.8478D-13  -3.5961D-14  -2.3766D-13   1.2992D-13   3.3415D-14   1.5877D-14  
D  MK-VLBA   NHY  CHEB_3    -5.2775D-14  -4.2858D-15   2.5794D-14   1.1682D-14   6.6257D-15   1.0761D-14  -1.0160D-14  -3.8406D-15  -8.5885D-16  
D  MK-VLBA   NHY  CHEB_4    -1.1449D-14  -1.6244D-15   4.6686D-15   2.3359D-15   2.8084D-16   2.6250D-15  -1.2611D-15  -9.2589D-16   2.4268D-16  
D  MK-VLBA   NHY  CHEB_5    -2.3471D-15  -2.5605D-17   8.9616D-16   7.2308D-17   3.4764D-16   6.2730D-16  -2.1958D-16  -7.4024D-17  -2.2264D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MOJAVE12  HYD  DER_NORT   5.9831D-05   1.6015D-05   4.4875D-06  -1.5620D-05  -1.6313D-05  -4.0830D-07  -3.9617D-06   2.1127D-07  -3.0456D-06  
D  MOJAVE12  HYD  DER_EAST   1.9106D-06  -2.5633D-05  -1.5671D-05  -8.5088D-07   1.1471D-05  -1.1239D-05   2.4111D-06   2.0577D-06  -9.7383D-07  
D  MOJAVE12  HYD  CHEB_0     6.9204D-09   3.0903D-11   1.4930D-12   8.1625D-12   1.4233D-12   4.2660D-14  -2.4241D-12   2.2223D-12   5.4786D-12  
D  MOJAVE12  HYD  CHEB_1    -8.6113D-12   1.1472D-11   5.6409D-12  -1.2744D-12  -1.3941D-12   1.4497D-12   1.1734D-12   4.9546D-13   5.8918D-13  
D  MOJAVE12  HYD  CHEB_2    -3.4821D-12   1.8755D-12   8.9356D-13  -1.9855D-13  -1.8632D-13   3.0497D-13   1.9853D-13   9.0710D-14   1.0150D-13  
D  MOJAVE12  HYD  CHEB_3    -1.4854D-12  -2.5452D-13  -1.3707D-13   3.3000D-14   3.9602D-14  -2.1494D-14  -3.0591D-14  -7.6003D-15  -9.8402D-15  
D  MOJAVE12  HYD  CHEB_4    -6.7203D-13  -3.0837D-14  -1.1328D-14   1.4691D-14   1.6241D-14  -8.8142D-15   2.0035D-15   9.7519D-16   6.0361D-16  
D  MOJAVE12  HYD  CHEB_5    -8.6881D-14   1.2516D-14   4.0225D-15  -7.5732D-15  -1.3240D-14   3.4978D-15   6.3756D-16   3.0444D-16  -6.9761D-16  
#
D  MOJAVE12  NHY  DER_NORT  -3.6285D-04  -8.0037D-04  -1.0740D-03  -3.5319D-04   6.9792D-04   5.3450D-04  -2.9708D-04  -8.6655D-05  -2.2331D-04  
D  MOJAVE12  NHY  DER_EAST   8.8437D-04  -1.4893D-03  -1.0457D-03   3.9284D-05   1.1849D-03   7.3948D-04  -8.0134D-04   3.4159D-04   1.0932D-04  
D  MOJAVE12  NHY  CHEB_0     2.3755D-10  -8.9037D-11  -4.7430D-11   8.9657D-12   4.9225D-11  -2.1444D-11  -4.1096D-11  -2.0183D-12  -4.8142D-13  
D  MOJAVE12  NHY  CHEB_1     1.3919D-11  -5.0380D-12  -2.6009D-12   1.8105D-13   2.5913D-12  -1.0172D-12  -1.8931D-12  -1.4950D-13   3.1789D-14  
D  MOJAVE12  NHY  CHEB_2     2.6038D-12  -9.4560D-13  -4.6465D-13   1.0254D-14   4.6207D-13  -1.5939D-13  -3.1550D-13  -2.6994D-14   7.1097D-15  
D  MOJAVE12  NHY  CHEB_3    -2.1378D-13   7.9359D-14   5.3440D-14  -1.0670D-14  -5.1373D-14   2.8996D-14   4.4144D-14   4.3694D-15  -3.0604D-15  
D  MOJAVE12  NHY  CHEB_4    -3.6672D-14   1.3983D-14   9.4861D-15  -1.7580D-15  -9.3282D-15   5.1604D-15   7.0338D-15   1.3211D-15  -4.8228D-16  
D  MOJAVE12  NHY  CHEB_5    -6.3677D-15   3.2238D-15   1.2203D-15   5.3208D-16  -1.2264D-15   1.1324D-16   2.4955D-16  -9.8967D-16  -6.4380D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MOJ_7288  HYD  DER_NORT   5.9758D-05   1.5860D-05   4.5331D-06  -1.5600D-05  -1.6281D-05  -4.3102D-07  -3.9825D-06   2.1199D-07  -3.0816D-06  
D  MOJ_7288  HYD  DER_EAST   1.9934D-06  -2.5469D-05  -1.5664D-05  -8.3310D-07   1.1445D-05  -1.1214D-05   2.3904D-06   2.0569D-06  -9.5011D-07  
D  MOJ_7288  HYD  CHEB_0     6.9316D-09   3.1366D-11   1.6258D-12   8.1924D-12   1.3712D-12   8.9996D-14  -2.4110D-12   2.3380D-12   5.5188D-12  
D  MOJ_7288  HYD  CHEB_1    -8.8609D-12   1.1501D-11   5.6486D-12  -1.2716D-12  -1.3963D-12   1.4526D-12   1.1755D-12   5.0681D-13   5.9119D-13  
D  MOJ_7288  HYD  CHEB_2    -3.5260D-12   1.8792D-12   8.9386D-13  -1.9841D-13  -1.8780D-13   3.0546D-13   1.9832D-13   9.3227D-14   1.0176D-13  
D  MOJ_7288  HYD  CHEB_3    -1.4817D-12  -2.5478D-13  -1.3712D-13   3.3167D-14   3.9972D-14  -2.1912D-14  -3.0725D-14  -7.6845D-15  -9.9647D-15  
D  MOJ_7288  HYD  CHEB_4    -6.7387D-13  -3.1466D-14  -1.1467D-14   1.4587D-14   1.5974D-14  -8.6510D-15   2.0500D-15   9.9671D-16   6.9171D-16  
D  MOJ_7288  HYD  CHEB_5    -8.6615D-14   1.2985D-14   4.4714D-15  -7.6670D-15  -1.3372D-14   3.3679D-15   5.0002D-16   2.0757D-16  -7.6112D-16  
#
D  MOJ_7288  NHY  DER_NORT  -3.5695D-04  -8.0011D-04  -1.0725D-03  -3.5378D-04   6.9869D-04   5.3332D-04  -2.9859D-04  -8.3419D-05  -2.2389D-04  
D  MOJ_7288  NHY  DER_EAST   8.8220D-04  -1.4845D-03  -1.0453D-03   4.0585D-05   1.1856D-03   7.4008D-04  -8.0464D-04   3.4471D-04   1.1107D-04  
D  MOJ_7288  NHY  CHEB_0     2.3875D-10  -8.9287D-11  -4.7527D-11   8.9079D-12   4.9311D-11  -2.1559D-11  -4.1155D-11  -1.8931D-12  -4.7448D-13  
D  MOJ_7288  NHY  CHEB_1     1.3975D-11  -5.0461D-12  -2.6014D-12   1.7499D-13   2.5901D-12  -1.0217D-12  -1.8890D-12  -1.3687D-13   3.2726D-14  
D  MOJ_7288  NHY  CHEB_2     2.6132D-12  -9.4694D-13  -4.6526D-13   9.3294D-15   4.6164D-13  -1.5966D-13  -3.1457D-13  -2.5685D-14   7.4002D-15  
D  MOJ_7288  NHY  CHEB_3    -2.1553D-13   8.0133D-14   5.4123D-14  -1.1089D-14  -5.1825D-14   2.9016D-14   4.4501D-14   4.8818D-15  -3.0711D-15  
D  MOJ_7288  NHY  CHEB_4    -3.6474D-14   1.3665D-14   8.9417D-15  -1.4033D-15  -9.0059D-15   5.2353D-15   6.8091D-15   6.6889D-16  -4.1522D-16  
D  MOJ_7288  NHY  CHEB_5    -6.4344D-15   3.5444D-15   1.6378D-15   4.0280D-16  -1.3182D-15  -5.5944D-17   2.8237D-16  -5.0736D-16  -7.5891D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MON_PEAK  HYD  DER_NORT   7.0277D-05   3.7257D-05   1.3583D-05  -2.4813D-05  -1.8197D-05   2.7043D-06   1.4004D-06  -4.4715D-07   2.5943D-08  
D  MON_PEAK  HYD  DER_EAST  -1.3042D-05  -2.9237D-05  -2.0648D-05  -4.9207D-06   9.1082D-06  -1.3560D-05   6.8446D-06   1.2044D-06  -6.8890D-07  
D  MON_PEAK  HYD  CHEB_0     6.2198D-09   1.8308D-12  -5.4719D-12   6.7807D-12   4.1251D-12  -3.4724D-12  -4.2307D-12  -8.2941D-13   2.2417D-12  
D  MON_PEAK  HYD  CHEB_1     3.9462D-12   8.9151D-12   5.0661D-12  -7.3181D-13  -6.8278D-13   1.1447D-12   1.0211D-12   2.1273D-13   2.6857D-13  
D  MON_PEAK  HYD  CHEB_2    -1.0390D-12   1.4432D-12   8.1559D-13  -1.5893D-13  -7.7264D-14   2.4759D-13   1.9727D-13   1.4678D-14   5.2483D-14  
D  MON_PEAK  HYD  CHEB_3    -1.6353D-12  -1.9464D-13  -1.1594D-13   2.7435D-14   3.6420D-14   2.9423D-15  -1.3884D-14  -3.9982D-15  -6.6591D-15  
D  MON_PEAK  HYD  CHEB_4    -5.7348D-13  -2.2396D-15  -4.4639D-15   1.9976D-16   1.2496D-15  -2.8654D-15  -2.8458D-15   3.1833D-16  -1.7588D-15  
D  MON_PEAK  HYD  CHEB_5    -7.3520D-14   3.4162D-16   5.8920D-16   6.2895D-16  -3.6889D-15  -1.3277D-16   9.0463D-16  -6.4882D-16   6.3631D-16  
#
D  MON_PEAK  NHY  DER_NORT  -4.2142D-05  -1.4094D-03  -1.6384D-04   4.6863D-04   3.4810D-04  -4.6405D-04   3.3220D-04  -9.6189D-05  -2.2146D-04  
D  MON_PEAK  NHY  DER_EAST   1.3628D-04  -1.8622D-03  -9.5951D-04   7.2482D-04   7.1720D-04   2.2279D-04  -2.3125D-04  -2.2497D-04  -2.5710D-04  
D  MON_PEAK  NHY  CHEB_0     1.6902D-10  -9.4113D-11  -6.3395D-11   1.5273D-11   6.0747D-11  -7.3058D-12  -4.1043D-11  -3.6779D-12   7.1307D-13  
D  MON_PEAK  NHY  CHEB_1     1.0657D-11  -5.9087D-12  -4.0470D-12   7.5200D-13   3.7772D-12  -2.9190D-14  -2.3226D-12   5.3453D-14   4.6048D-14  
D  MON_PEAK  NHY  CHEB_2     2.0745D-12  -1.1653D-12  -7.9638D-13   1.4062D-13   7.4703D-13   2.4230D-14  -4.5427D-13  -2.7000D-14   3.6134D-14  
D  MON_PEAK  NHY  CHEB_3    -1.2810D-13   6.3492D-14   4.2524D-14  -1.3851D-14  -3.7144D-14   1.8977D-14   2.7868D-14  -1.8106D-14   1.0979D-14  
D  MON_PEAK  NHY  CHEB_4    -2.5284D-14   1.6149D-14   9.8958D-15  -4.2886D-15  -9.8460D-15   1.5685D-15   6.7061D-15  -1.3961D-15  -2.9996D-16  
D  MON_PEAK  NHY  CHEB_5    -5.5131D-15   3.3427D-15   2.1126D-15  -1.0179D-15  -2.2250D-15   1.0905D-15   2.0227D-15   1.4821D-15  -8.1060D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MOPRA     HYD  DER_NORT  -1.0075D-04   3.0264D-05   1.1794D-05  -7.9279D-06   5.2190D-06   5.9044D-06   5.1315D-06   1.9957D-06  -1.0518D-07  
D  MOPRA     HYD  DER_EAST   1.1727D-05  -9.1641D-08   7.6600D-06  -1.1325D-07  -8.6081D-06   4.2940D-06   1.2926D-05  -1.9432D-07  -9.9649D-07  
D  MOPRA     HYD  CHEB_0     7.0332D-09  -2.3226D-11  -1.1278D-11  -1.0116D-11  -4.9199D-13   7.4975D-12  -4.9670D-12  -3.6724D-12   2.5410D-12  
D  MOPRA     HYD  CHEB_1    -7.7199D-12  -8.0761D-12  -3.1078D-12   1.9310D-12  -9.8027D-13  -3.8597D-13  -3.0891D-13  -3.3137D-13   3.2383D-13  
D  MOPRA     HYD  CHEB_2    -3.3182D-12  -1.4536D-12  -5.4446D-13   3.5394D-13  -1.0011D-13  -1.1040D-13  -5.6697D-14  -6.6521D-14   6.8271D-14  
D  MOPRA     HYD  CHEB_3    -1.5253D-12   1.4703D-13   7.0584D-14  -2.8925D-14   4.4189D-14  -5.2070D-15   1.9552D-15   4.1015D-15  -3.6894D-15  
D  MOPRA     HYD  CHEB_4    -6.3928D-13   1.6294D-14   8.7291D-15  -4.1477D-15   2.2486D-15   3.3346D-15  -2.9991D-15   1.0532D-15   9.5657D-17  
D  MOPRA     HYD  CHEB_5    -9.7136D-14   1.1801D-15   2.2225D-16   1.1237D-15  -2.4129D-15   2.1399D-16   2.4855D-15   1.6269D-16  -5.2583D-16  
#
D  MOPRA     NHY  DER_NORT  -2.7087D-04  -6.4142D-04   1.4683D-04   1.2726D-04   1.0541D-04   2.4599D-04  -1.9117D-04  -8.2750D-05   9.4221D-05  
D  MOPRA     NHY  DER_EAST   1.0427D-03   2.2861D-04  -2.4504D-04   2.6517D-06   7.8644D-05  -8.5158D-05   2.0054D-04   5.1889D-06  -1.9828D-04  
D  MOPRA     NHY  CHEB_0     3.2253D-10   1.4015D-10   7.6903D-11   5.0205D-12   2.8267D-11  -1.2375D-11   1.4327D-11   7.4038D-12  -3.5627D-12  
D  MOPRA     NHY  CHEB_1     1.9757D-11   7.1508D-12   4.3259D-12   3.8881D-13   1.4099D-12  -5.5971D-13   9.9454D-13   2.4284D-13  -7.6901D-15  
D  MOPRA     NHY  CHEB_2     3.6706D-12   1.1916D-12   7.6662D-13   6.1466D-14   2.1337D-13  -8.2635D-14   1.8517D-13   4.5171D-14   4.4153D-14  
D  MOPRA     NHY  CHEB_3    -3.1139D-13  -1.7547D-13  -8.4637D-14  -8.5786D-15  -4.3603D-14   1.7684D-14  -1.5460D-14  -4.7774D-15   1.7418D-14  
D  MOPRA     NHY  CHEB_4    -4.8233D-14  -1.8090D-14  -1.0477D-14  -1.1232D-15  -1.2468D-15   1.6153D-15  -1.5609D-15  -1.4535D-15   2.5432D-15  
D  MOPRA     NHY  CHEB_5    -8.5289D-15  -4.3570D-15  -1.7215D-15  -3.1903D-17  -1.3658D-15   5.5029D-16  -8.4143D-16  -3.2390D-16  -2.0664D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  MV2ONSLA  HYD  DER_NORT   1.2675D-04   7.2271D-05  -4.1908D-06   2.4104D-05  -3.2090D-05   1.2185D-05  -7.0485D-06  -1.5488D-06  -7.9845D-07  
D  MV2ONSLA  HYD  DER_EAST  -1.7440D-05  -1.8692D-05  -2.5892D-05   9.0054D-06  -1.9115D-05  -1.2284D-05  -7.2826D-06   2.4904D-06  -1.0708D-07  
D  MV2ONSLA  HYD  CHEB_0     7.6821D-09  -6.5844D-12   1.9416D-11  -1.5915D-11  -1.7757D-12   1.9943D-12  -8.9676D-12   5.1429D-13  -9.2060D-14  
D  MV2ONSLA  HYD  CHEB_1    -3.3908D-12   1.3933D-11   6.6969D-12  -5.9888D-14   4.9358D-13  -5.8808D-13   7.0028D-13  -6.7378D-14  -3.3147D-13  
D  MV2ONSLA  HYD  CHEB_2    -2.9816D-12   1.6823D-12   9.6671D-13   1.2314D-14   1.5906D-13  -1.4417D-13   1.2189D-13  -1.3384D-14  -5.8576D-14  
D  MV2ONSLA  HYD  CHEB_3    -1.7764D-12  -4.4248D-13  -1.9089D-13   1.3049D-14  -1.4213D-15  -2.5484D-15  -1.3843D-14   1.3545D-15   4.1527D-15  
D  MV2ONSLA  HYD  CHEB_4    -7.1275D-13   3.8282D-14   2.2939D-15  -1.8813D-15  -3.8600D-15   3.3822D-15   5.6966D-16  -1.2778D-15  -4.9304D-16  
D  MV2ONSLA  HYD  CHEB_5    -1.0700D-13   4.5000D-16   2.3621D-15  -3.5575D-16  -1.5859D-15  -1.4135D-15   2.4629D-16   4.6541D-16   7.2507D-16  
#
D  MV2ONSLA  NHY  DER_NORT   3.5446D-04   2.7195D-04   4.3406D-04   1.1903D-04  -4.0850D-04  -1.0365D-04   1.2259D-04   8.1303D-05  -2.3516D-04  
D  MV2ONSLA  NHY  DER_EAST   5.5132D-06  -4.7173D-04   5.5636D-05   3.1845D-04  -3.2850D-04   1.4261D-04  -2.1831D-04   1.1934D-04   3.3091D-04  
D  MV2ONSLA  NHY  CHEB_0     3.7338D-10  -1.3513D-10  -9.7984D-11   3.3237D-11   4.4823D-12   5.1514D-13  -1.2131D-12   6.9231D-13   1.6002D-12  
D  MV2ONSLA  NHY  CHEB_1     2.1672D-11  -6.9601D-12  -5.5488D-12   1.6756D-12   2.0101D-13   2.6173D-13  -4.1360D-15  -9.0007D-14   2.5169D-13  
D  MV2ONSLA  NHY  CHEB_2     3.9073D-12  -1.1909D-12  -9.8137D-13   2.8544D-13   3.7135D-14   5.0476D-14   2.1522D-15  -2.7801D-14   3.9225D-14  
D  MV2ONSLA  NHY  CHEB_3    -3.8686D-13   1.4618D-13   9.9847D-14  -4.0700D-14   5.9510D-15   3.4926D-15  -1.6618D-15  -5.0368D-15  -6.6844D-15  
D  MV2ONSLA  NHY  CHEB_4    -6.1750D-14   2.3865D-14   1.5320D-14  -3.7916D-15   2.8191D-16  -6.4616D-16  -4.1725D-15   2.1109D-15   2.4297D-15  
D  MV2ONSLA  NHY  CHEB_5    -4.6297D-15  -2.5320D-15  -4.6280D-16  -2.4427D-15   2.5565D-15   2.1649D-15   1.0575D-15  -2.6025D-15  -1.3896D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NL-VLBA   HYD  DER_NORT   1.2110D-04   5.7265D-05  -9.7266D-07   2.4591D-06   6.0409D-06  -1.0830D-05   1.6821D-05   7.3709D-07   6.4670D-07  
D  NL-VLBA   HYD  DER_EAST  -2.4844D-05  -6.8402D-06  -6.0936D-06   6.6779D-07  -2.3663D-05   1.9873D-05  -3.1995D-06  -1.4728D-07   9.2784D-07  
D  NL-VLBA   HYD  CHEB_0     7.5081D-09   2.7274D-11   8.6533D-12   5.7996D-12   4.3189D-13   1.4686D-12  -4.4928D-13   4.4641D-12   1.0654D-12  
D  NL-VLBA   HYD  CHEB_1    -9.8404D-12   1.7740D-11   6.2912D-12  -2.0225D-12   2.3807D-13  -1.6956D-12   3.0246D-12   6.9661D-13   8.0752D-15  
D  NL-VLBA   HYD  CHEB_2    -3.6927D-12   2.8692D-12   9.6533D-13  -2.6574D-13   1.7525D-13  -2.6495D-13   5.3188D-13   1.2121D-13   1.1378D-15  
D  NL-VLBA   HYD  CHEB_3    -1.5337D-12  -3.9402D-13  -1.6052D-13   6.7785D-14   3.7424D-14   3.6650D-14  -5.5071D-14  -1.1200D-14  -5.7937D-16  
D  NL-VLBA   HYD  CHEB_4    -6.9214D-13  -5.6274D-15  -1.0726D-15  -2.6409D-15  -7.7576D-15  -1.4851D-15  -5.6003D-15   5.0657D-17  -4.7073D-16  
D  NL-VLBA   HYD  CHEB_5    -1.0578D-13   5.9031D-16   7.8584D-16  -3.4320D-17  -5.0893D-16   2.2447D-16   9.5611D-16   3.8871D-16  -7.2913D-16  
#
D  NL-VLBA   NHY  DER_NORT   1.1864D-03   4.6773D-04   5.1958D-05  -1.7080D-05   3.8684D-04  -2.2798D-04   1.7938D-04  -1.6475D-04   8.8494D-05  
D  NL-VLBA   NHY  DER_EAST  -3.8480D-04  -1.7964D-04  -4.4637D-04   8.0533D-05  -7.7157D-04   1.2943D-04  -2.3329D-04  -9.8928D-05   1.0162D-04  
D  NL-VLBA   NHY  CHEB_0     4.0977D-10  -2.4084D-10  -6.5843D-11   2.3200D-11   2.6023D-11   2.5696D-11  -4.4458D-11  -1.6402D-12   2.2279D-13  
D  NL-VLBA   NHY  CHEB_1     2.2856D-11  -1.3767D-11  -3.2398D-12   1.4441D-12   9.7387D-13   1.0963D-12  -2.1731D-12  -1.7949D-13  -1.1936D-13  
D  NL-VLBA   NHY  CHEB_2     4.0864D-12  -2.4931D-12  -5.5720D-13   2.6900D-13   1.5007D-13   2.0816D-13  -3.8006D-13  -4.1991D-14  -2.4736D-14  
D  NL-VLBA   NHY  CHEB_3    -4.3742D-13   2.4732D-13   7.1472D-14  -2.1542D-14  -3.0858D-14  -2.1276D-14   4.9022D-14  -2.2010D-15  -4.6178D-15  
D  NL-VLBA   NHY  CHEB_4    -6.3194D-14   3.7036D-14   9.6179D-15  -4.0324D-15  -2.5047D-15  -3.9810D-17   2.3364D-15  -1.0599D-15   4.2832D-15  
D  NL-VLBA   NHY  CHEB_5    -9.3223D-15   5.0936D-15   2.0591D-15  -1.4688D-15  -2.4076D-15  -2.9009D-15   2.4725D-15   1.2241D-17  -2.6239D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NOBEY_6M  HYD  DER_NORT   1.9786D-04   9.8945D-05   5.5829D-05   7.5435D-06  -2.6157D-05  -3.4689D-06  -1.8702D-05  -1.6295D-06   1.9404D-06  
D  NOBEY_6M  HYD  DER_EAST  -1.4790D-06   5.9971D-06  -1.9196D-05  -5.7119D-06  -1.5943D-05   7.1488D-06   2.5225D-07  -1.7265D-06   2.3287D-06  
D  NOBEY_6M  HYD  CHEB_0     6.5916D-09   1.7075D-11  -1.3215D-11  -4.5365D-12  -3.6302D-12   1.7353D-13  -5.0898D-13  -1.0734D-14   2.5696D-13  
D  NOBEY_6M  HYD  CHEB_1     3.1322D-12   1.4510D-11   1.0105D-11  -1.0396D-12  -1.9846D-12  -4.4886D-13   2.2345D-13  -1.6743D-13   2.8601D-13  
D  NOBEY_6M  HYD  CHEB_2    -8.5699D-13   2.3988D-12   1.7397D-12  -1.2291D-13  -2.4603D-13  -1.0747D-13   1.1100D-14  -2.9598D-14   2.8764D-14  
D  NOBEY_6M  HYD  CHEB_3    -1.6054D-12  -3.2659D-13  -2.2558D-13   5.2923D-14   8.3074D-14   4.6215D-14   1.3315D-14   3.6135D-15   1.9024D-15  
D  NOBEY_6M  HYD  CHEB_4    -6.4554D-13  -2.3939D-14  -2.6320D-14   7.6142D-15  -1.5594D-15  -2.4339D-15  -2.7827D-15  -1.9895D-15   2.0178D-15  
D  NOBEY_6M  HYD  CHEB_5    -5.8963D-14   1.0681D-14   1.0343D-14  -3.0103D-15  -5.2991D-15  -4.5155D-15  -4.1995D-15   8.9751D-16  -3.5079D-16  
#
D  NOBEY_6M  NHY  DER_NORT   1.6932D-03   7.1757D-05  -1.3354D-04   9.4440D-05   3.9823D-04  -8.7914D-05  -1.1914D-04  -1.1672D-04   2.8492D-04  
D  NOBEY_6M  NHY  DER_EAST  -6.3593D-04  -3.6987D-04  -5.2761D-04  -2.8831D-04  -5.6259D-05   1.3896D-04  -3.8377D-05   5.0865D-05   1.6680D-04  
D  NOBEY_6M  NHY  CHEB_0     3.2805D-10  -2.4935D-10  -1.5221D-10   4.9835D-11   8.3297D-11  -7.7153D-12  -3.6743D-11   1.6601D-11  -1.3990D-11  
D  NOBEY_6M  NHY  CHEB_1     2.0302D-11  -1.4241D-11  -8.9476D-12   2.4240D-12   4.4589D-12  -5.3434D-13  -2.1313D-12   1.0697D-12  -5.8691D-13  
D  NOBEY_6M  NHY  CHEB_2     3.7148D-12  -2.4660D-12  -1.5703D-12   3.8326D-13   7.0992D-13  -1.1348D-13  -3.2752D-13   1.7054D-13  -1.3476D-14  
D  NOBEY_6M  NHY  CHEB_3    -3.4503D-13   3.0359D-13   1.7592D-13  -7.1063D-14  -1.1657D-13   1.0995D-14   6.1654D-14  -2.7073D-14   4.3685D-14  
D  NOBEY_6M  NHY  CHEB_4    -5.2294D-14   4.2141D-14   2.4628D-14  -9.6692D-15  -1.4150D-14   1.5269D-15   4.8772D-15  -4.8695D-15   2.1553D-15  
D  NOBEY_6M  NHY  CHEB_5    -6.9486D-15   2.8795D-15   1.9949D-15   6.3710D-16   1.7555D-16   1.2168D-15  -6.0952D-16   7.8491D-16  -1.8001D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NOME      HYD  DER_NORT   2.4159D-05   1.0776D-05  -5.0660D-06  -9.8880D-06   1.3018D-05  -1.6907D-05  -2.2552D-05   1.3350D-06   6.0790D-07  
D  NOME      HYD  DER_EAST   1.7774D-05   1.2929D-06  -6.0613D-06   1.8377D-05  -6.7209D-06   3.7132D-05   3.3915D-05  -1.1651D-06  -2.5681D-08  
D  NOME      HYD  CHEB_0     7.3847D-09  -1.1806D-11   2.4898D-11  -1.6911D-11   4.9197D-12  -3.9794D-11  -4.3796D-12  -2.8592D-13   1.9137D-13  
D  NOME      HYD  CHEB_1     1.5007D-11   1.7263D-11   5.5917D-12  -1.6622D-12  -2.7835D-12   1.6005D-12  -2.0649D-12   6.3612D-14   2.5856D-13  
D  NOME      HYD  CHEB_2     7.1347D-13   2.6320D-12   1.0447D-12  -2.3151D-13  -2.4484D-13   2.9967D-13  -3.3051D-13   3.7222D-15   3.5019D-14  
D  NOME      HYD  CHEB_3    -2.0347D-12  -4.2132D-13  -1.0097D-13   2.8945D-14   1.3329D-13  -4.0911D-14   2.9184D-14  -5.8561D-16  -6.8748D-15  
D  NOME      HYD  CHEB_4    -7.1698D-13   1.0144D-14  -1.3595D-14  -5.7764D-15  -1.2672D-14  -2.1552D-15   1.1484D-15   6.4389D-16  -6.3231D-16  
D  NOME      HYD  CHEB_5    -1.0122D-13  -2.0764D-15  -1.0767D-15   6.6917D-15  -1.6549D-15   4.4947D-15   1.5209D-15  -6.2738D-16   1.1220D-15  
#
D  NOME      NHY  DER_NORT   7.2563D-04   7.3924D-04   5.5472D-04  -1.2239D-04   3.6278D-04  -1.3927D-04  -2.2767D-05   1.0013D-04   1.0419D-04  
D  NOME      NHY  DER_EAST   6.8726D-04  -3.6148D-04   2.1482D-05   8.4974D-04  -5.4896D-04   1.5555D-03   9.6723D-05   2.7677D-05   1.0622D-05  
D  NOME      NHY  CHEB_0     2.0343D-10  -1.4650D-10  -6.6889D-11   3.4210D-11   2.4944D-11  -9.8485D-12   1.8443D-11  -9.5790D-13  -9.0877D-13  
D  NOME      NHY  CHEB_1     1.2166D-11  -8.7369D-12  -4.2942D-12   1.9599D-12   1.4312D-12  -4.8010D-13   9.5010D-13  -2.9390D-14  -1.2957D-14  
D  NOME      NHY  CHEB_2     2.2329D-12  -1.5833D-12  -7.9766D-13   3.3967D-13   2.5512D-13  -7.0175D-14   1.5658D-13  -5.5000D-15  -1.3945D-15  
D  NOME      NHY  CHEB_3    -2.1144D-13   1.5736D-13   6.7584D-14  -4.1583D-14  -2.7718D-14   1.6431D-14  -2.4662D-14  -9.4078D-16   5.1642D-16  
D  NOME      NHY  CHEB_4    -3.1453D-14   2.2708D-14   1.0589D-14  -5.4265D-15  -5.3826D-15   2.8456D-16  -4.9470D-16   2.3659D-16   1.7725D-15  
D  NOME      NHY  CHEB_5    -6.8219D-15   3.7159D-15   1.8803D-15  -1.0030D-15  -7.2368D-16   8.4171D-16  -1.3876D-15  -3.6673D-16  -6.5423D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NOTO      HYD  DER_NORT   5.8639D-05   2.0065D-06   1.4129D-05  -1.6198D-06   1.0524D-05   2.6044D-06   8.2397D-06   2.0993D-07   3.0376D-07  
D  NOTO      HYD  DER_EAST  -5.0867D-05  -6.7925D-06   6.2843D-06  -6.1999D-06   3.0589D-06   1.0531D-05  -1.6065D-05   1.3085D-06   2.3230D-06  
D  NOTO      HYD  CHEB_0     7.6409D-09   4.2103D-11  -2.6916D-12   1.5635D-11  -9.7441D-12   9.3796D-12  -5.0689D-12  -5.2154D-13  -2.9207D-12  
D  NOTO      HYD  CHEB_1    -2.0414D-11   1.1779D-11   7.2693D-12  -2.2743D-12  -1.7286D-12  -1.1859D-13  -3.8739D-13  -2.4854D-13  -6.3482D-13  
D  NOTO      HYD  CHEB_2    -5.0724D-12   1.6579D-12   1.1179D-12  -3.4383D-13  -1.7568D-13  -3.3233D-15  -7.7682D-14  -6.4846D-15  -1.0221D-13  
D  NOTO      HYD  CHEB_3    -1.4427D-12  -3.3334D-13  -2.0101D-13   5.0681D-14   6.4734D-14   7.2906D-16   3.3149D-15  -8.0322D-15   9.4216D-15  
D  NOTO      HYD  CHEB_4    -7.2874D-13   3.2222D-15  -3.2949D-15   1.1398D-15  -9.2987D-16   2.6693D-16   3.1235D-16   1.9896D-16   9.8177D-16  
D  NOTO      HYD  CHEB_5    -8.4287D-14   2.3193D-15   3.9906D-15  -1.7033D-15  -1.7404D-15  -5.5258D-16   1.3409D-15   1.5710D-15  -1.2441D-16  
#
D  NOTO      NHY  DER_NORT  -5.5122D-04   8.1957D-04  -1.0288D-04  -8.2658D-05  -1.1548D-04   1.1074D-04  -3.7884D-07  -4.7874D-04  -5.3636D-04  
D  NOTO      NHY  DER_EAST  -1.0495D-04  -1.7989D-04  -2.9866D-04   1.6112D-04   1.8370D-05  -5.9433D-05   2.3889D-04  -3.2080D-04  -1.9178D-05  
D  NOTO      NHY  CHEB_0     4.5001D-10  -9.8142D-11  -8.5003D-11  -1.9642D-11   1.1879D-11   1.4179D-12   1.4371D-11  -7.7247D-13   8.5656D-12  
D  NOTO      NHY  CHEB_1     2.5666D-11  -4.5943D-12  -4.3426D-12  -9.5616D-13   4.0840D-13   2.7783D-13   3.7572D-13  -5.5016D-13  -4.1915D-13  
D  NOTO      NHY  CHEB_2     4.6929D-12  -7.7503D-13  -7.7298D-13  -1.3600D-13   8.3814D-14   4.1050D-14   2.9455D-14  -6.8696D-14  -1.1551D-13  
D  NOTO      NHY  CHEB_3    -4.4708D-13   1.0986D-13   8.2703D-14   3.1290D-14  -1.4308D-15  -8.5407D-15  -2.3475D-14   1.0896D-14  -1.2181D-14  
D  NOTO      NHY  CHEB_4    -7.4633D-14   2.2146D-14   1.9405D-14   6.0128D-15  -6.2259D-15  -9.9532D-16  -2.3423D-16  -5.1840D-15   3.1317D-15  
D  NOTO      NHY  CHEB_5    -1.2434D-14  -2.3630D-15  -1.1769D-16   9.3385D-16   3.4127D-15   3.2479D-17  -2.5867D-15   9.0446D-16  -1.2894D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NOTOX     HYD  DER_NORT   5.8639D-05   2.0065D-06   1.4129D-05  -1.6198D-06   1.0524D-05   2.6044D-06   8.2397D-06   2.0993D-07   3.0376D-07  
D  NOTOX     HYD  DER_EAST  -5.0867D-05  -6.7925D-06   6.2843D-06  -6.1999D-06   3.0589D-06   1.0531D-05  -1.6065D-05   1.3085D-06   2.3230D-06  
D  NOTOX     HYD  CHEB_0     7.6409D-09   4.2103D-11  -2.6916D-12   1.5635D-11  -9.7441D-12   9.3796D-12  -5.0689D-12  -5.2154D-13  -2.9207D-12  
D  NOTOX     HYD  CHEB_1    -2.0414D-11   1.1779D-11   7.2693D-12  -2.2743D-12  -1.7286D-12  -1.1859D-13  -3.8739D-13  -2.4854D-13  -6.3482D-13  
D  NOTOX     HYD  CHEB_2    -5.0724D-12   1.6579D-12   1.1179D-12  -3.4383D-13  -1.7568D-13  -3.3233D-15  -7.7682D-14  -6.4846D-15  -1.0221D-13  
D  NOTOX     HYD  CHEB_3    -1.4427D-12  -3.3334D-13  -2.0101D-13   5.0681D-14   6.4734D-14   7.2906D-16   3.3149D-15  -8.0322D-15   9.4216D-15  
D  NOTOX     HYD  CHEB_4    -7.2874D-13   3.2222D-15  -3.2949D-15   1.1398D-15  -9.2987D-16   2.6693D-16   3.1235D-16   1.9896D-16   9.8177D-16  
D  NOTOX     HYD  CHEB_5    -8.4287D-14   2.3193D-15   3.9906D-15  -1.7033D-15  -1.7404D-15  -5.5258D-16   1.3409D-15   1.5710D-15  -1.2441D-16  
#
D  NOTOX     NHY  DER_NORT  -5.5122D-04   8.1957D-04  -1.0288D-04  -8.2658D-05  -1.1548D-04   1.1074D-04  -3.7884D-07  -4.7874D-04  -5.3636D-04  
D  NOTOX     NHY  DER_EAST  -1.0495D-04  -1.7989D-04  -2.9866D-04   1.6112D-04   1.8370D-05  -5.9433D-05   2.3889D-04  -3.2080D-04  -1.9178D-05  
D  NOTOX     NHY  CHEB_0     4.5001D-10  -9.8142D-11  -8.5003D-11  -1.9642D-11   1.1879D-11   1.4179D-12   1.4371D-11  -7.7247D-13   8.5656D-12  
D  NOTOX     NHY  CHEB_1     2.5666D-11  -4.5943D-12  -4.3426D-12  -9.5616D-13   4.0840D-13   2.7783D-13   3.7572D-13  -5.5016D-13  -4.1915D-13  
D  NOTOX     NHY  CHEB_2     4.6929D-12  -7.7503D-13  -7.7298D-13  -1.3600D-13   8.3814D-14   4.1050D-14   2.9455D-14  -6.8696D-14  -1.1551D-13  
D  NOTOX     NHY  CHEB_3    -4.4708D-13   1.0986D-13   8.2703D-14   3.1290D-14  -1.4308D-15  -8.5407D-15  -2.3475D-14   1.0896D-14  -1.2181D-14  
D  NOTOX     NHY  CHEB_4    -7.4633D-14   2.2146D-14   1.9405D-14   6.0128D-15  -6.2259D-15  -9.9532D-16  -2.3423D-16  -5.1840D-15   3.1317D-15  
D  NOTOX     NHY  CHEB_5    -1.2434D-14  -2.3630D-15  -1.1769D-16   9.3385D-16   3.4127D-15   3.2479D-17  -2.5867D-15   9.0446D-16  -1.2894D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NRAO20    HYD  DER_NORT   1.4312D-04   7.9301D-05   2.1133D-05   1.6018D-06   3.0125D-05  -1.2961D-05   1.9226D-05   1.1140D-06   8.8107D-07  
D  NRAO20    HYD  DER_EAST  -2.5001D-05   1.2766D-06  -3.1172D-05   3.2026D-06  -1.0448D-05   4.7422D-06  -4.9151D-06  -8.9441D-07   3.4207D-07  
D  NRAO20    HYD  CHEB_0     7.0234D-09   3.0847D-12   1.0557D-12   9.2398D-12  -6.7115D-12   4.6863D-12  -5.7478D-12   2.3474D-12   8.3744D-14  
D  NRAO20    HYD  CHEB_1    -3.1753D-12   1.2488D-11   7.2579D-12  -1.7693D-12   4.9685D-13  -2.6841D-12   2.2277D-12   4.9849D-13  -2.0276D-13  
D  NRAO20    HYD  CHEB_2    -2.5220D-12   1.9268D-12   1.0472D-12  -2.7427D-13   1.2062D-13  -4.1703D-13   3.9539D-13   8.3598D-14  -6.7671D-14  
D  NRAO20    HYD  CHEB_3    -1.5235D-12  -2.5153D-13  -1.7276D-13   4.1488D-14   3.1309D-14   5.1462D-14  -2.9806D-14  -8.4789D-15  -1.5438D-15  
D  NRAO20    HYD  CHEB_4    -6.6572D-13   1.1108D-15   3.6814D-15   1.0390D-15   5.3401D-16   2.1904D-15   1.3755D-16   1.3278D-15   3.2597D-17  
D  NRAO20    HYD  CHEB_5    -9.0084D-14   1.5675D-15  -2.0933D-15  -1.8740D-15  -2.4515D-15   1.0294D-15  -1.2744D-15  -4.6551D-16   6.5274D-16  
#
D  NRAO20    NHY  DER_NORT   4.8385D-04  -4.0290D-05   3.0138D-04   3.1048D-05   5.8110D-04  -1.5390D-04   3.8023D-04  -2.3941D-04  -1.3476D-04  
D  NRAO20    NHY  DER_EAST  -9.5299D-04  -5.8229D-04  -5.2643D-04   1.5323D-04  -1.4742D-04   2.7390D-04  -1.1367D-04  -2.5560D-04  -5.5479D-05  
D  NRAO20    NHY  CHEB_0     3.7946D-10  -1.9156D-10  -8.1968D-11   2.1487D-11   3.3825D-11   2.4916D-11  -2.7032D-11  -1.5311D-11   3.0075D-12  
D  NRAO20    NHY  CHEB_1     2.1664D-11  -1.1104D-11  -4.3527D-12   1.1138D-12   1.6424D-12   1.1328D-12  -1.5242D-12  -6.5169D-13   3.7890D-14  
D  NRAO20    NHY  CHEB_2     3.9936D-12  -2.0586D-12  -7.8241D-13   1.8173D-13   2.5487D-13   2.0076D-13  -2.6942D-13  -1.2305D-13   1.6767D-15  
D  NRAO20    NHY  CHEB_3    -3.6656D-13   1.8754D-13   8.5719D-14  -2.8113D-14  -5.1144D-14  -2.2009D-14   3.2636D-14   1.6341D-14  -9.0957D-15  
D  NRAO20    NHY  CHEB_4    -6.2846D-14   3.1278D-14   1.3166D-14  -3.9426D-15  -4.2215D-15  -3.2741D-15   6.5010D-15   2.7750D-15  -2.5264D-15  
D  NRAO20    NHY  CHEB_5    -7.6571D-15   5.1023D-15   1.7973D-15   6.6727D-16  -1.6638D-15  -1.1271D-15  -5.6559D-16   5.9841D-16   7.9312D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NRAO85_1  HYD  DER_NORT   1.4311D-04   7.9291D-05   2.1133D-05   1.5972D-06   3.0124D-05  -1.2965D-05   1.9229D-05   1.1095D-06   8.8162D-07  
D  NRAO85_1  HYD  DER_EAST  -2.4952D-05   1.3127D-06  -3.1153D-05   3.2066D-06  -1.0434D-05   4.7467D-06  -4.9124D-06  -8.9234D-07   3.4618D-07  
D  NRAO85_1  HYD  CHEB_0     7.0225D-09   3.0541D-12   1.0498D-12   9.2427D-12  -6.7101D-12   4.6892D-12  -5.7510D-12   2.3422D-12   9.3755D-14  
D  NRAO85_1  HYD  CHEB_1    -3.1619D-12   1.2483D-11   7.2557D-12  -1.7692D-12   4.9576D-13  -2.6835D-12   2.2267D-12   4.9788D-13  -2.0122D-13  
D  NRAO85_1  HYD  CHEB_2    -2.5189D-12   1.9267D-12   1.0469D-12  -2.7412D-13   1.2064D-13  -4.1692D-13   3.9537D-13   8.3470D-14  -6.7599D-14  
D  NRAO85_1  HYD  CHEB_3    -1.5235D-12  -2.5165D-13  -1.7269D-13   4.1461D-14   3.1303D-14   5.1391D-14  -2.9765D-14  -8.4352D-15  -1.5660D-15  
D  NRAO85_1  HYD  CHEB_4    -6.6582D-13   1.1066D-15   3.6136D-15   1.0714D-15   5.1653D-16   2.2207D-15   1.0507D-16   1.2938D-15   3.7052D-17  
D  NRAO85_1  HYD  CHEB_5    -8.9975D-14   1.5126D-15  -2.0523D-15  -1.8863D-15  -2.4576D-15   1.0310D-15  -1.2693D-15  -4.4383D-16   6.6210D-16  
#
D  NRAO85_1  NHY  DER_NORT   4.8195D-04  -3.9597D-05   3.0169D-04   3.1165D-05   5.8144D-04  -1.5428D-04   3.8035D-04  -2.3973D-04  -1.3478D-04  
D  NRAO85_1  NHY  DER_EAST  -9.4818D-04  -5.8312D-04  -5.2612D-04   1.5274D-04  -1.4793D-04   2.7438D-04  -1.1342D-04  -2.5579D-04  -5.5079D-05  
D  NRAO85_1  NHY  CHEB_0     3.7931D-10  -1.9148D-10  -8.1924D-11   2.1472D-11   3.3825D-11   2.4903D-11  -2.7033D-11  -1.5302D-11   3.0170D-12  
D  NRAO85_1  NHY  CHEB_1     2.1653D-11  -1.1098D-11  -4.3508D-12   1.1123D-12   1.6441D-12   1.1330D-12  -1.5254D-12  -6.5197D-13   3.8344D-14  
D  NRAO85_1  NHY  CHEB_2     3.9928D-12  -2.0588D-12  -7.8231D-13   1.8203D-13   2.5532D-13   2.0075D-13  -2.6978D-13  -1.2326D-13   2.4702D-15  
D  NRAO85_1  NHY  CHEB_3    -3.6605D-13   1.8714D-13   8.5641D-14  -2.7966D-14  -5.1109D-14  -2.2091D-14   3.2605D-14   1.6224D-14  -9.0283D-15  
D  NRAO85_1  NHY  CHEB_4    -6.2942D-14   3.1358D-14   1.3182D-14  -3.9835D-15  -4.2606D-15  -3.2056D-15   6.5687D-15   2.8518D-15  -2.5233D-15  
D  NRAO85_1  NHY  CHEB_5    -7.6821D-15   5.0882D-15   1.7878D-15   6.5844D-16  -1.6141D-15  -1.1564D-15  -5.7618D-16   5.5335D-16   7.5672D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NRAO85_3  HYD  DER_NORT   1.4229D-04   7.8770D-05   2.1023D-05   1.5533D-06   2.9932D-05  -1.2898D-05   1.9144D-05   1.0576D-06   8.8686D-07  
D  NRAO85_3  HYD  DER_EAST  -2.4829D-05   1.3769D-06  -3.0976D-05   3.1515D-06  -1.0394D-05   4.8071D-06  -4.9065D-06  -8.9643D-07   3.1269D-07  
D  NRAO85_3  HYD  CHEB_0     7.0407D-09   3.8792D-12   1.3555D-12   9.2588D-12  -6.6209D-12   4.5698D-12  -5.6297D-12   2.4784D-12  -4.6032D-14  
D  NRAO85_3  HYD  CHEB_1    -3.5242D-12   1.2529D-11   7.2633D-12  -1.7692D-12   4.9713D-13  -2.6918D-12   2.2319D-12   5.0922D-13  -2.1532D-13  
D  NRAO85_3  HYD  CHEB_2    -2.5789D-12   1.9355D-12   1.0477D-12  -2.7297D-13   1.2123D-13  -4.1715D-13   3.9716D-13   8.5574D-14  -6.9759D-14  
D  NRAO85_3  HYD  CHEB_3    -1.5201D-12  -2.5251D-13  -1.7332D-13   4.1363D-14   3.2344D-14   5.0780D-14  -2.9833D-14  -8.3190D-15  -1.4471D-15  
D  NRAO85_3  HYD  CHEB_4    -6.6764D-13   2.8151D-16   3.3421D-15   1.3673D-15  -5.2726D-16   2.8226D-15  -1.5388D-16   1.2015D-15  -2.5141D-16  
D  NRAO85_3  HYD  CHEB_5    -8.9482D-14   2.7956D-15  -1.6747D-15  -2.0621D-15  -1.6259D-15   6.5438D-16  -1.2774D-15  -4.2486D-16   8.2002D-16  
#
D  NRAO85_3  NHY  DER_NORT   4.6725D-04  -3.7652D-05   3.0272D-04   3.1070D-05   5.8002D-04  -1.5193D-04   3.7557D-04  -2.4099D-04  -1.3512D-04  
D  NRAO85_3  NHY  DER_EAST  -9.1898D-04  -5.8390D-04  -5.2487D-04   1.5041D-04  -1.5216D-04   2.7769D-04  -1.0933D-04  -2.5745D-04  -5.5292D-05  
D  NRAO85_3  NHY  CHEB_0     3.8313D-10  -1.9348D-10  -8.2479D-11   2.1735D-11   3.3961D-11   2.5071D-11  -2.7259D-11  -1.5296D-11   2.9419D-12  
D  NRAO85_3  NHY  CHEB_1     2.1805D-11  -1.1177D-11  -4.3660D-12   1.1242D-12   1.6411D-12   1.1387D-12  -1.5392D-12  -6.4868D-13   2.4016D-14  
D  NRAO85_3  NHY  CHEB_2     4.0185D-12  -2.0758D-12  -7.8644D-13   1.8674D-13   2.5861D-13   2.0041D-13  -2.7214D-13  -1.2429D-13   3.6055D-15  
D  NRAO85_3  NHY  CHEB_3    -3.6862D-13   1.8758D-13   8.6768D-14  -2.7997D-14  -5.2294D-14  -2.1740D-14   3.4031D-14   1.7367D-14  -7.1027D-15  
D  NRAO85_3  NHY  CHEB_4    -6.3439D-14   3.2683D-14   1.3652D-14  -4.3955D-15  -4.8014D-15  -3.9910D-15   6.2741D-15   2.0286D-15  -4.3352D-15  
D  NRAO85_3  NHY  CHEB_5    -7.4238D-15   5.0974D-15   1.8992D-15   6.0997D-16  -2.0963D-15  -5.4828D-16  -4.1017D-16   1.4683D-15   1.4594D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NRAO_140  HYD  DER_NORT   1.4331D-04   7.9377D-05   2.1147D-05   1.5889D-06   3.0164D-05  -1.2981D-05   1.9242D-05   1.1099D-06   8.8074D-07  
D  NRAO_140  HYD  DER_EAST  -2.4800D-05   1.4083D-06  -3.1109D-05   3.2135D-06  -1.0395D-05   4.7558D-06  -4.9065D-06  -8.9186D-07   3.6128D-07  
D  NRAO_140  HYD  CHEB_0     7.0185D-09   2.9099D-12   1.0017D-12   9.2521D-12  -6.7101D-12   4.7061D-12  -5.7664D-12   2.3157D-12   1.2946D-13  
D  NRAO_140  HYD  CHEB_1    -3.0905D-12   1.2469D-11   7.2483D-12  -1.7683D-12   4.9428D-13  -2.6822D-12   2.2237D-12   4.9524D-13  -1.9521D-13  
D  NRAO_140  HYD  CHEB_2    -2.5055D-12   1.9254D-12   1.0459D-12  -2.7390D-13   1.2038D-13  -4.1653D-13   3.9512D-13   8.2959D-14  -6.7338D-14  
D  NRAO_140  HYD  CHEB_3    -1.5234D-12  -2.5183D-13  -1.7229D-13   4.1396D-14   3.1282D-14   5.1199D-14  -2.9687D-14  -8.3950D-15  -1.6367D-15  
D  NRAO_140  HYD  CHEB_4    -6.6613D-13   1.1972D-15   3.4624D-15   1.1526D-15   5.4261D-16   2.2723D-15   6.2748D-17   1.2255D-15   7.0306D-17  
D  NRAO_140  HYD  CHEB_5    -8.9881D-14   1.2157D-15  -2.0060D-15  -1.9112D-15  -2.5513D-15   1.0610D-15  -1.2401D-15  -3.8447D-16   6.7153D-16  
#
D  NRAO_140  NHY  DER_NORT   4.8949D-04  -4.0173D-05   3.0354D-04   3.1882D-05   5.8049D-04  -1.5374D-04   3.8168D-04  -2.4128D-04  -1.3346D-04  
D  NRAO_140  NHY  DER_EAST  -9.3283D-04  -5.8547D-04  -5.2418D-04   1.5158D-04  -1.4976D-04   2.7607D-04  -1.1270D-04  -2.5728D-04  -5.3201D-05  
D  NRAO_140  NHY  CHEB_0     3.7859D-10  -1.9106D-10  -8.1759D-11   2.1412D-11   3.3800D-11   2.4829D-11  -2.7012D-11  -1.5253D-11   3.0676D-12  
D  NRAO_140  NHY  CHEB_1     2.1598D-11  -1.1068D-11  -4.3431D-12   1.1065D-12   1.6463D-12   1.1310D-12  -1.5256D-12  -6.5231D-13   4.1333D-14  
D  NRAO_140  NHY  CHEB_2     3.9877D-12  -2.0573D-12  -7.8164D-13   1.8246D-13   2.5581D-13   2.0052D-13  -2.7043D-13  -1.2407D-13   4.8091D-15  
D  NRAO_140  NHY  CHEB_3    -3.6414D-13   1.8578D-13   8.5325D-14  -2.7542D-14  -5.0820D-14  -2.2276D-14   3.2376D-14   1.5708D-14  -9.0033D-15  
D  NRAO_140  NHY  CHEB_4    -6.3217D-14   3.1693D-14   1.3230D-14  -4.1518D-15  -4.4100D-15  -2.8956D-15   6.7293D-15   3.1843D-15  -2.4813D-15  
D  NRAO_140  NHY  CHEB_5    -7.8408D-15   4.9734D-15   1.7285D-15   6.4575D-16  -1.3428D-15  -1.2718D-15  -5.6387D-16   3.6321D-16   6.8716D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  NYALES20  HYD  DER_NORT   5.7709D-05  -1.6068D-05  -4.9422D-06  -2.4144D-05   1.0682D-05   2.2982D-05  -1.8490D-05  -7.0557D-07   1.1841D-06  
D  NYALES20  HYD  DER_EAST  -2.1681D-05   1.2580D-05  -2.1797D-06   1.8256D-05  -8.6107D-06  -1.8676D-05  -3.4905D-05   2.1821D-06   1.3530D-06  
D  NYALES20  HYD  CHEB_0     7.6219D-09  -3.9883D-11   1.1830D-12  -2.3469D-11   2.7032D-12  -2.1618D-11   3.4232D-11   1.0869D-12   8.9140D-13  
D  NYALES20  HYD  CHEB_1     2.3050D-11   1.8843D-11   7.8503D-12  -4.0423D-12  -1.5627D-12   6.5345D-13   8.2069D-13   9.2131D-14  -2.0661D-13  
D  NYALES20  HYD  CHEB_2     8.9506D-13   1.9483D-12   1.0335D-12  -6.6772D-13  -4.2396D-13   8.4662D-14   9.5405D-14   9.2395D-15  -2.8269D-14  
D  NYALES20  HYD  CHEB_3    -2.4717D-12  -7.0196D-13  -2.5196D-13   6.6760D-14  -1.0114D-14  -1.2845D-14  -2.2823D-14  -6.6304D-15  -1.5662D-16  
D  NYALES20  HYD  CHEB_4    -5.6052D-13   4.0245D-14  -1.9349D-15   7.5083D-15   2.9119D-14   1.7610D-14  -5.3522D-15   1.7711D-15   1.5654D-15  
D  NYALES20  HYD  CHEB_5    -1.4124D-13   2.6309D-14   1.6622D-14   8.5043D-16  -2.3074D-15  -6.4642D-15   3.0826D-15  -6.0287D-16  -3.2750D-15  
#
D  NYALES20  NHY  DER_NORT   9.8895D-04   1.5957D-04   1.0558D-04  -7.9364D-04  -1.6159D-04  -4.3887D-05   1.7766D-04  -2.4864D-05   1.0963D-05  
D  NYALES20  NHY  DER_EAST   2.6749D-04   1.1377D-04   1.8851D-04   4.4678D-05   2.4363D-04  -5.1331D-04  -2.2348D-04  -2.6794D-05  -1.5387D-05  
D  NYALES20  NHY  CHEB_0     1.6044D-10  -9.2281D-11  -4.6394D-11   4.0944D-11   3.0792D-11  -8.6043D-12  -2.1112D-11  -1.2586D-12  -6.4715D-13  
D  NYALES20  NHY  CHEB_1     1.0865D-11  -5.5086D-12  -2.8061D-12   2.6676D-12   1.6827D-12  -6.8096D-13  -1.2359D-12   2.8656D-14  -1.1186D-14  
D  NYALES20  NHY  CHEB_2     1.5847D-12  -6.8553D-13  -3.6360D-13   3.2739D-13   1.4535D-13  -9.9408D-14  -1.0168D-13  -4.6153D-15   6.3100D-15  
D  NYALES20  NHY  CHEB_3    -2.1964D-13   1.0711D-13   6.1224D-14  -5.8722D-14  -3.9824D-14   1.8098D-14   3.3428D-14  -3.0571D-15   3.2891D-15  
D  NYALES20  NHY  CHEB_4     7.8129D-15  -1.6434D-14  -6.3705D-15   8.0750D-15   1.1894D-14   4.0535D-15  -8.0313D-15   1.4524D-15   1.3214D-15  
D  NYALES20  NHY  CHEB_5    -1.5644D-14   1.4428D-14   6.7547D-15  -6.7280D-15  -6.6894D-15  -1.7577D-15   5.3426D-15   5.9461D-16   3.8359D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  OCOTILLO  HYD  DER_NORT   7.3164D-05   3.7971D-05   1.1121D-05  -1.7595D-05  -1.4606D-05   2.4142D-06   5.3277D-08   1.1715D-05  -4.7625D-06  
D  OCOTILLO  HYD  DER_EAST  -1.6314D-05  -2.4347D-05  -1.3248D-05  -4.9830D-06   7.8320D-06  -1.0776D-05   5.7785D-06  -4.2900D-06   6.2886D-06  
D  OCOTILLO  HYD  CHEB_0     7.7029D-09   5.4221D-11   1.3112D-11   8.9968D-12   2.1700D-13   3.2761D-12  -1.6657D-12   9.9546D-12   6.1052D-12  
D  OCOTILLO  HYD  CHEB_1    -2.7549D-11   1.2316D-11   6.4622D-12  -8.6831D-13  -1.1525D-12   1.6932D-12   1.3069D-12   1.1159D-12   5.2377D-13  
D  OCOTILLO  HYD  CHEB_2    -7.0230D-12   1.8587D-12   9.7616D-13  -3.8417D-14  -1.3445D-13   3.5299D-13   1.8139D-13   2.3374D-13   6.5078D-14  
D  OCOTILLO  HYD  CHEB_3    -1.1785D-12  -3.3027D-13  -1.8021D-13   2.0201D-14   4.3281D-14  -2.8917D-14  -2.9309D-14  -1.3907D-14  -1.2665D-14  
D  OCOTILLO  HYD  CHEB_4    -6.8384D-13  -4.3782D-15  -6.7754D-15  -8.5708D-15  -2.1301D-15  -1.2171D-14   1.8007D-15   2.3284D-15  -6.3862D-16  
D  OCOTILLO  HYD  CHEB_5    -1.2170D-13   4.3334D-15   5.1965D-15   6.3968D-15   6.4695D-16   4.5709D-15  -8.9867D-16  -1.1561D-15  -2.5046D-16  
#
D  OCOTILLO  NHY  DER_NORT   1.3271D-03  -1.3088D-03  -3.4460D-04   2.7837D-04   7.3770D-05  -1.7104D-04   5.4847D-04  -7.9320D-05  -5.3541D-04  
D  OCOTILLO  NHY  DER_EAST  -1.4170D-04  -1.6495D-03  -8.2519D-04   8.6278D-04   1.0827D-03   3.9771D-04  -3.8598D-04   1.3304D-04   3.0304D-04  
D  OCOTILLO  NHY  CHEB_0     3.6531D-10  -1.7793D-10  -1.1905D-10   1.2926D-11   1.0588D-10  -4.2372D-12  -7.0239D-11   8.0539D-12   2.2301D-12  
D  OCOTILLO  NHY  CHEB_1     2.0615D-11  -8.5771D-12  -5.5445D-12  -5.7967D-13   4.7561D-12   3.7934D-13  -2.8443D-12   1.0467D-12   5.5638D-13  
D  OCOTILLO  NHY  CHEB_2     3.6416D-12  -1.3928D-12  -8.5716D-13  -1.8508D-13   7.0579D-13   8.3800D-14  -4.0653D-13   2.3283D-13   8.1095D-14  
D  OCOTILLO  NHY  CHEB_3    -4.1071D-13   2.1795D-13   1.6365D-13  -1.3502D-14  -1.4692D-13  -1.6951D-15   8.7605D-14  -6.1081D-15  -1.7612D-14  
D  OCOTILLO  NHY  CHEB_4    -5.5067D-14   2.5980D-14   1.7205D-14  -1.6431D-15  -1.2810D-14   2.4864D-16   6.2322D-15  -4.6099D-15   1.1118D-15  
D  OCOTILLO  NHY  CHEB_5    -9.7806D-15   3.1817D-15   3.2613D-15   2.5166D-15  -1.8750D-15   8.5770D-17   1.8020D-16  -3.7958D-16  -9.0266D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  OHIGGINS  HYD  DER_NORT  -1.2258D-04   6.4115D-06   4.3239D-05   2.1263D-05   1.5413D-06   3.0379D-05   8.3019D-06   1.0749D-06  -1.1051D-06  
D  OHIGGINS  HYD  DER_EAST  -1.9194D-05   2.8883D-05   1.0903D-06  -3.3734D-06  -3.9993D-05  -1.8703D-06  -4.7343D-06  -2.7024D-06   3.1661D-07  
D  OHIGGINS  HYD  CHEB_0     7.5371D-09  -4.9337D-11   1.4002D-12  -1.7166D-12   1.8710D-11   2.1458D-11   5.7527D-12  -3.3665D-13   9.1519D-13  
D  OHIGGINS  HYD  CHEB_1     2.1367D-11  -1.0367D-11  -5.2177D-12  -1.1821D-12   5.7769D-13   4.5537D-13  -1.5143D-12   1.6996D-13  -2.7846D-14  
D  OHIGGINS  HYD  CHEB_2     8.5124D-13  -7.1248D-13  -3.0668D-13  -6.0644D-14   7.0848D-14   2.5056D-14  -3.2809D-13   2.7919D-14   5.5881D-15  
D  OHIGGINS  HYD  CHEB_3    -2.3850D-12   4.6185D-13   2.5274D-13   5.3383D-14  -2.3334D-14  -3.9559D-14   1.4123D-14  -5.9200D-15   3.3481D-15  
D  OHIGGINS  HYD  CHEB_4    -6.9227D-13  -6.6635D-14  -1.7212D-14  -3.4830D-15   3.9105D-15   6.3149D-15   8.0191D-15   1.8418D-15  -9.0553D-16  
D  OHIGGINS  HYD  CHEB_5    -1.0222D-13   1.2696D-15  -1.2996D-14  -2.4101D-15  -1.5840D-15  -2.2116D-15  -2.1924D-16  -1.0481D-15  -2.4567D-17  
#
D  OHIGGINS  NHY  DER_NORT  -1.0981D-03   2.6164D-04   2.1497D-04   8.6850D-05   1.3919D-05  -3.0558D-05   2.6503D-04   7.6719D-05   6.9932D-05  
D  OHIGGINS  NHY  DER_EAST  -6.7460D-04   5.2129D-04  -2.4152D-05   1.3882D-04   1.3520D-04   1.9969D-04   1.2000D-04   3.6842D-05   8.2263D-05  
D  OHIGGINS  NHY  CHEB_0     1.5930D-10   4.8647D-11   1.7245D-11   3.3433D-12  -2.9851D-12  -5.3747D-12   1.0895D-11  -2.6544D-12  -1.1001D-12  
D  OHIGGINS  NHY  CHEB_1     9.6596D-12   3.0251D-12   9.2159D-13   9.6927D-14  -2.8631D-13  -4.3068D-13   4.8920D-13  -1.1458D-13  -5.2328D-14  
D  OHIGGINS  NHY  CHEB_2     1.7557D-12   5.4918D-13   1.5866D-13   1.4705D-15  -6.5881D-14  -9.3355D-14   7.0113D-14  -1.6857D-14  -8.9545D-15  
D  OHIGGINS  NHY  CHEB_3    -1.6607D-13  -5.0798D-14  -2.0158D-14  -8.9540D-15  -7.9662D-16   1.3504D-15  -1.5845D-14   3.5620D-15   1.9733D-15  
D  OHIGGINS  NHY  CHEB_4    -2.2035D-14  -6.1332D-15  -2.9495D-15  -1.1765D-15   1.9987D-16   6.7045D-16  -2.6530D-15  -2.6102D-16   3.9323D-16  
D  OHIGGINS  NHY  CHEB_5    -5.2852D-15  -1.2206D-15  -2.4796D-17   7.1297D-16   4.0781D-16   1.0727D-15   6.3407D-16   2.8416D-16   1.6720D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ONSALA60  HYD  DER_NORT   1.2693D-04   7.2400D-05  -4.1604D-06   2.4097D-05  -3.2122D-05   1.2159D-05  -7.0055D-06  -1.5829D-06  -8.1258D-07  
D  ONSALA60  HYD  DER_EAST  -1.7527D-05  -1.8861D-05  -2.5909D-05   9.0231D-06  -1.9150D-05  -1.2282D-05  -7.2963D-06   2.5670D-06  -8.1137D-08  
D  ONSALA60  HYD  CHEB_0     7.6677D-09  -6.9352D-12   1.9154D-11  -1.5850D-11  -1.7977D-12   2.0372D-12  -8.9703D-12   5.4852D-13  -4.2934D-14  
D  ONSALA60  HYD  CHEB_1    -3.1067D-12   1.3913D-11   6.6842D-12  -5.7586D-14   4.9047D-13  -5.8482D-13   6.9887D-13  -6.3771D-14  -3.2665D-13  
D  ONSALA60  HYD  CHEB_2    -2.9286D-12   1.6782D-12   9.6392D-13   1.3109D-14   1.5967D-13  -1.4270D-13   1.2088D-13  -1.2429D-14  -5.7858D-14  
D  ONSALA60  HYD  CHEB_3    -1.7803D-12  -4.3957D-13  -1.8919D-13   1.2761D-14  -2.2676D-15  -3.2467D-15  -1.3063D-14   1.2044D-15   4.4038D-15  
D  ONSALA60  HYD  CHEB_4    -7.0940D-13   3.6652D-14   1.0926D-15  -1.5144D-15  -2.9342D-15   4.0293D-15   9.0964D-17  -1.0767D-15  -6.5193D-16  
D  ONSALA60  HYD  CHEB_5    -1.0819D-13   1.6228D-15   2.9552D-15  -6.5712D-16  -2.0884D-15  -1.6704D-15   6.2304D-16   2.9676D-16   7.8856D-16  
#
D  ONSALA60  NHY  DER_NORT   3.5354D-04   2.7073D-04   4.3489D-04   1.2025D-04  -4.1071D-04  -1.0382D-04   1.2118D-04   8.2039D-05  -2.3574D-04  
D  ONSALA60  NHY  DER_EAST   1.5840D-06  -4.7013D-04   5.4655D-05   3.1896D-04  -3.2774D-04   1.4316D-04  -2.1792D-04   1.1902D-04   3.3172D-04  
D  ONSALA60  NHY  CHEB_0     3.7061D-10  -1.3438D-10  -9.7240D-11   3.3125D-11   4.4292D-12   4.3401D-13  -1.1742D-12   7.7678D-13   1.6454D-12  
D  ONSALA60  NHY  CHEB_1     2.1537D-11  -6.9364D-12  -5.5127D-12   1.6751D-12   1.9916D-13   2.5519D-13  -2.1597D-15  -8.4315D-14   2.5677D-13  
D  ONSALA60  NHY  CHEB_2     3.8819D-12  -1.1834D-12  -9.7348D-13   2.8668D-13   3.4738D-14   4.8812D-14   2.7668D-15  -2.5452D-14   3.8475D-14  
D  ONSALA60  NHY  CHEB_3    -3.8138D-13   1.4246D-13   9.8689D-14  -4.0891D-14   6.2940D-15   3.2709D-15  -1.4845D-15  -6.2605D-15  -5.2035D-15  
D  ONSALA60  NHY  CHEB_4    -6.4480D-14   2.8321D-14   1.6783D-14  -3.1130D-15  -1.5030D-15  -1.0921D-15  -4.0266D-15   3.6823D-15   1.5151D-15  
D  ONSALA60  NHY  CHEB_5    -3.6250D-15  -4.2896D-15  -4.4547D-16  -2.8860D-15   2.8866D-15   2.0912D-15   1.1234D-15  -3.5002D-15  -7.6345D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ONSALA85  HYD  DER_NORT   1.2691D-04   7.2401D-05  -4.1645D-06   2.4104D-05  -3.2109D-05   1.2163D-05  -6.9956D-06  -1.5871D-06  -8.1508D-07  
D  ONSALA85  HYD  DER_EAST  -1.7506D-05  -1.8869D-05  -2.5924D-05   9.0463D-06  -1.9158D-05  -1.2279D-05  -7.3145D-06   2.5848D-06  -6.1221D-08  
D  ONSALA85  HYD  CHEB_0     7.6685D-09  -6.9292D-12   1.9173D-11  -1.5847D-11  -1.7995D-12   2.0470D-12  -8.9768D-12   5.6052D-13  -3.9358D-14  
D  ONSALA85  HYD  CHEB_1    -3.1273D-12   1.3908D-11   6.6837D-12  -5.7335D-14   4.9058D-13  -5.8459D-13   6.9801D-13  -6.0797D-14  -3.2617D-13  
D  ONSALA85  HYD  CHEB_2    -2.9308D-12   1.6778D-12   9.6352D-13   1.3416D-14   1.5949D-13  -1.4273D-13   1.2067D-13  -1.2493D-14  -5.7707D-14  
D  ONSALA85  HYD  CHEB_3    -1.7803D-12  -4.3958D-13  -1.8907D-13   1.2815D-14  -2.3419D-15  -3.2130D-15  -1.3078D-14   1.2649D-15   4.4012D-15  
D  ONSALA85  HYD  CHEB_4    -7.0947D-13   3.6767D-14   1.1598D-15  -1.5305D-15  -2.9702D-15   4.0015D-15   1.3958D-16  -1.1197D-15  -6.2829D-16  
D  ONSALA85  HYD  CHEB_5    -1.0823D-13   1.5174D-15   2.9288D-15  -6.5497D-16  -2.0178D-15  -1.6439D-15   6.1189D-16   3.4625D-16   7.7065D-16  
#
D  ONSALA85  NHY  DER_NORT   3.5512D-04   2.7140D-04   4.3545D-04   1.2010D-04  -4.0985D-04  -1.0376D-04   1.2191D-04   8.1728D-05  -2.3609D-04  
D  ONSALA85  NHY  DER_EAST  -4.3631D-06  -4.6988D-04   5.6380D-05   3.1918D-04  -3.2758D-04   1.4381D-04  -2.1867D-04   1.1663D-04   3.3045D-04  
D  ONSALA85  NHY  CHEB_0     3.7072D-10  -1.3435D-10  -9.7272D-11   3.3099D-11   4.4396D-12   4.3483D-13  -1.1610D-12   7.5477D-13   1.6088D-12  
D  ONSALA85  NHY  CHEB_1     2.1543D-11  -6.9320D-12  -5.5171D-12   1.6730D-12   1.9830D-13   2.5592D-13   1.9208D-16  -8.2621D-14   2.5737D-13  
D  ONSALA85  NHY  CHEB_2     3.8834D-12  -1.1831D-12  -9.7442D-13   2.8645D-13   3.4680D-14   4.9297D-14   3.0994D-15  -2.4867D-14   3.9101D-14  
D  ONSALA85  NHY  CHEB_3    -3.8157D-13   1.4248D-13   9.8844D-14  -4.0728D-14   6.3401D-15   3.3452D-15  -1.5170D-15  -6.2866D-15  -5.1899D-15  
D  ONSALA85  NHY  CHEB_4    -6.4358D-14   2.8079D-14   1.6708D-14  -3.0950D-15  -1.4024D-15  -1.0829D-15  -4.1009D-15   3.5750D-15   1.5216D-15  
D  ONSALA85  NHY  CHEB_5    -3.6956D-15  -4.1764D-15  -4.3334D-16  -2.8883D-15   2.8803D-15   2.0739D-15   1.1484D-15  -3.4942D-15  -7.9689D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  OV-VLBA   HYD  DER_NORT   6.4923D-05   1.5815D-05   4.3243D-07  -1.1149D-05  -1.5070D-05  -5.1423D-06  -1.0072D-05  -2.7411D-06  -4.7866D-06  
D  OV-VLBA   HYD  DER_EAST  -1.1796D-04  -4.6305D-05  -2.6348D-05   3.2909D-06   1.6520D-05  -1.1544D-05   3.7308D-06  -9.7591D-06   1.9911D-05  
D  OV-VLBA   HYD  CHEB_0     6.7236D-09   3.0036D-11   1.3400D-12   7.1779D-12   1.6858D-12   2.3155D-13  -2.1917D-12   1.1211D-11   1.6428D-13  
D  OV-VLBA   HYD  CHEB_1     4.7933D-13   1.2063D-11   5.5725D-12  -1.6331D-12  -1.6978D-12   1.1885D-12   8.5455D-13   1.3112D-12   6.8300D-14  
D  OV-VLBA   HYD  CHEB_2    -2.0727D-12   1.8354D-12   8.6069D-13  -2.0984D-13  -2.0316D-13   2.8270D-13   1.8285D-13   2.4379D-13   1.2691D-14  
D  OV-VLBA   HYD  CHEB_3    -1.5725D-12  -2.4966D-13  -1.4237D-13   4.2687D-14   4.6802D-14  -4.5123D-15  -2.4457D-14  -1.4922D-14  -3.6664D-15  
D  OV-VLBA   HYD  CHEB_4    -5.7453D-13   3.0191D-15   2.6528D-15  -7.4667D-15   3.4733D-17  -1.4212D-14  -5.3499D-15  -2.7468D-15  -1.0201D-15  
D  OV-VLBA   HYD  CHEB_5    -1.2873D-13  -4.9615D-15   4.6633D-15   2.9556D-15   3.7195D-15   1.5011D-15   4.1909D-15  -6.4675D-17  -1.2121D-15  
#
D  OV-VLBA   NHY  DER_NORT   4.1436D-05  -6.6286D-05   4.8890D-05  -3.2727D-04  -1.5251D-04  -7.1911D-05  -8.7156D-05  -9.5107D-04   3.7917D-04  
D  OV-VLBA   NHY  DER_EAST  -3.8960D-03  -3.5332D-04  -9.1455D-04   3.8287D-04   5.6591D-04  -1.3172D-04   1.5530D-04   1.2258D-03   5.3069D-04  
D  OV-VLBA   NHY  CHEB_0     2.4354D-10  -8.8356D-11  -3.0505D-11   1.3201D-11   2.7931D-11  -2.2934D-11  -3.0280D-11  -3.7932D-12  -1.6044D-11  
D  OV-VLBA   NHY  CHEB_1     1.3456D-11  -3.2136D-12  -1.1807D-12  -7.1230D-14   1.3074D-12  -1.4557D-12  -1.6700D-12   9.8971D-13  -4.2300D-13  
D  OV-VLBA   NHY  CHEB_2     2.3948D-12  -5.0117D-13  -1.7820D-13  -5.7072D-14   2.3295D-13  -2.5503D-13  -3.0095D-13   2.7074D-13  -4.8867D-14  
D  OV-VLBA   NHY  CHEB_3    -2.6126D-13   8.7266D-14   3.1683D-14  -1.7151D-14  -2.2476D-14   3.1568D-14   3.0303D-14   1.8348D-14   2.1132D-14  
D  OV-VLBA   NHY  CHEB_4    -3.0448D-14   7.9596D-15   1.4086D-15  -3.6314D-16  -3.7377D-15   3.6368D-15   6.1786D-15  -3.3522D-16   2.1970D-15  
D  OV-VLBA   NHY  CHEB_5    -7.2441D-15   2.2628D-15  -3.1637D-16  -2.5178D-16   7.4512D-16   1.1097D-15  -2.6050D-16  -1.5258D-15   6.8016D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  OVRO_130  HYD  DER_NORT   6.5412D-05   1.5896D-05   4.9577D-07  -1.1141D-05  -1.5086D-05  -5.1442D-06  -1.0107D-05  -2.7382D-06  -4.8634D-06  
D  OVRO_130  HYD  DER_EAST  -1.1740D-04  -4.6275D-05  -2.6299D-05   3.2931D-06   1.6599D-05  -1.1480D-05   3.8003D-06  -9.5584D-06   1.9781D-05  
D  OVRO_130  HYD  CHEB_0     6.7203D-09   2.9905D-11   1.3372D-12   7.1754D-12   1.6953D-12   2.1987D-13  -2.2105D-12   1.1185D-11   1.1130D-13  
D  OVRO_130  HYD  CHEB_1     5.2905D-13   1.2034D-11   5.5665D-12  -1.6319D-12  -1.6919D-12   1.1836D-12   8.5453D-13   1.3093D-12   6.7651D-14  
D  OVRO_130  HYD  CHEB_2    -2.0559D-12   1.8359D-12   8.6095D-13  -2.1034D-13  -2.0374D-13   2.8392D-13   1.8272D-13   2.4271D-13   1.2758D-14  
D  OVRO_130  HYD  CHEB_3    -1.5736D-12  -2.5011D-13  -1.4231D-13   4.2578D-14   4.6971D-14  -4.9653D-15  -2.4551D-14  -1.5160D-14  -3.3174D-15  
D  OVRO_130  HYD  CHEB_4    -5.7594D-13   2.5393D-15   2.2098D-15  -7.3522D-15   2.3631D-16  -1.4196D-14  -5.1644D-15  -2.7378D-15  -1.0102D-15  
D  OVRO_130  HYD  CHEB_5    -1.2696D-13  -4.4678D-15   5.0942D-15   2.8009D-15   3.2303D-15   1.6372D-15   4.1422D-15   1.4549D-18  -1.2638D-15  
#
D  OVRO_130  NHY  DER_NORT   6.4921D-05  -6.7471D-05   5.2533D-05  -3.2744D-04  -1.5402D-04  -7.0490D-05  -8.7108D-05  -9.5827D-04   3.8334D-04  
D  OVRO_130  NHY  DER_EAST  -3.8684D-03  -3.6909D-04  -9.1422D-04   3.8347D-04   5.6423D-04  -1.2526D-04   1.5773D-04   1.2155D-03   5.1748D-04  
D  OVRO_130  NHY  CHEB_0     2.4346D-10  -8.8370D-11  -3.0406D-11   1.3199D-11   2.7873D-11  -2.2918D-11  -3.0265D-11  -3.9184D-12  -1.6121D-11  
D  OVRO_130  NHY  CHEB_1     1.3419D-11  -3.2066D-12  -1.1721D-12  -7.0492D-14   1.3006D-12  -1.4516D-12  -1.6617D-12   9.9873D-13  -4.2629D-13  
D  OVRO_130  NHY  CHEB_2     2.3881D-12  -4.9899D-13  -1.7761D-13  -5.6940D-14   2.3187D-13  -2.5472D-13  -2.9934D-13   2.7136D-13  -4.9157D-14  
D  OVRO_130  NHY  CHEB_3    -2.6020D-13   8.7243D-14   3.1088D-14  -1.6876D-14  -2.2000D-14   3.1338D-14   3.0155D-14   1.7938D-14   2.1517D-14  
D  OVRO_130  NHY  CHEB_4    -3.0568D-14   7.7406D-15   1.2103D-15  -4.5083D-16  -3.5106D-15   3.7342D-15   5.9152D-15  -7.4362D-16   2.1654D-15  
D  OVRO_130  NHY  CHEB_5    -6.9766D-15   2.2091D-15  -1.9070D-16  -1.7943D-16   6.2298D-16   1.0733D-15  -8.8653D-17  -1.2860D-15   6.8153D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  OVR_7853  HYD  DER_NORT   6.6340D-05   1.5730D-05   6.4551D-07  -1.1076D-05  -1.4950D-05  -5.2103D-06  -1.0202D-05  -2.6844D-06  -5.3621D-06  
D  OVR_7853  HYD  DER_EAST  -1.2010D-04  -4.5870D-05  -2.6484D-05   3.3122D-06   1.6645D-05  -1.1260D-05   4.0359D-06  -9.3121D-06   2.0048D-05  
D  OVR_7853  HYD  CHEB_0     6.7397D-09   3.0711D-11   1.6554D-12   7.1713D-12   1.6334D-12   2.9695D-13  -2.2111D-12   1.1453D-11  -2.8068D-14  
D  OVR_7853  HYD  CHEB_1     2.2951D-13   1.2039D-11   5.5724D-12  -1.6295D-12  -1.6848D-12   1.1808D-12   8.5685D-13   1.3210D-12   6.5094D-14  
D  OVR_7853  HYD  CHEB_2    -2.0879D-12   1.8438D-12   8.6436D-13  -2.1127D-13  -2.0757D-13   2.8692D-13   1.8220D-13   2.4414D-13   1.2170D-14  
D  OVR_7853  HYD  CHEB_3    -1.5726D-12  -2.5285D-13  -1.4474D-13   4.3010D-14   4.9644D-14  -6.0068D-15  -2.4489D-14  -1.7438D-14  -2.3946D-15  
D  OVR_7853  HYD  CHEB_4    -5.7954D-13   1.3977D-15   2.7581D-15  -7.4973D-15  -7.5055D-16  -1.4459D-14  -4.8743D-15  -1.8805D-15  -1.3364D-15  
D  OVR_7853  HYD  CHEB_5    -1.2603D-13  -2.5845D-15   5.0248D-15   2.8754D-15   3.5103D-15   2.1364D-15   4.1544D-15  -6.1996D-16  -1.0575D-15  
#
D  OVR_7853  NHY  DER_NORT   1.4583D-04  -8.9241D-05   6.3196D-05  -3.2494D-04  -1.5651D-04  -6.4871D-05  -8.8629D-05  -9.8743D-04   3.7641D-04  
D  OVR_7853  NHY  DER_EAST  -3.8470D-03  -3.8113D-04  -9.2941D-04   3.8536D-04   5.6424D-04  -1.0965D-04   1.5828D-04   1.2071D-03   5.1069D-04  
D  OVR_7853  NHY  CHEB_0     2.4629D-10  -8.9178D-11  -3.0461D-11   1.3202D-11   2.7980D-11  -2.3115D-11  -3.0566D-11  -3.9122D-12  -1.6506D-11  
D  OVR_7853  NHY  CHEB_1     1.3453D-11  -3.1943D-12  -1.1595D-12  -7.9055D-14   1.2912D-12  -1.4556D-12  -1.6593D-12   1.0461D-12  -4.2969D-13  
D  OVR_7853  NHY  CHEB_2     2.3913D-12  -4.9430D-13  -1.7587D-13  -5.7180D-14   2.3016D-13  -2.5565D-13  -2.9725D-13   2.7993D-13  -4.7564D-14  
D  OVR_7853  NHY  CHEB_3    -2.6252D-13   8.6499D-14   2.9075D-14  -1.6929D-14  -2.0879D-14   3.1384D-14   2.9458D-14   1.3256D-14   2.2067D-14  
D  OVR_7853  NHY  CHEB_4    -2.9815D-14   7.5210D-15   1.5442D-15   3.8202D-16  -3.1506D-15   3.7405D-15   5.9333D-15   1.5799D-16   2.4669D-15  
D  OVR_7853  NHY  CHEB_5    -8.0615D-15   2.0070D-15  -6.3066D-16  -6.2105D-16   6.7990D-16   1.2325D-15  -3.6928D-16  -2.4832D-15   4.9998D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PARKES    HYD  DER_NORT  -1.0606D-04   1.9425D-05   1.3211D-05  -1.7472D-06   4.8078D-06   2.2149D-06   6.2030D-06   1.5613D-06   1.0682D-07  
D  PARKES    HYD  DER_EAST   1.4263D-05   1.9873D-06   6.7601D-06  -1.1526D-06  -8.5041D-06   6.9191D-06   1.1450D-05  -1.0525D-06  -2.9030D-07  
D  PARKES    HYD  CHEB_0     7.4023D-09  -3.5599D-11  -1.3553D-11  -8.7714D-12  -1.1537D-13   7.4391D-12  -5.3825D-12  -4.8775D-12   4.8929D-12  
D  PARKES    HYD  CHEB_1    -1.4651D-11  -9.2954D-12  -3.3151D-12   2.1665D-12  -1.0813D-12  -4.7916D-13  -3.6865D-13  -4.8048D-13   4.6759D-13  
D  PARKES    HYD  CHEB_2    -4.5646D-12  -1.5928D-12  -5.7728D-13   3.7117D-13  -1.1475D-13  -1.2132D-13  -6.3190D-14  -9.4155D-14   9.6683D-14  
D  PARKES    HYD  CHEB_3    -1.4473D-12   1.9225D-13   7.8612D-14  -4.0986D-14   3.4554D-14  -6.9239D-15   1.1184D-14   4.9416D-15  -6.3610D-15  
D  PARKES    HYD  CHEB_4    -6.8470D-13   1.5024D-14   9.8533D-15  -2.1452D-16   3.1515D-17   4.3790D-15   1.7773D-15   1.7122D-15   2.4203D-15  
D  PARKES    HYD  CHEB_5    -1.0196D-13   2.2619D-15  -9.5330D-18  -3.3583D-16  -3.8155D-16  -1.3226D-15  -1.0903D-15  -6.1520D-16  -2.9697D-15  
#
D  PARKES    NHY  DER_NORT  -4.6578D-04  -8.1816D-04   3.2807D-04   4.7468D-04   2.0876D-04   2.1627D-04   1.2901D-04  -1.7142D-04  -1.9313D-05  
D  PARKES    NHY  DER_EAST   8.0784D-04   6.4246D-04  -2.5092D-04   5.1992D-05   8.9960D-06  -2.4306D-04   8.7902D-05   1.6330D-04  -1.0163D-04  
D  PARKES    NHY  CHEB_0     3.6043D-10   1.2224D-10   9.6355D-11   1.4772D-11   2.8425D-11  -3.2191D-12   1.3638D-11   4.1972D-12   2.3945D-13  
D  PARKES    NHY  CHEB_1     2.1131D-11   5.5259D-12   5.3918D-12   6.2452D-13   1.6009D-12  -1.5768D-13   9.6307D-13   8.2331D-14   3.8553D-13  
D  PARKES    NHY  CHEB_2     3.8845D-12   9.0335D-13   9.5167D-13   1.0590D-13   2.8336D-13  -1.4216D-14   1.9463D-13   1.5772D-14   8.3440D-14  
D  PARKES    NHY  CHEB_3    -3.5544D-13  -1.4734D-13  -1.0160D-13  -2.1088D-14  -2.7765D-14   5.3321D-15  -8.5902D-15  -7.9461D-15  -4.0504D-15  
D  PARKES    NHY  CHEB_4    -5.8663D-14  -2.1929D-14  -2.1847D-14   1.8707D-15  -8.7896D-15   5.7548D-15  -1.4744D-15  -1.6812D-15   1.8206D-15  
D  PARKES    NHY  CHEB_5    -8.5587D-15  -1.0455D-15   2.6200D-16  -2.6530D-15   5.5218D-16  -1.5142D-15  -6.8353D-16  -1.8875D-15  -2.1314D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PBLOSSOM  HYD  DER_NORT   5.9180D-05   1.7023D-05   7.8147D-06  -1.6067D-05  -1.4458D-05   8.3882D-07  -4.4857D-06   1.2894D-06  -1.4683D-06  
D  PBLOSSOM  HYD  DER_EAST  -4.5838D-06  -2.4523D-05  -1.7370D-05  -2.4545D-06   1.2034D-05  -1.3855D-05   4.0180D-06   1.7713D-06  -1.6112D-07  
D  PBLOSSOM  HYD  CHEB_0     6.9409D-09   2.6276D-11   3.6920D-12   7.4862D-12   1.2856D-12  -2.8036D-13  -2.7194D-12   3.3712D-12   2.6943D-12  
D  PBLOSSOM  HYD  CHEB_1    -9.6546D-12   1.0425D-11   5.4991D-12  -1.1992D-12  -9.9116D-13   1.2039D-12   1.2790D-12   7.4279D-13   2.7451D-13  
D  PBLOSSOM  HYD  CHEB_2    -3.4849D-12   1.8007D-12   9.4571D-13  -1.7699D-13  -1.8864D-13   3.3040D-13   2.0090D-13   1.1599D-13   5.2877D-14  
D  PBLOSSOM  HYD  CHEB_3    -1.4928D-12  -2.9724D-13  -1.6443D-13   3.8629D-14   6.5305D-14  -3.4511D-14  -2.4128D-14  -1.1958D-14  -8.8502D-15  
D  PBLOSSOM  HYD  CHEB_4    -6.5057D-13  -4.7827D-15  -8.7008D-15  -1.9837D-15  -1.0248D-14  -3.9561D-15  -1.3111D-15   2.8080D-15   3.0709D-16  
D  PBLOSSOM  HYD  CHEB_5    -6.9641D-14   1.0200D-14   1.2200D-14  -3.8536D-15  -7.0812D-15   6.5457D-15  -1.2795D-15  -1.3927D-15  -5.0425D-16  
#
D  PBLOSSOM  NHY  DER_NORT  -1.0640D-03  -5.3284D-04  -6.6214D-04  -1.0287D-04   7.3367D-04   4.8206D-04  -4.7658D-04   4.2209D-04   3.7856D-04  
D  PBLOSSOM  NHY  DER_EAST   6.9621D-04  -1.1043D-03  -4.2589D-04   8.8947D-05   6.8275D-04   4.3678D-04  -7.8064D-04  -1.6454D-05  -9.4580D-05  
D  PBLOSSOM  NHY  CHEB_0     2.4226D-10  -8.9332D-11  -4.7679D-11   4.4782D-12   4.6142D-11  -2.0358D-11  -3.7058D-11  -4.2213D-12  -4.2422D-12  
D  PBLOSSOM  NHY  CHEB_1     1.3920D-11  -4.8858D-12  -2.3384D-12  -1.7922D-14   2.2059D-12  -9.5617D-13  -1.6812D-12   1.6962D-13  -2.4751D-13  
D  PBLOSSOM  NHY  CHEB_2     2.6526D-12  -9.4667D-13  -4.5369D-13  -3.0554D-15   4.2467D-13  -1.6155D-13  -3.1243D-13   2.8832D-14  -5.1146D-14  
D  PBLOSSOM  NHY  CHEB_3    -1.9766D-13   6.3309D-14   3.1319D-14   3.2889D-16  -2.8522D-14   1.9701D-14   2.7217D-14  -6.7208D-16   3.7221D-15  
D  PBLOSSOM  NHY  CHEB_4    -3.5535D-14   1.1067D-14   5.0652D-15  -1.1916D-15  -4.7573D-15   2.1193D-15   5.4108D-15  -1.9140D-15   2.4319D-15  
D  PBLOSSOM  NHY  CHEB_5    -7.4553D-15   5.8161D-15   2.5258D-15  -1.0344D-15  -3.4586D-15   6.9445D-16   2.7915D-15   3.2483D-15  -2.0064D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PENTICTN  HYD  DER_NORT   1.1074D-04   3.9796D-05   2.9273D-06   4.9770D-06  -1.5959D-05  -1.8469D-05  -2.6370D-05  -9.5786D-07   1.1266D-06  
D  PENTICTN  HYD  DER_EAST   5.9030D-06  -1.5487D-05   1.3518D-05   1.1502D-05  -1.4967D-05  -4.2618D-06  -3.9374D-05  -9.1568D-06   7.8227D-06  
D  PENTICTN  HYD  CHEB_0     7.2618D-09   2.3089D-11   3.2851D-12   6.9988D-12   2.6400D-12   8.6148D-12   7.4492D-12   1.0770D-11   3.5810D-13  
D  PENTICTN  HYD  CHEB_1     1.7203D-12   1.3951D-11   5.5333D-12  -1.3406D-12  -4.1294D-12  -4.5613D-14  -8.8359D-13   1.2687D-12   4.6043D-14  
D  PENTICTN  HYD  CHEB_2    -1.6580D-12   2.2368D-12   9.4922D-13  -9.9242D-14  -6.0356D-13   1.9298D-14  -1.8719D-13   2.4358D-13   1.4661D-16  
D  PENTICTN  HYD  CHEB_3    -1.6954D-12  -3.0613D-13  -1.2239D-13   5.0699D-14   1.1250D-13   7.4862D-15   1.5923D-14  -1.3115D-14  -6.3869D-15  
D  PENTICTN  HYD  CHEB_4    -6.8438D-13   4.6470D-15  -5.8011D-15  -2.1578D-15  -5.6272D-15  -5.2888D-15   4.1292D-15   8.0610D-16  -2.6427D-16  
D  PENTICTN  HYD  CHEB_5    -1.0463D-13  -5.8865D-15   1.2428D-15  -2.8438D-15  -2.2335D-15  -1.3509D-15  -6.1125D-15  -9.6212D-16   1.7163D-16  
#
D  PENTICTN  NHY  DER_NORT  -2.8941D-04   5.5377D-04   2.8759D-04  -1.6637D-04   6.1699D-06   7.3733D-05  -2.2822D-05  -1.3724D-04   6.3800D-05  
D  PENTICTN  NHY  DER_EAST   2.0916D-05  -9.8079D-04  -1.0682D-04  -3.9292D-04   1.8073D-04   8.8009D-05  -1.1493D-04  -1.6857D-04   2.3533D-05  
D  PENTICTN  NHY  CHEB_0     3.0948D-10  -1.1016D-10  -4.2550D-11   1.9333D-11   2.2707D-11  -2.7071D-11  -3.6070D-12  -1.2812D-12  -3.6667D-12  
D  PENTICTN  NHY  CHEB_1     1.8592D-11  -6.1294D-12  -2.3875D-12   6.9500D-13   1.1991D-12  -1.5492D-12  -1.6153D-13   2.0858D-13  -3.5370D-13  
D  PENTICTN  NHY  CHEB_2     3.3983D-12  -1.0946D-12  -4.1456D-13   9.6714D-14   2.0172D-13  -2.7184D-13  -1.5813D-14   6.7138D-14  -7.7979D-14  
D  PENTICTN  NHY  CHEB_3    -3.2554D-13   1.1641D-13   5.2477D-14  -2.5607D-14  -2.9882D-14   3.0927D-14   8.8580D-15   7.3253D-15   6.7703D-16  
D  PENTICTN  NHY  CHEB_4    -5.0684D-14   1.7038D-14   7.9118D-15  -8.9290D-16  -3.6649D-15   3.5773D-15   2.0126D-15   1.4244D-15   9.7064D-16  
D  PENTICTN  NHY  CHEB_5    -7.6610D-15   1.3509D-15   2.7703D-16  -8.3079D-16  -1.1521D-16   6.9077D-16  -9.4089D-16  -1.7591D-15   1.7922D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PICOVEL   HYD  DER_NORT   9.6204D-05   9.1595D-07   1.0416D-05  -3.8704D-07   8.1223D-06  -1.5859D-05   1.6488D-05  -3.2749D-06  -4.1370D-06  
D  PICOVEL   HYD  DER_EAST   8.4993D-06  -2.3851D-05  -1.4909D-05   1.4326D-05  -1.8058D-05  -8.2421D-06   1.7133D-05   7.1968D-07  -1.9297D-06  
D  PICOVEL   HYD  CHEB_0     5.5333D-09  -9.2283D-12  -2.2558D-11   1.8450D-11   7.6137D-12   1.3545D-12   1.4703D-13   1.3168D-13   1.5005D-12  
D  PICOVEL   HYD  CHEB_1     2.1400D-11   7.5354D-12   5.9113D-12  -1.7122D-12  -1.5664D-12   7.8361D-13  -8.3691D-13  -2.2062D-14  -2.9466D-13  
D  PICOVEL   HYD  CHEB_2     2.0901D-12   1.1182D-12   1.0624D-12  -2.8603D-13  -2.9644D-13   1.7246D-13  -1.7052D-13   4.0823D-14  -2.7823D-14  
D  PICOVEL   HYD  CHEB_3    -1.8214D-12  -1.6536D-13  -9.5295D-14   2.0531D-14   3.1488D-14   2.3462D-15   4.6152D-16  -7.1330D-15   5.1103D-16  
D  PICOVEL   HYD  CHEB_4    -5.0508D-13   1.1581D-14  -4.7954D-15  -4.6780D-15   8.1610D-15  -5.0759D-15   1.9204D-15  -4.3439D-16   4.3144D-16  
D  PICOVEL   HYD  CHEB_5    -7.6867D-14  -4.2997D-15  -1.6766D-15   2.6613D-15  -2.6449D-15   7.2428D-16  -5.9697D-17   1.0600D-15   9.0284D-16  
#
D  PICOVEL   NHY  DER_NORT  -3.8253D-04   9.1444D-04  -2.6253D-04   2.5832D-04   5.2053D-04  -1.7875D-04  -2.0783D-04  -3.2268D-04  -6.0284D-04  
D  PICOVEL   NHY  DER_EAST   3.5479D-04  -1.1824D-03  -5.2370D-04   6.0251D-04   2.6459D-04   5.8699D-04  -1.8949D-04   6.2307D-05   4.5144D-04  
D  PICOVEL   NHY  CHEB_0     1.1966D-10  -2.9893D-11  -4.0664D-11  -1.3883D-11  -3.9523D-12  -5.5545D-12   1.3531D-11   1.2005D-12   3.1874D-12  
D  PICOVEL   NHY  CHEB_1     7.7444D-12  -1.6670D-12  -2.2484D-12  -9.3390D-13  -6.0480D-13  -5.5693D-13   8.6463D-13  -2.8791D-13  -1.3786D-13  
D  PICOVEL   NHY  CHEB_2     1.5774D-12  -4.0500D-13  -4.7293D-13  -1.5269D-13  -7.6967D-14  -1.0749D-13   1.3913D-13  -9.9534D-15   7.3913D-15  
D  PICOVEL   NHY  CHEB_3    -6.8661D-14  -7.1972D-15   1.7140D-14   1.9884D-14   1.6753D-14   4.0366D-15  -1.9342D-14   1.5679D-14   1.2013D-14  
D  PICOVEL   NHY  CHEB_4    -1.8891D-14   5.7811D-15   6.3020D-15   3.9707D-16  -1.4783D-15  -1.3043D-16  -8.3760D-16  -2.8129D-15  -2.0615D-15  
D  PICOVEL   NHY  CHEB_5    -4.3302D-15   2.0035D-15   2.1410D-15  -4.8402D-16  -1.1943D-15   2.5829D-16  -1.4808D-17  -8.3918D-16  -5.9371D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PIETOWN   HYD  DER_NORT   7.9677D-05   4.5982D-05   4.3680D-06  -3.0097D-05  -2.1932D-05  -2.9403D-06   1.2201D-05  -8.6734D-07   1.3819D-06  
D  PIETOWN   HYD  DER_EAST   1.0218D-05  -5.6189D-06   1.1858D-06  -6.7613D-06  -1.9360D-06   1.7232D-05   2.7716D-06   2.6589D-06  -7.5820D-07  
D  PIETOWN   HYD  CHEB_0     5.8527D-09  -1.0703D-11  -1.1689D-11   4.4061D-12   3.6635D-12  -3.7850D-12  -2.6110D-12   2.4733D-12   1.5220D-12  
D  PIETOWN   HYD  CHEB_1     1.2009D-11   9.4863D-12   5.1604D-12  -8.1900D-13  -1.0414D-12   1.0048D-12   6.8835D-13   6.1943D-13   1.5510D-13  
D  PIETOWN   HYD  CHEB_2     3.8652D-13   1.6681D-12   8.7426D-13  -1.6278D-13  -1.6154D-13   2.6238D-13   1.2057D-13   1.0732D-13   3.5421D-14  
D  PIETOWN   HYD  CHEB_3    -1.6526D-12  -1.6855D-13  -1.0062D-13   1.9411D-14   4.4025D-14   9.0441D-15  -2.0018D-14  -1.0783D-14  -1.1864D-15  
D  PIETOWN   HYD  CHEB_4    -5.7488D-13  -2.2852D-14  -8.1919D-15   1.1407D-14   7.5621D-15  -6.0741D-15  -4.4060D-15   2.7108D-16  -1.4500D-16  
D  PIETOWN   HYD  CHEB_5    -7.5103D-14   9.5404D-15  -1.1056D-15  -5.6864D-15  -1.8992D-15  -1.1582D-15   5.6200D-16   2.4701D-15  -2.6680D-15  
#
D  PIETOWN   NHY  DER_NORT   2.9066D-04  -1.3861D-03  -4.2677D-04   4.3471D-04   5.6412D-04  -1.9163D-05   4.0080D-04  -4.1674D-04  -4.0999D-04  
D  PIETOWN   NHY  DER_EAST   6.6511D-04  -6.9574D-04   3.7202D-04   4.1320D-04  -3.4207D-04  -9.9780D-05   3.7861D-04  -7.2274D-05  -3.3109D-04  
D  PIETOWN   NHY  CHEB_0     2.1468D-10  -1.4714D-10  -6.9949D-11   2.1089D-11   7.1558D-11   2.3162D-11  -3.5964D-11  -8.9781D-12  -7.5078D-12  
D  PIETOWN   NHY  CHEB_1     1.3850D-11  -8.5242D-12  -4.1566D-12   1.0151D-12   4.1350D-12   1.3795D-12  -2.0408D-12  -2.3519D-13  -3.4267D-13  
D  PIETOWN   NHY  CHEB_2     2.6232D-12  -1.5080D-12  -7.5852D-13   1.4707D-13   7.3873D-13   2.5250D-13  -3.5265D-13  -2.7085D-15  -7.5340D-14  
D  PIETOWN   NHY  CHEB_3    -1.9455D-13   1.6585D-13   6.9985D-14  -3.2740D-14  -7.6129D-14  -2.2119D-14   3.8164D-14   2.1654D-14   6.6047D-15  
D  PIETOWN   NHY  CHEB_4    -2.9986D-14   2.0330D-14   1.0319D-14  -2.1386D-15  -9.4347D-15  -2.5231D-15   4.2799D-15  -1.5502D-16   7.5096D-15  
D  PIETOWN   NHY  CHEB_5    -4.7425D-15   2.9282D-15   1.4096D-15  -9.3468D-16  -1.5069D-15  -4.6128D-16  -4.5893D-16   1.3695D-16  -2.0139D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PINFLATS  HYD  DER_NORT   6.6155D-05   3.2061D-05   1.0433D-05  -2.0439D-05  -1.7460D-05   2.5247D-06  -9.0194D-07   1.4798D-06   4.5083D-07  
D  PINFLATS  HYD  DER_EAST  -1.7298D-05  -3.0618D-05  -1.8720D-05  -3.0637D-06   1.0003D-05  -1.2205D-05   6.6951D-06   3.1147D-06  -3.3353D-07  
D  PINFLATS  HYD  CHEB_0     6.6688D-09   1.6407D-11  -2.2389D-13   7.0800D-12   3.2652D-12  -1.6680D-12  -3.1409D-12   1.2347D-13   3.1051D-12  
D  PINFLATS  HYD  CHEB_1    -4.1869D-12   1.0306D-11   5.5929D-12  -1.0699D-12  -9.6221D-13   1.2791D-12   1.1349D-12   3.1455D-13   3.0965D-13  
D  PINFLATS  HYD  CHEB_2    -2.7601D-12   1.6335D-12   8.8651D-13  -1.1424D-13  -8.9121D-14   3.0260D-13   1.9235D-13   6.0199D-14   4.6226D-14  
D  PINFLATS  HYD  CHEB_3    -1.5029D-12  -2.3298D-13  -1.3713D-13   2.3338D-14   2.8317D-14  -1.1668D-14  -2.5890D-14  -3.4013D-15  -7.3643D-15  
D  PINFLATS  HYD  CHEB_4    -6.1055D-13  -2.5169D-15  -6.9622D-15  -3.5309D-15  -1.9551D-15  -5.3868D-15  -1.4315D-16   8.4896D-16   3.5463D-17  
D  PINFLATS  HYD  CHEB_5    -9.0179D-14  -1.8729D-15   2.7894D-15   3.9363D-16   3.1904D-16  -3.2804D-16  -8.1646D-16  -1.4960D-15  -7.2806D-17  
#
D  PINFLATS  NHY  DER_NORT  -7.6387D-04  -7.4214D-04  -7.4569D-04   1.7074D-04   4.5436D-04  -2.6614D-05   1.1331D-04   3.3632D-04   1.4198D-04  
D  PINFLATS  NHY  DER_EAST   1.0300D-05  -1.8600D-03  -1.1072D-03   6.1323D-04   8.4631D-04   1.6808D-04  -1.8449D-04   2.2354D-04   7.2651D-05  
D  PINFLATS  NHY  CHEB_0     2.1974D-10  -1.0747D-10  -7.0136D-11   1.2825D-11   6.7452D-11  -9.5986D-12  -4.9692D-11  -8.4538D-12   1.2382D-12  
D  PINFLATS  NHY  CHEB_1     1.3112D-11  -6.0938D-12  -3.7802D-12   5.0555D-13   3.5718D-12  -2.8101D-13  -2.5756D-12  -2.7961D-13   1.2791D-13  
D  PINFLATS  NHY  CHEB_2     2.4767D-12  -1.1430D-12  -6.9753D-13   7.7907D-14   6.5635D-13  -1.5183D-14  -4.5869D-13  -5.6746D-14   1.0452D-14  
D  PINFLATS  NHY  CHEB_3    -1.9273D-13   1.0046D-13   6.4606D-14  -1.9032D-14  -6.4329D-14   1.9582D-14   5.2630D-14   2.1611D-15  -1.1862D-14  
D  PINFLATS  NHY  CHEB_4    -3.3826D-14   1.9280D-14   1.2011D-14  -3.6845D-15  -1.1989D-14   8.5436D-16   8.6571D-15   3.0213D-15  -3.0732D-15  
D  PINFLATS  NHY  CHEB_5    -6.1396D-15   3.1472D-15   1.1809D-15  -7.7774D-16  -1.7750D-15   3.1872D-16   1.5130D-15   5.6261D-16   2.3629D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PLATTVIL  HYD  DER_NORT   9.6010D-05   4.9238D-05  -2.8991D-06  -9.2085D-06  -7.1546D-06  -1.0169D-05   1.2463D-05   2.0875D-06   1.8804D-07  
D  PLATTVIL  HYD  DER_EAST  -6.0814D-06  -4.5187D-07   1.6601D-06  -2.0494D-06  -1.2335D-05   8.9866D-06  -4.8615D-06   2.3340D-06   1.7856D-06  
D  PLATTVIL  HYD  CHEB_0     6.4632D-09   4.7406D-12  -7.5989D-12   5.9801D-12   2.1749D-12   2.4899D-12  -2.3988D-12   4.9402D-12  -1.4888D-13  
D  PLATTVIL  HYD  CHEB_1     3.6948D-12   1.2265D-11   5.1934D-12  -1.8571D-12  -1.9885D-12   1.1197D-12   1.5006D-12   5.4806D-13   4.1427D-14  
D  PLATTVIL  HYD  CHEB_2    -6.5045D-13   2.6076D-12   9.4240D-13  -2.7442D-13  -2.6466D-13   1.5236D-13   3.3733D-13   1.2050D-13  -9.3125D-15  
D  PLATTVIL  HYD  CHEB_3    -1.7479D-12  -3.0199D-13  -1.1679D-13   5.7851D-14   7.6309D-14  -1.4531D-15  -3.1920D-14   9.4742D-15  -6.1750D-15  
D  PLATTVIL  HYD  CHEB_4    -6.9117D-13  -6.4203D-14  -2.8813D-14   7.1310D-15   3.1559D-15   3.6830D-15  -1.1697D-14  -2.4125D-15   2.4489D-15  
D  PLATTVIL  HYD  CHEB_5     2.2429D-15   4.5468D-14   4.7606D-15  -9.1325D-15  -8.9584D-15  -1.6873D-15   3.5964D-15   5.1175D-15  -3.8547D-15  
#
D  PLATTVIL  NHY  DER_NORT   9.2457D-04  -6.3133D-04  -6.4538D-05   2.1669D-04   3.0404D-04  -1.4254D-04  -2.2808D-04  -2.0253D-04  -1.0771D-04  
D  PLATTVIL  NHY  DER_EAST   1.1652D-04   9.9793D-04  -1.9313D-04  -2.0707D-06  -2.9739D-04  -4.2366D-04   6.1679D-04   1.5690D-03   5.8575D-05  
D  PLATTVIL  NHY  CHEB_0     2.7582D-10  -1.6911D-10  -5.4821D-11   2.6425D-11   4.6646D-11   2.3966D-12  -3.5439D-11  -1.1020D-11  -1.2900D-11  
D  PLATTVIL  NHY  CHEB_1     1.6621D-11  -9.5734D-12  -2.8792D-12   1.0147D-12   2.5827D-12   4.8216D-13  -2.0720D-12  -1.0472D-12  -4.0970D-13  
D  PLATTVIL  NHY  CHEB_2     3.1888D-12  -1.6994D-12  -5.2790D-13   1.1124D-13   4.3032D-13   8.8038D-14  -3.5536D-13  -1.3492D-13  -4.9641D-14  
D  PLATTVIL  NHY  CHEB_3    -2.2039D-13   1.8437D-13   5.3097D-14  -4.6788D-14  -6.2245D-14  -6.7879D-15   4.2492D-14   4.5827D-14   1.8875D-14  
D  PLATTVIL  NHY  CHEB_4    -4.6944D-14   2.5311D-14   7.7132D-15  -5.1188D-15  -6.3577D-15  -1.7231D-15   5.1524D-15  -5.4649D-15   8.3399D-15  
D  PLATTVIL  NHY  CHEB_5    -4.1453D-15   3.1956D-15   2.1573D-15   9.7662D-16  -1.1072D-15   2.5742D-16  -3.7711D-16   4.2099D-15  -1.4383D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PRESIDIO  HYD  DER_NORT   5.7243D-05   1.3599D-05   1.2178D-05  -3.0003D-06  -2.0449D-05  -2.1854D-06  -1.8260D-05  -6.4055D-07  -1.7398D-06  
D  PRESIDIO  HYD  DER_EAST   9.5808D-06  -2.5314D-05  -9.0453D-06   1.0700D-05   1.4884D-05  -1.5376D-05  -6.4592D-06  -1.4012D-06   1.1656D-06  
D  PRESIDIO  HYD  CHEB_0     7.7336D-09   3.7038D-11   1.4650D-11   9.4310D-12  -3.3275D-12   2.4627D-12  -3.1971D-12   1.0437D-12   4.0363D-12  
D  PRESIDIO  HYD  CHEB_1    -2.2105D-11   1.0326D-11   5.8354D-12  -1.2547D-12  -1.4409D-12   8.6851D-13   8.2575D-13   3.2609D-13   3.2496D-13  
D  PRESIDIO  HYD  CHEB_2    -5.7187D-12   1.4450D-12   8.4696D-13  -1.3292D-13  -1.5891D-13   2.0552D-13   1.2799D-13   5.1998D-14   4.5613D-14  
D  PRESIDIO  HYD  CHEB_3    -1.3051D-12  -2.9638D-13  -1.6162D-13   5.2255D-14   4.9222D-14  -2.4932D-15  -2.7554D-14  -5.6313D-15  -3.0960D-15  
D  PRESIDIO  HYD  CHEB_4    -7.0707D-13   1.7596D-15   7.1061D-16  -7.7387D-15  -4.3952D-15  -7.5918D-15  -2.2117D-15   4.0948D-15  -2.7349D-15  
D  PRESIDIO  HYD  CHEB_5    -1.1910D-13  -1.0976D-15  -1.4391D-15  -5.4778D-16   1.4589D-15  -2.0895D-15   2.4790D-15  -2.4209D-15   2.0021D-15  
#
D  PRESIDIO  NHY  DER_NORT  -6.5566D-04  -3.1378D-05  -3.5342D-04  -2.4539D-04   1.5683D-04  -7.1166D-05   2.4763D-05   3.0161D-05   9.3019D-05  
D  PRESIDIO  NHY  DER_EAST   1.3846D-04  -5.7007D-04  -1.9359D-04  -4.3113D-04   6.0461D-04  -3.5667D-04   2.6862D-04  -3.1552D-04  -9.3719D-05  
D  PRESIDIO  NHY  CHEB_0     3.4760D-10  -4.2464D-11  -2.8548D-11  -2.9252D-12   9.7218D-12  -4.2315D-11  -1.7790D-11  -6.2616D-13   5.9530D-12  
D  PRESIDIO  NHY  CHEB_1     2.0022D-11  -2.9862D-12  -2.0144D-12  -2.7687D-13   1.0767D-12  -2.1444D-12  -1.1191D-12  -2.2629D-13   2.0558D-13  
D  PRESIDIO  NHY  CHEB_2     3.6448D-12  -6.0414D-13  -3.9750D-13  -6.1460D-14   2.3257D-13  -3.5326D-13  -2.1451D-13  -5.8659D-14   1.7429D-14  
D  PRESIDIO  NHY  CHEB_3    -3.4833D-13   2.6285D-14   2.9513D-14   8.5198D-15  -7.2878D-15   4.9387D-14   1.9152D-14  -9.0814D-15  -4.4337D-15  
D  PRESIDIO  NHY  CHEB_4    -5.6407D-14   1.1066D-14   2.5149D-15  -9.5398D-15  -2.5335D-15   1.2066D-14   6.7938D-15   4.2815D-15  -6.9749D-15  
D  PRESIDIO  NHY  CHEB_5    -8.1442D-15   2.7377D-15   4.7726D-15   5.8285D-15  -4.0314D-15  -3.5428D-15   5.8372D-16  -4.5599D-15   6.1332D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PT_REYES  HYD  DER_NORT   5.5148D-05   1.7115D-05   1.3160D-05  -2.4197D-06  -2.1869D-05  -1.9182D-06  -1.9744D-05  -3.3794D-07  -6.3298D-07  
D  PT_REYES  HYD  DER_EAST   1.1278D-05  -2.4985D-05  -8.0031D-06   1.1500D-05   1.4727D-05  -1.5957D-05  -8.1329D-06  -1.1756D-06   2.8581D-06  
D  PT_REYES  HYD  CHEB_0     7.7097D-09   3.6628D-11   1.4673D-11   9.2003D-12  -3.6672D-12   2.3508D-12  -3.2450D-12   1.8164D-13   4.0268D-12  
D  PT_REYES  HYD  CHEB_1    -2.1191D-11   1.0160D-11   5.8288D-12  -1.2205D-12  -1.4397D-12   7.7667D-13   7.3786D-13   2.0376D-13   3.4680D-13  
D  PT_REYES  HYD  CHEB_2    -5.6062D-12   1.4407D-12   8.5130D-13  -1.3007D-13  -1.6562D-13   1.6826D-13   1.0636D-13   3.3316D-14   4.4913D-14  
D  PT_REYES  HYD  CHEB_3    -1.3235D-12  -2.9167D-13  -1.6091D-13   4.9154D-14   5.0035D-14   1.9656D-15  -1.6750D-14  -5.9743D-15  -3.0921D-15  
D  PT_REYES  HYD  CHEB_4    -7.0087D-13   3.1397D-15  -4.5010D-16  -3.7808D-15  -6.7240D-15  -4.1860D-15  -5.4667D-15   1.9844D-15  -2.4010D-15  
D  PT_REYES  HYD  CHEB_5    -1.1278D-13  -4.2963D-15   9.0671D-16   7.0719D-16   2.5744D-15  -4.0102D-15  -4.2588D-17  -1.2473D-15   2.4117D-15  
#
D  PT_REYES  NHY  DER_NORT  -7.7798D-04   1.1410D-04  -2.8594D-04  -2.8300D-04   1.1245D-04  -6.2260D-05   5.9935D-05   2.3850D-04   1.5900D-04  
D  PT_REYES  NHY  DER_EAST   6.1133D-05  -5.4045D-04  -1.5253D-04  -4.3032D-04   5.9250D-04  -4.5316D-04   3.6937D-04  -2.3341D-04   1.4986D-04  
D  PT_REYES  NHY  CHEB_0     3.4445D-10  -4.0319D-11  -2.5613D-11   7.3543D-13   7.1450D-12  -3.9784D-11  -2.0211D-11  -2.1090D-12   5.8753D-12  
D  PT_REYES  NHY  CHEB_1     1.9863D-11  -2.7823D-12  -1.7560D-12  -8.2951D-14   9.7597D-13  -2.0703D-12  -1.0218D-12  -5.2673D-13   3.2049D-13  
D  PT_REYES  NHY  CHEB_2     3.6130D-12  -5.5137D-13  -3.4394D-13  -2.3949D-14   2.1563D-13  -3.5140D-13  -1.9191D-13  -1.2012D-13   5.7236D-14  
D  PT_REYES  NHY  CHEB_3    -3.4499D-13   2.4158D-14   1.8787D-14   4.3787D-15  -1.2536D-15   4.7878D-14   1.5758D-14  -4.1541D-15  -4.0916D-15  
D  PT_REYES  NHY  CHEB_4    -5.2646D-14   6.7613D-15   1.6559D-15  -8.2722D-15   1.1135D-15   9.4203D-15   2.0424D-15   3.8103D-15  -7.4501D-15  
D  PT_REYES  NHY  CHEB_5    -8.4040D-15   2.8063D-15   1.3303D-15   4.2351D-15  -3.9626D-15  -2.4325D-16   1.6548D-15  -2.1725D-15   3.3671D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  PVERDES   HYD  DER_NORT   5.7918D-05   3.2586D-05   1.1982D-05  -1.3049D-05  -1.5614D-05   5.5190D-06  -3.7109D-06   6.8088D-06  -2.4385D-06  
D  PVERDES   HYD  DER_EAST   2.8119D-06  -2.3171D-05  -1.8822D-05  -3.0945D-06   1.2480D-05  -1.4002D-05   5.7626D-06   8.9046D-07   9.8114D-07  
D  PVERDES   HYD  CHEB_0     7.6261D-09   3.3296D-11   1.3349D-11   7.4091D-12   6.2903D-14   2.3381D-12  -2.8487D-13   2.1482D-12   4.0365D-12  
D  PVERDES   HYD  CHEB_1    -2.3812D-11   1.0241D-11   6.0484D-12  -1.2230D-12  -1.0378D-12   1.2734D-12   1.5123D-12   4.1186D-13   4.1368D-13  
D  PVERDES   HYD  CHEB_2    -6.2852D-12   1.4886D-12   9.1067D-13  -1.4481D-13  -1.2884D-13   2.7616D-13   2.5306D-13   7.4747D-14   6.2372D-14  
D  PVERDES   HYD  CHEB_3    -1.2525D-12  -2.9248D-13  -1.6740D-13   3.5063D-14   3.3234D-14  -1.6442D-14  -3.7878D-14  -1.1362D-14  -1.1512D-14  
D  PVERDES   HYD  CHEB_4    -6.6969D-13  -5.7279D-15  -1.5718D-15  -3.9821D-15  -2.2221D-15  -4.9755D-15   2.2711D-17   3.1147D-15  -1.3159D-15  
D  PVERDES   HYD  CHEB_5    -1.2516D-13  -2.0904D-16   6.8607D-16   2.7514D-15   3.9349D-15  -1.5418D-15  -6.4825D-16  -1.3787D-15  -1.3737D-16  
#
D  PVERDES   NHY  DER_NORT  -4.5467D-04  -2.1997D-04  -6.0985D-04   4.7594D-05   3.2211D-04   2.7345D-04  -5.8655D-05   5.9576D-04   3.9104D-04  
D  PVERDES   NHY  DER_EAST   9.8089D-04  -1.2076D-03  -4.4978D-04  -1.4139D-06   6.6019D-04   4.2776D-04  -8.9559D-04  -1.4942D-04  -2.1099D-04  
D  PVERDES   NHY  CHEB_0     3.2985D-10  -1.1691D-10  -6.2396D-11   4.5669D-13   5.7017D-11  -2.5419D-11  -4.2099D-11   2.1463D-13   9.8509D-13  
D  PVERDES   NHY  CHEB_1     1.9450D-11  -7.0226D-12  -3.1625D-12  -4.2772D-13   2.7191D-12  -1.0809D-12  -1.6853D-12  -1.9164D-13  -3.1354D-14  
D  PVERDES   NHY  CHEB_2     3.5424D-12  -1.2257D-12  -5.0925D-13  -1.0708D-13   4.0018D-13  -1.6590D-13  -2.2672D-13  -3.5033D-14  -2.6204D-14  
D  PVERDES   NHY  CHEB_3    -3.3916D-13   1.3728D-13   8.6283D-14  -5.7892D-15  -8.7214D-14   1.9498D-14   6.4104D-14  -1.1423D-14  -3.1930D-15  
D  PVERDES   NHY  CHEB_4    -4.6342D-14   1.7097D-14   5.0880D-15   1.6650D-15  -7.7311D-15   8.8226D-15   6.1961D-15   3.4884D-15   1.8702D-15  
D  PVERDES   NHY  CHEB_5    -9.1526D-15   1.5441D-16   2.7820D-15  -9.8978D-16   1.1437D-16  -5.0563D-15   4.0825D-16  -5.6214D-15  -9.6189D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  QUINCY    HYD  DER_NORT   7.2704D-05   1.5868D-05   6.7595D-06  -2.0370D-06  -2.3503D-05  -1.2146D-05  -2.6207D-05  -7.8219D-06   2.2374D-06  
D  QUINCY    HYD  DER_EAST   2.0418D-06  -2.4828D-05  -4.2129D-06   1.2367D-05   1.2206D-05  -5.8656D-06  -4.3077D-06   1.0256D-05  -2.9265D-06  
D  QUINCY    HYD  CHEB_0     6.7867D-09   2.3691D-11   3.9185D-12   8.1297D-12  -1.2094D-12   6.4177D-13  -2.4158D-12   5.4653D-12  -7.6055D-13  
D  QUINCY    HYD  CHEB_1    -3.0629D-13   1.1415D-11   5.6149D-12  -1.5590D-12  -2.1743D-12   8.8604D-13   5.4371D-13   8.8500D-13  -8.4202D-14  
D  QUINCY    HYD  CHEB_2    -2.2484D-12   1.6552D-12   8.7117D-13  -2.2570D-13  -2.4447D-13   2.2690D-13   1.3795D-13   1.8036D-13  -2.3593D-14  
D  QUINCY    HYD  CHEB_3    -1.5978D-12  -2.4590D-13  -1.3720D-13   4.3600D-14   4.7833D-14  -4.6828D-15  -2.0736D-14   1.8781D-15  -1.7995D-15  
D  QUINCY    HYD  CHEB_4    -5.8320D-13   2.3060D-14   1.0492D-14  -1.1742D-15  -1.1835D-14  -9.4501D-15  -5.2233D-15  -3.3333D-15   1.3714D-15  
D  QUINCY    HYD  CHEB_5    -1.3453D-13  -1.3825D-14  -6.9747D-15   3.0667D-15   1.2791D-14   2.8780D-16   2.6444D-15   8.0303D-16  -1.1049D-15  
#
D  QUINCY    NHY  DER_NORT  -1.1145D-03   3.4719D-04   1.5448D-04  -2.6065D-04   1.8229D-04  -4.0073D-05  -3.7626D-05   5.1691D-05   2.6572D-04  
D  QUINCY    NHY  DER_EAST   9.0185D-04  -1.8999D-03  -4.4950D-04   3.2993D-04   9.0177D-04   1.9417D-04  -2.9134D-04  -3.9556D-04  -3.5709D-04  
D  QUINCY    NHY  CHEB_0     2.4782D-10  -5.1205D-11  -6.0148D-12   5.5261D-12   1.2239D-12  -2.6761D-11  -2.0643D-11  -5.0986D-12  -4.8318D-12  
D  QUINCY    NHY  CHEB_1     1.5047D-11  -3.3106D-12   8.7986D-14   7.1024D-14   5.0517D-14  -1.6081D-12  -1.0512D-12  -3.4873D-13  -6.0369D-13  
D  QUINCY    NHY  CHEB_2     2.7785D-12  -6.5490D-13   2.2357D-14   6.8883D-15   1.2077D-14  -3.0086D-13  -1.8174D-13  -4.3806D-14  -1.4833D-13  
D  QUINCY    NHY  CHEB_3    -2.3852D-13   4.1410D-14   4.8547D-15  -4.6643D-15  -3.6990D-15   2.6327D-14   2.4551D-14   1.7994D-14  -2.8769D-15  
D  QUINCY    NHY  CHEB_4    -3.6096D-14   1.0010D-14   1.7426D-15  -3.8359D-15  -5.3857D-15   4.5915D-15   6.0728D-15   1.6567D-16   2.3765D-15  
D  QUINCY    NHY  CHEB_5    -6.4459D-15   3.4701D-15   3.6487D-16   2.3117D-17   1.0140D-15   9.5466D-16  -1.9338D-16   1.3264D-15   9.2489D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  RICHMOND  HYD  DER_NORT   4.9314D-05   2.9620D-05   2.5343D-05  -9.9382D-06  -3.2062D-06  -1.0554D-05   1.0787D-05   2.4852D-07  -1.6289D-06  
D  RICHMOND  HYD  DER_EAST  -1.9683D-05   4.4899D-06  -2.3811D-06   6.0768D-06   4.5532D-07  -7.7595D-08   1.4759D-07   4.3458D-07  -6.7550D-07  
D  RICHMOND  HYD  CHEB_0     7.7177D-09   1.6063D-11   1.1682D-11   1.1175D-11   5.2114D-12  -1.6437D-14  -6.2646D-12   1.4236D-12   1.6292D-12  
D  RICHMOND  HYD  CHEB_1    -3.3975D-11   3.4690D-12   3.8831D-12  -4.6916D-13  -7.8407D-13  -2.6046D-13  -3.9186D-13   2.6423D-13  -1.2246D-14  
D  RICHMOND  HYD  CHEB_2    -7.7427D-12   4.8875D-13   5.8507D-13  -1.0139D-13  -1.3160D-13  -5.2353D-14  -5.0597D-14   2.8926D-14  -1.2613D-14  
D  RICHMOND  HYD  CHEB_3    -1.0576D-12  -6.4146D-14  -9.2814D-14  -2.1863D-15   7.7308D-15   2.4854D-15   1.6041D-14  -8.0831D-15  -4.4202D-15  
D  RICHMOND  HYD  CHEB_4    -6.7042D-13  -1.0936D-14  -1.3979D-14   5.0219D-15   1.0582D-14  -1.1642D-16  -1.4923D-15   8.6044D-16   3.6621D-15  
D  RICHMOND  HYD  CHEB_5    -1.1053D-13  -1.7297D-15   1.6038D-15  -2.2438D-16  -9.1395D-16   3.5823D-16   5.8633D-17   8.6385D-16  -2.2145D-15  
#
D  RICHMOND  NHY  DER_NORT   7.1810D-04   5.2742D-04  -4.1814D-04  -3.3178D-04  -6.3277D-04  -5.4498D-04   1.0514D-03   5.2928D-04  -3.3203D-04  
D  RICHMOND  NHY  DER_EAST  -2.3545D-04   2.1493D-04   5.0783D-05  -1.8841D-04  -3.6442D-04  -3.5532D-04   7.1616D-05   3.4123D-04  -2.5171D-04  
D  RICHMOND  NHY  CHEB_0     7.7308D-10  -1.7558D-10  -1.6281D-10   5.9772D-11   5.5420D-11   2.2968D-11   2.8907D-11  -6.2787D-12   4.6753D-12  
D  RICHMOND  NHY  CHEB_1     4.2133D-11  -5.5478D-12  -6.0432D-12   2.0283D-12   1.1643D-12   1.4859D-12   9.6392D-13  -5.4965D-13   3.5148D-13  
D  RICHMOND  NHY  CHEB_2     7.5116D-12  -7.7391D-13  -7.8489D-13   3.0868D-13  -6.0568D-14   1.6341D-13   2.2973D-13  -2.2666D-13   2.3652D-14  
D  RICHMOND  NHY  CHEB_3    -7.9653D-13   1.4939D-13   2.0176D-13  -5.1145D-14  -8.7578D-14  -6.4890D-14  -2.5732D-14   5.0601D-15  -5.8081D-14  
D  RICHMOND  NHY  CHEB_4    -9.4083D-14  -4.2316D-15  -4.3036D-15  -9.5728D-15   2.9112D-14   2.4978D-15  -9.9625D-15   1.6773D-14  -4.0658D-15  
D  RICHMOND  NHY  CHEB_5    -2.4711D-14   1.9539D-15   7.7031D-15   2.4567D-15  -3.9778D-15   4.1572D-15  -4.8344D-15   2.1769D-15   2.1300D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ROBLED32  HYD  DER_NORT   7.0044D-05  -2.5583D-06  -1.6266D-05   8.6209D-06   1.2407D-05  -2.3442D-05   1.8718D-05   1.2486D-06   1.3974D-06  
D  ROBLED32  HYD  DER_EAST  -1.4942D-05  -1.7207D-05  -2.4234D-05   6.9584D-06  -1.8819D-05  -1.2563D-05   1.7349D-05   1.6672D-06  -4.8146D-07  
D  ROBLED32  HYD  CHEB_0     7.0711D-09   3.1370D-11   3.8551D-12   1.7559D-11  -5.3340D-13   9.9720D-12  -6.0413D-12   2.6097D-13  -3.9170D-12  
D  ROBLED32  HYD  CHEB_1    -3.4640D-12   9.9799D-12   7.9860D-12  -1.7824D-12  -2.0074D-12   6.6123D-13  -4.7968D-13   5.8357D-14  -7.9083D-13  
D  ROBLED32  HYD  CHEB_2    -2.8046D-12   1.4091D-12   1.2329D-12  -2.9284D-13  -3.1085D-13   6.6970D-14  -4.0121D-14   1.9849D-14  -1.4650D-13  
D  ROBLED32  HYD  CHEB_3    -1.6489D-12  -2.5287D-13  -1.8298D-13   3.1044D-14   5.9924D-14  -9.8875D-15   3.0451D-15  -7.1650D-15   8.0104D-15  
D  ROBLED32  HYD  CHEB_4    -6.4724D-13   8.8445D-15  -8.2440D-15   1.9742D-15  -1.9943D-15   1.3578D-15  -1.3811D-15  -1.1918D-15  -9.7264D-16  
D  ROBLED32  HYD  CHEB_5    -9.5492D-14  -2.9170D-15  -2.7878D-15   1.9585D-15  -3.9019D-15  -2.4883D-15   4.3826D-15   7.4732D-16   7.4041D-16  
#
D  ROBLED32  NHY  DER_NORT  -6.7021D-04   1.6949D-04  -1.5676D-04  -2.8488D-05  -1.5647D-04   1.3375D-04   3.1529D-04   6.3186D-06  -2.1328D-04  
D  ROBLED32  NHY  DER_EAST  -6.1682D-05  -3.1251D-04  -8.6153D-05   7.7104D-05  -1.2954D-04   7.7391D-05   2.9913D-05  -3.1017D-05  -1.0189D-05  
D  ROBLED32  NHY  CHEB_0     3.3892D-10  -6.7500D-11  -7.1189D-11  -2.4026D-11  -2.7905D-11  -2.1555D-11   3.1713D-11  -5.3085D-12   2.6674D-12  
D  ROBLED32  NHY  CHEB_1     2.0938D-11  -3.6591D-12  -3.3926D-12  -1.4864D-12  -1.8893D-12  -1.4105D-12   1.7996D-12  -3.9199D-13  -1.9328D-13  
D  ROBLED32  NHY  CHEB_2     3.8966D-12  -6.5984D-13  -5.8576D-13  -2.7383D-13  -3.5796D-13  -2.8633D-13   3.1473D-13  -6.6409D-14  -5.0290D-14  
D  ROBLED32  NHY  CHEB_3    -3.2772D-13   7.0791D-14   7.7146D-14   2.1142D-14   2.2466D-14   1.5228D-14  -3.6548D-14   5.2796D-15  -5.5545D-15  
D  ROBLED32  NHY  CHEB_4    -5.3158D-14   1.1688D-14   1.0549D-14   2.8655D-15   5.7158D-15   3.4367D-15  -5.4695D-15   3.7624D-16  -4.6966D-17  
D  ROBLED32  NHY  CHEB_5    -8.2522D-15   1.7164D-15   1.5262D-15   1.2722D-16  -3.2906D-16   1.6116D-16  -9.4067D-16  -3.9809D-16   4.0831D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SAGARA    HYD  DER_NORT   1.6011D-04   8.6237D-05   5.8736D-05   1.1615D-05  -2.4028D-05  -5.7905D-06  -1.1187D-05  -6.3407D-08  -3.2442D-06  
D  SAGARA    HYD  DER_EAST   5.9970D-06   8.2769D-06  -1.3107D-05  -3.9566D-06  -1.1771D-05   5.6626D-06  -7.7289D-07  -1.0940D-06  -8.9047D-07  
D  SAGARA    HYD  CHEB_0     7.6162D-09   5.4848D-11   9.6386D-12  -1.7389D-12  -6.1080D-12  -1.1667D-13  -4.0281D-13  -1.5297D-12   4.1315D-12  
D  SAGARA    HYD  CHEB_1    -1.8913D-11   1.5262D-11   1.0947D-11  -7.1324D-13  -1.7861D-12  -3.8822D-13   3.3414D-13  -2.9436D-13   4.4364D-13  
D  SAGARA    HYD  CHEB_2    -5.2951D-12   2.2334D-12   1.6264D-12  -4.4803D-14  -1.9765D-13  -2.1074D-14   5.5583D-14  -4.7517D-14   7.8749D-14  
D  SAGARA    HYD  CHEB_3    -1.2956D-12  -4.0548D-13  -2.9903D-13   4.2404D-14   6.3039D-14   2.1363D-14  -1.6260D-14   1.3685D-14  -6.1840D-15  
D  SAGARA    HYD  CHEB_4    -6.5489D-13   1.5336D-14   1.7129D-14  -6.2768D-15  -4.6508D-15  -6.0159D-15   1.0036D-15   9.4761D-16  -2.3105D-15  
D  SAGARA    HYD  CHEB_5    -1.3897D-13  -7.5985D-15  -4.7284D-15   1.2840D-15   7.9740D-15   6.2049D-16   2.0201D-16  -1.0378D-15   2.8669D-15  
#
D  SAGARA    NHY  DER_NORT   1.4473D-03   2.3611D-03   5.1643D-04   4.7735D-04   3.2172D-04  -5.9559D-05   1.7381D-04  -6.9328D-04   9.3922D-04  
D  SAGARA    NHY  DER_EAST   2.7555D-04   4.0260D-04   4.1422D-06  -4.5626D-04  -4.1707D-05   4.0200D-05  -1.4796D-04  -5.8294D-05   1.9340D-04  
D  SAGARA    NHY  CHEB_0     5.4923D-10  -3.6451D-10  -2.3534D-10   6.8565D-11   1.1834D-10  -1.6341D-11  -4.7251D-11   1.1294D-11   3.8107D-12  
D  SAGARA    NHY  CHEB_1     3.0343D-11  -1.7676D-11  -1.2259D-11   2.3216D-12   4.7187D-12  -8.3169D-13  -1.5000D-12   4.2627D-13  -5.7004D-13  
D  SAGARA    NHY  CHEB_2     5.3422D-12  -2.8300D-12  -2.0500D-12   2.3584D-13   6.5375D-13  -9.2066D-14  -1.6037D-13   6.4406D-14  -1.3333D-13  
D  SAGARA    NHY  CHEB_3    -6.1612D-13   4.8088D-13   2.9507D-13  -1.1971D-13  -1.6770D-13   4.3144D-14   6.5944D-14  -4.4554D-15  -9.7684D-15  
D  SAGARA    NHY  CHEB_4    -8.6057D-14   4.9185D-14   3.5754D-14  -5.2790D-15  -1.3818D-14  -8.3837D-16   3.3501D-15   1.1055D-16  -3.5238D-15  
D  SAGARA    NHY  CHEB_5    -1.2240D-14   8.2029D-15   4.5652D-15  -8.8502D-16  -2.2057D-15   1.3022D-15   1.1473D-16   1.0449D-15   2.9859D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SANPAULA  HYD  DER_NORT   2.7332D-05   1.1176D-05   7.4349D-06  -1.2910D-05  -1.1124D-05   2.8762D-06  -3.3418D-06  -7.2119D-06   1.5282D-07  
D  SANPAULA  HYD  DER_EAST  -5.4042D-06  -2.1590D-05  -1.8886D-05   8.2795D-08   1.4194D-05  -1.4056D-05   5.0441D-06   2.8670D-06  -3.8217D-07  
D  SANPAULA  HYD  CHEB_0     7.5264D-09   3.9446D-11   1.1572D-11   7.6432D-12  -2.0429D-13   1.8263D-12  -1.4163D-12   7.8052D-12   2.5876D-12  
D  SANPAULA  HYD  CHEB_1    -2.1697D-11   1.1304D-11   6.0117D-12  -1.2262D-12  -1.2661D-12   1.3363D-12   1.3344D-12   1.1495D-12   1.0026D-13  
D  SANPAULA  HYD  CHEB_2    -5.6649D-12   1.6457D-12   8.8404D-13  -1.7887D-13  -1.1516D-13   2.3468D-13   2.3091D-13   1.9933D-13   3.7051D-14  
D  SANPAULA  HYD  CHEB_3    -1.3495D-12  -2.9581D-13  -1.5900D-13   4.4348D-14   2.4501D-14  -1.7924D-14  -3.7972D-14  -1.2624D-15  -9.6908D-15  
D  SANPAULA  HYD  CHEB_4    -6.5833D-13   1.1061D-15  -5.5390D-15  -4.0145D-15  -1.2831D-15  -3.6365D-15  -1.9735D-15  -2.2802D-15   1.2418D-15  
D  SANPAULA  HYD  CHEB_5    -1.1741D-13  -3.8001D-15   1.2148D-15  -1.0426D-16   2.3120D-15  -1.6226D-15   1.0484D-15  -6.6385D-16  -9.9103D-16  
#
D  SANPAULA  NHY  DER_NORT  -2.4291D-03  -4.8202D-04  -9.0597D-04  -1.6776D-06   7.6099D-04   3.1618D-04  -9.8027D-05   6.5028D-04   5.4440D-04  
D  SANPAULA  NHY  DER_EAST   6.5247D-04  -1.2491D-03  -4.2587D-04   4.7442D-05   8.5654D-04   1.8902D-04  -6.6892D-04  -1.1237D-04  -2.2534D-04  
D  SANPAULA  NHY  CHEB_0     3.1333D-10  -9.9401D-11  -5.0016D-11   8.6292D-13   4.7341D-11  -2.9107D-11  -3.3283D-11  -4.7076D-13  -3.8701D-12  
D  SANPAULA  NHY  CHEB_1     1.8234D-11  -5.2325D-12  -2.2077D-12  -5.4744D-13   2.0177D-12  -1.2081D-12  -1.5200D-12   2.3788D-13  -4.3713D-13  
D  SANPAULA  NHY  CHEB_2     3.3205D-12  -9.3371D-13  -3.5828D-13  -1.3171D-13   3.1870D-13  -1.9200D-13  -2.2046D-13   9.5989D-14  -8.6306D-14  
D  SANPAULA  NHY  CHEB_3    -3.3023D-13   1.1036D-13   6.1704D-14  -6.5336D-15  -6.7200D-14   3.3602D-14   5.7878D-14   1.6321D-14   4.0720D-15  
D  SANPAULA  NHY  CHEB_4    -4.8465D-14   1.6377D-14   4.1113D-15  -2.3849D-15  -7.9233D-15   4.8822D-15   6.4239D-15   3.3582D-15   5.2680D-15  
D  SANPAULA  NHY  CHEB_5    -8.7766D-15   3.4469D-15   1.7777D-15   1.4092D-15  -1.6631D-15   1.1817D-16   1.3377D-16  -2.8239D-15  -1.1912D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SANTIA12  HYD  DER_NORT  -1.3252D-04   3.4267D-05   2.0429D-05  -5.8157D-06   4.0766D-07   8.0299D-06   8.3959D-06  -3.4671D-06   4.2926D-06  
D  SANTIA12  HYD  DER_EAST   4.5747D-04  -6.1304D-05  -3.8966D-05  -1.3351D-05  -1.4429D-05  -8.3119D-06   6.9662D-06   1.0798D-05  -5.1359D-05  
D  SANTIA12  HYD  CHEB_0     7.1235D-09  -2.3224D-11  -6.7694D-12   2.2077D-12  -3.4541D-13   9.1511D-14   1.1585D-12  -2.1835D-12  -6.7511D-13  
D  SANTIA12  HYD  CHEB_1    -3.8152D-12  -8.2272D-12  -2.4937D-12   3.7887D-13  -9.5658D-13  -1.9125D-13   5.2123D-13   3.9884D-13  -1.3204D-12  
D  SANTIA12  HYD  CHEB_2    -2.7406D-12  -1.2287D-12  -5.2058D-13   3.5750D-14  -9.5554D-14  -1.5838D-14   4.7353D-14   5.0843D-14  -3.3597D-13  
D  SANTIA12  HYD  CHEB_3    -1.3850D-12   1.2026D-13   3.6096D-14  -1.4809D-14   4.3116D-14  -9.0731D-16   5.7387D-15   9.4299D-15  -1.5483D-14  
D  SANTIA12  HYD  CHEB_4    -6.0632D-13   2.2318D-14   4.9393D-15  -3.8106D-15   4.1607D-16  -3.5654D-15   5.6219D-16  -1.3837D-15  -8.9227D-16  
D  SANTIA12  HYD  CHEB_5    -1.5323D-13   1.9843D-14   6.5235D-15   3.6610D-16  -1.4558D-15   1.3021D-15  -2.8642D-15  -2.8633D-15   3.5815D-15  
#
D  SANTIA12  NHY  DER_NORT  -1.3426D-03  -8.0388D-04   5.6075D-04   1.9742D-04  -7.8458D-05  -1.2926D-04  -9.8633D-05   4.8355D-04  -3.4837D-05  
D  SANTIA12  NHY  DER_EAST   1.2473D-02   5.5616D-03  -1.2043D-03  -8.3856D-04  -8.7421D-04  -7.0528D-04   4.9418D-04  -2.1095D-03   8.9049D-04  
D  SANTIA12  NHY  CHEB_0     2.5243D-10   5.4592D-11   1.4716D-11   6.2360D-12   3.7214D-11  -7.8985D-12   7.1340D-12  -2.4344D-11   6.6868D-12  
D  SANTIA12  NHY  CHEB_1     2.1462D-11   7.8278D-12   1.9743D-12   7.2995D-13   2.8813D-12  -5.7503D-13   4.9006D-13  -2.4411D-12   1.2799D-13  
D  SANTIA12  NHY  CHEB_2     3.9095D-12   1.6564D-12   3.7665D-13   1.2133D-13   4.7052D-13  -1.1551D-13   6.5743D-14  -4.7762D-13  -2.1846D-14  
D  SANTIA12  NHY  CHEB_3    -3.8780D-13  -8.2017D-14  -2.7074D-14  -3.4883D-14  -7.6823D-14   6.5292D-15  -2.8449D-14   4.3300D-14  -2.8470D-14  
D  SANTIA12  NHY  CHEB_4    -9.2080D-14  -6.3012D-14  -6.7325D-15  -8.9415D-15  -1.2346D-14   6.4688D-15  -7.9915D-15   2.1117D-14  -7.7795D-15  
D  SANTIA12  NHY  CHEB_5    -1.5584D-14  -1.2345D-14   8.6479D-17  -2.6584D-15  -1.1211D-15   8.5880D-16  -2.1314D-15   2.1891D-15   1.3293D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SC-VLBA   HYD  DER_NORT   3.0413D-05   5.3127D-06   1.3717D-05  -9.5816D-06  -4.7985D-06   2.1950D-06  -1.5828D-06   1.1614D-06   1.4267D-07  
D  SC-VLBA   HYD  DER_EAST   2.2577D-06  -5.0638D-06   1.9732D-06  -2.3699D-06   7.1192D-07  -2.4055D-06   9.8550D-07   1.4938D-07  -5.8334D-07  
D  SC-VLBA   HYD  CHEB_0     7.6883D-09   2.5430D-12   1.1002D-11   1.1922D-11   7.5779D-12   1.2854D-13   3.9211D-13   1.5141D-12   7.2442D-13  
D  SC-VLBA   HYD  CHEB_1    -3.7765D-11   1.7767D-12   1.4674D-12   5.8980D-13  -1.1466D-14   1.0195D-13  -5.5488D-13   2.5042D-13  -1.7827D-13  
D  SC-VLBA   HYD  CHEB_2    -8.3353D-12   2.0909D-13   1.9942D-13   5.8683D-14   1.1175D-14   2.0011D-14  -8.0565D-14   3.7939D-14  -3.4335D-14  
D  SC-VLBA   HYD  CHEB_3    -8.8685D-13  -5.6406D-14  -4.4929D-14  -2.2616D-14   7.5231D-15  -5.8870D-16   1.4765D-14  -4.1214D-15   9.0234D-16  
D  SC-VLBA   HYD  CHEB_4    -6.5507D-13   9.0035D-16   6.9557D-17  -2.2384D-15  -3.7850D-16   2.6139D-15   5.2732D-17  -6.8660D-16   3.1486D-16  
D  SC-VLBA   HYD  CHEB_5    -1.2914D-13   2.8396D-15   1.3816D-15   5.1592D-16   1.2973D-16  -6.4289D-16  -7.1203D-16   4.9096D-16  -5.8576D-16  
#
D  SC-VLBA   NHY  DER_NORT  -1.8857D-04   3.2878D-04  -4.6052D-04  -8.7808D-06   5.4302D-04  -1.9773D-04  -3.7986D-04   8.0828D-05   3.8389D-05  
D  SC-VLBA   NHY  DER_EAST  -4.0188D-04   2.5817D-04   4.8499D-05   1.4676D-04   1.4277D-05  -3.7731D-05   1.9949D-05  -1.0943D-04  -4.2129D-05  
D  SC-VLBA   NHY  CHEB_0     8.7125D-10  -1.0958D-10  -1.0553D-10  -3.8216D-11  -6.5692D-11  -4.5685D-13   2.0069D-12   7.2072D-13   5.9590D-13  
D  SC-VLBA   NHY  CHEB_1     4.8574D-11  -2.5749D-12  -2.1104D-12  -5.5301D-13  -2.2048D-12  -3.6962D-13  -2.6165D-13   2.2446D-13   3.0039D-13  
D  SC-VLBA   NHY  CHEB_2     8.7273D-12  -2.9939D-13  -2.7123D-13  -6.6210D-14  -2.2066D-13  -1.0894D-13  -8.9561D-14   1.8478D-14   1.2072D-13  
D  SC-VLBA   NHY  CHEB_3    -9.6301D-13   1.4995D-13   8.6008D-14   5.8526D-14   1.4284D-13  -2.4654D-14   1.5873D-14  -3.0802D-14  -2.7785D-16  
D  SC-VLBA   NHY  CHEB_4    -1.2127D-13   7.2874D-15   2.1591D-14  -1.7430D-14  -4.8775D-15   1.2881D-14  -1.9172D-14   7.3027D-15   6.9492D-15  
D  SC-VLBA   NHY  CHEB_5    -3.6079D-14   1.0646D-14   1.8093D-15   1.2493D-14   7.1229D-15  -3.0140D-15   1.3368D-14  -5.1426D-15  -7.9451D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SEATTLE1  HYD  DER_NORT   1.0319D-04   3.7472D-05   2.9046D-06   1.7287D-06  -2.1764D-05  -1.6327D-05  -2.5770D-05   1.2268D-06  -3.0002D-07  
D  SEATTLE1  HYD  DER_EAST   5.0943D-05  -1.3406D-06   2.3058D-05   1.7162D-05  -1.6130D-05  -1.6320D-05  -3.4765D-05   3.0779D-08  -5.3854D-07  
D  SEATTLE1  HYD  CHEB_0     7.7333D-09   1.4690D-11   8.8991D-12   6.2347D-12   9.9057D-13   9.7174D-12   8.3704D-12   4.6026D-12   3.0570D-12  
D  SEATTLE1  HYD  CHEB_1    -9.3165D-12   1.1675D-11   6.1793D-12  -1.2810D-12  -4.1049D-12   1.6166D-13  -9.3962D-13   7.0308D-13   3.1598D-13  
D  SEATTLE1  HYD  CHEB_2    -3.8352D-12   1.8123D-12   9.9816D-13  -5.8814D-14  -5.5376D-13   2.4302D-14  -2.3541D-13   1.3329D-13   4.5828D-14  
D  SEATTLE1  HYD  CHEB_3    -1.6141D-12  -3.0644D-13  -1.6166D-13   4.8253D-14   1.2258D-13   5.5515D-15   3.3388D-14   3.4122D-17  -1.1140D-14  
D  SEATTLE1  HYD  CHEB_4    -7.1894D-13  -2.7726D-14  -1.3089D-14  -3.9444D-15  -2.9349D-15  -1.8825D-15   6.6709D-15   2.5165D-16   3.3272D-16  
D  SEATTLE1  HYD  CHEB_5    -8.9809D-14   1.2563D-14   8.9985D-15   1.0837D-15  -3.9391D-15  -2.8372D-15  -9.2579D-15  -2.1323D-15   1.4367D-15  
#
D  SEATTLE1  NHY  DER_NORT   3.2847D-04   1.1632D-05   2.5845D-04  -2.3767D-04  -4.3343D-05  -1.0441D-04  -2.2676D-04  -2.2555D-04  -4.4930D-05  
D  SEATTLE1  NHY  DER_EAST   7.3827D-04  -1.7345D-04  -6.9212D-05  -2.8755D-04  -1.9613D-04  -5.2791D-05   1.8383D-04  -2.8745D-04  -4.8446D-05  
D  SEATTLE1  NHY  CHEB_0     3.8010D-10  -8.7732D-11  -3.5899D-11   1.2569D-11   1.6489D-11  -3.9963D-11  -1.2124D-11  -2.2482D-12  -1.1749D-13  
D  SEATTLE1  NHY  CHEB_1     2.2778D-11  -5.6368D-12  -2.0900D-12   5.8475D-13   8.3647D-13  -2.1140D-12  -2.6909D-13  -6.2145D-13  -3.3132D-14  
D  SEATTLE1  NHY  CHEB_2     4.1350D-12  -1.0510D-12  -3.8343D-13   8.7063D-14   1.4419D-13  -3.4377D-13  -1.3612D-14  -1.4509D-13  -1.3146D-14  
D  SEATTLE1  NHY  CHEB_3    -4.1700D-13   8.9998D-14   3.5427D-14  -2.1338D-14  -1.8345D-14   5.7629D-14   2.2713D-14  -4.7591D-15   9.0570D-17  
D  SEATTLE1  NHY  CHEB_4    -5.9426D-14   9.3371D-15   1.2514D-15  -6.5400D-16   2.7014D-15   6.8655D-15  -5.8707D-16   1.9225D-15  -3.3845D-16  
D  SEATTLE1  NHY  CHEB_5    -1.1606D-14   3.5719D-15   1.7564D-15  -1.2898D-15  -6.2673D-16   1.1304D-15   8.3703D-16  -8.1123D-16   2.3614D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SESHAN25  HYD  DER_NORT   1.1534D-04   6.4233D-05   3.8187D-05   1.9737D-06  -2.2741D-05  -4.8986D-06  -8.2983D-07  -1.0857D-06   1.3682D-06  
D  SESHAN25  HYD  DER_EAST   3.5892D-05   1.8963D-06  -5.6096D-06   9.2180D-06   3.1117D-06  -4.1776D-06  -6.6733D-06   1.3436D-06   4.5882D-07  
D  SESHAN25  HYD  CHEB_0     7.7132D-09   9.5267D-11   1.4478D-11  -5.7008D-13  -3.8982D-12   9.9103D-12   1.4536D-12  -3.5032D-12   3.6866D-12  
D  SESHAN25  HYD  CHEB_1    -2.5468D-11   1.5850D-11   7.1265D-12  -5.2477D-14  -9.8487D-13   8.9977D-13  -1.0118D-14  -4.7993D-13   4.8516D-13  
D  SESHAN25  HYD  CHEB_2    -6.1587D-12   2.3809D-12   1.0910D-12   4.4217D-14  -1.0128D-13   1.6760D-13   3.2879D-14  -9.3473D-14   3.5235D-14  
D  SESHAN25  HYD  CHEB_3    -1.1873D-12  -4.1014D-13  -1.8892D-13   1.7231D-14   4.4629D-14  -9.8500D-15   8.5751D-15   1.5696D-14   1.2042D-14  
D  SESHAN25  HYD  CHEB_4    -6.9030D-13  -1.8068D-14  -5.0945D-15   2.9355D-15   1.1227D-15  -7.0981D-15  -1.4645D-15  -7.5408D-16  -8.8998D-15  
D  SESHAN25  HYD  CHEB_5    -1.2160D-13  -2.0092D-16   5.3170D-16  -1.6610D-15  -7.1147D-16   1.5819D-15  -8.0779D-16   7.0904D-16   1.2825D-15  
#
D  SESHAN25  NHY  DER_NORT   2.3549D-03   1.1914D-03   9.0062D-04  -5.8816D-04  -3.9570D-04  -4.3691D-05   4.7405D-04   2.7073D-04   1.7622D-04  
D  SESHAN25  NHY  DER_EAST  -4.6368D-04   5.7316D-04  -5.4894D-04   4.4824D-04  -1.6957D-04   3.3779D-04  -2.4227D-04  -2.2450D-04  -2.3453D-05  
D  SESHAN25  NHY  CHEB_0     6.2631D-10  -4.1813D-10  -1.7858D-10   1.0123D-10   9.6410D-11  -6.2471D-11  -3.1644D-11   3.8323D-12  -5.6663D-12  
D  SESHAN25  NHY  CHEB_1     3.1265D-11  -1.8587D-11  -9.0908D-12   3.0962D-12   4.2562D-12  -2.1259D-12  -1.7190D-12  -4.7051D-13   9.3443D-13  
D  SESHAN25  NHY  CHEB_2     5.5371D-12  -3.2968D-12  -1.6826D-12   5.0720D-13   8.2762D-13  -3.0963D-13  -4.1284D-13  -1.4938D-13  -1.4342D-13  
D  SESHAN25  NHY  CHEB_3    -6.7812D-13   4.4977D-13   1.8978D-13  -1.1511D-13  -1.1041D-13   5.6564D-14   3.1317D-14  -1.6788D-15  -4.3472D-14  
D  SESHAN25  NHY  CHEB_4    -1.1150D-13   8.4411D-14   4.5298D-14  -2.0518D-14  -3.8893D-14   1.4386D-15   1.8360D-14   9.0812D-15   4.1363D-14  
D  SESHAN25  NHY  CHEB_5    -9.8267D-15   7.8098D-16  -2.4601D-15   5.3326D-16   4.8748D-15   2.7732D-16  -3.2409D-15  -1.6772D-15  -6.7287D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SEST      HYD  DER_NORT  -1.2607D-04   3.5961D-05   6.0608D-06  -8.8076D-07   6.8982D-06   7.6498D-06   1.6684D-06  -3.2215D-06   1.0141D-06  
D  SEST      HYD  DER_EAST   1.1795D-04   9.3201D-06   1.0855D-05  -1.0525D-05  -1.0885D-05  -5.0935D-06   2.5415D-07  -8.3156D-08  -3.3665D-06  
D  SEST      HYD  CHEB_0     5.8533D-09  -5.1869D-12  -2.0114D-12   1.6529D-13   1.5686D-12   7.1036D-13  -2.5981D-14   1.4852D-13   4.6706D-12  
D  SEST      HYD  CHEB_1     6.0310D-12  -3.9238D-12  -6.1215D-13   1.5976D-13  -6.6346D-13   4.6745D-13   6.6052D-13   2.4883D-13  -1.5999D-13  
D  SEST      HYD  CHEB_2     9.1319D-13  -1.1467D-12  -3.3318D-13   1.2005D-13  -1.2266D-13   2.5616D-14   6.5437D-14   7.9857D-14  -4.2968D-15  
D  SEST      HYD  CHEB_3    -1.7296D-12   1.2594D-13   4.5015D-14  -4.2385D-15   2.3217D-14   3.9850D-16   2.2377D-14  -7.3866D-15  -7.9795D-15  
D  SEST      HYD  CHEB_4    -7.0610D-13   3.7849D-14   2.5151D-14  -2.2182D-15   1.1271D-15   5.1678D-16   5.2366D-15  -3.8571D-15  -2.0831D-15  
D  SEST      HYD  CHEB_5     6.8568D-14  -1.8295D-14  -1.8385D-14  -9.5933D-17  -7.0201D-15  -6.9672D-15  -8.3905D-15   2.7651D-15   2.5528D-15  
#
D  SEST      NHY  DER_NORT   1.2294D-03   7.5806D-04  -3.7223D-04  -1.1235D-04   4.9904D-04  -1.4256D-04  -3.1942D-04  -7.9264D-04   7.2663D-04  
D  SEST      NHY  DER_EAST   9.2291D-03   3.7905D-03   8.3062D-04  -2.1738D-04  -5.2194D-04  -2.3089D-04   6.5131D-04  -3.7344D-03   1.8616D-04  
D  SEST      NHY  CHEB_0     9.4734D-11   9.8173D-12   1.3039D-11   4.6957D-12   6.1674D-12   5.7598D-12   3.6540D-12  -1.3817D-12   5.8793D-12  
D  SEST      NHY  CHEB_1     6.9198D-12   2.0596D-12   1.1350D-12   5.6453D-13   6.7899D-13   3.4246D-13   3.1681D-13  -6.3724D-13   6.6233D-13  
D  SEST      NHY  CHEB_2     1.4968D-12   5.2081D-13   2.4900D-13   1.1956D-13   1.5337D-13   6.4386D-14   7.6470D-14  -1.7404D-13   1.2790D-13  
D  SEST      NHY  CHEB_3    -2.8992D-14   2.6070D-14  -1.6986D-15   1.2080D-15   1.2028D-16  -1.0895D-14   5.4645D-15  -1.7080D-14   5.2096D-15  
D  SEST      NHY  CHEB_4    -2.1992D-14  -1.2865D-15  -3.7850D-15  -4.1181D-15   1.8626D-16   3.8915D-16  -1.3499D-15   1.9143D-15  -3.6221D-15  
D  SEST      NHY  CHEB_5    -4.4471D-15  -2.2254D-15  -2.8188D-16   4.0453D-16  -1.6413D-15  -1.0445D-15   1.3097D-15  -1.4734D-15   3.4773D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SHANGHAI  HYD  DER_NORT   1.1582D-04   6.4684D-05   3.8334D-05   2.1568D-06  -2.2720D-05  -4.6962D-06  -1.2829D-06  -1.1331D-06   2.2321D-06  
D  SHANGHAI  HYD  DER_EAST   3.5624D-05   5.1557D-07  -5.8793D-06   9.2581D-06   3.0084D-06  -4.0401D-06  -6.7787D-06   1.3687D-06  -6.5907D-07  
D  SHANGHAI  HYD  CHEB_0     7.7247D-09   9.5347D-11   1.5087D-11  -9.1950D-13  -3.9212D-12   9.7230D-12   1.6829D-12  -3.0548D-12   3.3841D-12  
D  SHANGHAI  HYD  CHEB_1    -2.5583D-11   1.5897D-11   7.2357D-12  -1.1436D-13  -1.0212D-12   8.8552D-13   3.5950D-14  -4.3280D-13   4.5507D-13  
D  SHANGHAI  HYD  CHEB_2    -6.1750D-12   2.3944D-12   1.1083D-12   3.2322D-14  -1.0428D-13   1.6721D-13   4.1126D-14  -8.2491D-14   4.0392D-14  
D  SHANGHAI  HYD  CHEB_3    -1.1832D-12  -4.2272D-13  -1.9157D-13   2.1058D-14   4.9208D-14  -1.1054D-14   6.6414D-15   1.5697D-14   9.1407D-15  
D  SHANGHAI  HYD  CHEB_4    -6.9405D-13  -1.2522D-14  -4.2936D-15   1.2244D-15  -1.1694D-15  -6.3164D-15  -7.6582D-16  -4.9163D-16  -5.2516D-15  
D  SHANGHAI  HYD  CHEB_5    -1.1710D-13  -1.8462D-15   1.2175D-15  -1.0831D-15  -1.2451D-15   7.1896D-16  -8.3136D-16   1.3048D-16  -4.6603D-16  
#
D  SHANGHAI  NHY  DER_NORT   2.3624D-03   1.1949D-03   9.3821D-04  -6.2043D-04  -3.7331D-04  -8.4758D-05   4.6785D-04   3.0991D-04   1.4265D-04  
D  SHANGHAI  NHY  DER_EAST  -5.6712D-04   6.3073D-04  -6.2113D-04   5.8836D-04  -1.3891D-04   3.6016D-04  -2.1829D-04  -3.1567D-04   1.3675D-04  
D  SHANGHAI  NHY  CHEB_0     6.2553D-10  -4.1704D-10  -1.8226D-10   1.0321D-10   9.7016D-11  -6.1864D-11  -3.3246D-11   2.5370D-12  -5.9078D-12  
D  SHANGHAI  NHY  CHEB_1     3.1279D-11  -1.8504D-11  -9.3918D-12   3.1892D-12   4.3753D-12  -2.0399D-12  -1.8694D-12  -4.2991D-13   8.9406D-13  
D  SHANGHAI  NHY  CHEB_2     5.5255D-12  -3.2458D-12  -1.7137D-12   5.1233D-13   8.0659D-13  -3.1615D-13  -4.1020D-13  -1.4696D-13  -9.1599D-14  
D  SHANGHAI  NHY  CHEB_3    -6.7656D-13   4.4955D-13   1.9678D-13  -1.0902D-13  -1.1078D-13   4.8640D-14   2.9920D-14  -1.1903D-14  -4.9462D-14  
D  SHANGHAI  NHY  CHEB_4    -1.0314D-13   7.0303D-14   3.9435D-14  -1.5991D-14  -3.2168D-14   1.1372D-15   1.3691D-14   6.5317D-15   3.1651D-14  
D  SHANGHAI  NHY  CHEB_5    -1.5696D-14   1.0618D-14   1.0701D-15  -2.5858D-15   8.5565D-16   1.5115D-15   6.4846D-16   3.7565D-16  -2.6812D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SINTOTU   HYD  DER_NORT   1.3725D-04   6.8280D-05  -7.4162D-06  -5.0961D-06  -1.6365D-05   2.7682D-08  -1.7016D-05  -1.3528D-06  -3.4521D-07  
D  SINTOTU   HYD  DER_EAST  -5.5035D-07   2.3414D-06  -1.6754D-05  -1.7697D-05  -9.5936D-06  -2.3657D-07  -1.1224D-05   7.3298D-07  -1.4854D-07  
D  SINTOTU   HYD  CHEB_0     7.6380D-09   4.7310D-11  -2.8070D-12  -7.6264D-12  -5.3262D-12  -7.9797D-13   5.3664D-13  -9.2675D-14   3.0716D-12  
D  SINTOTU   HYD  CHEB_1    -3.1709D-12   2.2122D-11   1.2728D-11  -6.6488D-13  -3.0090D-12  -5.4337D-13  -1.2301D-12  -1.6974D-13   5.7759D-13  
D  SINTOTU   HYD  CHEB_2    -2.2931D-12   3.5472D-12   2.0602D-12  -7.4563D-14  -3.4018D-13  -1.0322D-13  -2.5742D-13  -2.8680D-14   8.7435D-14  
D  SINTOTU   HYD  CHEB_3    -1.7434D-12  -5.6673D-13  -3.0466D-13   5.7431D-14   1.2580D-13   1.9115D-14   2.7669D-14   1.7717D-15  -1.9135D-15  
D  SINTOTU   HYD  CHEB_4    -7.2685D-13  -3.9037D-14  -2.8271D-14  -7.6787D-15   2.5700D-15   2.3082D-15   7.6796D-15   2.2248D-16  -2.6156D-15  
D  SINTOTU   HYD  CHEB_5    -8.9733D-14   1.8850D-14   1.1724D-14  -1.2585D-15  -7.4420D-15  -3.3317D-15  -2.7904D-15  -1.8904D-16  -1.8104D-16  
#
D  SINTOTU   NHY  DER_NORT   9.4344D-04   2.2066D-04   1.2279D-04  -5.0827D-04  -3.3595D-04  -3.7858D-05   1.1154D-04  -3.2754D-05  -3.5329D-04  
D  SINTOTU   NHY  DER_EAST   7.5149D-04   4.7034D-05  -1.3769D-04  -2.7186D-04  -4.3600D-04  -3.7384D-05   1.6758D-05   1.5460D-04  -2.8562D-04  
D  SINTOTU   NHY  CHEB_0     3.6175D-10  -2.8197D-10  -1.5459D-10   4.2641D-11   9.4947D-11   2.6872D-11  -3.2816D-11   6.2882D-12  -3.9773D-12  
D  SINTOTU   NHY  CHEB_1     2.1212D-11  -1.5638D-11  -8.5359D-12   2.5852D-12   4.8485D-12   1.0711D-12  -1.4083D-12   3.2674D-13  -3.2213D-13  
D  SINTOTU   NHY  CHEB_2     3.8044D-12  -2.6941D-12  -1.4861D-12   4.1626D-13   7.7341D-13   1.7107D-13  -1.7521D-13   5.5973D-14  -5.2330D-14  
D  SINTOTU   NHY  CHEB_3    -4.0158D-13   3.4343D-13   1.8559D-13  -6.7071D-14  -1.3554D-13  -3.4377D-14   5.9071D-14  -1.2582D-14   7.4472D-15  
D  SINTOTU   NHY  CHEB_4    -5.7885D-14   4.3828D-14   2.4872D-14  -5.3385D-15  -1.3899D-14  -4.1058D-15   3.1584D-15  -3.7805D-15  -6.8618D-17  
D  SINTOTU   NHY  CHEB_5    -9.0148D-15   5.8025D-15   4.4861D-15  -9.1313D-16  -2.2576D-15  -5.5742D-16   9.8285D-16  -7.6570D-16   1.1122D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SINTOTU3  HYD  DER_NORT   1.3725D-04   6.8283D-05  -7.4169D-06  -5.0962D-06  -1.6365D-05   2.7929D-08  -1.7017D-05  -1.3528D-06  -3.4551D-07  
D  SINTOTU3  HYD  DER_EAST  -5.5313D-07   2.3408D-06  -1.6756D-05  -1.7697D-05  -9.5939D-06  -2.3689D-07  -1.1225D-05   7.3284D-07  -1.5027D-07  
D  SINTOTU3  HYD  CHEB_0     7.6377D-09   4.7299D-11  -2.8102D-12  -7.6292D-12  -5.3251D-12  -7.9752D-13   5.3685D-13  -9.3958D-14   3.0700D-12  
D  SINTOTU3  HYD  CHEB_1    -3.1668D-12   2.2121D-11   1.2728D-11  -6.6491D-13  -3.0089D-12  -5.4334D-13  -1.2301D-12  -1.6974D-13   5.7740D-13  
D  SINTOTU3  HYD  CHEB_2    -2.2923D-12   3.5471D-12   2.0602D-12  -7.4585D-14  -3.4019D-13  -1.0323D-13  -2.5741D-13  -2.8683D-14   8.7403D-14  
D  SINTOTU3  HYD  CHEB_3    -1.7436D-12  -5.6666D-13  -3.0462D-13   5.7437D-14   1.2580D-13   1.9129D-14   2.7648D-14   1.7784D-15  -1.9166D-15  
D  SINTOTU3  HYD  CHEB_4    -7.2672D-13  -3.9060D-14  -2.8290D-14  -7.6877D-15   2.5609D-15   2.2942D-15   7.6954D-15   2.2009D-16  -2.6138D-15  
D  SINTOTU3  HYD  CHEB_5    -8.9821D-14   1.8864D-14   1.1738D-14  -1.2536D-15  -7.4373D-15  -3.3234D-15  -2.8003D-15  -1.8721D-16  -1.8248D-16  
#
D  SINTOTU3  NHY  DER_NORT   9.4342D-04   2.2066D-04   1.2278D-04  -5.0829D-04  -3.3594D-04  -3.7854D-05   1.1151D-04  -3.2764D-05  -3.5329D-04  
D  SINTOTU3  NHY  DER_EAST   7.5137D-04   4.7035D-05  -1.3773D-04  -2.7185D-04  -4.3598D-04  -3.7396D-05   1.6763D-05   1.5459D-04  -2.8559D-04  
D  SINTOTU3  NHY  CHEB_0     3.6171D-10  -2.8195D-10  -1.5458D-10   4.2638D-11   9.4939D-11   2.6870D-11  -3.2815D-11   6.2877D-12  -3.9774D-12  
D  SINTOTU3  NHY  CHEB_1     2.1210D-11  -1.5637D-11  -8.5353D-12   2.5852D-12   4.8483D-12   1.0710D-12  -1.4083D-12   3.2669D-13  -3.2218D-13  
D  SINTOTU3  NHY  CHEB_2     3.8041D-12  -2.6939D-12  -1.4861D-12   4.1627D-13   7.7340D-13   1.7104D-13  -1.7524D-13   5.5989D-14  -5.2350D-14  
D  SINTOTU3  NHY  CHEB_3    -4.0153D-13   3.4337D-13   1.8559D-13  -6.7051D-14  -1.3553D-13  -3.4367D-14   5.9076D-14  -1.2593D-14   7.4527D-15  
D  SINTOTU3  NHY  CHEB_4    -5.7872D-14   4.3846D-14   2.4844D-14  -5.3499D-15  -1.3892D-14  -4.1117D-15   3.1491D-15  -3.7645D-15  -7.2159D-17  
D  SINTOTU3  NHY  CHEB_5    -9.0267D-15   5.7918D-15   4.5052D-15  -9.0366D-16  -2.2599D-15  -5.4455D-16   9.8158D-16  -7.7994D-16   1.2009D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SNDPOINT  HYD  DER_NORT   5.7872D-05   1.9322D-05  -4.3660D-05  -1.7417D-05   1.2282D-05   1.2538D-06  -2.0258D-05   9.8455D-07  -7.6859D-08  
D  SNDPOINT  HYD  DER_EAST  -1.2289D-05   2.5202D-05  -1.0333D-05   2.0330D-05   1.6171D-05   4.0854D-05   5.1815D-05  -1.2921D-06   1.1899D-06  
D  SNDPOINT  HYD  CHEB_0     7.5968D-09  -3.3724D-11  -1.6009D-12  -1.2249D-11   4.8852D-12  -4.4474D-11   3.3710D-13   1.2816D-12   6.4786D-13  
D  SNDPOINT  HYD  CHEB_1     4.5183D-12   1.2899D-11   6.2646D-12  -1.2756D-12  -4.6574D-12   1.1300D-12  -5.3648D-13   8.2645D-14   3.5140D-13  
D  SNDPOINT  HYD  CHEB_2    -8.7054D-13   1.9590D-12   1.1067D-12  -1.3642D-13  -5.8061D-13   2.3543D-13  -9.7874D-14   6.4597D-16   5.2845D-14  
D  SNDPOINT  HYD  CHEB_3    -1.7957D-12  -3.1478D-13  -1.1708D-13   3.9040D-14   1.4923D-13  -8.7902D-15  -8.2587D-15   2.6484D-15  -9.2060D-15  
D  SNDPOINT  HYD  CHEB_4    -7.4887D-13  -5.4572D-15  -1.5374D-14  -4.6884D-15  -3.4935D-15  -2.0039D-15   4.3635D-15  -1.7962D-16   1.6249D-15  
D  SNDPOINT  HYD  CHEB_5    -1.0541D-13   8.3096D-15   3.7860D-15  -1.0184D-16  -4.7836D-15   2.0065D-15  -1.2865D-15  -3.0629D-16  -8.4079D-16  
#
D  SNDPOINT  NHY  DER_NORT   5.6758D-04   4.9885D-04   1.2782D-04   6.2746D-05   1.8441D-04  -1.4434D-04   1.2398D-05   8.6282D-05   1.9648D-05  
D  SNDPOINT  NHY  DER_EAST  -3.9957D-04  -3.7715D-04  -3.5695D-04   4.8969D-05   3.6128D-04   4.9798D-04   3.2605D-04  -4.8985D-05   5.6017D-05  
D  SNDPOINT  NHY  CHEB_0     2.7095D-10  -1.5255D-10  -7.9813D-11   2.3824D-11   5.1765D-11   1.5112D-11   1.7789D-12  -1.2368D-12  -9.6140D-13  
D  SNDPOINT  NHY  CHEB_1     1.5772D-11  -7.9266D-12  -4.4800D-12   1.1241D-12   2.3200D-12   8.8717D-13   5.4755D-13   1.2442D-14  -1.2652D-13  
D  SNDPOINT  NHY  CHEB_2     2.8868D-12  -1.3670D-12  -8.0716D-13   1.7824D-13   3.8763D-13   1.6300D-13   1.2889D-13   6.8303D-15  -1.8691D-14  
D  SNDPOINT  NHY  CHEB_3    -2.7606D-13   1.7483D-13   8.4636D-14  -3.0616D-14  -6.0764D-14  -1.5484D-14  -1.3338D-15   2.0367D-16   3.8391D-15  
D  SNDPOINT  NHY  CHEB_4    -4.2895D-14   2.3898D-14   1.1404D-14  -5.0572D-15  -7.8046D-15   9.5295D-16   1.7589D-15   4.0778D-16   5.2501D-16  
D  SNDPOINT  NHY  CHEB_5    -7.8402D-15   2.0825D-15   2.4868D-15   3.3119D-16  -1.8695D-15  -7.5987D-16  -1.7641D-15  -4.9723D-16  -2.7891D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SOURDOGH  HYD  DER_NORT   2.0459D-05   1.2673D-05  -2.9584D-06  -2.0823D-06   2.7644D-05   4.9335D-06   1.7273D-05  -1.5744D-06  -8.6470D-07  
D  SOURDOGH  HYD  DER_EAST   2.9960D-05  -2.1177D-07  -1.3853D-05   1.6383D-05   5.2892D-06   4.5596D-05   1.6476D-05  -1.7397D-06  -6.3133D-08  
D  SOURDOGH  HYD  CHEB_0     7.0290D-09  -3.5741D-11  -3.6611D-12  -1.0444D-11   6.6024D-12  -2.1359D-11   1.6057D-11   1.3155D-12   3.2112D-13  
D  SOURDOGH  HYD  CHEB_1     1.6920D-11   1.5306D-11   4.8616D-12  -3.3669D-12  -2.9730D-12  -1.5782D-12  -2.8682D-12   2.8074D-13   2.6356D-13  
D  SOURDOGH  HYD  CHEB_2     1.0362D-12   2.4888D-12   9.6693D-13  -5.5309D-13  -3.1903D-13  -3.8559D-13  -5.6660D-13   4.3045D-14   5.2809D-14  
D  SOURDOGH  HYD  CHEB_3    -1.9139D-12  -2.8677D-13  -3.9518D-14   5.8773D-14   1.3783D-13  -6.8240D-15   5.4327D-14  -2.8212D-15  -6.9459D-15  
D  SOURDOGH  HYD  CHEB_4    -6.8507D-13   5.7324D-15  -2.2729D-14  -1.1030D-15  -3.9779D-15   1.8766D-14   1.7059D-14   1.6868D-15   1.6088D-15  
D  SOURDOGH  HYD  CHEB_5    -9.9531D-14  -4.2815D-15  -1.1526D-15   8.3448D-15  -8.4600D-15   2.0116D-15  -9.0527D-15  -9.7844D-16  -8.7213D-17  
#
D  SOURDOGH  NHY  DER_NORT  -2.3118D-04   6.3523D-04   1.4708D-04   4.9354D-05   5.9234D-04  -2.3335D-04   2.0763D-04   2.5771D-04   9.5782D-05  
D  SOURDOGH  NHY  DER_EAST  -3.8157D-05  -3.4090D-04  -1.1152D-04   3.2736D-04   4.3321D-05   2.8775D-04   2.8635D-04   4.5645D-05  -2.2247D-04  
D  SOURDOGH  NHY  CHEB_0     2.1397D-10  -1.5981D-10  -6.1346D-11   4.8346D-11   3.1187D-11   1.1051D-11   1.6100D-11  -3.1440D-12  -4.9708D-12  
D  SOURDOGH  NHY  CHEB_1     1.3055D-11  -9.8316D-12  -3.6355D-12   2.9061D-12   1.6986D-12   7.1860D-13   9.8919D-13  -2.9677D-13  -2.6250D-13  
D  SOURDOGH  NHY  CHEB_2     2.4326D-12  -1.8302D-12  -6.7259D-13   5.2756D-13   2.9391D-13   1.2706D-13   1.8674D-13  -8.7679D-14  -2.3240D-14  
D  SOURDOGH  NHY  CHEB_3    -1.9934D-13   1.4788D-13   5.7585D-14  -4.8349D-14  -3.5395D-14  -1.5602D-14  -1.4746D-14  -8.7297D-15   1.1112D-14  
D  SOURDOGH  NHY  CHEB_4    -3.0244D-14   2.2452D-14   7.4136D-15  -8.2641D-15  -3.8899D-15   1.0818D-17  -1.9464D-15   1.5826D-15  -7.4132D-16  
D  SOURDOGH  NHY  CHEB_5    -5.8986D-15   4.9542D-15   1.7696D-15  -9.7854D-16  -6.5736D-16  -2.8723D-16  -3.7956D-16   3.8716D-16  -4.9297D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SUWON     HYD  DER_NORT   1.4601D-04   5.8343D-05   3.3125D-05  -4.9342D-06  -1.7394D-05  -1.9748D-06  -2.0591D-05  -8.5709D-07   6.7047D-07  
D  SUWON     HYD  DER_EAST   1.0833D-05  -5.0803D-06  -1.8819D-05   4.6574D-06   3.8544D-06  -2.0138D-07  -7.9849D-06  -3.1313D-07  -1.0362D-07  
D  SUWON     HYD  CHEB_0     7.6823D-09   8.7333D-11   7.4226D-12  -1.8730D-12  -3.2081D-12   5.3464D-12   1.5535D-13  -3.8148D-12   3.8723D-12  
D  SUWON     HYD  CHEB_1    -1.4075D-11   2.0034D-11   9.8497D-12  -6.1875D-13  -2.7364D-12   2.8972D-13  -3.8598D-13  -5.6045D-13   4.5333D-13  
D  SUWON     HYD  CHEB_2    -4.2823D-12   3.0955D-12   1.5650D-12   2.3024D-14  -3.1414D-13   7.4893D-14  -1.1921D-13  -8.6521D-14   8.1434D-14  
D  SUWON     HYD  CHEB_3    -1.5132D-12  -5.5367D-13  -2.6748D-13   6.7827D-14   1.1745D-13   1.3950D-15  -3.7541D-16   1.1174D-14   1.7720D-16  
D  SUWON     HYD  CHEB_4    -7.1825D-13  -2.6872D-14  -1.4950D-14   1.8194D-16   1.0129D-15  -3.8752D-15   6.2271D-15  -1.2212D-15  -1.7882D-15  
D  SUWON     HYD  CHEB_5    -9.2994D-14   7.0559D-15   5.1908D-15  -5.2233D-15  -5.4431D-15   7.1420D-16  -2.1627D-15   9.2366D-16   1.6247D-15  
#
D  SUWON     NHY  DER_NORT   1.2484D-03   1.0687D-03  -5.5921D-04   7.8517D-04   2.6781D-04  -3.0992D-05  -5.4620D-04  -1.2098D-04   3.1730D-04  
D  SUWON     NHY  DER_EAST   1.8290D-04   4.2771D-06   2.2500D-04  -2.9364D-04   8.5578D-05  -6.4377D-05  -1.6395D-04   1.8697D-04  -1.8745D-04  
D  SUWON     NHY  CHEB_0     4.4040D-10  -3.7231D-10  -1.7368D-10   9.2735D-11   1.1852D-10  -3.0824D-11  -7.4722D-11   1.6652D-12   4.1403D-12  
D  SUWON     NHY  CHEB_1     2.3946D-11  -1.8946D-11  -8.8047D-12   4.1447D-12   5.1207D-12  -2.0915D-12  -2.6550D-12   2.9062D-13  -1.9274D-13  
D  SUWON     NHY  CHEB_2     4.2361D-12  -3.2066D-12  -1.5101D-12   6.2474D-13   7.7239D-13  -3.6549D-13  -3.1432D-13   4.9554D-14  -3.8641D-14  
D  SUWON     NHY  CHEB_3    -4.6829D-13   4.3660D-13   1.9474D-13  -1.2726D-13  -1.5621D-13   4.8572D-14   1.0871D-13  -2.9984D-15   3.8631D-15  
D  SUWON     NHY  CHEB_4    -7.4530D-14   6.0078D-14   2.6687D-14  -1.6362D-14  -1.8068D-14   3.5976D-15   1.6617D-14  -3.7344D-15  -5.4569D-15  
D  SUWON     NHY  CHEB_5    -4.3653D-15   2.8111D-15   3.1182D-15   1.0976D-15   6.4981D-16   1.8505D-15  -5.7282D-15   2.9071D-15   5.9287D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SVETLOE   HYD  DER_NORT   1.0769D-04   4.9024D-05   4.9663D-06   8.8886D-06  -4.1195D-05   7.2916D-06  -2.0026D-08   3.5773D-07   2.9807D-07  
D  SVETLOE   HYD  DER_EAST  -2.9340D-05  -9.7813D-06  -8.7757D-06   1.1044D-06  -3.5624D-06  -1.1003D-05  -5.6691D-06  -4.1995D-07  -1.9352D-07  
D  SVETLOE   HYD  CHEB_0     7.6173D-09  -6.2232D-12   1.5428D-11  -2.0445D-11   4.6026D-12  -1.7415D-11  -2.0429D-12   1.6677D-13   8.6667D-14  
D  SVETLOE   HYD  CHEB_1     4.0077D-12   1.8197D-11   8.3113D-12  -4.7113D-13   6.6189D-13  -1.0868D-12   1.6703D-12  -2.5528D-13  -3.7950D-13  
D  SVETLOE   HYD  CHEB_2    -1.7803D-12   2.3151D-12   1.2136D-12  -6.3399D-14   1.0350D-13  -2.0509D-13   2.4150D-13  -2.3120D-14  -6.5299D-14  
D  SVETLOE   HYD  CHEB_3    -1.9601D-12  -5.5139D-13  -2.3282D-13   1.7397D-14  -1.8421D-14   1.8500D-14  -4.2725D-14  -2.0525D-16   8.1668D-15  
D  SVETLOE   HYD  CHEB_4    -6.9628D-13   3.8885D-14  -4.7021D-15   1.8563D-15  -1.0189D-15   4.1231D-15   1.6222D-15  -2.7037D-16  -6.9588D-16  
D  SVETLOE   HYD  CHEB_5    -1.0738D-13   3.6486D-15   5.7099D-15   2.9860D-16  -1.7530D-15   2.2138D-16   1.4133D-15   8.1950D-16   3.6159D-16  
#
D  SVETLOE   NHY  DER_NORT   5.6436D-04   2.0760D-04  -3.0598D-04  -8.9132D-05  -3.4106D-04   9.5443D-05   5.7761D-05   1.1958D-05  -1.9660D-04  
D  SVETLOE   NHY  DER_EAST   1.7108D-04  -3.8654D-04   6.4432D-05  -2.7612D-04   3.2736D-04  -8.8034D-05   2.4758D-04  -2.3619D-04   2.3234D-05  
D  SVETLOE   NHY  CHEB_0     3.1448D-10  -1.4927D-10  -9.8851D-11   1.2613D-11   1.1915D-11   1.2026D-11  -1.6206D-12  -2.0112D-12   2.3267D-12  
D  SVETLOE   NHY  CHEB_1     1.8343D-11  -8.4795D-12  -5.7636D-12   5.3716D-13   1.0608D-12   7.3311D-13  -3.7513D-13   2.7118D-14  -1.0775D-13  
D  SVETLOE   NHY  CHEB_2     3.3645D-12  -1.5325D-12  -1.0579D-12   8.2304D-14   2.0659D-13   1.5540D-13  -9.1040D-14   2.1963D-14  -2.7820D-14  
D  SVETLOE   NHY  CHEB_3    -3.1342D-13   1.5119D-13   1.0159D-13  -1.3953D-14  -1.2962D-14  -3.2726D-15  -1.3692D-15   4.3537D-15  -1.2858D-15  
D  SVETLOE   NHY  CHEB_4    -5.3607D-14   2.8969D-14   1.7516D-14  -1.2553D-15  -3.7131D-15  -5.2175D-15  -1.9079D-15   1.4470D-15   5.7269D-17  
D  SVETLOE   NHY  CHEB_5    -7.5082D-15   1.7698D-15   3.5407D-15  -3.4700D-16  -8.3999D-16   4.2758D-16   1.9379D-15  -9.9974D-16   1.9433D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  SYOWA     HYD  DER_NORT  -4.4675D-05   1.4569D-05   1.2815D-05   2.8418D-05  -1.4834D-05   2.1174D-05   1.3216D-05  -1.0644D-06  -6.4087D-07  
D  SYOWA     HYD  DER_EAST   1.7674D-05  -9.3485D-06   1.1868D-05  -1.2045D-05   6.7074D-06   7.7027D-06   7.0077D-06  -5.7292D-07   1.8634D-07  
D  SYOWA     HYD  CHEB_0     7.5106D-09  -2.8485D-11   2.7262D-12   1.1907D-11   1.2793D-11   1.6096D-11  -7.1375D-12   4.2317D-13   1.5616D-12  
D  SYOWA     HYD  CHEB_1     3.4881D-11  -1.0464D-11  -9.5514D-12  -3.1379D-12  -1.0717D-12  -2.0721D-12   2.4017D-13   1.1412D-14   1.6637D-14  
D  SYOWA     HYD  CHEB_2     2.8358D-12  -7.2717D-13  -8.1154D-13  -4.1503D-13  -5.1536D-14  -3.2469D-13   6.0723D-14   7.4775D-15   2.5919D-15  
D  SYOWA     HYD  CHEB_3    -2.7759D-12   4.4499D-13   4.3028D-13   7.9824D-14   3.8365D-14   4.9876D-14   7.6387D-15  -1.2341D-15  -2.1553D-15  
D  SYOWA     HYD  CHEB_4    -7.0132D-13  -6.2640D-14  -4.3641D-14  -6.4272D-15  -1.2159D-14   1.8419D-15  -2.4071D-15  -1.0131D-17   3.0584D-16  
D  SYOWA     HYD  CHEB_5    -7.2810D-14  -1.3520D-15  -7.0977D-15  -1.2605D-15   5.3727D-15  -6.3780D-15  -3.9852D-15  -4.8997D-16  -2.0500D-16  
#
D  SYOWA     NHY  DER_NORT  -3.9307D-03   4.8081D-05   4.8738D-04  -3.5857D-04   1.8879D-04   6.0292D-06   1.4094D-03   1.7865D-04  -8.3463D-05  
D  SYOWA     NHY  DER_EAST  -2.1606D-03   3.4888D-04   2.8561D-04  -6.6491D-04   7.9126D-04   2.8107D-04   5.8323D-04   2.8503D-04  -4.3888D-05  
D  SYOWA     NHY  CHEB_0     7.9387D-11   2.7121D-11   2.6252D-11   6.3757D-12   8.3281D-12   5.1694D-12   3.8181D-12  -5.7946D-13  -2.9219D-13  
D  SYOWA     NHY  CHEB_1     4.3740D-12   1.7678D-12   1.4551D-12   4.5195D-13   5.4948D-13   2.5176D-13   2.4647D-13  -1.3190D-14  -2.3994D-14  
D  SYOWA     NHY  CHEB_2     7.8617D-13   3.3512D-13   2.5967D-13   9.2481D-14   9.9235D-14   4.7508D-14   4.2262D-14   1.6763D-15   1.2166D-15  
D  SYOWA     NHY  CHEB_3    -8.4738D-14  -2.5886D-14  -2.7196D-14  -4.6816D-15  -8.9919D-15  -3.6672D-15  -4.7810D-15   1.9581D-15   3.2470D-15  
D  SYOWA     NHY  CHEB_4    -1.5366D-14  -5.2717D-15  -3.8094D-15  -1.3122D-15   2.7623D-16  -1.6458D-16   8.0407D-16  -3.2919D-16   1.7793D-16  
D  SYOWA     NHY  CHEB_5    -1.0862D-15  -1.6364D-16  -2.2833D-16  -2.2293D-16  -2.3935D-16  -3.3718D-16  -2.9092D-16   1.7196D-16   2.4129D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TATEYAMA  HYD  DER_NORT   1.5490D-04   7.6069D-05   5.3471D-05   1.2375D-05  -2.6832D-05  -4.7892D-06  -1.2415D-05   1.5433D-06  -1.9643D-06  
D  TATEYAMA  HYD  DER_EAST  -6.1201D-05   2.9117D-06  -1.0862D-05  -5.2446D-06  -1.4543D-05   5.5591D-06  -1.4729D-06   1.5251D-07  -1.8627D-06  
D  TATEYAMA  HYD  CHEB_0     7.6364D-09   5.3351D-11   9.4944D-12  -2.5612D-12  -5.5655D-12  -3.2590D-13  -8.0386D-13  -1.9013D-12   3.2012D-12  
D  TATEYAMA  HYD  CHEB_1    -1.9226D-11   1.5134D-11   1.1090D-11  -7.9344D-13  -1.5510D-12  -4.5236D-13   3.4200D-13  -3.3333D-13   3.9583D-13  
D  TATEYAMA  HYD  CHEB_2    -5.2303D-12   2.2901D-12   1.6791D-12  -5.0314D-14  -1.8510D-13  -3.2860D-14   6.0234D-14  -5.6817D-14   5.4127D-14  
D  TATEYAMA  HYD  CHEB_3    -1.2449D-12  -3.9453D-13  -3.0610D-13   3.9255D-14   4.4811D-14   1.7509D-14  -1.8437D-14   6.6066D-15  -9.0723D-15  
D  TATEYAMA  HYD  CHEB_4    -7.2579D-13  -3.3416D-14  -1.0388D-14  -1.9414D-15   7.8056D-15  -5.4902D-15   2.6736D-15  -3.0892D-17  -5.0225D-17  
D  TATEYAMA  HYD  CHEB_5    -1.1185D-13   8.6470D-15   3.6887D-15   1.0972D-15  -2.1921D-15   1.3143D-15  -9.8099D-16   1.4698D-15   8.3182D-16  
#
D  TATEYAMA  NHY  DER_NORT   1.2877D-03   1.5964D-03   1.1957D-04   3.3979D-04   5.0303D-04   1.1419D-05   3.2844D-04  -5.6229D-04   4.2016D-04  
D  TATEYAMA  NHY  DER_EAST   2.3907D-04   8.1548D-04  -4.8313D-05  -4.1045D-04  -1.1845D-04   1.4001D-04  -8.9056D-05  -2.3933D-04  -2.6815D-05  
D  TATEYAMA  NHY  CHEB_0     5.5917D-10  -3.4966D-10  -2.3901D-10   5.1972D-11   1.1193D-10  -1.2271D-11  -5.0027D-11   5.2082D-12   7.4808D-12  
D  TATEYAMA  NHY  CHEB_1     3.0275D-11  -1.6166D-11  -1.2051D-11   1.2259D-12   4.4478D-12  -1.3297D-13  -1.6886D-12   6.9441D-13  -5.2524D-13  
D  TATEYAMA  NHY  CHEB_2     5.3399D-12  -2.5911D-12  -2.0137D-12   8.2236D-14   6.0356D-13   2.5853D-15  -1.8361D-13   1.8278D-13  -3.4413D-14  
D  TATEYAMA  NHY  CHEB_3    -6.1423D-13   4.4113D-13   2.9260D-13  -7.7946D-14  -1.6883D-13   1.3721D-14   7.4621D-14   1.8791D-15   2.7687D-14  
D  TATEYAMA  NHY  CHEB_4    -9.3436D-14   5.6554D-14   4.6390D-14  -4.2907D-15  -2.2482D-14  -2.2165D-15   7.2527D-15  -5.6332D-15  -3.0026D-15  
D  TATEYAMA  NHY  CHEB_5    -1.1760D-14   6.3886D-15   2.8425D-15   1.8427D-17  -2.7284D-16   1.8950D-16  -7.5814D-16  -1.2597D-16  -1.1823D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TIDBIN64  HYD  DER_NORT  -1.1503D-04   5.7402D-06   1.7107D-05   7.4472D-06   7.2927D-06  -2.9623D-06   3.8158D-06   2.9636D-06   2.2114D-06  
D  TIDBIN64  HYD  DER_EAST  -6.5183D-06   5.4328D-06   7.9365D-06  -1.0487D-07  -6.3270D-06   9.6889D-06   1.2517D-05  -3.5557D-07  -1.5822D-06  
D  TIDBIN64  HYD  CHEB_0     7.1707D-09  -2.5393D-11  -9.2764D-12  -1.0777D-11   2.1985D-12   8.5193D-12  -5.2049D-12  -8.9905D-13   6.9129D-12  
D  TIDBIN64  HYD  CHEB_1    -6.9910D-12  -9.1714D-12  -3.4984D-12   1.9089D-12  -9.7636D-13  -5.1793D-13  -6.2168D-13  -1.6790D-13   7.6094D-13  
D  TIDBIN64  HYD  CHEB_2    -3.2319D-12  -1.5140D-12  -6.0884D-13   3.1988D-13  -1.1252D-13  -1.2875D-13  -9.8556D-14  -2.6272D-14   1.3587D-13  
D  TIDBIN64  HYD  CHEB_3    -1.5681D-12   2.0100D-13   7.8466D-14  -3.6849D-14   4.0043D-14  -2.8669D-15   2.1296D-14   6.2537D-15  -8.2451D-15  
D  TIDBIN64  HYD  CHEB_4    -6.4843D-13   9.0667D-15   8.3193D-15   1.5423D-15  -2.1747D-15   3.4316D-15   1.3164D-15  -1.6839D-15   7.0370D-16  
D  TIDBIN64  HYD  CHEB_5    -1.0031D-13   2.0399D-15  -9.2350D-16  -2.5270D-15  -1.2208D-15  -1.4698D-15  -8.5571D-17   8.2477D-16   1.2018D-16  
#
D  TIDBIN64  NHY  DER_NORT   8.3166D-04  -3.8135D-04  -3.9033D-04  -4.9102D-05   2.5906D-04   3.3854D-04   8.0476D-05   4.3456D-05  -2.9129D-04  
D  TIDBIN64  NHY  DER_EAST  -2.2281D-04   3.8335D-04  -6.1861D-05   2.3450D-04  -3.1965D-04  -2.5428D-04   3.8925D-05   7.4605D-06  -1.5162D-04  
D  TIDBIN64  NHY  CHEB_0     3.3114D-10   1.1733D-10   8.8415D-11   1.8648D-11   3.5179D-11  -8.2369D-13   1.6026D-11   9.7611D-12  -1.4265D-12  
D  TIDBIN64  NHY  CHEB_1     2.0461D-11   5.5923D-12   5.1357D-12   6.5897D-13   1.8957D-12  -1.9668D-13   6.3381D-13   3.2637D-13   2.4449D-13  
D  TIDBIN64  NHY  CHEB_2     3.7604D-12   8.5089D-13   9.0205D-13   6.4151D-14   3.0143D-13  -4.8491D-14   1.0483D-13   6.8709D-14   1.3094D-13  
D  TIDBIN64  NHY  CHEB_3    -3.4320D-13  -1.6982D-13  -1.0426D-13  -3.2620D-14  -4.3294D-14   2.5153D-15  -1.6568D-14  -2.9448D-15   2.6406D-14  
D  TIDBIN64  NHY  CHEB_4    -4.9687D-14  -1.6395D-14  -1.4243D-14  -2.4891D-15  -9.3223D-15  -4.1918D-16  -2.2232D-15  -4.1288D-15   3.0809D-15  
D  TIDBIN64  NHY  CHEB_5    -9.7586D-15  -1.7325D-15  -1.9043D-15  -3.0716D-17   2.7312D-15   1.5782D-15  -5.3686D-16   2.2876D-16  -3.2179D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TIGOCONC  HYD  DER_NORT  -1.0164D-04   2.2162D-05   2.4215D-05  -1.6161D-05   4.0986D-06   7.2562D-06   6.9869D-06   1.0307D-06  -2.1498D-06  
D  TIGOCONC  HYD  DER_EAST   5.9456D-05   3.5235D-06   2.0331D-07  -1.4733D-06  -8.0570D-06  -3.4321D-06  -1.7976D-06   7.7282D-08  -1.4248D-06  
D  TIGOCONC  HYD  CHEB_0     7.5994D-09  -2.0652D-11  -1.0391D-11  -1.5639D-12  -5.9948D-12   6.1391D-13   2.5489D-12  -1.0868D-13   3.5294D-14  
D  TIGOCONC  HYD  CHEB_1    -1.4715D-11  -7.0786D-12  -2.9928D-12   4.7079D-13  -1.6327D-12  -4.7843D-13   9.1524D-14   3.1394D-13  -2.3565D-13  
D  TIGOCONC  HYD  CHEB_2    -4.2761D-12  -1.0574D-12  -5.5227D-13   6.1072D-14  -2.4733D-13  -1.0484D-13   1.1863D-14   5.7523D-14  -4.9785D-14  
D  TIGOCONC  HYD  CHEB_3    -1.4747D-12   1.9788D-13   5.6878D-14  -1.5511D-14   3.9882D-14   4.0760D-15  -1.8706D-15  -1.4157D-15   7.0665D-15  
D  TIGOCONC  HYD  CHEB_4    -7.4295D-13   1.2862D-15   1.1193D-14  -7.8206D-16   2.7808D-15   5.8168D-15   1.9089D-15   1.6570D-15  -3.5515D-15  
D  TIGOCONC  HYD  CHEB_5    -9.3681D-14   2.1261D-15   2.1256D-16   1.7671D-15  -1.9866D-15  -3.0615D-15  -2.4194D-15  -3.9678D-16   1.3070D-15  
#
D  TIGOCONC  NHY  DER_NORT   9.4594D-04   7.8227D-04   1.9988D-04   2.6359D-04   7.6101D-05  -3.0932D-04   4.0268D-05  -3.6079D-04   1.3688D-04  
D  TIGOCONC  NHY  DER_EAST   1.9492D-03   8.9843D-04   1.1181D-05  -3.6759D-04   1.9150D-04  -6.0874D-05   3.2474D-05  -5.4253D-04   2.8664D-05  
D  TIGOCONC  NHY  CHEB_0     3.2072D-10   2.2103D-11   3.4454D-11   5.4318D-12   1.5363D-11  -7.0530D-12  -1.6165D-11  -1.6446D-12  -2.1161D-12  
D  TIGOCONC  NHY  CHEB_1     1.9253D-11   1.6235D-12   1.8359D-12   5.5905D-13   7.8450D-13  -5.6821D-13  -4.0644D-13  -1.0902D-13  -1.0180D-13  
D  TIGOCONC  NHY  CHEB_2     3.5742D-12   3.3990D-13   3.2241D-13   1.2821D-13   1.3264D-13  -1.1312D-13  -2.5163D-14  -3.2147D-14  -3.3826D-15  
D  TIGOCONC  NHY  CHEB_3    -3.1304D-13  -6.5762D-15  -4.2562D-14  -5.6434D-15  -1.4780D-14   3.6619D-15   2.5148D-14   3.0187D-16   7.9943D-15  
D  TIGOCONC  NHY  CHEB_4    -4.2658D-14  -4.1260D-15  -3.7565D-15   1.6838D-16  -4.0545D-15   3.1303D-15   1.5215D-15  -3.1807D-15  -1.6278D-16  
D  TIGOCONC  NHY  CHEB_5    -1.4078D-14  -8.4363D-16  -2.0269D-15  -1.2381D-15   2.4833D-16  -8.4758D-16  -8.4294D-16   2.2908D-15   4.3659D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TIGOWTZL  HYD  DER_NORT   9.8140D-05   4.2561D-05  -1.7483D-05   3.0557D-05   1.8123D-05  -4.3329D-06   1.4175D-05  -4.8937D-07   1.8779D-07  
D  TIGOWTZL  HYD  DER_EAST  -1.3014D-05  -2.2352D-05  -5.5700D-06  -9.9882D-07  -5.3416D-06  -5.5335D-06  -1.1711D-05   1.4390D-06  -8.8346D-07  
D  TIGOWTZL  HYD  CHEB_0     7.1989D-09   1.8942D-11  -4.6102D-12   8.2197D-12  -7.7047D-12   1.0013D-11  -1.4286D-11  -1.1209D-13  -1.7291D-12  
D  TIGOWTZL  HYD  CHEB_1    -1.4725D-13   1.0912D-11   6.2032D-12  -1.0099D-12   6.1151D-13  -1.3349D-13  -3.1294D-13  -7.1468D-14  -5.4332D-13  
D  TIGOWTZL  HYD  CHEB_2    -2.1029D-12   1.4445D-12   9.3251D-13  -1.2494D-13   2.3149D-13  -3.7710D-14  -3.8567D-14  -2.9839D-14  -9.4442D-14  
D  TIGOWTZL  HYD  CHEB_3    -1.7660D-12  -3.2755D-13  -1.7166D-13   3.0699D-14   1.7324D-14  -5.6979D-15   7.7975D-15   2.7555D-16   8.2922D-15  
D  TIGOWTZL  HYD  CHEB_4    -6.7167D-13   1.9050D-14  -2.7437D-15  -1.7756D-15  -1.1294D-14  -1.2346D-15   3.1437D-15  -6.1406D-16  -7.7647D-16  
D  TIGOWTZL  HYD  CHEB_5    -9.2376D-14  -2.5809D-17   2.8503D-15  -5.2470D-16   2.6279D-15   1.8400D-15   2.5957D-15   7.7778D-16  -8.9477D-17  
#
D  TIGOWTZL  NHY  DER_NORT   9.8195D-04  -4.1930D-04  -5.4726D-05  -2.0639D-05   4.0310D-05   9.0544D-05   4.7350D-04  -1.6392D-04  -1.9224D-04  
D  TIGOWTZL  NHY  DER_EAST   3.1568D-04  -5.5643D-04   3.0365D-04   1.4824D-04   2.3095D-04   1.0097D-04  -1.0383D-04   1.6676D-04  -5.0313D-06  
D  TIGOWTZL  NHY  CHEB_0     3.3851D-10  -1.3397D-10  -7.0691D-11   3.3459D-11   4.8996D-12  -1.2389D-11   2.0521D-11  -3.9096D-12   3.3299D-12  
D  TIGOWTZL  NHY  CHEB_1     2.0482D-11  -7.9307D-12  -3.6305D-12   1.8731D-12   2.7591D-13  -5.4870D-13   1.3299D-12  -1.8035D-13   1.9583D-13  
D  TIGOWTZL  NHY  CHEB_2     3.7936D-12  -1.4323D-12  -6.3491D-13   3.2008D-13   5.2478D-14  -7.4164D-14   2.3838D-13  -3.7432D-14   3.3945D-14  
D  TIGOWTZL  NHY  CHEB_3    -3.3693D-13   1.5525D-13   7.3966D-14  -4.4637D-14  -1.9160D-15   1.9012D-14  -2.8098D-14   2.4243D-15  -4.6052D-15  
D  TIGOWTZL  NHY  CHEB_4    -5.1581D-14   2.1874D-14   9.0304D-15  -4.9540D-15  -6.5598D-16   2.4899D-16  -2.9773D-15  -9.2570D-16  -1.1946D-15  
D  TIGOWTZL  NHY  CHEB_5    -1.1641D-14   6.4798D-15   2.1064D-15  -1.6730D-15  -1.8501D-16  -3.4776D-16  -1.8937D-15   1.4874D-15  -5.6813D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TITIJIMA  HYD  DER_NORT   7.5444D-05   5.6967D-05   6.5680D-05   5.1308D-06  -9.7219D-06   1.6259D-06   3.6728D-06  -1.3127D-07   8.8007D-07  
D  TITIJIMA  HYD  DER_EAST  -1.8288D-05   3.2581D-06  -5.0105D-06  -2.9145D-06  -7.5638D-06   8.0931D-06  -1.9812D-07  -3.2884D-07  -3.2751D-07  
D  TITIJIMA  HYD  CHEB_0     7.6622D-09   3.6817D-11   2.2997D-11   8.5671D-12  -4.4037D-12  -2.4024D-12  -5.4646D-12  -5.3519D-13   7.6464D-13  
D  TITIJIMA  HYD  CHEB_1    -3.5458D-11   6.3241D-12   5.8069D-12  -9.7463D-13   9.2358D-13  -7.3264D-13   1.0686D-13  -1.9435D-13   2.2882D-13  
D  TITIJIMA  HYD  CHEB_2    -6.8944D-12   8.9521D-13   9.0662D-13  -1.3726D-13   2.1228D-13  -1.0852D-13   4.6425D-14  -1.7041D-14   3.1297D-14  
D  TITIJIMA  HYD  CHEB_3    -9.5099D-13  -1.7544D-13  -1.3959D-13   3.1618D-14  -4.2097D-15   2.0920D-14   1.4677D-14   6.5119D-15  -5.5254D-15  
D  TITIJIMA  HYD  CHEB_4    -7.6404D-13   2.5500D-15  -1.5130D-15   5.0526D-16  -3.5635D-15  -1.7332D-15  -1.8805D-15  -5.2967D-16   9.7315D-17  
D  TITIJIMA  HYD  CHEB_5    -7.5706D-14   1.8030D-16  -3.9142D-16  -1.4806D-16  -4.5165D-16   7.9816D-16   1.7075D-15  -9.2872D-16   2.2270D-16  
#
D  TITIJIMA  NHY  DER_NORT   1.1006D-03   4.4139D-04   5.3973D-04  -2.2848D-04  -4.3551D-04   5.8213D-04   3.1705D-06   1.6166D-04  -9.4116D-05  
D  TITIJIMA  NHY  DER_EAST  -1.7104D-04   3.1956D-05  -1.3019D-04   1.1132D-04  -2.0168D-04  -5.7163D-05   1.0138D-04   1.0686D-04  -2.9507D-05  
D  TITIJIMA  NHY  CHEB_0     7.9678D-10  -2.2186D-10  -2.0488D-10   9.5907D-12  -2.1791D-11   1.7534D-11  -1.4110D-11   3.3398D-12  -1.8385D-12  
D  TITIJIMA  NHY  CHEB_1     4.2601D-11  -9.7077D-12  -1.0255D-11   3.2375D-13  -8.9770D-13  -1.5158D-13  -9.6649D-13  -1.1595D-13   1.8039D-13  
D  TITIJIMA  NHY  CHEB_2     7.3985D-12  -1.4947D-12  -1.6719D-12  -3.1681D-15  -1.4293D-13  -3.7333D-14  -1.3591D-13  -3.6143D-14   2.8893D-14  
D  TITIJIMA  NHY  CHEB_3    -8.6671D-13   2.7601D-13   2.3007D-13  -2.1183D-14   2.4416D-14  -1.3506D-14   3.0270D-14  -8.1956D-15   1.4237D-15  
D  TITIJIMA  NHY  CHEB_4    -1.4713D-13   3.7280D-14   4.8904D-14  -2.4108D-15   9.9987D-15  -4.9156D-15  -4.8044D-15   2.7527D-16  -8.2514D-16  
D  TITIJIMA  NHY  CHEB_5    -6.4534D-15   2.2872D-15  -6.1139D-15   2.0060D-16  -8.1885D-17  -9.9170D-16   2.5471D-15   6.3373D-16   1.0841D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TOMAKO11  HYD  DER_NORT   1.2619D-04   6.8607D-05   4.0659D-07  -3.7996D-06  -1.5410D-05   2.9142D-07  -1.7591D-05  -7.8937D-07  -9.2596D-07  
D  TOMAKO11  HYD  DER_EAST  -4.3732D-05  -3.7378D-06  -1.5791D-05  -1.6670D-05  -1.0220D-05   1.9853D-06  -1.0999D-05   1.8155D-07  -2.3427D-06  
D  TOMAKO11  HYD  CHEB_0     7.6633D-09   4.7333D-11  -1.4943D-12  -7.5062D-12  -5.5225D-12  -1.5657D-12   4.7436D-14  -1.6682D-13   2.6947D-12  
D  TOMAKO11  HYD  CHEB_1    -4.0951D-12   2.1624D-11   1.2984D-11  -6.6994D-13  -2.8420D-12  -6.6162D-13  -1.2234D-12  -1.7809D-13   5.1101D-13  
D  TOMAKO11  HYD  CHEB_2    -2.7967D-12   3.3892D-12   2.0664D-12  -1.2722D-14  -3.0924D-13  -1.0387D-13  -2.2855D-13  -2.9247D-14   8.0445D-14  
D  TOMAKO11  HYD  CHEB_3    -1.6862D-12  -5.5606D-13  -3.3204D-13   4.0391D-14   1.1170D-13   6.8201D-15   2.3936D-14   5.8661D-15  -1.0655D-14  
D  TOMAKO11  HYD  CHEB_4    -6.7249D-13  -7.7611D-15  -4.1691D-15  -1.0225D-14  -9.1002D-15   2.4923D-16   1.6172D-15  -1.4037D-15  -4.4873D-16  
D  TOMAKO11  HYD  CHEB_5    -1.3698D-13   3.1268D-15   6.2107D-15   3.5951D-15   3.2759D-15   1.2494D-15   1.2855D-15   7.1158D-16   4.3903D-16  
#
D  TOMAKO11  NHY  DER_NORT   5.2581D-04   1.6951D-04  -4.9160D-04  -1.5611D-04  -3.0042D-04  -2.0534D-04   5.7411D-05  -5.0440D-05   1.6678D-04  
D  TOMAKO11  NHY  DER_EAST  -3.9325D-04   2.5574D-04  -2.8723D-04  -3.2591D-04  -2.5936D-04  -1.6835D-04  -1.0204D-05   2.0508D-04  -4.8269D-06  
D  TOMAKO11  NHY  CHEB_0     3.7212D-10  -2.8495D-10  -1.5911D-10   3.8890D-11   9.3984D-11   2.5647D-11  -2.9829D-11   4.6234D-12  -1.7170D-12  
D  TOMAKO11  NHY  CHEB_1     2.1312D-11  -1.4952D-11  -8.4157D-12   2.1456D-12   4.3261D-12   1.0034D-12  -1.1742D-12   1.9022D-13  -3.2845D-14  
D  TOMAKO11  NHY  CHEB_2     3.8322D-12  -2.5946D-12  -1.4741D-12   3.8051D-13   7.0251D-13   1.4553D-13  -1.6402D-13   1.2793D-14  -3.0651D-15  
D  TOMAKO11  NHY  CHEB_3    -3.9858D-13   3.2518D-13   1.7562D-13  -4.7243D-14  -1.1870D-13  -3.9953D-14   4.7088D-14  -1.0329D-14  -4.4025D-15  
D  TOMAKO11  NHY  CHEB_4    -6.1296D-14   4.3748D-14   2.5910D-14  -3.8913D-15  -9.8880D-15   2.5241D-15   9.0456D-16  -2.0492D-15  -8.2145D-16  
D  TOMAKO11  NHY  CHEB_5    -7.7435D-15   6.7106D-15   3.3769D-15  -3.1394D-15  -4.2827D-15  -3.1788D-15   2.7617D-15   1.4418D-15  -1.0236D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TORUN     HYD  DER_NORT   1.2840D-04   6.1577D-05  -9.3105D-06   2.9481D-05  -3.3819D-06   6.5632D-06   4.7011D-06  -1.5831D-06   8.2847D-07  
D  TORUN     HYD  DER_EAST  -3.5681D-05  -2.5146D-05  -1.5446D-05   2.5070D-06  -2.1673D-06  -1.3573D-05  -4.1978D-06   1.6492D-06   7.2737D-07  
D  TORUN     HYD  CHEB_0     7.6216D-09   1.4341D-11   7.0368D-12  -8.0308D-12  -9.8495D-12   5.9075D-12  -1.3635D-11  -8.3339D-14  -1.6529D-12  
D  TORUN     HYD  CHEB_1    -4.0454D-12   1.3568D-11   6.9322D-12  -1.0270D-12   1.1126D-12  -2.8972D-14   6.3032D-13  -1.5868D-13  -4.8428D-13  
D  TORUN     HYD  CHEB_2    -3.1831D-12   1.7452D-12   1.0290D-12  -1.3904D-13   2.9269D-13  -2.2868D-14   1.1465D-13  -2.8655D-14  -8.2212D-14  
D  TORUN     HYD  CHEB_3    -1.7855D-12  -4.1061D-13  -1.9261D-13   3.5216D-14   1.4808D-15  -7.0864D-15  -8.6025D-15   1.7027D-15   9.5997D-15  
D  TORUN     HYD  CHEB_4    -6.7956D-13   2.8931D-14   7.2748D-16  -1.0328D-15  -5.4353D-15   1.1311D-15  -8.0809D-16  -1.4359D-15   2.1803D-17  
D  TORUN     HYD  CHEB_5    -1.1179D-13   2.1767D-16   7.4551D-16   3.4632D-16  -1.2650D-15  -5.1685D-16   1.2434D-15   1.2379D-15   6.5276D-16  
#
D  TORUN     NHY  DER_NORT   4.6318D-04   2.9710D-04   3.7067D-04  -2.4113D-04   2.0764D-04   7.2958D-05   2.8012D-04   1.8932D-05   2.1720D-04  
D  TORUN     NHY  DER_EAST  -1.3991D-04  -2.6901D-04  -3.9123D-04   5.5150D-05  -8.2460D-05   2.4335D-04  -1.5612D-04   5.2373D-05  -1.2099D-04  
D  TORUN     NHY  CHEB_0     3.7770D-10  -1.5465D-10  -9.0733D-11   4.1266D-11   1.1613D-11   2.1630D-12   4.9999D-12  -8.9065D-14   1.4731D-12  
D  TORUN     NHY  CHEB_1     2.1935D-11  -8.3109D-12  -4.8180D-12   2.1847D-12   3.3015D-13   2.9934D-13   6.9220D-13  -1.4736D-13   1.2320D-13  
D  TORUN     NHY  CHEB_2     3.9591D-12  -1.4240D-12  -8.2861D-13   3.6331D-13   2.2239D-14   7.2897D-14   1.5930D-13  -4.3112D-14   2.1126D-14  
D  TORUN     NHY  CHEB_3    -4.0495D-13   1.8772D-13   1.0894D-13  -5.0707D-14  -1.8003D-14  -3.4631D-15  -4.8403D-15  -4.7796D-15  -7.3302D-15  
D  TORUN     NHY  CHEB_4    -5.5414D-14   1.9610D-14   1.0775D-14  -4.8925D-15  -1.6136D-15  -3.0245D-16  -7.6180D-16  -1.6905D-16  -7.3813D-16  
D  TORUN     NHY  CHEB_5    -1.5331D-14   1.0607D-14   4.1464D-15  -1.7726D-15   5.0222D-16  -2.3942D-15  -2.8249D-15   5.5922D-16  -9.5958D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TOULOUSE  HYD  DER_NORT   6.5597D-05  -2.3225D-06  -1.6568D-05   2.2195D-05   2.0483D-05  -1.3110D-05   1.2730D-05  -1.2837D-06  -4.3953D-07  
D  TOULOUSE  HYD  DER_EAST  -2.8901D-06  -7.6365D-06  -1.5210D-05   2.2938D-07  -1.9026D-05  -9.8736D-06   1.1006D-05   1.8995D-06  -1.9339D-06  
D  TOULOUSE  HYD  CHEB_0     7.6162D-09   3.5017D-11   6.3384D-12   2.0493D-11  -2.7451D-13   1.2941D-11  -1.0814D-11  -7.5593D-13  -4.0983D-12  
D  TOULOUSE  HYD  CHEB_1    -1.3204D-11   9.9975D-12   8.0322D-12  -1.3875D-12  -4.5188D-13   5.6256D-13  -9.1678D-13  -2.5635D-14  -6.4665D-13  
D  TOULOUSE  HYD  CHEB_2    -4.5782D-12   1.3390D-12   1.2088D-12  -2.3290D-13  -5.7784D-14   6.2569D-14  -1.2831D-13  -1.4982D-14  -1.2224D-13  
D  TOULOUSE  HYD  CHEB_3    -1.5020D-12  -3.0686D-13  -2.4428D-13   5.1671D-14   3.8530D-14  -1.2081D-14   1.9903D-14  -4.7794D-15  -1.3685D-15  
D  TOULOUSE  HYD  CHEB_4    -6.9629D-13   1.3854D-14  -1.1833D-14   5.4883D-15  -4.1616D-16  -7.2559D-15   5.5703D-15   3.6494D-16   2.0697D-15  
D  TOULOUSE  HYD  CHEB_5    -1.0849D-13   2.7030D-15   8.8560D-15  -9.8120D-15  -5.3941D-15   2.4596D-15  -1.0907D-15   5.2881D-16   4.2306D-16  
#
D  TOULOUSE  NHY  DER_NORT   2.5415D-04  -2.3308D-04   5.7397D-04   5.7571D-05   6.4798D-07   8.0536D-05  -2.0236D-04   1.0904D-04   3.0035D-04  
D  TOULOUSE  NHY  DER_EAST  -4.8578D-04  -2.4310D-04  -2.7854D-04  -1.3105D-05   7.0927D-05  -9.8484D-05   4.9498D-05  -5.1326D-08   1.3325D-04  
D  TOULOUSE  NHY  CHEB_0     4.4334D-10  -1.4565D-10  -8.1236D-11  -7.7431D-12  -2.3733D-12  -5.4644D-12   3.1646D-11  -3.5680D-12   1.1718D-12  
D  TOULOUSE  NHY  CHEB_1     2.4774D-11  -7.8402D-12  -3.0823D-12  -5.8776D-13  -1.4813D-13   5.5859D-14   7.7367D-13  -1.1969D-13   1.2849D-13  
D  TOULOUSE  NHY  CHEB_2     4.6861D-12  -1.5060D-12  -5.7117D-13  -1.4876D-13  -8.4424D-14   7.2592D-15   1.0794D-13   5.2647D-14   4.7615D-14  
D  TOULOUSE  NHY  CHEB_3    -3.7847D-13   1.1926D-13   6.1477D-14  -7.2832D-15  -1.5097D-14   7.9679D-16  -3.0074D-14   2.0043D-14  -7.5596D-17  
D  TOULOUSE  NHY  CHEB_4    -7.2074D-14   2.7293D-14   1.1719D-14  -7.5414D-16   2.1786D-15   5.4750D-15  -1.5157D-15  -7.7954D-15  -1.6788D-15  
D  TOULOUSE  NHY  CHEB_5    -1.3976D-14   5.3808D-15   3.0761D-15   1.2800D-15   1.3226D-15  -4.6678D-16  -8.7103D-16  -6.2788D-16  -1.3783D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TROMSONO  HYD  DER_NORT   9.6448D-05   1.8207D-05   1.1500D-05  -2.2656D-05  -8.9445D-07   1.6759D-05  -1.9872D-05   1.1485D-06   2.0072D-06  
D  TROMSONO  HYD  DER_EAST  -4.1246D-05  -1.1516D-06  -1.6150D-05   7.9686D-06  -9.1531D-06  -1.2213D-05  -2.5832D-05  -2.4847D-06   2.0279D-06  
D  TROMSONO  HYD  CHEB_0     7.5550D-09  -4.9818D-11   3.5258D-12  -2.5060D-11   1.4223D-11  -2.1136D-11   2.1384D-11   6.5085D-13   1.4598D-12  
D  TROMSONO  HYD  CHEB_1     1.2033D-11   1.8217D-11   7.9693D-12  -1.2284D-12  -1.2855D-12  -9.1389D-13   2.4459D-12  -6.9531D-14  -2.7366D-13  
D  TROMSONO  HYD  CHEB_2    -5.2350D-13   2.0023D-12   1.1199D-12  -2.2395D-13  -3.2855D-13  -1.7157D-13   3.1911D-13  -3.7447D-15  -3.5260D-14  
D  TROMSONO  HYD  CHEB_3    -2.1730D-12  -6.3621D-13  -2.3106D-13   3.3311D-14  -6.3251D-15   1.0707D-14  -4.5549D-14  -2.3676D-16   4.7892D-15  
D  TROMSONO  HYD  CHEB_4    -6.5919D-13   6.7790D-14   1.7484D-15  -3.5844D-15   1.1314D-14   8.0427D-15  -9.5902D-15   4.5222D-16  -8.2215D-16  
D  TROMSONO  HYD  CHEB_5    -1.2428D-13   1.0893D-15   5.2745D-15   6.0172D-15  -5.8420D-15  -1.4161D-15   2.9468D-15   1.5119D-18  -8.7408D-16  
#
D  TROMSONO  NHY  DER_NORT   6.7746D-04  -6.0159D-04  -2.0478D-04  -2.3491D-04   4.6836D-04   1.3167D-04   7.2150D-05   1.9107D-05   3.0037D-04  
D  TROMSONO  NHY  DER_EAST  -8.8597D-05  -1.0670D-03  -2.7659D-04   4.4637D-04   2.2291D-04   3.9847D-04  -1.1457D-04   4.8767D-05   7.6557D-05  
D  TROMSONO  NHY  CHEB_0     2.5000D-10  -1.1856D-10  -6.4979D-11   2.7480D-11   2.5168D-11   1.5599D-11  -3.0167D-11  -3.4852D-13   7.4459D-14  
D  TROMSONO  NHY  CHEB_1     1.4991D-11  -6.8270D-12  -3.6818D-12   1.5937D-12   1.4218D-12   1.0708D-12  -1.8701D-12  -3.8381D-14   4.2370D-14  
D  TROMSONO  NHY  CHEB_2     2.7620D-12  -1.2396D-12  -6.5789D-13   2.9414D-13   2.7168D-13   1.8817D-13  -3.4710D-13  -3.8503D-15   2.1065D-14  
D  TROMSONO  NHY  CHEB_3    -2.4696D-13   1.2293D-13   7.2339D-14  -2.3757D-14  -2.3056D-14  -2.3367D-14   3.1323D-14   4.2410D-15   1.8947D-16  
D  TROMSONO  NHY  CHEB_4    -3.9849D-14   1.4495D-14   8.9765D-15  -4.5727D-15  -3.5954D-15   2.8530D-16   3.2231D-15  -5.6439D-16  -1.5499D-15  
D  TROMSONO  NHY  CHEB_5    -7.9010D-15   8.8248D-15   2.9052D-15  -1.2508D-15  -2.8287D-15  -6.6421D-16   1.9796D-15   2.9098D-16  -1.5777D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TRYSILNO  HYD  DER_NORT   1.1800D-04   7.3416D-05   1.4355D-05   5.9252D-06  -3.6652D-05   1.0050D-05  -1.1227D-05   1.1430D-06   9.2146D-07  
D  TRYSILNO  HYD  DER_EAST  -4.7925D-05  -2.2733D-05  -2.5956D-05   7.9793D-06  -1.4177D-05  -1.0131D-05  -6.6001D-06   1.2478D-06   1.1587D-06  
D  TRYSILNO  HYD  CHEB_0     7.0698D-09  -3.2415D-11   1.2613D-11  -2.0791D-11   6.6258D-12  -4.1412D-12  -5.9280D-13  -1.9583D-14  -7.2440D-13  
D  TRYSILNO  HYD  CHEB_1     1.2208D-11   1.5140D-11   6.7467D-12  -4.0971D-14  -3.6459D-13  -6.5348D-13   1.0219D-12  -2.1975D-13  -3.8151D-13  
D  TRYSILNO  HYD  CHEB_2    -2.5995D-13   1.8464D-12   1.0148D-12  -8.9701D-15  -2.3485D-14  -1.5250D-13   1.8002D-13  -3.1731D-14  -5.9557D-14  
D  TRYSILNO  HYD  CHEB_3    -1.9500D-12  -4.8152D-13  -1.8650D-13   4.2334D-15  -6.6977D-15  -1.6054D-16  -2.8809D-14   7.6789D-15   5.4744D-15  
D  TRYSILNO  HYD  CHEB_4    -6.6686D-13   4.6876D-14   6.5847D-16  -1.2905D-15  -2.3591D-15   1.6539D-15   2.9027D-15  -2.4473D-15  -3.3396D-15  
D  TRYSILNO  HYD  CHEB_5    -1.0421D-13  -7.3037D-15   4.8999D-16   3.3167D-15   5.7315D-15   4.7742D-16  -4.7526D-16   1.1366D-15   1.4041D-15  
#
D  TRYSILNO  NHY  DER_NORT   2.3093D-04   3.7852D-04   1.2975D-04   1.8545D-04  -5.0617D-04  -1.6988D-04   3.5820D-04   5.7214D-05  -5.3454D-05  
D  TRYSILNO  NHY  DER_EAST  -8.4118D-04  -2.3141D-04  -1.4709D-04   2.9619D-05  -2.5322D-04   2.4161D-04   2.7115D-04  -8.1490D-05   1.3836D-04  
D  TRYSILNO  NHY  CHEB_0     2.6298D-10  -1.2405D-10  -8.2821D-11   1.9133D-11   2.7090D-11   6.0314D-12  -7.2093D-12   1.3889D-12   8.6198D-12  
D  TRYSILNO  NHY  CHEB_1     1.5908D-11  -6.9860D-12  -4.7840D-12   1.0910D-12   1.2475D-12   4.1448D-13  -1.9824D-13   8.7606D-14   4.3094D-13  
D  TRYSILNO  NHY  CHEB_2     2.9679D-12  -1.2757D-12  -8.7425D-13   1.9597D-13   1.9830D-13   9.4909D-14  -1.6095D-14   1.4716D-14   8.4454D-14  
D  TRYSILNO  NHY  CHEB_3    -2.5053D-13   1.2586D-13   8.4406D-14  -1.8791D-14  -3.6139D-14  -2.4339D-15   8.0522D-15  -3.2624D-15  -5.0072D-15  
D  TRYSILNO  NHY  CHEB_4    -3.4832D-14   1.2301D-14   8.2302D-15  -1.5353D-15   3.5617D-16   2.3255D-15  -1.5018D-15  -2.4820D-15  -5.2784D-16  
D  TRYSILNO  NHY  CHEB_5    -9.5189D-15   6.5681D-15   3.1274D-15  -1.4327D-16  -1.5853D-15  -1.6330D-15  -1.4687D-16   8.5514D-16  -4.0581D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TSUKU3    HYD  DER_NORT   1.2794D-04   8.1938D-05   4.9878D-05   9.9559D-06  -1.7754D-05  -2.9106D-06  -1.1625D-05  -1.4503D-06   3.1234D-06  
D  TSUKU3    HYD  DER_EAST  -2.5716D-05   1.2557D-05  -4.2714D-06  -5.3602D-06  -1.3613D-05   4.6777D-06  -1.2644D-06  -4.1652D-07  -2.4987D-07  
D  TSUKU3    HYD  CHEB_0     7.6898D-09   5.8353D-11   8.3358D-12  -3.7503D-12  -5.0169D-12  -3.8169D-13  -1.3206D-12  -2.1016D-12   5.7635D-12  
D  TSUKU3    HYD  CHEB_1    -1.9565D-11   1.6134D-11   1.1316D-11  -7.6101D-13  -1.9768D-12  -4.8602D-13   4.6191D-14  -2.9046D-13   5.8196D-13  
D  TSUKU3    HYD  CHEB_2    -5.1054D-12   2.3897D-12   1.6875D-12  -9.9243D-14  -1.8076D-13  -9.6115D-14   1.0519D-14  -2.1589D-14   3.2932D-14  
D  TSUKU3    HYD  CHEB_3    -1.1851D-12  -3.6410D-13  -2.6110D-13   6.3522D-14   1.0419D-13   3.2633D-14   1.3625D-16   4.7409D-15   3.2988D-15  
D  TSUKU3    HYD  CHEB_4    -7.4084D-13  -2.3820D-14  -1.9109D-14  -3.5700D-15  -6.3813D-15   2.4574D-15  -1.6105D-15  -2.1258D-15  -4.7013D-16  
D  TSUKU3    HYD  CHEB_5    -1.0715D-13  -1.4949D-15   3.9914D-15  -2.5758D-15  -8.2905D-15  -4.3504D-15   2.4498D-16   1.1379D-15   6.0334D-16  
#
D  TSUKU3    NHY  DER_NORT   1.6105D-03   9.1025D-04   1.1752D-04   7.6275D-05   3.3639D-04  -9.8320D-07  -1.9039D-04  -3.5511D-04   4.9857D-04  
D  TSUKU3    NHY  DER_EAST   2.7177D-04   9.3989D-04   3.7744D-04  -4.5225D-04  -3.4487D-05   5.2058D-05  -1.3856D-04  -3.6398D-04   4.4673D-04  
D  TSUKU3    NHY  CHEB_0     5.4730D-10  -3.6352D-10  -2.3339D-10   5.1687D-11   1.0727D-10  -1.2003D-11  -4.9675D-11   1.9661D-11  -3.2606D-13  
D  TSUKU3    NHY  CHEB_1     2.8709D-11  -1.6841D-11  -1.1294D-11   1.4895D-12   4.2274D-12  -4.2413D-13  -1.7242D-12   8.3647D-13   1.8488D-13  
D  TSUKU3    NHY  CHEB_2     5.0937D-12  -2.8060D-12  -1.9219D-12   1.9376D-13   6.7480D-13  -5.0010D-14  -2.7134D-13   1.0066D-13  -6.6109D-14  
D  TSUKU3    NHY  CHEB_3    -5.6562D-13   4.1247D-13   2.6442D-13  -5.7105D-14  -1.2544D-13   1.7354D-14   5.4760D-14  -3.5196D-14  -3.6396D-14  
D  TSUKU3    NHY  CHEB_4    -8.6002D-14   6.0115D-14   3.6098D-14  -7.6616D-15  -1.9156D-14   2.3247D-15   8.9323D-15  -1.4474D-15   4.3738D-15  
D  TSUKU3    NHY  CHEB_5    -1.0867D-14   5.2784D-15   5.0036D-15  -3.2948D-16  -1.5467D-15   1.5764D-16   1.1042D-15  -6.5966D-16  -1.1016D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TSUKUB32  HYD  DER_NORT   1.2820D-04   8.2060D-05   4.9933D-05   9.9516D-06  -1.7802D-05  -2.9256D-06  -1.1662D-05  -1.4039D-06   3.1049D-06  
D  TSUKUB32  HYD  DER_EAST  -2.6040D-05   1.2600D-05  -4.3429D-06  -5.3986D-06  -1.3645D-05   4.7075D-06  -1.2604D-06  -4.0809D-07  -2.1069D-07  
D  TSUKUB32  HYD  CHEB_0     7.6764D-09   5.7790D-11   8.0739D-12  -3.7655D-12  -4.9966D-12  -3.7779D-13  -1.3087D-12  -2.0874D-12   5.6123D-12  
D  TSUKUB32  HYD  CHEB_1    -1.9266D-11   1.6110D-11   1.1305D-11  -7.6227D-13  -1.9758D-12  -4.8618D-13   4.6665D-14  -2.9134D-13   5.7140D-13  
D  TSUKUB32  HYD  CHEB_2    -5.0600D-12   2.3850D-12   1.6855D-12  -1.0054D-13  -1.8205D-13  -9.6384D-14   1.0656D-14  -2.1466D-14   3.0535D-14  
D  TSUKUB32  HYD  CHEB_3    -1.1893D-12  -3.6264D-13  -2.6035D-13   6.3851D-14   1.0412D-13   3.2765D-14  -9.2199D-17   4.6612D-15   3.0642D-15  
D  TSUKUB32  HYD  CHEB_4    -7.3833D-13  -2.3488D-14  -1.8506D-14  -3.8828D-15  -5.9051D-15   2.3248D-15  -1.4223D-15  -2.0435D-15  -5.2134D-16  
D  TSUKUB32  HYD  CHEB_5    -1.0704D-13  -1.6160D-15   3.6477D-15  -2.3014D-15  -8.1997D-15  -4.2209D-15   1.4231D-16   1.0634D-15   3.9699D-16  
#
D  TSUKUB32  NHY  DER_NORT   1.6164D-03   9.1252D-04   1.2082D-04   7.7349D-05   3.3932D-04  -1.1364D-06  -1.8902D-04  -3.5671D-04   4.9612D-04  
D  TSUKUB32  NHY  DER_EAST   2.7059D-04   9.3855D-04   3.7665D-04  -4.5253D-04  -3.2708D-05   5.2647D-05  -1.3818D-04  -3.6381D-04   4.4527D-04  
D  TSUKUB32  NHY  CHEB_0     5.4414D-10  -3.6177D-10  -2.3231D-10   5.1590D-11   1.0691D-10  -1.1994D-11  -4.9582D-11   1.9549D-11  -4.7325D-13  
D  TSUKUB32  NHY  CHEB_1     2.8582D-11  -1.6794D-11  -1.1268D-11   1.4939D-12   4.2275D-12  -4.2372D-13  -1.7318D-12   8.3567D-13   1.8074D-13  
D  TSUKUB32  NHY  CHEB_2     5.0729D-12  -2.7999D-12  -1.9165D-12   1.9591D-13   6.7335D-13  -5.2257D-14  -2.7192D-13   1.0372D-13  -6.6058D-14  
D  TSUKUB32  NHY  CHEB_3    -5.6137D-13   4.1011D-13   2.6077D-13  -5.8229D-14  -1.2293D-13   1.9161D-14   5.3613D-14  -3.5700D-14  -3.6436D-14  
D  TSUKUB32  NHY  CHEB_4    -8.6751D-14   6.0579D-14   3.8456D-14  -6.4798D-15  -2.0937D-14   5.8951D-16   9.6178D-15  -2.1683D-16   3.8854D-15  
D  TSUKUB32  NHY  CHEB_5    -1.0678D-14   5.3005D-15   3.7361D-15  -9.3225D-16  -5.3027D-16   1.2882D-15   6.1005D-16  -1.2621D-15  -1.0755D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  TSUKUBA   HYD  DER_NORT   1.2793D-04   8.1934D-05   4.9876D-05   9.9557D-06  -1.7752D-05  -2.9102D-06  -1.1623D-05  -1.4517D-06   3.1235D-06  
D  TSUKUBA   HYD  DER_EAST  -2.5695D-05   1.2557D-05  -4.2668D-06  -5.3583D-06  -1.3612D-05   4.6762D-06  -1.2646D-06  -4.1699D-07  -2.4949D-07  
D  TSUKUBA   HYD  CHEB_0     7.6902D-09   5.8370D-11   8.3437D-12  -3.7489D-12  -5.0207D-12  -3.8348D-13  -1.3210D-12  -2.1015D-12   5.7671D-12  
D  TSUKUBA   HYD  CHEB_1    -1.9574D-11   1.6135D-11   1.1316D-11  -7.6101D-13  -1.9768D-12  -4.8600D-13   4.6197D-14  -2.9042D-13   5.8228D-13  
D  TSUKUBA   HYD  CHEB_2    -5.1069D-12   2.3898D-12   1.6875D-12  -9.9226D-14  -1.8073D-13  -9.6108D-14   1.0516D-14  -2.1589D-14   3.3006D-14  
D  TSUKUBA   HYD  CHEB_3    -1.1850D-12  -3.6414D-13  -2.6111D-13   6.3524D-14   1.0420D-13   3.2631D-14   1.4143D-16   4.7404D-15   3.3020D-15  
D  TSUKUBA   HYD  CHEB_4    -7.4094D-13  -2.3831D-14  -1.9126D-14  -3.5643D-15  -6.4051D-15   2.4602D-15  -1.6212D-15  -2.1253D-15  -4.6325D-16  
D  TSUKUBA   HYD  CHEB_5    -1.0714D-13  -1.4984D-15   4.0003D-15  -2.5818D-15  -8.2819D-15  -4.3539D-15   2.4933D-16   1.1380D-15   6.0377D-16  
#
D  TSUKUBA   NHY  DER_NORT   1.6103D-03   9.1018D-04   1.1745D-04   7.6262D-05   3.3634D-04  -9.9376D-07  -1.9043D-04  -3.5508D-04   4.9863D-04  
D  TSUKUBA   NHY  DER_EAST   2.7195D-04   9.3987D-04   3.7755D-04  -4.5226D-04  -3.4598D-05   5.2036D-05  -1.3858D-04  -3.6398D-04   4.4681D-04  
D  TSUKUBA   NHY  CHEB_0     5.4740D-10  -3.6357D-10  -2.3343D-10   5.1692D-11   1.0728D-10  -1.2003D-11  -4.9678D-11   1.9664D-11  -3.2032D-13  
D  TSUKUBA   NHY  CHEB_1     2.8713D-11  -1.6843D-11  -1.1295D-11   1.4893D-12   4.2274D-12  -4.2413D-13  -1.7240D-12   8.3656D-13   1.8503D-13  
D  TSUKUBA   NHY  CHEB_2     5.0943D-12  -2.8062D-12  -1.9221D-12   1.9370D-13   6.7486D-13  -4.9935D-14  -2.7135D-13   1.0059D-13  -6.6141D-14  
D  TSUKUBA   NHY  CHEB_3    -5.6575D-13   4.1255D-13   2.6452D-13  -5.7067D-14  -1.2550D-13   1.7310D-14   5.4782D-14  -3.5181D-14  -3.6378D-14  
D  TSUKUBA   NHY  CHEB_4    -8.5975D-14   6.0097D-14   3.6040D-14  -7.7017D-15  -1.9115D-14   2.3648D-15   8.9241D-15  -1.4820D-15   4.3796D-15  
D  TSUKUBA   NHY  CHEB_5    -1.0878D-14   5.2874D-15   5.0363D-15  -3.1069D-16  -1.5766D-15   1.2580D-16   1.1172D-15  -6.4610D-16  -1.0939D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  URUMQI    HYD  DER_NORT   1.7894D-04   3.3058D-07   4.5073D-06  -1.8135D-05   8.1821D-06   4.3379D-06  -7.1663D-06  -5.4858D-06   5.1542D-06  
D  URUMQI    HYD  DER_EAST  -2.6448D-05  -5.7079D-07  -1.1936D-05   7.5390D-06   8.6011D-06  -8.2596D-06   4.0792D-06  -4.2594D-07  -3.4405D-06  
D  URUMQI    HYD  CHEB_0     6.0537D-09   1.5547D-11  -4.8494D-12  -8.5183D-12  -1.0094D-11   8.9424D-12   2.6258D-12   1.0988D-12   7.2888D-14  
D  URUMQI    HYD  CHEB_1     1.8043D-11   1.4845D-11   4.5344D-12   6.1600D-14  -1.0895D-12  -9.7189D-13   3.8262D-13  -4.4291D-13  -4.1350D-14  
D  URUMQI    HYD  CHEB_2     1.4006D-12   2.3376D-12   7.8184D-13  -3.7640D-15  -8.3302D-14  -1.2788D-13  -3.7697D-15  -1.1955D-13   2.5298D-14  
D  URUMQI    HYD  CHEB_3    -1.9307D-12  -3.6110D-13  -1.4219D-13   6.4522D-14   5.9398D-14   1.6503D-14  -2.8678D-15   7.0361D-15   3.1745D-15  
D  URUMQI    HYD  CHEB_4    -5.3272D-13  -2.3706D-14   2.9191D-15  -1.4475D-14   1.9548D-15   8.6239D-15  -9.2332D-15   2.4107D-15   1.5964D-15  
D  URUMQI    HYD  CHEB_5    -6.4544D-14   1.7521D-14   8.8256D-15  -8.3404D-15  -9.1222D-15  -8.7778D-15   3.6295D-15  -1.6318D-15  -9.2163D-16  
#
D  URUMQI    NHY  DER_NORT   4.8099D-03  -2.0853D-03   4.1615D-04  -1.1245D-03   1.4872D-03  -2.7310D-04  -3.9658D-04   1.7348D-03   5.3368D-04  
D  URUMQI    NHY  DER_EAST  -1.9489D-03   5.0309D-04  -4.4488D-04   9.5515D-05  -4.1160D-04  -8.7318D-05   1.9432D-04  -1.3006D-03   1.4282D-04  
D  URUMQI    NHY  CHEB_0     1.8537D-10  -1.3062D-10  -3.9216D-11   1.1794D-11   5.5440D-12  -1.5654D-11  -1.4419D-11   1.1739D-11   2.7486D-12  
D  URUMQI    NHY  CHEB_1     1.1866D-11  -7.8837D-12  -2.3070D-12   6.7161D-13   7.5496D-15  -1.2818D-12  -7.4625D-13   2.2985D-13   1.5181D-13  
D  URUMQI    NHY  CHEB_2     2.2665D-12  -1.4502D-12  -4.3802D-13   7.9398D-14  -9.6382D-15  -2.4516D-13  -1.3440D-13  -5.1513D-15   1.8577D-14  
D  URUMQI    NHY  CHEB_3    -1.7581D-13   1.4775D-13   3.8057D-14  -3.0746D-14  -1.2435D-14   1.4660D-14   1.8340D-14  -3.3975D-14  -4.0703D-15  
D  URUMQI    NHY  CHEB_4    -3.7073D-14   2.8950D-14   9.0243D-15  -2.6920D-15  -5.1993D-15   9.2403D-16   4.8027D-15  -6.3279D-15  -1.0346D-15  
D  URUMQI    NHY  CHEB_5    -6.9002D-15   5.6338D-15   2.1313D-15   1.5172D-16  -1.3625D-15   3.6757D-16   8.7218D-16  -1.9388D-15   9.1122D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  USSURISK  HYD  DER_NORT   1.4127D-04   5.4750D-05  -1.2800D-05  -8.4053D-06  -1.1858D-05  -7.7396D-06  -1.9403D-05  -1.1349D-06   1.2771D-07  
D  USSURISK  HYD  DER_EAST  -5.9755D-06  -1.9443D-05  -2.0105D-05  -3.0352D-06  -6.9063D-06  -1.9694D-06  -7.5616D-06  -1.2677D-06   7.3543D-07  
D  USSURISK  HYD  CHEB_0     7.6084D-09   7.8418D-11  -3.6615D-12  -1.6816D-12  -4.3597D-12   3.7679D-12  -3.0799D-13  -2.5553D-12   4.1107D-12  
D  USSURISK  HYD  CHEB_1    -1.3055D-12   2.3877D-11   1.1055D-11  -1.3583D-12  -3.6936D-12  -1.1157D-13  -2.1254D-12  -5.5074D-13   3.1263D-13  
D  USSURISK  HYD  CHEB_2    -2.0841D-12   3.9164D-12   1.7433D-12  -1.2146D-13  -4.9237D-13  -6.3411D-14  -4.4917D-13  -9.0896D-14   5.3189D-14  
D  USSURISK  HYD  CHEB_3    -1.7484D-12  -5.6625D-13  -2.5276D-13   7.8117D-14   1.2393D-13  -1.4109D-14   2.8398D-14   6.6508D-15   3.5738D-17  
D  USSURISK  HYD  CHEB_4    -7.2482D-13  -3.8015D-14  -1.3605D-14  -5.5345D-15   9.4206D-15   6.8918D-15   3.7026D-15   1.0354D-15   3.1821D-15  
D  USSURISK  HYD  CHEB_5    -9.7906D-14   1.1393D-14   4.3936D-15  -2.6400D-15  -8.3391D-15  -1.4278D-15  -1.9834D-15   3.7480D-16  -1.6595D-15  
#
D  USSURISK  NHY  DER_NORT   7.2110D-04   1.3502D-04  -5.1844D-04  -2.5686D-04  -2.6470D-05  -1.0651D-04  -2.9052D-04   7.4728D-05   1.0568D-04  
D  USSURISK  NHY  DER_EAST   4.0068D-04   2.6823D-04   4.6768D-06  -4.1278D-04   3.4522D-04   2.2928D-04  -2.8374D-04  -1.5392D-04   3.3523D-04  
D  USSURISK  NHY  CHEB_0     3.2808D-10  -3.0472D-10  -1.0748D-10   7.0873D-11   8.1841D-11  -2.1067D-12  -2.4363D-11   7.9726D-12  -1.2083D-12  
D  USSURISK  NHY  CHEB_1     1.8212D-11  -1.6202D-11  -5.7420D-12   3.2192D-12   3.9153D-12   2.4892D-14  -7.2210D-13   4.9795D-13  -2.8582D-13  
D  USSURISK  NHY  CHEB_2     3.2882D-12  -2.8708D-12  -1.0433D-12   5.0910D-13   6.7476D-13   3.9391D-14  -9.1127D-14   7.6945D-14  -9.6511D-14  
D  USSURISK  NHY  CHEB_3    -3.4149D-13   3.2556D-13   1.1432D-13  -8.8835D-14  -9.1611D-14   1.2888D-14   2.9913D-14  -1.5407D-14  -1.1701D-14  
D  USSURISK  NHY  CHEB_4    -5.1866D-14   4.9173D-14   1.7612D-14  -1.0397D-14  -1.3329D-14  -7.3139D-16   2.7287D-15  -1.1427D-15   6.5434D-16  
D  USSURISK  NHY  CHEB_5    -1.0666D-14   8.5373D-15   4.9138D-15  -1.2173D-15  -2.0361D-15   6.7420D-16  -4.6050D-16  -9.2584D-16  -1.1819D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  USUDA64   HYD  DER_NORT   1.9757D-04   9.7456D-05   5.1172D-05   7.0705D-06  -2.6940D-05  -3.2336D-06  -2.0451D-05  -1.5711D-06   6.1760D-08  
D  USUDA64   HYD  DER_EAST   3.8389D-06   4.5680D-06  -2.0166D-05  -6.1974D-06  -1.6516D-05   6.6771D-06  -3.9650D-07  -1.7128D-06   1.1068D-06  
D  USUDA64   HYD  CHEB_0     6.4797D-09   1.2926D-11  -1.5309D-11  -4.5277D-12  -3.2587D-12   1.4293D-13  -2.7079D-13   1.2731D-13  -2.3964D-13  
D  USUDA64   HYD  CHEB_1     5.8242D-12   1.4721D-11   1.0131D-11  -1.0034D-12  -2.0189D-12  -4.6723D-13   1.3557D-13  -1.7022D-13   2.3518D-13  
D  USUDA64   HYD  CHEB_2    -4.8735D-13   2.3812D-12   1.7049D-12  -1.3261D-13  -2.7161D-13  -8.7922D-14   2.3751D-14  -3.0117D-14   3.4607D-14  
D  USUDA64   HYD  CHEB_3    -1.6408D-12  -3.4544D-13  -2.3228D-13   4.8893D-14   6.9652D-14   3.7131D-14   1.9881D-15   2.5169D-15   2.6085D-15  
D  USUDA64   HYD  CHEB_4    -6.1445D-13  -4.6110D-15  -3.3683D-15   9.7717D-15   4.8880D-15  -4.2676D-15  -3.1283D-15  -3.6240D-16  -2.0776D-16  
D  USUDA64   HYD  CHEB_5    -6.6555D-14   4.9217D-15   8.3062D-16  -7.9198D-15  -4.3882D-15  -5.1614D-16  -1.4705D-15  -8.8453D-17  -7.1760D-16  
#
D  USUDA64   NHY  DER_NORT   1.5893D-03  -1.9548D-04  -2.9939D-04   9.0817D-05   4.0899D-04   9.8834D-05  -1.2338D-05   8.0389D-05  -4.3275D-07  
D  USUDA64   NHY  DER_EAST  -5.3192D-04  -4.7849D-04  -5.4101D-04  -2.7244D-04   2.5448D-05   2.1420D-04   9.4270D-06   1.0103D-04  -1.1438D-05  
D  USUDA64   NHY  CHEB_0     3.0341D-10  -2.3438D-10  -1.4112D-10   4.8592D-11   7.7647D-11  -7.5260D-12  -3.4836D-11   1.5212D-11  -1.4310D-11  
D  USUDA64   NHY  CHEB_1     1.9011D-11  -1.3668D-11  -8.5458D-12   2.4273D-12   4.4033D-12  -3.8981D-13  -2.1199D-12   1.0384D-12  -6.8488D-13  
D  USUDA64   NHY  CHEB_2     3.5128D-12  -2.4062D-12  -1.5257D-12   3.9820D-13   7.2145D-13  -9.3061D-14  -3.3494D-13   1.7257D-13  -5.4801D-14  
D  USUDA64   NHY  CHEB_3    -3.1317D-13   2.8118D-13   1.6373D-13  -6.5997D-14  -1.1367D-13  -3.1038D-16   5.8556D-14  -2.7379D-14   4.0514D-14  
D  USUDA64   NHY  CHEB_4    -4.6440D-14   3.5424D-14   2.1061D-14  -6.9054D-15  -1.0790D-14   4.0375D-15   4.0127D-15  -3.2935D-15   9.2810D-16  
D  USUDA64   NHY  CHEB_5    -7.5189D-15   4.7739D-15   3.3902D-15  -1.0820D-15  -1.2991D-15   2.0093D-16  -1.1451D-16   5.0553D-16  -8.3169D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VERAIRIK  HYD  DER_NORT   1.3037D-04   7.8810D-05   5.4377D-05   6.3767D-06  -2.8301D-05  -4.1903D-06   1.6664D-07  -1.3335D-07   2.0702D-07  
D  VERAIRIK  HYD  DER_EAST  -5.6256D-06   1.7184D-06  -1.1883D-05   5.1084D-06  -4.5756D-06   9.0628D-07  -2.1641D-06  -1.0487D-06  -2.5277D-06  
D  VERAIRIK  HYD  CHEB_0     7.2560D-09   5.2229D-11   1.0415D-11   1.0433D-12  -5.3080D-12  -4.2514D-13  -9.2716D-13  -1.7210D-12   1.2927D-12  
D  VERAIRIK  HYD  CHEB_1    -1.5943D-11   1.3240D-11   8.0827D-12  -7.1243D-13  -1.2683D-12   1.3531D-13   3.4445D-13  -3.3779D-13   3.1840D-13  
D  VERAIRIK  HYD  CHEB_2    -4.3590D-12   2.0498D-12   1.2955D-12  -7.9225D-14  -1.7156D-13   4.1918D-14   6.9754D-14  -5.8939D-14   1.6320D-14  
D  VERAIRIK  HYD  CHEB_3    -1.3124D-12  -3.4255D-13  -2.0676D-13   3.7504D-14   4.5681D-14   6.2792D-15   4.5865D-15   1.1436D-14   1.2327D-15  
D  VERAIRIK  HYD  CHEB_4    -6.6919D-13  -1.3284D-14  -1.2194D-14   4.2849D-15   4.1973D-15   8.5109D-16  -4.1817D-15   3.8960D-16   2.4041D-16  
D  VERAIRIK  HYD  CHEB_5    -9.1300D-14   5.3823D-15   5.4665D-15  -2.7160D-15  -2.0091D-15   3.3416D-16   2.2317D-16  -1.6312D-15  -1.1428D-15  
#
D  VERAIRIK  NHY  DER_NORT   1.8541D-03   1.1926D-03   4.8568D-04  -5.7732D-04  -3.3047D-04  -4.3809D-05   3.4519D-04  -2.1205D-04   2.4631D-04  
D  VERAIRIK  NHY  DER_EAST   4.9156D-04  -3.9966D-04  -1.1641D-04  -5.7310D-04  -1.8423D-04   1.1630D-04  -2.2652D-05   3.4024D-04  -6.0726D-04  
D  VERAIRIK  NHY  CHEB_0     5.1809D-10  -3.3215D-10  -1.9386D-10   7.6315D-11   1.1152D-10  -5.5849D-12  -3.6564D-11   9.2168D-12  -1.0361D-11  
D  VERAIRIK  NHY  CHEB_1     2.7347D-11  -1.5136D-11  -9.7364D-12   3.2438D-12   4.6117D-12  -7.8206D-13  -1.9037D-12   2.3727D-13   1.1942D-13  
D  VERAIRIK  NHY  CHEB_2     4.8962D-12  -2.5848D-12  -1.7217D-12   5.2515D-13   7.5823D-13  -1.6854D-13  -3.5721D-13   1.1234D-14  -1.0091D-13  
D  VERAIRIK  NHY  CHEB_3    -5.1186D-13   3.3855D-13   1.8656D-13  -8.4263D-14  -9.9991D-14   1.2147D-14   2.6973D-14  -1.4842D-14  -3.8600D-14  
D  VERAIRIK  NHY  CHEB_4    -8.2431D-14   5.1199D-14   3.0519D-14  -1.3812D-14  -2.3235D-14  -3.5469D-16   9.6641D-15  -4.1819D-16   1.3215D-14  
D  VERAIRIK  NHY  CHEB_5    -1.1846D-14   8.0554D-15   4.1777D-15  -9.2139D-16   1.5379D-15   3.2962D-15   1.6942D-16   8.3016D-16   1.9138D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VERAISGK  HYD  DER_NORT   2.9677D-05   4.8093D-05   4.6029D-05  -1.7347D-06  -9.0491D-06   2.9890D-06   1.0295D-07   4.6249D-07  -2.0336D-07  
D  VERAISGK  HYD  DER_EAST   2.2637D-05  -4.0114D-07   1.5345D-06   6.8831D-06  -2.0266D-06   8.4783D-07  -3.6528D-06  -1.3639D-07  -6.8553D-07  
D  VERAISGK  HYD  CHEB_0     7.6707D-09   5.8911D-11   1.9331D-11   2.1204D-12  -4.7182D-12   1.9935D-12   8.5602D-13  -1.1908D-12   1.7772D-12  
D  VERAISGK  HYD  CHEB_1    -3.6363D-11   6.8014D-12   3.5465D-12  -2.2890D-13   4.1853D-13   3.3698D-13   3.9306D-14  -2.5094D-13   2.3310D-13  
D  VERAISGK  HYD  CHEB_2    -7.3056D-12   1.1804D-12   6.8260D-13  -3.3241D-14   1.2499D-13   9.2691D-14  -2.0758D-14  -3.0832D-14   2.4998D-14  
D  VERAISGK  HYD  CHEB_3    -9.7234D-13  -2.8635D-13  -1.5184D-13   1.5329D-14   4.6427D-15   5.9732D-16   2.0536D-14   7.1676D-15  -2.1361D-15  
D  VERAISGK  HYD  CHEB_4    -7.1493D-13   2.1039D-14   4.1968D-15   9.1081D-16  -1.1304D-15  -1.6932D-15   1.3083D-15   1.8474D-15  -2.1317D-15  
D  VERAISGK  HYD  CHEB_5    -7.7375D-14   2.2307D-14   1.7544D-14   1.1238D-15  -1.1780D-15   7.2702D-16  -1.5608D-15  -5.6280D-16  -8.6900D-16  
#
D  VERAISGK  NHY  DER_NORT   9.5151D-04   7.5694D-04  -1.3236D-04  -1.2391D-04  -4.4090D-04   3.5792D-04  -9.0012D-05  -9.1856D-06   5.7635D-05  
D  VERAISGK  NHY  DER_EAST  -2.4925D-04   2.7554D-04  -1.8018D-04   1.7398D-04   9.8601D-05   1.5774D-04  -2.2431D-04  -8.1388D-05   3.6045D-05  
D  VERAISGK  NHY  CHEB_0     8.8600D-10  -2.6140D-10  -9.5203D-11   7.6856D-12  -8.5762D-12   3.7249D-12  -1.6500D-11   4.7646D-12  -8.8208D-13  
D  VERAISGK  NHY  CHEB_1     4.5133D-11  -9.2431D-12  -4.0449D-12   3.8086D-13   4.5020D-14  -3.2595D-13  -1.0372D-12  -2.3462D-15  -3.7692D-13  
D  VERAISGK  NHY  CHEB_2     8.1423D-12  -1.7872D-12  -7.6166D-13   2.7972D-13   1.3872D-13  -1.9371D-13  -1.8656D-13  -1.8416D-13   4.1173D-14  
D  VERAISGK  NHY  CHEB_3    -8.6951D-13   2.2282D-13   7.3871D-14   1.9457D-14   3.9291D-14  -4.3013D-14   2.4273D-14  -1.6867D-14   2.3775D-14  
D  VERAISGK  NHY  CHEB_4    -2.0038D-13   9.9456D-14   4.4842D-14  -9.1467D-15  -1.9963D-14   2.9422D-15  -1.1806D-14   1.1399D-14  -1.8801D-14  
D  VERAISGK  NHY  CHEB_5     5.9214D-15  -1.0923D-14  -1.4628D-14  -8.1076D-15   9.9399D-15   1.8025D-15   8.4472D-15   7.8089D-15   8.5244D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VERAMZSW  HYD  DER_NORT   1.6107D-04   7.0120D-05   2.8611D-05   3.8145D-06  -1.4974D-05   2.2497D-06  -1.7848D-05  -5.0446D-07  -2.0943D-07  
D  VERAMZSW  HYD  DER_EAST  -3.4409D-05  -8.9193D-06  -1.9111D-05  -1.1944D-05  -1.6226D-05   5.9388D-06  -4.9292D-06  -1.0379D-06  -1.6732D-06  
D  VERAMZSW  HYD  CHEB_0     7.6547D-09   5.4723D-11   2.8939D-12  -6.9418D-12  -6.0531D-12  -2.1345D-12  -1.5834D-12   1.2485D-13   5.8442D-12  
D  VERAMZSW  HYD  CHEB_1    -1.1328D-11   1.9453D-11   1.2821D-11  -6.1394D-13  -2.2286D-12  -9.1649D-13  -5.6041D-13  -1.0624D-13   8.3819D-13  
D  VERAMZSW  HYD  CHEB_2    -3.8287D-12   2.9063D-12   1.9458D-12  -4.1899D-14  -2.6293D-13  -1.2226D-13  -1.0612D-13  -1.8159D-14   1.2724D-13  
D  VERAMZSW  HYD  CHEB_3    -1.4422D-12  -4.8878D-13  -3.2582D-13   4.1504D-14   1.0086D-13   3.2860D-14   5.4748D-15   3.6683D-15  -1.1597D-14  
D  VERAMZSW  HYD  CHEB_4    -6.9551D-13   8.8551D-15   3.2202D-15  -5.6110D-15   9.5327D-16  -2.2123D-15  -1.3578D-16   1.1543D-17   1.1152D-15  
D  VERAMZSW  HYD  CHEB_5    -1.4014D-13  -1.2285D-14  -3.8252D-15   4.1478D-15  -8.5557D-16   5.2500D-16  -7.2372D-17  -3.3834D-16  -4.2002D-16  
#
D  VERAMZSW  NHY  DER_NORT   9.1466D-04  -1.3769D-05  -3.9091D-04   4.5251D-05  -2.8694D-05  -2.3980D-04  -5.5419D-04  -1.0534D-04  -1.8461D-05  
D  VERAMZSW  NHY  DER_EAST  -1.2318D-03  -8.7479D-04  -3.5874D-04  -5.7098D-04  -1.0030D-04  -1.2285D-04   1.6685D-04   3.0989D-04  -1.7522D-05  
D  VERAMZSW  NHY  CHEB_0     4.5794D-10  -3.1855D-10  -1.8941D-10   4.7706D-11   9.0988D-11   4.5590D-12  -3.2276D-11   1.1623D-11  -1.1694D-11  
D  VERAMZSW  NHY  CHEB_1     2.5842D-11  -1.6305D-11  -9.4863D-12   2.5390D-12   4.2459D-12   1.4440D-13  -1.5310D-12   5.1467D-13  -1.3295D-13  
D  VERAMZSW  NHY  CHEB_2     4.5761D-12  -2.7495D-12  -1.5897D-12   4.1304D-13   6.6084D-13   1.2029D-14  -2.2265D-13   3.8733D-14   2.4256D-14  
D  VERAMZSW  NHY  CHEB_3    -5.1046D-13   3.8185D-13   2.2911D-13  -6.4001D-14  -1.2345D-13  -6.0521D-15   4.8929D-14  -3.2356D-14   1.8203D-14  
D  VERAMZSW  NHY  CHEB_4    -7.3093D-14   5.0704D-14   2.8924D-14  -1.0109D-14  -1.6537D-14  -2.1363D-15   6.7432D-15  -9.8600D-16   1.1020D-16  
D  VERAMZSW  NHY  CHEB_5    -1.0803D-14   5.1052D-15   4.8015D-15   2.3115D-16  -9.3610D-16   5.3577D-16  -4.8565D-16   9.3625D-16  -1.5141D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VERAOGSW  HYD  DER_NORT   7.8103D-05   5.8859D-05   6.7435D-05   4.9622D-06  -9.9668D-06   1.7156D-06   3.7582D-06  -1.5392D-07   8.9301D-07  
D  VERAOGSW  HYD  DER_EAST  -2.0089D-05   3.6599D-06  -4.8992D-06  -2.8919D-06  -7.7945D-06   8.1926D-06  -1.3802D-07  -3.4294D-07  -2.9981D-07  
D  VERAOGSW  HYD  CHEB_0     7.5137D-09   3.4200D-11   2.0311D-11   8.4577D-12  -4.3870D-12  -2.3185D-12  -5.6328D-12  -4.9926D-13   5.7829D-13  
D  VERAOGSW  HYD  CHEB_1    -3.1795D-11   6.2308D-12   5.6618D-12  -9.6782D-13   9.2888D-13  -7.4083D-13   7.1519D-14  -1.9365D-13   2.1210D-13  
D  VERAOGSW  HYD  CHEB_2    -6.3123D-12   8.9219D-13   8.9230D-13  -1.3888D-13   2.1677D-13  -1.1144D-13   4.4086D-14  -1.7806D-14   2.9901D-14  
D  VERAOGSW  HYD  CHEB_3    -1.0036D-12  -1.7052D-13  -1.3549D-13   3.1332D-14  -4.1638D-15   1.9869D-14   1.1969D-14   7.2740D-15  -7.4385D-15  
D  VERAOGSW  HYD  CHEB_4    -7.5212D-13   3.6820D-15   4.5049D-17   3.5792D-16  -3.5855D-15  -1.3301D-15   1.1222D-15  -1.3289D-15   1.1776D-15  
D  VERAOGSW  HYD  CHEB_5    -6.9942D-14  -8.9253D-16  -1.8906D-15   2.1608D-16  -2.0484D-15   7.1352D-16  -8.1349D-17  -4.8041D-16  -1.1647D-15  
#
D  VERAOGSW  NHY  DER_NORT   1.1024D-03   4.2723D-04   5.3537D-04  -2.3587D-04  -4.6150D-04   6.0971D-04   2.1863D-06   1.6933D-04  -8.9104D-05  
D  VERAOGSW  NHY  DER_EAST  -1.9075D-04   2.9362D-05  -1.3871D-04   1.1447D-04  -2.0204D-04  -5.7323D-05   1.0812D-04   1.1291D-04  -2.8077D-05  
D  VERAOGSW  NHY  CHEB_0     7.3978D-10  -2.0886D-10  -1.9175D-10   9.4197D-12  -2.0505D-11   1.7472D-11  -1.3192D-11   3.1004D-12  -2.1506D-12  
D  VERAOGSW  NHY  CHEB_1     4.0078D-11  -9.2810D-12  -9.7853D-12   3.3079D-13  -7.8819D-13  -7.4851D-14  -9.6040D-13  -1.2395D-13   1.2031D-13  
D  VERAOGSW  NHY  CHEB_2     7.0300D-12  -1.4387D-12  -1.6171D-12  -6.1488D-16  -1.2928D-13  -3.3681D-14  -1.3893D-13  -3.6730D-14   2.4405D-14  
D  VERAOGSW  NHY  CHEB_3    -7.9409D-13   2.4865D-13   2.0952D-13  -1.6662D-14   1.9791D-14  -1.2497D-14   2.5542D-14  -8.7987D-15   2.4099D-15  
D  VERAOGSW  NHY  CHEB_4    -1.2693D-13   3.7896D-14   3.9049D-14  -1.6705D-15   1.4585D-14  -8.3158D-15  -5.1667D-15  -2.5451D-16  -4.0851D-16  
D  VERAOGSW  NHY  CHEB_5    -5.3933D-15  -4.5570D-15  -6.6013D-15   3.2711D-15  -2.4990D-15   2.7842D-16   8.5328D-16  -6.9777D-16   2.0461D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VERNAL    HYD  DER_NORT   6.6511D-05   3.1497D-05  -5.4696D-06  -6.5113D-06  -9.9045D-06  -1.4390D-05   5.5816D-06  -4.7193D-06   3.1932D-06  
D  VERNAL    HYD  DER_EAST   1.5582D-05  -1.3099D-05  -3.4420D-06  -2.7896D-06  -6.2443D-06   5.7378D-06  -6.0336D-06  -1.6513D-06   2.5777D-06  
D  VERNAL    HYD  CHEB_0     6.4056D-09   1.4657D-11  -8.8912D-12   6.8243D-12   2.6492D-12   3.5276D-13  -1.6597D-12   6.1160D-12   2.5097D-12  
D  VERNAL    HYD  CHEB_1     7.2264D-12   1.3633D-11   5.0988D-12  -1.8807D-12  -2.2178D-12   1.1821D-12   1.5010D-12   8.6609D-13   2.4482D-13  
D  VERNAL    HYD  CHEB_2    -7.1862D-13   2.3972D-12   8.3291D-13  -2.8153D-13  -3.5021D-13   2.3716D-13   2.4761D-13   2.0200D-13   4.1910D-14  
D  VERNAL    HYD  CHEB_3    -1.6991D-12  -2.6432D-13  -1.1056D-13   5.3650D-14   7.0583D-14  -1.5011D-14  -2.6967D-14  -2.6370D-15  -8.0505D-15  
D  VERNAL    HYD  CHEB_4    -5.7797D-13  -1.1957D-14  -1.5507D-14   4.8959D-16  -1.1281D-16   1.2960D-16   2.6789D-16  -3.7781D-15  -2.8250D-16  
D  VERNAL    HYD  CHEB_5    -7.4296D-14   5.7671D-15   1.0144D-14  -4.9580D-15  -4.7794D-15  -1.6999D-15  -4.5134D-17   1.5134D-15  -4.8001D-17  
#
D  VERNAL    NHY  DER_NORT  -7.9246D-04  -6.5416D-06  -4.4637D-04   4.6652D-05   4.6162D-04  -3.7938D-04  -4.5036D-04   5.2639D-04   3.0011D-04  
D  VERNAL    NHY  DER_EAST   5.7587D-04   1.5074D-04   1.0202D-04   3.0643D-05  -3.2488D-04  -4.3215D-04   2.7181D-04   7.9650D-04   4.3332D-04  
D  VERNAL    NHY  CHEB_0     2.4076D-10  -1.1060D-10  -5.5015D-11   1.2083D-11   4.4242D-11  -1.0230D-12  -3.5770D-11  -2.4384D-12   9.9722D-13  
D  VERNAL    NHY  CHEB_1     1.5176D-11  -5.7770D-12  -3.2433D-12  -1.2565D-13   2.3823D-12   1.2635D-13  -2.0029D-12  -8.9648D-14   4.0307D-13  
D  VERNAL    NHY  CHEB_2     2.8426D-12  -9.8301D-13  -5.7050D-13  -1.0734D-13   3.8995D-13   4.3509D-14  -3.3311D-13  -8.3129D-16   1.0630D-13  
D  VERNAL    NHY  CHEB_3    -2.3855D-13   1.3991D-13   6.7796D-14  -3.9692D-14  -6.2921D-14   3.7233D-15   4.9232D-14   1.2120D-14   5.3338D-15  
D  VERNAL    NHY  CHEB_4    -4.0774D-14   2.0445D-14   1.0050D-14  -2.5853D-15  -7.7404D-15  -8.0692D-17   5.4614D-15   2.6589D-15  -1.3098D-15  
D  VERNAL    NHY  CHEB_5    -6.7385D-15   2.9260D-15   6.9692D-16  -5.6777D-16  -8.3526D-17  -1.6891D-15  -3.3917D-16   5.0629D-16  -4.2178D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VICTORIA  HYD  DER_NORT   1.0056D-04   3.7982D-05   1.3732D-08   2.4849D-07  -1.8665D-05  -1.3629D-05  -2.5612D-05   1.9039D-06  -9.2294D-07  
D  VICTORIA  HYD  DER_EAST   2.2439D-05  -1.3567D-05   1.9784D-05   1.5794D-05  -1.2121D-05  -1.0108D-05  -2.8224D-05  -6.2257D-10   3.2876D-06  
D  VICTORIA  HYD  CHEB_0     7.6978D-09   6.5703D-12   6.8832D-12   5.3177D-12   3.1008D-12   1.1043D-11   1.0375D-11   3.2663D-12   2.2788D-12  
D  VICTORIA  HYD  CHEB_1    -8.4917D-12   1.1191D-11   6.2717D-12  -1.0593D-12  -4.2738D-12  -4.2944D-15  -1.4753D-12   5.4793D-13   2.8852D-13  
D  VICTORIA  HYD  CHEB_2    -3.1942D-12   1.6535D-12   1.0446D-12  -6.4182D-14  -5.9916D-13   2.0062D-14  -2.7727D-13   1.0698D-13   4.2242D-14  
D  VICTORIA  HYD  CHEB_3    -1.7016D-12  -3.3274D-13  -1.5390D-13   5.3260D-14   1.2646D-13   1.2009D-14   4.0859D-14  -2.2937D-15  -8.5175D-15  
D  VICTORIA  HYD  CHEB_4    -7.0516D-13   1.2234D-14  -9.7717D-15  -1.0988D-14  -1.0347D-14  -6.5701D-15   2.9167D-16  -1.3688D-15   1.6148D-15  
D  VICTORIA  HYD  CHEB_5    -9.6940D-14   4.0860D-15   5.4760D-15   3.2063D-15   1.6700D-15  -2.2115D-16  -3.0358D-15   1.4048D-16   3.8135D-16  
#
D  VICTORIA  NHY  DER_NORT   5.9783D-04   4.7608D-04   5.0693D-04  -1.8977D-04  -2.1346D-04  -2.7794D-04  -3.9776D-04  -2.7951D-04  -2.9964D-05  
D  VICTORIA  NHY  DER_EAST  -2.4330D-04  -5.7664D-04  -3.8314D-05  -1.6635D-04  -1.3885D-04  -1.3001D-04   2.7433D-04   4.0992D-04  -1.1199D-04  
D  VICTORIA  NHY  CHEB_0     3.6688D-10  -8.0506D-11  -3.7220D-11   1.6459D-11   2.0463D-11  -3.4179D-11  -1.3619D-11  -2.8812D-12   6.8735D-13  
D  VICTORIA  NHY  CHEB_1     2.1742D-11  -4.6850D-12  -2.0266D-12   5.8972D-13   1.2951D-12  -1.9082D-12  -6.1653D-13   3.5113D-14   1.4154D-13  
D  VICTORIA  NHY  CHEB_2     3.9488D-12  -8.2013D-13  -3.4176D-13   7.3012D-14   2.2970D-13  -3.3370D-13  -7.6588D-14   1.9410D-14   1.2848D-14  
D  VICTORIA  NHY  CHEB_3    -3.9372D-13   9.7041D-14   4.6050D-14  -2.5767D-14  -2.9696D-14   3.9102D-14   2.9040D-14   4.1508D-15  -8.8207D-15  
D  VICTORIA  NHY  CHEB_4    -5.8776D-14   1.1953D-14   1.2057D-15  -2.2391D-15  -1.5339D-15   6.7661D-15   1.3945D-15   5.9415D-17   1.5216D-16  
D  VICTORIA  NHY  CHEB_5    -9.7679D-15   2.1540D-15   1.6495D-15   3.6160D-16  -1.5398D-15   1.3314D-16   3.5278D-16  -4.4100D-16   4.3366D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VLA       HYD  DER_NORT   8.1754D-05   4.7480D-05   6.2855D-06  -2.9288D-05  -2.0914D-05  -2.4625D-06   1.2268D-05   2.7505D-08   7.2190D-07  
D  VLA       HYD  DER_EAST   6.8512D-06  -8.1597D-06   2.3389D-06  -4.1165D-06  -1.6405D-06   1.7590D-05   1.8722D-06   1.3535D-06  -8.7635D-07  
D  VLA       HYD  CHEB_0     6.0269D-09  -5.3910D-12  -1.0532D-11   5.0828D-12   3.8520D-12  -2.4363D-12  -2.4788D-12   4.2086D-12   1.5823D-12  
D  VLA       HYD  CHEB_1     8.7958D-12   9.9175D-12   5.2622D-12  -8.0649D-13  -1.0562D-12   1.0606D-12   6.8921D-13   7.4867D-13   1.5076D-13  
D  VLA       HYD  CHEB_2    -3.7188D-13   1.6721D-12   8.6310D-13  -9.1639D-14  -1.0667D-13   2.4969D-13   1.0856D-13   1.4277D-13   3.5241D-14  
D  VLA       HYD  CHEB_3    -1.6348D-12  -1.8596D-13  -1.1934D-13   1.8264D-14   3.5516D-14   8.5286D-15  -1.4362D-14  -9.8291D-15   3.6167D-15  
D  VLA       HYD  CHEB_4    -5.2527D-13   6.2914D-15  -6.4697D-15  -8.6804D-15  -3.3258D-15  -1.7504D-15   3.5573D-15  -1.4126D-15  -1.1091D-15  
D  VLA       HYD  CHEB_5    -1.0579D-13  -1.1808D-14   2.6648D-15   8.5519D-15   2.0087D-17  -1.7269D-15  -4.0908D-15   2.0493D-15  -1.5429D-15  
#
D  VLA       NHY  DER_NORT   3.4625D-04  -1.0333D-03  -3.7379D-04   2.9244D-04   4.0564D-04  -1.3725D-04   3.5601D-04  -1.4409D-04  -2.3805D-04  
D  VLA       NHY  DER_EAST   8.8544D-06  -3.8352D-04   4.7594D-04   4.3894D-04  -5.0127D-04  -2.1820D-04   3.2676D-04   3.6791D-04  -1.9629D-04  
D  VLA       NHY  CHEB_0     2.4188D-10  -1.6414D-10  -7.7349D-11   2.5345D-11   7.6714D-11   2.4421D-11  -3.6619D-11  -7.0049D-12  -9.1208D-12  
D  VLA       NHY  CHEB_1     1.5049D-11  -9.0068D-12  -4.4643D-12   1.2682D-12   4.3096D-12   1.3846D-12  -2.1081D-12   4.5838D-15  -2.3817D-13  
D  VLA       NHY  CHEB_2     2.8135D-12  -1.5546D-12  -7.9567D-13   1.9748D-13   7.4643D-13   2.4087D-13  -3.6219D-13   6.2720D-14  -4.5374D-14  
D  VLA       NHY  CHEB_3    -2.2261D-13   1.8649D-13   8.0634D-14  -3.4363D-14  -8.7911D-14  -2.6940D-14   4.1034D-14   2.3323D-14   8.6341D-15  
D  VLA       NHY  CHEB_4    -3.3526D-14   2.3264D-14   1.0940D-14  -3.9568D-15  -1.0568D-14  -2.5445D-15   5.2625D-15  -6.1693D-16   3.2536D-15  
D  VLA       NHY  CHEB_5    -4.4079D-15   8.7092D-16   4.7455D-16   2.0127D-16  -5.8919D-16  -5.0472D-16  -9.3576D-16  -1.1666D-15   1.2637D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VLA-N8    HYD  DER_NORT   8.1811D-05   4.7497D-05   6.2642D-06  -2.9294D-05  -2.0916D-05  -2.4612D-06   1.2281D-05   3.3910D-08   7.1990D-07  
D  VLA-N8    HYD  DER_EAST   6.8111D-06  -8.1868D-06   2.3369D-06  -4.1098D-06  -1.6452D-06   1.7588D-05   1.8641D-06   1.3474D-06  -8.7257D-07  
D  VLA-N8    HYD  CHEB_0     6.0271D-09  -5.3789D-12  -1.0530D-11   5.0803D-12   3.8517D-12  -2.4354D-12  -2.4806D-12   4.2127D-12   1.5847D-12  
D  VLA-N8    HYD  CHEB_1     8.7940D-12   9.9200D-12   5.2622D-12  -8.0785D-13  -1.0572D-12   1.0610D-12   6.8962D-13   7.4883D-13   1.5071D-13  
D  VLA-N8    HYD  CHEB_2    -3.7241D-13   1.6727D-12   8.6304D-13  -9.1828D-14  -1.0684D-13   2.4965D-13   1.0860D-13   1.4280D-13   3.5263D-14  
D  VLA-N8    HYD  CHEB_3    -1.6346D-12  -1.8595D-13  -1.1931D-13   1.8318D-14   3.5566D-14   8.5014D-15  -1.4337D-14  -9.8058D-15   3.6256D-15  
D  VLA-N8    HYD  CHEB_4    -5.2549D-13   6.1851D-15  -6.4451D-15  -8.6800D-15  -3.3093D-15  -1.7010D-15   3.5722D-15  -1.4205D-15  -1.0709D-15  
D  VLA-N8    HYD  CHEB_5    -1.0565D-13  -1.1761D-14   2.6626D-15   8.5295D-15  -1.6116D-17  -1.7563D-15  -4.0955D-15   2.0379D-15  -1.5697D-15  
#
D  VLA-N8    NHY  DER_NORT   3.5271D-04  -1.0348D-03  -3.7308D-04   2.9089D-04   4.0547D-04  -1.3605D-04   3.5757D-04  -1.4556D-04  -2.3984D-04  
D  VLA-N8    NHY  DER_EAST   9.0691D-06  -3.8599D-04   4.7534D-04   4.4060D-04  -5.0098D-04  -2.1855D-04   3.2613D-04   3.6538D-04  -1.9815D-04  
D  VLA-N8    NHY  CHEB_0     2.4188D-10  -1.6410D-10  -7.7329D-11   2.5323D-11   7.6702D-11   2.4433D-11  -3.6627D-11  -6.9922D-12  -9.1081D-12  
D  VLA-N8    NHY  CHEB_1     1.5051D-11  -9.0062D-12  -4.4631D-12   1.2660D-12   4.3091D-12   1.3862D-12  -2.1086D-12   6.1307D-15  -2.3787D-13  
D  VLA-N8    NHY  CHEB_2     2.8137D-12  -1.5544D-12  -7.9543D-13   1.9704D-13   7.4631D-13   2.4123D-13  -3.6230D-13   6.2931D-14  -4.5496D-14  
D  VLA-N8    NHY  CHEB_3    -2.2273D-13   1.8656D-13   8.0650D-14  -3.4385D-14  -8.7927D-14  -2.6903D-14   4.1074D-14   2.3306D-14   8.4955D-15  
D  VLA-N8    NHY  CHEB_4    -3.3530D-14   2.3268D-14   1.0919D-14  -3.9723D-15  -1.0560D-14  -2.5379D-15   5.2530D-15  -6.2737D-16   3.2244D-15  
D  VLA-N8    NHY  CHEB_5    -4.4213D-15   8.8071D-16   4.8285D-16   2.0768D-16  -5.8921D-16  -5.0649D-16  -9.3234D-16  -1.1743D-15   1.2810D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  VNDNBERG  HYD  DER_NORT   4.5088D-05   2.0975D-05   9.6860D-06  -8.5758D-06  -1.2035D-05   5.2223D-06  -5.7173D-06   1.9719D-06  -9.2361D-07  
D  VNDNBERG  HYD  DER_EAST  -1.1683D-05  -2.2811D-05  -2.0962D-05   2.7401D-07   1.7937D-05  -1.4081D-05   5.6417D-06  -1.7407D-06   2.5043D-06  
D  VNDNBERG  HYD  CHEB_0     7.7083D-09   3.4401D-11   1.4776D-11   7.3463D-12  -1.5345D-12   2.4311D-12  -1.4730D-12   1.2745D-12   3.4887D-12  
D  VNDNBERG  HYD  CHEB_1    -2.4669D-11   9.9276D-12   5.7418D-12  -1.2902D-12  -9.5353D-13   1.0263D-12   1.4662D-12   3.0021D-13   3.0462D-13  
D  VNDNBERG  HYD  CHEB_2    -6.1867D-12   1.4239D-12   8.5511D-13  -1.7142D-13  -1.0993D-13   2.3137D-13   2.5358D-13   4.8371D-14   3.4873D-14  
D  VNDNBERG  HYD  CHEB_3    -1.2645D-12  -3.2622D-13  -1.7821D-13   4.1375D-14   4.2094D-14  -1.8598D-14  -3.3659D-14  -8.1033D-15  -7.5701D-15  
D  VNDNBERG  HYD  CHEB_4    -6.7417D-13   4.7971D-15   4.5314D-15  -6.0252D-15  -6.0260D-15   1.2847D-15  -5.3736D-15  -5.3589D-16  -3.0883D-15  
D  VNDNBERG  HYD  CHEB_5    -1.1424D-13   1.3058D-14   4.6985D-15   3.0542D-15  -2.4986D-16   9.1544D-16   4.0222D-15   5.2725D-16   2.3996D-15  
#
D  VNDNBERG  NHY  DER_NORT  -1.0928D-03  -6.7646D-04  -5.8411D-04   4.0174D-05   4.7635D-04   4.8154D-04  -6.7913D-05   3.3819D-04   1.5591D-04  
D  VNDNBERG  NHY  DER_EAST   8.7757D-04  -1.3519D-03  -2.4494D-04  -1.0836D-05   8.0271D-04  -9.7445D-05  -4.0378D-04  -5.6705D-04  -2.5212D-04  
D  VNDNBERG  NHY  CHEB_0     3.3698D-10  -7.7892D-11  -4.9540D-11  -1.7995D-12   3.3235D-11  -3.0657D-11  -2.1828D-11   1.2811D-12   4.5056D-12  
D  VNDNBERG  NHY  CHEB_1     1.9766D-11  -4.6579D-12  -2.6188D-12  -4.8985D-13   1.7573D-12  -1.5341D-12  -8.4933D-13  -2.1973D-13   2.3792D-13  
D  VNDNBERG  NHY  CHEB_2     3.6639D-12  -8.6776D-13  -4.5937D-13  -1.0563D-13   3.3427D-13  -2.6801D-13  -1.4173D-13  -7.3881D-14   2.5694D-14  
D  VNDNBERG  NHY  CHEB_3    -3.2028D-13   7.2551D-14   5.3960D-14  -1.3233D-15  -3.5583D-14   3.5990D-14   2.6544D-14  -6.5572D-15  -1.2426D-14  
D  VNDNBERG  NHY  CHEB_4    -5.6904D-14   1.1452D-14   1.0117D-14   1.0196D-16  -3.2250D-15   5.1886D-15   1.4541D-15  -3.3367D-15  -2.4955D-15  
D  VNDNBERG  NHY  CHEB_5    -1.0770D-14   6.4926D-15   2.3829D-15  -1.2676D-17  -5.8192D-15   4.4567D-16   2.3313D-15   2.4333D-15   1.6141D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  WESTFORD  HYD  DER_NORT   1.4726D-04   6.4312D-05   4.6674D-06   1.9878D-05   2.7312D-05  -8.6124D-07   3.2609D-06  -4.1413D-07   2.1823D-06  
D  WESTFORD  HYD  DER_EAST  -2.0604D-06   7.6870D-06  -3.3315D-05  -1.5101D-06  -3.9078D-06  -1.3113D-05  -1.0742D-06  -1.4651D-07   8.9597D-07  
D  WESTFORD  HYD  CHEB_0     7.6257D-09   1.6958D-11   2.9449D-12   1.2623D-12  -7.8909D-12   8.7234D-12  -7.7694D-12   3.6349D-12  -2.6527D-12  
D  WESTFORD  HYD  CHEB_1    -8.9485D-12   1.6094D-11   1.0344D-11  -2.1168D-12   2.1338D-12  -2.2531D-12   2.6166D-12   5.7337D-13  -4.8886D-13  
D  WESTFORD  HYD  CHEB_2    -3.5219D-12   2.5632D-12   1.6510D-12  -3.0557D-13   4.9554D-13  -3.6018D-13   4.6437D-13   9.6228D-14  -7.1913D-14  
D  WESTFORD  HYD  CHEB_3    -1.5158D-12  -3.4984D-13  -2.3706D-13   5.9403D-14   9.8848D-15   5.7095D-14  -4.4607D-14  -1.1064D-14   5.5734D-15  
D  WESTFORD  HYD  CHEB_4    -7.2154D-13  -8.3043D-15  -4.7481D-15  -6.3032D-15  -7.4503D-15  -3.3594D-15   4.2093D-16   1.7413D-15   5.5747D-16  
D  WESTFORD  HYD  CHEB_5    -1.1126D-13  -1.1262D-15  -4.0319D-15   2.3997D-15  -4.3347D-16   8.8033D-16  -2.1217D-15  -8.8087D-16  -1.3514D-16  
#
D  WESTFORD  NHY  DER_NORT   1.2902D-03   4.5219D-04   3.4324D-04   2.8767D-04   6.0765D-04   1.0222D-04   2.8964D-04   2.9136D-04   9.2558D-05  
D  WESTFORD  NHY  DER_EAST  -7.1991D-04  -3.6815D-04   1.4301D-04   2.7169D-04   9.7352D-05  -2.2982D-04  -1.5625D-04   2.6905D-04  -8.8476D-05  
D  WESTFORD  NHY  CHEB_0     3.9675D-10  -2.1920D-10  -1.0800D-10   6.2972D-11   4.0032D-12  -8.5335D-12  -3.1258D-11  -1.1013D-11  -1.2674D-12  
D  WESTFORD  NHY  CHEB_1     2.2005D-11  -1.1925D-11  -6.6452D-12   3.0969D-12   2.8591D-13  -2.6158D-13  -1.6413D-12  -1.4453D-13  -3.5811D-14  
D  WESTFORD  NHY  CHEB_2     3.9265D-12  -2.1102D-12  -1.2457D-12   5.1302D-13   5.2670D-14  -3.5395D-14  -2.7495D-13  -9.9747D-15   2.6422D-14  
D  WESTFORD  NHY  CHEB_3    -4.2003D-13   2.2704D-13   9.9248D-14  -7.2073D-14   3.9229D-15   1.3036D-14   3.5976D-14   3.9358D-15   6.7475D-15  
D  WESTFORD  NHY  CHEB_4    -6.6971D-14   3.9745D-14   2.1091D-14  -1.2773D-14  -7.2483D-15   1.4684D-15   7.5437D-15   2.5221D-15   1.0296D-15  
D  WESTFORD  NHY  CHEB_5    -6.1063D-15  -2.5185D-16   2.3572D-15   1.7353D-15   2.5218D-15   1.4646D-16  -5.5548D-16  -2.6118D-15  -2.9212D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  WETTZELL  HYD  DER_NORT   9.8255D-05   4.2581D-05  -1.7485D-05   3.0568D-05   1.8130D-05  -4.3364D-06   1.4181D-05  -4.8736D-07   1.9216D-07  
D  WETTZELL  HYD  DER_EAST  -1.3095D-05  -2.2428D-05  -5.5882D-06  -9.7938D-07  -5.3265D-06  -5.5530D-06  -1.1732D-05   1.4983D-06  -8.6195D-07  
D  WETTZELL  HYD  CHEB_0     7.1902D-09   1.8629D-11  -4.6796D-12   8.1998D-12  -7.6974D-12   9.9994D-12  -1.4260D-11  -6.9357D-14  -1.6684D-12  
D  WETTZELL  HYD  CHEB_1     2.6363D-14   1.0890D-11   6.1994D-12  -1.0100D-12   6.1159D-13  -1.3340D-13  -3.1154D-13  -6.6793D-14  -5.3786D-13  
D  WETTZELL  HYD  CHEB_2    -2.0744D-12   1.4423D-12   9.3237D-13  -1.2535D-13   2.3203D-13  -3.8127D-14  -3.9072D-14  -2.9076D-14  -9.3357D-14  
D  WETTZELL  HYD  CHEB_3    -1.7660D-12  -3.2761D-13  -1.7104D-13   3.0855D-14   1.6850D-14  -5.4043D-15   8.3872D-15   3.9122D-16   8.2696D-15  
D  WETTZELL  HYD  CHEB_4    -6.7261D-13   1.9870D-14  -2.8693D-15  -1.9645D-15  -1.1062D-14  -1.5097D-15   2.6584D-15  -8.3366D-16  -8.1809D-16  
D  WETTZELL  HYD  CHEB_5    -9.1048D-14  -4.8132D-16   3.1340D-15  -4.7129D-16   2.3292D-15   2.0188D-15   3.0743D-15   9.2831D-16  -8.8679D-17  
#
D  WETTZELL  NHY  DER_NORT   9.8203D-04  -4.1891D-04  -5.5097D-05  -2.0479D-05   4.0220D-05   9.0396D-05   4.7405D-04  -1.6525D-04  -1.9277D-04  
D  WETTZELL  NHY  DER_EAST   3.1200D-04  -5.5728D-04   3.0438D-04   1.4850D-04   2.3177D-04   1.0072D-04  -1.0437D-04   1.6631D-04  -5.4033D-06  
D  WETTZELL  NHY  CHEB_0     3.3694D-10  -1.3350D-10  -7.0418D-11   3.3383D-11   4.8901D-12  -1.2354D-11   2.0412D-11  -3.8662D-12   3.3749D-12  
D  WETTZELL  NHY  CHEB_1     2.0402D-11  -7.9106D-12  -3.6191D-12   1.8725D-12   2.7576D-13  -5.4943D-13   1.3220D-12  -1.7752D-13   1.9890D-13  
D  WETTZELL  NHY  CHEB_2     3.7831D-12  -1.4329D-12  -6.3381D-13   3.2144D-13   5.3440D-14  -7.3618D-14   2.3860D-13  -3.7271D-14   3.5787D-14  
D  WETTZELL  NHY  CHEB_3    -3.3712D-13   1.5694D-13   7.4194D-14  -4.5046D-14  -2.8557D-15   1.8138D-14  -2.9163D-14   2.5679D-15  -5.5988D-15  
D  WETTZELL  NHY  CHEB_4    -4.9082D-14   1.9261D-14   8.5241D-15  -4.2302D-15   7.1225D-17   1.0008D-15  -1.8280D-15  -1.2486D-15  -2.1721D-16  
D  WETTZELL  NHY  CHEB_5    -1.2882D-14   7.9341D-15   2.1952D-15  -2.0556D-15  -6.7573D-16  -8.5802D-16  -2.4233D-15   1.6242D-15  -1.2929D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  WHTHORSE  HYD  DER_NORT   5.8419D-05   4.2807D-05  -1.4320D-05  -6.7462D-06   2.2848D-05   1.2103D-05   2.0708D-05   7.3728D-07  -3.6868D-07  
D  WHTHORSE  HYD  DER_EAST   2.5483D-05   8.9086D-06   2.1944D-06   6.5858D-06  -3.7723D-06   2.7430D-05  -8.8814D-06  -2.5839D-06  -8.1382D-07  
D  WHTHORSE  HYD  CHEB_0     7.0755D-09  -2.1906D-11  -6.0461D-12  -9.7302D-12   6.0008D-12  -1.0232D-11   1.6425D-11   2.8354D-12   1.1434D-12  
D  WHTHORSE  HYD  CHEB_1     1.6348D-11   1.5455D-11   5.0496D-12  -3.6150D-12  -3.5637D-12  -1.9026D-12  -3.4109D-12   4.9973D-13   3.3188D-13  
D  WHTHORSE  HYD  CHEB_2     9.8508D-13   2.5252D-12   9.9943D-13  -5.8907D-13  -3.6744D-13  -3.5733D-13  -5.7341D-13   9.2254D-14   6.0500D-14  
D  WHTHORSE  HYD  CHEB_3    -1.9507D-12  -3.0854D-13  -6.8499D-14   8.3147D-14   1.3663D-13   2.6563D-14   6.3398D-14  -3.0327D-15  -5.1364D-15  
D  WHTHORSE  HYD  CHEB_4    -7.0330D-13  -5.5842D-15  -6.3071D-15  -5.2832D-15  -1.6931D-14  -5.0970D-15  -4.3195D-15  -1.3480D-16  -1.0778D-16  
D  WHTHORSE  HYD  CHEB_5    -9.5707D-14  -2.3739D-15  -8.0059D-15   3.0639D-15   2.7721D-15   1.2729D-15   7.3221D-15  -6.1094D-16  -4.0207D-16  
#
D  WHTHORSE  NHY  DER_NORT   1.0207D-03   1.0566D-03   3.0807D-04  -1.3386D-04   4.0133D-04  -5.3323D-04   1.8912D-05  -1.1643D-04   3.0912D-05  
D  WHTHORSE  NHY  DER_EAST   7.3132D-04   1.3494D-04   4.4078D-04   6.6387D-05   2.9992D-04  -5.1084D-04  -3.7323D-04   2.8228D-04  -3.1257D-05  
D  WHTHORSE  NHY  CHEB_0     2.2360D-10  -1.4670D-10  -5.6859D-11   4.6098D-11   3.0393D-11   6.7218D-12   1.4321D-11  -2.0920D-12  -4.7984D-12  
D  WHTHORSE  NHY  CHEB_1     1.4082D-11  -8.9951D-12  -3.5380D-12   2.5756D-12   1.8650D-12   8.1388D-13   7.2589D-13  -1.7083D-13  -2.4548D-13  
D  WHTHORSE  NHY  CHEB_2     2.6249D-12  -1.6600D-12  -6.4856D-13   4.6039D-13   3.3609D-13   1.7650D-13   1.2416D-13  -3.6473D-14  -3.5088D-14  
D  WHTHORSE  NHY  CHEB_3    -2.1852D-13   1.4307D-13   5.9486D-14  -4.8263D-14  -3.3783D-14  -3.6943D-15  -1.7206D-14  -2.2845D-15   6.4760D-15  
D  WHTHORSE  NHY  CHEB_4    -3.4602D-14   2.2667D-14   9.1976D-15  -6.8410D-15  -5.7151D-15  -3.8950D-17  -1.3772D-15   4.0132D-15   1.6366D-15  
D  WHTHORSE  NHY  CHEB_5    -5.9922D-15   1.9441D-15   1.5168D-15  -1.2497D-15  -1.9410D-16  -1.2735D-15  -6.6716D-16  -1.8948D-15  -7.3777D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  WSTRBOR7  HYD  DER_NORT   1.3694D-04   6.5076D-05  -2.3346D-05   3.7998D-05  -9.1009D-06   3.1230D-06   7.2694D-06  -6.7809D-07  -1.5639D-07  
D  WSTRBOR7  HYD  DER_EAST   6.3890D-06  -1.8017D-05  -2.0354D-05   8.5336D-06  -2.0548D-05  -1.3691D-05  -7.2192D-07   3.4216D-06  -1.1542D-06  
D  WSTRBOR7  HYD  CHEB_0     7.6848D-09   1.2047D-11   1.1872D-11   6.1270D-13  -6.1803D-12   1.3383D-11  -1.7101D-11  -8.7967D-13  -3.7059D-13  
D  WSTRBOR7  HYD  CHEB_1    -7.1505D-12   1.1296D-11   5.8574D-12   7.0409D-14   5.8298D-13  -5.9117D-13  -3.7392D-13  -1.5173D-13  -3.7271D-13  
D  WSTRBOR7  HYD  CHEB_2    -3.5869D-12   1.3408D-12   8.4839D-13   5.4060D-14   1.9076D-13  -1.2687D-13  -5.6670D-14  -8.3999D-15  -4.9540D-14  
D  WSTRBOR7  HYD  CHEB_3    -1.7139D-12  -3.6332D-13  -1.6820D-13   1.1508D-14   1.5126D-15   1.5455D-15   1.4124D-14   1.1778D-15   7.0912D-15  
D  WSTRBOR7  HYD  CHEB_4    -7.0099D-13   3.0153D-14  -2.2143D-15  -9.7861D-16  -7.0960D-15   2.6348D-15   3.5631D-15  -7.1780D-16  -9.5195D-16  
D  WSTRBOR7  HYD  CHEB_5    -1.1100D-13   2.7038D-17   2.6898D-15  -5.3426D-16   1.8238D-16  -6.6001D-16  -8.0992D-16  -1.7338D-16  -3.2858D-16  
#
D  WSTRBOR7  NHY  DER_NORT   4.4085D-04  -1.7228D-04   6.1997D-05  -1.4707D-05  -2.6221D-04  -1.0654D-04   2.6311D-04  -6.7176D-05   3.8980D-04  
D  WSTRBOR7  NHY  DER_EAST  -2.3205D-04  -1.5861D-05  -8.7902D-05   4.3593D-06  -2.9938D-05  -9.6717D-05  -7.8059D-05   2.0933D-04   2.8523D-04  
D  WSTRBOR7  NHY  CHEB_0     4.0704D-10  -1.2550D-10  -9.5902D-11   1.6901D-11   6.6192D-12   2.2571D-12   2.5915D-11   4.1464D-12   2.6052D-12  
D  WSTRBOR7  NHY  CHEB_1     2.3816D-11  -6.9607D-12  -5.3485D-12   9.2209D-13   4.6986D-13   2.8074D-13   1.3269D-12  -2.4571D-13   1.3425D-13  
D  WSTRBOR7  NHY  CHEB_2     4.3086D-12  -1.2266D-12  -9.2160D-13   1.8295D-13   8.8872D-14   3.6872D-14   1.9072D-13  -3.2563D-14   2.9190D-14  
D  WSTRBOR7  NHY  CHEB_3    -4.1511D-13   1.2461D-13   1.1170D-13  -4.2120D-15  -1.0345D-14  -3.1675D-15  -3.8815D-14   7.5134D-15   2.8268D-15  
D  WSTRBOR7  NHY  CHEB_4    -7.3847D-14   2.8310D-14   2.0979D-14  -6.2032D-15  -1.8068D-15  -3.0509D-15  -2.2122D-15   1.0806D-15  -2.8916D-15  
D  WSTRBOR7  NHY  CHEB_5    -3.3906D-15  -4.5349D-15   5.7356D-16   2.0473D-15  -4.4803D-16   3.6016D-15  -8.1798D-16  -1.3322D-15   3.5679D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  WSTRBORK  HYD  DER_NORT   1.3703D-04   6.5069D-05  -2.3322D-05   3.8000D-05  -9.0747D-06   3.1325D-06   7.2722D-06  -6.8390D-07  -1.5699D-07  
D  WSTRBORK  HYD  DER_EAST   6.3383D-06  -1.8018D-05  -2.0344D-05   8.5227D-06  -2.0510D-05  -1.3694D-05  -8.0690D-07   3.4182D-06  -1.1587D-06  
D  WSTRBORK  HYD  CHEB_0     7.6846D-09   1.2063D-11   1.1846D-11   6.0787D-13  -6.1990D-12   1.3367D-11  -1.7100D-11  -8.7603D-13  -3.8567D-13  
D  WSTRBORK  HYD  CHEB_1    -7.1402D-12   1.1301D-11   5.8600D-12   6.7748D-14   5.8520D-13  -5.8953D-13  -3.7379D-13  -1.5146D-13  -3.7384D-13  
D  WSTRBORK  HYD  CHEB_2    -3.5868D-12   1.3427D-12   8.4840D-13   5.3389D-14   1.9126D-13  -1.2656D-13  -5.6806D-14  -9.8071D-15  -4.9933D-14  
D  WSTRBORK  HYD  CHEB_3    -1.7138D-12  -3.6367D-13  -1.6819D-13   1.1598D-14   1.4353D-15   1.4332D-15   1.4093D-14   1.5695D-15   7.2455D-15  
D  WSTRBORK  HYD  CHEB_4    -7.0115D-13   3.0308D-14  -2.2544D-15  -8.7059D-16  -7.0863D-15   2.6164D-15   3.6204D-15  -8.1674D-16  -9.4924D-16  
D  WSTRBORK  HYD  CHEB_5    -1.1099D-13   2.2151D-17   2.7083D-15  -6.7099D-16   1.4183D-16  -6.9330D-16  -8.4514D-16  -1.5955D-16  -3.6018D-16  
#
D  WSTRBORK  NHY  DER_NORT   4.3903D-04  -1.7132D-04   5.9628D-05  -1.6337D-05  -2.6085D-04  -1.0511D-04   2.6171D-04  -6.9783D-05   3.9001D-04  
D  WSTRBORK  NHY  DER_EAST  -2.3494D-04  -1.8078D-05  -8.4622D-05   1.6860D-06  -2.7211D-05  -9.6184D-05  -8.1727D-05   2.0166D-04   2.8578D-04  
D  WSTRBORK  NHY  CHEB_0     4.0696D-10  -1.2550D-10  -9.5896D-11   1.6922D-11   6.6123D-12   2.2331D-12   2.5915D-11   4.2056D-12   2.7160D-12  
D  WSTRBORK  NHY  CHEB_1     2.3821D-11  -6.9777D-12  -5.3422D-12   9.3527D-13   4.6777D-13   2.7325D-13   1.3193D-12  -2.3607D-13   1.4109D-13  
D  WSTRBORK  NHY  CHEB_2     4.3073D-12  -1.2265D-12  -9.2077D-13   1.8390D-13   8.9519D-14   3.6158D-14   1.8805D-13  -3.4189D-14   3.0263D-14  
D  WSTRBORK  NHY  CHEB_3    -4.1578D-13   1.2588D-13   1.1157D-13  -4.9273D-15  -1.0053D-14  -2.8980D-15  -3.8880D-14   6.3014D-15   2.8151D-15  
D  WSTRBORK  NHY  CHEB_4    -7.3788D-14   2.8234D-14   2.0983D-14  -6.1789D-15  -1.8569D-15  -3.0385D-15  -2.0667D-15   1.2197D-15  -2.7351D-15  
D  WSTRBORK  NHY  CHEB_5    -3.2457D-15  -4.7173D-15   6.0372D-16   2.1546D-15  -4.7355D-16   3.5068D-15  -8.2099D-16  -1.1697D-15   3.5887D-16  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YAKATAGA  HYD  DER_NORT  -7.3574D-05   3.6337D-05  -2.1844D-05  -1.3084D-05   2.4393D-05  -8.2307D-06   1.5548D-05   5.5592D-06   7.2809D-07  
D  YAKATAGA  HYD  DER_EAST   7.8932D-05   1.7084D-05  -9.0564D-06   9.2940D-06  -1.1575D-06   3.9337D-05   7.7353D-06  -2.8607D-06   1.0849D-06  
D  YAKATAGA  HYD  CHEB_0     7.6685D-09  -4.3571D-11  -3.3643D-12  -6.8482D-12   5.0792D-12  -1.0092D-11   2.3014D-11  -1.3371D-12   4.9714D-13  
D  YAKATAGA  HYD  CHEB_1     5.9916D-12   1.3848D-11   5.2870D-12  -2.7757D-12  -3.8745D-12  -8.8026D-13  -3.0836D-12   2.5510D-14   2.6319D-13  
D  YAKATAGA  HYD  CHEB_2    -1.3585D-12   2.0597D-12   9.5781D-13  -4.0454D-13  -3.8258D-13  -2.1862D-13  -4.7855D-13  -1.3578D-14   4.4118D-14  
D  YAKATAGA  HYD  CHEB_3    -1.8656D-12  -3.3163D-13  -1.0144D-13   7.8181D-14   1.4446D-13   3.4932D-14   7.5222D-14   7.5311D-16  -6.9129D-15  
D  YAKATAGA  HYD  CHEB_4    -7.0951D-13   2.3886D-14  -4.4496D-15  -3.4563D-15  -1.1057D-14   1.2389D-14  -8.0043D-15   1.4238D-15  -1.4565D-15  
D  YAKATAGA  HYD  CHEB_5    -1.4112D-13  -8.2698D-15   5.2195D-16   2.6805D-15  -1.3464D-15  -1.3646D-14   1.9048D-15  -1.7039D-15   3.6552D-16  
#
D  YAKATAGA  NHY  DER_NORT  -4.1162D-04   1.2860D-03   9.7451D-05  -5.7018D-04   4.4573D-04  -6.6994D-04  -3.9958D-04  -4.8106D-05  -1.2534D-04  
D  YAKATAGA  NHY  DER_EAST   9.9951D-04   1.8637D-04   4.7905D-04  -2.6744D-04   1.0185D-04  -2.9056D-04   2.6351D-04   1.6960D-04  -1.8537D-05  
D  YAKATAGA  NHY  CHEB_0     2.9743D-10  -1.5442D-10  -7.9856D-11   4.3855D-11   4.5559D-11   1.4451D-11   1.4681D-11  -2.1262D-12  -5.4088D-13  
D  YAKATAGA  NHY  CHEB_1     1.7736D-11  -8.7767D-12  -4.5603D-12   2.1173D-12   2.5697D-12   1.3489D-12   7.1064D-13  -1.2378D-13   3.5623D-15  
D  YAKATAGA  NHY  CHEB_2     3.0904D-12  -1.4561D-12  -7.7004D-13   3.2872D-13   4.3223D-13   2.6338D-13   1.4911D-13  -3.3069D-14   3.9303D-15  
D  YAKATAGA  NHY  CHEB_3    -3.5565D-13   1.9631D-13   1.0265D-13  -5.2454D-14  -5.7483D-14  -1.9127D-14  -4.6162D-15  -5.7765D-16   3.4310D-15  
D  YAKATAGA  NHY  CHEB_4    -3.7578D-14   1.3838D-14   1.1099D-14  -1.2015D-15  -7.1911D-15  -4.8937D-15  -1.9815D-15   1.3499D-15  -4.3599D-17  
D  YAKATAGA  NHY  CHEB_5    -8.1011D-15   3.7119D-15   1.9999D-15  -8.0590D-16  -1.0081D-15  -2.3743D-16  -3.2064D-16  -2.2204D-16  -7.7536D-17  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YAMAGUCH  HYD  DER_NORT   1.4342D-04   6.7458D-05   4.7110D-05   5.0701D-06  -2.6561D-05  -6.0614D-06  -7.1220D-06  -1.3012D-06  -2.0690D-07  
D  YAMAGUCH  HYD  DER_EAST   1.0853D-05  -1.6551D-07  -1.4767D-05   2.3353D-06  -3.8352D-06   2.2205D-06  -1.6433D-06  -3.2524D-07   1.2245D-07  
D  YAMAGUCH  HYD  CHEB_0     7.6084D-09   7.0654D-11   1.3827D-11  -1.0398D-12  -6.4723D-12   4.9226D-13  -2.3072D-14  -2.7498D-12   2.7796D-12  
D  YAMAGUCH  HYD  CHEB_1    -1.8542D-11   1.6487D-11   9.8035D-12  -7.8705D-13  -2.1924D-12   2.5175D-14   4.6119D-13  -4.3783D-13   3.8005D-13  
D  YAMAGUCH  HYD  CHEB_2    -4.9742D-12   2.5125D-12   1.5094D-12  -5.7944D-14  -2.8660D-13   2.9054D-14   9.0325D-14  -7.5503D-14   5.6507D-14  
D  YAMAGUCH  HYD  CHEB_3    -1.3353D-12  -4.4081D-13  -2.6575D-13   5.2680D-14   8.4954D-14   6.5962D-15  -7.9656D-15   1.2720D-14  -3.6239D-15  
D  YAMAGUCH  HYD  CHEB_4    -7.0033D-13  -1.7531D-14  -1.0591D-14  -1.0933D-15   4.6329D-15  -2.1939D-15  -1.8226D-15   1.5204D-16   1.7091D-15  
D  YAMAGUCH  HYD  CHEB_5    -1.0434D-13   5.4280D-15   2.4828D-15  -2.9499D-16  -3.6735D-15   8.8035D-16   7.3587D-17  -8.0462D-16  -7.8970D-16  
#
D  YAMAGUCH  NHY  DER_NORT   1.8716D-03   3.5626D-04   3.3547D-04   1.6566D-06   5.5391D-05   3.3504D-04   5.5380D-05   8.5464D-05  -4.1801D-05  
D  YAMAGUCH  NHY  DER_EAST   6.5143D-04   3.9937D-05  -2.6756D-04  -3.4081D-04   6.4076D-05   1.8982D-04  -1.3091D-04   1.5583D-04  -1.6705D-04  
D  YAMAGUCH  NHY  CHEB_0     5.3502D-10  -3.7827D-10  -2.0802D-10   1.0160D-10   1.3108D-10  -1.7858D-11  -6.4642D-11   3.9847D-12  -3.3377D-12  
D  YAMAGUCH  NHY  CHEB_1     2.8829D-11  -1.7820D-11  -1.0967D-11   3.7359D-12   5.6280D-12  -5.7555D-13  -2.3466D-12   8.5317D-14  -9.8216D-14  
D  YAMAGUCH  NHY  CHEB_2     5.1158D-12  -2.9583D-12  -1.8926D-12   5.4463D-13   8.7342D-13  -1.1372D-13  -3.2171D-13  -2.0531D-14  -4.3591D-14  
D  YAMAGUCH  NHY  CHEB_3    -5.7477D-13   4.6089D-13   2.4966D-13  -1.2970D-13  -1.7714D-13   3.0133D-15   8.9044D-14  -1.9677D-14  -6.2559D-15  
D  YAMAGUCH  NHY  CHEB_4    -7.9958D-14   4.9322D-14   2.8599D-14  -1.3532D-14  -1.3450D-14   4.7310D-15   7.4916D-15   4.5852D-15   1.0041D-14  
D  YAMAGUCH  NHY  CHEB_5    -1.9410D-14   1.8851D-14   1.2036D-14  -2.9302D-15  -1.1223D-14  -1.9481D-15   4.7904D-15  -1.8330D-15  -1.7907D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YEBES     HYD  DER_NORT   7.7677D-05  -1.1707D-06  -1.4525D-05   8.7929D-06   1.3760D-05  -2.5717D-05   1.9155D-05   6.3957D-07   4.7551D-07  
D  YEBES     HYD  DER_EAST  -5.1074D-06  -1.6101D-05  -2.1601D-05   8.4360D-06  -1.7336D-05  -1.1567D-05   1.6999D-05   1.6067D-06  -9.6723D-07  
D  YEBES     HYD  CHEB_0     6.9561D-09   2.6676D-11   2.9928D-13   1.7056D-11  -1.5327D-13   9.3385D-12  -5.8939D-12   7.3679D-13  -2.4757D-12  
D  YEBES     HYD  CHEB_1    -9.7118D-13   9.7268D-12   7.7341D-12  -1.8845D-12  -1.9493D-12   6.0395D-13  -4.9354D-13   1.2408D-13  -6.5112D-13  
D  YEBES     HYD  CHEB_2    -2.4888D-12   1.4192D-12   1.2569D-12  -3.1313D-13  -2.7143D-13   1.2599D-13  -1.1199D-13   1.7285D-14  -1.2495D-13  
D  YEBES     HYD  CHEB_3    -1.6541D-12  -2.7051D-13  -1.9134D-13   3.9875D-14   5.8898D-14  -1.4625D-14   1.4163D-14  -1.9699D-15   7.2754D-15  
D  YEBES     HYD  CHEB_4    -6.2336D-13   1.5459D-14   6.9124D-16  -1.1387D-15  -2.6174D-15  -6.5273D-16  -1.6076D-15  -8.9902D-16  -1.2237D-15  
D  YEBES     HYD  CHEB_5    -1.0994D-13  -2.1590D-15   1.0199D-18  -5.8579D-16  -1.7504D-15  -1.6117D-16   6.9219D-17   1.1688D-15   7.2820D-16  
#
D  YEBES     NHY  DER_NORT  -4.4724D-04   5.1195D-04   7.3657D-05  -4.4902D-05  -2.4891D-04   3.4235D-05   3.7090D-04   1.4519D-05  -1.4900D-04  
D  YEBES     NHY  DER_EAST   3.2148D-04  -3.0115D-04   1.0044D-04   6.7533D-06  -3.8042D-05   5.6551D-05  -1.8977D-05   6.8966D-06  -1.3543D-06  
D  YEBES     NHY  CHEB_0     3.2124D-10  -7.2844D-11  -7.0917D-11  -2.1840D-11  -2.3525D-11  -2.0488D-11   2.9633D-11  -5.4759D-12   2.9500D-12  
D  YEBES     NHY  CHEB_1     2.0364D-11  -4.4310D-12  -3.8251D-12  -1.3944D-12  -1.4578D-12  -1.2961D-12   1.5299D-12  -1.9685D-13  -7.7630D-15  
D  YEBES     NHY  CHEB_2     3.7763D-12  -8.0591D-13  -6.6862D-13  -2.5326D-13  -2.7203D-13  -2.4033D-13   2.4899D-13  -1.8104D-14  -5.7386D-15  
D  YEBES     NHY  CHEB_3    -3.2305D-13   7.5649D-14   8.1615D-14   2.4591D-14   2.1651D-14   2.1162D-14  -3.7312D-14   1.1669D-14  -5.4984D-15  
D  YEBES     NHY  CHEB_4    -4.7749D-14   1.3327D-14   9.9708D-15   1.8264D-15   3.9039D-15   1.4433D-15  -4.1396D-15  -1.7734D-15  -9.0831D-16  
D  YEBES     NHY  CHEB_5    -1.0009D-14   7.5229D-16   2.2163D-15   8.9285D-16   1.3589D-15   1.9859D-15   3.2110D-17   1.1006D-15  -1.1715D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YEBES40M  HYD  DER_NORT   7.7814D-05  -1.1883D-06  -1.4535D-05   8.8220D-06   1.3785D-05  -2.5736D-05   1.9171D-05   6.1090D-07   4.4493D-07  
D  YEBES40M  HYD  DER_EAST  -5.0692D-06  -1.6135D-05  -2.1600D-05   8.4552D-06  -1.7363D-05  -1.1576D-05   1.7022D-05   1.6320D-06  -9.6035D-07  
D  YEBES40M  HYD  CHEB_0     6.9487D-09   2.6414D-11   1.7597D-13   1.7040D-11  -1.2906D-13   9.3061D-12  -5.8881D-12   7.5165D-13  -2.4020D-12  
D  YEBES40M  HYD  CHEB_1    -8.2016D-13   9.7104D-12   7.7275D-12  -1.8855D-12  -1.9476D-12   6.0368D-13  -4.9537D-13   1.2591D-13  -6.4428D-13  
D  YEBES40M  HYD  CHEB_2    -2.4589D-12   1.4164D-12   1.2558D-12  -3.1301D-13  -2.7122D-13   1.2532D-13  -1.1164D-13   1.7797D-14  -1.2337D-13  
D  YEBES40M  HYD  CHEB_3    -1.6568D-12  -2.6977D-13  -1.9050D-13   3.9492D-14   5.8971D-14  -1.4346D-14   1.3739D-14  -1.9128D-15   7.1245D-15  
D  YEBES40M  HYD  CHEB_4    -6.2226D-13   1.5475D-14   4.8898D-16  -9.3821D-16  -2.7424D-15  -7.5137D-16  -1.4323D-15  -9.7908D-16  -1.1796D-15  
D  YEBES40M  HYD  CHEB_5    -1.1026D-13  -1.9382D-15   2.0816D-16  -6.4104D-16  -1.5941D-15  -9.5815D-17  -1.0946D-16   1.1619D-15   6.5758D-16  
#
D  YEBES40M  NHY  DER_NORT  -4.4564D-04   5.1135D-04   7.3802D-05  -4.4577D-05  -2.4993D-04   3.3839D-05   3.7151D-04   1.3771D-05  -1.4861D-04  
D  YEBES40M  NHY  DER_EAST   3.2234D-04  -3.0218D-04   1.0163D-04   7.7110D-06  -3.8863D-05   5.7078D-05  -1.8460D-05   7.8442D-06  -5.4413D-07  
D  YEBES40M  NHY  CHEB_0     3.1997D-10  -7.2738D-11  -7.0735D-11  -2.1755D-11  -2.3404D-11  -2.0420D-11   2.9529D-11  -5.4427D-12   3.0724D-12  
D  YEBES40M  NHY  CHEB_1     2.0297D-11  -4.4334D-12  -3.8216D-12  -1.3904D-12  -1.4511D-12  -1.2929D-12   1.5248D-12  -1.9525D-13   3.6810D-15  
D  YEBES40M  NHY  CHEB_2     3.7662D-12  -8.0783D-13  -6.6880D-13  -2.5182D-13  -2.7096D-13  -2.4109D-13   2.4839D-13  -1.8146D-14  -3.0964D-15  
D  YEBES40M  NHY  CHEB_3    -3.2215D-13   7.6210D-14   8.1468D-14   2.3974D-14   2.1815D-14   2.1910D-14  -3.7163D-14   1.1727D-14  -6.1343D-15  
D  YEBES40M  NHY  CHEB_4    -4.7017D-14   1.2815D-14   9.6980D-15   2.2691D-15   3.8588D-15   6.9227D-16  -4.0188D-15  -1.9853D-15  -7.2755D-16  
D  YEBES40M  NHY  CHEB_5    -1.0334D-14   1.2392D-15   2.2760D-15   6.1996D-16   1.4979D-15   2.3564D-15  -2.5424D-17   1.0724D-15  -1.3620D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YELLOWKN  HYD  DER_NORT   8.3112D-05   2.5818D-05   5.5683D-06   3.4237D-06   5.7430D-06   1.1581D-05   2.1328D-06  -1.3815D-07  -1.1735D-07  
D  YELLOWKN  HYD  DER_EAST  -5.9375D-05  -1.5292D-05  -3.3371D-06  -1.8031D-05  -8.2257D-06   1.1238D-05  -3.3426D-05  -5.1841D-07  -5.5739D-07  
D  YELLOWKN  HYD  CHEB_0     7.5353D-09   1.8396D-11   2.4159D-11  -2.4638D-11   1.0239D-11  -2.4480D-11   1.6041D-11   4.8532D-13   8.6369D-13  
D  YELLOWKN  HYD  CHEB_1     1.1617D-11   1.9219D-11   6.8972D-12  -3.6633D-12  -2.5505D-12  -3.4501D-12  -6.1551D-13   2.3732D-13   2.3682D-13  
D  YELLOWKN  HYD  CHEB_2    -1.1460D-13   2.9517D-12   1.2942D-12  -5.5367D-13  -2.1720D-13  -5.8922D-13  -5.8695D-14   3.2846D-14   4.4422D-14  
D  YELLOWKN  HYD  CHEB_3    -2.0086D-12  -4.4337D-13  -1.1235D-13   8.5615D-14   1.0270D-13   6.8888D-14   2.9631D-14  -2.3791D-15  -7.0946D-15  
D  YELLOWKN  HYD  CHEB_4    -7.0993D-13   1.1908D-14  -1.5036D-14   7.9736D-16  -8.0210D-15   3.4338D-15  -3.6860D-15   7.1142D-16  -6.5002D-16  
D  YELLOWKN  HYD  CHEB_5    -1.0709D-13  -1.8905D-15  -1.8883D-16  -2.1856D-16  -4.1323D-15   1.3317D-15  -5.9713D-16  -3.6346D-16   4.5616D-16  
#
D  YELLOWKN  NHY  DER_NORT   1.4540D-03  -1.4936D-04   6.3251D-04  -4.8659D-04   3.4401D-04  -2.4441D-04   1.0678D-04   1.7187D-04  -1.1845D-04  
D  YELLOWKN  NHY  DER_EAST  -8.5872D-04   5.6339D-04  -2.0898D-04  -1.3660D-04  -2.5066D-04  -1.0524D-04  -4.7804D-04  -1.2088D-05  -5.4132D-05  
D  YELLOWKN  NHY  CHEB_0     2.2285D-10  -1.6502D-10  -7.6937D-11   3.5085D-11   4.0374D-11   1.9747D-11  -1.2255D-11  -9.1822D-14  -2.5589D-12  
D  YELLOWKN  NHY  CHEB_1     1.2676D-11  -9.6177D-12  -4.2012D-12   1.6859D-12   2.1285D-12   1.5452D-12  -6.5463D-13   6.5410D-14  -1.1916D-13  
D  YELLOWKN  NHY  CHEB_2     2.3021D-12  -1.7809D-12  -7.4978D-13   3.1277D-13   3.8461D-13   3.0274D-13  -1.2817D-13  -1.3784D-15  -1.1225D-14  
D  YELLOWKN  NHY  CHEB_3    -2.3703D-13   1.6876D-13   8.5277D-14  -3.8907D-14  -4.5345D-14  -1.4118D-14   1.3278D-14   1.9097D-15   6.9856D-15  
D  YELLOWKN  NHY  CHEB_4    -3.3491D-14   1.9900D-14   8.4352D-15  -1.7501D-15  -1.9193D-15  -4.4622D-15  -1.8963D-15   1.9874D-15  -2.6893D-15  
D  YELLOWKN  NHY  CHEB_5    -7.9062D-15   8.5111D-15   3.6739D-15  -3.2179D-15  -3.2684D-15  -2.1677D-16   1.4993D-15   1.0391D-17   1.5137D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YLOW7296  HYD  DER_NORT   8.3146D-05   2.5832D-05   5.5797D-06   3.4145D-06   5.7425D-06   1.1582D-05   2.1425D-06  -1.3107D-07  -1.2248D-07  
D  YLOW7296  HYD  DER_EAST  -5.9402D-05  -1.5295D-05  -3.3383D-06  -1.8029D-05  -8.2219D-06   1.1236D-05  -3.3432D-05  -5.2210D-07  -5.5314D-07  
D  YLOW7296  HYD  CHEB_0     7.5335D-09   1.8239D-11   2.4100D-11  -2.4631D-11   1.0228D-11  -2.4462D-11   1.6042D-11   4.7646D-13   8.6176D-13  
D  YLOW7296  HYD  CHEB_1     1.1642D-11   1.9206D-11   6.8931D-12  -3.6647D-12  -2.5511D-12  -3.4493D-12  -6.1620D-13   2.3648D-13   2.3665D-13  
D  YLOW7296  HYD  CHEB_2    -1.0982D-13   2.9498D-12   1.2936D-12  -5.5440D-13  -2.1757D-13  -5.8917D-13  -5.8888D-14   3.2710D-14   4.4343D-14  
D  YLOW7296  HYD  CHEB_3    -2.0087D-12  -4.4316D-13  -1.1225D-13   8.5748D-14   1.0285D-13   6.8856D-14   2.9668D-14  -2.3292D-15  -7.1153D-15  
D  YLOW7296  HYD  CHEB_4    -7.0982D-13   1.2034D-14  -1.5012D-14   7.3041D-16  -8.1003D-15   3.4346D-15  -3.6673D-15   6.7793D-16  -6.0920D-16  
D  YLOW7296  HYD  CHEB_5    -1.0711D-13  -1.8625D-15  -1.6178D-16  -6.5938D-17  -3.9646D-15   1.3846D-15  -6.0064D-16  -2.8601D-16   4.1644D-16  
#
D  YLOW7296  NHY  DER_NORT   1.4537D-03  -1.4949D-04   6.3289D-04  -4.8629D-04   3.4313D-04  -2.4478D-04   1.0686D-04   1.7082D-04  -1.1809D-04  
D  YLOW7296  NHY  DER_EAST  -8.5818D-04   5.6367D-04  -2.1042D-04  -1.3775D-04  -2.5132D-04  -1.0625D-04  -4.7787D-04  -1.0980D-05  -5.4151D-05  
D  YLOW7296  NHY  CHEB_0     2.2270D-10  -1.6491D-10  -7.6886D-11   3.5084D-11   4.0358D-11   1.9724D-11  -1.2241D-11  -1.0444D-13  -2.5589D-12  
D  YLOW7296  NHY  CHEB_1     1.2670D-11  -9.6112D-12  -4.1998D-12   1.6863D-12   2.1279D-12   1.5430D-12  -6.5317D-13   6.3774D-14  -1.1779D-13  
D  YLOW7296  NHY  CHEB_2     2.3013D-12  -1.7796D-12  -7.4956D-13   3.1293D-13   3.8446D-13   3.0233D-13  -1.2793D-13  -1.7361D-15  -1.0843D-14  
D  YLOW7296  NHY  CHEB_3    -2.3677D-13   1.6844D-13   8.5182D-14  -3.8688D-14  -4.5103D-14  -1.4053D-14   1.3085D-14   2.0717D-15   6.8039D-15  
D  YLOW7296  NHY  CHEB_4    -3.3473D-14   1.9960D-14   8.4014D-15  -1.8785D-15  -1.9838D-15  -4.4116D-15  -1.7941D-15   1.9109D-15  -2.6992D-15  
D  YLOW7296  NHY  CHEB_5    -7.7985D-15   8.2372D-15   3.5919D-15  -3.0695D-15  -3.1331D-15  -2.1898D-16   1.4362D-15   5.0817D-17   1.4411D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  YUMA      HYD  DER_NORT   5.4269D-05   2.9144D-05   9.5031D-06  -2.1675D-05  -1.4697D-05   1.3622D-06   2.6493D-06  -9.2169D-07  -2.4937D-07  
D  YUMA      HYD  DER_EAST   8.8585D-06  -2.2531D-05  -1.2045D-05  -5.4543D-06   4.5541D-06  -5.3367D-06   8.3182D-06   2.0924D-06   2.2516D-06  
D  YUMA      HYD  CHEB_0     7.4654D-09   4.1715D-11   9.4445D-12   9.7492D-12   2.6953D-12   2.2250D-12  -2.9276D-12   5.0310D-12   6.8810D-12  
D  YUMA      HYD  CHEB_1    -2.2781D-11   1.2083D-11   6.4296D-12  -5.3323D-13  -1.0064D-12   1.8916D-12   9.3523D-13   6.8635D-13   5.4241D-13  
D  YUMA      HYD  CHEB_2    -6.0009D-12   1.8144D-12   9.1757D-13  -6.0640D-14  -1.0148D-13   3.5793D-13   1.5777D-13   1.2154D-13   1.0727D-13  
D  YUMA      HYD  CHEB_3    -1.3105D-12  -2.9477D-13  -1.8138D-13   3.1067D-14   3.5275D-14  -2.3645D-14  -2.8524D-14  -9.5866D-15  -8.3874D-15  
D  YUMA      HYD  CHEB_4    -6.6753D-13  -5.0860D-15  -5.1703D-15  -3.9037D-15   7.7105D-15  -4.2230D-15   2.7964D-15  -4.2132D-15  -1.0923D-15  
D  YUMA      HYD  CHEB_5    -1.0418D-13   1.8592D-15   1.3042D-15  -3.3332D-15  -5.0240D-15  -1.7035D-15   2.9040D-15   3.3817D-15  -1.6698D-15  
#
D  YUMA      NHY  DER_NORT  -4.9945D-04  -8.1134D-04  -8.8626D-04   7.4609D-04   6.0176D-04  -4.6711D-04   2.1533D-04   9.0674D-05  -7.2699D-05  
D  YUMA      NHY  DER_EAST   1.2896D-03  -1.5420D-03  -5.3389D-05   5.0942D-04   6.2100D-04   6.8482D-04   2.3014D-05   1.1912D-04   1.9057D-04  
D  YUMA      NHY  CHEB_0     3.4790D-10  -1.9385D-10  -1.2797D-10   2.4451D-11   1.2933D-10   5.4244D-12  -8.4106D-11   4.5615D-12   1.1233D-11  
D  YUMA      NHY  CHEB_1     1.9359D-11  -9.6754D-12  -7.0351D-12   3.3692D-13   6.6644D-12   9.2134D-13  -3.6416D-12   9.7105D-13   8.3191D-13  
D  YUMA      NHY  CHEB_2     3.4956D-12  -1.6881D-12  -1.2312D-12  -3.9870D-15   1.1060D-12   1.9988D-13  -5.3115D-13   1.6696D-13   1.7014D-13  
D  YUMA      NHY  CHEB_3    -3.6588D-13   2.2479D-13   1.5845D-13  -3.8190D-14  -1.7735D-13  -8.8654D-15   1.2731D-13  -9.4125D-15  -2.2192D-14  
D  YUMA      NHY  CHEB_4    -5.3310D-14   3.2097D-14   2.2437D-14  -2.5230D-15  -2.5367D-14  -3.9553D-15   1.5312D-14   3.7670D-15  -5.7613D-15  
D  YUMA      NHY  CHEB_5    -8.9290D-15   4.3950D-15   1.7080D-15  -2.8356D-16   5.1606D-16  -6.8629D-16  -1.7806D-15  -4.6376D-15   2.3211D-15  
#
#  Station   Type Variable   Average      SA_COS       SA_SIN       SSA_COS      SSA_SIN      STA_COS      STA_SIN      S1_COS       S1_SIN
#
D  ZELENCHK  HYD  DER_NORT   1.9569D-04   4.5918D-05   9.0731D-06   7.7019D-06   1.7141D-05   8.9536D-06   1.4027D-05  -6.1963D-06   5.9021D-07  
D  ZELENCHK  HYD  DER_EAST  -2.0717D-05  -2.9219D-05   1.0877D-06  -7.9761D-06   4.7041D-06   5.2740D-07   1.1317D-05  -1.1638D-06   4.6061D-07  
D  ZELENCHK  HYD  CHEB_0     6.7542D-09   1.7165D-11  -5.9908D-12   1.9112D-12  -1.1823D-11   8.0211D-12  -5.1738D-12  -1.8013D-12   8.6971D-14  
D  ZELENCHK  HYD  CHEB_1     7.2778D-12   1.6285D-11   8.3176D-12  -1.9516D-12  -1.6903D-12  -4.6485D-13  -6.8633D-13  -6.7499D-13  -2.7928D-13  
D  ZELENCHK  HYD  CHEB_2    -7.7348D-13   2.3800D-12   1.3341D-12  -2.5996D-13  -2.1143D-13  -1.1183D-13  -1.8408D-13  -1.3477D-13  -3.5055D-14  
D  ZELENCHK  HYD  CHEB_3    -1.7532D-12  -4.1979D-13  -2.0282D-13   6.3919D-14   3.9839D-14  -5.0535D-15  -4.1555D-15   2.8550D-15   8.1032D-15  
D  ZELENCHK  HYD  CHEB_4    -5.7514D-13   1.8957D-15   2.9969D-15  -4.1759D-15   6.6180D-15  -3.1014D-16   1.2353D-14   2.4054D-15   1.5464D-15  
D  ZELENCHK  HYD  CHEB_5    -1.1880D-13   1.2276D-14   9.2862D-15  -3.9932D-15  -4.8140D-15   2.6469D-15   1.5174D-15  -1.0490D-15   2.2712D-16  
#
D  ZELENCHK  NHY  DER_NORT   3.2640D-03  -5.3510D-04  -3.4877D-04  -7.5536D-04   2.5133D-04  -4.0053D-04   6.1873D-04   1.6112D-04  -2.0769D-04  
D  ZELENCHK  NHY  DER_EAST   2.1647D-04  -7.5942D-04  -3.6780D-04   1.4299D-04   1.7610D-04  -7.7597D-05  -4.6304D-04   1.3702D-04   2.1813D-04  
D  ZELENCHK  NHY  CHEB_0     3.0082D-10  -1.7777D-10  -9.4299D-11   1.7203D-11   2.3875D-11  -4.3223D-12   1.7161D-11   1.2764D-11   1.3846D-11  
D  ZELENCHK  NHY  CHEB_1     1.8869D-11  -9.7396D-12  -6.0605D-12   1.0894D-13   1.8142D-12  -3.1678D-13   5.1599D-13  -5.2073D-13   1.5343D-13  
D  ZELENCHK  NHY  CHEB_2     3.4531D-12  -1.6760D-12  -1.0620D-12  -2.4075D-14   3.0180D-13  -8.0289D-14   7.2302D-14  -2.3382D-13   2.3793D-14  
D  ZELENCHK  NHY  CHEB_3    -3.2420D-13   2.0387D-13   1.2948D-13  -1.0106D-14  -4.4049D-14  -3.6009D-15  -2.2901D-14  -4.2741D-14  -3.1248D-15  
D  ZELENCHK  NHY  CHEB_4    -5.1560D-14   2.4845D-14   1.9609D-14   4.0688D-15  -4.9825D-15  -2.8539D-16  -6.9074D-15   6.2973D-15  -2.6950D-15  
D  ZELENCHK  NHY  CHEB_5    -5.0830D-15   1.0087D-15   1.1165D-15   1.3844D-16   8.9766D-16   1.4316D-15   8.7976D-17   3.9897D-16   3.1946D-16  
#
# MMF_MOD   Format of 2008.09.21
