#!/usr/bin/env python3
# ************************************************************************
# *                                                                      *
# *   Program vex_cleanup.py
# *                                                                      *
# *   Copyright (c) 1975-2025 United States Government as represented by *
# *   the Administrator of the National Aeronautics and Space            *
# *   Administration. All Rights Reserved.                               *
# *   License: NASA Open Source Software Agreement (NOSA).               *
# *                                                                      *
# * ### 23-JUN-2025   vex_cleanup  v1.0 (d)  L. Petrov  23-JUN-2025 ###  *
# *                                                                      *
# ************************************************************************
import pwd, sys, os, re, shutil, time, subprocess, datetime
from   sur_sked_config import * # Import sur_sked confuguration
from   pet_misc        import *

vex_cleanup__label = "vex_cleanup 20250623"

if ( len(sys.argv)-1 < 1 ):
     print ( "Usage: vex_cleanup.py vex"  )
     exit  ( 1 )
else:
     fil_vex = sys.argv[1]

vex = read_file ( fil_vex )

fl_update = False
imod_beg  = None
imod_end  = None
ifreq_beg = None
ifreq_end = None
for i in range(0,len(vex)):
    if ( "def __@MOD" in vex[i] ):
         if ( vex[i-1][0:1] == "*" ):
              imod_beg = i - 1
         else:
              imod_beg = i
    if ( "  enddef; * __@MOD" in vex[i] ):
         imod_end = i

if ( imod_beg and imod_end ):
     out = []
     for i in range(0,len(vex)):
         if ( i >= imod_beg and i <= imod_end ):
              continue
         out.append ( vex[i] )
     vex = out
     fl_update = True

for i in range(0,len(vex)):
    if ( "def " in vex[i] and    \
         "__@HDS" in vex[i] and  \
         "__freq;" in vex[i] and \
         "@HDS" in vex[i]        ):
         ifreq_beg = i
    if ( "@@_freq___@HDS" in vex[i] ):
         ifreq_end = i

if ( ifreq_beg and ifreq_end ):
     out = []
     for i in range(0,len(vex)):
         if ( i >= ifreq_beg and i <= ifreq_end ):
              continue
         out.append ( vex[i] )
     vex = out
     fl_update = True

out=[]
for i in range(0,len(vex)):
    if ( "enddef; " in vex[i] and "** @HDS" in vex[i] ):
         ip = vex[i].find("enddef;")
         out.append ( vex[i][0:ip+7] )
         fl_update = True
    else:
         out.append ( vex[i] )
if ( fl_update ):
     vex = out

if ( fl_update ):
     print ( "Updating schedule file %s" % fil_vex )
     (ret,err) = write_file ( vex, fil_vex )
