      PROGRAM    TLE_TO_SPIND
! ************************************************************************
! *                                                                      *
! *   Program
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 23-JAN-2025  TLE_TO_SPIND  v1.1 (d) L. Petrov  18-MAR-2025 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'sur_sked.i'
      INCLUDE   'sur_sked_local.i'
      INCLUDE   'tle_sgp4.i'
      INCLUDE   'vtd_local.i'
      INCLUDE   'ners.i'
      INCLUDE   'ners_local.i'
      TYPE     ( EPH__TYPE  ), POINTER :: EPH(:)
      TYPE     ( NERS__TYPE ) :: NERS
      INTEGER*4    M_FIL, MO
      PARAMETER  ( M_FIL = 1024*1024 )
      PARAMETER  ( MO    = 6*1024*1024 )
      CHARACTER  SAT_LIST*1024, DATE_BEG*32, DATE_END*32, FILOUT*128, &
     &           C_SAT(SUR__M_SAT)*3, C_ACR(SUR__M_SAT)*19, DUR_STR*5, &
     &           STR*128, C_FIL(M_FIL)*128, DIRIN*128, BNAME*8, &
     &           FINAM*128, FIL_GNSS_TABLE*128, BUF_GNSS(2*SUR__M_SAT)*128, &
     &           FIL_TLE(SUR__M_SAT)*128, C_ACR_MIS*1024, C_EPH_MIS*1024, &
     &           SAT_STR*10, COM_LINE*1024, TLE_DATE*19, STR_NSTA*2
      CHARACTER   NERS_CONFIG*128, HOME_DIR*128
      CHARACTER, ALLOCATABLE :: OUT(:)*1024
      INTEGER*8  DIR_DESC(16)
      LOGICAL*1  FL_FOUND_ACR, FL_FOUND_EPH, LEX
      REAL*8     TAI_BEG, TAI_END, TIM_STEP, TAI_OBS, COO_SAT(3), VEL_SAT(3), &
     &           DST, RA, DEC, DUR, TLE_TIM, TIM_DIFF, TIM_DIFF_MIN, AZ, EL
      INTEGER*4  J1, J2, J3, J4, J5, J6, J7, J8, IB, IE, IL, NO, &
     &           IDAY, IS, N_SAT, MJD_BEG, MJD_END, MJD_OBS, LEV, LIND, &
     &           IND(2,SUR__M_SAT), L_FIL, N_TIM, N_GNSS, N_ACR_MIS, &
     &           N_EPH_MIS, TLE_MJD, N_STA, IUER
      INTEGER*4, EXTERNAL :: GET_FILE_FROM_DIR, ILEN, I_LEN
      CHARACTER, EXTERNAL :: MJDSEC_TO_DATE*32, GET_CDATE*19
!
      DIRIN = '/tle'
      ALLOCATE ( OUT(MO) )
!
      IF ( IARGC() < 7 ) THEN
           WRITE ( 6, '(A)' ) 'Usage: tle_to_spind sat_list date_beg date_end dur tim_step nsta output_file'
           CALL EXIT ( 1 )
         ELSE
           CALL GETARG ( 1, SAT_LIST )
!
           IUER = -1
           CALL EXWORD ( SAT_LIST, SUR__M_SAT, N_SAT, IND, ',', IUER )
           IF ( IUER .NE. 0 ) THEN
                IUER = -1
                CALL ERR_LOG ( 4801, IUER, 'TLE_TO_SPIND', 'Error in parsing '// &
     &              'the satellite list' )
                CALL EXIT ( 1 )
           END IF
           DO 410 J1=1,N_SAT
              C_SAT(J1) = SAT_LIST(IND(1,J1):IND(2,J1))
              CALL TRAN ( 11, C_SAT(J1), C_SAT(J1) )
 410       CONTINUE 
!
           CALL GETARG ( 2, DATE_BEG )
           IUER = -1
           CALL DATE_TO_TIME ( DATE_BEG, MJD_BEG, TAI_BEG, IUER )
           IF ( IUER .NE. 0 ) THEN
                IUER = -1
                CALL ERR_LOG ( 4802, IUER, 'TLE_TO_SPIND', 'Error in parsing '// &
     &              'the start date '//DATE_BEG )
                CALL EXIT ( 1 )
           END IF
!
           CALL GETARG ( 3, DATE_END )
           IUER = -1
           CALL DATE_TO_TIME ( DATE_END, MJD_END, TAI_END, IUER )
           IF ( IUER .NE. 0 ) THEN
                IUER = -1
                CALL ERR_LOG ( 4803, IUER, 'TLE_TO_SPIND', 'Error in parsing '// &
     &              'the start date '//DATE_END )
                CALL EXIT ( 1 )
           END IF
!
           CALL GETARG ( 4, STR      )
           IF ( INDEX ( STR, '.' ) < 1 ) THEN
                STR = TRIM(STR)//'.0'
           END IF
           READ ( UNIT=STR, FMT='(F12.3)' ) DUR
!
           CALL GETARG ( 5, STR      )
           IF ( INDEX ( STR, '.' ) < 1 ) THEN
                STR = TRIM(STR)//'.0'
           END IF
           READ ( UNIT=STR, FMT='(F12.3)' ) TIM_STEP
!
           CALL GETARG ( 6, STR_NSTA )
           CALL CHASHR (    STR_NSTA )
           CALL CHIN   ( STR, N_STA  )
!           
           CALL GETARG ( 7, FILOUT   )
      END IF
!
      ALLOCATE ( EPH(N_SAT), STAT=IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4804, IUER, 'TLE_TO_SPIND', 'Error in an attempt '// &
     &         'to allocate memory for array EPH' )
           CALL EXIT ( 1 )
      END IF
! --- Get NERS Environment variables
!
      CALL GETENVAR ( 'NERS_CONFIG', NERS_CONFIG )
      IF ( NERS_CONFIG == ' ' ) THEN
!
! -------- Second, check $HOME/.ners_config file
!
           CALL GETENVAR ( 'HOME', HOME_DIR )
           NERS_CONFIG = TRIM(HOME_DIR)//'/.ners_config'
           INQUIRE ( FILE=NERS_CONFIG, EXIST=LEX )
           IF ( .NOT. LEX ) THEN
!
! ------------- Third, check for the system-wide ners configuration file 
!
                NERS_CONFIG = NERS__CONFIG
           END IF
      END IF
!
! --- Initialise NERS
!
      IUER = -1
      CALL NERS_INIT ( 'NERS_CONFIG', NERS, -1.0D0, -1.0D0, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 1930, IUER, 'TLE_TO_SPIND', &
     &         'Error in initializing NERS data structure' )
           CALL EXIT ( 1 )
      END IF
!
! --- Load NERS
!
      IUER = -1
      CALL NERS_LOAD ( NERS, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 1931, IUER, 'TLE_TO_SPIND', &
     &         'Error in an attempt to retrieve NERS forecast '//     &
     &         'parameters from the remote server' )
           CALL EXIT ( 1 )
      END IF
!
      LEV   = 0
      L_FIL = 0
      DO 420 J2=1,M_FIL
         IS = GET_FILE_FROM_DIR ( LEV, DIR_DESC, DIRIN, FINAM )
         IF ( LEV < 1 ) GOTO 810
         IF ( IS .NE. 0 ) THEN
              IUER = -2
              CALL ERR_LOG ( 4805, IUER, 'TLE_TO_SPIND', 'Error in '// &
     &                 'reading input directory '//DIRIN )
              CALL EXIT ( 1 )
         END IF
         IF ( INDEX ( FINAM, '#' ) .GT. 0 ) GOTO 420
         IF ( INDEX ( FINAM, '!' ) .GT. 0 ) GOTO 420
         L_FIL = L_FIL + 1
         IF ( L_FIL .GE. M_FIL ) THEN
              CALL CLRCH ( STR )
              CALL INCH  ( M_FIL, STR )
              IUER = -2
              CALL ERR_LOG ( 4806, IUER, 'TLE_TO_SPIND', 'Error in '// &
     &                 'reading input directory '//TRIM(DIRIN)// &
     &                 ' -- that directory has more than '//TRIM(STR)//' files' )
              CALL EXIT ( 1 )
         END IF
         C_FIL(L_FIL) = FINAM
 420  CONTINUE 
 810  CONTINUE 
!
      IF ( L_FIL < 1 ) THEN
           IUER = -2
           CALL ERR_LOG ( 4807, IUER, 'TLE_TO_SPIND', 'Did  not find '// &
     &         'ephemeride files in the input directory '//DIRIN )
           CALL EXIT ( 1 )
      END IF
      CALL SORT_FAST_CH ( L_FIL, C_FIL )
!
      FIL_GNSS_TABLE = VTD__DATA//'/gnss_sat_table.txt'
!
      IUER = -1
      CALL RD_TEXT ( FIL_GNSS_TABLE, 2*SUR__M_SAT, BUF_GNSS, N_GNSS, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -2
           CALL ERR_LOG ( 4808, IUER, 'TLE_TO_SPIND', 'Did  not find '// &
     &         'ephemeride files in the input directory '//DIRIN )
           CALL EXIT ( 1 )
      END IF
      N_TIM = ((MJD_END*86400.0D0 + TAI_END) - (MJD_BEG*86400.0D0 + TAI_BEG))/TIM_STEP
!
!      write ( 6, * ) 'n_sat= ', n_sat, ' sat-1: ', c_sat(1), ' sat-l: ', c_sat(n_sat), &
!     &               ' mjd/tai_beg= ', mjd_beg, tai_beg, ' mjd/tai_end= ', &
!     &               mjd_end, tai_end, ' tim_step= ', tim_step ! %%%%%%%%%%%%%%%%%%
!      write ( 6, * ) 'l_fil = ', l_fil
!      do 510 j1=1,l_fil
!         write ( 6, * ) j1, trim(c_fil(j1)) ! %%%%
! 510  CONTINUE 
!
      N_ACR_MIS = 0
      N_EPH_MIS = 0
      CALL CLRCH ( C_ACR_MIS )
      CALL CLRCH ( C_EPH_MIS )
!
! --- Cycle over the satellites which ephemeride we would like 
! --- to compute
!
      DO 430 J3=1,N_SAT
!
! ------ Search for the acronym in the table SUR__GNSS_SAT_TABLE
!
         FL_FOUND_ACR = .FALSE.
         DO 440 J4=1,N_GNSS
            IF ( BUF_GNSS(J4)(1:1) == '#' ) GOTO 440
            IF ( BUF_GNSS(J4)(1:3) == C_SAT(J3) ) THEN
                 FL_FOUND_ACR = .TRUE.
                 C_ACR(J3) = BUF_GNSS(J4)(6:24)
            END IF
 440     CONTINUE 
!
! ------ Search for the ephemeride file
!
         FL_FOUND_EPH = .FALSE.
         IF ( FL_FOUND_ACR ) THEN
              TIM_DIFF_MIN = 1.D12
              DO 450 J5=1,L_FIL
                 IL = ILEN(C_FIL(J5))
                 IF ( IL < 10 ) GOTO 450
                 IF ( C_FIL(J5)(IL-3:IL) .NE. '.tle' ) GOTO 450
!
                 IF ( C_FIL(J5)(IL-8:IL-8) == '_' ) THEN
                      TLE_DATE = C_FIL(J5)(IL-16:IL-13)//'.'//C_FIL(J5)(IL-12:IL-11)//'.'// &
     &                           C_FIL(J5)(IL-10:IL-6)//':'//C_FIL(J5)(IL-5:IL-4)//':'// &
     &                           '00'
                    ELSE
                      TLE_DATE = C_FIL(J5)(IL-18:IL-15)//'.'//C_FIL(J5)(IL-14:IL-13)//'.'// &
     &                           C_FIL(J5)(IL-12:IL-8)//':'//C_FIL(J5)(IL-7:IL-6)//':'// &
     &                           C_FIL(J5)(IL-5:IL-4)
                 END IF
                 IUER = -1
                 CALL DATE_TO_TIME ( TLE_DATE, TLE_MJD, TLE_TIM, IUER )
                 IF ( IUER .NE. 0 ) THEN
                      IUER = -1
                      CALL ERR_LOG ( 4810, IUER, 'TLE_TO_SPIND', 'Malformed name '// &
     &                    'of epehemerid file '//C_FIL(J5) )
                      CALL EXIT ( 1 )
                 END IF
                 TIM_DIFF = DABS( ((MJD_BEG + MJD_END)*86400.0D0 + (TAI_BEG + TAI_END))/2.0D0 - &
     &                             (TLE_MJD*86400.0D0 + TLE_TIM) )
                 IF ( INDEX ( C_FIL(J5), TRIM(C_ACR(J3)) ) > 0 ) THEN
                      IF ( TIM_DIFF < TIM_DIFF_MIN ) THEN
                           TIM_DIFF_MIN = TIM_DIFF  
                           FIL_TLE(J3)  = C_FIL(J5)
                           FL_FOUND_EPH = .TRUE.
                      END IF
                 END IF
 450          CONTINUE 
            ELSE
              N_ACR_MIS = N_ACR_MIS + 1
              C_ACR_MIS = TRIM(C_ACR_MIS)//','//C_SAT(J3)
         END IF
         IF ( .NOT. FL_FOUND_EPH ) THEN
              N_EPH_MIS = N_EPH_MIS + 1
              C_EPH_MIS = TRIM(C_EPH_MIS)//','//C_SAT(J3)
         END IF
 430  CONTINUE 
!
! --- Report missing satellites
!
      IF ( N_ACR_MIS > 0 ) THEN
           CALL CLRCH ( STR )
           CALL INCH  ( N_ACR_MIS, STR )
           C_ACR_MIS = C_ACR_MIS(2:)
           IUER = -2
           CALL ERR_LOG ( 4809, IUER, 'TLE_TO_SPIND', 'Did  not find '// &
     &         'celestrak acronyms for '//TRIM(STR)//' satellites: '//C_ACR_MIS )
           CALL EXIT ( 1 )
      END IF
!
! --- Report missing ephemerides
!
      IF ( N_EPH_MIS > 0 ) THEN
           CALL CLRCH ( STR )
           CALL INCH  ( N_EPH_MIS, STR )
           C_EPH_MIS = C_EPH_MIS(2:)
           IUER = -2
           CALL ERR_LOG ( 4810, IUER, 'TLE_TO_SPIND', 'Did  not find '// &
     &         'ephemeride for '//TRIM(STR)//' satellites: '//C_EPH_MIS )
           CALL EXIT ( 1 )
      END IF
!
      WRITE ( UNIT=DUR_STR, FMT='(F5.1)' ) DUR
      CALL GET_COMMAND ( COM_LINE )
!
      NO = 0
      NO = 0
      NO = NO + 1 ; OUT(NO) = '# CATRES Flux and Spectral index file. Format version of 2004.12.18'
      NO = NO + 1 ;  OUT(NO) = '# DURATION, PRIORITY AND NOBS'
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '# Positions of Near Earth Zone objects'
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '# Command '//TRIM(COM_LINE)
      NO = NO + 1 ;  OUT(NO) = '#'
      DO 460 J6=1,N_SAT
         NO = NO + 1 ;  OUT(NO) = '# Satellite: '//C_SAT(J6)//' '//C_ACR(J6)// &
     &                            ' Ephemeride: '//TRIM(FIL_TLE(J6))
 460  CONTINUE 
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '# Created on '//GET_CDATE()
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '# Format:'
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '#   1:10  A10    J2000-name.'
      NO = NO + 1 ;  OUT(NO) = '#  13:23  A11    Right ascension'
      NO = NO + 1 ;  OUT(NO) = '#  26:36  A11    Declination'
      NO = NO + 1 ;  OUT(NO) = '#  39:48  F10.1  Flux density at 4.8 GHz (mJy)'
      NO = NO + 1 ;  OUT(NO) = '#  52:56  F5.2   Spectral index'
      NO = NO + 1 ;  OUT(NO) = '#  59:62  I4     Number of different frequences used in computations'
      NO = NO + 1 ;  OUT(NO) = '#  65:68  F4.1   Distance from the closest calibrator (in deg)'
      NO = NO + 1 ;  OUT(NO) = '#  71:75  F5.1   Galactic latitude (in deg)'
      NO = NO + 1 ;  OUT(NO) = '#  78:78  A1     Whether the source has been observed with VLBI'
      NO = NO + 1 ;  OUT(NO) = '#  81:88  A8     Bname'
      NO = NO + 1 ;  OUT(NO) = '#  91:96  F6.1   Scan duration in seconds'
      NO = NO + 1 ;  OUT(NO) = '#  98:104 F7.1   Priority'
      NO = NO + 1 ;  OUT(NO) = '# 106:107 I2     Minimal number of stations to observe'
      NO = NO + 1 ;  OUT(NO) = '# 114:115 I2     min number of scans'
      NO = NO + 1 ;  OUT(NO) = '# 117:118 I2     max number of scans'
      NO = NO + 1 ;  OUT(NO) = '# 120:256 A137   Comments'
      NO = NO + 1 ;  OUT(NO) = '#'
      NO = NO + 1 ;  OUT(NO) = '# Name      Right Asc.   Declination        Flux   Sp_ind    #  dist gal.lat D  B-name     Dura      Pri #S El_m  I  X # Comment'
      NO = NO + 1 ;  OUT(NO) = '#'
      DO 470 J7=1,N_SAT
         IUER = -1
         CALL TLE_PARSER ( NERS, FIL_TLE(J7), EPH(J7), IUER )     
         IF ( IUER .NE. 0 ) THEN
              IUER = -1
              CALL ERR_LOG ( 4811, IUER, 'TLE_TO_SPIND', 'Error in an attempt '// &
     &           'to parse a satellite ephemeride file '//FIL_TLE(J7) )
              CALL EXIT ( 1 )
         END IF
!
         DO 480 J8=1,N_TIM
            TAI_OBS = TAI_BEG + (J8-1)*TIM_STEP
            IDAY    = TAI_OBS/86400.0D0
            TAI_OBS = TAI_OBS - IDAY*86400.D0
            MJD_OBS = MJD_BEG + IDAY
            IUER = -1
            CALL TLE_TO_CRS ( NERS, EPH(J7), MJD_OBS, TAI_OBS, COO_SAT, VEL_SAT, IUER )
            IF ( IUER .NE. 0 ) THEN
                 IUER = -1
                 CALL ERR_LOG ( 4812, IUER, 'TLE_TO_SPIND', 'Error in an attempt '// &
     &              'to parse a satellite epehemeride file '//FIL_TLE(J7) )
                 CALL EXIT ( 1 )
            END IF
            CALL DECPOL ( 3, COO_SAT, DST, RA, DEC, IUER )
!
            CALL INCH ( J8, SAT_STR )
            CALL CHASHR   ( SAT_STR )
            SAT_STR(1:3) = C_SAT(J7)
            SAT_STR(4:4) = '_'
            CALL BLANK_TO_ZERO ( SAT_STR )
            NO = NO + 1
            CALL CLRCH ( OUT(NO) )
            OUT(NO)(1:10)  = SAT_STR
            CALL RH_TAT ( RA,  2, OUT(NO)(12:23), IUER )
            CALL RG_TAT ( DEC, 1, OUT(NO)(26:36), IUER )
            IF ( DEC > 0.0 ) OUT(NO)(26:26) = '+'
            IB = (J7-1)/26
            IE = J7 - IB*26
            BNAME(1:3) = C_SAT(J7)
            CALL INT_TO_BASE26 ( J8, BNAME(4:8) )
            IF ( BNAME(4:4) == 'A' ) BNAME(4:4) = '_'
            OUT(NO)(81:88)  = BNAME
            OUT(NO)(89:125) = '   '//DUR_STR(1:5)//'     1.0 '//STR_NSTA//' 15.0  1  1 ! Dst:'
            WRITE ( UNIT=OUT(NO)(127:140), FMT='(F13.2)' ) DST
            STR = MJDSEC_TO_DATE ( MJD_OBS, TAI_OBS, IUER )
            OUT(NO)(142:172) = 'Date: '//STR(1:21)//' TAI'
            WRITE ( UNIT=STR(1:8), FMT='(F8.1)' ) TIM_STEP/2.0D0
            OUT(NO)(174:) = 'Range: '//STR(1:8)//' sec'
            WRITE ( UNIT=OUT(NO)(195:207), FMT='(F13.2)' ) COO_SAT(1)
            WRITE ( UNIT=OUT(NO)(209:221), FMT='(F13.2)' ) COO_SAT(2)
            WRITE ( UNIT=OUT(NO)(223:235), FMT='(F13.2)' ) COO_SAT(3)
 480     CONTINUE 
         DEALLOCATE ( EPH(J7)%TLE )     
 470  CONTINUE 
!
      IUER = -1
      CALL WR_TEXT ( NO, OUT, FILOUT, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -2
           CALL ERR_LOG ( 4813, IUER, 'TLE_TO_SPIND', 'Error in writing '// &
     &         'into the output file '//FILOUT )
           CALL EXIT ( 1 )
      END IF
      WRITE ( 6, '(A)' ) 'Written file '//TRIM(FILOUT)
!
      END  PROGRAM    TLE_TO_SPIND  !#!  
