      FUNCTION   DIAGI_OST ( DIAGI_S )
! ************************************************************************
! *                                                                      *
! *   Routine  DIAGI_OST  bids user to change the overplot style         *
! *   of the plot of the current colour. DIAGI_S.OST(ICLR) is updated.   *
! *   DIAGI_S.OST(ICLR) = 0 means that the points beyond the plotting    *
! *                         window will not be shown.                    *
! *   DIAGI_S.OST(ICLR) = 1 means that the points beyond the plotting    *
! *                         window will be shown just after the border.  *
! *                                                                      *
! * _______________________ Modified parameters: _______________________ *
! *                                                                      *
! *     DIAGI_S ( RECORD    ) -- Data structure which keeps DiaGI        *
! *                              internal parameters.                    *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  05-AUG-2002  DIAGI_OST   v1.0  (d) L. Petrov  06-AUG-2002 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'diagi.i'
      TYPE ( DIAGI_STRU ) ::  DIAGI_S
      INTEGER*4  DIAGI_OST
      INTEGER*4  ICLR, IBST, ILST, IOST, IPST, IWST, MP, NSP, NPTS
      PARAMETER  ( MP=9,  NSP=64 )
      CHARACTER  MES*128, CH*1, STR*20
      REAL*4     XC, YC, SIZ, XP(MP), YP(MP), EP(MP), X2(2), Y2(2), &
     &           X4(4), Y4(4), XSPL(NSP), YSPL(NSP)
      REAL*4     RAD_MM, XRAD_WC, YRAD_WC, X4_MIN, X4_MAX, ADJ
      REAL*8     X8(MP), Y8(MP)
      INTEGER*4  J1, J2, J3, J4, J5, NN, IUER, IDI
      INTEGER*4  I_LEN, DIAGI_INBOX
      TYPE ( DIAGI_BOXES ) ::  BOX(MOST)
      DATA   ( XP(NN), YP(NN), EP(NN), NN=1,MP ) &
     &       /  0.15, 1.2,  0.1, &
     &          0.2,  0.5,  0.1, &
     &          0.3,  0.4,  0.1, &
     &          0.4,  1.4,  0.2, &
     &          0.5,  1.1,  0.2, &
     &          0.6,  0.6,  0.1, &
     &          0.7, -0.2,  0.1, &
     &          0.8,  0.2,  0.1, &
     &          1.4,  0.3,  0.1 &
     &       /
!
      ICLR = DIAGI_S%ICLR
      IBST = DIAGI_S%IBST(ICLR)
      ILST = DIAGI_S%ILST(ICLR)
      IOST = DIAGI_S%IOST(ICLR)
      IPST = DIAGI_S%IPST(ICLR)
      IWST = DIAGI_S%IWST(ICLR)
!
      IF ( IOST .GT. MOST-1 ) IOST = MOST-1
      IF ( IOST .LT. 0      ) IOST = 0
!
      CALL CLRCH ( MES )
      MES = 'Select overplot style'
      CALL PGSAVE ! 1
!
! --- Deleting previous window
!
      CALL PGERAS
!
! --- Setting new world coodrinates
!
      CALL PGSWIN  ( 0.0, 1.0, 0.0, 1.0 )
!
      CALL PGSCI   ( 1   )
      CALL PGSCH   ( 2.5 )
      CALL PGSLW   ( 8   )
!
! --- Printing the prompt
!
      XC = 0.50
      YC = 0.66
      CALL PGPTXT  ( XC, YC, 0.0, 0.5, MES(1:I_LEN(MES)) )
!
      CALL PGSAVE ! 2
      SIZ = 1.0/(3*MOST+1)
      YC  = 0.33
!
! --- Determine the radii of the circle
!
      IF ( IPST .EQ. 1  .OR.  IPST .EQ. 2  .OR.  IPST .EQ. 4 ) THEN
           RAD_MM = DIAGI_S%RAD_SMALL
           NPTS   = NPTS_SMALL
         ELSE IF ( IPST .EQ. 3 .OR. IPST .EQ. 5 ) THEN
           RAD_MM = DIAGI_S%RAD_LARGE
           NPTS   = NPTS_LARGE
      END IF
      IF ( DIAGI_S%XRIGHT > 600.0 ) RAD_MM = 1.6*RAD_MM
      XRAD_WC = RAD_MM/((DIAGI_S%XRIGHT - DIAGI_S%XLEFT)*SIZ)
      YRAD_WC = RAD_MM/((DIAGI_S%YTOP - DIAGI_S%YBOT)*SIZ)
!
! --- Some sorcery
!
      CALL PGSVP  ( 0.0, 1.0, 0.0, 1.0  )
!
      IF ( IPST .EQ. 3 .OR. IPST .EQ. 5 ) THEN
           ADJ = 0.013  ! large cicles
         ELSE
           ADJ = 0.007  ! small circles
      END IF
!
      DO 410 J1=1,MOST
!
! ------ Specifing the corner of the boxes
!
         BOX(J1)%XLB = SIZ + SIZ*((J1-1)*2+1)
         BOX(J1)%YLB = YC-SIZ/2.0
         BOX(J1)%XTU = SIZ + SIZ*((J1-1)*2+1)+SIZ
         BOX(J1)%YTU = YC+SIZ/2.0
         CALL PGSAVE ! 3A
!
! ------ Setting filling colour
!
         IF ( J1-1 .EQ. IOST ) THEN
              CALL PGSCI  ( 4 )  ! current error bar style
            ELSE
              CALL PGSCI  ( 3 )  ! other error bar style
         END IF
!
! ------ Printing the box with point style. Firstly as filled rectangular
!
         CALL PGSFS  ( 1 )
         CALL PGRECT ( BOX(J1)%XLB, BOX(J1)%XTU, BOX(J1)%YLB, BOX(J1)%YTU )
!
! ------ ... then as outlined rectangular
!
         CALL PGSFS  ( 2 )
         CALL PGSLW  ( 1 )
         CALL PGSCI  ( 1 )
         CALL PGRECT ( BOX(J1)%XLB, BOX(J1)%XTU, BOX(J1)%YLB, BOX(J1)%YTU )
!
         CALL PGUNSA ! 3A
         CALL PGSAVE ! 3B
!
! ------ Printing explaining text
!
         CALL CLRCH  ( STR )
         CALL INCH   ( J1-1, STR )
         CALL PGSCF  ( 3 )
         CALL PGSLW  ( 4 )
         CALL PGSCH  ( 1.5 )
         CALL PGPTXT ( BOX(J1)%XLB+SIZ/2., BOX(J1)%YLB-SIZ/2., 0.5, 0.5, &
     &                 'OST='//STR(1:1) )
!
         CALL PGSVP  ( BOX(J1)%XLB, BOX(J1)%XTU, BOX(J1)%YLB, BOX(J1)%YTU )
         CALL PGSCI  ( ITAB_CLR(ICLR,1) )
!
! ------ Drawing examples of the error bars
!
         IF ( IBST .EQ. 1 ) THEN
!
! ----------- "Stiky" style of the error bars with terminals
!
              CALL PGERRB ( 6, MP, XP, YP, EP, 1.0 )
           ELSE IF ( IBST .EQ. 2 ) THEN
!
! ----------- "Stiky" style of the error bars without terminals
!
              CALL PGERRB ( 6, MP, XP, YP, EP, 0.0 )
           ELSE IF ( IBST .EQ. 3 ) THEN
!
! ----------- Continuous line + sticks
!
              CALL PGERRB ( 6, MP, XP, YP, EP, 0.0 )
              DO 420 J2=1,MP-1
                 X2(1)=XP(J2)
                 X2(2)=XP(J2+1)
                 Y2(1)=YP(J2)   + EP(J2)
                 Y2(2)=YP(J2+1) + EP(J2+1)
                 CALL PGLINE ( 2, X2, Y2 )
                 Y2(1)=YP(J2)   - EP(J2)
                 Y2(2)=YP(J2+1) - EP(J2+1)
                 CALL PGLINE ( 2, X2, Y2 )
 420          CONTINUE
           ELSE IF ( IBST .EQ. 4 ) THEN
!
! ----------- Fill confidence interval area
!
              CALL PGSCI ( ITAB_CLR(ICLR,2) )
              CALL PGSFS ( 1   )
              DO 430 J3=1,MP-1
                 X4(1)=XP(J3)
                 X4(2)=XP(J3)
                 X4(3)=XP(J3+1)
                 X4(4)=XP(J3+1)
                 Y4(1)=YP(J3)   - EP(J3)
                 Y4(2)=YP(J3)   + EP(J3)
                 Y4(3)=YP(J3+1) + EP(J3+1)
                 Y4(4)=YP(J3+1) - EP(J3+1)
                 CALL PGPOLY ( 4, X4, Y4 )
 430          CONTINUE
         END IF
!
! ------ Drawing the line
!
         CALL PGSCI ( ITAB_CLR(ICLR,1) )
         IF ( ILST .EQ. 1 ) THEN
!
! ----------- Point-by-point style
!
              CALL PGSLW (   1 )
              CALL PGSCH ( 0.1 )
              DO 440 J4=1,MP
                 IF ( IPST .EQ. 1 ) THEN
                      CALL PGPNTS ( 1, XP(J4), YP(J4), 1, 1 )
                 END IF
 440          CONTINUE
            ELSE IF ( ILST .EQ. 2 ) THEN
!
! ----------- Piese-wise line style
!
              CALL PGSLW  ( DIAGI_S%IWD_LINS(IWST) )
              CALL PGLINE ( MP, XP, YP )
            ELSE IF ( ILST .EQ. 3 ) THEN
!
! ----------- Cubic spline style
!
              CALL COPY_R4_R8 ( MP, XP, X8 )
              CALL COPY_R4_R8 ( MP, YP, Y8 )
              X4_MIN = X8(1)
              X4_MAX = X8(MP)
              IUER = -1
              CALL DIAGI_SPL ( MP, X8, Y8, X4_MIN, X4_MAX, NSP, XSPL, YSPL, &
     &                         IUER )
              CALL PGSLW     ( DIAGI_S%IWD_LINS(IWST) )
              CALL PGLINE    ( NSP, XSPL, YSPL )
         END IF
!
! ------ Drawing the points
!
         DO 450 J5=1,MP
            IF ( IPST .EQ. 2  .OR.  IPST .EQ. 3  ) THEN
!
! -------------- Outlined circles
!
                 CALL PGSFS ( 1 )
                 CALL PGSCI ( 0 )
                 CALL PGSVP  ( BOX(J1)%XLB, BOX(J1)%XTU, &
     &                         BOX(J1)%YLB, BOX(J1)%YTU )
                 CALL PGCIRC_PET ( NPTS, XP(J5), YP(J5), XRAD_WC, YRAD_WC )
!
! -------------- Put a point a little bit beyond the plotting area
!
                 IF ( J1 .EQ. MOST .AND. YP(J5) .GT. 1.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), 1.0-ADJ*3.0, &
     &                                  XRAD_WC*0.5, YRAD_WC*0.5 )
                    ELSE IF ( J1 .EQ. MOST .AND. YP(J5) .LT. 0.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), ADJ*3.0, &
     &                                  XRAD_WC*0.7, YRAD_WC*0.7 )
                 END IF
!
                 CALL PGSFS ( 2  )
                 CALL PGSCI ( ITAB_CLR(ICLR,1) )
                 CALL PGSVP  ( BOX(J1)%XLB, BOX(J1)%XTU, &
     &                         BOX(J1)%YLB, BOX(J1)%YTU )
                 CALL PGCIRC_PET ( NPTS, XP(J5), YP(J5), XRAD_WC, YRAD_WC )
!
! -------------- Put a point a little bit beyond the plotting area
!
                 IF ( J1 .EQ. MOST .AND. YP(J5) .GT. 1.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), 1.0-ADJ*3.0, &
     &                                  XRAD_WC*0.7, YRAD_WC*0.7 )
                    ELSE IF ( J1 .EQ. MOST .AND. YP(J5) .LT. 0.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), ADJ*3.0, XRAD_WC*0.7, &
     &                                  YRAD_WC*0.7 )
                 END IF
               ELSE IF ( IPST .EQ. 1  .OR. IPST .EQ. 4  .OR.  IPST .EQ. 5 ) THEN
!
! -------------- Filled circles
!
                 CALL PGSFS ( 1  )
                 CALL PGSCI ( ITAB_CLR(ICLR,1) )
                 CALL PGSVP  ( BOX(J1)%XLB, BOX(J1)%XTU, &
     &                         BOX(J1)%YLB, BOX(J1)%YTU )
                 IF ( IPST .EQ. 1 ) THEN
                      CALL PGPNTS ( 1, XP(J5), YP(J5), 1, 1 )
                    ELSE
                      CALL PGCIRC_PET ( NPTS, XP(J5), YP(J5), XRAD_WC, YRAD_WC )
                 END IF
!
! -------------- Put a point a little biut beyond the plotting area
!
                 IF ( J1 .EQ. MOST .AND. YP(J5) .GT. 1.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), 1.0-ADJ*3.0, XRAD_WC*0.7, &
     &                                  YRAD_WC*0.7 )
                    ELSE IF ( J1 .EQ. MOST .AND. YP(J5) .LT. 0.0 ) THEN
                      CALL PGSVP  ( BOX(J1)%XLB-ADJ*1.5, BOX(J1)%XTU+ADJ*1.5, &
     &                              BOX(J1)%YLB-ADJ, BOX(J1)%YTU+ADJ )
                      CALL PGCIRC_PET ( NPTS, XP(J5), ADJ*3.0, XRAD_WC*0.7, &
     &                                  YRAD_WC*0.7 )
                 END IF
            END IF
 450     CONTINUE
         CALL PGUNSA ! 3B
         CALL PGSVP   ( 0.0, 1.0, 0.0, 1.0  )
         CALL PGSCI   ( 1 )
 410  CONTINUE
      CALL PGUNSA ! 2
!
! --- Position cursor in the box with the current error bar style
!
      XC = BOX(IOST+1)%XLB + ( BOX(IOST+1)%XTU - BOX(IOST+1)%XLB )/3.
      YC = BOX(IOST+1)%YLB + ( BOX(IOST+1)%YTU - BOX(IOST+1)%YLB )/3.
!
! --- Waiting for user reaction
!
      CALL PGBAND ( 0, 1, XC, YC, XC, YC, CH )
!
      CALL PGUNSA ! 1
      DIAGI_OST = 0
!
! --- Determine: which box has been specified
!
      IF ( CH .EQ. '0'  .OR.  CH .EQ. '1'  ) THEN
           CALL CHIN ( CH, IOST )
           DIAGI_OST = 1
         ELSE IF ( CH .NE. 'X' ) THEN
           IDI = DIAGI_INBOX ( MOST, BOX, XC, YC )
           IF ( IDI .GT. 0 ) THEN
                IOST = IDI - 1
                DIAGI_OST = 1
           END IF
      END IF
!
      DIAGI_S%IOST(ICLR) = IOST
!
      RETURN
      END !#!  DIAGI_OST  #!#
