#include <mk5_preprocessor_directives.inc>
      SUBROUTINE MUL_MM_SS_S_7  ( A, B, C )
! ************************************************************************
! *                                                                      *
! *   Compute a product of two square symmetric matrices in upper        *
! *   triangular representation.                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.12.14 ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), B(*), C(*)
!
      C( 1 ) = A( 1 ) * B( 1 )
      C( 1 ) = C( 1 ) + A( 2 ) * B( 2 )
      C( 1 ) = C( 1 ) + A( 4 ) * B( 4 )
      C( 1 ) = C( 1 ) + A( 7 ) * B( 7 )
      C( 1 ) = C( 1 ) + A( 11 ) * B( 11 )
      C( 1 ) = C( 1 ) + A( 16 ) * B( 16 )
      C( 1 ) = C( 1 ) + A( 22 ) * B( 22 )
!
      C( 2 ) = A( 2 ) * B( 1 )
      C( 2 ) = C( 2 ) + A( 3 ) * B( 2 )
      C( 2 ) = C( 2 ) + A( 5 ) * B( 4 )
      C( 2 ) = C( 2 ) + A( 8 ) * B( 7 )
      C( 2 ) = C( 2 ) + A( 12 ) * B( 11 )
      C( 2 ) = C( 2 ) + A( 17 ) * B( 16 )
      C( 2 ) = C( 2 ) + A( 23 ) * B( 22 )
!
      C( 3 ) = A( 2 ) * B( 2 )
      C( 3 ) = C( 3 ) + A( 3 ) * B( 3 )
      C( 3 ) = C( 3 ) + A( 5 ) * B( 5 )
      C( 3 ) = C( 3 ) + A( 8 ) * B( 8 )
      C( 3 ) = C( 3 ) + A( 12 ) * B( 12 )
      C( 3 ) = C( 3 ) + A( 17 ) * B( 17 )
      C( 3 ) = C( 3 ) + A( 23 ) * B( 23 )
!
      C( 4 ) = A( 4 ) * B( 1 )
      C( 4 ) = C( 4 ) + A( 5 ) * B( 2 )
      C( 4 ) = C( 4 ) + A( 6 ) * B( 4 )
      C( 4 ) = C( 4 ) + A( 9 ) * B( 7 )
      C( 4 ) = C( 4 ) + A( 13 ) * B( 11 )
      C( 4 ) = C( 4 ) + A( 18 ) * B( 16 )
      C( 4 ) = C( 4 ) + A( 24 ) * B( 22 )
!
      C( 5 ) = A( 4 ) * B( 2 )
      C( 5 ) = C( 5 ) + A( 5 ) * B( 3 )
      C( 5 ) = C( 5 ) + A( 6 ) * B( 5 )
      C( 5 ) = C( 5 ) + A( 9 ) * B( 8 )
      C( 5 ) = C( 5 ) + A( 13 ) * B( 12 )
      C( 5 ) = C( 5 ) + A( 18 ) * B( 17 )
      C( 5 ) = C( 5 ) + A( 24 ) * B( 23 )
!
      C( 6 ) = A( 4 ) * B( 4 )
      C( 6 ) = C( 6 ) + A( 5 ) * B( 5 )
      C( 6 ) = C( 6 ) + A( 6 ) * B( 6 )
      C( 6 ) = C( 6 ) + A( 9 ) * B( 9 )
      C( 6 ) = C( 6 ) + A( 13 ) * B( 13 )
      C( 6 ) = C( 6 ) + A( 18 ) * B( 18 )
      C( 6 ) = C( 6 ) + A( 24 ) * B( 24 )
!
      C( 7 ) = A( 7 ) * B( 1 )
      C( 7 ) = C( 7 ) + A( 8 ) * B( 2 )
      C( 7 ) = C( 7 ) + A( 9 ) * B( 4 )
      C( 7 ) = C( 7 ) + A( 10 ) * B( 7 )
      C( 7 ) = C( 7 ) + A( 14 ) * B( 11 )
      C( 7 ) = C( 7 ) + A( 19 ) * B( 16 )
      C( 7 ) = C( 7 ) + A( 25 ) * B( 22 )
!
      C( 8 ) = A( 7 ) * B( 2 )
      C( 8 ) = C( 8 ) + A( 8 ) * B( 3 )
      C( 8 ) = C( 8 ) + A( 9 ) * B( 5 )
      C( 8 ) = C( 8 ) + A( 10 ) * B( 8 )
      C( 8 ) = C( 8 ) + A( 14 ) * B( 12 )
      C( 8 ) = C( 8 ) + A( 19 ) * B( 17 )
      C( 8 ) = C( 8 ) + A( 25 ) * B( 23 )
!
      C( 9 ) = A( 7 ) * B( 4 )
      C( 9 ) = C( 9 ) + A( 8 ) * B( 5 )
      C( 9 ) = C( 9 ) + A( 9 ) * B( 6 )
      C( 9 ) = C( 9 ) + A( 10 ) * B( 9 )
      C( 9 ) = C( 9 ) + A( 14 ) * B( 13 )
      C( 9 ) = C( 9 ) + A( 19 ) * B( 18 )
      C( 9 ) = C( 9 ) + A( 25 ) * B( 24 )
!
      C( 10 ) = A( 7 ) * B( 7 )
      C( 10 ) = C( 10 ) + A( 8 ) * B( 8 )
      C( 10 ) = C( 10 ) + A( 9 ) * B( 9 )
      C( 10 ) = C( 10 ) + A( 10 ) * B( 10 )
      C( 10 ) = C( 10 ) + A( 14 ) * B( 14 )
      C( 10 ) = C( 10 ) + A( 19 ) * B( 19 )
      C( 10 ) = C( 10 ) + A( 25 ) * B( 25 )
!
      C( 11 ) = A( 11 ) * B( 1 )
      C( 11 ) = C( 11 ) + A( 12 ) * B( 2 )
      C( 11 ) = C( 11 ) + A( 13 ) * B( 4 )
      C( 11 ) = C( 11 ) + A( 14 ) * B( 7 )
      C( 11 ) = C( 11 ) + A( 15 ) * B( 11 )
      C( 11 ) = C( 11 ) + A( 20 ) * B( 16 )
      C( 11 ) = C( 11 ) + A( 26 ) * B( 22 )
!
      C( 12 ) = A( 11 ) * B( 2 )
      C( 12 ) = C( 12 ) + A( 12 ) * B( 3 )
      C( 12 ) = C( 12 ) + A( 13 ) * B( 5 )
      C( 12 ) = C( 12 ) + A( 14 ) * B( 8 )
      C( 12 ) = C( 12 ) + A( 15 ) * B( 12 )
      C( 12 ) = C( 12 ) + A( 20 ) * B( 17 )
      C( 12 ) = C( 12 ) + A( 26 ) * B( 23 )
!
      C( 13 ) = A( 11 ) * B( 4 )
      C( 13 ) = C( 13 ) + A( 12 ) * B( 5 )
      C( 13 ) = C( 13 ) + A( 13 ) * B( 6 )
      C( 13 ) = C( 13 ) + A( 14 ) * B( 9 )
      C( 13 ) = C( 13 ) + A( 15 ) * B( 13 )
      C( 13 ) = C( 13 ) + A( 20 ) * B( 18 )
      C( 13 ) = C( 13 ) + A( 26 ) * B( 24 )
!
      C( 14 ) = A( 11 ) * B( 7 )
      C( 14 ) = C( 14 ) + A( 12 ) * B( 8 )
      C( 14 ) = C( 14 ) + A( 13 ) * B( 9 )
      C( 14 ) = C( 14 ) + A( 14 ) * B( 10 )
      C( 14 ) = C( 14 ) + A( 15 ) * B( 14 )
      C( 14 ) = C( 14 ) + A( 20 ) * B( 19 )
      C( 14 ) = C( 14 ) + A( 26 ) * B( 25 )
!
      C( 15 ) = A( 11 ) * B( 11 )
      C( 15 ) = C( 15 ) + A( 12 ) * B( 12 )
      C( 15 ) = C( 15 ) + A( 13 ) * B( 13 )
      C( 15 ) = C( 15 ) + A( 14 ) * B( 14 )
      C( 15 ) = C( 15 ) + A( 15 ) * B( 15 )
      C( 15 ) = C( 15 ) + A( 20 ) * B( 20 )
      C( 15 ) = C( 15 ) + A( 26 ) * B( 26 )
!
      C( 16 ) = A( 16 ) * B( 1 )
      C( 16 ) = C( 16 ) + A( 17 ) * B( 2 )
      C( 16 ) = C( 16 ) + A( 18 ) * B( 4 )
      C( 16 ) = C( 16 ) + A( 19 ) * B( 7 )
      C( 16 ) = C( 16 ) + A( 20 ) * B( 11 )
      C( 16 ) = C( 16 ) + A( 21 ) * B( 16 )
      C( 16 ) = C( 16 ) + A( 27 ) * B( 22 )
!
      C( 17 ) = A( 16 ) * B( 2 )
      C( 17 ) = C( 17 ) + A( 17 ) * B( 3 )
      C( 17 ) = C( 17 ) + A( 18 ) * B( 5 )
      C( 17 ) = C( 17 ) + A( 19 ) * B( 8 )
      C( 17 ) = C( 17 ) + A( 20 ) * B( 12 )
      C( 17 ) = C( 17 ) + A( 21 ) * B( 17 )
      C( 17 ) = C( 17 ) + A( 27 ) * B( 23 )
!
      C( 18 ) = A( 16 ) * B( 4 )
      C( 18 ) = C( 18 ) + A( 17 ) * B( 5 )
      C( 18 ) = C( 18 ) + A( 18 ) * B( 6 )
      C( 18 ) = C( 18 ) + A( 19 ) * B( 9 )
      C( 18 ) = C( 18 ) + A( 20 ) * B( 13 )
      C( 18 ) = C( 18 ) + A( 21 ) * B( 18 )
      C( 18 ) = C( 18 ) + A( 27 ) * B( 24 )
!
      C( 19 ) = A( 16 ) * B( 7 )
      C( 19 ) = C( 19 ) + A( 17 ) * B( 8 )
      C( 19 ) = C( 19 ) + A( 18 ) * B( 9 )
      C( 19 ) = C( 19 ) + A( 19 ) * B( 10 )
      C( 19 ) = C( 19 ) + A( 20 ) * B( 14 )
      C( 19 ) = C( 19 ) + A( 21 ) * B( 19 )
      C( 19 ) = C( 19 ) + A( 27 ) * B( 25 )
!
      C( 20 ) = A( 16 ) * B( 11 )
      C( 20 ) = C( 20 ) + A( 17 ) * B( 12 )
      C( 20 ) = C( 20 ) + A( 18 ) * B( 13 )
      C( 20 ) = C( 20 ) + A( 19 ) * B( 14 )
      C( 20 ) = C( 20 ) + A( 20 ) * B( 15 )
      C( 20 ) = C( 20 ) + A( 21 ) * B( 20 )
      C( 20 ) = C( 20 ) + A( 27 ) * B( 26 )
!
      C( 21 ) = A( 16 ) * B( 16 )
      C( 21 ) = C( 21 ) + A( 17 ) * B( 17 )
      C( 21 ) = C( 21 ) + A( 18 ) * B( 18 )
      C( 21 ) = C( 21 ) + A( 19 ) * B( 19 )
      C( 21 ) = C( 21 ) + A( 20 ) * B( 20 )
      C( 21 ) = C( 21 ) + A( 21 ) * B( 21 )
      C( 21 ) = C( 21 ) + A( 27 ) * B( 27 )
!
      C( 22 ) = A( 22 ) * B( 1 )
      C( 22 ) = C( 22 ) + A( 23 ) * B( 2 )
      C( 22 ) = C( 22 ) + A( 24 ) * B( 4 )
      C( 22 ) = C( 22 ) + A( 25 ) * B( 7 )
      C( 22 ) = C( 22 ) + A( 26 ) * B( 11 )
      C( 22 ) = C( 22 ) + A( 27 ) * B( 16 )
      C( 22 ) = C( 22 ) + A( 28 ) * B( 22 )
!
      C( 23 ) = A( 22 ) * B( 2 )
      C( 23 ) = C( 23 ) + A( 23 ) * B( 3 )
      C( 23 ) = C( 23 ) + A( 24 ) * B( 5 )
      C( 23 ) = C( 23 ) + A( 25 ) * B( 8 )
      C( 23 ) = C( 23 ) + A( 26 ) * B( 12 )
      C( 23 ) = C( 23 ) + A( 27 ) * B( 17 )
      C( 23 ) = C( 23 ) + A( 28 ) * B( 23 )
!
      C( 24 ) = A( 22 ) * B( 4 )
      C( 24 ) = C( 24 ) + A( 23 ) * B( 5 )
      C( 24 ) = C( 24 ) + A( 24 ) * B( 6 )
      C( 24 ) = C( 24 ) + A( 25 ) * B( 9 )
      C( 24 ) = C( 24 ) + A( 26 ) * B( 13 )
      C( 24 ) = C( 24 ) + A( 27 ) * B( 18 )
      C( 24 ) = C( 24 ) + A( 28 ) * B( 24 )
!
      C( 25 ) = A( 22 ) * B( 7 )
      C( 25 ) = C( 25 ) + A( 23 ) * B( 8 )
      C( 25 ) = C( 25 ) + A( 24 ) * B( 9 )
      C( 25 ) = C( 25 ) + A( 25 ) * B( 10 )
      C( 25 ) = C( 25 ) + A( 26 ) * B( 14 )
      C( 25 ) = C( 25 ) + A( 27 ) * B( 19 )
      C( 25 ) = C( 25 ) + A( 28 ) * B( 25 )
!
      C( 26 ) = A( 22 ) * B( 11 )
      C( 26 ) = C( 26 ) + A( 23 ) * B( 12 )
      C( 26 ) = C( 26 ) + A( 24 ) * B( 13 )
      C( 26 ) = C( 26 ) + A( 25 ) * B( 14 )
      C( 26 ) = C( 26 ) + A( 26 ) * B( 15 )
      C( 26 ) = C( 26 ) + A( 27 ) * B( 20 )
      C( 26 ) = C( 26 ) + A( 28 ) * B( 26 )
!
      C( 27 ) = A( 22 ) * B( 16 )
      C( 27 ) = C( 27 ) + A( 23 ) * B( 17 )
      C( 27 ) = C( 27 ) + A( 24 ) * B( 18 )
      C( 27 ) = C( 27 ) + A( 25 ) * B( 19 )
      C( 27 ) = C( 27 ) + A( 26 ) * B( 20 )
      C( 27 ) = C( 27 ) + A( 27 ) * B( 21 )
      C( 27 ) = C( 27 ) + A( 28 ) * B( 27 )
!
      C( 28 ) = A( 22 ) * B( 22 )
      C( 28 ) = C( 28 ) + A( 23 ) * B( 23 )
      C( 28 ) = C( 28 ) + A( 24 ) * B( 24 )
      C( 28 ) = C( 28 ) + A( 25 ) * B( 25 )
      C( 28 ) = C( 28 ) + A( 26 ) * B( 26 )
      C( 28 ) = C( 28 ) + A( 27 ) * B( 27 )
      C( 28 ) = C( 28 ) + A( 28 ) * B( 28 )
!
!
      RETURN
      END !#! SUBROUTINE MUL_MM_SS_S_7 
