#include <mk5_preprocessor_directives.inc>
      SUBROUTINE TRMM7_3  ( M, A, B, LB )
! ************************************************************************
! *                                                                      *
! *   Computes B := -B*A                                                 *
! *   B dimensioned as (LB,N), A in upper triangular format.             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.11.28 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  M, LB
      REAL*8     A(*), B(LB,3 )
      INTEGER*4  J1
      REAL*8     DDOT
      IF ( M .EQ. 1 ) THEN
           B( 1, 3 ) = - B( 1, 3 )* A( 6 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 2 ) * A( 5 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 1 ) * A( 4 )
           B( 1, 2 ) = - B( 1, 2 )* A( 3 )
           B( 1, 2 ) = B( 1, 2 ) - B( 1, 1 ) * A( 2 )
           B( 1, 1 ) = - B( 1, 1 )* A( 1 )
         ELSE IF ( M .EQ. 2 ) THEN
           B( 1, 3 ) = - B( 1, 3 ) * A( 6 )
           B( 2, 3 ) = - B( 2, 3 ) * A( 6 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 2 ) * A( 5 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 2 ) * A( 5 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 1 ) * A( 4 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 1 ) * A( 4 )
           B( 1, 2 ) = - B( 1, 2 ) * A( 3 )
           B( 2, 2 ) = - B( 2, 2 ) * A( 3 )
           B( 1, 2 ) = B( 1, 2 ) - B( 1, 1 ) * A( 2 )
           B( 2, 2 ) = B( 2, 2 ) - B( 2, 1 ) * A( 2 )
           B( 1, 1 ) = - B( 1, 1 ) * A( 1 )
           B( 2, 1 ) = - B( 2, 1 ) * A( 1 )
         ELSE IF ( M .EQ. 3 ) THEN
           B( 1, 3 ) = - B( 1, 3 ) * A( 6 )
           B( 2, 3 ) = - B( 2, 3 ) * A( 6 )
           B( 3, 3 ) = - B( 3, 3 ) * A( 6 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 2 ) * A( 5 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 2 ) * A( 5 )
           B( 3, 3 ) = B( 3, 3 ) - B( 3, 2 ) * A( 5 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 1 ) * A( 4 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 1 ) * A( 4 )
           B( 3, 3 ) = B( 3, 3 ) - B( 3, 1 ) * A( 4 )
           B( 1, 2 ) = - B( 1, 2 ) * A( 3 )
           B( 2, 2 ) = - B( 2, 2 ) * A( 3 )
           B( 3, 2 ) = - B( 3, 2 ) * A( 3 )
           B( 1, 2 ) = B( 1, 2 ) - B( 1, 1 ) * A( 2 )
           B( 2, 2 ) = B( 2, 2 ) - B( 2, 1 ) * A( 2 )
           B( 3, 2 ) = B( 3, 2 ) - B( 3, 1 ) * A( 2 )
           B( 1, 1 ) = - B( 1, 1 ) * A( 1 )
           B( 2, 1 ) = - B( 2, 1 ) * A( 1 )
           B( 3, 1 ) = - B( 3, 1 ) * A( 1 )
         ELSE IF ( M .EQ. 4 ) THEN
           B( 1, 3 ) = - B( 1, 3 ) * A( 6 )
           B( 2, 3 ) = - B( 2, 3 ) * A( 6 )
           B( 3, 3 ) = - B( 3, 3 ) * A( 6 )
           B( 4, 3 ) = - B( 4, 3 ) * A( 6 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 2 ) * A( 5 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 2 ) * A( 5 )
           B( 3, 3 ) = B( 3, 3 ) - B( 3, 2 ) * A( 5 )
           B( 4, 3 ) = B( 4, 3 ) - B( 4, 2 ) * A( 5 )
           B( 1, 3 ) = B( 1, 3 ) - B( 1, 1 ) * A( 4 )
           B( 2, 3 ) = B( 2, 3 ) - B( 2, 1 ) * A( 4 )
           B( 3, 3 ) = B( 3, 3 ) - B( 3, 1 ) * A( 4 )
           B( 4, 3 ) = B( 4, 3 ) - B( 4, 1 ) * A( 4 )
           B( 1, 2 ) = - B( 1, 2 ) * A( 3 )
           B( 2, 2 ) = - B( 2, 2 ) * A( 3 )
           B( 3, 2 ) = - B( 3, 2 ) * A( 3 )
           B( 4, 2 ) = - B( 4, 2 ) * A( 3 )
           B( 1, 2 ) = B( 1, 2 ) - B( 1, 1 ) * A( 2 )
           B( 2, 2 ) = B( 2, 2 ) - B( 2, 1 ) * A( 2 )
           B( 3, 2 ) = B( 3, 2 ) - B( 3, 1 ) * A( 2 )
           B( 4, 2 ) = B( 4, 2 ) - B( 4, 1 ) * A( 2 )
           B( 1, 1 ) = - B( 1, 1 ) * A( 1 )
           B( 2, 1 ) = - B( 2, 1 ) * A( 1 )
           B( 3, 1 ) = - B( 3, 1 ) * A( 1 )
           B( 4, 1 ) = - B( 4, 1 ) * A( 1 )
         ELSE
           DO 810 J1=1,M
              B( J1, 3 ) = - DDOT (  3 , B( J1, 1 ), LB, A( 4 ), 1 )
              B( J1, 2 ) = - DDOT (  2 , B( J1, 1 ), LB, A( 2 ), 1 )
              B( J1, 1 ) = - DDOT (  1 , B( J1, 1 ), LB, A( 1 ), 1 )
  810      CONTINUE
      END IF
!
      RETURN 
      END  !#!  SUBROUTINE TRMM7_3 
