#include <mk5_preprocessor_directives.inc>
      SUBROUTINE TRMM8_4  ( M, A, B, LB )
! ************************************************************************
! *                                                                      *
! *   Computes B := B*A(T)                                               *
! *   B dimensioned as (LB,N), A in upper triangular format.             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.11.28 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  M, LB
      REAL*8     A(*), B(LB,4 )
      REAL*8     S, S1, S2, S3, S4
      INTEGER*4  J1
      IF ( M .EQ. 1 ) THEN
           S = 0.0D0
           S = S + B( 1, 1 ) * A( 1 )
           S = S + B( 1, 2 ) * A( 2 )
           S = S + B( 1, 3 ) * A( 4 )
           S = S + B( 1, 4 ) * A( 7 )
           B(1, 1 ) = S
           S = 0.0D0
           S = S + B( 1, 2 ) * A( 3 )
           S = S + B( 1, 3 ) * A( 5 )
           S = S + B( 1, 4 ) * A( 8 )
           B(1, 2 ) = S
           S = 0.0D0
           S = S + B( 1, 3 ) * A( 6 )
           S = S + B( 1, 4 ) * A( 9 )
           B(1, 3 ) = S
           S = 0.0D0
           S = S + B( 1, 4 ) * A( 10 )
           B(1, 4 ) = S
         ELSE IF ( M .EQ. 2 ) THEN
           S1 = 0.0D0
           S2 = 0.0D0
           S1 = S1 + B( 1, 1 ) * A( 1 )
           S2 = S2 + B( 2, 1 ) * A( 1 )
           S1 = S1 + B( 1, 2 ) * A( 2 )
           S2 = S2 + B( 2, 2 ) * A( 2 )
           S1 = S1 + B( 1, 3 ) * A( 4 )
           S2 = S2 + B( 2, 3 ) * A( 4 )
           S1 = S1 + B( 1, 4 ) * A( 7 )
           S2 = S2 + B( 2, 4 ) * A( 7 )
           B( 1, 1 ) = S1
           B( 2, 1 ) = S2
           S1 = 0.0D0
           S2 = 0.0D0
           S1 = S1 + B( 1, 2 ) * A( 3 )
           S2 = S2 + B( 2, 2 ) * A( 3 )
           S1 = S1 + B( 1, 3 ) * A( 5 )
           S2 = S2 + B( 2, 3 ) * A( 5 )
           S1 = S1 + B( 1, 4 ) * A( 8 )
           S2 = S2 + B( 2, 4 ) * A( 8 )
           B( 1, 2 ) = S1
           B( 2, 2 ) = S2
           S1 = 0.0D0
           S2 = 0.0D0
           S1 = S1 + B( 1, 3 ) * A( 6 )
           S2 = S2 + B( 2, 3 ) * A( 6 )
           S1 = S1 + B( 1, 4 ) * A( 9 )
           S2 = S2 + B( 2, 4 ) * A( 9 )
           B( 1, 3 ) = S1
           B( 2, 3 ) = S2
           S1 = 0.0D0
           S2 = 0.0D0
           S1 = S1 + B( 1, 4 ) * A( 10 )
           S2 = S2 + B( 2, 4 ) * A( 10 )
           B( 1, 4 ) = S1
           B( 2, 4 ) = S2
         ELSE IF ( M .EQ. 3 ) THEN
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S1 = S1 + B( 1, 1 ) * A( 1 )
           S2 = S2 + B( 2, 1 ) * A( 1 )
           S3 = S3 + B( 3, 1 ) * A( 1 )
           S1 = S1 + B( 1, 2 ) * A( 2 )
           S2 = S2 + B( 2, 2 ) * A( 2 )
           S3 = S3 + B( 3, 2 ) * A( 2 )
           S1 = S1 + B( 1, 3 ) * A( 4 )
           S2 = S2 + B( 2, 3 ) * A( 4 )
           S3 = S3 + B( 3, 3 ) * A( 4 )
           S1 = S1 + B( 1, 4 ) * A( 7 )
           S2 = S2 + B( 2, 4 ) * A( 7 )
           S3 = S3 + B( 3, 4 ) * A( 7 )
           B( 1, 1 ) = S1
           B( 2, 1 ) = S2
           B( 3, 1 ) = S3
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S1 = S1 + B( 1, 2 ) * A( 3 )
           S2 = S2 + B( 2, 2 ) * A( 3 )
           S3 = S3 + B( 3, 2 ) * A( 3 )
           S1 = S1 + B( 1, 3 ) * A( 5 )
           S2 = S2 + B( 2, 3 ) * A( 5 )
           S3 = S3 + B( 3, 3 ) * A( 5 )
           S1 = S1 + B( 1, 4 ) * A( 8 )
           S2 = S2 + B( 2, 4 ) * A( 8 )
           S3 = S3 + B( 3, 4 ) * A( 8 )
           B( 1, 2 ) = S1
           B( 2, 2 ) = S2
           B( 3, 2 ) = S3
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S1 = S1 + B( 1, 3 ) * A( 6 )
           S2 = S2 + B( 2, 3 ) * A( 6 )
           S3 = S3 + B( 3, 3 ) * A( 6 )
           S1 = S1 + B( 1, 4 ) * A( 9 )
           S2 = S2 + B( 2, 4 ) * A( 9 )
           S3 = S3 + B( 3, 4 ) * A( 9 )
           B( 1, 3 ) = S1
           B( 2, 3 ) = S2
           B( 3, 3 ) = S3
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S1 = S1 + B( 1, 4 ) * A( 10 )
           S2 = S2 + B( 2, 4 ) * A( 10 )
           S3 = S3 + B( 3, 4 ) * A( 10 )
           B( 1, 4 ) = S1
           B( 2, 4 ) = S2
           B( 3, 4 ) = S3
         ELSE IF ( M .EQ. 4 ) THEN
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S4 = 0.0D0
           S1 = S1 + B( 1, 1 ) * A( 1 )
           S2 = S2 + B( 2, 1 ) * A( 1 )
           S3 = S3 + B( 3, 1 ) * A( 1 )
           S4 = S4 + B( 4, 1 ) * A( 1 )
           S1 = S1 + B( 1, 2 ) * A( 2 )
           S2 = S2 + B( 2, 2 ) * A( 2 )
           S3 = S3 + B( 3, 2 ) * A( 2 )
           S4 = S4 + B( 4, 2 ) * A( 2 )
           S1 = S1 + B( 1, 3 ) * A( 4 )
           S2 = S2 + B( 2, 3 ) * A( 4 )
           S3 = S3 + B( 3, 3 ) * A( 4 )
           S4 = S4 + B( 4, 3 ) * A( 4 )
           S1 = S1 + B( 1, 4 ) * A( 7 )
           S2 = S2 + B( 2, 4 ) * A( 7 )
           S3 = S3 + B( 3, 4 ) * A( 7 )
           S4 = S4 + B( 4, 4 ) * A( 7 )
           B( 1, 1 ) = S1
           B( 2, 1 ) = S2
           B( 3, 1 ) = S3
           B( 4, 1 ) = S4
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S4 = 0.0D0
           S1 = S1 + B( 1, 2 ) * A( 3 )
           S2 = S2 + B( 2, 2 ) * A( 3 )
           S3 = S3 + B( 3, 2 ) * A( 3 )
           S4 = S4 + B( 4, 2 ) * A( 3 )
           S1 = S1 + B( 1, 3 ) * A( 5 )
           S2 = S2 + B( 2, 3 ) * A( 5 )
           S3 = S3 + B( 3, 3 ) * A( 5 )
           S4 = S4 + B( 4, 3 ) * A( 5 )
           S1 = S1 + B( 1, 4 ) * A( 8 )
           S2 = S2 + B( 2, 4 ) * A( 8 )
           S3 = S3 + B( 3, 4 ) * A( 8 )
           S4 = S4 + B( 4, 4 ) * A( 8 )
           B( 1, 2 ) = S1
           B( 2, 2 ) = S2
           B( 3, 2 ) = S3
           B( 4, 2 ) = S4
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S4 = 0.0D0
           S1 = S1 + B( 1, 3 ) * A( 6 )
           S2 = S2 + B( 2, 3 ) * A( 6 )
           S3 = S3 + B( 3, 3 ) * A( 6 )
           S4 = S4 + B( 4, 3 ) * A( 6 )
           S1 = S1 + B( 1, 4 ) * A( 9 )
           S2 = S2 + B( 2, 4 ) * A( 9 )
           S3 = S3 + B( 3, 4 ) * A( 9 )
           S4 = S4 + B( 4, 4 ) * A( 9 )
           B( 1, 3 ) = S1
           B( 2, 3 ) = S2
           B( 3, 3 ) = S3
           B( 4, 3 ) = S4
           S1 = 0.0D0
           S2 = 0.0D0
           S3 = 0.0D0
           S4 = 0.0D0
           S1 = S1 + B( 1, 4 ) * A( 10 )
           S2 = S2 + B( 2, 4 ) * A( 10 )
           S3 = S3 + B( 3, 4 ) * A( 10 )
           S4 = S4 + B( 4, 4 ) * A( 10 )
           B( 1, 4 ) = S1
           B( 2, 4 ) = S2
           B( 3, 4 ) = S3
           B( 4, 4 ) = S4
         ELSE
           DO 810 J1=1,M
              S = 0.0D0
              S = S + B ( J1, 1 ) * A( 1 )
              S = S + B ( J1, 2 ) * A( 2 )
              S = S + B ( J1, 3 ) * A( 4 )
              S = S + B ( J1, 4 ) * A( 7 )
              B ( J1, 1 ) = S
              S = 0.0D0
              S = S + B ( J1, 2 ) * A( 3 )
              S = S + B ( J1, 3 ) * A( 5 )
              S = S + B ( J1, 4 ) * A( 8 )
              B ( J1, 2 ) = S
              S = 0.0D0
              S = S + B ( J1, 3 ) * A( 6 )
              S = S + B ( J1, 4 ) * A( 9 )
              B ( J1, 3 ) = S
              S = 0.0D0
              S = S + B ( J1, 4 ) * A( 10 )
              B ( J1, 4 ) = S
  810      CONTINUE
      END IF
!
      RETURN 
      END SUBROUTINE TRMM8_4 
