        SUBROUTINE REGRW8 ( N, T, D, W, IV, DR, SH, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá ÷ùþéóìåîéñ õçìï÷ïçï ëïüææéãéåîôá é ó÷ïâïäîïçï þìåîá *
! *     òåçòåóóéïîîïê ðòñíïê æõîëãéé D(T) .                              *
! *                                                                      *
! *     éóðïìøúõåôóñ íáóóé÷  IV, óïóôïñýéê éú  0 éìé 1 , ëïôïòùê         *
! *     ïôíåþáåô îåéóðïìøúï÷áîîùå ïôóþåôù. åóìé  IV(I)=1, ôï  I-ôùê      *
! *     ïôóþåô õþáóô÷õåô ÷ ÷ùþéóìåîéé ðáòáíåôòï÷ òåçòåóóéïîîïê ðòñíïê.   *
! *     åóìé  IV(J)=0, ôï J-ôùê üìåíåîô éóëìàþáåôóñ éú ðïäóþåôï÷.        *
! *                                                                      *
! *                                                                      *
! * ------------------------- ÷èïäîùå ðáòíåôòù: ------------------------ *
! *                                                                      *
! *        N  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷ õ ÷åëôïòï÷  D  é  T .   *
! *        T  ( REAL*8    )  --  ÷åëôïò áòçõíåîôï÷ æõîëãéé D .           *
! *        D  ( REAL*8    )  --  ÷åëôïò úîáþåîéê æõîëãéé, äìñ ëïôïòïê    *
! *                              ÷ùþéóìñåôóñ äéóðåòóéñ é óòåäîåå.        *
! *        W  ( REAL*8, OPT    )  --  ÷åëôïò ÷åóï÷ îåéú÷åóôîùè.          *
! *                                   ðáòáíåôòá ïðõýåî, ôï ÷óåí ôïþëáí   *
! *                                   ðòéó÷áé÷áåôóñ ÷åó 1 .              *
! *       IV  ( INTEGER*4, OPT )  --  ÷åëôïò, õëáúù÷áàýéê îá éóëìàþåîîùå *
! *                              éú ðïäóþåôï÷ üìåíåîôù.                  *
! *                              åóìé ðáòáíåôò  IV  ïðõýåî, éóðïìøúõàôóñ *
! *                              ÷óå üìåíåîôù.                           *
! *                                                                      *
! * ------------------------- ÷ùèïäîùå ðáòíåôòù: ----------------------- *
! *                                                                      *
! *       DR  ( REAL*8    )  --  ó÷ïâïäîùê þìåî ôòåîäá.                  *
! *       SH  ( REAL*8    )  --  õçìï÷ïê ëïüææéãéåîô ôòåîäá.             *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *      IUER=1  --  ðáòáíåôò  DR  îåäïóôõðåî äìñ úáðéóé.                *
! *      IUER=2  --  ðáòáíåôò  SH  îåäïóôõðåî äìñ úáðéóé.                *
! *      IUER=3  --  üìåíåîôï÷, ðï ëïôïòùí óôòïéôóñ òåçòåóóéïîîáñ ðòñíáñ *
! *                  íåîøûå 2 .                                          *
! *      IUER=4  --  ÷îõôòåîîññ ïûéâëá: ïðòåäåìéôåìø ðï íïäõìà íåîøûå    *
! *                  1.D-30.                                             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  06-MAY-91     REGRW8    V1.5  (d) ðÅÔÒÏ× ì.à.  01-DEC-97  ###  *
! *                                                                      *
! ************************************************************************
        IMPLICIT  NONE
        INTEGER*4 N, IUER
        REAL*8    T(N), D(N), W(N), DR, SH
        INTEGER*4 IV(*), J1, NZ, I_LEN
        REAL*8    SD, ST, SDT, TT, STT, DET, DX, DY, WEI, SW
        CHARACTER STR*10
        LOGICAL   W_PRES, IV_PRES
!
! .....................\\\
!                       \\\
!        LOGICAL PRESENT, PROBE_W, PROBE_R, IV_PRES, W_PRES
!        INTEGER*4 NUM$ARG, NA, N_ARG
!C
!        PARAMETER ( N_ARG=8 )  !  ëïìéþåóô÷ï æïòíáìøîùè ðáòáíåôòï÷
!C
!C ----- ðòï÷åòëá óïïô÷åôóô÷éñ ëïìéþåóô÷á æáëôéþåóëéè é æïòíáìøîùè ðáòáíôòï÷
!C
!        NA=NUM$ARG()  !  Mù õúîáìé ëïìéþåóô÷ï æáëôéþåóëéè ðáòáíåôï÷
!        IF ( .NOT. ( NA.EQ.N_ARG .OR. ( .NOT. PRESENT ( IUER, N_ARG  )
!     $       .AND.   NA.EQ.(N_ARG-1) ) ) )    CALL VER$ARG ( N_ARG )
!C                        ///
!C ......................///  ...   ëïîåã ðòï÷åòëé  ...
!C
!        IF ( .NOT. PROBE_W ( 1, 8, DR ) ) THEN
!              CALL ERR_LOG ( 1, IUER, 'REGRW8', 'ðáòáíåôò DR '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, SH ) ) THEN
!              CALL ERR_LOG ( 2, IUER, 'REGRW8', 'ðáòáíåôò SH '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( PRESENT ( W, 4 ) .AND. PROBE_R ( N, 4, W ) ) THEN
!             W_PRES=.TRUE.
!          ELSE
!             W_PRES=.FALSE.
!        END IF
!C
!        IF ( PRESENT ( IV, 5 ) .AND. PROBE_R ( N, 4, IV ) ) THEN
!             IV_PRES=.TRUE.
!          ELSE
!             IV_PRES=.FALSE.
!        END IF
!C
        IF ( LOC(W) .EQ. 0 ) THEN
             W_PRES = .FALSE.
          ELSE
             W_PRES = .TRUE.
        END IF
        IF ( LOC(IV) .EQ. 0 ) THEN
             IV_PRES = .FALSE.
          ELSE
             IV_PRES = .TRUE.
        END IF
!
        SD  = 0.0D0
        SW  = 0.0D0
        ST  = 0.0D0
        SDT = 0.0D0
        STT = 0.0D0
        NZ  = 0
!
! ----- ÷ùþéóìåîéå ëïüææéãéåîôï÷ îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        DO 410 J1=1,N
           IF ( IV_PRES ) THEN
                IF ( IV(J1).EQ.0 ) GOTO 410
           END IF
           IF ( W_PRES ) THEN
                WEI = W(J1)
              ELSE
                WEI = 1.D0
           END IF
!
           NZ  = NZ+1
           SW  = SW + WEI**2
           SD  = SD + D(J1)*WEI**2
           TT  = T(J1)-T(1)
           ST  = ST  + TT*WEI**2
           SDT = SDT + D(J1)*TT*WEI**2
           STT = STT + TT**2 * WEI**2
  410   CONTINUE
!
! ----- ïëáúáìïóø, þôï þéóìï üìåíåîôï÷, õþáóô÷õàýéè ÷ ðïäóþåôáè, óìéûëïí íáìï
!
        IF ( NZ.LT.2 ) THEN
             CALL CLRCH ( STR )
             CALL INCH ( NZ, STR )
             CALL ERR_LOG ( 3, IUER, 'REGRW8', 'õþáóô÷õåô ôïìøëï '// &
     &                      STR(1:I_LEN(STR))//' üìåíåîôï÷' )
             RETURN
        END IF
!
! ----- ÷ùþéóìåîéå ïðòåäåìéôåìñ îïòíáìøîïê óéóôåíù
!
        DET = SW*STT - ST*ST
!
! ----- ÷ùþéóìåîéå íéîïòï÷ íáôòéãù îïòíáìøîïê óéóôåíù
!
        DX = SW*SDT - SD*ST
        DY = SD*STT - ST*SDT
!
! ----- ïðåòåäåìéôåìø óéóôåíù óìéûëïí íáì
!
        IF ( DABS(DET) .LT. 1.D-30 ) THEN
             CALL ERR_LOG ( 4, IUER, 'REGRW8', '÷îõôòåîîññ ïûéâëá: '// &
     &                      'îõìå÷ïê ïðòåäåìéôåìø' )
             RETURN
        END IF
!
! ----- òåûåîéå îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        DR = DX/DET
        SH = DY/DET
        CALL ERR_LOG ( 0, IUER )
        RETURN
        END  !#!  REGRW8  #!#
!
! ------------------------------------------------------------------------
!
        SUBROUTINE DESIG8 ( N, T, X, IV, NZ, ED_I, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá  DESIG8  ïôíåþáåô üìåíåîôù, ëïôïòùå ðòå÷ùûáàô       *
! *     úáäáîîïå þéóìï óôáîäáòôîùè ïôëìïîåîéê ïôîïóéôåìøîï òåçòåóóéïîîïê *
! *     ðòñíïê ô.å. òáúîïóôé : X(I) - ( A*T(I) + B )                     *
! *            çäå A  --  ëïüææéãéåîô îáëìïîá òåçòåóóéïîîïê ðòñíïê, á    *
! *                B  --  ó÷ïâïäîùê þìåî òåçòåóóéïîîïê ðòñíïê, á         *
! *                                                                      *
! *________________________ ÷èïäîùå ðáòáíåôòù: __________________________*
! *                                                                      *
! *       N  ( INTEGER*4 )  --  äìéîá íáóóé÷ï÷.                          *
! *       T  ( REAL*8    )  --  íáóóé÷ áòçõíåîôá.                        *
! *       X  ( REAL*8    )  --  íáóóé÷ úîáþåîéê.                         *
! *                                                                      *
! *_____________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________*
! *                                                                      *
! *      IV  ( INTEGER*4 )  --  ãåìùê íáóóé÷ äìéîïê N, ïôíåþáàýéê        *
! *                             ÷ùâòáóù÷áåíùå üìåíåîôù. åóìé IV(I)=0,    *
! *                             ôï I-ôùê üìåíåîô ïôíåþáåôóñ ëáë ÷ùâòïó,  *
! *                             åóìé  IV(J)=1, ôï J-ôùê üìåíåîô          *
! *                             õþáóô÷õåô ÷ äáìøîåêûéè ÷ùþéóìåîéñè.      *
! *                                                                      *
! *_______________________ ÷ùèïäîùå ðáòáíåôòù: __________________________*
! *                                                                      *
! *      NZ  ( INTEGER*4 )  --  þéóìï îåïôâòïûåîîùè üìåíåîôï÷.           *
! *                                                                      *
! * ___________________ ÷èïäîïê ïðõóëáåíùê ðáòáíåôò: ___________________ *
! *                                                                      *
! *      ED_I  ( REAL*8  )  --  ëïìéþåóô÷ï óôáîäáòôîùè ïôëìïîåîéê,       *
! *                             ëïôïòïå îáäï ðòå÷ùóéôø, þôïâù âùôø       *
! *                             ïôâòïûåîîùí .                            *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *                                                                      *
! *      ðòéíåþáîéå: åóìé ðáòáíåôò  ED ïðõýåî, ôï ïî úáðòáûé÷áåôóñ ó     *
! *      ôåòíéîáìá.  åóìé é îá úáðòïó ïô÷åôéôø <÷ë>, ôï ðï õíïìþáîéà     *
! *      ED ÷ùâåòåôóñ òá÷îùí 3 .                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  06-MAY-91     DESIG8    V1.4  (d) ðÅÔÒÏ× ì.à.  08-AUG-94  ###  *
! *                                                                      *
! ************************************************************************
        REAL*8  T(N), X(N), AV, D, ED_I, VALKR, A, B
        INTEGER*4  IER
        INTEGER IV(N)
!
!        NA=NUM$ARG()
!        IF ( NA.LT.5 .AND. NA.GT.7 ) CALL VER$ARG ( 7 )
!
! ----- ÷ùþéóìåîéå ëïüææéãéåîôï÷ òåçòåóóéé A é B
!
        CALL REGRW8 ( N, T, X, %VAL(0), IV, A, B, IER )
!
! ----- ÷ùþéóìåîéå óòåäîåçï  --  AV  é äéóðåòóéé  --  ä  òáúîïóôé
! ----- íáóóé÷-òåçòåóóéñ
!
        CALL ERR_PASS ( IUER, IER )
        CALL DISP_TR8 ( N, T, X, A, B, IV, AV, D, NZ, IER )
        IF ( IER.GT.0 ) THEN
             CALL ERR_LOG ( IER, IUER, 'DESIG8', 'aa' )
             RETURN
        END IF
!
! ----- úáäáîéå  ED  --  þéóìï óôáîäáòôîùè ïôëìïîåîéê ïôîïóéôåìøîï
! ----- òåçòåóóéïîîïê ðòñíïê, âïìøûå ëïôïòùè óìåäõåT üìåíåîô ïôíåþáôø ëáë
! ----- ÷ùâòïó
!
!        IF ( NA.EQ.5 ) THEN
!             TYPE 110
!  110        FORMAT(1X/2X,'???  éóëìàþéôø ÷ùâòïóù, ëïôïòùå ðòå÷ùûáàô'/
!     *       2X,'óëïìøëï óòåäîåë÷áäòáôéþîùè ïôëìïîåîéê  <3.>  ? '$)
!             ACCEPT 120,IQ,ED
!  120        FORMAT(Q,G15.7)
!             IF( IQ.EQ.0 ) ED=3.   !  ðï õíïìþáîéà  ED=3
!          ELSE
!             ED=ED_I
!             IF ( ED .LT. 1.D-5 ) ED=3.
!        END IF
         ED=ED_I
         IF ( ED .LT. 1.D-5 ) ED=3.0
!
! ##### îáþáìï éôåòáôé÷îïçï ãéëìá
!
  610   IDEL=0
        VALKR=ED*D
        DO 410 J1=1,N
           IF( IV(J1) .EQ. 0 ) GOTO 410
!
! -------- IDEL  --  þéóìï éóëìàþåîîùè üìíåîôï÷ îá äáîîïí ûáçå ãéëìá
!
           TT=T(J1)-T(1)
           IF( DABS( (X(J1)-AV)-(A*TT+B) ) .GT. VALKR ) IDEL=IDEL+1
           IF( DABS( (X(J1)-AV)-(A*TT+B) ) .GT. VALKR ) IV(J1)=0
  410   CONTINUE
!
! ----- åýå òáú ÷ùþéóìåîéå óòåäîåçï é äéóðåòóéé
!
        CALL REGRW8 ( N, T, X, %VAL(0), IV, A, B, IER )
        CALL ERR_PASS ( IUER, IER )
        CALL DISP_TR8 ( N, T, X, A, B, IV, AV, D, NZ, IER )
        IF ( IER.GT.0 ) THEN
             CALL ERR_LOG ( IER, IUER, 'DESIG8', 'bb' )
             RETURN
        END IF
!
! ----- åóìé îá äáîîïí ûáçå éóëìàþåîîùè üìåíåîôï÷ îåô  --  ôï ÷ùèïä éú ãéëìá
!
        IF ( IDEL .EQ. 0 ) THEN
             CALL ERR_LOG ( 0, IUER )
             RETURN
        END IF
        GOTO 610
!
! ##### ëïîåã éôåòáôé÷îïçï ãéëìá
!
        END  !#!  DESIG8  #!#
!
! ------------------------------------------------------------------------
!
        SUBROUTINE REGRV_EL8 ( N, T, D, IV, IV_EL, A, B, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá ÷ùþéóìåîéñ õçìï÷ïçï ëïüææéãéåîôá é ó÷ïâïäîïçï þìåîá *
! *     òåçòåóóéïîîïê ðòñíïê æõîëãéé D(T) .                              *
! *                                                                      *
! *     éóðïìøúõåôóñ ÷åëôïò õþáóôéñ, ëïôïòùê ïôíåþáåô üìåíåîôù, ëïôïòùå  *
! *     âõäõô òáóóíáôòé÷áôøóñ. ÷ ïâòáâïôëõ âõäõô ÷ëìàþáôøóñ ôïìøëï ôå    *
! *     üìåíåîôù, äìñ ëïôïòùè IV(I)=IV_EL .                              *
! *                                                                      *
! *                                                                      *
! * ------------------------- ÷èïäîùå ðáòíåôòù: ------------------------ *
! *                                                                      *
! *        N  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷ õ ÷åëôïòï÷  D  é  T .   *
! *        T  ( REAL*8    )  --  ÷åëôïò áòçõíåîôï÷ æõîëãéé D .           *
! *        D  ( REAL*8    )  --  ÷åëôïò úîáþåîéê æõîëãéé, äìñ ëïôïòïê    *
! *                              ÷ùþéóìñåôóñ äéóðåòóéñ é óòåäîåå.        *
! *       IV  ( INTEGER*4 )  --  ÷åëôïò õþáóôéñ.                         *
! *     IV_EL ( INTEGER*4 )  --  úîáþåîéå, ëïôïòïå õëáúù÷áåô îá          *
! *                              éóðïìøúõåíùê üìåíåîô.
! *                                                                      *
! * ------------------------- ÷ùèïäîùå ðáòíåôòù: ----------------------- *
! *                                                                      *
! *        A  ( REAL*8    )  --  õçìï÷ïê ëïüææéãéåîô ôòåîäá.             *
! *        B  ( REAL*8    )  --  ó÷ïâïäîùê þìåî ôòåîäá.                  *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *      IUER=1  --  ðáòáíåôò  A  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=2  --  ðáòáíåôò  B  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=3  --  üìåíåîôï÷, ðï ëïôïòùí óôòïéôóñ òåçòåóóéïîîáñ ðòñíáñ *
! *                  íåîøûå 2 .                                          *
! *      IUER=4  --  ÷îõôòåîîññ ïûéâëá: ïðòåäåìéôåìø ðï íïäõìà íåîøûå    *
! *                  1.D-30.                                             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  13-JUL-91   REGRV_EL8   V1.4  (d) ðÅÔÒÏ× ì.à.  08-AUG-94  ###  *
! *                                                                      *
! ************************************************************************
        REAL*8    T(N), D(N), A, B
        INTEGER*4 IV(N), IV_EL
        REAL*8    SD, ST, SDT, STT, DET, DX, DY
        CHARACTER STR*10
!
! .....................\\\
!                       \\\
!        LOGICAL PRESENT, PROBE_W, PROBE_R, IV_PRES
!        INTEGER*4 NUM$ARG, NA, N_ARG
!C
!        PARAMETER ( N_ARG=8 )  !  ëïìéþåóô÷ï æïòíáìøîùè ðáòáíåôòï÷
!C
!C ----- ðòï÷åòëá óïïô÷åôóô÷éñ ëïìéþåóô÷á æáëôéþåóëéêè é æïòíáìøîùè ðáòáíôòï÷
!C
!        NA=NUM$ARG()  !  Mù õúîáìé ëïìéþåóô÷ï æáëôéþåóëéè ðáòáíåôï÷
!        IF ( .NOT. ( NA.EQ.N_ARG .OR. ( .NOT. PRESENT ( IUER, N_ARG  )
!     $       .AND.   NA.EQ.(N_ARG-1) ) ) )    CALL VER$ARG ( N_ARG )
!C                        ///
!C ......................///  ...   ëïîåã ðòï÷åòëé  ...
!C
!        IF ( .NOT. PROBE_W ( 1, 8, A ) ) THEN
!              CALL ERR_LOG ( 1, IUER, 'REGRV_EL8', 'ðáòáíåôò A '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, B ) ) THEN
!              CALL ERR_LOG ( 2, IUER, 'REGRV_EL8', 'ðáòáíåôò B '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_R ( N, 4, IV ) ) THEN
!              CALL ERR_LOG ( 5, IUER, 'REGRV_EL8', 'ðáòáíåôò IV '//
!     $                                'îåäïóôõðåî äìñ þôåîéñ' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_R ( 1, 4, IV_EL ) ) THEN
!              CALL ERR_LOG ( 6, IUER, 'REGRV_EL8', 'ðáòáíåôò IV_EL '//
!     $                                'îåäïóôõðåî äìñ þôåîéñ' )
!              RETURN
!        END IF
!
        SD= 0.0D0
        ST= 0.0D0
        SDT=0.0D0
        STT=0.0D0
        NZ=0
!
! ----- ÷ùþéóìåîéå ëïüææéãéåîôï÷ îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        DO 410 J1=1,N
           IF ( IV(J1).EQ.IV_EL ) THEN
                NZ=NZ+1
                SD=SD+D(J1)
                TT=T(J1)-T(1)
                ST=ST+TT
                SDT=SDT+D(J1)*TT
                STT=STT+TT**2
           END IF
  410   CONTINUE
!
! ----- ïëáúáìïóø, þôï þéóìï üìåíåîôï÷, õþáóô÷õàýéè ÷ ðïäóþåôáè, óìéûëïí íáìï
!
        IF ( NZ.LT.2 ) THEN
             CALL CLRCH ( STR )
             CALL INCH ( NZ, STR )
             CALL ERR_LOG ( 3, IUER, 'REGRV_EL8', 'õþáóô÷õåô ôïìøëï '// &
     &                      STR(1:I_LEN(STR))//' üìåíåîôï÷' )
             RETURN
        END IF
!
! ----- ÷ùþéóìåîéå ïðòåäåìéôåìñ îïòíáìøîïê óéóôåíù
!
        DET=NZ*STT-ST*ST
!
! ----- ÷ùþéóìåîéå íéîïòï÷ íáôòéãù îïòíáìøîïê óéóôåíù
!
        DX=NZ*SDT-SD*ST
        DY=SD*STT-ST*SDT
!
! ----- ïðåòåäåìéôåìø óéóôåíù óìéûëïí íáì
!
        IF ( DABS(DET) .LT. 1.D-30 ) THEN
             CALL ERR_LOG ( 4, IUER, 'REGRV_EL8', '÷îõôòåîîññ ïûéâëá: '// &
     &                      'îõìå÷ïê ïðòåäåìéôåìø' )
             RETURN
        END IF
!
! ----- òåûåîéå îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        A=DX/DET
        B=DY/DET
        CALL ERR_LOG ( 0, IUER )
        END  !#!  REGRV_EL8  #!#
!
! ------------------------------------------------------------------------
!
!
        SUBROUTINE DESIG_EL8 ( N, T, X, IV, IV_EL, ED, NZ, SH, DR, IUER)
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá  DESIG_EL8  ïôíåþáåô üìåíåîôù, ëïôïòùå ðòå÷ùûáàô    *
! *     úáäáîîïå þéóìï óôáîäáòôîùè ïôëìïîåîéê ïôîïóéôåìøîï òåçòåóóéïîîïê *
! *     ðòñíïê ô.å. òáúîïóôé : X(I) - ( SH + DR*T(I) )                   *
! *            çäå  SH  --  ó÷ïâïäîùê þìåî òåçòåóóéïîîïê ðòñíïê.         *
! *                 DR  --  ëïüææéãéåîô îáëìïîá òåçòåóóéïîîïê ðòñíïê.    *
! *                                                                      *
! *________________________ ÷èïäîùå ðáòáíåôòù: __________________________*
! *                                                                      *
! *       N  ( INTEGER*4 )  --  äìéîá íáóóé÷ï÷.                          *
! *       T  ( REAL*8    )  --  íáóóé÷ áòçõíåîôá.                        *
! *       X  ( REAL*8    )  --  íáóóé÷ úîáþåîéê.                         *
! *   IV_EL  ( INTEGER*4 )  --  úîáþåîéå, ëïôïòïå õëáúù÷áåô îá           *
! *                             éóðïìøúõåíùê üìåíåîô.                    *
! *      ED  ( REAL*8    )  --  ëïìéþåóô÷ï óôáîäáòôîùè ïôëìïîåîéê,       *
! *                             ëïôïòïå îáäï ðòå÷ùóéôø, þôïâù âùôø       *
! *                             ïôâòïûåîîùí.                             *
! *                                                                      *
! *_______________________ ÷ùèïäîùå ðáòáíåôòù: __________________________*
! *                                                                      *
! *      NZ  ( INTEGER*4 )  --  þéóìï îåïôâòïûåîîùè üìåíåîôï÷.           *
! *      SH  ( REAL*8    )  --  ó÷ïâïäîùê þìåî òåçòåóóéïîîïê ðòñíïê.     *
! *      DR  ( REAL*8    )  --  ëïüææéãéåîô îáëìïîá òåçòåóóéïîîïê ðòñíïê *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *      IV  ( INTEGER*4 )  --  ÷åëôïò õþáóôéñ.                          *
! *    IUER  ( INTEGER*4, OPT )  --  ðáòáíåôò ïûéâëé:                    *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  14-JUL-92   DESIG_EL8   V1.4  (d) ðÅÔÒÏ× ì.à.  08-AUG-94  ###  *
! *                                                                      *
! ************************************************************************
        IMPLICIT   NONE 
        INTEGER    N, IV(N), IV_EL, NZ, IUER
        REAL*8     T(N), X(N), ED, AV, D, VALKR, SH, DR
        REAL*8     TT
        INTEGER*4  J1, J2, IDEL, IER
        INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
! .....................\\\
!                       \\\
!        LOGICAL PRESENT
!        INTEGER*4 NUM$ARG, NA, N_ARG
!C
!        PARAMETER ( N_ARG=10 )  !  ëïìéþåóô÷ï æïòíáìøîùè ðáòáíåôòï÷
!C
!!C ----- ðòï÷åòëá óïïô÷åôóô÷éñ ëïìéþåóô÷á æáëôéþåóëéè é æïòíáìøîùè ðáòáíåôòï÷
!C
!        NA=NUM$ARG()  !  Mù õúîáìé ëïìéþåóô÷ï æáëôéþåóëéè ðáòáíåôòï÷
!        IF ( .NOT. ( NA.EQ.N_ARG .OR. ( .NOT. PRESENT ( IUER, N_ARG )
!     $       .AND.   NA.EQ.(N_ARG-1) ) ) )    CALL  VER$ARG ( N_ARG )
!C                        ///
!C ......................///  ...   ëïîåã ðòï÷åòëé  ...
!C
!
! ----- ÷ùþéóìåîéå ëïüææéãéåîôï÷ òåçòåóóéé SH é DR
!
        CALL ERR_PASS  ( IUER, IER )
        CALL REGRV_EL8 ( N, T, X, IV, IV_EL, DR, SH, IER )
        IF ( IER.GT.0 ) THEN
             CALL ERR_LOG ( IER, IUER, 'DESIG_EL8', &
     &                     'ïûéâëá ÷ DISP_TREL8' )
             RETURN
        END IF
!
! ----- ÷ùþéóìåîéå óòåäîåçï  --  AV  é äéóðåòóéé  --  D  òáúîïóôé
! ----- íáóóé÷-òåçòåóóéñ
!
        CALL ERR_PASS  ( IUER, IER )
        CALL DISP_TREL8 ( N, T, X, DR, SH, IV, IV_EL, AV, D, NZ, IER )
        IF ( IER.GT.0 ) THEN
             CALL ERR_LOG ( IER, IUER, 'DESIG_EL8', &
     &                     'ïûéâëá ÷ DISP_TREL8' )
             RETURN
        END IF
!
! ##### îáþáìï éôåòáôé÷îïçï ãéëìá
!
        DO 410 J1=1,N
           IDEL=0
           VALKR=ED*D
           DO 420 J2=1,N
              IF ( IV(J2).EQ.IV_EL ) THEN
!
! --------------- IDEL  --  þéóìï éóëìàþåîîùè üìíåîôï÷ îá äáîîïí ûáçå ãéëìá
!
                  TT=T(J2)-T(1)
                  IF ( DABS ( (X(J2)-AV)-(SH+DR*TT) ) .GT. VALKR ) THEN
!
! -------------------- õ äáîîïçï îáâìàäåîéñ îå÷ñúëá ðòå÷ùóéìá ðïòïç
!
                       IDEL=IDEL+1
                       IV(J2)=0
                  END IF
              END IF
  420      CONTINUE
           IF ( (NZ-IDEL).LT.3 ) THEN
                CALL ERR_LOG ( 13, IUER, 'DESIG_TREL8', '÷ùâòïûåîù '// &
     &                        '÷óå üìåíåîåôù' )
                RETURN
           END IF
!
! -------- åýå òáú ÷ùþéóìåîéå ðáòáíåôòï÷ òåçòåóéïîîïê ðòñíïê
!
           CALL ERR_PASS  ( IUER, IER )
           CALL REGRV_EL8  ( N, T, X, IV, IV_EL, DR, SH, IER )
!
! -------- åýå òáú ÷ùþéóìåîéå óòåäîåçï é äéóðåòóéé
!
           CALL ERR_PASS  ( IUER, IER )
           CALL DISP_TREL8 ( N, T, X, DR, SH, IV, IV_EL, AV, D, NZ, IER)
           IF ( IER.GT.0 ) THEN
                CALL ERR_LOG ( IER, IUER, 'DESIG_EL8', &
     &                        'ïûéâëá ÷ DISP_TREL' )
                RETURN
           END IF
!
! -------- åóìé îá äáîîïí ûáçå éóëìàþåîîùè üìåíåîôï÷ îåô  --  ôï ÷ùèïä éú ãéëìá
!
           IF ( IDEL.EQ.0 ) THEN
                CALL ERR_LOG ( 0, IUER )
                RETURN
           END IF
  410   CONTINUE
        CALL ERR_LOG ( 7, IUER, 'DESIG_EL8', 'éôåòáãéé òáúïûìéóø' )
        RETURN
!
! ##### ëïîåã éôåòáôé÷îïçï ãéëìá
!
        END  !#!  DESIG_EL8  #!#
!
! ------------------------------------------------------------------------
!
        SUBROUTINE WDISP8 ( N, X, W, IV, AV, D, DW, DSW, NZ, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá WDISP8 ÷ùþéóìñåô ëïòåîø ë÷áäòáôîùê éú îå÷ú÷åûåîîïê  *
! *     äéóðåòóéé -- D, ëïòåîø ë÷áäòáôîùê éú ÷ú÷åûåîîïê äéóðåòóéé,       *
! *     ûëáìéòï÷áîîïê îá óòåäîåå úîáþåîéå  - DW, ëïòåîø ë÷áäòáôîùê éú    *
! *     ÷ú÷åûåîîïê äéóðåòóéé - DSW, óòåäîåå  -- AV  é þéóìï              *
! *     éóðïìøúï÷áîîùè ïôóþåôï÷  --  NZ  äìñ  íáóóé÷á  X  äìéîïê N.      *
! *     W  --  íáóóé÷ ÷åóï÷ ÷åìéþéîù X.                                  *
! *     éóðïìøúõåôóñ íáóóé÷  IV, óïóôïñýéê éú  0 éìé 1, ëïôïòùê ïôíåþáåô *
! *     îåéóðïìøúï÷áîîùå ïôóþåôù. åóìé  IV(I)=1, ôï  I-ôùê ïôóþåô        *
! *     õþáóô÷õåô ÷ ïâòáúï÷áîéé óòåäîåçï é äéóðåòóéé, åóìé  IV(J)=0, ôï  *
! *     J-ôùê üìåíåîô éóëìàþáåôóñ éú ðïäóþåôï÷.                          *
! *                                                                      *
! * ------------------------- ÷èïäîùå ðáòíåôòù: ------------------------ *
! *                                                                      *
! *        N  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷ õ ÷åëôïòá  X .          *
! *        X  ( REAL*8    )  --  ÷åëôïò, äìñ ëïôïòïçï óþéôáåôóñ          *
! *                              äéóðåòóéñ é óòåäîåå.                    *
! *        W  ( REAL*8    )  --  ÷åëôïò ÷åóï÷ ÷åìéþéîù X.                *
! *       IV  ( INTEGER*4, OPT )  --  ÷åëôïò, õëáúù÷áàýéê îá éóëìàþîîùå *
! *                              éú ðïäóþåôï÷ üìåíåîôù.                  *
! *                              åóìé ðáòáíåôò  IV  ïðõýåî, éóðïìøúõàôóñ *
! *                              ÷óå üìåíåîôù.                           *
! *                                                                      *
! * ------------------------- ÷ùèïäîùå ðáòíåôòù: ----------------------- *
! *                                                                      *
! *       AV  ( REAL*8    )  --  óòåäîåå éú NZ üìåíåîôï÷ íáóóé÷á X .     *
! *        D  ( REAL*8    )  --  R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X .     *
! *       DW  ( REAL*8    )  --  ûëáìéòï÷áîîáñ îá óòåäîåå úîáþåîéå       *
! *                              ÷åóá W.R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X*
! *      DSW  ( REAL*8    )  --  W.R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X .   *
! *       NZ  ( INTEGER*4, OPT )  --  þéóìï üìåíåîôï÷, ëïôïòùå ÷         *
! *                              ÷ õþáóô÷ï÷ïáìé ðïäóþåôå.                *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *      IUER=1  --  ðáòáíåôò  A  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=2  --  ðáòáíåôò  D  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=3  --  üìåíåîôï÷, ðï ëïôïòùí ÷ùþéóìñåôóñ äéóðåòóéñ,        *
! *                  íåîøûå 2 .                                          *
! *      IUER=4  --  ðáòáíåôò  DW îåäïóôõðåî äìñ úáðéóé.                 *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  04-JUN-93     WDISP8    V2.6  (d) ðÅÔÒÏ× ì.à.  20-OCT-95  ###  *
! *                                                                      *
! ************************************************************************
        IMPLICIT   NONE 
        INTEGER    N, IV(N), NZ, IUER
        REAL*8     X(N), W(N), D, AV, DW, DSW, WW
        CHARACTER  STR*10
        INTEGER*4  J1, J2, NZZ
        LOGICAL*4  IV_PRES
        INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
! .....................\\\
!                       \\\
!        LOGICAL   PRESENT, PROBE_W, PROBE_R, IV_PRES
!        INTEGER*4 NUM$ARG, NA, N_ARG
!C
!        PARAMETER ( N_ARG=10 )  !  ëïìéþåóô÷ï æïòíáìøîùè ðáòáíåôòï÷
!C
!C ----- ðòï÷åòëá óïïô÷åôóô÷éñ ëïìéþåóô÷á æáëôéþåóëéêè é æïòíáìøîùè ðáòáíôòï÷
!C
!        NA=NUM$ARG()  !  Mù õúîáìé ëïìéþåóô÷ï æáëôéþåóëéè ðáòáíåôï÷
!        IF ( .NOT. ( NA.EQ.N_ARG .OR. ( .NOT. PRESENT ( IUER, N_ARG  )
!     $       .AND.   NA.EQ.(N_ARG-1) ) ) )    CALL VER$ARG ( N_ARG )
!C                        ///
!C ......................///  ...   ëïîåã ðòï÷åòëé  ...
!C
!        IF ( .NOT. PROBE_W ( 1, 8, AV ) ) THEN
!              CALL ERR_LOG ( 1, IUER, 'WDISP8', 'ðáòáíåôò AV '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, D ) ) THEN
!              CALL ERR_LOG ( 2, IUER, 'WDISP8', 'ðáòáíåôò D '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, DW ) ) THEN
!              CALL ERR_LOG ( 3, IUER, 'WDISP8', 'ðáòáíåôò DW '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, DSW ) ) THEN
!              CALL ERR_LOG ( 4, IUER, 'WDISP8', 'ðáòáíåôò DSW '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!
!        IF ( PROBE_R ( N, 4, IV ) ) THEN
!             IV_PRES=.TRUE.
!          ELSE
!             IV_PRES=.FALSE.
!        END IF
!
        IF ( LOC(IV) .EQ. 0 ) THEN
             IV_PRES = .FALSE.
          ELSE
             IV_PRES = .TRUE.
        END IF
!
! ----- îáþáìøîùå ïâîõìåîéñ
!
        AV=0.D0
        NZZ=0
!
! ----- ÷ùþéóìåîéå óòåäîåçï
!
        DO 410 J1=1,N
           IF ( IV_PRES ) THEN
                IF ( IV(J1).EQ.0 ) GOTO 410
           END IF
           NZZ=NZZ+1             !  NZZ  --  þéóìï õþáóô÷ï÷á÷ûéè
!                                !           ÷ ðïäóþåôáè üìåíåîôï÷
           AV=AV+X(J1)
 410   CONTINUE
!
! ----- ïëáúáìïóø, þôï þéóìï üìåíåîôï÷, õþáóô÷õàýéè ÷ ðïäóþåôáè, óìéûëïí íáìï
!
        IF ( NZZ.LT.2 ) THEN
             CALL CLRCH   ( STR )
             CALL INCH    ( NZZ, STR )
             CALL ERR_LOG ( 3, IUER, 'WDISP8', 'õþáóô÷õåô ôïìøëï '// &
     &                      STR(1:I_LEN(STR))//' üìåíåîôï÷' )
!!             IF ( PRESENT ( NZ, 8 ) .AND. PROBE_W ( 1, 4, NZ ) ) NZ=NZZ
             IF ( LOC(NZ) .NE. 0 ) NZ = NZZ
             RETURN
        END IF
        AV=AV/NZZ
!
! ----- ÷ùþéóìåîéå äéóðåòóéé
!
        D  = 0.0D0
        DW = 0.0D0
        WW = 0.0D0
        DO 420 J2=1,N
           IF ( IV_PRES ) THEN
                IF ( IV(J2).EQ.0 ) GOTO 420
           END IF
           D=D   + ( X(J2)-AV )**2
           DW=DW + ( W(J2)* (X(J2)-AV) )**2
           WW=WW +   W(J2)**2
  420   CONTINUE
!
        IF ( DABS(WW) .LT. 1.D-30 ) THEN
             WRITE ( 6,  * ) ' WW=',WW,' NZZ=',NZZ
             CALL ERR_LOG ( 4, IUER, 'WDISP', 'éóðïìøúï÷áîîùå '// &
     &                      '÷åóá ïëáúáìéóø îõìå÷ùíé' )
             RETURN
        END IF
!
! ----- ðòï÷òåëá: äïóôáôïþîïå ìé þéóìï üìåíåîôï÷ ?
!
        D   = DSQRT ( D/(NZZ-1) )
        DSW = DSQRT ( DW/NZZ    )
        DW  = DSQRT ( DW/WW     )
!!        IF ( PRESENT ( NZ, 8 ) .AND. PROBE_W ( 1, 4, NZ ) ) NZ=NZZ
        IF ( LOC(NZ) .NE. 0 ) NZ=NZZ
        CALL ERR_LOG ( 0, IUER )
        RETURN
        END  !#!  WDISP8  #!#
!
! ------------------------------------------------------------------------
!
        SUBROUTINE WDISP_EL8 ( N, X, W, IV, IV_EL, AV, D, DW, DSW, &
     &                         CHI, NZ, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá  WDISP_EL8  ÷ùþéóìñåô ëïòåîø ë÷áäòáôîùê éú          *
! *     îå÷ú÷åûåîîïê äéóðåòóéé -- D, ëïòåîø ë÷áäòáôîùê éú ÷ú÷åûåîîïê     *
! *     äéóðåòóéé, ûëáìéòï÷áîîïê îá óòåäîåå úîáþåîéå  - DW, ëïòåîø       *
! *     ë÷áäòáôîùê éú ÷ú÷åûåîîïê äéóðåòóéé - DSW, óòåäîåå  -- AV  é      *
! *     þéóìï éóðïìøúï÷áîîùè ïôóþåôï÷  --  NZ  äìñ  íáóóé÷á  X äìéîïê N. *
! *     W  --  íáóóé÷ ÷åóï÷ ÷åìéþéîù X.                                  *
! *     éóðïìøúõåôóñ íáóóé÷  IV, ëïôïòùê ïôíåþáåô éóðïìøúõåíùå ïôóþåôù.  *
! *     ðòé üôïí éóðïìøúõåôóñ ôïìøëï ôå ïôóþôù  X(I), äìñ ëïôïòùè       *
! *     IV(I)=IV_EL.                                                     *
! *                                                                      *
! * ------------------------- ÷èïäîùå ðáòíåôòù: ------------------------ *
! *                                                                      *
! *        N  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷ õ ÷åëôïòá  X .          *
! *        X  ( REAL*8    )  --  ÷åëôïò, äìñ ëïôïòïçï óþéôáåôóñ          *
! *                              äéóðåòóéñ é óòåäîåå.                    *
! *        W  ( REAL*8    )  --  ÷åëôïò ÷åóï÷ ÷åìéþéîù X.                *
! *       IV  ( INTEGER*4, OPT )  --  ÷åëôïò, õëáúù÷áàýéê îá éóëìàþåîîùå *
! *                              éú ðïäóþåôï÷ üìåíåîôù.                  *
! *                              åóìé ðáòáíåôò  IV  ïðõýåî, éóðïìøúõàôóñ *
! *                              ÷óå üìåíåîôù.                           *
! *     IV_EL ( INTEGER*4, OPT ) --   úîáþåîéå, õëáúù÷áàýåå îá           *
! *                              éóðïìøúõåíùê ïôóþô.                    *
! *                                                                      *
! * ------------------------- ÷ùèïäîùå ðáòíåôòù: ----------------------- *
! *                                                                      *
! *       AV  ( REAL*8    )  --  óòåäîåå éú NZ üìåíåîôï÷ íáóóé÷á X .     *
! *        D  ( REAL*8    )  --  R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X .     *
! *       DW  ( REAL*8    )  --  ûëáìéòï÷áîîáñ îá óòåäîåå úîáþåîéå       *
! *                              ÷åóá W.R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X*
! *      DSW  ( REAL*8    )  --  W.R.M.S. äìñ NZ üìåíåîôï÷ íáóóé÷á X .   *
! *      CHI  ( REAL*8    )  --  èé-ë÷áäòáô îá óôåðåîø ó÷ïâïäù.          *
! *       NZ  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷, ëïôïòùå õþáóô÷ï÷áìé ÷  *
! *                              ðïäóþåôå.                               *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *      IUER=1  --  ðáòáíåôò  A  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=2  --  ðáòáíåôò  B  îåäïóôõðåî äìñ úáðéóé.                 *
! *      IUER=3  --  üìåíåîôï÷, ðï ëïôïòùí ÷ùþéóìñåôóñ äéóðåòóéñ,        *
! *                  íåîøûå 2 .                                          *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  21-JUN-94   WDISP_EL8   V1.6  (d) ðÅÔÒÏ× ì.à.  20-OCT-95  ###  *
! *                                                                      *
! ************************************************************************
        REAL*8      X(N), W(N), D, AV, DW, DSW, WW, CHI
        INTEGER     IV(N)
        CHARACTER   STR*10
        LOGICAL*4   IV_PRES
!
! .....................\\\
!                       \\\
!        LOGICAL PRESENT, PROBE_W, PROBE_R, IV_PRES
!        INTEGER*4 NUM$ARG, NA, N_ARG
!C
!        PARAMETER ( N_ARG=12 )  !  ëïìéþåóô÷ï æïòíáìøîùè ðáòáíåôòï÷
!C
!C ----- ðòï÷åòëá óïïô÷åôóô÷éñ ëïìéþåóô÷á æáëôéþåóëéêè é æïòíáìøîùè ðáòáíôòï÷
!C
!        NA=NUM$ARG()  !  Mù õúîáìé ëïìéþåóô÷ï æáëôéþåóëéè ðáòáíåôï÷
!        IF ( .NOT. ( NA.EQ.N_ARG .OR. ( .NOT. PRESENT ( IUER, N_ARG  )
!     $       .AND.   NA.EQ.(N_ARG-1) ) ) )    CALL VER$ARG ( N_ARG )
!C                        ///
!C ......................///  ...   ëïîåã ðòï÷åòëé  ...
!C
!        IF ( .NOT. PROBE_W ( 1, 8, AV ) ) THEN
!              CALL ERR_LOG ( 1, IUER, 'WDISP_EL8', 'ðáòáíåôò AV '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, D ) ) THEN
!              CALL ERR_LOG ( 2, IUER, 'WDISP_EL8', 'ðáòáíåôò D '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, DW ) ) THEN
!              CALL ERR_LOG ( 4, IUER, 'WDISP_EL8', 'ðáòáíåôò DW '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( .NOT. PROBE_W ( 1, 8, DW ) ) THEN
!              CALL ERR_LOG ( 4, IUER, 'WDISP_EL8', 'ðáòáíåôò DSW '//
!     $                                'îåäïóôõðåî äìñ úáðéóé' )
!              RETURN
!        END IF
!C
!        IF ( PROBE_R ( N, 4, IV ) ) THEN
!             IV_PRES=.TRUE.
!          ELSE
!             IV_PRES=.FALSE.
!        END IF
        IF ( LOC(IV) .EQ. 0 ) THEN
             IV_PRES = .FALSE.
          ELSE
             IV_PRES = .TRUE.
        END IF
!
! ----- îáþáìøîùå ïâîõìåîéñ
!
        AV=0.D0
        D =0.D0
        DW=0.D0
        WW=0.D0
        NZ=0
!
! ----- ÷ùþéóìåîéå óòåäîåçï
!
        DO 410 J1=1,N
           IF ( IV_PRES ) THEN
                IF ( IV(J1).EQ.0 ) GOTO 410
                IF ( IV(J1).NE.IV_EL ) GOTO 410
           END IF
           NZ=NZ+1             !  NZ  --  þéóìï õþáóô÷ï÷á÷ûéè
!                              !          ÷ ðïäóþåôáè üìåíåîôï÷
           AV=AV + X(J1)*W(J1)
           WW=WW + W(J1)
  410   CONTINUE
!
! ----- ïëáúáìïóø, þôï þéóìï üìåíåîôï÷, õþáóô÷õàýéè ÷ ðïäóþåôáè, óìéûëïí íáìï
!
        IF ( NZ.LT.2 ) THEN
             CALL CLRCH   ( STR )
             CALL INCH    ( NZ, STR )
             CALL ERR_LOG ( 3, IUER, 'WDISP_EL8', 'õþáóô÷õåô ôïìøëï '// &
     &                      STR(1:I_LEN(STR))//' üìåíåîôï÷' )
             RETURN
        END IF
!
        IF ( DABS(WW) .LT. 1.D-30 ) THEN
             WRITE ( 6, * ) ' WW=',WW, ' NZ=',NZ
             CALL ERR_LOG ( 4, IUER, 'WDISP_EL8', 'éóðïìøúï÷áîîùå '// &
     &                      '÷åóá ïëáúáìéóø îõìå÷ùíé' )
             RETURN
        END IF
        AV=AV/WW
        WW=0.
!
! ----- ÷ùþéóìåîéå äéóðåòóéé
!
        DO 420 J2=1,N
           IF ( IV_PRES ) THEN
                IF ( IV(J2).EQ.0 ) GOTO 420
                IF ( IV(J2).NE.IV_EL ) GOTO 420
           END IF
           D=D + ( X(J2)-AV )**2
           DW=DW + ( W(J2)* ( X(J2)-AV )) **2
           WW=WW +   W(J2)**2
  420   CONTINUE
!
! ----- ðòï÷åòëá: äïóôáôïþîïå ìé þéóìï üìåíåîôï÷ ?
!
        D   = DSQRT ( D/(NZ-1) )
        CHI = DW
        DSW = DSQRT ( DW/NZ    )
        DW  = DSQRT ( DW/WW     )
        CALL ERR_LOG ( 0, IUER )
!
        RETURN
        END  !#!  WDISP_EL8  #!#
!
! ------------------------------------------------------------------------
!
        SUBROUTINE REGR8 ( N, T, D, DR, SH, IUER )
! ************************************************************************
! *                                                                      *
! *     ðïäðòïçòáííá ÷ùþéóìåîéñ õçìï÷ïçï ëïüææéãéåîôá é ó÷ïâïäîïçï þìåîá *
! *     òåçòåóóéïîîïê ðòñíïê æõîëãéé D(T) .                              *
! *                                                                      *
! *     éóðïìøúõåôóñ íáóóé÷  IV, óïóôïñýéê éú  0 éìé 1 , ëïôïòùê         *
! *     ïôíåþáåô îåéóðïìøúï÷áîîùå ïôóþåôù. åóìé  IV(I)=1, ôï  I-ôùê      *
! *     ïôóþåô õþáóô÷õåô ÷ ÷ùþéóìåîéé ðáòáíåôòï÷ òåçòåóóéïîîïê ðòñíïê.   *
! *     åóìé  IV(J)=0, ôï J-ôùê üìåíåîô éóëìàþáåôóñ éú ðïäóþåôï÷.        *
! *                                                                      *
! *                                                                      *
! * ------------------------- ÷èïäîùå ðáòíåôòù: ------------------------ *
! *                                                                      *
! *        N  ( INTEGER*4 )  --  þéóìï üìåíåîôï÷ õ ÷åëôïòï÷  D  é  T .   *
! *        T  ( REAL*8    )  --  ÷åëôïò áòçõíåîôï÷ æõîëãéé D .           *
! *        D  ( REAL*8    )  --  ÷åëôïò úîáþåîéê æõîëãéé, äìñ ëïôïòïê    *
! *                              ÷ùþéóìñåôóñ äéóðåòóéñ é óòåäîåå.        *
! *                                                                      *
! * ------------------------- ÷ùèïäîùå ðáòíåôòù: ----------------------- *
! *                                                                      *
! *       DR  ( REAL*8    )  --  ó÷ïâïäîùê þìåî ôòåîäá.                  *
! *       SH  ( REAL*8    )  --  õçìï÷ïê ëïüææéãéåîô ôòåîäá.             *
! *                                                                      *
! * ___________________ íïäéæéãéòõåíùå ðáòáíåôòù: ______________________ *
! *                                                                      *
! *  IUER  ( INTEGER*4, OPT )  -- ðáòáíåôò ïûéâëé:                       *
! *             ÷èïäîïå úîáþåîéå  --  òåöéí ïâòáâïôëé ïûéâëé:            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             *
! *      IUER>-1 -- ÷ïú÷òáýåîéå ëïäá ïûéâëé.                             *
! *      IUER=-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ é ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ        *
! *                 ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.                       *
! *      IUER<-1 -- ÷ïú÷òáýåîéå ëïäá IUER=0 ÷ óìõþáå îïòíáìøîïçï         *
! *                 úá÷åòûåîéñ, ÷ù÷ïä äéáçîïóôéþåóëïçï óïïâýåîéñ é       *
! *                 úá÷åòûåîéñ ïâòáúá ÷ óìõþáå ÷ïúîéëîï÷åîéñ ïûéâëé.     *
! *      åóìé IUER ïðõýåî, ôï ÷èïäîïå úîáþåîéå ðòéîéíáåôóñ òá÷îùí -1     *
! *             ÷ùèïäîïå úîáþåîéå  --  ëïä ïûéâëé ( åóìé IUER            *
! *             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        *
! *             äïóôõðåî äìñ úáðéóé ):                                   *
! *      IUER=0  --  îïòíáìøîïå úá÷åòûåîéå.                              *
! *      IUER=1  --  ðáòáíåôò  DR  îåäïóôõðåî äìñ úáðéóé.                *
! *      IUER=2  --  ðáòáíåôò  SH  îåäïóôõðåî äìñ úáðéóé.                *
! *      IUER=3  --  üìåíåîôï÷, ðï ëïôïòùí óôòïéôóñ òåçòåóóéïîîáñ ðòñíáñ *
! *                  íåîøûå 2 .                                          *
! *      IUER=4  --  ÷îõôòåîîññ ïûéâëá: ïðòåäåìéôåìø ðï íïäõìà íåîøûå    *
! *                  1.D-30.                                             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  06-MAY-1991     REGR8  v1.6  (d) ðÅÔÒÏ× ì.à.  26-FEB-2008 ###  *
! *                                                                      *
! ************************************************************************
        IMPLICIT  NONE
        INTEGER*4 N, IUER
        REAL*8    T(N), D(N), DR, SH
        INTEGER*4 J1
        REAL*8    SD, ST, SDT, TT, STT, DET, DX, DY, SW
        CHARACTER STR*10
!
        SD  = 0.0D0
        SW  = 0.0D0
        ST  = 0.0D0
        SDT = 0.0D0
        STT = 0.0D0
!
! ----- ÷ùþéóìåîéå ëïüææéãéåîôï÷ îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        DO 410 J1=1,N
           SW  = SW + 1.0
           SD  = SD + D(J1)
           TT  = T(J1)-T(1)
           ST  = ST  + TT
           SDT = SDT + D(J1)*TT
           STT = STT + TT**2
  410   CONTINUE
!
! ----- ÷ùþéóìåîéå ïðòåäåìéôåìñ îïòíáìøîïê óéóôåíù
!
        DET = SW*STT - ST*ST
!
! ----- ÷ùþéóìåîéå íéîïòï÷ íáôòéãù îïòíáìøîïê óéóôåíù
!
        DX = SW*SDT - SD*ST
        DY = SD*STT - ST*SDT
!
! ----- ïðåòåäåìéôåìø óéóôåíù óìéûëïí íáì
!
        IF ( DABS(DET) .LT. 1.D-30 ) THEN
             CALL ERR_LOG ( 1014, IUER, 'REGR8', 'Zero determinant' )
             RETURN
        END IF
!
! ----- òåûåîéå îïòíáìøîïê óéóôåíù õòá÷îåîéê
!
        DR = DX/DET
        SH = DY/DET
        CALL ERR_LOG ( 0, IUER )
        RETURN
        END  SUBROUTINE  REGR8  !#!#
