!!CalcTab
!
!     Common space to keep all the Calc-related values.
!
!     Programmers:
!       Gregg Cooke        91.02.16  Creation.
!     Modifications:
!       Darin Miller       91.12.02  Added flags run_calc,setup, and
!                                    suppress for calc option.
!
!     Parameters:
!
!     MAXCALCTAB is the number of Calc flags in the flags table. It will
!     only ever need to be changed when the Calc program gets changed to
!     increase/decrease the number of flags.
!
      integer*2  MAXCALCTAB
      parameter (MAXCALCTAB = 62)
!
!     Specifications:
!
!     CALCHIST   -- History entry used for current CALC database.
!     HISFLG     -- Flag indicating if user has entered a CALC history.
!     CALC_TABLE -- Table of CALC flags.  The names are taken from
!                   the 'ccon.i' file in the CALC source directory.
!     CFLGS      -- An array of CALC flag values for the current
!                   CALC database.
!     DEFCFLGS   -- An array containing default Calc flag values
!     CALC       -- Indicates whether or not we will run Calc on the
!                   current database.
!     RUN_CALC   -- Flag to indicate that Calc is to be run directly
!                   from DBEDIT.
!     SETUP      -- Flag to indicate that the calcon file is to
!                   be generated by DBEDIT, with no Calc run.
!     SUPPRESS   -- Subflag of RUN_CALC and SETUP indicating the
!                   printout suppression.
!     CALCON_OPEN -- Flag indicating if the calcon file has been opened.
!     CALCON     -- Path and filename of the calcon file.
!
!     NOTE:  The values in 'calc_table' will only ever need to be
!            changed when the the Calc program changes because:
!               a)  a flag gets added or deleted from the list of
!                       flags used by Calc, or
!               b)  a flag's accepted name gets changed, or
!               c)  the order of the flags gets changed.
!            To ease the programming task, each flag begins with a 'K'
!            and is 5 characters long.  This can be changed with minimal
!            impact and effort, however.
!
      character calchist*80, calc_table(MAXCALCTAB)*5, CALCON*40
      integer*2 cflgs(MAXCALCTAB), defcflgs(MAXCALCTAB)
      logical*1 calc, run_calc, setup, suppress, calcon_open, hisflg
!
!     Common Space:
!
      common /calctab/ calc_table, calchist, cflgs, defcflgs, calc, &
     &                 run_calc, setup, suppress, calcon_open, CALCON, &
     &                 hisflg
!
