      BLOCK DATA UT1CMB
      IMPLICIT NONE                         !Added by IMP/jwr
!
!     Contains coefficients for zonal tides.
!     Taken from CALC module UT1CM.
!
! :89.05.01: JWR
!
! 8.1.3 REFERENCES -1) ASH, M.E., "DETERMINATION OF EARTH SATELLITE
!                    ORBITS", LINCOLN LABORATORY TECHNICAL REPORT
!                    1972-5, 04/19/72, P. 42
!
!                   2)  AMERICAN EPHEMERIS AND NAUTICAL ALMANAC
!
!                   3)  MELCHIOR,"THE EARTH TIDES"
!
!                   4)  WOOLARD, E.W., 1959, ASTRONOMICAL JOURNAL,
!                       V64, #1269, PP. 140-142
!
      COMMON/UT1CM/ X1(160),X2(160),X3(8)
!
      REAL*8 X1,X2,X3
!
!     TABLE OF MULTIPLES OF ARGUMENTS AND COEFFICIENTS
!
!                   MULTIPLE OF               DUT         DLOD   DOMEGA
!              L    L'   F    D  OMEGA   COEFF. OF SIN    COEFF. OF COS
      DATA X1/ 1.,  0.,  2.,  2.,  2.,      -0.02,        0.3,    -0.2, &
     &         2.,  0.,  2.,  0.,  1.,      -0.04,        0.4,    -0.3, &
     &         2.,  0.,  2.,  0.,  2.,      -0.10,        0.9,    -0.8, &
     &         0.,  0.,  2.,  2.,  1.,      -0.05,        0.4,    -0.4, &
     &         0.,  0.,  2.,  2.,  2.,      -0.12,        1.1,    -0.9, &
     &         1.,  0.,  2.,  0.,  0.,      -0.04,        0.3,    -0.2, &
     &         1.,  0.,  2.,  0.,  1.,      -0.41,        2.8,    -2.4, &
     &         1.,  0.,  2.,  0.,  2.,      -0.99,        6.8,    -5.8, &
     &         3.,  0.,  0.,  0.,  0.,      -0.02,        0.1,    -0.1, &
     &        -1.,  0.,  2.,  2.,  1.,      -0.08,        0.5,    -0.5, &
     &        -1.,  0.,  2.,  2.,  2.,      -0.20,        1.3,    -1.1, &
     &         1.,  0.,  0.,  2.,  0.,      -0.08,        0.5,    -0.4, &
     &         2.,  0.,  2., -2.,  2.,       0.02,       -0.1,     0.1, &
     &         0.,  1.,  2.,  0.,  2.,       0.03,       -0.1,     0.1, &
     &         0.,  0.,  2.,  0.,  0.,      -0.30,        1.4,    -1.2, &
     &         0.,  0.,  2.,  0.,  1.,      -3.21,       14.8,   -12.5, &
     &         0.,  0.,  2.,  0.,  2.,      -7.76,       35.7,   -30.1, &
     &         2.,  0.,  0.,  0., -1.,       0.02,       -0.1,     0.1, &
     &         2.,  0.,  0.,  0.,  0.,      -0.34,        1.5,    -1.3, &
     &         2.,  0.,  0.,  0.,  1.,       0.02,       -0.1,     0.1/
      DATA X2/ 0., -1.,  2.,  0.,  2.,      -0.02,        0.1,    -0.1, &
     &         0.,  0.,  0.,  2., -1.,       0.05,       -0.2,     0.2, &
     &         0.,  0.,  0.,  2.,  0.,      -0.73,        3.1,    -2.6, &
     &         0.,  0.,  0.,  2.,  1.,      -0.05,        0.2,    -0.2, &
     &         0., -1.,  0.,  2.,  0.,      -0.05,        0.2,    -0.2, &
     &         1.,  0.,  2., -2.,  1.,       0.05,       -0.1,     0.1, &
     &         1.,  0.,  2., -2.,  2.,       0.10,       -0.3,     0.2, &
     &         1.,  1.,  0.,  0.,  0.,       0.04,       -0.1,     0.1, &
     &        -1.,  0.,  2.,  0.,  0.,       0.05,       -0.1,     0.1, &
     &        -1.,  0.,  2.,  0.,  1.,       0.18,       -0.4,     0.3, &
     &        -1.,  0.,  2.,  0.,  2.,       0.44,       -1.0,     0.9, &
     &         1.,  0.,  0.,  0., -1.,       0.53,       -1.2,     1.0, &
     &         1.,  0.,  0.,  0.,  0.,      -8.26,       18.8,   -15.9, &
     &         1.,  0.,  0.,  0.,  1.,       0.54,       -1.2,     1.0, &
     &         0.,  0.,  0.,  1.,  0.,       0.05,       -0.1,     0.1, &
     &         1., -1.,  0.,  0.,  0.,      -0.06,        0.1,    -0.1, &
     &        -1.,  0.,  0.,  2., -1.,       0.12,       -0.2,     0.2, &
     &        -1.,  0.,  0.,  2.,  0.,      -1.82,        3.6,    -3.0, &
     &        -1.,  0.,  0.,  2.,  1.,       0.13,       -0.3,     0.2, &
     &         1.,  0., -2.,  2., -1.,       0.02,        0.0,     0.0/
      DATA X3/-1., -1.,  0.,  2.,  0.,      -0.09,        0.2,    -0.1/
      END
