!FTN77,Y,I,S
!$FILES(0,1)
!$CDS ON
!$EMA /PARFL/
      SUBROUTINE J2000(DAYIN,DAYOUT)
      IMPLICIT NONE
!
! 1.  J2000 PROGRAM SPECIFICATION
!
! 1.1 CONVERT FROM JULIAN DATE TO TIME IN JULIAN CENTURIES SINCE J2000 !
!
! 1.2 REFERENCES:
!
! 2.  J2000 INTERFACE
!
! 2.1 Parameter File
!
! 2.2 INPUT Variables:
!
      REAL*8 DAYIN
!
!  DAYIN - Julian date
!
! 2.3 OUTPUT Variables:
!
      REAL*8 DAYOUT
!
!  DAYOUT - Time in julian centuries since J2000
!
! 2.4 COMMON BLOCKS USED
!
! 2.5 SUBROUTINE INTERFACE
!
!       CALLING SUBROUTINES:
!       CALLED SUBROUTINES: None
!
! 3.  LOCAL VARIABLES
!
! 4.  HISTORY
!  WHO  WHEN    WHAT
!
! 5. J2000 PROGRAM STRUCTURE
!
      DAYOUT = (DAYIN - 2451545.0D0) / 36525.0D0
!
      RETURN
      END
