      PROGRAM    EOPS_TO_EOB_MAIN
! ************************************************************************
! *                                                                      *
! *   Program EOPS_TO_EOP converts input file in EOPS (or EOPI) format   *
! *   to the output file in EOB format.                                  *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 18-JUN-2002  EOPS_TO_EOP  v1.0 (d)  L. Petrov  18-JUN-2002 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'solve.i'
      INCLUDE   'param.i'
      INCLUDE   'getpar.i'
      INTEGER*4  MSES, NSES, NHEAD, IVRB, IUER
      CHARACTER  FINAM_EOPS*128, FINAM_EOB*128
      CHARACTER  HEAD_BUF(M_HEAD_EOB)*80, MASTER_DIR*128, ARG(3)*128
      CHARACTER  GET_CDATE*19
      PARAMETER  ( MSES = M_SES )
      TYPE ( EOP__STRU ) ::  EOP(MSES)
      INTEGER*4, EXTERNAL :: I_LEN, ILEN
!
      IF ( IARGC() .LT. 2 ) THEN
           WRITE ( 6, '(A)' ) 'Usage: eops_to_eop [-q] <input_eops_file> '// &
     &                        '<output_eob_file>'
           CALL EXIT ( 1 )
        ELSE
           CALL GETARG ( 1, ARG(1) )
           CALL GETARG ( 2, ARG(2) )
           CALL GETARG ( 3, ARG(3) )
      END IF
!
      IF ( ARG(1) .EQ. '-q' ) THEN
           IVRB = 0
           FINAM_EOPS = ARG(2)
           FINAM_EOB  = ARG(3)
         ELSE
           IVRB = 1
           FINAM_EOPS = ARG(1)
           FINAM_EOB  = ARG(2)
      END IF
!
! --- Get directory for master files
!
      CALL GETENV ( 'MASTER_DIR', MASTER_DIR )
      IF ( ILEN(MASTER_DIR) .LE. 0 ) THEN
           MASTER_DIR = MASTER_DIR_DEF
      END IF
      IF ( MASTER_DIR(I_LEN(MASTER_DIR):I_LEN(MASTER_DIR)) .NE. '/' ) THEN
           MASTER_DIR = MASTER_DIR(1:I_LEN(MASTER_DIR))//'/'
      END IF
!
      IUER  = -1
      CALL READ_EOPS ( FINAM_EOPS, MASTER_DIR, IVRB, MSES, NSES, EOP, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 2 )
!
! --- Create the header section
!
      NHEAD = 1
      HEAD_BUF(NHEAD) = '# Generated by eops_to_eob '
      NHEAD = NHEAD + 1
      HEAD_BUF(NHEAD) = '# Created at '//GET_CDATE()
      NHEAD = NHEAD + 1
      HEAD_BUF(NHEAD) = '# Input file: '//FINAM_EOPS(1:I_LEN(FINAM_EOPS))
      NHEAD = NHEAD + 1
      HEAD_BUF(NHEAD) = '# '
!
      IF ( IVRB .GE. 1 ) THEN
           WRITE ( 6, '(A,A,$)' ) '  EOPS_TO_EOB: Writing EOB file  ... ', &
     &                              CHAR(13)
           CALL FLUSH ( 6 )
      END IF
!
! --- Write output EOB file
!
      IUER = -1
      CALL WRITE_EOB_FILE ( FINAM_EOB, NHEAD, HEAD_BUF, NSES, EOP, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 3 )
      IF ( IVRB .GE. 1 ) THEN
           WRITE ( 6, '(A)' ) '  EOPS_TO_EOB: Output file: '// &
     &                        FINAM_EOB(1:I_LEN(FINAM_EOB))
      END IF
!
      END  !#!   EOPS_TO_EOB_MAIN  #!#
