/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class GCCMain
extends Main {
    private HashSet commandLineCompilationUnits = new HashSet();
    private boolean syntaxOnly;
    private String zipDestination;
    private ZipOutputStream zipStream;
    private String zipDependencyDestination;
    private ZipOutputStream zipDependencyStream;

    public GCCMain(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished) {
        super(outWriter, errWriter, systemExitWhenFinished);
        this.logger.setEmacs();
    }

    public GCCMain(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Map customDefaultOptions) {
        super(outWriter, errWriter, systemExitWhenFinished, customDefaultOptions);
        this.logger.setEmacs();
    }

    private void fail(Exception t) {
        t.printStackTrace();
        this.logger.logException(t);
        System.exit(1);
    }

    public CompilationUnit[] getCompilationUnits() {
        CompilationUnit[] units = super.getCompilationUnits();
        int i = 0;
        while (i < units.length) {
            this.commandLineCompilationUnits.add(units[i]);
            ++i;
        }
        return units;
    }

    private String combine(char[] one, char[] two) {
        StringBuffer b = new StringBuffer();
        b.append(one);
        b.append(two);
        return b.toString();
    }

    private ZipOutputStream getZipOutput() throws IOException {
        if (this.zipDestination != null && this.zipStream == null) {
            OutputStream os = "-".equals(this.zipDestination) ? System.out : new FileOutputStream(this.zipDestination);
            this.zipStream = new ZipOutputStream(new BufferedOutputStream(os));
            this.zipStream.setMethod(0);
            ZipEntry entry = new ZipEntry(".dummy");
            byte[] contents = new byte[]{};
            CRC32 crc = new CRC32();
            crc.update(contents);
            entry.setSize(contents.length);
            entry.setCrc(crc.getValue());
            this.zipStream.putNextEntry(entry);
            this.zipStream.write(contents);
            this.zipStream.closeEntry();
        }
        return this.zipStream;
    }

    private ZipOutputStream getDependencyOutput() throws IOException {
        if (this.zipDependencyDestination != null && this.zipDependencyStream == null) {
            FileOutputStream os = new FileOutputStream(this.zipDependencyDestination);
            this.zipDependencyStream = new ZipOutputStream(new BufferedOutputStream(os));
            this.zipDependencyStream.setMethod(0);
            ZipEntry entry = new ZipEntry(".dummy");
            byte[] contents = new byte[]{};
            CRC32 crc = new CRC32();
            crc.update(contents);
            entry.setSize(contents.length);
            entry.setCrc(crc.getValue());
            this.zipDependencyStream.putNextEntry(entry);
            this.zipDependencyStream.write(contents);
            this.zipDependencyStream.closeEntry();
        }
        return this.zipDependencyStream;
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (this.syntaxOnly) {
            return;
        }
        if (this.zipDestination == null) {
            super.outputClassFiles(unitResult);
            return;
        }
        if (unitResult == null || unitResult.hasErrors()) {
            return;
        }
        boolean gcjCompile = this.commandLineCompilationUnits.contains(unitResult.getCompilationUnit());
        if (this.zipDependencyDestination == null && !gcjCompile) {
            return;
        }
        try {
            ZipOutputStream dest = gcjCompile ? this.getZipOutput() : this.getDependencyOutput();
            ClassFile[] classFiles = unitResult.getClassFiles();
            int i = 0;
            while (i < classFiles.length) {
                ClassFile classFile = classFiles[i];
                String filename = this.combine(classFile.fileName(), SuffixConstants.SUFFIX_class);
                if (this.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), filename}));
                }
                ZipEntry entry = new ZipEntry(filename);
                byte[] contents = classFile.getBytes();
                CRC32 crc = new CRC32();
                crc.update(contents);
                entry.setSize(contents.length);
                entry.setCrc(crc.getValue());
                dest.putNextEntry(entry);
                dest.write(contents);
                dest.closeEntry();
                ++i;
            }
        }
        catch (IOException err) {
            this.fail(err);
        }
    }

    private String getArgument(String option) {
        int index = option.indexOf(61);
        return option.substring(index + 1);
    }

    private void addPath(ArrayList result, String currentClasspathName) {
        String customEncoding = null;
        AccessRule[] accessRules = new AccessRule[0];
        AccessRuleSet accessRuleSet = new AccessRuleSet(accessRules, 0, currentClasspathName);
        FileSystem.Classpath currentClasspath = FileSystem.getClasspath(currentClasspathName, customEncoding, accessRuleSet);
        if (currentClasspath != null) {
            result.add(currentClasspath);
        }
    }

    private void parsePath(ArrayList result, String path) {
        StringTokenizer iter = new StringTokenizer(path, File.pathSeparator);
        while (iter.hasMoreTokens()) {
            this.addPath(result, iter.nextToken());
        }
    }

    protected void handleWarningToken(String token, boolean isEnabling) {
        if ("deprecated".equals(token)) {
            token = "deprecation";
        } else if (!("static-access".equals(token) || "dep-ann".equals(token) || "over-ann".equals(token))) {
            if ("extraneous-semicolon".equals(token)) {
                token = "semicolon";
            } else {
                StringBuffer newToken = new StringBuffer(token.length());
                StringTokenizer t = new StringTokenizer(token, "-");
                boolean first = true;
                while (t.hasMoreTokens()) {
                    String next = t.nextToken();
                    if (first) {
                        newToken.append(next);
                        first = false;
                        continue;
                    }
                    newToken.append(Character.toUpperCase(next.charAt(0)));
                    newToken.append(next.substring(1));
                }
                token = newToken.toString();
            }
        }
        super.handleWarningToken(token, isEnabling);
    }

    private void turnWarningsToErrors() {
        Object[] entries = this.options.entrySet().toArray();
        int i = 0;
        int max = entries.length;
        while (i < max) {
            Map.Entry entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "error");
            }
            ++i;
        }
    }

    private void setDebugLevel(int level) {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", level > 1 ? "generate" : "do not generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", level > 0 ? "generate" : "do not generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private void readFileList(String file, ArrayList result) {
        try {
            String line;
            BufferedReader b = new BufferedReader(new FileReader(file));
            while ((line = b.readLine()) != null) {
                if (!line.endsWith(".java")) continue;
                result.add(line);
            }
            b.close();
        }
        catch (IOException err) {
            this.fail(err);
        }
    }

    private void readAllFileListFiles(ArrayList fileList, ArrayList result) {
        Iterator it = fileList.iterator();
        while (it.hasNext()) {
            this.readFileList((String)it.next(), result);
        }
    }

    private void handleWall(boolean enable) {
        this.handleWarningToken("constructor-name", enable);
        this.handleWarningToken("pkg-default-method", enable);
        this.handleWarningToken("masked-catch-block", enable);
        this.handleWarningToken("all-deprecation", enable);
        this.handleWarningToken("unused-local", enable);
        this.handleWarningToken("unused-label", enable);
        this.handleWarningToken("static-receiver", enable);
        this.handleWarningToken("indirect-static", enable);
        this.handleWarningToken("no-effect-assign", enable);
        this.handleWarningToken("char-concat", enable);
        this.handleWarningToken("useless-type-check", enable);
        this.handleWarningToken("final-bound", enable);
        this.handleWarningToken("assert-identifier", enable);
        this.handleWarningToken("enum-identifier", enable);
        this.handleWarningToken("finally", enable);
        this.handleWarningToken("varargs-cast", enable);
        this.handleWarningToken("unused", enable);
        this.handleWarningToken("forbidden", enable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String[] argv) {
        if (argv == null || argv.length == 0) {
            System.exit(1);
        }
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> otherFiles = new ArrayList<String>();
        String classpath = null;
        boolean haveFileList = false;
        boolean inhibitAllWarnings = false;
        boolean treatWarningsAsErrors = false;
        int i = 0;
        while (i < argv.length) {
            String currentArg = argv[i];
            if (currentArg.startsWith("-fencoding=")) {
                String encoding = this.getArgument(currentArg);
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", encoding));
                }
                this.options.put("org.eclipse.jdt.core.encoding", encoding);
            } else if (currentArg.startsWith("-foutput-class-dir=")) {
                String arg = this.getArgument(currentArg);
                if (this.destinationPath != null) {
                    StringBuffer errorMessage = new StringBuffer();
                    errorMessage.append("-d");
                    errorMessage.append(' ');
                    errorMessage.append(arg);
                    throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", errorMessage.toString()));
                }
                this.setDestinationPath(arg);
            } else if (currentArg.startsWith("-fbootclasspath=")) {
                classpath = this.getArgument(currentArg);
            } else if (currentArg.equals("-fzip-target")) {
                if (++i >= argv.length) {
                    throw new IllegalArgumentException(this.bind("gcc.zipArg"));
                }
                this.zipDestination = argv[i];
            } else if (currentArg.equals("-fzip-dependency")) {
                if (++i >= argv.length) {
                    throw new IllegalArgumentException(this.bind("gcc.zipDepArg"));
                }
                this.zipDependencyDestination = argv[i];
            } else if (currentArg.startsWith("-g")) {
                if (currentArg.equals("-g0")) {
                    this.setDebugLevel(0);
                } else if (currentArg.equals("-g2") || currentArg.equals("-g3") || currentArg.equals("-g")) {
                    this.setDebugLevel(2);
                } else {
                    this.setDebugLevel(1);
                }
            } else if (currentArg.equals("-Werror")) {
                treatWarningsAsErrors = true;
            } else if (currentArg.equals("-Wno-error")) {
                treatWarningsAsErrors = false;
            } else if (currentArg.equals("-Wall")) {
                this.handleWall(true);
            } else if (currentArg.equals("-Wno-all")) {
                this.handleWall(false);
            } else if (currentArg.startsWith("-Wno-")) {
                this.handleWarningToken(currentArg.substring(5), false);
            } else if (currentArg.startsWith("-W")) {
                this.handleWarningToken(currentArg.substring(2), true);
            } else if (currentArg.equals("-w")) {
                inhibitAllWarnings = true;
            } else if (!currentArg.startsWith("-O")) {
                if (currentArg.equals("-v")) {
                    this.verbose = true;
                } else if (currentArg.equals("-fsyntax-only")) {
                    this.syntaxOnly = true;
                } else if (currentArg.startsWith("-fsource=")) {
                    if ((currentArg = this.getArgument(currentArg)).equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (currentArg.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else {
                        if (!currentArg.equals("1.6") && !currentArg.equals("6") && !currentArg.equals("6.0")) throw new IllegalArgumentException(this.bind("configure.source", currentArg));
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    }
                } else if (currentArg.startsWith("-ftarget=")) {
                    if ((currentArg = this.getArgument(currentArg)).equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (currentArg.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (currentArg.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (currentArg.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (currentArg.equals("1.6") || currentArg.equals("6") || currentArg.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else {
                        if (!currentArg.equals("jsr14")) throw new IllegalArgumentException(this.bind("configure.targetJDK", currentArg));
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    }
                } else if (currentArg.equals("-ffilelist-file")) {
                    haveFileList = true;
                } else if (currentArg.endsWith(".java")) {
                    files.add(currentArg);
                } else if (currentArg.charAt(0) != '-') {
                    otherFiles.add(currentArg);
                }
            }
            ++i;
        }
        if (haveFileList) {
            this.readAllFileListFiles(otherFiles, files);
        }
        this.filenames = files.toArray(new String[0]);
        this.encodings = new String[this.filenames.length];
        this.destinationPaths = new String[this.filenames.length];
        i = 0;
        while (i < this.filenames.length) {
            this.destinationPaths[i] = this.destinationPath;
            ++i;
        }
        ArrayList result = new ArrayList();
        if (classpath == null) {
            throw new IllegalArgumentException(this.bind("gcc.noClasspath"));
        }
        this.parsePath(result, classpath);
        try {
            this.getZipOutput();
            this.getDependencyOutput();
        }
        catch (IOException err) {
            this.fail(err);
        }
        if (inhibitAllWarnings) {
            this.disableAll(0);
        }
        if (treatWarningsAsErrors) {
            this.turnWarningsToErrors();
        }
        this.checkedClasspaths = new FileSystem.Classpath[result.size()];
        result.toArray(this.checkedClasspaths);
        this.logger.logCommandLineArguments(argv);
        this.logger.logOptions(this.options);
        this.logger.logClasspath(this.checkedClasspaths);
        this.maxRepetition = 1;
    }

    public boolean compile(String[] argv) {
        boolean result = super.compile(argv);
        try {
            if (this.zipStream != null) {
                this.zipStream.finish();
                this.zipStream.close();
            }
            if (this.zipDependencyStream != null) {
                this.zipDependencyStream.finish();
                this.zipDependencyStream.close();
            }
        }
        catch (IOException err) {
            this.fail(err);
        }
        return result;
    }

    public static void main(String[] argv) {
        boolean result = new GCCMain(new PrintWriter(System.out), new PrintWriter(System.err), false).compile(argv);
        System.exit(result ? 0 : 1);
    }
}

