!
! --- This file was generated automatically by program hw95_out v 3.0
! --- written by Leonid Petrov (pet@leo.gsfc.nasa.gov)
! --- It contains phases, frequencies, accelerations amplitudes and 
! --- orders of the tidal waves of the 2 degree 
! --- with amplitudes greater than  2.000D-04 m^2/sec^2
! --- Harmonic expansion HW95 was used.
! --- (T. Hartmann and H-G. Wenzel "The HW95 tidal potential catalogue",
! ---  Geophysical Research Letters", Vol. 22(24), p. 3553-3556, 1995),
! ---  Amplitudes were renormalized!
!
      INTEGER*4   NW, N2
      PARAMETER ( NW = 517 )
      REAL*8      PHAS2_TID(NW), FREQ2_TID(NW), ACCL2_TID(NW), AMPL2_TID(NW)
      INTEGER*4   M2_TID(NW)
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2), N2=1,10) &
   & / &
   & 2.169437D0, 1.405189027044D-04,  1.24D-23, 6.1945543, 2, & !  9337 M2     1
   & 3.324267D0, 7.292115855138D-05,  1.06D-24, 3.6120854, 1, & !* 5958 K1     2
   & 3.141593D0, 0.000000000000D+00,  0.00D+00, 3.0824701, 0, & !*    1 S0     3
   & 6.283185D0, 1.454441043329D-04, -7.35D-40, 2.8817487, 2, & !*10068 S2     4
   & 5.128356D0, 6.759774415297D-05,  1.13D-23, 2.5694227, 1, & !  4681 O1     5
   & 2.958919D0, 7.252294578148D-05, -1.06D-24, 1.1953411, 1, & !* 5653 P1     6
   & 6.097067D0, 1.378796996516D-04, -1.86D-23, 1.1860472, 2, & !  8976 N2     7
   & 3.506941D0, 1.458423171028D-04,  2.13D-24, 0.7830281, 2, & !*10303 K2     8
   & 4.479096D0, 5.323414398410D-06, -1.03D-23, 0.6526323, 0, & !  1512 MF     9
   & 2.772800D0, 6.495854110023D-05, -1.97D-23, 0.4919537, 1  & !  4263 Q1    10
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=11,20) &
   & / &
   & 1.141827D0, 7.293185551375D-05, -6.21D-24, 0.4901280, 1, & !  5978       11
   & 1.027610D0, 6.758704719061D-05,  1.86D-23, 0.4847250, 1, & !  4664       12
   & 5.497148D0, 2.639203052741D-06,  3.10D-23, 0.3447428, 0, & !   946 MM    13
   & 0.365348D0, 3.982127698995D-07,  2.13D-24, 0.3036334, 0, & !*  358 SSA   14
   & 4.100746D0, 1.069696236521D-08, -7.28D-24, 0.2735919, 0, & !    23       15
   & 2.296657D0, 5.334111360775D-06, -1.76D-23, 0.2705913, 0, & !  1529       16
   & 1.324501D0, 1.458530140651D-04, -5.15D-24, 0.2333273, 2, & ! 10318       17
   & 1.210284D0, 1.405082057420D-04,  1.97D-23, 0.2311303, 2, & !  9323       18
   & 0.411245D0, 1.382329041286D-04,  5.58D-23, 0.2252981, 2, & !  9082 NI2   19
   & 5.679822D0, 7.556036160412D-05,  3.21D-23, 0.2020427, 1  & !  6738 J1    20
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=21,30) &
   & / &
   & 0.968711D0, 7.028195549864D-05, -3.00D-23, 0.2019701, 1, & !  5110 M1    21
   & 4.338875D0, 1.355937010758D-04,  2.48D-23, 0.1894263, 2, & !  8720 MI2   22
   & 1.383401D0, 1.431581057571D-04,  4.34D-23, 0.1751075, 2, & !  9622 L2    23
   & 0.043125D0, 1.452450074576D-04,  5.39D-25, 0.1684489, 2, & !* 9947 T2    24
   & 3.741511D0, 1.352404965989D-04, -4.97D-23, 0.1569500, 2, & !  8628 2N2   25
   & 0.551466D0, 7.962617451151D-06,  2.08D-23, 0.1249583, 0, & !  1989 MTM   26
   & 4.661770D0, 7.824457294979D-05, -9.22D-24, 0.1105150, 1, & !  7106 OO1   27
   & 3.370164D0, 6.531174557720D-05,  5.48D-23, 0.0933773, 1, & !  4388 RO1   28
   & 4.955240D0, 6.494784413786D-05, -1.24D-23, 0.0927772, 1, & !  4251       29
   & 1.014608D0, 6.267254252446D-05,  2.37D-23, 0.0785042, 1  & !  3979 SIG   30
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=31,40) &
   & / &
   & 4.342319D0, 7.023694720571D-05,  4.24D-23, 0.0726403, 1, & !  5059       31
   & 2.365113D0, 7.291046158901D-05,  8.34D-24, 0.0715340, 1, & !  5946       32
   & 2.479331D0, 7.825526991216D-05, -1.65D-23, 0.0708131, 1, & !  7112       33
   & 3.002044D0, 7.232384890619D-05, -5.24D-25, 0.0697853, 1, & !  5525 PI1   34
   & 4.899785D0, 2.285998575769D-06, -4.34D-23, 0.0659215, 0, & !   799 MSM   35
   & 0.417245D0, 6.231933804749D-05, -5.07D-23, 0.0651007, 1, & !  3876 2Q1   36
   & 0.972155D0, 4.925201628510D-06, -1.24D-23, 0.0571888, 0, & !  1325 MSF   37
   & 4.652212D0, 7.973314413516D-06,  1.35D-23, 0.0517898, 0, & !  2001       38
   & 0.548022D0, 7.331937132128D-05,  3.19D-24, 0.0513321, 1, & !  6244 FI1   39
   & 3.098467D0, 1.990968752920D-07, -5.39D-25, 0.0488841, 0  & !   194 SA    40
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=41,50) &
   & / &
   & 1.983319D0, 1.329544980231D-04, -6.23D-24, 0.0457704, 2, & !  8418 EPS   41
   & 0.786037D0, 1.428049012801D-04, -3.10D-23, 0.0456784, 2, & !  9568 LMB   42
   & 5.137914D0, 1.378690026892D-04, -1.14D-23, 0.0442790, 2, & !  8965       43
   & 5.862496D0, 1.484815201555D-04,  3.32D-23, 0.0438013, 2, & ! 10826 ETA   44
   & 1.151385D0, 1.432031140500D-04, -2.89D-23, 0.0437703, 2, & !  9661       45
   & 5.069457D0, 7.029265246100D-05, -3.73D-23, 0.0405337, 1, & !  5119       46
   & 3.497383D0, 7.557105856649D-05,  2.48D-23, 0.0400477, 1, & !  6749       47
   & 1.566075D0, 7.063515997561D-05,  4.45D-23, 0.0386478, 1, & !  5210 CHI   48
   & 5.082459D0, 7.520715712715D-05, -4.24D-23, 0.0386363, 1, & !  6636 THE   49
   & 1.154829D0, 7.784636017989D-05, -1.13D-23, 0.0335085, 1  & !  6992 SO1   50
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=51,60) &
   & / &
   & 5.493704D0, 6.799595692287D-05,  1.35D-23, 0.0334911, 1, & !  4840 TAU   51
   & 3.281141D0, 7.312025542667D-05,  5.24D-25, 0.0286560, 1, & !  6117 PSI   52
   & 3.367392D0, 7.272206167609D-05,  1.60D-24, 0.0286446, 1, & !  5816 S1    53
   & 1.569519D0, 5.278406105483D-06,  6.21D-23, 0.0282545, 0, & !  1456       54
   & 5.425248D0, 1.458637110275D-04, -1.24D-23, 0.0253677, 2, & ! 10327       55
   & 0.114218D0, 5.344808323140D-06, -2.48D-23, 0.0253068, 0, & !  1542       56
   & 3.098467D0, 1.456432012082D-04, -5.39D-25, 0.0240549, 2, & ! 10196 R2    57
   & 6.237288D0, 7.609412974179D-06, -5.37D-23, 0.0237287, 0, & !  1862 MST   58
   & 4.537995D0, 2.628506090376D-06,  3.83D-23, 0.0226301, 0, & !   932       59
   & 0.173117D0, 2.649900015107D-06,  2.38D-23, 0.0223722, 0  & !   962       60
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=61,70) &
   & / &
   & 5.354155D0, 1.403198058291D-04,  1.29D-23, 0.0212856, 2, & !  9266 ALF   61
   & 0.734140D0, 8.088377600253D-05,  2.18D-23, 0.0211636, 1, & !  7365 V1    62
   & 2.309658D0, 1.024861602692D-05, -2.27D-23, 0.0199581, 0, & !  2323 MSQ   63
   & 5.252131D0, 1.432138110124D-04, -3.62D-23, 0.0193176, 2, & !  9664       64
   & 3.680057D0, 1.484922171179D-04,  2.59D-23, 0.0190737, 2, & ! 10833       65
   & 4.942238D0, 6.003333947172D-05, -7.29D-24, 0.0189670, 1, & !  3650       66
   & 3.744956D0, 6.988374272874D-05, -3.21D-23, 0.0189478, 1, & !  4984       67
   & 2.126312D0, 1.407179995796D-04,  1.19D-23, 0.0187520, 2, & !  9417 BET   68
   & 4.713666D0, 1.401656982274D-04, -6.21D-23, 0.0185964, 2, & !  9241 GAM   69
   & 5.265133D0, 2.684211345668D-06, -4.13D-23, 0.0184491, 0  & !  1017       70
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=71,80) &
   & / &
   & 0.322223D0, 5.973096451915D-07,  1.59D-24, 0.0177267, 0, & !   478 STA   71
   & 1.385956D0, 1.326012935461D-04, -8.07D-23, 0.0176580, 2, & !  8348 3N2   72
   & 5.552603D0, 6.530104861484D-05,  6.21D-23, 0.0176126, 1, & !  4380       73
   & 1.752193D0, 7.819956465686D-05,  6.31D-23, 0.0165620, 1, & !  7077       74
   & 4.896340D0, 6.764275244590D-05, -6.10D-23, 0.0165534, 1, & !  4740       75
   & 2.907022D0, 1.060182050389D-05,  5.18D-23, 0.0165314, 0, & !  2424       76
   & 0.068457D0, 6.757635022824D-05,  2.59D-23, 0.0148496, 1, & !  4656       77
   & 0.296892D0, 7.826596687452D-05, -2.38D-23, 0.0148360, 1, & !  7117       78
   & 3.197047D0, 6.266184556210D-05,  3.10D-23, 0.0148085, 1, & !  3974       79
   & 4.834886D0, 8.089447296490D-05,  1.45D-23, 0.0135513, 1  & !  7373       80
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=81,90) &
   & / &
   & 1.999765D0, 7.251224881912D-05,  6.21D-24, 0.0135476, 1, & !  5635       81
   & 0.241573D0, 7.022625024335D-05,  4.97D-23, 0.0134434, 1, & !  5052       82
   & 4.295750D0, 1.357927979511D-04,  2.43D-23, 0.0127754, 2, & !  8769       83
   & 2.599684D0, 6.230864108512D-05, -4.35D-23, 0.0122775, 1, & !  3871       84
   & 4.844444D0, 1.511657315012D-04, -8.15D-24, 0.0114602, 2, & ! 11052       85
   & 6.053942D0, 1.380787965269D-04, -1.92D-23, 0.0110683, 2, & !  9048       86
   & 2.100981D0, 7.294255247611D-05, -1.35D-23, 0.0105317, 1, & !  5997       87
   & 0.368120D0, 1.384320010039D-04,  5.53D-23, 0.0103936, 2, & !  9135       88
   & 2.547787D0, 1.458316201404D-04,  9.40D-24, 0.0100223, 2, & ! 10295       89
   & 6.057386D0, 7.272204265677D-05, -1.60D-24, 0.0099731, 1  & !  5805       90
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=91,100) &
   & / &
   & 2.998600D0, 1.376806027763D-04, -1.81D-23, 0.0099698, 2, & !  8898       91
   & 2.662005D0, 1.511764284635D-04, -1.54D-23, 0.0099375, 2, & ! 11056       92
   & 4.054849D0, 7.620109936544D-06, -6.10D-23, 0.0098356, 0, & !  1871       93
   & 3.327711D0, 7.564404681252D-06,  1.86D-23, 0.0090643, 0, & !  1827       94
   & 2.580683D0, 1.333077025001D-04,  6.83D-23, 0.0088320, 2, & !  8478       95
   & 2.029889D0, 6.739864727768D-05,  1.19D-23, 0.0088310, 1, & !  4597       96
   & 5.666821D0, 7.064585693798D-05,  3.72D-23, 0.0084796, 1, & !  5215       97
   & 5.735277D0, 1.382222071662D-04,  6.31D-23, 0.0083973, 2, & !  9077       98
   & 5.265133D0, 1.481283156785D-04, -4.13D-23, 0.0083743, 2, & ! 10756 KSI   99
   & 1.748749D0, 1.435563185270D-04,  4.56D-23, 0.0083730, 2  & !  9718      100
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=101,110) &
   & / &
   & 0.127219D0, 1.025931298929D-05, -3.00D-23, 0.0082703, 0, & !  2327      101
   & 5.085231D0, 6.779684102826D-05,  1.08D-23, 0.0077772, 1, & !  4778      102
   & 1.389400D0, 6.724453967600D-05, -6.31D-23, 0.0077191, 1, & !  4573      103
   & 2.900020D0, 7.521785408951D-05, -4.97D-23, 0.0076637, 1, & !  6642      104
   & 5.910949D0, 1.303152949704D-04, -3.73D-23, 0.0075666, 2, & !  8196      105
   & 1.324501D0, 4.089097322647D-07, -5.15D-24, 0.0075634, 0, & !   371      106
   & 3.082694D0, 2.694908308034D-06, -4.86D-23, 0.0075051, 0, & !  1026      107
   & 4.344874D0, 5.968013499475D-05, -8.18D-23, 0.0073218, 1, & !  3572      108
   & 0.169672D0, 6.800665388524D-05,  6.19D-24, 0.0073000, 1, & !  4845      109
   & 1.337503D0, 1.507675187313D-04, -1.03D-23, 0.0072643, 2  & ! 10982      110
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=111,120) &
   & / &
   & 5.676378D0, 1.409171154743D-04,  1.45D-23, 0.0072626, 2, & !  9465 DLT  111
   & 3.379721D0, 1.355830041135D-04,  3.21D-23, 0.0070639, 2, & !  8715      112
   & 0.724583D0, 1.061251746626D-05,  4.45D-23, 0.0068539, 0, & !  2430      113
   & 0.086250D0, 1.450459105823D-04,  1.08D-24, 0.0068315, 2, & !  9874 2T2  114
   & 5.255575D0, 7.785705714226D-05, -1.86D-23, 0.0065620, 1, & !  6996      115
   & 2.182439D0, 1.454334073705D-04,  7.28D-24, 0.0064531, 2, & ! 10048      116
   & 0.424247D0, 1.431474087947D-04,  5.07D-23, 0.0064067, 2, & !  9615      117
   & 0.112564D0, 1.380563018901D-04,  1.86D-23, 0.0063975, 2, & !  9034      118
   & 3.463816D0, 1.460414139781D-04,  1.59D-24, 0.0062129, 2, & ! 10405      119
   & 3.550066D0, 1.456432202275D-04,  2.66D-24, 0.0061975, 2  & ! 10204      120
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=121,130) &
   & / &
   & 4.720669D0, 7.554966464176D-05,  3.94D-23, 0.0059130, 1, & !  6729      121
   & 2.782358D0, 1.352297996365D-04, -4.24D-23, 0.0058548, 2, & !  8623      122
   & 0.009557D0, 7.027125853627D-05, -2.27D-23, 0.0058515, 1, & !  5100      123
   & 4.936238D0, 1.359469055528D-04,  9.93D-23, 0.0057768, 2, & !  8795      124
   & 0.730696D0, 1.462405298727D-04,  4.25D-24, 0.0053235, 2, & ! 10484      125
   & 3.138148D0, 6.535675387013D-05, -1.76D-23, 0.0053080, 1, & !  4417      126
   & 3.510385D0, 8.048556323263D-05,  1.97D-23, 0.0053063, 1, & !  7275      127
   & 0.971483D0, 6.287163939975D-05,  2.32D-23, 0.0053009, 1, & !  4033      128
   & 2.469773D0, 7.984011375882D-06,  6.21D-24, 0.0048514, 0, & !  2011      129
   & 4.665214D0, 1.288781907966D-05,  8.35D-24, 0.0048222, 0  & !  2665      130
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=131,140) &
   & / &
   & 5.862496D0, 3.037415822641D-06,  3.32D-23, 0.0048132, 0, & !  1118      131
   & 3.940631D0, 2.275301613404D-06, -3.62D-23, 0.0047342, 0, & !   792      132
   & 0.225127D0, 1.306684994473D-04,  3.72D-23, 0.0046934, 2, & !  8237      133
   & 2.729675D0, 6.515763797552D-05, -2.02D-23, 0.0045907, 1, & !  4342      134
   & 4.410776D0, 1.378132974340D-04,  6.83D-23, 0.0045426, 2, & !  8927      135
   & 3.327039D0, 6.551084245249D-05,  5.42D-23, 0.0043127, 1, & !  4445      136
   & 5.927395D0, 6.987304576637D-05, -2.48D-23, 0.0042918, 1, & !  4982      137
   & 5.858938D0, 2.296695538134D-06, -5.07D-23, 0.0042798, 0, & !   808      138
   & 5.957518D0, 6.475944422494D-05, -1.92D-23, 0.0041366, 1, & !  4178      139
   & 3.154594D0, 4.914504666145D-06, -5.13D-24, 0.0040789, 0  & !  1319      140
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=141,150) &
   & / &
   & 5.849495D0, 1.435670154894D-04,  3.83D-23, 0.0040422, 2, & !  9721      141
   & 0.136777D0, 8.053057152556D-05, -5.27D-23, 0.0040199, 1, & !  7296      142
   & 2.358111D0, 1.375264951746D-04, -9.31D-23, 0.0038167, 2, & !  8874      143
   & 1.015280D0, 4.726104753218D-06, -1.19D-23, 0.0037645, 0, & !  1257      144
   & 5.539601D0, 6.038654394869D-05,  6.72D-23, 0.0036664, 1, & !  3716      145
   & 1.931309D0, 4.935898590875D-06, -1.97D-23, 0.0036648, 0, & !  1333      146
   & 3.082694D0, 1.481390126409D-04, -4.86D-23, 0.0036507, 2, & ! 10759      147
   & 1.934867D0, 1.511207232082D-04,  6.42D-23, 0.0035889, 2, & ! 11032      148
   & 5.079015D0, 1.405639109973D-04, -6.00D-23, 0.0035874, 2, & !  9383      149
   & 0.841492D0, 6.002264250935D-05, -1.58D-26, 0.0035785, 1  & !  3644      150
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=151,160) &
   & / &
   & 5.908394D0, 1.408721071813D-04,  8.69D-23, 0.0035302, 2, & !  9445      151
   & 0.352346D0, 1.409278124366D-04,  7.26D-24, 0.0034827, 2, & !  9467      152
   & 1.940194D0, 1.331535948984D-04, -6.77D-24, 0.0034664, 2, & !  8458      153
   & 2.492332D0, 8.316977457830D-05, -2.16D-23, 0.0033795, 1, & !  7542      154
   & 5.852939D0, 7.821026161923D-05,  5.59D-23, 0.0032801, 1, & !  7082      155
   & 0.251131D0, 1.404975087796D-04,  2.70D-23, 0.0032195, 2, & !  9313      156
   & 0.479566D0, 1.511871254259D-04, -2.27D-23, 0.0032155, 2, & ! 11059      157
   & 2.586682D0, 5.739413641898D-05, -3.83D-23, 0.0031423, 1, & !  3416      158
   & 5.438249D0, 1.507782156936D-04, -1.76D-23, 0.0031262, 2, & ! 10984      159
   & 5.447807D0, 7.560536989705D-05, -4.03D-23, 0.0031239, 1  & !  6783      160
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=161,170) &
   & / &
   & 3.738956D0, 3.532044769725D-07,  7.45D-23, 0.0030576, 0, & !   309      161
   & 0.504897D0, 7.351846819657D-05,  2.65D-24, 0.0030020, 1, & !  6337      162
   & 5.762628D0, 1.405189217237D-04,  1.56D-23, 0.0029578, 2, & !  9341      163
   & 3.996086D0, 6.493714717550D-05, -5.15D-24, 0.0028523, 1, & !  4243      164
   & 2.652447D0, 8.090516992726D-05,  7.27D-24, 0.0028438, 1, & !  7376      165
   & 3.045169D0, 7.212475203090D-05,  1.44D-26, 0.0028326, 1, & !  5435      166
   & 4.942910D0, 2.086901700477D-06, -4.29D-23, 0.0028186, 0, & !   723      167
   & 3.089696D0, 8.352297905527D-05,  5.29D-23, 0.0028003, 1, & !  7601      168
   & 3.069692D0, 1.432245079747D-04, -4.35D-23, 0.0027318, 2, & !  9668      169
   & 2.713901D0, 6.765344940826D-05, -6.83D-23, 0.0026970, 1  & !  4744      170
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=171,180) &
   & / &
   & 6.168968D0, 1.400992960097D-04,  2.48D-23, 0.0026888, 2, & !  9222      171
   & 5.059900D0, 2.139392473041D-08, -1.46D-23, 0.0026706, 0, & !    44      172
   & 1.240407D0, 1.353946042005D-04,  2.53D-23, 0.0026667, 2, & !  8665      173
   & 3.071482D0, 6.513514333872D-05,  1.75D-23, 0.0026524, 1, & !  4329      174
   & 4.237523D0, 8.054126848792D-05, -5.99D-23, 0.0025743, 1, & !  7299      175
   & 3.550066D0, 1.991158946075D-07,  2.66D-24, 0.0025308, 0, & !   204      176
   & 3.698386D0, 1.354395934742D-04, -5.02D-23, 0.0024268, 2, & !  8680      177
   & 1.611972D0, 6.302574700143D-05,  9.82D-23, 0.0023968, 1, & !  4061      178
   & 3.680057D0, 3.048112785006D-06,  2.59D-23, 0.0023960, 0, & !  1122      179
   & 3.925075D0, 7.917609158224D-06,  9.31D-23, 0.0022697, 0  & !  1955      180
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=181,190) &
   & / &
   & 1.294378D0, 5.522511273702D-06, -1.08D-23, 0.0022440, 0, & !  1605      181
   & 5.450579D0, 6.819505379816D-05,  1.29D-23, 0.0022088, 1, & !  4885      182
   & 1.197954D0, 7.764726330460D-05, -1.08D-23, 0.0022057, 1, & !  6950      183
   & 3.595963D0, 1.380338072533D-04,  5.64D-23, 0.0022004, 2, & !  9020      184
   & 0.916814D0, 1.538049345539D-04,  2.29D-23, 0.0021949, 2, & ! 11210      185
   & 0.829162D0, 1.426058044048D-04, -3.05D-23, 0.0021878, 2, & !  9544      186
   & 0.309893D0, 8.318047154067D-05, -2.89D-23, 0.0021645, 1, & !  7545      187
   & 0.643044D0, 1.350413997236D-04, -4.91D-23, 0.0021183, 2, & !  8565      188
   & 5.540274D0, 2.440106177449D-06,  3.16D-23, 0.0021181, 0, & !   850      189
   & 1.497618D0, 1.485029140802D-04,  1.86D-23, 0.0020705, 2  & ! 10839      190
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=191,200) &
   & / &
   & 6.110069D0, 1.427942043178D-04, -2.38D-23, 0.0020449, 2, & !  9565      191
   & 0.900254D0, 2.705605270399D-06, -5.59D-23, 0.0020157, 0, & !  1030      192
   & 2.482775D0, 1.289851604203D-05,  1.08D-24, 0.0019979, 0, & !  2669      193
   & 1.507176D0, 7.333006828364D-05, -4.09D-24, 0.0019904, 1, & !  6252      194
   & 4.522221D0, 5.124317523118D-06, -9.74D-24, 0.0019754, 0, & !  1405      195
   & 3.265368D0, 7.561606685941D-05, -4.75D-23, 0.0019635, 1, & !  6788      196
   & 1.934867D0, 5.676618875382D-06,  6.42D-23, 0.0019606, 0, & !  1633      197
   & 3.184046D0, 5.774734089595D-05,  3.62D-23, 0.0019495, 1, & !  3460      198
   & 5.017560D0, 1.538156315163D-04,  1.56D-23, 0.0019015, 2, & ! 11213      199
   & 1.086509D0, 6.489213888257D-05,  6.72D-23, 0.0018837, 1  & !  4207      200
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=201,210) &
   & / &
   & 5.262578D0, 1.324102355663D-05,  8.28D-23, 0.0018602, 0, & !  2740      201
   & 2.528672D0, 5.289103067848D-06,  5.48D-23, 0.0018332, 0, & !  1462      202
   & 5.198467D0, 2.462600814255D-06, -6.20D-24, 0.0018222, 0, & !   867      203
   & 5.313585D0, 1.299620904934D-04, -1.12D-22, 0.0018090, 2, & !  8152      204
   & 0.907257D0, 8.353367601764D-05,  4.56D-23, 0.0017936, 1, & !  7603      205
   & 2.726903D0, 7.256795407441D-05, -7.34D-23, 0.0017915, 1, & !  5711      206
   & 3.921630D0, 7.327436302835D-05,  7.55D-23, 0.0017915, 1, & !  6203      207
   & 2.312431D0, 2.838299928033D-06,  3.05D-23, 0.0017666, 0, & !  1064      208
   & 2.730347D0, 7.211200204279D-06, -5.58D-23, 0.0017582, 0, & !  1733      209
   & 1.024166D0, 1.329438010607D-04,  1.05D-24, 0.0017089, 2  & !  8413      210
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=211,220) &
   & / &
   & 4.040193D0, 1.354170988374D-04, -1.24D-23, 0.0016769, 2, & !  8673      211
   & 5.425248D0, 4.196066946299D-07, -1.24D-23, 0.0016673, 0, & !   379      212
   & 4.097302D0, 6.536745083249D-05, -2.48D-23, 0.0016613, 1, & !  4420      213
   & 1.522949D0, 7.083425685090D-05,  4.40D-23, 0.0016514, 1, & !  5260      214
   & 5.125584D0, 7.500806025186D-05, -4.18D-23, 0.0016509, 1, & !  6582      215
   & 5.317029D0, 6.460533662326D-05, -9.42D-23, 0.0015830, 1, & !  4151      216
   & 6.035613D0, 1.511314201706D-04,  5.69D-23, 0.0015626, 2, & ! 11034      217
   & 0.610365D0, 5.267709143118D-06,  6.94D-23, 0.0015038, 0, & !  1447      218
   & 2.584127D0, 6.795094862994D-05,  8.58D-23, 0.0014646, 1, & !  4813      219
   & 4.899113D0, 6.023243634701D-05, -7.83D-24, 0.0014378, 1  & !  3691      220
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=221,230) &
   & / &
   & 0.244128D0, 5.966943803238D-05, -7.45D-23, 0.0013813, 1, & !  3569      221
   & 3.571839D0, 6.723384271363D-05, -5.59D-23, 0.0013517, 1, & !  4571      222
   & 2.352784D0, 1.004951915163D-05, -2.21D-23, 0.0013465, 0, & !  2260      223
   & 2.540785D0, 6.500354939316D-05, -9.21D-23, 0.0013319, 1, & !  4297      224
   & 4.107749D0, 8.083876770960D-05,  9.42D-23, 0.0013301, 1, & !  7344      225
   & 2.896575D0, 1.405746079596D-04, -6.72D-23, 0.0012842, 2, & !  9386      226
   & 4.152757D0, 1.280292963946D-04,  6.18D-24, 0.0012487, 2, & !  8087      227
   & 0.925586D0, 7.048105237393D-05, -3.05D-23, 0.0012413, 1, & !  5179      228
   & 5.722948D0, 7.536126472883D-05,  3.26D-23, 0.0012411, 1, & !  6674      229
   & 4.123305D0, 7.519646016478D-05, -3.51D-23, 0.0012377, 1  & !  6632      230
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=231,240) &
   & / &
   & 5.565605D0, 7.021555328098D-05,  5.69D-23, 0.0011815, 1, & !  5050      231
   & 1.082928D0, 7.562676382178D-05, -5.48D-23, 0.0011811, 1, & !  6791      232
   & 1.311500D0, 1.409385093990D-04, -1.95D-26, 0.0011779, 2, & !  9470      233
   & 3.055342D0, 3.981937505839D-07, -1.08D-24, 0.0011773, 0, & !   354      234
   & 0.594592D0, 7.763520575859D-06,  2.13D-23, 0.0011660, 0, & !  1911      235
   & 3.320822D0, 1.382779124215D-04, -1.65D-23, 0.0011514, 2, & !  9110      236
   & 3.693059D0, 1.534067217840D-04,  2.08D-23, 0.0011512, 2, & ! 11150      237
   & 4.355321D0, 7.515145187186D-05,  3.73D-23, 0.0011481, 1, & !  6607      238
   & 6.028610D0, 7.030334942337D-05, -4.45D-23, 0.0011329, 1, & !  5125      239
   & 0.606921D0, 7.062446301325D-05,  5.18D-23, 0.0011188, 1  & !  5203      240
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=241,250) &
   & / &
   & 2.844701D0, 6.717813745834D-05,  2.38D-23, 0.0011155, 1, & !  4550      241
   & 4.199326D0, 6.247344564917D-05,  2.43D-23, 0.0011069, 1, & !  3914      242
   & 1.084719D0, 1.429815035186D-04,  6.20D-24, 0.0011027, 2, & !  9590      243
   & 6.280413D0, 7.410316098887D-06, -5.32D-23, 0.0010954, 0, & !  1788      244
   & 0.374792D0, 4.571997151538D-06, -8.69D-23, 0.0010747, 0, & !  1227      245
   & 5.683267D0, 1.020360773399D-05,  4.97D-23, 0.0010733, 0, & !  2298      246
   & 3.337268D0, 7.783566321753D-05, -4.07D-24, 0.0010688, 1, & !  6988      247
   & 1.267393D0, 7.045855773713D-05,  7.27D-24, 0.0010679, 1, & !  5164      248
   & 5.381141D0, 7.538375936564D-05, -5.14D-24, 0.0010678, 1, & !  6686      249
   & 4.212328D0, 6.738795031531D-05,  1.92D-23, 0.0010547, 1  & !  4592      250
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=251,260) &
   & / &
   & 3.593191D0, 1.454441233522D-04,  3.20D-24, 0.0010525, 2, & ! 10074      251
   & 3.649934D0, 8.161714326443D-06,  2.02D-23, 0.0010511, 0, & !  2084      252
   & 1.327946D0, 8.049626019500D-05,  1.24D-23, 0.0010371, 1, & !  7280      253
   & 2.495105D0, 7.575945847941D-05,  3.16D-23, 0.0010354, 1, & !  6814      254
   & 4.153429D0, 7.008285862335D-05, -2.94D-23, 0.0010351, 1, & !  5028      255
   & 3.555393D0, 1.276760919176D-04, -6.83D-23, 0.0010328, 2, & !  8061      256
   & 3.735512D0, 6.570995834710D-05,  5.69D-23, 0.0010295, 1, & !  4486      257
   & 2.913021D0, 8.013235875566D-05, -5.48D-23, 0.0010186, 1, & !  7224      258
   & 0.374119D0, 6.251843492278D-05, -5.13D-23, 0.0010060, 1, & !  3934      259
   & 3.813412D0, 1.374600929570D-04, -6.21D-24, 0.0010028, 2  & !  8860      260
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=261,270) &
   & / &
   & 2.537558D0, 1.335067993754D-04,  6.77D-23, 0.0009991, 2, & !  8499      261
   & 3.153922D0, 6.286094243739D-05,  3.05D-23, 0.0009796, 1, & !  4031      262
   & 1.040612D0, 7.250155185675D-05,  1.35D-23, 0.0009767, 1, & !  5623      263
   & 5.607922D0, 7.334076524601D-05, -1.14D-23, 0.0009765, 1, & !  6259      264
   & 4.397638D0, 7.827666383689D-05, -3.10D-23, 0.0009671, 1, & !  7123      265
   & 3.297281D0, 1.378572050148D-04,  1.91D-23, 0.0009670, 2, & !  8951      266
   & 4.534551D0, 6.798525996050D-05,  2.07D-23, 0.0009587, 1, & !  4834      267
   & 2.055220D0, 1.351740943812D-04,  3.72D-23, 0.0009434, 2, & !  8589      268
   & 5.012348D0, 1.403423004659D-04, -2.48D-23, 0.0009367, 2, & !  9277      269
   & 4.067851D0, 1.253461460269D-05, -6.61D-23, 0.0009313, 0  & !  2597      270
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=271,280) &
   & / &
   & 5.510150D0, 7.553707718886D-06,  2.59D-23, 0.0009281, 0, & !  1823      271
   & 0.271696D0, 6.511264870191D-05,  5.53D-23, 0.0009128, 1, & !  4313      272
   & 3.788081D0, 6.968464585345D-05, -3.16D-23, 0.0009078, 1, & !  4953      273
   & 1.872410D0, 7.630806898909D-06, -6.83D-23, 0.0008889, 0, & !  1878      274
   & 5.085903D0, 9.850403257020D-06, -2.48D-23, 0.0008792, 0, & !  2215      275
   & 3.601962D0, 6.212024117220D-05, -5.02D-23, 0.0008788, 1, & !  3816      276
   & 5.168037D0, 1.327554011478D-04, -5.69D-24, 0.0008684, 2, & !  8376      277
   & 4.456537D0, 7.558175552885D-05,  1.76D-23, 0.0008609, 1, & !  6757      278
   & 4.903343D0, 1.484708231931D-04,  4.04D-23, 0.0008282, 2, & ! 10821      279
   & 0.192231D0, 1.431924170877D-04, -2.16D-23, 0.0008196, 2  & !  9656      280
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=281,290) &
   & / &
   & 4.847888D0, 8.580897763104D-05,  9.42D-24, 0.0008165, 1, & !  7719      281
   & 6.045170D0, 7.595857437402D-05,  3.42D-23, 0.0008150, 1, & !  6853      282
   & 0.984485D0, 6.778614406590D-05,  1.81D-23, 0.0008067, 1, & !  4774      283
   & 0.737585D0, 1.552702213240D-05,  3.94D-23, 0.0007979, 0, & !  2913      284
   & 4.279976D0, 1.382886093839D-04, -2.38D-23, 0.0007913, 2, & !  9113      285
   & 5.509478D0, 6.550014549013D-05,  6.15D-23, 0.0007898, 1, & !  4442      286
   & 2.438362D0, 6.759776317229D-05,  1.45D-23, 0.0007764, 1, & !  4686      287
   & 3.080139D0, 1.325172051900D-05,  7.56D-23, 0.0007714, 0, & !  2743      288
   & 4.227965D0, 1.027000995165D-05, -3.72D-23, 0.0007711, 0, & !  2333      289
   & 6.035613D0, 5.687315837747D-06,  5.69D-23, 0.0007549, 0  & !  1635      290
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=291,300) &
   & / &
   & 4.756792D0, 1.399666013521D-04, -6.15D-23, 0.0007527, 2, & !  9212      291
   & 1.989318D0, 5.704093194200D-05, -1.13D-22, 0.0007505, 1, & !  3376      292
   & 2.872668D0, 7.292113953206D-05, -2.14D-24, 0.0007397, 1, & !* 5954      293
   & 4.912114D0, 6.514694101316D-05, -1.30D-23, 0.0007393, 1, & !  4337      294
   & 4.326545D0, 7.273275863845D-05, -5.67D-24, 0.0007382, 1, & !  5821      295
   & 0.279098D0, 7.964065204835D-07,  1.05D-24, 0.0007193, 0, & !   553      296
   & 1.426526D0, 1.429590088818D-04,  4.40D-23, 0.0007037, 2, & !  9583      297
   & 3.238016D0, 7.331935230196D-05, -1.44D-26, 0.0006981, 1, & !  6240      298
   & 0.715926D0, 6.249594028597D-05, -1.35D-23, 0.0006956, 1, & !  3925      299
   & 1.438855D0, 6.037584698633D-05,  7.45D-23, 0.0006913, 1  & !  3712      300
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=301,310) &
   & / &
   & 0.252785D0, 7.786015212665D-06, -1.65D-23, 0.0006739, 0, & !  1923      301
   & 2.597129D0, 7.286545329609D-05,  8.07D-23, 0.0006645, 1, & !  5895      302
   & 1.856772D0, 6.474874726257D-05, -1.19D-23, 0.0006632, 1, & !  4174      303
   & 6.240060D0, 1.990968752920D-07, -5.39D-25, 0.0006619, 0, & !   192      304
   & 3.370836D0, 7.365307805960D-06,  1.92D-23, 0.0006603, 0, & !  1763      305
   & 0.426802D0, 1.325905965838D-04, -7.34D-23, 0.0006599, 2, & !  8345      306
   & 3.754513D0, 1.401550012650D-04, -5.48D-23, 0.0006445, 2, & !  9237      307
   & 4.825329D0, 1.062321442862D-05,  3.72D-23, 0.0006421, 0, & !  2435      308
   & 1.031054D0, 2.230293320477D-06,  3.62D-23, 0.0006404, 0, & !   756      309
   & 0.782593D0, 6.271755081739D-05, -4.86D-23, 0.0006338, 1  & !  4001      310
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=311,320) &
   & / &
   & 5.865941D0, 8.312476628537D-05,  5.07D-23, 0.0006336, 1, & !  7529      311
   & 4.070623D0, 5.124298503802D-06, -1.29D-23, 0.0006313, 0, & !  1401      312
   & 0.557466D0, 7.749315570292D-05, -8.58D-23, 0.0006291, 1, & !  6931      313
   & 5.867824D0, 1.305143918456D-04, -3.78D-23, 0.0006264, 2, & !  8221      314
   & 3.410517D0, 7.252296480080D-05,  2.14D-24, 0.0006256, 1, & !  5659      315
   & 6.091068D0, 6.834916139984D-05,  8.80D-23, 0.0006252, 1, & !  4902      316
   & 3.862731D0, 7.596927133639D-05,  2.70D-23, 0.0006237, 1, & !  6856      317
   & 4.178760D0, 1.378583057269D-04, -4.08D-24, 0.0006179, 2, & !  8955      318
   & 2.835121D0, 1.538263284786D-04,  8.33D-24, 0.0006165, 2, & ! 11215      319
   & 0.182002D0, 1.308675963226D-04,  3.67D-23, 0.0006157, 2  & !  8258      320
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=321,330) &
   & / &
   & 4.252625D0, 1.359918948264D-04,  2.37D-23, 0.0006116, 2, & !  8809      321
   & 1.712295D0, 9.895411549947D-06, -9.72D-23, 0.0006093, 0, & !  2234      322
   & 3.407073D0, 1.378797186709D-04, -1.54D-23, 0.0006055, 2, & !  8978      323
   & 4.769121D0, 5.738343945661D-05, -3.11D-23, 0.0005923, 1, & !  3414      324
   & 5.395124D0, 5.533208236067D-06, -1.81D-23, 0.0005888, 0, & !  1608      325
   & 0.002555D0, 1.348872921219D-04, -1.24D-22, 0.0005853, 2, & !  8548      326
   & 4.286864D0, 7.575101643617D-06,  1.14D-23, 0.0005791, 0, & !  1833      327
   & 2.042890D0, 7.231315194382D-05,  6.75D-24, 0.0005586, 1, & !  5511      328
   & 0.170344D0, 1.006021611399D-05, -2.94D-23, 0.0005469, 0, & !  2264      329
   & 4.537995D0, 1.480726104232D-04,  3.83D-23, 0.0005466, 2  & ! 10736      330
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=331,340) &
   & / &
   & 1.098702D0, 7.313095238904D-05, -6.75D-24, 0.0005461, 1, & !  6129      331
   & 1.073371D0, 5.355505285505D-06, -3.21D-23, 0.0005416, 0, & !  1551      332
   & 2.665449D0, 8.581967459341D-05,  2.14D-24, 0.0005229, 1, & !  7721      333
   & 4.593450D0, 6.529035165247D-05,  6.93D-23, 0.0005220, 1, & !  4374      334
   & 2.055084D0, 8.055196545029D-05, -6.72D-23, 0.0005210, 1, & !  7301      335
   & 4.893113D0, 1.361460024281D-04,  9.88D-23, 0.0005186, 2, & !  8819      336
   & 0.828490D0, 5.510813784321D-05,  5.11D-24, 0.0005180, 1, & !  3312      337
   & 5.268577D0, 8.277156180840D-05, -2.37D-23, 0.0005152, 1, & !  7478      338
   & 1.379956D0, 6.307075529436D-05,  2.59D-23, 0.0005146, 1, & !  4080      339
   & 1.739191D0, 7.328505999072D-05,  6.83D-23, 0.0005077, 1  & !  6207      340
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=341,350) &
   & / &
   & 4.395002D0, 1.403091088667D-04,  2.02D-23, 0.0005029, 2, & !  9261      341
   & 0.140221D0, 1.517381765543D-05, -3.51D-23, 0.0004950, 0, & !  2866      342
   & 5.253921D0, 6.512444637635D-05,  2.48D-23, 0.0004942, 1, & !  4320      343
   & 1.510620D0, 1.534174187464D-04,  1.35D-23, 0.0004937, 2, & ! 11152      344
   & 4.270418D0, 6.801735084760D-05, -1.08D-24, 0.0004889, 1, & !  4849      345
   & 1.380628D0, 1.505684218560D-04, -9.74D-24, 0.0004796, 2, & ! 10960      346
   & 3.937187D0, 6.763205548353D-05, -5.37D-23, 0.0004791, 1, & !  4732      347
   & 2.237758D0, 8.029019668809D-06, -6.61D-23, 0.0004773, 0, & !  2050      348
   & 3.667055D0, 1.435777124517D-04,  3.10D-23, 0.0004753, 2, & !  9726      349
   & 5.633253D0, 1.411162123495D-04,  1.40D-23, 0.0004730, 2  & !  9493      350
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=351,360) &
   & / &
   & 3.336596D0, 1.357821009888D-04,  3.15D-23, 0.0004673, 2, & !  8766      351
   & 4.580312D0, 1.511978223883D-04, -3.00D-23, 0.0004608, 2, & ! 11062      352
   & 4.043637D0, 7.006034496723D-05,  5.14D-24, 0.0004572, 1, & !  5013      353
   & 2.237894D0, 6.265114859973D-05,  3.83D-23, 0.0004532, 1, & !  3967      354
   & 3.794411D0, 6.301505003907D-05,  1.06D-22, 0.0004521, 1, & !  4057      355
   & 4.410639D0, 8.319116850303D-05, -3.62D-23, 0.0004521, 1, & !  7547      356
   & 1.405960D0, 7.289976462665D-05,  1.56D-23, 0.0004505, 1, & !  5931      357
   & 2.339782D0, 5.135014485483D-06, -1.70D-23, 0.0004502, 0, & !  1410      358
   & 4.637557D0, 1.357703033143D-04,  6.21D-23, 0.0004411, 2, & !  8760      359
   & 4.097974D0, 7.421013061252D-06, -6.05D-23, 0.0004408, 0  & !  1792      360
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=361,370) &
   & / &
   & 1.715067D0, 2.485095451061D-06, -4.40D-23, 0.0004331, 0, & !   885      361
   & 2.355556D0, 1.480833073856D-04,  3.10D-23, 0.0004321, 2, & ! 10739      362
   & 1.497618D0, 3.058809747371D-06,  1.86D-23, 0.0004303, 0, & !  1125      363
   & 0.231126D0, 5.475493336624D-05, -6.94D-23, 0.0004285, 1, & !  3283      364
   & 5.298701D0, 7.765796026696D-05, -1.81D-23, 0.0004250, 1, & !  6952      365
   & 3.732740D0, 7.312027444599D-05,  3.73D-24, 0.0004202, 1, & !  6125      366
   & 0.319451D0, 1.534517300769D-04, -5.16D-23, 0.0004170, 2, & ! 11161      367
   & 0.489145D0, 6.453893440560D-05, -7.27D-24, 0.0004161, 1, & !  4135      368
   & 5.496476D0, 6.058564082398D-05,  6.67D-23, 0.0004139, 1, & !  3742      369
   & 4.695338D0, 7.774217538224D-06,  1.40D-23, 0.0004127, 0  & !  1915      370
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=371,380) &
   & / &
   & 5.280907D0, 1.883999129268D-07,  6.74D-24, 0.0004120, 0, & !   182      371
   & 0.075852D0, 1.405181580092D-04,  4.09D-23, 0.0004115, 2, & !  9335      372
   & 1.104896D0, 1.405196473995D-04, -1.61D-23, 0.0004091, 2, & !  9343      373
   & 6.256200D0, 6.493604646342D-05,  1.81D-23, 0.0004065, 1, & !  4238      374
   & 4.290423D0, 8.315821928124D-06,  9.52D-23, 0.0004019, 0, & !  2113      375
   & 0.900254D0, 1.481497096033D-04, -5.59D-23, 0.0003949, 2, & ! 10762      376
   & 0.793039D0, 7.818886769450D-05,  7.04D-23, 0.0003928, 1, & !  7073      377
   & 5.014139D0, 6.225293582983D-05,  3.62D-23, 0.0003914, 1, & !  3838      378
   & 3.095023D0, 6.555585074542D-05, -1.81D-23, 0.0003898, 1, & !  4464      379
   & 1.688082D0, 6.742114191448D-05, -2.59D-23, 0.0003886, 1  & !  4609      380
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=381,390) &
   & / &
   & 0.225799D0, 7.272206167609D-05,  1.60D-24, 0.0003884, 1, & !  5814      381
   & 2.909577D0, 1.454891126258D-04, -7.24D-23, 0.0003883, 2, & ! 10125      382
   & 4.104304D0, 1.461955215797D-04,  7.66D-23, 0.0003883, 2, & ! 10459      383
   & 3.553510D0, 8.028646635734D-05,  2.02D-23, 0.0003869, 1, & !  7237      384
   & 0.139549D0, 7.312025542667D-05,  5.24D-25, 0.0003864, 1, & !  6115      385
   & 1.885411D0, 1.254531156505D-05, -7.34D-23, 0.0003860, 0, & !  2600      386
   & 1.167159D0, 1.407073026173D-04,  1.91D-23, 0.0003858, 2, & !  9412      387
   & 1.477052D0, 7.844366982508D-05, -9.76D-24, 0.0003800, 1, & !  7152      388
   & 5.623695D0, 7.084495381327D-05,  3.67D-23, 0.0003788, 1, & !  5263      389
   & 1.342830D0, 1.328003904214D-04, -8.12D-23, 0.0003781, 2  & !  8386      390
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=391,400) &
   & / &
   & 1.640530D0, 6.229794412276D-05, -3.62D-23, 0.0003776, 1, & !  3865      391
   & 5.008003D0, 8.354437298000D-05,  3.83D-23, 0.0003765, 1, & !  7605      392
   & 5.692152D0, 1.384213040415D-04,  6.26D-23, 0.0003764, 2, & !  9132      393
   & 2.395237D0, 6.779686004758D-05,  1.40D-23, 0.0003722, 1, & !  4782      394
   & 0.324995D0, 1.386310978792D-04,  5.48D-23, 0.0003720, 2, & !  9166      395
   & 0.740140D0, 4.970209921437D-06, -8.48D-23, 0.0003720, 0, & !  1360      396
   & 0.727138D0, 5.570525529221D-08, -7.96D-23, 0.0003709, 0, & !    90      397
   & 1.467495D0, 8.172411288808D-06,  1.29D-23, 0.0003703, 0, & !  2087      398
   & 4.253297D0, 7.804545705518D-05, -1.19D-23, 0.0003701, 1, & !  7044      399
   & 5.366485D0, 5.773664393358D-05,  4.34D-23, 0.0003674, 1  & !  3458      400
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=401,410) &
   & / &
   & 4.708339D0, 1.268872220437D-05,  8.89D-24, 0.0003652, 0, & !  2621      401
   & 4.420197D0, 1.534624270393D-04, -5.89D-23, 0.0003612, 2, & ! 11164      402
   & 1.843770D0, 5.983424259643D-05, -6.75D-24, 0.0003603, 1, & !  3598      403
   & 0.544464D0, 7.257865103677D-05, -8.07D-23, 0.0003592, 1, & !  5723      404
   & 5.308258D0, 1.479292188032D-04, -4.08D-23, 0.0003591, 2, & ! 10716      405
   & 1.705623D0, 1.437554154023D-04,  4.50D-23, 0.0003579, 2, & !  9749      406
   & 3.268948D0, 6.488144192021D-05,  7.45D-23, 0.0003551, 1, & !  4205      407
   & 5.094788D0, 1.380680995645D-04, -1.19D-23, 0.0003529, 2, & !  9043      408
   & 4.509219D0, 1.456539171898D-04, -4.61D-24, 0.0003517, 2, & ! 10208      409
   & 2.675007D0, 1.560909331297D-04, -2.06D-23, 0.0003505, 2  & ! 11298      410
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=411,420) &
   & / &
   & 1.612644D0, 5.079309230191D-06,  6.26D-23, 0.0003489, 0, & !  1376      411
   & 3.255810D0, 1.507889126560D-04, -2.48D-23, 0.0003379, 2, & ! 10987      412
   & 4.704895D0, 7.804547607450D-05, -8.68D-24, 0.0003344, 1, & !  7048      413
   & 2.117541D0, 7.859777742676D-05,  6.53D-23, 0.0003320, 1, & !  7165      414
   & 4.838331D0, 1.553771909477D-05,  3.21D-23, 0.0003308, 0, & !  2916      415
   & 2.339110D0, 6.308145225672D-05,  1.86D-23, 0.0003305, 1, & !  4082      416
   & 4.570673D0, 1.324021966708D-04, -8.02D-23, 0.0003301, 2, & !  8307      417
   & 1.621529D0, 1.332970055377D-04,  7.55D-23, 0.0003300, 2, & !  8473      418
   & 5.630481D0, 1.485265284484D-04, -3.92D-23, 0.0003239, 2, & ! 10856      419
   & 2.943145D0, 7.501875721422D-05, -4.91D-23, 0.0003172, 1  & !  6585      420
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=421,430) &
   & / &
   & 2.779803D0, 1.457866118475D-04,  8.18D-23, 0.0003165, 2, & ! 10260      421
   & 2.039446D0, 1.376699058140D-04, -1.08D-23, 0.0003164, 2, & !  8892      422
   & 5.445252D0, 8.616218210801D-05,  8.39D-23, 0.0003151, 1, & !  7760      423
   & 5.026332D0, 7.049174933630D-05, -3.78D-23, 0.0003148, 1, & !  5182      424
   & 1.432525D0, 6.704544280071D-05, -6.26D-23, 0.0003123, 1, & !  4541      425
   & 1.281376D0, 6.080066075567D-07, -5.69D-24, 0.0003118, 0, & !   484      426
   & 0.687571D0, 1.464396267480D-04,  3.71D-24, 0.0003113, 2, & ! 10544      427
   & 4.694665D0, 6.572065530947D-05,  4.96D-23, 0.0003066, 1, & !  4488      428
   & 4.057621D0, 2.097938376572D-07, -7.81D-24, 0.0003048, 0, & !   210      429
   & 0.492567D0, 1.561016300920D-04, -2.78D-23, 0.0003037, 2  & ! 11301      430
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=431,440) &
   & / &
   & 1.270837D0, 5.101803866996D-06,  2.48D-23, 0.0003029, 0, & !  1386      431
   & 4.385444D0, 7.003785033042D-05,  4.29D-23, 0.0002920, 1, & !  5006      432
   & 3.272370D0, 1.564441376067D-04,  5.39D-23, 0.0002904, 2, & ! 11329      433
   & 4.290423D0, 1.537599262610D-04,  9.52D-23, 0.0002883, 2, & ! 11199      434
   & 3.578841D0, 2.617809128011D-06,  4.56D-23, 0.0002872, 0, & !   922      435
   & 4.667986D0, 5.477502980775D-06,  6.15D-23, 0.0002868, 0, & !  1581      436
   & 2.723459D0, 1.379247079445D-04, -9.10D-23, 0.0002866, 2, & !  9007      437
   & 0.822491D0, 1.310217039243D-04,  1.12D-22, 0.0002851, 2, & !  8266      438
   & 4.698110D0, 3.639014393377D-07,  6.72D-23, 0.0002835, 0, & !   315      439
   & 0.479566D0, 5.743021093040D-06, -2.27D-23, 0.0002832, 0  & !  1653      440
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=441,450) &
   & / &
   & 4.951795D0, 1.303045980080D-04, -3.00D-23, 0.0002831, 2, & !  8192      441
   & 1.689850D0, 1.462512268350D-04, -3.02D-24, 0.0002827, 2, & ! 10489      442
   & 5.408126D0, 1.044771290221D-05, -2.32D-23, 0.0002812, 0, & !  2389      443
   & 1.684637D0, 1.327778957846D-04, -4.35D-23, 0.0002791, 2, & !  8382      444
   & 2.013749D0, 2.661697689547D-06, -6.74D-24, 0.0002766, 0, & !   982      445
   & 2.656793D0, 1.377030974131D-04, -5.59D-23, 0.0002766, 2, & !  8908      446
   & 4.353531D0, 7.796712175030D-06, -2.38D-23, 0.0002761, 0, & !  1932      447
   & 3.448042D0, 1.485372254108D-04, -4.65D-23, 0.0002754, 2, & ! 10860      448
   & 1.216283D0, 6.459463966089D-05, -8.69D-23, 0.0002729, 1, & !  4150      449
   & 4.766566D0, 6.794025166758D-05,  9.31D-23, 0.0002712, 1  & !  4811      450
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=451,460) &
   & / &
   & 1.108260D0, 1.434022109253D-04, -2.95D-23, 0.0002690, 2, & !  9702      451
   & 5.905622D0, 1.482824232802D-04,  3.37D-23, 0.0002690, 2, & ! 10778      452
   & 5.098233D0, 7.271134569441D-05,  5.67D-24, 0.0002683, 1, & !  5797      453
   & 0.798366D0, 6.022173938465D-05, -5.54D-25, 0.0002662, 1, & !  3689      454
   & 2.225564D0, 1.452343104952D-04,  7.81D-24, 0.0002661, 2, & !  9933      455
   & 0.941726D0, 1.352180019621D-04, -1.19D-23, 0.0002639, 2, & !  8611      456
   & 1.925309D0, 8.084946467197D-05,  8.69D-23, 0.0002632, 1, & !  7346      457
   & 1.281376D0, 1.460521109404D-04, -5.69D-24, 0.0002602, 2, & ! 10412      458
   & 2.543557D0, 5.759323329427D-05, -3.89D-23, 0.0002593, 1, & !  3442      459
   & 5.748279D0, 1.431367118324D-04,  5.80D-23, 0.0002560, 2  & !  9614      460
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=461,470) &
   & / &
   & 1.265602D0, 1.485479223732D-04, -5.37D-23, 0.0002557, 2, & ! 10863      461
   & 2.950147D0, 1.040272362860D-05,  5.23D-23, 0.0002555, 0, & !  2367      462
   & 3.140920D0, 5.794643777124D-05,  3.56D-23, 0.0002551, 1, & !  3480      463
   & 0.928358D0, 6.307073627504D-05,  2.27D-23, 0.0002540, 1, & !  4079      464
   & 1.897741D0, 7.540625400244D-05, -4.29D-23, 0.0002538, 1, & !  6698      465
   & 4.750792D0, 7.043606310032D-05,  4.50D-23, 0.0002537, 1, & !  5153      466
   & 5.813041D0, 9.906108512313D-06, -1.04D-22, 0.0002525, 0, & !  2236      467
   & 4.968241D0, 6.986234880401D-05, -1.76D-23, 0.0002523, 1, & !  4977      468
   & 1.680292D0, 7.597996829875D-05,  1.97D-23, 0.0002522, 1, & !  6859      469
   & 1.089931D0, 1.564548345690D-04,  4.66D-23, 0.0002517, 2  & ! 11331      470
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=471,480) &
   & / &
   & 1.741746D0, 6.272824777975D-05, -5.59D-23, 0.0002504, 1, & !  4004      471
   & 1.970990D0, 7.009355558571D-05, -3.67D-23, 0.0002486, 1, & !  5031      472
   & 0.714136D0, 1.405853049220D-04, -7.45D-23, 0.0002448, 2, & !  9388      473
   & 5.692824D0, 8.047486627027D-05,  2.70D-23, 0.0002431, 1, & !  7271      474
   & 4.750120D0, 1.283825008716D-04,  8.07D-23, 0.0002430, 2, & !  8106      475
   & 2.961474D0, 6.196613357052D-05, -1.25D-22, 0.0002428, 1, & !  3796      476
   & 1.921865D0, 1.462062185421D-04,  6.93D-23, 0.0002418, 2, & ! 10462      477
   & 3.354390D0, 6.780755700994D-05,  6.73D-24, 0.0002392, 1, & !  4787      478
   & 1.797201D0, 1.253900933418D-04, -2.49D-23, 0.0002379, 2, & !  7998      479
   & 1.974434D0, 4.736801715583D-06, -1.91D-23, 0.0002374, 0  & !  1261      480
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=481,490) &
   & / &
   & 0.129376D0, 1.448468137070D-04,  1.62D-24, 0.0002364, 2, & !  9833      481
   & 3.213493D0, 2.219596358111D-06,  4.35D-23, 0.0002358, 0, & !   754      482
   & 5.436595D0, 1.380456049277D-04,  2.59D-23, 0.0002356, 2, & !  9028      483
   & 5.368139D0, 7.046925469949D-05, -9.74D-27, 0.0002337, 1, & !  5171      484
   & 3.052570D0, 7.808509849471D-06, -5.43D-23, 0.0002319, 0, & !  1938      485
   & 1.450067D0, 1.433797162885D-04,  8.33D-24, 0.0002314, 2, & !  9690      486
   & 5.563815D0, 1.483049179170D-04, -4.08D-24, 0.0002314, 2, & ! 10788      487
   & 5.819371D0, 3.236512697933D-06,  3.26D-23, 0.0002304, 0, & !  1152      488
   & 2.535458D0, 8.297067770301D-05, -2.11D-23, 0.0002280, 1, & !  7508      489
   & 2.677779D0, 1.486806170308D-04,  3.26D-23, 0.0002245, 2  & ! 10876      490
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=491,500) &
   & / &
   & 4.336103D0, 1.430040171747D-04, -2.84D-23, 0.0002242, 2, & !  9599      491
   & 3.918186D0, 1.386311168985D-04,  5.80D-23, 0.0002235, 2, & !  9167      492
   & 6.005490D0, 1.080091737918D-05,  5.13D-23, 0.0002233, 0, & !  2483      493
   & 2.056874D0, 1.479067051471D-04, -6.20D-24, 0.0002230, 2, & ! 10708      494
   & 3.095695D0, 1.530535173070D-04, -5.37D-23, 0.0002227, 2, & ! 11119      495
   & 2.652584D0, 1.355272988582D-04,  1.12D-22, 0.0002220, 2, & !  8692      496
   & 2.468119D0, 1.406955049428D-04,  4.96D-23, 0.0002199, 2, & !  9405      497
   & 2.083187D0, 1.409170964549D-04,  1.13D-23, 0.0002198, 2, & !  9463      498
   & 3.624739D0, 1.404525004867D-04,  9.93D-23, 0.0002193, 2, & !  9296      499
   & 3.757957D0, 7.479824739488D-05, -3.72D-23, 0.0002190, 1  & !  6536      500
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=501,510) &
   & / &
   & 1.132270D0, 2.660596977472D-06,  1.65D-23, 0.0002180, 0, & !   976      501
   & 2.282001D0, 1.331311002616D-04,  3.10D-23, 0.0002172, 2, & !  8450      502
   & 3.977085D0, 1.359362085904D-04,  1.07D-22, 0.0002157, 2, & !  8791      503
   & 5.397280D0, 1.401207089538D-04,  1.35D-23, 0.0002153, 2, & !  9230      504
   & 1.568847D0, 6.322484387672D-05,  9.77D-23, 0.0002146, 1, & !  4090      505
   & 5.790596D0, 1.462619237974D-04, -1.03D-23, 0.0002124, 2, & ! 10494      506
   & 3.983757D0, 2.076204738112D-06, -3.56D-23, 0.0002119, 0, & !   719      507
   & 1.223286D0, 1.454227104081D-04,  1.46D-23, 0.0002115, 2, & ! 10035      508
   & 4.481868D0, 1.433572026324D-04,  4.29D-23, 0.0002082, 2, & !  9682      509
   & 3.198701D0, 7.539445632800D-05, -1.24D-23, 0.0002067, 1  & !  6693      510
   & /
!
      DATA      ( PHAS2_TID(N2), FREQ2_TID(N2), ACCL2_TID(N2), AMPL2_TID(N2), M2_TID(N2),  N2=511,517) &
   & / &
   & 4.240967D0, 1.518451461780D-05, -4.24D-23, 0.0002052, 0, & !  2868      511
   & 3.055342D0, 1.458422980834D-04, -1.08D-24, 0.0002049, 2, & ! 10300      512
   & 4.853215D0, 6.784184932119D-05, -6.16D-23, 0.0002044, 1, & !  4803      513
   & 1.795318D0, 7.800046778157D-05,  6.37D-23, 0.0002041, 1, & !  7024      514
   & 5.481375D0, 1.505791188183D-04, -1.70D-23, 0.0002025, 2, & ! 10962      515
   & 3.262813D0, 8.617287907038D-05,  7.66D-23, 0.0002019, 1, & !  7762      516
   & 2.779803D0, 3.425075146073D-07,  8.18D-23, 0.0002006, 0  & !   299      517
   & /
