!
! --- This file was generated automatically by nut_out v4.2  2003.12.27
! --- written by Leonid Petrov ( Leonid.Petrov@lpetrov.net )
! --- File was created at 2003.12.27-18:17:06
! --- It contains nutation expansion of the model IERS96 luni-solar + planet terms
! --- Phases, frequencies, accelerations of the arguments as well as amplitudes  
! --- of cos and sin components of nutation in longituide and in obliquity
! --- are transformed to the form suitable for computations.
! --- Nutation is considered as a a harmonic variations in polar motion 
! --- Convention: angles of a small rotation are computed as :
! ---             E1 = sum_i {  PMC_i*cos(ARG_i) + PMS_i*sin(ARG_i) }
! ---             E2 = sum_i { -PMC_i*sin(ARG_i) + PMS_i*cos(ARG_i) }
! ---             E3 = 0 
! --- Truncation limit for amplitudes:   1.0000 prad
! --- Units are picoradians for amplitudes  and  1.0D-24 rad/sec for their rates
! --- in total  737 consitiuents are presented
! --- Epsilon_o =  0.4090928041 rad
! --- OM_preces = -7.08618327D-12 rad/sec
!
      INTEGER*4   N_NUT, I_NUT
      PARAMETER ( N_NUT = 737 )
      INTEGER*4  IND_NUT(N_NUT)
      CHARACTER  TYP_NUT(N_NUT)*1, MODEL_NUT*40
      REAL*8     PHAS_NUT(N_NUT), FREQ_NUT(N_NUT), ACCL_NUT(N_NUT)
      REAL*8     PMC_NUT(N_NUT),      PMS_NUT(N_NUT) 
      REAL*8     PMC_RATE_NUT(N_NUT), PMS_RATE_NUT(N_NUT)
      REAL*8     EPSILON_0_NUT
      PARAMETER  ( EPSILON_0_NUT = 0.4090928041D0 ) ! rad
      PARAMETER  ( MODEL_NUT = 'IERS96 luni-solar + planet terms        ' )
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1,10 ) &
     &             /            &
     & 0.0484511887D0, -9.108738374179D-05, -7.3864D-23,  198, 'R', & !    1
     &        -13.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6458148159D0, -9.073417926490D-05,  6.0248D-25,  168, 'R', & !    2
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8066434615D0, -8.880138516554D-05, -1.1680D-22,  145, 'R', & !    3
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5864462887D0, -8.845887765071D-05, -3.5064D-23,  154, 'R', & !    4
     &          5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4040070887D0, -8.844818068864D-05, -4.2334D-23,   80, 'R', & !    5
     &          9.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 2.3608819115D0, -8.824908381341D-05, -4.2856D-23,  205, 'R', & !    6
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1838099159D0, -8.810567317381D-05,  3.9402D-23,  174, 'R', & !    7
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0013707159D0, -8.809497621175D-05,  3.2132D-23,   98, 'R', & !    8
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9582455387D0, -8.789587933651D-05,  3.1610D-23,  201, 'R', & !    9
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0614532544D0, -8.617287907445D-05, -7.8001D-23,  104, 'R', & !   10
     &         12.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  11,  20 ) &
     &             /                 &
     & 4.1621993615D0, -8.616218211239D-05, -8.5271D-23,   53, 'R', & !   11
     &         21.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.1190741844D0, -8.596308523715D-05, -8.5793D-23,  250, 'R', & !   12
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8412560815D0, -8.583037155962D-05,  3.7354D-24,  217, 'R', & !   13
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6588168815D0, -8.581967459756D-05, -3.5346D-24,   73, 'R', & !   14
     &         31.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.7595629887D0, -8.580897763550D-05, -1.0804D-23,   35, 'R', & !   15
     &         47.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.3859547415D0, -8.576396934209D-05, -8.3183D-23,  249, 'R', & !   16
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6156917044D0, -8.562057772232D-05, -4.0567D-24,  219, 'R', & !   17
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7164378115D0, -8.560988076026D-05, -1.1327D-23,  101, 'R', & !   18
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2561805087D0, -8.546647012067D-05,  7.0932D-23,  140, 'R', & !   19
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3569266159D0, -8.545577315860D-05,  6.3662D-23,   70, 'R', & !   20
     &         14.4D0,         1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  21,  30 ) &
     &             /                 &
     & 1.9833183687D0, -8.541076486520D-05, -8.7159D-24,  216, 'R', & !   21
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9203916344D0, -8.387618353614D-05, -1.2821D-22,  207, 'R', & !   22
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4601343315D0, -8.373277289654D-05, -4.5949D-23,  246, 'R', & !   23
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2776951315D0, -8.372207593448D-05, -5.3219D-23,  124, 'R', & !   24
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6898712944D0, -8.358938127677D-05,  3.3177D-23,  161, 'R', & !   25
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5994483544D0, -8.354437298337D-05, -3.9201D-23,  147, 'R', & !   26
     &         37.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4170091544D0, -8.353367602131D-05, -4.6471D-23,   44, 'R', & !   27
     &        138.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.2345699544D0, -8.352297905924D-05, -5.3741D-23,   22, 'R', & !   28
     &        213.5D0,        -2.0D0,     -768.1D0,      0.0D0,     & !
     & 3.1441470144D0, -8.347797076584D-05, -1.2612D-22,  206, 'R', & !   29
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0574979587D0, -8.337956841965D-05,  2.8517D-23,  213, 'R', & !   30
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  31,  40 ) &
     &             /                 &
     & 0.8750587587D0, -8.336887145759D-05,  2.1247D-23,  106, 'R', & !   31
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8572836215D0, -8.335707378286D-05, -9.2380D-24,  240, 'R', & !   32
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6748444215D0, -8.334637682080D-05, -1.6508D-23,  134, 'R', & !   33
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3738839772D0, -8.333457914607D-05, -4.6994D-23,  247, 'R', & !   34
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1914447772D0, -8.332388218400D-05, -5.4263D-23,  114, 'R', & !   35
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1968119815D0, -8.319116850648D-05,  3.5265D-23,  141, 'R', & !   36
     &         42.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0143727815D0, -8.318047154441D-05,  2.7995D-23,   38, 'R', & !   37
     &        171.8D0,        -0.5D0,    -1073.7D0,      0.0D0,     & !
     & 0.8319335815D0, -8.316977458235D-05,  2.0725D-23,   20, 'R', & !   38
     &        266.6D0,        -2.5D0,        0.0D0,      0.0D0,     & !
     & 5.9239498415D0, -8.313546325101D-05, -4.4383D-23,  254, 'P', & !   39
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7415106415D0, -8.312476628894D-05, -5.1653D-23,  128, 'R', & !   40
     &         59.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  41,  50 ) &
     &             /                 &
     & 1.5590714415D0, -8.311406932688D-05, -5.8923D-23,  190, 'R', & !   41
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2722080487D0, -8.299317234390D-05,  5.7959D-23,  226, 'R', & !   42
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9712476044D0, -8.298137466917D-05,  2.7473D-23,  109, 'R', & !   43
     &         15.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7888084044D0, -8.297067770711D-05,  2.0203D-23,   59, 'R', & !   44
     &         21.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.6117364087D0, -8.282726706752D-05,  1.0246D-22,  155, 'R', & !   45
     &          5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4292972087D0, -8.281657010546D-05,  9.5192D-23,   77, 'R', & !   46
     &          9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3388742687D0, -8.277156181205D-05,  2.2814D-23,  135, 'R', & !   47
     &         48.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1564350687D0, -8.276086484999D-05,  1.5544D-23,  166, 'R', & !   48
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3861720315D0, -8.261747323022D-05,  9.4670D-23,  212, 'R', & !   49
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2957490915D0, -8.257246493681D-05,  2.2292D-23,  237, 'R', & !   50
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  51,  60 ) &
     &             /                 &
     & 4.1752014272D0, -8.124767744505D-05, -8.9408D-23,  179, 'R', & !   51
     &         -5.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9927622272D0, -8.123698048299D-05, -9.6678D-23,   83, 'R', & !   52
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8156902315D0, -8.109356984340D-05, -1.4419D-23,  123, 'R', & !   53
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6332510315D0, -8.108287288133D-05, -2.1689D-23,   61, 'R', & !   54
     &        -19.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4330366944D0, -8.106037824454D-05, -5.9445D-23,  245, 'R', & !   55
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2278663944D0, -8.096087518569D-05,  7.1976D-23,  159, 'R', & !   56
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0454271944D0, -8.095017822363D-05,  6.4706D-23,   78, 'R', & !   57
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8542581472D0, -8.091586689228D-05, -4.0165D-25,  193, 'P', & !   58
     &         21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0735254987D0, -8.090627064289D-05,  1.5544D-23,  146, 'R', & !   59
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6718189472D0, -8.090516993022D-05, -7.6716D-24,   65, 'R', & !   60
     &        295.4D0,        -1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  61,  70 ) &
     &             /                 &
     & 4.7725650544D0, -8.089447296816D-05, -1.4942D-23,   17, 'R', & !   61
     &       1409.1D0,        -7.8D0,    -1222.2D0,      0.0D0,     & !
     & 2.5901258544D0, -8.088377600610D-05, -2.2211D-23,    9, 'R', & !   62
     &       2202.5D0,       -11.6D0,    -5831.0D0,      0.0D0,     & !
     & 1.3989568072D0, -8.084946467475D-05, -8.7320D-23,  172, 'P', & !   63
     &         30.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4997029144D0, -8.083876771269D-05, -9.4590D-23,   82, 'R', & !   64
     &        139.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 3.3172637144D0, -8.082807075063D-05, -1.0186D-22,  224, 'R', & !   65
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4130538587D0, -8.074036536650D-05,  6.0047D-23,  228, 'R', & !   66
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2306146587D0, -8.072966840444D-05,  5.2777D-23,  105, 'R', & !   67
     &         -4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9296542144D0, -8.071787072971D-05,  2.2292D-23,  136, 'R', & !   68
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0304003215D0, -8.070717376765D-05,  1.5022D-23,   69, 'R', & !   69
     &        -15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7294398772D0, -8.069537609292D-05, -1.5464D-23,  115, 'R', & !   70
     &         12.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  71,  80 ) &
     &             /                 &
     & 2.5470006772D0, -8.068467913086D-05, -2.2734D-23,   55, 'R', & !   71
     &         21.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 6.1401917187D0, -8.068466011103D-05, -1.9601D-23,  203, 'R', & !   72
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2691825744D0, -8.055196545333D-05,  6.6795D-23,  122, 'R', & !   73
     &         64.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3699286815D0, -8.054126849127D-05,  5.9525D-23,   33, 'R', & !   74
     &        279.9D0,        -2.9D0,     -305.5D0,      0.0D0,     & !
     & 3.1874894815D0, -8.053057152920D-05,  5.2255D-23,   16, 'R', & !   75
     &        439.4D0,        -2.5D0,    -1073.7D0,      0.0D0,     & !
     & 1.9963204344D0, -8.049626019786D-05, -1.2853D-23,  107, 'P', & !   76
     &        113.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0970665415D0, -8.048556323580D-05, -2.0123D-23,   49, 'R', & !   77
     &        585.0D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.9146273415D0, -8.047486627373D-05, -2.7393D-23,   81, 'R', & !   78
     &         27.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3268035044D0, -8.034217161603D-05,  5.9003D-23,  112, 'R', & !   79
     &         13.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1443643044D0, -8.033147465396D-05,  5.1733D-23,   56, 'R', & !   80
     &         23.8D0,         1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  81,  90 ) &
     &             /                 &
     & 6.0539413644D0, -8.028646636056D-05, -2.0645D-23,  139, 'R', & !   81
     &         46.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5936840615D0, -8.014305572097D-05,  6.1614D-23,  184, 'P', & !   82
     &         26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1012391272D0, -8.013237777873D-05,  5.1211D-23,  210, 'R', & !   83
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4112448615D0, -8.013235875890D-05,  5.4344D-23,   88, 'R', & !   84
     &        118.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5119909687D0, -8.012166179684D-05,  4.7074D-23,  158, 'R', & !   85
     &          4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3681196844D0, -7.993326188367D-05,  5.3822D-23,  196, 'R', & !   86
     &         14.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7028733600D0, -7.867487660944D-05,  2.9040D-23,  175, 'R', & !   87
     &         -5.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8036194672D0, -7.866417964737D-05,  2.1770D-23,   84, 'R', & !   88
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0319321087D0, -7.864276670342D-05,  1.0363D-23,  214, 'R', & !   89
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4300112200D0, -7.861917135397D-05, -5.0608D-23,  233, 'P', & !   90
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  91, 100 ) &
     &             /                 &
     & 0.2475720200D0, -7.860847439190D-05, -5.7878D-23,   79, 'R', & !   91
     &        -33.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3483181272D0, -7.859777742984D-05, -6.5148D-23,   42, 'R', & !   92
     &        -51.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8880608244D0, -7.845436679025D-05,  1.7110D-23,   86, 'R', & !   93
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9888069315D0, -7.844366982819D-05,  9.8405D-24,   37, 'R', & !   94
     &        -60.3D0,         1.5D0,    -2147.4D0,      0.0D0,     & !
     & 4.3051929500D0, -7.839868055460D-05, -6.5670D-23,  248, 'R', & !   95
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6151986844D0, -7.839866153478D-05, -6.2538D-23,  162, 'R', & !   96
     &        -27.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1177977872D0, -7.831097517048D-05,  9.6236D-23,  232, 'R', & !   97
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2098140472D0, -7.827666383914D-05,  3.1128D-23,   95, 'P', & !   98
     &        152.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0273748472D0, -7.826596687707D-05,  2.3858D-23,   26, 'R', & !   99
     &       2356.8D0,        -9.2D0,        0.0D0,      0.0D0,     & !
     & 0.8449356472D0, -7.825526991501D-05,  1.6588D-23,    8, 'R', & !  100
     &      11299.4D0,       -46.7D0,    -9769.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 101, 110 ) &
     &             /                 &
     & 3.3188633611D0, -7.824530215830D-05,  4.0848D-23,  374, 'R', & !  101
     &         -0.4D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.9456817544D0, -7.824457295295D-05,  9.3184D-24,    3, 'R', & !  102
     &      17654.4D0,       -73.8D0,   -43898.4D0,      0.0D0,     & !
     & 0.2893148405D0, -7.824384374760D-05, -2.2211D-23,  375, 'R', & !  103
     &          0.4D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 2.7632425544D0, -7.823387599088D-05,  2.0484D-24,  173, 'R', & !  104
     &         19.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0554731515D0, -7.822205929633D-05, -2.5304D-23,  243, 'R', & !  105
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9369519072D0, -7.822095858367D-05, -4.8520D-23,  252, 'P', & !  106
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7545127072D0, -7.821026162160D-05, -5.5790D-23,   60, 'P', & !  107
     &        525.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.5720735072D0, -7.819956465954D-05, -6.3060D-23,   25, 'R', & !  108
     &       2668.2D0,       -10.1D0,        0.0D0,      0.0D0,     & !
     & 5.6728196144D0, -7.818886769748D-05, -7.0330D-23,   62, 'R', & !  109
     &        -66.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4903804144D0, -7.817817073542D-05, -7.7600D-23,  222, 'R', & !  110
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 111, 120 ) &
     &             /                 &
     & 2.1027709144D0, -7.806797071450D-05,  4.6552D-23,  225, 'R', & !  111
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8018104700D0, -7.805617303977D-05,  1.6066D-23,   93, 'R', & !  112
     &         21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3950015115D0, -7.805615401995D-05,  1.9199D-23,  238, 'P', & !  113
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9025565772D0, -7.804547607771D-05,  8.7962D-24,   39, 'R', & !  114
     &         55.7D0,         1.0D0,     2147.4D0,      0.0D0,     & !
     & 2.2125623115D0, -7.804545705789D-05,  1.1929D-23,  117, 'R', & !  115
     &        -64.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0301231115D0, -7.803476009582D-05,  4.6592D-24,  156, 'R', & !  116
     &         -4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0123479744D0, -7.802296242110D-05, -2.5826D-23,  157, 'R', & !  117
     &        -31.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5289483300D0, -7.800046778430D-05, -6.3582D-23,  149, 'R', & !  118
     &         36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6247384744D0, -7.791276240018D-05,  9.8325D-23,  255, 'R', & !  119
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4422992744D0, -7.790206543812D-05,  9.1055D-23,  151, 'R', & !  120
     &         -5.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 121, 130 ) &
     &             /                 &
     & 5.5430453815D0, -7.789136847605D-05,  8.3785D-23,   74, 'R', & !  121
     &        -11.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2511302272D0, -7.786775410677D-05,  2.5947D-23,  182, 'P', & !  122
     &        -24.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3518763344D0, -7.785705714471D-05,  1.8677D-23,   46, 'P', & !  123
     &       1134.7D0,        -4.4D0,      305.5D0,      0.0D0,     & !
     & 4.8594314000D0, -7.784637920247D-05,  8.2741D-24,  215, 'R', & !  124
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1694371344D0, -7.784636018265D-05,  1.1407D-23,   19, 'R', & !  125
     &       5806.4D0,       -22.7D0,      305.5D0,      0.0D0,     & !
     & 6.2701832415D0, -7.783566322059D-05,  4.1370D-24,   40, 'R', & !  126
     &        184.2D0,         0.0D0,     -305.5D0,      0.0D0,     & !
     & 4.0877440415D0, -7.782496625852D-05, -3.1329D-24,  116, 'R', & !  127
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8965749944D0, -7.779065492718D-05, -6.8241D-23,  231, 'P', & !  128
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4999202044D0, -7.769227160082D-05,  8.3263D-23,  257, 'R', & !  129
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6097116015D0, -7.766975794420D-05,  4.8640D-23,  208, 'R', & !  130
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 131, 140 ) &
     &             /                 &
     & 4.3087511572D0, -7.765796026947D-05,  1.8155D-23,  131, 'P', & !  131
     &         75.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1263119572D0, -7.764726330741D-05,  1.0885D-23,   54, 'R', & !  132
     &        397.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 6.2270580644D0, -7.763656634535D-05,  3.6149D-24,  167, 'R', & !  133
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9492399615D0, -7.750385266782D-05,  9.3144D-23,  191, 'P', & !  134
     &         22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7668007615D0, -7.749315570576D-05,  8.5874D-23,   90, 'R', & !  135
     &        125.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5843615615D0, -7.748245874369D-05,  7.8604D-23,  186, 'R', & !  136
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0831867800D0, -7.744816643217D-05,  1.0363D-23,  176, 'R', & !  137
     &         20.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4939386215D0, -7.743745045029D-05,  6.2256D-24,  163, 'P', & !  138
     &         37.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7236755844D0, -7.729405883052D-05,  8.5351D-23,  211, 'R', & !  139
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6462530972D0, -7.616836821399D-05, -2.5826D-23,  144, 'R', & !  140
     &         -6.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 141, 150 ) &
     &             /                 &
     & 0.4638138972D0, -7.615767125193D-05, -3.3096D-23,   76, 'R', & !  141
     &         -9.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8759900600D0, -7.602497659423D-05,  5.3299D-23,  209, 'R', & !  142
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7855671200D0, -7.597996830082D-05, -1.9079D-23,  111, 'P', & !  143
     &        -74.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6031279200D0, -7.596927133876D-05, -2.6349D-23,   41, 'R', & !  144
     &       -184.9D0,         0.0D0,      305.5D0,      0.0D0,     & !
     & 0.4206887200D0, -7.595857437669D-05, -3.3618D-23,   23, 'R', & !  145
     &       -230.7D0,         0.0D0,      768.1D0,      0.0D0,     & !
     & 3.2436167244D0, -7.581516373710D-05,  4.8640D-23,  194, 'R', & !  146
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0611775244D0, -7.580446677504D-05,  4.1370D-23,  118, 'R', & !  147
     &         -3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0434023872D0, -7.579266910031D-05,  1.0885D-23,  187, 'R', & !  148
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8609631872D0, -7.578197213825D-05,  3.6149D-24,   97, 'R', & !  149
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1531937844D0, -7.577015544370D-05, -2.3738D-23,  150, 'P', & !  150
     &        -49.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 151, 160 ) &
     &             /                 &
     & 0.3775635428D0, -7.575947750146D-05, -3.4141D-23,  220, 'R', & !  151
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9707545844D0, -7.575945848163D-05, -3.1008D-23,   64, 'R', & !  152
     &       -316.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7883153844D0, -7.574876151957D-05, -3.8278D-23,  127, 'R', & !  153
     &         13.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2821846400D0, -7.563746078599D-05,  6.2658D-23,  142, 'P', & !  154
     &        -60.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3829307472D0, -7.562676382393D-05,  5.5388D-23,   58, 'R', & !  155
     &       -379.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.2004915472D0, -7.561606686186D-05,  4.8118D-23,   24, 'R', & !  156
     &       -637.4D0,         1.0D0,      611.1D0,      0.0D0,     & !
     & 1.0180523472D0, -7.560536989980D-05,  4.0848D-23,   12, 'R', & !  157
     &      -1016.3D0,         3.4D0,     2610.0D0,      0.0D0,     & !
     & 4.6112433887D0, -7.560535087998D-05,  4.3981D-23,  229, 'R', & !  158
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6552800772D0, -7.559356271516D-05,  1.1929D-23,  258, 'R', & !  159
     &          0.0D0,         7.7D0,        0.0D0,      0.0D0,     & !
     & 3.8178380100D0, -7.558287526301D-05,  3.0927D-24,  202, 'R', & !  160
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 161, 170 ) &
     &             /                 &
     & 2.4728408772D0, -7.558286575310D-05,  4.6592D-24,  259, 'R', & !  161
     &          0.0D0,        18.5D0,        0.0D0,      0.0D0,     & !
     & 1.1278437444D0, -7.558285624319D-05,  6.2256D-24,  125, 'R', & !  162
     &         55.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0093225000D0, -7.558175553052D-05, -1.6990D-23,   75, 'P', & !  163
     &       -279.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2285898515D0, -7.557215928112D-05, -1.0443D-24,  236, 'R', & !  164
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1100686072D0, -7.557105856846D-05, -2.4260D-23,   15, 'P', & !  165
     &      13203.7D0,       -37.7D0,     1833.3D0,      0.0D0,     & !
     & 3.9276294072D0, -7.556036160639D-05, -3.1530D-23,    7, 'R', & !  166
     &      66909.4D0,      -189.0D0,     2138.8D0,      0.0D0,     & !
     & 1.7451902072D0, -7.554966464433D-05, -3.8800D-23,   14, 'R', & !  167
     &      -1967.0D0,         5.3D0,     1833.3D0,      0.0D0,     & !
     & 5.8459363144D0, -7.553896768227D-05, -4.6070D-23,   67, 'R', & !  168
     &         16.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6547672672D0, -7.550465635093D-05, -1.1118D-22,  235, 'P', & !  169
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1573663700D0, -7.541696998663D-05,  4.7596D-23,  251, 'R', & !  170
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 171, 180 ) &
     &             /                 &
     & 0.4673721044D0, -7.541695096680D-05,  5.0729D-23,  244, 'P', & !  171
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5681182115D0, -7.540625400474D-05,  4.3459D-23,  100, 'R', & !  172
     &        -90.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3856790115D0, -7.539555704268D-05,  3.6189D-23,  185, 'R', & !  173
     &          4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2671577672D0, -7.539445633001D-05,  1.2973D-23,  130, 'P', & !  174
     &        -75.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0847185672D0, -7.538375936795D-05,  5.7035D-24,   57, 'R', & !  175
     &       -399.6D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.1854646744D0, -7.537306240588D-05, -1.5665D-24,  121, 'R', & !  176
     &         12.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0669434300D0, -7.537196169322D-05, -2.4782D-23,  133, 'P', & !  177
     &         71.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8845042300D0, -7.536126473116D-05, -3.2052D-23,   51, 'R', & !  178
     &        444.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.7020650300D0, -7.535056776909D-05, -3.9322D-23,  102, 'R', & !  179
     &        -16.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6066861272D0, -7.522855105363D-05,  5.7477D-23,  137, 'P', & !  180
     &        -64.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 181, 190 ) &
     &             /                 &
     & 0.4242469272D0, -7.521785409156D-05,  5.0207D-23,   31, 'P', & !  181
     &       2922.3D0,        -8.7D0,      305.5D0,      0.0D0,     & !
     & 4.5249930344D0, -7.520715712950D-05,  4.2937D-23,   13, 'R', & !  182
     &      14830.7D0,       -40.1D0,      305.5D0,      0.0D0,     & !
     & 2.3425538344D0, -7.519646016744D-05,  3.5667D-23,   28, 'R', & !  183
     &       -478.9D0,         1.0D0,      305.5D0,      0.0D0,     & !
     & 0.1601146344D0, -7.518576320538D-05,  2.8397D-23,  129, 'R', & !  184
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8413790528D0, -7.516216785592D-05, -3.2574D-23,  221, 'R', & !  185
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1513847872D0, -7.516214883610D-05, -2.9441D-23,  132, 'P', & !  186
     &        -73.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2521308944D0, -7.515145187403D-05, -3.6711D-23,   66, 'P', & !  187
     &        451.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 3.0696916944D0, -7.514075491197D-05, -4.3981D-23,  126, 'R', & !  188
     &        -55.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6820821944D0, -7.503055489105D-05,  8.0170D-23,  253, 'R', & !  189
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3811217500D0, -7.501875721633D-05,  4.9685D-23,   99, 'P', & !  190
     &        136.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 191, 200 ) &
     &             /                 &
     & 4.4818678572D0, -7.500806025426D-05,  4.2415D-23,   47, 'R', & !  191
     &        696.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.2994286572D0, -7.499736329220D-05,  3.5145D-23,   91, 'R', & !  192
     &        -22.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5916592544D0, -7.498554659765D-05,  7.7921D-24,  160, 'P', & !  193
     &         38.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2090057172D0, -7.495235499879D-05, -3.7233D-23,  195, 'P', & !  194
     &         22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1223566615D0, -7.485395265261D-05,  1.1740D-22,  197, 'R', & !  195
     &         15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4387426800D0, -7.480896337903D-05,  4.1893D-23,  165, 'R', & !  196
     &         26.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7487484144D0, -7.480894435920D-05,  4.5025D-23,  218, 'P', & !  197
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8494945215D0, -7.479824739714D-05,  3.7755D-23,  110, 'P', & !  198
     &        103.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6670553215D0, -7.478755043508D-05,  3.0486D-23,  227, 'R', & !  199
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9056201515D0, -7.391666194926D-05, -5.2215D-25,  119, 'R', & !  200
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 201, 210 ) &
     &             /                 &
     & 5.0449341744D0, -7.372826203608D-05,  6.2256D-24,  189, 'R', & !  201
     &         -4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8624949744D0, -7.371756507402D-05, -1.0443D-24,   29, 'R', & !  202
     &        138.9D0,         0.5D0,     -933.7D0,      0.0D0,     & !
     & 0.4683970452D0, -7.368399885484D-05, -2.1637D-24,  373, 'R', & !  203
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3613201928D0, -7.368327276250D-05, -6.9285D-23,  192, 'R', & !  204
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356845298397D-05, -2.1637D-24,  372, 'R', & !  205
     &         -3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354386270325D-05,  0.0000D+00,  371, 'R', & !  206
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9010628900D0, -7.353986212291D-05,  1.2973D-23,  120, 'P', & !  207
     &        -63.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0018089972D0, -7.352916516085D-05,  5.7035D-24,   50, 'R', & !  208
     &       -122.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351927242252D-05,  2.1637D-24,  370, 'R', & !  209
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8193697972D0, -7.351846819878D-05, -1.5665D-24,    6, 'R', & !  210
     &       4557.5D0,        -8.4D0,   -14651.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 211, 220 ) &
     &             /                 &
     & 5.3930805700D0, -7.350585340231D-05, -2.1637D-24,  369, 'R', & !  211
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6223208622D0, -7.350168508941D-05, -2.1637D-24,  368, 'R', & !  212
     &         -3.2D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.6191554600D0, -7.349597356199D-05, -3.9322D-23,  241, 'R', & !  213
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2616858442D0, -7.349389515472D-05, -2.1637D-24,  367, 'R', & !  214
     &          0.0D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 2.2218673592D0, -7.348490019559D-05, -2.1637D-24,  366, 'R', & !  215
     &         -0.5D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.6282007500D0, -7.348415686744D-05, -6.6675D-23,  181, 'P', & !  216
     &         29.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7289468572D0, -7.347345990538D-05, -7.3944D-23,   92, 'P', & !  217
     &        113.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5465076572D0, -7.346276294331D-05, -8.1214D-23,  223, 'R', & !  218
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344391215397D-05, -2.1637D-24,  365, 'R', & !  219
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932187325D-05,  0.0000D+00,  364, 'R', & !  220
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 221, 230 ) &
     &             /                 &
     & 6.1145765614D0, -7.339473159252D-05,  2.1637D-24,  363, 'R', & !  221
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6843622272D0, -7.336935432472D-05, -2.1637D-24,  362, 'R', & !  222
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 3.0403769128D0, -7.335146220974D-05,  1.9721D-23,   85, 'P', & !  223
     &       -190.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5373332002D0, -7.334394615248D-05, -2.1637D-24,  361, 'P', & !  224
     &         -6.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 0.8579377128D0, -7.334076524767D-05,  1.2451D-23,   30, 'P', & !  225
     &      -2136.5D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 4.6891237815D0, -7.333198790488D-05, -2.1637D-24,  359, 'R', & !  226
     &         -7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.9586838200D0, -7.333006828561D-05,  5.1813D-24,   11, 'R', & !  227
     &      -4357.3D0,         7.7D0,     3509.5D0,      0.0D0,     & !
     & 2.2686895544D0, -7.333004926579D-05,  8.3142D-24,  239, 'P', & !  228
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332020466771D-05, -2.1637D-24,  358, 'R', & !  229
     &         25.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9432152724D0, -7.331948296617D-05, -2.1637D-24,  357, 'P', & !  230
     &          0.5D0,         3.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 231, 240 ) &
     &             /                 &
     & 2.7762446792D0, -7.331937132397D-05, -2.1637D-24,  356, 'R', & !  231
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7762446200D0, -7.331937132355D-05, -2.0886D-24,    2, 'R', & !  232
     &     119216.9D0,      -225.7D0,  -282716.8D0,      0.0D0,     & !
     & 0.0862503544D0, -7.331935230372D-05,  1.0443D-24,   34, 'R', & !  233
     &       1645.2D0,        -3.4D0,    -2444.4D0,      0.0D0,     & !
     & 5.8924593931D0, -7.331925968177D-05, -2.1637D-24,  355, 'R', & !  234
     &         -0.5D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 5.3903041732D0, -7.331853798023D-05, -2.1637D-24,  354, 'P', & !  235
     &         -1.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5938054200D0, -7.330867436148D-05, -9.3585D-24,   87, 'R', & !  236
     &         70.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1869964615D0, -7.330865534166D-05, -6.2256D-24,  188, 'R', & !  237
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330675474306D-05, -2.1637D-24,  353, 'R', & !  238
     &          7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 3.3757911762D0, -7.330258643015D-05, -2.1637D-24,  352, 'R', & !  239
     &          2.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.7675147728D0, -7.329575695427D-05, -5.9927D-23,  169, 'P', & !  240
     &        -36.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 241, 250 ) &
     &             /                 &
     & 2.0151561582D0, -7.329479649547D-05, -2.1637D-24,  351, 'R', & !  241
     &          4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478104325D-05,  0.0000D+00,  350, 'R', & !  242
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328578608412D-05,  0.0000D+00,  349, 'R', & !  243
     &         37.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5850755728D0, -7.328505999220D-05, -6.7197D-23,   43, 'P', & !  244
     &       1295.2D0,        -1.0D0,      305.5D0,      0.0D0,     & !
     & 5.6858216800D0, -7.327436303014D-05, -7.4467D-23,   21, 'P', & !  245
     &       4719.6D0,        -9.2D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019076252D-05,  2.1637D-24,  348, 'R', & !  246
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8681271312D0, -7.326938832322D-05, -2.1637D-24,  347, 'P', & !  247
     &          0.0D0,         2.0D0,        0.0D0,      0.0D0,     & !
     & 4.5748841702D0, -7.326900119030D-05,  0.0000D+00,  346, 'R', & !  248
     &          7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 3.5033824800D0, -7.326366606808D-05, -8.1737D-23,   48, 'R', & !  249
     &       -142.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.3209432800D0, -7.325296910601D-05, -8.9007D-23,  204, 'R', & !  250
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 251, 260 ) &
     &             /                 &
     & 4.1989210622D0, -7.319483049397D-05, -2.1637D-24,  344, 'P', & !  251
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319482276786D-05, -1.0819D-24,  345, 'P', & !  252
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 5.5991726244D0, -7.317596068395D-05,  8.0170D-23,  234, 'R', & !  253
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024021325D-05,  0.0000D+00,  343, 'R', & !  254
     &        -57.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317023248714D-05,  1.0819D-24,  342, 'R', & !  255
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 4.2982121800D0, -7.316416300923D-05,  4.9685D-23,  242, 'P', & !  256
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3306219992D0, -7.315384245235D-05, -2.1637D-24,  341, 'R', & !  257
     &         -2.9D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 2.1157729800D0, -7.315346604716D-05,  4.2415D-23,  143, 'R', & !  258
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314564993252D-05,  2.1637D-24,  340, 'R', & !  259
     &        -42.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314484749322D-05, -2.1637D-24,  339, 'P', & !  260
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 261, 270 ) &
     &             /                 &
     & 0.8148125356D0, -7.314166837243D-05,  1.1929D-23,  103, 'P', & !  261
     &         94.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4080035772D0, -7.314164935261D-05,  1.5062D-23,  113, 'P', & !  262
     &       -117.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313705755854D-05, -2.1637D-24,  338, 'R', & !  263
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313288924563D-05, -2.1637D-24,  337, 'R', & !  264
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9155586428D0, -7.313097141037D-05,  4.6592D-24,   45, 'R', & !  265
     &        197.0D0,         0.0D0,    -1073.7D0,      0.0D0,     & !
     & 2.2255643772D0, -7.313095239055D-05,  7.7921D-24,   32, 'P', & !  266
     &       2779.9D0,        10.6D0,      462.6D0,      0.0D0,     & !
     & 2.7331194428D0, -7.312027444831D-05, -2.6108D-24,   10, 'R', & !  267
     &      -2438.1D0,       -23.3D0,     8072.3D0,      0.0D0,     & !
     & 0.0431251772D0, -7.312025542848D-05,  5.2215D-25,    5, 'R', & !  268
     &     160182.5D0,      1560.9D0,  -125814.5D0,      0.0D0,     & !
     & 5.4037317502D0, -7.311349817203D-05,  0.0000D+00,  336, 'R', & !  269
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1438712844D0, -7.310955846642D-05, -6.7478D-24,   27, 'R', & !  270
     &        721.7D0,        17.4D0,     -916.6D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 271, 280 ) &
     &             /                 &
     & 5.0253500400D0, -7.310845775376D-05, -2.9963D-23,   94, 'P', & !  271
     &       -216.2D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 2.6168358908D0, -7.310764063159D-05,  0.0000D+00,  335, 'R', & !  272
     &        -36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1292614902D0, -7.310347231868D-05,  0.0000D+00,  334, 'R', & !  273
     &       -118.6D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 1.9614320844D0, -7.309886150436D-05, -1.4018D-23,   96, 'R', & !  274
     &        -13.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.8429108400D0, -7.309776079169D-05, -3.7233D-23,   68, 'P', & !  275
     &       -523.8D0,       -67.7D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309568238399D-05,  0.0000D+00,  333, 'R', & !  276
     &          0.0D0,        28.0D0,        0.0D0,      0.0D0,     & !
     & 0.7039567885D0, -7.309502405067D-05,  0.0000D+00,  332, 'R', & !  277
     &         -7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 0.6604716400D0, -7.308706382963D-05, -4.4503D-23,  177, 'R', & !  278
     &          4.3D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308668742487D-05,  0.0000D+00,  331, 'R', & !  279
     &        -17.4D0,        26.0D0,        0.0D0,      0.0D0,     & !
     & 5.6426965028D0, -7.307526615490D-05, -7.4989D-23,  199, 'P', & !  280
     &         -6.3D0,        -1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 281, 290 ) &
     &             /                 &
     & 5.6215974452D0, -7.307028966397D-05, -2.1637D-24,  330, 'P', & !  281
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028193786D-05, -1.0819D-24,  329, 'P', & !  282
     &          0.0D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306988707883D-05,  2.1637D-24,  328, 'R', & !  283
     &        -22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7702630372D0, -7.306455017302D-05, -7.9126D-23,  171, 'P', & !  284
     &        -20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8710091444D0, -7.305385321095D-05, -8.6396D-23,  256, 'P', & !  285
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304570710936D-05, -1.0819D-24,  327, 'R', & !  286
     &         -2.4D0,         6.3D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569938325D-05,  0.0000D+00,  326, 'R', & !  287
     &        147.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302111682863D-05,  1.0819D-24,  325, 'R', & !  288
     &          2.4D0,        20.8D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302110910252D-05,  2.1637D-24,  324, 'R', & !  289
     &       -105.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4302945900D0, -7.302030666322D-05, -2.1637D-24,  323, 'P', & !  290
     &          0.0D0,         5.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 291, 300 ) &
     &             /                 &
     & 4.4500105990D0, -7.301439959242D-05,  0.0000D+00,  322, 'R', & !  291
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5371314966D0, -7.300178301150D-05,  0.0000D+00,  321, 'R', & !  292
     &         -7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6377405400D0, -7.299825773284D-05,  9.4188D-23,   89, 'P', & !  293
     &       -160.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299571638250D-05,  0.0000D+00,  320, 'P', & !  294
     &          0.0D0,        -8.7D0,        0.0D0,      0.0D0,     & !
     & 1.4553013400D0, -7.298756077078D-05,  8.6918D-23,   36, 'R', & !  295
     &      -1038.4D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.5560474472D0, -7.297686380872D-05,  7.9648D-23,   18, 'R', & !  296
     &      -1450.1D0,        -1.5D0,      759.6D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114155399D-05,  0.0000D+00,  318, 'R', & !  297
     &          0.0D0,        60.7D0,        0.0D0,      0.0D0,     & !
     & 3.3736082472D0, -7.296616684665D-05,  7.2378D-23,   52, 'R', & !  298
     &         17.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6836139815D0, -7.296614782683D-05,  7.5511D-23,  170, 'R', & !  299
     &        -21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9833461468D0, -7.296544075474D-05,  5.1813D-24,  317, 'R', & !  300
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 301, 310 ) &
     &             /                 &
     & 2.9435276618D0, -7.295644579561D-05,  5.1813D-24,  316, 'R', & !  301
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295474379310D-05, -2.1637D-24,  315, 'R', & !  302
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295473606699D-05, -1.0819D-24,  313, 'R', & !  303
     &         -1.0D0,        -3.1D0,        0.0D0,      0.0D0,     & !
     & 1.9424996300D0, -7.295473606678D-05, -1.0443D-24,  314, 'R', & !  304
     &         -0.5D0,         5.9D0,        0.0D0,      0.0D0,     & !
     & 2.0726478028D0, -7.295436917193D-05,  4.1893D-23,  230, 'R', & !  305
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7276506700D0, -7.295435966201D-05,  4.3459D-23,  260, 'R', & !  306
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 0.2641322928D0, -7.295324943944D-05,  2.1810D-23,  152, 'P', & !  307
     &         45.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2886217102D0, -7.294655899959D-05,  1.0443D-24,  312, 'P', & !  308
     &        -30.5D0,         5.3D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655127327D-05,  2.1637D-24,  311, 'R', & !  309
     &          0.0D0,       -56.6D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294640716729D-05, -2.1637D-24,  310, 'P', & !  310
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 311, 320 ) &
     &             /                 &
     & 3.8257582047D0, -7.294639171507D-05,  0.0000D+00,  309, 'P', & !  311
     &          7.7D0,        13.5D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574883397D-05, -2.1637D-24,  308, 'P', & !  312
     &         29.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574110786D-05, -1.0819D-24,  307, 'P', & !  313
     &         -1.5D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294573338175D-05,  0.0000D+00,  306, 'P', & !  314
     &         21.2D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 4.8283967772D0, -7.294366269995D-05,  3.6189D-23,  261, 'R', & !  315
     &          0.0D0,       114.5D0,        0.0D0,      0.0D0,     & !
     & 3.4833996444D0, -7.294365319004D-05,  3.7755D-23,   63, 'R', & !  316
     &        312.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4719551932D0, -7.294327856929D-05,  8.1737D-23,  305, 'P', & !  317
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7716873585D0, -7.294257149720D-05,  1.1407D-23,  200, 'P', & !  318
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3648784000D0, -7.294255247737D-05,  1.4540D-23,    4, 'P', & !  319
     &    -417560.6D0,      -138.8D0,    29686.1D0,      0.0D0,     & !
     & 2.6125197854D0, -7.294157656635D-05,  7.4467D-23,  304, 'R', & !  320
     &        -13.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 321, 330 ) &
     &             /                 &
     & 5.6836388102D0, -7.293795117317D-05, -1.0819D-24,  302, 'R', & !  321
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.5420461270D0, -7.293795117296D-05, -1.0443D-24,  303, 'R', & !  322
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293794344706D-05,  0.0000D+00,  301, 'R', & !  323
     &         -7.7D0,        24.1D0,        0.0D0,      0.0D0,     & !
     & 2.5420461862D0, -7.293793572117D-05,  1.0443D-24,  299, 'P', & !  324
     &         12.1D0,        42.6D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293793572095D-05,  1.0819D-24,  300, 'R', & !  325
     &          1.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 3.2933767098D0, -7.293721735515D-05, -6.7197D-23,  298, 'P', & !  326
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2477751934D0, -7.293585431163D-05, -5.1813D-24,  297, 'P', & !  327
     &          1.9D0,       -98.2D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293468436029D-05, -1.0819D-24,  294, 'R', & !  328
     &         -2.5D0,        -4.9D0,        0.0D0,      0.0D0,     & !
     & 1.3935591100D0, -7.293468436008D-05, -1.0443D-24,  295, 'R', & !  329
     &          2.5D0,         3.9D0,        0.0D0,      0.0D0,     & !
     & 5.0544717264D0, -7.293378286006D-05, -1.0443D-24,  293, 'R', & !  330
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 331, 340 ) &
     &             /                 &
     & 1.9128791024D0, -7.293377513416D-05,  0.0000D+00,  292, 'P', & !  331
     &         44.4D0,        42.4D0,        0.0D0,      0.0D0,     & !
     & 5.0544717855D0, -7.293376740826D-05,  1.0443D-24,  291, 'P', & !  332
     &        -62.4D0,        17.4D0,        0.0D0,      0.0D0,     & !
     & 2.6459575772D0, -7.293296573789D-05,  2.8919D-23,  262, 'R', & !  333
     &          0.0D0,        -8.9D0,        0.0D0,      0.0D0,     & !
     & 1.3009604444D0, -7.293295622798D-05,  3.0486D-23,   72, 'R', & !  334
     &        -37.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8515650132D0, -7.293268885905D-05,  7.2699D-24,  290, 'P', & !  335
     &          3.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 0.5556208067D0, -7.293258472066D-05,  3.8800D-23,  289, 'P', & !  336
     &         -5.8D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 4.5727013004D0, -7.293258160722D-05,  7.4467D-23,  288, 'R', & !  337
     &        -42.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2946337162D0, -7.293208093001D-05,  7.2699D-24,  287, 'P', & !  338
     &          6.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.3494097933D0, -7.293196715751D-05,  7.2699D-24,  286, 'P', & !  339
     &         17.4D0,        66.7D0,        0.0D0,      0.0D0,     & !
     & 4.8724334656D0, -7.293187453513D-05,  4.1370D-24,   71, 'R', & !  340
     &         41.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 341, 350 ) &
     &             /                 &
     & 2.1824392000D0, -7.293185551531D-05,  7.2699D-24,    1, 'P', & !  341
     &   38905342.7D0,      7219.3D0,  6002929.4D0,      0.0D0,     & !
     & 5.2986539139D0, -7.293174387311D-05,  7.2699D-24,  285, 'P', & !  342
     &        -17.4D0,        67.7D0,        0.0D0,      0.0D0,     & !
     & 5.3534299910D0, -7.293163010061D-05,  7.2699D-24,  284, 'P', & !  343
     &         -7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 3.8092575933D0, -7.293112630996D-05, -2.4260D-23,  283, 'P', & !  344
     &          6.7D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 4.7964986940D0, -7.293102217157D-05,  7.2699D-24,  282, 'P', & !  345
     &         -4.8D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292792531982D-05, -1.0819D-24,  280, 'R', & !  346
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2675758670D0, -7.292792531961D-05, -1.0443D-24,  281, 'R', & !  347
     &         -6.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292791759371D-05,  0.0000D+00,  279, 'R', & !  348
     &          1.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 2.2675759262D0, -7.292790986781D-05,  1.0443D-24,  278, 'P', & !  349
     &        -38.2D0,        17.4D0,        0.0D0,      0.0D0,     & !
     & 3.5011996102D0, -7.292724648500D-05, -7.2699D-24,  277, 'R', & !  350
     &          1.9D0,        -6.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 351, 360 ) &
     &             /                 &
     & 0.3596069862D0, -7.292723875910D-05, -6.2256D-24,  276, 'R', & !  351
     &         -1.9D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 2.2863506502D0, -7.292687008024D-05,  3.7233D-23,  275, 'R', & !  352
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1109375098D0, -7.292652039309D-05, -7.4467D-23,  274, 'P', & !  353
     &         33.7D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 1.0715016902D0, -7.292649367547D-05,  8.1737D-23,  273, 'P', & !  354
     &        -20.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292608352603D-05,  0.0000D+00,  272, 'R', & !  355
     &          4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 4.4317540428D0, -7.292531536865D-05, -7.4467D-23,  271, 'P', & !  356
     &         -7.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 0.0653359934D0, -7.292515734957D-05, -1.2451D-23,  270, 'R', & !  357
     &          0.0D0,        22.2D0,        0.0D0,      0.0D0,     & !
     & 5.3574696750D0, -7.292323696095D-05, -3.7233D-23,  269, 'P', & !  358
     &          0.0D0,        12.5D0,        0.0D0,      0.0D0,     & !
     & 6.0136252095D0, -7.292307817210D-05, -7.2699D-24,  268, 'R', & !  359
     &         16.2D0,        14.3D0,        0.0D0,      0.0D0,     & !
     & 2.8720325855D0, -7.292307044620D-05, -6.2256D-24,  267, 'R', & !  360
     &         26.0D0,        -7.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 361, 370 ) &
     &             /                 &
     & 0.4635183772D0, -7.292226877582D-05,  2.1649D-23,  263, 'R', & !  361
     &          0.0D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 5.4017065515D0, -7.292225926591D-05,  2.3216D-23,  108, 'R', & !  362
     &          5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5275331892D0, -7.292198417109D-05,  1.0443D-24,  266, 'P', & !  363
     &       -270.8D0,       135.4D0,        0.0D0,      0.0D0,     & !
     & 4.6563669139D0, -7.292188775860D-05,  3.1530D-23,  265, 'R', & !  364
     &         22.2D0,         9.6D0,        0.0D0,      0.0D0,     & !
     & 2.3902621004D0, -7.292188464516D-05,  6.7197D-23,  264, 'R', & !  365
     &         -9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8929232068D0, -7.292043246133D-05, -6.7197D-23,  264, 'P', & !  366
     &        -63.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6268183933D0, -7.292042934790D-05, -3.1530D-23,  265, 'P', & !  367
     &        -22.2D0,         9.6D0,        0.0D0,      0.0D0,     & !
     & 5.7556521180D0, -7.292033293541D-05, -1.0443D-24,  266, 'R', & !  368
     &        -39.4D0,       -19.7D0,        0.0D0,      0.0D0,     & !
     & 0.8814787556D0, -7.292005784058D-05, -2.3216D-23,  108, 'P', & !  369
     &        105.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196669300D0, -7.292004833067D-05, -2.1649D-23,  263, 'P', & !  370
     &          0.0D0,        -5.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 371, 380 ) &
     &             /                 &
     & 3.4111527216D0, -7.291924666030D-05,  6.2256D-24,  267, 'P', & !  371
     &        -26.0D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 0.2695600976D0, -7.291923893440D-05,  7.2699D-24,  268, 'P', & !  372
     &        105.0D0,       -97.2D0,        0.0D0,      0.0D0,     & !
     & 0.9257156322D0, -7.291908014555D-05,  3.7233D-23,  269, 'R', & !  373
     &          0.0D0,        12.5D0,        0.0D0,      0.0D0,     & !
     & 6.2178493138D0, -7.291715975693D-05,  1.2451D-23,  270, 'P', & !  374
     &          0.0D0,        22.2D0,        0.0D0,      0.0D0,     & !
     & 1.8514312644D0, -7.291700173785D-05,  7.4467D-23,  271, 'R', & !  375
     &          7.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291623358046D-05,  0.0000D+00,  272, 'P', & !  376
     &         -4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 5.2116836170D0, -7.291582343102D-05, -8.1737D-23,  273, 'R', & !  377
     &         -3.4D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 5.1722477974D0, -7.291579671341D-05,  7.4467D-23,  274, 'R', & !  378
     &        -33.7D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 3.9968346570D0, -7.291544702626D-05, -3.7233D-23,  275, 'P', & !  379
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9235783210D0, -7.291507834739D-05,  6.2256D-24,  276, 'P', & !  380
     &          1.9D0,        -7.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 381, 390 ) &
     &             /                 &
     & 2.7819856970D0, -7.291507062149D-05,  7.2699D-24,  277, 'P', & !  381
     &         -1.9D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.0156093810D0, -7.291440723868D-05, -1.0443D-24,  278, 'R', & !  382
     &         -5.4D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439951278D-05,  0.0000D+00,  279, 'P', & !  383
     &         -1.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 4.0156094402D0, -7.291439178688D-05,  1.0443D-24,  281, 'P', & !  384
     &          6.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439178667D-05,  1.0819D-24,  280, 'P', & !  385
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4866866132D0, -7.291129493492D-05, -7.2699D-24,  282, 'R', & !  386
     &          4.8D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 2.4739277139D0, -7.291119079654D-05,  2.4260D-23,  283, 'R', & !  387
     &         -6.7D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.9297553162D0, -7.291068700588D-05, -7.2699D-24,  284, 'R', & !  388
     &          7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.9845313933D0, -7.291057323338D-05, -7.2699D-24,  285, 'R', & !  389
     &         -2.0D0,        -9.9D0,        0.0D0,      0.0D0,     & !
     & 4.1007461072D0, -7.291046159118D-05, -7.2699D-24,    1, 'R', & !  390
     &    5723443.8D0,      -261.4D0, -4641783.6D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 391, 400 ) &
     &             /                 &
     & 1.4107518415D0, -7.291044257136D-05, -4.1370D-24,   71, 'P', & !  391
     &        292.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9337755139D0, -7.291034994898D-05, -7.2699D-24,  286, 'R', & !  392
     &          2.0D0,       -10.8D0,        0.0D0,      0.0D0,     & !
     & 0.9885515910D0, -7.291023617649D-05, -7.2699D-24,  287, 'R', & !  393
     &         -6.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.7104840068D0, -7.290973549927D-05, -7.4467D-23,  288, 'P', & !  394
     &         42.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7275645005D0, -7.290973238583D-05, -3.8800D-23,  289, 'R', & !  395
     &          5.8D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.4316202940D0, -7.290962824744D-05, -7.2699D-24,  290, 'R', & !  396
     &         -3.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 4.9822248628D0, -7.290936087852D-05, -3.0486D-23,   72, 'P', & !  397
     &       -292.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6372277300D0, -7.290935136861D-05, -2.8919D-23,  262, 'P', & !  398
     &          0.0D0,        78.3D0,        0.0D0,      0.0D0,     & !
     & 1.2287135216D0, -7.290854969823D-05, -1.0443D-24,  291, 'R', & !  399
     &        -10.3D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290854197233D-05,  0.0000D+00,  292, 'R', & !  400
     &        -44.4D0,        42.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 401, 410 ) &
     &             /                 &
     & 1.2287135808D0, -7.290853424644D-05,  1.0443D-24,  293, 'P', & !  401
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 4.8896261972D0, -7.290763274642D-05,  1.0443D-24,  295, 'P', & !  402
     &         12.1D0,       -25.2D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290763274621D-05,  1.0819D-24,  294, 'P', & !  403
     &        -12.1D0,        24.2D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290762502010D-05,  2.1637D-24,  296, 'P', & !  404
     &         23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0354101138D0, -7.290646279486D-05,  5.1813D-24,  297, 'R', & !  405
     &         -1.9D0,        13.3D0,        0.0D0,      0.0D0,     & !
     & 2.9898085974D0, -7.290509975135D-05,  6.7197D-23,  298, 'R', & !  406
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290438138554D-05, -1.0819D-24,  300, 'P', & !  407
     &         -1.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 3.7411391210D0, -7.290438138533D-05, -1.0443D-24,  299, 'R', & !  408
     &          2.5D0,        -5.9D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290437365943D-05,  0.0000D+00,  301, 'P', & !  409
     &          7.7D0,        24.1D0,        0.0D0,      0.0D0,     & !
     & 3.7411391802D0, -7.290436593353D-05,  1.0443D-24,  303, 'P', & !  410
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 411, 420 ) &
     &             /                 &
     & 0.5995464970D0, -7.290436593332D-05,  1.0819D-24,  302, 'P', & !  411
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6706655218D0, -7.290074054014D-05, -7.4467D-23,  304, 'P', & !  412
     &         13.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9183069072D0, -7.289976462912D-05, -1.4540D-23,    4, 'R', & !  413
     &     -17540.3D0,         1.8D0,    42519.2D0,      0.0D0,     & !
     & 5.5114979487D0, -7.289974560930D-05, -1.1407D-23,  200, 'R', & !  414
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8112301140D0, -7.289903853721D-05, -8.1737D-23,  305, 'R', & !  415
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7997856628D0, -7.289866391646D-05, -3.7755D-23,   63, 'P', & !  416
     &       -317.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4547885300D0, -7.289865440654D-05, -3.6189D-23,  261, 'P', & !  417
     &          0.0D0,      -317.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289658372474D-05,  0.0000D+00,  306, 'R', & !  418
     &        -21.2D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289657599863D-05,  1.0819D-24,  307, 'R', & !  419
     &         -3.4D0,       -14.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289656827252D-05,  2.1637D-24,  308, 'R', & !  420
     &        436.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 421, 430 ) &
     &             /                 &
     & 2.4574271025D0, -7.289592539142D-05,  0.0000D+00,  309, 'R', & !  421
     &         -7.7D0,        13.5D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289590993920D-05,  2.1637D-24,  310, 'R', & !  422
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289576583322D-05, -2.1637D-24,  311, 'P', & !  423
     &          0.0D0,         6.4D0,        0.0D0,      0.0D0,     & !
     & 4.9945635970D0, -7.289575810690D-05, -1.0443D-24,  312, 'R', & !  424
     &         -3.5D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.0190530144D0, -7.288906766706D-05, -2.1810D-23,  152, 'R', & !  425
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5555346372D0, -7.288795744448D-05, -4.3459D-23,  260, 'P', & !  426
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 4.2105375044D0, -7.288794793457D-05, -4.1893D-23,  230, 'P', & !  427
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3406856772D0, -7.288758103972D-05,  1.0443D-24,  314, 'P', & !  428
     &          5.3D0,       -32.9D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758103950D-05,  1.0819D-24,  313, 'P', & !  429
     &         -8.7D0,        55.1D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288757331339D-05,  2.1637D-24,  315, 'P', & !  430
     &        235.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 431, 440 ) &
     &             /                 &
     & 3.3396576454D0, -7.288587131088D-05, -5.1813D-24,  316, 'P', & !  431
     &        -26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2998391604D0, -7.287687635176D-05, -5.1813D-24,  317, 'P', & !  432
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5995713256D0, -7.287616927966D-05, -7.5511D-23,  170, 'P', & !  433
     &         21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9095770600D0, -7.287615025984D-05, -7.2378D-23,   52, 'P', & !  434
     &        617.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287117555250D-05,  0.0000D+00,  318, 'P', & !  435
     &          0.0D0,        60.7D0,        0.0D0,      0.0D0,     & !
     & 1.7986394910D0, -7.287078841958D-05,  2.1637D-24,  319, 'P', & !  436
     &         23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7271378600D0, -7.286545329778D-05, -7.9648D-23,   18, 'P', & !  437
     &     -10301.8D0,         3.4D0,    -2295.9D0,      0.0D0,     & !
     & 4.8278839672D0, -7.285475633571D-05, -8.6918D-23,   36, 'P', & !  438
     &       1086.8D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284660072400D-05,  0.0000D+00,  320, 'R', & !  439
     &          0.0D0,        -8.7D0,        0.0D0,      0.0D0,     & !
     & 2.6454447672D0, -7.284405937365D-05, -9.4188D-23,   89, 'R', & !  440
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 441, 450 ) &
     &             /                 &
     & 3.7460538105D0, -7.284053409499D-05,  0.0000D+00,  321, 'P', & !  441
     &          7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 1.8331747082D0, -7.282791751408D-05,  0.0000D+00,  322, 'P', & !  442
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8528907172D0, -7.282201044327D-05,  2.1637D-24,  323, 'R', & !  443
     &          0.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120800397D-05, -2.1637D-24,  324, 'P', & !  444
     &         -5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120027786D-05, -1.0819D-24,  325, 'P', & !  445
     &          2.4D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279661772325D-05,  0.0000D+00,  326, 'P', & !  446
     &       -147.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279660999714D-05,  1.0819D-24,  327, 'P', & !  447
     &         -2.4D0,       -17.9D0,        0.0D0,      0.0D0,     & !
     & 1.4121761628D0, -7.278846389554D-05,  8.6396D-23,  256, 'R', & !  448
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5129222700D0, -7.277776693348D-05,  7.9126D-23,  171, 'R', & !  449
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277243002767D-05, -2.1637D-24,  328, 'P', & !  450
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 451, 460 ) &
     &             /                 &
     & 0.6615878620D0, -7.277203516863D-05,  1.0819D-24,  329, 'R', & !  451
     &          0.0D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277202744252D-05,  2.1637D-24,  330, 'R', & !  452
     &         93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6404888044D0, -7.276705095159D-05,  7.4989D-23,  199, 'R', & !  453
     &         11.1D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.5543773200D0, -7.275562968163D-05,  0.0000D+00,  331, 'P', & !  454
     &         17.4D0,        26.0D0,        0.0D0,      0.0D0,     & !
     & 5.6227136672D0, -7.275525327686D-05,  4.4503D-23,  177, 'P', & !  455
     &        -28.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.5792285187D0, -7.274729305582D-05,  0.0000D+00,  332, 'P', & !  456
     &          7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274663472250D-05,  0.0000D+00,  333, 'P', & !  457
     &          0.0D0,        28.0D0,        0.0D0,      0.0D0,     & !
     & 3.4402744672D0, -7.274455631480D-05,  3.7233D-23,   68, 'R', & !  458
     &        257.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.3217532228D0, -7.274345560214D-05,  1.4018D-23,   96, 'P', & !  459
     &       -146.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273884478781D-05,  0.0000D+00,  334, 'P', & !  460
     &        118.6D0,        -2.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 461, 470 ) &
     &             /                 &
     & 3.6663494164D0, -7.273467647491D-05,  0.0000D+00,  335, 'P', & !  461
     &         36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2578352672D0, -7.273385935274D-05,  2.9963D-23,   94, 'R', & !  462
     &        -21.4D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.1393140228D0, -7.273275864007D-05,  6.7478D-24,   27, 'P', & !  463
     &       3433.1D0,        -2.0D0,      916.6D0,      0.0D0,     & !
     & 0.8794535570D0, -7.272881893446D-05,  0.0000D+00,  336, 'P', & !  464
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2400601300D0, -7.272206167801D-05, -5.2215D-25,    5, 'P', & !  465
     &    -124354.8D0,       600.9D0,    96625.1D0,      0.0D0,     & !
     & 3.5500658644D0, -7.272204265819D-05,  2.6108D-24,   10, 'P', & !  466
     &     -44060.4D0,        34.9D0,    38016.1D0,      0.0D0,     & !
     & 4.0576209300D0, -7.271136471595D-05, -7.7921D-24,   32, 'R', & !  467
     &        332.6D0,         0.9D0,     1073.7D0,      0.0D0,     & !
     & 1.3676266644D0, -7.271134569612D-05, -4.6592D-24,   45, 'P', & !  468
     &       1116.9D0,         0.0D0,     -462.6D0,      0.0D0,     & !
     & 6.1237765188D0, -7.270942786086D-05,  2.1637D-24,  337, 'P', & !  469
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270525954796D-05,  2.1637D-24,  338, 'P', & !  470
     &         50.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 471, 480 ) &
     &             /                 &
     & 1.8751817300D0, -7.270066775388D-05, -1.5062D-23,  113, 'R', & !  471
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4683727715D0, -7.270064873406D-05, -1.1929D-23,  103, 'R', & !  472
     &        -79.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269746961327D-05,  2.1637D-24,  339, 'R', & !  473
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269666717397D-05, -2.1637D-24,  340, 'P', & !  474
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1674123272D0, -7.268885105933D-05, -4.2415D-23,  143, 'P', & !  475
     &         56.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9525633080D0, -7.268847465414D-05,  2.1637D-24,  341, 'P', & !  476
     &          2.9D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 1.9849731272D0, -7.267815409727D-05, -4.9685D-23,  242, 'R', & !  477
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267208461936D-05, -1.0819D-24,  342, 'P', & !  478
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267207689325D-05,  0.0000D+00,  343, 'P', & !  479
     &         57.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6840126828D0, -7.266635642254D-05, -8.0170D-23,  234, 'P', & !  480
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 481, 490 ) &
     &             /                 &
     & 2.0842642450D0, -7.264749433863D-05,  1.0819D-24,  345, 'R', & !  481
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264748661252D-05,  2.1637D-24,  344, 'R', & !  482
     &        -22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9622420272D0, -7.258934800048D-05,  8.9007D-23,  204, 'P', & !  483
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7798028272D0, -7.257865103842D-05,  8.1737D-23,   48, 'P', & !  484
     &       -923.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.7083011370D0, -7.257331591619D-05,  0.0000D+00,  346, 'P', & !  485
     &         -7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257292878327D-05,  2.1637D-24,  347, 'R', & !  486
     &          0.0D0,       -27.1D0,        0.0D0,      0.0D0,     & !
     & 0.5973636272D0, -7.256795407635D-05,  7.4467D-23,   21, 'R', & !  487
     &      -4486.9D0,         5.3D0,        0.0D0,      0.0D0,     & !
     & 4.6981097344D0, -7.255725711429D-05,  6.7197D-23,   43, 'R', & !  488
     &        178.6D0,        -1.0D0,     -305.5D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255653102238D-05,  0.0000D+00,  349, 'P', & !  489
     &        -37.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254753606325D-05,  0.0000D+00,  350, 'P', & !  490
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 491, 500 ) &
     &             /                 &
     & 4.2680291490D0, -7.254752061103D-05,  2.1637D-24,  351, 'P', & !  491
     &         -4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.5156705344D0, -7.254656015223D-05,  5.9927D-23,  169, 'R', & !  492
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253973067634D-05,  2.1637D-24,  352, 'P', & !  493
     &         31.4D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 5.4198197304D0, -7.253556236344D-05,  2.1637D-24,  353, 'P', & !  494
     &         -7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 2.0961888456D0, -7.253366176483D-05,  6.2256D-24,  188, 'P', & !  495
     &         20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6893798872D0, -7.253364274501D-05,  9.3585D-24,   87, 'P', & !  496
     &       -167.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8928811340D0, -7.252377912626D-05,  2.1637D-24,  354, 'R', & !  497
     &        -13.1D0,       -19.3D0,        0.0D0,      0.0D0,     & !
     & 0.3907259141D0, -7.252305742472D-05,  2.1637D-24,  355, 'P', & !  498
     &        -23.7D0,       -84.1D0,        0.0D0,      0.0D0,     & !
     & 6.1969349528D0, -7.252296480277D-05, -1.0443D-24,   34, 'P', & !  499
     &      -1577.3D0,         1.5D0,     2444.4D0,      0.0D0,     & !
     & 3.5069406872D0, -7.252294578295D-05,  2.0886D-24,    2, 'P', & !  500
     &    2659051.5D0,     -2470.3D0,  -187385.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 501, 510 ) &
     &             /                 &
     & 3.5069406280D0, -7.252294578252D-05,  2.1637D-24,  356, 'P', & !  501
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3399700347D0, -7.252283414032D-05,  2.1637D-24,  357, 'R', & !  502
     &         23.7D0,       -84.1D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252211243878D-05,  2.1637D-24,  358, 'P', & !  503
     &         37.3D0,       -19.3D0,        0.0D0,      0.0D0,     & !
     & 4.0144957528D0, -7.251226784071D-05, -8.3142D-24,  239, 'R', & !  504
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3245014872D0, -7.251224882088D-05, -5.1813D-24,   11, 'P', & !  505
     &     -29080.3D0,        27.1D0,    -5045.8D0,      0.0D0,     & !
     & 1.5940615256D0, -7.251032920161D-05,  2.1637D-24,  359, 'P', & !  506
     &          7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.1064871250D0, -7.250616088871D-05,  2.1637D-24,  360, 'P', & !  507
     &        -33.4D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4252475944D0, -7.250155185882D-05, -1.2451D-23,   30, 'R', & !  508
     &       2063.8D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 2.7458521070D0, -7.249837095402D-05,  2.1637D-24,  361, 'R', & !  509
     &          6.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.2428083944D0, -7.249085489676D-05, -1.9721D-23,   85, 'R', & !  510
     &        -22.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 511, 520 ) &
     &             /                 &
     & 4.5988230800D0, -7.247296278178D-05,  2.1637D-24,  362, 'P', & !  511
     &          0.0D0,       -35.8D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244758551397D-05, -2.1637D-24,  363, 'P', & !  512
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242299523325D-05,  0.0000D+00,  364, 'P', & !  513
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239840495252D-05,  2.1637D-24,  365, 'P', & !  514
     &         60.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7366776500D0, -7.237955416318D-05,  8.1214D-23,  223, 'P', & !  515
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5542384500D0, -7.236885720112D-05,  7.3944D-23,   92, 'R', & !  516
     &       -108.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6549845572D0, -7.235816023905D-05,  6.6675D-23,  181, 'R', & !  517
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0613179480D0, -7.235741691090D-05,  2.1637D-24,  366, 'P', & !  518
     &        -14.0D0,       -18.4D0,        0.0D0,      0.0D0,     & !
     & 6.0214994630D0, -7.234842195178D-05,  2.1637D-24,  367, 'P', & !  519
     &          0.0D0,       -22.7D0,        0.0D0,      0.0D0,     & !
     & 0.6640298472D0, -7.234634354450D-05,  3.9322D-23,  241, 'P', & !  520
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 521, 530 ) &
     &             /                 &
     & 4.6608644450D0, -7.234063201709D-05,  2.1637D-24,  368, 'P', & !  521
     &       -103.5D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.8901047372D0, -7.233646370418D-05,  2.1637D-24,  369, 'P', & !  522
     &        -28.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4638155100D0, -7.232384890771D-05,  1.5665D-24,    6, 'P', & !  523
     &     104234.7D0,       -95.7D0,   -89816.1D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232304468397D-05, -2.1637D-24,  370, 'P', & !  524
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2813763100D0, -7.231315194565D-05, -5.7035D-24,   50, 'P', & !  525
     &       -818.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.3821224172D0, -7.230245498358D-05, -1.2973D-23,  120, 'R', & !  526
     &         63.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229845440325D-05,  0.0000D+00,  371, 'P', & !  527
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227386412252D-05,  2.1637D-24,  372, 'P', & !  528
     &        -78.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9218651144D0, -7.215904434399D-05,  6.9285D-23,  192, 'P', & !  529
     &        -21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8147882620D0, -7.215831825165D-05,  2.1637D-24,  373, 'P', & !  530
     &         36.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 531, 540 ) &
     &             /                 &
     & 3.4206903328D0, -7.212475203247D-05,  1.0443D-24,   29, 'P', & !  531
     &       3182.1D0,        -4.4D0,    -5211.4D0,      0.0D0,     & !
     & 1.2382511328D0, -7.211405507041D-05, -6.2256D-24,  189, 'P', & !  532
     &        -19.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3775651556D0, -7.192565515723D-05,  5.2215D-25,  119, 'P', & !  533
     &         88.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6161299856D0, -7.105476667142D-05, -3.0486D-23,  227, 'P', & !  534
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4336907856D0, -7.104406970936D-05, -3.7755D-23,  110, 'R', & !  535
     &         12.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5344368928D0, -7.103337274729D-05, -4.5025D-23,  218, 'R', & !  536
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8444426272D0, -7.103335372747D-05, -4.1893D-23,  165, 'P', & !  537
     &        -26.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1608286456D0, -7.098836445389D-05, -1.1740D-22,  197, 'P', & !  538
     &        -15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0741795900D0, -7.088996210770D-05,  3.7233D-23,  195, 'R', & !  539
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9837566500D0, -7.084495381429D-05, -3.5145D-23,   91, 'P', & !  540
     &       -166.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 541, 550 ) &
     &             /                 &
     & 1.8013174500D0, -7.083425685223D-05, -4.2415D-23,   47, 'P', & !  541
     &       -720.8D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.9020635572D0, -7.082355989017D-05, -4.9685D-23,   99, 'R', & !  542
     &         18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6011031128D0, -7.081176221544D-05, -8.0170D-23,  253, 'P', & !  543
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2134936128D0, -7.070156219453D-05,  4.3981D-23,  126, 'P', & !  544
     &         55.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0310544128D0, -7.069086523246D-05,  3.6711D-23,   66, 'R', & !  545
     &         67.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.1318005200D0, -7.068016827040D-05,  2.9441D-23,  132, 'R', & !  546
     &         -4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4418062544D0, -7.068014925058D-05,  3.2574D-23,  221, 'P', & !  547
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1230706728D0, -7.065655390112D-05, -2.8397D-23,  129, 'P', & !  548
     &         77.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9406314728D0, -7.064585693906D-05, -3.5667D-23,   28, 'P', & !  549
     &      -3404.4D0,         1.0D0,     -305.5D0,      0.0D0,     & !
     & 1.7581922728D0, -7.063515997699D-05, -4.2937D-23,   13, 'P', & !  550
     &     -15446.4D0,         3.5D0,     -305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 551, 560 ) &
     &             /                 &
     & 5.8589383800D0, -7.062446301493D-05, -5.0207D-23,   31, 'R', & !  551
     &        442.3D0,         1.0D0,     -305.5D0,      0.0D0,     & !
     & 3.6764991800D0, -7.061376605287D-05, -5.7477D-23,  137, 'R', & !  552
     &         -3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5811202772D0, -7.049174933740D-05,  3.9322D-23,  102, 'P', & !  553
     &       -114.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3986810772D0, -7.048105237534D-05,  3.2052D-23,   51, 'P', & !  554
     &       -463.9D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2162418772D0, -7.047035541327D-05,  2.4782D-23,  133, 'R', & !  555
     &         11.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0977206328D0, -7.046925470061D-05,  1.5665D-24,  121, 'P', & !  556
     &         84.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1984667400D0, -7.045855773855D-05, -5.7035D-24,   57, 'P', & !  557
     &        414.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.0160275400D0, -7.044786077648D-05, -1.2973D-23,  130, 'R', & !  558
     &        -11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8975062956D0, -7.044676006382D-05, -3.6189D-23,  185, 'P', & !  559
     &         24.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7150670956D0, -7.043606310176D-05, -4.3459D-23,  100, 'P', & !  560
     &         90.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 561, 570 ) &
     &             /                 &
     & 5.3082581372D0, -7.043604408193D-05, -4.0326D-23,  180, 'P', & !  561
     &         30.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8158132028D0, -7.042536613969D-05, -5.0729D-23,  244, 'R', & !  562
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1258189372D0, -7.042534711987D-05, -4.7596D-23,  251, 'P', & !  563
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6284180400D0, -7.033766075557D-05,  1.1118D-22,  235, 'R', & !  564
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4372489928D0, -7.030334942423D-05,  4.6070D-23,   67, 'P', & !  565
     &        396.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5379951000D0, -7.029265246216D-05,  3.8800D-23,   14, 'P', & !  566
     &     -14143.4D0,         0.5D0,    -1833.3D0,      0.0D0,     & !
     & 2.3555559000D0, -7.028195550010D-05,  3.1530D-23,    7, 'P', & !  567
     &     -70240.1D0,         0.0D0,    -2138.8D0,      0.0D0,     & !
     & 0.1731167000D0, -7.027125853804D-05,  2.4260D-23,   15, 'R', & !  568
     &       2024.3D0,         1.1D0,    -1833.3D0,      0.0D0,     & !
     & 1.0545954556D0, -7.027015782537D-05,  1.0443D-24,  236, 'P', & !  569
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2738628072D0, -7.026056157597D-05,  1.6990D-23,   75, 'R', & !  570
     &        -11.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 571, 580 ) &
     &             /                 &
     & 5.1553415628D0, -7.025946086331D-05, -6.2256D-24,  125, 'P', & !  571
     &        -55.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8103444300D0, -7.025945135340D-05, -4.6592D-24,  259, 'P', & !  572
     &          0.0D0,       -49.4D0,        0.0D0,      0.0D0,     & !
     & 2.4653472972D0, -7.025944184348D-05, -3.0927D-24,  202, 'P', & !  573
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6279052300D0, -7.024875439133D-05, -1.1929D-23,  258, 'P', & !  574
     &          0.0D0,         7.7D0,        0.0D0,      0.0D0,     & !
     & 1.6719419185D0, -7.023696622652D-05, -4.3981D-23,  229, 'P', & !  575
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2651329600D0, -7.023694720669D-05, -4.0848D-23,   12, 'P', & !  576
     &     -24838.8D0,        -1.5D0,     1998.9D0,      0.0D0,     & !
     & 3.0826937600D0, -7.022625024463D-05, -4.8118D-23,   24, 'P', & !  577
     &      -4579.2D0,         1.0D0,     -611.1D0,      0.0D0,     & !
     & 0.9002545600D0, -7.021555328257D-05, -5.5388D-23,   58, 'P', & !  578
     &        399.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.0010006672D0, -7.020485632050D-05, -6.2658D-23,  142, 'R', & !  579
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4948699228D0, -7.009355558693D-05,  3.8278D-23,  127, 'P', & !  580
     &         78.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 581, 590 ) &
     &             /                 &
     & 2.3124307228D0, -7.008285862486D-05,  3.1008D-23,   64, 'P', & !  581
     &        335.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9056217644D0, -7.008283960504D-05,  3.4141D-23,  220, 'P', & !  582
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1299915228D0, -7.007216166280D-05,  2.3738D-23,  150, 'R', & !  583
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4222221200D0, -7.006034496825D-05, -3.6149D-24,   97, 'P', & !  584
     &        146.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2397829200D0, -7.004964800618D-05, -1.0885D-23,  187, 'P', & !  585
     &         21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2220077828D0, -7.003785033146D-05, -4.1370D-23,  118, 'P', & !  586
     &        -93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0395685828D0, -7.002715336939D-05, -4.8640D-23,  194, 'P', & !  587
     &        -20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8624965872D0, -6.988374272980D-05,  3.3618D-23,   23, 'P', & !  588
     &      -5751.9D0,         0.0D0,      768.1D0,      0.0D0,     & !
     & 3.6800573872D0, -6.987304576774D-05,  2.6349D-23,   41, 'P', & !  589
     &      -1303.4D0,         0.0D0,     -305.5D0,      0.0D0,     & !
     & 1.4976181872D0, -6.986234880567D-05,  1.9079D-23,  111, 'R', & !  590
     &         74.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 591, 600 ) &
     &             /                 &
     & 4.4071952472D0, -6.981734051227D-05, -5.3299D-23,  209, 'P', & !  591
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8193714100D0, -6.968464585456D-05,  3.3096D-23,   76, 'P', & !  592
     &       -256.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6369322100D0, -6.967394889250D-05,  2.5826D-23,  144, 'P', & !  593
     &        -51.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5595097228D0, -6.854825827598D-05, -8.5351D-23,  211, 'P', & !  594
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7892466856D0, -6.840486665621D-05, -6.2256D-24,  163, 'R', & !  595
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1999985272D0, -6.839415067432D-05, -1.0363D-23,  176, 'P', & !  596
     &        -20.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6988237456D0, -6.835985836280D-05, -7.8604D-23,  186, 'P', & !  597
     &        -25.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5163845456D0, -6.834916140074D-05, -8.5874D-23,   90, 'P', & !  598
     &       -121.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3339453456D0, -6.833846443868D-05, -9.3144D-23,  191, 'R', & !  599
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0561272428D0, -6.820575076115D-05, -3.6149D-24,  167, 'P', & !  600
     &         30.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 601, 610 ) &
     &             /                 &
     & 4.1568733500D0, -6.819505379908D-05, -1.0885D-23,   54, 'P', & !  601
     &       -441.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.9744341500D0, -6.818435683702D-05, -1.8155D-23,  131, 'R', & !  602
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6734737056D0, -6.817255916229D-05, -4.8640D-23,  208, 'P', & !  603
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7832651028D0, -6.815004550568D-05, -8.3263D-23,  257, 'P', & !  604
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3866103128D0, -6.805166217932D-05,  6.8241D-23,  231, 'R', & !  605
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1954412656D0, -6.801735084797D-05,  3.1329D-24,  116, 'P', & !  606
     &         92.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0130020656D0, -6.800665388591D-05, -4.1370D-24,   40, 'P', & !  607
     &       1401.1D0,         0.0D0,      305.5D0,      0.0D0,     & !
     & 4.1137481728D0, -6.799595692385D-05, -1.1407D-23,   19, 'P', & !  608
     &      -6412.4D0,        -8.2D0,     -305.5D0,      0.0D0,     & !
     & 1.4237539072D0, -6.799593790402D-05, -8.2741D-24,  215, 'P', & !  609
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9313089728D0, -6.798525996178D-05, -1.8677D-23,   46, 'R', & !  610
     &        184.0D0,         0.5D0,     -305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 611, 620 ) &
     &             /                 &
     & 0.7401399256D0, -6.795094863044D-05, -8.3785D-23,   74, 'P', & !  611
     &       -279.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8408860328D0, -6.794025166838D-05, -9.1055D-23,  151, 'P', & !  612
     &        -47.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6584468328D0, -6.792955470631D-05, -9.8325D-23,  255, 'P', & !  613
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7542369772D0, -6.784184932219D-05,  6.3582D-23,  149, 'P', & !  614
     &        -36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2708373328D0, -6.781935468540D-05,  2.5826D-23,  157, 'P', & !  615
     &         31.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2530621956D0, -6.780755701067D-05, -4.6592D-24,  156, 'P', & !  616
     &        -39.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0706229956D0, -6.779686004861D-05, -1.1929D-23,  117, 'P', & !  617
     &         64.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3806287300D0, -6.779684102878D-05, -8.7962D-24,   39, 'P', & !  618
     &       1432.7D0,         1.0D0,      925.2D0,      0.0D0,     & !
     & 1.8881837956D0, -6.778616308654D-05, -1.9199D-23,  238, 'R', & !  619
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4813748372D0, -6.778614406672D-05, -1.6066D-23,   93, 'P', & !  620
     &        148.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 621, 630 ) &
     &             /                 &
     & 4.1804143928D0, -6.777434639199D-05, -4.6552D-23,  225, 'P', & !  621
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7928048928D0, -6.766414637108D-05,  7.7600D-23,  222, 'P', & !  622
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6103656928D0, -6.765344940902D-05,  7.0330D-23,   62, 'P', & !  623
     &       -486.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7111118000D0, -6.764275244695D-05,  6.3060D-23,   25, 'P', & !  624
     &      -2968.8D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 2.5286726000D0, -6.763205548489D-05,  5.5790D-23,   60, 'R', & !  625
     &         85.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.3462334000D0, -6.762135852283D-05,  4.8520D-23,  252, 'R', & !  626
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2277121556D0, -6.762025781016D-05,  2.5304D-23,  243, 'P', & !  627
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5199427528D0, -6.760844111561D-05, -2.0484D-24,  173, 'P', & !  628
     &        -19.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9938704667D0, -6.759847335890D-05,  2.2211D-23,  375, 'P', & !  629
     &        -24.7D0,       -13.1D0,        0.0D0,      0.0D0,     & !
     & 1.3375035528D0, -6.759774415355D-05, -9.3184D-24,    3, 'P', & !  630
     &     456803.6D0,       629.2D0,   -29843.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 631, 640 ) &
     &             /                 &
     & 2.9643219461D0, -6.759701494819D-05, -4.0848D-23,  374, 'P', & !  631
     &         24.7D0,       -13.1D0,        0.0D0,      0.0D0,     & !
     & 5.4382496600D0, -6.758704719148D-05, -1.6588D-23,    8, 'P', & !  632
     &      86031.8D0,       118.1D0,    12841.6D0,      0.0D0,     & !
     & 3.2558104600D0, -6.757635022942D-05, -2.3858D-23,   26, 'P', & !  633
     &      -2628.3D0,        -4.3D0,        0.0D0,      0.0D0,     & !
     & 1.0733712600D0, -6.756565326736D-05, -3.1128D-23,   95, 'R', & !  634
     &         21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1653875200D0, -6.753134193601D-05, -9.6236D-23,  232, 'P', & !  635
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6679866228D0, -6.744365557171D-05,  6.2538D-23,  162, 'P', & !  636
     &         27.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9779923572D0, -6.744363655189D-05,  6.5670D-23,  248, 'P', & !  637
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7777780200D0, -6.742114191510D-05,  2.7915D-23,  138, 'P', & !  638
     &         63.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2943783756D0, -6.739864727831D-05, -9.8405D-24,   37, 'P', & !  639
     &      -1520.2D0,        -3.4D0,     -925.2D0,      0.0D0,     & !
     & 5.3951244828D0, -6.738795031625D-05, -1.7110D-23,   86, 'P', & !  640
     &       -179.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 641, 650 ) &
     &             /                 &
     & 1.9348671800D0, -6.724453967665D-05,  6.5148D-23,   42, 'P', & !  641
     &      -1291.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 6.0356132872D0, -6.723384271459D-05,  5.7878D-23,   79, 'P', & !  642
     &       -228.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8531740872D0, -6.722314575253D-05,  5.0608D-23,  233, 'R', & !  643
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2512531985D0, -6.719955040307D-05, -1.0363D-23,  214, 'P', & !  644
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4795658400D0, -6.717813745912D-05, -2.1770D-23,   84, 'P', & !  645
     &       -182.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5803119472D0, -6.716744049706D-05, -2.9040D-23,  175, 'P', & !  646
     &        -28.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8917420028D0, -6.704544280142D-05,  6.4626D-23,  148, 'P', & !  647
     &        -48.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9150656228D0, -6.590905522283D-05, -5.3822D-23,  196, 'P', & !  648
     &        -14.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7711943385D0, -6.572065530965D-05, -4.7074D-23,  158, 'P', & !  649
     &         39.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8719404456D0, -6.570995834759D-05, -5.4344D-23,   88, 'P', & !  650
     &       -137.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 651, 660 ) &
     &             /                 &
     & 3.1819461800D0, -6.570993932777D-05, -5.1211D-23,  210, 'P', & !  651
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6895012456D0, -6.569926138553D-05, -6.1614D-23,  184, 'R', & !  652
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2292439428D0, -6.555585074594D-05,  2.0645D-23,  139, 'P', & !  653
     &        -46.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1388210028D0, -6.551084245253D-05, -5.1733D-23,   56, 'P', & !  654
     &        567.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.9563818028D0, -6.550014549047D-05, -5.9003D-23,  112, 'P', & !  655
     &        102.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3685579656D0, -6.536745083276D-05,  2.7393D-23,   81, 'P', & !  656
     &        210.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1861187656D0, -6.535675387070D-05,  2.0123D-23,   49, 'P', & !  657
     &       -682.0D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 4.2868648728D0, -6.534605690864D-05,  1.2853D-23,  107, 'R', & !  658
     &         17.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0956958256D0, -6.531174557729D-05, -5.2255D-23,   16, 'P', & !  659
     &      11942.8D0,        31.4D0,     -462.6D0,      0.0D0,     & !
     & 0.9132566256D0, -6.530104861523D-05, -5.9525D-23,   33, 'P', & !  660
     &       2250.8D0,         6.8D0,      305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 661, 670 ) &
     &             /                 &
     & 5.0140027328D0, -6.529035165317D-05, -6.6795D-23,  122, 'P', & !  661
     &        -59.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1429935885D0, -6.515765699546D-05,  1.9601D-23,  203, 'P', & !  662
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7361846300D0, -6.515763797564D-05,  2.2734D-23,   55, 'P', & !  663
     &        574.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.5537454300D0, -6.514694101357D-05,  1.5464D-23,  115, 'P', & !  664
     &         93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2527849856D0, -6.513514333885D-05, -1.5022D-23,   69, 'P', & !  665
     &       -333.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3535310928D0, -6.512444637678D-05, -2.2292D-23,  136, 'P', & !  666
     &        -60.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0525706485D0, -6.511264870205D-05, -5.2777D-23,  105, 'P', & !  667
     &       -112.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8701314485D0, -6.510195173999D-05, -6.0047D-23,  228, 'P', & !  668
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9659215928D0, -6.501424635587D-05,  1.0186D-22,  224, 'P', & !  669
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7834823928D0, -6.500354939381D-05,  9.4590D-23,   82, 'P', & !  670
     &       -163.5D0,        -1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 671, 680 ) &
     &             /                 &
     & 4.8842285000D0, -6.499285243174D-05,  8.7320D-23,  172, 'R', & !  671
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6930594528D0, -6.495854110040D-05,  2.2211D-23,    9, 'P', & !  672
     &      60319.1D0,       167.8D0,    -3386.6D0,      0.0D0,     & !
     & 1.5106202528D0, -6.494784413834D-05,  1.4942D-23,   17, 'P', & !  673
     &      11365.8D0,        31.0D0,     1222.2D0,      0.0D0,     & !
     & 5.6113663600D0, -6.493714717627D-05,  7.6716D-24,   65, 'P', & !  674
     &       -348.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2096598085D0, -6.493604646361D-05, -1.5544D-23,  146, 'P', & !  675
     &         47.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4289271600D0, -6.492645021421D-05,  4.0165D-25,  193, 'R', & !  676
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2377581128D0, -6.489213888287D-05, -6.4706D-23,   78, 'P', & !  677
     &       -229.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0553189128D0, -6.488144192080D-05, -7.1976D-23,  159, 'P', & !  678
     &        -40.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8501486128D0, -6.478193886195D-05,  5.9445D-23,  245, 'P', & !  679
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6499342756D0, -6.475944422516D-05,  2.1689D-23,   61, 'P', & !  680
     &       -494.2D0,        -1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 681, 690 ) &
     &             /                 &
     & 1.4674950756D0, -6.474874726310D-05,  1.4419D-23,  123, 'P', & !  681
     &        -78.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2904230800D0, -6.460533662351D-05,  9.6678D-23,   83, 'P', & !  682
     &       -187.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1079838800D0, -6.459463966144D-05,  8.9408D-23,  179, 'P', & !  683
     &        -28.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8351217400D0, -6.453893440597D-05,  9.7602D-24,  153, 'P', & !  684
     &        -44.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9874362156D0, -6.326985216968D-05, -2.2292D-23,  237, 'P', & !  685
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8970132756D0, -6.322484387628D-05, -9.4670D-23,  212, 'P', & !  686
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1267502385D0, -6.308145225651D-05, -1.5544D-23,  166, 'P', & !  687
     &         32.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9443110385D0, -6.307075529444D-05, -2.2814D-23,  135, 'P', & !  688
     &        -43.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5375020800D0, -6.307073627462D-05, -1.9681D-23,  183, 'P', & !  689
     &         24.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8538880985D0, -6.302574700104D-05, -9.5192D-23,   77, 'P', & !  690
     &        242.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 691, 700 ) &
     &             /                 &
     & 2.6714488985D0, -6.301505003897D-05, -1.0246D-22,  155, 'P', & !  691
     &         43.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4943769028D0, -6.287163939938D-05, -2.0203D-23,   59, 'P', & !  692
     &        530.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.3119377028D0, -6.286094243732D-05, -2.7473D-23,  109, 'P', & !  693
     &        100.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0109772585D0, -6.284914476259D-05, -5.7959D-23,  226, 'P', & !  694
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7241138656D0, -6.272824777961D-05,  5.8923D-23,  190, 'P', & !  695
     &         20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5416746656D0, -6.271755081755D-05,  5.1653D-23,  128, 'P', & !  696
     &        -54.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3592354656D0, -6.270685385549D-05,  4.4383D-23,  254, 'R', & !  697
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4512517256D0, -6.267254252414D-05, -2.0725D-23,   20, 'P', & !  698
     &       7698.9D0,        31.4D0,        0.0D0,      0.0D0,     & !
     & 3.2688125256D0, -6.266184556208D-05, -2.7995D-23,   38, 'P', & !  699
     &       1452.3D0,         4.4D0,     -462.6D0,      0.0D0,     & !
     & 1.0863733256D0, -6.265114860002D-05, -3.5265D-23,  141, 'P', & !  700
     &        -37.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 701, 710 ) &
     &             /                 &
     & 6.0917405300D0, -6.251843492249D-05,  5.4263D-23,  114, 'P', & !  701
     &         97.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9093013300D0, -6.250773796043D-05,  4.6994D-23,  247, 'P', & !  702
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6083408856D0, -6.249594028570D-05,  1.6508D-23,  134, 'P', & !  703
     &        -65.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4259016856D0, -6.248524332364D-05,  9.2380D-24,  240, 'P', & !  704
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4081265485D0, -6.247344564891D-05, -2.1247D-23,  106, 'P', & !  705
     &       -105.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2256873485D0, -6.246274868684D-05, -2.8517D-23,  213, 'P', & !  706
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1390382928D0, -6.236434634066D-05,  1.2612D-22,  206, 'P', & !  707
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0486153528D0, -6.231933804725D-05,  5.3741D-23,   22, 'P', & !  708
     &       6195.7D0,        27.1D0,     -768.1D0,      0.0D0,     & !
     & 3.8661761528D0, -6.230864108519D-05,  4.6471D-23,   44, 'P', & !  709
     &       1166.0D0,         4.4D0,        0.0D0,      0.0D0,     & !
     & 1.6837369528D0, -6.229794412313D-05,  3.9201D-23,  147, 'P', & !  710
     &        -32.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 711, 720 ) &
     &             /                 &
     & 4.5933140128D0, -6.225293582972D-05, -3.3177D-23,  161, 'P', & !  711
     &        -37.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0054901756D0, -6.212024117201D-05,  5.3219D-23,  124, 'P', & !  712
     &        -79.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8230509756D0, -6.210954420995D-05,  4.5949D-23,  246, 'P', & !  713
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3627936728D0, -6.196613357036D-05,  1.2821D-22,  207, 'P', & !  714
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9693838685D0, -6.058564082313D-05, -6.3140D-23,  164, 'P', & !  715
     &         33.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2998669385D0, -6.043155224130D-05,  8.7159D-24,  216, 'P', & !  716
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9262586913D0, -6.038654394789D-05, -6.3662D-23,   70, 'P', & !  717
     &        305.6D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.0270047985D0, -6.037584698583D-05, -7.0932D-23,  140, 'P', & !  718
     &         56.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5667474956D0, -6.023243634624D-05,  1.1327D-23,  101, 'P', & !  719
     &        117.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6674936028D0, -6.022173938417D-05,  4.0567D-24,  219, 'P', & !  720
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 721, 730 ) &
     &             /                 &
     & 4.8972305656D0, -6.007834776440D-05,  8.3183D-23,  249, 'P', & !  721
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5236223185D0, -6.003333947100D-05,  1.0804D-23,   35, 'P', & !  722
     &       1528.4D0,         8.7D0,        0.0D0,      0.0D0,     & !
     & 5.6243684256D0, -6.002264250893D-05,  3.5346D-24,   73, 'P', & !  723
     &        288.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.4419292256D0, -6.001194554687D-05, -3.7354D-24,  217, 'P', & !  724
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1641111228D0, -5.987923186934D-05,  8.5793D-23,  250, 'P', & !  725
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4804971413D0, -5.983424259576D-05,  1.0282D-23,  178, 'P', & !  726
     &        -29.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1209859456D0, -5.968013499410D-05,  8.5271D-23,   53, 'P', & !  727
     &        579.2D0,         4.4D0,        0.0D0,      0.0D0,     & !
     & 6.2217320528D0, -5.966943803204D-05,  7.8001D-23,  104, 'P', & !  728
     &        108.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3249397685D0, -5.794643776998D-05, -3.1610D-23,  201, 'P', & !  729
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2818145913D0, -5.774734089474D-05, -3.2132D-23,   98, 'P', & !  730
     &        136.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 731, 737 ) &
     &             /                 &
     & 1.0993753913D0, -5.773664393268D-05, -3.9402D-23,  174, 'P', & !  731
     &         26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9223033956D0, -5.759323329309D-05,  4.2856D-23,  205, 'P', & !  732
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8791782185D0, -5.739413641785D-05,  4.2334D-23,   80, 'P', & !  733
     &        218.1D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.6967390185D0, -5.738343945579D-05,  3.5064D-23,  154, 'P', & !  734
     &         42.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4765418456D0, -5.704093194096D-05,  1.1680D-22,  145, 'P', & !  735
     &         51.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6373704913D0, -5.510813784160D-05, -6.0248D-25,  168, 'P', & !  736
     &         32.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2347341185D0, -5.475493336470D-05,  7.3864D-23,  198, 'P', & !  737
     &         13.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
