!
! --- This file was generated automatically by program make_tid v 1.0
! --- written by Leonid Petrov (Leonid.Petrov@lpetrov.net)
! --- It contains phases, frequencies, accelerations amplitudes and 
! --- orders of the tidal waves of the 2-nd and 3-rd degree 
! --- with (renormalized) amplitude  cutoff  0.00010 m
! --- Constituents with differences in frequences less than  1.000D-11 rad/sec 
! --- are merged
! --- Harmonic expansion HW95 was used.
! --- (T. Hartmann and H-G. Wenzel "The HW95 tidal potential catalogue",
! ---  Geophysical Research Letters", Vol. 22(24), p. 3553-3556, 1995),
! ---  Amplitudes were renormalized!
!
      INTEGER*4   NTID, NT$1
      PARAMETER ( NTID = 886 )
      REAL*8      TID_PHAS(NTID), TID_FREQ(NTID), TID_ACCL(NTID), TID_AMPL(NTID)
      INTEGER*4   L(NTID), M(NTID)
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=1,10)    &
     & / &
     & 3.141593D0, 0.000000000000D+00,  0.00D+00, 3.082489,  2, 0, & !     1
     & 4.100746D0, 1.069696236521D-08, -7.28D-24, 0.273654,  2, 0, & !     2
     & 2.066431D0, 1.180718409829D-08, -2.89D-23, 0.000104,  0, 3, & !     3
     & 5.059900D0, 2.139392473041D-08, -1.46D-23, 0.002671,  2, 0, & !     4
     & 3.025585D0, 2.250414646350D-08, -3.62D-23, 0.002002,  0, 3, & !     5
     & 0.843146D0, 3.320110882871D-08, -4.35D-23, 0.000320,  0, 3, & !     6
     & 0.727138D0, 5.570525529221D-08, -7.96D-23, 0.000371,  2, 0, & !     7
     & 4.827884D0, 6.640221765742D-08, -8.69D-23, 0.000143,  2, 0, & !     8
     & 5.280907D0, 1.883999129268D-07,  6.74D-24, 0.000412,  2, 0, & !     9
     & 3.098467D0, 1.990968752920D-07, -5.39D-25, 0.049546,  2, 0  & !    10
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=11,20)   &
     & / &
     & 3.550066D0, 1.991158946075D-07,  2.66D-24, 0.002537,  2, 0, & !    11
     & 4.057621D0, 2.097938376572D-07, -7.81D-24, 0.000305,  2, 0, & !    12
     & 4.509219D0, 2.098128569727D-07, -4.61D-24, 0.000150,  2, 0, & !    13
     & 2.779803D0, 3.425075146073D-07,  8.18D-23, 0.000201,  2, 0, & !    14
     & 3.738956D0, 3.532044769725D-07,  7.45D-23, 0.003058,  2, 0, & !    15
     & 4.698110D0, 3.639014393377D-07,  6.72D-23, 0.000284,  2, 0, & !    16
     & 3.622948D0, 3.757086234360D-07,  3.83D-23, 0.000373,  0, 3, & !    17
     & 3.055342D0, 3.981937505839D-07, -1.08D-24, 0.001177,  2, 0, & !    18
     & 0.365348D0, 3.982127698995D-07,  2.13D-24, 0.303633,  2, 0, & !    19
     & 1.324501D0, 4.089097322647D-07, -5.15D-24, 0.007563,  2, 0  & !    20
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=21,30)   &
     & / &
     & 5.425248D0, 4.196066946299D-07, -1.24D-23, 0.001667,  2, 0, & !    21
     & 3.695831D0, 5.523013522645D-07,  7.39D-23, 0.000103,  2, 0, & !    22
     & 0.322223D0, 5.973096451915D-07,  1.59D-24, 0.017750,  2, 0, & !    23
     & 1.281376D0, 6.080066075567D-07, -5.69D-24, 0.000312,  2, 0, & !    24
     & 0.279098D0, 7.964065204835D-07,  1.05D-24, 0.000719,  2, 0, & !    25
     & 0.433691D0, 1.877088843504D-06, -3.83D-23, 0.000122,  2, 0, & !    26
     & 3.983757D0, 2.076204738112D-06, -3.56D-23, 0.000212,  2, 0, & !    27
     & 4.942910D0, 2.086901700477D-06, -4.29D-23, 0.002819,  2, 0, & !    28
     & 5.902063D0, 2.097598662842D-06, -5.02D-23, 0.000177,  2, 0, & !    29
     & 3.213493D0, 2.219596358111D-06,  4.35D-23, 0.000236,  2, 0  & !    30
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=31,40)   &
     & / &
     & 1.031054D0, 2.230293320477D-06,  3.62D-23, 0.000640,  2, 0, & !    31
     & 4.056639D0, 2.252797466940D-06,  9.74D-27, 0.000101,  0, 3, & !    32
     & 5.015793D0, 2.263494429305D-06, -7.27D-24, 0.000420,  0, 3, & !    33
     & 3.940631D0, 2.275301613404D-06, -3.62D-23, 0.004734,  2, 0, & !    34
     & 4.899785D0, 2.285998575769D-06, -4.34D-23, 0.065922,  2, 0, & !    35
     & 5.858938D0, 2.296695538134D-06, -5.07D-23, 0.004280,  2, 0, & !    36
     & 4.581120D0, 2.429409215084D-06,  3.89D-23, 0.000176,  2, 0, & !    37
     & 5.540274D0, 2.440106177449D-06,  3.16D-23, 0.002118,  2, 0, & !    38
     & 0.216242D0, 2.450803139815D-06,  2.43D-23, 0.000107,  2, 0, & !    39
     & 4.239313D0, 2.451903851890D-06,  1.07D-24, 0.000131,  2, 0  & !    40
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=41,50)   &
     & / &
     & 5.198467D0, 2.462600814255D-06, -6.20D-24, 0.001912,  2, 0, & !    41
     & 6.157620D0, 2.473297776620D-06, -1.35D-23, 0.000115,  2, 0, & !    42
     & 1.715067D0, 2.485095451061D-06, -4.40D-23, 0.000433,  2, 0, & !    43
     & 5.613156D0, 2.616698906278D-06,  6.72D-23, 0.000152,  0, 3, & !    44
     & 3.578841D0, 2.617809128011D-06,  4.56D-23, 0.000287,  2, 0, & !    45
     & 4.537995D0, 2.628506090376D-06,  3.83D-23, 0.022630,  2, 0, & !    46
     & 5.497148D0, 2.639203052741D-06,  3.10D-23, 0.344743,  2, 0, & !    47
     & 0.173117D0, 2.649900015107D-06,  2.38D-23, 0.022372,  2, 0, & !    48
     & 4.421987D0, 2.651010236840D-06,  2.14D-24, 0.001902,  0, 3, & !    49
     & 1.132270D0, 2.660596977472D-06,  1.65D-23, 0.000218,  2, 0  & !    50
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=51,60)   &
     & / &
     & 2.013749D0, 2.661697689547D-06, -6.74D-24, 0.000277,  2, 0, & !    51
     & 5.381141D0, 2.661707199205D-06, -5.14D-24, 0.036768,  0, 3, & !    52
     & 3.198701D0, 2.672404161570D-06, -1.24D-23, 0.005803,  0, 3, & !    53
     & 4.157855D0, 2.683101123935D-06, -1.97D-23, 0.000452,  0, 3, & !    54
     & 5.265133D0, 2.684211345668D-06, -4.13D-23, 0.018449,  2, 0, & !    55
     & 3.082694D0, 2.694908308034D-06, -4.86D-23, 0.007505,  2, 0, & !    56
     & 0.900254D0, 2.705605270399D-06, -5.59D-23, 0.002016,  2, 0, & !    57
     & 1.353277D0, 2.827602965668D-06,  3.78D-23, 0.000139,  2, 0, & !    58
     & 2.312431D0, 2.838299928033D-06,  3.05D-23, 0.001767,  2, 0, & !    59
     & 5.563815D0, 2.860813584155D-06, -4.08D-24, 0.000117,  2, 0  & !    60
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=61,70)   &
     & / &
     & 5.862496D0, 3.037415822641D-06,  3.32D-23, 0.004813,  2, 0, & !    61
     & 3.680057D0, 3.048112785006D-06,  2.59D-23, 0.002396,  2, 0, & !    62
     & 1.497618D0, 3.058809747371D-06,  1.86D-23, 0.000430,  2, 0, & !    63
     & 5.819371D0, 3.236512697933D-06,  3.26D-23, 0.000230,  2, 0, & !    64
     & 3.636932D0, 3.247209660298D-06,  2.54D-23, 0.000108,  2, 0, & !    65
     & 2.789246D0, 4.516291896246D-06, -7.26D-24, 0.000103,  2, 0, & !    66
     & 1.058406D0, 4.527007877926D-06, -1.13D-23, 0.000177,  2, 0, & !    67
     & 0.374792D0, 4.571997151538D-06, -8.69D-23, 0.001075,  2, 0, & !    68
     & 1.015280D0, 4.726104753218D-06, -1.19D-23, 0.003765,  2, 0, & !    69
     & 1.974434D0, 4.736801715583D-06, -1.91D-23, 0.000237,  2, 0  & !    70
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=71,80)   &
     & / &
     & 5.337034D0, 4.903807703780D-06,  2.15D-24, 0.000124,  2, 0, & !    71
     & 3.154594D0, 4.914504666145D-06, -5.13D-24, 0.004079,  2, 0, & !    72
     & 0.972155D0, 4.925201628510D-06, -1.24D-23, 0.057189,  2, 0, & !    73
     & 1.931309D0, 4.935898590875D-06, -1.97D-23, 0.003665,  2, 0, & !    74
     & 0.856147D0, 4.947705774974D-06, -4.86D-23, 0.001171,  0, 3, & !    75
     & 4.956894D0, 4.958402737339D-06, -5.59D-23, 0.000185,  0, 3, & !    76
     & 0.740140D0, 4.970209921437D-06, -8.48D-23, 0.000372,  2, 0, & !    77
     & 4.840886D0, 4.980906883802D-06, -9.20D-23, 0.000151,  2, 0, & !    78
     & 1.612644D0, 5.079309230191D-06,  6.26D-23, 0.000349,  2, 0, & !    79
     & 1.270837D0, 5.101803866996D-06,  2.48D-23, 0.000303,  2, 0  & !    80
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=81,90)   &
     & / &
     & 6.253062D0, 5.113601541437D-06, -5.67D-24, 0.000134,  2, 0, & !    81
     & 4.070623D0, 5.124298503802D-06, -1.29D-23, 0.000631,  2, 0, & !    82
     & 4.522221D0, 5.124317523118D-06, -9.74D-24, 0.001975,  2, 0, & !    83
     & 2.339782D0, 5.135014485483D-06, -1.70D-23, 0.000450,  2, 0, & !    84
     & 0.610365D0, 5.267709143118D-06,  6.94D-23, 0.001504,  2, 0, & !    85
     & 1.569519D0, 5.278406105483D-06,  6.21D-23, 0.028254,  2, 0, & !    86
     & 2.528672D0, 5.289103067848D-06,  5.48D-23, 0.001833,  2, 0, & !    87
     & 0.494358D0, 5.290213289581D-06,  3.32D-23, 0.000313,  0, 3, & !    88
     & 1.453511D0, 5.300910251946D-06,  2.59D-23, 0.006010,  0, 3, & !    89
     & 5.554257D0, 5.311607214311D-06,  1.86D-23, 0.000948,  0, 3  & !    90
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=91,100)   &
     & / &
     & 4.479096D0, 5.323414398410D-06, -1.03D-23, 0.652632,  2, 0, & !    91
     & 2.296657D0, 5.334111360775D-06, -1.76D-23, 0.270591,  2, 0, & !    92
     & 0.114218D0, 5.344808323140D-06, -2.48D-23, 0.025307,  2, 0, & !    93
     & 1.221495D0, 5.345918544873D-06, -4.65D-23, 0.000168,  0, 3, & !    94
     & 1.073371D0, 5.355505285505D-06, -3.21D-23, 0.000542,  2, 0, & !    95
     & 5.322242D0, 5.356615507238D-06, -5.37D-23, 0.000105,  0, 3, & !    96
     & 4.667986D0, 5.477502980775D-06,  6.15D-23, 0.000287,  2, 0, & !    97
     & 1.294378D0, 5.522511273702D-06, -1.08D-23, 0.002244,  2, 0, & !    98
     & 5.395124D0, 5.533208236067D-06, -1.81D-23, 0.000589,  2, 0, & !    99
     & 1.934867D0, 5.676618875382D-06,  6.42D-23, 0.001961,  2, 0  & !   100
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=101,110)   &
     & / &
     & 6.035613D0, 5.687315837747D-06,  5.69D-23, 0.000755,  2, 0, & !   101
     & 0.479566D0, 5.743021093040D-06, -2.27D-23, 0.000283,  2, 0, & !   102
     & 4.580312D0, 5.753718055405D-06, -3.00D-23, 0.000105,  2, 0, & !   103
     & 2.773473D0, 7.012103328987D-06, -5.53D-23, 0.000191,  2, 0, & !   104
     & 4.912787D0, 7.200503241914D-06, -4.86D-23, 0.000171,  2, 0, & !   105
     & 2.730347D0, 7.211200204279D-06, -5.58D-23, 0.001758,  2, 0, & !   106
     & 3.689501D0, 7.221897166644D-06, -6.31D-23, 0.000112,  2, 0, & !   107
     & 3.370836D0, 7.365307805960D-06,  1.92D-23, 0.000660,  2, 0, & !   108
     & 6.280413D0, 7.410316098887D-06, -5.32D-23, 0.001095,  2, 0, & !   109
     & 4.097974D0, 7.421013061252D-06, -6.05D-23, 0.000441,  2, 0  & !   110
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=111,120)   &
     & / &
     & 5.510150D0, 7.553707718886D-06,  2.59D-23, 0.000928,  2, 0, & !   111
     & 3.327711D0, 7.564404681252D-06,  1.86D-23, 0.009064,  2, 0, & !   112
     & 4.286864D0, 7.575101643617D-06,  1.14D-23, 0.000579,  2, 0, & !   113
     & 3.211703D0, 7.586908827715D-06, -1.75D-23, 0.001008,  0, 3, & !   114
     & 1.029264D0, 7.597605790080D-06, -2.48D-23, 0.000157,  0, 3, & !   115
     & 6.237288D0, 7.609412974179D-06, -5.37D-23, 0.023729,  2, 0, & !   116
     & 4.054849D0, 7.620109936544D-06, -6.10D-23, 0.009836,  2, 0, & !   117
     & 1.872410D0, 7.630806898909D-06, -6.83D-23, 0.000889,  2, 0, & !   118
     & 0.142993D0, 7.763501556544D-06,  1.81D-23, 0.000145,  2, 0, & !   119
     & 0.594592D0, 7.763520575859D-06,  2.13D-23, 0.001166,  2, 0  & !   120
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=121,130)   &
     & / &
     & 4.695338D0, 7.774217538224D-06,  1.40D-23, 0.000413,  2, 0, & !   121
     & 0.252785D0, 7.786015212665D-06, -1.65D-23, 0.000674,  2, 0, & !   122
     & 4.353531D0, 7.796712175030D-06, -2.38D-23, 0.000276,  2, 0, & !   123
     & 3.052570D0, 7.808509849471D-06, -5.43D-23, 0.000232,  2, 0, & !   124
     & 3.925075D0, 7.917609158224D-06,  9.31D-23, 0.002270,  2, 0, & !   125
     & 4.884228D0, 7.928306120589D-06,  8.58D-23, 0.000147,  2, 0, & !   126
     & 3.809067D0, 7.940113304688D-06,  5.69D-23, 0.000724,  0, 3, & !   127
     & 1.626628D0, 7.950810267053D-06,  4.97D-23, 0.000114,  0, 3, & !   128
     & 0.551466D0, 7.962617451151D-06,  2.08D-23, 0.124958,  2, 0, & !   129
     & 4.652212D0, 7.973314413516D-06,  1.35D-23, 0.051790,  2, 0  & !   130
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=131,140)   &
     & / &
     & 2.469773D0, 7.984011375882D-06,  6.21D-24, 0.004851,  2, 0, & !   131
     & 3.351252D0, 7.985112087957D-06, -1.70D-23, 0.000102,  2, 0, & !   132
     & 0.435459D0, 7.985121597615D-06, -1.54D-23, 0.002993,  0, 3, & !   133
     & 3.428927D0, 7.994708338247D-06, -1.07D-24, 0.000104,  2, 0, & !   134
     & 4.536205D0, 7.995818559980D-06, -2.27D-23, 0.001861,  0, 3, & !   135
     & 2.353765D0, 8.006515522345D-06, -3.00D-23, 0.000364,  0, 3, & !   136
     & 2.237758D0, 8.029019668809D-06, -6.61D-23, 0.000477,  2, 0, & !   137
     & 0.055318D0, 8.039716631174D-06, -7.34D-23, 0.000198,  2, 0, & !   138
     & 3.649934D0, 8.161714326443D-06,  2.02D-23, 0.001051,  2, 0, & !   139
     & 1.467495D0, 8.172411288808D-06,  1.29D-23, 0.000370,  2, 0  & !   140
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=141,150)   &
     & / &
     & 4.290423D0, 8.315821928124D-06,  9.52D-23, 0.000402,  2, 0, & !   141
     & 2.107983D0, 8.326518890489D-06,  8.80D-23, 0.000152,  2, 0, & !   142
     & 2.835121D0, 8.382224145781D-06,  8.33D-24, 0.000105,  2, 0, & !   143
     & 5.129028D0, 9.651306381728D-06, -2.43D-23, 0.000109,  2, 0, & !   144
     & 0.985157D0, 9.839706294655D-06, -1.75D-23, 0.000185,  2, 0, & !   145
     & 5.085903D0, 9.850403257020D-06, -2.48D-23, 0.000879,  2, 0, & !   146
     & 1.712295D0, 9.895411549947D-06, -9.72D-23, 0.000609,  2, 0, & !   147
     & 5.813041D0, 9.906108512313D-06, -1.04D-22, 0.000252,  2, 0, & !   148
     & 2.352784D0, 1.004951915163D-05, -2.21D-23, 0.001346,  2, 0, & !   149
     & 0.170344D0, 1.006021611399D-05, -2.94D-23, 0.000547,  2, 0  & !   150
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=151,160)   &
     & / &
     & 1.582521D0, 1.019291077163D-05,  5.69D-23, 0.000140,  2, 0, & !   151
     & 5.683267D0, 1.020360773399D-05,  4.97D-23, 0.001073,  2, 0, & !   152
     & 5.567259D0, 1.022611188046D-05,  1.35D-23, 0.000225,  0, 3, & !   153
     & 2.309658D0, 1.024861602692D-05, -2.27D-23, 0.019958,  2, 0, & !   154
     & 0.127219D0, 1.025931298929D-05, -3.00D-23, 0.008270,  2, 0, & !   155
     & 4.227965D0, 1.027000995165D-05, -3.72D-23, 0.000771,  2, 0, & !   156
     & 2.193651D0, 1.027112017338D-05, -5.89D-23, 0.000154,  0, 3, & !   157
     & 2.950147D0, 1.040272362860D-05,  5.23D-23, 0.000256,  2, 0, & !   158
     & 2.608340D0, 1.042521826541D-05,  1.46D-23, 0.000177,  2, 0, & !   159
     & 5.408126D0, 1.044771290221D-05, -2.32D-23, 0.000281,  2, 0  & !   160
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=161,170)   &
     & / &
     & 3.225687D0, 1.045840986458D-05, -3.05D-23, 0.000106,  2, 0, & !   161
     & 6.280630D0, 1.055681221097D-05,  1.24D-22, 0.000180,  2, 0, & !   162
     & 2.907022D0, 1.060182050389D-05,  5.18D-23, 0.016531,  2, 0, & !   163
     & 0.724583D0, 1.061251746626D-05,  4.45D-23, 0.006854,  2, 0, & !   164
     & 4.825329D0, 1.062321442862D-05,  3.72D-23, 0.000642,  2, 0, & !   165
     & 2.791014D0, 1.062432465036D-05,  1.56D-23, 0.000821,  0, 3, & !   166
     & 0.608575D0, 1.063502161272D-05,  8.34D-24, 0.000511,  0, 3, & !   167
     & 4.709321D0, 1.064571857509D-05,  1.07D-24, 0.000100,  0, 3, & !   168
     & 6.005490D0, 1.080091737918D-05,  5.13D-23, 0.000223,  2, 0, & !   169
     & 4.110976D0, 1.233551772740D-05, -6.56D-23, 0.000105,  2, 0  & !   170
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=171,180)   &
     & / &
     & 1.158274D0, 1.248960630976D-05,  6.23D-24, 0.000183,  2, 0, & !   171
     & 4.067851D0, 1.253461460269D-05, -6.61D-23, 0.000931,  2, 0, & !   172
     & 1.885411D0, 1.254531156505D-05, -7.34D-23, 0.000386,  2, 0, & !   173
     & 4.708339D0, 1.268872220437D-05,  8.89D-24, 0.000365,  2, 0, & !   174
     & 2.525900D0, 1.269941916673D-05,  1.62D-24, 0.000148,  2, 0, & !   175
     & 1.755637D0, 1.284281078673D-05,  8.07D-23, 0.000112,  2, 0, & !   176
     & 4.665214D0, 1.288781907966D-05,  8.35D-24, 0.004822,  2, 0, & !   177
     & 2.482775D0, 1.289851604203D-05,  1.08D-24, 0.001998,  2, 0, & !   178
     & 0.300336D0, 1.290921300439D-05, -6.20D-24, 0.000187,  2, 0, & !   179
     & 4.549206D0, 1.291032322612D-05, -2.78D-23, 0.000143,  0, 3  & !   180
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=181,190)   &
     & / &
     & 5.262578D0, 1.324102355663D-05,  8.28D-23, 0.001860,  2, 0, & !   181
     & 3.080139D0, 1.325172051900D-05,  7.56D-23, 0.000771,  2, 0, & !   182
     & 5.146570D0, 1.326352770310D-05,  4.67D-23, 0.000142,  0, 3, & !   183
     & 0.140221D0, 1.517381765543D-05, -3.51D-23, 0.000495,  2, 0, & !   184
     & 4.240967D0, 1.518451461780D-05, -4.24D-23, 0.000205,  2, 0, & !   185
     & 0.737585D0, 1.552702213240D-05,  3.94D-23, 0.000798,  2, 0, & !   186
     & 4.838331D0, 1.553771909477D-05,  3.21D-23, 0.000331,  2, 0, & !   187
     & 1.334948D0, 1.588022660938D-05,  1.14D-22, 0.000191,  2, 0, & !   188
     & 2.495777D0, 1.781302070817D-05, -4.05D-24, 0.000132,  2, 0, & !   189
     & 3.093140D0, 1.816622518514D-05,  7.04D-23, 0.000109,  2, 0  & !   190
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=191,200)   &
     & / &
     & 0.231126D0, 5.475493336624D-05, -6.94D-23, 0.000428,  2, 1, & !   191
     & 0.828490D0, 5.510813784321D-05,  5.11D-24, 0.000518,  2, 1, & !   192
     & 1.425854D0, 5.546134232018D-05,  7.96D-23, 0.000101,  2, 1, & !   193
     & 4.171758D0, 5.703023497964D-05, -1.06D-22, 0.000142,  2, 1, & !   194
     & 1.989318D0, 5.704093194200D-05, -1.13D-22, 0.000751,  2, 1, & !   195
     & 2.702690D0, 5.737163227251D-05, -2.15D-24, 0.000180,  1, 3, & !   196
     & 4.769121D0, 5.738343945661D-05, -3.11D-23, 0.000592,  2, 1, & !   197
     & 2.586682D0, 5.739413641898D-05, -3.83D-23, 0.003142,  2, 1, & !   198
     & 2.543557D0, 5.759323329427D-05, -3.89D-23, 0.000259,  2, 1, & !   199
     & 5.366485D0, 5.773664393358D-05,  4.34D-23, 0.000367,  2, 1  & !   200
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=201,210)   &
     & / &
     & 3.184046D0, 5.774734089595D-05,  3.62D-23, 0.001950,  2, 1, & !   201
     & 3.140920D0, 5.794643777124D-05,  3.56D-23, 0.000255,  2, 1, & !   202
     & 3.781409D0, 5.810054537292D-05,  1.11D-22, 0.000118,  2, 1, & !   203
     & 1.246407D0, 5.948103811945D-05, -8.12D-23, 0.000137,  2, 1, & !   204
     & 0.360136D0, 5.964693388592D-05, -3.83D-23, 0.000235,  1, 3, & !   205
     & 4.460882D0, 5.965763084828D-05, -4.56D-23, 0.000594,  1, 3, & !   206
     & 0.244128D0, 5.966943803238D-05, -7.45D-23, 0.001381,  2, 1, & !   207
     & 4.344874D0, 5.968013499475D-05, -8.18D-23, 0.007322,  2, 1, & !   208
     & 1.843770D0, 5.983424259643D-05, -6.75D-24, 0.000360,  2, 1, & !   209
     & 4.643556D0, 5.985673723323D-05, -4.45D-23, 0.000116,  2, 1  & !   210
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=211,220)   &
     & / &
     & 4.301749D0, 5.987923187004D-05, -8.23D-23, 0.000157,  2, 1, & !   211
     & 0.957499D0, 6.000013836289D-05,  3.62D-23, 0.000236,  1, 3, & !   212
     & 5.058246D0, 6.001083532526D-05,  2.89D-23, 0.000597,  1, 3, & !   213
     & 6.165524D0, 6.001194554699D-05,  7.26D-24, 0.000110,  2, 1, & !   214
     & 0.841492D0, 6.002264250935D-05, -1.58D-26, 0.003578,  2, 1, & !   215
     & 4.942238D0, 6.003333947172D-05, -7.29D-24, 0.018967,  2, 1, & !   216
     & 0.798366D0, 6.022173938465D-05, -5.54D-25, 0.000266,  2, 1, & !   217
     & 4.899113D0, 6.023243634701D-05, -7.83D-24, 0.001438,  2, 1, & !   218
     & 1.438855D0, 6.037584698633D-05,  7.45D-23, 0.000691,  2, 1, & !   219
     & 5.539601D0, 6.038654394869D-05,  6.72D-23, 0.003666,  2, 1  & !   220
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=221,230)   &
     & / &
     & 5.307586D0, 6.043155224162D-05, -5.17D-24, 0.000107,  2, 1, & !   221
     & 5.496476D0, 6.058564082398D-05,  6.67D-23, 0.000414,  2, 1, & !   222
     & 2.961474D0, 6.196613357052D-05, -1.25D-22, 0.000243,  2, 1, & !   223
     & 5.784402D0, 6.210954420983D-05, -4.29D-23, 0.000150,  2, 1, & !   224
     & 3.601962D0, 6.212024117220D-05, -5.02D-23, 0.000879,  2, 1, & !   225
     & 5.014139D0, 6.225293582983D-05,  3.62D-23, 0.000391,  2, 1, & !   226
     & 4.898131D0, 6.227543997629D-05, -6.04D-27, 0.000107,  1, 3, & !   227
     & 2.715692D0, 6.228613693866D-05, -7.28D-24, 0.001357,  1, 3, & !   228
     & 0.533252D0, 6.229683390102D-05, -1.46D-23, 0.003429,  1, 3, & !   229
     & 3.900644D0, 6.229684341068D-05, -1.30D-23, 0.000110,  2, 1  & !   230
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=231,240)   &
     & / &
     & 1.640530D0, 6.229794412276D-05, -3.62D-23, 0.000378,  2, 1, & !   231
     & 2.599684D0, 6.230864108512D-05, -4.35D-23, 0.012277,  2, 1, & !   232
     & 0.417245D0, 6.231933804749D-05, -5.07D-23, 0.065101,  2, 1, & !   233
     & 0.185229D0, 6.236434634041D-05, -1.23D-22, 0.000105,  2, 1, & !   234
     & 0.098580D0, 6.246274868680D-05,  3.16D-23, 0.000190,  2, 1, & !   235
     & 4.199326D0, 6.247344564917D-05,  2.43D-23, 0.001107,  2, 1, & !   236
     & 2.898366D0, 6.248524332361D-05, -6.22D-24, 0.000131,  2, 1, & !   237
     & 0.715926D0, 6.249594028597D-05, -1.35D-23, 0.000696,  2, 1, & !   238
     & 2.556559D0, 6.250773796041D-05, -4.40D-23, 0.000173,  2, 1, & !   239
     & 0.374119D0, 6.251843492278D-05, -5.13D-23, 0.001006,  2, 1  & !   240
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=241,250)   &
     & / &
     & 3.313055D0, 6.263934141563D-05,  6.72D-23, 0.000254,  1, 3, & !   241
     & 1.130616D0, 6.265003837800D-05,  5.99D-23, 0.000641,  1, 3, & !   242
     & 2.237894D0, 6.265114859973D-05,  3.83D-23, 0.000453,  2, 1, & !   243
     & 3.197047D0, 6.266184556210D-05,  3.10D-23, 0.014809,  2, 1, & !   244
     & 1.014608D0, 6.267254252446D-05,  2.37D-23, 0.078504,  2, 1, & !   245
     & 4.040193D0, 6.269504667092D-05, -1.24D-23, 0.000238,  1, 3, & !   246
     & 0.782593D0, 6.271755081739D-05, -4.86D-23, 0.000634,  2, 1, & !   247
     & 1.741746D0, 6.272824777975D-05, -5.59D-23, 0.000250,  2, 1, & !   248
     & 1.313290D0, 6.284914476295D-05,  6.10D-23, 0.000183,  2, 1, & !   249
     & 3.153922D0, 6.286094243739D-05,  3.05D-23, 0.000980,  2, 1  & !   250
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=251,260)   &
     & / &
     & 0.971483D0, 6.287163939975D-05,  2.32D-23, 0.005301,  2, 1, & !   251
     & 3.794411D0, 6.301505003907D-05,  1.06D-22, 0.000452,  2, 1, & !   252
     & 1.611972D0, 6.302574700143D-05,  9.82D-23, 0.002397,  2, 1, & !   253
     & 0.928358D0, 6.307073627504D-05,  2.27D-23, 0.000254,  2, 1, & !   254
     & 1.379956D0, 6.307075529436D-05,  2.59D-23, 0.000515,  2, 1, & !   255
     & 2.339110D0, 6.308145225672D-05,  1.86D-23, 0.000331,  2, 1, & !   256
     & 1.568847D0, 6.322484387672D-05,  9.77D-23, 0.000215,  2, 1, & !   257
     & 0.489145D0, 6.453893440560D-05, -7.27D-24, 0.000416,  2, 1, & !   258
     & 1.216283D0, 6.459463966089D-05, -8.69D-23, 0.000273,  2, 1, & !   259
     & 5.317029D0, 6.460533662326D-05, -9.42D-23, 0.001583,  2, 1  & !   260
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=261,270)   &
     & / &
     & 1.856772D0, 6.474874726257D-05, -1.19D-23, 0.000663,  2, 1, & !   261
     & 5.957518D0, 6.475944422494D-05, -1.92D-23, 0.004137,  2, 1, & !   262
     & 5.615711D0, 6.478193886174D-05, -5.69D-23, 0.000115,  2, 1, & !   263
     & 3.268948D0, 6.488144192021D-05,  7.45D-23, 0.000355,  2, 1, & !   264
     & 1.086509D0, 6.489213888257D-05,  6.72D-23, 0.001884,  2, 1, & !   265
     & 0.970501D0, 6.491464302904D-05,  3.10D-23, 0.000387,  1, 3, & !   266
     & 5.071247D0, 6.492533999140D-05,  2.38D-23, 0.004947,  1, 3, & !   267
     & 2.888808D0, 6.493603695377D-05,  1.65D-23, 0.012501,  1, 3, & !   268
     & 6.256200D0, 6.493604646342D-05,  1.81D-23, 0.000406,  2, 1, & !   269
     & 3.996086D0, 6.493714717550D-05, -5.15D-24, 0.002852,  2, 1  & !   270
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=271,280)   &
     & / &
     & 4.955240D0, 6.494784413786D-05, -1.24D-23, 0.092777,  2, 1, & !   271
     & 2.772800D0, 6.495854110023D-05, -1.97D-23, 0.491954,  2, 1, & !   272
     & 0.082806D0, 6.495856011954D-05, -1.65D-23, 0.000157,  2, 1, & !   273
     & 4.839232D0, 6.497034828433D-05, -4.86D-23, 0.000114,  1, 3, & !   274
     & 5.798385D0, 6.498104524669D-05, -5.59D-23, 0.000770,  1, 3, & !   275
     & 2.540785D0, 6.500354939316D-05, -9.21D-23, 0.001332,  2, 1, & !   276
     & 0.358346D0, 6.501424635552D-05, -9.93D-23, 0.000148,  2, 1, & !   277
     & 2.454136D0, 6.510195173954D-05,  6.26D-23, 0.000150,  2, 1, & !   278
     & 0.271696D0, 6.511264870191D-05,  5.53D-23, 0.000913,  2, 1, & !   279
     & 5.253921D0, 6.512444637635D-05,  2.48D-23, 0.000494,  2, 1  & !   280
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=281,290)   &
     & / &
     & 3.071482D0, 6.513514333872D-05,  1.75D-23, 0.002652,  2, 1, & !   281
     & 4.912114D0, 6.514694101316D-05, -1.30D-23, 0.000739,  2, 1, & !   282
     & 2.729675D0, 6.515763797552D-05, -2.02D-23, 0.004591,  2, 1, & !   283
     & 4.593450D0, 6.529035165247D-05,  6.93D-23, 0.000522,  2, 1, & !   284
     & 5.552603D0, 6.530104861484D-05,  6.21D-23, 0.017613,  2, 1, & !   285
     & 3.370164D0, 6.531174557720D-05,  5.48D-23, 0.093377,  2, 1, & !   286
     & 5.436595D0, 6.532355276130D-05,  2.59D-23, 0.000157,  1, 3, & !   287
     & 0.112564D0, 6.533424972367D-05,  1.86D-23, 0.001071,  1, 3, & !   288
     & 2.178995D0, 6.534605690776D-05, -1.03D-23, 0.000151,  2, 1, & !   289
     & 3.138148D0, 6.535675387013D-05, -1.76D-23, 0.005308,  2, 1  & !   290
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=291,300)   &
     & / &
     & 4.097302D0, 6.536745083249D-05, -2.48D-23, 0.001661,  2, 1, & !   291
     & 5.509478D0, 6.550014549013D-05,  6.15D-23, 0.000790,  2, 1, & !   292
     & 3.327039D0, 6.551084245249D-05,  5.42D-23, 0.004313,  2, 1, & !   293
     & 3.095023D0, 6.555585074542D-05, -1.81D-23, 0.000390,  2, 1, & !   294
     & 3.283914D0, 6.570993932779D-05,  5.37D-23, 0.000155,  2, 1, & !   295
     & 3.735512D0, 6.570995834710D-05,  5.69D-23, 0.001029,  2, 1, & !   296
     & 4.694665D0, 6.572065530947D-05,  4.96D-23, 0.000307,  2, 1, & !   297
     & 3.692387D0, 6.590905522239D-05,  5.64D-23, 0.000123,  2, 1, & !   298
     & 1.432525D0, 6.704544280071D-05, -6.26D-23, 0.000312,  2, 1, & !   299
     & 5.027140D0, 6.716744049598D-05,  3.10D-23, 0.000189,  2, 1  & !   300
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=301,310)   &
     & / &
     & 2.844701D0, 6.717813745834D-05,  2.38D-23, 0.001116,  2, 1, & !   301
     & 1.505408D0, 6.722203552953D-05, -2.70D-23, 0.000174,  1, 3, & !   302
     & 3.571839D0, 6.723384271363D-05, -5.59D-23, 0.001352,  2, 1, & !   303
     & 1.389400D0, 6.724453967600D-05, -6.31D-23, 0.007719,  2, 1, & !   304
     & 4.212328D0, 6.738795031531D-05,  1.92D-23, 0.001055,  2, 1, & !   305
     & 2.029889D0, 6.739864727768D-05,  1.19D-23, 0.008831,  2, 1, & !   306
     & 1.688082D0, 6.742114191448D-05, -2.59D-23, 0.000389,  2, 1, & !   307
     & 1.797873D0, 6.744365557061D-05, -6.05D-23, 0.000168,  2, 1, & !   308
     & 4.285210D0, 6.756454304414D-05,  5.48D-23, 0.000279,  1, 3, & !   309
     & 5.392488D0, 6.756565326587D-05,  3.32D-23, 0.000142,  2, 1  & !   310
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=311,320)   &
     & / &
     & 2.102771D0, 6.757524000651D-05,  4.75D-23, 0.000708,  1, 3, & !   311
     & 0.068457D0, 6.757635022824D-05,  2.59D-23, 0.014850,  2, 1, & !   312
     & 1.027610D0, 6.758704719061D-05,  1.86D-23, 0.484725,  2, 1, & !   313
     & 4.620801D0, 6.758706620992D-05,  2.18D-23, 0.000106,  2, 1, & !   314
     & 3.064029D0, 6.759694942083D-05,  1.65D-23, 0.000171,  2, 1, & !   315
     & 5.128356D0, 6.759774415297D-05,  1.13D-23, 2.569423,  2, 1, & !   316
     & 2.438362D0, 6.759776317229D-05,  1.45D-23, 0.000776,  2, 1, & !   317
     & 4.042779D0, 6.759853888511D-05,  6.22D-24, 0.000168,  2, 1, & !   318
     & 2.945917D0, 6.760844111534D-05,  4.07D-24, 0.000114,  2, 1, & !   319
     & 0.911602D0, 6.760955133707D-05, -1.76D-23, 0.000945,  1, 3  & !   320
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=321,330)   &
     & / &
     & 1.870756D0, 6.762024829943D-05, -2.48D-23, 0.006392,  1, 3, & !   321
     & 2.829909D0, 6.763094526180D-05, -3.21D-23, 0.000832,  1, 3, & !   322
     & 3.937187D0, 6.763205548353D-05, -5.37D-23, 0.000479,  2, 1, & !   323
     & 4.896340D0, 6.764275244590D-05, -6.10D-23, 0.016553,  2, 1, & !   324
     & 2.713901D0, 6.765344940826D-05, -6.83D-23, 0.002697,  2, 1, & !   325
     & 3.673055D0, 6.766414637063D-05, -7.56D-23, 0.000101,  2, 1, & !   326
     & 0.984485D0, 6.778614406590D-05,  1.81D-23, 0.000807,  2, 1, & !   327
     & 5.085231D0, 6.779684102826D-05,  1.08D-23, 0.007777,  2, 1, & !   328
     & 2.395237D0, 6.779686004758D-05,  1.40D-23, 0.000372,  2, 1, & !   329
     & 3.354390D0, 6.780755700994D-05,  6.73D-24, 0.000239,  2, 1  & !   330
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=331,340)   &
     & / &
     & 5.195022D0, 6.781935468438D-05, -2.38D-23, 0.000178,  2, 1, & !   331
     & 4.853215D0, 6.784184932119D-05, -6.16D-23, 0.000204,  2, 1, & !   332
     & 4.766566D0, 6.794025166758D-05,  9.31D-23, 0.000271,  2, 1, & !   333
     & 2.584127D0, 6.795094862994D-05,  8.58D-23, 0.001465,  2, 1, & !   334
     & 1.508966D0, 6.796275581404D-05,  5.69D-23, 0.000184,  1, 3, & !   335
     & 2.468119D0, 6.797345277641D-05,  4.96D-23, 0.001245,  1, 3, & !   336
     & 3.427273D0, 6.798414973877D-05,  4.24D-23, 0.000174,  1, 3, & !   337
     & 4.534551D0, 6.798525996050D-05,  2.07D-23, 0.000959,  2, 1, & !   338
     & 5.042106D0, 6.799593790355D-05,  1.03D-23, 0.000108,  2, 1, & !   339
     & 5.493704D0, 6.799595692287D-05,  1.35D-23, 0.033491,  2, 1  & !   340
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=341,350)   &
     & / &
     & 0.169672D0, 6.800665388524D-05,  6.19D-24, 0.007300,  2, 1, & !   341
     & 4.270418D0, 6.801735084760D-05, -1.08D-24, 0.000489,  2, 1, & !   342
     & 5.450579D0, 6.819505379816D-05,  1.29D-23, 0.002209,  2, 1, & !   343
     & 0.126547D0, 6.820575076053D-05,  5.65D-24, 0.000174,  2, 1, & !   344
     & 6.091068D0, 6.834916139984D-05,  8.80D-23, 0.000625,  2, 1, & !   345
     & 3.908629D0, 6.835985836221D-05,  8.07D-23, 0.000133,  2, 1, & !   346
     & 5.407454D0, 6.839415067345D-05,  1.24D-23, 0.000103,  2, 1, & !   347
     & 5.970520D0, 6.967394889108D-05, -2.43D-23, 0.000193,  2, 1, & !   348
     & 3.788081D0, 6.968464585345D-05, -3.16D-23, 0.000908,  2, 1, & !   349
     & 6.043403D0, 6.985054161991D-05,  1.14D-23, 0.000145,  1, 3  & !   350
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=351,360)   &
     & / &
     & 4.968241D0, 6.986234880401D-05, -1.76D-23, 0.000252,  2, 1, & !   351
     & 5.927395D0, 6.987304576637D-05, -2.48D-23, 0.004292,  2, 1, & !   352
     & 3.744956D0, 6.988374272874D-05, -3.21D-23, 0.018948,  2, 1, & !   353
     & 4.385444D0, 7.003785033042D-05,  4.29D-23, 0.000292,  2, 1, & !   354
     & 4.043637D0, 7.006034496723D-05,  5.14D-24, 0.000457,  2, 1, & !   355
     & 4.153429D0, 7.008285862335D-05, -2.94D-23, 0.001035,  2, 1, & !   356
     & 1.970990D0, 7.009355558571D-05, -3.67D-23, 0.000249,  2, 1, & !   357
     & 5.565605D0, 7.021555328098D-05,  5.69D-23, 0.001181,  2, 1, & !   358
     & 0.241573D0, 7.022625024335D-05,  4.97D-23, 0.013443,  2, 1, & !   359
     & 4.342319D0, 7.023694720571D-05,  4.24D-23, 0.072640,  2, 1  & !   360
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=361,370)   &
     & / &
     & 2.308004D0, 7.023805742744D-05,  2.08D-23, 0.000175,  1, 3, & !   361
     & 3.267158D0, 7.024875438981D-05,  1.35D-23, 0.005784,  1, 3, & !   362
     & 4.226311D0, 7.025945135218D-05,  6.20D-24, 0.039110,  1, 3, & !   363
     & 4.452111D0, 7.025946086183D-05,  7.80D-24, 0.000161,  2, 1, & !   364
     & 5.185465D0, 7.027014831454D-05, -1.07D-24, 0.005059,  1, 3, & !   365
     & 0.009557D0, 7.027125853627D-05, -2.27D-23, 0.005852,  2, 1, & !   366
     & 0.968711D0, 7.028195549864D-05, -3.00D-23, 0.201970,  2, 1, & !   367
     & 5.069457D0, 7.029265246100D-05, -3.73D-23, 0.040534,  2, 1, & !   368
     & 6.028610D0, 7.030334942337D-05, -4.45D-23, 0.001133,  2, 1, & !   369
     & 4.750792D0, 7.043606310032D-05,  4.50D-23, 0.000254,  2, 1  & !   370
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=371,380)   &
     & / &
     & 1.267393D0, 7.045855773713D-05,  7.27D-24, 0.001121,  2, 1, & !   371
     & 5.368139D0, 7.046925469949D-05, -9.74D-27, 0.000234,  2, 1, & !   372
     & 0.925586D0, 7.048105237393D-05, -3.05D-23, 0.001241,  2, 1, & !   373
     & 5.026332D0, 7.049174933630D-05, -3.78D-23, 0.000315,  2, 1, & !   374
     & 0.606921D0, 7.062446301325D-05,  5.18D-23, 0.001119,  2, 1, & !   375
     & 1.566075D0, 7.063515997561D-05,  4.45D-23, 0.038648,  2, 1, & !   376
     & 5.666821D0, 7.064585693798D-05,  3.72D-23, 0.008480,  2, 1, & !   377
     & 0.342789D0, 7.065655390034D-05,  3.00D-23, 0.000197,  2, 1, & !   378
     & 1.450067D0, 7.065766412207D-05,  8.33D-24, 0.000162,  1, 3, & !   379
     & 2.409220D0, 7.066836108444D-05,  1.05D-24, 0.000100,  1, 3  & !   380
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=381,390)   &
     & / &
     & 5.434805D0, 7.069086523090D-05, -3.51D-23, 0.000167,  2, 1, & !   381
     & 3.252366D0, 7.070156219327D-05, -4.24D-23, 0.000138,  2, 1, & !   382
     & 1.522949D0, 7.083425685090D-05,  4.40D-23, 0.001651,  2, 1, & !   383
     & 5.623695D0, 7.084495381327D-05,  3.67D-23, 0.000379,  2, 1, & !   384
     & 3.045169D0, 7.212475203090D-05,  1.44D-26, 0.002833,  2, 1, & !   385
     & 2.042890D0, 7.231315194382D-05,  6.75D-24, 0.000559,  2, 1, & !   386
     & 3.002044D0, 7.232384890619D-05, -5.24D-25, 0.069873,  2, 1, & !   387
     & 1.040612D0, 7.250155185675D-05,  1.35D-23, 0.000977,  2, 1, & !   388
     & 1.999765D0, 7.251224881912D-05,  6.21D-24, 0.013658,  2, 1, & !   389
     & 2.958919D0, 7.252294578148D-05, -1.06D-24, 1.195341,  2, 1  & !   390
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=391,400)   &
     & / &
     & 3.410517D0, 7.252296480080D-05,  2.14D-24, 0.000626,  2, 1, & !   391
     & 5.984503D0, 7.254544992794D-05, -3.72D-23, 0.000397,  1, 3, & !   392
     & 2.726903D0, 7.256795407441D-05, -7.34D-23, 0.001792,  2, 1, & !   393
     & 0.544464D0, 7.257865103677D-05, -8.07D-23, 0.000359,  2, 1, & !   394
     & 5.098233D0, 7.271134569441D-05,  5.67D-24, 0.000268,  2, 1, & !   395
     & 6.057386D0, 7.272204265677D-05, -1.60D-24, 0.009998,  2, 1, & !   396
     & 3.367392D0, 7.272206167609D-05,  1.60D-24, 0.029033,  2, 1, & !   397
     & 4.326545D0, 7.273275863845D-05, -5.67D-24, 0.000738,  2, 1, & !   398
     & 2.597129D0, 7.286545329609D-05,  8.07D-23, 0.000664,  2, 1, & !   399
     & 5.622714D0, 7.288795744255D-05,  4.45D-23, 0.000319,  1, 3  & !   400
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=401,410)   &
     & / &
     & 0.298682D0, 7.289865440492D-05,  3.72D-23, 0.002130,  1, 3, & !   401
     & 1.405960D0, 7.289976462665D-05,  1.56D-23, 0.000451,  2, 1, & !   402
     & 1.257835D0, 7.290935136728D-05,  3.00D-23, 0.000275,  1, 3, & !   403
     & 2.365113D0, 7.291046158901D-05,  8.34D-24, 0.071534,  2, 1, & !   404
     & 2.872668D0, 7.292113953206D-05, -2.14D-24, 0.000740,  2, 1, & !   405
     & 3.324267D0, 7.292115855138D-05,  1.06D-24, 3.612086,  2, 1, & !   406
     & 1.141827D0, 7.293185551375D-05, -6.21D-24, 0.490219,  2, 1, & !   407
     & 4.735019D0, 7.293187453306D-05, -3.01D-24, 0.000120,  2, 1, & !   408
     & 2.100981D0, 7.294255247611D-05, -1.35D-23, 0.010532,  2, 1, & !   409
     & 3.208259D0, 7.294366269784D-05, -3.51D-23, 0.000778,  1, 3  & !   410
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=411,420)   &
     & / &
     & 1.025820D0, 7.295435966021D-05, -4.24D-23, 0.000319,  1, 3, & !   411
     & 5.463581D0, 7.310955846431D-05,  7.80D-24, 0.000108,  2, 1, & !   412
     & 3.281141D0, 7.312025542667D-05,  5.24D-25, 0.029042,  2, 1, & !   413
     & 3.732740D0, 7.312027444599D-05,  3.73D-24, 0.000420,  2, 1, & !   414
     & 1.098702D0, 7.313095238904D-05, -6.75D-24, 0.000546,  2, 1, & !   415
     & 3.921630D0, 7.327436302835D-05,  7.55D-23, 0.001792,  2, 1, & !   416
     & 1.739191D0, 7.328505999072D-05,  6.83D-23, 0.000508,  2, 1, & !   417
     & 3.805622D0, 7.329686717482D-05,  3.94D-23, 0.000145,  1, 3, & !   418
     & 3.238016D0, 7.331935230196D-05, -1.44D-26, 0.000698,  2, 1, & !   419
     & 0.548022D0, 7.331937132128D-05,  3.19D-24, 0.051435,  2, 1  & !   420
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=421,430)   &
     & / &
     & 1.507176D0, 7.333006828364D-05, -4.09D-24, 0.001990,  2, 1, & !   421
     & 5.607922D0, 7.334076524601D-05, -1.14D-23, 0.000977,  2, 1, & !   422
     & 0.504897D0, 7.351846819657D-05,  2.65D-24, 0.003002,  2, 1, & !   423
     & 0.461772D0, 7.371756507186D-05,  2.11D-24, 0.000122,  2, 1, & !   424
     & 3.757957D0, 7.479824739488D-05, -3.72D-23, 0.000219,  2, 1, & !   425
     & 5.125584D0, 7.500806025186D-05, -4.18D-23, 0.001651,  2, 1, & !   426
     & 2.943145D0, 7.501875721422D-05, -4.91D-23, 0.000317,  2, 1, & !   427
     & 3.396167D0, 7.514075490949D-05,  4.45D-23, 0.000138,  2, 1, & !   428
     & 4.355321D0, 7.515145187186D-05,  3.73D-23, 0.001148,  2, 1, & !   429
     & 5.314474D0, 7.516214883422D-05,  3.00D-23, 0.000182,  2, 1  & !   430
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=431,440)   &
     & / &
     & 4.239313D0, 7.517395601832D-05,  1.07D-24, 0.000100,  1, 3, & !   431
     & 2.056874D0, 7.518465298069D-05, -6.20D-24, 0.000447,  1, 3, & !   432
     & 4.123305D0, 7.519646016478D-05, -3.51D-23, 0.001238,  2, 1, & !   433
     & 5.082459D0, 7.520715712715D-05, -4.24D-23, 0.038636,  2, 1, & !   434
     & 2.900020D0, 7.521785408951D-05, -4.97D-23, 0.007664,  2, 1, & !   435
     & 3.859173D0, 7.522855105188D-05, -5.69D-23, 0.000164,  2, 1, & !   436
     & 5.722948D0, 7.536126472883D-05,  3.26D-23, 0.001241,  2, 1, & !   437
     & 3.540508D0, 7.537196169119D-05,  2.54D-23, 0.000192,  2, 1, & !   438
     & 5.381141D0, 7.538375936564D-05, -5.14D-24, 0.001121,  2, 1, & !   439
     & 3.198701D0, 7.539445632800D-05, -1.24D-23, 0.000207,  2, 1  & !   440
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=441,450)   &
     & / &
     & 1.897741D0, 7.540625400244D-05, -4.29D-23, 0.000254,  2, 1, & !   441
     & 2.654238D0, 7.553785745766D-05,  6.83D-23, 0.000161,  1, 3, & !   442
     & 4.720669D0, 7.554966464176D-05,  3.94D-23, 0.005913,  2, 1, & !   443
     & 5.679822D0, 7.556036160412D-05,  3.21D-23, 0.202043,  2, 1, & !   444
     & 3.497383D0, 7.557105856649D-05,  2.48D-23, 0.040048,  2, 1, & !   445
     & 4.604661D0, 7.557216878822D-05,  3.20D-24, 0.000465,  1, 3, & !   446
     & 4.456537D0, 7.558175552885D-05,  1.76D-23, 0.000861,  2, 1, & !   447
     & 2.196423D0, 7.558285624093D-05, -5.68D-24, 0.000162,  2, 1, & !   448
     & 5.563815D0, 7.558286575059D-05, -4.08D-24, 0.014274,  1, 3, & !   449
     & 3.381375D0, 7.559356271295D-05, -1.14D-23, 0.005784,  1, 3  & !   450
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=451,460)   &
     & / &
     & 1.198936D0, 7.560425967532D-05, -1.86D-23, 0.000480,  1, 3, & !   451
     & 5.447807D0, 7.560536989705D-05, -4.03D-23, 0.003124,  2, 1, & !   452
     & 3.265368D0, 7.561606685941D-05, -4.75D-23, 0.001963,  2, 1, & !   453
     & 1.082928D0, 7.562676382178D-05, -5.48D-23, 0.001181,  2, 1, & !   454
     & 5.183675D0, 7.563746078414D-05, -6.21D-23, 0.000179,  2, 1, & !   455
     & 2.495105D0, 7.575945847941D-05,  3.16D-23, 0.001035,  2, 1, & !   456
     & 0.312665D0, 7.577015544178D-05,  2.43D-23, 0.000155,  2, 1, & !   457
     & 6.045170D0, 7.595857437402D-05,  3.42D-23, 0.000815,  2, 1, & !   458
     & 3.862731D0, 7.596927133639D-05,  2.70D-23, 0.000624,  2, 1, & !   459
     & 1.680292D0, 7.597996829875D-05,  1.97D-23, 0.000252,  2, 1  & !   460
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=461,470)   &
     & / &
     & 6.113513D0, 7.743745044763D-05, -6.19D-24, 0.000185,  2, 1, & !   461
     & 1.241080D0, 7.744816642931D-05, -1.03D-23, 0.000104,  2, 1, & !   462
     & 0.557466D0, 7.749315570292D-05, -8.58D-23, 0.000629,  2, 1, & !   463
     & 4.658212D0, 7.750385266528D-05, -9.31D-23, 0.000125,  2, 1, & !   464
     & 1.197954D0, 7.764726330460D-05, -1.08D-23, 0.002206,  2, 1, & !   465
     & 5.298701D0, 7.765796026696D-05, -1.81D-23, 0.000425,  2, 1, & !   466
     & 0.427691D0, 7.779065492460D-05,  6.83D-23, 0.000101,  2, 1, & !   467
     & 3.337268D0, 7.783566321753D-05, -4.07D-24, 0.001069,  2, 1, & !   468
     & 1.154829D0, 7.784636017989D-05, -1.13D-23, 0.033509,  2, 1, & !   469
     & 5.255575D0, 7.785705714226D-05, -1.86D-23, 0.006562,  2, 1  & !   470
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=471,480)   &
     & / &
     & 6.214729D0, 7.786775410462D-05, -2.59D-23, 0.000140,  2, 1, & !   471
     & 1.038821D0, 7.786886432635D-05, -4.75D-23, 0.000454,  1, 3, & !   472
     & 5.139568D0, 7.787956128872D-05, -5.48D-23, 0.000184,  1, 3, & !   473
     & 1.795318D0, 7.800046778157D-05,  6.37D-23, 0.000204,  2, 1, & !   474
     & 1.453511D0, 7.802296241838D-05,  2.59D-23, 0.000177,  2, 1, & !   475
     & 4.253297D0, 7.804545705518D-05, -1.19D-23, 0.000370,  2, 1, & !   476
     & 4.704895D0, 7.804547607450D-05, -8.68D-24, 0.000334,  2, 1, & !   477
     & 2.522456D0, 7.805617303686D-05, -1.60D-23, 0.000118,  2, 1, & !   478
     & 0.793039D0, 7.818886769450D-05,  7.04D-23, 0.000393,  2, 1, & !   479
     & 1.752193D0, 7.819956465686D-05,  6.31D-23, 0.016562,  2, 1  & !   480
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=481,490)   &
     & / &
     & 5.852939D0, 7.821026161923D-05,  5.59D-23, 0.003280,  2, 1, & !   481
     & 1.636185D0, 7.822206880333D-05,  2.70D-23, 0.002333,  1, 3, & !   482
     & 5.736931D0, 7.823276576569D-05,  1.97D-23, 0.000945,  1, 3, & !   483
     & 4.661770D0, 7.824457294979D-05, -9.22D-24, 0.110515,  2, 1, & !   484
     & 2.479331D0, 7.825526991216D-05, -1.65D-23, 0.070813,  2, 1, & !   485
     & 0.296892D0, 7.826596687452D-05, -2.38D-23, 0.014836,  2, 1, & !   486
     & 4.397638D0, 7.827666383689D-05, -3.10D-23, 0.000967,  2, 1, & !   487
     & 4.850660D0, 7.839866153215D-05,  6.26D-23, 0.000168,  2, 1, & !   488
     & 1.477052D0, 7.844366982508D-05, -9.76D-24, 0.000380,  2, 1, & !   489
     & 5.577798D0, 7.845436678745D-05, -1.70D-23, 0.000154,  2, 1  & !   490
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=491,500)   &
     & / &
     & 2.117541D0, 7.859777742676D-05,  6.53D-23, 0.000332,  2, 1, & !   491
     & 6.218287D0, 7.860847438913D-05,  5.80D-23, 0.000197,  2, 1, & !   492
     & 2.956147D0, 7.993326188037D-05, -5.42D-23, 0.000113,  2, 1, & !   493
     & 2.913021D0, 8.013235875566D-05, -5.48D-23, 0.001019,  2, 1, & !   494
     & 0.730582D0, 8.014305571802D-05, -6.21D-23, 0.000194,  2, 1, & !   495
     & 3.553510D0, 8.028646635734D-05,  2.02D-23, 0.000387,  2, 1, & !   496
     & 0.179902D0, 8.033147465027D-05, -5.21D-23, 0.000185,  2, 1, & !   497
     & 4.280648D0, 8.034217161263D-05, -5.94D-23, 0.000115,  2, 1, & !   498
     & 5.692824D0, 8.047486627027D-05,  2.70D-23, 0.000243,  2, 1, & !   499
     & 3.510385D0, 8.048556323263D-05,  1.97D-23, 0.005306,  2, 1  & !   500
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=501,510)   &
     & / &
     & 1.327946D0, 8.049626019500D-05,  1.24D-23, 0.001037,  2, 1, & !   501
     & 3.394377D0, 8.050806737910D-05, -1.65D-23, 0.000391,  1, 3, & !   502
     & 1.211938D0, 8.051876434146D-05, -2.38D-23, 0.000157,  1, 3, & !   503
     & 0.136777D0, 8.053057152556D-05, -5.27D-23, 0.004020,  2, 1, & !   504
     & 4.237523D0, 8.054126848792D-05, -5.99D-23, 0.002574,  2, 1, & !   505
     & 2.055084D0, 8.055196545029D-05, -6.72D-23, 0.000521,  2, 1, & !   506
     & 0.777266D0, 8.068467912724D-05,  2.24D-23, 0.000197,  2, 1, & !   507
     & 4.878012D0, 8.069537608960D-05,  1.51D-23, 0.000108,  2, 1, & !   508
     & 0.435459D0, 8.070717376404D-05, -1.54D-23, 0.000114,  2, 1, & !   509
     & 4.107749D0, 8.083876770960D-05,  9.42D-23, 0.001330,  2, 1  & !   510
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=511,520)   &
     & / &
     & 1.925309D0, 8.084946467197D-05,  8.69D-23, 0.000263,  2, 1, & !   511
     & 3.991741D0, 8.086127185607D-05,  5.80D-23, 0.000281,  1, 3, & !   512
     & 1.809302D0, 8.087196881843D-05,  5.07D-23, 0.000114,  1, 3, & !   513
     & 0.734140D0, 8.088377600253D-05,  2.18D-23, 0.021164,  2, 1, & !   514
     & 4.834886D0, 8.089447296490D-05,  1.45D-23, 0.013551,  2, 1, & !   515
     & 2.652447D0, 8.090516992726D-05,  7.27D-24, 0.002844,  2, 1, & !   516
     & 0.618133D0, 8.090628014899D-05, -1.44D-23, 0.000538,  1, 3, & !   517
     & 0.470008D0, 8.091586688963D-05, -3.70D-27, 0.000186,  2, 1, & !   518
     & 4.718879D0, 8.091697711136D-05, -2.16D-23, 0.000456,  1, 3, & !   519
     & 2.536439D0, 8.092767407373D-05, -2.89D-23, 0.000141,  1, 3  & !   520
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=521,530)   &
     & / &
     & 3.832608D0, 8.108287287782D-05,  2.13D-23, 0.000178,  2, 1, & !   521
     & 5.268577D0, 8.277156180840D-05, -2.37D-23, 0.000515,  2, 1, & !   522
     & 1.894969D0, 8.281657010133D-05, -9.61D-23, 0.000103,  2, 1, & !   523
     & 2.535458D0, 8.297067770301D-05, -2.11D-23, 0.000228,  2, 1, & !   524
     & 0.353018D0, 8.298137466537D-05, -2.84D-23, 0.000143,  2, 1, & !   525
     & 5.865941D0, 8.312476628537D-05,  5.07D-23, 0.000634,  2, 1, & !   526
     & 3.683502D0, 8.313546324774D-05,  4.35D-23, 0.000123,  2, 1, & !   527
     & 2.492332D0, 8.316977457830D-05, -2.16D-23, 0.003379,  2, 1, & !   528
     & 0.309893D0, 8.318047154067D-05, -2.89D-23, 0.002165,  2, 1, & !   529
     & 4.410639D0, 8.319116850303D-05, -3.62D-23, 0.000452,  2, 1  & !   530
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=531,540)   &
     & / &
     & 0.180119D0, 8.347797076235D-05,  1.25D-22, 0.000105,  2, 1, & !   531
     & 3.089696D0, 8.352297905527D-05,  5.29D-23, 0.002800,  2, 1, & !   532
     & 0.907257D0, 8.353367601764D-05,  4.56D-23, 0.001794,  2, 1, & !   533
     & 5.008003D0, 8.354437298000D-05,  3.83D-23, 0.000376,  2, 1, & !   534
     & 2.973688D0, 8.354548320174D-05,  1.67D-23, 0.000148,  1, 3, & !   535
     & 0.791249D0, 8.355618016410D-05,  9.41D-24, 0.000125,  1, 3, & !   536
     & 1.340948D0, 8.541076486114D-05,  7.29D-24, 0.000101,  2, 1, & !   537
     & 4.250525D0, 8.545577315407D-05, -6.51D-23, 0.000158,  2, 1, & !   538
     & 2.068085D0, 8.546647011643D-05, -7.23D-23, 0.000101,  2, 1, & !   539
     & 4.847888D0, 8.580897763104D-05,  9.42D-24, 0.000817,  2, 1  & !   540
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=541,550)   &
     & / &
     & 2.665449D0, 8.581967459341D-05,  2.14D-24, 0.000523,  2, 1, & !   541
     & 0.483010D0, 8.583037155577D-05, -5.13D-24, 0.000110,  2, 1, & !   542
     & 5.445252D0, 8.616218210801D-05,  8.39D-23, 0.000315,  2, 1, & !   543
     & 3.262813D0, 8.617287907038D-05,  7.66D-23, 0.000202,  2, 1, & !   544
     & 0.920259D0, 8.844818068378D-05,  4.05D-23, 0.000135,  2, 1, & !   545
     & 1.199837D0, 1.250368888649D-04, -9.93D-23, 0.000125,  2, 2, & !   546
     & 1.797201D0, 1.253900933418D-04, -2.49D-23, 0.000238,  2, 2, & !   547
     & 2.394564D0, 1.257432978188D-04,  4.96D-23, 0.000107,  2, 2, & !   548
     & 2.958029D0, 1.273228874406D-04, -1.43D-22, 0.000174,  2, 2, & !   549
     & 3.671401D0, 1.276535877712D-04, -3.21D-23, 0.000111,  2, 3  & !   550
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=551,560)   &
     & / &
     & 3.555393D0, 1.276760919176D-04, -6.83D-23, 0.001033,  2, 2, & !   551
     & 4.152757D0, 1.280292963946D-04,  6.18D-24, 0.001249,  2, 2, & !   552
     & 4.109631D0, 1.282283932699D-04,  5.64D-24, 0.000176,  2, 2, & !   553
     & 4.750120D0, 1.283825008716D-04,  8.07D-23, 0.000243,  2, 2, & !   554
     & 5.429593D0, 1.299395863469D-04, -7.56D-23, 0.000252,  2, 3, & !   555
     & 5.313585D0, 1.299620904934D-04, -1.12D-22, 0.001809,  2, 2, & !   556
     & 2.812481D0, 1.301161980951D-04, -3.67D-23, 0.000182,  2, 2, & !   557
     & 6.026956D0, 1.302927908239D-04, -1.09D-24, 0.000550,  2, 3, & !   558
     & 4.951795D0, 1.303045980080D-04, -3.00D-23, 0.000283,  2, 2, & !   559
     & 5.910949D0, 1.303152949704D-04, -3.73D-23, 0.007567,  2, 2  & !   560
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=561,570)   &
     & / &
     & 3.409845D0, 1.304694025720D-04,  3.78D-23, 0.000117,  2, 2, & !   561
     & 5.867824D0, 1.305143918456D-04, -3.78D-23, 0.000626,  2, 2, & !   562
     & 0.341135D0, 1.306459953009D-04,  7.34D-23, 0.000105,  2, 3, & !   563
     & 5.549159D0, 1.306578024850D-04,  4.45D-23, 0.000176,  2, 2, & !   564
     & 0.225127D0, 1.306684994473D-04,  3.72D-23, 0.004693,  2, 2, & !   565
     & 0.182002D0, 1.308675963226D-04,  3.67D-23, 0.000616,  2, 2, & !   566
     & 0.822491D0, 1.310217039243D-04,  1.12D-22, 0.000285,  2, 2, & !   567
     & 4.570673D0, 1.324021966708D-04, -8.02D-23, 0.000330,  2, 2, & !   568
     & 5.982849D0, 1.325348913285D-04,  6.20D-24, 0.000148,  2, 2, & !   569
     & 3.684403D0, 1.325680924373D-04, -3.73D-23, 0.000308,  2, 3  & !   570
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=571,580)   &
     & / &
     & 1.501963D0, 1.325787893997D-04, -4.45D-23, 0.001810,  2, 3, & !   571
     & 0.426802D0, 1.325905965838D-04, -7.34D-23, 0.000660,  2, 2, & !   572
     & 1.385956D0, 1.326012935461D-04, -8.07D-23, 0.017658,  2, 2, & !   573
     & 5.168037D0, 1.327554011478D-04, -5.69D-24, 0.000868,  2, 2, & !   574
     & 1.684637D0, 1.327778957846D-04, -4.35D-23, 0.000279,  2, 2, & !   575
     & 1.342830D0, 1.328003904214D-04, -8.12D-23, 0.000378,  2, 2, & !   576
     & 0.297028D0, 1.328880958054D-04,  8.07D-23, 0.000195,  2, 2, & !   577
     & 4.281766D0, 1.329212969143D-04,  3.72D-23, 0.000309,  2, 3, & !   578
     & 2.099327D0, 1.329319938766D-04,  3.00D-23, 0.001820,  2, 3, & !   579
     & 1.024166D0, 1.329438010607D-04,  1.05D-24, 0.001709,  2, 2  & !   580
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=581,590)   &
     & / &
     & 1.983319D0, 1.329544980231D-04, -6.23D-24, 0.045770,  2, 2, & !   581
     & 5.765401D0, 1.331086056248D-04,  6.88D-23, 0.000180,  2, 2, & !   582
     & 2.056202D0, 1.331310907519D-04,  2.94D-23, 0.000123,  2, 3, & !   583
     & 2.282001D0, 1.331311002616D-04,  3.10D-23, 0.000217,  2, 2, & !   584
     & 0.981040D0, 1.331428979360D-04,  5.08D-25, 0.000127,  2, 2, & !   585
     & 1.940194D0, 1.331535948984D-04, -6.77D-24, 0.003466,  2, 2, & !   586
     & 1.621529D0, 1.332970055377D-04,  7.55D-23, 0.000330,  2, 2, & !   587
     & 2.580683D0, 1.333077025001D-04,  6.83D-23, 0.008832,  2, 2, & !   588
     & 1.897069D0, 1.333526917737D-04, -7.31D-24, 0.000180,  2, 2, & !   589
     & 2.537558D0, 1.335067993754D-04,  6.77D-23, 0.000999,  2, 2  & !   590
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=591,600)   &
     & / &
     & 3.178046D0, 1.336609069770D-04,  1.43D-22, 0.000129,  2, 2, & !   591
     & 1.457856D0, 1.348208899042D-04, -3.72D-23, 0.000198,  2, 2, & !   592
     & 0.002555D0, 1.348872921219D-04, -1.24D-22, 0.000585,  2, 2, & !   593
     & 0.759052D0, 1.350188955771D-04, -1.30D-23, 0.000106,  2, 3, & !   594
     & 0.643044D0, 1.350413997236D-04, -4.91D-23, 0.002118,  2, 2, & !   595
     & 2.055220D0, 1.351740943812D-04,  3.72D-23, 0.000943,  2, 2, & !   596
     & 6.039958D0, 1.352072954900D-04, -6.22D-24, 0.001777,  2, 3, & !   597
     & 3.857519D0, 1.352179924524D-04, -1.35D-23, 0.010462,  2, 3, & !   598
     & 0.941726D0, 1.352180019621D-04, -1.19D-23, 0.000264,  2, 2, & !   599
     & 2.782358D0, 1.352297996365D-04, -4.24D-23, 0.005855,  2, 2  & !   600
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=601,610)   &
     & / &
     & 3.741511D0, 1.352404965989D-04, -4.97D-23, 0.156950,  2, 2, & !   601
     & 1.240407D0, 1.353946042005D-04,  2.53D-23, 0.002667,  2, 2, & !   602
     & 3.814394D0, 1.354170893277D-04, -1.40D-23, 0.000113,  2, 3, & !   603
     & 4.040193D0, 1.354170988374D-04, -1.24D-23, 0.001677,  2, 2, & !   604
     & 3.698386D0, 1.354395934742D-04, -5.02D-23, 0.002427,  2, 2, & !   605
     & 2.652584D0, 1.355272988582D-04,  1.12D-22, 0.000222,  2, 2, & !   606
     & 0.354137D0, 1.355604999670D-04,  6.83D-23, 0.000332,  2, 3, & !   607
     & 4.454883D0, 1.355711969294D-04,  6.10D-23, 0.001955,  2, 3, & !   608
     & 3.379721D0, 1.355830041135D-04,  3.21D-23, 0.007064,  2, 2, & !   609
     & 4.338875D0, 1.355937010758D-04,  2.48D-23, 0.189426,  2, 2  & !   610
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=611,620)   &
     & / &
     & 1.648881D0, 1.355937200952D-04,  2.80D-23, 0.000123,  2, 2, & !   611
     & 4.222867D0, 1.356162052223D-04, -1.14D-23, 0.000219,  2, 3, & !   612
     & 1.924420D0, 1.356494063311D-04, -5.48D-23, 0.000119,  2, 2, & !   613
     & 4.637557D0, 1.357703033143D-04,  6.21D-23, 0.000441,  2, 2, & !   614
     & 3.336596D0, 1.357821009888D-04,  3.15D-23, 0.000467,  2, 2, & !   615
     & 4.295750D0, 1.357927979511D-04,  2.43D-23, 0.012775,  2, 2, & !   616
     & 3.977085D0, 1.359362085904D-04,  1.07D-22, 0.000216,  2, 2, & !   617
     & 4.936238D0, 1.359469055528D-04,  9.93D-23, 0.005777,  2, 2, & !   618
     & 4.252625D0, 1.359918948264D-04,  2.37D-23, 0.000612,  2, 2, & !   619
     & 1.562630D0, 1.359919138457D-04,  2.69D-23, 0.000112,  2, 2  & !   620
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=621,630)   &
     & / &
     & 2.521784D0, 1.360026108081D-04,  1.97D-23, 0.000158,  2, 2, & !   621
     & 4.893113D0, 1.361460024281D-04,  9.88D-23, 0.000519,  2, 2, & !   622
     & 2.401236D0, 1.373273982993D-04, -9.26D-23, 0.000132,  2, 2, & !   623
     & 3.813412D0, 1.374600929570D-04, -6.21D-24, 0.001003,  2, 2, & !   624
     & 2.474119D0, 1.375039910282D-04, -5.69D-23, 0.000233,  2, 3, & !   625
     & 1.398957D0, 1.375157982123D-04, -8.58D-23, 0.000130,  2, 2, & !   626
     & 2.358111D0, 1.375264951746D-04, -9.31D-23, 0.003817,  2, 2, & !   627
     & 3.114607D0, 1.376580986299D-04,  1.81D-23, 0.000197,  2, 3, & !   628
     & 2.039446D0, 1.376699058140D-04, -1.08D-23, 0.000316,  2, 2, & !   629
     & 2.998600D0, 1.376806027763D-04, -1.81D-23, 0.009970,  2, 2  & !   630
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=631,640)   &
     & / &
     & 2.656793D0, 1.377030974131D-04, -5.59D-23, 0.000277,  2, 2, & !   631
     & 3.451622D0, 1.378026004716D-04,  7.55D-23, 0.000169,  2, 2, & !   632
     & 4.410776D0, 1.378132974340D-04,  6.83D-23, 0.004543,  2, 2, & !   633
     & 3.639088D0, 1.378347103780D-04,  5.69D-23, 0.000137,  2, 2, & !   634
     & 1.153175D0, 1.378358015804D-04,  3.21D-23, 0.000348,  2, 3, & !   635
     & 2.112329D0, 1.378464985428D-04,  2.48D-23, 0.006478,  2, 3, & !   636
     & 6.213075D0, 1.378571955051D-04,  1.75D-23, 0.038122,  2, 3, & !   637
     & 3.297281D0, 1.378572050148D-04,  1.91D-23, 0.000967,  2, 2, & !   638
     & 4.178760D0, 1.378583057269D-04, -4.08D-24, 0.000618,  2, 2, & !   639
     & 5.137914D0, 1.378690026892D-04, -1.14D-23, 0.044279,  2, 2  & !   640
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=641,650)   &
     & / &
     & 4.024008D0, 1.378789549565D-04,  9.84D-24, 0.000116,  2, 2, & !   641
     & 6.097067D0, 1.378796996516D-04, -1.86D-23, 1.186047,  2, 2, & !   642
     & 3.407073D0, 1.378797186709D-04, -1.54D-23, 0.000606,  2, 2, & !   643
     & 5.021069D0, 1.378804443468D-04, -4.71D-23, 0.000119,  2, 2, & !   644
     & 5.981059D0, 1.379022037981D-04, -5.48D-23, 0.000692,  2, 3, & !   645
     & 3.798620D0, 1.379129007604D-04, -6.21D-23, 0.000123,  2, 3, & !   646
     & 2.723459D0, 1.379247079445D-04, -9.10D-23, 0.000287,  2, 2, & !   647
     & 3.595963D0, 1.380338072533D-04,  5.64D-23, 0.002200,  2, 2, & !   648
     & 5.436595D0, 1.380456049277D-04,  2.59D-23, 0.000236,  2, 2, & !   649
     & 0.106658D0, 1.380563018901D-04,  1.86D-23, 0.006399,  2, 2  & !   650
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=651,660)   &
     & / &
     & 5.094788D0, 1.380680995645D-04, -1.19D-23, 0.000353,  2, 2, & !   651
     & 6.053942D0, 1.380787965269D-04, -1.92D-23, 0.011068,  2, 2, & !   652
     & 4.776124D0, 1.382115102039D-04,  7.04D-23, 0.000113,  2, 2, & !   653
     & 5.735277D0, 1.382222071662D-04,  6.31D-23, 0.008397,  2, 2, & !   654
     & 0.411245D0, 1.382329041286D-04,  5.58D-23, 0.225298,  2, 2, & !   655
     & 4.004436D0, 1.382329231479D-04,  5.91D-23, 0.000139,  2, 2, & !   656
     & 0.295238D0, 1.382554082750D-04,  1.97D-23, 0.000968,  2, 3, & !   657
     & 6.010817D0, 1.382778934022D-04, -1.97D-23, 0.000190,  2, 2, & !   658
     & 3.320822D0, 1.382779124215D-04, -1.65D-23, 0.001151,  2, 2, & !   659
     & 4.279976D0, 1.382886093839D-04, -2.38D-23, 0.000791,  2, 2  & !   660
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=661,670)   &
     & / &
     & 5.692152D0, 1.384213040415D-04,  6.26D-23, 0.000376,  2, 2, & !   661
     & 0.368120D0, 1.384320010039D-04,  5.53D-23, 0.010394,  2, 2, & !   662
     & 0.324995D0, 1.386310978792D-04,  5.48D-23, 0.000372,  2, 2, & !   663
     & 3.918186D0, 1.386311168985D-04,  5.80D-23, 0.000223,  2, 2, & !   664
     & 4.877339D0, 1.386418138608D-04,  5.07D-23, 0.000146,  2, 2, & !   665
     & 6.212093D0, 1.399001991344D-04,  2.54D-23, 0.000107,  2, 2, & !   666
     & 4.756792D0, 1.399666013521D-04, -6.15D-23, 0.000753,  2, 2, & !   667
     & 6.168968D0, 1.400992960097D-04,  2.48D-23, 0.002689,  2, 2, & !   668
     & 5.397280D0, 1.401207089538D-04,  1.35D-23, 0.000215,  2, 2, & !   669
     & 0.728928D0, 1.401324971185D-04, -1.86D-23, 0.000115,  2, 3  & !   670
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=671,680)   &
     & / &
     & 4.829674D0, 1.401431940809D-04, -2.59D-23, 0.000532,  2, 3, & !   671
     & 3.754513D0, 1.401550012650D-04, -5.48D-23, 0.000644,  2, 2, & !   672
     & 4.713666D0, 1.401656982274D-04, -6.21D-23, 0.018596,  2, 2, & !   673
     & 4.395002D0, 1.403091088667D-04,  2.02D-23, 0.000503,  2, 2, & !   674
     & 5.354155D0, 1.403198058291D-04,  1.29D-23, 0.021286,  2, 2, & !   675
     & 5.012348D0, 1.403423004659D-04, -2.48D-23, 0.000937,  2, 2, & !   676
     & 4.670541D0, 1.403647951027D-04, -6.26D-23, 0.000143,  2, 2, & !   677
     & 3.624739D0, 1.404525004867D-04,  9.93D-23, 0.000219,  2, 2, & !   678
     & 1.326292D0, 1.404857015955D-04,  5.59D-23, 0.000365,  2, 3, & !   679
     & 5.427038D0, 1.404963985579D-04,  4.86D-23, 0.002159,  2, 3  & !   680
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=681,690)   &
     & / &
     & 0.251131D0, 1.404975087796D-04,  2.70D-23, 0.003219,  2, 2, & !   681
     & 1.210284D0, 1.405082057420D-04,  1.97D-23, 0.231130,  2, 2, & !   682
     & 4.803475D0, 1.405082247613D-04,  2.29D-23, 0.000124,  2, 2, & !   683
     & 0.075852D0, 1.405181580092D-04,  4.09D-23, 0.000412,  2, 2, & !   684
     & 2.169437D0, 1.405189027044D-04,  1.24D-23, 6.194554,  2, 2, & !   685
     & 5.762628D0, 1.405189217237D-04,  1.56D-23, 0.002958,  2, 2, & !   686
     & 1.104896D0, 1.405196473995D-04, -1.61D-23, 0.000409,  2, 2, & !   687
     & 6.270184D0, 1.405295996667D-04,  5.13D-24, 0.000101,  2, 2, & !   688
     & 1.094276D0, 1.405307098884D-04, -1.65D-23, 0.000340,  2, 3, & !   689
     & 2.053430D0, 1.405414068508D-04, -2.38D-23, 0.005747,  2, 3  & !   690
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=691,700)   &
     & / &
     & 6.154176D0, 1.405521038132D-04, -3.10D-23, 0.001090,  2, 3, & !   691
     & 5.079015D0, 1.405639109973D-04, -6.00D-23, 0.003587,  2, 2, & !   692
     & 2.896575D0, 1.405746079596D-04, -6.72D-23, 0.001284,  2, 2, & !   693
     & 0.714136D0, 1.405853049220D-04, -7.45D-23, 0.000245,  2, 2, & !   694
     & 2.468119D0, 1.406955049428D-04,  4.96D-23, 0.000220,  2, 2, & !   695
     & 1.167159D0, 1.407073026173D-04,  1.91D-23, 0.000386,  2, 2, & !   696
     & 2.126312D0, 1.407179995796D-04,  1.19D-23, 0.018752,  2, 2, & !   697
     & 3.537064D0, 1.407287155613D-04,  7.79D-24, 0.000113,  2, 2, & !   698
     & 4.949240D0, 1.408614102190D-04,  9.42D-23, 0.000129,  2, 2, & !   699
     & 5.908394D0, 1.408721071813D-04,  8.69D-23, 0.003530,  2, 2  & !   700
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=701,710)   &
     & / &
     & 2.650793D0, 1.408946113278D-04,  5.07D-23, 0.001120,  2, 3, & !   701
     & 0.468354D0, 1.409053082902D-04,  4.34D-23, 0.000227,  2, 3, & !   702
     & 4.717225D0, 1.409064185119D-04,  2.18D-23, 0.000129,  2, 2, & !   703
     & 2.083187D0, 1.409170964549D-04,  1.13D-23, 0.000220,  2, 2, & !   704
     & 5.676378D0, 1.409171154743D-04,  1.45D-23, 0.007263,  2, 2, & !   705
     & 0.352346D0, 1.409278124366D-04,  7.26D-24, 0.003483,  2, 2, & !   706
     & 1.311500D0, 1.409385093990D-04, -1.95D-26, 0.001178,  2, 2, & !   707
     & 5.865269D0, 1.410712040566D-04,  8.63D-23, 0.000154,  2, 2, & !   708
     & 5.633253D0, 1.411162123495D-04,  1.40D-23, 0.000473,  2, 2, & !   709
     & 6.273742D0, 1.412703199512D-04,  8.90D-23, 0.000136,  2, 2  & !   710
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=711,720)   &
     & / &
     & 0.829162D0, 1.426058044048D-04, -3.05D-23, 0.002188,  2, 2, & !   711
     & 5.382931D0, 1.427384990625D-04,  5.59D-23, 0.000153,  2, 2, & !   712
     & 3.084484D0, 1.427717001713D-04,  1.24D-23, 0.000190,  2, 3, & !   713
     & 6.110069D0, 1.427942043178D-04, -2.38D-23, 0.002045,  2, 2, & !   714
     & 0.786037D0, 1.428049012801D-04, -3.10D-23, 0.045678,  2, 2, & !   715
     & 1.426526D0, 1.429590088818D-04,  4.40D-23, 0.000704,  2, 2, & !   716
     & 1.084719D0, 1.429815035186D-04,  6.20D-24, 0.001103,  2, 2, & !   717
     & 3.884504D0, 1.430039981554D-04, -3.16D-23, 0.000111,  2, 2, & !   718
     & 4.336103D0, 1.430040171747D-04, -2.84D-23, 0.000224,  2, 2, & !   719
     & 2.153664D0, 1.430147141371D-04, -3.56D-23, 0.000118,  2, 2  & !   720
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=721,730)   &
     & / &
     & 5.748279D0, 1.431367118324D-04,  5.80D-23, 0.000256,  2, 2, & !   721
     & 0.424247D0, 1.431474087947D-04,  5.07D-23, 0.006407,  2, 2, & !   722
     & 1.383401D0, 1.431581057571D-04,  4.34D-23, 0.175107,  2, 2, & !   723
     & 3.449832D0, 1.431699129412D-04,  1.45D-23, 0.002080,  2, 3, & !   724
     & 4.183186D0, 1.431806003939D-04,  5.66D-24, 0.000132,  2, 2, & !   725
     & 4.408985D0, 1.431806099036D-04,  7.27D-24, 0.035163,  2, 3, & !   726
     & 2.226546D0, 1.431913068659D-04, -9.74D-27, 0.006624,  2, 3, & !   727
     & 0.192231D0, 1.431924170877D-04, -2.16D-23, 0.000820,  2, 2, & !   728
     & 3.185700D0, 1.432020038283D-04, -7.28D-24, 0.000237,  2, 3, & !   729
     & 1.151385D0, 1.432031140500D-04, -2.89D-23, 0.043770,  2, 2  & !   730
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=731,740)   &
     & / &
     & 5.252131D0, 1.432138110124D-04, -3.62D-23, 0.019318,  2, 2, & !   731
     & 3.069692D0, 1.432245079747D-04, -4.35D-23, 0.002732,  2, 2, & !   732
     & 4.481868D0, 1.433572026324D-04,  4.29D-23, 0.000208,  2, 2, & !   733
     & 1.450067D0, 1.433797162885D-04,  8.33D-24, 0.000242,  2, 2, & !   734
     & 5.550813D0, 1.433904132509D-04,  1.05D-24, 0.000111,  2, 2, & !   735
     & 1.108260D0, 1.434022109253D-04, -2.95D-23, 0.000269,  2, 2, & !   736
     & 5.209006D0, 1.434129078877D-04, -3.67D-23, 0.000149,  2, 2, & !   737
     & 0.789595D0, 1.435456215646D-04,  5.28D-23, 0.000157,  2, 2, & !   738
     & 1.748749D0, 1.435563185270D-04,  4.56D-23, 0.008373,  2, 2, & !   739
     & 5.849495D0, 1.435670154894D-04,  3.83D-23, 0.004042,  2, 2  & !   740
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=741,750)   &
     & / &
     & 3.667055D0, 1.435777124517D-04,  3.10D-23, 0.000475,  2, 2, & !   741
     & 1.705623D0, 1.437554154023D-04,  4.50D-23, 0.000358,  2, 2, & !   742
     & 5.806369D0, 1.437661123646D-04,  3.78D-23, 0.000181,  2, 2, & !   743
     & 0.129376D0, 1.448468137070D-04,  1.62D-24, 0.000236,  2, 2, & !   744
     & 0.086250D0, 1.450459105823D-04,  1.08D-24, 0.006836,  2, 2, & !   745
     & 0.289621D0, 1.451950226686D-04, -4.85D-26, 0.000142,  2, 2, & !   746
     & 2.225564D0, 1.452343104952D-04,  7.81D-24, 0.000266,  2, 2, & !   747
     & 0.043125D0, 1.452450074576D-04,  5.39D-25, 0.168449,  2, 2, & !   748
     & 1.956698D0, 1.452617905686D-04, -2.80D-25, 0.000171,  2, 2, & !   749
     & 1.223286D0, 1.454227104081D-04,  1.46D-23, 0.000212,  2, 2  & !   750
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=751,760)   &
     & / &
     & 2.182439D0, 1.454334073705D-04,  7.28D-24, 0.006453,  2, 2, & !   751
     & 6.283185D0, 1.454441043329D-04, -7.35D-40, 2.881748,  2, 2, & !   752
     & 3.593191D0, 1.454441233522D-04,  3.20D-24, 0.001052,  2, 2, & !   753
     & 6.167178D0, 1.454666084793D-04, -3.62D-23, 0.000357,  2, 3, & !   754
     & 2.909577D0, 1.454891126258D-04, -7.24D-23, 0.000388,  2, 2, & !   755
     & 0.727138D0, 1.454998095882D-04, -7.96D-23, 0.000171,  2, 2, & !   756
     & 5.280907D0, 1.456325042458D-04,  6.74D-24, 0.000128,  2, 2, & !   757
     & 3.098467D0, 1.456432012082D-04, -5.39D-25, 0.024055,  2, 2, & !   758
     & 3.550066D0, 1.456432202275D-04,  2.66D-24, 0.006198,  2, 2, & !   759
     & 4.509219D0, 1.456539171898D-04, -4.61D-24, 0.000352,  2, 2  & !   760
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=761,770)   &
     & / &
     & 2.779803D0, 1.457866118475D-04,  8.18D-23, 0.000317,  2, 2, & !   761
     & 5.805388D0, 1.458091159939D-04,  4.56D-23, 0.000114,  2, 3, & !   762
     & 0.481356D0, 1.458198129563D-04,  3.83D-23, 0.001915,  2, 3, & !   763
     & 4.582102D0, 1.458305099187D-04,  3.10D-23, 0.000360,  2, 3, & !   764
     & 2.547787D0, 1.458316201404D-04,  9.40D-24, 0.010022,  2, 2, & !   765
     & 3.055342D0, 1.458422980834D-04, -1.08D-24, 0.000205,  2, 2, & !   766
     & 3.506941D0, 1.458423171028D-04,  2.13D-24, 0.783028,  2, 2, & !   767
     & 0.816946D0, 1.458423361221D-04,  5.33D-24, 0.000118,  2, 2, & !   768
     & 1.324501D0, 1.458530140651D-04, -5.15D-24, 0.233371,  2, 2, & !   769
     & 5.425248D0, 1.458637110275D-04, -1.24D-23, 0.025368,  2, 2  & !   770
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=771,780)   &
     & / &
     & 3.390933D0, 1.458648212492D-04, -3.41D-23, 0.000177,  2, 3, & !   771
     & 1.208494D0, 1.458755182116D-04, -4.13D-23, 0.000115,  2, 3, & !   772
     & 3.463816D0, 1.460414139781D-04,  1.59D-24, 0.006213,  2, 2, & !   773
     & 1.281376D0, 1.460521109404D-04, -5.69D-24, 0.000260,  2, 2, & !   774
     & 4.104304D0, 1.461955215797D-04,  7.66D-23, 0.000388,  2, 2, & !   775
     & 1.921865D0, 1.462062185421D-04,  6.93D-23, 0.000242,  2, 2, & !   776
     & 3.420690D0, 1.462405108533D-04,  1.05D-24, 0.000152,  2, 2, & !   777
     & 0.730696D0, 1.462405298727D-04,  4.25D-24, 0.005334,  2, 2, & !   778
     & 1.689850D0, 1.462512268350D-04, -3.02D-24, 0.000283,  2, 2, & !   779
     & 5.790596D0, 1.462619237974D-04, -1.03D-23, 0.000212,  2, 2  & !   780
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=781,790)   &
     & / &
     & 0.687571D0, 1.464396267480D-04,  3.71D-24, 0.000311,  2, 2, & !   781
     & 3.940631D0, 1.477194059463D-04, -3.62D-23, 0.000105,  2, 2, & !   782
     & 2.056874D0, 1.479067051471D-04, -6.20D-24, 0.000223,  2, 2, & !   783
     & 5.308258D0, 1.479292188032D-04, -4.08D-23, 0.000359,  2, 2, & !   784
     & 3.125819D0, 1.479399157656D-04, -4.81D-23, 0.000151,  2, 2, & !   785
     & 4.537995D0, 1.480726104232D-04,  3.83D-23, 0.000547,  2, 2, & !   786
     & 2.355556D0, 1.480833073856D-04,  3.10D-23, 0.000432,  2, 2, & !   787
     & 2.239548D0, 1.481058115321D-04, -5.14D-24, 0.000402,  2, 3, & !   788
     & 4.305979D0, 1.481176187162D-04, -3.40D-23, 0.000173,  2, 2, & !   789
     & 5.265133D0, 1.481283156785D-04, -4.13D-23, 0.008374,  2, 2  & !   790
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=791,800)   &
     & / &
     & 3.082694D0, 1.481390126409D-04, -4.86D-23, 0.003651,  2, 2, & !   791
     & 0.900254D0, 1.481497096033D-04, -5.59D-23, 0.000395,  2, 2, & !   792
     & 5.905622D0, 1.482824232802D-04,  3.37D-23, 0.000269,  2, 2, & !   793
     & 5.563815D0, 1.483049179170D-04, -4.08D-24, 0.000242,  2, 2, & !   794
     & 2.836912D0, 1.484590160090D-04,  6.93D-23, 0.000145,  2, 3, & !   795
     & 4.903343D0, 1.484708231931D-04,  4.04D-23, 0.000828,  2, 2, & !   796
     & 5.862496D0, 1.484815201555D-04,  3.32D-23, 0.043801,  2, 2, & !   797
     & 3.680057D0, 1.484922171179D-04,  2.59D-23, 0.019074,  2, 2, & !   798
     & 1.497618D0, 1.485029140802D-04,  1.86D-23, 0.002070,  2, 2, & !   799
     & 5.746489D0, 1.485040243020D-04, -3.01D-24, 0.003239,  2, 3  & !   800
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=801,810)   &
     & / &
     & 3.564049D0, 1.485147212643D-04, -1.03D-23, 0.002080,  2, 3, & !   801
     & 1.381610D0, 1.485254182267D-04, -1.76D-23, 0.000431,  2, 3, & !   802
     & 5.630481D0, 1.485265284484D-04, -3.92D-23, 0.000324,  2, 2, & !   803
     & 3.448042D0, 1.485372254108D-04, -4.65D-23, 0.000275,  2, 2, & !   804
     & 1.265602D0, 1.485479223732D-04, -5.37D-23, 0.000256,  2, 2, & !   805
     & 2.677779D0, 1.486806170308D-04,  3.26D-23, 0.000225,  2, 2, & !   806
     & 0.740140D0, 1.504143142543D-04, -8.48D-23, 0.000136,  2, 2, & !   807
     & 1.380628D0, 1.505684218560D-04, -9.74D-24, 0.000480,  2, 2, & !   808
     & 5.481375D0, 1.505791188183D-04, -1.70D-23, 0.000202,  2, 2, & !   809
     & 3.519942D0, 1.507568217689D-04, -3.00D-24, 0.000150,  2, 2  & !   810
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=811,820)   &
     & / &
     & 1.337503D0, 1.507675187313D-04, -1.03D-23, 0.007264,  2, 2, & !   811
     & 5.438249D0, 1.507782156936D-04, -1.76D-23, 0.003126,  2, 2, & !   812
     & 3.255810D0, 1.507889126560D-04, -2.48D-23, 0.000338,  2, 2, & !   813
     & 1.221495D0, 1.507900228777D-04, -4.65D-23, 0.000103,  2, 3, & !   814
     & 1.934867D0, 1.511207232082D-04,  6.42D-23, 0.003589,  2, 2, & !   815
     & 6.035613D0, 1.511314201706D-04,  5.69D-23, 0.001563,  2, 2, & !   816
     & 3.853174D0, 1.511421171330D-04,  4.97D-23, 0.000170,  2, 2, & !   817
     & 1.818859D0, 1.511432273547D-04,  2.80D-23, 0.000529,  2, 3, & !   818
     & 5.919605D0, 1.511539243171D-04,  2.07D-23, 0.000340,  2, 3, & !   819
     & 4.844444D0, 1.511657315012D-04, -8.15D-24, 0.011460,  2, 2  & !   820
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=821,830)   &
     & / &
     & 2.662005D0, 1.511764284635D-04, -1.54D-23, 0.009937,  2, 2, & !   821
     & 0.479566D0, 1.511871254259D-04, -2.27D-23, 0.003215,  2, 2, & !   822
     & 4.580312D0, 1.511978223883D-04, -3.00D-23, 0.000461,  2, 2, & !   823
     & 3.095695D0, 1.530535173070D-04, -5.37D-23, 0.000223,  2, 2, & !   824
     & 3.693059D0, 1.534067217840D-04,  2.08D-23, 0.001151,  2, 2, & !   825
     & 1.510620D0, 1.534174187464D-04,  1.35D-23, 0.000494,  2, 2, & !   826
     & 0.319451D0, 1.534517300769D-04, -5.16D-23, 0.000417,  2, 2, & !   827
     & 4.420197D0, 1.534624270393D-04, -5.89D-23, 0.000361,  2, 2, & !   828
     & 2.237758D0, 1.534731240017D-04, -6.61D-23, 0.000113,  2, 2, & !   829
     & 4.290423D0, 1.537599262610D-04,  9.52D-23, 0.000288,  2, 2  & !   830
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=831,840)   &
     & / &
     & 2.107983D0, 1.537706232233D-04,  8.80D-23, 0.000125,  2, 2, & !   831
     & 0.916814D0, 1.538049345539D-04,  2.29D-23, 0.002195,  2, 2, & !   832
     & 5.017560D0, 1.538156315163D-04,  1.56D-23, 0.001902,  2, 2, & !   833
     & 2.835121D0, 1.538263284786D-04,  8.33D-24, 0.000616,  2, 2, & !   834
     & 5.451251D0, 1.556927203598D-04, -2.27D-23, 0.000111,  2, 2, & !   835
     & 6.048615D0, 1.560459248368D-04,  5.18D-23, 0.000137,  2, 2, & !   836
     & 2.675007D0, 1.560909331297D-04, -2.06D-23, 0.000351,  2, 2, & !   837
     & 0.492567D0, 1.561016300920D-04, -2.78D-23, 0.000304,  2, 2, & !   838
     & 3.272370D0, 1.564441376067D-04,  5.39D-23, 0.000290,  2, 2, & !   839
     & 1.089931D0, 1.564548345690D-04,  4.66D-23, 0.000252,  2, 2  & !   840
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=841,850)   &
     & / &
     & 0.712482D0, 2.005747463225D-04, -3.11D-23, 0.000218,  3, 3, & !   841
     & 1.309846D0, 2.009279507995D-04,  4.34D-23, 0.000122,  3, 3, & !   842
     & 2.470674D0, 2.028607448983D-04, -7.45D-23, 0.000497,  3, 3, & !   843
     & 3.068038D0, 2.032139493753D-04, -2.55D-26, 0.001081,  3, 3, & !   844
     & 3.665401D0, 2.035671538522D-04,  7.45D-23, 0.000207,  3, 3, & !   845
     & 3.867077D0, 2.054892509887D-04, -3.62D-23, 0.000200,  3, 3, & !   846
     & 4.826230D0, 2.054999479510D-04, -4.35D-23, 0.003565,  3, 3, & !   847
     & 4.464440D0, 2.058424554657D-04,  3.83D-23, 0.000200,  3, 3, & !   848
     & 5.423594D0, 2.058531524280D-04,  3.10D-23, 0.003584,  3, 3, & !   849
     & 5.380468D0, 2.060522493033D-04,  3.05D-23, 0.000242,  3, 3  & !   850
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=851,860)   &
     & / &
     & 6.020957D0, 2.062063569050D-04,  1.05D-22, 0.000127,  3, 3, & !   851
     & 3.442829D0, 2.077859465268D-04, -8.69D-23, 0.000110,  3, 3, & !   852
     & 4.083318D0, 2.079400541285D-04, -1.19D-23, 0.000209,  3, 3, & !   853
     & 6.222632D0, 2.081284540414D-04, -5.16D-24, 0.001153,  3, 3, & !   854
     & 0.898600D0, 2.081391510038D-04, -1.24D-23, 0.020565,  3, 3, & !   855
     & 1.197282D0, 2.083157532423D-04,  2.48D-23, 0.000110,  3, 3, & !   856
     & 0.855475D0, 2.083382478791D-04, -1.30D-23, 0.000223,  3, 3, & !   857
     & 0.536811D0, 2.084816585184D-04,  6.93D-23, 0.000215,  3, 3, & !   858
     & 1.495964D0, 2.084923554808D-04,  6.21D-23, 0.003850,  3, 3, & !   859
     & 1.452839D0, 2.086914523560D-04,  6.15D-23, 0.000183,  3, 3  & !   860
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=861,870)   &
     & / &
     & 5.798385D0, 2.104251495796D-04, -5.59D-23, 0.000458,  3, 3, & !   861
     & 0.155689D0, 2.105792571812D-04,  1.91D-23, 0.000387,  3, 3, & !   862
     & 2.295003D0, 2.107676570942D-04,  2.59D-23, 0.004199,  3, 3, & !   863
     & 3.254156D0, 2.107783540565D-04,  1.86D-23, 0.075042,  3, 3, & !   864
     & 6.163733D0, 2.108233623495D-04, -5.37D-23, 0.000192,  3, 3, & !   865
     & 3.211031D0, 2.109774509318D-04,  1.81D-23, 0.000341,  3, 3, & !   866
     & 0.709927D0, 2.111315585335D-04,  9.31D-23, 0.000163,  3, 3, & !   867
     & 0.477912D0, 2.111765668264D-04,  2.07D-23, 0.000260,  3, 3, & !   868
     & 1.870756D0, 2.130643526323D-04, -2.48D-23, 0.001046,  3, 3, & !   869
     & 1.508966D0, 2.134068601469D-04,  5.69D-23, 0.000236,  3, 3  & !   870
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=871,880)   &
     & / &
     & 2.468119D0, 2.134175571093D-04,  4.96D-23, 0.004250,  3, 3, & !   871
     & 2.236104D0, 2.134625654022D-04, -2.27D-23, 0.001597,  3, 3, & !   872
     & 0.053664D0, 2.134732623646D-04, -3.00D-23, 0.000706,  3, 3, & !   873
     & 2.833467D0, 2.138157698792D-04,  5.18D-23, 0.000311,  3, 3, & !   874
     & 0.651028D0, 2.138264668415D-04,  4.45D-23, 0.000147,  3, 3, & !   875
     & 3.267158D0, 2.156928587227D-04,  1.35D-23, 0.000123,  3, 3, & !   876
     & 3.632506D0, 2.160910714926D-04,  1.56D-23, 0.000368,  3, 3, & !   877
     & 4.591659D0, 2.161017684549D-04,  8.33D-24, 0.009776,  3, 3, & !   878
     & 2.409220D0, 2.161124654173D-04,  1.05D-24, 0.004289,  3, 3, & !   879
     & 0.226781D0, 2.161231623797D-04, -6.22D-24, 0.000466,  3, 3  & !   880
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=881,886)   &
     & / &
     & 0.664030D0, 2.187409715077D-04,  3.94D-23, 0.000532,  3, 3, & !   881
     & 4.764776D0, 2.187516684700D-04,  3.21D-23, 0.000233,  3, 3, & !   882
     & 2.422222D0, 2.210269700834D-04, -4.08D-24, 0.000112,  3, 3, & !   883
     & 5.929163D0, 2.214251828533D-04, -1.95D-24, 0.000420,  3, 3, & !   884
     & 3.746723D0, 2.214358798157D-04, -9.23D-24, 0.000368,  3, 3, & !   885
     & 1.564284D0, 2.214465767781D-04, -1.65D-23, 0.000120,  3, 3  & !   886
     & /
