      SUBROUTINE GETPAR_TO_EOB ( FILEOB, FILSPL, N_SES, DBNAME, EXPNAME, &
     &           USED, DURA, TAG, XEOP_VAL,  XEOP_ERR, YEOP_VAL, &
     &           YEOP_ERR, XREOP_VAL, XREOP_ERR, YREOP_VAL, YREOP_ERR, &
     &           UEOP_VAL,  UEOP_ERR, REOP_VAL,  REOP_ERR, &
     &           QEOP_VAL,  QEOP_ERR, PEOP_VAL,  PEOP_ERR, &
     &           EEOP_VAL,  EEOP_ERR, CEOP,      RMS_STR,   MJD_EOP, MJD_NUT, &
     &           NUT_USAGE, C_NET, SOL_ID, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine GETPAR_TO_EOB fills teh field of EOB record with the       *
! *   values extracted from parsing a spool file.                        *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 04-JUN-2002  GETPAR_TO_EOB  v3.0 (d) L. Petrov  12-JUN-2021 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'solve.i'
      INCLUDE   'getpar.i'
      CHARACTER  FILEOB*(*), FILSPL*(*), SOL_ID*(*)
      INTEGER*4  N_SES, NUT_USAGE, IUER
      CHARACTER  DBNAME(N_SES)*(*), EXPNAME(N_SES)*(*), USED(N_SES)*6, &
     &           DURA(N_SES)*10, TAG(N_SES)*14
      CHARACTER  XEOP_VAL(N_SES)*11,  XEOP_ERR(N_SES)*10, &
     &           YEOP_VAL(N_SES)*11,  YEOP_ERR(N_SES)*10, &
     &           XREOP_VAL(N_SES)*11, XREOP_ERR(N_SES)*10, &
     &           YREOP_VAL(N_SES)*11, YREOP_ERR(N_SES)*10, &
     &           UEOP_VAL(N_SES)*11,  UEOP_ERR(N_SES)*10, &
     &           REOP_VAL(N_SES)*11,  REOP_ERR(N_SES)*10, &
     &           QEOP_VAL(N_SES)*11,  QEOP_ERR(N_SES)*10, &
     &           PEOP_VAL(N_SES)*11,  PEOP_ERR(N_SES)*10, &
     &           EEOP_VAL(N_SES)*11,  EEOP_ERR(N_SES)*10, &
     &           CEOP(28,N_SES)*6,    RMS_STR(N_SES)*64, C_NET(N_SES)*(*)
      INTEGER*4  MG_BUF, LG_BUF
      PARAMETER  ( MG_BUF = MAX_ARCS )
      CHARACTER  G_BUF(MG_BUF)*128, MARK3_NAME*10
      REAL*8     MJD_EOP(N_SES), MJD_NUT(N_SES)
      CHARACTER  SDAT*19, STR*128, STR_EOB*512
      TYPE      ( EOB__CHAR ) ::  EOB
      INTEGER*4  LUN, MJD_INT4, IYEAR, IOS(16), LEN_EOB, J1, J2, IER
      REAL*8     MJD_REF, SEC, ARR(16), DURA_SEC, WRMS_VAL
      LOGICAL*1  FL_EOP_ADJ_ONLY 
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN, GET_UNIT
!
      CALL GETENVAR ( 'GETPAR_EOP_ADJ_ONLY', STR )
      IF ( STR(1:1) == 'Y' .OR. STR(1:1) == 'y' ) THEN
           FL_EOP_ADJ_ONLY = .TRUE.
         ELSE
           FL_EOP_ADJ_ONLY = .FALSE.
      END IF
!
! --- Writing EOP in B-format
!
      LUN = GET_UNIT ()
      OPEN ( UNIT=LUN, FILE=FILEOB, STATUS='UNKNOWN' )
      WRITE ( LUN, '(A)' ) SIG_EOB
      WRITE ( LUN, '(A)' ) '# Earth orientation parameters from the VLBI '// &
     &                    'solution'
      WRITE ( LUN, '(A)' ) '# VLBI VTD/pSolve solution '//SOL_ID(1:I_LEN(SOL_ID))
      WRITE ( LUN, '(A)' ) '# Spool file: '//FILSPL(1:I_LEN(FILSPL))
      WRITE ( LUN, '(A)' ) '# Analysis center: '//CENTER_ABR//' ( '// &
     &                     CENTER_FULL_NAME//' )'
      STR = GET_CDATE()
      WRITE ( LUN, '(A)' ) '# Generated by getpar at '//STR(1:19)
      WRITE ( LUN, '(A)' ) '#'
      WRITE ( LUN, '(A)' ) '# EOP totals DO NOT include the effect of '// &
     &                     'subdaily variations'
      WRITE ( LUN, '(A)' ) '# Time argument: TAI'
      IF ( NUT_USAGE .EQ. 1 )  THEN
           WRITE ( LUN, FMT='(A)' ) '# Nutation angles are wrt apriori expansion' 
         ELSE IF ( NUT_USAGE .EQ. 2 ) THEN
           WRITE ( LUN, FMT='(A)' ) '# Nutation angles are wrt Wahr1980 expansion'
      END IF
      IF ( FL_EOP_ADJ_ONLY ) THEN
           WRITE ( LUN, FMT='(A)' ) '# ONLY ADJUSTMENTS, not totals for Xpol, Ypol, UT1 and their rate of changes'
      END IF
      WRITE ( LUN, '(A)' ) '#'
!
      LG_BUF = 0
      DO 410 J1=1,N_SES
!
! ------ Clrear the record
!
         CALL CLRCH ( STR_EOB )
         LEN_EOB = SIZEOF ( EOB )
         CALL LIB$MOVC3  ( LEN_EOB, %REF(STR_EOB), EOB )
!
         IF ( MJD_EOP(J1) .GT. 40000.0  .AND. MJD_EOP(J1) .LT. 90000.0 ) THEN
              MJD_REF = MJD_EOP(J1)
            ELSE
              SDAT = '19'//TAG(J1)(1:2)//'.'//TAG(J1)(4:5)//'.'//&
     &                     TAG(J1)(7:8)// '-'//TAG(J1)(10:14)//'-00'
              CALL CHIN ( TAG(J1)(1:2), IYEAR )
              IF ( IYEAR .LT. 70 ) SDAT(1:2) = '20'
              IF ( SDAT(1:16) .EQ. '2000.00.00-00000' ) GOTO 410 ! No EOP data
              IF ( SDAT(1:16) .EQ. '20  .  .  -     ' ) GOTO 410 ! No EOP data
!
              CALL ERR_PASS ( IUER, IER )
              CALL DATE_TO_TIME ( SDAT, MJD_INT4, SEC, IER )
              IF ( IER .NE. 0 ) THEN
                   WRITE ( 6, * ) ' session ',J1,'  sdat=',sdat
                   CALL ERR_LOG ( 1741, IUER, 'GETPAR_TO_EOB', 'Trap of '// &
     &                 'internal control: wrong date format: '//SDAT )
                   RETURN
              END IF
              MJD_REF = MJD_INT4 + SEC/86400.0
         END IF
!
         WRITE ( UNIT=EOB%MJD_EOP, FMT='(F12.6)' ) MJD_REF
!
! ------ The same for nutation epoch
!
         IF ( MJD_NUT(J1) .GT. 40000.0  .AND. MJD_NUT(J1) .LT. 90000.0 ) THEN
              WRITE ( UNIT=EOB%MJD_NUT, FMT='(F12.6)' ) MJD_NUT(J1)
            ELSE
              WRITE ( UNIT=EOB%MJD_NUT, FMT='(F12.6)' ) MJD_REF
         END IF
!
! ------ We read vales of EOP since we have to rescale some of them
!
         READ ( UNIT=XEOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(1)  ) ARR(1)
         READ ( UNIT=YEOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(2)  ) ARR(2)
         READ ( UNIT=UEOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(3)  ) ARR(3)
         READ ( UNIT=PEOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(4)  ) ARR(4)
         READ ( UNIT=EEOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(5)  ) ARR(5)
         READ ( UNIT=XREOP_VAL(J1), FMT='(F11.5)', IOSTAT=IOS(6)  ) ARR(6)
         READ ( UNIT=YREOP_VAL(J1), FMT='(F11.5)', IOSTAT=IOS(7)  ) ARR(7)
         READ ( UNIT=REOP_VAL(J1),  FMT='(F11.5)', IOSTAT=IOS(8)  ) ARR(8)
!
         READ ( UNIT=XEOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(9)  ) ARR(9)
         READ ( UNIT=YEOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(10) ) ARR(10)
         READ ( UNIT=UEOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(11) ) ARR(11)
         READ ( UNIT=PEOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(12) ) ARR(12)
         READ ( UNIT=EEOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(13) ) ARR(13)
         READ ( UNIT=XREOP_ERR(J1), FMT='(F10.5)', IOSTAT=IOS(14) ) ARR(14)
         READ ( UNIT=YREOP_ERR(J1), FMT='(F10.5)', IOSTAT=IOS(15) ) ARR(15)
         READ ( UNIT=REOP_ERR(J1),  FMT='(F10.5)', IOSTAT=IOS(16) ) ARR(16)
!
         IF ( ILEN(CEOP(2,J1))  .EQ. 0 ) CEOP(2,J1)  = '0.0000'
         IF ( ILEN(CEOP(7,J1))  .EQ. 0 ) CEOP(7,J1)  = '0.0000'
         IF ( ILEN(CEOP(9,J1))  .EQ. 0 ) CEOP(9,J1)  = '0.0000'
         IF ( ILEN(CEOP(28,J1)) .EQ. 0 ) CEOP(28,J1) = '0.0000'
         IF ( ILEN(CEOP(11,J1)) .EQ. 0 ) CEOP(11,J1) = '0.0000'
         IF ( ILEN(CEOP(13,J1)) .EQ. 0 ) CEOP(13,J1) = '0.0000'
         IF ( ILEN(CEOP(15,J1)) .EQ. 0 ) CEOP(15,J1) = '0.0000'
         DO 420 J2=1,16
            IF ( IOS(J2) .NE. 0 ) ARR(J2) = 0.0
 420     CONTINUE
!
         IF ( INDEX ( RMS_STR(J1)(29:29), '.' ) .GT. 0 ) THEN
              READ ( UNIT=RMS_STR(J1)(20:32),       FMT='(F13.3)'  ) WRMS_VAL
            ELSE IF ( INDEX ( RMS_STR(J1)(31:31), '.' ) .GT. 0 ) THEN
              READ ( UNIT=RMS_STR(J1)(17:37),       FMT='(F21.10)' ) WRMS_VAL
            ELSE
              CALL CLRCH ( STR )
              STR = RMS_STR(J1)(20:31)//'.0'
              READ ( UNIT=STR, FMT='(F12.6)' ) WRMS_VAL
         END IF
!
         EOB%FLAG = ' '
         EOB%DBNAME = DBNAME(J1)
         EOB%SCODE  = EXPNAME(J1)
!
         WRITE ( UNIT=EOB%XPL_V,  FMT='(F8.6)'  ) ARR(1)*1.D-3
         WRITE ( UNIT=EOB%YPL_V,  FMT='(F8.6)'  ) ARR(2)*1.D-3
         WRITE ( UNIT=EOB%U1_V,   FMT='(F11.7)' ) ARR(3)*1.D-3
         WRITE ( UNIT=EOB%DPSI_V, FMT='(F8.3)'  ) ARR(4)
         WRITE ( UNIT=EOB%DEPS_V, FMT='(F8.3)'  ) ARR(5)
         WRITE ( UNIT=EOB%XPR_V,  FMT='(F9.6)'  ) ARR(6)*1.D-3
         WRITE ( UNIT=EOB%YPR_V,  FMT='(F9.6)'  ) ARR(7)*1.D-3
         WRITE ( UNIT=EOB%UTR_V,  FMT='(F7.4)'  ) ARR(8)
!
         IF ( FL_EOP_ADJ_ONLY ) THEN
              WRITE ( UNIT=EOB%XPL_V,  FMT='(F8.6)'  ) ARR(1)*1.D-6
              WRITE ( UNIT=EOB%YPL_V,  FMT='(F8.6)'  ) ARR(2)*1.D-6
              WRITE ( UNIT=EOB%U1_V,   FMT='(F11.7)' ) ARR(3)*1.D-6
              WRITE ( UNIT=EOB%DPSI_V, FMT='(F8.3)'  ) ARR(4)*1.D-3
              WRITE ( UNIT=EOB%DEPS_V, FMT='(F8.3)'  ) ARR(5)*1.D-3
              WRITE ( UNIT=EOB%XPR_V,  FMT='(F9.6)'  ) ARR(6)*1.D-6
              WRITE ( UNIT=EOB%YPR_V,  FMT='(F9.6)'  ) ARR(7)*1.D-6
              WRITE ( UNIT=EOB%UTR_V,  FMT='(F7.4)'  ) ARR(8)*1.D-3
         END IF
!
         WRITE ( UNIT=EOB%XPL_E,  FMT='(F8.6)'  ) ARR(9)*1.D-6
         WRITE ( UNIT=EOB%YPL_E,  FMT='(F8.6)'  ) ARR(10)*1.D-6
         WRITE ( UNIT=EOB%U1_E,   FMT='(F9.7)'  ) ARR(11)*1.D-6
         WRITE ( UNIT=EOB%DPSI_E, FMT='(F7.3)'  ) ARR(12)*1.D-3
         WRITE ( UNIT=EOB%DEPS_E, FMT='(F7.3)'  ) ARR(13)*1.D-3
         WRITE ( UNIT=EOB%XPR_E,  FMT='(F9.6)'  ) ARR(14)*1.D-6
         WRITE ( UNIT=EOB%YPR_E,  FMT='(F9.6)'  ) ARR(15)*1.D-6
         WRITE ( UNIT=EOB%UTR_E,  FMT='(F7.4)'  ) ARR(16)*1.D-3
!
         IF ( ARR(9) .LT. GTP__EPS ) THEN
              EOB%XPL_V = '-0      '
              EOB%XPL_E = '-0      '
         END IF
!
         IF ( ARR(10) .LT. GTP__EPS ) THEN
              EOB%YPL_V = '-0      '
              EOB%YPL_E = '-0      '
         END IF
!
         IF ( ARR(11) .LT. GTP__EPS ) THEN
              EOB%U1_V = '-0         '
              EOB%U1_E = '-0        '
         END IF
!
         IF ( ARR(12) .LT. GTP__EPS ) THEN
              EOB%DPSI_V = '-0      '
              EOB%DPSI_E = '-0     '
         END IF
!
         IF ( ARR(13) .LT. GTP__EPS ) THEN
              EOB%DEPS_V = '-0      '
              EOB%DEPS_E = '-0     '
         END IF
!
         IF ( ARR(14) .LT. GTP__EPS ) THEN
              EOB%XPR_V = '-0       '
              EOB%XPR_E = '-0       '
         END IF
!
         IF ( ARR(15) .LT. GTP__EPS ) THEN
              EOB%YPR_V = '-0       '
              EOB%YPR_E = '-0       '
         END IF
!
         IF ( ARR(16) .LT. GTP__EPS ) THEN
              EOB%UTR_V = '-0      '
              EOB%UTR_E = '-0      '
         END IF
!
         EOB%C_XY  = CEOP(2,J1)
         EOB%C_XU  = CEOP(7,J1)
         EOB%C_YU  = CEOP(9,J1)
         EOB%C_PE  = CEOP(28,J1)
         EOB%C_URX = CEOP(15,J1)
         EOB%C_URY = CEOP(11,J1)
         EOB%C_URU = CEOP(13,J1)
         CALL BLANK_TO_ZERO ( EOB%C_XY(1:1)  )
         CALL BLANK_TO_ZERO ( EOB%C_XU(1:1)  )
         CALL BLANK_TO_ZERO ( EOB%C_YU(1:1)  )
         CALL BLANK_TO_ZERO ( EOB%C_PE(1:1)  )
         CALL BLANK_TO_ZERO ( EOB%C_URX(1:1) )
         CALL BLANK_TO_ZERO ( EOB%C_URY(1:1) )
         CALL BLANK_TO_ZERO ( EOB%C_URU(1:1) )
!
         READ  ( UNIT=DURA(J1), FMT='(F10.5)' ) DURA_SEC
         WRITE ( UNIT=EOB%DURA, FMT='(F5.2)'  ) DURA_SEC/3600.0D0
         WRITE ( UNIT=EOB%WRMS, FMT='(F7.2)'  ) WRMS_VAL
         EOB%NOBS  = USED(J1)
         EOB%C_NET = C_NET(J1)
!
         CALL LIB$MOVC3 ( LEN_EOB, EOB, %REF(STR_EOB) )
         WRITE  ( LUN, FMT='(A)' ) STR_EOB(1:LEN_EOB)
 410  CONTINUE
      CLOSE ( UNIT=LUN )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  !#!  GETPAR_TO_EOB  #!#
