      PROGRAM    ACTA_PLOT_MAIN
! ************************************************************************
! *                                                                      *
! *   Pprogram ACTA_PLOT generates a plot of autocorrlation spectrum,    *
! *   average over a time wihtin a segment, using a text file with       *
! *   the sepctrum generated by PIPMA task acta.                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 18-APR-2014   ACTA_PLOT   v1.0 (d)  L. Petrov  18-APR-2014 ###  *
! *                                                                      *
! ************************************************************************
      CHARACTER  FILIN*128, FILOUT*128
      INCLUDE   'pima.i'
      INTEGER*4  IUER 
      CHARACTER  STR*128
      INTEGER*8    STACK_SIZE_IN_BYTES, GB, IS
      PARAMETER  ( GB = 1024*1024*1024 )
      PARAMETER  ( STACK_SIZE_IN_BYTES = PIMA__STACK_SIZE_IN_GIGABYTES * GB )
      INTEGER*8, EXTERNAL :: SET_STACKSIZE 
!
! --- Set stacksize
!
      IS = SET_STACKSIZE ( %VAL(STACK_SIZE_IN_BYTES) )
      CALL INCH8    ( STACK_SIZE_IN_BYTES/INT8(1024), STR )
      CALL SETENV   ( 'GOMP_STACKSIZE'//CHAR(0), TRIM(STR)//CHAR(0), %VAL(1) )
!
      FILOUT = '/XW'
      IF ( IARGC() < 1 ) THEN
           WRITE ( 6, * ) 'Usage: acta_plot input_file [output_file]'
           CALL EXIT ( 1 )
         ELSE
           CALL GETARG ( 1, FILIN )
           IF ( IARGC() .GE. 2 ) THEN
                CALL GETARG ( 2, FILOUT )
           END IF
      END IF
!
      IUER = -1
      CALL ACTA_PLOT ( FILIN, FILOUT, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
      END  PROGRAM  ACTA_PLOT_MAIN  !#!#
!
! ------------------------------------------------------------------------
!
      SUBROUTINE ACTA_PLOT ( FILIN, FILOUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine ACTA_PLOT 
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 18-APR-2014   ACTA_PLOT   v1.0 (d)  L. Petrov  18-APR-2014 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'pima.i'
      INCLUDE   'diagi.i'
      TYPE     ( DIAGI_STRU ) ::  DIAGI_S
      CHARACTER  FILIN*(*), FILOUT*(*)
      INTEGER*4  IUER
      CHARACTER  STR*128, EXP_NAME*32, STA_NAME*8, SCAN_NAME*16, EXT*8
      CHARACTER  REG*3
      PARAMETER  ( REG = CHAR(32)//CHAR(0)//CHAR(9) )
      INTEGER*8  SIZE_I8
      INTEGER*4  ACTA__LEN, MIND
      PARAMETER  ( ACTA__LEN = 74  )
      PARAMETER  ( MIND = 32 )
      INTEGER*4  IBST, ILST, IOST, IPST, IWST, IDEV, ICL1, ICL2, ICL3
      INTEGER*4  DIAGI_LEN
      CHARACTER  ZAG*128, UNIT*128
      CHARACTER, ALLOCATABLE :: BUF(:)*128
      REAL*8,    ALLOCATABLE :: FRQ_ARR(:), AC_ARR(:)
      INTEGER*4  UNIX_DATE, J1, J2, J3, J4, IP, IS, MB, NB, NP, &
     &           LIND, IND(2,MIND), IBATCH, IER
      INTEGER*4, EXTERNAL :: I_LEN, ILEN, FILE_INFO, LINDEX
!
! --- Clear DIAGI_S object
!
      DIAGI_LEN = LOC(DIAGI_S%STATUS) - LOC(DIAGI_S%IFIRST_FIELD) + 4
      CALL NOUT ( DIAGI_LEN, DIAGI_S )
!
! --- Setting defaults values of the plotting parameters
!
      CALL ERR_PASS   ( IUER, IER )
      CALL DIAGI_DEF  ( IBST, ILST, IOST, IPST, IWST, IDEV, ZAG, UNIT, &
     &                  ICL1, ICL2, ICL3, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 6316, IUER, 'ACTA_PLOT', 'Error in setting '// &
     &         'default values for the plot' )
           RETURN
      END IF
!
      IF ( FILOUT == '/XW' .OR. FILOUT == '/xw' .OR. &
     &     FILOUT == '/XS' .OR. FILOUT == '/xs' ) THEN
           IDEV = 1
           IBATCH = 0
         ELSE
           IF ( ILEN(FILOUT) < 5 ) THEN
                CALL ERR_LOG ( 6311, IUER, 'ACTA_PLOT', 'Output file '// &
     &              'name '//FILOUT(1:I_LEN(FILOUT))//' is too short' )
                RETURN
           END IF
           IP = LINDEX ( FILOUT, '.' ) 
           IF ( IP .LE. 0 ) THEN
                CALL ERR_LOG ( 6312, IUER, 'ACTA_PLOT', 'Output file '// &
     &              'name '//FILOUT(1:I_LEN(FILOUT))//' does not have '// &
     &              'any extension' )
                RETURN
           END IF
           EXT = FILOUT(IP:)
           IF ( EXT == '.ps' ) THEN
                IDEV = 5
                IBATCH = 1
              ELSE IF ( EXT == '.gif' ) THEN
                IDEV = 8
                IBATCH = 1
              ELSE IF ( EXT == '.sav' ) THEN
                IDEV = 8
                IBATCH = 2
              ELSE 
                CALL ERR_LOG ( 6312, IUER, 'ACTA_PLOT', 'Output file '// &
     &              'name '//FILOUT(1:I_LEN(FILOUT))//' has an extension '// &
     &               EXT(1:I_LEN(EXT))//' that is not supported. List of '// &
     &              'supported extnesion: .ps, .gif, .sav' )
                RETURN
           END IF
      END IF
!
! --- Learn the size of the file
!
      IS = FILE_INFO ( FILIN(1:I_LEN(FILIN))//CHAR(0), UNIX_DATE, SIZE_I8 )
      IF ( IS .NE. 0 ) THEN
           CALL CLRCH  ( STR )
           CALL GERROR ( STR )
           CALL ERR_LOG ( 6311, IUER, 'ACTA_PLOT', 'Cannot find input '// &
     &         'file '//FILIN(1:I_LEN(FILIN))//' -- '//STR )
           RETURN
      END IF
!
! --- Determine approximage number of lines in the input file
!
      MB = SIZE_I8/ACTA__LEN + 256
!
! --- Allocate menmory for the buffer wiht file contents and array of frequencies
! --- and autospectrum values
!
      ALLOCATE ( BUF(MB),     STAT=IER )
      IF ( IER .NE.0 ) THEN
           CALL CLRCH ( STR )
           CALL IINCH ( 128*MB, STR )
           CALL ERR_LOG ( 6312, IUER, 'ACTA_PLOT', 'Cannot allocate '// &
     &          STR(1:I_LEN(STR))//' bytes of dynamic memory for '// &
     &         'array BUF' )
           RETURN
      END IF
!
      ALLOCATE ( FRQ_ARR(MB), STAT=IER )
      IF ( IER .NE.0 ) THEN
           CALL CLRCH ( STR )
           CALL IINCH ( 8*MB, STR )
           CALL ERR_LOG ( 6313, IUER, 'ACTA_PLOT', 'Cannot allocate '// &
     &          STR(1:I_LEN(STR))//' bytes of dynamic memory for '// &
     &         'array FRQ_ARR' )
           RETURN
      END IF
      ALLOCATE ( AC_ARR(MB),  STAT=IER )
      IF ( IER .NE.0 ) THEN
           CALL CLRCH ( STR )
           CALL IINCH ( 8*MB, STR )
           CALL ERR_LOG ( 6314, IUER, 'ACTA_PLOT', 'Cannot allocate '// &
     &          STR(1:I_LEN(STR))//' bytes of dynamic memory for '// &
     &         'array AC_ARR' )
           RETURN
      END IF
!
! --- Read the file
!
      CALL ERR_PASS ( IUER, IER )
      CALL RD_TEXT ( FILIN, MB, BUF, NB, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 6315, IUER, 'ACTA_PLOT', 'Failure in reading '// &
     &         'input file '//FILIN )
           RETURN
      END IF
!
      IF ( BUF(1)(1:LEN(PIMA__ACTA_LABEL)) .NE. PIMA__ACTA_LABEL ) THEN
           STR = BUF(1)
           CALL TRAN ( 13, STR, STR )
           CALL ERR_LOG ( 6316, IUER, 'ACTA_PLOT', 'Trap of internal control: '// &
     &         'the first line of the input file '//FILIN(1:I_LEN(FILIN))// &
     &         ' is '//STR(1:I_LEN(STR))//' while format label '// &
     &         PIMA__ACTA_LABEL//' was expected' )
           RETURN
      END IF
!
! --- Parse the file
!
      NP = 0
      DO 410 J1=2,NB
         CALL EXWORD ( BUF(J1), MIND, LIND, IND, REG, IER )
         IF ( LIND < 3 ) GOTO 410
         IF ( BUF(J1)(IND(1,2):IND(2,2)) == 'Experiment:' ) THEN
              EXP_NAME = BUF(J1)(IND(1,3):IND(2,3)) 
         END IF
         IF ( BUF(J1)(IND(1,2):IND(2,2)) == 'Station:' ) THEN
              STA_NAME = BUF(J1)(IND(1,3):IND(2,3)) 
         END IF
         IF ( BUF(J1)(IND(1,2):IND(2,2)) == 'Scan_name:' ) THEN
              SCAN_NAME = BUF(J1)(IND(1,3):IND(2,3)) 
         END IF
         IF ( BUF(J1)(IND(1,1):IND(2,1)) == 'ACRL' ) THEN
              NP = NP + 1
              READ ( UNIT=BUF(J1)(IND(1,7):IND(2,7)),   FMT='(F24.12)' ) FRQ_ARR(NP)
              READ ( UNIT=BUF(J1)(IND(1,10):IND(2,10)), FMT='(F24.12)' ) AC_ARR(NP)
         END IF
 410  CONTINUE 
!
! --- Generate the title
!
      ZAG = 'Autocorrelation at '//STA_NAME//' in scan '// &
     &      SCAN_NAME(1:I_LEN(SCAN_NAME))//' in experiment '//EXP_NAME
      UNIT = 'Hz'
!
! --- Setting up the values of the DIAGI internal data structure for the further
! --- plotting
!
      DIAGI_S%IDEV      = IDEV
      DIAGI_S%NCLR      = 1
      DIAGI_S%NPOI(1)   = NP
      DIAGI_S%ADR_X8(1) = LOC(FRQ_ARR)
      DIAGI_S%ADR_Y8(1) = LOC(AC_ARR)
      DIAGI_S%LER(1)    = .FALSE.
      DIAGI_S%ICOL(1)   = ICL1
      DIAGI_S%IBST(1)   = 0
      DIAGI_S%ILST(1)   = ILST
      DIAGI_S%IOST(1)   = IOST
      DIAGI_S%IPST(1)   = IPST
      DIAGI_S%IWST(1)   = IWST
      DIAGI_S%ICLR      = 1
      DIAGI_S%XMIN      = 1.0
      DIAGI_S%XMAX      = 0.0
      DIAGI_S%YMIN      = 1.0
      DIAGI_S%YMAX      = 0.0
      DIAGI_S%ZAG       = ZAG
      DIAGI_S%NAME      = FILOUT
      DIAGI_S%ARG_UNITS = UNIT
      DIAGI_S%ITRM      = 0
      DIAGI_S%IBATCH    = IBATCH
      DIAGI_S%STATUS    = DIA__DEF
!
! --- Calling the main routine of DiaGI
!
      CALL ERR_PASS ( IUER, IER )
      CALL DIAGI    ( DIAGI_S, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 6319, IUER, 'ACTA_PLOT', 'Error in DIAGI' )
           RETURN
      END IF
!
! --- Final cleaning
!
      DEALLOCATE ( BUF )
      DEALLOCATE ( AC_ARR )
      DEALLOCATE ( FRQ_ARR )
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  ACTA_PLOT !#!  
