      SUBROUTINE PIMA_UPDATE_BADUV_LIST ( PIM, N_BAD, UV_BAD, N_NEW, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine  PIMA_UPDATE_BADUV_LIST 
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * # 09-OCT-2009 PIMA_UPDATE_BADUV_LIST v1.0 (d) L. Petrov 09-OCT-2009 #*
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'pima.i'
      TYPE     ( PIMA__TYPE    ) :: PIM
      CHARACTER  FILBAD*128
      INTEGER*4  N_BAD, UV_BAD(N_BAD), N_NEW, IUER
      INTEGER*4  N_EXT, N_LEN
      PARAMETER  ( N_EXT = 1024 )
      PARAMETER  ( N_LEN = 13   )
      CHARACTER  STR*128
      CHARACTER, ALLOCATABLE :: BUF(:)*24
      INTEGER*4, ALLOCATABLE :: USE_UV_BAD(:)
      LOGICAL*4  LEX
      INTEGER*4  N_OLD, J1, J2, J3, J4, IOS, NB, NOUT, LAST_UV_BAD, &
     &           K_BAD, L_BAD, LAST_BAD, IVAL, IP, UNIX_DATE, IS, &
     &           K_LIN, IER
      INTEGER*8  SIZE_I8
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN, IFIND_PL, FILE_INFO 
!
      N_NEW = 0
      IF ( N_BAD == 0 ) THEN
!
! -------- No bad points? Nothing to do!
!
           CALL ERR_LOG ( 0, IUER )
           RETURN 
      END IF
!
! --- The name of the file with bad points in AUTO mode
!
      FILBAD = PIM%CONF%EXPER_DIR(1:I_LEN(PIM%CONF%EXPER_DIR))//'/'// &
     &         PIM%CONF%SESS_CODE(1:I_LEN(PIM%CONF%SESS_CODE))//'_uv.exc'
      INQUIRE ( FILE=FILBAD, EXIST=LEX )
      IF ( LEX ) THEN
           IS = FILE_INFO ( FILBAD(1:I_LEN(FILBAD))//CHAR(0), UNIX_DATE, &
     &                      SIZE_I8 )
!
! -------- Try to get approximate number of lines using the filesize
!
           K_LIN = SIZE_I8/N_LEN
         ELSE 
           K_LIN = 0
      END IF
      ALLOCATE ( BUF(N_BAD+K_LIN+N_EXT), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL CLRCH ( STR )
           CALL INCH  ( (PIM%NUV+N_EXT)*LEN(BUF(1)), STR )
           CALL ERR_LOG ( 7621, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &         'Error in an attempt to allocate '//STR(1:I_LEN(STR))// &
     &         ' bytes memory for BUF' )
           RETURN 
      END IF
!
      ALLOCATE ( USE_UV_BAD(2*PIM%NUV+N_EXT), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL CLRCH ( STR )
           CALL INCH  ( (PIM%NUV+N_EXT)*4, STR )
           DEALLOCATE ( BUF )
           CALL ERR_LOG ( 7622, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &         'Error in an attempt to allocate '//STR(1:I_LEN(STR))// &
     &         ' bytes memory for USE_UV_BAD' )
           RETURN 
      END IF
      K_BAD = 0
      IF ( LEX ) THEN
           CALL ERR_PASS ( IUER, IER )
           CALL RD_TEXT  ( FILBAD, PIM%NUV+N_EXT, BUF, NB, IER )
           IF ( IER .NE. 0 ) THEN
                CALL ERR_LOG ( 7623, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &              'Error in an attempt to read existing UV exclude '// &
     &              'file '//FILBAD )
                DEALLOCATE ( BUF )
                DEALLOCATE ( USE_UV_BAD )
                RETURN 
           END IF
!
           DO 410 J1=1,NB
              IF ( BUF(J1)(1:1)  == '#' ) GOTO 410
              IF ( ILEN(BUF(J1)) ==  0  ) GOTO 410
              CALL CHASHL ( BUF(J1) )
              READ ( UNIT=BUF(J1), FMT='(I12)', IOSTAT=IOS ) IVAL 
              IF ( IOS .NE. 0 ) THEN
                   CALL ERR_LOG ( 7624, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &                'Error in parsing '//BUF(J1)(1:I_LEN(BUF(J1)))// &
     &                ' -- the '//STR(1:I_LEN(STR))//' -th '// &
     &                'string of the existing UV exclude file '//FILBAD )
                   DEALLOCATE ( BUF )
                   DEALLOCATE ( USE_UV_BAD )
                   RETURN 
              END IF
              IF ( IVAL > 0 .AND. IVAL .LE. PIM%NUV ) THEN
                   K_BAD = K_BAD + 1
                   USE_UV_BAD(K_BAD) = IVAL
                   IF ( PIM%CONF%DEBUG_LEVEL .GE. 6 ) THEN
                        WRITE ( 6, * ) 'PIMA_UPDATE_BADUVE_LIST K_BAD= ', K_BAD, &
     &                                 ' ORIG_IND: ', IVAL
                   END IF
              END IF
 410       CONTINUE 
      END IF
!
      NOUT = 1; BUF(NOUT) = '# UV EXCLUDE file'
      NOUT = 2; BUF(NOUT) = '# '
      NOUT = 3; BUF(NOUT) = '# Generated by PIMA on'
      NOUT = 4; BUF(NOUT) = '#    '//GET_CDATE()
      NOUT = 5; BUF(NOUT) = '# '
!
! --- Augment new bad points to the old bad points from the exclude
! --- file 
!
      DO 420 J2=1,N_BAD
         IF ( K_BAD > 0 ) THEN
              IP = IFIND_PL ( K_BAD, USE_UV_BAD, &
     &                        PIM%UV_IND(UV_BAD(J2))%ORIG_IND )
              IF ( IP > 0 ) GOTO 420
         END IF
         K_BAD = K_BAD + 1
         IF ( K_BAD > 2*PIM%NUV ) THEN
               CALL CLRCH ( STR )
               CALL INCH  ( 2*PIM%NUV, STR )
               CALL ERR_LOG ( 7625, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &             'Trap of internal control: too many bad UV '// &
     &             'points: more than '//STR )
                    DEALLOCATE ( USE_UV_BAD )
               RETURN 
          END IF
          IF ( UV_BAD(J2) > 0 ) THEN
               N_NEW = N_NEW + 1
               IF ( PIM%CONF%DEBUG_LEVEL .GE. 6 ) THEN
                    WRITE ( 6, * ) 'PIMA_UPDATE_BADUVE_LIST J2= ', J2, ' BAD_POI_IND: ', UV_BAD(J2), &
     &                             ' ORIG_IND: ', PIM%UV_IND(UV_BAD(J2))%ORIG_IND
               END IF
               USE_UV_BAD(K_BAD) = PIM%UV_IND(UV_BAD(J2))%ORIG_IND
             ELSE 
               K_BAD = K_BAD - 1
          END IF
 420  CONTINUE 
      IF ( N_NEW == 0 ) THEN
           DEALLOCATE ( BUF )
           DEALLOCATE ( USE_UV_BAD )
           IF ( PIM%CONF%DEBUG_LEVEL .GE. 3 ) THEN
                WRITE ( 6, '(A)' ) 'PIMA_UV_UPDATE_BADUV_LIST: No new bad '// &
     &                 'points have been found' 
           END IF
           CALL ERR_LOG ( 0, IUER )
           RETURN 
      END IF
!
! --- Sort the consolidated list
!
      CALL SORT_FAST_I4 ( K_BAD, USE_UV_BAD )
!
      L_BAD = 0
      LAST_BAD = 0
      DO 430 J3=1,K_BAD
!
! ------ Mark duplicates with zeros
!
         IF ( USE_UV_BAD(J3) == LAST_BAD ) THEN
              USE_UV_BAD(J3) = 0
            ELSE 
              L_BAD = L_BAD + 1  ! Augment the counter of non-duplicates
              LAST_BAD = USE_UV_BAD(J3) 
         END IF
 430  CONTINUE 
!
! --- Write down the sorted list of original UV point indexes
!
      IF ( L_BAD > 0 ) THEN
           NOUT = 6
           WRITE ( UNIT=BUF(NOUT), FMT='("#  N_bad: ", I8)' ) L_BAD
           NOUT = 7; BUF(NOUT) = '# '
           L_BAD = 0
           LAST_UV_BAD = 0
           DO 440 J4=1,K_BAD
              IF ( USE_UV_BAD(J4) > 0 ) THEN
                   L_BAD = L_BAD + 1
                   NOUT = NOUT + 1
                   IF ( NOUT > N_BAD+K_LIN+N_EXT ) THEN
                        WRITE ( 6, * ) 'N_BAD= ', N_BAD, ' K_LIN= ', K_LIN
                        CALL ERR_LOG ( 7626, IUER, 'PIMA_UPDATE_BADUV_LIST', &
     &                      'Trap of internal control: we incorrectly '// &
     &                      'computed the size of BUF array' )
                        DEALLOCATE ( USE_UV_BAD )
                        DEALLOCATE ( BUF )
                        RETURN 
                   END IF
                   WRITE ( UNIT=BUF(NOUT), FMT='(I12)' ) USE_UV_BAD(J4)
              END IF
 440       CONTINUE 
         ELSE 
           NOUT = 6; BUF(NOUT) = '# N_bad: 0'
           NOUT = 7; BUF(NOUT) = '# '
      END IF
!
! --- Write the output file
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT ( NOUT, BUF, FILBAD, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7627, IUER, 'PIMA_UPDATE_BADUV_LIST', 'Error '// &
     &         'in an attempt to write in the external bad UV points file '// &
     &          FILBAD )
           DEALLOCATE ( BUF )
           DEALLOCATE ( USE_UV_BAD )
           RETURN 
      END IF
      DEALLOCATE ( BUF )
      DEALLOCATE ( USE_UV_BAD )
!
      IF ( L_BAD > 0  ) THEN
           IF ( PIM%CONF%DEBUG_LEVEL .GE. 3 ) THEN
                WRITE ( 6, 110 ) L_BAD, FILBAD(1:I_LEN(FILBAD))
 110            FORMAT ( 'PIMA_UV_UPDATE_BADUV_LIST: ', I8, ' UV points ', &
     &                   'are excluded and kept in file ', A )
           END IF
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  PIMA_UPDATE_BADUV_LIST  !#!#
