      SUBROUTINE PIMA_WRITE_GACO ( PIM, L_SOU, C_SOU, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine PIMA_WRITE_GACO
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 24-FEB-2016  PIMA_WRITE_GACO v1.0 (d) L. Petrov 24-FEB-2016 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'pima.i'
      TYPE     ( PIMA__TYPE  ) :: PIM
      INTEGER*4  L_SOU, IUER
      CHARACTER  C_SOU(L_SOU)*(*)
      INTEGER*4  MBUF
      PARAMETER  ( MBUF = 128 + 2*PIM__MSTA*PIM__MFRQ )
      CHARACTER  BUF(MBUF)*128, STR*32
      INTEGER*4  NO, J1, J2, J3, J4, IER
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      BUF(1) = PIMA__GACO_LABEL
      NO = 1 
      NO = NO + 1 ; BUF(NO) = '#'
      NO = NO + 1 ; BUF(NO) = '# Gain correction file. Generated by '//PIMA__LABEL//' on '//GET_CDATE()
      NO = NO + 1 ; BUF(NO) = '#'
      NO = NO + 1 ; BUF(NO) = '# Experiment:      '//PIM%CONF%SESS_CODE
      CALL CLRCH ( STR )
      CALL INCH  ( PIM%CONF%FRQ_GRP, STR )
      NO = NO + 1 ; BUF(NO) = '# Frequency group: '//STR
      CALL CLRCH ( STR )
      CALL INCH  ( L_SOU, STR(1:3) )
      IF ( L_SOU > 0 ) THEN
           NO = NO + 1 ; BUF(NO) = '#'
           CALL CHASHR ( STR(1:3) )
           NO = NO + 1 ; BUF(NO) = '# '//STR(1:3)//' maps at '//PIM%CONF%BAND// &
     &                             ' band were used to derive gain corrections'
           NO = NO + 1 ; BUF(NO) = '#'
           DO 410 J1=1,L_SOU
              NO = NO + 1 ; BUF(NO) = '#     Source: '//C_SOU(J1)
 410       CONTINUE 
      END IF
      NO = NO + 1 ; BUF(NO) = '#'
      NO = NO + 1 ; BUF(NO) = '#  Format:'
      NO = NO + 1 ; BUF(NO) = '#'
      NO = NO + 1 ; BUF(NO) = '#   1-4   A4       filler 1'
      NO = NO + 1 ; BUF(NO) = '#   6-13  A8     Station name'
      NO = NO + 1 ; BUF(NO) = '#  16-18  A2       filler 2'
      NO = NO + 1 ; BUF(NO) = '#  20-21  I2     IF index'
      NO = NO + 1 ; BUF(NO) = '#  24-28  A5       filler 3'
      NO = NO + 1 ; BUF(NO) = '#  30-43  F14.1  Frequency (Hz)'
      NO = NO + 1 ; BUF(NO) = '#  46-50  A5       filler 4'
      NO = NO + 1 ; BUF(NO) = '#  52-59  F8.4   Gain correction'
      NO = NO + 1 ; BUF(NO) = '#  62-65  A5       filler 5'
      NO = NO + 1 ; BUF(NO) = '#  67-73  F7.4   Multiplicative gain error. -1 for lack of data'
      NO = NO + 1 ; BUF(NO) = '#  76-80  A5       filler 6'
      NO = NO + 1 ; BUF(NO) = '#  82-89  I8     Number of visibilites used in parameter estimation'
      NO = NO + 1 ; BUF(NO) = '#'
!
      DO 420 J2=1,PIM%NSTA
         NO = NO + 1 ; BUF(NO) = '#'
         DO 430 J3=1,PIM%GACO(J2)%NFRQ
            NO = NO + 1
            WRITE ( BUF(NO), 110 ) PIM%C_STA(J2), J3, PIM%GACO(J2)%GACO_FRQ(J3), &
     &                             PIM%GACO(J2)%GAIN_CORR(J3), PIM%GACO(J2)%GACO_ERR(J3), &
     &                             PIM%GACO(J2)%NVIS(J3) 
 110        FORMAT ( 'Sta: ', A, '  IF: ', I2, '  Freq: ', F14.1, &
     &               '  Gain: ', F8.4, '  Err: ', F7.4, '  Nvis: ', I7 )
 430     CONTINUE 
 420  CONTINUE 
      NO = NO + 1 ; BUF(NO) = '#'
      NO = NO + 1 ; BUF(NO) = PIMA__GACO_LABEL
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT  ( NO, BUF, PIM%CONF%SPLT_GAIN_CORR_FILE, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7301, IUER, 'PIMA_WRITE_GACO', 'Failure in '// &
     &         'an attempt to write gain corrections into the output '// &
     &         'file '//PIM%CONF%SPLT_GAIN_CORR_FILE )
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  PIMA_WRITE_GACO  !#!#
