!
! --- This file was generated automatically by nut_out v4.2  2003.12.27
! --- written by Leonid Petrov ( Leonid.Petrov@lpetrov.net )
! --- File was created at 2003.12.27-18:17:06
! --- It contains nutation expansion of the model MHB2000 according to Herring
! --- Phases, frequencies, accelerations of the arguments as well as amplitudes
! --- of cos and sin components of nutation in longitude and in obliquity
! --- are transformed to the form suitable for computations.
! --- Nutation is considered as a a harmonic variations in polar motion
! --- Convention: angles of a small rotation are computed as :
! ---             E1 = sum_i {  PMC_i*cos(ARG_i) + PMS_i*sin(ARG_i) }
! ---             E2 = sum_i { -PMC_i*sin(ARG_i) + PMS_i*cos(ARG_i) }
! ---             E3 = 0
! --- Truncation limit for amplitudes:   0.0050 prad
! --- Units are picoradians for amplitudes  and  1.0D-24 rad/sec for their rates
! --- in total 2609 constituents are presented
! --- This expansion does not contains terms with geodesic nutation
! --- Epsilon_o =  0.4090928041 rad
! --- OM_preces = -7.08618327D-12 rad/sec
!
      INTEGER*4   N_NUT, I_NUT
      PARAMETER ( N_NUT = 2609 )
      INTEGER*4  IND_NUT(N_NUT)
      CHARACTER  TYP_NUT(N_NUT)*1, MODEL_NUT*40
      REAL*8     PHAS_NUT(N_NUT), FREQ_NUT(N_NUT), ACCL_NUT(N_NUT)
      REAL*8     PMC_NUT(N_NUT),      PMS_NUT(N_NUT)
      REAL*8     PMC_RATE_NUT(N_NUT), PMS_RATE_NUT(N_NUT)
      REAL*8     EPSILON_0_NUT
      PARAMETER  ( EPSILON_0_NUT = 0.4090928041D0 ) ! rad
      PARAMETER  ( MODEL_NUT = 'MHB2000 according to Herring            ' )
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1,10 ) &
     &             /            &
     & 3.9760818283D0, -9.372658679113D-05, -1.0147D-22,  444, 'R', & !    1
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4726993346D0, -9.338407927653D-05, -1.9712D-23,  678, 'R', & !    2
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5734454452D0, -9.337338231416D-05, -2.6987D-23,  318, 'R', & !    3
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5303202649D0, -9.317428543887D-05, -2.7526D-23,  677, 'R', & !    4
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1708090620D0, -9.302017783719D-05,  4.7496D-23,  443, 'R', & !    5
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6335278444D0, -9.145128517773D-05, -1.3764D-22,  676, 'R', & !    6
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7342739549D0, -9.144058821536D-05, -1.4491D-22,  442, 'R', & !    7
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0915774449D0, -9.128648061368D-05, -6.9893D-23,  675, 'R', & !    8
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2308914612D0, -9.109808070076D-05, -6.3156D-23,  441, 'R', & !    9
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0484522646D0, -9.108738373839D-05, -7.0431D-23,  184, 'R', & !   10
     &          0.7D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  11,  20 ) &
     &             /                 &
     & 0.6889410618D0, -9.093327613671D-05,  4.5901D-24,  674, 'R', & !   11
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0053270844D0, -9.088828686310D-05, -7.0970D-23,  440, 'R', & !   12
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8282550781D0, -9.074487622378D-05,  1.1327D-23,  317, 'R', & !   13
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6458158815D0, -9.073417926142D-05,  4.0515D-24,  170, 'R', & !   14
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7851298979D0, -9.054577934849D-05,  1.0788D-23,  673, 'R', & !   15
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6026907012D0, -9.053508238613D-05,  3.5129D-24,  439, 'R', & !   16
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4256186950D0, -9.039167174681D-05,  8.5810D-23,  672, 'R', & !   17
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2431794984D0, -9.038097478445D-05,  7.8534D-23,  316, 'R', & !   18
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2000543181D0, -9.018187790915D-05,  7.7996D-23,  671, 'R', & !   19
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9890835879D0, -8.881208212499D-05, -1.0660D-22,  269, 'R', & !   20
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  21,  30 ) &
     &             /                 &
     & 1.8066443913D0, -8.880138516262D-05, -1.1388D-22,  147, 'R', & !   21
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6295723850D0, -8.865797452331D-05, -3.1579D-23,  669, 'R', & !   22
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4471331884D0, -8.864727756094D-05, -3.8854D-23,  315, 'R', & !   23
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2469188533D0, -8.862478292414D-05, -7.6634D-23,  668, 'R', & !   24
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7635192110D0, -8.860228828733D-05, -1.1441D-22,  667, 'R', & !   25
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4857010942D0, -8.846957461038D-05, -2.4842D-23,  665, 'R', & !   26
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5864472047D0, -8.845887764802D-05, -3.2117D-23,  159, 'R', & !   27
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4040080081D0, -8.844818068565D-05, -3.9393D-23,   81, 'R', & !   28
     &          6.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.3135850774D0, -8.840317239272D-05, -1.1175D-22,  664, 'R', & !   29
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0444968052D0, -8.829407308397D-05,  3.5629D-23,  438, 'R', & !   30
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  31,  40 ) &
     &             /                 &
     & 5.8442824701D0, -8.827157844716D-05, -2.1512D-24,  663, 'R', & !   31
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5433220245D0, -8.825978077272D-05, -3.2656D-23,  437, 'R', & !   32
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3608828279D0, -8.824908381036D-05, -3.9931D-23,  224, 'R', & !   33
     &          0.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.0830647110D0, -8.811637013341D-05,  4.9641D-23,  662, 'R', & !   34
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1838108216D0, -8.810567317104D-05,  4.2365D-23,  183, 'R', & !   35
     &          2.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.0013716250D0, -8.809497620868D-05,  3.5090D-23,   98, 'R', & !   36
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3177576476D0, -8.804998693507D-05, -4.0470D-23,  661, 'R', & !   37
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9109486943D0, -8.804996791575D-05, -3.7267D-23,  660, 'R', & !   38
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7285094977D0, -8.803927095339D-05, -4.4542D-23,  659, 'R', & !   39
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1406856413D0, -8.790657629575D-05,  4.1827D-23,  436, 'R', & !   40
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  41,  50 ) &
     &             /                 &
     & 2.9582464447D0, -8.789587933339D-05,  3.4552D-23,  223, 'R', & !   41
     &          0.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.7811744385D0, -8.775246869407D-05,  1.1685D-22,  658, 'R', & !   42
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5987352419D0, -8.774177173170D-05,  1.0957D-22,  314, 'R', & !   43
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9151212645D0, -8.769678245809D-05,  3.4013D-23,  657, 'R', & !   44
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2251270040D0, -8.769676343878D-05,  3.7216D-23,  656, 'R', & !   45
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0201378418D0, -8.658178880451D-05, -7.0412D-23,  654, 'R', & !   46
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5648365179D0, -8.651538658685D-05, -1.5732D-22,  435, 'R', & !   47
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1045792044D0, -8.637197594754D-05, -7.5023D-23,  653, 'R', & !   48
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2053253150D0, -8.636127898517D-05, -8.2298D-23,  268, 'R', & !   49
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5167553481D0, -8.623928128990D-05,  1.1346D-23,  652, 'R', & !   50
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  51,  60 ) &
     &             /                 &
     & 5.6175014587D0, -8.622858432754D-05,  4.0710D-24,  434, 'R', & !   51
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3624144699D0, -8.618467674669D-05, -4.5057D-23,  651, 'R', & !   52
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2438932208D0, -8.618357603461D-05, -6.8286D-23,  433, 'R', & !   53
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0614540242D0, -8.617287907225D-05, -7.5561D-23,  106, 'R', & !   54
     &         12.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.1622001348D0, -8.616218210988D-05, -8.2837D-23,   54, 'R', & !   55
     &         18.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.7885918969D0, -8.611717381695D-05, -1.5519D-22,  650, 'R', & !   56
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7019428213D0, -8.601877147057D-05, -5.3998D-25,  313, 'R', & !   57
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8026889319D0, -8.600807450820D-05, -7.8152D-24,  182, 'R', & !   58
     &         -0.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5017284862D0, -8.599627683376D-05, -3.8320D-23,  649, 'R', & !   59
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3192892896D0, -8.598557987139D-05, -4.5595D-23,  267, 'R', & !   60
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  61,  70 ) &
     &             /                 &
     & 0.0183288439D0, -8.597378219695D-05, -7.6100D-23,  432, 'R', & !   61
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1190749545D0, -8.596308523459D-05, -8.3375D-23,  241, 'R', & !   62
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1141189650D0, -8.588607681293D-05,  8.5829D-23,  648, 'R', & !   63
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2148650755D0, -8.587537985057D-05,  7.8554D-23,  312, 'R', & !   64
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9597780867D0, -8.583147226971D-05,  2.9426D-23,  647, 'R', & !   65
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8412568377D0, -8.583037155764D-05,  6.1966D-24,  266, 'R', & !   66
     &          6.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.6588176411D0, -8.581967459527D-05, -1.0786D-24,   74, 'R', & !   67
     &         32.4D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.7595637516D0, -8.580897763291D-05, -8.3538D-24,   36, 'R', & !   68
     &         50.5D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.5683947104D0, -8.577466630235D-05, -7.3436D-23,  584, 'P', & !   69
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3859555138D0, -8.576396933998D-05, -8.0711D-23,  311, 'R', & !   70
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  71,  80 ) &
     &             /                 &
     & 5.4867016243D0, -8.575327237762D-05, -8.7986D-23,  431, 'R', & !   71
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2993064382D0, -8.566556699359D-05,  7.3943D-23,  646, 'R', & !   72
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4000525487D0, -8.565487003123D-05,  6.6668D-23,  310, 'R', & !   73
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0990921031D0, -8.564307235679D-05,  3.6163D-23,  645, 'R', & !   74
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9166529065D0, -8.563237539442D-05,  2.8888D-23,  309, 'R', & !   75
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7981316574D0, -8.563127468235D-05,  5.6580D-24,  644, 'R', & !   76
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6156924608D0, -8.562057771998D-05, -1.6172D-24,  203, 'R', & !   77
     &          2.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.7164385714D0, -8.560988075762D-05, -8.8924D-24,  104, 'R', & !   78
     &          4.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.3428303335D0, -8.556487246469D-05, -8.1250D-23,  643, 'R', & !   79
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4386204545D0, -8.547716708067D-05,  8.0679D-23,  430, 'R', & !   80
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  81,  90 ) &
     &             /                 &
     & 1.2561812579D0, -8.546647011830D-05,  7.3404D-23,  141, 'R', & !   81
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3569273685D0, -8.545577315594D-05,  6.6129D-23,   71, 'R', & !   82
     &         10.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5725672805D0, -8.542148084469D-05, -2.1558D-24,  642, 'R', & !   83
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1657583272D0, -8.542146182537D-05,  1.0470D-24,  583, 'P', & !   84
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6733133911D0, -8.541078388232D-05, -9.4310D-24,  308, 'R', & !   85
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9833191306D0, -8.541076486301D-05, -6.2282D-24,  265, 'R', & !   86
     &          6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0840652412D0, -8.540006790064D-05, -1.3503D-23,  307, 'R', & !   87
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5140165233D0, -8.527917091745D-05,  1.0337D-22,  641, 'R', & !   88
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2130560777D0, -8.526737324301D-05,  7.2866D-23,  306, 'R', & !   89
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3138021882D0, -8.525667628064D-05,  6.5590D-23,  169, 'R', & !   90
     &          1.4D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  91, 100 ) &
     &             /                 &
     & 1.9401939504D0, -8.521166798772D-05, -6.7668D-24,  640, 'R', & !   91
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0409400609D0, -8.520097102535D-05, -1.4042D-23,  639, 'R', & !   92
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8535448748D0, -8.511326564133D-05,  1.4789D-22,  638, 'R', & !   93
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9542909853D0, -8.510256867896D-05,  1.4061D-22,  429, 'R', & !   94
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2706770080D0, -8.505757940535D-05,  6.5052D-23,  428, 'R', & !   95
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5806827475D0, -8.505756038604D-05,  6.8255D-23,  427, 'R', & !   96
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3982435509D0, -8.504686342367D-05,  6.0979D-23,  637, 'R', & !   97
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9111658051D0, -8.490347180367D-05,  1.4007D-22,  636, 'R', & !   98
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5375575672D0, -8.485846351074D-05,  6.7716D-23,  635, 'R', & !   99
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9635174416D0, -8.407528040940D-05, -1.2574D-22,  634, 'R', & !  100
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 101, 110 ) &
     &             /                 &
     & 3.2749474747D0, -8.395328271413D-05, -3.2098D-23,  633, 'R', & !  101
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0925082781D0, -8.394258575177D-05, -3.9373D-23,  305, 'R', & !  102
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8196461508D0, -8.388688049648D-05, -1.1901D-22,  426, 'R', & !  103
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9203922614D0, -8.387618353411D-05, -1.2628D-22,  193, 'R', & !  104
     &         -1.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.8094547412D0, -8.387082169448D-05, -5.1798D-23,  688, 'R', & !  105
     &         -0.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6425741446D0, -8.374346985716D-05, -3.6709D-23,  632, 'R', & !  106
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6635394537D0, -8.373277467878D-05, -4.4523D-23,  683, 'R', & !  107
     &         -0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.4601349479D0, -8.373277289480D-05, -4.3984D-23,  240, 'R', & !  108
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2776957513D0, -8.372207593243D-05, -5.1259D-23,  124, 'R', & !  109
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0774814162D0, -8.369958129563D-05, -8.9039D-23,  425, 'R', & !  110
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 111, 120 ) &
     &             /                 &
     & 3.8723110916D0, -8.360007823716D-05,  4.2385D-23,  304, 'R', & !  111
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6898718950D0, -8.358938127480D-05,  3.5110D-23,  163, 'R', & !  112
     &         -1.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.9181845484D0, -8.356796833075D-05,  2.3762D-23,  631, 'R', & !  113
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9004094100D0, -8.355617065631D-05, -6.7426D-24,  630, 'R', & !  114
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4987028537D0, -8.355506994424D-05, -2.9972D-23,  396, 'P', & !  115
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7179702133D0, -8.354547369395D-05, -1.4018D-23,  264, 'R', & !  116
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5994489643D0, -8.354437298187D-05, -3.7247D-23,  155, 'R', & !  117
     &         28.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.8072718611D0, -8.353440211124D-05,  2.2685D-23,  679, 'R', & !  118
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4170097677D0, -8.353367601950D-05, -4.4523D-23,   45, 'R', & !  119
     &        137.4D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.2345705711D0, -8.352297905714D-05, -5.1798D-23,   23, 'R', & !  120
     &        215.4D0,        -1.7D0,     -875.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 121, 130 ) &
     &             /                 &
     & 4.3353166816D0, -8.351228209477D-05, -5.9073D-23,  626, 'R', & !  121
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3265868370D0, -8.348866772658D-05, -1.1688D-22,  582, 'P', & !  122
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1441476404D0, -8.347797076421D-05, -1.2416D-22,  239, 'R', & !  123
     &          8.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2399377614D0, -8.339026538019D-05,  3.7774D-23,  625, 'R', & !  124
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0574985648D0, -8.337956841782D-05,  3.0499D-23,  222, 'R', & !  125
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8750593682D0, -8.336887145546D-05,  2.3224D-23,  109, 'R', & !  126
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7565381191D0, -8.336777074338D-05, -6.0365D-27,  624, 'R', & !  127
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8572842297D0, -8.335707378102D-05, -7.2812D-24,  238, 'R', & !  128
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6748450331D0, -8.334637681865D-05, -1.4556D-23,  138, 'R', & !  129
     &         -2.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.5563237840D0, -8.334527610658D-05, -3.7786D-23,  623, 'R', & !  130
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 131, 140 ) &
     &             /                 &
     & 2.3738845874D0, -8.333457914421D-05, -4.5061D-23,  221, 'R', & !  131
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1914453908D0, -8.332388218185D-05, -5.2336D-23,  115, 'R', & !  132
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7846364375D0, -8.332386316253D-05, -4.9134D-23,  622, 'R', & !  133
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6021972409D0, -8.331316620017D-05, -5.6409D-23,  621, 'R', & !  134
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4696747085D0, -8.324687376019D-05,  1.1687D-22,  620, 'R', & !  135
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2872355118D0, -8.323617679782D-05,  1.0959D-22,  263, 'R', & !  136
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0960664706D0, -8.320186546726D-05,  4.4511D-23,  395, 'P', & !  137
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3153338302D0, -8.319226921697D-05,  6.0465D-23,  424, 'R', & !  138
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1968125812D0, -8.319116850490D-05,  3.7235D-23,  144, 'R', & !  139
     &         36.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.0143733845D0, -8.318047154253D-05,  2.9960D-23,   39, 'R', & !  140
     &        172.8D0,        -1.0D0,     -336.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 141, 150 ) &
     &             /                 &
     & 0.8319341879D0, -8.316977458017D-05,  2.2685D-23,   20, 'R', & !  141
     &        268.9D0,        -1.2D0,     -875.5D0,      0.0D0,     & !
     & 4.9326802985D0, -8.315907761780D-05,  1.5410D-23,  617, 'R', & !  142
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9239504539D0, -8.313546324961D-05, -4.2397D-23,  259, 'P', & !  143
     &          9.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1483202106D0, -8.312478530656D-05, -5.2875D-23,  423, 'R', & !  144
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7415112572D0, -8.312476628724D-05, -4.9672D-23,  127, 'R', & !  145
     &         50.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5590720606D0, -8.311406932487D-05, -5.6947D-23,  192, 'R', & !  146
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6598181712D0, -8.310337236251D-05, -6.4223D-23,  422, 'R', & !  147
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4724229851D0, -8.301566697849D-05,  9.7706D-23,  421, 'R', & !  148
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1714625394D0, -8.300386930405D-05,  6.7202D-23,  420, 'R', & !  149
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2722086500D0, -8.299317234168D-05,  5.9926D-23,  220, 'R', & !  150
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 151, 160 ) &
     &             /                 &
     & 5.1536874009D0, -8.299207162961D-05,  3.6697D-23,  419, 'R', & !  151
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9712482043D0, -8.298137466724D-05,  2.9422D-23,  114, 'R', & !  152
     &         11.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7888090077D0, -8.297067770488D-05,  2.2146D-23,   60, 'R', & !  153
     &         18.4D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.3820000544D0, -8.297065868556D-05,  2.5349D-23,  615, 'R', & !  154
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8986004121D0, -8.294816404875D-05, -1.2431D-23,  613, 'R', & !  155
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8808252736D0, -8.293636637431D-05, -4.2936D-23,  581, 'P', & !  156
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6983860770D0, -8.292566941195D-05, -5.0211D-23,  303, 'R', & !  157
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5159468804D0, -8.291497244958D-05, -5.7486D-23,  612, 'R', & !  158
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7941761980D0, -8.283796402793D-05,  1.1172D-22,  611, 'R', & !  159
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6117370014D0, -8.282726706556D-05,  1.0444D-22,  154, 'R', & !  160
     &          5.4D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 161, 170 ) &
     &             /                 &
     & 1.4292978048D0, -8.281657010319D-05,  9.7168D-23,   78, 'R', & !  161
     &          8.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9281230240D0, -8.278227779195D-05,  2.8883D-23,  418, 'R', & !  162
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2381287636D0, -8.278225877263D-05,  3.2086D-23,  297, 'P', & !  163
     &          8.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7456838274D0, -8.277158082958D-05,  2.1608D-23,  191, 'R', & !  164
     &          0.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3388748741D0, -8.277156181027D-05,  2.4811D-23,  137, 'R', & !  165
     &         43.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.1564356775D0, -8.276086484790D-05,  1.7535D-23,  168, 'R', & !  166
     &          4.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.2571817881D0, -8.275016788554D-05,  1.0260D-23,  609, 'R', & !  167
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5686118212D0, -8.262817019027D-05,  1.0390D-22,  417, 'R', & !  168
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3861726245D0, -8.261747322790D-05,  9.6629D-23,  202, 'R', & !  169
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1950035833D0, -8.258316189734D-05,  3.1547D-23,  580, 'P', & !  170
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 171, 180 ) &
     &             /                 &
     & 4.2957496939D0, -8.257246493498D-05,  2.4272D-23,  302, 'R', & !  171
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1133104972D0, -8.256176797261D-05,  1.6997D-23,  416, 'R', & !  172
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3430474443D0, -8.241837635261D-05,  9.6091D-23,  607, 'R', & !  173
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9362384910D0, -8.241835733330D-05,  9.9293D-23,  415, 'R', & !  174
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7537992944D0, -8.240766037093D-05,  9.2018D-23,  606, 'R', & !  175
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2526245136D0, -8.237336805968D-05,  2.3733D-23,  605, 'R', & !  176
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8931133107D0, -8.221926045800D-05,  9.8755D-23,  604, 'R', & !  177
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4911892019D0, -8.150247957432D-05, -7.7957D-24,  603, 'R', & !  178
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2183270746D0, -8.144677431903D-05, -8.7428D-23,  602, 'R', & !  179
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0358878779D0, -8.143607735666D-05, -9.4703D-23,  301, 'R', & !  180
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 181, 190 ) &
     &             /                 &
     & 5.6305032182D0, -8.131407966139D-05, -1.0591D-24,  262, 'R', & !  181
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4480640216D0, -8.130338269903D-05, -8.3343D-24,  151, 'R', & !  182
     &         -1.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.8588158717D0, -8.129266671735D-05, -1.2407D-23,  601, 'R', & !  183
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6763766751D0, -8.128196975498D-05, -1.9682D-23,  414, 'R', & !  184
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0744557837D0, -8.125837440610D-05, -8.0692D-23,  579, 'P', & !  185
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1752018943D0, -8.124767744374D-05, -8.7967D-23,  176, 'R', & !  186
     &         -4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9927626977D0, -8.123698048137D-05, -9.5242D-23,   84, 'R', & !  187
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6051531764D0, -8.112678046054D-05,  2.8907D-23,  413, 'R', & !  188
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7149445809D0, -8.110426680442D-05, -5.6701D-24,  412, 'R', & !  189
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8156906914D0, -8.109356984206D-05, -1.2945D-23,  126, 'R', & !  190
     &        -10.1D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 191, 200 ) &
     &             /                 &
     & 0.8366560006D0, -8.108287466367D-05, -2.0759D-23,  707, 'R', & !  191
     &         -1.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.6332514948D0, -8.108287287969D-05, -2.0220D-23,   62, 'R', & !  192
     &        -18.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.3322910492D0, -8.107107520525D-05, -5.0725D-23,  411, 'R', & !  193
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4330371597D0, -8.106037824288D-05, -5.8001D-23,  237, 'R', & !  194
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9496375174D0, -8.103788360608D-05, -9.5781D-23,  410, 'R', & !  195
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5428285641D0, -8.103786458676D-05, -9.2578D-23,  409, 'R', & !  196
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1674499316D0, -8.100831683438D-05, -2.0759D-23,  680, 'R', & !  197
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1271207245D0, -8.097157214679D-05,  8.0699D-23,  600, 'R', & !  198
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2278668351D0, -8.096087518442D-05,  7.3424D-23,  158, 'R', & !  199
     &         -5.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.0454276385D0, -8.095017822206D-05,  6.6148D-23,   79, 'R', & !  200
     &         -8.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 201, 210 ) &
     &             /                 &
     & 5.4561794886D0, -8.093946224037D-05,  6.2076D-23,  599, 'R', & !  201
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2737402919D0, -8.092876527801D-05,  5.4801D-23,  300, 'R', & !  202
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3177769765D0, -8.091697711323D-05,  2.2695D-23,  598, 'R', & !  203
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.9727798463D0, -8.091696760357D-05,  2.4296D-23,  261, 'R', & !  204
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8542585972D0, -8.091586689149D-05,  1.0665D-24,  217, 'P', & !  205
     &         19.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1353377799D0, -8.090628015086D-05,  1.5419D-23,  597, 'R', & !  206
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 6.0735259568D0, -8.090627064120D-05,  1.7021D-23,  150, 'R', & !  207
     &          1.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.6718194006D0, -8.090516992913D-05, -6.2087D-24,   66, 'R', & !  208
     &        296.0D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 5.2026460896D0, -8.090419401737D-05,  5.3724D-23,  681, 'R', & !  209
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8796422974D0, -8.089519905850D-05,  5.3724D-23,  682, 'R', & !  210
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 211, 220 ) &
     &             /                 &
     & 4.7725655112D0, -8.089447296676D-05, -1.3484D-23,   17, 'R', & !  211
     &       1414.6D0,        -6.5D0,    -1283.3D0,      0.0D0,     & !
     & 5.7570969078D0, -8.088388764552D-05, -2.0759D-23,  687, 'R', & !  212
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5901263146D0, -8.088377600440D-05, -2.0759D-23,    9, 'R', & !  213
     &       2208.4D0,       -10.3D0,    -5939.3D0,      0.0D0,     & !
     & 5.7317189972D0, -8.088376827873D-05, -1.9696D-23,  685, 'R', & !  214
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.7063410285D0, -8.088366436328D-05, -2.0759D-23,  686, 'R', & !  215
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4076871179D0, -8.087307904203D-05, -2.8034D-23,  408, 'R', & !  216
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3899119795D0, -8.086128136759D-05, -5.8539D-23,  595, 'R', & !  217
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6999177190D0, -8.086126234828D-05, -5.5336D-23,  594, 'R', & !  218
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5813964699D0, -8.086016163620D-05, -7.8566D-23,  578, 'P', & !  219
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3989572733D0, -8.084946467384D-05, -8.5841D-23,  181, 'P', & !  220
     &         27.4D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 221, 230 ) &
     &             /                 &
     & 5.4997033839D0, -8.083876771147D-05, -9.3116D-23,   83, 'R', & !  221
     &        139.7D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.3172641873D0, -8.082807074911D-05, -1.0039D-22,  219, 'R', & !  222
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1348249906D0, -8.081737378674D-05, -1.0767D-22,  593, 'R', & !  223
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0128026976D0, -8.075923517442D-05, -2.0759D-23,  690, 'R', & !  224
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3123081977D0, -8.075106232745D-05,  6.8813D-23,  592, 'R', & !  225
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4130543083D0, -8.074036536508D-05,  6.1538D-23,  218, 'R', & !  226
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2306151117D0, -8.072966840272D-05,  5.4262D-23,  105, 'R', & !  227
     &         -4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1120938626D0, -8.072856769064D-05,  3.1033D-23,  407, 'R', & !  228
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9296546660D0, -8.071787072828D-05,  2.3758D-23,  139, 'R', & !  229
     &         -7.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 6.0304007766D0, -8.070717376591D-05,  1.6482D-23,   70, 'R', & !  230
     &        -12.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 231, 240 ) &
     &             /                 &
     & 0.6286942204D0, -8.070607305384D-05, -6.7473D-24,  406, 'R', & !  231
     &          2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7294403309D0, -8.069537609147D-05, -1.4023D-23,  117, 'R', & !  232
     &         11.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.0394460704D0, -8.069535707216D-05, -1.0820D-23,  577, 'P', & !  233
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5470011343D0, -8.068467912911D-05, -2.1298D-23,   56, 'R', & !  234
     &         21.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 6.1401921810D0, -8.068466010979D-05, -1.8095D-23,  236, 'R', & !  235
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9577529844D0, -8.067396314743D-05, -2.5370D-23,  299, 'R', & !  236
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6567925387D0, -8.066216547298D-05, -5.5875D-23,  405, 'R', & !  237
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4565782036D0, -8.063967083618D-05, -9.3655D-23,  404, 'R', & !  238
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4516222141D0, -8.056266241452D-05,  7.5549D-23,  394, 'P', & !  239
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2691830175D0, -8.055196545216D-05,  6.8274D-23,  123, 'R', & !  240
     &         57.0D0,        -0.2D0,     -336.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 241, 250 ) &
     &             /                 &
     & 0.1976813410D0, -8.054663032943D-05, -1.3484D-23,  699, 'R', & !  241
     &         -0.6D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.3699291280D0, -8.054126848979D-05,  6.0999D-23,   34, 'R', & !  242
     &        281.9D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 3.1874899314D0, -8.053057152743D-05,  5.3724D-23,   16, 'R', & !  243
     &        441.1D0,        -1.6D0,    -1181.1D0,      0.0D0,     & !
     & 1.0050507348D0, -8.051987456506D-05,  4.6449D-23,  589, 'R', & !  244
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9872755963D0, -8.050807689062D-05,  1.5944D-23,  403, 'R', & !  245
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2972813358D0, -8.050805787130D-05,  1.9147D-23,  588, 'R', & !  246
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1787600868D0, -8.050695715923D-05, -4.0830D-24,  393, 'P', & !  247
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6863151507D0, -8.049627921618D-05, -1.4561D-23,  587, 'R', & !  248
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9963208902D0, -8.049626019686D-05, -1.1358D-23,  108, 'P', & !  249
     &        114.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.5038759540D0, -8.048558225381D-05, -2.1836D-23,  260, 'R', & !  250
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 251, 260 ) &
     &             /                 &
     & 6.0970670007D0, -8.048556323450D-05, -1.8633D-23,   50, 'R', & !  251
     &        585.7D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 3.9146278041D0, -8.047486627213D-05, -2.5909D-23,   82, 'R', & !  252
     &         26.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7321886075D0, -8.046416930977D-05, -3.3184D-23,  402, 'R', & !  253
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5410195663D0, -8.042985797921D-05, -9.8266D-23,  576, 'P', & !  254
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3445790863D0, -8.035396928894D-05,  9.0965D-23,  401, 'R', & !  255
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2260578372D0, -8.035286857686D-05,  6.7736D-23,  400, 'R', & !  256
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3414137484D0, -8.034825776189D-05,  5.3724D-23,  691, 'R', & !  257
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3268039478D0, -8.034217161450D-05,  6.0460D-23,  110, 'R', & !  258
     &         13.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.1443647512D0, -8.033147465213D-05,  5.3185D-23,   58, 'R', & !  259
     &         20.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4543704907D0, -8.033145563282D-05,  5.6388D-23,  399, 'R', & !  260
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 261, 270 ) &
     &             /                 &
     & 4.5551166013D0, -8.032075867045D-05,  4.9113D-23,  586, 'R', & !  261
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2541561556D0, -8.030896099601D-05,  1.8608D-23,  398, 'R', & !  262
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0717169590D0, -8.029826403365D-05,  1.1333D-23,  397, 'R', & !  263
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9531957099D0, -8.029716332157D-05, -1.1897D-23,  296, 'P', & !  264
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1724630695D0, -8.028756707128D-05,  4.0575D-24,  585, 'R', & !  265
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0539418205D0, -8.028646635921D-05, -1.9172D-23,  136, 'R', & !  266
     &         43.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.8715026239D0, -8.027576939684D-05, -2.6447D-23,  298, 'R', & !  267
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7848535483D0, -8.017736705045D-05,  1.2821D-22,  575, 'R', & !  268
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7761237037D0, -8.015375268226D-05,  7.0400D-23,  518, 'P', & !  269
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2836787675D0, -8.014307473921D-05,  5.9922D-23,  392, 'R', & !  270
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 271, 280 ) &
     &             /                 &
     & 2.5936845070D0, -8.014305571989D-05,  6.3125D-23,  196, 'P', & !  271
     &         23.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.1012395709D0, -8.013237777684D-05,  5.2646D-23,  201, 'R', & !  272
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4112453104D0, -8.013235875753D-05,  5.5849D-23,   89, 'R', & !  273
     &        119.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5119914210D0, -8.012166179516D-05,  4.8574D-23,  157, 'R', & !  274
     &          5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3295522244D0, -8.011096483280D-05,  4.1299D-23,  391, 'R', & !  275
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0108166402D0, -8.008736948391D-05, -1.9711D-23,  390, 'R', & !  276
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3208223797D0, -8.008735046460D-05, -1.6508D-23,  517, 'P', & !  277
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1383831831D0, -8.007665350223D-05, -2.3783D-23,  352, 'P', & !  278
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5505593268D0, -7.994395884460D-05,  6.2586D-23,  351, 'P', & !  279
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0581143907D0, -7.993328090155D-05,  5.2108D-23,  574, 'R', & !  280
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 281, 290 ) &
     &             /                 &
     & 0.3681201302D0, -7.993326188223D-05,  5.5311D-23,  200, 'R', & !  281
     &         13.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4688662407D0, -7.992256491987D-05,  4.8036D-23,  389, 'R', & !  282
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0086089273D0, -7.977915428055D-05,  1.3033D-22,  388, 'R', & !  283
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3249949499D0, -7.973416500694D-05,  5.4772D-23,  573, 'R', & !  284
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7357468000D0, -7.972344902526D-05,  5.0700D-23,  516, 'P', & !  285
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2062561482D0, -7.901738412326D-05, -5.1778D-23,  572, 'R', & !  286
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4345688017D0, -7.899597117921D-05, -6.3126D-23,  571, 'R', & !  287
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7509548243D0, -7.895098190560D-05, -1.3869D-22,  570, 'R', & !  288
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7459988348D0, -7.887397348394D-05,  3.0518D-23,  569, 'R', & !  289
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8467449454D0, -7.886327652158D-05,  2.3243D-23,  295, 'R', & !  290
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 291, 300 ) &
     &             /                 &
     & 2.4731367075D0, -7.881826822865D-05, -4.9114D-23,  515, 'P', & !  291
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2906975109D0, -7.880757126629D-05, -5.6389D-23,  258, 'R', & !  292
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3914436214D0, -7.879687430392D-05, -6.3665D-23,  149, 'R', & !  293
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8853128512D0, -7.868557357102D-05,  3.7255D-23,  514, 'P', & !  294
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7028736545D0, -7.867487660865D-05,  2.9980D-23,  175, 'R', & !  295
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8036197651D0, -7.866417964629D-05,  2.2704D-23,   85, 'R', & !  296
     &         -6.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6211805685D0, -7.865348268392D-05,  1.5429D-23,  568, 'R', & !  297
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9311863080D0, -7.865346366461D-05,  1.8632D-23,  387, 'R', & !  298
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4387413719D0, -7.864278572156D-05,  8.1540D-24,  386, 'R', & !  299
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0319324186D0, -7.864276670224D-05,  1.1357D-23,  235, 'R', & !  300
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 301, 310 ) &
     &             /                 &
     & 4.6124507239D0, -7.862986831572D-05, -4.2378D-23,  513, 'P', & !  301
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4300115272D0, -7.861917135336D-05, -4.9653D-23,  249, 'P', & !  302
     &         -8.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2475723306D0, -7.860847439099D-05, -5.6928D-23,   80, 'R', & !  303
     &        -29.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3483184412D0, -7.859777742863D-05, -6.4203D-23,   43, 'R', & !  304
     &        -49.7D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.9747102033D0, -7.855276913570D-05, -1.3656D-22,  350, 'P', & !  305
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1003292921D0, -7.849365461162D-05,  1.0280D-23,  692, 'R', & !  306
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6597484743D0, -7.847577973336D-05,  2.9441D-23,  567, 'R', & !  307
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7604945848D0, -7.846508277099D-05,  2.2166D-23,  385, 'R', & !  308
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0705003244D0, -7.846506375168D-05,  2.5369D-23,  384, 'R', & !  309
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8880611277D0, -7.845436678931D-05,  1.8093D-23,   86, 'R', & !  310
     &        -23.7D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 311, 320 ) &
     &             /                 &
     & 3.1922117441D0, -7.844367161093D-05,  1.0280D-23,  684, 'R', & !  311
     &          0.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.9888072383D0, -7.844366982695D-05,  1.0818D-23,   38, 'R', & !  312
     &        -58.3D0,         0.2D0,     -641.7D0,      0.0D0,     & !
     & 5.8702859893D0, -7.844256911487D-05, -1.2411D-23,  512, 'P', & !  313
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6878467926D0, -7.843187215251D-05, -1.9687D-23,  257, 'R', & !  314
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7917582411D0, -7.842688671720D-05,  1.0280D-23,  693, 'R', & !  315
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5054075960D0, -7.842117519014D-05, -2.6962D-23,  135, 'R', & !  316
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2044471504D0, -7.840937751570D-05, -5.7467D-23,  566, 'R', & !  317
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7976381971D0, -7.840935849639D-05, -5.4264D-23,  349, 'P', & !  318
     &         -5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3051932609D0, -7.839868055334D-05, -6.4742D-23,  256, 'R', & !  319
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6151990004D0, -7.839866153402D-05, -6.1539D-23,  162, 'R', & !  320
     &        -26.1D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 321, 330 ) &
     &             /                 &
     & 5.7159451110D0, -7.838796457166D-05, -6.8814D-23,  383, 'R', & !  321
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4149846653D0, -7.837616689722D-05, -9.9319D-23,  511, 'P', & !  322
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5230056751D0, -7.836911378164D-05,  1.0280D-23,  694, 'R', & !  323
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3002372714D0, -7.832167213168D-05,  1.0446D-22,  382, 'R', & !  324
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1177980748D0, -7.831097516931D-05,  9.7187D-23,  216, 'R', & !  325
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8537996061D0, -7.829455595234D-05,  1.0280D-23,  695, 'R', & !  326
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1090682302D0, -7.828736080112D-05,  3.9380D-23,  510, 'P', & !  327
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2098143407D0, -7.827666383875D-05,  3.2105D-23,   95, 'P', & !  328
     &        153.7D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.0273751441D0, -7.826596687639D-05,  2.4830D-23,   27, 'R', & !  329
     &       2362.8D0,        -9.0D0,        0.0D0,      0.0D0,     & !
     & 3.2351980409D0, -7.825599600576D-05,  8.4762D-23,  696, 'R', & !  330
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 331, 340 ) &
     &             /                 &
     & 0.8449359475D0, -7.825526991402D-05,  1.7555D-23,    8, 'R', & !  331
     &      11313.2D0,       -40.4D0,    -9831.0D0,     30.6D0,     & !
     & 3.9865286302D0, -7.825526218835D-05,  1.8618D-23,  698, 'R', & !  332
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 6.0566195782D0, -7.824993479129D-05, -6.4203D-23,  700, 'R', & !  333
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8294673441D0, -7.824468459277D-05,  1.0280D-23,  702, 'R', & !  334
     &         -0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.9456820581D0, -7.824457295166D-05,  1.0280D-23,    3, 'R', & !  335
     &      17684.6D0,       -63.5D0,   -44404.7D0,    137.9D0,     & !
     & 1.8040894336D0, -7.824456522598D-05,  1.1342D-23,  705, 'R', & !  336
     &          0.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.2556877976D0, -7.824455393234D-05,  1.3483D-23,  565, 'R', & !  337
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9329230023D0, -7.824446881367D-05,  4.1318D-23,  706, 'R', & !  338
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7787114648D0, -7.824446131054D-05,  1.0280D-23,  703, 'R', & !  339
     &          0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7632428614D0, -7.823387598929D-05,  3.0044D-24,  215, 'R', & !  340
     &         12.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 341, 350 ) &
     &             /                 &
     & 5.9048355441D0, -7.823386826362D-05,  4.0673D-24,  708, 'R', & !  341
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.2997244821D0, -7.823276576756D-05, -1.8624D-23,  564, 'R', & !  342
     &          0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.9547273519D0, -7.823275625790D-05, -1.7022D-23,  509, 'P', & !  343
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4622824158D0, -7.822207831485D-05, -2.7500D-23,  381, 'R', & !  344
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1172852855D0, -7.822206880519D-05, -2.5899D-23,  563, 'R', & !  345
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 5.0554734625D0, -7.822205929554D-05, -2.4297D-23,  294, 'R', & !  346
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9369522134D0, -7.822095858346D-05, -4.7527D-23,  248, 'P', & !  347
     &        -11.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8730342659D0, -7.821136233317D-05, -3.1573D-23,  562, 'R', & !  348
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1447751102D0, -7.821098771283D-05,  1.2405D-23,  709, 'R', & !  349
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7545130168D0, -7.821026162110D-05, -5.4802D-23,   61, 'P', & !  350
     &        528.1D0,        -1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 351, 360 ) &
     &             /                 &
     & 4.2620680807D0, -7.819958367805D-05, -6.5280D-23,  561, 'R', & !  351
     &          0.6D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.5720738202D0, -7.819956465873D-05, -6.2078D-23,   26, 'R', & !  352
     &       2672.1D0,       -10.3D0,        0.0D0,      0.0D0,     & !
     & 6.0375645101D0, -7.819458995097D-05,  1.0280D-23,  710, 'R', & !  353
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6728199308D0, -7.818886769636D-05, -6.9353D-23,   63, 'R', & !  354
     &        -63.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.4903807341D0, -7.817817073400D-05, -7.6628D-23,  214, 'R', & !  355
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2992116929D0, -7.814385940344D-05, -1.4171D-22,  508, 'P', & !  356
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0851731339D0, -7.812003212168D-05,  1.0280D-23,  711, 'R', & !  357
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4854247446D0, -7.810116231234D-05,  9.2576D-23,  560, 'R', & !  358
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5861708552D0, -7.809046534998D-05,  8.5301D-23,  293, 'R', & !  359
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1027712129D0, -7.806797071317D-05,  4.7521D-23,  213, 'R', & !  360
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 361, 370 ) &
     &             /                 &
     & 2.9842499638D0, -7.806687000110D-05,  2.4291D-23,  559, 'R', & !  361
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0996058751D0, -7.806225918612D-05,  1.0280D-23,  712, 'R', & !  362
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8018107672D0, -7.805617303873D-05,  1.7016D-23,   96, 'R', & !  363
     &         19.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3950018139D0, -7.805615401941D-05,  2.0219D-23,  247, 'P', & !  364
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9025568778D0, -7.804547607636D-05,  9.7410D-24,   40, 'R', & !  365
     &         55.6D0,        -0.2D0,      641.7D0,      0.0D0,     & !
     & 2.2125626173D0, -7.804545705705D-05,  1.2944D-23,  119, 'R', & !  366
     &        -61.5D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.0301234207D0, -7.803476009468D-05,  5.6687D-24,  153, 'R', & !  367
     &         -5.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9116021717D0, -7.803365938261D-05, -1.7561D-23,  282, 'P', & !  368
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1308695313D0, -7.802406313232D-05, -1.6065D-24,  380, 'R', & !  369
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0123482822D0, -7.802296242024D-05, -2.4836D-23,  156, 'R', & !  370
     &        -29.6D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 371, 380 ) &
     &             /                 &
     & 2.8299090856D0, -7.801226545788D-05, -3.2111D-23,  379, 'R', & !  371
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7113878366D0, -7.801116474580D-05, -5.5341D-23,  281, 'P', & !  372
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5289486399D0, -7.800046778344D-05, -6.2616D-23,  148, 'R', & !  373
     &         34.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.5078495169D0, -7.799549129169D-05,  1.0280D-23,  713, 'R', & !  374
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6296947505D0, -7.798977082107D-05, -6.9891D-23,  292, 'R', & !  375
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8071779576D0, -7.792345936178D-05,  1.0659D-22,  507, 'P', & !  376
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6247387610D0, -7.791276239941D-05,  9.9313D-23,  291, 'R', & !  377
     &         -5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4422995644D0, -7.790206543705D-05,  9.2038D-23,  146, 'R', & !  378
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5430456749D0, -7.789136847468D-05,  8.4762D-23,   75, 'R', & !  379
     &        -10.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0596460326D0, -7.786887383788D-05,  4.6982D-23,  558, 'R', & !  380
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 381, 390 ) &
     &             /                 &
     & 0.7146489024D0, -7.786886432822D-05,  4.8584D-23,  556, 'R', & !  381
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.6528370793D0, -7.786885481856D-05,  5.0185D-23,  557, 'R', & !  382
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2511305231D0, -7.786775410649D-05,  2.6956D-23,  187, 'P', & !  383
     &        -24.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7586855870D0, -7.785707616344D-05,  1.6478D-23,  555, 'R', & !  384
     &          0.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.3518766337D0, -7.785705714412D-05,  1.9681D-23,   47, 'P', & !  385
     &       1135.7D0,        -4.2D0,      336.1D0,      0.0D0,     & !
     & 3.2803749572D0, -7.785172202139D-05, -6.2078D-23,  729, 'P', & !  386
     &         -2.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 4.8594316975D0, -7.784637920107D-05,  9.2024D-24,  212, 'R', & !  387
     &          1.7D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 2.1694374371D0, -7.784636018176D-05,  1.2405D-23,   19, 'R', & !  388
     &       5815.5D0,       -21.5D0,      336.1D0,      0.0D0,     & !
     & 6.2701835476D0, -7.783566321939D-05,  5.1301D-24,   41, 'R', & !  389
     &        185.5D0,        -0.8D0,     -336.1D0,      0.0D0,     & !
     & 4.0877443510D0, -7.782496625703D-05, -2.1451D-24,  116, 'R', & !  390
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 391, 400 ) &
     &             /                 &
     & 4.9692231020D0, -7.782386554495D-05, -2.5375D-23,  553, 'R', & !  391
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4858234597D0, -7.780137090815D-05, -6.3155D-23,  552, 'R', & !  392
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0790145064D0, -7.780135188883D-05, -5.9952D-23,  348, 'P', & !  393
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8965753098D0, -7.779065492647D-05, -6.7227D-23,  208, 'P', & !  394
     &         17.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7141361131D0, -7.777995796410D-05, -7.4502D-23,  378, 'R', & !  395
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3991743841D0, -7.770296856176D-05,  9.1499D-23,  377, 'R', & !  396
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4999204947D0, -7.769227159939D-05,  8.4224D-23,  234, 'R', & !  397
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8099262342D0, -7.769225258008D-05,  8.7427D-23,  376, 'R', & !  398
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5089657885D0, -7.768045490564D-05,  5.6922D-23,  347, 'P', & !  399
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6097118991D0, -7.766975794327D-05,  4.9647D-23,  233, 'R', & !  400
     &         -9.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 401, 410 ) &
     &             /                 &
     & 0.2080053429D0, -7.766865723120D-05,  2.6417D-23,  505, 'P', & !  401
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3233612541D0, -7.766404641622D-05,  1.2405D-23,  714, 'P', & !  402
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4272727025D0, -7.765906098091D-05,  4.2372D-23,  551, 'R', & !  403
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3087514534D0, -7.765796026883D-05,  1.9142D-23,  131, 'P', & !  404
     &         76.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1263122568D0, -7.764726330647D-05,  1.1867D-23,   55, 'R', & !  405
     &        399.6D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 6.2270583674D0, -7.763656634410D-05,  4.5915D-24,  167, 'R', & !  406
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5370641069D0, -7.763654732478D-05,  7.7944D-24,  504, 'P', & !  407
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0446191707D0, -7.762586938173D-05, -2.6837D-24,  375, 'R', & !  408
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0147902031D0, -7.759727852179D-05,  1.2405D-23,  715, 'P', & !  409
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8534501295D0, -7.759155805117D-05, -6.7766D-23,  503, 'P', & !  410
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 411, 420 ) &
     &             /                 &
     & 0.8484941400D0, -7.751454962952D-05,  1.0144D-22,  502, 'P', & !  411
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9492402505D0, -7.750385266715D-05,  9.4163D-23,  186, 'P', & !  412
     &         23.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7668010539D0, -7.749315570478D-05,  8.6888D-23,   91, 'R', & !  413
     &        118.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.5843618573D0, -7.748245874242D-05,  7.9613D-23,  180, 'R', & !  414
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6851079679D0, -7.747176178005D-05,  7.2338D-23,  550, 'R', & !  415
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5665867188D0, -7.747066106798D-05,  4.9108D-23,  549, 'R', & !  416
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2656262732D0, -7.745886339354D-05,  1.8603D-23,  346, 'P', & !  417
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0831870765D0, -7.744816643117D-05,  1.1328D-23,  179, 'R', & !  418
     &         19.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6763781232D0, -7.744814741186D-05,  1.4531D-23,  280, 'P', & !  419
     &         -6.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4939389266D0, -7.743745044949D-05,  7.2557D-24,  166, 'P', & !  420
     &         35.1D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 421, 430 ) &
     &             /                 &
     & 1.3114997300D0, -7.742675348713D-05, -1.9473D-26,  548, 'R', & !  421
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9061150703D0, -7.730475579186D-05,  9.3625D-23,  345, 'P', & !  422
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7236758737D0, -7.729405882949D-05,  8.6350D-23,  232, 'R', & !  423
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5412366771D0, -7.728336186713D-05,  7.9074D-23,  374, 'R', & !  424
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0400618963D0, -7.724906955588D-05,  1.0789D-23,  547, 'R', & !  425
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6332529430D0, -7.724905053657D-05,  1.3992D-23,  501, 'P', & !  426
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4508137464D0, -7.723835357420D-05,  6.7171D-24,  344, 'P', & !  427
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6805506934D0, -7.709496195420D-05,  8.5811D-23,  546, 'R', & !  428
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0913025435D0, -7.708424597252D-05,  8.1739D-23,  500, 'P', & !  429
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2786265845D0, -7.637818107052D-05, -2.0740D-23,  373, 'R', & !  430
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 431, 440 ) &
     &             /                 &
     & 2.6893784346D0, -7.636746508884D-05, -2.4812D-23,  372, 'R', & !  431
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5069392380D0, -7.635676812647D-05, -3.2087D-23,  255, 'R', & !  432
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1065105678D0, -7.631177885286D-05, -1.0765D-22,  371, 'R', & !  433
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8286924510D0, -7.617906517591D-05, -1.8075D-23,  343, 'P', & !  434
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6462532544D0, -7.616836821355D-05, -2.5351D-23,  143, 'R', & !  435
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4638140578D0, -7.615767125118D-05, -3.2626D-23,   77, 'R', & !  436
     &        -10.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2635997227D0, -7.613517661437D-05, -7.0406D-23,  544, 'R', & !  437
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3733911271D0, -7.611266295825D-05, -1.0498D-22,  499, 'P', & !  438
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0584293980D0, -7.603567355591D-05,  6.1018D-23,  370, 'R', & !  439
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8759902014D0, -7.602497659355D-05,  5.3743D-23,  211, 'R', & !  440
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 441, 450 ) &
     &             /                 &
     & 1.1043028549D0, -7.600356364950D-05,  4.2396D-23,  369, 'R', & !  441
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6848211602D0, -7.599066526298D-05, -1.1339D-23,  279, 'P', & !  442
     &         -8.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7855672707D0, -7.597996830062D-05, -1.8614D-23,  113, 'P', & !  443
     &        -71.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.6031280741D0, -7.596927133825D-05, -2.5889D-23,   42, 'R', & !  444
     &       -178.9D0,         0.4D0,      305.5D0,      0.0D0,     & !
     & 0.4206888775D0, -7.595857437589D-05, -3.3164D-23,   24, 'R', & !  445
     &       -233.8D0,         0.6D0,      768.1D0,      0.0D0,     & !
     & 4.0138799242D0, -7.595855535657D-05, -2.9962D-23,  368, 'R', & !  446
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5214349881D0, -7.594787741352D-05, -4.0440D-23,  542, 'R', & !  447
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8314407276D0, -7.594785839421D-05, -3.7237D-23,  543, 'R', & !  448
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5127051434D0, -7.592426304533D-05, -9.8246D-23,  342, 'P', & !  449
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3302659468D0, -7.591356608296D-05, -1.0552D-22,  498, 'P', & !  450
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 451, 460 ) &
     &             /                 &
     & 1.1478267502D0, -7.590286912060D-05, -1.1280D-22,  541, 'R', & !  451
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4260560679D0, -7.582586069894D-05,  5.6407D-23,  367, 'R', & !  452
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4470213770D0, -7.581516552056D-05,  4.8594D-23,  697, 'R', & !  453
     &          0.6D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.2436168712D0, -7.581516373657D-05,  4.9132D-23,  199, 'R', & !  454
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0611776746D0, -7.580446677421D-05,  4.1857D-23,  118, 'R', & !  455
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9426564256D0, -7.580336606213D-05,  1.8627D-23,  341, 'P', & !  456
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0434025361D0, -7.579266909977D-05,  1.1352D-23,  190, 'R', & !  457
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8609633395D0, -7.578197213740D-05,  4.0770D-24,   97, 'R', & !  458
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7424420905D0, -7.578087142533D-05, -1.9153D-23,  496, 'P', & !  459
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0524478300D0, -7.578085240601D-05, -1.5950D-23,  497, 'P', & !  460
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 461, 470 ) &
     &             /                 &
     & 2.5600028939D0, -7.577017446296D-05, -2.6428D-23,  254, 'R', & !  461
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1531939406D0, -7.577015544365D-05, -2.3225D-23,  152, 'P', & !  462
     &        -47.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.3775636972D0, -7.575947750060D-05, -3.3703D-23,  231, 'R', & !  463
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9707547439D0, -7.575945848128D-05, -3.0500D-23,   65, 'R', & !  464
     &       -318.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.7883155473D0, -7.574876151892D-05, -3.7775D-23,  125, 'R', & !  465
     &         11.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7737057467D0, -7.574267537153D-05, -3.1039D-23,  716, 'R', & !  466
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8890616579D0, -7.573806455655D-05, -4.5051D-23,  366, 'R', & !  467
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4873551017D0, -7.573696384447D-05, -6.8280D-23,  340, 'P', & !  468
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2871407666D0, -7.571446920767D-05, -1.0606D-22,  495, 'P', & !  469
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5049531807D0, -7.568490243597D-05, -3.1039D-23,  717, 'R', & !  470
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 471, 480 ) &
     &             /                 &
     & 3.4646239737D0, -7.564815774838D-05,  7.0419D-23,  494, 'P', & !  471
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2821847770D0, -7.563746078601D-05,  6.3144D-23,  142, 'P', & !  472
     &        -57.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.3829308876D0, -7.562676382365D-05,  5.5869D-23,   59, 'R', & !  473
     &       -381.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.2004916910D0, -7.561606686128D-05,  4.8594D-23,   25, 'R', & !  474
     &       -636.8D0,         1.7D0,      641.7D0,      0.0D0,     & !
     & 0.5104974305D0, -7.561604784197D-05,  5.1796D-23,  493, 'P', & !  475
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1850230876D0, -7.560548154003D-05,  4.1318D-23,  701, 'R', & !  476
     &          1.2D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.0180524944D0, -7.560536989892D-05,  4.1318D-23,   12, 'R', & !  477
     &      -1018.7D0,         2.8D0,     2794.2D0,      0.0D0,     & !
     & 4.6112435411D0, -7.560535087960D-05,  4.4521D-23,  253, 'R', & !  478
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1187986049D0, -7.559467293655D-05,  3.4043D-23,  365, 'R', & !  479
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4288043444D0, -7.559465391723D-05,  3.7246D-23,  537, 'R', & !  480
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 481, 490 ) &
     &             /                 &
     & 2.7285365115D0, -7.559394684481D-05, -3.3164D-23,  718, 'R', & !  481
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0002773559D0, -7.559357222447D-05,  1.0814D-23,  364, 'R', & !  482
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6552802256D0, -7.559356271482D-05,  1.2415D-23,  536, 'R', & !  483
     &          0.0D0,         7.2D0,        0.0D0,      0.0D0,     & !
     & 3.3102830954D0, -7.559355320516D-05,  1.4016D-23,  246, 'P', & !  484
     &         10.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6887180265D0, -7.558495188594D-05, -3.3164D-23,  719, 'R', & !  485
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8178381593D0, -7.558287526211D-05,  3.5384D-24,  210, 'R', & !  486
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4728410290D0, -7.558286575245D-05,  5.1398D-24,  535, 'R', & !  487
     &          0.0D0,        17.8D0,        0.0D0,      0.0D0,     & !
     & 1.1278438988D0, -7.558285624279D-05,  6.7413D-24,  130, 'R', & !  488
     &         53.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3995847432D0, -7.558248162246D-05,  5.0719D-23,  720, 'P', & !  489
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0093226497D0, -7.558175553072D-05, -1.6488D-23,   76, 'P', & !  490
     &       -283.3D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 491, 500 ) &
     &             /                 &
     & 0.2569640316D0, -7.558077961896D-05,  4.3444D-23,  721, 'R', & !  491
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2904018324D0, -7.557216879009D-05, -2.1354D-24,  534, 'R', & !  492
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.2285900093D0, -7.557215928043D-05, -5.3394D-25,  252, 'R', & !  493
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2171455466D0, -7.557178466009D-05,  4.3444D-23,  722, 'R', & !  494
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5168777136D0, -7.557107758767D-05, -2.6966D-23,  533, 'R', & !  495
     &          2.4D0,         2.5D0,        0.0D0,      0.0D0,     & !
     & 6.1100687603D0, -7.557105856835D-05, -2.3764D-23,   15, 'P', & !  496
     &      13208.9D0,       -36.4D0,     1925.0D0,      0.0D0,     & !
     & 0.0347063499D0, -7.556108769773D-05,  3.6169D-23,  724, 'R', & !  497
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8114148498D0, -7.556047324711D-05, -3.1039D-23,  725, 'P', & !  498
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3344385170D0, -7.556038062530D-05, -3.4242D-23,  363, 'R', & !  499
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7860368810D0, -7.556036933166D-05, -3.2102D-23,  726, 'R', & !  500
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 501, 510 ) &
     &             /                 &
     & 3.9276295637D0, -7.556036160599D-05, -3.1039D-23,    7, 'R', & !  501
     &      66936.5D0,      -170.9D0,     2230.5D0,      0.0D0,     & !
     & 0.7860369392D0, -7.556035388032D-05, -2.9976D-23,  727, 'P', & !  502
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.7606589704D0, -7.556024996487D-05, -3.1039D-23,  728, 'R', & !  503
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.8166920436D0, -7.555499976635D-05,  4.3444D-23,  730, 'R', & !  504
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7451903671D0, -7.554966464362D-05, -3.8314D-23,   14, 'R', & !  505
     &      -1969.4D0,         4.8D0,     1925.0D0,      0.0D0,     & !
     & 4.8867830498D0, -7.554965691795D-05, -3.7251D-23,  731, 'R', & !  506
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.8459364776D0, -7.553896768126D-05, -4.5589D-23,   68, 'R', & !  507
     &         16.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4442299214D0, -7.553786696918D-05, -6.8819D-23,  492, 'P', & !  508
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5540213258D0, -7.551535331306D-05, -1.0340D-22,  339, 'P', & !  509
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6547674364D0, -7.550465635070D-05, -1.1067D-22,  207, 'P', & !  510
     &         17.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 511, 520 ) &
     &             /                 &
     & 2.4723282398D0, -7.549395938833D-05, -1.1795D-22,  338, 'P', & !  511
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6796404146D0, -7.545623878898D-05,  4.3444D-23,  732, 'R', & !  512
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3503059467D0, -7.543582077601D-05, -3.1039D-23,  733, 'P', & !  513
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3398057073D0, -7.542766694835D-05,  5.5330D-23,  362, 'R', & !  514
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1573665107D0, -7.541696998599D-05,  4.8055D-23,  230, 'R', & !  515
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4673722502D0, -7.541695096667D-05,  5.1258D-23,  229, 'P', & !  516
     &        -14.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4693271908D0, -7.541203550107D-05,  4.9656D-23, 1280, 'P', & !  517
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9749273141D0, -7.540627302362D-05,  4.0780D-23,  174, 'R', & !  518
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5681183608D0, -7.540625400431D-05,  4.3983D-23,  101, 'R', & !  519
     &        -89.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.4495971118D0, -7.540515329223D-05,  2.0753D-23,  491, 'P', & !  520
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 521, 530 ) &
     &             /                 &
     & 2.3856791642D0, -7.539555704194D-05,  3.6707D-23,  189, 'R', & !  521
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2671579151D0, -7.539445632987D-05,  1.3478D-23,  133, 'P', & !  522
     &        -73.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.2032399676D0, -7.538486007958D-05,  2.9432D-23,  209, 'R', & !  523
     &         13.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0847187185D0, -7.538375936750D-05,  6.2026D-24,   57, 'R', & !  524
     &       -412.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.9661974695D0, -7.538265865543D-05, -1.7027D-23,  490, 'P', & !  525
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0815533807D0, -7.537804784045D-05, -3.1039D-23,  734, 'P', & !  526
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1854648291D0, -7.537306240514D-05, -1.0726D-24,  122, 'R', & !  527
     &         12.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0669435800D0, -7.537196169306D-05, -2.4302D-23,  134, 'P', & !  528
     &         68.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.0030256325D0, -7.536236544277D-05, -8.3478D-24,  361, 'R', & !  529
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8845043834D0, -7.536126473070D-05, -3.1577D-23,   52, 'R', & !  530
     &        445.7D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 531, 540 ) &
     &             /                 &
     & 1.1945101229D0, -7.536124571138D-05, -2.8374D-23,  489, 'P', & !  531
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7020651868D0, -7.535056776833D-05, -3.8853D-23,  103, 'R', & !  532
     &        -16.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2952562335D0, -7.535054874902D-05, -3.5650D-23,  245, 'P', & !  533
     &        -10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8028112974D0, -7.533987080597D-05, -4.6128D-23,  360, 'R', & !  534
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1128170369D0, -7.533985178665D-05, -4.2925D-23,  531, 'R', & !  535
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9802945045D0, -7.527355934667D-05,  1.3035D-22,  530, 'R', & !  536
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7978553078D0, -7.526286238431D-05,  1.2308D-22,  290, 'R', & !  537
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6154161112D0, -7.525216542194D-05,  1.1580D-22,  289, 'R', & !  538
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6066862666D0, -7.522855105375D-05,  5.7994D-23,  140, 'P', & !  539
     &        -62.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4242470700D0, -7.521785409138D-05,  5.0719D-23,   32, 'P', & !  540
     &       2926.7D0,        -7.0D0,      305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 541, 550 ) &
     &             /                 &
     & 5.6359307007D0, -7.521251896865D-05, -3.1039D-23,  735, 'P', & !  541
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4087784666D0, -7.520726877013D-05,  4.3444D-23,  737, 'P', & !  542
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 4.5249931806D0, -7.520715712902D-05,  4.3444D-23,   13, 'R', & !  543
     &      14839.0D0,       -36.1D0,      305.5D0,      0.0D0,     & !
     & 1.3580225873D0, -7.520704548790D-05,  4.3444D-23,  738, 'R', & !  544
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 2.3425539839D0, -7.519646016665D-05,  3.6169D-23,   29, 'R', & !  545
     &       -477.3D0,         1.3D0,      305.5D0,      0.0D0,     & !
     & 6.2354771977D0, -7.519573407491D-05, -3.1039D-23,  739, 'P', & !  546
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9124734055D0, -7.518673911604D-05, -3.1039D-23,  740, 'P', & !  547
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1601147873D0, -7.518576320429D-05,  2.8894D-23,  129, 'R', & !  548
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0415935383D0, -7.518466249221D-05,  5.6640D-24,  529, 'R', & !  549
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0238183998D0, -7.517286481777D-05, -2.4841D-23,  487, 'P', & !  550
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 551, 560 ) &
     &             /                 &
     & 3.8413792032D0, -7.516216785540D-05, -3.2116D-23,  251, 'R', & !  551
     &          8.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1513849427D0, -7.516214883609D-05, -2.8913D-23,  132, 'P', & !  552
     &        -71.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.6589400066D0, -7.515147089304D-05, -3.9391D-23,  359, 'R', & !  553
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2521310533D0, -7.515145187372D-05, -3.6188D-23,   67, 'P', & !  554
     &        451.7D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 3.0696918566D0, -7.514075491136D-05, -4.3464D-23,  128, 'R', & !  555
     &        -54.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.8872526600D0, -7.513005794899D-05, -5.0739D-23,  288, 'R', & !  556
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8445677747D0, -7.511125925651D-05,  0.0000D+00,  876, 'R', & !  557
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9476695636D0, -7.508261629903D-05,  4.3444D-23,  741, 'P', & !  558
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8645215320D0, -7.504125185289D-05,  8.7961D-23,  486, 'P', & !  559
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6820823354D0, -7.503055489053D-05,  8.0685D-23,  287, 'R', & !  560
     &         -4.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 561, 570 ) &
     &             /                 &
     & 2.5635610863D0, -7.502945417845D-05,  5.7456D-23,  337, 'P', & !  561
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6789169976D0, -7.502484336348D-05,  4.3444D-23,  742, 'P', & !  562
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7828284460D0, -7.501985792816D-05,  7.3410D-23,  528, 'R', & !  563
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3811218897D0, -7.501875721609D-05,  5.0181D-23,  100, 'P', & !  564
     &        133.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 4.4818680003D0, -7.500806025372D-05,  4.2905D-23,   48, 'R', & !  565
     &        696.4D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 2.2994288037D0, -7.499736329136D-05,  3.5630D-23,   92, 'R', & !  566
     &        -23.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.8926198504D0, -7.499734427204D-05,  3.8833D-23,  336, 'P', & !  567
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1169896071D0, -7.498666632899D-05,  2.8355D-23,  358, 'R', & !  568
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5916594047D0, -7.498554659760D-05,  8.3283D-24,  160, 'P', & !  569
     &         38.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4092202081D0, -7.497484963524D-05,  1.0531D-24,  278, 'P', & !  570
     &         -6.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 571, 580 ) &
     &             /                 &
     & 0.2267810115D0, -7.496415267287D-05, -6.2221D-24,  527, 'R', & !  571
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1082597624D0, -7.496305196080D-05, -2.9452D-23,  335, 'P', & !  572
     &         -5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0871606394D0, -7.495807546905D-05,  4.3444D-23,  743, 'P', & !  573
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2090058730D0, -7.495235499843D-05, -3.6727D-23,  185, 'P', & !  574
     &         23.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0265666764D0, -7.494165803607D-05, -4.4002D-23,  357, 'R', & !  575
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0216106869D0, -7.486464961441D-05,  1.2520D-22,  334, 'P', & !  576
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1223567974D0, -7.485395265204D-05,  1.1793D-22,  198, 'R', & !  577
     &         15.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9399176008D0, -7.484325568968D-05,  1.1065D-22,  356, 'R', & !  578
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5496555074D0, -7.484252959794D-05,  4.3444D-23,  744, 'P', & !  579
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6389571551D0, -7.483145801524D-05,  8.0147D-23,  526, 'R', & !  580
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 581, 590 ) &
     &             /                 &
     & 0.3379967095D0, -7.481966034080D-05,  4.9642D-23,  333, 'P', & !  581
     &          5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4387428200D0, -7.480896337843D-05,  4.2367D-23,  161, 'R', & !  582
     &         26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7487485596D0, -7.480894435912D-05,  4.5570D-23,  228, 'P', & !  583
     &        -14.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2563036234D0, -7.479826641607D-05,  3.5092D-23,  286, 'R', & !  584
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8494946701D0, -7.479824739675D-05,  3.8294D-23,  112, 'P', & !  585
     &        102.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.6670554735D0, -7.478755043439D-05,  3.1019D-23,  250, 'R', & !  586
     &         -7.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4846162769D0, -7.477685347202D-05,  2.3744D-23,  525, 'R', & !  587
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1658806927D0, -7.475325812314D-05, -3.7266D-23,  485, 'P', & !  588
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0792316172D0, -7.465485577675D-05,  1.1739D-22,  355, 'R', & !  589
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3956176398D0, -7.460986650314D-05,  4.1828D-23,  524, 'R', & !  590
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 591, 600 ) &
     &             /                 &
     & 1.7056233793D0, -7.460984748382D-05,  4.5031D-23,  484, 'P', & !  591
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8063694899D0, -7.459915052146D-05,  3.7756D-23,  244, 'P', & !  592
     &          9.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6239302932D0, -7.458845355909D-05,  3.0481D-23,  523, 'R', & !  593
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7632443096D0, -7.440005364617D-05,  3.7217D-23,  483, 'P', & !  594
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0455487304D0, -7.411576596012D-05,  0.0000D+00,  753, 'R', & !  595
     &          0.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.0455487304D0, -7.411575823452D-05,  0.0000D+00,  750, 'R', & !  596
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.0455487304D0, -7.411575050891D-05,  0.0000D+00,  751, 'R', & !  597
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5233716884D0, -7.406660857730D-05,  0.0000D+00,  754, 'R', & !  598
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 6.0454684745D0, -7.404202602308D-05,  0.0000D+00,  755, 'R', & !  599
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0454684745D0, -7.404201829747D-05,  0.0000D+00,  757, 'P', & !  600
     &         -1.2D0,         1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 601, 610 ) &
     &             /                 &
     & 1.9460480714D0, -7.394207547292D-05,  0.0000D+00,  759, 'R', & !  601
     &          1.1D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.9460480714D0, -7.394206774732D-05,  0.0000D+00,  760, 'R', & !  602
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 3.6773075083D0, -7.393807489307D-05,  1.0838D-23,  522, 'R', & !  603
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1849595504D0, -7.391748519310D-05,  0.0000D+00,  761, 'R', & !  604
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1849595504D0, -7.391747746749D-05,  0.0000D+00,  762, 'P', & !  605
     &          0.0D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 5.5956144222D0, -7.391668096834D-05, -3.7127D-24,  521, 'R', & !  606
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9056201618D0, -7.391666194902D-05, -5.0980D-25,  121, 'R', & !  607
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0379305234D0, -7.389209247224D-05,  0.0000D+00,  763, 'R', & !  608
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9981120384D0, -7.388309751337D-05,  0.0000D+00,  764, 'R', & !  609
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4044453810D0, -7.388236963778D-05, -6.8795D-23,  520, 'R', & !  610
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 611, 620 ) &
     &             /                 &
     & 2.2220061844D0, -7.387167267541D-05, -7.6070D-23,  519, 'R', & !  611
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5976585354D0, -7.386631261963D-05,  0.0000D+00,  765, 'R', & !  612
     &          0.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 6.1972050324D0, -7.384952772589D-05,  0.0000D+00,  766, 'R', & !  613
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3687244544D0, -7.381753464294D-05,  0.0000D+00,  769, 'R', & !  614
     &         -0.2D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3687244544D0, -7.381752691733D-05,  0.0000D+00,  770, 'R', & !  615
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.3687244544D0, -7.381751919173D-05,  0.0000D+00,  768, 'R', & !  616
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 2.6076359334D0, -7.379294436312D-05,  0.0000D+00,  771, 'R', & !  617
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6076359334D0, -7.379293663751D-05,  0.0000D+00,  772, 'P', & !  618
     &         -0.2D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 4.4606069064D0, -7.376755164226D-05,  0.0000D+00,  775, 'R', & !  619
     &          2.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.4606069064D0, -7.376754391665D-05,  0.0000D+00,  774, 'R', & !  620
     &         -2.4D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 621, 630 ) &
     &             /                 &
     & 5.8166215247D0, -7.374967498014D-05,  1.7574D-23,  353, 'R', & !  621
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6995183854D0, -7.374297681365D-05,  0.0000D+00,  776, 'R', & !  622
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6341823280D0, -7.373897801778D-05,  1.0299D-23,  285, 'R', & !  623
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9441880676D0, -7.373895899846D-05,  1.3502D-23,  332, 'P', & !  624
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0449341781D0, -7.372826203610D-05,  6.2268D-24,  197, 'R', & !  625
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9384298644D0, -7.371838653382D-05,  0.0000D+00,  777, 'R', & !  626
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.5524892420D0, -7.371758409305D-05, -4.2513D-24,  284, 'R', & !  627
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8624949815D0, -7.371756507373D-05, -1.0484D-24,   30, 'R', & !  628
     &        137.6D0,        -0.3D0,    -1026.2D0,      0.0D0,     & !
     & 5.5524893584D0, -7.371755319035D-05,  0.0000D+00,  778, 'R', & !  629
     &          0.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.6396102560D0, -7.370495206099D-05,  0.0000D+00,  779, 'R', & !  630
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 631, 640 ) &
     &             /                 &
     & 1.0173375652D0, -7.370405056003D-05,  0.0000D+00,  780, 'R', & !  631
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1520358554D0, -7.370078374783D-05,  0.0000D+00,  781, 'R', & !  632
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.2605740902D0, -7.369396972485D-05, -6.2058D-23,  331, 'P', & !  633
     &         -2.7D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7914008374D0, -7.369299381296D-05,  0.0000D+00,  782, 'R', & !  634
     &         -0.2D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 4.7914008374D0, -7.369298608735D-05,  0.0000D+00,  783, 'R', & !  635
     &         -0.2D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7914008374D0, -7.369297836174D-05,  0.0000D+00,  784, 'R', & !  636
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7267311536D0, -7.369233548040D-05,  0.0000D+00,  785, 'R', & !  637
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4683970452D0, -7.368399885409D-05,  0.0000D+00,  786, 'R', & !  638
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3613202007D0, -7.368327276248D-05, -6.9333D-23,  188, 'R', & !  639
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6713259403D0, -7.368325374317D-05, -6.6130D-23,  481, 'P', & !  640
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 641, 650 ) &
     &             /                 &
     & 2.1788810041D0, -7.367257580012D-05, -7.6608D-23,  283, 'R', & !  641
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7720720508D0, -7.367255678080D-05, -7.3406D-23,  330, 'P', & !  642
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0303123164D0, -7.366841125874D-05,  0.0000D+00,  787, 'R', & !  643
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.0303123164D0, -7.366840353314D-05,  0.0000D+00,  788, 'R', & !  644
     &          3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0303123164D0, -7.366839580753D-05,  0.0000D+00,  789, 'P', & !  645
     &         -0.8D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 1.0679435422D0, -7.366721396035D-05,  0.0000D+00,  790, 'R', & !  646
     &          0.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.2692237954D0, -7.364382097892D-05,  0.0000D+00,  792, 'P', & !  647
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 3.2692237954D0, -7.364381325331D-05,  0.0000D+00,  793, 'P', & !  648
     &         -6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8832832894D0, -7.364301081227D-05,  0.0000D+00,  794, 'R', & !  649
     &         -0.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0884580734D0, -7.362756750719D-05, -1.4897D-22,  468, 'P', & !  650
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 651, 660 ) &
     &             /                 &
     & 5.1221947684D0, -7.361843598367D-05,  0.0000D+00,  795, 'R', & !  651
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5599058618D0, -7.359909444106D-05,  0.0000D+00,  796, 'R', & !  652
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3611062474D0, -7.359384570384D-05,  0.0000D+00,  797, 'R', & !  653
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.6470267595D0, -7.358647786047D-05,  0.0000D+00,  798, 'R', & !  654
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0173329643D0, -7.357386127989D-05,  0.0000D+00,  800, 'R', & !  655
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356845298298D-05,  0.0000D+00,  801, 'R', & !  656
     &         -3.1D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356844525737D-05,  0.0000D+00,  802, 'R', & !  657
     &         -0.1D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356843753176D-05,  0.0000D+00,  803, 'R', & !  658
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0835020839D0, -7.355055908553D-05,  2.0239D-23,  273, 'P', & !  659
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354387815437D-05,  0.0000D+00,  804, 'R', & !  660
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 661, 670 ) &
     &             /                 &
     & 5.4529886994D0, -7.354387042876D-05,  0.0000D+00,  805, 'R', & !  661
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354386270315D-05,  0.0000D+00,  806, 'R', & !  662
     &          5.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354385497755D-05,  0.0000D+00,  807, 'P', & !  663
     &         -0.9D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 1.7838628862D0, -7.354304481090D-05,  0.0000D+00,  808, 'R', & !  664
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.9010628873D0, -7.353986212317D-05,  1.2963D-23,  120, 'P', & !  665
     &        -63.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4232278682D0, -7.353525487603D-05,  0.0000D+00,  809, 'R', & !  666
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.9356534675D0, -7.353108656288D-05,  0.0000D+00,  810, 'R', & !  667
     &          0.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0018089979D0, -7.352916516080D-05,  5.6882D-24,   51, 'R', & !  668
     &       -115.5D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351928014894D-05,  0.0000D+00,  812, 'P', & !  669
     &          0.0D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351927242333D-05,  0.0000D+00,  813, 'P', & !  670
     &        -10.2D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 671, 680 ) &
     &             /                 &
     & 4.1897449584D0, -7.351858162341D-05,  0.0000D+00,  814, 'R', & !  671
     &          0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.0227743652D0, -7.351846998229D-05,  0.0000D+00,  815, 'R', & !  672
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8193698013D0, -7.351846819844D-05, -1.5870D-24,    6, 'R', & !  673
     &       4558.8D0,        -8.3D0,   -14542.8D0,     61.1D0,     & !
     & 4.2445210355D0, -7.351846784816D-05,  0.0000D+00,  816, 'R', & !  674
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1293755408D0, -7.351844917912D-05,  1.6158D-24,  165, 'R', & !  675
     &         27.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1389890791D0, -7.351835834118D-05,  0.0000D+00,  817, 'R', & !  676
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1937651562D0, -7.351824456593D-05,  0.0000D+00,  818, 'R', & !  677
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6368338592D0, -7.351763663883D-05,  0.0000D+00,  819, 'R', & !  678
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7008485522D0, -7.351736748636D-05, -2.4817D-23,  467, 'P', & !  679
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8047600006D0, -7.351238205105D-05,  5.1496D-24,  820, 'R', & !  680
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 681, 690 ) &
     &             /                 &
     & 1.8967911222D0, -7.351171094152D-05,  0.0000D+00,  821, 'R', & !  681
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6369306046D0, -7.350777123607D-05, -8.8622D-24,  277, 'R', & !  682
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5184093556D0, -7.350667052400D-05, -3.2092D-23,  243, 'R', & !  683
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3930805700D0, -7.350585340171D-05,  0.0000D+00,  822, 'R', & !  684
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7708078792D0, -7.350495190076D-05,  0.0000D+00,  823, 'R', & !  685
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.6223208622D0, -7.350168508855D-05,  0.0000D+00,  825, 'R', & !  686
     &          1.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.6191554662D0, -7.349597356163D-05, -3.9367D-23,  276, 'R', & !  687
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8106399566D0, -7.349485383024D-05, -5.9394D-23,  466, 'P', & !  688
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2616858442D0, -7.349389515368D-05,  0.0000D+00,  826, 'R', & !  689
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 3.4802014676D0, -7.349323682113D-05,  0.0000D+00,  828, 'R', & !  690
     &         -0.3D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 691, 700 ) &
     &             /                 &
     & 2.2218673592D0, -7.348490019482D-05,  0.0000D+00,  829, 'R', & !  691
     &         -0.6D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 2.2218673592D0, -7.348488474360D-05,  0.0000D+00,  830, 'R', & !  692
     &         -0.4D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.6282007600D0, -7.348415686788D-05, -6.6669D-23,  177, 'P', & !  693
     &         29.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5673223653D0, -7.348062024054D-05,  0.0000D+00,  831, 'R', & !  694
     &          0.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.7289468706D0, -7.347345990551D-05, -7.3944D-23,   99, 'P', & !  695
     &         98.7D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.7837826304D0, -7.346930487386D-05,  0.0000D+00,  832, 'R', & !  696
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.7837826304D0, -7.346929714825D-05,  0.0000D+00,  833, 'P', & !  697
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1146568172D0, -7.346848698161D-05,  0.0000D+00,  834, 'R', & !  698
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8214138562D0, -7.346811530108D-05,  0.0000D+00,  835, 'R', & !  699
     &         -0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.8214138562D0, -7.346809984986D-05,  0.0000D+00,  836, 'R', & !  700
     &          1.7D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 701, 710 ) &
     &             /                 &
     & 5.9376285701D0, -7.346800365996D-05,  0.0000D+00,  837, 'R', & !  701
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5465076740D0, -7.346276294315D-05, -8.1219D-23,  206, 'R', & !  702
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5360074346D0, -7.345460911549D-05,  5.1496D-24,  838, 'R', & !  703
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4209603532D0, -7.345131495612D-05,  0.0000D+00,  839, 'R', & !  704
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2455472283D0, -7.345096526871D-05, -1.1172D-22,  465, 'P', & !  705
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0226941094D0, -7.344471459403D-05,  0.0000D+00,  840, 'P', & !  706
     &          0.0D0,        -2.2D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344391215300D-05,  0.0000D+00,  841, 'R', & !  707
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344390442739D-05,  0.0000D+00,  842, 'R', & !  708
     &         -0.2D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344389670178D-05,  0.0000D+00,  843, 'R', & !  709
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0205068502D0, -7.343451461117D-05,  0.0000D+00,  844, 'P', & !  710
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 711, 720 ) &
     &             /                 &
     & 2.8559490734D0, -7.342522894295D-05,  0.0000D+00,  845, 'R', & !  711
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341933732439D-05,  0.0000D+00,  846, 'R', & !  712
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932959878D-05,  0.0000D+00,  847, 'R', & !  713
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932187317D-05,  0.0000D+00,  848, 'R', & !  714
     &          8.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341931414756D-05,  0.0000D+00,  849, 'P', & !  715
     &         -1.3D0,         5.5D0,        0.0D0,      0.0D0,     & !
     & 0.9430699710D0, -7.341261236236D-05,  0.0000D+00,  850, 'R', & !  716
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3133761758D0, -7.339999578178D-05,  0.0000D+00,  851, 'R', & !  717
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.1307998343D0, -7.339647050317D-05,  9.2057D-23,  480, 'R', & !  718
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1145765614D0, -7.339473931896D-05,  0.0000D+00,  852, 'P', & !  719
     &          0.8D0,         2.6D0,        0.0D0,      0.0D0,     & !
     & 6.1145765614D0, -7.339473159335D-05,  0.0000D+00,  853, 'P', & !  720
     &        -14.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 721, 730 ) &
     &             /                 &
     & 2.4454507482D0, -7.339392915231D-05,  0.0000D+00,  854, 'R', & !  721
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.4454507482D0, -7.339392142670D-05,  0.0000D+00,  855, 'R', & !  722
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4004970735D0, -7.338737920120D-05,  0.0000D+00,  856, 'R', & !  723
     &         -0.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.2315459449D0, -7.338577354080D-05,  8.4782D-23,  479, 'R', & !  724
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4876179711D0, -7.337476262061D-05,  0.0000D+00,  857, 'R', & !  725
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.6843622272D0, -7.336935432370D-05,  0.0000D+00,  858, 'R', & !  726
     &          0.0D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 1.6843622272D0, -7.336933887249D-05,  0.0000D+00,  859, 'R', & !  727
     &          0.6D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 5.2228161003D0, -7.336215917261D-05,  2.6975D-23,  325, 'P', & !  728
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8579241759D0, -7.336214604003D-05,  0.0000D+00,  860, 'R', & !  729
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.2316966791D0, -7.335722106477D-05,  0.0000D+00,  861, 'R', & !  730
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 731, 740 ) &
     &             /                 &
     & 1.5771516852D0, -7.335294111049D-05,  0.0000D+00,  862, 'R', & !  731
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1588981527D0, -7.335256292232D-05,  4.2930D-23,  478, 'R', & !  732
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0403769037D0, -7.335146221024D-05,  1.9700D-23,   87, 'P', & !  733
     &       -187.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334477949509D-05,  0.0000D+00,  863, 'R', & !  734
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334476404388D-05,  0.0000D+00,  864, 'R', & !  735
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334475631827D-05,  0.0000D+00,  865, 'P', & !  736
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334474859266D-05,  0.0000D+00,  866, 'P', & !  737
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3188175767D0, -7.334460448418D-05,  0.0000D+00,  867, 'R', & !  738
     &          0.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.5373332002D0, -7.334394615163D-05,  0.0000D+00,  868, 'R', & !  739
     &          0.7D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.8579377070D0, -7.334076524788D-05,  1.2425D-23,   31, 'P', & !  740
     &      -2140.9D0,         4.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 741, 750 ) &
     &             /                 &
     & 4.4511287537D0, -7.334074622856D-05,  1.5628D-23,  464, 'P', & !  741
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1766981822D0, -7.333615621676D-05,  0.0000D+00,  869, 'R', & !  742
     &         -1.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6891237815D0, -7.333198790360D-05,  0.0000D+00,  870, 'R', & !  743
     &          0.8D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.8424691037D0, -7.333017992663D-05,  5.1496D-24,  871, 'R', & !  744
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.9586838176D0, -7.333006828551D-05,  5.1496D-24,   11, 'R', & !  745
     &      -4357.6D0,         8.0D0,     3494.7D0,      0.0D0,     & !
     & 1.8170911931D0, -7.333006055984D-05,  6.2124D-24,  872, 'R', & !  746
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.2686895571D0, -7.333004926620D-05,  8.3524D-24,  227, 'P', & !  747
     &         13.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7917132244D0, -7.332995664439D-05,  5.1496D-24,  873, 'R', & !  748
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.8160631642D0, -7.332836628188D-05,  0.0000D+00,  874, 'R', & !  749
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9022279222D0, -7.332613036379D-05,  0.0000D+00,  875, 'R', & !  750
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 751, 760 ) &
     &             /                 &
     & 0.1621851852D0, -7.332018148966D-05,  0.0000D+00,  878, 'P', & !  751
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332017376405D-05,  0.0000D+00,  877, 'P', & !  752
     &         12.5D0,       -22.7D0,        0.0D0,      0.0D0,     & !
     & 5.8409143629D0, -7.332002965557D-05,  0.0000D+00,  880, 'R', & !  753
     &          0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.8884391954D0, -7.331959673938D-05,  0.0000D+00,  881, 'R', & !  754
     &         -0.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7214686021D0, -7.331948509827D-05,  0.0000D+00,  882, 'R', & !  755
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9432152724D0, -7.331948296413D-05,  0.0000D+00,  884, 'R', & !  756
     &          2.4D0,         8.1D0,        0.0D0,      0.0D0,     & !
     & 2.7762446210D0, -7.331937132315D-05, -2.1256D-24,    2, 'R', & !  757
     &     119082.5D0,      -208.7D0,  -282773.9D0,    597.1D0,     & !
     & 2.7762446792D0, -7.331937132302D-05,  0.0000D+00,  886, 'R', & !  758
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9979913495D0, -7.331936918888D-05,  0.0000D+00,  885, 'R', & !  759
     &         -1.5D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 5.9178373037D0, -7.331936359747D-05, -1.0628D-24,  888, 'R', & !  760
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 761, 770 ) &
     &             /                 &
     & 2.7762446792D0, -7.331936359741D-05,  0.0000D+00,  889, 'R', & !  761
     &         -0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.7762446792D0, -7.331935587180D-05,  0.0000D+00,  891, 'R', & !  762
     &         -9.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0862503605D0, -7.331935230383D-05,  1.0772D-24,   35, 'R', & !  763
     &       1651.7D0,        -3.4D0,    -2674.0D0,      0.0D0,     & !
     & 5.8924593931D0, -7.331925968190D-05,  0.0000D+00,  892, 'R', & !  764
     &         -1.0D0,         3.6D0,        0.0D0,      0.0D0,     & !
     & 2.8310207563D0, -7.331925754777D-05,  0.0000D+00,  893, 'R', & !  765
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9472354702D0, -7.331914590665D-05,  0.0000D+00,  894, 'R', & !  766
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9947603026D0, -7.331871299046D-05,  0.0000D+00,  895, 'R', & !  767
     &         -0.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.3903041732D0, -7.331853797955D-05,  0.0000D+00,  896, 'R', & !  768
     &         -0.7D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4332024895D0, -7.331444634775D-05,  0.0000D+00,  897, 'R', & !  769
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6502614362D0, -7.331261228225D-05,  0.0000D+00,  898, 'R', & !  770
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 771, 780 ) &
     &             /                 &
     & 0.5938054244D0, -7.330867436078D-05, -9.4009D-24,   88, 'R', & !  771
     &         79.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.1869964711D0, -7.330865534147D-05, -6.1980D-24,  195, 'R', & !  772
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4752841753D0, -7.330757364871D-05, -3.2630D-23,  477, 'R', & !  773
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1302870451D0, -7.330756413905D-05, -3.1029D-23,  462, 'P', & !  774
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330675474243D-05,  0.0000D+00,  899, 'R', & !  775
     &         -0.8D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330673929122D-05,  0.0000D+00,  900, 'R', & !  776
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.5242781932D0, -7.330584551587D-05,  0.0000D+00,  901, 'R', & !  777
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.5242781932D0, -7.330583779026D-05,  0.0000D+00,  902, 'R', & !  778
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3757911762D0, -7.330258642928D-05,  0.0000D+00,  903, 'R', & !  779
     &          1.4D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.3757911762D0, -7.330257097806D-05,  0.0000D+00,  904, 'R', & !  780
     &          0.0D0,         3.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 781, 790 ) &
     &             /                 &
     & 3.5203233872D0, -7.330182976717D-05,  0.0000D+00,  905, 'R', & !  781
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3982949502D0, -7.329907874949D-05,  0.0000D+00,  906, 'R', & !  782
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.6945515349D0, -7.329797739842D-05, -1.6676D-23,  329, 'R', & !  783
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0045572745D0, -7.329795837910D-05, -1.3473D-23,  476, 'R', & !  784
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2310331557D0, -7.329686717668D-05, -3.8304D-23,  475, 'R', & !  785
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 2.8860360254D0, -7.329685766703D-05, -3.6703D-23,  324, 'P', & !  786
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7675147764D0, -7.329575695495D-05, -5.9932D-23,  173, 'P', & !  787
     &        -35.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329479649441D-05,  0.0000D+00,  907, 'R', & !  788
     &         -0.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478876880D-05,  0.0000D+00,  908, 'R', & !  789
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478104319D-05,  0.0000D+00,  909, 'R', & !  790
     &          8.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 791, 800 ) &
     &             /                 &
     & 2.0151561582D0, -7.329477331758D-05,  0.0000D+00,  910, 'P', & !  791
     &         -1.7D0,         7.6D0,        0.0D0,      0.0D0,     & !
     & 5.2336717816D0, -7.329413816185D-05,  0.0000D+00,  911, 'R', & !  792
     &         -0.2D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.2336717816D0, -7.329412271063D-05,  0.0000D+00,  912, 'R', & !  793
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6292156522D0, -7.329396315094D-05,  0.0000D+00,  913, 'R', & !  794
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.7035968288D0, -7.328616070466D-05, -4.3978D-23,  474, 'R', & !  795
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328580153554D-05,  0.0000D+00,  914, 'R', & !  796
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328579380993D-05,  0.0000D+00,  915, 'R', & !  797
     &          0.1D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328578608432D-05,  0.0000D+00,  916, 'R', & !  798
     &         39.8D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 1.5850755797D0, -7.328505999258D-05, -6.7208D-23,   44, 'P', & !  799
     &       1293.9D0,        -2.7D0,      336.1D0,      0.0D0,     & !
     & 3.3207926793D0, -7.328152158127D-05,  0.0000D+00,  917, 'R', & !  800
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 801, 810 ) &
     &             /                 &
     & 3.3207926793D0, -7.328150613005D-05,  0.0000D+00,  918, 'R', & !  801
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9777504896D0, -7.327659660600D-05,  0.0000D+00,  919, 'R', & !  802
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7928984766D0, -7.327508912196D-05, -7.2752D-24,  920, 'R', & !  803
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5696069764D0, -7.327447467134D-05, -7.4483D-23,  736, 'P', & !  804
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6858216903D0, -7.327436303022D-05, -7.4483D-23,   22, 'P', & !  805
     &       4717.2D0,        -7.8D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327020621458D-05,  0.0000D+00,  921, 'R', & !  806
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019848897D-05,  0.0000D+00,  922, 'P', & !  807
     &          1.0D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019076337D-05,  0.0000D+00,  923, 'P', & !  808
     &        -23.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8681271312D0, -7.326938832233D-05,  0.0000D+00,  924, 'R', & !  809
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 3.8681271312D0, -7.326938059672D-05,  0.0000D+00,  925, 'R', & !  810
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 811, 820 ) &
     &             /                 &
     & 4.5748841702D0, -7.326900119059D-05,  0.0000D+00,  926, 'R', & !  811
     &          8.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.0648713873D0, -7.326398002542D-05,  0.0000D+00,  927, 'R', & !  812
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5033824937D0, -7.326366606785D-05, -8.1758D-23,   49, 'R', & !  813
     &       -142.8D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.3209432971D0, -7.325296910549D-05, -8.9033D-23,  194, 'R', & !  814
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1744306672D0, -7.325221629685D-05,  0.0000D+00,  928, 'R', & !  815
     &          1.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.1744306672D0, -7.325220084563D-05,  0.0000D+00,  929, 'P', & !  816
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2024220480D0, -7.325186839341D-05, -1.1226D-22,  461, 'P', & !  817
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1519922849D0, -7.325136344484D-05,  0.0000D+00,  930, 'R', & !  818
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4929791162D0, -7.324561593476D-05,  0.0000D+00,  931, 'P', & !  819
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1070386102D0, -7.324481349372D-05,  0.0000D+00,  932, 'R', & !  820
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 821, 830 ) &
     &             /                 &
     & 3.1070386102D0, -7.324479804251D-05,  0.0000D+00,  933, 'R', & !  821
     &         -0.4D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 0.2391131825D0, -7.323874686425D-05,  0.0000D+00,  934, 'R', & !  822
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7739771642D0, -7.323541595189D-05,  0.0000D+00,  935, 'P', & !  823
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6094193874D0, -7.322613028367D-05,  0.0000D+00,  936, 'R', & !  824
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322022321390D-05,  0.0000D+00,  937, 'R', & !  825
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322021548829D-05,  0.0000D+00,  938, 'P', & !  826
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322020776268D-05,  0.0000D+00,  939, 'P', & !  827
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.9600095832D0, -7.321940532164D-05,  0.0000D+00,  940, 'R', & !  828
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1297742558D0, -7.321865777493D-05, -1.5412D-22,  323, 'P', & !  829
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2305203664D0, -7.320796081256D-05, -1.6139D-22,  460, 'P', & !  830
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 831, 840 ) &
     &             /                 &
     & 0.7836611826D0, -7.320088167129D-05,  0.0000D+00,  941, 'R', & !  831
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6808657008D0, -7.319735460856D-05,  9.4721D-23,  459, 'P', & !  832
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5848615682D0, -7.319564065968D-05,  0.0000D+00,  942, 'P', & !  833
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5848615682D0, -7.319563293407D-05,  0.0000D+00,  943, 'P', & !  834
     &          0.0D0,        -4.7D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319483049304D-05,  0.0000D+00,  944, 'R', & !  835
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0573283795D0, -7.319482276749D-05, -1.0628D-24,  945, 'R', & !  836
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319482276743D-05,  0.0000D+00,  946, 'R', & !  837
     &         -0.2D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319481504182D-05,  0.0000D+00,  947, 'P', & !  838
     &         -0.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.1539673875D0, -7.318826509070D-05,  0.0000D+00,  948, 'R', & !  839
     &          1.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 1.4984265042D0, -7.318665764620D-05,  8.7446D-23,  328, 'R', & !  840
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 841, 850 ) &
     &             /                 &
     & 5.6202717378D0, -7.318093717558D-05,  7.2752D-24,  949, 'P', & !  841
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5991726147D0, -7.317596068383D-05,  8.0171D-23,  205, 'R', & !  842
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2410882851D0, -7.317564851012D-05,  0.0000D+00,  950, 'R', & !  843
     &          0.5D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.2410882851D0, -7.317563305891D-05,  0.0000D+00,  951, 'P', & !  844
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1974660585D0, -7.317485997176D-05,  5.6941D-23,  458, 'P', & !  845
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7310755022D0, -7.317062734496D-05,  0.0000D+00,  952, 'R', & !  846
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024793882D-05,  0.0000D+00,  953, 'R', & !  847
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024021321D-05,  0.0000D+00,  954, 'R', & !  848
     &        -57.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317023248760D-05,  0.0000D+00,  956, 'P', & !  849
     &         -2.6D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 0.2962399167D0, -7.317023248754D-05,  1.0628D-24,  955, 'P', & !  850
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 851, 860 ) &
     &             /                 &
     & 3.4167334181D0, -7.316526372147D-05,  7.2896D-23,  473, 'R', & !  851
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2982121691D0, -7.316416300939D-05,  4.9666D-23,  272, 'P', & !  852
     &          6.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3282091827D0, -7.316303192954D-05,  0.0000D+00,  957, 'R', & !  853
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.3282091827D0, -7.316301647832D-05,  0.0000D+00,  958, 'P', & !  854
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2553933446D0, -7.315954325084D-05, -7.2752D-24,  959, 'R', & !  855
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9851669931D0, -7.315812240549D-05,  0.0000D+00,  960, 'R', & !  856
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3306219992D0, -7.315384245122D-05,  0.0000D+00,  961, 'R', & !  857
     &          0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.1157729725D0, -7.315346604703D-05,  4.2391D-23,  145, 'R', & !  858
     &          8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9972517234D0, -7.315236533495D-05,  1.9161D-23,  271, 'P', & !  859
     &          7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8578021000D0, -7.315052288983D-05,  0.0000D+00,  962, 'P', & !  860
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 861, 870 ) &
     &             /                 &
     & 6.1126076346D0, -7.314775451997D-05,  5.1496D-24,  964, 'R', & !  861
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314566538460D-05,  0.0000D+00,  965, 'R', & !  862
     &          1.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314565765899D-05,  0.0000D+00,  967, 'P', & !  863
     &          2.0D0,         8.0D0,        0.0D0,      0.0D0,     & !
     & 5.8183367029D0, -7.314565765893D-05,  1.0628D-24,  966, 'P', & !  864
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314564993338D-05,  0.0000D+00,  968, 'P', & !  865
     &        -40.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0722878907D0, -7.314550582491D-05,  0.0000D+00,  969, 'R', & !  866
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314484749235D-05,  0.0000D+00,  970, 'R', & !  867
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314483976674D-05,  0.0000D+00,  971, 'R', & !  868
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314483204113D-05,  0.0000D+00,  972, 'P', & !  869
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 6.2165190830D0, -7.314276908466D-05,  3.5116D-23,  275, 'R', & !  870
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 871, 880 ) &
     &             /                 &
     & 3.5265248225D0, -7.314275006534D-05,  3.8319D-23,  472, 'R', & !  871
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8148125268D0, -7.314166837259D-05,  1.1886D-23,  107, 'P', & !  872
     &         91.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4080035735D0, -7.314164935327D-05,  1.5089D-23,  111, 'P', & !  873
     &       -118.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313705755748D-05,  0.0000D+00,  973, 'R', & !  874
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313704983187D-05,  0.0000D+00,  974, 'R', & !  875
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313704210626D-05,  0.0000D+00,  975, 'R', & !  876
     &          0.8D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 0.4943048817D0, -7.313495297089D-05, -5.1496D-24,  976, 'P', & !  877
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7816814792D0, -7.313379074528D-05,  0.0000D+00,  977, 'R', & !  878
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313288924432D-05,  0.0000D+00,  978, 'R', & !  879
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313287379311D-05,  0.0000D+00,  979, 'R', & !  880
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 881, 890 ) &
     &             /                 &
     & 4.9155586374D0, -7.313097141022D-05,  4.6109D-24,   46, 'R', & !  881
     &        200.9D0,         0.4D0,     -336.1D0,      0.0D0,     & !
     & 3.5705615071D0, -7.313096190056D-05,  6.2124D-24,  471, 'R', & !  882
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2255643769D0, -7.313095239090D-05,  7.8138D-24,   33, 'P', & !  883
     &       2775.2D0,        12.4D0,     -336.1D0,      0.0D0,     & !
     & 3.6556982362D0, -7.312703170451D-05,  0.0000D+00,  980, 'R', & !  884
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6782020102D0, -7.312352402473D-05,  0.0000D+00,  981, 'R', & !  885
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9156554992D0, -7.312109055599D-05,  0.0000D+00,  982, 'P', & !  886
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9156554992D0, -7.312107510478D-05,  0.0000D+00,  983, 'P', & !  887
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4135002793D0, -7.312038430486D-05,  0.0000D+00,  985, 'R', & !  888
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4135002793D0, -7.312036885364D-05,  0.0000D+00,  986, 'P', & !  889
     &          1.8D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 2.7331194407D0, -7.312027444785D-05, -2.6643D-24,   10, 'R', & !  890
     &      -2442.8D0,       -21.3D0,     7873.3D0,     76.8D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 891, 900 ) &
     &             /                 &
     & 4.5297149932D0, -7.312025721252D-05,  0.0000D+00,  987, 'R', & !  891
     &          0.8D0,        -2.6D0,        0.0D0,      0.0D0,     & !
     & 0.0431251803D0, -7.312025542854D-05,  5.3862D-25,    5, 'R', & !  892
     &     160216.7D0,      1605.8D0,  -125139.7D0,   -842.4D0,     & !
     & 4.5297149932D0, -7.312024948692D-05,  0.0000D+00,  988, 'P', & !  893
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3627443999D0, -7.312016102262D-05,  0.0000D+00,  989, 'R', & !  894
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3627443999D0, -7.312014557141D-05,  0.0000D+00,  990, 'R', & !  895
     &          2.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.4175204770D0, -7.312003179616D-05,  0.0000D+00,  991, 'R', & !  896
     &         -1.3D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.8605891800D0, -7.311943932027D-05,  0.0000D+00,  992, 'R', & !  897
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9246039312D0, -7.311915471646D-05, -2.2691D-23,  322, 'P', & !  898
     &          6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7992750874D0, -7.311833759431D-05,  7.2752D-24,  993, 'P', & !  899
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0285153796D0, -7.311416928115D-05,  7.2752D-24,  994, 'P', & !  900
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 901, 910 ) &
     &             /                 &
     & 5.4037317502D0, -7.311349817176D-05,  0.0000D+00,  995, 'R', & !  901
     &         -7.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5506802441D0, -7.310957748549D-05, -9.9395D-24,  327, 'R', & !  902
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1438712908D0, -7.310955846617D-05, -6.7366D-24,   28, 'R', & !  903
     &        717.8D0,        18.5D0,     -917.5D0,      0.0D0,     & !
     & 5.0253500418D0, -7.310845775410D-05, -2.9966D-23,   93, 'P', & !  904
     &       -218.3D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 2.6168358908D0, -7.310764063194D-05,  0.0000D+00,  996, 'R', & !  905
     &        -35.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2777485072D0, -7.310673913099D-05,  0.0000D+00,  997, 'R', & !  906
     &         -0.6D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.9510656688D0, -7.310637934628D-05,  7.2752D-24,  998, 'P', & !  907
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.9582706992D0, -7.310369773515D-05,  0.0000D+00,  999, 'R', & !  908
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1292614902D0, -7.310348004439D-05,  0.0000D+00, 1000, 'R', & !  909
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.1292614902D0, -7.310347231879D-05,  0.0000D+00, 1001, 'R', & !  910
     &       -117.9D0,        -2.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 911, 920 ) &
     &             /                 &
     & 5.1292614902D0, -7.310346459318D-05,  0.0000D+00, 1002, 'P', & !  911
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.0170669740D0, -7.310324690242D-05,  0.0000D+00, 1003, 'R', & !  912
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8685799570D0, -7.309998009022D-05,  0.0000D+00, 1004, 'R', & !  913
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9614320942D0, -7.309886150381D-05, -1.4012D-23,   94, 'R', & !  914
     &        -10.1D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.8429108452D0, -7.309776079173D-05, -3.7241D-23,   69, 'P', & !  915
     &       -522.3D0,       -67.7D0,        0.0D0,      0.0D0,     & !
     & 1.6280618766D0, -7.309738438741D-05,  7.2752D-24, 1005, 'P', & !  916
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309569010952D-05,  0.0000D+00, 1007, 'R', & !  917
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309568238391D-05,  0.0000D+00, 1008, 'R', & !  918
     &         -0.5D0,        31.6D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309567465831D-05,  0.0000D+00, 1009, 'P', & !  919
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309566693270D-05,  0.0000D+00, 1010, 'P', & !  920
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 921, 930 ) &
     &             /                 &
     & 0.7039567885D0, -7.309502405136D-05,  0.0000D+00, 1011, 'R', & !  921
     &         -7.5D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 0.0995006590D0, -7.309486449166D-05,  0.0000D+00, 1012, 'R', & !  922
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9468222936D0, -7.309277535642D-05, -7.2752D-24, 1013, 'R', & !  923
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6604716485D0, -7.308706382937D-05, -4.4517D-23,  178, 'R', & !  924
     &          2.2D0,        -5.4D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308668742505D-05,  0.0000D+00, 1014, 'R', & !  925
     &        -16.0D0,        25.9D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308667197383D-05,  0.0000D+00, 1015, 'P', & !  926
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5861872756D0, -7.308498542155D-05, -7.2752D-24, 1016, 'R', & !  927
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0742629933D0, -7.308240747077D-05,  0.0000D+00, 1017, 'R', & !  928
     &         -1.5D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 5.0742629933D0, -7.308239201956D-05,  0.0000D+00, 1018, 'P', & !  929
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5208512764D0, -7.308098662555D-05,  5.1496D-24, 1019, 'R', & !  930
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 931, 940 ) &
     &             /                 &
     & 4.7612177591D0, -7.307636686700D-05, -5.1792D-23,  326, 'R', & !  931
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5463687906D0, -7.307599046268D-05, -7.2752D-24, 1020, 'R', & !  932
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.6426965101D0, -7.307526615493D-05, -7.5021D-23,  204, 'P', & !  933
     &         -6.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.9527022496D0, -7.307524713561D-05, -7.1819D-23,  457, 'P', & !  934
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0075379512D0, -7.307110755531D-05,  0.0000D+00, 1021, 'R', & !  935
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.0075379512D0, -7.307109982970D-05,  0.0000D+00, 1022, 'P', & !  936
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0075379512D0, -7.307109210409D-05,  0.0000D+00, 1023, 'P', & !  937
     &          0.0D0,        -9.2D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028966305D-05,  0.0000D+00, 1024, 'R', & !  938
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4800047625D0, -7.307028193751D-05, -1.0628D-24, 1025, 'R', & !  939
     &          0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028193745D-05,  0.0000D+00, 1026, 'R', & !  940
     &         -0.6D0,         1.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 941, 950 ) &
     &             /                 &
     & 5.6215974452D0, -7.307027421184D-05,  0.0000D+00, 1027, 'P', & !  941
     &         -0.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306990253131D-05,  0.0000D+00, 1028, 'R', & !  942
     &         -2.7D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306989480570D-05,  0.0000D+00, 1029, 'P', & !  943
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306988708009D-05,  0.0000D+00, 1030, 'P', & !  944
     &        -24.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1613838909D0, -7.306979089019D-05,  0.0000D+00, 1031, 'R', & !  945
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 3.1613838909D0, -7.306977543898D-05,  0.0000D+00, 1032, 'P', & !  946
     &         -1.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.1898433920D0, -7.306611739620D-05,  7.4483D-23, 1033, 'R', & !  947
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8183417013D0, -7.306488136614D-05,  0.0000D+00, 1034, 'R', & !  948
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4602573134D0, -7.306456919256D-05, -8.2297D-23,  274, 'R', & !  949
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7702630530D0, -7.306455017325D-05, -7.9094D-23,  172, 'P', & !  950
     &        -21.9D0,        -0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 951, 960 ) &
     &             /                 &
     & 4.1459153457D0, -7.305919011760D-05, -5.1496D-24, 1035, 'P', & !  951
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2485047886D0, -7.305717430961D-05,  0.0000D+00, 1036, 'P', & !  952
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.2485047886D0, -7.305715885839D-05,  0.0000D+00, 1037, 'P', & !  953
     &         -0.2D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.7597628136D0, -7.305639634559D-05,  7.2752D-24, 1038, 'P', & !  954
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2778181168D0, -7.305387223020D-05, -8.9572D-23,  470, 'R', & !  955
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8710091635D0, -7.305385321088D-05, -8.6369D-23,  270, 'P', & !  956
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6447156740D0, -7.305311763757D-05,  0.0000D+00, 1039, 'R', & !  957
     &         -0.4D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 0.6447156740D0, -7.305310218635D-05,  0.0000D+00, 1040, 'P', & !  958
     &         -6.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 3.9054625989D0, -7.305226478556D-05,  0.0000D+00, 1041, 'R', & !  959
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7189162415D0, -7.304570710890D-05, -1.0628D-24, 1042, 'R', & !  960
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 961, 970 ) &
     &             /                 &
     & 4.8605089242D0, -7.304570710884D-05,  0.0000D+00, 1043, 'R', & !  961
     &          0.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569938323D-05,  0.0000D+00, 1044, 'R', & !  962
     &        143.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569165762D-05,  0.0000D+00, 1046, 'P', & !  963
     &         -5.6D0,        24.0D0,        0.0D0,      0.0D0,     & !
     & 1.7189162997D0, -7.304569165756D-05,  1.0628D-24, 1045, 'P', & !  964
     &         -1.2D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304568393201D-05,  0.0000D+00, 1047, 'P', & !  965
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6188109934D0, -7.304454227781D-05,  0.0000D+00, 1048, 'P', & !  966
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.6885699669D0, -7.304315624852D-05, -9.3644D-23,  469, 'R', & !  967
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5700487179D0, -7.304205553644D-05, -1.1687D-22,  456, 'P', & !  968
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9925834965D0, -7.303964820498D-05,  0.0000D+00, 1049, 'R', & !  969
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9925834965D0, -7.303963275376D-05,  0.0000D+00, 1050, 'P', & !  970
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 971, 980 ) &
     &             /                 &
     & 1.2442621710D0, -7.303631729262D-05,  0.0000D+00, 1051, 'P', & !  971
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6780697276D0, -7.303500242086D-05, -7.2752D-24, 1052, 'R', & !  972
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196624102D0, -7.303499469519D-05, -6.2124D-24, 1053, 'R', & !  973
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.2690882722D0, -7.303025786200D-05, -1.4738D-22,  455, 'P', & !  974
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0797043942D0, -7.302701617318D-05,  0.0000D+00, 1054, 'R', & !  975
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.2479891491D0, -7.302528137026D-05, -7.4483D-23, 1055, 'P', & !  976
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302112455462D-05,  0.0000D+00, 1056, 'R', & !  977
     &         -4.4D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302111682901D-05,  0.0000D+00, 1059, 'P', & !  978
     &          5.8D0,        23.8D0,        0.0D0,      0.0D0,     & !
     & 0.9578277787D0, -7.302111682895D-05,  1.0628D-24, 1058, 'P', & !  979
     &          1.6D0,         6.3D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302110910340D-05,  0.0000D+00, 1060, 'P', & !  980
     &        -98.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 981, 990 ) &
     &             /                 &
     & 0.4302945900D0, -7.302030666237D-05,  0.0000D+00, 1061, 'R', & !  981
     &          0.0D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.5718872145D0, -7.302029893682D-05, -1.0628D-24, 1062, 'R', & !  982
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4302945900D0, -7.302029893676D-05,  0.0000D+00, 1063, 'R', & !  983
     &          0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.4500105990D0, -7.301439959259D-05,  0.0000D+00, 1064, 'R', & !  984
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0585738892D0, -7.301041986658D-05, -6.2124D-24, 1065, 'R', & !  985
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.9169812647D0, -7.301041214091D-05, -5.1496D-24, 1066, 'P', & !  986
     &         -6.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8201797171D0, -7.300895469563D-05,  1.0146D-22,  321, 'P', & !  987
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5371314966D0, -7.300178301201D-05,  0.0000D+00, 1067, 'R', & !  988
     &         -6.6D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 6.0177273753D0, -7.299971517854D-05, -1.2425D-23, 1068, 'R', & !  989
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6377405205D0, -7.299825773327D-05,  9.4183D-23,   90, 'P', & !  990
     &       -163.3D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 991,1000 ) &
     &             /                 &
     & 3.3383318822D0, -7.299654200040D-05,  0.0000D+00, 1069, 'P', & !  991
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.3383318822D0, -7.299653427479D-05,  0.0000D+00, 1070, 'P', & !  992
     &          3.2D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299573183376D-05,  0.0000D+00, 1071, 'R', & !  993
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299572410815D-05,  0.0000D+00, 1072, 'R', & !  994
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299571638254D-05,  0.0000D+00, 1073, 'P', & !  995
     &         -2.1D0,        -8.4D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299570865693D-05,  0.0000D+00, 1075, 'P', & !  996
     &          2.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.8107987517D0, -7.299570865687D-05,  1.0628D-24, 1074, 'P', & !  997
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6242523943D0, -7.298916643143D-05,  0.0000D+00, 1076, 'R', & !  998
     &         -1.9D0,         3.3D0,        0.0D0,      0.0D0,     & !
     & 0.6242523943D0, -7.298915870582D-05,  0.0000D+00, 1077, 'P', & !  999
     &         -0.2D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.6242523943D0, -7.298915098021D-05,  0.0000D+00, 1078, 'P', & ! 1000
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1001,1010 ) &
     &             /                 &
     & 0.5738225730D0, -7.298866148298D-05,  1.1014D-22,  320, 'R', & ! 1001
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8849993192D0, -7.298831357942D-05,  0.0000D+00, 1079, 'R', & ! 1002
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4553013239D0, -7.298756077090D-05,  8.6908D-23,   37, 'R', & ! 1003
     &      -1037.8D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 3.7699521796D0, -7.298501942018D-05, -7.2752D-24, 1080, 'R', & ! 1004
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3837996474D0, -7.298222564817D-05,  5.1496D-24, 1082, 'R', & ! 1005
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0905567446D0, -7.298183851630D-05,  7.2752D-24, 1083, 'P', & ! 1006
     &          0.0D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 5.5560474345D0, -7.297686380854D-05,  7.9632D-23,   18, 'R', & ! 1007
     &      -1449.8D0,        -1.9D0,      759.6D0,      0.0D0,     & !
     & 2.8660531740D0, -7.297684478922D-05,  8.2835D-23,  449, 'P', & ! 1008
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9945585991D0, -7.297654985084D-05,  0.0000D+00, 1084, 'R', & ! 1009
     &          0.0D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 4.9945585991D0, -7.297654212524D-05,  0.0000D+00, 1085, 'P', & ! 1010
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1011,1020 ) &
     &             /                 &
     & 4.9945585991D0, -7.297653439963D-05,  0.0000D+00, 1086, 'P', & ! 1011
     &         -3.2D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 3.1657853410D0, -7.297613771680D-05,  1.2425D-23, 1087, 'P', & ! 1012
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3683311023D0, -7.297164032680D-05,  0.0000D+00, 1088, 'R', & ! 1013
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3683311023D0, -7.297162487558D-05,  0.0000D+00, 1089, 'P', & ! 1014
     &         -0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152868568D-05,  0.0000D+00, 1090, 'R', & ! 1015
     &          1.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.3429531335D0, -7.297152096014D-05, -1.0628D-24, 1092, 'R', & ! 1016
     &          0.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152096007D-05,  0.0000D+00, 1093, 'R', & ! 1017
     &         -0.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114927954D-05,  0.0000D+00, 1094, 'R', & ! 1018
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114155393D-05,  0.0000D+00, 1095, 'R', & ! 1019
     &          0.8D0,        59.2D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297113382833D-05,  0.0000D+00, 1097, 'P', & ! 1020
     &         -6.8D0,        -0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1021,1030 ) &
     &             /                 &
     & 2.0497102307D0, -7.297113382826D-05,  1.0628D-24, 1096, 'P', & ! 1021
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297112610272D-05,  0.0000D+00, 1098, 'P', & ! 1022
     &         -1.0D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 1.5221770420D0, -7.297032366168D-05,  0.0000D+00, 1099, 'R', & ! 1023
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5221770420D0, -7.297031593607D-05,  0.0000D+00, 1100, 'R', & ! 1024
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.1259668560D0, -7.296714275793D-05,  1.2425D-23, 1101, 'P', & ! 1025
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3736082379D0, -7.296616684617D-05,  7.2357D-23,   53, 'R', & ! 1026
     &         21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2320156134D0, -7.296615912050D-05,  7.3420D-23, 1102, 'R', & ! 1027
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.6836139774D0, -7.296614782686D-05,  7.5560D-23,  171, 'R', & ! 1028
     &        -21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9833461444D0, -7.296544075444D-05,  5.1496D-24, 1103, 'R', & ! 1029
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1249388271D0, -7.296543302876D-05,  6.2124D-24, 1104, 'P', & ! 1030
     &          0.3D0,         1.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1031,1040 ) &
     &             /                 &
     & 4.2550869888D0, -7.296506613410D-05,  4.9128D-23,  319, 'P', & ! 1031
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9100898586D0, -7.296505662444D-05,  5.0729D-23,  448, 'P', & ! 1032
     &          0.0D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 3.0816794967D0, -7.296393327026D-05,  0.0000D+00, 1105, 'R', & ! 1033
     &          0.7D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 3.0816794967D0, -7.296392554465D-05,  0.0000D+00, 1106, 'P', & ! 1034
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0816794967D0, -7.296391781905D-05,  0.0000D+00, 1107, 'P', & ! 1035
     &         -1.5D0,         2.4D0,        0.0D0,      0.0D0,     & !
     & 3.0088636586D0, -7.296044459157D-05, -7.2752D-24, 1108, 'R', & ! 1036
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 6.1504563412D0, -7.296043686589D-05, -6.2124D-24, 1109, 'R', & ! 1037
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295902374621D-05,  0.0000D+00, 1110, 'R', & ! 1038
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.5970446244D0, -7.295901602067D-05, -1.0628D-24, 1112, 'R', & ! 1039
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295901602060D-05,  0.0000D+00, 1113, 'R', & ! 1040
     &          0.3D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1041,1050 ) &
     &             /                 &
     & 5.7386373071D0, -7.295900829500D-05,  0.0000D+00, 1114, 'P', & ! 1041
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 3.4710609063D0, -7.295725596202D-05,  8.3380D-24, 1115, 'P', & ! 1042
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0081973431D0, -7.295710412812D-05,  5.1496D-24, 1116, 'R', & ! 1043
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0081974013D0, -7.295708867678D-05,  7.2752D-24, 1117, 'P', & ! 1044
     &          0.9D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.9435276594D0, -7.295644579557D-05,  5.1496D-24, 1118, 'R', & ! 1045
     &         -4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0851203421D0, -7.295643806989D-05,  6.2124D-24, 1119, 'P', & ! 1046
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 2.9435277176D0, -7.295643034422D-05,  7.2752D-24, 1120, 'P', & ! 1047
     &          1.7D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.7843600879D0, -7.295545086449D-05,  6.8285D-23,  242, 'R', & ! 1048
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9131015222D0, -7.295496920831D-05,  0.0000D+00, 1121, 'R', & ! 1049
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295474379194D-05,  0.0000D+00, 1123, 'R', & ! 1050
     &         10.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1051,1060 ) &
     &             /                 &
     & 1.9424996305D0, -7.295473606640D-05, -1.0628D-24, 1125, 'R', & ! 1051
     &          0.8D0,         4.9D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295473606633D-05,  0.0000D+00, 1126, 'R', & ! 1052
     &         -1.6D0,        -8.9D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295472834072D-05,  0.0000D+00, 1127, 'R', & ! 1053
     &         -2.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 1.9718977970D0, -7.295451837557D-05,  0.0000D+00, 1128, 'R', & ! 1054
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0726477922D0, -7.295436917173D-05,  4.1852D-23,  226, 'R', & ! 1055
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7276506620D0, -7.295435966208D-05,  4.3454D-23,  454, 'R', & ! 1056
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 0.2641322827D0, -7.295324944034D-05,  2.1826D-23,  164, 'P', & ! 1057
     &         31.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8992403583D0, -7.295322085655D-05, -5.1496D-24, 1129, 'P', & ! 1058
     &         -0.2D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 5.1216418100D0, -7.295263331329D-05,  7.4483D-23, 1130, 'R', & ! 1059
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7949589717D0, -7.295227352858D-05,  8.1758D-23, 1131, 'P', & ! 1060
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1061,1070 ) &
     &             /                 &
     & 2.6112724140D0, -7.295143968177D-05,  0.0000D+00, 1132, 'R', & ! 1061
     &          0.5D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.6112724140D0, -7.295142423056D-05,  0.0000D+00, 1133, 'P', & ! 1062
     &          0.9D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.1688003944D0, -7.295131668968D-05,  0.0000D+00, 1134, 'R', & ! 1063
     &          0.9D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.1688003944D0, -7.295130123846D-05,  0.0000D+00, 1135, 'P', & ! 1064
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 1.5828926414D0, -7.294865586070D-05,  5.1496D-24, 1136, 'R', & ! 1065
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7244853241D0, -7.294864813502D-05,  6.2124D-24, 1137, 'P', & ! 1066
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.5828926996D0, -7.294864040935D-05,  7.2752D-24, 1138, 'P', & ! 1067
     &         -0.9D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 4.7244853823D0, -7.294863268368D-05,  8.3380D-24, 1139, 'P', & ! 1068
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294656672532D-05,  0.0000D+00, 1140, 'R', & ! 1069
     &         -1.3D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655899972D-05,  0.0000D+00, 1141, 'P', & ! 1070
     &        -19.9D0,         3.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1071,1080 ) &
     &             /                 &
     & 1.2886217097D0, -7.294655899965D-05,  1.0628D-24, 1142, 'P', & ! 1071
     &        -31.7D0,         6.0D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655127411D-05,  0.0000D+00, 1146, 'P', & ! 1072
     &          2.3D0,       -52.6D0,        0.0D0,      0.0D0,     & !
     & 4.4302143924D0, -7.294655127398D-05,  2.1256D-24, 1145, 'P', & ! 1073
     &          0.0D0,         2.4D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294640716563D-05,  0.0000D+00, 1147, 'R', & ! 1074
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6841655220D0, -7.294639944009D-05, -1.0628D-24, 1149, 'R', & ! 1075
     &         -0.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639944002D-05,  0.0000D+00, 1150, 'R', & ! 1076
     &          0.3D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639171441D-05,  0.0000D+00, 1151, 'P', & ! 1077
     &          8.3D0,        14.8D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294638398881D-05,  0.0000D+00, 1153, 'P', & ! 1078
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6841655802D0, -7.294638398874D-05,  1.0628D-24, 1152, 'P', & ! 1079
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7610884628D0, -7.294574883320D-05, -2.1256D-24, 1155, 'R', & ! 1080
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1081,1090 ) &
     &             /                 &
     & 0.7610885210D0, -7.294574883307D-05,  0.0000D+00, 1156, 'R', & ! 1081
     &         17.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9026811455D0, -7.294574110753D-05, -1.0628D-24, 1158, 'R', & ! 1082
     &          0.2D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574110746D-05,  0.0000D+00, 1157, 'R', & ! 1083
     &         -0.6D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294573338186D-05,  0.0000D+00, 1159, 'P', & ! 1084
     &         14.0D0,         4.5D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294572565625D-05,  0.0000D+00, 1160, 'P', & ! 1085
     &          1.0D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 3.9026812037D0, -7.294572565618D-05,  1.0628D-24, 1161, 'P', & ! 1086
     &          2.1D0,        -3.3D0,        0.0D0,      0.0D0,     & !
     & 0.4344056244D0, -7.294538904850D-05,  5.1496D-24, 1162, 'R', & ! 1087
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5759983071D0, -7.294538132282D-05,  6.2124D-24, 1163, 'P', & ! 1088
     &          0.4D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.6019208913D0, -7.294475390213D-05,  6.1010D-23,  453, 'R', & ! 1089
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9537256163D0, -7.294447982187D-05,  6.2124D-24, 1164, 'P', & ! 1090
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1091,1100 ) &
     &             /                 &
     & 4.0953182990D0, -7.294447209620D-05,  7.2752D-24, 1165, 'P', & ! 1091
     &          8.4D0,         8.0D0,        0.0D0,      0.0D0,     & !
     & 0.9537256745D0, -7.294446437052D-05,  8.3380D-24, 1166, 'P', & ! 1092
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0432457411D0, -7.294403910403D-05, -8.3380D-24, 1167, 'R', & ! 1093
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1733939028D0, -7.294367220937D-05,  3.4577D-23,  452, 'R', & ! 1094
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8283967725D0, -7.294366269971D-05,  3.6179D-23,  451, 'R', & ! 1095
     &          0.0D0,       115.3D0,        0.0D0,      0.0D0,     & !
     & 3.4833996423D0, -7.294365319005D-05,  3.7780D-23,   64, 'R', & ! 1096
     &        313.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4719551795D0, -7.294327856972D-05,  8.1758D-23, 1168, 'P', & ! 1097
     &        -12.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2486636793D0, -7.294266411909D-05,  1.4550D-23, 1169, 'P', & ! 1098
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 0.7716873465D0, -7.294257149729D-05,  1.1348D-23,  225, 'P', & ! 1099
     &          9.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3648783932D0, -7.294255247798D-05,  1.4550D-23,    4, 'P', & ! 1100
     &    -417594.8D0,      -137.8D0,    29777.8D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1101,1110 ) &
     &             /                 &
     & 1.1979078000D0, -7.294244083686D-05,  1.4550D-23, 1170, 'P', & ! 1101
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.6125197750D0, -7.294157656622D-05,  7.4483D-23, 1171, 'R', & ! 1102
     &        -13.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6611350362D0, -7.294145112677D-05,  0.0000D+00, 1172, 'R', & ! 1103
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.5195423535D0, -7.294144340123D-05, -1.0628D-24, 1174, 'R', & ! 1104
     &          0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6611350362D0, -7.294144340116D-05,  0.0000D+00, 1173, 'R', & ! 1105
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5489405200D0, -7.294121025919D-05,  0.0000D+00, 1175, 'R', & ! 1106
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8310353985D0, -7.294091823366D-05,  7.4483D-23, 1176, 'R', & ! 1107
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4288332756D0, -7.294072726806D-05, -5.1496D-24, 1177, 'P', & ! 1108
     &          0.2D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 5.2695465631D0, -7.294060427597D-05, -5.1496D-24, 1178, 'P', & ! 1109
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 6.1005954928D0, -7.293899861544D-05,  8.1758D-23, 1179, 'P', & ! 1110
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1111,1120 ) &
     &             /                 &
     & 5.5391065992D0, -7.293870010910D-05,  0.0000D+00, 1180, 'R', & ! 1111
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5391065992D0, -7.293868465788D-05,  0.0000D+00, 1181, 'P', & ! 1112
     &          0.9D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.4500150641D0, -7.293862228205D-05,  6.2124D-24, 1182, 'P', & ! 1113
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3084224396D0, -7.293861455638D-05,  7.2752D-24, 1183, 'P', & ! 1114
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.4500151223D0, -7.293860683071D-05,  8.3380D-24, 1184, 'P', & ! 1115
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293795889820D-05,  0.0000D+00, 1185, 'R', & ! 1116
     &         -0.6D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.5420461275D0, -7.293795117266D-05, -1.0628D-24, 1187, 'R', & ! 1117
     &          0.1D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293795117259D-05,  0.0000D+00, 1188, 'R', & ! 1118
     &         -0.1D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293794344699D-05,  0.0000D+00, 1189, 'R', & ! 1119
     &         -8.8D0,        23.9D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293793572138D-05,  0.0000D+00, 1190, 'P', & ! 1120
     &          3.0D0,        11.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1121,1130 ) &
     &             /                 &
     & 2.5420461857D0, -7.293793572131D-05,  1.0628D-24, 1191, 'P', & ! 1121
     &         11.4D0,        43.7D0,        0.0D0,      0.0D0,     & !
     & 2.5714442940D0, -7.293771803062D-05,  0.0000D+00, 1192, 'R', & ! 1122
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 4.4687898416D0, -7.293756704266D-05,  4.4517D-23, 1193, 'P', & ! 1123
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1771620028D0, -7.293732899636D-05, -6.7208D-23, 1194, 'P', & ! 1124
     &          0.2D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 3.2933767167D0, -7.293721735525D-05, -6.7208D-23, 1195, 'P', & ! 1125
     &         11.9D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 5.8086666935D0, -7.293678049088D-05,  7.2752D-24, 1196, 'P', & ! 1126
     &          1.2D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3310079426D0, -7.293601233125D-05, -6.7208D-23, 1197, 'P', & ! 1127
     &         -2.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.2477751376D0, -7.293586976296D-05, -7.2752D-24, 1198, 'R', & ! 1128
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.3893678202D0, -7.293586203729D-05, -6.2124D-24, 1199, 'R', & ! 1129
     &          3.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 2.2477751957D0, -7.293585431161D-05, -5.1496D-24, 1200, 'P', & ! 1130
     &          3.9D0,       -98.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1131,1140 ) &
     &             /                 &
     & 1.6433190081D0, -7.293569475205D-05, -7.2752D-24, 1201, 'R', & ! 1131
     &          0.4D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.7202419489D0, -7.293504414516D-05, -8.3380D-24, 1202, 'R', & ! 1132
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8618346316D0, -7.293503641949D-05, -7.2752D-24, 1203, 'R', & ! 1133
     &          0.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7202420071D0, -7.293502869382D-05, -6.2124D-24, 1204, 'P', & ! 1134
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293469208600D-05,  0.0000D+00, 1205, 'R', & ! 1135
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3935591105D0, -7.293468436046D-05, -1.0628D-24, 1207, 'R', & ! 1136
     &          1.7D0,         3.7D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293468436039D-05,  0.0000D+00, 1206, 'R', & ! 1137
     &         -1.6D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 1.3935591687D0, -7.293466890911D-05,  1.0628D-24, 1208, 'P', & ! 1138
     &         -0.8D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.3213932533D0, -7.293459225599D-05, -2.9966D-23, 1209, 'P', & ! 1139
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2567235696D0, -7.293393392343D-05, -2.9966D-23, 1210, 'P', & ! 1140
     &          0.0D0,         5.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1141,1150 ) &
     &             /                 &
     & 5.0544717269D0, -7.293378285950D-05, -1.0628D-24, 1212, 'R', & ! 1141
     &          0.2D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293378285944D-05,  0.0000D+00, 1211, 'R', & ! 1142
     &         -0.1D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293377513383D-05,  0.0000D+00, 1213, 'P', & ! 1143
     &         43.3D0,        41.5D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293376740822D-05,  0.0000D+00, 1215, 'P', & ! 1144
     &         -5.4D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 5.0544717850D0, -7.293376740816D-05,  1.0628D-24, 1214, 'P', & ! 1145
     &        -61.7D0,        18.1D0,        0.0D0,      0.0D0,     & !
     & 2.6459575759D0, -7.293296573735D-05,  2.8903D-23,  450, 'R', & ! 1146
     &          0.0D0,        -7.6D0,        0.0D0,      0.0D0,     & !
     & 1.3009604457D0, -7.293295622769D-05,  3.0505D-23,   72, 'R', & ! 1147
     &        -43.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8515650098D0, -7.293268885908D-05,  7.2752D-24, 1216, 'P', & ! 1148
     &          8.9D0,        12.8D0,        0.0D0,      0.0D0,     & !
     & 2.7099723853D0, -7.293268113341D-05,  8.3380D-24, 1217, 'P', & ! 1149
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4311086074D0, -7.293258933302D-05,  7.3420D-23, 1218, 'R', & ! 1150
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1151,1160 ) &
     &             /                 &
     & 0.5556206468D0, -7.293258472109D-05,  3.8314D-23, 1219, 'P', & ! 1151
     &        -12.8D0,        -6.3D0,        0.0D0,      0.0D0,     & !
     & 4.5727012900D0, -7.293258160735D-05,  7.4483D-23, 1220, 'R', & ! 1152
     &        -42.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2471088803D0, -7.293251384817D-05,  7.2752D-24, 1221, 'P', & ! 1153
     &          2.1D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.4605067739D0, -7.293235619098D-05,  7.4483D-23, 1222, 'R', & ! 1154
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8855207147D0, -7.293216174763D-05,  8.7970D-23, 1223, 'P', & ! 1155
     &         -0.8D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.1530410301D0, -7.293208865765D-05,  6.2124D-24, 1224, 'P', & ! 1156
     &          0.9D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 5.2946337128D0, -7.293208093198D-05,  7.2752D-24, 1225, 'P', & ! 1157
     &         16.5D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 5.3494097899D0, -7.293196715673D-05,  7.2752D-24, 1226, 'P', & ! 1158
     &         18.6D0,        66.0D0,        0.0D0,      0.0D0,     & !
     & 1.1951982524D0, -7.293195965360D-05, -2.3764D-23, 1227, 'P', & ! 1159
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8724334571D0, -7.293187453493D-05,  4.0723D-24,   73, 'R', & ! 1160
     &         39.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1161,1170 ) &
     &             /                 &
     & 2.1824391384D0, -7.293187096696D-05,  5.1496D-24, 1228, 'R', & ! 1161
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1824391966D0, -7.293185551561D-05,  7.2752D-24,    1, 'P', & ! 1162
     &   38905212.8D0,      6946.7D0,  6034833.5D0,   1039.7D0,     & !
     & 5.7756302433D0, -7.293183649630D-05,  1.0478D-23,  447, 'P', & ! 1163
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1696801408D0, -7.293175137762D-05,  3.8314D-23, 1229, 'P', & ! 1164
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2986539105D0, -7.293174387450D-05,  7.2752D-24, 1230, 'P', & ! 1165
     &        -19.0D0,        67.3D0,        0.0D0,      0.0D0,     & !
     & 5.3534299876D0, -7.293163009925D-05,  7.2752D-24, 1231, 'P', & ! 1166
     &        -17.3D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 2.2118373631D0, -7.293162237357D-05,  8.3380D-24, 1232, 'P', & ! 1167
     &          0.5D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.7625429857D0, -7.293154928359D-05, -7.3420D-23, 1233, 'P', & ! 1168
     &          1.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4009548201D0, -7.293119718306D-05,  7.2752D-24, 1234, 'P', & ! 1169
     &         -2.2D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.4160629427D0, -7.293117668054D-05,  1.0628D-24, 1235, 'P', & ! 1170
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1171,1180 ) &
     &             /                 &
     & 3.8092577464D0, -7.293112631014D-05, -2.3764D-23, 1236, 'P', & ! 1171
     &         15.3D0,        -7.6D0,        0.0D0,      0.0D0,     & !
     & 6.0571103528D0, -7.293103839345D-05,  3.7241D-23, 1237, 'R', & ! 1172
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7964986324D0, -7.293103762349D-05,  5.1496D-24, 1238, 'R', & ! 1173
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.6549060079D0, -7.293102989782D-05,  6.2124D-24, 1239, 'P', & ! 1174
     &          1.3D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 4.7964986906D0, -7.293102217215D-05,  7.2752D-24, 1240, 'P', & ! 1175
     &        -10.5D0,        14.8D0,        0.0D0,      0.0D0,     & !
     & 0.4300805784D0, -7.293087960385D-05,  6.7208D-23, 1241, 'R', & ! 1176
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1673934737D0, -7.293045831448D-05, -6.7208D-23, 1242, 'P', & ! 1177
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3230037922D0, -7.293015351211D-05,  0.0000D+00, 1243, 'R', & ! 1178
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5295793861D0, -7.293003030570D-05, -1.2425D-23, 1244, 'R', & ! 1179
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.5935919154D0, -7.292994362307D-05,  1.3488D-23, 1245, 'P', & ! 1180
     &         -2.0D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1181,1190 ) &
     &             /                 &
     & 2.4519992909D0, -7.292993589739D-05,  1.4550D-23, 1246, 'P', & ! 1181
     &          1.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.1081548236D0, -7.292977710779D-05,  4.4517D-23, 1247, 'P', & ! 1182
     &          0.0D0,         6.4D0,        0.0D0,      0.0D0,     & !
     & 0.0434851399D0, -7.292911877524D-05,  4.4517D-23, 1248, 'P', & ! 1183
     &         -0.9D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5698369127D0, -7.292886560978D-05,  0.0000D+00, 1249, 'R', & ! 1184
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5698369127D0, -7.292885015857D-05,  0.0000D+00, 1250, 'P', & ! 1185
     &         -0.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.9181562961D0, -7.292830165308D-05,  7.4483D-23, 1251, 'R', & ! 1186
     &         -2.3D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 3.3566674026D0, -7.292800314673D-05, -7.2752D-24, 1252, 'R', & ! 1187
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3566674608D0, -7.292798769538D-05, -5.1496D-24, 1253, 'P', & ! 1188
     &         -2.2D0,        -5.0D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292793304523D-05,  0.0000D+00, 1254, 'R', & ! 1189
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.2675758675D0, -7.292792531969D-05, -1.0628D-24, 1256, 'R', & ! 1190
     &          2.1D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1191,1200 ) &
     &             /                 &
     & 5.4091685502D0, -7.292792531962D-05,  0.0000D+00, 1255, 'R', & ! 1191
     &         -1.5D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292791759402D-05,  0.0000D+00, 1257, 'R', & ! 1192
     &          1.1D0,         5.4D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292790986841D-05,  0.0000D+00, 1259, 'P', & ! 1193
     &          1.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.2675759257D0, -7.292790986834D-05,  1.0628D-24, 1258, 'P', & ! 1194
     &        -39.3D0,        19.0D0,        0.0D0,      0.0D0,     & !
     & 2.1171031975D0, -7.292785671961D-05,  1.9700D-23, 1260, 'P', & ! 1195
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 4.0338704507D0, -7.292769869997D-05,  8.1758D-23, 1261, 'P', & ! 1196
     &          3.8D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4385667167D0, -7.292768445198D-05,  1.0628D-24, 1262, 'P', & ! 1197
     &         -1.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.3596069309D0, -7.292725421029D-05, -8.3380D-24, 1263, 'R', & ! 1198
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5011996136D0, -7.292724648462D-05, -7.2752D-24, 1264, 'R', & ! 1199
     &         -0.7D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 0.3596069891D0, -7.292723875895D-05, -6.2124D-24, 1265, 'R', & ! 1200
     &         -2.0D0,        -7.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1201,1210 ) &
     &             /                 &
     & 4.8393969488D0, -7.292694599169D-05,  5.1496D-24, 1266, 'R', & ! 1201
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8393970070D0, -7.292693054035D-05,  7.2752D-24, 1267, 'P', & ! 1202
     &         -3.4D0,        -1.6D0,        0.0D0,      0.0D0,     & !
     & 0.1908760093D0, -7.292687791783D-05, -4.3444D-23, 1268, 'R', & ! 1203
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.3324686920D0, -7.292687019216D-05, -4.2381D-23, 1269, 'P', & ! 1204
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2863506450D0, -7.292687008030D-05,  3.7241D-23, 1270, 'R', & ! 1205
     &         -5.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2231320363D0, -7.292674580925D-05, -7.4483D-23, 1271, 'P', & ! 1206
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2779081134D0, -7.292663203400D-05, -7.4483D-23, 1272, 'P', & ! 1207
     &          1.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 1.1109375201D0, -7.292652039288D-05, -7.4483D-23, 1273, 'P', & ! 1208
     &         33.7D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 4.2525302028D0, -7.292651266721D-05, -7.3420D-23, 1274, 'P', & ! 1209
     &          0.8D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 4.2130943010D0, -7.292650140165D-05,  8.0695D-23, 1275, 'R', & ! 1210
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1211,1220 ) &
     &             /                 &
     & 1.0715016765D0, -7.292649367598D-05,  8.1758D-23, 1276, 'P', & ! 1211
     &        -20.2D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 4.1877163904D0, -7.292638203486D-05,  8.1758D-23, 1277, 'P', & ! 1212
     &         -0.8D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.2819283111D0, -7.292629497652D-05, -7.4483D-23, 1278, 'P', & ! 1213
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.8176945591D0, -7.292614871235D-05, -7.4483D-23, 1279, 'R', & ! 1214
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292608352851D-05,  0.0000D+00, 1281, 'R', & ! 1215
     &          4.3D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292607580290D-05,  0.0000D+00, 1283, 'P', & ! 1216
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.4846348723D0, -7.292607580284D-05,  1.0628D-24, 1282, 'P', & ! 1217
     &          0.0D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292606807730D-05,  0.0000D+00, 1284, 'P', & ! 1218
     &          2.8D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 1.6037828724D0, -7.292591337619D-05,  0.0000D+00, 1285, 'R', & ! 1219
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7453754969D0, -7.292590565064D-05, -1.0628D-24, 1287, 'R', & ! 1220
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1221,1230 ) &
     &             /                 &
     & 1.6037828724D0, -7.292590565058D-05,  0.0000D+00, 1286, 'R', & ! 1221
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.8228322075D0, -7.292577530991D-05,  1.3488D-23, 1288, 'P', & ! 1222
     &          0.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.9644248902D0, -7.292576758424D-05,  1.4550D-23, 1289, 'P', & ! 1223
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.2901613705D0, -7.292532309456D-05, -7.5546D-23, 1290, 'R', & ! 1224
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4317540531D0, -7.292531536888D-05, -7.4483D-23, 1291, 'P', & ! 1225
     &         -7.5D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 3.2069286236D0, -7.292516507492D-05, -1.3488D-23, 1292, 'R', & ! 1226
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0653359991D0, -7.292515734925D-05, -1.2425D-23, 1293, 'R', & ! 1227
     &         -1.0D0,        22.5D0,        0.0D0,      0.0D0,     & !
     & 6.1980485781D0, -7.292510420052D-05,  6.2124D-24, 1294, 'P', & ! 1228
     &          4.0D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 3.0564559536D0, -7.292509647484D-05,  7.2752D-24, 1295, 'P', & ! 1229
     &         -0.9D0,         5.5D0,        0.0D0,      0.0D0,     & !
     & 6.1980486363D0, -7.292508874917D-05,  8.3380D-24, 1296, 'P', & ! 1230
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1231,1240 ) &
     &             /                 &
     & 5.1089570430D0, -7.292502637348D-05,  1.2425D-23, 1297, 'P', & ! 1231
     &          0.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5474682076D0, -7.292471241578D-05, -6.7208D-23, 1298, 'P', & ! 1232
     &          1.3D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 1.1190889087D0, -7.292464305614D-05,  1.0628D-24, 1299, 'P', & ! 1233
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 4.1321277828D0, -7.292443414753D-05,  4.3444D-23, 1300, 'P', & ! 1234
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.1484870170D0, -7.292442536545D-05,  0.0000D+00, 1301, 'R', & ! 1235
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.2900796997D0, -7.292441763978D-05,  1.0628D-24, 1302, 'P', & ! 1236
     &          0.0D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 2.6793954349D0, -7.292433945713D-05, -1.4550D-23, 1303, 'R', & ! 1237
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8957875911D0, -7.292416391029D-05,  7.2752D-24, 1304, 'P', & ! 1238
     &          0.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4943052211D0, -7.292398739809D-05, -8.3380D-24, 1305, 'R', & ! 1239
     &         -0.2D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 5.4943052792D0, -7.292397194675D-05, -6.2124D-24, 1306, 'R', & ! 1240
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1241,1250 ) &
     &             /                 &
     & 2.1389540567D0, -7.292389529362D-05, -3.7241D-23, 1307, 'P', & ! 1241
     &          1.5D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.9425980404D0, -7.292359073043D-05,  0.0000D+00, 1308, 'R', & ! 1242
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0841906649D0, -7.292358300488D-05, -1.0628D-24, 1310, 'R', & ! 1243
     &          0.5D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.9425980404D0, -7.292358300482D-05,  0.0000D+00, 1309, 'R', & ! 1244
     &         -2.1D0,        -2.5D0,        0.0D0,      0.0D0,     & !
     & 0.8018914362D0, -7.292352823911D-05,  0.0000D+00, 1311, 'R', & ! 1245
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.9434841189D0, -7.292352051344D-05,  1.0628D-24, 1312, 'P', & ! 1246
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.2919287411D0, -7.292339212916D-05,  7.2357D-23, 1313, 'R', & ! 1247
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.2456358103D0, -7.292325358068D-05, -7.4483D-23, 1314, 'P', & ! 1248
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3574696802D0, -7.292323696107D-05, -3.7241D-23, 1315, 'P', & ! 1249
     &          0.0D0,        12.6D0,        0.0D0,      0.0D0,     & !
     & 2.2158770557D0, -7.292322923539D-05, -3.6179D-23, 1316, 'P', & ! 1250
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1251,1260 ) &
     &             /                 &
     & 2.8720325302D0, -7.292308589714D-05, -8.3380D-24, 1317, 'R', & ! 1251
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.0136252129D0, -7.292307817147D-05, -7.2752D-24, 1318, 'R', & ! 1252
     &         15.3D0,        14.3D0,        0.0D0,      0.0D0,     & !
     & 2.8720325884D0, -7.292307044579D-05, -6.2124D-24, 1319, 'R', & ! 1253
     &         25.6D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 3.1334412941D0, -7.292302816431D-05, -7.4483D-23, 1320, 'P', & ! 1254
     &          0.6D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.1426207116D0, -7.292286055674D-05,  7.2752D-24, 1321, 'P', & ! 1255
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2982310300D0, -7.292255575438D-05,  7.4483D-23, 1322, 'R', & ! 1256
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4635183793D0, -7.292226877498D-05,  2.1628D-23,  446, 'R', & ! 1257
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.4017065562D0, -7.292225926532D-05,  2.3230D-23,  102, 'R', & ! 1258
     &          5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7523586182D0, -7.292213446501D-05, -5.9932D-23, 1323, 'P', & ! 1259
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5024566096D0, -7.292211006135D-05,  6.7208D-23, 1324, 'R', & ! 1260
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1261,1270 ) &
     &             /                 &
     & 0.5275331305D0, -7.292199962239D-05, -1.0628D-24, 1326, 'R', & ! 1261
     &         -0.4D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292199962232D-05,  0.0000D+00, 1325, 'R', & ! 1262
     &          1.2D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292199189671D-05,  0.0000D+00, 1327, 'R', & ! 1263
     &         22.7D0,        32.2D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292198417111D-05,  0.0000D+00, 1329, 'P', & ! 1264
     &         24.2D0,       -11.8D0,        0.0D0,      0.0D0,     & !
     & 0.5275331887D0, -7.292198417104D-05,  1.0628D-24, 1328, 'P', & ! 1265
     &       -271.1D0,       135.0D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292197644550D-05,  0.0000D+00, 1331, 'P', & ! 1266
     &          8.1D0,        35.3D0,        0.0D0,      0.0D0,     & !
     & 3.6691258714D0, -7.292197644537D-05,  2.1256D-24, 1330, 'P', & ! 1267
     &          0.0D0,         2.9D0,        0.0D0,      0.0D0,     & !
     & 2.4085141510D0, -7.292197567540D-05, -2.9966D-23, 1332, 'P', & ! 1268
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5147740747D0, -7.292189548440D-05,  2.9976D-23, 1333, 'R', & ! 1269
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.5318547179D0, -7.292189237066D-05,  6.6145D-23, 1334, 'R', & ! 1270
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1271,1280 ) &
     &             /                 &
     & 4.6563667574D0, -7.292188775872D-05,  3.1039D-23, 1335, 'R', & ! 1271
     &         21.8D0,         9.7D0,        0.0D0,      0.0D0,     & !
     & 2.3902620934D0, -7.292188464499D-05,  6.7208D-23, 1336, 'R', & ! 1272
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0495615611D0, -7.292183738832D-05,  6.2124D-24, 1337, 'P', & ! 1273
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 3.0646696837D0, -7.292181688580D-05,  0.0000D+00, 1338, 'R', & ! 1274
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5612528844D0, -7.292165922862D-05,  6.7208D-23, 1339, 'R', & ! 1275
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0827963497D0, -7.292161711165D-05, -1.0628D-24, 1340, 'R', & ! 1276
     &         -0.3D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.2148489685D0, -7.292153495757D-05, -4.4517D-23, 1341, 'R', & ! 1277
     &          0.9D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.4348356437D0, -7.292152250810D-05,  1.0628D-24, 1342, 'P', & ! 1278
     &          0.0D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 2.6770494183D0, -7.292150581813D-05,  4.3444D-23, 1343, 'P', & ! 1279
     &         -9.9D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 3.7030815181D0, -7.292146478527D-05,  8.0695D-23, 1344, 'P', & ! 1280
     &         -2.5D0,        -0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1281,1290 ) &
     &             /                 &
     & 3.1121945162D0, -7.292139942083D-05,  0.0000D+00, 1345, 'R', & ! 1281
     &         -1.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 6.2537871407D0, -7.292139169529D-05, -1.0628D-24, 1347, 'R', & ! 1282
     &        101.9D0,      -169.0D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292139169522D-05,  0.0000D+00, 1346, 'R', & ! 1283
     &       -326.1D0,       544.0D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292138396961D-05,  0.0000D+00, 1348, 'P', & ! 1284
     &         47.3D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292137624401D-05,  0.0000D+00, 1350, 'P', & ! 1285
     &          0.6D0,         7.3D0,        0.0D0,      0.0D0,     & !
     & 6.2537871989D0, -7.292137624394D-05,  1.0628D-24, 1349, 'P', & ! 1286
     &         -7.1D0,      -108.7D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292136851840D-05,  0.0000D+00, 1351, 'P', & ! 1287
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6044561295D0, -7.292131811294D-05,  0.0000D+00, 1352, 'P', & ! 1288
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2284092301D0, -7.292128777971D-05,  0.0000D+00, 1353, 'R', & ! 1289
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.0253779106D0, -7.292127792004D-05, -1.0628D-24, 1355, 'R', & ! 1290
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1291,1300 ) &
     &             /                 &
     & 3.1669705933D0, -7.292127791997D-05,  0.0000D+00, 1354, 'R', & ! 1291
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1669705933D0, -7.292127019436D-05,  0.0000D+00, 1356, 'P', & ! 1292
     &         44.5D0,       154.7D0,        0.0D0,      0.0D0,     & !
     & 0.1674965494D0, -7.292126770248D-05,  0.0000D+00, 1357, 'P', & ! 1293
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2959443630D0, -7.292126269124D-05, -3.1039D-23, 1358, 'P', & ! 1294
     &         21.1D0,         8.6D0,        0.0D0,      0.0D0,     & !
     & 3.1669705933D0, -7.292126246876D-05,  0.0000D+00, 1360, 'P', & ! 1295
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0253779688D0, -7.292126246869D-05,  1.0628D-24, 1359, 'P', & ! 1296
     &         25.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2284092301D0, -7.292125687728D-05,  0.0000D+00, 1361, 'P', & ! 1297
     &         -0.3D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 1.1407066042D0, -7.292122104456D-05,  0.0000D+00, 1362, 'R', & ! 1298
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.6899942605D0, -7.292117757256D-05, -3.2029D-24,   21, 'R', & ! 1299
     &       -230.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292117613860D-05,  0.0000D+00, 1363, 'R', & ! 1300
     &         -1.0D0,        -4.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1301,1310 ) &
     &             /                 &
     & 0.0000000000D0, -7.292117400446D-05,  0.0000D+00,  745, 'R', & ! 1301
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2217466703D0, -7.292117187033D-05,  0.0000D+00, 1364, 'R', & ! 1302
     &         -4.3D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 1.3449971302D0, -7.292116806290D-05, -1.6014D-24,  445, 'R', & ! 1303
     &          0.0D0,       215.3D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292116068738D-05,  0.0000D+00, 1365, 'R', & ! 1304
     &        138.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2217466703D0, -7.292115641911D-05,  0.0000D+00, 1365, 'P', & ! 1305
     &       -138.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9381881769D0, -7.292114904359D-05,  1.6014D-24,  445, 'P', & ! 1306
     &          0.0D0,      -598.7D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292114523616D-05,  0.0000D+00, 1364, 'P', & ! 1307
     &        -15.1D0,       -21.5D0,        0.0D0,      0.0D0,     & !
     & 0.0000000000D0, -7.292114310203D-05,  0.0000D+00,  745, 'P', & ! 1308
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2217466703D0, -7.292114096790D-05,  0.0000D+00, 1363, 'P', & ! 1309
     &        -25.1D0,        -4.1D0,        0.0D0,      0.0D0,     & !
     & 3.5931910467D0, -7.292113953393D-05,  3.2029D-24,   21, 'P', & ! 1310
     &      -6494.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1311,1320 ) &
     &             /                 &
     & 5.1424787030D0, -7.292109606193D-05,  0.0000D+00, 1362, 'P', & ! 1311
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.0547760771D0, -7.292106022921D-05,  0.0000D+00, 1361, 'R', & ! 1312
     &          0.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.2578073384D0, -7.292105463780D-05, -1.0628D-24, 1359, 'R', & ! 1313
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1162147139D0, -7.292105463774D-05,  0.0000D+00, 1360, 'R', & ! 1314
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9872409442D0, -7.292105441526D-05,  3.1039D-23, 1358, 'R', & ! 1315
     &        -21.1D0,         8.6D0,        0.0D0,      0.0D0,     & !
     & 6.1156887578D0, -7.292104940401D-05,  0.0000D+00, 1357, 'R', & ! 1316
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1162147139D0, -7.292104691213D-05,  0.0000D+00, 1356, 'R', & ! 1317
     &        -44.5D0,       154.7D0,        0.0D0,      0.0D0,     & !
     & 3.1162147139D0, -7.292103918652D-05,  0.0000D+00, 1354, 'P', & ! 1318
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2578073966D0, -7.292103918646D-05,  1.0628D-24, 1355, 'P', & ! 1319
     &        -22.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0547760771D0, -7.292102932678D-05,  0.0000D+00, 1353, 'P', & ! 1320
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1321,1330 ) &
     &             /                 &
     & 5.6787291777D0, -7.292099899355D-05,  0.0000D+00, 1352, 'R', & ! 1321
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292094858810D-05,  0.0000D+00, 1351, 'R', & ! 1322
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0293981083D0, -7.292094086255D-05, -1.0628D-24, 1349, 'R', & ! 1323
     &         -1.1D0,        15.9D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292094086249D-05,  0.0000D+00, 1350, 'R', & ! 1324
     &          3.3D0,       -49.4D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292093313688D-05,  0.0000D+00, 1348, 'R', & ! 1325
     &        -47.3D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292092541127D-05,  0.0000D+00, 1346, 'P', & ! 1326
     &        -47.7D0,       -79.5D0,        0.0D0,      0.0D0,     & !
     & 0.0293981665D0, -7.292092541121D-05,  1.0628D-24, 1347, 'P', & ! 1327
     &        696.6D0,      1157.0D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292091768566D-05,  0.0000D+00, 1345, 'P', & ! 1328
     &         -3.2D0,        -5.0D0,        0.0D0,      0.0D0,     & !
     & 2.5801037891D0, -7.292085232123D-05, -8.0695D-23, 1344, 'R', & ! 1329
     &          2.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.6061358889D0, -7.292081128836D-05, -4.3444D-23, 1343, 'R', & ! 1330
     &          9.9D0,        -5.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1331,1340 ) &
     &             /                 &
     & 3.8483496635D0, -7.292079459839D-05, -1.0628D-24, 1342, 'R', & ! 1331
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.0683363386D0, -7.292078214893D-05,  4.4517D-23, 1341, 'P', & ! 1332
     &          5.9D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 3.2003889575D0, -7.292069999484D-05,  1.0628D-24, 1340, 'P', & ! 1333
     &         -2.1D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 0.7219324227D0, -7.292065787787D-05, -6.7208D-23, 1339, 'P', & ! 1334
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2185156235D0, -7.292050022069D-05,  0.0000D+00, 1338, 'P', & ! 1335
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2336237461D0, -7.292047971818D-05, -6.2124D-24, 1337, 'R', & ! 1336
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 3.8929232137D0, -7.292043246151D-05, -6.7208D-23, 1336, 'P', & ! 1337
     &        -64.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6268185498D0, -7.292042934777D-05, -3.1039D-23, 1335, 'P', & ! 1338
     &        -21.8D0,         9.7D0,        0.0D0,      0.0D0,     & !
     & 0.7513305893D0, -7.292042473584D-05, -6.6145D-23, 1334, 'P', & ! 1339
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 4.7684112325D0, -7.292042162210D-05, -2.9976D-23, 1333, 'P', & ! 1340
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1341,1350 ) &
     &             /                 &
     & 3.8746711562D0, -7.292034143109D-05,  2.9966D-23, 1332, 'R', & ! 1341
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6140594358D0, -7.292034066113D-05, -2.1256D-24, 1330, 'R', & ! 1342
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292034066100D-05,  0.0000D+00, 1331, 'R', & ! 1343
     &          0.2D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 5.7556521185D0, -7.292033293545D-05, -1.0628D-24, 1328, 'R', & ! 1344
     &        -39.7D0,       -19.7D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292033293539D-05,  0.0000D+00, 1329, 'R', & ! 1345
     &        106.2D0,        52.7D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292032520978D-05,  0.0000D+00, 1327, 'P', & ! 1346
     &        -22.7D0,        32.2D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292031748417D-05,  0.0000D+00, 1325, 'P', & ! 1347
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.7556521767D0, -7.292031748411D-05,  1.0628D-24, 1326, 'P', & ! 1348
     &         -2.5D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.7807286976D0, -7.292020704514D-05, -6.7208D-23, 1324, 'P', & ! 1349
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5308266890D0, -7.292018264149D-05,  5.9932D-23, 1323, 'R', & ! 1350
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1351,1360 ) &
     &             /                 &
     & 0.8814787510D0, -7.292005784117D-05, -2.3230D-23,  102, 'P', & ! 1351
     &        119.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196669279D0, -7.292004833151D-05, -2.1628D-23,  446, 'P', & ! 1352
     &          0.0D0,       -12.6D0,        0.0D0,      0.0D0,     & !
     & 1.9849542771D0, -7.291976135211D-05, -7.4483D-23, 1322, 'P', & ! 1353
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1405645956D0, -7.291945654975D-05, -7.2752D-24, 1321, 'R', & ! 1354
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1497440130D0, -7.291928894218D-05,  7.4483D-23, 1320, 'R', & ! 1355
     &         -0.6D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.4111527188D0, -7.291924666070D-05,  6.2124D-24, 1319, 'P', & ! 1356
     &        -25.6D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 0.2695600943D0, -7.291923893503D-05,  7.2752D-24, 1318, 'P', & ! 1357
     &        104.0D0,       -98.2D0,        0.0D0,      0.0D0,     & !
     & 3.4111527769D0, -7.291923120936D-05,  8.3380D-24, 1317, 'P', & ! 1358
     &          0.0D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 4.0673082515D0, -7.291908787110D-05,  3.6179D-23, 1316, 'R', & ! 1359
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9257156270D0, -7.291908014543D-05,  3.7241D-23, 1315, 'R', & ! 1360
     &          0.0D0,        12.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1361,1370 ) &
     &             /                 &
     & 0.0375494969D0, -7.291906352581D-05,  7.4483D-23, 1314, 'R', & ! 1361
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9912565661D0, -7.291892497733D-05, -7.2357D-23, 1313, 'P', & ! 1362
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.3397011883D0, -7.291879659306D-05, -1.0628D-24, 1312, 'R', & ! 1363
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4812938710D0, -7.291878886738D-05,  0.0000D+00, 1311, 'P', & ! 1364
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.3405872668D0, -7.291873410168D-05,  0.0000D+00, 1309, 'P', & ! 1365
     &         -0.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1989946423D0, -7.291873410161D-05,  1.0628D-24, 1310, 'P', & ! 1366
     &          3.8D0,        -4.3D0,        0.0D0,      0.0D0,     & !
     & 4.3405872668D0, -7.291872637607D-05,  0.0000D+00, 1308, 'P', & ! 1367
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1442312505D0, -7.291842181287D-05,  3.7241D-23, 1307, 'R', & ! 1368
     &         -1.5D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.7888800279D0, -7.291834515975D-05,  6.2124D-24, 1306, 'P', & ! 1369
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.7888800861D0, -7.291832970840D-05,  8.3380D-24, 1305, 'P', & ! 1370
     &         -2.3D0,         5.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1371,1380 ) &
     &             /                 &
     & 2.3873977161D0, -7.291815319620D-05, -7.2752D-24, 1304, 'R', & ! 1371
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6037898722D0, -7.291797764937D-05,  1.4550D-23, 1303, 'P', & ! 1372
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9931056075D0, -7.291789946672D-05, -1.0628D-24, 1302, 'R', & ! 1373
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.1346982902D0, -7.291789174105D-05,  0.0000D+00, 1301, 'P', & ! 1374
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1510575243D0, -7.291788295896D-05, -4.3444D-23, 1300, 'R', & ! 1375
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.1640963985D0, -7.291767405035D-05, -1.0628D-24, 1299, 'R', & ! 1376
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7357170995D0, -7.291760469071D-05,  6.7208D-23, 1298, 'R', & ! 1377
     &          0.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.1742282642D0, -7.291729073302D-05, -1.2425D-23, 1297, 'R', & ! 1378
     &         -0.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.2267293536D0, -7.291722063165D-05, -7.2752D-24, 1295, 'R', & ! 1379
     &         -0.1D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.0851367291D0, -7.291721290598D-05, -6.2124D-24, 1294, 'R', & ! 1380
     &         -4.0D0,         1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1381,1390 ) &
     &             /                 &
     & 6.2178493080D0, -7.291715975725D-05,  1.2425D-23, 1293, 'P', & ! 1381
     &          1.0D0,        22.5D0,        0.0D0,      0.0D0,     & !
     & 3.0762566835D0, -7.291715203157D-05,  1.3488D-23, 1292, 'P', & ! 1382
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8514312540D0, -7.291700173761D-05,  7.4483D-23, 1291, 'R', & ! 1383
     &          7.5D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 4.9930239367D0, -7.291699401194D-05,  7.5546D-23, 1290, 'P', & ! 1384
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.3187604169D0, -7.291654952226D-05, -1.4550D-23, 1289, 'R', & ! 1385
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4603530996D0, -7.291654179658D-05, -1.3488D-23, 1288, 'R', & ! 1386
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6794024348D0, -7.291641145591D-05,  0.0000D+00, 1286, 'P', & ! 1387
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.5378098103D0, -7.291641145585D-05,  1.0628D-24, 1287, 'P', & ! 1388
     &         -0.2D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 4.6794024348D0, -7.291640373031D-05,  0.0000D+00, 1285, 'P', & ! 1389
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291624902920D-05,  0.0000D+00, 1284, 'R', & ! 1390
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1391,1400 ) &
     &             /                 &
     & 5.7985504348D0, -7.291624130365D-05, -1.0628D-24, 1282, 'R', & ! 1391
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291624130359D-05,  0.0000D+00, 1283, 'R', & ! 1392
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291623357798D-05,  0.0000D+00, 1281, 'P', & ! 1393
     &         -4.3D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 4.4654907480D0, -7.291616839414D-05,  7.4483D-23, 1279, 'P', & ! 1394
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0012569960D0, -7.291602212998D-05,  7.4483D-23, 1278, 'R', & ! 1395
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0954689168D0, -7.291593507163D-05, -8.1758D-23, 1277, 'R', & ! 1396
     &         -0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.2116836307D0, -7.291582343052D-05, -8.1758D-23, 1276, 'R', & ! 1397
     &         -3.1D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 2.0700910062D0, -7.291581570484D-05, -8.0695D-23, 1275, 'P', & ! 1398
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0306551044D0, -7.291580443929D-05,  7.3420D-23, 1274, 'R', & ! 1399
     &          0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.1722477870D0, -7.291579671361D-05,  7.4483D-23, 1273, 'R', & ! 1400
     &        -33.7D0,        -6.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1401,1410 ) &
     &             /                 &
     & 2.0052771938D0, -7.291568507250D-05,  7.4483D-23, 1272, 'R', & ! 1401
     &         -1.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 2.0600532709D0, -7.291557129725D-05,  7.4483D-23, 1271, 'R', & ! 1402
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9968346622D0, -7.291544702620D-05, -3.7241D-23, 1270, 'P', & ! 1403
     &          5.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9507166152D0, -7.291544691434D-05,  4.2381D-23, 1269, 'R', & ! 1404
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0923092978D0, -7.291543918867D-05,  4.3444D-23, 1268, 'P', & ! 1405
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 1.4437883002D0, -7.291538656615D-05, -7.2752D-24, 1267, 'R', & ! 1406
     &         -0.5D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.4437883584D0, -7.291537111480D-05, -5.1496D-24, 1266, 'P', & ! 1407
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9235783181D0, -7.291507834755D-05,  6.2124D-24, 1265, 'P', & ! 1408
     &          2.0D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 2.7819856936D0, -7.291507062187D-05,  7.2752D-24, 1264, 'P', & ! 1409
     &         -4.6D0,       -15.7D0,        0.0D0,      0.0D0,     & !
     & 5.9235783763D0, -7.291506289620D-05,  8.3380D-24, 1263, 'P', & ! 1410
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1411,1420 ) &
     &             /                 &
     & 0.8446185905D0, -7.291463265452D-05, -1.0628D-24, 1262, 'R', & ! 1411
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.2493148565D0, -7.291461840652D-05, -8.1758D-23, 1261, 'R', & ! 1412
     &          0.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1660821097D0, -7.291446038688D-05, -1.9700D-23, 1260, 'R', & ! 1413
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.0156093815D0, -7.291440723815D-05, -1.0628D-24, 1258, 'R', & ! 1414
     &         -5.8D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291440723809D-05,  0.0000D+00, 1259, 'R', & ! 1415
     &          7.2D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439951248D-05,  0.0000D+00, 1257, 'P', & ! 1416
     &         -1.1D0,         5.4D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439178687D-05,  0.0000D+00, 1255, 'P', & ! 1417
     &        -10.6D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 4.0156094397D0, -7.291439178681D-05,  1.0628D-24, 1256, 'P', & ! 1418
     &         14.8D0,        -2.6D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291438406126D-05,  0.0000D+00, 1254, 'P', & ! 1419
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.9265178464D0, -7.291432941111D-05,  5.1496D-24, 1253, 'R', & ! 1420
     &         -0.2D0,         0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1421,1430 ) &
     &             /                 &
     & 2.9265179046D0, -7.291431395976D-05,  7.2752D-24, 1252, 'P', & ! 1421
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3650290110D0, -7.291401545342D-05, -7.4483D-23, 1251, 'P', & ! 1422
     &          2.3D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 1.7133483945D0, -7.291346694793D-05,  0.0000D+00, 1250, 'R', & ! 1423
     &          0.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 1.7133483945D0, -7.291345149671D-05,  0.0000D+00, 1249, 'P', & ! 1424
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2397001673D0, -7.291319833126D-05, -4.4517D-23, 1248, 'R', & ! 1425
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1750304835D0, -7.291253999870D-05, -4.4517D-23, 1247, 'R', & ! 1426
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.8311860163D0, -7.291238120910D-05, -1.4550D-23, 1246, 'R', & ! 1427
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.6895933918D0, -7.291237348343D-05, -1.3488D-23, 1245, 'R', & ! 1428
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7536059210D0, -7.291228680080D-05,  1.2425D-23, 1244, 'P', & ! 1429
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.9601815150D0, -7.291216359438D-05,  0.0000D+00, 1243, 'P', & ! 1430
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1431,1440 ) &
     &             /                 &
     & 2.1157918334D0, -7.291185879202D-05,  6.7208D-23, 1242, 'R', & ! 1431
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8531047287D0, -7.291143750264D-05, -6.7208D-23, 1241, 'P', & ! 1432
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4866866166D0, -7.291129493435D-05, -7.2752D-24, 1240, 'R', & ! 1433
     &         -1.6D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 4.6282792992D0, -7.291128720868D-05, -6.2124D-24, 1239, 'R', & ! 1434
     &         -1.3D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 1.4866866747D0, -7.291127948300D-05, -5.1496D-24, 1238, 'P', & ! 1435
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.2260749543D0, -7.291127871304D-05, -3.7241D-23, 1237, 'P', & ! 1436
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4739275608D0, -7.291119079636D-05,  2.3764D-23, 1236, 'R', & ! 1437
     &          2.2D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.8671223645D0, -7.291114042595D-05, -1.0628D-24, 1235, 'R', & ! 1438
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.8822304871D0, -7.291111992344D-05, -7.2752D-24, 1234, 'R', & ! 1439
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.5206423214D0, -7.291076782290D-05,  7.3420D-23, 1233, 'R', & ! 1440
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1441,1450 ) &
     &             /                 &
     & 4.0713479441D0, -7.291069473292D-05, -8.3380D-24, 1232, 'R', & ! 1441
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9297553196D0, -7.291068700725D-05, -7.2752D-24, 1231, 'R', & ! 1442
     &         -2.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.9845313966D0, -7.291057323200D-05, -7.2752D-24, 1230, 'R', & ! 1443
     &         -2.8D0,        -9.8D0,        0.0D0,      0.0D0,     & !
     & 3.1135051664D0, -7.291056572887D-05, -3.8314D-23, 1229, 'R', & ! 1444
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5075550639D0, -7.291048061020D-05, -1.0478D-23,  447, 'R', & ! 1445
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1007461106D0, -7.291046159088D-05, -7.2752D-24,    1, 'R', & ! 1446
     &    5723016.7D0,      -508.3D0, -4638967.8D0,    732.5D0,     & !
     & 4.1007461687D0, -7.291044613954D-05, -5.1496D-24, 1228, 'P', & ! 1447
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4107518501D0, -7.291044257157D-05, -4.0723D-24,   73, 'P', & ! 1448
     &        286.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0879870548D0, -7.291035745289D-05,  2.3764D-23, 1227, 'R', & ! 1449
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9337755173D0, -7.291034994976D-05, -7.2752D-24, 1226, 'R', & ! 1450
     &          2.8D0,        -9.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1451,1460 ) &
     &             /                 &
     & 0.9885515944D0, -7.291023617452D-05, -7.2752D-24, 1225, 'R', & ! 1451
     &          2.4D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.1301442771D0, -7.291022844884D-05, -6.2124D-24, 1224, 'R', & ! 1452
     &         -0.9D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 0.3976645925D0, -7.291015535886D-05, -8.7970D-23, 1223, 'R', & ! 1453
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.8226785333D0, -7.290996091551D-05, -7.4483D-23, 1222, 'P', & ! 1454
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0360764268D0, -7.290980325833D-05, -7.2752D-24, 1221, 'R', & ! 1455
     &          0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7104840171D0, -7.290973549914D-05, -7.4483D-23, 1220, 'P', & ! 1456
     &         42.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7275646604D0, -7.290973238541D-05, -3.8314D-23, 1219, 'R', & ! 1457
     &         -1.8D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.8520766998D0, -7.290972777347D-05, -7.3420D-23, 1218, 'P', & ! 1458
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.5732129219D0, -7.290963597309D-05, -8.3380D-24, 1217, 'R', & ! 1459
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4316202974D0, -7.290962824741D-05, -7.2752D-24, 1216, 'R', & ! 1460
     &          1.2D0,        -1.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1461,1470 ) &
     &             /                 &
     & 4.9822248615D0, -7.290936087881D-05, -3.0505D-23,   72, 'P', & ! 1461
     &       -296.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6372277313D0, -7.290935136915D-05, -2.8903D-23,  450, 'P', & ! 1462
     &          0.0D0,        77.8D0,        0.0D0,      0.0D0,     & !
     & 1.2287135221D0, -7.290854969834D-05, -1.0628D-24, 1214, 'R', & ! 1463
     &         -9.1D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290854969827D-05,  0.0000D+00, 1215, 'R', & ! 1464
     &         -0.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290854197266D-05,  0.0000D+00, 1213, 'R', & ! 1465
     &        -43.3D0,        41.5D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290853424706D-05,  0.0000D+00, 1211, 'P', & ! 1466
     &         -1.3D0,        10.6D0,        0.0D0,      0.0D0,     & !
     & 1.2287135803D0, -7.290853424699D-05,  1.0628D-24, 1212, 'P', & ! 1467
     &          1.7D0,       -10.6D0,        0.0D0,      0.0D0,     & !
     & 5.0264617376D0, -7.290838318306D-05,  2.9966D-23, 1210, 'R', & ! 1468
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 1.9617920539D0, -7.290772485051D-05,  2.9966D-23, 1209, 'R', & ! 1469
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8896261385D0, -7.290764819738D-05, -1.0628D-24, 1208, 'R', & ! 1470
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1471,1480 ) &
     &             /                 &
     & 1.7480335140D0, -7.290763274610D-05,  0.0000D+00, 1206, 'P', & ! 1471
     &        -11.5D0,        25.8D0,        0.0D0,      0.0D0,     & !
     & 4.8896261967D0, -7.290763274604D-05,  1.0628D-24, 1207, 'P', & ! 1472
     &         10.9D0,       -24.9D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290762502049D-05,  0.0000D+00, 1205, 'P', & ! 1473
     &         26.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5629433001D0, -7.290728841268D-05,  6.2124D-24, 1204, 'R', & ! 1474
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.4213506756D0, -7.290728068700D-05,  7.2752D-24, 1203, 'P', & ! 1475
     &          4.7D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 4.5629433583D0, -7.290727296133D-05,  8.3380D-24, 1202, 'P', & ! 1476
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.6398662991D0, -7.290662235445D-05,  7.2752D-24, 1201, 'P', & ! 1477
     &          2.5D0,        -4.7D0,        0.0D0,      0.0D0,     & !
     & 4.0354101114D0, -7.290646279488D-05,  5.1496D-24, 1200, 'R', & ! 1478
     &          0.4D0,        14.4D0,        0.0D0,      0.0D0,     & !
     & 0.8938174869D0, -7.290645506921D-05,  6.2124D-24, 1199, 'P', & ! 1479
     &         -3.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 4.0354101696D0, -7.290644734354D-05,  7.2752D-24, 1198, 'P', & ! 1480
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1481,1490 ) &
     &             /                 &
     & 5.9521773646D0, -7.290630477524D-05,  6.7208D-23, 1197, 'R', & ! 1481
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4745186137D0, -7.290553661562D-05, -7.2752D-24, 1196, 'R', & ! 1482
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9898085904D0, -7.290509975125D-05,  6.7208D-23, 1195, 'R', & ! 1483
     &          1.7D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1060233044D0, -7.290498811013D-05,  6.7208D-23, 1194, 'R', & ! 1484
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.8143954655D0, -7.290475006383D-05, -4.4517D-23, 1193, 'R', & ! 1485
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7117410132D0, -7.290459907587D-05,  0.0000D+00, 1192, 'P', & ! 1486
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.7411391215D0, -7.290438138518D-05, -1.0628D-24, 1191, 'R', & ! 1487
     &          1.7D0,        -6.3D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290438138512D-05,  0.0000D+00, 1190, 'R', & ! 1488
     &          0.4D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290437365951D-05,  0.0000D+00, 1189, 'P', & ! 1489
     &          8.8D0,        23.9D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290436593390D-05,  0.0000D+00, 1188, 'P', & ! 1490
     &         -1.3D0,        12.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1491,1500 ) &
     &             /                 &
     & 3.7411391797D0, -7.290436593384D-05,  1.0628D-24, 1187, 'P', & ! 1491
     &          1.3D0,       -10.6D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290435820829D-05,  0.0000D+00, 1185, 'P', & ! 1492
     &        -10.6D0,         4.6D0,        0.0D0,      0.0D0,     & !
     & 1.8331701849D0, -7.290371027579D-05, -8.3380D-24, 1184, 'R', & ! 1493
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9747628676D0, -7.290370255011D-05, -7.2752D-24, 1183, 'R', & ! 1494
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.8331702431D0, -7.290369482444D-05, -6.2124D-24, 1182, 'R', & ! 1495
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7440787080D0, -7.290363244862D-05,  0.0000D+00, 1181, 'R', & ! 1496
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7440787080D0, -7.290361699740D-05,  0.0000D+00, 1180, 'P', & ! 1497
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1825898144D0, -7.290331849105D-05, -8.1758D-23, 1179, 'R', & ! 1498
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0136387440D0, -7.290171283053D-05,  5.1496D-24, 1178, 'R', & ! 1499
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.8543520316D0, -7.290158983843D-05,  5.1496D-24, 1177, 'R', & ! 1500
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1501,1510 ) &
     &             /                 &
     & 0.4521499087D0, -7.290139887283D-05, -7.4483D-23, 1176, 'P', & ! 1501
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7342447872D0, -7.290110684731D-05,  0.0000D+00, 1175, 'P', & ! 1502
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6220502710D0, -7.290087370533D-05,  0.0000D+00, 1173, 'P', & ! 1503
     &         -1.7D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.7636429537D0, -7.290087370527D-05,  1.0628D-24, 1174, 'P', & ! 1504
     &          1.7D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.6220502710D0, -7.290086597973D-05,  0.0000D+00, 1172, 'P', & ! 1505
     &          0.0D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 3.6706655321D0, -7.290074054028D-05, -7.4483D-23, 1171, 'P', & ! 1506
     &         13.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0852775072D0, -7.289987626963D-05, -1.4550D-23, 1170, 'R', & ! 1507
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.9183069139D0, -7.289976462852D-05, -1.4550D-23,    4, 'R', & ! 1508
     &     -17521.6D0,         3.2D0,    42427.5D0,      0.0D0,     & !
     & 5.5114979606D0, -7.289974560920D-05, -1.1348D-23,  225, 'R', & ! 1509
     &         -9.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0345216279D0, -7.289965298740D-05, -1.4550D-23, 1169, 'R', & ! 1510
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1511,1520 ) &
     &             /                 &
     & 5.8112301277D0, -7.289903853678D-05, -8.1758D-23, 1168, 'R', & ! 1511
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7997856649D0, -7.289866391644D-05, -3.7780D-23,   64, 'P', & ! 1512
     &       -318.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.4547885347D0, -7.289865440678D-05, -3.6179D-23,  451, 'P', & ! 1513
     &          0.0D0,      -316.7D0,        0.0D0,      0.0D0,     & !
     & 0.1097914044D0, -7.289864489713D-05, -3.4577D-23,  452, 'P', & ! 1514
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2399395661D0, -7.289827800246D-05,  8.3380D-24, 1167, 'P', & ! 1515
     &          0.0D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.3294596327D0, -7.289785273597D-05, -8.3380D-24, 1166, 'R', & ! 1516
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1878670082D0, -7.289784501030D-05, -7.2752D-24, 1165, 'R', & ! 1517
     &          1.3D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 5.3294596909D0, -7.289783728463D-05, -6.2124D-24, 1164, 'R', & ! 1518
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.6812644159D0, -7.289756320437D-05, -6.1010D-23,  453, 'P', & ! 1519
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7071870001D0, -7.289693578367D-05, -6.2124D-24, 1163, 'R', & ! 1520
     &         -0.4D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1521,1530 ) &
     &             /                 &
     & 5.8487796827D0, -7.289692805800D-05, -5.1496D-24, 1162, 'P', & ! 1521
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3805041035D0, -7.289659145031D-05, -1.0628D-24, 1161, 'R', & ! 1522
     &          0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289659145025D-05,  0.0000D+00, 1160, 'R', & ! 1523
     &          0.4D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289658372464D-05,  0.0000D+00, 1159, 'R', & ! 1524
     &        -14.0D0,         4.5D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289657599903D-05,  0.0000D+00, 1157, 'P', & ! 1525
     &         -2.8D0,       -11.0D0,        0.0D0,      0.0D0,     & !
     & 2.3805041617D0, -7.289657599896D-05,  1.0628D-24, 1158, 'P', & ! 1526
     &          2.2D0,         8.9D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289656827342D-05,  0.0000D+00, 1156, 'P', & ! 1527
     &        416.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220968444D0, -7.289656827329D-05,  2.1256D-24, 1155, 'P', & ! 1528
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5990197270D0, -7.289593311775D-05, -1.0628D-24, 1152, 'R', & ! 1529
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289593311769D-05,  0.0000D+00, 1153, 'R', & ! 1530
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1531,1540 ) &
     &             /                 &
     & 2.4574271025D0, -7.289592539208D-05,  0.0000D+00, 1151, 'R', & ! 1531
     &         -8.3D0,        14.8D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289591766647D-05,  0.0000D+00, 1148, 'P', & ! 1532
     &          3.0D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 5.5990197851D0, -7.289591766641D-05,  1.0628D-24, 1149, 'P', & ! 1533
     &         -2.1D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289590994086D-05,  0.0000D+00, 1147, 'P', & ! 1534
     &         10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8529709148D0, -7.289576583252D-05, -2.1256D-24, 1145, 'R', & ! 1535
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289576583239D-05,  0.0000D+00, 1146, 'R', & ! 1536
     &          0.2D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 4.9945635975D0, -7.289575810684D-05, -1.0628D-24, 1142, 'R', & ! 1537
     &         -4.7D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289575810678D-05,  0.0000D+00, 1141, 'R', & ! 1538
     &         -2.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289575038117D-05,  0.0000D+00, 1140, 'P', & ! 1539
     &          1.3D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 1.5586999249D0, -7.289368442282D-05, -8.3380D-24, 1139, 'R', & ! 1540
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1541,1550 ) &
     &             /                 &
     & 4.7002926076D0, -7.289367669714D-05, -7.2752D-24, 1138, 'R', & ! 1541
     &         -0.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.5586999831D0, -7.289366897147D-05, -6.2124D-24, 1137, 'R', & ! 1542
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.7002926657D0, -7.289366124580D-05, -5.1496D-24, 1136, 'P', & ! 1543
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1143849128D0, -7.289101586803D-05,  0.0000D+00, 1135, 'R', & ! 1544
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.1143849128D0, -7.289100041682D-05,  0.0000D+00, 1134, 'P', & ! 1545
     &         -0.9D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 3.6719128932D0, -7.289089287594D-05,  0.0000D+00, 1133, 'R', & ! 1546
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6719128932D0, -7.289087742472D-05,  0.0000D+00, 1132, 'P', & ! 1547
     &         -0.5D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.4882263355D0, -7.289004357791D-05, -8.1758D-23, 1131, 'R', & ! 1548
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1615434971D0, -7.288968379320D-05, -7.4483D-23, 1130, 'P', & ! 1549
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3839449489D0, -7.288909624994D-05,  5.1496D-24, 1129, 'R', & ! 1550
     &         -0.2D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1551,1560 ) &
     &             /                 &
     & 6.0190530245D0, -7.288906766615D-05, -2.1826D-23,  164, 'R', & ! 1551
     &        -10.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5555346452D0, -7.288795744442D-05, -4.3454D-23,  454, 'P', & ! 1552
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 4.2105375150D0, -7.288794793476D-05, -4.1852D-23,  226, 'P', & ! 1553
     &        -15.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3112875102D0, -7.288779873092D-05,  0.0000D+00, 1128, 'P', & ! 1554
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758876577D-05,  0.0000D+00, 1127, 'P', & ! 1555
     &          2.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758104016D-05,  0.0000D+00, 1126, 'P', & ! 1556
     &        -11.5D0,        61.4D0,        0.0D0,      0.0D0,     & !
     & 4.3406856767D0, -7.288758104010D-05,  1.0628D-24, 1125, 'P', & ! 1557
     &          6.0D0,       -32.5D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288757331455D-05,  0.0000D+00, 1123, 'P', & ! 1558
     &        234.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1990930522D0, -7.288757331442D-05,  2.1256D-24, 1122, 'P', & ! 1559
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3700837850D0, -7.288734789819D-05,  0.0000D+00, 1121, 'P', & ! 1560
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1561,1570 ) &
     &             /                 &
     & 1.4988252192D0, -7.288686624200D-05, -6.8285D-23,  242, 'P', & ! 1561
     &          8.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3396575896D0, -7.288588676227D-05, -7.2752D-24, 1120, 'R', & ! 1562
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.1980649651D0, -7.288587903660D-05, -6.2124D-24, 1119, 'R', & ! 1563
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3396576477D0, -7.288587131093D-05, -5.1496D-24, 1118, 'P', & ! 1564
     &        -26.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2749879058D0, -7.288522842972D-05, -7.2752D-24, 1117, 'R', & ! 1565
     &          0.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.2749879640D0, -7.288521297837D-05, -5.1496D-24, 1116, 'P', & ! 1566
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288330881150D-05,  0.0000D+00, 1114, 'R', & ! 1567
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288330108589D-05,  0.0000D+00, 1113, 'P', & ! 1568
     &          2.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 3.6861406828D0, -7.288330108582D-05,  1.0628D-24, 1112, 'P', & ! 1569
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288329336028D-05,  0.0000D+00, 1110, 'P', & ! 1570
     &          4.7D0,        -2.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1571,1580 ) &
     &             /                 &
     & 0.1327289659D0, -7.288188024060D-05,  6.2124D-24, 1109, 'P', & ! 1571
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2743216486D0, -7.288187251493D-05,  7.2752D-24, 1108, 'P', & ! 1572
     &          0.0D0,        -7.2D0,        0.0D0,      0.0D0,     & !
     & 3.2015058104D0, -7.287839928745D-05,  0.0000D+00, 1107, 'R', & ! 1573
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.2015058104D0, -7.287839156184D-05,  0.0000D+00, 1106, 'R', & ! 1574
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2015058104D0, -7.287838383623D-05,  0.0000D+00, 1105, 'P', & ! 1575
     &         -0.7D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 3.3730954486D0, -7.287726048205D-05, -5.0729D-23,  448, 'R', & ! 1576
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.0280983184D0, -7.287725097240D-05, -4.9128D-23,  319, 'R', & ! 1577
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1582464801D0, -7.287688407773D-05, -6.2124D-24, 1104, 'R', & ! 1578
     &         -0.3D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 5.2998391627D0, -7.287687635206D-05, -5.1496D-24, 1103, 'P', & ! 1579
     &        -11.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5995713298D0, -7.287616927964D-05, -7.5560D-23,  171, 'P', & ! 1580
     &         22.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1581,1590 ) &
     &             /                 &
     & 6.0511696938D0, -7.287615798599D-05, -7.3420D-23, 1102, 'P', & ! 1581
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 2.9095770693D0, -7.287615026032D-05, -7.2357D-23,   53, 'P', & ! 1582
     &        613.9D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1572184511D0, -7.287517434856D-05, -1.2425D-23, 1101, 'R', & ! 1583
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7610082652D0, -7.287200117042D-05,  0.0000D+00, 1100, 'P', & ! 1584
     &          0.2D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.7610082652D0, -7.287199344481D-05,  0.0000D+00, 1099, 'P', & ! 1585
     &         -5.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287119100378D-05,  0.0000D+00, 1098, 'R', & ! 1586
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.2334750765D0, -7.287118327823D-05, -1.0628D-24, 1096, 'R', & ! 1587
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287118327817D-05,  0.0000D+00, 1097, 'R', & ! 1588
     &         -1.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287117555256D-05,  0.0000D+00, 1095, 'P', & ! 1589
     &         -0.8D0,        59.2D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287116782695D-05,  0.0000D+00, 1094, 'P', & ! 1590
     &         -0.8D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1591,1600 ) &
     &             /                 &
     & 1.7986394910D0, -7.287079614642D-05,  0.0000D+00, 1093, 'P', & ! 1591
     &         -1.5D0,         5.1D0,        0.0D0,      0.0D0,     & !
     & 4.9402321737D0, -7.287079614636D-05,  1.0628D-24, 1092, 'P', & ! 1592
     &          0.8D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 1.7986394910D0, -7.287078842082D-05,  0.0000D+00, 1090, 'P', & ! 1593
     &         25.6D0,         4.2D0,        0.0D0,      0.0D0,     & !
     & 4.9148542049D0, -7.287069223091D-05,  0.0000D+00, 1089, 'R', & ! 1594
     &          0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.9148542049D0, -7.287067677970D-05,  0.0000D+00, 1088, 'P', & ! 1595
     &          1.3D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.1173999661D0, -7.286617938969D-05, -1.2425D-23, 1087, 'R', & ! 1596
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2886267081D0, -7.286578270687D-05,  0.0000D+00, 1086, 'R', & ! 1597
     &         -0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.2886267081D0, -7.286577498126D-05,  0.0000D+00, 1085, 'R', & ! 1598
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2886267081D0, -7.286576725565D-05,  0.0000D+00, 1084, 'P', & ! 1599
     &          0.0D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 3.4171321332D0, -7.286547231727D-05, -8.2835D-23,  449, 'R', & ! 1600
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1601,1610 ) &
     &             /                 &
     & 0.7271378727D0, -7.286545329795D-05, -7.9632D-23,   18, 'P', & ! 1601
     &     -10300.2D0,         7.8D0,    -2295.9D0,      0.0D0,     & !
     & 5.1926285626D0, -7.286047859020D-05, -7.2752D-24, 1083, 'R', & ! 1602
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 5.8993856597D0, -7.286009145832D-05, -5.1496D-24, 1082, 'P', & ! 1603
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0019751026D0, -7.285806019912D-05,  0.0000D+00, 1081, 'P', & ! 1604
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.5132331276D0, -7.285729768632D-05,  7.2752D-24, 1080, 'P', & ! 1605
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.8278839833D0, -7.285475633559D-05, -8.6908D-23,   37, 'P', & ! 1606
     &       1088.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.3981859880D0, -7.285400352708D-05,  0.0000D+00, 1079, 'P', & ! 1607
     &          1.8D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.7093627342D0, -7.285365562351D-05, -1.1014D-22,  320, 'P', & ! 1608
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6589329129D0, -7.285316612628D-05,  0.0000D+00, 1078, 'R', & ! 1609
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6589329129D0, -7.285315840067D-05,  0.0000D+00, 1077, 'R', & ! 1610
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1611,1620 ) &
     &             /                 &
     & 5.6589329129D0, -7.285315067507D-05,  0.0000D+00, 1076, 'P', & ! 1611
     &          1.9D0,         3.3D0,        0.0D0,      0.0D0,     & !
     & 3.4723865555D0, -7.284660844962D-05, -1.0628D-24, 1074, 'R', & ! 1612
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284660844956D-05,  0.0000D+00, 1075, 'R', & ! 1613
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284660072395D-05,  0.0000D+00, 1073, 'R', & ! 1614
     &          2.1D0,        -8.4D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284659299834D-05,  0.0000D+00, 1072, 'P', & ! 1615
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284658527274D-05,  0.0000D+00, 1071, 'P', & ! 1616
     &          0.5D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 2.9448534250D0, -7.284578283170D-05,  0.0000D+00, 1070, 'R', & ! 1617
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9448534250D0, -7.284577510609D-05,  0.0000D+00, 1069, 'R', & ! 1618
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.6454447867D0, -7.284405937322D-05, -9.4183D-23,   90, 'R', & ! 1619
     &        -25.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2654579319D0, -7.284260192795D-05,  1.2425D-23, 1068, 'P', & ! 1620
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1621,1630 ) &
     &             /                 &
     & 3.7460538105D0, -7.284053409448D-05,  0.0000D+00, 1067, 'P', & ! 1621
     &          6.6D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 0.4630055900D0, -7.283336241086D-05, -1.0146D-22,  321, 'R', & ! 1622
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3662040424D0, -7.283190496559D-05,  5.1496D-24, 1066, 'R', & ! 1623
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2246114179D0, -7.283189723991D-05,  6.2124D-24, 1065, 'P', & ! 1624
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.8331747082D0, -7.282791751390D-05,  0.0000D+00, 1064, 'P', & ! 1625
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8528907172D0, -7.282201816973D-05,  0.0000D+00, 1063, 'P', & ! 1626
     &          2.6D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 2.7112980927D0, -7.282201816967D-05,  1.0628D-24, 1062, 'P', & ! 1627
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8528907172D0, -7.282201044413D-05,  0.0000D+00, 1061, 'P', & ! 1628
     &         -0.5D0,        13.4D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120800309D-05,  0.0000D+00, 1060, 'R', & ! 1629
     &         -4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3253575285D0, -7.282120027755D-05, -1.0628D-24, 1058, 'R', & ! 1630
     &          0.3D0,        -0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1631,1640 ) &
     &             /                 &
     & 2.1837649040D0, -7.282120027748D-05,  0.0000D+00, 1059, 'R', & ! 1631
     &          1.0D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282119255188D-05,  0.0000D+00, 1056, 'P', & ! 1632
     &          4.4D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 4.0351961580D0, -7.281703573624D-05,  7.4483D-23, 1055, 'R', & ! 1633
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2034809130D0, -7.281530093332D-05,  0.0000D+00, 1054, 'P', & ! 1634
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4635228969D0, -7.280732241130D-05,  6.2124D-24, 1053, 'P', & ! 1635
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.6051155796D0, -7.280731468563D-05,  7.2752D-24, 1052, 'P', & ! 1636
     &          6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2906018106D0, -7.280268435273D-05,  0.0000D+00, 1050, 'R', & ! 1637
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.2906018106D0, -7.280266890152D-05,  0.0000D+00, 1049, 'P', & ! 1638
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7131365893D0, -7.280026157005D-05,  1.1687D-22,  456, 'R', & ! 1639
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5946153403D0, -7.279916085798D-05,  9.3644D-23,  469, 'P', & ! 1640
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1641,1650 ) &
     &             /                 &
     & 0.6643743138D0, -7.279777482869D-05,  0.0000D+00, 1048, 'R', & ! 1641
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279663317448D-05,  0.0000D+00, 1047, 'R', & ! 1642
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5642690075D0, -7.279662544894D-05, -1.0628D-24, 1045, 'R', & ! 1643
     &         -0.2D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279662544887D-05,  0.0000D+00, 1046, 'R', & ! 1644
     &         -0.7D0,        -3.6D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279661772327D-05,  0.0000D+00, 1044, 'P', & ! 1645
     &       -143.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279660999766D-05,  0.0000D+00, 1043, 'P', & ! 1646
     &          1.6D0,        -7.2D0,        0.0D0,      0.0D0,     & !
     & 4.5642690657D0, -7.279660999759D-05,  1.0628D-24, 1042, 'P', & ! 1647
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 2.3777227083D0, -7.279005232093D-05,  0.0000D+00, 1041, 'P', & ! 1648
     &          1.3D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 5.6384696332D0, -7.278921492014D-05,  0.0000D+00, 1040, 'R', & ! 1649
     &         -0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.6384696332D0, -7.278919946892D-05,  0.0000D+00, 1039, 'P', & ! 1650
     &          0.4D0,         0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1651,1660 ) &
     &             /                 &
     & 1.4121761437D0, -7.278846389561D-05,  8.6369D-23,  270, 'R', & ! 1651
     &         -4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0053671904D0, -7.278844487630D-05,  8.9572D-23,  470, 'P', & ! 1652
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5234224936D0, -7.278592076090D-05, -7.2752D-24, 1038, 'R', & ! 1653
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0346805186D0, -7.278515824810D-05,  0.0000D+00, 1037, 'R', & ! 1654
     &         -0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0346805186D0, -7.278514279689D-05,  0.0000D+00, 1036, 'R', & ! 1655
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1372699614D0, -7.278312698890D-05,  5.1496D-24, 1035, 'R', & ! 1656
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5129222542D0, -7.277776693325D-05,  7.9094D-23,  172, 'R', & ! 1657
     &         -4.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8229279937D0, -7.277774791393D-05,  8.2297D-23,  274, 'P', & ! 1658
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4648436059D0, -7.277743574035D-05,  0.0000D+00, 1034, 'P', & ! 1659
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.0933419151D0, -7.277619971029D-05, -7.4483D-23, 1033, 'P', & ! 1660
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1661,1670 ) &
     &             /                 &
     & 3.1218014163D0, -7.277254166752D-05,  0.0000D+00, 1032, 'R', & ! 1661
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1218014163D0, -7.277252621630D-05,  0.0000D+00, 1031, 'P', & ! 1662
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277243002640D-05,  0.0000D+00, 1030, 'R', & ! 1663
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277242230079D-05,  0.0000D+00, 1029, 'R', & ! 1664
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277241457519D-05,  0.0000D+00, 1028, 'P', & ! 1665
     &          2.7D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277204289466D-05,  0.0000D+00, 1027, 'R', & ! 1666
     &          0.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277203516905D-05,  0.0000D+00, 1026, 'P', & ! 1667
     &         -3.3D0,       -13.2D0,        0.0D0,      0.0D0,     & !
     & 3.8031805447D0, -7.277203516898D-05,  1.0628D-24, 1025, 'P', & ! 1668
     &          0.2D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277202744344D-05,  0.0000D+00, 1024, 'P', & ! 1669
     &         92.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2756473560D0, -7.277122500241D-05,  0.0000D+00, 1023, 'R', & ! 1670
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1671,1680 ) &
     &             /                 &
     & 3.2756473560D0, -7.277121727680D-05,  0.0000D+00, 1022, 'R', & ! 1671
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2756473560D0, -7.277120955119D-05,  0.0000D+00, 1021, 'P', & ! 1672
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.3304830576D0, -7.276706997088D-05,  7.1819D-23,  457, 'R', & ! 1673
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6404887971D0, -7.276705095157D-05,  7.5021D-23,  204, 'R', & ! 1674
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7368165166D0, -7.276632664381D-05,  7.2752D-24, 1020, 'P', & ! 1675
     &         -0.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 1.5219675481D0, -7.276595023949D-05,  5.1792D-23,  326, 'P', & ! 1676
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7623340307D0, -7.276133048095D-05, -5.1496D-24, 1019, 'P', & ! 1677
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2089223139D0, -7.275992508694D-05,  0.0000D+00, 1018, 'R', & ! 1678
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2089223139D0, -7.275990963572D-05,  0.0000D+00, 1017, 'P', & ! 1679
     &          1.5D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 4.6969980316D0, -7.275733168494D-05,  7.2752D-24, 1016, 'P', & ! 1680
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1681,1690 ) &
     &             /                 &
     & 0.5543773200D0, -7.275562968145D-05,  0.0000D+00, 1014, 'P', & ! 1681
     &         16.0D0,        25.9D0,        0.0D0,      0.0D0,     & !
     & 5.6227136586D0, -7.275525327713D-05,  4.4517D-23,  178, 'P', & ! 1682
     &        -28.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3363630136D0, -7.274954175007D-05,  7.2752D-24, 1013, 'P', & ! 1683
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1836846482D0, -7.274745261483D-05,  0.0000D+00, 1012, 'P', & ! 1684
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5792285187D0, -7.274729305514D-05,  0.0000D+00, 1011, 'P', & ! 1685
     &          7.5D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274664244819D-05,  0.0000D+00, 1009, 'R', & ! 1686
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274663472258D-05,  0.0000D+00, 1008, 'P', & ! 1687
     &          0.5D0,        31.6D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274662699697D-05,  0.0000D+00, 1007, 'P', & ! 1688
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8487886130D0, -7.274537343692D-05,  7.2752D-24, 1006, 'P', & ! 1689
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6551234306D0, -7.274493271908D-05, -7.2752D-24, 1005, 'R', & ! 1690
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1691,1700 ) &
     &             /                 &
     & 3.4402744620D0, -7.274455631476D-05,  3.7241D-23,   69, 'R', & ! 1691
     &        254.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.3217532130D0, -7.274345560269D-05,  1.4012D-23,   94, 'P', & ! 1692
     &       -148.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4146053502D0, -7.274233701628D-05,  0.0000D+00, 1004, 'P', & ! 1693
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2661183332D0, -7.273907020408D-05,  0.0000D+00, 1003, 'P', & ! 1694
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273885251332D-05,  0.0000D+00, 1002, 'R', & ! 1695
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273884478771D-05,  0.0000D+00, 1001, 'P', & ! 1696
     &        117.9D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273883706210D-05,  0.0000D+00, 1000, 'P', & ! 1697
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.3249146080D0, -7.273861937134D-05,  0.0000D+00,  999, 'P', & ! 1698
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3321196384D0, -7.273593776021D-05, -7.2752D-24,  998, 'R', & ! 1699
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.0054368000D0, -7.273557797551D-05,  0.0000D+00,  997, 'P', & ! 1700
     &          0.6D0,         1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1701,1710 ) &
     &             /                 &
     & 3.6663494164D0, -7.273467647455D-05,  0.0000D+00,  996, 'P', & ! 1701
     &         35.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2578352654D0, -7.273385935240D-05,  2.9966D-23,   93, 'R', & ! 1702
     &        -21.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1393140164D0, -7.273275864032D-05,  6.7366D-24,   28, 'P', & ! 1703
     &       3427.9D0,        -3.3D0,      610.2D0,      0.0D0,     & !
     & 5.7325050631D0, -7.273273962100D-05,  9.9395D-24,  327, 'P', & ! 1704
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8794535570D0, -7.272881893474D-05,  0.0000D+00,  995, 'P', & ! 1705
     &          7.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2546699276D0, -7.272814782534D-05, -7.2752D-24,  994, 'R', & ! 1706
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4839102197D0, -7.272397951219D-05, -7.2752D-24,  993, 'R', & ! 1707
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3585813760D0, -7.272316239003D-05,  2.2691D-23,  322, 'R', & ! 1708
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4225961272D0, -7.272287778622D-05,  0.0000D+00,  992, 'P', & ! 1709
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8656648302D0, -7.272228531034D-05,  0.0000D+00,  991, 'P', & ! 1710
     &          1.3D0,        -2.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1711,1720 ) &
     &             /                 &
     & 4.9204409073D0, -7.272217153509D-05,  0.0000D+00,  990, 'P', & ! 1711
     &         -2.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.9204409073D0, -7.272215608387D-05,  0.0000D+00,  989, 'P', & ! 1712
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7534703140D0, -7.272206761958D-05,  0.0000D+00,  988, 'R', & ! 1713
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2400601269D0, -7.272206167796D-05, -5.3862D-25,    5, 'P', & ! 1714
     &    -124403.0D0,       673.1D0,    96872.1D0,    -74.3D0,     & !
     & 1.7534703140D0, -7.272205989397D-05,  0.0000D+00,  987, 'P', & ! 1715
     &         -0.8D0,        -2.6D0,        0.0D0,      0.0D0,     & !
     & 3.5500658664D0, -7.272204265864D-05,  2.6643D-24,   10, 'P', & ! 1716
     &     -44064.9D0,        42.7D0,    38061.5D0,    -76.8D0,     & !
     & 4.8696850279D0, -7.272194825285D-05,  0.0000D+00,  986, 'R', & ! 1717
     &         -1.8D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.8696850279D0, -7.272193280164D-05,  0.0000D+00,  985, 'P', & ! 1718
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9244611050D0, -7.272181902639D-05,  0.0000D+00,  984, 'P', & ! 1719
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.3675298080D0, -7.272124200172D-05,  0.0000D+00,  983, 'R', & ! 1720
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1721,1730 ) &
     &             /                 &
     & 4.3675298080D0, -7.272122655050D-05,  0.0000D+00,  982, 'R', & ! 1721
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6049832970D0, -7.271879308177D-05,  0.0000D+00,  981, 'P', & ! 1722
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6274870710D0, -7.271528540199D-05,  0.0000D+00,  980, 'P', & ! 1723
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0576209303D0, -7.271136471559D-05, -7.8138D-24,   33, 'R', & ! 1724
     &        334.9D0,        -0.2D0,      336.1D0,      0.0D0,     & !
     & 2.7126238001D0, -7.271135520593D-05, -6.2124D-24,  471, 'P', & ! 1725
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3676266698D0, -7.271134569627D-05, -4.6109D-24,   46, 'P', & ! 1726
     &       1117.3D0,        -1.0D0,      336.1D0,      0.0D0,     & !
     & 6.1237765188D0, -7.270944331339D-05,  0.0000D+00,  979, 'P', & ! 1727
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1237765188D0, -7.270942786217D-05,  0.0000D+00,  978, 'P', & ! 1728
     &         14.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5015038280D0, -7.270852636122D-05,  0.0000D+00,  977, 'P', & ! 1729
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.7888804254D0, -7.270736413561D-05,  5.1496D-24,  976, 'R', & ! 1730
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1731,1740 ) &
     &             /                 &
     & 2.3530168110D0, -7.270527500023D-05,  0.0000D+00,  975, 'P', & ! 1731
     &         -0.8D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270526727462D-05,  0.0000D+00,  974, 'P', & ! 1732
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270525954902D-05,  0.0000D+00,  973, 'P', & ! 1733
     &         52.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8751817337D0, -7.270066775322D-05, -1.5089D-23,  111, 'R', & ! 1734
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4683727804D0, -7.270064873391D-05, -1.1886D-23,  107, 'R', & ! 1735
     &        -77.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7566604846D0, -7.269956704115D-05, -3.8319D-23,  472, 'P', & ! 1736
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0666662242D0, -7.269954802183D-05, -3.5116D-23,  275, 'P', & ! 1737
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269748506536D-05,  0.0000D+00,  972, 'R', & ! 1738
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269747733975D-05,  0.0000D+00,  971, 'P', & ! 1739
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269746961414D-05,  0.0000D+00,  970, 'P', & ! 1740
     &          0.0D0,        -5.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1741,1750 ) &
     &             /                 &
     & 4.2108974165D0, -7.269681128159D-05,  0.0000D+00,  969, 'P', & ! 1741
     &          3.8D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269666717311D-05,  0.0000D+00,  968, 'R', & ! 1742
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4648486043D0, -7.269665944757D-05, -1.0628D-24,  966, 'R', & ! 1743
     &          0.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269665944750D-05,  0.0000D+00,  967, 'R', & ! 1744
     &          0.4D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269665172189D-05,  0.0000D+00,  965, 'P', & ! 1745
     &         -1.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.1705776726D0, -7.269456258652D-05, -5.1496D-24,  964, 'P', & ! 1746
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4253832072D0, -7.269179421666D-05,  0.0000D+00,  962, 'R', & ! 1747
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2859335838D0, -7.268995177154D-05, -1.9161D-23,  271, 'R', & ! 1748
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1674123347D0, -7.268885105947D-05, -4.2391D-23,  145, 'P', & ! 1749
     &         53.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9525633080D0, -7.268847465528D-05,  0.0000D+00,  961, 'P', & ! 1750
     &          7.0D0,        -9.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1751,1760 ) &
     &             /                 &
     & 2.2980183141D0, -7.268419470100D-05,  0.0000D+00,  960, 'P', & ! 1751
     &          0.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.0277919626D0, -7.268277385565D-05,  7.2752D-24,  959, 'P', & ! 1752
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9549761244D0, -7.267930062817D-05,  0.0000D+00,  958, 'R', & ! 1753
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9549761244D0, -7.267928517696D-05,  0.0000D+00,  957, 'P', & ! 1754
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.9849731381D0, -7.267815409710D-05, -4.9666D-23,  272, 'R', & ! 1755
     &         -5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8664518891D0, -7.267705338503D-05, -7.2896D-23,  473, 'P', & ! 1756
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9869453905D0, -7.267208461896D-05, -1.0628D-24,  955, 'R', & ! 1757
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267208461889D-05,  0.0000D+00,  956, 'R', & ! 1758
     &         -0.3D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267207689328D-05,  0.0000D+00,  954, 'P', & ! 1759
     &         57.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267206916768D-05,  0.0000D+00,  953, 'P', & ! 1760
     &          0.5D0,        -3.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1761,1770 ) &
     &             /                 &
     & 3.5521098050D0, -7.267168976154D-05,  0.0000D+00,  952, 'P', & ! 1761
     &          1.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 3.0420970221D0, -7.266668404759D-05,  0.0000D+00,  951, 'R', & ! 1762
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0420970221D0, -7.266666859637D-05,  0.0000D+00,  950, 'P', & ! 1763
     &         -0.5D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.6840126924D0, -7.266635642266D-05, -8.0171D-23,  205, 'P', & ! 1764
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6629135694D0, -7.266137993092D-05, -7.2752D-24,  949, 'R', & ! 1765
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7847588030D0, -7.265565946030D-05, -8.7446D-23,  328, 'P', & ! 1766
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1292179197D0, -7.265405201579D-05,  0.0000D+00,  948, 'P', & ! 1767
     &         -1.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264750206468D-05,  0.0000D+00,  947, 'R', & ! 1768
     &          0.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264749433907D-05,  0.0000D+00,  946, 'P', & ! 1769
     &         -1.7D0,        -6.9D0,        0.0D0,      0.0D0,     & !
     & 5.2258569277D0, -7.264749433900D-05,  1.0628D-24,  945, 'P', & ! 1770
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1771,1780 ) &
     &             /                 &
     & 2.0842642450D0, -7.264748661346D-05,  0.0000D+00,  944, 'P', & ! 1771
     &        -22.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6983237390D0, -7.264668417242D-05,  0.0000D+00,  943, 'R', & ! 1772
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6983237390D0, -7.264667644682D-05,  0.0000D+00,  942, 'R', & ! 1773
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6023196064D0, -7.264496249793D-05, -9.4721D-23,  459, 'R', & ! 1774
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4995241245D0, -7.264143543521D-05,  0.0000D+00,  941, 'P', & ! 1775
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0526649408D0, -7.263435629393D-05,  1.6139D-22,  460, 'R', & ! 1776
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1534110513D0, -7.262365933157D-05,  1.5412D-22,  323, 'R', & ! 1777
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3231757240D0, -7.262291178485D-05,  0.0000D+00,  940, 'P', & ! 1778
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9372352180D0, -7.262210934381D-05,  0.0000D+00,  939, 'R', & ! 1779
     &          0.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.9372352180D0, -7.262209389260D-05,  0.0000D+00,  937, 'P', & ! 1780
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1781,1790 ) &
     &             /                 &
     & 1.6737659198D0, -7.261618682282D-05,  0.0000D+00,  936, 'P', & ! 1781
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0440721246D0, -7.260357024224D-05,  0.0000D+00,  934, 'P', & ! 1782
     &          3.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.1761466970D0, -7.259751906399D-05,  0.0000D+00,  933, 'P', & ! 1783
     &          0.4D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 3.1761466970D0, -7.259750361277D-05,  0.0000D+00,  932, 'P', & ! 1784
     &          1.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 5.7902061910D0, -7.259670117174D-05,  0.0000D+00,  931, 'R', & ! 1785
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1311930223D0, -7.259095366166D-05,  0.0000D+00,  930, 'P', & ! 1786
     &          1.0D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 4.0807632591D0, -7.259044871308D-05,  1.1226D-22,  461, 'R', & ! 1787
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1087546400D0, -7.259011626086D-05,  0.0000D+00,  929, 'R', & ! 1788
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1087546400D0, -7.259010080965D-05,  0.0000D+00,  928, 'P', & ! 1789
     &         -1.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.9622420101D0, -7.258934800101D-05,  8.9033D-23,  194, 'P', & ! 1790
     &         20.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1791,1800 ) &
     &             /                 &
     & 2.7798028135D0, -7.257865103864D-05,  8.1758D-23,   49, 'P', & ! 1791
     &       -926.7D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 2.2183139199D0, -7.257833708108D-05,  0.0000D+00,  927, 'P', & ! 1792
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 1.7083011370D0, -7.257331591591D-05,  0.0000D+00,  926, 'P', & ! 1793
     &         -8.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257293650977D-05,  0.0000D+00,  925, 'P', & ! 1794
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257292878416D-05,  0.0000D+00,  924, 'P', & ! 1795
     &          0.0D0,       -22.9D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257212634313D-05,  0.0000D+00,  923, 'R', & ! 1796
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257211861752D-05,  0.0000D+00,  922, 'R', & ! 1797
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257211089191D-05,  0.0000D+00,  921, 'P', & ! 1798
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5973636169D0, -7.256795407627D-05,  7.4483D-23,   22, 'R', & ! 1799
     &      -4485.9D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 3.7135783308D0, -7.256784243516D-05,  7.4483D-23,  736, 'R', & ! 1800
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1801,1810 ) &
     &             /                 &
     & 4.4902868306D0, -7.256722798454D-05,  7.2752D-24,  920, 'P', & ! 1801
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3054348176D0, -7.256572050049D-05,  0.0000D+00,  919, 'P', & ! 1802
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.9623926279D0, -7.256081097644D-05,  0.0000D+00,  918, 'P', & ! 1803
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9623926279D0, -7.256079552523D-05,  0.0000D+00,  917, 'P', & ! 1804
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.6981097274D0, -7.255725711391D-05,  6.7208D-23,   44, 'R', & ! 1805
     &        180.4D0,        -0.2D0,     -336.1D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255653102217D-05,  0.0000D+00,  916, 'P', & ! 1806
     &        -39.8D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255652329656D-05,  0.0000D+00,  915, 'P', & ! 1807
     &          0.9D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255651557095D-05,  0.0000D+00,  914, 'P', & ! 1808
     &          1.3D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.5795884784D0, -7.255615640183D-05,  4.3978D-23,  474, 'P', & ! 1809
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6539696550D0, -7.254835395555D-05,  0.0000D+00,  913, 'P', & ! 1810
     &          0.5D0,         1.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1811,1820 ) &
     &             /                 &
     & 1.0495135255D0, -7.254819439586D-05,  0.0000D+00,  912, 'P', & ! 1811
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0495135255D0, -7.254817894464D-05,  0.0000D+00,  911, 'P', & ! 1812
     &         -3.7D0,        -5.9D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254754378891D-05,  0.0000D+00,  910, 'R', & ! 1813
     &         -0.2D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254753606330D-05,  0.0000D+00,  909, 'P', & ! 1814
     &         -8.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254752833769D-05,  0.0000D+00,  908, 'P', & ! 1815
     &         -0.5D0,         2.6D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254752061209D-05,  0.0000D+00,  907, 'P', & ! 1816
     &        -11.0D0,        -3.1D0,        0.0D0,      0.0D0,     & !
     & 2.5156705308D0, -7.254656015154D-05,  5.9932D-23,  173, 'R', & ! 1817
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3971492818D0, -7.254545943947D-05,  3.6703D-23,  324, 'R', & ! 1818
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0521521515D0, -7.254544992981D-05,  3.8304D-23,  475, 'P', & ! 1819
     &          0.0D0,        -3.6D0,        0.0D0,      0.0D0,     & !
     & 4.2786280327D0, -7.254435872739D-05,  1.3473D-23,  476, 'P', & ! 1820
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1821,1830 ) &
     &             /                 &
     & 1.5886337722D0, -7.254433970808D-05,  1.6676D-23,  329, 'P', & ! 1821
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8848903570D0, -7.254323835700D-05,  0.0000D+00,  906, 'P', & ! 1822
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.7628619200D0, -7.254048733933D-05,  0.0000D+00,  905, 'P', & ! 1823
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253974612843D-05,  0.0000D+00,  904, 'P', & ! 1824
     &          0.0D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253973067722D-05,  0.0000D+00,  903, 'P', & ! 1825
     &         31.1D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 1.7589071140D0, -7.253647931623D-05,  0.0000D+00,  902, 'P', & ! 1826
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7589071140D0, -7.253647159062D-05,  0.0000D+00,  901, 'P', & ! 1827
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4198197304D0, -7.253557781528D-05,  0.0000D+00,  900, 'P', & ! 1828
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4198197304D0, -7.253556236406D-05,  0.0000D+00,  899, 'P', & ! 1829
     &        -16.2D0,       -14.4D0,        0.0D0,      0.0D0,     & !
     & 6.1528982621D0, -7.253475296745D-05,  3.1029D-23,  462, 'R', & ! 1830
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1831,1840 ) &
     &             /                 &
     & 4.8079011318D0, -7.253474345779D-05,  3.2630D-23,  477, 'P', & ! 1831
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0961888361D0, -7.253366176503D-05,  6.1980D-24,  195, 'P', & ! 1832
     &         21.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6893798828D0, -7.253364274571D-05,  9.4009D-24,   88, 'P', & ! 1833
     &       -161.5D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.6329238710D0, -7.252970482425D-05,  0.0000D+00,  898, 'P', & ! 1834
     &          0.0D0,        -4.1D0,        0.0D0,      0.0D0,     & !
     & 0.8499828177D0, -7.252787075874D-05,  0.0000D+00,  897, 'P', & ! 1835
     &         -2.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8928811340D0, -7.252377912694D-05,  0.0000D+00,  896, 'P', & ! 1836
     &        -12.4D0,       -19.4D0,        0.0D0,      0.0D0,     & !
     & 0.2884250045D0, -7.252360411603D-05,  0.0000D+00,  895, 'P', & ! 1837
     &         -2.8D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 0.3359498370D0, -7.252317119984D-05,  0.0000D+00,  894, 'P', & ! 1838
     &          2.3D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.4521645509D0, -7.252305955873D-05,  0.0000D+00,  893, 'P', & ! 1839
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3907259141D0, -7.252305742459D-05,  0.0000D+00,  892, 'P', & ! 1840
     &        -24.7D0,       -83.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1841,1850 ) &
     &             /                 &
     & 6.1969349467D0, -7.252296480266D-05, -1.0772D-24,   35, 'P', & ! 1841
     &      -1570.2D0,         1.5D0,     2520.4D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252296123469D-05,  0.0000D+00,  891, 'P', & ! 1842
     &         -8.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252295350909D-05,  0.0000D+00,  889, 'P', & ! 1843
     &         -1.6D0,        -7.1D0,        0.0D0,      0.0D0,     & !
     & 0.3653480035D0, -7.252295350902D-05,  1.0628D-24,  888, 'P', & ! 1844
     &          0.0D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 0.2851939577D0, -7.252294791761D-05,  0.0000D+00,  885, 'P', & ! 1845
     &         -1.5D0,       -12.9D0,        0.0D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252294578348D-05,  0.0000D+00,  886, 'P', & ! 1846
     &         17.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5069406862D0, -7.252294578335D-05,  2.1256D-24,    2, 'P', & ! 1847
     &    2659062.8D0,     -2432.5D0,  -180415.0D0,    136.2D0,     & !
     & 0.3399700347D0, -7.252283414236D-05,  0.0000D+00,  883, 'P', & ! 1848
     &         26.2D0,       -88.4D0,        0.0D0,      0.0D0,     & !
     & 3.5617167051D0, -7.252283200823D-05,  0.0000D+00,  882, 'P', & ! 1849
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3947461118D0, -7.252272036711D-05,  0.0000D+00,  881, 'P', & ! 1850
     &         -2.4D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1851,1860 ) &
     &             /                 &
     & 0.4422709443D0, -7.252228745092D-05,  0.0000D+00,  880, 'P', & ! 1851
     &          2.7D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252214334244D-05,  0.0000D+00,  877, 'R', & ! 1852
     &          0.6D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252213561683D-05,  0.0000D+00,  878, 'R', & ! 1853
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3809573850D0, -7.251618674271D-05,  0.0000D+00,  875, 'P', & ! 1854
     &          0.0D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 5.4671221430D0, -7.251395082461D-05,  0.0000D+00,  874, 'P', & ! 1855
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4914720828D0, -7.251236046210D-05, -5.1496D-24,  873, 'P', & ! 1856
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.0144957501D0, -7.251226784030D-05, -8.3524D-24,  227, 'R', & ! 1857
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4660941141D0, -7.251225654666D-05, -6.2124D-24,  872, 'P', & ! 1858
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.3245014896D0, -7.251224882098D-05, -5.1496D-24,   11, 'P', & ! 1859
     &     -29085.9D0,        26.9D0,    -4877.3D0,      0.0D0,     & !
     & 4.4407162035D0, -7.251213717987D-05, -5.1496D-24,  871, 'P', & ! 1860
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1861,1870 ) &
     &             /                 &
     & 1.5940615256D0, -7.251032920289D-05,  0.0000D+00,  870, 'P', & ! 1861
     &         17.2D0,       -14.3D0,        0.0D0,      0.0D0,     & !
     & 4.1064871250D0, -7.250616088974D-05,  0.0000D+00,  869, 'P', & ! 1862
     &        -33.2D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 1.8320565534D0, -7.250157087793D-05, -1.5628D-23,  463, 'R', & ! 1863
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4252476001D0, -7.250155185862D-05, -1.2425D-23,   31, 'R', & ! 1864
     &       2059.9D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.7458521070D0, -7.249837095487D-05,  0.0000D+00,  868, 'P', & ! 1865
     &         12.9D0,        -3.2D0,        0.0D0,      0.0D0,     & !
     & 5.9643677305D0, -7.249771262231D-05,  0.0000D+00,  867, 'P', & ! 1866
     &          4.2D0,        -6.5D0,        0.0D0,      0.0D0,     & !
     & 5.3599116010D0, -7.249756851383D-05,  0.0000D+00,  866, 'R', & ! 1867
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3599116010D0, -7.249756078823D-05,  0.0000D+00,  865, 'R', & ! 1868
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3599116010D0, -7.249755306262D-05,  0.0000D+00,  864, 'P', & ! 1869
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 5.3599116010D0, -7.249753761140D-05,  0.0000D+00,  863, 'P', & ! 1870
     &         -0.5D0,         1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1871,1880 ) &
     &             /                 &
     & 3.2428084035D0, -7.249085489625D-05, -1.9700D-23,   87, 'R', & ! 1871
     &        -26.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1242871545D0, -7.248975418418D-05, -4.2930D-23,  478, 'P', & ! 1872
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7060336220D0, -7.248937599600D-05,  0.0000D+00,  862, 'P', & ! 1873
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0514886281D0, -7.248509604173D-05,  0.0000D+00,  861, 'P', & ! 1874
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 0.4252611313D0, -7.248017106646D-05,  0.0000D+00,  860, 'P', & ! 1875
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 1.0603692069D0, -7.248015793389D-05, -2.6975D-23,  325, 'R', & ! 1876
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5988230800D0, -7.247297823401D-05,  0.0000D+00,  859, 'P', & ! 1877
     &         -0.6D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 4.5988230800D0, -7.247296278279D-05,  0.0000D+00,  858, 'P', & ! 1878
     &         -1.0D0,       -34.9D0,        0.0D0,      0.0D0,     & !
     & 4.7955673361D0, -7.246755448588D-05,  0.0000D+00,  857, 'P', & ! 1879
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.0516393623D0, -7.245654356569D-05, -8.4782D-23,  479, 'P', & ! 1880
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1881,1890 ) &
     &             /                 &
     & 2.8826882337D0, -7.245493790530D-05,  0.0000D+00,  856, 'P', & ! 1881
     &         -1.4D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 3.8377345590D0, -7.244839567979D-05,  0.0000D+00,  855, 'P', & ! 1882
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8377345590D0, -7.244838795418D-05,  0.0000D+00,  854, 'P', & ! 1883
     &         -0.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244758551315D-05,  0.0000D+00,  853, 'R', & ! 1884
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244757778754D-05,  0.0000D+00,  852, 'R', & ! 1885
     &          0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1523854728D0, -7.244584660333D-05, -9.2057D-23,  480, 'P', & ! 1886
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9698091314D0, -7.244232132471D-05,  0.0000D+00,  851, 'P', & ! 1887
     &         -5.2D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 5.3401153362D0, -7.242970474413D-05,  0.0000D+00,  850, 'P', & ! 1888
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242300295893D-05,  0.0000D+00,  849, 'R', & ! 1889
     &         -0.1D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242299523332D-05,  0.0000D+00,  848, 'P', & ! 1890
     &         -8.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1891,1900 ) &
     &             /                 &
     & 5.6907055320D0, -7.242298750771D-05,  0.0000D+00,  847, 'P', & ! 1891
     &          0.0D0,        -2.2D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242297978211D-05,  0.0000D+00,  846, 'P', & ! 1892
     &         -2.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.4272362338D0, -7.241708816355D-05,  0.0000D+00,  845, 'P', & ! 1893
     &         -0.5D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.2626784570D0, -7.240780249533D-05,  0.0000D+00,  844, 'R', & ! 1894
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239842040471D-05,  0.0000D+00,  843, 'P', & ! 1895
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239841267910D-05,  0.0000D+00,  842, 'P', & ! 1896
     &         -1.2D0,        -5.1D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239840495350D-05,  0.0000D+00,  841, 'P', & ! 1897
     &         68.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2604911978D0, -7.239760251246D-05,  0.0000D+00,  840, 'R', & ! 1898
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.0376380789D0, -7.239135183779D-05,  1.1172D-22,  465, 'R', & ! 1899
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8622249540D0, -7.239100215037D-05,  0.0000D+00,  839, 'P', & ! 1900
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1901,1910 ) &
     &             /                 &
     & 2.7471778726D0, -7.238770799100D-05, -5.1496D-24,  838, 'P', & ! 1901
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7366776332D0, -7.237955416335D-05,  8.1219D-23,  206, 'P', & ! 1902
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3455567371D0, -7.237431344653D-05,  0.0000D+00,  837, 'P', & ! 1903
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.4617714510D0, -7.237421725663D-05,  0.0000D+00,  836, 'P', & ! 1904
     &         -1.7D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.4617714510D0, -7.237420180542D-05,  0.0000D+00,  835, 'P', & ! 1905
     &         -1.8D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 4.1685284900D0, -7.237383012489D-05,  0.0000D+00,  834, 'P', & ! 1906
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4994026768D0, -7.237301995824D-05,  0.0000D+00,  833, 'R', & ! 1907
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4994026768D0, -7.237301223264D-05,  0.0000D+00,  832, 'P', & ! 1908
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.5542384366D0, -7.236885720098D-05,  7.3944D-23,   99, 'R', & ! 1909
     &        -96.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.7158629419D0, -7.236169686595D-05,  0.0000D+00,  831, 'P', & ! 1910
     &         -1.1D0,        -1.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1911,1920 ) &
     &             /                 &
     & 4.6549845472D0, -7.235816023862D-05,  6.6669D-23,  177, 'R', & ! 1911
     &          4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0613179480D0, -7.235743236289D-05,  0.0000D+00,  830, 'P', & ! 1912
     &          0.4D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 4.0613179480D0, -7.235741691168D-05,  0.0000D+00,  829, 'P', & ! 1913
     &        -13.5D0,       -18.2D0,        0.0D0,      0.0D0,     & !
     & 2.8029838395D0, -7.234908028537D-05,  0.0000D+00,  828, 'P', & ! 1914
     &         -6.0D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 6.0214994630D0, -7.234842195281D-05,  0.0000D+00,  826, 'P', & ! 1915
     &          0.0D0,       -23.1D0,        0.0D0,      0.0D0,     & !
     & 0.6640298410D0, -7.234634354486D-05,  3.9367D-23,  276, 'P', & ! 1916
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6608644450D0, -7.234063201794D-05,  0.0000D+00,  824, 'P', & ! 1917
     &        -98.6D0,         3.2D0,        0.0D0,      0.0D0,     & !
     & 3.5123774280D0, -7.233736520574D-05,  0.0000D+00,  823, 'P', & ! 1918
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 0.8901047372D0, -7.233646370478D-05,  0.0000D+00,  822, 'P', & ! 1919
     &        -28.8D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7647759516D0, -7.233564658250D-05,  3.2092D-23,  243, 'P', & ! 1920
     &         10.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1921,1930 ) &
     &             /                 &
     & 5.6462547025D0, -7.233454587042D-05,  8.8622D-24,  277, 'P', & ! 1921
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3863941850D0, -7.233060616497D-05,  0.0000D+00,  821, 'P', & ! 1922
     &         -5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4784253066D0, -7.232993505544D-05, -5.1496D-24,  820, 'P', & ! 1923
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5823367550D0, -7.232494962013D-05,  2.4817D-23,  467, 'R', & ! 1924
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6463514480D0, -7.232468046767D-05,  0.0000D+00,  819, 'P', & ! 1925
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0894201510D0, -7.232407254057D-05,  0.0000D+00,  818, 'P', & ! 1926
     &         -1.0D0,         2.4D0,        0.0D0,      0.0D0,     & !
     & 2.1441962281D0, -7.232395876532D-05,  0.0000D+00,  817, 'P', & ! 1927
     &          5.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1538097664D0, -7.232386792737D-05, -1.6158D-24,  165, 'P', & ! 1928
     &        -26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0386642717D0, -7.232384925833D-05,  0.0000D+00,  816, 'P', & ! 1929
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4638155059D0, -7.232384890806D-05,  1.5870D-24,    6, 'P', & ! 1930
     &     104226.6D0,       -92.7D0,   -89463.4D0,     61.1D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1931,1940 ) &
     &             /                 &
     & 5.2604109420D0, -7.232384712420D-05,  0.0000D+00,  815, 'P', & ! 1931
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.0934403487D0, -7.232373548308D-05,  0.0000D+00,  814, 'P', & ! 1932
     &          4.5D0,         2.4D0,        0.0D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232304468317D-05,  0.0000D+00,  813, 'R', & ! 1933
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232303695756D-05,  0.0000D+00,  812, 'R', & ! 1934
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.2813763093D0, -7.231315194569D-05, -5.6882D-24,   51, 'P', & ! 1935
     &       -805.7D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 3.3475318396D0, -7.231123054362D-05,  0.0000D+00,  810, 'P', & ! 1936
     &          0.9D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.8599574390D0, -7.230706223046D-05,  0.0000D+00,  809, 'P', & ! 1937
     &          1.0D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 5.3821224199D0, -7.230245498333D-05, -1.2963D-23,  120, 'R', & ! 1938
     &         63.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4993224210D0, -7.229927229559D-05,  0.0000D+00,  808, 'P', & ! 1939
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229846212895D-05,  0.0000D+00,  807, 'R', & ! 1940
     &         -0.1D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1941,1950 ) &
     &             /                 &
     & 0.8301966078D0, -7.229845440334D-05,  0.0000D+00,  806, 'P', & ! 1941
     &         -5.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229844667773D-05,  0.0000D+00,  805, 'P', & ! 1942
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229843895212D-05,  0.0000D+00,  804, 'P', & ! 1943
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1996832233D0, -7.229175802096D-05, -2.0239D-23,  273, 'R', & ! 1944
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227387957473D-05,  0.0000D+00,  803, 'P', & ! 1945
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227387184912D-05,  0.0000D+00,  802, 'P', & ! 1946
     &         -0.9D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227386412351D-05,  0.0000D+00,  801, 'P', & ! 1947
     &        -74.5D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.2658523429D0, -7.226845582660D-05,  0.0000D+00,  800, 'P', & ! 1948
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.6361585477D0, -7.225583924602D-05,  0.0000D+00,  798, 'P', & ! 1949
     &          1.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.9220790598D0, -7.224847140265D-05,  0.0000D+00,  797, 'P', & ! 1950
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1951,1960 ) &
     &             /                 &
     & 2.7232794454D0, -7.224322266544D-05,  0.0000D+00,  796, 'P', & ! 1951
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1609905388D0, -7.222388112283D-05,  0.0000D+00,  795, 'P', & ! 1952
     &          0.0D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 1.1947272337D0, -7.221474959930D-05,  1.4897D-22,  468, 'R', & ! 1953
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3999020178D0, -7.219930629422D-05,  0.0000D+00,  794, 'P', & ! 1954
     &         -0.9D0,         3.3D0,        0.0D0,      0.0D0,     & !
     & 3.0139615118D0, -7.219850385318D-05,  0.0000D+00,  793, 'R', & ! 1955
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0139615118D0, -7.219849612758D-05,  0.0000D+00,  792, 'R', & ! 1956
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.6156952680D0, -7.219188803988D-05,  0.0000D+00,  791, 'P', & ! 1957
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2152417650D0, -7.217510314614D-05,  0.0000D+00,  790, 'P', & ! 1958
     &          7.4D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.2528729908D0, -7.217392129897D-05,  0.0000D+00,  789, 'R', & ! 1959
     &         -0.2D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 2.2528729908D0, -7.217391357336D-05,  0.0000D+00,  788, 'P', & ! 1960
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1961,1970 ) &
     &             /                 &
     & 2.2528729908D0, -7.217390584775D-05,  0.0000D+00,  787, 'P', & ! 1961
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.5111132564D0, -7.216976032569D-05,  7.3406D-23,  330, 'R', & ! 1962
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1043043031D0, -7.216974130638D-05,  7.6608D-23,  283, 'P', & ! 1963
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6118593669D0, -7.215906336333D-05,  6.6130D-23,  481, 'R', & ! 1964
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9218651064D0, -7.215904434401D-05,  6.9333D-23,  188, 'P', & ! 1965
     &        -22.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8147882620D0, -7.215831825240D-05,  0.0000D+00,  786, 'P', & ! 1966
     &         37.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5564541535D0, -7.214998162609D-05,  0.0000D+00,  785, 'P', & ! 1967
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214933874475D-05,  0.0000D+00,  784, 'P', & ! 1968
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214933101914D-05,  0.0000D+00,  783, 'P', & ! 1969
     &         -0.2D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214932329353D-05,  0.0000D+00,  782, 'P', & ! 1970
     &         -6.1D0,        -0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1971,1980 ) &
     &             /                 &
     & 6.0226112170D0, -7.214834738164D-05,  6.2058D-23,  331, 'R', & ! 1971
     &          2.7D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.1311494518D0, -7.214153335866D-05,  0.0000D+00,  781, 'P', & ! 1972
     &          0.5D0,        -6.5D0,        0.0D0,      0.0D0,     & !
     & 5.2658477420D0, -7.213826654646D-05,  0.0000D+00,  780, 'P', & ! 1973
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6435750512D0, -7.213736504551D-05,  0.0000D+00,  779, 'P', & ! 1974
     &          0.0D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 0.7306959488D0, -7.212476391614D-05,  0.0000D+00,  778, 'P', & ! 1975
     &         -0.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.4206903257D0, -7.212475203276D-05,  1.0484D-24,   30, 'P', & ! 1976
     &       3183.4D0,        -2.8D0,    -5426.1D0,      0.0D0,     & !
     & 0.7306960652D0, -7.212473301345D-05,  4.2513D-24,  284, 'P', & ! 1977
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3447554428D0, -7.212393057267D-05,  0.0000D+00,  777, 'P', & ! 1978
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.2382511291D0, -7.211405507040D-05, -6.2268D-24,  197, 'P', & ! 1979
     &        -19.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3389972396D0, -7.210335810803D-05, -1.3502D-23,  332, 'R', & ! 1980
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1981,1990 ) &
     &             /                 &
     & 2.6490029791D0, -7.210333908872D-05, -1.0299D-23,  285, 'P', & ! 1981
     &          8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5836669218D0, -7.209934029285D-05,  0.0000D+00,  776, 'P', & ! 1982
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.4665637825D0, -7.209264212635D-05, -1.7574D-23,  353, 'P', & ! 1983
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8225784008D0, -7.207477318985D-05,  0.0000D+00,  774, 'P', & ! 1984
     &         -2.4D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.8225784008D0, -7.207476546424D-05,  0.0000D+00,  775, 'P', & ! 1985
     &         -1.3D0,        -4.6D0,        0.0D0,      0.0D0,     & !
     & 3.6755493738D0, -7.204938046899D-05,  0.0000D+00,  772, 'R', & ! 1986
     &         -0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.6755493738D0, -7.204937274338D-05,  0.0000D+00,  771, 'P', & ! 1987
     &         -2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9144608528D0, -7.202479791477D-05,  0.0000D+00,  768, 'P', & ! 1988
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.9144608528D0, -7.202479018916D-05,  0.0000D+00,  770, 'P', & ! 1989
     &          0.0D0,        -1.6D0,        0.0D0,      0.0D0,     & !
     & 2.9144608528D0, -7.202478246355D-05,  0.0000D+00,  769, 'P', & ! 1990
     &         -1.7D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1991,2000 ) &
     &             /                 &
     & 0.0859802748D0, -7.199278938060D-05,  0.0000D+00,  766, 'P', & ! 1991
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6855267718D0, -7.197600448686D-05,  0.0000D+00,  765, 'P', & ! 1992
     &          1.8D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.0611791228D0, -7.197064443108D-05,  7.6070D-23,  519, 'P', & ! 1993
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8787399262D0, -7.195994746872D-05,  6.8795D-23,  520, 'P', & ! 1994
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2850732688D0, -7.195921959312D-05,  0.0000D+00,  764, 'P', & ! 1995
     &         -0.5D0,         2.4D0,        0.0D0,      0.0D0,     & !
     & 3.2452547838D0, -7.195022463426D-05,  0.0000D+00,  763, 'P', & ! 1996
     &         -1.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.3775651454D0, -7.192565515747D-05,  5.0980D-25,  121, 'P', & ! 1997
     &         86.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6875708849D0, -7.192563613816D-05,  3.7127D-24,  521, 'P', & ! 1998
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0982257568D0, -7.192483963900D-05,  0.0000D+00,  762, 'R', & ! 1999
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.0982257568D0, -7.192483191340D-05,  0.0000D+00,  761, 'P', & ! 2000
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2001,2010 ) &
     &             /                 &
     & 2.6058777989D0, -7.190424221343D-05, -1.0838D-23,  522, 'P', & ! 2001
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3371372358D0, -7.190024935918D-05,  0.0000D+00,  760, 'P', & ! 2002
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 4.3371372358D0, -7.190024163357D-05,  0.0000D+00,  759, 'P', & ! 2003
     &         -1.6D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.2377168326D0, -7.180029880902D-05,  0.0000D+00,  757, 'R', & ! 2004
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2377168326D0, -7.180029108341D-05,  0.0000D+00,  755, 'P', & ! 2005
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7598136188D0, -7.177570852920D-05,  0.0000D+00,  754, 'P', & ! 2006
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 4.2376365768D0, -7.172656659759D-05,  0.0000D+00,  751, 'P', & ! 2007
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2376365768D0, -7.172655887198D-05,  0.0000D+00,  750, 'P', & ! 2008
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.2376365768D0, -7.172655114637D-05,  0.0000D+00,  749, 'P', & ! 2009
     &         -1.7D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 0.5199409976D0, -7.144226346033D-05, -3.7217D-23,  483, 'R', & ! 2010
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2011,2020 ) &
     &             /                 &
     & 2.6592550139D0, -7.125386354740D-05, -3.0481D-23,  523, 'P', & ! 2011
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4768158173D0, -7.124316658503D-05, -3.7756D-23,  244, 'R', & ! 2012
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5775619279D0, -7.123246962267D-05, -4.5031D-23,  484, 'R', & ! 2013
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8875676674D0, -7.123245060335D-05, -4.1828D-23,  524, 'P', & ! 2014
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2039536900D0, -7.118746132974D-05, -1.1739D-22,  355, 'P', & ! 2015
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1173046144D0, -7.108905898335D-05,  3.7266D-23,  485, 'R', & ! 2016
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7985690303D0, -7.106546363447D-05, -2.3744D-23,  525, 'P', & ! 2017
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6161298337D0, -7.105476667211D-05, -3.1019D-23,  250, 'P', & ! 2018
     &          7.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4336906371D0, -7.104406970974D-05, -3.8294D-23,  112, 'R', & ! 2019
     &         15.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.0268816838D0, -7.104405069043D-05, -3.5092D-23,  286, 'P', & ! 2020
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2021,2030 ) &
     &             /                 &
     & 4.5344367476D0, -7.103337274738D-05, -4.5570D-23,  228, 'R', & ! 2021
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8444424871D0, -7.103335372806D-05, -4.2367D-23,  161, 'P', & ! 2022
     &        -27.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9451885977D0, -7.102265676570D-05, -4.9642D-23,  333, 'R', & ! 2023
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6442281520D0, -7.101085909126D-05, -8.0147D-23,  526, 'P', & ! 2024
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7335297998D0, -7.099978750855D-05, -4.3444D-23,  744, 'R', & ! 2025
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3432677064D0, -7.099906141682D-05, -1.1065D-22,  356, 'P', & ! 2026
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1608285098D0, -7.098836445445D-05, -1.1793D-22,  198, 'P', & ! 2027
     &        -15.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2615746203D0, -7.097766749209D-05, -1.2520D-22,  334, 'R', & ! 2028
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2566186308D0, -7.090065907043D-05,  4.4002D-23,  357, 'P', & ! 2029
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0741794342D0, -7.088996210806D-05,  3.6727D-23,  185, 'R', & ! 2030
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2031,2040 ) &
     &             /                 &
     & 5.1960246678D0, -7.088424163744D-05, -4.3444D-23,  743, 'R', & ! 2031
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1749255447D0, -7.087926514570D-05,  2.9452D-23,  335, 'R', & ! 2032
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0564042957D0, -7.087816443362D-05,  6.2221D-24,  527, 'P', & ! 2033
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8739650991D0, -7.086746747126D-05, -1.0531D-24,  278, 'R', & ! 2034
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6915259025D0, -7.085677050889D-05, -8.3283D-24,  160, 'R', & ! 2035
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1661957001D0, -7.085565077750D-05, -2.8355D-23,  358, 'P', & ! 2036
     &          3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3905654568D0, -7.084497283445D-05, -3.8833D-23,  336, 'R', & ! 2037
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9837565035D0, -7.084495381514D-05, -3.5630D-23,   92, 'P', & ! 2038
     &       -166.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.8013173069D0, -7.083425685277D-05, -4.2905D-23,   48, 'P', & ! 2039
     &       -721.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.9020634174D0, -7.082355989041D-05, -5.0181D-23,  100, 'R', & ! 2040
     &         20.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2041,2050 ) &
     &             /                 &
     & 0.5003568612D0, -7.082245917833D-05, -7.3410D-23,  528, 'P', & ! 2041
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6042683096D0, -7.081747374302D-05, -4.3444D-23,  742, 'R', & ! 2042
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7196242208D0, -7.081286292804D-05, -5.7456D-23,  337, 'R', & ! 2043
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6011029718D0, -7.081176221596D-05, -8.0685D-23,  287, 'P', & ! 2044
     &          4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4186637752D0, -7.080106525360D-05, -8.7961D-23,  486, 'R', & ! 2045
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3355157436D0, -7.075970080746D-05, -4.3444D-23,  741, 'R', & ! 2046
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4386175325D0, -7.073105784999D-05,  0.0000D+00,  876, 'P', & ! 2047
     &          2.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.3959326472D0, -7.071225915750D-05,  5.0739D-23,  288, 'P', & ! 2048
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2134934505D0, -7.070156219514D-05,  4.3464D-23,  128, 'P', & ! 2049
     &         56.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.0310542539D0, -7.069086523277D-05,  3.6188D-23,   67, 'R', & ! 2050
     &         68.5D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2051,2060 ) &
     &             /                 &
     & 4.6242453006D0, -7.069084621345D-05,  3.9391D-23,  359, 'P', & ! 2051
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1318003645D0, -7.068016827041D-05,  2.8913D-23,  132, 'R', & ! 2052
     &         -2.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.4418061040D0, -7.068014925109D-05,  3.2116D-23,  251, 'P', & ! 2053
     &         -8.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2593669074D0, -7.066945228872D-05,  2.4841D-23,  487, 'R', & ! 2054
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2415917689D0, -7.065765461428D-05, -5.6640D-24,  529, 'P', & ! 2055
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1230705199D0, -7.065655390221D-05, -2.8894D-23,  129, 'P', & ! 2056
     &         79.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3707119017D0, -7.065557799045D-05,  3.1039D-23,  740, 'R', & ! 2057
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0477081095D0, -7.064658303158D-05,  3.1039D-23,  739, 'R', & ! 2058
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9406313232D0, -7.064585693984D-05, -3.6169D-23,   29, 'P', & ! 2059
     &      -3401.7D0,         0.8D0,     -305.5D0,      0.0D0,     & !
     & 4.9251627199D0, -7.063527161860D-05, -4.3444D-23,  738, 'P', & ! 2060
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2061,2070 ) &
     &             /                 &
     & 1.7581921266D0, -7.063515997748D-05, -4.3444D-23,   13, 'P', & ! 2061
     &     -15437.7D0,         3.7D0,     -305.5D0,      0.0D0,     & !
     & 4.8744068406D0, -7.063504833636D-05, -4.3444D-23,  737, 'R', & ! 2062
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.6472546065D0, -7.062979813784D-05,  3.1039D-23,  735, 'R', & ! 2063
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8589382372D0, -7.062446301511D-05, -5.0719D-23,   32, 'R', & ! 2064
     &        444.2D0,        -0.2D0,     -305.5D0,      0.0D0,     & !
     & 3.6764990406D0, -7.061376605275D-05, -5.7994D-23,  140, 'R', & ! 2065
     &         -2.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6677691959D0, -7.059015168455D-05, -1.1580D-22,  289, 'P', & ! 2066
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4853299993D0, -7.057945472219D-05, -1.2308D-22,  290, 'P', & ! 2067
     &         -5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3028908027D0, -7.056875775982D-05, -1.3035D-22,  530, 'P', & ! 2068
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1703682703D0, -7.050246531984D-05,  4.2925D-23,  531, 'P', & ! 2069
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4803740098D0, -7.050244630053D-05,  4.6128D-23,  360, 'P', & ! 2070
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2071,2080 ) &
     &             /                 &
     & 0.9879290737D0, -7.049176835748D-05,  3.5650D-23,  245, 'R', & ! 2071
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5811201204D0, -7.049174933816D-05,  3.8853D-23,  103, 'P', & ! 2072
     &       -118.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3986809238D0, -7.048105237580D-05,  3.1577D-23,   52, 'P', & ! 2073
     &       -465.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.2801596747D0, -7.047995166372D-05,  8.3478D-24,  361, 'P', & ! 2074
     &         -2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2162417271D0, -7.047035541343D-05,  2.4302D-23,  134, 'R', & ! 2075
     &         10.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.0977204781D0, -7.046925470136D-05,  1.0726D-24,  122, 'P', & ! 2076
     &         87.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2016319265D0, -7.046426926604D-05,  3.1039D-23,  734, 'R', & ! 2077
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1984665887D0, -7.045855773899D-05, -6.2026D-24,   57, 'P', & ! 2078
     &        403.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0799453396D0, -7.045745702692D-05, -2.9432D-23,  209, 'P', & ! 2079
     &         12.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0160273920D0, -7.044786077663D-05, -1.3478D-23,  133, 'R', & ! 2080
     &        -11.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2081,2090 ) &
     &             /                 &
     & 3.8975061430D0, -7.044676006455D-05, -3.6707D-23,  189, 'P', & ! 2081
     &         25.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8335881954D0, -7.043716381426D-05, -2.0753D-23,  491, 'R', & ! 2082
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7150669464D0, -7.043606310219D-05, -4.3983D-23,  101, 'P', & ! 2083
     &         93.4D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.3082579931D0, -7.043604408287D-05, -4.0780D-23,  174, 'P', & ! 2084
     &         32.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8138581164D0, -7.043028160543D-05, -4.9656D-23, 1280, 'R', & ! 2085
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8158130569D0, -7.042536613982D-05, -5.1258D-23,  229, 'R', & ! 2086
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1258187965D0, -7.042534712051D-05, -4.8055D-23,  230, 'P', & ! 2087
     &         14.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9433795998D0, -7.041465015814D-05, -5.5330D-23,  362, 'P', & ! 2088
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9328793605D0, -7.040649633049D-05,  3.1039D-23,  733, 'R', & ! 2089
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6035448926D0, -7.038607831752D-05, -4.3444D-23,  732, 'P', & ! 2090
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2091,2100 ) &
     &             /                 &
     & 3.8108570674D0, -7.034835771816D-05,  1.1795D-22,  338, 'R', & ! 2091
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6284178708D0, -7.033766075580D-05,  1.1067D-22,  207, 'R', & ! 2092
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7291639814D0, -7.032696379343D-05,  1.0340D-22,  339, 'R', & ! 2093
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8389553858D0, -7.030445013731D-05,  6.8819D-23,  492, 'R', & ! 2094
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4372488295D0, -7.030334942524D-05,  4.5589D-23,   68, 'P', & ! 2095
     &        398.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3964022574D0, -7.029266018854D-05,  3.7251D-23,  731, 'P', & ! 2096
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.5379949401D0, -7.029265246287D-05,  3.8314D-23,   14, 'P', & ! 2097
     &     -14140.0D0,         0.4D0,    -1925.0D0,      0.0D0,     & !
     & 3.4664932636D0, -7.028731734014D-05, -4.3444D-23,  730, 'P', & ! 2098
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5225263368D0, -7.028206714162D-05,  3.1039D-23,  728, 'P', & ! 2099
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.3555557435D0, -7.028195550051D-05,  3.1039D-23,    7, 'P', & ! 2100
     &     -70209.0D0,         2.7D0,    -2230.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2101,2110 ) &
     &             /                 &
     & 5.4971484262D0, -7.028194777483D-05,  3.2102D-23,  726, 'P', & ! 2101
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 5.9487467902D0, -7.028193648119D-05,  3.4242D-23,  363, 'P', & ! 2102
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4717704574D0, -7.028184385939D-05,  3.1039D-23,  725, 'R', & ! 2103
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 6.2484789572D0, -7.028122940877D-05, -3.6169D-23,  724, 'P', & ! 2104
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1731165469D0, -7.027125853814D-05,  2.3764D-23,   15, 'R', & ! 2105
     &       2028.3D0,         0.0D0,    -1925.0D0,      0.0D0,     & !
     & 3.7663075936D0, -7.027123951883D-05,  2.6966D-23,  533, 'P', & ! 2106
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0660397606D0, -7.027053244640D-05, -4.3444D-23,  722, 'P', & ! 2107
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0545952978D0, -7.027015782607D-05,  5.3394D-25,  252, 'P', & ! 2108
     &        -11.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9927834748D0, -7.027014831641D-05,  2.1354D-24,  534, 'P', & ! 2109
     &          0.0D0,         6.3D0,        0.0D0,      0.0D0,     & !
     & 6.0262212756D0, -7.026153748753D-05, -4.3444D-23,  721, 'P', & ! 2110
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2111,2120 ) &
     &             /                 &
     & 4.2738626574D0, -7.026056157578D-05,  1.6488D-23,   76, 'R', & ! 2111
     &        -12.4D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.8836005640D0, -7.025983548404D-05, -5.0719D-23,  720, 'R', & ! 2112
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1553414084D0, -7.025946086370D-05, -6.7413D-24,  130, 'P', & ! 2113
     &        -55.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.8103442782D0, -7.025945135404D-05, -5.1398D-24,  535, 'P', & ! 2114
     &          0.0D0,       -49.1D0,        0.0D0,      0.0D0,     & !
     & 2.4653471479D0, -7.025944184438D-05, -3.5384D-24,  210, 'P', & ! 2115
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5944672807D0, -7.025736522055D-05,  3.3164D-23,  719, 'P', & ! 2116
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9729022118D0, -7.024876390133D-05, -1.4016D-23,  246, 'R', & ! 2117
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6279050815D0, -7.024875439168D-05, -1.2415D-23,  536, 'P', & ! 2118
     &          0.0D0,         7.2D0,        0.0D0,      0.0D0,     & !
     & 0.2829079513D0, -7.024874488202D-05, -1.0814D-23,  364, 'P', & ! 2119
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5546487957D0, -7.024837026168D-05,  3.3164D-23,  718, 'P', & ! 2120
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2121,2130 ) &
     &             /                 &
     & 3.8543809627D0, -7.024766318926D-05, -3.7246D-23,  537, 'P', & ! 2121
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1643867022D0, -7.024764416994D-05, -3.4043D-23,  365, 'P', & ! 2122
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6719417661D0, -7.023696622689D-05, -4.4521D-23,  253, 'P', & ! 2123
     &          6.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.2651328128D0, -7.023694720758D-05, -4.1318D-23,   12, 'P', & ! 2124
     &     -24827.2D0,         0.9D0,     2121.9D0,      0.0D0,     & !
     & 2.0981622196D0, -7.023683556646D-05, -4.1318D-23,  701, 'P', & ! 2125
     &         25.5D0,       -12.6D0,        0.0D0,      0.0D0,     & !
     & 5.7726878767D0, -7.022626926453D-05, -5.1796D-23,  493, 'R', & ! 2126
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0826936162D0, -7.022625024521D-05, -4.8594D-23,   25, 'P', & ! 2127
     &      -4578.8D0,         0.2D0,     -641.7D0,      0.0D0,     & !
     & 0.9002544196D0, -7.021555328285D-05, -5.5869D-23,   59, 'P', & ! 2128
     &        400.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0010005301D0, -7.020485632048D-05, -6.3144D-23,  142, 'R', & ! 2129
     &         -9.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.7782321265D0, -7.015741467052D-05,  3.1039D-23,  717, 'P', & ! 2130
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2131,2140 ) &
     &             /                 &
     & 2.9960445406D0, -7.012784789883D-05,  1.0606D-22,  495, 'R', & ! 2131
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6950840950D0, -7.011605022438D-05,  7.5555D-23,  540, 'P', & ! 2132
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7958302055D0, -7.010535326202D-05,  6.8280D-23,  340, 'R', & ! 2133
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3941236493D0, -7.010425254994D-05,  4.5051D-23,  366, 'P', & ! 2134
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5094795605D0, -7.009964173497D-05,  3.1039D-23,  716, 'P', & ! 2135
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4948697599D0, -7.009355558758D-05,  3.7775D-23,  125, 'P', & ! 2136
     &         80.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3124305632D0, -7.008285862521D-05,  3.0500D-23,   65, 'P', & ! 2137
     &        335.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9056216099D0, -7.008283960590D-05,  3.3703D-23,  231, 'P', & ! 2138
     &         14.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1299913666D0, -7.007216166285D-05,  2.3225D-23,  152, 'R', & ! 2139
     &         -7.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.7231824133D0, -7.007214264353D-05,  2.6428D-23,  254, 'P', & ! 2140
     &          8.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2141,2150 ) &
     &             /                 &
     & 4.2307374772D0, -7.006146470048D-05,  1.5950D-23,  497, 'R', & ! 2141
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5407432167D0, -7.006144568117D-05,  1.9153D-23,  496, 'R', & ! 2142
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4222219677D0, -7.006034496909D-05, -4.0770D-24,   97, 'P', & ! 2143
     &        141.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2397827710D0, -7.004964800673D-05, -1.1352D-23,  190, 'P', & ! 2144
     &         25.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3405288816D0, -7.003895104436D-05, -1.8627D-23,  341, 'R', & ! 2145
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2220076326D0, -7.003785033229D-05, -4.1857D-23,  118, 'P', & ! 2146
     &        -93.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0395684359D0, -7.002715336992D-05, -4.9132D-23,  199, 'P', & ! 2147
     &        -21.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8361639302D0, -7.002715158594D-05, -4.8594D-23,  697, 'P', & ! 2148
     &          4.7D0,        -2.5D0,        0.0D0,      0.0D0,     & !
     & 0.8571292393D0, -7.001645640756D-05, -5.6407D-23,  367, 'P', & ! 2149
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1353585570D0, -6.993944798590D-05,  1.1280D-22,  541, 'P', & ! 2150
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2151,2160 ) &
     &             /                 &
     & 2.9529193604D0, -6.992875102353D-05,  1.0552D-22,  498, 'R', & ! 2151
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7704801637D0, -6.991805406117D-05,  9.8246D-23,  342, 'R', & ! 2152
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4517445796D0, -6.989445871229D-05,  3.7237D-23,  543, 'P', & ! 2153
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7617503191D0, -6.989443969297D-05,  4.0440D-23,  542, 'P', & ! 2154
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2693053830D0, -6.988376174992D-05,  2.9962D-23,  368, 'P', & ! 2155
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8624964297D0, -6.988374273061D-05,  3.3164D-23,   24, 'P', & ! 2156
     &      -5747.9D0,        -0.8D0,      768.1D0,      0.0D0,     & !
     & 3.6800572331D0, -6.987304576824D-05,  2.5889D-23,   42, 'P', & ! 2157
     &      -1297.4D0,         0.0D0,     -305.5D0,      0.0D0,     & !
     & 1.4976180364D0, -6.986234880588D-05,  1.8614D-23,  113, 'R', & ! 2158
     &         76.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.5983641470D0, -6.985165184351D-05,  1.1339D-23,  279, 'R', & ! 2159
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1788824523D0, -6.983875345699D-05, -4.2396D-23,  369, 'P', & ! 2160
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2161,2170 ) &
     &             /                 &
     & 4.4071951058D0, -6.981734051295D-05, -5.3743D-23,  211, 'P', & ! 2161
     &         18.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2247559092D0, -6.980664355058D-05, -6.1018D-23,  370, 'P', & ! 2162
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9097941801D0, -6.972965414824D-05,  1.0498D-22,  499, 'R', & ! 2163
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0195855845D0, -6.970714049212D-05,  7.0406D-23,  544, 'P', & ! 2164
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8193712494D0, -6.968464585531D-05,  3.2626D-23,   77, 'P', & ! 2165
     &       -259.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6369320528D0, -6.967394889295D-05,  2.5351D-23,  143, 'P', & ! 2166
     &        -54.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4544928562D0, -6.966325193058D-05,  1.8075D-23,  343, 'R', & ! 2167
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3640699255D0, -6.961824363766D-05, -5.4282D-23,  545, 'P', & ! 2168
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1766747394D0, -6.953053825363D-05,  1.0765D-22,  371, 'P', & ! 2169
     &          5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7762460692D0, -6.948554898002D-05,  3.2087D-23,  255, 'P', & ! 2170
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2171,2180 ) &
     &             /                 &
     & 3.5938068725D0, -6.947485201766D-05,  2.4812D-23,  372, 'P', & ! 2171
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0045587226D0, -6.946413603598D-05,  2.0740D-23,  373, 'P', & ! 2172
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1918827637D0, -6.875807113397D-05, -8.1739D-23,  500, 'R', & ! 2173
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6026346138D0, -6.874735515229D-05, -8.5811D-23,  546, 'P', & ! 2174
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8323715608D0, -6.860396353229D-05, -6.7171D-24,  344, 'R', & ! 2175
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6499323642D0, -6.859326656993D-05, -1.3992D-23,  501, 'R', & ! 2176
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2431234109D0, -6.859324755061D-05, -1.0789D-23,  547, 'P', & ! 2177
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7419486301D0, -6.855895523937D-05, -7.9074D-23,  374, 'P', & ! 2178
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5595094335D0, -6.854825827700D-05, -8.6350D-23,  232, 'P', & ! 2179
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3770702369D0, -6.853756131464D-05, -9.3625D-23,  345, 'R', & ! 2180
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2181,2190 ) &
     &             /                 &
     & 4.9716855772D0, -6.841556361937D-05,  1.9473D-26,  548, 'P', & ! 2181
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7892463806D0, -6.840486665700D-05, -7.2557D-24,  166, 'R', & ! 2182
     &          5.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.6068071839D0, -6.839416969464D-05, -1.4531D-23,  280, 'R', & ! 2183
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1999982306D0, -6.839415067532D-05, -1.1328D-23,  179, 'P', & ! 2184
     &        -21.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0175590340D0, -6.838345371296D-05, -1.8603D-23,  346, 'R', & ! 2185
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7165985884D0, -6.837165603852D-05, -4.9108D-23,  549, 'P', & ! 2186
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5980773393D0, -6.837055532644D-05, -7.2338D-23,  550, 'P', & ! 2187
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6988234499D0, -6.835985836407D-05, -7.9613D-23,  180, 'P', & ! 2188
     &        -27.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5163842533D0, -6.834916140171D-05, -8.6888D-23,   91, 'P', & ! 2189
     &       -129.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3339450566D0, -6.833846443934D-05, -9.4163D-23,  186, 'R', & ! 2190
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2191,2200 ) &
     &             /                 &
     & 5.4346911672D0, -6.832776747698D-05, -1.0144D-22,  502, 'R', & ! 2191
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2683951041D0, -6.824503858470D-05, -1.2405D-23,  715, 'R', & ! 2192
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2385661364D0, -6.821644772476D-05,  2.6837D-24,  375, 'P', & ! 2193
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7461212003D0, -6.820576978171D-05, -7.7944D-24,  504, 'R', & ! 2194
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0561269398D0, -6.820575076239D-05, -4.5915D-24,  167, 'P', & ! 2195
     &         34.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1568730504D0, -6.819505380003D-05, -1.1867D-23,   55, 'P', & ! 2196
     &       -438.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.9744338538D0, -6.818435683766D-05, -1.9142D-23,  131, 'R', & ! 2197
     &         12.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8559126047D0, -6.818325612559D-05, -4.2372D-23,  551, 'P', & ! 2198
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9598240531D0, -6.817827069028D-05, -1.2405D-23,  714, 'R', & ! 2199
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0751799643D0, -6.817365987530D-05, -2.6417D-23,  505, 'R', & ! 2200
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2201,2210 ) &
     &             /                 &
     & 0.6734734081D0, -6.817255916322D-05, -4.9647D-23,  233, 'P', & ! 2201
     &         10.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7742195187D0, -6.816186220086D-05, -5.6922D-23,  347, 'R', & ! 2202
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4732590730D0, -6.815006452642D-05, -8.7427D-23,  376, 'P', & ! 2203
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7832648125D0, -6.815004550710D-05, -8.4224D-23,  234, 'P', & ! 2204
     &        -12.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8840109231D0, -6.813934854474D-05, -9.1499D-23,  377, 'P', & ! 2205
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5690491940D0, -6.806235914239D-05,  7.4502D-23,  378, 'P', & ! 2206
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3866099974D0, -6.805166218003D-05,  6.7227D-23,  208, 'R', & ! 2207
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2041708008D0, -6.804096521766D-05,  5.9952D-23,  348, 'R', & ! 2208
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7973618475D0, -6.804094619835D-05,  6.3155D-23,  552, 'P', & ! 2209
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3139622052D0, -6.801845156154D-05,  2.5375D-23,  553, 'P', & ! 2210
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2211,2220 ) &
     &             /                 &
     & 2.1954409562D0, -6.801735084947D-05,  2.1451D-24,  116, 'P', & ! 2211
     &         93.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0130017596D0, -6.800665388710D-05, -5.1301D-24,   41, 'P', & ! 2212
     &       1400.8D0,         1.2D0,      336.1D0,      0.0D0,     & !
     & 4.1137478701D0, -6.799595692474D-05, -1.2405D-23,   19, 'P', & ! 2213
     &      -6407.0D0,        -7.4D0,     -336.1D0,      0.0D0,     & !
     & 1.4237536096D0, -6.799593790542D-05, -9.2024D-24,  212, 'P', & ! 2214
     &         17.7D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 3.0028103500D0, -6.799059508510D-05,  6.2078D-23,  729, 'R', & ! 2215
     &          2.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 1.9313086735D0, -6.798525996237D-05, -1.9681D-23,   47, 'R', & ! 2216
     &        183.0D0,         0.2D0,     -336.1D0,      0.0D0,     & !
     & 5.5244997202D0, -6.798524094306D-05, -1.6478D-23,  555, 'P', & ! 2217
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0320547841D0, -6.797456300001D-05, -2.6956D-23,  187, 'R', & ! 2218
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6303482278D0, -6.797346228793D-05, -5.0185D-23,  557, 'P', & ! 2219
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5685364048D0, -6.797345277827D-05, -4.8584D-23,  556, 'P', & ! 2220
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2221,2230 ) &
     &             /                 &
     & 4.2235392745D0, -6.797344326862D-05, -4.6982D-23,  558, 'P', & ! 2221
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7401396323D0, -6.795094863181D-05, -8.4762D-23,   75, 'P', & ! 2222
     &       -276.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 4.8408857428D0, -6.794025166944D-05, -9.2038D-23,  146, 'P', & ! 2223
     &        -51.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6584465462D0, -6.792955470708D-05, -9.9313D-23,  291, 'P', & ! 2224
     &          6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4760073496D0, -6.791885774471D-05, -1.0659D-22,  507, 'R', & ! 2225
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6534905567D0, -6.785254628542D-05,  6.9891D-23,  292, 'P', & ! 2226
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7753357903D0, -6.784682581480D-05, -1.0280D-23,  713, 'P', & ! 2227
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7542366672D0, -6.784184932306D-05,  6.2616D-23,  148, 'P', & ! 2228
     &        -38.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.5717974706D0, -6.783115236069D-05,  5.5341D-23,  281, 'R', & ! 2229
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4532762216D0, -6.783005164862D-05,  3.2111D-23,  379, 'P', & ! 2230
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2231,2240 ) &
     &             /                 &
     & 1.2708370250D0, -6.781935468625D-05,  2.4836D-23,  156, 'P', & ! 2231
     &         33.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.1523157759D0, -6.781825397418D-05,  1.6065D-24,  380, 'P', & ! 2232
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3715831355D0, -6.780865772389D-05,  1.7561D-23,  282, 'R', & ! 2233
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2530618865D0, -6.780755701181D-05, -5.6687D-24,  153, 'P', & ! 2234
     &        -43.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0706226899D0, -6.779686004944D-05, -1.2944D-23,  119, 'P', & ! 2235
     &         68.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.3806284294D0, -6.779684103013D-05, -9.7410D-24,   40, 'P', & ! 2236
     &       1432.8D0,         1.7D0,     -641.7D0,      0.0D0,     & !
     & 1.8881834932D0, -6.778616308708D-05, -2.0219D-23,  247, 'R', & ! 2237
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4813745399D0, -6.778614406776D-05, -1.7016D-23,   96, 'P', & ! 2238
     &        148.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.1835794321D0, -6.778005792038D-05, -1.0280D-23,  712, 'P', & ! 2239
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2989353433D0, -6.777544710540D-05, -2.4291D-23,  559, 'P', & ! 2240
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2241,2250 ) &
     &             /                 &
     & 4.1804140943D0, -6.777434639332D-05, -4.7521D-23,  213, 'P', & ! 2241
     &        -16.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6970144520D0, -6.775185175652D-05, -8.5301D-23,  293, 'P', & ! 2242
     &          5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7977605626D0, -6.774115479415D-05, -9.2576D-23,  560, 'P', & ! 2243
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1980121733D0, -6.772228498482D-05, -1.0280D-23,  711, 'P', & ! 2244
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9839736143D0, -6.769845770306D-05,  1.4171D-22,  508, 'R', & ! 2245
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7928045730D0, -6.766414637249D-05,  7.6628D-23,  214, 'P', & ! 2246
     &         18.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6103653764D0, -6.765344941013D-05,  6.9353D-23,   63, 'P', & ! 2247
     &       -483.8D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.2456207971D0, -6.764772715552D-05, -1.0280D-23,  710, 'P', & ! 2248
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7111114870D0, -6.764275244776D-05,  6.2078D-23,   26, 'P', & ! 2249
     &      -2967.3D0,        -4.0D0,        0.0D0,      0.0D0,     & !
     & 2.0211172265D0, -6.764273342845D-05,  6.5280D-23,  561, 'P', & ! 2250
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2251,2260 ) &
     &             /                 &
     & 2.5286722904D0, -6.763205548540D-05,  5.4802D-23,   61, 'R', & ! 2251
     &         85.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1384101969D0, -6.763132939366D-05, -1.2405D-23,  709, 'P', & ! 2252
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4101510413D0, -6.763095477332D-05,  3.1573D-23,  562, 'P', & ! 2253
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3462330938D0, -6.762135852303D-05,  4.7527D-23,  248, 'R', & ! 2254
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2277118447D0, -6.762025781096D-05,  2.4297D-23,  294, 'P', & ! 2255
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1659000216D0, -6.762024830130D-05,  2.5899D-23,  563, 'P', & ! 2256
     &          0.0D0,        -3.9D0,        0.0D0,      0.0D0,     & !
     & 4.8209028914D0, -6.762023879164D-05,  2.7500D-23,  381, 'P', & ! 2257
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3284579553D0, -6.760956084859D-05,  1.7022D-23,  509, 'R', & ! 2258
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9834608250D0, -6.760955133894D-05,  1.8624D-23,  564, 'P', & ! 2259
     &         -0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.3783497631D0, -6.760844884288D-05, -4.0673D-24,  708, 'P', & ! 2260
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2261,2270 ) &
     &             /                 &
     & 3.5199424457D0, -6.760844111720D-05, -3.0044D-24,  215, 'P', & ! 2261
     &        -12.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5044738424D0, -6.759785579595D-05, -1.0280D-23,  703, 'P', & ! 2262
     &          0.2D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 0.3502623049D0, -6.759784829283D-05, -4.1318D-23,  706, 'P', & ! 2263
     &          1.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.0274975096D0, -6.759776317415D-05, -1.3483D-23,  565, 'P', & ! 2264
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4790958736D0, -6.759775188051D-05, -1.1342D-23,  705, 'P', & ! 2265
     &          0.8D0,         6.3D0,        0.0D0,      0.0D0,     & !
     & 1.3375032491D0, -6.759774415484D-05, -1.0280D-23,    3, 'P', & ! 2266
     &     456686.7D0,       602.7D0,   -30105.0D0,    -15.7D0,     & !
     & 4.4537179630D0, -6.759763251372D-05, -1.0280D-23,  702, 'P', & ! 2267
     &         -0.2D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 0.2265657290D0, -6.759238231520D-05,  6.4203D-23,  700, 'P', & ! 2268
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2966566770D0, -6.758705491815D-05, -1.8618D-23,  698, 'P', & ! 2269
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 5.4382493597D0, -6.758704719247D-05, -1.7555D-23,    8, 'P', & ! 2270
     &      86003.5D0,       113.7D0,    12596.3D0,     30.6D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2271,2280 ) &
     &             /                 &
     & 3.0479872663D0, -6.758632110073D-05, -8.4762D-23,  696, 'P', & ! 2271
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2558101631D0, -6.757635023011D-05, -2.4830D-23,   27, 'P', & ! 2272
     &      -2629.4D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 1.0733709665D0, -6.756565326774D-05, -3.2105D-23,   95, 'R', & ! 2273
     &         25.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1741170770D0, -6.755495630538D-05, -3.9380D-23,  510, 'R', & ! 2274
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4293857011D0, -6.754776115415D-05, -1.0280D-23,  695, 'P', & ! 2275
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.1653872324D0, -6.753134193718D-05, -9.7187D-23,  216, 'P', & ! 2276
     &         15.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9829480358D0, -6.752064497481D-05, -1.0446D-22,  382, 'P', & ! 2277
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7601796321D0, -6.747320332486D-05, -1.0280D-23,  694, 'P', & ! 2278
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8682006418D0, -6.746615020928D-05,  9.9319D-23,  511, 'R', & ! 2279
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5672401962D0, -6.745435253484D-05,  6.8814D-23,  383, 'P', & ! 2280
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2281,2290 ) &
     &             /                 &
     & 4.6679863067D0, -6.744365557247D-05,  6.1539D-23,  162, 'P', & ! 2281
     &         29.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.9779920462D0, -6.744363655316D-05,  6.4742D-23,  256, 'P', & ! 2282
     &        -10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4855471101D0, -6.743295861011D-05,  5.4264D-23,  349, 'R', & ! 2283
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0787381568D0, -6.743293959079D-05,  5.7467D-23,  566, 'P', & ! 2284
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7777777111D0, -6.742114191635D-05,  2.6962D-23,  135, 'P', & ! 2285
     &         67.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4914270661D0, -6.741543038930D-05, -1.0280D-23,  693, 'P', & ! 2286
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5953385145D0, -6.741044495399D-05,  1.9687D-23,  257, 'P', & ! 2287
     &          8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4128993179D0, -6.739974799162D-05,  1.2411D-23,  512, 'R', & ! 2288
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2943780689D0, -6.739864727955D-05, -1.0818D-23,   38, 'P', & ! 2289
     &      -1517.4D0,        -2.3D0,      641.7D0,      0.0D0,     & !
     & 3.0909735631D0, -6.739864549556D-05, -1.0280D-23,  684, 'P', & ! 2290
     &          4.7D0,        -2.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2291,2300 ) &
     &             /                 &
     & 5.3951241794D0, -6.738795031718D-05, -1.8093D-23,   86, 'P', & ! 2291
     &       -180.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.2126849828D0, -6.737725335482D-05, -2.5369D-23,  384, 'P', & ! 2292
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5226907223D0, -6.737723433550D-05, -2.2166D-23,  385, 'P', & ! 2293
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6234368329D0, -6.736653737313D-05, -2.9441D-23,  567, 'P', & ! 2294
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1828560151D0, -6.734866249487D-05, -1.0280D-23,  692, 'P', & ! 2295
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3084751039D0, -6.728954797079D-05,  1.3656D-22,  350, 'R', & ! 2296
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9348668660D0, -6.724453967786D-05,  6.4203D-23,   43, 'P', & ! 2297
     &      -1292.2D0,        -1.6D0,        0.0D0,      0.0D0,     & !
     & 6.0356129766D0, -6.723384271550D-05,  5.6928D-23,   80, 'P', & ! 2298
     &       -226.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.8531737799D0, -6.722314575313D-05,  4.9653D-23,  249, 'R', & ! 2299
     &          9.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6707345833D0, -6.721244879077D-05,  4.2378D-23,  513, 'R', & ! 2300
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2301,2310 ) &
     &             /                 &
     & 1.2512528886D0, -6.719955040425D-05, -1.1357D-23,  235, 'P', & ! 2301
     &        -14.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8444439353D0, -6.719953138494D-05, -8.1540D-24,  386, 'P', & ! 2302
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3519989992D0, -6.718885344189D-05, -1.8632D-23,  387, 'P', & ! 2303
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6620047387D0, -6.718883442257D-05, -1.5429D-23,  568, 'P', & ! 2304
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4795655421D0, -6.717813746021D-05, -2.2704D-23,   85, 'P', & ! 2305
     &       -184.7D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.5803116526D0, -6.716744049784D-05, -2.9980D-23,  175, 'P', & ! 2306
     &        -31.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3978724560D0, -6.715674353548D-05, -3.7255D-23,  514, 'R', & ! 2307
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8917416857D0, -6.704544280257D-05,  6.3665D-23,  149, 'P', & ! 2308
     &        -50.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9924877963D0, -6.703474584021D-05,  5.6389D-23,  258, 'P', & ! 2309
     &         -9.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8100485997D0, -6.702404887784D-05,  4.9114D-23,  515, 'R', & ! 2310
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2311,2320 ) &
     &             /                 &
     & 0.4364403618D0, -6.697904058492D-05, -2.3243D-23,  295, 'P', & ! 2311
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5371864724D0, -6.696834362255D-05, -3.0518D-23,  569, 'P', & ! 2312
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5322304829D0, -6.689133520089D-05,  1.3869D-22,  570, 'P', & ! 2313
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8486165055D0, -6.684634592728D-05,  6.3126D-23,  571, 'P', & ! 2314
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0769291589D0, -6.682493298323D-05,  5.1778D-23,  572, 'P', & ! 2315
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5474385072D0, -6.611886808123D-05, -5.0700D-23,  516, 'R', & ! 2316
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9581903573D0, -6.610815209955D-05, -5.4772D-23,  573, 'P', & ! 2317
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2745763799D0, -6.606316282594D-05, -1.3033D-22,  388, 'P', & ! 2318
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8143190664D0, -6.591975218663D-05, -4.8036D-23,  389, 'P', & ! 2319
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9150651770D0, -6.590905522426D-05, -5.5311D-23,  200, 'P', & ! 2320
     &        -15.8D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2321,2330 ) &
     &             /                 &
     & 3.2250709165D0, -6.590903620494D-05, -5.2108D-23,  574, 'P', & ! 2321
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7326259804D0, -6.589835826189D-05, -6.2586D-23,  351, 'R', & ! 2322
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1448021240D0, -6.576566360426D-05,  2.3783D-23,  352, 'R', & ! 2323
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9623629274D0, -6.575496664190D-05,  1.6508D-23,  517, 'R', & ! 2324
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2723686669D0, -6.575494762258D-05,  1.9711D-23,  390, 'P', & ! 2325
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9536330828D0, -6.573135227370D-05, -4.1299D-23,  391, 'P', & ! 2326
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7711938862D0, -6.572065531133D-05, -4.8574D-23,  157, 'P', & ! 2327
     &         41.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8719399967D0, -6.570995834897D-05, -5.5849D-23,   89, 'P', & ! 2328
     &       -138.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.1819457363D0, -6.570993932965D-05, -5.2646D-23,  201, 'P', & ! 2329
     &         20.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6895008001D0, -6.569926138660D-05, -6.3125D-23,  196, 'R', & ! 2330
     &          3.9D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2331,2340 ) &
     &             /                 &
     & 0.9995065397D0, -6.569924236729D-05, -5.9922D-23,  392, 'P', & ! 2331
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5070616035D0, -6.568856442424D-05, -7.0400D-23,  518, 'R', & ! 2332
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4983317589D0, -6.566495005604D-05, -1.2821D-22,  575, 'P', & ! 2333
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4116826833D0, -6.556654770965D-05,  2.6447D-23,  298, 'P', & ! 2334
     &          8.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2292434867D0, -6.555585074729D-05,  1.9172D-23,  136, 'P', & ! 2335
     &        -51.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.1107222376D0, -6.555475003521D-05, -4.0575D-24,  585, 'P', & ! 2336
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3299895973D0, -6.554515378492D-05,  1.1897D-23,  296, 'R', & ! 2337
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2114683482D0, -6.554405307285D-05, -1.1333D-23,  397, 'P', & ! 2338
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0290291516D0, -6.553335611048D-05, -1.8608D-23,  398, 'P', & ! 2339
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7280687059D0, -6.552155843604D-05, -4.9113D-23,  586, 'P', & ! 2340
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2341,2350 ) &
     &             /                 &
     & 5.8288148165D0, -6.551086147368D-05, -5.6388D-23,  399, 'P', & ! 2341
     &          2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1388205560D0, -6.551084245436D-05, -5.3185D-23,   58, 'P', & ! 2342
     &        564.4D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 0.9563813594D0, -6.550014549200D-05, -6.0460D-23,  110, 'P', & ! 2343
     &        103.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.9417715588D0, -6.549405934461D-05, -5.3724D-23,  691, 'P', & ! 2344
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0571274700D0, -6.548944852963D-05, -6.7736D-23,  400, 'P', & ! 2345
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9386062209D0, -6.548834781755D-05, -9.0965D-23,  401, 'P', & ! 2346
     &         -3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7421657409D0, -6.541245912729D-05,  9.8266D-23,  576, 'R', & ! 2347
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5509966997D0, -6.537814779673D-05,  3.3184D-23,  402, 'P', & ! 2348
     &         -4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3685575031D0, -6.536745083436D-05,  2.5909D-23,   82, 'P', & ! 2349
     &        213.8D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 0.1861183064D0, -6.535675387200D-05,  1.8633D-23,   50, 'P', & ! 2350
     &       -682.2D0,        -1.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2351,2360 ) &
     &             /                 &
     & 3.7793093531D0, -6.535673485268D-05,  2.1836D-23,  260, 'P', & ! 2351
     &         10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2868644170D0, -6.534605690963D-05,  1.1358D-23,  108, 'R', & ! 2352
     &         19.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5968701565D0, -6.534603789031D-05,  1.4561D-23,  587, 'P', & ! 2353
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1044252204D0, -6.533535994727D-05,  4.0830D-24,  393, 'R', & ! 2354
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9859039713D0, -6.533425923519D-05, -1.9147D-23,  588, 'P', & ! 2355
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2959097109D0, -6.533424021587D-05, -1.5944D-23,  403, 'P', & ! 2356
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2781345724D0, -6.532244254143D-05, -4.6449D-23,  589, 'P', & ! 2357
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0956953758D0, -6.531174557907D-05, -5.3724D-23,   16, 'P', & ! 2358
     &      11943.5D0,        30.4D0,     -508.9D0,      0.0D0,     & !
     & 0.9132561791D0, -6.530104861670D-05, -6.0999D-23,   34, 'P', & ! 2359
     &       2249.8D0,         6.0D0,        0.0D0,      0.0D0,     & !
     & 6.0855039662D0, -6.529568677707D-05,  1.3484D-23,  699, 'P', & ! 2360
     &         -4.7D0,        -2.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2361,2370 ) &
     &             /                 &
     & 5.0140022897D0, -6.529035165434D-05, -6.8274D-23,  123, 'P', & ! 2361
     &        -66.2D0,        -0.2D0,      336.1D0,      0.0D0,     & !
     & 2.8315630931D0, -6.527965469197D-05, -7.5549D-23,  394, 'R', & ! 2362
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8266071036D0, -6.520264627032D-05,  9.3655D-23,  404, 'P', & ! 2363
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6263927685D0, -6.518015163351D-05,  5.5875D-23,  405, 'P', & ! 2364
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3254323228D0, -6.516835395907D-05,  2.5370D-23,  299, 'P', & ! 2365
     &         -7.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1429931262D0, -6.515765699670D-05,  1.8095D-23,  236, 'P', & ! 2366
     &         10.7D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.7361841729D0, -6.515763797739D-05,  2.1298D-23,   56, 'P', & ! 2367
     &        576.2D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 4.2437392367D0, -6.514696003434D-05,  1.0820D-23,  577, 'R', & ! 2368
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5537449763D0, -6.514694101502D-05,  1.4023D-23,  117, 'P', & ! 2369
     &         93.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.6544910868D0, -6.513624405266D-05,  6.7473D-24,  406, 'P', & ! 2370
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2371,2380 ) &
     &             /                 &
     & 0.2527845306D0, -6.513514334058D-05, -1.6482D-23,   70, 'P', & ! 2371
     &       -332.2D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 4.3535306412D0, -6.512444637822D-05, -2.3758D-23,  139, 'P', & ! 2372
     &        -61.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.1710914445D0, -6.511374941585D-05, -3.1033D-23,  407, 'P', & ! 2373
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0525701955D0, -6.511264870378D-05, -5.4262D-23,  105, 'P', & ! 2374
     &       -114.1D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.8701309989D0, -6.510195174141D-05, -6.1538D-23,  218, 'P', & ! 2375
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9708771094D0, -6.509125477905D-05, -6.8813D-23,  592, 'P', & ! 2376
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2703826096D0, -6.508308193208D-05,  2.0759D-23,  690, 'P', & ! 2377
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1483603165D0, -6.502494331975D-05,  1.0767D-22,  593, 'P', & ! 2378
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9659211199D0, -6.501424635739D-05,  1.0039D-22,  219, 'P', & ! 2379
     &        -18.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7834819233D0, -6.500354939502D-05,  9.3116D-23,   83, 'P', & ! 2380
     &       -164.0D0,        -0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2381,2390 ) &
     &             /                 &
     & 4.8842280339D0, -6.499285243266D-05,  8.5841D-23,  181, 'R', & ! 2381
     &          4.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7017888373D0, -6.498215547029D-05,  7.8566D-23,  578, 'R', & ! 2382
     &          0.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5832675882D0, -6.498105475822D-05,  5.5336D-23,  594, 'P', & ! 2383
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8932733277D0, -6.498103573890D-05,  5.8539D-23,  595, 'P', & ! 2384
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8754981892D0, -6.496923806446D-05,  2.8034D-23,  408, 'P', & ! 2385
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8039965128D0, -6.496390294173D-05, -5.3724D-23,  689, 'P', & ! 2386
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5768442787D0, -6.495865274321D-05,  2.0759D-23,  686, 'P', & ! 2387
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.5514663099D0, -6.495854882777D-05,  1.9696D-23,  685, 'P', & ! 2388
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 3.6930589926D0, -6.495854110210D-05,  2.0759D-23,    9, 'P', & ! 2389
     &      60345.1D0,       167.6D0,    -3739.3D0,      0.0D0,     & !
     & 0.5260883994D0, -6.495842946098D-05,  2.0759D-23,  687, 'P', & ! 2390
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2391,2400 ) &
     &             /                 &
     & 1.5106197960D0, -6.494784413973D-05,  1.3484D-23,   17, 'P', & ! 2391
     &      11368.0D0,        31.3D0,     1283.3D0,      0.0D0,     & !
     & 5.4035430098D0, -6.494711804799D-05, -5.3724D-23,  682, 'P', & ! 2392
     &         -2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0805392176D0, -6.493812308912D-05, -5.3724D-23,  681, 'P', & ! 2393
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6113659066D0, -6.493714717737D-05,  6.2087D-24,   66, 'P', & ! 2394
     &       -347.9D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2096593503D0, -6.493604646529D-05, -1.7021D-23,  150, 'P', & ! 2395
     &         48.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.1478475273D0, -6.493603695563D-05, -1.5419D-23,  597, 'P', & ! 2396
     &          0.0D0,        -5.2D0,        0.0D0,      0.0D0,     & !
     & 3.4289267100D0, -6.492645021500D-05, -1.0665D-24,  217, 'R', & ! 2397
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3104054609D0, -6.492534950293D-05, -2.4296D-23,  261, 'P', & ! 2398
     &          9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9654083307D0, -6.492533999327D-05, -2.2695D-23,  598, 'P', & ! 2399
     &          0.0D0,        -2.2D0,        0.0D0,      0.0D0,     & !
     & 3.0094450152D0, -6.491355182848D-05, -5.4801D-23,  300, 'P', & ! 2400
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2401,2410 ) &
     &             /                 &
     & 0.8270058186D0, -6.490285486612D-05, -6.2076D-23,  599, 'P', & ! 2401
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2377576687D0, -6.489213888444D-05, -6.6148D-23,   79, 'P', & ! 2402
     &       -229.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.0553184721D0, -6.488144192207D-05, -7.3424D-23,  158, 'P', & ! 2403
     &        -43.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1560645827D0, -6.487074495971D-05, -8.0699D-23,  600, 'P', & ! 2404
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1157353756D0, -6.483400027211D-05,  2.0759D-23,  680, 'P', & ! 2405
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7403567430D0, -6.480445251973D-05,  9.2578D-23,  409, 'P', & ! 2406
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3335477897D0, -6.480443350042D-05,  9.5781D-23,  410, 'P', & ! 2407
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8501481475D0, -6.478193886361D-05,  5.8001D-23,  237, 'P', & ! 2408
     &         13.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9508942580D0, -6.477124190124D-05,  5.0725D-23,  411, 'P', & ! 2409
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6499338124D0, -6.475944422680D-05,  2.0220D-23,   62, 'P', & ! 2410
     &       -496.7D0,        -1.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2411,2420 ) &
     &             /                 &
     & 5.4465293066D0, -6.475944244282D-05,  2.0759D-23,  707, 'P', & ! 2411
     &        -26.4D0,       -12.4D0,        0.0D0,      0.0D0,     & !
     & 1.4674946157D0, -6.474874726444D-05,  1.2945D-23,  126, 'P', & ! 2412
     &        -79.6D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.5682407263D0, -6.473805030207D-05,  5.6701D-24,  412, 'P', & ! 2413
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6780321307D0, -6.471553664595D-05, -2.8907D-23,  413, 'P', & ! 2414
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2904226095D0, -6.460533662512D-05,  9.5242D-23,   84, 'P', & ! 2415
     &       -186.8D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.1079834129D0, -6.459463966276D-05,  8.7967D-23,  176, 'P', & ! 2416
     &        -32.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2087295234D0, -6.458394270039D-05,  8.0692D-23,  579, 'R', & ! 2417
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6068086321D0, -6.456034735151D-05,  1.9682D-23,  414, 'P', & ! 2418
     &         -4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4243694355D0, -6.454965038915D-05,  1.2407D-23,  601, 'P', & ! 2419
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8351212856D0, -6.453893440747D-05,  8.3343D-24,  151, 'P', & ! 2420
     &        -48.6D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2421,2430 ) &
     &             /                 &
     & 0.6526820890D0, -6.452823744510D-05,  1.0591D-24,  262, 'P', & ! 2421
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2472974292D0, -6.440623974983D-05,  9.4703D-23,  301, 'P', & ! 2422
     &         -6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0648582326D0, -6.439554278747D-05,  8.7428D-23,  602, 'P', & ! 2423
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7919961053D0, -6.433983753217D-05,  7.7957D-24,  603, 'P', & ! 2424
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3900719965D0, -6.362305664849D-05, -9.8755D-23,  604, 'P', & ! 2425
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0305607936D0, -6.346894904681D-05, -2.3733D-23,  605, 'P', & ! 2426
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5293860128D0, -6.343465673556D-05, -9.2018D-23,  606, 'P', & ! 2427
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3469468162D0, -6.342395977320D-05, -9.9293D-23,  415, 'P', & ! 2428
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9401378629D0, -6.342394075388D-05, -9.6091D-23,  607, 'P', & ! 2429
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1698748099D0, -6.328054913388D-05, -1.6997D-23,  416, 'P', & ! 2430
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2431,2440 ) &
     &             /                 &
     & 1.9874356133D0, -6.326985217152D-05, -2.4272D-23,  302, 'P', & ! 2431
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5806266600D0, -6.326983315220D-05, -2.1069D-23,  608, 'P', & ! 2432
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0881817239D0, -6.325915520915D-05, -3.1547D-23,  580, 'R', & ! 2433
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8970126826D0, -6.322484387859D-05, -9.6629D-23,  202, 'P', & ! 2434
     &         22.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7145734860D0, -6.321414691623D-05, -1.0390D-22,  417, 'P', & ! 2435
     &          4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0260035191D0, -6.309214922096D-05, -1.0260D-23,  609, 'P', & ! 2436
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1267496297D0, -6.308145225859D-05, -1.7535D-23,  168, 'P', & ! 2437
     &         33.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.9443104331D0, -6.307075529623D-05, -2.4811D-23,  137, 'P', & ! 2438
     &        -52.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.5375014798D0, -6.307073627691D-05, -2.1608D-23,  191, 'P', & ! 2439
     &         25.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.0450565436D0, -6.306005833386D-05, -3.2086D-23,  297, 'R', & ! 2440
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2441,2450 ) &
     &             /                 &
     & 3.3550622831D0, -6.306003931455D-05, -2.8883D-23,  418, 'P', & ! 2441
     &          4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0541018375D0, -6.304824164011D-05, -5.9388D-23,  610, 'P', & ! 2442
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8538875024D0, -6.302574700330D-05, -9.7168D-23,   78, 'P', & ! 2443
     &        242.6D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 2.6714483058D0, -6.301505004093D-05, -1.0444D-22,  154, 'P', & ! 2444
     &         45.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4890091092D0, -6.300435307857D-05, -1.1172D-22,  611, 'P', & ! 2445
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7672384268D0, -6.292734465691D-05,  5.7486D-23,  612, 'P', & ! 2446
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5847992302D0, -6.291664769455D-05,  5.0211D-23,  303, 'P', & ! 2447
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4023600336D0, -6.290595073218D-05,  4.2936D-23,  581, 'R', & ! 2448
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3845848951D0, -6.289415305774D-05,  1.2431D-23,  613, 'P', & ! 2449
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0836244494D0, -6.288235538330D-05, -1.8074D-23,  614, 'P', & ! 2450
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2451,2460 ) &
     &             /                 &
     & 1.9011852528D0, -6.287165842093D-05, -2.5349D-23,  615, 'P', & ! 2451
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4943762995D0, -6.287163940162D-05, -2.2146D-23,   60, 'P', & ! 2452
     &        528.9D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 3.3119371029D0, -6.286094243925D-05, -2.9422D-23,  114, 'P', & ! 2453
     &         97.5D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1294979063D0, -6.285024547689D-05, -3.6697D-23,  419, 'P', & ! 2454
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0109766572D0, -6.284914476481D-05, -5.9926D-23,  220, 'P', & ! 2455
     &        -18.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1117227678D0, -6.283844780245D-05, -6.7202D-23,  420, 'P', & ! 2456
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8107623221D0, -6.282665012801D-05, -9.7706D-23,  421, 'P', & ! 2457
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6233671360D0, -6.273894474398D-05,  6.4223D-23,  422, 'P', & ! 2458
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7241132465D0, -6.272824778162D-05,  5.6947D-23,  192, 'P', & ! 2459
     &         24.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5416740499D0, -6.271755081925D-05,  4.9672D-23,  127, 'P', & ! 2460
     &        -62.5D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2461,2470 ) &
     &             /                 &
     & 6.1348650966D0, -6.271753179994D-05,  5.2875D-23,  423, 'P', & ! 2461
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3592348533D0, -6.270685385689D-05,  4.2397D-23,  259, 'R', & ! 2462
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6514654543D0, -6.269503716313D-05,  1.5095D-23,  616, 'P', & ! 2463
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3505050087D0, -6.268323948869D-05, -1.5410D-23,  617, 'P', & ! 2464
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4512511192D0, -6.267254252633D-05, -2.2685D-23,   20, 'P', & ! 2465
     &       7706.3D0,        31.7D0,     -814.4D0,      0.0D0,     & !
     & 3.2688119226D0, -6.266184556396D-05, -2.9960D-23,   39, 'P', & ! 2466
     &       1452.8D0,         5.8D0,      336.1D0,      0.0D0,     & !
     & 1.0863727260D0, -6.265114860160D-05, -3.7235D-23,  144, 'P', & ! 2467
     &        -44.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.9678514770D0, -6.265004788952D-05, -6.0465D-23,  424, 'P', & ! 2468
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1871188366D0, -6.264045163923D-05, -4.4511D-23,  395, 'R', & ! 2469
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9959497953D0, -6.260614030867D-05, -1.0959D-22,  263, 'P', & ! 2470
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2471,2480 ) &
     &             /                 &
     & 1.8135105987D0, -6.259544334630D-05, -1.1687D-22,  620, 'P', & ! 2471
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6809880663D0, -6.252915090633D-05,  5.6409D-23,  621, 'P', & ! 2472
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4985488697D0, -6.251845394396D-05,  4.9134D-23,  622, 'P', & ! 2473
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0917399164D0, -6.251843492465D-05,  5.2336D-23,  115, 'P', & ! 2474
     &         97.2D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.9093007198D0, -6.250773796228D-05,  4.5061D-23,  221, 'P', & ! 2475
     &         16.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7268615231D0, -6.249704099992D-05,  3.7786D-23,  623, 'P', & ! 2476
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6083402741D0, -6.249594028784D-05,  1.4556D-23,  138, 'P', & ! 2477
     &        -67.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.4259010775D0, -6.248524332548D-05,  7.2812D-24,  238, 'P', & ! 2478
     &        -12.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5266471880D0, -6.247454636311D-05,  6.0365D-27,  624, 'P', & ! 2479
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4081259390D0, -6.247344565104D-05, -2.3224D-23,  109, 'P', & ! 2480
     &       -106.9D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2481,2490 ) &
     &             /                 &
     & 3.2256867424D0, -6.246274868867D-05, -3.0499D-23,  222, 'P', & ! 2481
     &        -18.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0432475458D0, -6.245205172630D-05, -3.7774D-23,  625, 'P', & ! 2482
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1390376668D0, -6.236434634228D-05,  1.2416D-22,  239, 'P', & ! 2483
     &        -10.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9565984702D0, -6.235364937992D-05,  1.1688D-22,  582, 'R', & ! 2484
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9478686256D0, -6.233003501172D-05,  5.9073D-23,  626, 'P', & ! 2485
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0486147361D0, -6.231933804935D-05,  5.1798D-23,   23, 'P', & ! 2486
     &       6202.6D0,        26.9D0,     -814.4D0,      0.0D0,     & !
     & 3.8661755395D0, -6.230864108699D-05,  4.4523D-23,   45, 'P', & ! 2487
     &       1169.2D0,         4.9D0,        0.0D0,      0.0D0,     & !
     & 1.4759134461D0, -6.230791499525D-05, -2.2685D-23,  679, 'P', & ! 2488
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6837363429D0, -6.229794412462D-05,  3.7247D-23,  155, 'P', & ! 2489
     &        -35.7D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.5652150938D0, -6.229684341255D-05,  1.4018D-23,  264, 'P', & ! 2490
     &         10.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2491,2500 ) &
     &             /                 &
     & 1.2202179636D0, -6.229683390289D-05,  1.5619D-23,  629, 'P', & ! 2491
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.7844824534D0, -6.228724716226D-05,  2.9972D-23,  396, 'R', & ! 2492
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3827758972D0, -6.228614645018D-05,  6.7426D-24,  630, 'P', & ! 2493
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3650007587D0, -6.227434877574D-05, -2.3762D-23,  631, 'P', & ! 2494
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5933134122D0, -6.225293583170D-05, -3.5110D-23,  163, 'P', & ! 2495
     &        -37.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.4108742156D0, -6.224223886933D-05, -4.2385D-23,  304, 'P', & ! 2496
     &         -7.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2057038910D0, -6.214273581087D-05,  8.9039D-23,  425, 'P', & ! 2497
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0054895559D0, -6.212024117406D-05,  5.1259D-23,  124, 'P', & ! 2498
     &        -82.4D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.8230503592D0, -6.210954421170D-05,  4.3984D-23,  240, 'P', & ! 2499
     &        -14.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6196458535D0, -6.210954242771D-05,  4.4523D-23,  683, 'P', & ! 2500
     &         -0.9D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2501,2510 ) &
     &             /                 &
     & 1.6406111626D0, -6.209884724933D-05,  3.6709D-23,  632, 'P', & ! 2501
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4737305659D0, -6.197149541202D-05,  5.1798D-23,  688, 'P', & ! 2502
     &         -5.0D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 0.3627930458D0, -6.196613357238D-05,  1.2628D-22,  193, 'P', & ! 2503
     &        -22.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4635391564D0, -6.195543661002D-05,  1.1901D-22,  426, 'P', & ! 2504
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1906770291D0, -6.189973135472D-05,  3.9373D-23,  305, 'P', & ! 2505
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0082378325D0, -6.188903439236D-05,  3.2098D-23,  633, 'P', & ! 2506
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3196678655D0, -6.176703669709D-05,  1.2574D-22,  634, 'P', & ! 2507
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7456277399D0, -6.098385359575D-05, -6.7716D-23,  635, 'P', & ! 2508
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3720195021D0, -6.093884530282D-05, -1.4007D-22,  636, 'P', & ! 2509
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8849417563D0, -6.079545368282D-05, -6.0979D-23,  637, 'P', & ! 2510
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2511,2520 ) &
     &             /                 &
     & 3.7025025597D0, -6.078475672046D-05, -6.8255D-23,  427, 'P', & ! 2511
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0125082992D0, -6.078473770114D-05, -6.5052D-23,  428, 'P', & ! 2512
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3288943218D0, -6.073974842753D-05, -1.4061D-22,  429, 'P', & ! 2513
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4296404324D0, -6.072905146517D-05, -1.4789D-22,  638, 'P', & ! 2514
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2422452462D0, -6.064134608114D-05,  1.4042D-23,  639, 'P', & ! 2515
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3429913568D0, -6.063064911878D-05,  6.7668D-24,  640, 'P', & ! 2516
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9693831190D0, -6.058564082585D-05, -6.5590D-23,  169, 'P', & ! 2517
     &         35.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0701292295D0, -6.057494386349D-05, -7.2866D-23,  306, 'P', & ! 2518
     &          6.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7691687839D0, -6.056314618904D-05, -1.0337D-22,  641, 'P', & ! 2519
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1991200660D0, -6.044224920585D-05,  1.3503D-23,  307, 'P', & ! 2520
     &          7.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2521,2530 ) &
     &             /                 &
     & 4.2998661766D0, -6.043155224349D-05,  6.2282D-24,  265, 'P', & ! 2521
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6098719161D0, -6.043153322417D-05,  9.4310D-24,  308, 'P', & ! 2522
     &          6.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1174269799D0, -6.042085528112D-05, -1.0470D-24,  583, 'R', & ! 2523
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7106180266D0, -6.042083626180D-05,  2.1558D-24,  642, 'P', & ! 2524
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9262579387D0, -6.038654395056D-05, -6.6129D-23,   71, 'P', & ! 2525
     &        303.5D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 5.0270040493D0, -6.037584698819D-05, -7.3404D-23,  141, 'P', & ! 2526
     &         57.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 2.8445648526D0, -6.036515002583D-05, -8.0679D-23,  430, 'P', & ! 2527
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9403549737D0, -6.027744464180D-05,  8.1250D-23,  643, 'P', & ! 2528
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5667467358D0, -6.023243634888D-05,  8.8924D-24,  104, 'P', & ! 2529
     &        118.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.6674928464D0, -6.022173938651D-05,  1.6172D-24,  203, 'P', & ! 2530
     &         21.8D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2531,2540 ) &
     &             /                 &
     & 3.4850536498D0, -6.021104242415D-05, -5.6580D-24,  644, 'P', & ! 2531
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3665324007D0, -6.020994171207D-05, -2.8888D-23,  309, 'P', & ! 2532
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1840932041D0, -6.019924474971D-05, -3.6163D-23,  645, 'P', & ! 2533
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8831327584D0, -6.018744707527D-05, -6.6668D-23,  310, 'P', & ! 2534
     &         -6.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9838788690D0, -6.017675011290D-05, -7.3943D-23,  646, 'P', & ! 2535
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7964836829D0, -6.008904472888D-05,  8.7986D-23,  431, 'P', & ! 2536
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8972297934D0, -6.007834776651D-05,  8.0711D-23,  311, 'P', & ! 2537
     &         -5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7147905968D0, -6.006765080415D-05,  7.3436D-23,  584, 'R', & ! 2538
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5236215556D0, -6.003333947359D-05,  8.3538D-24,   36, 'P', & ! 2539
     &       1532.9D0,         8.8D0,        0.0D0,      0.0D0,     & !
     & 5.6243676661D0, -6.002264251122D-05,  1.0786D-24,   74, 'P', & ! 2540
     &        289.1D0,         1.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2541,2550 ) &
     &             /                 &
     & 3.4419284695D0, -6.001194554886D-05, -6.1966D-24,  266, 'P', & ! 2541
     &         -8.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3234072205D0, -6.001084483678D-05, -2.9426D-23,  647, 'P', & ! 2542
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0683202316D0, -5.996693725593D-05, -7.8554D-23,  312, 'P', & ! 2543
     &         -6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1690663422D0, -5.995624029356D-05, -8.5829D-23,  648, 'P', & ! 2544
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1641103527D0, -5.987923187191D-05,  8.3375D-23,  241, 'P', & ! 2545
     &         12.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2648564632D0, -5.986853490954D-05,  7.6100D-23,  432, 'P', & ! 2546
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9638960176D0, -5.985673723510D-05,  4.5595D-23,  267, 'P', & ! 2547
     &         -9.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7814568210D0, -5.984604027273D-05,  3.8320D-23,  649, 'P', & ! 2548
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4804963753D0, -5.983424259829D-05,  7.8152D-24,  182, 'P', & ! 2549
     &        -28.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.5812424859D0, -5.982354563593D-05,  5.3998D-25,  313, 'P', & ! 2550
     &         -5.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2551,2560 ) &
     &             /                 &
     & 5.4945934103D0, -5.972514328954D-05,  1.5519D-22,  650, 'P', & ! 2551
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1209851724D0, -5.968013499661D-05,  8.2837D-23,   54, 'P', & ! 2552
     &        578.4D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 6.2217312830D0, -5.966943803425D-05,  7.5561D-23,  106, 'P', & ! 2553
     &        109.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 4.0392920864D0, -5.965874107188D-05,  6.8286D-23,  433, 'P', & ! 2554
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9207708373D0, -5.965764035981D-05,  4.5057D-23,  651, 'P', & ! 2555
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6656838485D0, -5.961373277896D-05, -4.0710D-24,  434, 'P', & ! 2556
     &         -4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7664299591D0, -5.960303581659D-05, -1.1346D-23,  652, 'P', & ! 2557
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0778599922D0, -5.948103812132D-05,  8.2298D-23,  268, 'P', & ! 2558
     &        -10.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1786061027D0, -5.947034115896D-05,  7.5023D-23,  653, 'P', & ! 2559
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7183487893D0, -5.932693051964D-05,  1.5732D-22,  435, 'P', & ! 2560
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2561,2570 ) &
     &             /                 &
     & 1.2630474654D0, -5.926052830198D-05,  7.0412D-23,  654, 'P', & ! 2561
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7275752456D0, -5.829964225008D-05, -1.0903D-22,  655, 'P', & ! 2562
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0580583032D0, -5.814555366772D-05, -3.7216D-23,  656, 'P', & ! 2563
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3680640427D0, -5.814553464840D-05, -3.4013D-23,  657, 'P', & ! 2564
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6844500653D0, -5.810054537479D-05, -1.0957D-22,  314, 'P', & ! 2565
     &          8.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5020108687D0, -5.808984841242D-05, -1.1685D-22,  658, 'P', & ! 2566
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3249388624D0, -5.794643777311D-05, -3.4552D-23,  223, 'P', & ! 2567
     &         18.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.1424996658D0, -5.793574081074D-05, -4.1827D-23,  436, 'P', & ! 2568
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5546758095D0, -5.780304615311D-05,  4.4542D-23,  659, 'P', & ! 2569
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3722366129D0, -5.779234919074D-05,  3.7267D-23,  660, 'P', & ! 2570
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2571,2580 ) &
     &             /                 &
     & 3.9654276596D0, -5.779233017143D-05,  4.0470D-23,  661, 'P', & ! 2571
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2818136822D0, -5.774734089782D-05, -3.5090D-23,   98, 'P', & ! 2572
     &        138.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.0993744856D0, -5.773664393545D-05, -4.2365D-23,  183, 'P', & ! 2573
     &         26.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.2001205961D0, -5.772594697309D-05, -4.9641D-23,  662, 'P', & ! 2574
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9223024793D0, -5.759323329614D-05,  3.9931D-23,  224, 'P', & ! 2575
     &         18.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7398632827D0, -5.758253633377D-05,  3.2656D-23,  437, 'P', & ! 2576
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4389028370D0, -5.757073865933D-05,  2.1512D-24,  663, 'P', & ! 2577
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2386885019D0, -5.754824402252D-05, -3.5629D-23,  438, 'P', & ! 2578
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9696002297D0, -5.743914471377D-05,  1.1175D-22,  664, 'P', & ! 2579
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8791772991D0, -5.739413642084D-05,  3.9393D-23,   81, 'P', & ! 2580
     &        218.8D0,         1.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2581,2590 ) &
     &             /                 &
     & 1.6967381024D0, -5.738343945848D-05,  3.2117D-23,  159, 'P', & ! 2581
     &         41.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.7974842130D0, -5.737274249611D-05,  2.4842D-23,  665, 'P', & ! 2582
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4238759751D0, -5.732773420319D-05, -4.7515D-23,  666, 'P', & ! 2583
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5196660962D0, -5.724002881916D-05,  1.1441D-22,  667, 'P', & ! 2584
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0362664539D0, -5.721753418236D-05,  7.6634D-23,  668, 'P', & ! 2585
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8360521188D0, -5.719503954555D-05,  3.8854D-23,  315, 'P', & ! 2586
     &         -5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6536129222D0, -5.718434258319D-05,  3.1579D-23,  669, 'P', & ! 2587
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4765409159D0, -5.704093194387D-05,  1.1388D-22,  147, 'P', & ! 2588
     &         51.4D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 2.2941017193D0, -5.703023498151D-05,  1.0660D-22,  269, 'P', & ! 2589
     &          9.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4334157357D0, -5.684183506858D-05,  1.1334D-22,  670, 'P', & ! 2590
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2591,2600 ) &
     &             /                 &
     & 5.0831309891D0, -5.566043919734D-05, -7.7996D-23,  671, 'P', & ! 2591
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0400058088D0, -5.546134232205D-05, -7.8534D-23,  316, 'P', & ! 2592
     &          6.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8575666122D0, -5.545064535968D-05, -8.5810D-23,  672, 'P', & ! 2593
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6804946059D0, -5.530723472037D-05, -3.5129D-24,  439, 'P', & ! 2594
     &          4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4980554093D0, -5.529653775800D-05, -1.0788D-23,  673, 'P', & ! 2595
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6373694257D0, -5.510813784508D-05, -4.0515D-24,  170, 'P', & ! 2596
     &         32.4D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.4549302291D0, -5.509744088271D-05, -1.1327D-23,  317, 'P', & ! 2597
     &          6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2778582228D0, -5.495403024340D-05,  7.0970D-23,  440, 'P', & ! 2598
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5942442454D0, -5.490904096978D-05, -4.5901D-24,  674, 'P', & ! 2599
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2347330426D0, -5.475493336810D-05,  7.0431D-23,  184, 'P', & ! 2600
     &         26.5D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2601,2609 ) &
     &             /                 &
     & 4.0522938459D0, -5.474423640574D-05,  6.3156D-23,  441, 'P', & ! 2601
     &          5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1916078623D0, -5.455583649281D-05,  6.9893D-23,  675, 'P', & ! 2602
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5489113522D0, -5.440172889113D-05,  1.4491D-22,  442, 'P', & ! 2603
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6496574628D0, -5.439103192877D-05,  1.3764D-22,  676, 'P', & ! 2604
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1123762451D0, -5.282213926931D-05, -4.7496D-23,  443, 'P', & ! 2605
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7528650423D0, -5.266803166763D-05,  2.7526D-23,  677, 'P', & ! 2606
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7097398620D0, -5.246893479233D-05,  2.6987D-23,  318, 'P', & ! 2607
     &          5.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8104859726D0, -5.245823782997D-05,  1.9712D-23,  678, 'P', & ! 2608
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3071034789D0, -5.211573031536D-05,  1.0147D-22,  444, 'P', & ! 2609
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
! --- Contribution to E3 due to a secular part of the nutation-nutation
! --- cross terms
!
      REAL*8      CROSS_NUT_RATE_E3
      DATA        CROSS_NUT_RATE_E3 / -5.9232757709D-18 / ! rad/s  or -3.85559184 mas/Jul_cent
