      SUBROUTINE ADDC_VV ( N, C1, VEC1, C2, VEC2, VEC3 )
! ************************************************************************
! *                                                                      *
! *   Subroutine  ADDC_VV   multiplies vector VEC1 by constant C1,       *
! *   multiply vector VEC2 by constant C2, adds results and pust         *
! *   the summa to vector VEC3.                                          *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ###  12-Dec-96    ADD_VV      v1.0  (d)  L. Petrov   12-Dec-96 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  N, J1
      REAL*8     C1, VEC1(N), C2, VEC2(N), VEC3(N)
!
      DO 410 J1=1,N
         VEC3(J1) = C1*VEC1(J1) + C2*VEC2(J1)
 410  CONTINUE
!
      RETURN
      END  !#!  ADDC_VV  #!#
