      SUBROUTINE NERS_WRITE_LEAPSEC ( NERS, FILOUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine  NERS_WRITE_LEAPSEC 
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ## 17-JUN-2016 NERS_WRITE_LEAPSEC  v1.1 (d) L. Petrov 26-APR-2021 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'ners.i'
      TYPE     ( NERS__TYPE ) :: NERS
      CHARACTER  FILOUT*(*)
      CHARACTER  OUT(NERS__MJUMP)*80, STR*80, COM*128
      INTEGER*4  IUER 
      INTEGER*4  J1, NO, IER
      CHARACTER, EXTERNAL :: GET_CDATE*19, TIM_TO_DATE*23
!
      IF ( NERS%FCS_STATUS .NE. NERS__LOAD ) THEN
           CALL ERR_LOG ( 4361, IUER, 'NERS_WRITE_LEAPSEC', 'Trap of '// &
     &         'internal control: NERS was not loaded. Please execute '// &
     &         'routine ners_load first' )
           RETURN 
      END IF
!
      NO = 0
      NO = NO + 1 ; OUT(NO) = NERS__LS_FMT
      NO = NO + 1 ; OUT(NO) = '# '
      NO = NO + 1 ; OUT(NO) = '# Generated by '//NERS__LABEL//' on '//GET_CDATE()
      NO = NO + 1 ; OUT(NO) = '# '
      NO = NO + 1 ; OUT(NO) = '# Format'
      NO = NO + 1 ; OUT(NO) = '#'
      NO = NO + 1 ; OUT(NO) = '#  1-12 F12.0  UTC interval since 2000.01.01_00:00:00.0'
      NO = NO + 1 ; OUT(NO) = '# 15-33 A19    Calandar epoch on UTC of the leap second jump'
      NO = NO + 1 ; OUT(NO) = '# 36-40 F5.1   Value of the UTC minus TAI function'
      NO = NO + 1 ; OUT(NO) = '#'
!
      DO 410 J1=1,NERS%FCS%NJ
         NO = NO + 1
         STR = TIM_TO_DATE ( NERS%FCS%ARG_UTC_M_TAI(J1), IER )
         WRITE ( OUT(NO), 120 ) NERS%FCS%ARG_UTC_M_TAI(J1), &
     &                          STR(1:19), &
     &                          NERS%FCS%BSPL_UTC_M_TAI(J1)
 120     FORMAT ( F12.1, 2X,A, 2X,F5.1 )
 410  CONTINUE 
      NO = NO + 1
      OUT(NO) = '# '
      NO = NO + 1
      OUT(NO) = NERS__LS_FMT
!
      IER = IUER 
      CALL WR_TEXT ( NO, OUT, FILOUT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4362, IUER, 'NERS_WRITE_LEAPSEC', 'Failure to '// &
     &         'write leap second file into '//FILOUT )
           RETURN 
      END IF
!
! --- Make leapsec file writeable for all
!
      COM = 'chmod u+rw,o+rw,g+rw '//TRIM(FILOUT)//'> /dev/null 2>&1'
      CALL SYSTEM ( TRIM(COM)//CHAR(0) )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN 
      END SUBROUTINE NERS_WRITE_LEAPSEC  !#!#s
!
! ------------------------------------------------------------------------
!
      SUBROUTINE NERS_READ_LEAPSEC ( NERS, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine  NERS_READ_LEAPSEC 
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ## 17-JUN-2016  NERS_READ_LEAPSEC  v1.1 (d) L. Petrov 09-MAY-2017 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'ners.i'
      TYPE     ( NERS__TYPE ) :: NERS
      CHARACTER  BUF(NERS__MJUMP)*80, STR*80
      INTEGER*4  IUER 
      INTEGER*4  J1, J2, IS, NJ, IND, IER
      INTEGER*4, EXTERNAL :: GETPID
      CHARACTER, EXTERNAL :: GET_CDATE*19, TIM_TO_DATE*23
!
      WRITE ( UNIT=STR(1:8), FMT='(I8.8)' ) GETPID()
      IF ( NERS%FCS_STATUS .NE. NERS__INIT  .AND.  &
     &     NERS%FCS_STATUS .NE. NERS__LOAD         ) THEN
           CALL ERR_LOG ( 4371, IUER, 'NERS_READ_LEAPSEC', 'Trap '// &
     &         'of internal control: NERS data structure was not '// &
     &         'initialized or loaded. Please first call rouitne NERS_INIT' )
           RETURN 
      END IF
!
      IER = IUER
      CALL RD_TEXT ( NERS%CNF%LEAPSEC_FILE, NERS__MJUMP, BUF, NJ, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4372, IUER, 'NERS_READ_LEAPSEC', 'Error in '// &
     &         'an attempt to read leap second file '//NERS%CNF%LEAPSEC_FILE )
           RETURN 
      END IF
!
      NERS%FCS%NJ = 0
      DO 410 J1=1,NJ
         IF ( BUF(J1)(1:1) == '#' ) GOTO 410
         NERS%FCS%NJ = NERS%FCS%NJ + 1
 410  CONTINUE 
!
      IF ( ASSOCIATED ( NERS%FCS%ARG_UTC_M_TAI ) ) DEALLOCATE ( NERS%FCS%ARG_UTC_M_TAI )
      ALLOCATE ( NERS%FCS%ARG_UTC_M_TAI(NERS%FCS%NJ), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4372, IUER, 'NERS_READ_LEAPSEC', 'Error in '// &
     &         'an attempt to allocate memory for array NERS%FCS%ARG_UTC_M_TAI' )
           RETURN 
      END IF
!
      IF ( ASSOCIATED ( NERS%FCS%BSPL_UTC_M_TAI ) ) DEALLOCATE ( NERS%FCS%BSPL_UTC_M_TAI )
      ALLOCATE ( NERS%FCS%BSPL_UTC_M_TAI(NERS%FCS%NJ), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4373, IUER, 'NERS_READ_LEAPSEC', 'Error in '// &
     &         'an attempt to allocate memory for array NERS%FCS%BSPL_UTC_M_TAI' )
           RETURN 
      END IF
!
      IND = 0
      DO 420 J2=1,NJ
         IF ( BUF(J2)(1:1) .NE. '#' ) THEN
              IND = IND + 1
              READ ( UNIT=BUF(J2)(1:12),  FMT='(F12.1)', IOSTAT=IER ) NERS%FCS%ARG_UTC_M_TAI(IND)
              IF ( IER .NE. 0 ) THEN
                   WRITE ( UNIT=STR(1:4), FMT='(I4)' ) J2
                   CALL ERR_LOG ( 4375, IUER, 'NERS_READ_LEAPSEC', 'Error '// &
     &                 'in deccoding line '//STR(1:4)//' of the file with '// &
     &                 'leap second '//NERS%CNF%LEAPSEC_FILE )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J2)(36:40), FMT='(F5.1)',  IOSTAT=IER ) NERS%FCS%BSPL_UTC_M_TAI(IND)
              IF ( IER .NE. 0 ) THEN
                   WRITE ( UNIT=STR(1:4), FMT='(I4)' ) J2
                   CALL ERR_LOG ( 4376, IUER, 'NERS_READ_LEAPSEC', 'Error '// &
     &                 'in deccoding line '//STR(1:4)//' of the file with '// &
     &                 'leap second '//NERS%CNF%LEAPSEC_FILE )
                   RETURN 
              END IF
         END IF
 420  CONTINUE 
!
      CALL ERR_LOG ( 0, IUER )
      RETURN 
      END SUBROUTINE  NERS_READ_LEAPSEC  !#!#
