C-----------------------------------------------------------------------
      FUNCTION LENGDS(KGDS)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    LENGDS      RETURN THE LENGTH OF A GRID
C   PRGMMR: IREDELL          ORG: W/NMC23     DATE: 96-07-19
C
C ABSTRACT: GIVEN A GRID DESCRIPTION SECTION (IN W3FI63 FORMAT),
C   RETURN ITS SIZE IN TERMS OF NUMBER OF DATA POINTS.
C
C PROGRAM HISTORY LOG:
C   96-07-19  IREDELL
C
C USAGE:    CALL LENGDS(KGDS)
C   INPUT ARGUMENTS:
C     KGDS         INTEGER (200) GDS PARAMETERS IN W3FI63 FORMAT
C   OUTPUT ARGUMENTS:
C     LENGDS       INTEGER SIZE OF GRID
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN
C
C$$$
      INTEGER KGDS(200)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SPECIAL CASE OF STAGGERED ETA
      IF(KGDS(1).EQ.201) THEN
        LENGDS=KGDS(7)*KGDS(8)-KGDS(8)/2
C  SPECIAL CASE OF FILLED ETA
      ELSEIF(KGDS(1).EQ.202) THEN
        LENGDS=KGDS(7)*KGDS(8)
C  SPECIAL CASE OF THINNED WAFS
      ELSEIF(KGDS(19).EQ.0.AND.KGDS(20).NE.255) THEN
        LENGDS=KGDS(21)
C  GENERAL CASE
      ELSE
        LENGDS=KGDS(2)*KGDS(3)
      ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
