#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "spc.h"
#include "spd_local.h"
/*
# ************************************************************************
# *                                                                      *
# *   Example of using SPD_CLIENT in C.
# *                                                                      *
# * ### 28-APR-2015  spd_cli_example  v1.0 (c) L. Petrov 29-APR-2015 ### *
# *                                                                      *
# ************************************************************************
*/

void main(){
   char spd_cli_conf[128] ;
   char spd_cli_dat[128] ;
   int  spd_cli[spd__size] ;
   int ivrb = 2 ;
   int m_del = 8 ;
   struct struct_spd_2p spd_2p[m_del] ;
   int n_del, k, iuer ;

//
// --- File names 
//
   strncpy  ( (char *) spd_cli_conf, spd__share, sizeof(spd_cli_conf)  ) ;
   strncat ( spd_cli_conf, (const char *) "/spd_cli_example.cnf", sizeof(spd_cli_conf) ) ;

   strncpy  ( (char *) spd_cli_dat, spd__share, sizeof(spd_cli_dat)  ) ;
   strncat ( spd_cli_dat, (const char *) "/spd_cli_example.dat", sizeof(spd_cli_dat) ) ;

   printf ( "spd_cli_conf= %s \n", spd_cli_conf ) ;
   printf ( "spd_cli_dat=  %s \n", spd_cli_dat ) ;

//
// --- Read the file with data 
//
   iuer = -1;
   read_spd_cli_dat ( (char *)spd_cli_dat, &m_del, spd_2p, &n_del, &iuer, sizeof(spd_cli_dat) ) ;
   if ( iuer != 0 ){ 
        printf ( "a:iuer= %d \n", iuer ) ;
        printf ( "Error in reading data from %s\n", spd_cli_dat ) ;
        exit ( 11 ) ;
   }

//
// --- Read the configuration file and initialize SPD_CLI
//
   iuer = -1;
   spd_cli_init ( (char *) spd_cli_conf, (int *)spd_cli, &iuer, sizeof(spd_cli_conf) ) ;
   if ( iuer != 0 ){ 
        printf ( "Error in reading cofiguration file %s\n", spd_cli_conf ) ;
        exit ( 12 ) ;
   }
//
// --- Check whether the server is running
//
   iuer = -1 ;
   spd_cli_ping ( (int *)spd_cli, &ivrb, &iuer ) ;
   if ( iuer != 0 ){ 
        printf ( "Server is not running or unreachable \n" ) ;
        exit ( 13 ) ;
   }
//
// --- Send qc request to the server to compute path delay and get the result
//
   iuer = -1 ;
   spd_cli_get_2pd ( (int *)spd_cli, &n_del, spd_2p, &ivrb, &iuer ) ;
   if ( iuer != 0 ){ 
        printf ( "Error in getting the path delays\n" ) ;
        exit ( 14 ) ;
   }
//
// --- Print results
//
   for ( k=0; k<n_del; k++ ){
       printf ( "Poiunt %4d  mjd: %5d, tai: %8.2f  emi: %13.3f %13.3f %13.3f  rec: %13.3f %13.3f %13.3f  del: %6.4f %6.4f  rder: %12.4g, %12.4g,  eder: %12.4g %12.4g \n", 
                k,
                spd_2p[k].mjd,          spd_2p[k].tai, 
                spd_2p[k].emi_1,        spd_2p[k].emi_2,  spd_2p[k].emi_3,  
                spd_2p[k].rec_1,        spd_2p[k].rec_2,  spd_2p[k].rec_3,  
                spd_2p[k].del_1st,      spd_2p[k].del_2nd,
                spd_2p[k].del_rder_1st, spd_2p[k].del_rder_2nd,
                spd_2p[k].del_eder_1st, spd_2p[k].del_eder_2nd
       );
   }
  exit ( 0 ) ;
}
