      SUBROUTINE SUR_ASTRO_STAT ( SUR, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine SUR_ASTRO_STAT
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 15-JAN-2007  SUR_ASTRO_STAT  v1.7 (d) L. Petrov  02-FEB-2019 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'astro_constants.i'
      INCLUDE   'sur_sked.i'
      TYPE     ( SUR__TYPE ) :: SUR
      CHARACTER  BUF(SUR__M_SOU)*1024
      CHARACTER  USER_NAME*128, USER_REALNAME*128, USER_E_ADDRESS*128
      CHARACTER  STR*8192, STR1*1024, STR2*1024
      INTEGER*4  IUER
      INTEGER*4  J1, J2, J3, J4, J5, J6, J7, J8, J9, J10, J11, J12, J13, J14, &
     &           K_OBS, K_SEC, NOUT, IP, K_CAL, KN_SRC(SUR__M_SOU), &
     &           KS_SRC(SUR__M_SOU), KN_ALL, KS_ALL, IR, &
     &           KOBS, NOBS, NOBS_STA(SUR__M_STA), IER
      REAL*8     TIM_LAST, TIM_VIS, TAG_TIME, CAL_TIME, SEC_TIME, DUR_SEC, &
     &           REC_GB(SUR__M_STA), REC_GB_TOT, SCAN_LEN, GAP, GAP_MAX
      CHARACTER, EXTERNAL :: GET_CDATE*19, MJDSEC_TO_DATE*30
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      CALL GETINFO_USER ( USER_NAME, USER_REALNAME, USER_E_ADDRESS )
!
      NOUT = 1
      BUF(NOUT) = 'Statistics of the schedule '//SUR%EXP_CODE
      NOUT = NOUT + 1
      BUF(NOUT) = 'Generator: '//SUR__LABEL
      NOUT = NOUT + 1
      BUF(NOUT) = 'Generated by '//USER_REALNAME(1:I_LEN(USER_REALNAME))// &
     &            ' at '//GET_CDATE()
      NOUT = NOUT + 1
      BUF(NOUT) = 'Time start schedule generation '//SUR%CDATE_START(1:19)
      NOUT = NOUT + 1
      BUF(NOUT) = 'Time stop  schedule generation '//SUR%CDATE_STOP(1:19)
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      CALL INCH  ( SUR%L_SOU, STR )
      BUF(NOUT) = 'Total number of target sources: '//STR(1:I_LEN(STR))
      TAG_TIME = 0.0D0
      SEC_TIME = 0.0D0
      CAL_TIME = 0.0D0
      GAP_MAX  = 0.0D0
      DO 410 J1=1,SUR%L_SCN
         SCAN_LEN = (SUR%MJD_OBS_END(J1) - SUR%MJD_OBS_BEG(J1))*86400.0D0 + &
     &              (SUR%TAI_OBS_END(J1) - SUR%TAI_OBS_BEG(J1))
         IF ( SUR%SRC_TYP(J1) == SUR__TYP_TAG ) THEN
              TAG_TIME = TAG_TIME + SCAN_LEN
            ELSE IF ( SUR%SRC_TYP(J1) == SUR__TYP_SEC ) THEN
              SEC_TIME = SEC_TIME + SCAN_LEN
            ELSE IF ( SUR%SRC_TYP(J1) == SUR__TYP_CAL ) THEN
              CAL_TIME = CAL_TIME + SCAN_LEN
         END IF
         IF ( J1 > 1 ) THEN
              GAP = ( SUR%MJD_OBS_BEG(J1) - SUR%MJD_OBS_END(J1-1) )*86400.0D0 + &
     &              ( SUR%TAI_OBS_BEG(J1) - SUR%TAI_OBS_END(J1-1) )
              IF ( GAP > GAP_MAX ) THEN
                   GAP_MAX = GAP
              END IF
         END IF
 410  CONTINUE
!
      CALL CLRCH ( STR )
      WRITE ( UNIT=STR(1:5),   FMT='(F5.2)' ) ( (SUR%MJD_STOP - SUR%MJD_START)*86400.0D0 + &
     &                                          (SUR%TAI_STOP - SUR%TAI_START) )/3600.0D0
      BUF(NOUT) = 'Total experiment duration: '//STR(1:5)//' hours'
!
      CALL CLRCH ( STR )
      WRITE ( UNIT=STR(1:5),   FMT='(F5.2)' ) (TAG_TIME+CAL_TIME+SEC_TIME)/3600.0D0
      WRITE ( UNIT=STR(11:15), FMT='(F5.3)' ) (TAG_TIME+CAL_TIME+SEC_TIME)/ &
     &        ( (SUR%MJD_STOP - SUR%MJD_START)*86400.0D0 + &
     &          (SUR%TAI_STOP - SUR%TAI_START) )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      BUF(NOUT) = 'Total on source time:      '//STR(1:5)//' hours, efficiency: '// &
     &             STR(11:15)
!
      CALL CLRCH ( STR )
      WRITE ( UNIT=STR(1:5),   FMT='(F5.2)' ) TAG_TIME/3600.0D0
      WRITE ( UNIT=STR(11:15), FMT='(F5.3)' ) TAG_TIME/ &
     &        ( (SUR%MJD_STOP - SUR%MJD_START)*86400.0D0 + &
     &          (SUR%TAI_STOP - SUR%TAI_START) )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      BUF(NOUT) = 'On target source time:     '//STR(1:5)//' hours, '//&
                  'efficiency: '//STR(11:15)
!
      IF ( CAL_TIME > 0.0D0 ) THEN
           CALL CLRCH ( STR )
           WRITE ( UNIT=STR(1:5),   FMT='(F5.2)' ) SEC_TIME/3600.0D0
!
           NOUT = NOUT + 1
           CALL CLRCH ( BUF(NOUT) )
           BUF(NOUT) = 'On secondary source time:  '//STR(1:5)//' hours'
      END IF
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      WRITE ( UNIT=STR(1:6), FMT='(F6.0)' ) GAP_MAX
      BUF(NOUT) = 'Maximum gap between scans: '//STR(1:5)//' sec'
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
!
      NOUT = NOUT + 1
      BUF(NOUT) = '          Name                   Vis len  Time of obs wrt'
      NOUT = NOUT + 1
      BUF(NOUT) = '                                 hours    schedule start'
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
!
      CALL NOUT_I4 ( SUR__M_SOU, KN_SRC )
      CALL NOUT_I4 ( SUR__M_SOU, KS_SRC )
!
      DO 420 J2=1,SUR%L_SOU
         K_OBS = 0
         CALL CLRCH ( STR )
         DO 430 J3=1,SUR%L_SCN
            IF ( SUR%IND_SRC(J3) == J2           .AND. &
     &           SUR%SRC_TYP(J3) == SUR__TYP_TAG       ) THEN
!
                 K_OBS = K_OBS + 1
                 IP = (K_OBS -1)*6 + 1
                 TIM_LAST = (SUR%MJD_OBS_BEG(J3) - SUR%MJD_START)*86400.0D0 + &
     &                      (SUR%TAI_OBS_BEG(J3) - SUR%TAI_START)
                 WRITE ( STR(IP:IP+4), FMT='(F5.2)' ) TIM_LAST/3600.0D0
                 CALL CHASHR ( STR(IP:IP+4) )
            END IF
 430     CONTINUE
         IF ( IP == 0 ) IP = 1
!
         TIM_VIS = 0.0D0
         IF ( SUR%N_VIS(J2,SUR__TYP_TAG) > 0 ) THEN
              CALL CLRCH ( STR1 )
              IR = 1
              DO 440 J4=1,SUR%N_VIS(J2,SUR__TYP_TAG)
                 TIM_VIS = TIM_VIS + (SUR%MJD_VIS(J4,SUR__SET,J2,SUR__TYP_TAG) - &
     &                                SUR%MJD_VIS(J4,SUR__RIS,J2,SUR__TYP_TAG))*86400.0D0 + &
     &                               (SUR%TAI_VIS(J4,SUR__SET,J2,SUR__TYP_TAG) - &
     &                                SUR%TAI_VIS(J4,SUR__RIS,J2,SUR__TYP_TAG))
                 WRITE ( UNIT=STR1(IR:), FMT='("[",F5.2,", ",F5.2,"]")' ) &
     &                   (SUR%MJD_VIS(J4,SUR__RIS,J2,SUR__TYP_TAG) - SUR%MJD_START)*24.0D0 +  &
     &                   (SUR%TAI_VIS(J4,SUR__RIS,J2,SUR__TYP_TAG) - SUR%TAI_START)/3600.0D0, &
     &                   (SUR%MJD_VIS(J4,SUR__SET,J2,SUR__TYP_TAG) - SUR%MJD_START)*24.0D0 +  &
     &                   (SUR%TAI_VIS(J4,SUR__SET,J2,SUR__TYP_TAG) - SUR%TAI_START)/3600.0D0
                 IR = ILEN(STR1) + 2
 440          CONTINUE
              TIM_VIS = TIM_VIS/3600.0D0
         END IF
!
         NOUT = NOUT + 1
         CALL CHASHL ( STR1 )
         IF ( SUR%ALGORITHM == 'ASTROMET_12' ) THEN
              NOBS = SUR%NOBS_SRC(J2) - SUR%SOU(J2)%NOBS
            ELSE 
              NOBS = SUR%NOBS_SRC(J2) - SUR%NOBS_SRC_ORIG(J2)
         END IF
         IF ( SUR%SCAN_PER_SOURCE_MAX .LE. 5 ) THEN
              WRITE ( UNIT=BUF(NOUT), FMT=110 ) J2, SUR%SOU(J2)%J2000_NAME, &
     &                NOBS, TIM_VIS, STR(1:29), STR1(1:IR)
            ELSE IF ( SUR%SCAN_PER_SOURCE_MAX .LE. 10 ) THEN
              WRITE ( UNIT=BUF(NOUT), FMT=110 ) J2, SUR%SOU(J2)%J2000_NAME, &
     &                NOBS, TIM_VIS, STR(1:58), STR1(1:IR)
            ELSE IF ( SUR%SCAN_PER_SOURCE_MAX .LE. 15 ) THEN
              WRITE ( UNIT=BUF(NOUT), FMT=110 ) J2, SUR%SOU(J2)%J2000_NAME, &
     &                NOBS, TIM_VIS, STR(1:87), STR1(1:IR)
            ELSE
              WRITE ( UNIT=BUF(NOUT), FMT=110 ) J2, SUR%SOU(J2)%J2000_NAME, &
     &                NOBS, TIM_VIS, STR(1:116), STR1(1:IR)
         END IF 
 110     FORMAT ( 'Tag ', I7,')  ',A,'  Nobs: ', I3, 2X, F5.2,' || ', A, &
     &            ' || ', A )
         IF ( NOBS > 0 ) THEN
              KN_SRC(NOBS) = KN_SRC(NOBS) + 1
         END IF
 420  CONTINUE
!
      IF ( SUR%L_SO2 > 0 ) THEN
           DO 450 J5=1,SUR%L_SO2
              IF ( SUR%ALGORITHM == 'ASTROMET_12' ) THEN
                   NOBS = SUR%NOBS_SO2(J5) - SUR%SO2(J5)%NOBS
                 ELSE 
                   NOBS = SUR%NOBS_SO2(J5) - SUR%NOBS_SO2_ORIG(J5)
              END IF
              IF ( NOBS > 0 ) THEN
                   KS_SRC(NOBS) = KS_SRC(NOBS) + 1
              END IF
 450       CONTINUE 
      END IF
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      BUF(NOUT) = 'Source usage statistics: '
      KN_ALL = 0
      DO 460 J6=1,128
         IF ( KN_SRC(J6) > 0 ) THEN
              NOUT = NOUT + 1
              WRITE ( UNIT=BUF(NOUT), FMT=120 ) KN_SRC(J6), J6
 120          FORMAT ( 'Tag_usage:  ', I4,' sources are observed in ', &
     &                  I2, ' scans' )
              KN_ALL = KN_ALL + KN_SRC(J6)
         END IF
 460  CONTINUE
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
!
      KS_ALL = 0
      DO 470 J7=1,128
         IF ( KS_SRC(J7) > 0 ) THEN
              NOUT = NOUT + 1
              WRITE ( UNIT=BUF(NOUT), FMT=130 ) KS_SRC(J7), J7
 130          FORMAT ( 'Sec_usage:  ', I4,' sources are observed in ', &
     &                  I2, ' scans' )
              KS_ALL = KS_ALL + 1
         END IF
 470  CONTINUE
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
!
      WRITE ( UNIT=BUF(NOUT), FMT=125 ) KN_ALL
 125  FORMAT ( 'Tag_usage:  ', I4, ' target    sources are observed on total' )
      NOUT = NOUT + 1
      WRITE ( UNIT=BUF(NOUT), FMT=135 ) KS_ALL
 135  FORMAT ( 'Sec_usage:  ', I4, ' secondary sources are observed on total' )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      NOUT = NOUT + 1
      CALL CLRCH   ( BUF(NOUT) )
!
      BUF(NOUT) = 'Calibrator section  '
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      K_CAL = 0
      DO 480 J8=1,SUR%L_CAL
         K_OBS = 0
         CALL CLRCH ( STR )
         DO 490 J9=1,SUR%L_SCN
            IF ( SUR%IND_SRC(J9) == J8           .AND. &
     &           SUR%SRC_TYP(J9) == SUR__TYP_CAL       ) THEN
!
                 K_OBS = K_OBS + 1
                 IP = (K_OBS-1)*6 + 1
                 TIM_LAST = (SUR%MJD_OBS_BEG(J9) - SUR%MJD_START)*86400.0D0 + &
     &                      (SUR%TAI_OBS_BEG(J9) - SUR%TAI_START)
                 WRITE ( STR(IP:IP+4), FMT='(F5.2)' ) TIM_LAST/3600.0D0
            END IF
 490     CONTINUE
!
         IF ( K_OBS > 0 ) THEN
              K_CAL = K_CAL + 1
              NOUT = NOUT + 1
              WRITE ( UNIT=BUF(NOUT), FMT=140, IOSTAT=IER ) &
     &                K_CAL, SUR%CAL(J8)%J2000_NAME, SUR%CAL(J8)%B1950_NAME, &
     &                K_OBS, STR(1:I_LEN(STR))
 140          FORMAT ( 'Cal ', I3,')  ',A, 2X, A, '  Nobs: ',I3, ' || ', A )
         END IF
 480  CONTINUE
!
      K_SEC = 0
      IF ( SEC_TIME > 0.0D0 .AND. SUR%L_SO2 > 0 ) THEN
!
           NOUT = NOUT + 1
           CALL CLRCH   ( BUF(NOUT) )
           NOUT = NOUT + 1
           BUF(NOUT) = 'Secondary sources section  '
           NOUT = NOUT + 1
           CALL CLRCH   ( BUF(NOUT) )
!
           DO 4100 J10=1,SUR%L_SO2
              K_OBS = 0
              CALL CLRCH ( STR )
              DO 4110 J11=1,SUR%L_SCN
                 IF ( SUR%IND_SRC(J11) == J10           .AND. &
     &                SUR%SRC_TYP(J11) == SUR__TYP_SEC       ) THEN
!
                      K_OBS = K_OBS + 1
                      IP = (K_OBS -1)*6 + 1
                      TIM_LAST = (SUR%MJD_OBS_BEG(J11) - SUR%MJD_START)*86400.0D0 + &
     &                           (SUR%TAI_OBS_BEG(J11) - SUR%TAI_START)
                      WRITE ( STR(IP:IP+4), FMT='(F5.2)' ) TIM_LAST/3600.0D0
                 END IF
 4110         CONTINUE
!
              IF ( K_OBS > 0 ) THEN
                   K_SEC = K_SEC + 1
                   NOUT = NOUT + 1
                   WRITE ( UNIT=BUF(NOUT), FMT=150, IOSTAT=IER ) &
     &                     K_SEC, SUR%SO2(J10)%J2000_NAME, K_OBS, STR(1:I_LEN(STR))
 150               FORMAT ( 'Sec ', I4,')  ',A,'  Nobs: ',I3, ' || ', A )
              END IF
 4100      CONTINUE
      END IF
!
      NOBS = 0
      CALL NOUT_I4 ( SUR__M_STA, NOBS_STA )
      CALL NOUT_R8 ( SUR__M_STA, REC_GB   )
      DO 4120 J12=1,SUR%L_SCN
         KOBS = 0
         DO 4130 J13=1,SUR%L_STA
            IF ( SUR%OBS_STA(J13,J12) == SUR__USED ) THEN
                 KOBS = KOBS + 1
                 NOBS_STA(J13) = NOBS_STA(J13) + 1
                 SCAN_LEN = (SUR%MJD_OBS_END(J12) - SUR%MJD_OBS_BEG(J12))*86400.0D0 + &
     &                      (SUR%TAI_OBS_END(J12) - SUR%TAI_OBS_BEG(J12))
                 REC_GB(J13) = REC_GB(J13) + SCAN_LEN*SUR%RECORDING_RATE/1.D9/8.0
            END IF
 4130     CONTINUE
         NOBS = NOBS + (KOBS*(KOBS-1))/2
 4120 CONTINUE
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      WRITE ( UNIT=BUF(NOUT), FMT=160, IOSTAT=IER ) SUR%L_SCN, NOBS
 160  FORMAT ( '# scans: ',I4, 4X, '# observations: ',I6 )
!
      DUR_SEC = (SUR%MJD_STOP - SUR%MJD_START)*86400.0D0 + &
     &          (SUR%TAI_STOP - SUR%TAI_START)
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      WRITE ( UNIT=BUF(NOUT), FMT=170, IOSTAT=IER ) SUR%RECORDING_RATE*1.D-6
 170  FORMAT ( 'Recording rate: ', F7.1,' Mbps' )
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
!
      REC_GB_TOT = 0.0D0
      DO 4140 J14=1,SUR%L_STA
         NOUT = NOUT + 1
         WRITE ( UNIT=BUF(NOUT), FMT=180, IOSTAT=IER ) J14, &
     &           SUR%STA(J14)%NAME, NOBS_STA(J14), &
     &           NOBS_STA(J14)/DUR_SEC*3600.0D0, REC_GB(J14)
 180     FORMAT ( 'STA:  ',I2,') ',A, 2X, ' # scans: ', I4, 2X, &
     &            ' scans/hour: ', F5.2, ' data amount: ', F8.1, ' Gb' )
         REC_GB_TOT = REC_GB_TOT + REC_GB(J14)
 4140 CONTINUE
!
      NOUT = NOUT + 1
      CALL CLRCH ( BUF(NOUT) )
      NOUT = NOUT + 1
      WRITE ( UNIT=BUF(NOUT), FMT=190, IOSTAT=IER ) REC_GB_TOT
 190  FORMAT ( 'Total recorded data: ', F8.1, ' Gb' )
!
! --- Write down the file
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT  ( NOUT, BUF, SUR%OUT_STAT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 1761, IUER, 'SUR_ASTRO_STAT', 'Error in '// &
     &         'an attempt to write in the output statistics file '// &
     &          SUR%OUT_STAT )
           RETURN
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  SUR_ASTRO_STAT  !#!#
