#include <mk5_preprocessor_directives.inc>
      SUBROUTINE TRSM4_3  ( N, A, B, LB )
! ************************************************************************
! *                                                                      *
! *   Solves B=A'*X , B(M,N), A(N,N).                                    *
! *   B dimensioned as (LB,N), A in upper triangular format.             *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.11.28 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  N, LB
      REAL*8     A(*), B(LB,N)
!
      IF ( N .EQ. 1 ) THEN
           B( 1 ,1) = B( 1 ,1 ) / A( 1 )
           B( 2 ,1) = B( 2 ,1 ) - A( 2 ) * B( 1 ,1 )
           B( 2 ,1) = B( 2 ,1 ) / A( 3 )
           B( 3 ,1) = B( 3 ,1 ) - A( 4 ) * B( 1 ,1 )
           B( 3 ,1) = B( 3 ,1 ) - A( 5 ) * B( 2 ,1 )
           B( 3 ,1) = B( 3 ,1 ) / A( 6 )
        ELSE IF ( N .EQ. 2 ) THEN
           B( 1 ,1) = B( 1 ,1 ) / A( 1 )
           B( 1 ,2) = B( 1 ,2 ) / A( 1 )
           B( 2 ,1) = B( 2 ,1 ) - A( 2 ) * B( 1 ,1 )
           B( 2 ,2) = B( 2 ,2 ) - A( 2 ) * B( 1 ,2 )
           B( 2 ,1) = B( 2 ,1 ) / A( 3 )
           B( 2 ,2) = B( 2 ,2 ) / A( 3 )
           B( 3 ,1) = B( 3 ,1 ) - A( 4 ) * B( 1 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 4 ) * B( 1 ,2 )
           B( 3 ,1) = B( 3 ,1 ) - A( 5 ) * B( 2 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 5 ) * B( 2 ,2 )
           B( 3 ,1) = B( 3 ,1 ) / A( 6 )
           B( 3 ,2) = B( 3 ,2 ) / A( 6 )
        ELSE IF ( N .EQ. 3 ) THEN
           B( 1 ,1) = B( 1 ,1 ) / A( 1 )
           B( 1 ,2) = B( 1 ,2 ) / A( 1 )
           B( 1 ,3) = B( 1 ,3 ) / A( 1 )
           B( 2 ,1) = B( 2 ,1 ) - A( 2 ) * B( 1 ,1 )
           B( 2 ,2) = B( 2 ,2 ) - A( 2 ) * B( 1 ,2 )
           B( 2 ,3) = B( 2 ,3 ) - A( 2 ) * B( 1 ,3 )
           B( 2 ,1) = B( 2 ,1 ) / A( 3 )
           B( 2 ,2) = B( 2 ,2 ) / A( 3 )
           B( 2 ,3) = B( 2 ,3 ) / A( 3 )
           B( 3 ,1) = B( 3 ,1 ) - A( 4 ) * B( 1 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 4 ) * B( 1 ,2 )
           B( 3 ,3) = B( 3 ,3 ) - A( 4 ) * B( 1 ,3 )
           B( 3 ,1) = B( 3 ,1 ) - A( 5 ) * B( 2 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 5 ) * B( 2 ,2 )
           B( 3 ,3) = B( 3 ,3 ) - A( 5 ) * B( 2 ,3 )
           B( 3 ,1) = B( 3 ,1 ) / A( 6 )
           B( 3 ,2) = B( 3 ,2 ) / A( 6 )
           B( 3 ,3) = B( 3 ,3 ) / A( 6 )
        ELSE IF ( N .EQ. 4 ) THEN
           B( 1 ,1) = B( 1 ,1 ) / A( 1 )
           B( 1 ,2) = B( 1 ,2 ) / A( 1 )
           B( 1 ,3) = B( 1 ,3 ) / A( 1 )
           B( 1 ,4) = B( 1 ,4 ) / A( 1 )
           B( 2 ,1) = B( 2 ,1 ) - A( 2 ) * B( 1 ,1 )
           B( 2 ,2) = B( 2 ,2 ) - A( 2 ) * B( 1 ,2 )
           B( 2 ,3) = B( 2 ,3 ) - A( 2 ) * B( 1 ,3 )
           B( 2 ,4) = B( 2 ,4 ) - A( 2 ) * B( 1 ,4 )
           B( 2 ,1) = B( 2 ,1 ) / A( 3 )
           B( 2 ,2) = B( 2 ,2 ) / A( 3 )
           B( 2 ,3) = B( 2 ,3 ) / A( 3 )
           B( 2 ,4) = B( 2 ,4 ) / A( 3 )
           B( 3 ,1) = B( 3 ,1 ) - A( 4 ) * B( 1 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 4 ) * B( 1 ,2 )
           B( 3 ,3) = B( 3 ,3 ) - A( 4 ) * B( 1 ,3 )
           B( 3 ,4) = B( 3 ,4 ) - A( 4 ) * B( 1 ,4 )
           B( 3 ,1) = B( 3 ,1 ) - A( 5 ) * B( 2 ,1 )
           B( 3 ,2) = B( 3 ,2 ) - A( 5 ) * B( 2 ,2 )
           B( 3 ,3) = B( 3 ,3 ) - A( 5 ) * B( 2 ,3 )
           B( 3 ,4) = B( 3 ,4 ) - A( 5 ) * B( 2 ,4 )
           B( 3 ,1) = B( 3 ,1 ) / A( 6 )
           B( 3 ,2) = B( 3 ,2 ) / A( 6 )
           B( 3 ,3) = B( 3 ,3 ) / A( 6 )
           B( 3 ,4) = B( 3 ,4 ) / A( 6 )
        ELSE
           CALL DSCAL ( N, 1.0D0 / A( 1 ), B( 1 ,1 ), LB )
           CALL DAXPY ( N, -A( 2 ), B( 1 ,1), LB, B( 2 ,1), LB )
           CALL DSCAL ( N, 1.0D0 / A( 3 ), B( 2 ,1 ), LB )
           CALL DAXPY ( N, -A( 4 ), B( 1 ,1), LB, B( 3 ,1), LB )
           CALL DAXPY ( N, -A( 5 ), B( 2 ,1), LB, B( 3 ,1), LB )
           CALL DSCAL ( N, 1.0D0 / A( 6 ), B( 3 ,1 ), LB )
      END IF
!
      RETURN 
      END SUBROUTINE TRSM4_3 
