      SUBROUTINE B1950_TO_J2000 ( S_B1950, S_J2000 )
! ************************************************************************
! *                                                                      *
! *   Routine for conversion from J2000.0 to B1950.0                     *
! *   Source: equation 71 in T. Fukushima "A new precession formula",    *
! *   Astron. J., vol. 126, pp. 494-534, 2003.                           *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 11-SEP-2003  B1950_TO_J2000   v1.0 (d) L. Petrov 11-SEP-2003 ### *
! *                                                                      *
! ************************************************************************
      REAL*8     S_B1950(3), S_J2000(3)
      REAL*8     MAT(3,3)
      INTEGER*4  IER
!
   MAT(1,1)= 0.999925712D0; MAT(1,2)= -0.011178667D0; MAT(1,3)= -0.004858799D0
   MAT(2,1)= 0.011178667D0; MAT(2,2)=  0.999937516D0; MAT(2,3)= -0.000027189D0
   MAT(3,1)= 0.004858799D0; MAT(3,2)= -0.000027127D0; MAT(3,3)=  0.999988196D0
!
      CALL MUL_MV_IV_V ( 3, 3, MAT, 3, S_B1950, 3, S_J2000, IER )
!
      RETURN
      END  !#!  B1950_TO_J2000  #!#
