      PROGRAM    SPD_CLI_EXAMPLE
! ************************************************************************
! *                                                                      *
! *   Program SPD_CLI_EXAMPLE is the example of computing path delay     *
! *   using SPD server.                                                  *
! *                                                                      *
! * ### 28-APR-2015  SPD_CLI_EXAMPLE v1.0 (c) L. Petrov  28-APR-2015 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'spd.i'
      INCLUDE   'spd_local.i'
      INTEGER*4  M_DEL, MO
      PARAMETER  ( M_DEL =   8 )
      PARAMETER  ( MO    = 256 )
      TYPE     ( SPD_CLI__TYPE ) :: SPD_CLI
      TYPE     ( SPD_2P__TYPE  ) :: SPD_2P(M_DEL)
      CHARACTER  SPD_CLI_CONF*128, SPD_CLI_DAT*128, BUF(MO)*256, FILO*128
      INTEGER*4  N_DEL, NO, J1, IVRB, IUER
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      SPD_CLI_CONF = SPD__SHARE//'/spd_cli_example.cnf'
      SPD_CLI_DAT  = SPD__SHARE//'/spd_cli_example.dat'
      FILO = '/tmp/spd_cli_res.txt'
      IVRB = 2
!
! --- Read the file with data 
!
      IUER = -1
      CALL READ_SPD_CLI_DAT ( SPD_CLI_DAT, M_DEL, SPD_2P, N_DEL, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
! --- Read the configuration file and initialize SPD_CLI
!
      IUER = -1
      CALL SPD_CLI_INIT ( SPD_CLI_CONF, SPD_CLI, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
! --- Check whether the server is running
!
      IUER = -1
      CALL SPD_CLI_PING ( SPD_CLI, IVRB, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
! --- Send request to the server to compute path delay and get the result
!
      IUER = -1
      CALL SPD_CLI_GET_2PD ( SPD_CLI, N_DEL, SPD_2P, IVRB, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
! --- Just create the output file
!
      NO = 0
      NO = NO + 1; BUF(NO) = '# Two-point data for delay computation. Format of 2015.01.24'
      NO = NO + 1; BUF(NO) = '#'
      NO = NO + 1; BUF(NO) = '# ----------------------------------------------------------------------------------------------------------------------------------------------------'
      NO = NO + 1; BUF(NO) = '#'
      NO = NO + 1; BUF(NO) = '#  Format description:'
      NO = NO + 1; BUF(NO) = '#'
      NO = NO + 1; BUF(NO) = '# Filed      Position  Format   Units          Meaning'
      NO = NO + 1; BUF(NO) = '# -----      --------  ------   -----          -------'
      NO = NO + 1; BUF(NO) = '# Poi ID     1:9       I9       n/a            A unique integer number that identifies the pulse'
      NO = NO + 1; BUF(NO) = '# MJD        11:15     I5       day            Integer modified Julian date at  the midnight'
      NO = NO + 1; BUF(NO) = '# TAI        17:23     F7.1     sec            Time of the pulse emission in TAI scale'
      NO = NO + 1; BUF(NO) = '# X_emi      26:38     F13.4    meter          X-coordinate of the emitter  in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# Y_emi      40:52     F13.4    meter          Y-coordinate of the emitter  in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# Z_emi      54:66     F13.4    meter          Z-coordinate of the emitter  in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# X_bou      69:81     F13.4    meter          X-coordinate of the bouncing point in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# Y_bou      83:95     F13.4    meter          Y-coordinate of the bouncing point in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# Z_bou      97:109    F13.4    meter          Z-coordinate of the bouncing point in the crust fixed system'
      NO = NO + 1; BUF(NO) = '# Del_1     112:117    F6.4     meter          Path delay at 532 nm'
      NO = NO + 1; BUF(NO) = '# Del_2     120:125    F6.4     meter          Path delay at 1064 nm'
      NO = NO + 1; BUF(NO) = '# Der_r1    128:138    1PD11.4  dimensionless  Partial derivative of path delay at  532 nm with respect to receiver height'
      NO = NO + 1; BUF(NO) = '# Der_r2    140:150    1PD11.4  dimensionless  Partial derivative of path delay at 1064 nm with respect to receiver height'
      NO = NO + 1; BUF(NO) = '# Der_e1    152:162    1PD11.4  dimensionless  Partial derivative of path delay at  532 nm with respect to emitter  height'
      NO = NO + 1; BUF(NO) = '# Der_e2    164:174    1PD11.4  dimensionless  Partial derivative of path delay at 1064 nm with respect to emitter  height'
      NO = NO + 1; BUF(NO) = '#'
      NO = NO + 1; BUF(NO) = '# ----------------------------------------------------------------------------------------------------------------------------------------------------'
      NO = NO + 1; BUF(NO) = '#                           Position of the emitter                     Position of the bouncing point'
      NO = NO + 1; BUF(NO) = '#  Poi ID   MJD   TAI     X-coordinate  Y-coordinate  Z-coordinate    X-coordinate  Y-coordinate  Z-coordinate  Delay   Delay   Delay_rder  Delay_rder  Delay_eder  Delay_eder'
      NO = NO + 1; BUF(NO) = '#                                                                                                              532 nm 1064 nm       532 nm     1064 nm      532 nm     1064 nm'
      NO = NO + 1; BUF(NO) = '#'
!
      DO 410 J1=1,N_DEL
         NO = NO + 1
         WRITE ( BUF(NO), 110 ) J1, SPD_2P(J1)%MJD, SPD_2P(J1)%TAI, &
     &                          SPD_2P(J1)%COO_EMI, SPD_2P(J1)%COO_REC, &
     &                          SPD_2P(J1)%DEL, SPD_2P(J1)%DEL_EDER, &
     &                          SPD_2P(J1)%DEL_RDER
 110     FORMAT  ( I9, 1X, I5, 1X, F7.1, 1X, 3(1X,F13.4), 1X,3(1X,F13.4), 2(2X,F6.4), &
     &             1X,2(1X,1PD11.4), 1X,2(1X,1PD11.4) )
 410  CONTINUE 
!
      IUER = -1
      CALL WR_TEXT ( NO, BUF, FILO, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
      WRITE ( 6, '(A)' ) 'Results are written in '//FILO(1:I_LEN(FILO))
!
      END  PROGRAM  !#!#  SPD_CLI_EXAMPLE  #!#!
