      PROGRAM    SPD_DEL_EXAMPLE_FORTRAN
! ************************************************************************
! *                                                                      *
! *   Program SPD_DEL_EXAMPLE_FORTRAN
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ## 10-JAN-2026 SPD_DEL_EXAMPLE_FORTRAN v1.0 (d) L. Petrov 10-JAN-2026 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'spd.i'
      INCLUDE   'spd_local.i'
      INTEGER*4    M_STA, M_DIR
      PARAMETER  ( M_STA = 8 )
      PARAMETER  ( M_DIR = 2 )
      TYPE     ( SPD_DEL__TYPE ) :: SPD(M_STA)
      CHARACTER  C_DIR(M_DIR)*128, C_STA(M_STA)*8
      INTEGER*4  L_DIR, L_STA, MJD_BEG, MJD_OBS, MJD_END, J1, J2, IUER
      REAL*8     TAI_BEG, TAI_OBS, TAI_END, LAYER_HEIGHT, LAYER_FWHM, &
     &           ELEV, AZIM, ELEV_RATE, AZIM_RATE
      REAL*8     SPD_DELAY, SPD_RATE, SPD_DELAY_DER_ZEN, SPD_RATE_DER_ZEN
!
! --- Define directories with slant path delays in binary format.
!
      L_DIR = 1
      C_DIR(1) = SPD__ROOT//'/share/spd_geosit/bin'
!
! --- Define the station list 
!
      L_STA = 2
      C_STA(1) = 'GGAO12M '
      C_STA(2) = 'SVETLOE '
!
! --- Define the range for computation of partial derivatives
!
      LAYER_HEIGHT = 2000.0
      LAYER_FWHM   = 5000.0
!
! --- Derfine the time range for interpolation of slant path delay
!
      MJD_BEG = 61048 ; TAI_BEG = 39600.0 ! Corresponds to 2026.01.08_11:00:00.0
      MJD_END = 61048 ; TAI_END = 48137.0 ! Corresponds to 2026.01.08_13:22:17.0
!
! --- Initialize SPD object 
!
      DO 410 J1=1,L_STA
         IUER = -1
         CALL SPD_DEL_INIT ( SPD(J1), IUER )
         IF ( IUER .NE. 0 ) THEN
              IUER = -1
              CALL ERR_LOG ( 4601, IUER, 'SPD_DEL_EXAMPLE_FORTRAN', 'Failure '// &
     &            'in initialization SPD data structure' )
              CALL EXIT ( 1 ) 
         END IF
 410  CONTINUE 
!
! --- Load data infr SPD objects
!
      IUER = -1
      CALL SPD_LOAD_BSPD ( L_DIR, C_DIR, 'NONE', 'GAUSSIAN_LAYER', &
     &                     LAYER_HEIGHT, LAYER_FWHM, L_STA, C_STA, &
     &                     MJD_BEG, TAI_BEG, MJD_END, TAI_END, &
     &                     SPD, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4602, IUER, 'SPD_DEL_EXAMPLE_FORTRAN', 'Failure '// &
     &         'in loading binary slant path delay data into SPD '// &
     &         'data structures' )
           CALL EXIT ( 1 ) 
      END IF
!
      ELEV = 0.345D0
      AZIM = 2.424D0
      ELEV_RATE = 1.0D-6
      AZIM_RATE = 2.0D-7
      MJD_OBS   = 61048
      TAI_OBS   = 43260 ! 12:01:00
!
! --- Compute path delay and its time derivative using SPD objects 
! --- for station C_STA(1), given elevation and azimith and given time
!
      CALL SPD_INTRP_DELAY ( C_STA(1), L_STA, SPD, ELEV, AZIM, &
     &                       ELEV_RATE, AZIM_RATE, MJD_OBS, TAI_OBS, &
     &                       SPD_DELAY, SPD_RATE, SPD_DELAY_DER_ZEN, &
     &                       SPD_RATE_DER_ZEN, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4603, IUER, 'SPD_DEL_EXAMPLE_FORTRAN', 'Failure '// &
     &         'in commputing slant path delay' )
           CALL EXIT ( 1 ) 
      END IF
!
      WRITE  ( 6, '(A)' ) 'spd_del_example_fortran'
      WRITE  ( 6, '(A)' ) '======================='
      WRITE  ( 6, '(A)' ) ' '
      WRITE  ( 6, '(A)' ) 'Slant path delays are taken from '//TRIM(C_DIR(1))
      WRITE  ( 6, '(A)' ) ' '
      WRITE  ( 6, 110 ) C_STA(1), ELEV, AZIM, ELEV_RATE, AZIM_RATE
 110  FORMAT ( 'Station ', A, ' Elev: ', F9.5, ' Azim: ', F9.5, ' rad '/ &
     &         'Elev_rate: ', 1PD12.5, '  Azim_rate: ', 1PD12.5, ' rad/s' )
      WRITE  ( 6, 120 ) SPD_DELAY, SPD_RATE, SPD_DELAY_DER_ZEN, SPD_RATE_DER_ZEN
 120  FORMAT ( 'Delay: ', 1PD12.5, ' s    Rate: ', 1PD12.5, ' d/l ' / &
     &         'Delay_der_zen: ', 0PF8.5, '  Rate_der_zen: ', 0PF8.5, ' d/l ' )
!
! --- Free SPD objects
!
      DO 420 J2=1,L_STA
         IUER = -1
         CALL SPD_DEL_QUIT ( SPD(J2), IUER )
         IF ( IUER .NE. 0 ) THEN
              IUER = -1
              CALL ERR_LOG ( 4604, IUER, 'SPD_DEL_EXAMPLE_FORTRAN', 'Failure '// &
     &            'in freeing SPD data structure' )
              CALL EXIT ( 1 ) 
         END IF
 420  CONTINUE 
      END  PROGRAM   SPD_DEL_EXAMPLE_FORTRAN  !#!  
