!
! --- This file was generated automatically by nut_out v4.1  2003.12.11
! --- written by Leonid Petrov ( pet@leo.gsfc.nasa.gov )
! --- File was created at 2003.12.11-15:46:55
! --- It contains nutation expansion of the model WAHR1980
! --- Phases, frequencies, accelerations of the arguments as well as amplitudes
! --- of cos and sin components of nutation in longituide and in obliquity
! --- are transformed to the form suitable for computations.
! --- Nutation is considered as a a harmonic variations in polar motion
! --- Convention: angles of a small rotation are computed as :
! ---             E1 = sum_i {  PMC_i*cos(ARG_i) + PMS_i*sin(ARG_i) }
! ---             E2 = sum_i { -PMC_i*sin(ARG_i) + PMS_i*cos(ARG_i) }
! ---             E3 = 0
! --- Truncation limit for amplitudes:   0.0000 prad
! --- Units are picoradians for amplitudes  and  1.0D-24 rad/sec for their rates
! --- in total  212 consitiuents are presented
! --- Epsilon_o =  0.4090928041 rad
! --- OM_preces = -7.08618327D-12 rad/sec
!
      INTEGER*4   N_NUT, I_NUT
      PARAMETER ( N_NUT = 212 )
      INTEGER*4  IND_NUT(N_NUT)
      CHARACTER  TYP_NUT(N_NUT)*1, MODEL_NUT*40
      REAL*8     PHAS_NUT(N_NUT), FREQ_NUT(N_NUT), ACCL_NUT(N_NUT)
      REAL*8     PMC_NUT(N_NUT),      PMS_NUT(N_NUT)
      REAL*8     PMC_RATE_NUT(N_NUT), PMS_RATE_NUT(N_NUT)
      REAL*8     EPSILON_0_NUT
      PARAMETER  ( EPSILON_0_NUT = 0.4090928041D0 ) ! rad
      PARAMETER  ( MODEL_NUT = 'WAHR1980                                ' )
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1,10 ) &
     &             /            &
     & 2.4040070827D0, -8.844818068858D-05, -3.9393D-23,  106, 'R', & !    1
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0013707039D0, -8.809497621160D-05,  3.5090D-23,  105, 'R', & !    2
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1621993595D0, -8.616218211243D-05, -8.2837D-23,  104, 'R', & !    3
     &        -46.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6588168735D0, -8.581967459751D-05, -1.0786D-24,  102, 'R', & !    4
     &        146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7595629807D0, -8.580897763545D-05, -8.3538D-24,  103, 'R', & !    5
     &        -44.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3569266019D0, -8.545577315846D-05,  6.6129D-23,  101, 'R', & !    6
     &         49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4170091504D0, -8.353367602136D-05, -4.4523D-23,  100, 'R', & !    7
     &        245.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2345699504D0, -8.352297905930D-05, -5.1798D-23,   99, 'R', & !    8
     &        162.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0143727715D0, -8.318047154438D-05,  2.9960D-23,   97, 'R', & !    9
     &         52.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8319335715D0, -8.316977458231D-05,  2.2685D-23,   98, 'R', & !   10
     &        214.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  11,  20 ) &
     &             /                 &
     & 3.7415106435D0, -8.312476628880D-05, -4.9672D-23,   96, 'R', & !   11
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7888083944D0, -8.297067770708D-05,  2.2146D-23,   95, 'R', & !   12
     &        -46.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4292971927D0, -8.281657010533D-05,  9.7168D-23,   94, 'R', & !   13
     &        146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9927622272D0, -8.123698048315D-05, -9.5242D-23,   93, 'R', & !   14
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6332510255D0, -8.108287288140D-05, -2.0220D-23,   92, 'R', & !   15
     &        -49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0454271764D0, -8.095017822381D-05,  6.6148D-23,   91, 'R', & !   16
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6718189412D0, -8.090516993029D-05, -6.2087D-24,   90, 'R', & !   17
     &        289.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7725650484D0, -8.089447296823D-05, -1.3484D-23,   89, 'R', & !   18
     &       1627.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5901258484D0, -8.088377600616D-05, -2.0759D-23,   88, 'R', & !   19
     &       2246.9D0,         0.0D0,    -7681.4D0,      0.0D0,     & !
     & 5.4997029204D0, -8.083876771265D-05, -9.3116D-23,   87, 'R', & !   20
     &        192.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  21,  30 ) &
     &             /                 &
     & 6.0304003125D0, -8.070717376767D-05,  1.6482D-23,   86, 'R', & !   21
     &        -49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5470006712D0, -8.068467913093D-05, -2.1298D-23,   85, 'R', & !   22
     &        -46.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2691825624D0, -8.055196545331D-05,  6.8274D-23,   84, 'P', & !   23
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3699286695D0, -8.054126849124D-05,  6.0999D-23,   83, 'R', & !   24
     &        247.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1874894695D0, -8.053057152918D-05,  5.3724D-23,   82, 'R', & !   25
     &        613.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0970665415D0, -8.048556323566D-05, -1.8633D-23,   81, 'R', & !   26
     &        578.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9146273415D0, -8.047486627360D-05, -2.5909D-23,   80, 'R', & !   27
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1443642924D0, -8.033147465394D-05,  5.3185D-23,   79, 'R', & !   28
     &        -46.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4112448555D0, -8.013235875868D-05,  5.5849D-23,   78, 'P', & !   29
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8036194532D0, -7.866417964766D-05,  2.2704D-23,   77, 'R', & !   30
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  31,  40 ) &
     &             /                 &
     & 0.2475720180D0, -7.860847439208D-05, -5.6928D-23,   76, 'R', & !   31
     &       -146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3483181252D0, -7.859777743001D-05, -6.4203D-23,   75, 'R', & !   32
     &       -148.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8880608164D0, -7.845436679033D-05,  1.8093D-23,   74, 'R', & !   33
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9888069235D0, -7.844366982827D-05,  1.0818D-23,   73, 'R', & !   34
     &        -52.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2098140392D0, -7.827666383922D-05,  3.2105D-23,   70, 'P', & !   35
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0273748392D0, -7.826596687716D-05,  2.4830D-23,   71, 'R', & !   36
     &       2264.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8449356392D0, -7.825526991509D-05,  1.7555D-23,   72, 'R', & !   37
     &      11261.7D0,         0.0D0,   -12222.0D0,      0.0D0,     & !
     & 4.9456817464D0, -7.824457295303D-05,  1.0280D-23,   69, 'R', & !   38
     &      17563.5D0,         0.0D0,   -44518.0D0,      0.0D0,     & !
     & 3.7545127112D0, -7.821026162158D-05, -5.4802D-23,   68, 'P', & !   39
     &        435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5720735112D0, -7.819956465951D-05, -6.2078D-23,   67, 'R', & !   40
     &       2553.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  41,  50 ) &
     &             /                 &
     & 5.6728196184D0, -7.818886769745D-05, -6.9353D-23,   66, 'R', & !   41
     &        -49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8018104620D0, -7.805617303986D-05,  1.7016D-23,   64, 'R', & !   42
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9025565692D0, -7.804547607779D-05,  9.7410D-24,   65, 'R', & !   43
     &         52.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2125623095D0, -7.804545705777D-05,  1.2944D-23,   63, 'R', & !   44
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5430453675D0, -7.789136847605D-05,  8.4762D-23,   62, 'R', & !   45
     &       -146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3518763324D0, -7.785705714459D-05,  1.9681D-23,   61, 'P', & !   46
     &       1209.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1694371324D0, -7.784636018253D-05,  1.2405D-23,   60, 'R', & !   47
     &       5589.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2701832395D0, -7.783566322047D-05,  5.1301D-24,   59, 'R', & !   48
     &        148.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1263119552D0, -7.764726330729D-05,  1.1867D-23,   58, 'P', & !   49
     &        385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7668007535D0, -7.749315570555D-05,  8.6888D-23,   57, 'P', & !   50
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  51,  60 ) &
     &             /                 &
     & 0.4638138932D0, -7.615767125212D-05, -3.2626D-23,   56, 'R', & !   51
     &       -146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7855671160D0, -7.597996830101D-05, -1.8614D-23,   34, 'R', & !   52
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6031279160D0, -7.596927133894D-05, -2.5889D-23,   53, 'R', & !   53
     &       -148.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4206887160D0, -7.595857437688D-05, -3.3164D-23,   54, 'R', & !   54
     &       -112.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8609631802D0, -7.578197213839D-05,  4.0770D-24,   52, 'R', & !   55
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9707545864D0, -7.575945848162D-05, -3.0500D-23,   51, 'R', & !   56
     &       -289.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3829307372D0, -7.562676382402D-05,  5.5869D-23,   50, 'P', & !   57
     &       -385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2004915372D0, -7.561606686196D-05,  4.8594D-23,   49, 'R', & !   58
     &       -399.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0180523372D0, -7.560536989990D-05,  4.1318D-23,   48, 'R', & !   59
     &       -987.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1278437434D0, -7.558285624313D-05,  6.7413D-24,   47, 'R', & !   60
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  61,  70 ) &
     &             /                 &
     & 2.0093225020D0, -7.558175553051D-05, -1.6488D-23,   46, 'P', & !   61
     &       -338.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1100686092D0, -7.557105856844D-05, -2.3764D-23,   45, 'P', & !   62
     &      13349.6D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 3.9276294092D0, -7.556036160638D-05, -3.1039D-23,   44, 'R', & !   63
     &      66957.0D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 1.7451902092D0, -7.554966464432D-05, -3.8314D-23,   43, 'R', & !   64
     &      -1924.7D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 5.8459363164D0, -7.553896768225D-05, -4.5589D-23,   42, 'R', & !   65
     &         49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5681182075D0, -7.540625400463D-05,  4.3983D-23,   41, 'P', & !   66
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0847185662D0, -7.538375936789D-05,  6.2026D-24,   40, 'R', & !   67
     &       -385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8845042320D0, -7.536126473114D-05, -3.1577D-23,   39, 'R', & !   68
     &        482.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4242469232D0, -7.521785409146D-05,  5.0719D-23,   38, 'P', & !   69
     &       2950.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5249930304D0, -7.520715712940D-05,  4.3444D-23,   37, 'R', & !   70
     &      14992.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  71,  80 ) &
     &             /                 &
     & 2.3425538304D0, -7.519646016733D-05,  3.6169D-23,   36, 'R', & !   71
     &       -396.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2521309024D0, -7.515145187382D-05, -3.6188D-23,   35, 'P', & !   72
     &        435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0696917024D0, -7.514075491175D-05, -4.3464D-23,   55, 'R', & !   73
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3811217460D0, -7.501875721622D-05,  5.0181D-23,   33, 'P', & !   74
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4818678532D0, -7.500806025416D-05,  4.2905D-23,   32, 'P', & !   75
     &        675.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2994286532D0, -7.499736329210D-05,  3.5630D-23,   31, 'R', & !   76
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8624949684D0, -7.371756507422D-05, -1.0484D-24,   30, 'R', & !   77
     &        154.1D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 0.9010628840D0, -7.353986212311D-05,  1.2963D-23,   29, 'R', & !   78
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0018089912D0, -7.352916516105D-05,  5.6882D-24,   28, 'R', & !   79
     &        -99.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8193697912D0, -7.351846819899D-05, -1.5870D-24,   27, 'R', & !   80
     &       4448.0D0,         0.0D0,    -9422.6D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  81,  90 ) &
     &             /                 &
     & 5.7289468632D0, -7.347345990547D-05, -7.3944D-23,   26, 'R', & !   81
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0403769068D0, -7.335146220994D-05,  1.9700D-23,   25, 'P', & !   82
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8579377068D0, -7.334076524787D-05,  1.2425D-23,   24, 'R', & !   83
     &      -2121.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9586838140D0, -7.333006828581D-05,  5.1496D-24,   23, 'R', & !   84
     &      -4529.8D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 2.7762446140D0, -7.331937132375D-05, -2.1256D-24,   22, 'R', & !   85
     &     118903.6D0,         0.0D0,  -287011.5D0,      0.0D0,     & !
     & 0.0862503544D0, -7.331935230372D-05,  1.0772D-24,   21, 'R', & !   86
     &       1639.2D0,         0.0D0,    -3055.5D0,      0.0D0,     & !
     & 1.5850755788D0, -7.328505999229D-05, -6.7208D-23,   20, 'P', & !   87
     &       1305.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6858216860D0, -7.327436303023D-05, -7.4483D-23,   19, 'P', & !   88
     &       4870.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5033824860D0, -7.326366606817D-05, -8.1758D-23,   18, 'R', & !   89
     &        -99.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8148125296D0, -7.314166837264D-05,  1.1886D-23,   17, 'P', & !   90
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  91, 100 ) &
     &             /                 &
     & 4.9155586368D0, -7.313097141057D-05,  4.6109D-24,   16, 'R', & !   91
     &        245.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2255643772D0, -7.313095239055D-05,  7.8138D-24,   15, 'P', & !   92
     &       2611.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7331194368D0, -7.312027444851D-05, -2.6643D-24,   14, 'R', & !   93
     &      -2104.7D0,         0.0D0,     7766.8D0,      0.0D0,     & !
     & 0.0431251772D0, -7.312025542848D-05,  5.3862D-25,   13, 'P', & !   94
     &     150590.5D0,         0.0D0,  -111568.0D0,      0.0D0,     & !
     & 4.1438712844D0, -7.310955846642D-05, -6.7366D-24,   12, 'R', & !   95
     &        735.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0253500430D0, -7.310845775380D-05, -2.9966D-23,   11, 'P', & !   96
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9614320844D0, -7.309886150436D-05, -1.4012D-23,   10, 'R', & !   97
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8429108430D0, -7.309776079174D-05, -3.7241D-23,    9, 'R', & !   98
     &       -385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6377405280D0, -7.299825773295D-05,  9.4183D-23,    8, 'P', & !   99
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4553013280D0, -7.298756077089D-05,  8.6908D-23,    7, 'P', & !  100
     &      -1060.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 101, 110 ) &
     &             /                 &
     & 5.5560474352D0, -7.297686380883D-05,  7.9632D-23,    6, 'R', & !  101
     &      -1382.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3736082352D0, -7.296616684676D-05,  7.2357D-23,    5, 'R', & !  102
     &        -46.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4833996414D0, -7.294365318999D-05,  3.7780D-23,    4, 'P', & !  103
     &        289.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3648784000D0, -7.294255247737D-05,  1.4550D-23,    3, 'P', & !  104
     &    -415780.2D0,         0.0D0,    32296.1D0,      0.0D0,     & !
     & 4.8724334596D0, -7.293187453534D-05,  4.0723D-24,    2, 'R', & !  105
     &         49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1824392000D0, -7.293185551531D-05,  7.2752D-24,    1, 'P', & !  106
     &   38892015.2D0,         0.0D0,  6006307.5D0,      0.0D0,     & !
     & 4.1007461072D0, -7.291046159118D-05, -7.2752D-24,    1, 'R', & !  107
     &    5722963.8D0,         0.0D0, -4639016.6D0,      0.0D0,     & !
     & 1.4107518475D0, -7.291044257116D-05, -4.0723D-24,    2, 'P', & !  108
     &        435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9183069072D0, -7.289976462912D-05, -1.4550D-23,    3, 'R', & !  109
     &     -18128.0D0,         0.0D0,    44518.0D0,      0.0D0,     & !
     & 2.7997856658D0, -7.289866391650D-05, -3.7780D-23,    4, 'R', & !  110
     &       -289.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 111, 120 ) &
     &             /                 &
     & 2.9095770720D0, -7.287615025973D-05, -7.2357D-23,    5, 'P', & !  111
     &        531.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7271378720D0, -7.286545329767D-05, -7.9632D-23,    6, 'P', & !  112
     &     -10253.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8278839792D0, -7.285475633560D-05, -8.6908D-23,    7, 'R', & !  113
     &       1060.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6454447792D0, -7.284405937354D-05, -9.4183D-23,    8, 'R', & !  114
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4402744642D0, -7.274455631476D-05,  3.7241D-23,    9, 'P', & !  115
     &        385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3217532228D0, -7.274345560214D-05,  1.4012D-23,   10, 'P', & !  116
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2578352642D0, -7.273385935269D-05,  2.9966D-23,   11, 'R', & !  117
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1393140228D0, -7.273275864007D-05,  6.7366D-24,   12, 'P', & !  118
     &       3628.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2400601300D0, -7.272206167801D-05, -5.3862D-25,   13, 'R', & !  119
     &    -124410.5D0,         0.0D0,    96205.2D0,      0.0D0,     & !
     & 3.5500658704D0, -7.272204265798D-05,  2.6643D-24,   14, 'P', & !  120
     &     -43952.6D0,         0.0D0,    38321.7D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 121, 130 ) &
     &             /                 &
     & 4.0576209300D0, -7.271136471595D-05, -7.8138D-24,   15, 'R', & !  121
     &        297.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3676266704D0, -7.271134569592D-05, -4.6109D-24,   16, 'P', & !  122
     &       1209.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4683727775D0, -7.270064873386D-05, -1.1886D-23,   17, 'R', & !  123
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7798028212D0, -7.257865103833D-05,  8.1758D-23,   18, 'P', & !  124
     &       -870.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5973636212D0, -7.256795407626D-05,  7.4483D-23,   19, 'R', & !  125
     &      -4385.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6981097284D0, -7.255725711420D-05,  6.7208D-23,   20, 'R', & !  126
     &        148.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1969349528D0, -7.252296480277D-05, -1.0772D-24,   21, 'P', & !  127
     &      -1639.2D0,         0.0D0,     3055.5D0,      0.0D0,     & !
     & 3.5069406932D0, -7.252294578275D-05,  2.1256D-24,   22, 'P', & !  128
     &    2661987.7D0,         0.0D0,  -189235.9D0,      0.0D0,     & !
     & 1.3245014932D0, -7.251224882068D-05, -5.1496D-24,   23, 'P', & !  129
     &     -29407.2D0,         0.0D0,    -3055.5D0,      0.0D0,     & !
     & 5.4252476004D0, -7.250155185862D-05, -1.2425D-23,   24, 'P', & !  130
     &       2121.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 131, 140 ) &
     &             /                 &
     & 3.2428084004D0, -7.249085489656D-05, -1.9700D-23,   25, 'R', & !  131
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5542384440D0, -7.236885720103D-05,  7.3944D-23,   26, 'P', & !  132
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4638155160D0, -7.232384890751D-05,  1.5870D-24,   27, 'P', & !  133
     &     104150.3D0,         0.0D0,   -82754.3D0,      0.0D0,     & !
     & 1.2813763160D0, -7.231315194544D-05, -5.6882D-24,   28, 'P', & !  134
     &       -870.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3821224232D0, -7.230245498338D-05, -1.2963D-23,   29, 'P', & !  135
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4206903388D0, -7.212475203227D-05,  1.0484D-24,   30, 'P', & !  136
     &       3239.6D0,         0.0D0,    -3055.5D0,      0.0D0,     & !
     & 3.9837566540D0, -7.084495381440D-05, -3.5630D-23,   31, 'P', & !  137
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8013174540D0, -7.083425685234D-05, -4.2905D-23,   32, 'R', & !  138
     &       -675.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9020635612D0, -7.082355989027D-05, -5.0181D-23,   33, 'R', & !  139
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2134936048D0, -7.070156219474D-05,  4.3464D-23,   55, 'P', & !  140
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 141, 150 ) &
     &             /                 &
     & 1.0310544048D0, -7.069086523268D-05,  3.6188D-23,   35, 'R', & !  141
     &         49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9406314768D0, -7.064585693916D-05, -3.6169D-23,   36, 'P', & !  142
     &      -3482.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7581922768D0, -7.063515997710D-05, -4.3444D-23,   37, 'P', & !  143
     &     -15477.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8589383840D0, -7.062446301503D-05, -5.0719D-23,   38, 'R', & !  144
     &        443.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3986810752D0, -7.048105237535D-05,  3.1577D-23,   39, 'P', & !  145
     &       -482.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1984667410D0, -7.045855773861D-05, -6.2026D-24,   40, 'P', & !  146
     &        385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7150670996D0, -7.043606310186D-05, -4.3983D-23,   41, 'R', & !  147
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4372489908D0, -7.030334942424D-05,  4.5589D-23,   42, 'P', & !  148
     &        435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5379950980D0, -7.029265246218D-05,  3.8314D-23,   43, 'P', & !  149
     &     -14074.1D0,         0.0D0,    -3055.5D0,      0.0D0,     & !
     & 2.3555558980D0, -7.028195550011D-05,  3.1039D-23,   44, 'P', & !  150
     &     -70350.7D0,         0.0D0,    -3055.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 151, 160 ) &
     &             /                 &
     & 0.1731166980D0, -7.027125853805D-05,  2.3764D-23,   45, 'R', & !  151
     &       2164.4D0,         0.0D0,    -3055.5D0,      0.0D0,     & !
     & 4.2738628052D0, -7.026056157599D-05,  1.6488D-23,   46, 'R', & !  152
     &       -146.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1553415638D0, -7.025946086337D-05, -6.7413D-24,   47, 'P', & !  153
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2651329700D0, -7.023694720660D-05, -4.1318D-23,   48, 'P', & !  154
     &     -24707.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0826937700D0, -7.022625024453D-05, -4.8594D-23,   49, 'P', & !  155
     &      -4449.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9002545700D0, -7.021555328247D-05, -5.5869D-23,   50, 'R', & !  156
     &        385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3124307208D0, -7.008285862488D-05,  3.0500D-23,   51, 'P', & !  157
     &        289.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4222221270D0, -7.006034496810D-05, -4.0770D-24,   52, 'P', & !  158
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8624965912D0, -6.988374272961D-05,  3.3164D-23,   54, 'P', & !  159
     &      -5705.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6800573912D0, -6.987304576755D-05,  2.5889D-23,   53, 'P', & !  160
     &      -1305.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 161, 170 ) &
     &             /                 &
     & 1.4976181912D0, -6.986234880549D-05,  1.8614D-23,   34, 'P', & !  161
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8193714140D0, -6.968464585437D-05,  3.2626D-23,   56, 'P', & !  162
     &       -338.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5163845536D0, -6.834916140095D-05, -8.6888D-23,   57, 'R', & !  163
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1568733520D0, -6.819505379920D-05, -1.1867D-23,   58, 'R', & !  164
     &       -385.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0130020676D0, -6.800665388603D-05, -5.1301D-24,   59, 'P', & !  165
     &       1305.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1137481748D0, -6.799595692396D-05, -1.2405D-23,   60, 'P', & !  166
     &      -6559.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9313089748D0, -6.798525996190D-05, -1.9681D-23,   61, 'R', & !  167
     &        245.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7401399396D0, -6.795094863045D-05, -8.4762D-23,   62, 'P', & !  168
     &       -338.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0706229976D0, -6.779686004873D-05, -1.2944D-23,   63, 'P', & !  169
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3806287380D0, -6.779684102870D-05, -9.7410D-24,   65, 'P', & !  170
     &       1402.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 171, 180 ) &
     &             /                 &
     & 5.4813748452D0, -6.778614406664D-05, -1.7016D-23,   64, 'P', & !  171
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6103656888D0, -6.765344940904D-05,  6.9353D-23,   66, 'P', & !  172
     &       -435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7111117960D0, -6.764275244698D-05,  6.2078D-23,   67, 'P', & !  173
     &      -3038.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5286725960D0, -6.763205548492D-05,  5.4802D-23,   68, 'R', & !  174
     &         49.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3375035608D0, -6.759774415346D-05, -1.0280D-23,   69, 'P', & !  175
     &     456099.4D0,         0.0D0,   -32296.1D0,      0.0D0,     & !
     & 5.4382496680D0, -6.758704719140D-05, -1.7555D-23,   72, 'P', & !  176
     &      85701.0D0,         0.0D0,    12222.0D0,      0.0D0,     & !
     & 3.2558104680D0, -6.757635022934D-05, -2.4830D-23,   71, 'P', & !  177
     &      -2749.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0733712680D0, -6.756565326727D-05, -3.2105D-23,   70, 'R', & !  178
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2943783836D0, -6.739864727823D-05, -1.0818D-23,   73, 'P', & !  179
     &      -1402.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3951244908D0, -6.738795031616D-05, -1.8093D-23,   74, 'P', & !  180
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 181, 190 ) &
     &             /                 &
     & 1.9348671820D0, -6.724453967648D-05,  6.4203D-23,   75, 'P', & !  181
     &      -1305.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0356132892D0, -6.723384271442D-05,  5.6928D-23,   76, 'P', & !  182
     &       -338.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4795658540D0, -6.717813745884D-05, -2.2704D-23,   77, 'P', & !  183
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8719404516D0, -6.570995834782D-05, -5.5849D-23,   78, 'R', & !  184
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1388210148D0, -6.551084245255D-05, -5.3185D-23,   79, 'P', & !  185
     &        531.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3685579656D0, -6.536745083289D-05,  2.5909D-23,   80, 'P', & !  186
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1861187656D0, -6.535675387083D-05,  1.8633D-23,   81, 'P', & !  187
     &       -578.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0956958376D0, -6.531174557731D-05, -5.3724D-23,   82, 'P', & !  188
     &      11991.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9132566376D0, -6.530104861525D-05, -6.0999D-23,   83, 'P', & !  189
     &       2176.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0140027448D0, -6.529035165319D-05, -6.8274D-23,   84, 'R', & !  190
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 191, 200 ) &
     &             /                 &
     & 3.7361846360D0, -6.515763797557D-05,  2.1298D-23,   85, 'P', & !  191
     &        531.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2527849946D0, -6.513514333882D-05, -1.6482D-23,   86, 'P', & !  192
     &       -435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7834823868D0, -6.500354939385D-05,  9.3116D-23,   87, 'P', & !  193
     &       -192.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6930594588D0, -6.495854110033D-05,  2.0759D-23,   88, 'P', & !  194
     &      60294.1D0,         0.0D0,    -7681.4D0,      0.0D0,     & !
     & 1.5106202588D0, -6.494784413827D-05,  1.3484D-23,   89, 'P', & !  195
     &      11462.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6113663660D0, -6.493714717620D-05,  6.2087D-24,   90, 'P', & !  196
     &       -289.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2377581308D0, -6.489213888269D-05, -6.6148D-23,   91, 'P', & !  197
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6499342816D0, -6.475944422509D-05,  2.0220D-23,   92, 'P', & !  198
     &       -435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2904230800D0, -6.460533662335D-05,  9.5242D-23,   93, 'P', & !  199
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8538881145D0, -6.302574700116D-05, -9.7168D-23,   94, 'P', & !  200
     &        338.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 201, 210 ) &
     &             /                 &
     & 5.4943769128D0, -6.287163939942D-05, -2.2146D-23,   95, 'P', & !  201
     &        531.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5416746636D0, -6.271755081770D-05,  4.9672D-23,   96, 'P', & !  202
     &        -96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4512517356D0, -6.267254252418D-05, -2.2685D-23,   98, 'P', & !  203
     &       7542.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2688125356D0, -6.266184556212D-05, -2.9960D-23,   97, 'P', & !  204
     &       1402.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0486153568D0, -6.231933804720D-05,  5.1798D-23,   99, 'P', & !  205
     &       6140.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8661761568D0, -6.230864108513D-05,  4.4523D-23,  100, 'P', & !  206
     &       1209.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9262587053D0, -6.038654394803D-05, -6.6129D-23,  101, 'P', & !  207
     &        435.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5236223265D0, -6.003333947105D-05,  8.3538D-24,  103, 'P', & !  208
     &       1498.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6243684336D0, -6.002264250898D-05,  1.0786D-24,  102, 'P', & !  209
     &        338.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1209859476D0, -5.968013499406D-05,  8.2837D-23,  104, 'P', & !  210
     &        531.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 211, 212 ) &
     &             /                 &
     & 3.2818146033D0, -5.774734089490D-05, -3.5090D-23,  105, 'P', & !  211
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8791782245D0, -5.739413641791D-05,  3.9393D-23,  106, 'P', & !  212
     &         96.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
! --- Contribution to E3 due to a secular part of the nutation-nutation
! --- cross terms
!
      REAL*8      CROSS_NUT_RATE_E3
      DATA        CROSS_NUT_RATE_E3 /  -5.9159320328D-18 / ! rad/s  or -3.85081164 mas/Jul_cent
