      PROGRAM    GEN_EGM2008_GEOID
! ************************************************************************
! *                                                                      *
! *   PROGRAM    GEN_EGM2008_GEOID
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 28-AUG-2013 GEN_EGM2008_GEOID v1.1 (d) L. Petrov 20-NOV-2013 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'heb.i'
      TYPE     ( HEB__TYPE ) :: HEB_GEOID, HEB_BSPL
      INTEGER*4  MLON, MLAT, MDEG
      PARAMETER  ( MLON = 21601 )
      PARAMETER  ( MLAT = 10801 )
      PARAMETER  ( MDEG =     3 )
      CHARACTER  FILIN*128, FILOUT_UNDL*128, FILOUT_BSPL*128, STR*128
      REAL*4,    ALLOCATABLE :: UND(:,:)
      REAL*4     LON_ARR(MLON+2), LAT_ARR(MLAT), LON_VAL, LAT_VAL
      INTEGER*4  NLON, NLAT, IND_LON, IND_LAT, J1, J2, J3, J4, J5, J6, ID, IUER
      REAL*4,    EXTERNAL :: VAL_2D_BSPL4 
      INTEGER*4, EXTERNAL :: IXMN4, LINDEX, ILEN, I_LEN
!
      IF ( IARGC() < 5 ) THEN
           WRITE ( 6, '(A)' ) 'Usage: gen_egm2008_geoid filin nlon nlat filout_val filout_bspl' 
           CALL EXIT ( 1 )
         ELSE 
           CALL GETARG ( 1, FILIN  )
           CALL GETARG ( 2, STR    )
           CALL CHIN   ( STR, NLON )
           CALL GETARG ( 3, STR    )
           CALL CHIN   ( STR, NLAT )
           CALL GETARG ( 4, FILOUT_UNDL )
           CALL GETARG ( 5, FILOUT_BSPL )
      END IF
!
      ALLOCATE ( UND(1-MDEG:MLON+2,1-MDEG:MLAT) )
      ALLOCATE ( HEB_GEOID%VAL(NLON,NLAT,1,1) )
      ALLOCATE ( HEB_BSPL%VAL(1-MDEG:NLON+2,1-MDEG:NLAT,1,1) )
      IUER = -1
      CALL READ_EGM2008_UND ( FILIN, MDEG, MLON, MLAT, UND, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 7401, IUER, 'GEN_EGM2008_GEOID', 'Error in '// &
     &         'reading input file '//FILIN )
           CALL EXIT ( 1 )
      END IF
!
      DO 410 J1=1,MLON+2
         LON_ARR(J1) = (J1-1)*PI2/(MLON-1)
 410  CONTINUE 
!
      DO 420 J2=1,MLAT
         LAT_ARR(J2) = -P2I + (J2-1)*PI__NUM/(MLAT-1)
 420  CONTINUE 
!
      HEB_BSPL%VAL = 0.0
      DO 430 J3=1,NLAT
         LAT_VAL = -P2I + (J3-1)*PI__NUM/(NLAT-1)
         IND_LAT = IXMN4 ( MLAT, LAT_ARR, LAT_VAL )
         DO 440 J4=1,NLON
            LON_VAL = (J4-1)*PI2/NLON
            IND_LON = IXMN4 ( MLON, LON_ARR, LON_VAL )
            HEB_GEOID%VAL(J4,J3,1,1) = VAL_2D_BSPL4 ( LON_VAL, LAT_VAL, &
     &                                                MLON+2, MLAT, MDEG, &
     &                                                IND_LON, IND_LAT, &
     &                                                LON_ARR, LAT_ARR, UND )
            HEB_BSPL%VAL(J4,J3,1,1) = HEB_GEOID%VAL(J4,J3,1,1) 
 440     CONTINUE 
         HEB_BSPL%VAL(NLON+1,J3,1,1) = HEB_GEOID%VAL(1,J3,1,1) 
         HEB_BSPL%VAL(NLON+2,J3,1,1) = HEB_GEOID%VAL(2,J3,1,1) 
 430  CONTINUE 
!
!      IUER = -1
!      CALL PLOT_GRID_R4 ( 1, 7, 41, 1, NLON, NLAT, HEB_GEOID%VAL, &
!     &                    'Geoid height', 'm', '/tmp/boo', IUER )
      HEB_GEOID%DIMS(1) = NLON
      HEB_GEOID%DIMS(2) = NLAT
      HEB_GEOID%DIMS(3) = 1
      HEB_GEOID%DIMS(4) = 1
      HEB_GEOID%DATA_OFFSET = HEB__HDS
      HEB_GEOID%ENDIAN      = HEB__LE
      HEB_GEOID%FILL_VALUE     = 1.0E15
      HEB_GEOID%DATA_COMPRESSION = HEB__NONE
      HEB_GEOID%MIN_VALUE      = MINVAL(HEB_GEOID%VAL)
      HEB_GEOID%MAX_VALUE      = MAXVAL(HEB_GEOID%VAL)
      HEB_GEOID%VALID_RANGE(1) = -108.0
      HEB_GEOID%VALID_RANGE(2) =  108.0
      HEB_GEOID%DATA_TRANSFORM = HEB__SCOF
      HEB_GEOID%SDS_NAME       = 'Height of the EGM2008 geoid relative the WGS84 ellipsoid'
      HEB_GEOID%UNITS          = 'm'
      HEB_GEOID%DATA_FORMAT    = HEB__I2
      HEB_GEOID%OFFSET         = 0.0
      HEB_GEOID%SCALE_FACTOR   = 108.0/32000
      HEB_GEOID%FILE_NAME = FILOUT_UNDL
      HEB_GEOID%PROD_NAME = 'Geoid undulations, tide-free, relative the WGS84 reference ellipsoid'
      HEB_GEOID%HISTORY   = 'Generated by program gen_egm2008 from precomputed 1x1 arcmin geoid undulations';\
!                      http://earth-info.nga.mil/GandG/wgs84/gravitymod/egm2008/egm08_wgs84.html
      ID = LINDEX ( FILIN, '/' )
      HEB_GEOID%SOURCE    = 'Geoid undulations from EGM2008 file '//FILIN(ID+1:)
      HEB_GEOID%TITLE     = 'EGM2008 Geoid height wrt WGS84 ellipsoid'
      HEB_GEOID%INSTITUTION = 'National Geospatial Intelligence Agency (USA)'
      HEB_GEOID%REFERENCES  = 'N.K. Pavlis, S.A. Holmes, S.C. Kenyon, J.K. Factor, JGR, 117, B4, 2012'
      HEB_GEOID%PROD_DATE_TIME = '2008'
      HEB_GEOID%VERSION_ID     = '1'
      HEB_GEOID%MJD = J2000__MJD
      HEB_GEOID%UTC = 0.0D0
      HEB_GEOID%TAI = 0.0D0
!
! --- Write the output heb-file
!
      IUER = -1
      CALL WRITE_HEB ( HEB_GEOID, HEB_GEOID%VAL, FILOUT_UNDL, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 7402, IUER, 'GEN_EGM2008_GEOID', 'Error in '// &
     &         'an attempt to write output file in heb format: '// &
     &          FILOUT_UNDL )
           CALL EXIT ( 1 )
      END IF
!
      DO 450 J5=1,NLON+2
         LON_ARR(J5) = (J5-1)*PI2/NLON
 450  CONTINUE 
!
      DO 460 J6=1,NLAT
         LAT_ARR(J6) = -P2I + (J6-1)*PI__NUM/(NLAT-1)
 460  CONTINUE 
!
      IUER = -1
      CALL BSPL4_2D_CMP ( MDEG, 0, NLON+2, NLAT, LON_ARR, LAT_ARR, &
     &                    HEB_BSPL%VAL, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 7217, IUER, 'READ_EGM2008_UND', 'Error '// &
     &         'in computing interpolating B-spline' )
           RETURN 
      END IF
      HEB_BSPL%DIMS(1) = NLON+2+MDEG
      HEB_BSPL%DIMS(2) = NLAT+MDEG
      HEB_BSPL%DIMS(3) = 1
      HEB_BSPL%DIMS(4) = 1
      HEB_BSPL%DATA_OFFSET = HEB__HDS
      HEB_BSPL%ENDIAN      = HEB__LE
      HEB_BSPL%FILL_VALUE     = 1.0E15
      HEB_BSPL%DATA_COMPRESSION = HEB__NONE
      HEB_BSPL%MIN_VALUE = MINVAL(HEB_BSPL%VAL)
      HEB_BSPL%MAX_VALUE = MAXVAL(HEB_BSPL%VAL)
      HEB_BSPL%VALID_RANGE(1) = -108.0
      HEB_BSPL%VALID_RANGE(2) =  108.0
      HEB_BSPL%DATA_TRANSFORM = HEB__SCOF
      HEB_BSPL%SDS_NAME  = 'B-spline coefficients of expansion height of the EGM2008 geoid relative the WGS84 ellipsoid'
      HEB_BSPL%UNITS          = 'm'
      HEB_BSPL%DATA_FORMAT    = HEB__I2
      HEB_BSPL%OFFSET         = 0.0
      HEB_BSPL%SCALE_FACTOR   = 108.0/32000
      HEB_BSPL%FILE_NAME = FILOUT_BSPL
      HEB_BSPL%PROD_NAME = 'B-spline coefficients of expansion height of EGM2008 geoid relative the WGS84 ellipsoid from precomputed 1x1 arcmin undulations'
      HEB_BSPL%HISTORY   = 'Generated by program gen_egm2008 from precomputed 1x1 arcmin geoid undulations';\
!                      http://earth-info.nga.mil/GandG/wgs84/gravitymod/egm2008/egm08_wgs84.html
      ID = LINDEX ( FILIN, '/' )
      HEB_BSPL%SOURCE    = 'Geoid undulations from EGM2008 file '//FILIN(ID+1:)
      HEB_BSPL%TITLE     = 'EGM2008 Geoid height wrt WGS84 ellipsoid'
      HEB_BSPL%INSTITUTION = 'National Geospatial Intelligence Agency (USA)'
      HEB_BSPL%REFERENCES  = 'N.K. Pavlis, S.A. Holmes, S.C. Kenyon, J.K. Factor, JGR, 117, B4, 2012'
      HEB_BSPL%PROD_DATE_TIME = '2008'
      HEB_BSPL%VERSION_ID     = '1'
      HEB_BSPL%MJD = J2000__MJD
      HEB_BSPL%UTC = 0.0D0
      HEB_BSPL%TAI = 0.0D0
!
! --- Write the output heb-file with B-spline coefficients
!
      IUER = -1
      CALL WRITE_HEB ( HEB_BSPL, HEB_BSPL%VAL, FILOUT_BSPL, IUER )
      IF ( IUER .NE. 0 ) THEN
           CALL ERR_LOG ( 7218, IUER, 'GEN_EGM2008_GEOID', 'Error in '// &
     &         'an attempt to write output file in heb format: '// &
     &          FILOUT_BSPL )
           CALL EXIT ( 1 )
      END IF
!
      END  PROGRAM  GEN_EGM2008_GEOID  !#!#
!
! ------------------------------------------------------------------------
!
      SUBROUTINE READ_EGM2008_UND ( FILIN, MDEG, MLON, MLAT, UND, IUER )
! ************************************************************************
! *                                                                      *
! *   SUBROUTINE READ_EGM2008_UND reads files with EGM2008 geoid         *
! *   undulations. It returns the coefficients of undulation expansion   *
! *   into B-spline basis.                                               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 28-AUG-2013  READ_EGM2008_UND v1.1 (d) L. Petrov 20-NOV-2013 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      CHARACTER  FILIN*(*)
      INTEGER*4  MDEG, MLON, MLAT, IUER
      REAL*4     UND(1-MDEG:MLON+2,1-MDEG:MLAT)
      CHARACTER  STR*128
      REAL*4     LON_ARR(MLON+2), LAT_ARR(MLAT)
      INTEGER*4  J1, J2, J3, DESCR, IS, LUN, IER
      INTEGER*4, EXTERNAL :: READ, ILEN, I_LEN
!
      UND = 0.0D0
!
      CALL ERR_PASS ( IUER, IER )
      CALL BINF_OPEN ( FILIN, 'OLD', LUN, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7211, IUER, 'READ_EGM2008_UND', 'Failure in an '// &
     &         'attempt to open the input file '//FILIN )
           RETURN 
      END IF
!
      DO 410 J1=1,MLAT
!
! ------ Read the header descriptor
!
         IS = READ ( %VAL(LUN), DESCR, %VAL(4) )
!!         write ( 6, * ) ' j1= ', j1, ' is = ', is, ' descr= ', descr ! %%%
!!         write ( 6, * ) ' is = ', is, ' descr= ', descr ! %%%
         IF ( IS == -1 ) THEN
              CALL CLRCH  ( STR )
              CALL GERROR ( STR )
              CALL ERR_LOG ( 7212, IUER, 'READ_EGM2008_UND', 'Error '// &
     &             STR(1:I_LEN(STR))//' in reading the input file '//FILIN )
              RETURN 
            ELSE IF ( IS .NE. 4 ) THEN
              CALL ERR_LOG ( 7213, IUER, 'READ_EGM2008_UND', 'Error '// &
     &            'in reading the input file '//FILIN(1:I_LEN(FILIN))// &
     &            ' -- not all bytes have been read' )
              RETURN 
         END IF
!
         IS = READ ( %VAL(LUN), UND(1,MLAT+1-J1), %VAL(DESCR) )
         IF ( IS == -1 ) THEN
              CALL CLRCH  ( STR )
              CALL GERROR ( STR )
              CALL ERR_LOG ( 7214, IUER, 'READ_EGM2008_UND', 'Error '// &
     &             STR(1:I_LEN(STR))//' in reading the input file '//FILIN )
              RETURN 
            ELSE IF ( IS .NE. DESCR ) THEN
              CALL ERR_LOG ( 7215, IUER, 'READ_EGM2008_UND', 'Error '// &
     &            'in reading the input file '//FILIN(1:I_LEN(FILIN))// &
     &            ' -- not all bytes have been read' )
              RETURN 
         END IF
         UND(MLON,MLAT+1-J1) = UND(1,MLAT+1-J1)   ! Set the undulation for 360 deg the same afor 0 deg longitude
         UND(MLON+1,MLAT+1-J1) = UND(2,MLAT+1-J1)
         UND(MLON+2,MLAT+1-J1) = UND(3,MLAT+1-J1)
!
! ------ Read the trailing descriptor
!
         IS = READ ( %VAL(LUN), DESCR, %VAL(4) )
         IF ( IS == -1 ) THEN
              CALL CLRCH  ( STR )
              CALL GERROR ( STR )
              CALL ERR_LOG ( 7216, IUER, 'READ_EGM2008_UND', 'Error '// &
     &             STR(1:I_LEN(STR))//' in reading the input file '//FILIN )
              RETURN 
            ELSE IF ( IS .NE. 4 ) THEN
              CALL ERR_LOG ( 7217, IUER, 'READ_EGM2008_UND', 'Error '// &
     &            'in reading the input file '//FILIN(1:I_LEN(FILIN))// &
     &            ' -- not all bytes have been read' )
              RETURN 
         END IF
 410  CONTINUE 
!
      DO 420 J2=1,MLON+2
         LON_ARR(J2) = (J2-1)*PI2/(MLON-1)
 420  CONTINUE 
!
      DO 430 J3=1,MLAT
         LAT_ARR(J3) = -P2I + (J3-1)*PI__NUM/(MLAT-1)
 430  CONTINUE 
!
      CALL ERR_PASS ( IUER, IER )
      CALL BSPL4_2D_CMP ( MDEG, 0, MLON+2, MLAT, LON_ARR, LAT_ARR, UND, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7217, IUER, 'READ_EGM2008_UND', 'Error '// &
     &         'in computing interpolating B-spline' )
           RETURN 
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  READ_EGM2008_UND  !#!#
